import HashContainer from './Base';
import { initContainer } from "../ContainerBase";
declare class HashSet<K> extends HashContainer<K> {
    /**
     * @description HashSet's constructor.
     * @param container Initialize container, must have a forEach function.
     * @param initBucketNum Initialize bucket num, must be an integer power of 2 and greater than 16.
     * @param hashFunc The hash function, convert key element from type T to a number.
     * @example new HashSet([1, 2, 3], 1 << 10, x => x);
     */
    constructor(container?: initContainer<K>, initBucketNum?: number, hashFunc?: (x: K) => number);
    forEach(callback: (element: K, index: number, set: HashSet<K>) => void): void;
    /**
     * @description Insert element to hash set.
     * @param element The element you want to insert.
     * @example container.insert(1);
     */
    insert(element: K): void;
    eraseElementByKey(key: K): void;
    find(element: K): boolean;
    [Symbol.iterator](): Generator<K, void, unknown>;
}
export default HashSet;
