/*!
 * js-sdsl v4.2.0-beta.0
 * https://github.com/js-sdsl/js-sdsl
 * (c) 2021-present ZLY201 <zilongyao1366@gmail.com>
 * MIT license
 */

(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.sdsl = {}));
})(this, (function (exports) { 'use strict';

    /******************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function (d, b) {
      extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      };
      return extendStatics(d, b);
    };
    function __extends(d, b) {
      if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    function __generator(thisArg, body) {
      var _ = {
          label: 0,
          sent: function () {
            if (t[0] & 1) throw t[1];
            return t[1];
          },
          trys: [],
          ops: []
        },
        f,
        y,
        t,
        g;
      return g = {
        next: verb(0),
        "throw": verb(1),
        "return": verb(2)
      }, typeof Symbol === "function" && (g[Symbol.iterator] = function () {
        return this;
      }), g;
      function verb(n) {
        return function (v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return {
                value: op[1],
                done: false
              };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return {
          value: op[0] ? op[1] : void 0,
          done: true
        };
      }
    }
    function __values(o) {
      var s = typeof Symbol === "function" && Symbol.iterator,
        m = s && o[s],
        i = 0;
      if (m) return m.call(o);
      if (o && typeof o.length === "number") return {
        next: function () {
          if (o && i >= o.length) o = void 0;
          return {
            value: o && o[i++],
            done: !o
          };
        }
      };
      throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    function __read(o, n) {
      var m = typeof Symbol === "function" && o[Symbol.iterator];
      if (!m) return o;
      var i = m.call(o),
        r,
        ar = [],
        e;
      try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
      } catch (error) {
        e = {
          error: error
        };
      } finally {
        try {
          if (r && !r.done && (m = i["return"])) m.call(i);
        } finally {
          if (e) throw e.error;
        }
      }
      return ar;
    }
    function __spreadArray(to, from, pack) {
      if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
        }
      }
      return to.concat(ar || Array.prototype.slice.call(from));
    }

    var ContainerIterator = /** @class */function () {
      function ContainerIterator(iteratorType) {
        if (iteratorType === void 0) {
          iteratorType = 0 /* IteratorType.NORMAL */;
        }
        this.iteratorType = iteratorType;
      }
      return ContainerIterator;
    }();
    var Base = /** @class */function () {
      function Base() {
        /**
         * @description Container's size.
         * @internal
         */
        this._length = 0;
      }
      /**
       * @return The size of the container.
       * @example
       * const container = new Vector([1, 2]);
       * console.log(container.size()); // 2
       */
      Base.prototype.size = function () {
        return this._length;
      };
      /**
       * @return Boolean about if the container is empty.
       * @example
       * container.clear();
       * console.log(container.empty());  // true
       */
      Base.prototype.empty = function () {
        return this._length === 0;
      };
      return Base;
    }();
    var Container = /** @class */function (_super) {
      __extends(Container, _super);
      function Container() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      return Container;
    }(Base);

    var Stack = /** @class */function (_super) {
      __extends(Stack, _super);
      function Stack(container) {
        if (container === void 0) {
          container = [];
        }
        var _this = _super.call(this) || this;
        /**
         * @internal
         */
        _this._stack = [];
        container.forEach(function (element) {
          return _this.push(element);
        });
        return _this;
      }
      Stack.prototype.clear = function () {
        this._length = 0;
        this._stack.length = 0;
      };
      /**
       * @description Insert element to stack's end.
       */
      Stack.prototype.push = function (element) {
        this._stack.push(element);
        this._length += 1;
      };
      /**
       * @description Removes the end element.
       */
      Stack.prototype.pop = function () {
        this._stack.pop();
        if (this._length > 0) this._length -= 1;
      };
      /**
       * @description Accesses the end element.
       */
      Stack.prototype.top = function () {
        return this._stack[this._length - 1];
      };
      return Stack;
    }(Base);

    var SequentialContainer = /** @class */function (_super) {
      __extends(SequentialContainer, _super);
      function SequentialContainer() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      return SequentialContainer;
    }(Container);

    var RandomIterator = /** @class */function (_super) {
      __extends(RandomIterator, _super);
      /**
       * @internal
       */
      function RandomIterator(index, size, getElementByPos, setElementByPos, iteratorType) {
        var _this = _super.call(this, iteratorType) || this;
        _this._node = index;
        _this._size = size;
        _this._getElementByPos = getElementByPos;
        _this._setElementByPos = setElementByPos;
        if (_this.iteratorType === 0 /* IteratorType.NORMAL */) {
          _this.pre = function () {
            if (this._node === 0) {
              throw new RangeError('Random iterator access denied!');
            }
            this._node -= 1;
            return this;
          };
          _this.next = function () {
            if (this._node === this._size()) {
              throw new RangeError('Random Iterator access denied!');
            }
            this._node += 1;
            return this;
          };
        } else {
          _this.pre = function () {
            if (this._node === this._size() - 1) {
              throw new RangeError('Random iterator access denied!');
            }
            this._node += 1;
            return this;
          };
          _this.next = function () {
            if (this._node === -1) {
              throw new RangeError('Random iterator access denied!');
            }
            this._node -= 1;
            return this;
          };
        }
        return _this;
      }
      Object.defineProperty(RandomIterator.prototype, "pointer", {
        get: function () {
          if (this._node < 0 || this._node > this._size() - 1) {
            throw new RangeError();
          }
          return this._getElementByPos(this._node);
        },
        set: function (newValue) {
          if (this._node < 0 || this._node > this._size() - 1) {
            throw new RangeError();
          }
          this._setElementByPos(this._node, newValue);
        },
        enumerable: false,
        configurable: true
      });
      RandomIterator.prototype.equals = function (obj) {
        return this._node === obj._node;
      };
      return RandomIterator;
    }(ContainerIterator);

    var DequeIterator = /** @class */function (_super) {
      __extends(DequeIterator, _super);
      function DequeIterator() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      DequeIterator.prototype.copy = function () {
        return new DequeIterator(this._node, this._size, this._getElementByPos, this._setElementByPos, this.iteratorType);
      };
      return DequeIterator;
    }(RandomIterator);
    var Deque = /** @class */function (_super) {
      __extends(Deque, _super);
      function Deque(container, _bucketSize) {
        if (container === void 0) {
          container = [];
        }
        if (_bucketSize === void 0) {
          _bucketSize = 1 << 12;
        }
        var _this = _super.call(this) || this;
        /**
         * @internal
         */
        _this._first = 0;
        /**
         * @internal
         */
        _this._curFirst = 0;
        /**
         * @internal
         */
        _this._last = 0;
        /**
         * @internal
         */
        _this._curLast = 0;
        /**
         * @internal
         */
        _this._bucketNum = 0;
        /**
         * @internal
         */
        _this._map = [];
        var _length;
        if ('size' in container) {
          if (typeof container.size === 'number') {
            _length = container.size;
          } else {
            _length = container.size();
          }
        } else if ('length' in container) {
          _length = container.length;
        } else {
          throw new RangeError('Can\'t get container\'s size!');
        }
        _this._bucketSize = _bucketSize;
        _this._bucketNum = Math.max(Math.ceil(_length / _this._bucketSize), 1);
        for (var i = 0; i < _this._bucketNum; ++i) {
          _this._map.push(new Array(_this._bucketSize));
        }
        var needBucketNum = Math.ceil(_length / _this._bucketSize);
        _this._first = _this._last = (_this._bucketNum >> 1) - (needBucketNum >> 1);
        _this._curFirst = _this._curLast = _this._bucketSize - _length % _this._bucketSize >> 1;
        container.forEach(function (element) {
          return _this.pushBack(element);
        });
        _this.size = _this.size.bind(_this);
        _this.getElementByPos = _this.getElementByPos.bind(_this);
        _this.setElementByPos = _this.setElementByPos.bind(_this);
        return _this;
      }
      /**
       * @description Growth the Deque.
       * @internal
       */
      Deque.prototype._reAllocate = function () {
        var newMap = [];
        var addBucketNum = Math.max(this._bucketNum >> 1, 1);
        for (var i = 0; i < addBucketNum; ++i) {
          newMap[i] = new Array(this._bucketSize);
        }
        for (var i = this._first; i < this._bucketNum; ++i) {
          newMap[newMap.length] = this._map[i];
        }
        for (var i = 0; i < this._last; ++i) {
          newMap[newMap.length] = this._map[i];
        }
        newMap[newMap.length] = __spreadArray([], __read(this._map[this._last]), false);
        this._first = addBucketNum;
        this._last = newMap.length - 1;
        for (var i = 0; i < addBucketNum; ++i) {
          newMap[newMap.length] = new Array(this._bucketSize);
        }
        this._map = newMap;
        this._bucketNum = newMap.length;
      };
      /**
       * @description Get the bucket position of the element and the pointer position by index.
       * @param pos The element's index.
       * @internal
       */
      Deque.prototype._getElementIndex = function (pos) {
        var offset = this._curFirst + pos + 1;
        var offsetRemainder = offset % this._bucketSize;
        var curNodePointerIndex = offsetRemainder - 1;
        var curNodeBucketIndex = this._first + (offset - offsetRemainder) / this._bucketSize;
        if (offsetRemainder === 0) curNodeBucketIndex -= 1;
        curNodeBucketIndex %= this._bucketNum;
        if (curNodePointerIndex < 0) curNodePointerIndex += this._bucketSize;
        return {
          curNodeBucketIndex: curNodeBucketIndex,
          curNodePointerIndex: curNodePointerIndex
        };
      };
      Deque.prototype.clear = function () {
        this._map = [[]];
        this._bucketNum = 1;
        this._first = this._last = this._length = 0;
        this._curFirst = this._curLast = this._bucketSize >> 1;
      };
      Deque.prototype.front = function () {
        return this._map[this._first][this._curFirst];
      };
      Deque.prototype.back = function () {
        return this._map[this._last][this._curLast];
      };
      Deque.prototype.begin = function () {
        return new DequeIterator(0, this.size, this.getElementByPos, this.setElementByPos);
      };
      Deque.prototype.end = function () {
        return new DequeIterator(this._length, this.size, this.getElementByPos, this.setElementByPos);
      };
      Deque.prototype.rBegin = function () {
        return new DequeIterator(this._length - 1, this.size, this.getElementByPos, this.setElementByPos, 1 /* IteratorType.REVERSE */);
      };

      Deque.prototype.rEnd = function () {
        return new DequeIterator(-1, this.size, this.getElementByPos, this.setElementByPos, 1 /* IteratorType.REVERSE */);
      };

      Deque.prototype.pushBack = function (element) {
        if (this._length) {
          if (this._curLast < this._bucketSize - 1) {
            this._curLast += 1;
          } else if (this._last < this._bucketNum - 1) {
            this._last += 1;
            this._curLast = 0;
          } else {
            this._last = 0;
            this._curLast = 0;
          }
          if (this._last === this._first && this._curLast === this._curFirst) this._reAllocate();
        }
        this._length += 1;
        this._map[this._last][this._curLast] = element;
      };
      Deque.prototype.popBack = function () {
        if (!this._length) return;
        this._map[this._last][this._curLast] = undefined;
        if (this._length !== 1) {
          if (this._curLast > 0) {
            this._curLast -= 1;
          } else if (this._last > 0) {
            this._last -= 1;
            this._curLast = this._bucketSize - 1;
          } else {
            this._last = this._bucketNum - 1;
            this._curLast = this._bucketSize - 1;
          }
        }
        this._length -= 1;
      };
      /**
       * @description Push the element to the front.
       * @param element The element you want to push.
       */
      Deque.prototype.pushFront = function (element) {
        if (this._length) {
          if (this._curFirst > 0) {
            this._curFirst -= 1;
          } else if (this._first > 0) {
            this._first -= 1;
            this._curFirst = this._bucketSize - 1;
          } else {
            this._first = this._bucketNum - 1;
            this._curFirst = this._bucketSize - 1;
          }
          if (this._first === this._last && this._curFirst === this._curLast) this._reAllocate();
        }
        this._length += 1;
        this._map[this._first][this._curFirst] = element;
      };
      /**
       * @description Remove the _first element.
       */
      Deque.prototype.popFront = function () {
        if (!this._length) return;
        this._map[this._first][this._curFirst] = undefined;
        if (this._length !== 1) {
          if (this._curFirst < this._bucketSize - 1) {
            this._curFirst += 1;
          } else if (this._first < this._bucketNum - 1) {
            this._first += 1;
            this._curFirst = 0;
          } else {
            this._first = 0;
            this._curFirst = 0;
          }
        }
        this._length -= 1;
      };
      Deque.prototype.forEach = function (callback) {
        for (var i = 0; i < this._length; ++i) {
          callback(this.getElementByPos(i), i, this);
        }
      };
      Deque.prototype.getElementByPos = function (pos) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        var _a = this._getElementIndex(pos),
          curNodeBucketIndex = _a.curNodeBucketIndex,
          curNodePointerIndex = _a.curNodePointerIndex;
        return this._map[curNodeBucketIndex][curNodePointerIndex];
      };
      Deque.prototype.setElementByPos = function (pos, element) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        var _a = this._getElementIndex(pos),
          curNodeBucketIndex = _a.curNodeBucketIndex,
          curNodePointerIndex = _a.curNodePointerIndex;
        this._map[curNodeBucketIndex][curNodePointerIndex] = element;
      };
      Deque.prototype.insert = function (pos, element, num) {
        if (num === void 0) {
          num = 1;
        }
        if (pos < 0 || pos > this._length) {
          throw new RangeError();
        }
        if (pos === 0) {
          while (num--) this.pushFront(element);
        } else if (pos === this._length) {
          while (num--) this.pushBack(element);
        } else {
          var arr = [];
          for (var i = pos; i < this._length; ++i) {
            arr.push(this.getElementByPos(i));
          }
          this.cut(pos - 1);
          for (var i = 0; i < num; ++i) this.pushBack(element);
          for (var i = 0; i < arr.length; ++i) this.pushBack(arr[i]);
        }
      };
      /**
       * @description Remove all elements after the specified position (excluding the specified position).
       * @param pos The previous position of the _first removed element.
       * @example deque.cut(1); // Then deque's size will be 2. deque -> [0, 1]
       */
      Deque.prototype.cut = function (pos) {
        if (pos < 0) {
          this.clear();
          return;
        }
        var _a = this._getElementIndex(pos),
          curNodeBucketIndex = _a.curNodeBucketIndex,
          curNodePointerIndex = _a.curNodePointerIndex;
        this._last = curNodeBucketIndex;
        this._curLast = curNodePointerIndex;
        this._length = pos + 1;
      };
      Deque.prototype.eraseElementByPos = function (pos) {
        var _this = this;
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        if (pos === 0) this.popFront();else if (pos === this._length - 1) this.popBack();else {
          var arr = [];
          for (var i = pos + 1; i < this._length; ++i) {
            arr.push(this.getElementByPos(i));
          }
          this.cut(pos);
          this.popBack();
          arr.forEach(function (element) {
            return _this.pushBack(element);
          });
        }
      };
      Deque.prototype.eraseElementByValue = function (value) {
        if (!this._length) return;
        var arr = [];
        for (var i = 0; i < this._length; ++i) {
          var element = this.getElementByPos(i);
          if (element !== value) arr.push(element);
        }
        var _length = arr.length;
        for (var i = 0; i < _length; ++i) this.setElementByPos(i, arr[i]);
        this.cut(_length - 1);
      };
      Deque.prototype.eraseElementByIterator = function (iter) {
        var _node = iter._node;
        this.eraseElementByPos(_node);
        iter = iter.next();
        return iter;
      };
      Deque.prototype.find = function (element) {
        for (var i = 0; i < this._length; ++i) {
          if (this.getElementByPos(i) === element) {
            return new DequeIterator(i, this.size, this.getElementByPos, this.setElementByPos);
          }
        }
        return this.end();
      };
      Deque.prototype.reverse = function () {
        var l = 0;
        var r = this._length - 1;
        while (l < r) {
          var tmp = this.getElementByPos(l);
          this.setElementByPos(l, this.getElementByPos(r));
          this.setElementByPos(r, tmp);
          l += 1;
          r -= 1;
        }
      };
      Deque.prototype.unique = function () {
        if (this._length <= 1) return;
        var index = 1;
        var pre = this.getElementByPos(0);
        for (var i = 1; i < this._length; ++i) {
          var cur = this.getElementByPos(i);
          if (cur !== pre) {
            pre = cur;
            this.setElementByPos(index++, cur);
          }
        }
        while (this._length > index) this.popBack();
      };
      Deque.prototype.sort = function (cmp) {
        var arr = [];
        for (var i = 0; i < this._length; ++i) {
          arr.push(this.getElementByPos(i));
        }
        arr.sort(cmp);
        for (var i = 0; i < this._length; ++i) this.setElementByPos(i, arr[i]);
      };
      /**
       * @description Remove as much useless space as possible.
       */
      Deque.prototype.shrinkToFit = function () {
        if (!this._length) return;
        var arr = [];
        this.forEach(function (element) {
          return arr.push(element);
        });
        this._bucketNum = Math.max(Math.ceil(this._length / this._bucketSize), 1);
        this._length = this._first = this._last = this._curFirst = this._curLast = 0;
        this._map = [];
        for (var i = 0; i < this._bucketNum; ++i) {
          this._map.push(new Array(this._bucketSize));
        }
        for (var i = 0; i < arr.length; ++i) this.pushBack(arr[i]);
      };
      Deque.prototype[Symbol.iterator] = function () {
        return function () {
          var i;
          return __generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                i = 0;
                _a.label = 1;
              case 1:
                if (!(i < this._length)) return [3 /*break*/, 4];
                return [4 /*yield*/, this.getElementByPos(i)];
              case 2:
                _a.sent();
                _a.label = 3;
              case 3:
                ++i;
                return [3 /*break*/, 1];
              case 4:
                return [2 /*return*/];
            }
          });
        }.bind(this)();
      };
      return Deque;
    }(SequentialContainer);

    var Queue = /** @class */function (_super) {
      __extends(Queue, _super);
      function Queue(container) {
        if (container === void 0) {
          container = [];
        }
        var _this = _super.call(this) || this;
        _this._queue = new Deque(container);
        _this._length = _this._queue.size();
        return _this;
      }
      Queue.prototype.clear = function () {
        this._queue.clear();
        this._length = 0;
      };
      /**
       * @description Inserts element to queue's end.
       */
      Queue.prototype.push = function (element) {
        this._queue.pushBack(element);
        this._length += 1;
      };
      /**
       * @description Removes the first element.
       */
      Queue.prototype.pop = function () {
        this._queue.popFront();
        if (this._length) this._length -= 1;
      };
      /**
       * @description Access the first element.
       */
      Queue.prototype.front = function () {
        return this._queue.front();
      };
      return Queue;
    }(Base);

    var PriorityQueue = /** @class */function (_super) {
      __extends(PriorityQueue, _super);
      /**
       * @description PriorityQueue's constructor.
       * @param container Initialize container, must have a forEach function.
       * @param cmp Compare function.
       * @param copy When the container is an array, you can choose to directly operate on the original object of
       *             the array or perform a shallow copy. The default is shallow copy.
       * @example
       * new PriorityQueue();
       * new PriorityQueue([1, 2, 3]);
       * new PriorityQueue([1, 2, 3], (x, y) => x - y);
       * new PriorityQueue([1, 2, 3], (x, y) => x - y, false);
       */
      function PriorityQueue(container, cmp, copy) {
        if (container === void 0) {
          container = [];
        }
        if (cmp === void 0) {
          cmp = function (x, y) {
            if (x > y) return -1;
            if (x < y) return 1;
            return 0;
          };
        }
        if (copy === void 0) {
          copy = true;
        }
        var _this = _super.call(this) || this;
        _this._cmp = cmp;
        if (Array.isArray(container)) {
          _this._priorityQueue = copy ? __spreadArray([], __read(container), false) : container;
        } else {
          _this._priorityQueue = [];
          container.forEach(function (element) {
            return _this._priorityQueue.push(element);
          });
        }
        _this._length = _this._priorityQueue.length;
        var halfLength = _this._length >> 1;
        for (var parent_1 = _this._length - 1 >> 1; parent_1 >= 0; --parent_1) {
          _this._pushDown(parent_1, halfLength);
        }
        return _this;
      }
      /**
       * @internal
       */
      PriorityQueue.prototype._pushUp = function (pos) {
        var item = this._priorityQueue[pos];
        while (pos > 0) {
          var parent_2 = pos - 1 >> 1;
          var parentItem = this._priorityQueue[parent_2];
          if (this._cmp(parentItem, item) <= 0) break;
          this._priorityQueue[pos] = parentItem;
          pos = parent_2;
        }
        this._priorityQueue[pos] = item;
      };
      /**
       * @internal
       */
      PriorityQueue.prototype._pushDown = function (pos, halfLength) {
        var item = this._priorityQueue[pos];
        while (pos < halfLength) {
          var left = pos << 1 | 1;
          var right = left + 1;
          var minItem = this._priorityQueue[left];
          if (right < this._length && this._cmp(minItem, this._priorityQueue[right]) > 0) {
            left = right;
            minItem = this._priorityQueue[right];
          }
          if (this._cmp(minItem, item) >= 0) break;
          this._priorityQueue[pos] = minItem;
          pos = left;
        }
        this._priorityQueue[pos] = item;
      };
      PriorityQueue.prototype.clear = function () {
        this._length = 0;
        this._priorityQueue.length = 0;
      };
      /**
       * @description Push element into a container in order.
       * @param item The element you want to push.
       * @example queue.push(1);
       */
      PriorityQueue.prototype.push = function (item) {
        this._priorityQueue.push(item);
        this._pushUp(this._length);
        this._length += 1;
      };
      /**
       * @description Removes the top element.
       * @example queue.pop();
       */
      PriorityQueue.prototype.pop = function () {
        if (!this._length) return;
        var last = this._priorityQueue.pop();
        this._length -= 1;
        if (this._length) {
          this._priorityQueue[0] = last;
          this._pushDown(0, this._length >> 1);
        }
      };
      /**
       * @description Accesses the top element.
       * @example const top = queue.top();
       */
      PriorityQueue.prototype.top = function () {
        return this._priorityQueue[0];
      };
      /**
       * @description Check if element is in heap.
       * @param item The item want to find.
       * @return Boolean about if element is in heap.
       * @example
       * const que = new PriorityQueue([], (x, y) => x.id - y.id);
       * const obj = { id: 1 };
       * que.push(obj);
       * console.log(que.find(obj));  // true
       */
      PriorityQueue.prototype.find = function (item) {
        return this._priorityQueue.indexOf(item) >= 0;
      };
      /**
       * @description Remove specified item from heap.
       * @param item The item want to remove.
       * @return Boolean about if remove success.
       * @example
       * const que = new PriorityQueue([], (x, y) => x.id - y.id);
       * const obj = { id: 1 };
       * que.push(obj);
       * que.remove(obj);
       */
      PriorityQueue.prototype.remove = function (item) {
        var index = this._priorityQueue.indexOf(item);
        if (index < 0) return false;
        if (index === 0) {
          this.pop();
        } else if (index === this._length - 1) {
          this._priorityQueue.pop();
          this._length -= 1;
        } else {
          this._priorityQueue.splice(index, 1, this._priorityQueue.pop());
          this._length -= 1;
          this._pushUp(index);
          this._pushDown(index, this._length >> 1);
        }
        return true;
      };
      /**
       * @description Update item and it's pos in the heap.
       * @param item The item want to update.
       * @return Boolean about if update success.
       * @example
       * const que = new PriorityQueue([], (x, y) => x.id - y.id);
       * const obj = { id: 1 };
       * que.push(obj);
       * obj.id = 2;
       * que.updateItem(obj);
       */
      PriorityQueue.prototype.updateItem = function (item) {
        var index = this._priorityQueue.indexOf(item);
        if (index < 0) return false;
        this._pushUp(index);
        this._pushDown(index, this._length >> 1);
        return true;
      };
      /**
       * @return Return a copy array of heap.
       * @example const arr = queue.toArray();
       */
      PriorityQueue.prototype.toArray = function () {
        return __spreadArray([], __read(this._priorityQueue), false);
      };
      return PriorityQueue;
    }(Base);

    var VectorIterator = /** @class */function (_super) {
      __extends(VectorIterator, _super);
      function VectorIterator() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      VectorIterator.prototype.copy = function () {
        return new VectorIterator(this._node, this._size, this._getElementByPos, this._setElementByPos, this.iteratorType);
      };
      return VectorIterator;
    }(RandomIterator);
    var Vector = /** @class */function (_super) {
      __extends(Vector, _super);
      /**
       * @description Vector's constructor.
       * @param container Initialize container, must have a forEach function.
       * @param copy When the container is an array, you can choose to directly operate on the original object of
       *             the array or perform a shallow copy. The default is shallow copy.
       */
      function Vector(container, copy) {
        if (container === void 0) {
          container = [];
        }
        if (copy === void 0) {
          copy = true;
        }
        var _this = _super.call(this) || this;
        if (Array.isArray(container)) {
          _this._vector = copy ? __spreadArray([], __read(container), false) : container;
          _this._length = container.length;
        } else {
          _this._vector = [];
          container.forEach(function (element) {
            return _this.pushBack(element);
          });
        }
        _this.size = _this.size.bind(_this);
        _this.getElementByPos = _this.getElementByPos.bind(_this);
        _this.setElementByPos = _this.setElementByPos.bind(_this);
        return _this;
      }
      Vector.prototype.clear = function () {
        this._length = 0;
        this._vector.length = 0;
      };
      Vector.prototype.begin = function () {
        return new VectorIterator(0, this.size, this.getElementByPos, this.setElementByPos);
      };
      Vector.prototype.end = function () {
        return new VectorIterator(this._length, this.size, this.getElementByPos, this.setElementByPos);
      };
      Vector.prototype.rBegin = function () {
        return new VectorIterator(this._length - 1, this.size, this.getElementByPos, this.setElementByPos, 1 /* IteratorType.REVERSE */);
      };

      Vector.prototype.rEnd = function () {
        return new VectorIterator(-1, this.size, this.getElementByPos, this.setElementByPos, 1 /* IteratorType.REVERSE */);
      };

      Vector.prototype.front = function () {
        return this._vector[0];
      };
      Vector.prototype.back = function () {
        return this._vector[this._length - 1];
      };
      Vector.prototype.forEach = function (callback) {
        for (var i = 0; i < this._length; ++i) {
          callback(this._vector[i], i, this);
        }
      };
      Vector.prototype.getElementByPos = function (pos) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        return this._vector[pos];
      };
      Vector.prototype.eraseElementByPos = function (pos) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        this._vector.splice(pos, 1);
        this._length -= 1;
      };
      Vector.prototype.eraseElementByValue = function (value) {
        var index = 0;
        for (var i = 0; i < this._length; ++i) {
          if (this._vector[i] !== value) {
            this._vector[index++] = this._vector[i];
          }
        }
        this._length = this._vector.length = index;
      };
      Vector.prototype.eraseElementByIterator = function (iter) {
        var _node = iter._node;
        iter = iter.next();
        this.eraseElementByPos(_node);
        return iter;
      };
      Vector.prototype.pushBack = function (element) {
        this._vector.push(element);
        this._length += 1;
      };
      Vector.prototype.popBack = function () {
        if (!this._length) return;
        this._vector.pop();
        this._length -= 1;
      };
      Vector.prototype.setElementByPos = function (pos, element) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        this._vector[pos] = element;
      };
      Vector.prototype.insert = function (pos, element, num) {
        var _a;
        if (num === void 0) {
          num = 1;
        }
        if (pos < 0 || pos > this._length) {
          throw new RangeError();
        }
        (_a = this._vector).splice.apply(_a, __spreadArray([pos, 0], __read(new Array(num).fill(element)), false));
        this._length += num;
      };
      Vector.prototype.find = function (element) {
        for (var i = 0; i < this._length; ++i) {
          if (this._vector[i] === element) {
            return new VectorIterator(i, this.size, this.getElementByPos, this.getElementByPos);
          }
        }
        return this.end();
      };
      Vector.prototype.reverse = function () {
        this._vector.reverse();
      };
      Vector.prototype.unique = function () {
        var index = 1;
        for (var i = 1; i < this._length; ++i) {
          if (this._vector[i] !== this._vector[i - 1]) {
            this._vector[index++] = this._vector[i];
          }
        }
        this._length = this._vector.length = index;
      };
      Vector.prototype.sort = function (cmp) {
        this._vector.sort(cmp);
      };
      Vector.prototype[Symbol.iterator] = function () {
        return function () {
          return __generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                return [5 /*yield**/, __values(this._vector)];
              case 1:
                return [2 /*return*/, _a.sent()];
            }
          });
        }.bind(this)();
      };
      return Vector;
    }(SequentialContainer);

    /**
     * @internal
     */
    var LinkNode = /** @class */function () {
      function LinkNode(element) {
        this._value = undefined;
        this._pre = undefined;
        this._next = undefined;
        this._value = element;
      }
      return LinkNode;
    }();
    var LinkListIterator = /** @class */function (_super) {
      __extends(LinkListIterator, _super);
      /**
       * @internal
       */
      function LinkListIterator(_node, _header, iteratorType) {
        var _this = _super.call(this, iteratorType) || this;
        _this._node = _node;
        _this._header = _header;
        if (_this.iteratorType === 0 /* IteratorType.NORMAL */) {
          _this.pre = function () {
            if (this._node._pre === this._header) {
              throw new RangeError('LinkList iterator access denied!');
            }
            this._node = this._node._pre;
            return this;
          };
          _this.next = function () {
            if (this._node === this._header) {
              throw new RangeError('LinkList iterator access denied!');
            }
            this._node = this._node._next;
            return this;
          };
        } else {
          _this.pre = function () {
            if (this._node._next === this._header) {
              throw new RangeError('LinkList iterator access denied!');
            }
            this._node = this._node._next;
            return this;
          };
          _this.next = function () {
            if (this._node === this._header) {
              throw new RangeError('LinkList iterator access denied!');
            }
            this._node = this._node._pre;
            return this;
          };
        }
        return _this;
      }
      Object.defineProperty(LinkListIterator.prototype, "pointer", {
        get: function () {
          if (this._node === this._header) {
            throw new RangeError('LinkList iterator access denied!');
          }
          return this._node._value;
        },
        set: function (newValue) {
          if (this._node === this._header) {
            throw new RangeError('LinkList iterator access denied!');
          }
          this._node._value = newValue;
        },
        enumerable: false,
        configurable: true
      });
      LinkListIterator.prototype.equals = function (obj) {
        return this._node === obj._node;
      };
      LinkListIterator.prototype.copy = function () {
        return new LinkListIterator(this._node, this._header, this.iteratorType);
      };
      return LinkListIterator;
    }(ContainerIterator);
    var LinkList = /** @class */function (_super) {
      __extends(LinkList, _super);
      function LinkList(container) {
        if (container === void 0) {
          container = [];
        }
        var _this = _super.call(this) || this;
        /**
         * @internal
         */
        _this._header = new LinkNode();
        /**
         * @internal
         */
        _this._head = undefined;
        /**
         * @internal
         */
        _this._tail = undefined;
        container.forEach(function (element) {
          return _this.pushBack(element);
        });
        return _this;
      }
      LinkList.prototype.clear = function () {
        this._length = 0;
        this._head = this._tail = undefined;
        this._header._pre = this._header._next = undefined;
      };
      LinkList.prototype.begin = function () {
        return new LinkListIterator(this._head || this._header, this._header);
      };
      LinkList.prototype.end = function () {
        return new LinkListIterator(this._header, this._header);
      };
      LinkList.prototype.rBegin = function () {
        return new LinkListIterator(this._tail || this._header, this._header, 1 /* IteratorType.REVERSE */);
      };

      LinkList.prototype.rEnd = function () {
        return new LinkListIterator(this._header, this._header, 1 /* IteratorType.REVERSE */);
      };

      LinkList.prototype.front = function () {
        return this._head ? this._head._value : undefined;
      };
      LinkList.prototype.back = function () {
        return this._tail ? this._tail._value : undefined;
      };
      LinkList.prototype.forEach = function (callback) {
        if (!this._length) return;
        var curNode = this._head;
        var index = 0;
        while (curNode !== this._header) {
          callback(curNode._value, index++, this);
          curNode = curNode._next;
        }
      };
      LinkList.prototype.getElementByPos = function (pos) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        var curNode = this._head;
        while (pos--) {
          curNode = curNode._next;
        }
        return curNode._value;
      };
      LinkList.prototype.eraseElementByPos = function (pos) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        if (pos === 0) this.popFront();else if (pos === this._length - 1) this.popBack();else {
          var curNode = this._head;
          while (pos--) {
            curNode = curNode._next;
          }
          curNode = curNode;
          var _pre = curNode._pre;
          var _next = curNode._next;
          _next._pre = _pre;
          _pre._next = _next;
          this._length -= 1;
        }
      };
      LinkList.prototype.eraseElementByValue = function (_value) {
        while (this._head && this._head._value === _value) this.popFront();
        while (this._tail && this._tail._value === _value) this.popBack();
        if (!this._head) return;
        var curNode = this._head;
        while (curNode !== this._header) {
          if (curNode._value === _value) {
            var _pre = curNode._pre;
            var _next = curNode._next;
            _next._pre = _pre;
            _pre._next = _next;
            this._length -= 1;
          }
          curNode = curNode._next;
        }
      };
      LinkList.prototype.eraseElementByIterator = function (iter) {
        var _node = iter._node;
        if (_node === this._header) {
          throw new RangeError('Invalid iterator');
        }
        iter = iter.next();
        if (this._head === _node) this.popFront();else if (this._tail === _node) this.popBack();else {
          var _pre = _node._pre;
          var _next = _node._next;
          _next._pre = _pre;
          _pre._next = _next;
          this._length -= 1;
        }
        return iter;
      };
      LinkList.prototype.pushBack = function (element) {
        this._length += 1;
        var newTail = new LinkNode(element);
        if (!this._tail) {
          this._head = this._tail = newTail;
          this._header._next = this._head;
          this._head._pre = this._header;
        } else {
          this._tail._next = newTail;
          newTail._pre = this._tail;
          this._tail = newTail;
        }
        this._tail._next = this._header;
        this._header._pre = this._tail;
      };
      LinkList.prototype.popBack = function () {
        if (!this._tail) return;
        this._length -= 1;
        if (this._head === this._tail) {
          this._head = this._tail = undefined;
          this._header._next = undefined;
        } else {
          this._tail = this._tail._pre;
          this._tail._next = this._header;
        }
        this._header._pre = this._tail;
      };
      LinkList.prototype.setElementByPos = function (pos, element) {
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        var curNode = this._head;
        while (pos--) {
          curNode = curNode._next;
        }
        curNode._value = element;
      };
      LinkList.prototype.insert = function (pos, element, num) {
        if (num === void 0) {
          num = 1;
        }
        if (pos < 0 || pos > this._length) {
          throw new RangeError();
        }
        if (num <= 0) return;
        if (pos === 0) {
          while (num--) this.pushFront(element);
        } else if (pos === this._length) {
          while (num--) this.pushBack(element);
        } else {
          var curNode = this._head;
          for (var i = 1; i < pos; ++i) {
            curNode = curNode._next;
          }
          var _next = curNode._next;
          this._length += num;
          while (num--) {
            curNode._next = new LinkNode(element);
            curNode._next._pre = curNode;
            curNode = curNode._next;
          }
          curNode._next = _next;
          _next._pre = curNode;
        }
      };
      LinkList.prototype.find = function (element) {
        if (!this._head) return this.end();
        var curNode = this._head;
        while (curNode !== this._header) {
          if (curNode._value === element) {
            return new LinkListIterator(curNode, this._header);
          }
          curNode = curNode._next;
        }
        return this.end();
      };
      LinkList.prototype.reverse = function () {
        if (this._length <= 1) return;
        var pHead = this._head;
        var pTail = this._tail;
        var cnt = 0;
        while (cnt << 1 < this._length) {
          var tmp = pHead._value;
          pHead._value = pTail._value;
          pTail._value = tmp;
          pHead = pHead._next;
          pTail = pTail._pre;
          cnt += 1;
        }
      };
      LinkList.prototype.unique = function () {
        if (this._length <= 1) return;
        var curNode = this._head;
        while (curNode !== this._header) {
          var tmpNode = curNode;
          while (tmpNode._next && tmpNode._value === tmpNode._next._value) {
            tmpNode = tmpNode._next;
            this._length -= 1;
          }
          curNode._next = tmpNode._next;
          curNode._next._pre = curNode;
          curNode = curNode._next;
        }
      };
      LinkList.prototype.sort = function (cmp) {
        if (this._length <= 1) return;
        var arr = [];
        this.forEach(function (element) {
          return arr.push(element);
        });
        arr.sort(cmp);
        var curNode = this._head;
        arr.forEach(function (element) {
          curNode._value = element;
          curNode = curNode._next;
        });
      };
      /**
       * @description Push an element to the front.
       * @param element The element you want to push.
       */
      LinkList.prototype.pushFront = function (element) {
        this._length += 1;
        var newHead = new LinkNode(element);
        if (!this._head) {
          this._head = this._tail = newHead;
          this._tail._next = this._header;
          this._header._pre = this._tail;
        } else {
          newHead._next = this._head;
          this._head._pre = newHead;
          this._head = newHead;
        }
        this._header._next = this._head;
        this._head._pre = this._header;
      };
      /**
       * @description Removes the first element.
       */
      LinkList.prototype.popFront = function () {
        if (!this._head) return;
        this._length -= 1;
        if (this._head === this._tail) {
          this._head = this._tail = undefined;
          this._header._pre = this._tail;
        } else {
          this._head = this._head._next;
          this._head._pre = this._header;
        }
        this._header._next = this._head;
      };
      /**
       * @description Merges two sorted lists.
       * @param list The other list you want to merge (must be sorted).
       * @example
       * const linkA = new LinkList([1, 3, 5]);
       * const linkB = new LinkList([2, 4, 6]);
       * linkA.merge(linkB);  // [1, 2, 3, 4, 5];
       */
      LinkList.prototype.merge = function (list) {
        var _this = this;
        if (!this._head) {
          list.forEach(function (element) {
            return _this.pushBack(element);
          });
          return;
        }
        var curNode = this._head;
        list.forEach(function (element) {
          while (curNode && curNode !== _this._header && curNode._value <= element) {
            curNode = curNode._next;
          }
          if (curNode === _this._header) {
            _this.pushBack(element);
            curNode = _this._tail;
          } else if (curNode === _this._head) {
            _this.pushFront(element);
            curNode = _this._head;
          } else {
            _this._length += 1;
            var _pre = curNode._pre;
            _pre._next = new LinkNode(element);
            _pre._next._pre = _pre;
            _pre._next._next = curNode;
            curNode._pre = _pre._next;
          }
        });
      };
      LinkList.prototype[Symbol.iterator] = function () {
        return function () {
          var curNode;
          return __generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                if (!this._head) return [2 /*return*/];
                curNode = this._head;
                _a.label = 1;
              case 1:
                if (!(curNode !== this._header)) return [3 /*break*/, 3];
                return [4 /*yield*/, curNode._value];
              case 2:
                _a.sent();
                curNode = curNode._next;
                return [3 /*break*/, 1];
              case 3:
                return [2 /*return*/];
            }
          });
        }.bind(this)();
      };
      return LinkList;
    }(SequentialContainer);

    var TreeNode = /** @class */function () {
      function TreeNode(_key, _value) {
        /**
         * @internal
         */
        this._color = 1 /* TreeNodeColor.RED */;
        /**
         * @internal
         */
        this._key = undefined;
        /**
         * @internal
         */
        this._value = undefined;
        /**
         * @internal
         */
        this._left = undefined;
        /**
         * @internal
         */
        this._right = undefined;
        /**
         * @internal
         */
        this._parent = undefined;
        this._key = _key;
        this._value = _value;
      }
      /**
       * @description Get the pre node.
       * @return TreeNode about the pre node.
       */
      TreeNode.prototype.pre = function () {
        var preNode = this;
        if (preNode._color === 1 /* TreeNodeColor.RED */ && preNode._parent._parent === preNode) {
          preNode = preNode._right;
        } else if (preNode._left) {
          preNode = preNode._left;
          while (preNode._right) {
            preNode = preNode._right;
          }
        } else {
          var pre = preNode._parent;
          while (pre._left === preNode) {
            preNode = pre;
            pre = preNode._parent;
          }
          preNode = pre;
        }
        return preNode;
      };
      /**
       * @description Get the next node.
       * @return TreeNode about the next node.
       */
      TreeNode.prototype.next = function () {
        var nextNode = this;
        if (nextNode._right) {
          nextNode = nextNode._right;
          while (nextNode._left) {
            nextNode = nextNode._left;
          }
          return nextNode;
        } else {
          var pre = nextNode._parent;
          while (pre._right === nextNode) {
            nextNode = pre;
            pre = nextNode._parent;
          }
          if (nextNode._right !== pre) {
            return pre;
          } else return nextNode;
        }
      };
      /**
       * @description Rotate left.
       * @return TreeNode about moved to original position after rotation.
       */
      TreeNode.prototype.rotateLeft = function () {
        var PP = this._parent;
        var V = this._right;
        var R = V._left;
        if (PP._parent === this) PP._parent = V;else if (PP._left === this) PP._left = V;else PP._right = V;
        V._parent = PP;
        V._left = this;
        this._parent = V;
        this._right = R;
        if (R) R._parent = this;
        return V;
      };
      /**
       * @description Rotate right.
       * @return TreeNode about moved to original position after rotation.
       */
      TreeNode.prototype.rotateRight = function () {
        var PP = this._parent;
        var F = this._left;
        var K = F._right;
        if (PP._parent === this) PP._parent = F;else if (PP._left === this) PP._left = F;else PP._right = F;
        F._parent = PP;
        F._right = this;
        this._parent = F;
        this._left = K;
        if (K) K._parent = this;
        return F;
      };
      return TreeNode;
    }();
    var TreeNodeEnableIndex = /** @class */function (_super) {
      __extends(TreeNodeEnableIndex, _super);
      function TreeNodeEnableIndex() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * @internal
         */
        _this._left = undefined;
        /**
         * @internal
         */
        _this._right = undefined;
        /**
         * @internal
         */
        _this._parent = undefined;
        /**
         * @internal
         */
        _this._subTreeSize = 1;
        return _this;
      }
      /**
       * @description Rotate left and do recount.
       * @return TreeNode about moved to original position after rotation.
       */
      TreeNodeEnableIndex.prototype.rotateLeft = function () {
        var parent = _super.prototype.rotateLeft.call(this);
        this.recount();
        parent.recount();
        return parent;
      };
      /**
       * @description Rotate right and do recount.
       * @return TreeNode about moved to original position after rotation.
       */
      TreeNodeEnableIndex.prototype.rotateRight = function () {
        var parent = _super.prototype.rotateRight.call(this);
        this.recount();
        parent.recount();
        return parent;
      };
      TreeNodeEnableIndex.prototype.recount = function () {
        this._subTreeSize = 1;
        if (this._left) this._subTreeSize += this._left._subTreeSize;
        if (this._right) this._subTreeSize += this._right._subTreeSize;
      };
      return TreeNodeEnableIndex;
    }(TreeNode);

    var TreeContainer = /** @class */function (_super) {
      __extends(TreeContainer, _super);
      /**
       * @param cmp The compare function.
       * @param enableIndex Whether to enable iterator indexing function.
       */
      function TreeContainer(cmp, enableIndex) {
        if (cmp === void 0) {
          cmp = function (x, y) {
            if (x < y) return -1;
            if (x > y) return 1;
            return 0;
          };
        }
        if (enableIndex === void 0) {
          enableIndex = false;
        }
        var _this = _super.call(this) || this;
        /**
         * @internal
         */
        _this._root = undefined;
        /**
         * @description InOrder traversal the tree.
         * @internal
         */
        _this._inOrderTraversal = function (curNode, callback) {
          if (curNode === undefined) return false;
          var ifReturn = _this._inOrderTraversal(curNode._left, callback);
          if (ifReturn) return true;
          if (callback(curNode)) return true;
          return _this._inOrderTraversal(curNode._right, callback);
        };
        _this._cmp = cmp;
        if (enableIndex) {
          _this._TreeNodeClass = TreeNodeEnableIndex;
          _this._set = function (_key, _value, hint) {
            var curNode = this._preSet(_key, _value, hint);
            if (curNode) {
              var p = curNode._parent;
              while (p !== this._header) {
                p._subTreeSize += 1;
                p = p._parent;
              }
              var nodeList = this._insertNodeSelfBalance(curNode);
              if (nodeList) {
                var _a = nodeList,
                  parentNode = _a.parentNode,
                  grandParent = _a.grandParent,
                  curNode_1 = _a.curNode;
                parentNode.recount();
                grandParent.recount();
                curNode_1.recount();
              }
            }
          };
          _this._eraseNode = function (curNode) {
            var p = this._preEraseNode(curNode);
            while (p !== this._header) {
              p._subTreeSize -= 1;
              p = p._parent;
            }
          };
        } else {
          _this._TreeNodeClass = TreeNode;
          _this._set = function (key, value, hint) {
            var curNode = this._preSet(key, value, hint);
            if (curNode) this._insertNodeSelfBalance(curNode);
          };
          _this._eraseNode = _this._preEraseNode;
        }
        _this._header = new _this._TreeNodeClass();
        return _this;
      }
      /**
       * @param curNode The starting node of the search.
       * @param key The key you want to search.
       * @return TreeNode which _key is greater than or equals to the given key.
       * @internal
       */
      TreeContainer.prototype._lowerBound = function (curNode, key) {
        var resNode;
        while (curNode) {
          var cmpResult = this._cmp(curNode._key, key);
          if (cmpResult < 0) {
            curNode = curNode._right;
          } else if (cmpResult > 0) {
            resNode = curNode;
            curNode = curNode._left;
          } else return curNode;
        }
        return resNode === undefined ? this._header : resNode;
      };
      /**
       * @param curNode The starting node of the search.
       * @param key The key you want to search.
       * @return TreeNode which _key is greater than the given key.
       * @internal
       */
      TreeContainer.prototype._upperBound = function (curNode, key) {
        var resNode;
        while (curNode) {
          var cmpResult = this._cmp(curNode._key, key);
          if (cmpResult <= 0) {
            curNode = curNode._right;
          } else {
            resNode = curNode;
            curNode = curNode._left;
          }
        }
        return resNode === undefined ? this._header : resNode;
      };
      /**
       * @param curNode The starting node of the search.
       * @param key The key you want to search.
       * @return TreeNode which key is less than or equals to the given key.
       * @internal
       */
      TreeContainer.prototype._reverseLowerBound = function (curNode, key) {
        var resNode;
        while (curNode) {
          var cmpResult = this._cmp(curNode._key, key);
          if (cmpResult < 0) {
            resNode = curNode;
            curNode = curNode._right;
          } else if (cmpResult > 0) {
            curNode = curNode._left;
          } else return curNode;
        }
        return resNode === undefined ? this._header : resNode;
      };
      /**
       * @param curNode The starting node of the search.
       * @param key The key you want to search.
       * @return TreeNode which key is less than the given key.
       * @internal
       */
      TreeContainer.prototype._reverseUpperBound = function (curNode, key) {
        var resNode;
        while (curNode) {
          var cmpResult = this._cmp(curNode._key, key);
          if (cmpResult < 0) {
            resNode = curNode;
            curNode = curNode._right;
          } else {
            curNode = curNode._left;
          }
        }
        return resNode === undefined ? this._header : resNode;
      };
      /**
       * @description Make self balance after erase a node.
       * @param curNode The node want to remove.
       * @internal
       */
      TreeContainer.prototype._eraseNodeSelfBalance = function (curNode) {
        while (true) {
          var parentNode = curNode._parent;
          if (parentNode === this._header) return;
          if (curNode._color === 1 /* TreeNodeColor.RED */) {
            curNode._color = 0 /* TreeNodeColor.BLACK */;
            return;
          }
          if (curNode === parentNode._left) {
            var brother = parentNode._right;
            if (brother._color === 1 /* TreeNodeColor.RED */) {
              brother._color = 0 /* TreeNodeColor.BLACK */;
              parentNode._color = 1 /* TreeNodeColor.RED */;
              if (parentNode === this._root) {
                this._root = parentNode.rotateLeft();
              } else parentNode.rotateLeft();
            } else {
              if (brother._right && brother._right._color === 1 /* TreeNodeColor.RED */) {
                brother._color = parentNode._color;
                parentNode._color = 0 /* TreeNodeColor.BLACK */;
                brother._right._color = 0 /* TreeNodeColor.BLACK */;
                if (parentNode === this._root) {
                  this._root = parentNode.rotateLeft();
                } else parentNode.rotateLeft();
                return;
              } else if (brother._left && brother._left._color === 1 /* TreeNodeColor.RED */) {
                brother._color = 1 /* TreeNodeColor.RED */;
                brother._left._color = 0 /* TreeNodeColor.BLACK */;
                brother.rotateRight();
              } else {
                brother._color = 1 /* TreeNodeColor.RED */;
                curNode = parentNode;
              }
            }
          } else {
            var brother = parentNode._left;
            if (brother._color === 1 /* TreeNodeColor.RED */) {
              brother._color = 0 /* TreeNodeColor.BLACK */;
              parentNode._color = 1 /* TreeNodeColor.RED */;
              if (parentNode === this._root) {
                this._root = parentNode.rotateRight();
              } else parentNode.rotateRight();
            } else {
              if (brother._left && brother._left._color === 1 /* TreeNodeColor.RED */) {
                brother._color = parentNode._color;
                parentNode._color = 0 /* TreeNodeColor.BLACK */;
                brother._left._color = 0 /* TreeNodeColor.BLACK */;
                if (parentNode === this._root) {
                  this._root = parentNode.rotateRight();
                } else parentNode.rotateRight();
                return;
              } else if (brother._right && brother._right._color === 1 /* TreeNodeColor.RED */) {
                brother._color = 1 /* TreeNodeColor.RED */;
                brother._right._color = 0 /* TreeNodeColor.BLACK */;
                brother.rotateLeft();
              } else {
                brother._color = 1 /* TreeNodeColor.RED */;
                curNode = parentNode;
              }
            }
          }
        }
      };
      /**
       * @internal
       */
      TreeContainer.prototype._preEraseNode = function (curNode) {
        var _a, _b;
        if (this._length === 1) {
          this.clear();
          return this._header;
        }
        var swapNode = curNode;
        while (swapNode._left || swapNode._right) {
          if (swapNode._right) {
            swapNode = swapNode._right;
            while (swapNode._left) swapNode = swapNode._left;
          } else {
            swapNode = swapNode._left;
          }
          _a = __read([swapNode._key, curNode._key], 2), curNode._key = _a[0], swapNode._key = _a[1];
          _b = __read([swapNode._value, curNode._value], 2), curNode._value = _b[0], swapNode._value = _b[1];
          curNode = swapNode;
        }
        if (this._header._left === swapNode) {
          this._header._left = swapNode._parent;
        } else if (this._header._right === swapNode) {
          this._header._right = swapNode._parent;
        }
        this._eraseNodeSelfBalance(swapNode);
        var _parent = swapNode._parent;
        if (swapNode === _parent._left) {
          _parent._left = undefined;
        } else _parent._right = undefined;
        this._length -= 1;
        this._root._color = 0 /* TreeNodeColor.BLACK */;
        return _parent;
      };
      /**
       * @internal
       */
      TreeContainer.prototype._insertNodeSelfBalance = function (curNode) {
        while (true) {
          var parentNode = curNode._parent;
          if (parentNode._color === 0 /* TreeNodeColor.BLACK */) return;
          var grandParent = parentNode._parent;
          if (parentNode === grandParent._left) {
            var uncle = grandParent._right;
            if (uncle && uncle._color === 1 /* TreeNodeColor.RED */) {
              uncle._color = parentNode._color = 0 /* TreeNodeColor.BLACK */;
              if (grandParent === this._root) return;
              grandParent._color = 1 /* TreeNodeColor.RED */;
              curNode = grandParent;
              continue;
            } else if (curNode === parentNode._right) {
              curNode._color = 0 /* TreeNodeColor.BLACK */;
              if (curNode._left) curNode._left._parent = parentNode;
              if (curNode._right) curNode._right._parent = grandParent;
              parentNode._right = curNode._left;
              grandParent._left = curNode._right;
              curNode._left = parentNode;
              curNode._right = grandParent;
              if (grandParent === this._root) {
                this._root = curNode;
                this._header._parent = curNode;
              } else {
                var GP = grandParent._parent;
                if (GP._left === grandParent) {
                  GP._left = curNode;
                } else GP._right = curNode;
              }
              curNode._parent = grandParent._parent;
              parentNode._parent = curNode;
              grandParent._parent = curNode;
              grandParent._color = 1 /* TreeNodeColor.RED */;
              return {
                parentNode: parentNode,
                grandParent: grandParent,
                curNode: curNode
              };
            } else {
              parentNode._color = 0 /* TreeNodeColor.BLACK */;
              if (grandParent === this._root) {
                this._root = grandParent.rotateRight();
              } else grandParent.rotateRight();
              grandParent._color = 1 /* TreeNodeColor.RED */;
            }
          } else {
            var uncle = grandParent._left;
            if (uncle && uncle._color === 1 /* TreeNodeColor.RED */) {
              uncle._color = parentNode._color = 0 /* TreeNodeColor.BLACK */;
              if (grandParent === this._root) return;
              grandParent._color = 1 /* TreeNodeColor.RED */;
              curNode = grandParent;
              continue;
            } else if (curNode === parentNode._left) {
              curNode._color = 0 /* TreeNodeColor.BLACK */;
              if (curNode._left) curNode._left._parent = grandParent;
              if (curNode._right) curNode._right._parent = parentNode;
              grandParent._right = curNode._left;
              parentNode._left = curNode._right;
              curNode._left = grandParent;
              curNode._right = parentNode;
              if (grandParent === this._root) {
                this._root = curNode;
                this._header._parent = curNode;
              } else {
                var GP = grandParent._parent;
                if (GP._left === grandParent) {
                  GP._left = curNode;
                } else GP._right = curNode;
              }
              curNode._parent = grandParent._parent;
              parentNode._parent = curNode;
              grandParent._parent = curNode;
              grandParent._color = 1 /* TreeNodeColor.RED */;
              return {
                parentNode: parentNode,
                grandParent: grandParent,
                curNode: curNode
              };
            } else {
              parentNode._color = 0 /* TreeNodeColor.BLACK */;
              if (grandParent === this._root) {
                this._root = grandParent.rotateLeft();
              } else grandParent.rotateLeft();
              grandParent._color = 1 /* TreeNodeColor.RED */;
            }
          }

          return;
        }
      };
      /**
       * @internal
       */
      TreeContainer.prototype._preSet = function (key, _value, hint) {
        if (this._root === undefined) {
          this._length += 1;
          this._root = new this._TreeNodeClass(key, _value);
          this._root._color = 0 /* TreeNodeColor.BLACK */;
          this._root._parent = this._header;
          this._header._parent = this._root;
          this._header._left = this._root;
          this._header._right = this._root;
          return;
        }
        var curNode;
        var minNode = this._header._left;
        var compareToMin = this._cmp(minNode._key, key);
        if (compareToMin === 0) {
          minNode._value = _value;
          return;
        } else if (compareToMin > 0) {
          minNode._left = new this._TreeNodeClass(key, _value);
          minNode._left._parent = minNode;
          curNode = minNode._left;
          this._header._left = curNode;
        } else {
          var maxNode = this._header._right;
          var compareToMax = this._cmp(maxNode._key, key);
          if (compareToMax === 0) {
            maxNode._value = _value;
            return;
          } else if (compareToMax < 0) {
            maxNode._right = new this._TreeNodeClass(key, _value);
            maxNode._right._parent = maxNode;
            curNode = maxNode._right;
            this._header._right = curNode;
          } else {
            if (hint !== undefined) {
              var iterNode = hint._node;
              if (iterNode !== this._header) {
                var iterCmpRes = this._cmp(iterNode._key, key);
                if (iterCmpRes === 0) {
                  iterNode._value = _value;
                  return;
                } else /* istanbul ignore else */if (iterCmpRes > 0) {
                    var preNode = iterNode.pre();
                    var preCmpRes = this._cmp(preNode._key, key);
                    if (preCmpRes === 0) {
                      preNode._value = _value;
                      return;
                    } else if (preCmpRes < 0) {
                      curNode = new this._TreeNodeClass(key, _value);
                      if (preNode._right === undefined) {
                        preNode._right = curNode;
                        curNode._parent = preNode;
                      } else {
                        iterNode._left = curNode;
                        curNode._parent = iterNode;
                      }
                    }
                  }
              }
            }
            if (curNode === undefined) {
              curNode = this._root;
              while (true) {
                var cmpResult = this._cmp(curNode._key, key);
                if (cmpResult > 0) {
                  if (curNode._left === undefined) {
                    curNode._left = new this._TreeNodeClass(key, _value);
                    curNode._left._parent = curNode;
                    curNode = curNode._left;
                    break;
                  }
                  curNode = curNode._left;
                } else if (cmpResult < 0) {
                  if (curNode._right === undefined) {
                    curNode._right = new this._TreeNodeClass(key, _value);
                    curNode._right._parent = curNode;
                    curNode = curNode._right;
                    break;
                  }
                  curNode = curNode._right;
                } else {
                  curNode._value = _value;
                  return;
                }
              }
            }
          }
        }
        this._length += 1;
        return curNode;
      };
      TreeContainer.prototype.clear = function () {
        this._length = 0;
        this._root = undefined;
        this._header._parent = undefined;
        this._header._left = this._header._right = undefined;
      };
      /**
       * @description Update node's key by iterator.
       * @param iter The iterator you want to change.
       * @param key The key you want to update.
       * @return Boolean about if the modification is successful.
       * @example
       * const st = new orderedSet([1, 2, 5]);
       * const iter = st.find(2);
       * st.updateKeyByIterator(iter, 3); // then st will become [1, 3, 5]
       */
      TreeContainer.prototype.updateKeyByIterator = function (iter, key) {
        var node = iter._node;
        if (node === this._header) {
          throw new TypeError('Invalid iterator!');
        }
        if (this._length === 1) {
          node._key = key;
          return true;
        }
        if (node === this._header._left) {
          if (this._cmp(node.next()._key, key) > 0) {
            node._key = key;
            return true;
          }
          return false;
        }
        if (node === this._header._right) {
          if (this._cmp(node.pre()._key, key) < 0) {
            node._key = key;
            return true;
          }
          return false;
        }
        var preKey = node.pre()._key;
        if (this._cmp(preKey, key) >= 0) return false;
        var nextKey = node.next()._key;
        if (this._cmp(nextKey, key) <= 0) return false;
        node._key = key;
        return true;
      };
      TreeContainer.prototype.eraseElementByPos = function (pos) {
        var _this = this;
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        var index = 0;
        this._inOrderTraversal(this._root, function (curNode) {
          if (pos === index) {
            _this._eraseNode(curNode);
            return true;
          }
          index += 1;
          return false;
        });
      };
      /**
       * @description Find node which key is equals to the given key.
       * @param curNode The starting node of the search.
       * @param key The key you want to search.
       * @internal
       */
      TreeContainer.prototype._findElementNode = function (curNode, key) {
        while (curNode) {
          var cmpResult = this._cmp(curNode._key, key);
          if (cmpResult < 0) {
            curNode = curNode._right;
          } else if (cmpResult > 0) {
            curNode = curNode._left;
          } else return curNode;
        }
        return curNode;
      };
      /**
       * @description Remove the element of the specified _key.
       * @param key The _key you want to remove.
       */
      TreeContainer.prototype.eraseElementByKey = function (key) {
        if (!this._length) return;
        var curNode = this._findElementNode(this._root, key);
        if (curNode === undefined) return;
        this._eraseNode(curNode);
      };
      TreeContainer.prototype.eraseElementByIterator = function (iter) {
        var node = iter._node;
        if (node === this._header) {
          throw new RangeError('Invalid iterator');
        }
        if (node._right === undefined) {
          iter = iter.next();
        }
        this._eraseNode(node);
        return iter;
      };
      /**
       * @description Get the height of the tree.
       * @return Number about the height of the RB-tree.
       */
      TreeContainer.prototype.getHeight = function () {
        if (!this._length) return 0;
        var traversal = function (curNode) {
          if (!curNode) return 0;
          return Math.max(traversal(curNode._left), traversal(curNode._right)) + 1;
        };
        return traversal(this._root);
      };
      return TreeContainer;
    }(Container);

    var TreeIterator = /** @class */function (_super) {
      __extends(TreeIterator, _super);
      /**
       * @internal
       */
      function TreeIterator(_node, _header, iteratorType) {
        var _this = _super.call(this, iteratorType) || this;
        _this._node = _node;
        _this._header = _header;
        if (_this.iteratorType === 0 /* IteratorType.NORMAL */) {
          _this.pre = function () {
            if (this._node === this._header._left) {
              throw new RangeError('Tree iterator access denied!');
            }
            this._node = this._node.pre();
            return this;
          };
          _this.next = function () {
            if (this._node === this._header) {
              throw new RangeError('Tree iterator access denied!');
            }
            this._node = this._node.next();
            return this;
          };
        } else {
          _this.pre = function () {
            if (this._node === this._header._right) {
              throw new RangeError('Tree iterator access denied!');
            }
            this._node = this._node.next();
            return this;
          };
          _this.next = function () {
            if (this._node === this._header) {
              throw new RangeError('Tree iterator access denied!');
            }
            this._node = this._node.pre();
            return this;
          };
        }
        return _this;
      }
      Object.defineProperty(TreeIterator.prototype, "index", {
        /**
         * @description Get the sequential index of the iterator in the tree container.<br/>
         *              <strong>
         *                Note:
         *              </strong>
         *              This function only takes effect when the specified tree container `enableIndex = true`.
         * @example
         * const st = new OrderedSet([1, 2, 3], true);
         * console.log(st.begin().next().index);  // 1
         */
        get: function () {
          var _node = this._node;
          var root = this._header._parent;
          if (_node === this._header) {
            if (root) {
              return root._subTreeSize - 1;
            }
            return 0;
          }
          var index = 0;
          if (_node._left) {
            index += _node._left._subTreeSize;
          }
          while (_node !== root) {
            var _parent = _node._parent;
            if (_node === _parent._right) {
              index += 1;
              if (_parent._left) {
                index += _parent._left._subTreeSize;
              }
            }
            _node = _parent;
          }
          return index;
        },
        enumerable: false,
        configurable: true
      });
      TreeIterator.prototype.equals = function (obj) {
        return this._node === obj._node;
      };
      return TreeIterator;
    }(ContainerIterator);

    var OrderedSetIterator = /** @class */function (_super) {
      __extends(OrderedSetIterator, _super);
      function OrderedSetIterator() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      Object.defineProperty(OrderedSetIterator.prototype, "pointer", {
        get: function () {
          if (this._node === this._header) {
            throw new RangeError('OrderedSet iterator access denied!');
          }
          return this._node._key;
        },
        enumerable: false,
        configurable: true
      });
      OrderedSetIterator.prototype.copy = function () {
        return new OrderedSetIterator(this._node, this._header, this.iteratorType);
      };
      return OrderedSetIterator;
    }(TreeIterator);
    var OrderedSet = /** @class */function (_super) {
      __extends(OrderedSet, _super);
      /**
       * @param container The initialization container.
       * @param cmp The compare function.
       * @param enableIndex Whether to enable iterator indexing function.
       * @example
       * new OrderedSet();
       * new OrderedSet([0, 1, 2]);
       * new OrderedSet([0, 1, 2], (x, y) => x - y);
       * new OrderedSet([0, 1, 2], (x, y) => x - y, true);
       */
      function OrderedSet(container, cmp, enableIndex) {
        if (container === void 0) {
          container = [];
        }
        var _this = _super.call(this, cmp, enableIndex) || this;
        /**
         * @internal
         */
        _this._iterationFunc = function (curNode) {
          return __generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                if (curNode === undefined) return [2 /*return*/];
                return [5 /*yield**/, __values(this._iterationFunc(curNode._left))];
              case 1:
                _a.sent();
                return [4 /*yield*/, curNode._key];
              case 2:
                _a.sent();
                return [5 /*yield**/, __values(this._iterationFunc(curNode._right))];
              case 3:
                _a.sent();
                return [2 /*return*/];
            }
          });
        };

        container.forEach(function (element) {
          return _this.insert(element);
        });
        return _this;
      }
      OrderedSet.prototype.begin = function () {
        return new OrderedSetIterator(this._header._left || this._header, this._header);
      };
      OrderedSet.prototype.end = function () {
        return new OrderedSetIterator(this._header, this._header);
      };
      OrderedSet.prototype.rBegin = function () {
        return new OrderedSetIterator(this._header._right || this._header, this._header, 1 /* IteratorType.REVERSE */);
      };

      OrderedSet.prototype.rEnd = function () {
        return new OrderedSetIterator(this._header, this._header, 1 /* IteratorType.REVERSE */);
      };

      OrderedSet.prototype.front = function () {
        return this._header._left ? this._header._left._key : undefined;
      };
      OrderedSet.prototype.back = function () {
        return this._header._right ? this._header._right._key : undefined;
      };
      OrderedSet.prototype.forEach = function (callback) {
        var e_1, _a;
        var index = 0;
        try {
          for (var _b = __values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
            var element = _c.value;
            callback(element, index++, this);
          }
        } catch (e_1_1) {
          e_1 = {
            error: e_1_1
          };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
      };
      OrderedSet.prototype.getElementByPos = function (pos) {
        var e_2, _a;
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        var res;
        var index = 0;
        try {
          for (var _b = __values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
            var element = _c.value;
            if (index === pos) {
              res = element;
              break;
            }
            index += 1;
          }
        } catch (e_2_1) {
          e_2 = {
            error: e_2_1
          };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
          } finally {
            if (e_2) throw e_2.error;
          }
        }
        return res;
      };
      /**
       * @description Insert element to set.
       * @param key The key want to insert.
       * @param hint You can give an iterator hint to improve insertion efficiency.
       * @example
       * const st = new OrderedSet([2, 4, 5]);
       * const iter = st.begin();
       * st.insert(1);
       * st.insert(3, iter);  // give a hint will be faster.
       */
      OrderedSet.prototype.insert = function (key, hint) {
        this._set(key, undefined, hint);
      };
      OrderedSet.prototype.find = function (element) {
        var curNode = this._findElementNode(this._root, element);
        if (curNode !== undefined) {
          return new OrderedSetIterator(curNode, this._header);
        }
        return this.end();
      };
      OrderedSet.prototype.lowerBound = function (key) {
        var resNode = this._lowerBound(this._root, key);
        return new OrderedSetIterator(resNode, this._header);
      };
      OrderedSet.prototype.upperBound = function (key) {
        var resNode = this._upperBound(this._root, key);
        return new OrderedSetIterator(resNode, this._header);
      };
      OrderedSet.prototype.reverseLowerBound = function (key) {
        var resNode = this._reverseLowerBound(this._root, key);
        return new OrderedSetIterator(resNode, this._header);
      };
      OrderedSet.prototype.reverseUpperBound = function (key) {
        var resNode = this._reverseUpperBound(this._root, key);
        return new OrderedSetIterator(resNode, this._header);
      };
      OrderedSet.prototype.union = function (other) {
        var _this = this;
        other.forEach(function (element) {
          return _this.insert(element);
        });
      };
      OrderedSet.prototype[Symbol.iterator] = function () {
        return this._iterationFunc(this._root);
      };
      return OrderedSet;
    }(TreeContainer);

    var OrderedMapIterator = /** @class */function (_super) {
      __extends(OrderedMapIterator, _super);
      function OrderedMapIterator() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      Object.defineProperty(OrderedMapIterator.prototype, "pointer", {
        get: function () {
          var _this = this;
          if (this._node === this._header) {
            throw new RangeError('OrderedMap iterator access denied');
          }
          return new Proxy([], {
            get: function (_, props) {
              if (props === '0') return _this._node._key;else if (props === '1') return _this._node._value;
            },
            set: function (_, props, newValue) {
              if (props !== '1') {
                throw new TypeError('props must be 1');
              }
              _this._node._value = newValue;
              return true;
            }
          });
        },
        enumerable: false,
        configurable: true
      });
      OrderedMapIterator.prototype.copy = function () {
        return new OrderedMapIterator(this._node, this._header, this.iteratorType);
      };
      return OrderedMapIterator;
    }(TreeIterator);
    var OrderedMap = /** @class */function (_super) {
      __extends(OrderedMap, _super);
      /**
       * @param container The initialization container.
       * @param cmp The compare function.
       * @param enableIndex Whether to enable iterator indexing function.
       * @example
       * new OrderedMap();
       * new OrderedMap([[0, 1], [2, 1]]);
       * new OrderedMap([[0, 1], [2, 1]], (x, y) => x - y);
       * new OrderedMap([[0, 1], [2, 1]], (x, y) => x - y, true);
       */
      function OrderedMap(container, cmp, enableIndex) {
        if (container === void 0) {
          container = [];
        }
        var _this = _super.call(this, cmp, enableIndex) || this;
        /**
         * @internal
         */
        _this._iterationFunc = function (curNode) {
          return __generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                if (curNode === undefined) return [2 /*return*/];
                return [5 /*yield**/, __values(this._iterationFunc(curNode._left))];
              case 1:
                _a.sent();
                return [4 /*yield*/, [curNode._key, curNode._value]];
              case 2:
                _a.sent();
                return [5 /*yield**/, __values(this._iterationFunc(curNode._right))];
              case 3:
                _a.sent();
                return [2 /*return*/];
            }
          });
        };

        container.forEach(function (_a) {
          var _b = __read(_a, 2),
            _key = _b[0],
            _value = _b[1];
          return _this.setElement(_key, _value);
        });
        return _this;
      }
      OrderedMap.prototype.begin = function () {
        return new OrderedMapIterator(this._header._left || this._header, this._header);
      };
      OrderedMap.prototype.end = function () {
        return new OrderedMapIterator(this._header, this._header);
      };
      OrderedMap.prototype.rBegin = function () {
        return new OrderedMapIterator(this._header._right || this._header, this._header, 1 /* IteratorType.REVERSE */);
      };

      OrderedMap.prototype.rEnd = function () {
        return new OrderedMapIterator(this._header, this._header, 1 /* IteratorType.REVERSE */);
      };

      OrderedMap.prototype.front = function () {
        if (!this._length) return undefined;
        var minNode = this._header._left;
        return [minNode._key, minNode._value];
      };
      OrderedMap.prototype.back = function () {
        if (!this._length) return undefined;
        var maxNode = this._header._right;
        return [maxNode._key, maxNode._value];
      };
      OrderedMap.prototype.forEach = function (callback) {
        var e_1, _a;
        var index = 0;
        try {
          for (var _b = __values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
            var pair = _c.value;
            callback(pair, index++, this);
          }
        } catch (e_1_1) {
          e_1 = {
            error: e_1_1
          };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
      };
      OrderedMap.prototype.lowerBound = function (key) {
        var resNode = this._lowerBound(this._root, key);
        return new OrderedMapIterator(resNode, this._header);
      };
      OrderedMap.prototype.upperBound = function (key) {
        var resNode = this._upperBound(this._root, key);
        return new OrderedMapIterator(resNode, this._header);
      };
      OrderedMap.prototype.reverseLowerBound = function (key) {
        var resNode = this._reverseLowerBound(this._root, key);
        return new OrderedMapIterator(resNode, this._header);
      };
      OrderedMap.prototype.reverseUpperBound = function (key) {
        var resNode = this._reverseUpperBound(this._root, key);
        return new OrderedMapIterator(resNode, this._header);
      };
      /**
       * @description Insert a key-value pair or set value by the given key.
       * @param key The key want to insert.
       * @param value The value want to set.
       * @param hint You can give an iterator hint to improve insertion efficiency.
       * @example
       * const mp = new OrderedMap([[2, 0], [4, 0], [5, 0]]);
       * const iter = mp.begin();
       * mp.setElement(1, 0);
       * mp.setElement(3, 0, iter);  // give a hint will be faster.
       */
      OrderedMap.prototype.setElement = function (key, value, hint) {
        this._set(key, value, hint);
      };
      OrderedMap.prototype.find = function (key) {
        var curNode = this._findElementNode(this._root, key);
        if (curNode !== undefined) {
          return new OrderedMapIterator(curNode, this._header);
        }
        return this.end();
      };
      /**
       * @description Get the value of the element of the specified key.
       * @example const val = container.getElementByKey(1);
       */
      OrderedMap.prototype.getElementByKey = function (key) {
        var curNode = this._findElementNode(this._root, key);
        return curNode ? curNode._value : undefined;
      };
      OrderedMap.prototype.getElementByPos = function (pos) {
        var e_2, _a;
        if (pos < 0 || pos > this._length - 1) {
          throw new RangeError();
        }
        var res;
        var index = 0;
        try {
          for (var _b = __values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
            var pair = _c.value;
            if (index === pos) {
              res = pair;
              break;
            }
            index += 1;
          }
        } catch (e_2_1) {
          e_2 = {
            error: e_2_1
          };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
          } finally {
            if (e_2) throw e_2.error;
          }
        }
        return res;
      };
      OrderedMap.prototype.union = function (other) {
        var _this = this;
        other.forEach(function (_a) {
          var _b = __read(_a, 2),
            _key = _b[0],
            _value = _b[1];
          return _this.setElement(_key, _value);
        });
      };
      OrderedMap.prototype[Symbol.iterator] = function () {
        return this._iterationFunc(this._root);
      };
      return OrderedMap;
    }(TreeContainer);

    var HashContainer = /** @class */function (_super) {
      __extends(HashContainer, _super);
      function HashContainer(initBucketNum, hashFunc) {
        if (initBucketNum === void 0) {
          initBucketNum = 16;
        }
        if (hashFunc === void 0) {
          hashFunc = function (x) {
            var str;
            if (typeof x !== 'string') {
              str = JSON.stringify(x);
            } else str = x;
            var hashCode = 0;
            var strLength = str.length;
            for (var i = 0; i < strLength; i++) {
              var ch = str.charCodeAt(i);
              hashCode = (hashCode << 5) - hashCode + ch;
              hashCode |= 0;
            }
            return hashCode >>> 0;
          };
        }
        var _this = _super.call(this) || this;
        if (initBucketNum < 16 || (initBucketNum & initBucketNum - 1) !== 0) {
          throw new RangeError('InitBucketNum range error');
        }
        _this._bucketNum = _this._initBucketNum = initBucketNum;
        _this._hashFunc = hashFunc;
        return _this;
      }
      HashContainer.prototype.clear = function () {
        this._length = 0;
        this._bucketNum = this._initBucketNum;
        this._hashTable = [];
      };
      return HashContainer;
    }(Base);

    var HashSet = /** @class */function (_super) {
      __extends(HashSet, _super);
      /**
       * @description HashSet's constructor.
       * @param container Initialize container, must have a forEach function.
       * @param initBucketNum Initialize bucket num, must be an integer power of 2 and greater than 16.
       * @param hashFunc The hash function, convert key element from type T to a number.
       * @example new HashSet([1, 2, 3], 1 << 10, x => x);
       */
      function HashSet(container, initBucketNum, hashFunc) {
        if (container === void 0) {
          container = [];
        }
        var _this = _super.call(this, initBucketNum, hashFunc) || this;
        /**
         * @internal
         */
        _this._hashTable = [];
        container.forEach(function (element) {
          return _this.insert(element);
        });
        return _this;
      }
      /**
       * @internal
       */
      HashSet.prototype._reAllocate = function () {
        var _this = this;
        if (this._bucketNum >= 1073741824 /* HashContainerConst.maxBucketNum */) return;
        var newHashTable = [];
        var originalBucketNum = this._bucketNum;
        this._bucketNum <<= 1;
        var keys = Object.keys(this._hashTable);
        var keyNums = keys.length;
        var _loop_1 = function (i) {
          var index = parseInt(keys[i]);
          var container = this_1._hashTable[index];
          var size = container.size();
          if (size === 0) return "continue";
          if (size === 1) {
            var element = container.front();
            newHashTable[this_1._hashFunc(element) & this_1._bucketNum - 1] = new Vector([element], false);
            return "continue";
          }
          var lowList = [];
          var highList = [];
          container.forEach(function (element) {
            var hashCode = _this._hashFunc(element);
            if ((hashCode & originalBucketNum) === 0) {
              lowList.push(element);
            } else highList.push(element);
          });
          if (container instanceof OrderedSet) {
            if (lowList.length > 6 /* HashContainerConst.untreeifyThreshold */) {
              newHashTable[index] = new OrderedSet(lowList);
            } else {
              newHashTable[index] = new Vector(lowList, false);
            }
            if (highList.length > 6 /* HashContainerConst.untreeifyThreshold */) {
              newHashTable[index + originalBucketNum] = new OrderedSet(highList);
            } else {
              newHashTable[index + originalBucketNum] = new Vector(highList, false);
            }
          } else {
            newHashTable[index] = new Vector(lowList, false);
            newHashTable[index + originalBucketNum] = new Vector(highList, false);
          }
        };
        var this_1 = this;
        for (var i = 0; i < keyNums; ++i) {
          _loop_1(i);
        }
        this._hashTable = newHashTable;
      };
      HashSet.prototype.forEach = function (callback) {
        var _this = this;
        var containers = Object.values(this._hashTable);
        var containersNum = containers.length;
        var index = 0;
        for (var i = 0; i < containersNum; ++i) {
          containers[i].forEach(function (element) {
            return callback(element, index++, _this);
          });
        }
      };
      /**
       * @description Insert element to hash set.
       * @param element The element you want to insert.
       * @example container.insert(1);
       */
      HashSet.prototype.insert = function (element) {
        var index = this._hashFunc(element) & this._bucketNum - 1;
        var container = this._hashTable[index];
        if (!container) {
          this._hashTable[index] = new Vector([element], false);
          this._length += 1;
        } else {
          var preSize = container.size();
          if (container instanceof Vector) {
            if (!container.find(element).equals(container.end())) return;
            container.pushBack(element);
            if (preSize + 1 >= 8 /* HashContainerConst.treeifyThreshold */) {
              if (this._bucketNum <= 64 /* HashContainerConst.minTreeifySize */) {
                this._length += 1;
                this._reAllocate();
                return;
              }
              this._hashTable[index] = new OrderedSet(container);
            }
            this._length += 1;
          } else {
            container.insert(element);
            var curSize = container.size();
            this._length += curSize - preSize;
          }
        }
        if (this._length > this._bucketNum * 0.75 /* HashContainerConst.sigma */) {
          this._reAllocate();
        }
      };
      HashSet.prototype.eraseElementByKey = function (key) {
        var index = this._hashFunc(key) & this._bucketNum - 1;
        var container = this._hashTable[index];
        if (!container) return;
        var preSize = container.size();
        if (preSize === 0) return;
        if (container instanceof Vector) {
          container.eraseElementByValue(key);
          var curSize = container.size();
          this._length += curSize - preSize;
        } else {
          container.eraseElementByKey(key);
          var curSize = container.size();
          this._length += curSize - preSize;
          if (curSize <= 6 /* HashContainerConst.untreeifyThreshold */) {
            this._hashTable[index] = new Vector(container);
          }
        }
      };
      HashSet.prototype.find = function (element) {
        var index = this._hashFunc(element) & this._bucketNum - 1;
        var container = this._hashTable[index];
        if (!container) return false;
        return !container.find(element).equals(container.end());
      };
      HashSet.prototype[Symbol.iterator] = function () {
        return function () {
          var containers, containersNum, i, container, container_1, container_1_1, element, e_1_1;
          var e_1, _a;
          return __generator(this, function (_b) {
            switch (_b.label) {
              case 0:
                containers = Object.values(this._hashTable);
                containersNum = containers.length;
                i = 0;
                _b.label = 1;
              case 1:
                if (!(i < containersNum)) return [3 /*break*/, 10];
                container = containers[i];
                _b.label = 2;
              case 2:
                _b.trys.push([2, 7, 8, 9]);
                container_1 = (e_1 = void 0, __values(container)), container_1_1 = container_1.next();
                _b.label = 3;
              case 3:
                if (!!container_1_1.done) return [3 /*break*/, 6];
                element = container_1_1.value;
                return [4 /*yield*/, element];
              case 4:
                _b.sent();
                _b.label = 5;
              case 5:
                container_1_1 = container_1.next();
                return [3 /*break*/, 3];
              case 6:
                return [3 /*break*/, 9];
              case 7:
                e_1_1 = _b.sent();
                e_1 = {
                  error: e_1_1
                };
                return [3 /*break*/, 9];
              case 8:
                try {
                  if (container_1_1 && !container_1_1.done && (_a = container_1.return)) _a.call(container_1);
                } finally {
                  if (e_1) throw e_1.error;
                }
                return [7 /*endfinally*/];
              case 9:
                ++i;
                return [3 /*break*/, 1];
              case 10:
                return [2 /*return*/];
            }
          });
        }.bind(this)();
      };
      return HashSet;
    }(HashContainer);

    var HashMap = /** @class */function (_super) {
      __extends(HashMap, _super);
      /**
       * @description HashMap's constructor.
       * @param container Initialize container, must have a forEach function.
       * @param initBucketNum Initialize bucket num, must be an integer power of 2 and greater than 16.
       * @param hashFunc The hash function, convert key element from type T to a number.
       * @example new HashMap([[0, 1], [2, 1], [3, 2]], 1 << 10, x => x);
       */
      function HashMap(container, initBucketNum, hashFunc) {
        if (container === void 0) {
          container = [];
        }
        var _this = _super.call(this, initBucketNum, hashFunc) || this;
        /**
         * @internal
         */
        _this._hashTable = [];
        container.forEach(function (element) {
          return _this.setElement(element[0], element[1]);
        });
        return _this;
      }
      /**
       * @internal
       */
      HashMap.prototype._reAllocate = function () {
        var _this = this;
        if (this._bucketNum >= 1073741824 /* HashContainerConst.maxBucketNum */) return;
        var newHashTable = [];
        var originalBucketNum = this._bucketNum;
        this._bucketNum <<= 1;
        var keys = Object.keys(this._hashTable);
        var keyNums = keys.length;
        var _loop_1 = function (i) {
          var index = parseInt(keys[i]);
          var container = this_1._hashTable[index];
          var size = container.size();
          if (size === 0) return "continue";
          if (size === 1) {
            var element = container.front();
            newHashTable[this_1._hashFunc(element[0]) & this_1._bucketNum - 1] = new Vector([element], false);
            return "continue";
          }
          var lowList = [];
          var highList = [];
          container.forEach(function (element) {
            var hashCode = _this._hashFunc(element[0]);
            if ((hashCode & originalBucketNum) === 0) {
              lowList.push(element);
            } else highList.push(element);
          });
          if (container instanceof OrderedMap) {
            if (lowList.length > 6 /* HashContainerConst.untreeifyThreshold */) {
              newHashTable[index] = new OrderedMap(lowList);
            } else {
              newHashTable[index] = new Vector(lowList, false);
            }
            if (highList.length > 6 /* HashContainerConst.untreeifyThreshold */) {
              newHashTable[index + originalBucketNum] = new OrderedMap(highList);
            } else {
              newHashTable[index + originalBucketNum] = new Vector(highList, false);
            }
          } else {
            newHashTable[index] = new Vector(lowList, false);
            newHashTable[index + originalBucketNum] = new Vector(highList, false);
          }
        };
        var this_1 = this;
        for (var i = 0; i < keyNums; ++i) {
          _loop_1(i);
        }
        this._hashTable = newHashTable;
      };
      HashMap.prototype.forEach = function (callback) {
        var _this = this;
        var containers = Object.values(this._hashTable);
        var containersNum = containers.length;
        var index = 0;
        for (var i = 0; i < containersNum; ++i) {
          containers[i].forEach(function (element) {
            return callback(element, index++, _this);
          });
        }
      };
      /**
       * @description Insert a new key-value pair to hash map or set value by key.
       * @param key The key you want to insert.
       * @param value The value you want to insert.
       * @example HashMap.setElement(1, 2); // insert a key-value pair [1, 2]
       */
      HashMap.prototype.setElement = function (key, value) {
        var e_1, _a;
        var index = this._hashFunc(key) & this._bucketNum - 1;
        var container = this._hashTable[index];
        if (!container) {
          this._length += 1;
          this._hashTable[index] = new Vector([[key, value]], false);
        } else {
          var preSize = container.size();
          if (container instanceof Vector) {
            try {
              for (var container_1 = __values(container), container_1_1 = container_1.next(); !container_1_1.done; container_1_1 = container_1.next()) {
                var pair = container_1_1.value;
                if (pair[0] === key) {
                  pair[1] = value;
                  return;
                }
              }
            } catch (e_1_1) {
              e_1 = {
                error: e_1_1
              };
            } finally {
              try {
                if (container_1_1 && !container_1_1.done && (_a = container_1.return)) _a.call(container_1);
              } finally {
                if (e_1) throw e_1.error;
              }
            }
            container.pushBack([key, value]);
            if (preSize + 1 >= 8 /* HashContainerConst.treeifyThreshold */) {
              if (this._bucketNum <= 64 /* HashContainerConst.minTreeifySize */) {
                this._length += 1;
                this._reAllocate();
                return;
              }
              this._hashTable[index] = new OrderedMap(this._hashTable[index]);
            }
            this._length += 1;
          } else {
            container.setElement(key, value);
            var curSize = container.size();
            this._length += curSize - preSize;
          }
        }
        if (this._length > this._bucketNum * 0.75 /* HashContainerConst.sigma */) {
          this._reAllocate();
        }
      };
      /**
       * @description Get the value of the element which has the specified key.
       * @param key The key you want to get.
       * @example const value = container.getElementByKey(1);
       */
      HashMap.prototype.getElementByKey = function (key) {
        var e_2, _a;
        var index = this._hashFunc(key) & this._bucketNum - 1;
        var container = this._hashTable[index];
        if (!container) return undefined;
        if (container instanceof OrderedMap) {
          return container.getElementByKey(key);
        } else {
          try {
            for (var container_2 = __values(container), container_2_1 = container_2.next(); !container_2_1.done; container_2_1 = container_2.next()) {
              var pair = container_2_1.value;
              if (pair[0] === key) return pair[1];
            }
          } catch (e_2_1) {
            e_2 = {
              error: e_2_1
            };
          } finally {
            try {
              if (container_2_1 && !container_2_1.done && (_a = container_2.return)) _a.call(container_2);
            } finally {
              if (e_2) throw e_2.error;
            }
          }
          return undefined;
        }
      };
      HashMap.prototype.eraseElementByKey = function (key) {
        var e_3, _a;
        var index = this._hashFunc(key) & this._bucketNum - 1;
        var container = this._hashTable[index];
        if (!container) return;
        if (container instanceof Vector) {
          var pos = 0;
          try {
            for (var container_3 = __values(container), container_3_1 = container_3.next(); !container_3_1.done; container_3_1 = container_3.next()) {
              var pair = container_3_1.value;
              if (pair[0] === key) {
                container.eraseElementByPos(pos);
                this._length -= 1;
                return;
              }
              pos += 1;
            }
          } catch (e_3_1) {
            e_3 = {
              error: e_3_1
            };
          } finally {
            try {
              if (container_3_1 && !container_3_1.done && (_a = container_3.return)) _a.call(container_3);
            } finally {
              if (e_3) throw e_3.error;
            }
          }
        } else {
          var preSize = container.size();
          container.eraseElementByKey(key);
          var curSize = container.size();
          this._length += curSize - preSize;
          if (curSize <= 6 /* HashContainerConst.untreeifyThreshold */) {
            this._hashTable[index] = new Vector(container);
          }
        }
      };
      HashMap.prototype.find = function (key) {
        var e_4, _a;
        var index = this._hashFunc(key) & this._bucketNum - 1;
        var container = this._hashTable[index];
        if (!container) return false;
        if (container instanceof OrderedMap) {
          return !container.find(key).equals(container.end());
        }
        try {
          for (var container_4 = __values(container), container_4_1 = container_4.next(); !container_4_1.done; container_4_1 = container_4.next()) {
            var pair = container_4_1.value;
            if (pair[0] === key) return true;
          }
        } catch (e_4_1) {
          e_4 = {
            error: e_4_1
          };
        } finally {
          try {
            if (container_4_1 && !container_4_1.done && (_a = container_4.return)) _a.call(container_4);
          } finally {
            if (e_4) throw e_4.error;
          }
        }
        return false;
      };
      HashMap.prototype[Symbol.iterator] = function () {
        return function () {
          var containers, containersNum, i, container, container_5, container_5_1, element, e_5_1;
          var e_5, _a;
          return __generator(this, function (_b) {
            switch (_b.label) {
              case 0:
                containers = Object.values(this._hashTable);
                containersNum = containers.length;
                i = 0;
                _b.label = 1;
              case 1:
                if (!(i < containersNum)) return [3 /*break*/, 10];
                container = containers[i];
                _b.label = 2;
              case 2:
                _b.trys.push([2, 7, 8, 9]);
                container_5 = (e_5 = void 0, __values(container)), container_5_1 = container_5.next();
                _b.label = 3;
              case 3:
                if (!!container_5_1.done) return [3 /*break*/, 6];
                element = container_5_1.value;
                return [4 /*yield*/, element];
              case 4:
                _b.sent();
                _b.label = 5;
              case 5:
                container_5_1 = container_5.next();
                return [3 /*break*/, 3];
              case 6:
                return [3 /*break*/, 9];
              case 7:
                e_5_1 = _b.sent();
                e_5 = {
                  error: e_5_1
                };
                return [3 /*break*/, 9];
              case 8:
                try {
                  if (container_5_1 && !container_5_1.done && (_a = container_5.return)) _a.call(container_5);
                } finally {
                  if (e_5) throw e_5.error;
                }
                return [7 /*endfinally*/];
              case 9:
                ++i;
                return [3 /*break*/, 1];
              case 10:
                return [2 /*return*/];
            }
          });
        }.bind(this)();
      };
      return HashMap;
    }(HashContainer);

    exports.Deque = Deque;
    exports.HashMap = HashMap;
    exports.HashSet = HashSet;
    exports.LinkList = LinkList;
    exports.OrderedMap = OrderedMap;
    exports.OrderedSet = OrderedSet;
    exports.PriorityQueue = PriorityQueue;
    exports.Queue = Queue;
    exports.Stack = Stack;
    exports.Vector = Vector;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
