"use strict";

Object.defineProperty(exports, "t", {
    value: true
});

exports.default = void 0;

var _ContainerBase = require("../../ContainerBase");

var _checkObject = _interopRequireDefault(require("../../../utils/checkObject"));

function _interopRequireDefault(e) {
    return e && e.t ? e : {
        default: e
    };
}

class HashContainer extends _ContainerBase.Base {
    constructor() {
        super();
        this.u = [];
        this.h = {};
        this.HASH_KEY_TAG = Symbol("JS_SDSL_HASH_KEY_TAG");
        Object.setPrototypeOf(this.h, null);
    }
    i(e, t, i) {
        if (i === undefined) i = (0, _checkObject.default)(e);
        if (i) {
            const i = e[this.HASH_KEY_TAG];
            if (i !== undefined) {
                this.u[i][1] = t;
                return;
            }
            Object.defineProperty(e, this.HASH_KEY_TAG, {
                value: this.u.length,
                configurable: true
            });
            this.u.push([ e, t ]);
        } else {
            const i = this.h[e];
            if (i) {
                i[1] = t;
                return;
            }
            this.h[e] = [ e, t ];
        }
        this.o += 1;
    }
    clear() {
        const e = this;
        this.u.forEach((function(t) {
            delete t[0][e.HASH_KEY_TAG];
        }));
        this.u = [];
        this.h = {};
        Object.setPrototypeOf(this.h, null);
        this.o = 0;
    }
    eraseElementByKey(e, t) {
        if (t === undefined) t = (0, _checkObject.default)(e);
        if (t) {
            const t = e[this.HASH_KEY_TAG];
            if (t === undefined) return;
            delete e[this.HASH_KEY_TAG];
            delete this.u[t];
        } else {
            if (this.h[e] === undefined) return;
            delete this.h[e];
        }
        this.o -= 1;
    }
    find(e, t) {
        if (t === undefined) t = (0, _checkObject.default)(e);
        if (t) {
            return typeof e[this.HASH_KEY_TAG] === "number";
        } else {
            return this.h[e] !== undefined;
        }
    }
}

var _default = HashContainer;

exports.default = _default;
//# sourceMappingURL=index.js.map
