import { initContainer } from "../ContainerBase";
import HashContainer from "./Base";
declare class HashMap<K, V> extends HashContainer<K, V> {
    constructor(container?: initContainer<[K, V]>);
    /**
     * @description Insert a key-value pair or set value by the given key.
     * @param key The key want to insert.
     * @param value The value want to set.
     * @param isObject Tell us if the type of inserted key is `object` to improve efficiency.<br/>
     *                 If a `undefined` value is passed in, the type will be automatically judged.
     */
    setElement(key: K, value: V, isObject?: boolean): void;
    /**
     * @description Get the value of the element of the specified key.
     * @param key The key want to search.
     * @param isObject Tell us if the type of inserted key is `object` to improve efficiency.<br/>
     *                 If a `undefined` value is passed in, the type will be automatically judged.
     * @example const val = container.getElementByKey(1);
     */
    getElementByKey(key: K, isObject?: boolean): V | undefined;
    forEach(callback: (element: [K, V], index: number, hashMap: HashMap<K, V>) => void): void;
    [Symbol.iterator](): Generator<[K, V], void, undefined>;
}
export default HashMap;
