"use strict";

Object.defineProperty(exports, "t", {
    value: true
});

exports.default = void 0;

var _ContainerBase = require("../ContainerBase");

class PriorityQueue extends _ContainerBase.Base {
    constructor(t = [], s = function(t, s) {
        if (t > s) return -1;
        if (t < s) return 1;
        return 0;
    }, i = true) {
        super();
        this.l = s;
        if (Array.isArray(t)) {
            this.p = i ? [ ...t ] : t;
        } else {
            this.p = [];
            const s = this;
            t.forEach((function(t) {
                s.p.push(t);
            }));
        }
        this.o = this.p.length;
        const e = this.o >> 1;
        for (let t = this.o - 1 >> 1; t >= 0; --t) {
            this._(t, e);
        }
    }
    v(t) {
        const s = this.p[t];
        while (t > 0) {
            const i = t - 1 >> 1;
            const e = this.p[i];
            if (this.l(e, s) <= 0) break;
            this.p[t] = e;
            t = i;
        }
        this.p[t] = s;
    }
    _(t, s) {
        const i = this.p[t];
        while (t < s) {
            let s = t << 1 | 1;
            const e = s + 1;
            let h = this.p[s];
            if (e < this.o && this.l(h, this.p[e]) > 0) {
                s = e;
                h = this.p[e];
            }
            if (this.l(h, i) >= 0) break;
            this.p[t] = h;
            t = s;
        }
        this.p[t] = i;
    }
    clear() {
        this.o = 0;
        this.p.length = 0;
    }
    push(t) {
        this.p.push(t);
        this.v(this.o);
        this.o += 1;
    }
    pop() {
        if (!this.o) return;
        const t = this.p.pop();
        this.o -= 1;
        if (this.o) {
            this.p[0] = t;
            this._(0, this.o >> 1);
        }
    }
    top() {
        return this.p[0];
    }
    find(t) {
        return this.p.indexOf(t) >= 0;
    }
    remove(t) {
        const s = this.p.indexOf(t);
        if (s < 0) return false;
        if (s === 0) {
            this.pop();
        } else if (s === this.o - 1) {
            this.p.pop();
            this.o -= 1;
        } else {
            this.p.splice(s, 1, this.p.pop());
            this.o -= 1;
            this.v(s);
            this._(s, this.o >> 1);
        }
        return true;
    }
    updateItem(t) {
        const s = this.p.indexOf(t);
        if (s < 0) return false;
        this.v(s);
        this._(s, this.o >> 1);
        return true;
    }
    toArray() {
        return [ ...this.p ];
    }
}

var _default = PriorityQueue;

exports.default = _default;
//# sourceMappingURL=PriorityQueue.js.map
