"use strict";

Object.defineProperty(exports, "t", {
    value: true
});

exports.default = exports.LinkNode = void 0;

var _Base = _interopRequireDefault(require("./Base"));

var _ContainerBase = require("../ContainerBase");

function _interopRequireDefault(t) {
    return t && t.t ? t : {
        default: t
    };
}

class LinkNode {
    constructor(t) {
        this.L = undefined;
        this.O = undefined;
        this.S = undefined;
        this.L = t;
    }
}

exports.LinkNode = LinkNode;

class LinkListIterator extends _ContainerBase.ContainerIterator {
    constructor(t, i, s) {
        super(s);
        this.I = t;
        this.V = i;
        if (this.iteratorType === 0) {
            this.pre = function() {
                if (this.I.O === this.V) {
                    throw new RangeError("LinkList iterator access denied!");
                }
                this.I = this.I.O;
                return this;
            };
            this.next = function() {
                if (this.I === this.V) {
                    throw new RangeError("LinkList iterator access denied!");
                }
                this.I = this.I.S;
                return this;
            };
        } else {
            this.pre = function() {
                if (this.I.S === this.V) {
                    throw new RangeError("LinkList iterator access denied!");
                }
                this.I = this.I.S;
                return this;
            };
            this.next = function() {
                if (this.I === this.V) {
                    throw new RangeError("LinkList iterator access denied!");
                }
                this.I = this.I.O;
                return this;
            };
        }
    }
    get pointer() {
        if (this.I === this.V) {
            throw new RangeError("LinkList iterator access denied!");
        }
        return this.I.L;
    }
    set pointer(t) {
        if (this.I === this.V) {
            throw new RangeError("LinkList iterator access denied!");
        }
        this.I.L = t;
    }
    equals(t) {
        return this.I === t.I;
    }
    copy() {
        return new LinkListIterator(this.I, this.V, this.iteratorType);
    }
}

class LinkList extends _Base.default {
    constructor(t = []) {
        super();
        this.V = new LinkNode;
        this.G = undefined;
        this.H = undefined;
        const i = this;
        t.forEach((function(t) {
            i.pushBack(t);
        }));
    }
    clear() {
        this.o = 0;
        this.G = this.H = undefined;
        this.V.O = this.V.S = undefined;
    }
    begin() {
        return new LinkListIterator(this.G || this.V, this.V);
    }
    end() {
        return new LinkListIterator(this.V, this.V);
    }
    rBegin() {
        return new LinkListIterator(this.H || this.V, this.V, 1);
    }
    rEnd() {
        return new LinkListIterator(this.V, this.V, 1);
    }
    front() {
        return this.G ? this.G.L : undefined;
    }
    back() {
        return this.H ? this.H.L : undefined;
    }
    forEach(t) {
        if (!this.o) return;
        let i = this.G;
        let s = 0;
        while (i !== this.V) {
            t(i.L, s++, this);
            i = i.S;
        }
    }
    getElementByPos(t) {
        if (t < 0 || t > this.o - 1) {
            throw new RangeError;
        }
        let i = this.G;
        while (t--) {
            i = i.S;
        }
        return i.L;
    }
    eraseElementByPos(t) {
        if (t < 0 || t > this.o - 1) {
            throw new RangeError;
        }
        if (t === 0) this.popFront(); else if (t === this.o - 1) this.popBack(); else {
            let i = this.G;
            while (t--) {
                i = i.S;
            }
            i = i;
            const s = i.O;
            const e = i.S;
            e.O = s;
            s.S = e;
            this.o -= 1;
        }
    }
    eraseElementByValue(t) {
        while (this.G && this.G.L === t) this.popFront();
        while (this.H && this.H.L === t) this.popBack();
        if (!this.G) return;
        let i = this.G;
        while (i !== this.V) {
            if (i.L === t) {
                const t = i.O;
                const s = i.S;
                s.O = t;
                t.S = s;
                this.o -= 1;
            }
            i = i.S;
        }
    }
    eraseElementByIterator(t) {
        const i = t.I;
        if (i === this.V) {
            throw new RangeError("Invalid iterator");
        }
        t = t.next();
        if (this.G === i) this.popFront(); else if (this.H === i) this.popBack(); else {
            const t = i.O;
            const s = i.S;
            s.O = t;
            t.S = s;
            this.o -= 1;
        }
        return t;
    }
    pushBack(t) {
        this.o += 1;
        const i = new LinkNode(t);
        if (!this.H) {
            this.G = this.H = i;
            this.V.S = this.G;
            this.G.O = this.V;
        } else {
            this.H.S = i;
            i.O = this.H;
            this.H = i;
        }
        this.H.S = this.V;
        this.V.O = this.H;
    }
    popBack() {
        if (!this.H) return;
        this.o -= 1;
        if (this.G === this.H) {
            this.G = this.H = undefined;
            this.V.S = undefined;
        } else {
            this.H = this.H.O;
            this.H.S = this.V;
        }
        this.V.O = this.H;
    }
    setElementByPos(t, i) {
        if (t < 0 || t > this.o - 1) {
            throw new RangeError;
        }
        let s = this.G;
        while (t--) {
            s = s.S;
        }
        s.L = i;
    }
    insert(t, i, s = 1) {
        if (t < 0 || t > this.o) {
            throw new RangeError;
        }
        if (s <= 0) return;
        if (t === 0) {
            while (s--) this.pushFront(i);
        } else if (t === this.o) {
            while (s--) this.pushBack(i);
        } else {
            let e = this.G;
            for (let i = 1; i < t; ++i) {
                e = e.S;
            }
            const h = e.S;
            this.o += s;
            while (s--) {
                e.S = new LinkNode(i);
                e.S.O = e;
                e = e.S;
            }
            e.S = h;
            h.O = e;
        }
    }
    find(t) {
        if (!this.G) return this.end();
        let i = this.G;
        while (i !== this.V) {
            if (i.L === t) {
                return new LinkListIterator(i, this.V);
            }
            i = i.S;
        }
        return this.end();
    }
    reverse() {
        if (this.o <= 1) return;
        let t = this.G;
        let i = this.H;
        let s = 0;
        while (s << 1 < this.o) {
            const e = t.L;
            t.L = i.L;
            i.L = e;
            t = t.S;
            i = i.O;
            s += 1;
        }
    }
    unique() {
        if (this.o <= 1) return;
        let t = this.G;
        while (t !== this.V) {
            let i = t;
            while (i.S && i.L === i.S.L) {
                i = i.S;
                this.o -= 1;
            }
            t.S = i.S;
            t.S.O = t;
            t = t.S;
        }
    }
    sort(t) {
        if (this.o <= 1) return;
        const i = [];
        this.forEach((function(t) {
            i.push(t);
        }));
        i.sort(t);
        let s = this.G;
        i.forEach((function(t) {
            s.L = t;
            s = s.S;
        }));
    }
    pushFront(t) {
        this.o += 1;
        const i = new LinkNode(t);
        if (!this.G) {
            this.G = this.H = i;
            this.H.S = this.V;
            this.V.O = this.H;
        } else {
            i.S = this.G;
            this.G.O = i;
            this.G = i;
        }
        this.V.S = this.G;
        this.G.O = this.V;
    }
    popFront() {
        if (!this.G) return;
        this.o -= 1;
        if (this.G === this.H) {
            this.G = this.H = undefined;
            this.V.O = this.H;
        } else {
            this.G = this.G.S;
            this.G.O = this.V;
        }
        this.V.S = this.G;
    }
    merge(t) {
        const i = this;
        if (!this.G) {
            t.forEach((function(t) {
                i.pushBack(t);
            }));
            return;
        }
        let s = this.G;
        t.forEach((function(t) {
            while (s && s !== i.V && s.L <= t) {
                s = s.S;
            }
            if (s === i.V) {
                i.pushBack(t);
                s = i.H;
            } else if (s === i.G) {
                i.pushFront(t);
                s = i.G;
            } else {
                i.o += 1;
                const e = s.O;
                e.S = new LinkNode(t);
                e.S.O = e;
                e.S.S = s;
                s.O = e.S;
            }
        }));
    }
    [Symbol.iterator]() {
        return function*() {
            if (!this.G) return;
            let t = this.G;
            while (t !== this.V) {
                yield t.L;
                t = t.S;
            }
        }.bind(this)();
    }
}

var _default = LinkList;

exports.default = _default;
//# sourceMappingURL=LinkList.js.map
