"use strict";

Object.defineProperty(exports, "t", {
    value: true
});

exports.default = void 0;

var _Base = _interopRequireDefault(require("./Base"));

var _RandomIterator = require("./Base/RandomIterator");

function _interopRequireDefault(t) {
    return t && t.t ? t : {
        default: t
    };
}

class VectorIterator extends _RandomIterator.RandomIterator {
    copy() {
        return new VectorIterator(this.I, this.g, this.m, this.D, this.iteratorType);
    }
}

class Vector extends _Base.default {
    constructor(t = [], e = true) {
        super();
        if (Array.isArray(t)) {
            this.J = e ? [ ...t ] : t;
            this.o = t.length;
        } else {
            this.J = [];
            const e = this;
            t.forEach((function(t) {
                e.pushBack(t);
            }));
        }
        this.size = this.size.bind(this);
        this.getElementByPos = this.getElementByPos.bind(this);
        this.setElementByPos = this.setElementByPos.bind(this);
    }
    clear() {
        this.o = 0;
        this.J.length = 0;
    }
    begin() {
        return new VectorIterator(0, this.size, this.getElementByPos, this.setElementByPos);
    }
    end() {
        return new VectorIterator(this.o, this.size, this.getElementByPos, this.setElementByPos);
    }
    rBegin() {
        return new VectorIterator(this.o - 1, this.size, this.getElementByPos, this.setElementByPos, 1);
    }
    rEnd() {
        return new VectorIterator(-1, this.size, this.getElementByPos, this.setElementByPos, 1);
    }
    front() {
        return this.J[0];
    }
    back() {
        return this.J[this.o - 1];
    }
    forEach(t) {
        for (let e = 0; e < this.o; ++e) {
            t(this.J[e], e, this);
        }
    }
    getElementByPos(t) {
        if (t < 0 || t > this.o - 1) {
            throw new RangeError;
        }
        return this.J[t];
    }
    eraseElementByPos(t) {
        if (t < 0 || t > this.o - 1) {
            throw new RangeError;
        }
        this.J.splice(t, 1);
        this.o -= 1;
    }
    eraseElementByValue(t) {
        let e = 0;
        for (let r = 0; r < this.o; ++r) {
            if (this.J[r] !== t) {
                this.J[e++] = this.J[r];
            }
        }
        this.o = this.J.length = e;
    }
    eraseElementByIterator(t) {
        const e = t.I;
        t = t.next();
        this.eraseElementByPos(e);
        return t;
    }
    pushBack(t) {
        this.J.push(t);
        this.o += 1;
    }
    popBack() {
        if (!this.o) return;
        this.J.pop();
        this.o -= 1;
    }
    setElementByPos(t, e) {
        if (t < 0 || t > this.o - 1) {
            throw new RangeError;
        }
        this.J[t] = e;
    }
    insert(t, e, r = 1) {
        if (t < 0 || t > this.o) {
            throw new RangeError;
        }
        this.J.splice(t, 0, ...new Array(r).fill(e));
        this.o += r;
    }
    find(t) {
        for (let e = 0; e < this.o; ++e) {
            if (this.J[e] === t) {
                return new VectorIterator(e, this.size, this.getElementByPos, this.getElementByPos);
            }
        }
        return this.end();
    }
    reverse() {
        this.J.reverse();
    }
    unique() {
        let t = 1;
        for (let e = 1; e < this.o; ++e) {
            if (this.J[e] !== this.J[e - 1]) {
                this.J[t++] = this.J[e];
            }
        }
        this.o = this.J.length = t;
    }
    sort(t) {
        this.J.sort(t);
    }
    [Symbol.iterator]() {
        return function*() {
            return yield* this.J;
        }.bind(this)();
    }
}

var _default = Vector;

exports.default = _default;
//# sourceMappingURL=Vector.js.map
