"use strict";

Object.defineProperty(exports, "t", {
    value: true
});

exports.default = void 0;

var _ContainerBase = require("../../ContainerBase");

class TreeIterator extends _ContainerBase.ContainerIterator {
    constructor(t, e, r) {
        super(r);
        this.I = t;
        this.V = e;
        if (this.iteratorType === 0) {
            this.pre = function() {
                if (this.I === this.V.U) {
                    throw new RangeError("Tree iterator access denied!");
                }
                this.I = this.I.pre();
                return this;
            };
            this.next = function() {
                if (this.I === this.V) {
                    throw new RangeError("Tree iterator access denied!");
                }
                this.I = this.I.next();
                return this;
            };
        } else {
            this.pre = function() {
                if (this.I === this.V.W) {
                    throw new RangeError("Tree iterator access denied!");
                }
                this.I = this.I.next();
                return this;
            };
            this.next = function() {
                if (this.I === this.V) {
                    throw new RangeError("Tree iterator access denied!");
                }
                this.I = this.I.pre();
                return this;
            };
        }
    }
    get index() {
        let t = this.I;
        const e = this.V.tt;
        if (t === this.V) {
            if (e) {
                return e.et - 1;
            }
            return 0;
        }
        let r = 0;
        if (t.U) {
            r += t.U.et;
        }
        while (t !== e) {
            const e = t.tt;
            if (t === e.W) {
                r += 1;
                if (e.U) {
                    r += e.U.et;
                }
            }
            t = e;
        }
        return r;
    }
    equals(t) {
        return this.I === t.I;
    }
}

var _default = TreeIterator;

exports.default = _default;
//# sourceMappingURL=TreeIterator.js.map
