"use strict";

Object.defineProperty(exports, "t", {
    value: true
});

exports.default = void 0;

var _Base = _interopRequireDefault(require("./Base"));

var _TreeIterator = _interopRequireDefault(require("./Base/TreeIterator"));

function _interopRequireDefault(e) {
    return e && e.t ? e : {
        default: e
    };
}

class OrderedMapIterator extends _TreeIterator.default {
    get pointer() {
        if (this.I === this.V) {
            throw new RangeError("OrderedMap iterator access denied");
        }
        const e = this;
        return new Proxy([], {
            get(r, t) {
                if (t === "0") return e.I.T; else if (t === "1") return e.I.L;
            },
            set(r, t, n) {
                if (t !== "1") {
                    throw new TypeError("props must be 1");
                }
                e.I.L = n;
                return true;
            }
        });
    }
    copy() {
        return new OrderedMapIterator(this.I, this.V, this.iteratorType);
    }
}

class OrderedMap extends _Base.default {
    constructor(e = [], r, t) {
        super(r, t);
        const n = this;
        e.forEach((function(e) {
            n.setElement(e[0], e[1]);
        }));
    }
    * K(e) {
        if (e === undefined) return;
        yield* this.K(e.U);
        yield [ e.T, e.L ];
        yield* this.K(e.W);
    }
    begin() {
        return new OrderedMapIterator(this.V.U || this.V, this.V);
    }
    end() {
        return new OrderedMapIterator(this.V, this.V);
    }
    rBegin() {
        return new OrderedMapIterator(this.V.W || this.V, this.V, 1);
    }
    rEnd() {
        return new OrderedMapIterator(this.V, this.V, 1);
    }
    front() {
        if (!this.o) return undefined;
        const e = this.V.U;
        return [ e.T, e.L ];
    }
    back() {
        if (!this.o) return undefined;
        const e = this.V.W;
        return [ e.T, e.L ];
    }
    forEach(e) {
        let r = 0;
        for (const t of this) e(t, r++, this);
    }
    lowerBound(e) {
        const r = this.X(this.Y, e);
        return new OrderedMapIterator(r, this.V);
    }
    upperBound(e) {
        const r = this.Z(this.Y, e);
        return new OrderedMapIterator(r, this.V);
    }
    reverseLowerBound(e) {
        const r = this.$(this.Y, e);
        return new OrderedMapIterator(r, this.V);
    }
    reverseUpperBound(e) {
        const r = this.ee(this.Y, e);
        return new OrderedMapIterator(r, this.V);
    }
    setElement(e, r, t) {
        this.i(e, r, t);
    }
    find(e) {
        const r = this.re(this.Y, e);
        if (r !== undefined) {
            return new OrderedMapIterator(r, this.V);
        }
        return this.end();
    }
    getElementByKey(e) {
        const r = this.re(this.Y, e);
        return r ? r.L : undefined;
    }
    getElementByPos(e) {
        if (e < 0 || e > this.o - 1) {
            throw new RangeError;
        }
        let r;
        let t = 0;
        for (const n of this) {
            if (t === e) {
                r = n;
                break;
            }
            t += 1;
        }
        return r;
    }
    union(e) {
        const r = this;
        e.forEach((function(e) {
            r.setElement(e[0], e[1]);
        }));
    }
    [Symbol.iterator]() {
        return this.K(this.Y);
    }
}

var _default = OrderedMap;

exports.default = _default;
//# sourceMappingURL=OrderedMap.js.map
