"use strict";

Object.defineProperty(exports, "t", {
    value: true
});

exports.default = void 0;

var _Base = _interopRequireDefault(require("./Base"));

var _TreeIterator = _interopRequireDefault(require("./Base/TreeIterator"));

function _interopRequireDefault(e) {
    return e && e.t ? e : {
        default: e
    };
}

class OrderedSetIterator extends _TreeIterator.default {
    get pointer() {
        if (this.I === this.V) {
            throw new RangeError("OrderedSet iterator access denied!");
        }
        return this.I.T;
    }
    copy() {
        return new OrderedSetIterator(this.I, this.V, this.iteratorType);
    }
}

class OrderedSet extends _Base.default {
    constructor(e = [], t, r) {
        super(t, r);
        const i = this;
        e.forEach((function(e) {
            i.insert(e);
        }));
    }
    * K(e) {
        if (e === undefined) return;
        yield* this.K(e.U);
        yield e.T;
        yield* this.K(e.W);
    }
    begin() {
        return new OrderedSetIterator(this.V.U || this.V, this.V);
    }
    end() {
        return new OrderedSetIterator(this.V, this.V);
    }
    rBegin() {
        return new OrderedSetIterator(this.V.W || this.V, this.V, 1);
    }
    rEnd() {
        return new OrderedSetIterator(this.V, this.V, 1);
    }
    front() {
        return this.V.U ? this.V.U.T : undefined;
    }
    back() {
        return this.V.W ? this.V.W.T : undefined;
    }
    forEach(e) {
        let t = 0;
        for (const r of this) e(r, t++, this);
    }
    getElementByPos(e) {
        if (e < 0 || e > this.o - 1) {
            throw new RangeError;
        }
        let t;
        let r = 0;
        for (const i of this) {
            if (r === e) {
                t = i;
                break;
            }
            r += 1;
        }
        return t;
    }
    insert(e, t) {
        this.i(e, undefined, t);
    }
    find(e) {
        const t = this.re(this.Y, e);
        if (t !== undefined) {
            return new OrderedSetIterator(t, this.V);
        }
        return this.end();
    }
    lowerBound(e) {
        const t = this.X(this.Y, e);
        return new OrderedSetIterator(t, this.V);
    }
    upperBound(e) {
        const t = this.Z(this.Y, e);
        return new OrderedSetIterator(t, this.V);
    }
    reverseLowerBound(e) {
        const t = this.$(this.Y, e);
        return new OrderedSetIterator(t, this.V);
    }
    reverseUpperBound(e) {
        const t = this.ee(this.Y, e);
        return new OrderedSetIterator(t, this.V);
    }
    union(e) {
        const t = this;
        e.forEach((function(e) {
            t.insert(e);
        }));
    }
    [Symbol.iterator]() {
        return this.K(this.Y);
    }
}

var _default = OrderedSet;

exports.default = _default;
//# sourceMappingURL=OrderedSet.js.map
