import { Base } from "../../ContainerBase";
declare abstract class HashContainer<K, V> extends Base {
    protected constructor();
    clear(): void;
    /**
     * @description Remove the element of the specified key.
     * @param key The key you want to remove.
     * @param isObject Tell us if the type of inserted key is `object` to improve efficiency.<br/>
     *                 If a `undefined` value is passed in, the type will be automatically judged.
     */
    eraseElementByKey(key: K, isObject?: boolean): void;
    /**
     * @description Check key if exist in container.
     * @param key The element you want to search.
     * @param isObject Tell us if the type of inserted key is `object` to improve efficiency.<br/>
     *                 If a `undefined` value is passed in, the type will be automatically judged.
     * @return Boolean about if key exist in container.
     */
    find(key: K, isObject?: boolean): boolean;
    /**
     * @description Iterate over all elements in the container.
     * @param callback Callback function like Array.forEach.
     * @example container.forEach((element, index) => console.log(element, index));
     */
    abstract forEach(callback: (element: K | [K, V], index: number, hashContainer: HashContainer<K, V>) => void): void;
    /**
     * @description Using for `for...of` syntax like Array.
     * @example
     * for (const element of container) {
     *   console.log(element);
     * }
     */
    abstract [Symbol.iterator](): Generator<K | [K, V], void, undefined>;
}
export default HashContainer;
