import { initContainer } from "../ContainerBase";
import HashContainerBase from "./Base";
declare class HashSet<K> extends HashContainerBase<K, undefined> {
    constructor(container?: initContainer<K>);
    /**
     * @description Insert element to set.
     * @param key The key want to insert.
     * @param isObject Tell us if the type of inserted key is `object` to improve efficiency.<br/>
     *                 If a `undefined` value is passed in, the type will be automatically judged.
     */
    insert(key: K, isObject?: boolean): void;
    forEach(callback: (element: K, index: number, hashSet: HashSet<K>) => void): void;
    [Symbol.iterator](): Generator<K, void, unknown>;
}
export default HashSet;
