'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Stemming is the process of reducing search tokens to their root (or stem) so that searches for different forms of a
 * word will match. For example "search", "searching" and "searched" are all reduced to the stem "search".
 *
 * <p>This stemming tokenizer converts tokens (words) to their stem forms before returning them. It requires an
 * external stemming function to be provided; for this purpose I recommend the NPM 'porter-stemmer' library.
 *
 * <p>For more information see http : //tartarus.org/~martin/PorterStemmer/
 */
var StemmingTokenizer = exports.StemmingTokenizer = function () {

  /**
   * Constructor.
   *
   * @param stemmingFunction Function capable of accepting a word and returning its stem.
   * @param decoratedIndexStrategy Index strategy to be run after all stop words have been removed.
   */
  function StemmingTokenizer(stemmingFunction, decoratedTokenizer) {
    _classCallCheck(this, StemmingTokenizer);

    this._stemmingFunction = stemmingFunction;
    this._tokenizer = decoratedTokenizer;
  }

  /**
   * @inheritDocs
   */


  _createClass(StemmingTokenizer, [{
    key: 'tokenize',
    value: function tokenize(text) {
      return this._tokenizer.tokenize(text).map(this._stemmingFunction);
    }
  }]);

  return StemmingTokenizer;
}();

;
//# sourceMappingURL=StemmingTokenizer.js.map