/**
 * ec.js
 */
/// <reference types="node" />
import { SignatureType } from './typedef';
/**
 * Sign encoded tbsCertificate with given signature algorithm under the JWK private key.
 * @param {Uint8Array} encodedTbsCertificate - TBS Certificate encoded to Uint8Array.
 * @param {JsonWebKey} privateJwk - Private key object in JWK format.
 * @param {String} signatureAlgorithm - Signature algorithm name like 'ecdsa-with-sha256'.
 * @returns {Promise<{data: BufferR, unused: Number}>} - ASN.1 encoded signature.
 */
export declare const getAsn1Signature: (encodedTbsCertificate: Uint8Array, privateJwk: JsonWebKey, signatureAlgorithm: SignatureType) => Promise<{
    unused: 0;
    data: Buffer;
}>;
