/**
 * rsa.js
 */
/// <reference types="node" />
import { DER, HashTypes, RsaPssOptions, SignatureType } from './typedef';
/**
 * Sign TBSCertificate under the issuer's RSA private key in JWK format.
 * @param {Uint8Array} encodedTbsCertificate - Message body to be signed.
 * @param {JsonWebKey} privateJwk - A RSA signing key in JWK format.
 * @param {String} algorithm - Name of signing algorithm like 'sha256WithRSAEncryption'.
 * @param {RSAPSSObject} [pssParams] - Effective only for RSASSA-PSS.
 * @returns {Promise<{data: Buffer, unused: number}>} - ASN.1 parsed signature object.
 */
export declare const getSignature: (encodedTbsCertificate: Uint8Array, privateJwk: JsonWebKey, algorithm: SignatureType, pssParams: RsaPssOptions) => Promise<{
    unused: 0;
    data: Buffer;
}>;
/**
 * Encode RSA-PSS parsed params to ASN.1 Uint8Array binary
 * @param {RSAPSSObject} options - RSA-PSS params as a parsed object.
 * @returns {DER} - Encoded RSA-PSS object.
 */
export declare const encodeRsassaPssParams: (options: RsaPssOptions) => DER;
/**
 * Parse encoded RSA-PSS parameters represented in Uint8Array.
 * @param {Buffer|Uint8Array} pssParams - Extracted RSA-PSS parameter byte sequence.
 * @returns {{hashForMgf: string, saltLength: number, mgf: string, hash: string}}
 * @throws {Error} - Throws if InvalidCertificateFormat.
 */
export declare const decodeRsassaPssParams: (pssParams: Buffer | Uint8Array) => {
    hash: HashTypes;
    mgf: string;
    hashForMgf: string;
    saltLength: number;
};
