"use strict";
/**
 * rsa.js
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeRsassaPssParams = exports.encodeRsassaPssParams = exports.getSignature = void 0;
var params = __importStar(require("./params"));
var util = __importStar(require("./util"));
var js_crypto_rsa_1 = __importDefault(require("js-crypto-rsa"));
var asn1_js_1 = __importDefault(require("asn1.js"));
var BN = asn1_js_1.default.bignum;
var asn1_js_rfc5280_1 = __importDefault(require("asn1.js-rfc5280"));
var buffer_1 = __importDefault(require("buffer"));
var BufferR = buffer_1.default.Buffer;
/**
 * Sign TBSCertificate under the issuer's RSA private key in JWK format.
 * @param {Uint8Array} encodedTbsCertificate - Message body to be signed.
 * @param {JsonWebKey} privateJwk - A RSA signing key in JWK format.
 * @param {String} algorithm - Name of signing algorithm like 'sha256WithRSAEncryption'.
 * @param {RSAPSSObject} [pssParams] - Effective only for RSASSA-PSS.
 * @returns {Promise<{data: Buffer, unused: number}>} - ASN.1 parsed signature object.
 */
exports.getSignature = function (encodedTbsCertificate, privateJwk, algorithm, pssParams) { return __awaiter(void 0, void 0, void 0, function () {
    var signature;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!(algorithm === 'rsassaPss')) return [3 /*break*/, 2];
                return [4 /*yield*/, js_crypto_rsa_1.default.sign(encodedTbsCertificate, privateJwk, pssParams.hash, { name: 'RSA-PSS', saltLength: pssParams.saltLength })];
            case 1:
                signature = _a.sent();
                return [3 /*break*/, 4];
            case 2: return [4 /*yield*/, js_crypto_rsa_1.default.sign(encodedTbsCertificate, privateJwk, params.signatureAlgorithms[algorithm].hash, { name: 'RSASSA-PKCS1-v1_5' })];
            case 3:
                signature = _a.sent();
                _a.label = 4;
            case 4: return [2 /*return*/, { unused: 0, data: BufferR.from(signature) }];
        }
    });
}); };
/**
 * Encode RSA-PSS parsed params to ASN.1 Uint8Array binary
 * @param {RSAPSSObject} options - RSA-PSS params as a parsed object.
 * @returns {DER} - Encoded RSA-PSS object.
 */
exports.encodeRsassaPssParams = function (options) {
    if (options.hash === 'SHA-1' && options.saltLength === 20 && options.explicit === false)
        return BufferR.from([0x30, 0x00]);
    else {
        var pssParams = {
            hashAlgorithm: {
                algorithm: params.hashes[options.hash].oid,
                parameters: BufferR.from(params.ans1null)
            },
            maskGenAlgorithm: {
                algorithm: params.maskGeneratorFunctions.MGF1.oid,
                parameters: asn1_js_rfc5280_1.default.AlgorithmIdentifier.encode({
                    algorithm: params.hashes[options.hash].oid,
                    parameters: BufferR.from(params.ans1null)
                }, 'der')
            },
            saltLength: new BN(options.saltLength),
            trailerField: new BN(1) // default
        };
        return RSASSAPSSParams.encode(pssParams, 'der');
    }
};
/**
 * Parse encoded RSA-PSS parameters represented in Uint8Array.
 * @param {Buffer|Uint8Array} pssParams - Extracted RSA-PSS parameter byte sequence.
 * @returns {{hashForMgf: string, saltLength: number, mgf: string, hash: string}}
 * @throws {Error} - Throws if InvalidCertificateFormat.
 */
exports.decodeRsassaPssParams = function (pssParams) {
    var returnParams;
    if ((new Uint8Array(pssParams)).toString() !== (new Uint8Array([0x30, 0x00]).toString())) {
        // non empty params
        var decodedParams = RSASSAPSSParams.decode(pssParams, 'der');
        decodedParams.maskGenAlgorithm.parameters
            = asn1_js_rfc5280_1.default.AlgorithmIdentifier.decode(decodedParams.maskGenAlgorithm.parameters, 'der');
        decodedParams.saltLength = decodedParams.saltLength.toNumber();
        decodedParams.trailerField = decodedParams.trailerField.toNumber();
        var hash = util.getKeyFromOid(decodedParams.hashAlgorithm.algorithm, params.hashes);
        var mgf = util.getKeyFromOid(decodedParams.maskGenAlgorithm.algorithm, params.maskGeneratorFunctions);
        var hashForMgf = util.getKeyFromOid(decodedParams.maskGenAlgorithm.parameters.algorithm, params.hashes);
        if (hash.length === 0 || mgf.length === 0 || hashForMgf.length === 0)
            throw new Error('InvalidCertificateFormat');
        returnParams = { hash: hash[0], mgf: mgf[0], hashForMgf: hashForMgf[0], saltLength: decodedParams.saltLength };
    }
    else {
        // if empty, defaults are SHA-1 for Sign and MGF1 with SHA-1, using salt of length 20
        returnParams = { hash: 'SHA-1', mgf: 'MGF1', hashForMgf: 'SHA-1', saltLength: 20 };
    }
    return returnParams;
};
/////////////////////////////////////////////////////////////////////////////////////////
// RFC4055 https://tools.ietf.org/html/rfc4055
// RFC7427 https://tools.ietf.org/html/rfc7427
// RSASSA-PSS-params  ::=  SEQUENCE  {
//          hashAlgorithm      [0] HashAlgorithm DEFAULT
//                                    sha1Identifier,
//          maskGenAlgorithm   [1] MaskGenAlgorithm DEFAULT
//                                    mgf1SHA1Identifier,
//          saltLength         [2] INTEGER DEFAULT 20,
//          trailerField       [3] INTEGER DEFAULT 1  }
var RSASSAPSSParams = asn1_js_1.default.define('rsassaPssParams', function () {
    // @ts-ignore
    this.seq().obj(
    // @ts-ignore
    this.key('hashAlgorithm').explicit(0).use(asn1_js_rfc5280_1.default.AlgorithmIdentifier), 
    // @ts-ignore
    this.key('maskGenAlgorithm').explicit(1).use(asn1_js_rfc5280_1.default.AlgorithmIdentifier), 
    // @ts-ignore
    this.key('saltLength').explicit(2).int(), 
    // @ts-ignore
    this.key('trailerField').explicit(3).int());
});
//# sourceMappingURL=rsa.js.map