"use strict";
/**
 * x509.js
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.info = exports.parse = exports.toJwk = exports.fromJwk = void 0;
var params = __importStar(require("./params"));
var rsa = __importStar(require("./rsa"));
var ecdsa = __importStar(require("./ec"));
var bn_js_1 = __importDefault(require("bn.js"));
var asn1_js_rfc5280_1 = __importDefault(require("asn1.js-rfc5280"));
var js_encoding_utils_1 = __importDefault(require("js-encoding-utils"));
var js_crypto_random_1 = __importDefault(require("js-crypto-random"));
var js_crypto_key_utils_1 = require("js-crypto-key-utils");
var buffer_1 = __importDefault(require("buffer"));
var BufferR = buffer_1.default.Buffer;
/**
 * Convert public key in JWK format to X.509 PEM or DER object.
 * @param {JsonWebKey} publicJwk - A public key object in JWK format to be encoded and signed to X.509
 * @param {JsonWebKey} privateJwk - A private key object in JWK format by which would be used to sign the public key.
 * @param {AsnFormat} [format='pem'] - Output format of X.509 certificate, 'pem' or 'der'
 * @param {X509EncodingOptions} [options={}] - X.509 encoding options
 * @return {Promise<DER|PEM>} - Generated X.509 public key certificate in intended format.
 * @throws {Error} - Throws if InvalidFormatSpecification or UnsupportedKeyType.
 */
exports.fromJwk = function (publicJwk, privateJwk, format, options) {
    if (format === void 0) { format = 'pem'; }
    if (options === void 0) { options = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var version, rand, serialNumber, signature, issuer, current, validity, subject, publicObj, spkiDer, _a, _b, subjectPublicKeyInfo, tbsCertificate, signatureAlgorithm, encodedTbsCertificate, signatureValue, certBin;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    // default values
                    if (typeof options.signature === 'undefined')
                        options.signature = (privateJwk.kty === 'EC') ? 'ecdsa-with-sha256' : 'rsassaPss';
                    if (typeof options.days === 'undefined')
                        options.days = 3650;
                    if (typeof options.issuer === 'undefined')
                        options.issuer = { organizationName: 'Self' };
                    if (typeof options.subject === 'undefined')
                        options.subject = { organizationName: 'Self' };
                    // default params for RSA-PSS
                    if (typeof options.pssParams === 'undefined')
                        options.pssParams = {};
                    if (typeof options.pssParams.saltLength === 'undefined' && options.signature === 'rsassaPss')
                        options.pssParams.saltLength = 20;
                    if (typeof options.pssParams.hash === 'undefined' && options.signature === 'rsassaPss')
                        options.pssParams.hash = 'SHA-1';
                    if (typeof options.pssParams.explicit === 'undefined' && options.signature === 'rsassaPss')
                        options.pssParams.explicit = true;
                    version = 0;
                    return [4 /*yield*/, js_crypto_random_1.default.getRandomBytes(20)];
                case 1:
                    rand = _c.sent();
                    serialNumber = new bn_js_1.default(rand);
                    signature = { algorithm: params.signatureAlgorithms[options.signature].oid };
                    if (options.signature === 'rsassaPss') {
                        signature.parameters = rsa.encodeRsassaPssParams(options.pssParams);
                    }
                    else
                        signature.parameters = BufferR.from(params.ans1null);
                    issuer = { type: 'rdnSequence', value: setRDNSequence(options.issuer) };
                    current = (Date.now() / 1000) * 1000;
                    validity = {
                        notBefore: { type: 'utcTime', value: current },
                        notAfter: { type: 'utcTime', value: (current + options.days * 86400 * 1000) }
                    };
                    subject = { type: 'rdnSequence', value: setRDNSequence(options.subject) };
                    publicObj = new js_crypto_key_utils_1.Key('jwk', publicJwk);
                    _b = (_a = BufferR).from;
                    return [4 /*yield*/, publicObj.export('der', { compact: false, outputPublic: true })];
                case 2:
                    spkiDer = _b.apply(_a, [_c.sent()]);
                    subjectPublicKeyInfo = asn1_js_rfc5280_1.default.SubjectPublicKeyInfo.decode(spkiDer, 'der');
                    tbsCertificate = { version: version, serialNumber: serialNumber, signature: signature, issuer: issuer, validity: validity, subject: subject, subjectPublicKeyInfo: subjectPublicKeyInfo };
                    signatureAlgorithm = tbsCertificate.signature;
                    encodedTbsCertificate = asn1_js_rfc5280_1.default.TBSCertificate.encode(tbsCertificate, 'der');
                    if (!(privateJwk.kty === 'EC')) return [3 /*break*/, 4];
                    return [4 /*yield*/, ecdsa.getAsn1Signature(encodedTbsCertificate, privateJwk, options.signature)];
                case 3:
                    signatureValue = _c.sent();
                    return [3 /*break*/, 7];
                case 4:
                    if (!(privateJwk.kty === 'RSA')) return [3 /*break*/, 6];
                    return [4 /*yield*/, rsa.getSignature(encodedTbsCertificate, privateJwk, options.signature, options.pssParams)];
                case 5:
                    signatureValue = _c.sent();
                    return [3 /*break*/, 7];
                case 6: throw new Error('UnsupportedKeyType');
                case 7:
                    certBin = asn1_js_rfc5280_1.default.Certificate.encode({ tbsCertificate: tbsCertificate, signatureAlgorithm: signatureAlgorithm, signature: signatureValue }, 'der');
                    if (format === 'pem') {
                        return [2 /*return*/, js_encoding_utils_1.default.formatter.binToPem(certBin, 'certificate')];
                    }
                    else if (format === 'der') {
                        return [2 /*return*/, certBin];
                    }
                    else
                        throw new Error('InvalidFormatSpecification');
                    return [2 /*return*/];
            }
        });
    });
};
/**
 * Convert X.509 certificate to a JWK object.
 * @param {PEM|DER} certX509 - X.509 public key certificate in DER or PEM format.
 * @param {AsnFormat} format - 'der' or 'pem'
 * @return {Promise<JsonWebKey>} - Extracted key object in JWK format.
 * @throws {Error} - Throws if InvalidFormatSpecification.
 */
exports.toJwk = function (certX509, format) {
    if (format === void 0) { format = 'pem'; }
    return __awaiter(void 0, void 0, void 0, function () {
        var x509bin, binKeyBuffer, decoded, binSpki, publicObj;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (format === 'pem')
                        x509bin = js_encoding_utils_1.default.formatter.pemToBin(certX509);
                    else if (format === 'der')
                        x509bin = certX509;
                    else
                        throw new Error('InvalidFormatSpecification');
                    binKeyBuffer = BufferR.from(x509bin);
                    decoded = asn1_js_rfc5280_1.default.Certificate.decode(binKeyBuffer, 'der');
                    binSpki = asn1_js_rfc5280_1.default.SubjectPublicKeyInfo.encode(decoded.tbsCertificate.subjectPublicKeyInfo, 'der');
                    publicObj = new js_crypto_key_utils_1.Key('der', binSpki);
                    return [4 /*yield*/, publicObj.export('jwk', { outputPublic: true })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
};
/**
 * Parse X.509 certificate and return DER-encoded TBSCertificate and DER encoded signature
 * @param {DER|PEM} certX509 - X.509 public key certificate in DER or PEM format.
 * @param {AsnFormat} format - 'der' or 'pem'
 * @return {{tbsCertificate: Uint8Array, signatureValue: Uint8Array, signatureAlgorithm: String}} - Parsed object.
 * @throws {Error} - Throws if UnsupportedSignatureAlgorithm or InvalidFormatSpecification.
 */
exports.parse = function (certX509, format) {
    if (format === void 0) { format = 'pem'; }
    var decoded = exports.info(certX509, format);
    var sigOid = decoded.signatureAlgorithm.algorithm;
    var sigParam = decoded.signatureAlgorithm.parameters;
    var filter = Object.keys(params.signatureAlgorithms).filter(function (name) { return params.signatureAlgorithms[name].oid.toString() === sigOid.toString(); });
    if (filter.length <= 0)
        throw new Error('UnsupportedSignatureAlgorithm');
    var signatureAlgorithm = { algorithm: filter[0] };
    if (filter[0] === 'rsassaPss')
        signatureAlgorithm.parameters = rsa.decodeRsassaPssParams(sigParam);
    else
        signatureAlgorithm.parameters = { hash: params.signatureAlgorithms[signatureAlgorithm.algorithm].hash };
    var binTBSCertificate = asn1_js_rfc5280_1.default.TBSCertificate.encode(decoded.tbsCertificate, 'der');
    return {
        tbsCertificate: new Uint8Array(binTBSCertificate),
        signatureValue: new Uint8Array(decoded.signature.data),
        signatureAlgorithm: signatureAlgorithm
    };
};
/**
 * Parse X.509 certificate and return parsed info
 * @param {DER|PEM} certX509 - X.509 public key certificate in DER or PEM format.
 * @param {AsnFormat} format - 'der' or 'pem'
 * @return {{tbsCertificate: Uint8Array, signatureValue: Uint8Array, signatureAlgorithm: String}} - Parsed object.
 * @throws {Error} - Throws if UnsupportedSignatureAlgorithm or InvalidFormatSpecification.
 */
exports.info = function (certX509, format) {
    if (format === void 0) { format = 'pem'; }
    var x509bin;
    if (format === 'pem')
        x509bin = js_encoding_utils_1.default.formatter.pemToBin(certX509);
    else if (format === 'der')
        x509bin = certX509;
    else
        throw new Error('InvalidFormatSpecification');
    var binKeyBuffer = BufferR.from(x509bin); // This must be Buffer object to get decoded;
    return asn1_js_rfc5280_1.default.Certificate.decode(binKeyBuffer, 'der'); // decode binary x509-formatted public key to parsed object
};
/**
 * Set RDN sequence for issuer and subject fields
 * @param {Object} options - RDN Sequence
 * @return {{type: *, value: *}[][]}
 * @throws {Error} - throws if InvalidOptionSpecification or InvalidCountryNameCode.
 */
var setRDNSequence = function (options) {
    var encodedArray = Object.keys(options).map(function (k) {
        if (Object.keys(attributeTypeOIDMap).indexOf(k) < 0)
            throw new Error('InvalidOptionSpecification');
        var type = attributeTypeOIDMap[k];
        var value;
        if (['dnQualifier, countryName, serialNumber'].indexOf(k) >= 0) {
            if (k === 'countryName' && options[k].length !== 2)
                throw new Error('InvalidCountryNameCode');
            value = asn1_js_rfc5280_1.default.DirectoryString.encode({ type: 'printableString', value: options[k] }, 'der');
        }
        else
            value = asn1_js_rfc5280_1.default.DirectoryString.encode({ type: 'utf8String', value: options[k] }, 'der');
        return { type: type, value: value };
    });
    return [encodedArray];
};
// https://tools.ietf.org/html/rfc5280#appendix-A
var attributeTypeOIDMap = {
    // X509name DirectoryName
    name: [2, 5, 4, 41],
    surname: [2, 5, 4, 4],
    givenName: [2, 5, 4, 42],
    initials: [2, 5, 4, 43],
    generationQualifier: [2, 5, 4, 44],
    commonName: [2, 5, 4, 3],
    localityName: [2, 5, 4, 7],
    stateOrProvinceName: [2, 5, 4, 8],
    organizationName: [2, 5, 4, 10],
    organizationalUnitName: [2, 5, 4, 11],
    title: [2, 5, 4, 12],
    dnQualifier: [2, 5, 4, 46],
    countryName: [2, 5, 4, 6],
    serialNumber: [2, 5, 4, 5],
    pseudonym: [2, 5, 4, 65],
    domainComponent: [0, 9, 2342, 19200300, 100, 1, 25],
};
//# sourceMappingURL=x509.js.map