const test = require('ava')

const countOf = require('../../test/helpers/countOf')

const { deserialize } = require('../index')

//
// Test suite for DXF deserialization (import)
//
test('ASCII DXF 3D Polyline Entities translated to JSCAD Scripts', (t) => {
  // DXF 3D POLYLINE with mesh, translates to script with CSG.fromPolygons
  const dxf3 = `0
SECTION
2
ENTITIES
0
POLYLINE
66
1
10
0
20
0
30
0
70
16
71
6
72
3
62
7
0
VERTEX
10
-144
20
-684
30
240
70
64
0
VERTEX
10
-160
20
-720
30
0
70
64
0
VERTEX
10
-160
20
-720
30
0
70
64
0
VERTEX
10
-444
20
-684
30
240
70
64
0
VERTEX
10
-480
20
-720
30
0
70
64
0
VERTEX
10
-480
20
-720
30
0
70
64
0
VERTEX
10
-444
20
-432
30
240
70
64
0
VERTEX
10
-480
20
-432
30
0
70
64
0
VERTEX
10
-480
20
-720
30
0
70
64
0
VERTEX
10
-144
20
-432
30
240
70
64
0
VERTEX
10
-160
20
-432
30
0
70
64
0
VERTEX
10
-160
20
-720
30
0
70
64
0
VERTEX
10
-144
20
-432
30
240
70
64
0
VERTEX
10
-144
20
-432
30
240
70
64
0
VERTEX
10
-144
20
-684
30
240
70
64
0
VERTEX
10
-444
20
-432
30
240
70
64
0
VERTEX
10
-444
20
-432
30
240
70
64
0
VERTEX
10
-444
20
-684
30
240
70
64
0
SEQEND
0
ENDSEC`
  const src3 = deserialize({ filename: 'dxf3-test', output: 'script' }, dxf3)
  t.is(countOf('main', src3), 2)
  t.is(countOf('createPolygon', src3), 11)
  t.is(countOf('geom3.create', src3), 1)
  t.is(countOf('color', src3), 6)

  // DXF 3D POLYLINE with faces, translates to script with 3D geometry
})

test('ASCII DXF 3D FACE Entities translated to JSCAD Scripts', (t) => {
  const dxf1 = `0
SECTION
2
ENTITIES
0
3DFACE
8
1
62
1
10
-0.5
20
-0.5
30
-0.5
11
-0.5
21
0.5
31
-0.5
12
0.5
22
0.5
32
-0.5
13
0.5
23
-0.5
33
-0.5
0
3DFACE
8
1
62
1
10
-0.5
20
-0.5
30
-0.5
11
0.5
21
-0.5
31
-0.5
12
0
22
-0.5
32
0.5
13
0
23
-0.5
33
0.5
0
ENDSEC`
  // expect a script which calls createPolygon for each 3DFACE, and creates a new 3D geometry
  const src1 = deserialize({ filename: 'dxf1-test', output: 'script' }, dxf1)
  t.is(countOf('main', src1), 2)
  t.is(countOf('createPolygon', src1), 3)
  t.is(countOf('geom3.create', src1), 1)
})
