const test = require('ava')

const geom3 = require('../geometries/geom3')

const { geodesicSphere } = require('./index')

const comparePolygonsAsPoints = require('../../test/helpers/comparePolygonsAsPoints')

test('geodesicSphere (defaults)', (t) => {
  const obs = geodesicSphere()
  const pts = geom3.toPoints(obs)
  t.notThrows(() => geom3.validate(obs))
  t.is(pts.length, 20)
})

test('geodesicSphere (options)', (t) => {
  // test radius
  let obs = geodesicSphere({ radius: 5 })
  let pts = geom3.toPoints(obs)
  const exp = [
    [[4.253254557317035, 0, 2.628654726407001], [2.628654726407001, -4.253254557317035, 0], [4.253254557317035, 0, -2.628654726407001]],
    [[4.253254557317035, 0, -2.628654726407001], [2.628654726407001, 4.253254557317035, 0], [4.253254557317035, 0, 2.628654726407001]],
    [[4.253254557317035, 0, -2.628654726407001], [0, -2.628654726407001, -4.253254557317035], [0, 2.628654726407001, -4.253254557317035]],
    [[4.253254557317035, 0, -2.628654726407001], [0, 2.628654726407001, -4.253254557317035], [2.628654726407001, 4.253254557317035, 0]],
    [[4.253254557317035, 0, -2.628654726407001], [2.628654726407001, -4.253254557317035, 0], [0, -2.628654726407001, -4.253254557317035]],
    [[0, -2.628654726407001, 4.253254557317035], [4.253254557317035, 0, 2.628654726407001], [0, 2.628654726407001, 4.253254557317035]],
    [[2.628654726407001, -4.253254557317035, 0], [4.253254557317035, 0, 2.628654726407001], [0, -2.628654726407001, 4.253254557317035]],
    [[4.253254557317035, 0, 2.628654726407001], [2.628654726407001, 4.253254557317035, 0], [0, 2.628654726407001, 4.253254557317035]],
    [[-4.253254557317035, 0, -2.628654726407001], [-2.628654726407001, -4.253254557317035, 0], [-4.253254557317035, 0, 2.628654726407001]],
    [[-4.253254557317035, 0, 2.628654726407001], [-2.628654726407001, 4.253254557317035, 0], [-4.253254557317035, 0, -2.628654726407001]],
    [[0, -2.628654726407001, 4.253254557317035], [0, 2.628654726407001, 4.253254557317035], [-4.253254557317035, 0, 2.628654726407001]],
    [[-4.253254557317035, 0, 2.628654726407001], [-2.628654726407001, -4.253254557317035, 0], [0, -2.628654726407001, 4.253254557317035]],
    [[0, 2.628654726407001, 4.253254557317035], [-2.628654726407001, 4.253254557317035, 0], [-4.253254557317035, 0, 2.628654726407001]],
    [[0, 2.628654726407001, -4.253254557317035], [0, -2.628654726407001, -4.253254557317035], [-4.253254557317035, 0, -2.628654726407001]],
    [[-4.253254557317035, 0, -2.628654726407001], [-2.628654726407001, 4.253254557317035, 0], [0, 2.628654726407001, -4.253254557317035]],
    [[-4.253254557317035, 0, -2.628654726407001], [0, -2.628654726407001, -4.253254557317035], [-2.628654726407001, -4.253254557317035, 0]],
    [[0, -2.628654726407001, 4.253254557317035], [-2.628654726407001, -4.253254557317035, 0], [2.628654726407001, -4.253254557317035, 0]],
    [[0, 2.628654726407001, 4.253254557317035], [2.628654726407001, 4.253254557317035, 0], [-2.628654726407001, 4.253254557317035, 0]],
    [[0, 2.628654726407001, -4.253254557317035], [-2.628654726407001, 4.253254557317035, 0], [2.628654726407001, 4.253254557317035, 0]],
    [[0, -2.628654726407001, -4.253254557317035], [2.628654726407001, -4.253254557317035, 0], [-2.628654726407001, -4.253254557317035, 0]]
  ]

  t.notThrows(() => geom3.validate(obs))
  t.is(pts.length, 20)
  t.true(comparePolygonsAsPoints(pts, exp))

  // test frequency
  obs = geodesicSphere({ radius: 5, frequency: 18 })
  pts = geom3.toPoints(obs)

  t.notThrows.skip(() => geom3.validate(obs))
  t.is(pts.length, 180)
})

test('geodesicSphere (zero radius)', (t) => {
  const obs = geodesicSphere({ radius: 0 })
  const pts = geom3.toPoints(obs)
  t.notThrows(() => geom3.validate(obs))
  t.is(pts.length, 0)
})
