const test = require('ava')

const comparePoints = require('../../../test/helpers/comparePoints')

const { geom2, geom3 } = require('../../geometries')
const { cube, torus } = require('../../primitives')

const { project } = require('./index')

test('project (defaults)', (t) => {
  const geometry0 = geom3.create()
  const geometry1 = cube({ size: 10 })
  const geometry2 = 'hi'
  const geometry3 = undefined
  const geometry4 = null

  const results = project({ }, geometry0, geometry1, geometry2, geometry3, geometry4)
  t.is(results.length, 5)
  t.true(geom2.isA(results[0]))
  t.true(geom2.isA(results[1]))
  t.is(results[2], geometry2)
  t.is(results[3], geometry3)
  t.is(results[4], geometry4)

  const result = project({ }, torus({ outerSegments: 4 }))
  t.true(geom2.isA(result))
  const pts = geom2.toPoints(result)
  const exp = [
    [0, -2.9999933333333333],
    [0, -5.000013333333333],
    [0, 5.000013333333333],
    [5.000013333333333, 0],
    [0, 2.9999933333333333],
    [-2.9999933333333333, 0],
    [2.9999933333333333, 0],
    [-5.000013333333333, 0]
  ]
  t.true(comparePoints(pts, exp))
})

test('project (X and Y axis)', (t) => {
  let result = project({ axis: [1, 0, 0], origin: [1, 0, 0] }, torus({ outerSegments: 4 }))
  t.true(geom2.isA(result))
  let pts = geom2.toPoints(result)
  let exp = [
    [-1.0000200000000001, -3.999986666666667],
    [-0.8314600000000001, 4.555553333333334],
    [-0.9807933333333334, -4.1951],
    [-0.7070933333333335, 4.707126666666667],
    [-0.9238600000000001, -4.382700000000001],
    [-0.5555666666666668, 4.831446666666667],
    [-0.8314600000000001, -4.555553333333334],
    [-0.3826666666666667, 4.923893333333334],
    [-0.7070933333333335, -4.707126666666667],
    [-0.19511333333333336, 4.98078],
    [-0.5555666666666668, -4.831446666666667],
    [0, 5.000006666666668],
    [-0.3826666666666667, -4.923893333333334],
    [0.19511333333333336, 4.98078],
    [-0.19511333333333336, -4.98078],
    [0.3826666666666667, 4.923893333333334],
    [0, -5.000006666666668],
    [0.5555666666666668, 4.831446666666667],
    [0.19511333333333336, -4.98078],
    [0.7070933333333335, 4.707126666666667],
    [0.3826666666666667, -4.923893333333334],
    [0.8314600000000001, 4.555553333333334],
    [0.5555666666666668, -4.831446666666667],
    [0.9238600000000001, 4.382700000000001],
    [0.7070933333333335, -4.707126666666667],
    [0.9807933333333334, 4.1951],
    [0.8314600000000001, -4.555553333333334],
    [1.0000200000000001, 3.999986666666667],
    [1.0000200000000001, -3.999986666666667],
    [0.9238600000000001, -4.382700000000001],
    [0.9807933333333334, -4.1951],
    [-1.0000200000000001, 3.999986666666667],
    [-0.9807933333333334, 4.1951],
    [-0.9238600000000001, 4.382700000000001]
  ]
  t.true(comparePoints(pts, exp))

  result = project({ axis: [0, 1, 0], origin: [0, -1, 0] }, torus({ outerSegments: 4 }))
  t.true(geom2.isA(result))
  pts = geom2.toPoints(result)
  exp = [
    [3.999986666666667, -1.0000200000000001],
    [-4.555553333333334, -0.8314600000000001],
    [4.1951, -0.9807933333333334],
    [-4.707126666666667, -0.7070933333333335],
    [4.382700000000001, -0.9238600000000001],
    [-4.831446666666667, -0.5555666666666668],
    [4.555553333333334, -0.8314600000000001],
    [-4.923893333333334, -0.3826666666666667],
    [4.707126666666667, -0.7070933333333335],
    [-4.98078, -0.19511333333333336],
    [4.831446666666667, -0.5555666666666668],
    [-5.000006666666668, 0],
    [4.923893333333334, -0.3826666666666667],
    [-4.98078, 0.19511333333333336],
    [4.98078, -0.19511333333333336],
    [-4.923893333333334, 0.3826666666666667],
    [5.000006666666668, 0],
    [-4.831446666666667, 0.5555666666666668],
    [4.98078, 0.19511333333333336],
    [-4.707126666666667, 0.7070933333333335],
    [4.923893333333334, 0.3826666666666667],
    [-4.555553333333334, 0.8314600000000001],
    [4.831446666666667, 0.5555666666666668],
    [-4.382700000000001, 0.9238600000000001],
    [4.707126666666667, 0.7070933333333335],
    [-4.1951, 0.9807933333333334],
    [4.555553333333334, 0.8314600000000001],
    [-3.999986666666667, 1.0000200000000001],
    [3.999986666666667, 1.0000200000000001],
    [4.382700000000001, 0.9238600000000001],
    [4.1951, 0.9807933333333334],
    [-3.999986666666667, -1.0000200000000001],
    [-4.1951, -0.9807933333333334],
    [-4.382700000000001, -0.9238600000000001]
  ]
  t.true(comparePoints(pts, exp))
})
