"use strict";

const conversions = require("webidl-conversions");
const utils = require("./utils.js");
const HTMLElement = require("./HTMLElement.js");
const impl = utils.implSymbol;

function HTMLTemplateElement() {
  throw new TypeError("Illegal constructor");
}
Object.setPrototypeOf(HTMLTemplateElement.prototype, HTMLElement.interface.prototype);
Object.setPrototypeOf(HTMLTemplateElement, HTMLElement.interface);

Object.defineProperty(HTMLTemplateElement.prototype, "content", {
  get() {
    return utils.tryWrapperForImpl(this[impl]["content"]);
  },
  enumerable: true,
  configurable: true
});

Object.defineProperty(HTMLTemplateElement.prototype, Symbol.toStringTag, {
  value: "HTMLTemplateElement",
  writable: false,
  enumerable: false,
  configurable: true
});

const iface = {
  mixedInto: [],
  is(obj) {
    if (obj) {
      if (obj[impl] instanceof Impl.implementation) {
        return true;
      }
      for (let i = 0; i < module.exports.mixedInto.length; ++i) {
        if (obj instanceof module.exports.mixedInto[i]) {
          return true;
        }
      }
    }
    return false;
  },
  isImpl(obj) {
    if (obj) {
      if (obj instanceof Impl.implementation) {
        return true;
      }

      const wrapper = utils.wrapperForImpl(obj);
      for (let i = 0; i < module.exports.mixedInto.length; ++i) {
        if (wrapper instanceof module.exports.mixedInto[i]) {
          return true;
        }
      }
    }
    return false;
  },
  convert(obj, { context = "The provided value" } = {}) {
    if (module.exports.is(obj)) {
      return utils.implForWrapper(obj);
    }
    throw new TypeError(`${context} is not of type 'HTMLTemplateElement'.`);
  },
  create(constructorArgs, privateData) {
    let obj = Object.create(HTMLTemplateElement.prototype);
    this.setup(obj, constructorArgs, privateData);
    return obj;
  },
  createImpl(constructorArgs, privateData) {
    let obj = Object.create(HTMLTemplateElement.prototype);
    this.setup(obj, constructorArgs, privateData);
    return utils.implForWrapper(obj);
  },
  _internalSetup(obj) {
    HTMLElement._internalSetup(obj);
  },
  setup(obj, constructorArgs, privateData) {
    if (!privateData) privateData = {};
    privateData.wrapper = obj;

    this._internalSetup(obj);

    Object.defineProperty(obj, impl, {
      value: new Impl.implementation(constructorArgs, privateData),
      writable: false,
      enumerable: false,
      configurable: true
    });
    obj[impl][utils.wrapperSymbol] = obj;
  },
  interface: HTMLTemplateElement,
  expose: {
    Window: { HTMLTemplateElement: HTMLTemplateElement }
  }
};
module.exports = iface;

const Impl = require("../nodes/HTMLTemplateElement-impl.js");
