"use strict";

const conversions = require("webidl-conversions");
const utils = require("./utils.js");

const impl = utils.implSymbol;
const HTMLElement = require("./HTMLElement.js");
const mixin = utils.mixin;
const LinkStyle = require("./LinkStyle.js");

function HTMLStyleElement() {
  throw new TypeError("Illegal constructor");
}

Object.setPrototypeOf(HTMLStyleElement.prototype, HTMLElement.interface.prototype);
Object.setPrototypeOf(HTMLStyleElement, HTMLElement.interface);

Object.defineProperty(HTMLStyleElement, "prototype", {
  value: HTMLStyleElement.prototype,
  writable: false,
  enumerable: false,
  configurable: false
});

mixin(HTMLStyleElement.prototype, LinkStyle.interface.prototype);
LinkStyle.mixedInto.push(HTMLStyleElement);

Object.defineProperty(HTMLStyleElement.prototype, "media", {
  get() {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    const value = this.getAttribute("media");
    return value === null ? "" : value;
  },

  set(V) {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    V = conversions["DOMString"](V, {
      context: "Failed to set the 'media' property on 'HTMLStyleElement': The provided value"
    });

    this.setAttribute("media", V);
  },

  enumerable: true,
  configurable: true
});

Object.defineProperty(HTMLStyleElement.prototype, "nonce", {
  get() {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    const value = this.getAttribute("nonce");
    return value === null ? "" : value;
  },

  set(V) {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    V = conversions["DOMString"](V, {
      context: "Failed to set the 'nonce' property on 'HTMLStyleElement': The provided value"
    });

    this.setAttribute("nonce", V);
  },

  enumerable: true,
  configurable: true
});

Object.defineProperty(HTMLStyleElement.prototype, "type", {
  get() {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    const value = this.getAttribute("type");
    return value === null ? "" : value;
  },

  set(V) {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    V = conversions["DOMString"](V, {
      context: "Failed to set the 'type' property on 'HTMLStyleElement': The provided value"
    });

    this.setAttribute("type", V);
  },

  enumerable: true,
  configurable: true
});

Object.defineProperty(HTMLStyleElement.prototype, Symbol.toStringTag, {
  value: "HTMLStyleElement",
  writable: false,
  enumerable: false,
  configurable: true
});

const iface = {
  mixedInto: [],
  is(obj) {
    if (obj) {
      if (obj[impl] instanceof Impl.implementation) {
        return true;
      }
      for (let i = 0; i < module.exports.mixedInto.length; ++i) {
        if (obj instanceof module.exports.mixedInto[i]) {
          return true;
        }
      }
    }
    return false;
  },
  isImpl(obj) {
    if (obj) {
      if (obj instanceof Impl.implementation) {
        return true;
      }

      const wrapper = utils.wrapperForImpl(obj);
      for (let i = 0; i < module.exports.mixedInto.length; ++i) {
        if (wrapper instanceof module.exports.mixedInto[i]) {
          return true;
        }
      }
    }
    return false;
  },
  convert(obj, { context = "The provided value" } = {}) {
    if (module.exports.is(obj)) {
      return utils.implForWrapper(obj);
    }
    throw new TypeError(`${context} is not of type 'HTMLStyleElement'.`);
  },

  create(constructorArgs, privateData) {
    let obj = Object.create(HTMLStyleElement.prototype);
    obj = this.setup(obj, constructorArgs, privateData);
    return obj;
  },
  createImpl(constructorArgs, privateData) {
    let obj = Object.create(HTMLStyleElement.prototype);
    obj = this.setup(obj, constructorArgs, privateData);
    return utils.implForWrapper(obj);
  },
  _internalSetup(obj) {
    HTMLElement._internalSetup(obj);
  },
  setup(obj, constructorArgs, privateData) {
    if (!privateData) privateData = {};

    privateData.wrapper = obj;

    this._internalSetup(obj);
    Object.defineProperty(obj, impl, {
      value: new Impl.implementation(constructorArgs, privateData),
      writable: false,
      enumerable: false,
      configurable: true
    });

    obj[impl][utils.wrapperSymbol] = obj;
    if (Impl.init) {
      Impl.init(obj[impl], privateData);
    }
    return obj;
  },
  interface: HTMLStyleElement,
  expose: {
    Window: { HTMLStyleElement }
  }
}; // iface
module.exports = iface;

const Impl = require("../nodes/HTMLStyleElement-impl.js");
