"use strict";

const conversions = require("webidl-conversions");
const utils = require("./utils.js");

const ScrollOptions = require("./ScrollOptions.js");

module.exports = {
  convertInherit(obj, ret, { context = "The provided value" } = {}) {
    ScrollOptions.convertInherit(obj, ret, { context });

    {
      const key = "block";
      let value = obj === undefined || obj === null ? undefined : obj[key];
      if (value !== undefined) {
        value = utils.tryImplForWrapper(value);

        ret[key] = value;
      } else {
        ret[key] = "center";
      }
    }

    {
      const key = "inline";
      let value = obj === undefined || obj === null ? undefined : obj[key];
      if (value !== undefined) {
        value = utils.tryImplForWrapper(value);

        ret[key] = value;
      } else {
        ret[key] = "center";
      }
    }
  },

  convert(obj, { context = "The provided value" } = {}) {
    if (obj !== undefined && typeof obj !== "object" && typeof obj !== "function") {
      throw new TypeError(`${context} is not an object.`);
    }

    const ret = Object.create(null);
    module.exports.convertInherit(obj, ret, { context });
    return ret;
  }
};
