[Constructor(DOMString type, optional EventInit eventInitDict),
 Exposed=(Window,Worker,AudioWorklet)]
interface Event {
  readonly attribute DOMString type;
  readonly attribute EventTarget? target;
  readonly attribute EventTarget? currentTarget;
//  sequence<EventTarget> composedPath();

  const unsigned short NONE = 0;
  const unsigned short CAPTURING_PHASE = 1;
  const unsigned short AT_TARGET = 2;
  const unsigned short BUBBLING_PHASE = 3;
  readonly attribute unsigned short eventPhase;

  void stopPropagation();
           attribute boolean cancelBubble; // historical alias of .stopPropagation
  void stopImmediatePropagation();

  readonly attribute boolean bubbles;
  readonly attribute boolean cancelable;
  void preventDefault();
  readonly attribute boolean defaultPrevented;
//  readonly attribute boolean composed;

  [Unforgeable] readonly attribute boolean isTrusted;
  // Modified - No support for DOMHighResTimeStamp usage in Event-impl
  // readonly attribute DOMHighResTimeStamp timeStamp;
  readonly attribute DOMTimeStamp timeStamp;

  void initEvent(DOMString type, optional boolean bubbles = false, optional boolean cancelable = false); // historical
};

dictionary EventInit {
  boolean bubbles = false;
  boolean cancelable = false;
//  boolean composed = false;
};
