const webpack = require('webpack');

module.exports = {
    entry: './src/index.js',
    output: {
        filename: 'jshangul.js',
        minifyFilename: 'jshangul.min.js',
        sourceMapFilename: 'jshangul.js.map',
        libraryTarget: 'umd',
        library: 'Hangul'
    },
    module: {
        loaders: [
            {test: /.js$/, loader: 'babel-loader'}
            //{test: /\.coffee$/, loader: 'coffee-loader'}
        ]
    },
    devtool: '#inline-source-map',
    plugins: [
        new webpack.ProvidePlugin({
            FINAL_CONSONANTS: './vars/finalConsonants',
            INITIAL_CONSONANTS: './vars/initialConsonants',
            LARGE_NUMBERS: './vars/largeNumbers',
            NUMBERS: './vars/numbers',
            VOWELS: './vars/vowels'
        })
    ]
};
