(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define(factory);
	else if(typeof exports === 'object')
		exports["Hangul"] = factory();
	else
		root["Hangul"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _interopRequireDefault = __webpack_require__(2)['default'];
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	
	var _isHangul = __webpack_require__(3);
	
	var _isHangul2 = _interopRequireDefault(_isHangul);
	
	var _initial = __webpack_require__(5);
	
	var _initial2 = _interopRequireDefault(_initial);
	
	var _vowel = __webpack_require__(7);
	
	var _vowel2 = _interopRequireDefault(_vowel);
	
	var _under = __webpack_require__(1);
	
	var _under2 = _interopRequireDefault(_under);
	
	var _hasUnder = __webpack_require__(9);
	
	var _hasUnder2 = _interopRequireDefault(_hasUnder);
	
	var _hasLastUnder = __webpack_require__(10);
	
	var _hasLastUnder2 = _interopRequireDefault(_hasLastUnder);
	
	var _formatNumber = __webpack_require__(11);
	
	var _formatNumber2 = _interopRequireDefault(_formatNumber);
	
	exports['default'] = {
	    is: _isHangul2['default'],
	    initial: _initial2['default'],
	    vowel: _vowel2['default'],
	    under: _under2['default'],
	    hasUnder: _hasUnder2['default'],
	    hasLastUnder: _hasLastUnder2['default'],
	    formatNumber: _formatNumber2['default']
	};
	
	String.prototype.isHangul = function (len) {
	    return (0, _isHangul2['default'])(this.toString(), len);
	};
	
	String.prototype.hangulInitial = function () {
	    return (0, _initial2['default'])(this.toString());
	};
	
	String.prototype.hangulVowel = function () {
	    return (0, _vowel2['default'])(this.toString());
	};
	
	String.prototype.hangulUnder = function () {
	    return (0, _under2['default'])(this.toString());
	};
	
	String.prototype.hasHangulUnder = function () {
	    return (0, _hasUnder2['default'])(this.toString());
	};
	
	String.prototype.hasLastHangulUnder = function () {
	    return (0, _hasLastUnder2['default'])(this.toString());
	};
	
	String.prototype.toHangulNumber = function (delimiter) {
	    return (0, _formatNumber2['default'])(this.toString(), delimiter);
	};
	
	Number.prototype.toHangul = function (delimiter) {
	    return (0, _formatNumber2['default'])(this.toString(), delimiter);
	};
	module.exports = exports['default'];

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _interopRequireDefault = __webpack_require__(2)['default'];
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	
	var _isHangul = __webpack_require__(3);
	
	var _isHangul2 = _interopRequireDefault(_isHangul);
	
	var _varsFinalConsonants = __webpack_require__(4);
	
	var _varsFinalConsonants2 = _interopRequireDefault(_varsFinalConsonants);
	
	/**
	 * @description 한글 한문자에서 종성을 분리해서 가져온다
	 * @param {string} str 문자
	 * @return {string} 종성
	 */
	
	exports['default'] = function (str) {
	    if (!(0, _isHangul2['default'])(str, 1)) {
	        return typeof str === 'string' ? str.charAt(0) : str;
	    }
	    return _varsFinalConsonants2['default'][parseInt(((str.charCodeAt(0) & 0xFFFF) - 0xAC00) % (21 * 28) % 28)];
	};
	
	module.exports = exports['default'];

/***/ },
/* 2 */
/***/ function(module, exports) {

	"use strict";
	
	exports["default"] = function (obj) {
	  return obj && obj.__esModule ? obj : {
	    "default": obj
	  };
	};
	
	exports.__esModule = true;

/***/ },
/* 3 */
/***/ function(module, exports) {

	/**
	 * @description 문자열이 한글인지 검사한다
	 * @param {string} str 문자열
	 * @param {number} [len] 검사길이
	 * @return {boolean} 검사결과
	 */
	'use strict';
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	
	exports['default'] = function (str, len) {
	    if (typeof str !== 'string' || str.length === 0) {
	        return false;
	    }
	    if (!len || len < 0 || len > str.length) {
	        len = str.length;
	    }
	    for (var i = 0; i < len; i++) {
	        var c = str.charCodeAt(i);
	        if (c < 0xAC00 || c > 0xD7A3) {
	            return false;
	        }
	    }
	    return true;
	};
	
	module.exports = exports['default'];

/***/ },
/* 4 */
/***/ function(module, exports) {

	'use strict';
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	exports['default'] = ['', 'ㄱ', 'ㄲ', 'ㄳ', 'ㄴ', 'ㄵ', 'ㄶ', 'ㄷ', 'ㄹ', 'ㄺ', 'ㄻ', 'ㄼ', 'ㄽ', 'ㄾ', 'ㄿ', 'ㅀ', 'ㅁ', 'ㅂ', 'ㅄ', 'ㅅ', 'ㅆ', 'ㅇ', 'ㅈ', 'ㅊ', 'ㅋ', 'ㅌ', 'ㅍ', 'ㅎ'];
	module.exports = exports['default'];

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _interopRequireDefault = __webpack_require__(2)['default'];
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	
	var _isHangul = __webpack_require__(3);
	
	var _isHangul2 = _interopRequireDefault(_isHangul);
	
	var _varsInitialConsonants = __webpack_require__(6);
	
	var _varsInitialConsonants2 = _interopRequireDefault(_varsInitialConsonants);
	
	/**
	 * @description 한글 한문자에서 초성을 분리해서 가져온다
	 * @param {string} str 문자
	 * @return {string} 초성
	 */
	
	exports['default'] = function (str) {
	    if (!(0, _isHangul2['default'])(str, 1)) {
	        return typeof str === 'string' ? str.charAt(0) : str;
	    }
	    return _varsInitialConsonants2['default'][parseInt(((str.charCodeAt(0) & 0xFFFF) - 0xAC00) / (21 * 28))];
	};
	
	module.exports = exports['default'];

/***/ },
/* 6 */
/***/ function(module, exports) {

	'use strict';
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	exports['default'] = ['ㄱ', 'ㄲ', 'ㄴ', 'ㄷ', 'ㄸ', 'ㄹ', 'ㅁ', 'ㅂ', 'ㅃ', 'ㅅ', 'ㅆ', 'ㅇ', 'ㅈ', 'ㅉ', 'ㅊ', 'ㅋ', 'ㅌ', 'ㅍ', 'ㅎ'];
	module.exports = exports['default'];

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _interopRequireDefault = __webpack_require__(2)['default'];
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	
	var _isHangul = __webpack_require__(3);
	
	var _isHangul2 = _interopRequireDefault(_isHangul);
	
	var _varsVowels = __webpack_require__(8);
	
	var _varsVowels2 = _interopRequireDefault(_varsVowels);
	
	/**
	 * @description 한글 한문자에서 중성을 분리해서 가져온다
	 * @param {string} str 문자
	 * @return {string} 중성
	 */
	
	exports['default'] = function (str) {
	    if (!(0, _isHangul2['default'])(str, 1)) {
	        return typeof str === 'string' ? str.charAt(0) : str;
	    }
	    return _varsVowels2['default'][parseInt(((str.charCodeAt(0) & 0xFFFF) - 0xAC00) % (21 * 28) / 28)];
	};
	
	module.exports = exports['default'];

/***/ },
/* 8 */
/***/ function(module, exports) {

	'use strict';
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	exports['default'] = ['ㅏ', 'ㅐ', 'ㅑ', 'ㅒ', 'ㅓ', 'ㅔ', 'ㅕ', 'ㅖ', 'ㅗ', 'ㅘ', 'ㅙ', 'ㅚ', 'ㅛ', 'ㅜ', 'ㅝ', 'ㅞ', 'ㅟ', 'ㅠ', 'ㅡ', 'ㅢ', 'ㅣ'];
	module.exports = exports['default'];

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _interopRequireDefault = __webpack_require__(2)['default'];
	
	Object.defineProperty(exports, '__esModule', {
	  value: true
	});
	
	var _isHangul = __webpack_require__(3);
	
	var _isHangul2 = _interopRequireDefault(_isHangul);
	
	var _under = __webpack_require__(1);
	
	var _under2 = _interopRequireDefault(_under);
	
	/**
	 * @description 한문자의 종성의 유무를 검사한다
	 * @param {string} str 문자
	 * @return {boolean} 종성의 유무
	 */
	
	exports['default'] = function (str) {
	  return (0, _isHangul2['default'])(str, 1) && (0, _under2['default'])(str) !== '';
	};
	
	module.exports = exports['default'];

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _interopRequireDefault = __webpack_require__(2)['default'];
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	
	var _hasUnder = __webpack_require__(9);
	
	var _hasUnder2 = _interopRequireDefault(_hasUnder);
	
	/**
	 * @description 문자열의 마지막 문자의 종성 유무를 검사한다
	 * @param {string} str 문자열
	 * @return {boolean} 마지막 문자의 종성 유무
	 */
	
	exports['default'] = function (str) {
	    if (typeof str !== 'string' || str.length === 0) {
	        return false;
	    }
	    return (0, _hasUnder2['default'])(str.charAt(str.length - 1));
	};
	
	module.exports = exports['default'];

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _interopRequireDefault = __webpack_require__(2)['default'];
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	
	var _varsNumbers = __webpack_require__(12);
	
	var _varsNumbers2 = _interopRequireDefault(_varsNumbers);
	
	var _varsLargeNumbers = __webpack_require__(13);
	
	var _varsLargeNumbers2 = _interopRequireDefault(_varsLargeNumbers);
	
	/**
	 * @description 숫자를 한글형식으로 바꿔준다
	 * @param {number|string} number 숫자
	 * @param {string} [delimiter] 단위 구분자
	 * @return {string} 한글숫자
	 */
	
	exports['default'] = function (number, delimiter) {
	    if (typeof number === 'undefined') {
	        throw new TypeError('\'number\' is undefined');
	    }
	    if (typeof number !== 'string') {
	        number = number.toString();
	    }
	    if (!/^[0-9]+$/.test(number)) {
	        return number;
	    }
	    if (number.charAt(0) === '0') {
	        for (var i = 1; i < number.length; i++) {
	            if (number.charAt(i) === '0') {
	                continue;
	            }
	            number = number.substring(i);
	            break;
	        }
	    }
	    if (number.length === 0) {
	        return _varsNumbers2['default'][0];
	    }
	    if (number.length === 1) {
	        return _varsNumbers2['default'][number.charAt(0)];
	    }
	    var splitedNumbers = number.split('').map(function (a) {
	        return parseInt(a);
	    });
	    var reversedNumbers = splitedNumbers.reverse();
	    var groupedNumbers = [];
	    for (var i = 0; i < reversedNumbers.length; i += 4) {
	        groupedNumbers.push(reversedNumbers.slice(i, i + 4));
	    }
	    return groupedNumbers.map(function (nums, i) {
	        var hnums = nums.map(function (n, j) {
	            var hnum = n > 1 || j === 0 && n === 1 ? _varsNumbers2['default'][n] : '';
	            var unit = n > 0 && j > 0 ? _varsLargeNumbers2['default'][0][j - 1] : '';
	            return hnum + unit;
	        }).reduce(function (a, b) {
	            return b + a;
	        });
	        var lunit = i > 0 && hnums.length > 0 ? _varsLargeNumbers2['default'][1][(i - 1) % 4] : '';
	        return hnums + lunit;
	    }).filter(function (a) {
	        return a.length > 0;
	    }).reduce(function (a, b) {
	        return b + (delimiter || '') + a;
	    });
	};
	
	module.exports = exports['default'];

/***/ },
/* 12 */
/***/ function(module, exports) {

	'use strict';
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	exports['default'] = ['영', '일', '이', '삼', '사', '오', '육', '칠', '팔', '구'];
	module.exports = exports['default'];

/***/ },
/* 13 */
/***/ function(module, exports) {

	'use strict';
	
	Object.defineProperty(exports, '__esModule', {
	    value: true
	});
	exports['default'] = [['십', '백', '천'], ['만', '억', '조', '경']];
	module.exports = exports['default'];

/***/ }
/******/ ])
});
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vd2VicGFjay91bml2ZXJzYWxNb2R1bGVEZWZpbml0aW9uIiwid2VicGFjazovLy93ZWJwYWNrL2Jvb3RzdHJhcCBmYWQ3ODNiNzBkNzcxN2FlYTQ4NCIsIndlYnBhY2s6Ly8vLi9zcmMvaW5kZXguanMiLCJ3ZWJwYWNrOi8vLy4vc3JjL3VuZGVyLmpzIiwid2VicGFjazovLy8uL34vYmFiZWwtcnVudGltZS9oZWxwZXJzL2ludGVyb3AtcmVxdWlyZS1kZWZhdWx0LmpzIiwid2VicGFjazovLy8uL3NyYy9pc0hhbmd1bC5qcyIsIndlYnBhY2s6Ly8vLi9zcmMvdmFycy9maW5hbENvbnNvbmFudHMuanMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2luaXRpYWwuanMiLCJ3ZWJwYWNrOi8vLy4vc3JjL3ZhcnMvaW5pdGlhbENvbnNvbmFudHMuanMiLCJ3ZWJwYWNrOi8vLy4vc3JjL3Zvd2VsLmpzIiwid2VicGFjazovLy8uL3NyYy92YXJzL3Zvd2Vscy5qcyIsIndlYnBhY2s6Ly8vLi9zcmMvaGFzVW5kZXIuanMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2hhc0xhc3RVbmRlci5qcyIsIndlYnBhY2s6Ly8vLi9zcmMvZm9ybWF0TnVtYmVyLmpzIiwid2VicGFjazovLy8uL3NyYy92YXJzL251bWJlcnMuanMiLCJ3ZWJwYWNrOi8vLy4vc3JjL3ZhcnMvbGFyZ2VOdW1iZXJzLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUM7QUFDRCxPO0FDVkE7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsdUJBQWU7QUFDZjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7O0FBR0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTs7Ozs7Ozs7Ozs7Ozs7O3FDQ3RDcUIsQ0FBWTs7OztvQ0FDYixDQUFXOzs7O2tDQUNiLENBQVM7Ozs7a0NBQ1QsQ0FBUzs7OztxQ0FDTixDQUFZOzs7O3lDQUNSLEVBQWdCOzs7O3lDQUNoQixFQUFnQjs7OztzQkFFMUI7QUFDWCxPQUFFLHVCQUFVO0FBQ1osWUFBTyxzQkFBUztBQUNoQixVQUFLLG9CQUFPO0FBQ1osVUFBSyxvQkFBTztBQUNaLGFBQVEsdUJBQVU7QUFDbEIsaUJBQVksMkJBQWM7QUFDMUIsaUJBQVksMkJBQWM7RUFDN0I7O0FBRUQsT0FBTSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEdBQUcsVUFBUyxHQUFHLEVBQUU7QUFDdEMsWUFBTywyQkFBUyxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7RUFDekMsQ0FBQzs7QUFFRixPQUFNLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxZQUFXO0FBQ3hDLFlBQU8sMEJBQVEsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7RUFDbkMsQ0FBQzs7QUFFRixPQUFNLENBQUMsU0FBUyxDQUFDLFdBQVcsR0FBRyxZQUFXO0FBQ3RDLFlBQU8sd0JBQU0sSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7RUFDakMsQ0FBQzs7QUFFRixPQUFNLENBQUMsU0FBUyxDQUFDLFdBQVcsR0FBRyxZQUFXO0FBQ3RDLFlBQU8sd0JBQU0sSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7RUFDakMsQ0FBQzs7QUFFRixPQUFNLENBQUMsU0FBUyxDQUFDLGNBQWMsR0FBRyxZQUFXO0FBQ3pDLFlBQU8sMkJBQVMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7RUFDcEMsQ0FBQzs7QUFFRixPQUFNLENBQUMsU0FBUyxDQUFDLGtCQUFrQixHQUFHLFlBQVc7QUFDN0MsWUFBTywrQkFBYSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQztFQUN4QyxDQUFDOztBQUVGLE9BQU0sQ0FBQyxTQUFTLENBQUMsY0FBYyxHQUFHLFVBQVMsU0FBUyxFQUFFO0FBQ2xELFlBQU8sK0JBQWEsSUFBSSxDQUFDLFFBQVEsRUFBRSxFQUFFLFNBQVMsQ0FBQyxDQUFDO0VBQ25ELENBQUM7O0FBRUYsT0FBTSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEdBQUcsVUFBUyxTQUFTLEVBQUU7QUFDNUMsWUFBTywrQkFBYSxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUUsU0FBUyxDQUFDLENBQUM7RUFDbkQsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7O3FDQ2hEbUIsQ0FBWTs7OztnREFDSixDQUF3Qjs7Ozs7Ozs7OztzQkFPdEMsVUFBUyxHQUFHLEVBQUU7QUFDekIsU0FBSSxDQUFDLDJCQUFTLEdBQUcsRUFBRSxDQUFDLENBQUMsRUFBRTtBQUNuQixnQkFBTyxPQUFPLEdBQUcsS0FBSyxRQUFRLEdBQUcsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLENBQUM7TUFDeEQ7QUFDRCxZQUFPLGlDQUFpQixRQUFRLENBQUUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEdBQUcsTUFBTSxJQUFJLE1BQU0sS0FBSyxFQUFFLEdBQUcsRUFBRSxDQUFDLEdBQUksRUFBRSxDQUFDLENBQUMsQ0FBQztFQUNqRzs7Ozs7Ozs7QUNiRDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLDJCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7c0JDRmUsVUFBUyxHQUFHLEVBQUUsR0FBRyxFQUFFO0FBQzlCLFNBQUksT0FBTyxHQUFHLEtBQUssUUFBUSxJQUFJLEdBQUcsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO0FBQzdDLGdCQUFPLEtBQUssQ0FBQztNQUNoQjtBQUNELFNBQUksQ0FBQyxHQUFHLElBQUksR0FBRyxHQUFHLENBQUMsSUFBSSxHQUFHLEdBQUcsR0FBRyxDQUFDLE1BQU0sRUFBRTtBQUNyQyxZQUFHLEdBQUcsR0FBRyxDQUFDLE1BQU0sQ0FBQztNQUNwQjtBQUNELFVBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxHQUFHLEVBQUUsQ0FBQyxFQUFFLEVBQUU7QUFDMUIsYUFBSSxDQUFDLEdBQUcsR0FBRyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUMxQixhQUFJLENBQUMsR0FBRyxNQUFNLElBQUksQ0FBQyxHQUFHLE1BQU0sRUFBRTtBQUMxQixvQkFBTyxLQUFLLENBQUM7VUFDaEI7TUFDSjtBQUNELFlBQU8sSUFBSSxDQUFDO0VBQ2Y7Ozs7Ozs7Ozs7Ozs7c0JDcEJjLENBQ1gsRUFBRSxFQUNGLEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxDQUNOOzs7Ozs7Ozs7Ozs7Ozs7cUNDN0JvQixDQUFZOzs7O2tEQUNGLENBQTBCOzs7Ozs7Ozs7O3NCQU8xQyxVQUFTLEdBQUcsRUFBRTtBQUN6QixTQUFJLENBQUMsMkJBQVMsR0FBRyxFQUFFLENBQUMsQ0FBQyxFQUFFO0FBQ25CLGdCQUFPLE9BQU8sR0FBRyxLQUFLLFFBQVEsR0FBRyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUcsQ0FBQztNQUN4RDtBQUNELFlBQU8sbUNBQW1CLFFBQVEsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsR0FBRyxNQUFNLElBQUksTUFBTSxLQUFLLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDNUY7Ozs7Ozs7Ozs7Ozs7c0JDYmMsQ0FDWCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLENBQ047Ozs7Ozs7Ozs7Ozs7OztxQ0NwQm9CLENBQVk7Ozs7dUNBQ2QsQ0FBZTs7Ozs7Ozs7OztzQkFPbkIsVUFBUyxHQUFHLEVBQUU7QUFDekIsU0FBSSxDQUFDLDJCQUFTLEdBQUcsRUFBRSxDQUFDLENBQUMsRUFBRTtBQUNuQixnQkFBTyxPQUFPLEdBQUcsS0FBSyxRQUFRLEdBQUcsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLENBQUM7TUFDeEQ7QUFDRCxZQUFPLHdCQUFPLFFBQVEsQ0FBRSxDQUFDLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsR0FBRyxNQUFNLElBQUksTUFBTSxLQUFLLEVBQUUsR0FBRyxFQUFFLENBQUMsR0FBSSxFQUFFLENBQUMsQ0FBQyxDQUFDO0VBQ3ZGOzs7Ozs7Ozs7Ozs7O3NCQ2JjLENBQ1gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLENBQ047Ozs7Ozs7Ozs7Ozs7OztxQ0N0Qm9CLENBQVk7Ozs7a0NBQ2YsQ0FBUzs7Ozs7Ozs7OztzQkFPWixVQUFTLEdBQUcsRUFBRTtBQUN6QixVQUFPLDJCQUFTLEdBQUcsRUFBRSxDQUFDLENBQUMsSUFBSSx3QkFBTSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7RUFDaEQ7Ozs7Ozs7Ozs7Ozs7Ozs7cUNDVm9CLENBQVk7Ozs7Ozs7Ozs7c0JBT2xCLFVBQVMsR0FBRyxFQUFFO0FBQ3pCLFNBQUksT0FBTyxHQUFHLEtBQUssUUFBUSxJQUFJLEdBQUcsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO0FBQzdDLGdCQUFPLEtBQUssQ0FBQztNQUNoQjtBQUNELFlBQU8sMkJBQVMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDL0M7Ozs7Ozs7Ozs7Ozs7Ozs7d0NDWm1CLEVBQWdCOzs7OzZDQUNWLEVBQXFCOzs7Ozs7Ozs7OztzQkFRaEMsVUFBUyxNQUFNLEVBQUUsU0FBUyxFQUFFO0FBQ3ZDLFNBQUksT0FBTyxNQUFNLEtBQUssV0FBVyxFQUFFO0FBQy9CLGVBQU0sSUFBSSxTQUFTLENBQUMseUJBQXVCLENBQUMsQ0FBQztNQUNoRDtBQUNELFNBQUksT0FBTyxNQUFNLEtBQUssUUFBUSxFQUFFO0FBQzVCLGVBQU0sR0FBRyxNQUFNLENBQUMsUUFBUSxFQUFFLENBQUM7TUFDOUI7QUFDRCxTQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsRUFBRTtBQUMxQixnQkFBTyxNQUFNLENBQUM7TUFDakI7QUFDRCxTQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxFQUFFO0FBQzFCLGNBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxNQUFNLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFO0FBQ3BDLGlCQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxFQUFFO0FBQzFCLDBCQUFTO2NBQ1o7QUFDRCxtQkFBTSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDN0IsbUJBQU07VUFDVDtNQUNKO0FBQ0QsU0FBSSxNQUFNLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtBQUNyQixnQkFBTyx5QkFBUSxDQUFDLENBQUMsQ0FBQztNQUNyQjtBQUNELFNBQUksTUFBTSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7QUFDckIsZ0JBQU8seUJBQVEsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO01BQ3BDO0FBQ0QsU0FBSSxjQUFjLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQyxHQUFHLENBQUMsV0FBQztnQkFBSSxRQUFRLENBQUMsQ0FBQyxDQUFDO01BQUEsQ0FBQyxDQUFDO0FBQzVELFNBQUksZUFBZSxHQUFHLGNBQWMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztBQUMvQyxTQUFJLGNBQWMsR0FBRyxFQUFFLENBQUM7QUFDeEIsVUFBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLGVBQWUsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRTtBQUNoRCx1QkFBYyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztNQUN4RDtBQUNELFlBQU8sY0FBYyxDQUFDLEdBQUcsQ0FBQyxVQUFDLElBQUksRUFBRSxDQUFDLEVBQUs7QUFDbkMsYUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFDLENBQUMsRUFBRSxDQUFDLEVBQUs7QUFDM0IsaUJBQUksSUFBSSxHQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFJLHlCQUFRLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMzRCxpQkFBSSxJQUFJLEdBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFJLDhCQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDM0Qsb0JBQU8sSUFBSSxHQUFHLElBQUksQ0FBQztVQUN0QixDQUFDLENBQUMsTUFBTSxDQUFDLFVBQUMsQ0FBQyxFQUFFLENBQUM7b0JBQUssQ0FBQyxHQUFHLENBQUM7VUFBQSxDQUFDLENBQUM7QUFDM0IsYUFBSSxLQUFLLEdBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsR0FBSSw4QkFBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzdFLGdCQUFPLEtBQUssR0FBRyxLQUFLLENBQUM7TUFDeEIsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxXQUFDO2dCQUFJLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQztNQUFBLENBQUMsQ0FBQyxNQUFNLENBQUMsVUFBQyxDQUFDLEVBQUUsQ0FBQztnQkFBSyxDQUFDLElBQUksU0FBUyxJQUFJLEVBQUUsQ0FBQyxHQUFHLENBQUM7TUFBQSxDQUFDLENBQUM7RUFDNUU7Ozs7Ozs7Ozs7Ozs7c0JDakRjLENBQ1gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxFQUNILEdBQUcsRUFDSCxHQUFHLEVBQ0gsR0FBRyxDQUNOOzs7Ozs7Ozs7Ozs7c0JDWGMsQ0FDWCxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLEVBQ2YsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FDdkIiLCJmaWxlIjoianNoYW5ndWwuanMiLCJzb3VyY2VzQ29udGVudCI6WyIoZnVuY3Rpb24gd2VicGFja1VuaXZlcnNhbE1vZHVsZURlZmluaXRpb24ocm9vdCwgZmFjdG9yeSkge1xuXHRpZih0eXBlb2YgZXhwb3J0cyA9PT0gJ29iamVjdCcgJiYgdHlwZW9mIG1vZHVsZSA9PT0gJ29iamVjdCcpXG5cdFx0bW9kdWxlLmV4cG9ydHMgPSBmYWN0b3J5KCk7XG5cdGVsc2UgaWYodHlwZW9mIGRlZmluZSA9PT0gJ2Z1bmN0aW9uJyAmJiBkZWZpbmUuYW1kKVxuXHRcdGRlZmluZShmYWN0b3J5KTtcblx0ZWxzZSBpZih0eXBlb2YgZXhwb3J0cyA9PT0gJ29iamVjdCcpXG5cdFx0ZXhwb3J0c1tcIkhhbmd1bFwiXSA9IGZhY3RvcnkoKTtcblx0ZWxzZVxuXHRcdHJvb3RbXCJIYW5ndWxcIl0gPSBmYWN0b3J5KCk7XG59KSh0aGlzLCBmdW5jdGlvbigpIHtcbnJldHVybiBcblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiB3ZWJwYWNrL3VuaXZlcnNhbE1vZHVsZURlZmluaXRpb25cbiAqKi8iLCIgXHQvLyBUaGUgbW9kdWxlIGNhY2hlXG4gXHR2YXIgaW5zdGFsbGVkTW9kdWxlcyA9IHt9O1xuXG4gXHQvLyBUaGUgcmVxdWlyZSBmdW5jdGlvblxuIFx0ZnVuY3Rpb24gX193ZWJwYWNrX3JlcXVpcmVfXyhtb2R1bGVJZCkge1xuXG4gXHRcdC8vIENoZWNrIGlmIG1vZHVsZSBpcyBpbiBjYWNoZVxuIFx0XHRpZihpbnN0YWxsZWRNb2R1bGVzW21vZHVsZUlkXSlcbiBcdFx0XHRyZXR1cm4gaW5zdGFsbGVkTW9kdWxlc1ttb2R1bGVJZF0uZXhwb3J0cztcblxuIFx0XHQvLyBDcmVhdGUgYSBuZXcgbW9kdWxlIChhbmQgcHV0IGl0IGludG8gdGhlIGNhY2hlKVxuIFx0XHR2YXIgbW9kdWxlID0gaW5zdGFsbGVkTW9kdWxlc1ttb2R1bGVJZF0gPSB7XG4gXHRcdFx0ZXhwb3J0czoge30sXG4gXHRcdFx0aWQ6IG1vZHVsZUlkLFxuIFx0XHRcdGxvYWRlZDogZmFsc2VcbiBcdFx0fTtcblxuIFx0XHQvLyBFeGVjdXRlIHRoZSBtb2R1bGUgZnVuY3Rpb25cbiBcdFx0bW9kdWxlc1ttb2R1bGVJZF0uY2FsbChtb2R1bGUuZXhwb3J0cywgbW9kdWxlLCBtb2R1bGUuZXhwb3J0cywgX193ZWJwYWNrX3JlcXVpcmVfXyk7XG5cbiBcdFx0Ly8gRmxhZyB0aGUgbW9kdWxlIGFzIGxvYWRlZFxuIFx0XHRtb2R1bGUubG9hZGVkID0gdHJ1ZTtcblxuIFx0XHQvLyBSZXR1cm4gdGhlIGV4cG9ydHMgb2YgdGhlIG1vZHVsZVxuIFx0XHRyZXR1cm4gbW9kdWxlLmV4cG9ydHM7XG4gXHR9XG5cblxuIFx0Ly8gZXhwb3NlIHRoZSBtb2R1bGVzIG9iamVjdCAoX193ZWJwYWNrX21vZHVsZXNfXylcbiBcdF9fd2VicGFja19yZXF1aXJlX18ubSA9IG1vZHVsZXM7XG5cbiBcdC8vIGV4cG9zZSB0aGUgbW9kdWxlIGNhY2hlXG4gXHRfX3dlYnBhY2tfcmVxdWlyZV9fLmMgPSBpbnN0YWxsZWRNb2R1bGVzO1xuXG4gXHQvLyBfX3dlYnBhY2tfcHVibGljX3BhdGhfX1xuIFx0X193ZWJwYWNrX3JlcXVpcmVfXy5wID0gXCJcIjtcblxuIFx0Ly8gTG9hZCBlbnRyeSBtb2R1bGUgYW5kIHJldHVybiBleHBvcnRzXG4gXHRyZXR1cm4gX193ZWJwYWNrX3JlcXVpcmVfXygwKTtcblxuXG5cbi8qKiBXRUJQQUNLIEZPT1RFUiAqKlxuICoqIHdlYnBhY2svYm9vdHN0cmFwIGZhZDc4M2I3MGQ3NzE3YWVhNDg0XG4gKiovIiwiaW1wb3J0IGlzSGFuZ3VsIGZyb20gJy4vaXNIYW5ndWwnXG5pbXBvcnQgaW5pdGlhbCBmcm9tICcuL2luaXRpYWwnXG5pbXBvcnQgdm93ZWwgZnJvbSAnLi92b3dlbCdcbmltcG9ydCB1bmRlciBmcm9tICcuL3VuZGVyJ1xuaW1wb3J0IGhhc1VuZGVyIGZyb20gJy4vaGFzVW5kZXInXG5pbXBvcnQgaGFzTGFzdFVuZGVyIGZyb20gJy4vaGFzTGFzdFVuZGVyJ1xuaW1wb3J0IGZvcm1hdE51bWJlciBmcm9tICcuL2Zvcm1hdE51bWJlcidcblxuZXhwb3J0IGRlZmF1bHQge1xuICAgIGlzOiBpc0hhbmd1bCxcbiAgICBpbml0aWFsOiBpbml0aWFsLFxuICAgIHZvd2VsOiB2b3dlbCxcbiAgICB1bmRlcjogdW5kZXIsXG4gICAgaGFzVW5kZXI6IGhhc1VuZGVyLFxuICAgIGhhc0xhc3RVbmRlcjogaGFzTGFzdFVuZGVyLFxuICAgIGZvcm1hdE51bWJlcjogZm9ybWF0TnVtYmVyXG59O1xuXG5TdHJpbmcucHJvdG90eXBlLmlzSGFuZ3VsID0gZnVuY3Rpb24obGVuKSB7XG4gICAgcmV0dXJuIGlzSGFuZ3VsKHRoaXMudG9TdHJpbmcoKSwgbGVuKTtcbn07XG5cblN0cmluZy5wcm90b3R5cGUuaGFuZ3VsSW5pdGlhbCA9IGZ1bmN0aW9uKCkge1xuICAgIHJldHVybiBpbml0aWFsKHRoaXMudG9TdHJpbmcoKSk7XG59O1xuXG5TdHJpbmcucHJvdG90eXBlLmhhbmd1bFZvd2VsID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIHZvd2VsKHRoaXMudG9TdHJpbmcoKSk7XG59O1xuXG5TdHJpbmcucHJvdG90eXBlLmhhbmd1bFVuZGVyID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIHVuZGVyKHRoaXMudG9TdHJpbmcoKSk7XG59O1xuXG5TdHJpbmcucHJvdG90eXBlLmhhc0hhbmd1bFVuZGVyID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIGhhc1VuZGVyKHRoaXMudG9TdHJpbmcoKSk7XG59O1xuXG5TdHJpbmcucHJvdG90eXBlLmhhc0xhc3RIYW5ndWxVbmRlciA9IGZ1bmN0aW9uKCkge1xuICAgIHJldHVybiBoYXNMYXN0VW5kZXIodGhpcy50b1N0cmluZygpKTtcbn07XG5cblN0cmluZy5wcm90b3R5cGUudG9IYW5ndWxOdW1iZXIgPSBmdW5jdGlvbihkZWxpbWl0ZXIpIHtcbiAgICByZXR1cm4gZm9ybWF0TnVtYmVyKHRoaXMudG9TdHJpbmcoKSwgZGVsaW1pdGVyKTtcbn07XG5cbk51bWJlci5wcm90b3R5cGUudG9IYW5ndWwgPSBmdW5jdGlvbihkZWxpbWl0ZXIpIHtcbiAgICByZXR1cm4gZm9ybWF0TnVtYmVyKHRoaXMudG9TdHJpbmcoKSwgZGVsaW1pdGVyKTtcbn07XG5cblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy9pbmRleC5qc1xuICoqLyIsImltcG9ydCBpc0hhbmd1bCBmcm9tICcuL2lzSGFuZ3VsJ1xuaW1wb3J0IEZJTkFMX0NPTlNPTkFOVFMgZnJvbSAnLi92YXJzL2ZpbmFsQ29uc29uYW50cydcblxuLyoqXG4gKiBAZGVzY3JpcHRpb24g7ZWc6riAIO2VnOusuOyekOyXkOyEnCDsooXshLHsnYQg67aE66as7ZW07IScIOqwgOyguOyYqOuLpFxuICogQHBhcmFtIHtzdHJpbmd9IHN0ciDrrLjsnpBcbiAqIEByZXR1cm4ge3N0cmluZ30g7KKF7ISxXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKHN0cikge1xuICAgIGlmICghaXNIYW5ndWwoc3RyLCAxKSkge1xuICAgICAgICByZXR1cm4gdHlwZW9mIHN0ciA9PT0gJ3N0cmluZycgPyBzdHIuY2hhckF0KDApIDogc3RyO1xuICAgIH1cbiAgICByZXR1cm4gRklOQUxfQ09OU09OQU5UU1twYXJzZUludCgoKChzdHIuY2hhckNvZGVBdCgwKSAmIDB4RkZGRikgLSAweEFDMDApICUgKDIxICogMjgpKSAlIDI4KV07XG59XG5cblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy91bmRlci5qc1xuICoqLyIsIlwidXNlIHN0cmljdFwiO1xuXG5leHBvcnRzW1wiZGVmYXVsdFwiXSA9IGZ1bmN0aW9uIChvYmopIHtcbiAgcmV0dXJuIG9iaiAmJiBvYmouX19lc01vZHVsZSA/IG9iaiA6IHtcbiAgICBcImRlZmF1bHRcIjogb2JqXG4gIH07XG59O1xuXG5leHBvcnRzLl9fZXNNb2R1bGUgPSB0cnVlO1xuXG5cbi8qKioqKioqKioqKioqKioqKlxuICoqIFdFQlBBQ0sgRk9PVEVSXG4gKiogLi9+L2JhYmVsLXJ1bnRpbWUvaGVscGVycy9pbnRlcm9wLXJlcXVpcmUtZGVmYXVsdC5qc1xuICoqIG1vZHVsZSBpZCA9IDJcbiAqKiBtb2R1bGUgY2h1bmtzID0gMFxuICoqLyIsIi8qKlxuICogQGRlc2NyaXB0aW9uIOusuOyekOyXtOydtCDtlZzquIDsnbjsp4Ag6rKA7IKs7ZWc64ukXG4gKiBAcGFyYW0ge3N0cmluZ30gc3RyIOusuOyekOyXtFxuICogQHBhcmFtIHtudW1iZXJ9IFtsZW5dIOqygOyCrOq4uOydtFxuICogQHJldHVybiB7Ym9vbGVhbn0g6rKA7IKs6rKw6rO8XG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKHN0ciwgbGVuKSB7XG4gICAgaWYgKHR5cGVvZiBzdHIgIT09ICdzdHJpbmcnIHx8IHN0ci5sZW5ndGggPT09IDApIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgICBpZiAoIWxlbiB8fCBsZW4gPCAwIHx8IGxlbiA+IHN0ci5sZW5ndGgpIHtcbiAgICAgICAgbGVuID0gc3RyLmxlbmd0aDtcbiAgICB9XG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCBsZW47IGkrKykge1xuICAgICAgICBsZXQgYyA9IHN0ci5jaGFyQ29kZUF0KGkpO1xuICAgICAgICBpZiAoYyA8IDB4QUMwMCB8fCBjID4gMHhEN0EzKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIHRydWU7XG59XG5cblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy9pc0hhbmd1bC5qc1xuICoqLyIsImV4cG9ydCBkZWZhdWx0IFtcbiAgICAnJyxcbiAgICAn44SxJyxcbiAgICAn44SyJyxcbiAgICAn44SzJyxcbiAgICAn44S0JyxcbiAgICAn44S1JyxcbiAgICAn44S2JyxcbiAgICAn44S3JyxcbiAgICAn44S5JyxcbiAgICAn44S6JyxcbiAgICAn44S7JyxcbiAgICAn44S8JyxcbiAgICAn44S9JyxcbiAgICAn44S+JyxcbiAgICAn44S/JyxcbiAgICAn44WAJyxcbiAgICAn44WBJyxcbiAgICAn44WCJyxcbiAgICAn44WEJyxcbiAgICAn44WFJyxcbiAgICAn44WGJyxcbiAgICAn44WHJyxcbiAgICAn44WIJyxcbiAgICAn44WKJyxcbiAgICAn44WLJyxcbiAgICAn44WMJyxcbiAgICAn44WNJyxcbiAgICAn44WOJ1xuXTtcblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy92YXJzL2ZpbmFsQ29uc29uYW50cy5qc1xuICoqLyIsImltcG9ydCBpc0hhbmd1bCBmcm9tICcuL2lzSGFuZ3VsJ1xuaW1wb3J0IElOSVRJQUxfQ09OU09OQU5UUyBmcm9tICcuL3ZhcnMvaW5pdGlhbENvbnNvbmFudHMnXG5cbi8qKlxuICogQGRlc2NyaXB0aW9uIO2VnOq4gCDtlZzrrLjsnpDsl5DshJwg7LSI7ISx7J2EIOu2hOumrO2VtOyEnCDqsIDsoLjsmKjri6RcbiAqIEBwYXJhbSB7c3RyaW5nfSBzdHIg66y47J6QXG4gKiBAcmV0dXJuIHtzdHJpbmd9IOy0iOyEsVxuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbihzdHIpIHtcbiAgICBpZiAoIWlzSGFuZ3VsKHN0ciwgMSkpIHtcbiAgICAgICAgcmV0dXJuIHR5cGVvZiBzdHIgPT09ICdzdHJpbmcnID8gc3RyLmNoYXJBdCgwKSA6IHN0cjtcbiAgICB9XG4gICAgcmV0dXJuIElOSVRJQUxfQ09OU09OQU5UU1twYXJzZUludCgoKHN0ci5jaGFyQ29kZUF0KDApICYgMHhGRkZGKSAtIDB4QUMwMCkgLyAoMjEgKiAyOCkpXTtcbn1cblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy9pbml0aWFsLmpzXG4gKiovIiwiZXhwb3J0IGRlZmF1bHQgW1xuICAgICfjhLEnLFxuICAgICfjhLInLFxuICAgICfjhLQnLFxuICAgICfjhLcnLFxuICAgICfjhLgnLFxuICAgICfjhLknLFxuICAgICfjhYEnLFxuICAgICfjhYInLFxuICAgICfjhYMnLFxuICAgICfjhYUnLFxuICAgICfjhYYnLFxuICAgICfjhYcnLFxuICAgICfjhYgnLFxuICAgICfjhYknLFxuICAgICfjhYonLFxuICAgICfjhYsnLFxuICAgICfjhYwnLFxuICAgICfjhY0nLFxuICAgICfjhY4nXG5dO1xuXG5cbi8qKiBXRUJQQUNLIEZPT1RFUiAqKlxuICoqIC4vc3JjL3ZhcnMvaW5pdGlhbENvbnNvbmFudHMuanNcbiAqKi8iLCJpbXBvcnQgaXNIYW5ndWwgZnJvbSAnLi9pc0hhbmd1bCdcbmltcG9ydCBWT1dFTFMgZnJvbSAnLi92YXJzL3Zvd2VscydcblxuLyoqXG4gKiBAZGVzY3JpcHRpb24g7ZWc6riAIO2VnOusuOyekOyXkOyEnCDspJHshLHsnYQg67aE66as7ZW07IScIOqwgOyguOyYqOuLpFxuICogQHBhcmFtIHtzdHJpbmd9IHN0ciDrrLjsnpBcbiAqIEByZXR1cm4ge3N0cmluZ30g7KSR7ISxXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKHN0cikge1xuICAgIGlmICghaXNIYW5ndWwoc3RyLCAxKSkge1xuICAgICAgICByZXR1cm4gdHlwZW9mIHN0ciA9PT0gJ3N0cmluZycgPyBzdHIuY2hhckF0KDApIDogc3RyO1xuICAgIH1cbiAgICByZXR1cm4gVk9XRUxTW3BhcnNlSW50KCgoKHN0ci5jaGFyQ29kZUF0KDApICYgMHhGRkZGKSAtIDB4QUMwMCkgJSAoMjEgKiAyOCkpIC8gMjgpXTtcbn1cblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy92b3dlbC5qc1xuICoqLyIsImV4cG9ydCBkZWZhdWx0IFtcbiAgICAn44WPJyxcbiAgICAn44WQJyxcbiAgICAn44WRJyxcbiAgICAn44WSJyxcbiAgICAn44WTJyxcbiAgICAn44WUJyxcbiAgICAn44WVJyxcbiAgICAn44WWJyxcbiAgICAn44WXJyxcbiAgICAn44WYJyxcbiAgICAn44WZJyxcbiAgICAn44WaJyxcbiAgICAn44WbJyxcbiAgICAn44WcJyxcbiAgICAn44WdJyxcbiAgICAn44WeJyxcbiAgICAn44WfJyxcbiAgICAn44WgJyxcbiAgICAn44WhJyxcbiAgICAn44WiJyxcbiAgICAn44WjJ1xuXTtcblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy92YXJzL3Zvd2Vscy5qc1xuICoqLyIsImltcG9ydCBpc0hhbmd1bCBmcm9tICcuL2lzSGFuZ3VsJ1xuaW1wb3J0IHVuZGVyIGZyb20gJy4vdW5kZXInXG5cbi8qKlxuICogQGRlc2NyaXB0aW9uIO2VnOusuOyekOydmCDsooXshLHsnZgg7Jyg66y066W8IOqygOyCrO2VnOuLpFxuICogQHBhcmFtIHtzdHJpbmd9IHN0ciDrrLjsnpBcbiAqIEByZXR1cm4ge2Jvb2xlYW59IOyiheyEseydmCDsnKDrrLRcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24oc3RyKSB7XG4gICAgcmV0dXJuIGlzSGFuZ3VsKHN0ciwgMSkgJiYgdW5kZXIoc3RyKSAhPT0gJyc7XG59XG5cblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy9oYXNVbmRlci5qc1xuICoqLyIsImltcG9ydCBoYXNVbmRlciBmcm9tICcuL2hhc1VuZGVyJ1xuXG4vKipcbiAqIEBkZXNjcmlwdGlvbiDrrLjsnpDsl7TsnZgg66eI7KeA66eJIOusuOyekOydmCDsooXshLEg7Jyg66y066W8IOqygOyCrO2VnOuLpFxuICogQHBhcmFtIHtzdHJpbmd9IHN0ciDrrLjsnpDsl7RcbiAqIEByZXR1cm4ge2Jvb2xlYW59IOuniOyngOuniSDrrLjsnpDsnZgg7KKF7ISxIOycoOustFxuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbihzdHIpIHtcbiAgICBpZiAodHlwZW9mIHN0ciAhPT0gJ3N0cmluZycgfHwgc3RyLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIHJldHVybiBoYXNVbmRlcihzdHIuY2hhckF0KHN0ci5sZW5ndGggLSAxKSk7XG59XG5cblxuLyoqIFdFQlBBQ0sgRk9PVEVSICoqXG4gKiogLi9zcmMvaGFzTGFzdFVuZGVyLmpzXG4gKiovIiwiaW1wb3J0IE5VTUJFUlMgZnJvbSAnLi92YXJzL251bWJlcnMnXG5pbXBvcnQgTEFSR0VfTlVNQkVSUyBmcm9tICcuL3ZhcnMvbGFyZ2VOdW1iZXJzJ1xuXG4vKipcbiAqIEBkZXNjcmlwdGlvbiDsiKvsnpDrpbwg7ZWc6riA7ZiV7Iud7Jy866GcIOuwlOq/lOykgOuLpFxuICogQHBhcmFtIHtudW1iZXJ8c3RyaW5nfSBudW1iZXIg7Iir7J6QXG4gKiBAcGFyYW0ge3N0cmluZ30gW2RlbGltaXRlcl0g64uo7JyEIOq1rOu2hOyekFxuICogQHJldHVybiB7c3RyaW5nfSDtlZzquIDsiKvsnpBcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24obnVtYmVyLCBkZWxpbWl0ZXIpIHtcbiAgICBpZiAodHlwZW9mIG51bWJlciA9PT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihcIidudW1iZXInIGlzIHVuZGVmaW5lZFwiKTtcbiAgICB9XG4gICAgaWYgKHR5cGVvZiBudW1iZXIgIT09ICdzdHJpbmcnKSB7XG4gICAgICAgIG51bWJlciA9IG51bWJlci50b1N0cmluZygpO1xuICAgIH1cbiAgICBpZiAoIS9eWzAtOV0rJC8udGVzdChudW1iZXIpKSB7XG4gICAgICAgIHJldHVybiBudW1iZXI7XG4gICAgfVxuICAgIGlmIChudW1iZXIuY2hhckF0KDApID09PSAnMCcpIHtcbiAgICAgICAgZm9yIChsZXQgaSA9IDE7IGkgPCBudW1iZXIubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgICAgIGlmIChudW1iZXIuY2hhckF0KGkpID09PSAnMCcpIHtcbiAgICAgICAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIG51bWJlciA9IG51bWJlci5zdWJzdHJpbmcoaSk7XG4gICAgICAgICAgICBicmVhaztcbiAgICAgICAgfVxuICAgIH1cbiAgICBpZiAobnVtYmVyLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICByZXR1cm4gTlVNQkVSU1swXTtcbiAgICB9XG4gICAgaWYgKG51bWJlci5sZW5ndGggPT09IDEpIHtcbiAgICAgICAgcmV0dXJuIE5VTUJFUlNbbnVtYmVyLmNoYXJBdCgwKV07XG4gICAgfVxuICAgIGxldCBzcGxpdGVkTnVtYmVycyA9IG51bWJlci5zcGxpdCgnJykubWFwKGEgPT4gcGFyc2VJbnQoYSkpO1xuICAgIGxldCByZXZlcnNlZE51bWJlcnMgPSBzcGxpdGVkTnVtYmVycy5yZXZlcnNlKCk7XG4gICAgbGV0IGdyb3VwZWROdW1iZXJzID0gW107XG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCByZXZlcnNlZE51bWJlcnMubGVuZ3RoOyBpICs9IDQpIHtcbiAgICAgICAgZ3JvdXBlZE51bWJlcnMucHVzaChyZXZlcnNlZE51bWJlcnMuc2xpY2UoaSwgaSArIDQpKTtcbiAgICB9XG4gICAgcmV0dXJuIGdyb3VwZWROdW1iZXJzLm1hcCgobnVtcywgaSkgPT4ge1xuICAgICAgICBsZXQgaG51bXMgPSBudW1zLm1hcCgobiwgaikgPT4ge1xuICAgICAgICAgICAgbGV0IGhudW0gPSAobiA+IDEgfHwgaiA9PT0gMCAmJiBuID09PSAxKSA/IE5VTUJFUlNbbl0gOiAnJztcbiAgICAgICAgICAgIGxldCB1bml0ID0gKG4gPiAwICYmIGogPiAwKSA/IExBUkdFX05VTUJFUlNbMF1baiAtIDFdIDogJyc7XG4gICAgICAgICAgICByZXR1cm4gaG51bSArIHVuaXQ7XG4gICAgICAgIH0pLnJlZHVjZSgoYSwgYikgPT4gYiArIGEpO1xuICAgICAgICBsZXQgbHVuaXQgPSAoaSA+IDAgJiYgaG51bXMubGVuZ3RoID4gMCkgPyBMQVJHRV9OVU1CRVJTWzFdWyhpIC0gMSkgJSA0XSA6ICcnO1xuICAgICAgICByZXR1cm4gaG51bXMgKyBsdW5pdDtcbiAgICB9KS5maWx0ZXIoYSA9PiBhLmxlbmd0aCA+IDApLnJlZHVjZSgoYSwgYikgPT4gYiArIChkZWxpbWl0ZXIgfHwgJycpICsgYSk7XG59XG5cblxuLyoqIFdFQlBBQ0sgRk9PVEVSICoqXG4gKiogLi9zcmMvZm9ybWF0TnVtYmVyLmpzXG4gKiovIiwiZXhwb3J0IGRlZmF1bHQgW1xuICAgICfsmIEnLFxuICAgICfsnbwnLFxuICAgICfsnbQnLFxuICAgICfsgrwnLFxuICAgICfsgqwnLFxuICAgICfsmKQnLFxuICAgICfsnKEnLFxuICAgICfsuaAnLFxuICAgICftjJQnLFxuICAgICfqtawnXG5dO1xuXG5cbi8qKiBXRUJQQUNLIEZPT1RFUiAqKlxuICoqIC4vc3JjL3ZhcnMvbnVtYmVycy5qc1xuICoqLyIsImV4cG9ydCBkZWZhdWx0IFtcbiAgICBbJ+yLrScsICfrsLEnLCAn7LKcJ10sXG4gICAgWyfrp4wnLCAn7Ja1JywgJ+yhsCcsICfqsr0nXVxuXTtcblxuXG4vKiogV0VCUEFDSyBGT09URVIgKipcbiAqKiAuL3NyYy92YXJzL2xhcmdlTnVtYmVycy5qc1xuICoqLyJdLCJzb3VyY2VSb290IjoiIn0=