const webpack = require('webpack');

module.exports = {
    entry: './src/index.js',
    output: {
        filename: 'jshangul.js',
        minifyFilename: 'jshangul.min.js',
        sourceMapFilename: 'jshangul.js.map',
        libraryTarget: 'umd',
        library: 'Hangul'
    },
    module: {
        loaders: [
            {
                test: /.js$/,
                exclude: /(node_modules|bower_components)/,
                loader: 'babel-loader?optional=runtime'
            }
            //{test: /\.coffee$/, loader: 'coffee-loader'}
        ]
    },
    devtool: '#inline-source-map',
    plugins: [
        new webpack.ProvidePlugin({
            FINAL_CONSONANTS: __dirname + '/src/vars/finalConsonants',
            INITIAL_CONSONANTS: __dirname + '/src/vars/initialConsonants',
            LARGE_NUMBERS: __dirname + '/src/vars/largeNumbers',
            NUMBERS: __dirname + '/src/vars/numbers',
            VOWELS: __dirname + '/src/vars/vowels'
        })
    ]
};
