// Generated by CoffeeScript 1.9.1
(function() {
  var JSOG, assert, moment;

  assert = require('assert');

  JSOG = require('../lib/JSOG');

  moment = require('moment');

  describe('leaving original object alone', function() {
    var foo;
    foo = {};
    JSOG.encode(foo);
    return it('should not have added an id', function() {
      return assert(!(foo['$id'] != null));
    });
  });

  describe('duplicate references', function() {
    var decoded, encoded, inside, outside, roundtrip;
    inside = {
      name: 'thing'
    };
    outside = {
      inside1: inside,
      inside2: inside
    };
    encoded = JSOG.encode(outside);
    decoded = JSOG.decode(encoded);
    console.log("Encoded is:");
    console.log(JSON.stringify(encoded, void 0, 4));
    console.log("Outside after encoding is:");
    console.log(JSON.stringify(outside, void 0, 4));
    console.log("Decoded is:");
    console.log(JSON.stringify(decoded, void 0, 4));
    roundtrip = JSOG.parse(JSOG.stringify(outside));
    console.log("Roundtrip is:");
    console.log(JSON.stringify(roundtrip, void 0, 4));
    it('inside1 and inside2 should be equal', function() {
      return assert(decoded.inside1 === decoded.inside2);
    });
    it('should have inside1.name', function() {
      return assert(decoded.inside1.name === 'thing');
    });
    return it('should not have an @id', function() {
      return assert(!(decoded['@id'] != null));
    });
  });

  describe('cyclic references', function() {
    var circular, decoded, encoded;
    circular = {};
    circular.me = circular;
    encoded = JSOG.encode(circular);
    decoded = JSOG.decode(encoded);
    console.log("Encoded: " + JSON.stringify(encoded, void 0, 4));
    it('should have an encoded id', function() {
      return assert(encoded['@id'] != null);
    });
    it('should have resolved references', function() {
      return assert(encoded.me['@ref'] === encoded['@id']);
    });
    it('me is decoded', function() {
      return assert(decoded.me === decoded);
    });
    return it('is not circular', function() {
      return assert(!(circular['@id'] != null));
    });
  });

  describe('nulls', function() {
    it('should leave null by itself alone', function() {
      return assert(JSOG.encode(null) === null);
    });
    return it('should leave null in an object alone', function() {
      var encoded, foo;
      foo = {
        foo: null
      };
      encoded = JSOG.encode(foo);
      assert(encoded['@id'] != null);
      return assert(encoded.foo === null);
    });
  });

  describe('arrays', function() {
    return it('should encode arrays properly', function() {
      var array, encoded, foo;
      foo = {
        bar: true
      };
      array = [foo, foo];
      encoded = JSOG.encode(array);
      assert(encoded[0]['@id'] != null);
      return assert(encoded[0]['@id'] === encoded[1]['@ref']);
    });
  });

  describe('custom json serialization', function() {
    return it('should leave objects with toJSON methods alone', function() {
      var encoded, foo;
      foo = {
        foo: moment()
      };
      encoded = JSOG.encode(foo);
      return assert(encoded.foo === foo.foo);
    });
  });

}).call(this);
