'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _applyBaobabJsPatch = require('./applyBaobabJsPatch');

var _applyBaobabJsPatch2 = _interopRequireDefault(_applyBaobabJsPatch);

var _isPatch = require('./isPatch');

var _isPatch2 = _interopRequireDefault(_isPatch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var applyPatch = (0, _ramda.curry)(function (tree, patch) {
  var patches = (0, _ramda.isArrayLike)(patch) ? patch : [patch];
  (0, _ramda.forEach)(function (x) {
    if ((0, _isPatch2.default)(x) !== true) {
      console.error('[patch error]: op: ' + x.op + ', path: ' + x.path + ', value: ' + x.value);
      throw (0, _isPatch2.default)(x) + JSON.stringify(x);
    }
  }, patches);

  if ((0, _ramda.equals)(tree.toString(), '[object Baobab]')) {
    (0, _applyBaobabJsPatch2.default)(tree, patches);
  } else {
    throw new Error('Tree not supported to apply patch to.');
  }
});

exports.default = applyPatch;
//# sourceMappingURL=applyPatch.js.map
