'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _isPatch = require('./isPatch');

var _isPatch2 = _interopRequireDefault(_isPatch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var valueType = (0, _ramda.cond)([[(0, _ramda.contains)(_ramda.__, ['move', 'copy']), (0, _ramda.always)('from')], [(0, _ramda.contains)(_ramda.__, ['add', 'replace', 'test', 'merge']), (0, _ramda.always)('value')], [_ramda.T, _ramda.F]]);

/**
 * Creates a JSON Patches given an operator, path and a value
 *
 * https://tools.ietf.org/html/rfc6902
 *
 * https://tools.ietf.org/html/rfc7386
 *
 * ** Sig: String -> String -> A -> Object **
 *
 * @function
 * @implements curry
 * @param {string} operation - A JSON Patch operation (see https://tools.ietf.org/html/rfc6902)
 * @param {string} pointer - A JSON Pointer (see http://tools.ietf.org/html/rfc6901)
 * @param {object} value|from path - A value for [add, replace, test] and a FROM path for [move, copy]
 * @return {object} jsonPatch - A valid json patch
 * @example
 *
 * lib.createPatch('add', '/foo/bar', 123) // { op: 'add', path: '/foo/bar', value: 123 }
 *
 */
var createPatch = (0, _ramda.curry)(function (op, jsonPath, value) {

  var patch = {
    op: op,
    path: jsonPath
  };

  if (valueType(op) !== false) {
    patch[valueType(op)] = value;
  }

  var result = (0, _isPatch2.default)(patch);

  if (true !== result) {
    var err = new Error();
    err.result = result;
    err.op = op;
    err.path = jsonPath;
    err.value = value;
    return err;
  }

  return patch;
});

exports.default = createPatch;
//# sourceMappingURL=createPatch.js.map
