'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _listPath = require('./listPath');

var _listPath2 = _interopRequireDefault(_listPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A wrapper for cursor.exists(path) to get if a path exists or not.
 *
 * ** Sig: DataCursor -> jsonPath -> boolean **
 *
 * @function
 * @implements curry
 * @memberof lib
 * @param {Object} DataCursor - The base from which the select path will be made
 * @param {string} jsonPath - The JSON path that will traverse the tree
 * @return {Object} - The nested cursor found at the given path
 * @example
 *
 * let cursor = new Baobab({
 *   foo: {}
 * })
 *
 * lib.cursorExists(cursor, '/foo') // true
 * lib.cursorExists(cursor, '/bar') // false
 *
 */
var cursorExists = (0, _ramda.curry)(function (cursor, jsonPath) {
  return cursor.exists((0, _listPath2.default)(jsonPath));
});

exports.default = cursorExists;
//# sourceMappingURL=cursorExists.js.map
