'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _cursorSelect = require('./cursorSelect');

var _cursorSelect2 = _interopRequireDefault(_cursorSelect);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A wrapper for cursor.select(path).get() that uses JSON Paths.
 *
 * ** Sig: DataCursor -> jsonPath -> Any **
 *
 * @function
 * @implements curry
 * @memberof lib
 * @param {Object} DataCursor - The base from which the select path will be made
 * @param {string} jsonPath - The JSON path that will traverse the tree
 * @return {any} - The value at the given path
 * @example
 *
 * let cursor = new Baobab({
 *   foo: {
 *     bar: 23
 *   }
 * })
 * let jsonPath = '/foo/bar/'
 *
 * lib.cursorGet(cursor, jsonPath) // 23
 * lib.cursorGet(cursor)(jsonPath) // 23 - curried
 *
 */
var cursorGet = (0, _ramda.curry)(function (cursor, jsonPath) {
  return (0, _cursorSelect2.default)(cursor, jsonPath).serialize();
});

exports.default = cursorGet;
//# sourceMappingURL=cursorGet.js.map
