'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _kefir = require('kefir');

var Kefir = _interopRequireWildcard(_kefir);

var _cursorSelect = require('./cursorSelect');

var _cursorSelect2 = _interopRequireDefault(_cursorSelect);

var _cursorExists = require('./cursorExists');

var _cursorExists2 = _interopRequireDefault(_cursorExists);

var _cursorGet = require('./cursorGet');

var _cursorGet2 = _interopRequireDefault(_cursorGet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

/**
 * Set a listener on a data cursor at the given path.
 * When the listener is fired it is given the current value found
 * at that path
 *
 * ** Sig: DataCursor -> EventName -> jsonPath -> Stream **
 *
 * @function
 * @implements curry
 * @memberof lib
 * @param {object} BaobabCursor - The base from which the select path will be made
 * @param {string} eventName - The event that will be listened on
 * @param {string} jsonPath - The JSON path that will traverse the tree
 * @return {object} - Stream - a stream of currentData values from the cursor path
 * @example
 *
 * let cursor = new Baobab({
 *   foo: {
 *     bar: 23
 *   }
 * })
 * let jsonPath = '/foo/bar/'
 *
 * let fooBarStream = lib.cursorOn(cursor, 'update', jsonPath)
 * fooBarStream.onValue(lib.log('/foo/bar is '))
 * lib.cursorSet(cursor, jsonPath, 100) // /foo/bar/ is 100
 *
 */
var cursorOn = (0, _ramda.curry)(function (cursor, e, jsonPath) {
  return Kefir.stream(function (emitter) {
    var past = void 0;

    if ((0, _cursorExists2.default)(cursor, jsonPath)) {
      past = (0, _cursorGet2.default)(cursor, jsonPath);
      emitter.emit(past);
    }

    (0, _cursorSelect2.default)(cursor, jsonPath).on(e, function (x) {
      var now = x.data.currentData;

      if ((0, _ramda.not)((0, _ramda.equals)(past, now))) {
        past = now;
        emitter.emit(now);
      }
    });
  });
});

exports.default = cursorOn;
//# sourceMappingURL=cursorOn.js.map
