'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _listPath = require('./listPath');

var _listPath2 = _interopRequireDefault(_listPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A wrapper for cursor.select(path) to get a nested cursor.
 *
 * ** Sig: DataCursor -> jsonPath -> DataCursor **
 *
 * @function
 * @implements curry
 * @memberof lib
 * @param {Object} DataCursor - The base from which the select path will be made
 * @param {string} jsonPath - The JSON path that will traverse the tree
 * @return {Object} - The nested cursor found at the given path
 * @example
 *
 * let cursor = new Baobab({
 *   foo: {
 *     bar: 23
 *   }
 * })
 * let jsonPath = '/foo/bar/'
 *
 * let fooBarCursor = lib.cursorSelect(cursor, jsonPath)
 * fooBarCursor.get() // 23
 *
 */
var cursorSelect = (0, _ramda.curry)(function (cursor, jsonPath) {
  return cursor.select((0, _listPath2.default)(jsonPath));
});

exports.default = cursorSelect;
//# sourceMappingURL=cursorSelect.js.map
