'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

/**
 * Decodes a path according to https://tools.ietf.org/html/rfc6901 by replacing special symbols
 *
 * @function
 * @param {string} path - A valid path
 * @returns {string} result - The decoded path with properly replaced characters
 * @example
 *
 * decodePath('/foo~1bar') // '/foo/bar'
 * decodePath('/foo ~0/bar~1/2') // '/foo~/bar/2'
 */
var decodePath = (0, _ramda.compose)((0, _ramda.replace)(/\s/g, ''), (0, _ramda.replace)(/~0/g, '~'), (0, _ramda.replace)(/~1/g, '/'));

exports.default = decodePath;
//# sourceMappingURL=decodePath.js.map
