'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _ramda = require('ramda');

var _listPath = require('./listPath');

var _listPath2 = _interopRequireDefault(_listPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var derefSchema = function derefSchema(schema, initial) {
  if (initial === undefined) {
    initial = schema;
  }

  return (0, _ramda.mapObjIndexed)(function (v, k) {
    if ((typeof v === 'undefined' ? 'undefined' : _typeof(v)) === 'object' && null !== v && false == v instanceof Array) {
      if ((0, _ramda.has)('$ref', v)) {
        var ref = (0, _ramda.replace)('#/definitions', '', (0, _ramda.prop)('$ref', v));
        var refPath = (0, _listPath2.default)(ref);
        var refVal = (0, _ramda.path)(refPath, initial.definitions);
        v = (0, _ramda.dissoc)('$ref', v);
        v = (0, _ramda.merge)(v, refVal);
      }
      return derefSchema(v, initial);
    } else {
      return v;
    }
  }, schema);
};

exports.default = derefSchema;
//# sourceMappingURL=derefSchema.js.map
