'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _baobab = require('baobab');

var _listPath = require('./listPath');

var _listPath2 = _interopRequireDefault(_listPath);

var _isPath = require('./isPath');

var _isPath2 = _interopRequireDefault(_isPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var makePath = (0, _ramda.ifElse)((0, _ramda.is)(String), _listPath2.default, _ramda.identity);

var prepareArr = function prepareArr(acc, x) {

  if ((0, _ramda.is)(String, x) && true !== (0, _isPath2.default)(x)) {
    throw 'dynamicNode needs json paths "' + x + '"';
  }

  acc.push(makePath(x));
  return acc;
};

var dynamic = function dynamic() {
  var args = Array.prototype.slice.call(arguments);

  if (!(0, _ramda.equals)(2, (0, _ramda.length)(args))) {
    throw new Error('dynamicNode needs 2 params but "' + (0, _ramda.length)(args) + '" were specified');
  }

  if ((0, _ramda.not)((0, _ramda.isArrayLike)(args[0]))) {
    throw new Error('dynamicNode parameters are invalid. First param needs to be an array. "' + args + '"');
  }

  if (!(0, _ramda.is)(Function, args[1])) {
    throw new Error('dynamicNode paramters are invalid. Second param needs to be a function.  "' + args + '"');
  }

  args = (0, _ramda.flatten)(args);

  args.forEach(function (x) {
    if ((0, _ramda.is)(String, x) && !(0, _isPath2.default)(x)) {
      throw 'dynamicNode parameters are invalid. Param is not a valid path. "' + args + '"';
    }
  });

  args = (0, _ramda.reduce)(prepareArr, [], args);

  var node = _baobab.dynamicNode.apply(null, args);

  return node;
};

exports.default = dynamic;
//# sourceMappingURL=dynamicNode.js.map
