'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var operations = ['add', 'replace', 'test', 'remove', 'move', 'copy', 'merge'];

/**
 * Tests if a given string is a valid JSON Patch operation name
 * 
 * ** Sig: String -> Boolean|String **
 *
 * @function
 * @param {string} operation - the operation to be tested
 * @returns {true|string} result - ** true ** if the operation is valid or a ** string ** with the corresponding error
 * @example
 *
 * import isOperation from 'json-patch-utils'
 * isOperation('add') // true
 * isOperation('foobar') // "The operation name is not among the valid names"
 *
 */
var isOperation = (0, _ramda.cond)([[(0, _ramda.pipe)((0, _ramda.is)(String), _ramda.not), (0, _ramda.always)('The operation property must be a string')], [(0, _ramda.pipe)((0, _ramda.contains)(_ramda.__, operations), _ramda.not), (0, _ramda.always)('The operation name is not among the valid names ' + operations.join(', '))], [_ramda.T, _ramda.T]]);

exports.default = isOperation;
//# sourceMappingURL=isOperation.js.map
