'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _isPath = require('./isPath');

var _isPath2 = _interopRequireDefault(_isPath);

var _isOperation = require('./isOperation');

var _isOperation2 = _interopRequireDefault(_isOperation);

var _isValueForOperation = require('./isValueForOperation');

var _isValueForOperation2 = _interopRequireDefault(_isValueForOperation);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var validatePatch = (0, _ramda.juxt)([(0, _ramda.pipe)((0, _ramda.prop)('path'), _isPath2.default), (0, _ramda.pipe)((0, _ramda.prop)('op'), _isOperation2.default), (0, _ramda.pipe)((0, _ramda.props)(['op', 'value', 'from']), (0, _ramda.filter)((0, _ramda.pipe)((0, _ramda.equals)(undefined), _ramda.not)), (0, _ramda.apply)(_isValueForOperation2.default))]);

/**
 * Tests if a given object is a valid JSON Patch object according to https://tools.ietf.org/html/rfc6902
 *
 * @function
 * @param {object} jsonPatch - the json patch to be tested
 * @returns {boolean} testResult - true|false if the object is a valid JSON Patch
 * @example
 *
 * let patch1 = { op: 'add', path: '/foo', value: 'bar' }
 * let patch2 = { op: 'add', path: 'foo', value: 'bar' }
 * isPatch(patch1) // true
 * isPatch(patch2) // [errors]
 *
 */
var isPatch = (0, _ramda.compose)((0, _ramda.ifElse)((0, _ramda.all)((0, _ramda.equals)(true)), _ramda.T, (0, _ramda.reject)((0, _ramda.equals)(true))), validatePatch);

exports.default = isPatch;
//# sourceMappingURL=isPatch.js.map
