'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _decodePath = require('./decodePath');

var _decodePath2 = _interopRequireDefault(_decodePath);

var _pathExp = require('./pathExp');

var _pathExp2 = _interopRequireDefault(_pathExp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Tests if a given string is a valid JSON Pointer according to https://tools.ietf.org/html/rfc6901
 *
 * ** Sig: String -> Boolean|String **
 *
 * @function
 * @param {string} path - the path that should validate as a JSON Pointer
 * @returns {true|string} result - ** true ** if the path is a valid JSON Pointer or a ** string ** with the encountered error
 * @example
 *
 * isPath('/foo/bar') // true
 * isPath('foo!') // The path "foo!" did not match the encoded path regexp [regular expression]
 * isPath(123) // The path must be a string
 *
 */
var isPath = (0, _ramda.cond)([[(0, _ramda.pipe)((0, _ramda.is)(String), _ramda.not), (0, _ramda.always)('The path must be a string')], [(0, _ramda.pipe)((0, _ramda.test)(_pathExp2.default), _ramda.not), function (x) {
  return 'The path "' + x + '" did not match the encoded path regexp: ' + _pathExp2.default;
}], [(0, _ramda.pipe)(_decodePath2.default, (0, _ramda.test)(_pathExp2.default), _ramda.not), function (x) {
  return 'The path "' + x + '" did not match, after decoding, the decoded path regexp: ' + _pathExp2.default;
}], [_ramda.T, _ramda.T]]);

exports.default = isPath;
//# sourceMappingURL=isPath.js.map
