'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _isPath = require('./isPath');

var _isPath2 = _interopRequireDefault(_isPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Tests if a given value corresponds to the given operation
 *
 * e.g. ADD should not have an undefined value
 *
 * e.g. MOVE should have a path value
 *
 * @function
 * @param {string} operation - The operation that will decide the type of value
 * @param {string} value - The value that will be tested according to specifications
 * @returns {true|string} result - ** true ** if the value is correct or a ** string ** with the error
 * @example
 *
 * isValueForOperation('add', 'foo') // true
 * isValueForOperation('remove', null) // true - on remove the value is simply ignored
 * isValueForOperation('move', 'foo') // The path "foo!" did not match the encoded path regexp [regular expression]
 */
var isValueForOperation = (0, _ramda.cond)([[function (op, value) {
  return (0, _ramda.contains)(op, ['add', 'replace', 'test']) && (0, _ramda.equals)(undefined, value);
}, (0, _ramda.always)('The value or from path provided must be different than undefined')], [(0, _ramda.pipe)((0, _ramda.nthArg)(0), (0, _ramda.equals)('remove')), _ramda.T], [function (op, value) {
  return (0, _ramda.contains)(op, ['move', 'copy']) && (0, _ramda.pipe)(_isPath2.default, (0, _ramda.is)(String))(value);
}, (0, _ramda.pipe)((0, _ramda.nthArg)(1), _isPath2.default)], [_ramda.T, _ramda.T]]);

exports.default = isValueForOperation;
//# sourceMappingURL=isValueForOperation.js.map
