'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _decodePath = require('./decodePath');

var _decodePath2 = _interopRequireDefault(_decodePath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Convert a path into a list of strings.
 * Useful when traversing a path on a JSON Document
 *
 * ** Sig: String -> Array[String]
 *
 * @function
 * @param {string} path - A valid path that will be converted to an array
 * @returns {array} result - An array with the path names
 * @example
 *
 * listPath('/foo/bar') // ['foo', 'bar']
 * listPath('/foo~1bar~0/1') // ['foo', 'bar~', 1]
 */
var listPath = (0, _ramda.compose)(_ramda.tail, (0, _ramda.split)('/'), _decodePath2.default);

exports.default = listPath;
//# sourceMappingURL=listPath.js.map
