'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _derefSchema = require('./derefSchema');

var _derefSchema2 = _interopRequireDefault(_derefSchema);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var schemaParser = function schemaParser(schema) {

  if ((0, _ramda.has)('properties', schema)) {
    schema = schema.properties;
  } else if ((0, _ramda.has)('patternProperties', schema)) {
    schema = schema.patternProperties;
  }

  var props = (0, _ramda.pipe)(_ramda.toPairs, (0, _ramda.map)((0, _ramda.zipObj)(['key', 'val'])))(schema);

  return (0, _ramda.reduce)(function (acc, o) {
    if ((0, _ramda.and)((0, _ramda.equals)('object', o.val.type), (0, _ramda.is)(Object, o.val.properties))) {
      acc[o.key] = objFromSchema(o.val.properties);
    } else {
      if ((0, _ramda.equals)('object', o.val.type)) {
        acc[o.key] = {};
      } else if ((0, _ramda.equals)('array', o.val.type)) {
        acc[o.key] = [];
      } else if ((0, _ramda.equals)('string', o.val.type)) {
        acc[o.key] = '';
      } else {
        acc[o.key] = null;
      }

      if ((0, _ramda.has)('default', o.val)) {
        acc[o.key] = (0, _ramda.prop)('default', o.val);
      }
    }

    return acc;
  }, {}, props);
};

/**
 * Creates an object from a JSON schema.
 *
 * @function
 * @param {object} schema - The JSON Schema
 * @returns {object} obj - An object with the JSON Schema structure
 * @example
 *
 * var schema = {
 *  foo: {
 *    type: "string"
 *  },
 *  bar: {
 *    type: "array"
 *  },
 *  baz: {
 *    type: "object"
 *    properties: {
 *      bam: {
 *        type: "string",
 *        value: 23
 *      }
 *    }
 *  }
 * }
 *
 * objFromSchema(schema) // { foo: "", bar: [], baz: { bam: 23 } }
 *
 */
var objFromSchema = (0, _ramda.pipe)(_derefSchema2.default, schemaParser);

exports.default = objFromSchema;
//# sourceMappingURL=objFromSchema.js.map
