'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _dynamicNode = require('./dynamicNode');

var _dynamicNode2 = _interopRequireDefault(_dynamicNode);

var _isPath = require('./isPath');

var _isPath2 = _interopRequireDefault(_isPath);

var _listPath = require('./listPath');

var _listPath2 = _interopRequireDefault(_listPath);

var _routeParser = require('route-parser');

var _routeParser2 = _interopRequireDefault(_routeParser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var testRoute = (0, _ramda.curry)(function (url, fn, xs) {
  var testUrl = xs[0];

  if ((0, _ramda.last)(url) === '*') {
    url += 'a';
  }

  if ((0, _ramda.not)(new _routeParser2.default(url).match(testUrl))) {
    return false;
  }

  if ((0, _ramda.isNil)(fn)) {
    return true;
  }

  // Remove the route from the arguments list
  xs.shift();

  var result = (0, _ramda.apply)(fn, xs);

  if ((0, _ramda.not)((0, _ramda.is)(Boolean, result))) {
    throw new Error('The result of evaluating ' + fn.toString() + ' is ' + result + '. This should have been a Boolean');
  }

  return result;
});
/**
 * Route dyamic node that returns true or false
 * if the given route and its dependencies resolve
 *
 * If the provided route does not match the current route, then
 * the function is not called.
 *
 * @function
 * @memberof lib
 * @param {string} url - The url path that the current route has to match
 * @param {array}? cursors - A list of cursors that get the current state which will then be checked in the provided function
 * @param {function}? fn - A function that will receive the current route and the data from the cursors and should decide if the route is matched or not.
 * @return {boolean} - Whether the route is matched or not
 * @example
 *
 * let tree = new Baobab({
 *   url: '/foo/baz'
 *   bars: 2,
 *   isFooVisible: route('/foo/bar', ['/bars'], (route, bars) => {
 *      console.log('Function was called')
 *      return bars === 5
 *   })
 * })
 *
 * lib.cursorGet(tree, '/isFooVisible') // false
 *
 * tree.select('url').set(['foo', 'bar'])
 * lib.cursorGet(tree, '/isFooVisible') // Function was called | false
 *
 * tree.select('bars').set(5)
 * lib.cursorGet(tree, '/isFooVisible') // Function was called | true
 *
 */
var route = (0, _ramda.curryN)(2, function (urlPath, urlMatch) {
  var cursors = arguments.length <= 2 || arguments[2] === undefined ? [] : arguments[2];
  var fn = arguments[3];


  if ((0, _ramda.not)((0, _ramda.isNil)(cursors)) && (0, _ramda.not)((0, _ramda.isArrayLike)(cursors))) {
    throw 'Cursors must be an array';
  }

  if ((0, _ramda.not)((0, _ramda.isNil)(fn)) && (0, _ramda.not)((0, _ramda.is)(Function, fn))) {
    throw 'The last parameter must be a function';
  }

  cursors = (0, _ramda.prepend)(urlPath, cursors);

  return (0, _dynamicNode2.default)(cursors, (0, _ramda.pipe)((0, _ramda.unapply)(_ramda.identity), testRoute(urlMatch, fn)));
});

exports.default = route;
//# sourceMappingURL=route.js.map
