'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _isPath = require('./isPath');

var _isPath2 = _interopRequireDefault(_isPath);

var _listPath = require('./listPath');

var _listPath2 = _interopRequireDefault(_listPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getProp = (0, _ramda.useWith)(_ramda.path, [(0, _ramda.pipe)(_ramda.head, (0, _ramda.append)(_ramda.__, ['properties'])), _ramda.identity]);

var matchPattern = function matchPattern(path, schema) {
  return (0, _ramda.find)((0, _ramda.pipe)(RegExp, (0, _ramda.test)(_ramda.__, (0, _ramda.head)(path))), (0, _ramda.pipe)((0, _ramda.prop)('patternProperties'), _ramda.keys)(schema));
};

var appendRef = function appendRef(ref, path) {
  return (0, _ramda.concat)((0, _ramda.pipe)((0, _ramda.replace)('#/definitions', ''), _listPath2.default)(ref), path);
};

// newSchema :: object -> any
// o = {
//   xs: the current path
//   a: the current schema
//   b: the initial schema
// }
var newSchema = (0, _ramda.cond)([

// Check if the current path is present in the "properties" property
[function (o) {
  return getProp(o.xs, o.a);
}, function (o) {
  return {
    xs: (0, _ramda.tail)(o.xs),
    a: getProp(o.xs, o.a),
    b: o.b
  };
}],

// Check if the current path is present in the "patternPropperties" property
[function (o) {
  return matchPattern(o.xs, o.a);
}, function (o) {
  return {
    xs: (0, _ramda.tail)(o.xs),
    a: (0, _ramda.path)(['patternProperties', matchPattern(o.xs, o.a)], o.a),
    b: o.b
  };
}],

// Check for reference to the definitions
[function (o) {
  return (0, _ramda.has)('$ref', o.a);
}, function (o) {
  return {
    xs: appendRef((0, _ramda.prop)('$ref', o.a), o.xs),
    a: { properties: o.b.definitions },
    b: o.b
  };
}],

// If none of the above has tested then something is not supported
[_ramda.T, (0, _ramda.always)(undefined)]]);

var getSchema = (0, _ramda.pipe)(newSchema, function (o) {
  return (0, _ramda.isNil)(o) ? undefined : (0, _ramda.isEmpty)(o.xs) ? o.a : getSchema(o);
});

/**
 * Given a JSON schema and a JSON pointer it gets
 * the value found at that pointer.
 *
 * Works for both properties and patternProperties
 *
 * https://tools.ietf.org/html/draft-zyp-json-schema-04
 * https://tools.ietf.org/html/rfc6901
 *
 * @function
 * @implements curry
 * @param {string} path - A JSON Path string
 * @param {object} schema - A JSON Schema object
 * @returns {any} - The value found at that path or undefined if nothing was found
 * @example
 *
 * import getSchemaPath from 'json-patch-utils'
 *
 * let schema = require('./schema.json')
 * schema.properties.foo.properties.bar.properties.baz // { type: "integer" }
 *
 * schemaPath('/foo/bar/baz', schema) // { type: "integer" }
 * schemaPath('/foo/BAM', schema) // undefined
 *
 */
var schemaPath = function schemaPath(xs, a) {
  return getSchema({ xs: (0, _listPath2.default)(xs), a: a, b: a });
};

exports.default = schemaPath;
//# sourceMappingURL=schemaPath.js.map
