'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ramda = require('ramda');

var _cursorGet = require('./cursorGet');

var _cursorGet2 = _interopRequireDefault(_cursorGet);

var _jsonschema = require('jsonschema');

var _schemaPath = require('./schemaPath');

var _schemaPath2 = _interopRequireDefault(_schemaPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var v = new _jsonschema.Validator();

var validateSchema = (0, _ramda.curry)(function (tree, schema, path) {
  var val = (0, _cursorGet2.default)(tree, path);
  var rule = (0, _schemaPath2.default)(path, schema);
  var result = v.validate(val, rule);
  if ((0, _ramda.isEmpty)(result.errors)) {
    result.isValid = true;
    return result;
  } else {
    result.isValid = false;
    return result;
  }
});

exports.default = validateSchema;
//# sourceMappingURL=validateSchema.js.map
