/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Edge
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2023 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 10.0.0
 * @date    2023-12-21
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(self,function(){return n={897:function(e,t,n){"use strict";n.d(t,{x:function(){return r}});var c=n(602),d=n(791),h=n(907);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}var r=function(){function l(t,e){if(!(this instanceof l))throw new TypeError("Cannot call a class as a function");this.dom={};var d=this,n=this.dom,e=(this.anchor=void 0,this.items=t,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0,this.limitHeight=!!e&&e.limitHeight,document.createElement("div")),i=(e.className="jsoneditor-contextmenu-root",n.root=e,document.createElement("div")),e=(i.className="jsoneditor-contextmenu",n.menu=i,e.appendChild(i),document.createElement("ul")),i=(e.className="jsoneditor-menu",i.appendChild(e),n.list=e,n.items=[],document.createElement("button")),n=(i.type="button",n.focusButton=i,document.createElement("li"));n.style.overflow="hidden",n.style.height="0",n.appendChild(i),e.appendChild(n),function a(l,c,e){e.forEach(function(t){var n,e,i,o,r,s;"separator"===t.type?((r=document.createElement("div")).className="jsoneditor-separator",(e=document.createElement("li")).appendChild(r),l.appendChild(e)):(n={},r=document.createElement("li"),l.appendChild(r),(e=document.createElement("button")).type="button",e.className=t.className,n.button=e,t.title&&(e.title=t.title),t.click&&(e.onclick=function(e){e.preventDefault(),d.hide(),t.click()}),r.appendChild(e),t.submenu?((o=document.createElement("div")).className="jsoneditor-icon",e.appendChild(o),(o=document.createElement("div")).className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),o.appendChild(document.createTextNode(t.text)),e.appendChild(o),(i=t.click?(e.className+=" jsoneditor-default",(o=document.createElement("button")).type="button",(n.buttonExpand=o).className="jsoneditor-expand",(s=document.createElement("div")).className="jsoneditor-expand",o.appendChild(s),r.appendChild(o),t.submenuTitle&&(o.title=t.submenuTitle),o):((s=document.createElement("div")).className="jsoneditor-expand",e.appendChild(s),e)).onclick=function(e){e.preventDefault(),d._onExpandItem(n),i.focus()},n.subItems=o=[],s=document.createElement("ul"),(n.ul=s).className="jsoneditor-menu",s.style.height="0",r.appendChild(s),a(s,o,t.submenu)):((r=document.createElement("div")).className="jsoneditor-icon",e.appendChild(r),(s=document.createElement("div")).className="jsoneditor-text",s.appendChild(document.createTextNode((0,h.Iu)(t.text))),e.appendChild(s)),c.push(n))})}(e,this.dom.items,t),this.maxHeight=0,t.forEach(function(e){e=24*(t.length+(e.submenu?e.submenu.length:0));d.maxHeight=Math.max(d.maxHeight,e)})}var e,t,n;return e=l,(t=[{key:"_getVisibleButtons",value:function(){var t=[],n=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e===n.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t}},{key:"show",value:function(e,t,n){this.hide();var i=!0,o=e.parentNode,r=e.getBoundingClientRect(),o=o.getBoundingClientRect(),s=t.getBoundingClientRect(),a=this,t=(this.dom.absoluteAnchor=(0,c.w)(e,t,function(){a.hide()}),r.bottom+this.maxHeight<s.bottom||r.top-this.maxHeight>s.top&&(i=!1),n?0:r.top-o.top);i?(n=e.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=t+n+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px"),this.limitHeight&&(o=i?s.bottom-r.bottom-10:r.top-s.top-10,this.dom.list.style.maxHeight=o+"px",this.dom.list.style.overflowY="auto"),this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=(0,d.getSelection)(),this.anchor=e,setTimeout(function(){a.dom.focusButton.focus()},0),l.visibleMenu&&l.visibleMenu.hide(),l.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose)&&this.onClose(),l.visibleMenu===this&&(l.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(n){var i,o=this,e=n===this.expandedItem,t=this.expandedItem;t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){o.expandedItem!==t&&(t.ul.style.display="",d.removeClassName)(t.ul.parentNode,"jsoneditor-selected")},300),this.expandedItem=void 0),e||((i=n.ul).style.display="block",i.clientHeight,setTimeout(function(){if(o.expandedItem===n){for(var e=0,t=0;t<i.childNodes.length;t++)e+=i.childNodes[t].clientHeight;i.style.height=e+"px",i.style.padding="5px 10px"}},0),(0,d.addClassName)(i.parentNode,"jsoneditor-selected"),this.expandedItem=n)}},{key:"_onKeyDown",value:function(e){var t,n,i,o,r=e.target,s=e.which,a=!1;27===s?(this.selection&&(0,d.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9===s?e.shiftKey?0===(n=(t=this._getVisibleButtons()).indexOf(r))&&(t[t.length-1].focus(),a=!0):(n=(t=this._getVisibleButtons()).indexOf(r))===t.length-1&&(t[0].focus(),a=!0):37===s?("jsoneditor-expand"===r.className&&(n=(t=this._getVisibleButtons()).indexOf(r),i=t[n-1])&&i.focus(),a=!0):38===s?(n=(t=this._getVisibleButtons()).indexOf(r),(i=(i=(i=t[n-1])&&"jsoneditor-expand"===i.className?t[n-2]:i)||t[t.length-1])&&i.focus(),a=!0):39===s?(n=(t=this._getVisibleButtons()).indexOf(r),(o=t[n+1])&&"jsoneditor-expand"===o.className&&o.focus(),a=!0):40===s&&(n=(t=this._getVisibleButtons()).indexOf(r),(o=(o=(o=t[n+1])&&"jsoneditor-expand"===o.className?t[n+2]:o)||t[0])&&(o.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())}}])&&i(e.prototype,t),n&&i(e,n),Object.defineProperty(e,"prototype",{writable:!1}),l}();r.visibleMenu=void 0},436:function(e,t,n){"use strict";function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}n.d(t,{Q:function(){return i}});var i=function(){function n(e){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=e.errorTableVisible,this.onToggleVisibility=e.onToggleVisibility,this.onFocusLine=e.onFocusLine||function(){},this.onChangeHeight=e.onChangeHeight,this.dom={};var e=document.createElement("div"),t=(e.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=e,document.createElement("div")),e=(t.style.display="none",t.className="jsoneditor-additional-errors fadein",t.textContent="Scroll for more ▿",this.dom.additionalErrorsIndication=t,e.appendChild(t),document.createElement("span")),t=(e.className="jsoneditor-validation-error-icon",e.style.display="none",this.dom.validationErrorIcon=e,document.createElement("span"));t.className="jsoneditor-validation-error-count",t.style.display="none",this.dom.validationErrorCount=t,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}var e,t,i;return e=n,(t=[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(e,r){var s,t,a=this,n=(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<e.length?((n=document.createElement("div")).className="jsoneditor-validation-errors",(t=document.createElement("table")).className="jsoneditor-text-errors",n.appendChild(t),s=document.createElement("tbody"),t.appendChild(s),e.forEach(function(t){isNaN(t.line)?t.dataPath&&(n=r.find(function(e){return e.path===t.dataPath}))&&(e=n.line+1):e=t.line;var e,n=document.createElement("tr"),i=(n.className=isNaN(e)?"":"jump-to-line","error"===t.type?n.className+=" parse-error":n.className+=" validation-error",document.createElement("td")),o=document.createElement("button"),o=(o.className="jsoneditor-schema-error",i.appendChild(o),n.appendChild(i),document.createElement("td"));o.style="white-space: nowrap;",o.textContent=isNaN(e)?"":"Ln "+e,n.appendChild(o),"string"==typeof t?((i=document.createElement("td")).colSpan=2,(o=document.createElement("pre")).appendChild(document.createTextNode(t)),i.appendChild(o),n.appendChild(i)):((o=document.createElement("td")).appendChild(document.createTextNode(t.dataPath||"")),n.appendChild(o),i=document.createElement("td"),(o=document.createElement("pre")).appendChild(document.createTextNode(t.message.replace(/<br>/gi,"\n"))),i.appendChild(o),n.appendChild(i)),n.onclick=function(){a.onFocusLine(e)},s.appendChild(n)}),this.dom.validationErrors=n,this.dom.validationErrorsContainer.appendChild(n),this.dom.additionalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){a.dom.additionalErrorsIndication.style.display=0<a.dom.validationErrorsContainer.clientHeight&&0===a.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0,t=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0),this.onChangeHeight(t)):this.onChangeHeight(0),e.filter(function(e){return"error"!==e.type}).length);0<n?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=n,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=n+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),e.some(function(e){return"error"===e.type})?(t=e[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(t)?"parse error - check that the json is valid":"parse error on line "+t,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}])&&r(e.prototype,t),i&&r(e,i),Object.defineProperty(e,"prototype",{writable:!1}),n}()},474:function(e,t,n){"use strict";function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}n.d(t,{R:function(){return i}});var i=function(){function t(e){if(!(this instanceof t))throw new TypeError("Cannot call a class as a function");if(this.target=e.target||null,!this.target)throw new Error('FocusTracker constructor called without a "target" to track.');this.onFocus="function"==typeof e.onFocus?e.onFocus:null,this.onBlur="function"==typeof e.onBlur?e.onBlur:null,this._onClick=this._onEvent.bind(this),this._onKeyUp=function(e){9!==e.which&&9!==e.keyCode||this._onEvent(e)}.bind(this),this._onBlur=this._onEvent.bind(this),this.focusFlag=!1,this.firstEventFlag=!0,(this.onFocus||this.onBlur)&&(document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp),document.addEventListener("blur",this._onBlur))}var e,n,i;return e=t,(n=[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick),document.removeEventListener("keyup",this._onKeyUp),document.removeEventListener("blur",this._onBlur),this._onEvent({target:document.body})}},{key:"_onEvent",value:function(e){e=e.target,e=e===this.target||!(!this.target.contains(e)&&!this.target.contains(document.activeElement));e?this.focusFlag||(this.onFocus&&this.onFocus({type:"focus",target:this.target}),this.focusFlag=!0):(this.focusFlag||this.firstEventFlag)&&(this.onBlur&&this.onBlur({type:"blur",target:this.target}),this.focusFlag=!1,this.firstEventFlag)&&(this.firstEventFlag=!1)}}])&&r(e.prototype,n),i&&r(e,i),Object.defineProperty(e,"prototype",{writable:!1}),t}()},161:function(e,t,o){"use strict";var n=o(170),i=o(37),r=o(38).treeModeMixins,s=o(458).textModeMixins,a=o(341).previewModeMixins,l=o(791),c=l.clear,d=l.extend,h=l.getInnerText,u=l.getInternetExplorerVersion,p=l.parse,l=o(744).tryRequireAjv,m=o(558).showTransformModal,f=o(210).showSortModal,g=l();function v(e,t,n){if(!(this instanceof v))throw new Error('JSONEditor constructor called without "new".');var i=u();if(-1!==i&&i<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"===t.mode||"code"===t.mode||t.modes&&(-1!==t.modes.indexOf("text")||-1!==t.modes.indexOf("code")))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),t)&&Object.keys(t).forEach(function(e){-1===v.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')}),arguments.length&&this._create(e,t,n)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),v.modes={},v.prototype.DEBOUNCE_INTERVAL=150,v.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onExpand","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","onFocus","onBlur","colorPicker","onColorPicker","timestampTag","timestampFormat","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","limitDragging","maxVisibleChilds","onValidationError","modalAnchor","popupAnchor","createQuery","executeQuery","queryDescription","allowSchemaSuggestions","showErrorTable"],v.prototype._create=function(e,t,n){this.container=e,this.options=t||{},this.json=n||{};e=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(e)},v.prototype.destroy=function(){},v.prototype.set=function(e){this.json=e},v.prototype.get=function(){return this.json},v.prototype.setText=function(e){this.json=p(e)},v.prototype.getText=function(){return JSON.stringify(this.json)},v.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},v.prototype.getName=function(){return this.options&&this.options.name},v.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t=this.container,n=d({},this.options),i=n.mode,o=(n.mode=e,v.modes[e]);if(!o)throw new Error('Unknown mode "'+n.mode+'"');var r="text"===o.data,s=this.getName(),a=this[r?"getText":"get"]();if(this.destroy(),c(this),d(this,o.mixin),this.create(t,n),this.setName(s),this[r?"setText":"set"](a),"function"==typeof o.load)try{o.load.call(this)}catch(e){console.error(e)}if("function"==typeof n.onModeChange&&e!==i)try{n.onModeChange(e,i)}catch(e){console.error(e)}}},v.prototype.getMode=function(){return this.options.mode},v.prototype._onError=function(e){this.options&&"function"==typeof this.options.onError?this.options.onError(e):window.alert(e.toString())},v.prototype.setSchema=function(e,t){if(e){var n;try{this.options.ajv?n=this.options.ajv:((n=g({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(o(Object(function(){var e=new Error("Cannot find module 'ajv/lib/refs/json-schema-draft-04.json'");throw e.code="MODULE_NOT_FOUND",e}()))),n.addMetaSchema(o(Object(function(){var e=new Error("Cannot find module 'ajv/lib/refs/json-schema-draft-06.json'");throw e.code="MODULE_NOT_FOUND",e}()))))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(n){if(t){for(var i in t)n.removeSchema(i),t[i]&&n.addSchema(t[i],i);this.options.schemaRefs=t}this.validateSchema=n.compile(e),this.options.schema=e,this.options.schemaRefs=t,this.validate()}}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate();this.refresh(),"function"==typeof this._onSchemaChange&&this._onSchemaChange(e,t)},v.prototype.validate=function(){},v.prototype.refresh=function(){},(v.registerMode=function(e){var t;if(Array.isArray(e))for(o=0;o<e.length;o++)v.registerMode(e[o]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var n=e.mode;if(n in v.modes)throw new Error('Mode "'+n+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');for(var i=["setMode","registerMode","modes"],o=0;o<i.length;o++)if((t=i[o])in e.mixin)throw new Error('Reserved property "'+t+'" not allowed in mixin');v.modes[n]=e}})(r),v.registerMode(s),v.registerMode(a),v.ace=n,v.Ajv=g,v.VanillaPicker=i,v.showTransformModal=m,v.showSortModal=f,v.getInnerText=h,e.exports=v.default=v},617:function(e,t,n){"use strict";n.d(t,{x:function(){return r}});var u=n(897),p=n(907);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}var r=function(){function h(e,t,n,i){if(!(this instanceof h))throw new TypeError("Cannot call a class as a function");for(var o={code:{text:(0,p.Iu)("modeCodeText"),title:(0,p.Iu)("modeCodeTitle"),click:function(){i("code")}},form:{text:(0,p.Iu)("modeFormText"),title:(0,p.Iu)("modeFormTitle"),click:function(){i("form")}},text:{text:(0,p.Iu)("modeTextText"),title:(0,p.Iu)("modeTextTitle"),click:function(){i("text")}},tree:{text:(0,p.Iu)("modeTreeText"),title:(0,p.Iu)("modeTreeTitle"),click:function(){i("tree")}},view:{text:(0,p.Iu)("modeViewText"),title:(0,p.Iu)("modeViewTitle"),click:function(){i("view")}},preview:{text:(0,p.Iu)("modePreviewText"),title:(0,p.Iu)("modePreviewTitle"),click:function(){i("preview")}}},r=[],s=0;s<t.length;s++){var a=t[s],l=o[a];if(!l)throw new Error('Unknown mode "'+a+'"');l.className="jsoneditor-type-modes"+(n===a?" jsoneditor-selected":""),r.push(l)}var c=o[n];if(!c)throw new Error('Unknown mode "'+n+'"');var c=c.text,d=document.createElement("button"),c=(d.type="button",d.className="jsoneditor-modes jsoneditor-separator",d.textContent=c+" ▾",d.title=(0,p.Iu)("modeEditorTitle"),d.onclick=function(){new u.x(r).show(d,e)},document.createElement("div"));c.className="jsoneditor-modes",c.style.position="relative",c.appendChild(d),e.appendChild(c),this.dom={container:e,box:d,frame:c}}var e,t,n;return e=h,(t=[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}])&&i(e.prototype,t),n&&i(e,n),Object.defineProperty(e,"prototype",{writable:!1}),h}()},170:function(e,t,n){var i;if(window.ace)i=window.ace;else try{i=n(Object(function(){var e=new Error("Cannot find module 'ace-builds/src-noconflict/ace'");throw e.code="MODULE_NOT_FOUND",e}())),n(Object(function(){var e=new Error("Cannot find module 'ace-builds/src-noconflict/mode-json'");throw e.code="MODULE_NOT_FOUND",e}())),n(Object(function(){var e=new Error("Cannot find module 'ace-builds/src-noconflict/ext-searchbox'");throw e.code="MODULE_NOT_FOUND",e}())),n(Object(function(){var e=new Error("Cannot find module 'ace-builds/src-noconflict/ext-language_tools'");throw e.code="MODULE_NOT_FOUND",e}()));var o=n(Object(function(){var e=new Error("Cannot find module '../generated/worker-json-data-url'");throw e.code="MODULE_NOT_FOUND",e}()));i.config.setModuleUrl("ace/mode/json_worker",o)}catch(e){}e.exports=i},864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,n){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})},589:function(e,t){(n={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,n,i,o,r,s){var a=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[a-1];case 13:this.$={};break;case 14:this.$=r[a-1];break;case 15:this.$=[r[a-2],r[a]];break;case 16:this.$={},this.$[r[a][0]]=r[a][1];break;case 17:this.$=r[a-2],r[a-2][r[a][0]]=r[a][1];break;case 18:this.$=[];break;case 19:this.$=r[a-1];break;case 20:this.$=[r[a]];break;case 21:this.$=r[a-2],r[a-2].push(r[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){var t=this,n=[0],i=[null],o=[],r=this.table,s="",a=0,l=0,c=0,d=(this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={}),this.lexer.yylloc);function h(){var e=t.lexer.lex()||1;return e="number"!=typeof e?t.symbols_[e]||e:e}o.push(d),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var u,p,m,f,g,v,y,b,x,C={};;){if(m=n[n.length-1],void 0===(f=this.defaultActions[m]||(null==u&&(u=h()),r[m]&&r[m][u]))||!f.length||!f[0]){if(!c){for(g in b=[],r[m])this.terminals_[g]&&2<g&&b.push("'"+this.terminals_[g]+"'");var T="",T=this.lexer.showPosition?"Parse error on line "+(a+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+b.join(", ")+", got '"+this.terminals_[u]+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==u?"end of input":"'"+(this.terminals_[u]||u)+"'");this.parseError(T,{text:this.lexer.match,token:this.terminals_[u]||u,line:this.lexer.yylineno,loc:d,expected:b})}if(3==c){if(1==u)throw new Error(T||"Parsing halted.");l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,d=this.lexer.yylloc,u=h()}for(;;){if(2..toString()in r[m])break;if(0==m)throw new Error(T||"Parsing halted.");x=1,n.length=n.length-2*x,i.length=i.length-x,o.length=o.length-x,m=n[n.length-1]}p=u,u=2,f=r[m=n[n.length-1]]&&r[m][2],c=3}if(f[0]instanceof Array&&1<f.length)throw new Error("Parse Error: multiple actions possible at state: "+m+", token: "+u);switch(f[0]){case 1:n.push(u),i.push(this.lexer.yytext),o.push(this.lexer.yylloc),n.push(f[1]),u=null,p?(u=p,p=null):(l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,d=this.lexer.yylloc,0<c&&c--);break;case 2:if(v=this.productions_[f[1]][1],C.$=i[i.length-v],C._$={first_line:o[o.length-(v||1)].first_line,last_line:o[o.length-1].last_line,first_column:o[o.length-(v||1)].first_column,last_column:o[o.length-1].last_column},void 0!==(y=this.performAction.call(C,s,l,a,this.yy,f[1],i,o)))return y;v&&(n=n.slice(0,-1*v*2),i=i.slice(0,-1*v),o=o.slice(0,-1*v)),n.push(this.productions_[f[1]][0]),i.push(C.$),o.push(C._$),y=r[n[n.length-2]][n[n.length-1]],n.push(y);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var e,t,n,i,o=this._currentRules(),r=0;r<o.length&&(!(t=this._input.match(this.rules[o[r]]))||e&&!(t[0].length>e[0].length)||(e=t,n=r,this.options.flex));r++);return e?((i=e[0].match(/\n.*/g))&&(this.yylineno+=i.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:i?i[i.length-1].length-1:this.yylloc.last_column+e[0].length},this.yytext+=e[0],this.match+=e[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(e[0].length),this.matched+=e[0],i=this.performAction.call(this,this.yy,this,o[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),i||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,n,i){switch(n){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}};var n;t.parser=n,t.parse=n.parse.bind(n)},879:function(e){"use strict";function i(){}i.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},i.mixin=function(e){for(var t=["on","off","emit"],n=0;n<t.length;n++)"function"==typeof e?e.prototype[t[n]]=i.prototype[t[n]]:e[t[n]]=i.prototype[t[n]];return e};var u={escapeRegExp:function(e){var t=/[\\^$.*+?()[\]{}|]/g,n=new RegExp(t.source);return e&&n.test(e)?e.replace(t,"\\$&"):e},extend:function(e,t){for(var n in t){var i;t.hasOwnProperty(n)&&((i=t[n])&&"[object Object]"===Object.prototype.toString.call(i)?(e[n]=e[n]||{},u.extend(e[n],i)):e[n]=i)}return e},each:function(e,t,n){if("[object Object]"===Object.prototype.toString.call(e))for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&t.call(n,i,e[i],e);else for(var o=0,r=e.length;o<r;o++)t.call(n,o,e[o],e)},createElement:function(e,t){var n,i=document.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(n in t)n in i?i[n]=t[n]:"html"===n?i.innerHTML=t[n]:i.setAttribute(n,t[n]);return i},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){u.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){u.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:u.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(i,o,r){var s;return function(){var e=this,t=arguments,n=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||i.apply(e,t)},o),n&&i.apply(e,t)}},rect:function(e,t){var n=window,e=e.getBoundingClientRect(),i=t?n.pageXOffset:0,t=t?n.pageYOffset:0;return{bottom:e.bottom+t,height:e.height,left:e.left+i,right:e.right+i,top:e.top+t,width:e.width}},includes:function(e,t){return-1<e.indexOf(t)},startsWith:function(e,t){return e.substr(0,t.length)===t},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}};function d(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function p(e,t,n){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),u.removeClass(e,"excluded"),n||(e.textContent=e.textContent)}function o(){var n,e;this.items.length&&(n=document.createDocumentFragment(),this.config.pagination?(e=this.pages.slice(0,this.pageIndex),u.each(e,function(e,t){u.each(t,function(e,t){p(t,n,this.customOption)},this)},this)):u.each(this.items,function(e,t){p(t,n,this.customOption)},this),n.childElementCount&&(u.removeClass(this.items[this.navIndex],"active"),this.navIndex=(n.querySelector(".selectr-option.selected")||n.querySelector(".selectr-option")).idx,u.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(n))}function h(e,t){t=t||e;var n={class:"selectr-option",role:"treeitem","aria-selected":!1};return this.customOption?n.html=this.config.renderOption(t):n.textContent=e.textContent,(t=u.createElement("li",n)).idx=e.idx,this.items.push(t),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(t.disabled=!0,u.addClass(t,"disabled")),t}function r(){var n,e=this.tree,t=e.scrollTop;e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length&&(n=document.createDocumentFragment(),u.each(this.pages[this.pageIndex],function(e,t){p(t,n,this.customOption)},this),e.appendChild(n),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length}))}function s(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&u.removeClass(this.inputContainer,"active"),u.hasClass(this.container,"notice")&&(u.removeClass(this.container,"notice"),u.addClass(this.container,"open"),this.input.focus()),u.each(this.items,function(e,t){u.removeClass(t,"excluded"),this.customOption||(t.textContent=t.textContent)},this))}function t(e,t){if(!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}t.prototype.render=function(e){var t;this.rendered||((this.el.selectr=this).config=u.extend({defaultSelected:!0,width:"auto",disabled:!1,disabledMobile:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,nativeKeyboard:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag...",messages:{noResults:"No results.",noOptions:"No options available.",maxSelections:"A maximum of {max} items can be selected.",tagDuplicate:"That tag is already in use.",searchPlaceholder:"Search options..."}},e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=d(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,!this.config.disabledMobile&&/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,this.supportsEventPassiveOption=this.detectEventPassiveOption(),i.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,d(this.config,"width")&&(u.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":u.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=u.createElement("div",{class:"selectr-container"}),this.config.customClass&&u.addClass(this.container,this.config.customClass),this.mobileDevice?u.addClass(this.container,"selectr-mobile"):u.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?u.addClass(this.el,"selectr-visible"):u.addClass(this.el,"selectr-hidden"),this.selected=u.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:0,"aria-expanded":!1}),this.label=u.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=u.createElement("div",{class:"selectr-options-container"});if(this.tree=u.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=u.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple?(u.addClass(this.label,"selectr-tags"),u.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.config.defaultSelected?this.getSelectedProperties("value"):[],this.selectedIndexes=this.getSelectedProperties("idx")):(this.selectedValue=null,this.selectedIndex=-1),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=u.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),u.addClass(this.container,"clearable")),this.config.taggable){var t=u.createElement("li",{class:"input-tag"});if(this.input=u.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),u.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators){this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators);for(var n=[],i=0;i<this.tagSeperators.length;i++)n.push(u.escapeRegExp(this.tagSeperators[i]));this.tagSeperatorsRegex=new RegExp(n.join("|"),"i")}else this.tagSeperatorsRegex=new RegExp(",","i")}this.config.searchable&&(this.input=u.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search",placeholder:this.config.messages.searchPlaceholder}),this.inputClear=u.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=u.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var o,r,s,a=!1,l=0;this.el.children.length&&u.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(a=u.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),u.each(t.children,function(e,t){t.idx=l,a.appendChild(h.call(this,t,a)),l++},this)):(t.idx=l,h.call(this,t),l++)},this),this.config.data&&Array.isArray(this.config.data)&&(o=!(this.data=[]),a=!1,l=0,u.each(this.config.data,function(e,t){d(t,"children")?(o=u.createElement("optgroup",{label:t.text}),a=u.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),u.each(t.children,function(e,t){(r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=d(t,"disabled"),this.options.push(r),o.appendChild(r),r.idx=l,a.appendChild(h.call(this,r,t)),this.data[l]=t,l++},this),this.el.appendChild(o)):((r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=d(t,"disabled"),this.options.push(r),r.idx=l,h.call(this,r,t),this.data[l]=t,l++)},this)),this.setSelected(!0);for(var c=this.navIndex=0;c<this.items.length;c++)if(s=this.items[c],!u.hasClass(s,"disabled")){u.addClass(s,"active"),this.navIndex=c;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=u.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=u.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex),t=this,setTimeout(function(){t.emit("selectr.init")},20))},t.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},t.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},t.prototype.detectEventPassiveOption=function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){e=!0}});window.addEventListener("test",null,t)}catch(e){}return e},t.prototype.bindEvents=function(){var n,i=this;this.events={},this.events.dismiss=function(e){e=e.target;this.container.contains(e)||!this.opened&&!u.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&u.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.noResults||this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,n=this.items[this.navIndex],i=this.navIndex;switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:this.navIndex<this.items.length-(t=1)&&this.navIndex++}for(this.navigating=!0;u.hasClass(this.items[this.navIndex],"disabled")||u.hasClass(this.items[this.navIndex],"excluded");){if(!(0<this.navIndex&&this.navIndex<this.items.length-1)){this.navIndex=i;break}if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}}e=u.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:e.top+e.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(e.top+e.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&r.call(this)):0===this.navIndex?this.tree.scrollTop=0:e.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(e.top-this.optsRect.top)),n&&u.removeClass(n,"active"),u.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),(this.config.nativeDropdown||this.mobileDevice)&&(this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===i.el&&i.toggle()},!!this.supportsEventPassiveOption&&{passive:!0}),this.container.addEventListener("click",function(e){e.target===i.el&&i.toggle()}),this.el.addEventListener("change",function(e){e.__selfTriggered||(i.el.multiple?(e=i.getSelectedProperties("idx"),e=function(e,t){for(var n,i=[],o=e.slice(0),r=0;r<t.length;r++)-1<(n=o.indexOf(t[r]))?o.splice(n,1):i.push(t[r]);return[i,o]}(i.selectedIndexes,e),u.each(e[0],function(e,t){i.select(t)},i),u.each(e[1],function(e,t){i.deselect(t)},i)):-1<i.el.selectedIndex&&i.select(i.el.selectedIndex))})),this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&i.selected===document.activeElement&&(i.toggle(),setTimeout(function(){i.el.focus()},200))}),this.selected.addEventListener("click",function(e){i.disabled||i.toggle(),e.preventDefault()}),this.config.nativeKeyboard&&(n="",this.selected.addEventListener("keydown",function(e){var t;i.disabled||i.selected!==document.activeElement||e.altKey||e.ctrlKey||e.metaKey||(" "===e.key||!i.opened&&-1<["Enter","ArrowUp","ArrowDown"].indexOf(e.key)?(i.toggle(),e.preventDefault(),e.stopPropagation()):e.key.length<=2&&String[String.fromCodePoint?"fromCodePoint":"fromCharCode"](e.key[String.codePointAt?"codePointAt":"charCodeAt"](0))===e.key&&(i.config.multiple?(i.open(),i.config.searchable&&(i.input.value=e.key,i.input.focus(),i.search(null,!0))):(n+=e.key,(t=i.search(n,!0))&&t.length&&(i.clear(),i.setValue(t[0].value)),setTimeout(function(){n=""},1e3)),e.preventDefault(),e.stopPropagation()))}),this.container.addEventListener("keyup",function(e){i.opened&&"Escape"===e.key&&(i.close(),e.stopPropagation(),i.selected.focus())})),this.label.addEventListener("click",function(e){u.hasClass(e.target,"selectr-tag-remove")&&i.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){var t=u.closest(e.target,function(e){return e&&u.hasClass(e,"selectr-option")});t&&!u.hasClass(t,"disabled")&&(u.hasClass(t,"selected")?(i.el.multiple||!i.el.multiple&&i.config.allowDeselect)&&i.deselect(t.idx):i.select(t.idx),i.opened&&!i.el.multiple)&&i.close(),e.preventDefault(),e.stopPropagation()}),this.tree.addEventListener("mouseover",function(e){!u.hasClass(e.target,"selectr-option")||u.hasClass(e.target,"disabled")||(u.removeClass(i.items[i.navIndex],"active"),u.addClass(e.target,"active"),i.navIndex=[].slice.call(i.items).indexOf(e.target))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){i.searching=!0}),this.input.addEventListener("blur",function(e){i.searching=!1}),this.input.addEventListener("keyup",function(e){i.search(),i.config.taggable||(this.value.length?u.addClass(this.parentNode,"active"):u.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){i.input.value=null,s.call(i),i.tree.childElementCount||o.call(i)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){var t,n;i.search(),i.config.taggable&&this.value.length&&(t=this.value.trim()).length&&(13===e.which||i.tagSeperatorsRegex.test(t))&&(e=t.replace(i.tagSeperatorsRegex,""),(n=(e=(e=u.escapeRegExp(e)).trim()).length?i.add({value:e,textContent:e,selected:!0},!0):n)?(i.close(),s.call(i)):(this.value="",i.setMessage(i.config.messages.tagDuplicate)))}),this.update=u.debounce(function(){i.opened&&i.config.closeOnScroll&&i.close(),i.width&&(i.container.style.width=i.width),i.invert()},50),this.requiresPagination&&(this.paginateItems=u.debounce(function(){r.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.on("selectr.destroy",function(){document.removeEventListener("click",this.events.dismiss),window.removeEventListener("keydown",this.events.navigate),window.removeEventListener("resize",this.update),window.removeEventListener("scroll",this.update)}),this.el.form&&(this.el.form.addEventListener("reset",this.events.reset),this.on("selectr.destroy",function(){this.el.form.removeEventListener("reset",this.events.reset)}))},t.prototype.setSelected=function(e){var n;this.config.data||this.el.multiple||!this.el.options.length||(0!==this.el.selectedIndex||this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),u.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data&&(!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&0<this.config.data.length&&this.select(0),n=0,u.each(this.config.data,function(e,t){d(t,"children")?u.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(n),n++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(n),n++)},this))},t.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),u.removeClass(this.el,"selectr-hidden"),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1,delete this.el.selectr)},t.prototype.change=function(e){var t=this.items[e],n=this.options[e];n.disabled||(n.selected&&u.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},t.prototype.select=function(i){var e=this.items[i],t=[].slice.call(this.el.options),n=this.options[i];if(this.el.multiple){if(u.includes(this.selectedIndexes,i))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage(this.config.messages.maxSelections.replace("{max}",this.config.maxSelections),!0),!1;this.selectedValues.push(n.value),this.selectedIndexes.push(i),!function(e){var l,c=this,n=document.createDocumentFragment(),t=this.options[e.idx],i=this.data?this.data[e.idx]:t,o={class:"selectr-tag"},i=(this.customSelected?o.html=this.config.renderSelection(i):o.textContent=t.textContent,u.createElement("li",o)),o=u.createElement("button",{class:"selectr-tag-remove",type:"button"});i.appendChild(o),i.idx=e.idx,i.tag=t.value,this.tags.push(i),this.config.sortSelected?(o=this.tags.slice(),l=function(e,i){e.replace(/(\d+)|(\D+)/g,function(e,t,n){i.push([t||1/0,n||""])})},o.sort(function(e,t){var n,i,o=[],r=[];for(!0===c.config.sortSelected?(n=e.tag,i=t.tag):"text"===c.config.sortSelected&&(n=e.textContent,i=t.textContent),l(n,o),l(i,r);o.length&&r.length;){var s=o.shift(),a=r.shift(),s=s[0]-a[0]||s[1].localeCompare(a[1]);if(s)return s}return o.length-r.length}),u.each(o,function(e,t){n.appendChild(t)}),this.label.innerHTML=""):n.appendChild(i),this.config.taggable?this.label.insertBefore(n,this.input.parentNode):this.label.appendChild(n)}.call(this,e)}else{var o=this.data?this.data[i]:n;this.customSelected?this.label.innerHTML=this.config.renderSelection(o):this.label.textContent=n.textContent,this.selectedValue=n.value,this.selectedIndex=i,u.each(this.options,function(e,t){var n=this.items[e];e!==i&&(n&&u.removeClass(n,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}u.includes(t,n)||this.el.add(n),e.setAttribute("aria-selected",!0),u.addClass(e,"selected"),u.addClass(this.container,"has-selected"),n.selected=!0,n.setAttribute("selected",""),this.emit("selectr.change",n),this.emit("selectr.select",n),"createEvent"in document?((o=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),o.__selfTriggered=!0,this.el.dispatchEvent(o)):this.el.fireEvent("onchange")},t.prototype.deselect=function(e,t){var n=this.items[e],i=this.options[e];if(this.el.multiple){var o=this.selectedIndexes.indexOf(e),o=(this.selectedIndexes.splice(o,1),this.selectedValues.indexOf(i.value));this.selectedValues.splice(o,1),!function(n){var i=!1;u.each(this.tags,function(e,t){t.idx===n.idx&&(i=t)},this),i&&(this.label.removeChild(i),this.tags.splice(this.tags.indexOf(i),1))}.call(this,n),this.tags.length||u.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,u.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),u.removeClass(this.items[e],"selected"),i.selected=!1,i.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",i),"createEvent"in document?((o=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),o.__selfTriggered=!0,this.el.dispatchEvent(o)):this.el.fireEvent("onchange")},t.prototype.setValue=function(n){var i=Array.isArray(n);if(i||(n=n.toString().trim()),!this.el.multiple&&i)return!1;u.each(this.options,function(e,t){(i&&-1<n.indexOf(t.value)||t.value===n)&&this.change(t.idx)},this)},t.prototype.getValue=function(e,t){var n,i;return this.el.multiple?e?this.selectedIndexes.length&&(i={values:[]},u.each(this.selectedIndexes,function(e,t){t=this.options[t];i.values[e]={value:t.value,text:t.textContent}},this)):i=this.selectedValues.slice():i=e?{value:(n=this.options[this.selectedIndex]).value,text:n.textContent}:this.selectedValue,i=e&&t?JSON.stringify(i):i},t.prototype.add=function(n,i){if(n){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(n))u.each(n,function(e,t){this.add(t,i)},this);else if("[object Object]"===Object.prototype.toString.call(n)){if(i){var o=!1;if(u.each(this.options,function(e,t){t.value.toLowerCase()===n.value.toLowerCase()&&(o=!0)}),o)return!1}var e=u.createElement("option",n);return this.data.push(n),this.mobileDevice&&this.el.add(e),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,h.call(this,e),n.selected&&this.select(e.idx),this.setPlaceholder(),e}return this.config.pagination&&this.paginate(),!0}},t.prototype.remove=function(e){var n,i=[];Array.isArray(e)?u.each(e,function(e,t){u.isInt(t)?i.push(this.getOptionByIndex(t)):"string"==typeof t&&i.push(this.getOptionByValue(t))},this):u.isInt(e)?i.push(this.getOptionByIndex(e)):"string"==typeof e&&i.push(this.getOptionByValue(e)),i.length&&(u.each(i,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);t=this.items[n].parentNode;t&&t.removeChild(this.items[n]),this.items.splice(n,1),u.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination)&&this.paginate()},t.prototype.removeAll=function(){this.clear(!0),u.each(this.el.options,function(e,t){this.el.remove(t)},this),u.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},t.prototype.search=function(a,e){var l,c,d,h,t;if(!this.navigating)return l=!1,a||(a=this.input.value,l=!0,this.removeMessage(),u.truncate(this.tree)),c=[],d=document.createDocumentFragment(),0<(a=a.trim().toLowerCase()).length?(h=e?u.startsWith:u.includes,u.each(this.options,function(e,t){var n,i,o,r,s=this.items[t.idx];h(t.textContent.trim().toLowerCase(),a)&&!t.disabled?(c.push({text:t.textContent,value:t.value}),l&&(p(s,d,this.customOption),u.removeClass(s,"excluded"),!this.customOption)&&(n=a,o=(t=t).textContent,n=new RegExp(n,"ig"),r=n.exec(o))&&(t.innerHTML="",(i=document.createElement("span")).classList.add("selectr-match"),i.textContent=r[0],t.appendChild(document.createTextNode(o.substring(0,r.index))),t.appendChild(i),t.appendChild(document.createTextNode(o.substring(n.lastIndex))))):l&&u.addClass(s,"excluded")},this),l&&(d.childElementCount?(e=this.items[this.navIndex],t=d.querySelector(".selectr-option:not(.excluded)"),this.noResults=!1,u.removeClass(e,"active"),this.navIndex=t.idx,u.addClass(t,"active")):this.config.taggable||(this.noResults=!0,this.setMessage(this.config.messages.noResults)),this.tree.appendChild(d))):o.call(this),c},t.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},t.prototype.open=function(){var e=this;if(!this.options.length)return!1;this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(u.addClass(this.container,"native-open"),this.config.data&&u.each(this.options,function(e,t){this.el.add(t)},this)):(u.addClass(this.container,"open"),o.call(this),this.invert(),this.tree.scrollTop=0,u.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))},t.prototype.close=function(){var e;this.opened&&this.emit("selectr.close"),this.opened=!1,this.navigating=!1,this.mobileDevice||this.config.nativeDropdown?u.removeClass(this.container,"native-open"):(e=u.hasClass(this.container,"notice"),this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(u.removeClass(this.container,"notice"),this.notice.textContent=""),u.removeClass(this.container,"open"),u.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),u.truncate(this.tree),s.call(this))},t.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&u.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),u.removeClass(this.container,"selectr-disabled")},t.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&u.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,u.addClass(this.container,"selectr-disabled")},t.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),u.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},t.prototype.clear=function(e,t){var n;this.el.multiple?this.selectedIndexes.length&&(n=this.selectedIndexes.slice(),t?this.deselect(n.slice(-1)[0]):u.each(n,function(e,t){this.deselect(t)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,e),this.emit("selectr.clear")},t.prototype.serialise=function(e){var i=[];return u.each(this.options,function(e,t){var n={value:t.value,text:t.textContent};t.selected&&(n.selected=!0),t.disabled&&(n.disabled=!0),i[e]=n}),e?JSON.stringify(i):i},t.prototype.serialize=function(e){return this.serialise(e)},t.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e=this.config.messages.noOptions),this.placeEl.innerHTML=e},t.prototype.paginate=function(){var n;if(this.items.length)return(n=this).pages=this.items.map(function(e,t){return t%n.config.pagination==0?n.items.slice(t,t+n.config.pagination):null}).filter(function(e){return e}),this.pages},t.prototype.setMessage=function(e,t){t&&this.close(),u.addClass(this.container,"notice"),this.notice.textContent=e},t.prototype.removeMessage=function(){u.removeClass(this.container,"notice"),this.notice.innerHTML=""},t.prototype.invert=function(){var e=u.rect(this.selected),t=this.tree.parentNode.offsetHeight,n=window.innerHeight;e.top+e.height+t>n?(u.addClass(this.container,"inverted"),this.isInverted=!0):(u.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=u.rect(this.tree)},t.prototype.getOptionByIndex=function(e){return this.options[e]},t.prototype.getOptionByValue=function(e){for(var t=!1,n=0,i=this.options.length;n<i;n++)if(this.options[n].value.trim()===e.toString().trim()){t=this.options[n];break}return t},e.exports=t},188:function(e,t,n){"use strict";n.d(t,{EX:function(){return o},WF:function(){return r},oW:function(){return s},qD:function(){return i}});var i=document.body,o=10485760,r=2e4,s=2147483648},602:function(e,t,n){"use strict";n.d(t,{w:function(){return i}});var u=n(791);function i(n,e,i){var t,o=3<arguments.length&&void 0!==arguments[3]&&arguments[3],r="function"==typeof(a=n).getRootNode?a.getRootNode():window,s={},a=n.getBoundingClientRect(),l=e.getBoundingClientRect(),c=document.createElement("div");function d(){if(
c&&c.parentNode){for(var e in c.parentNode.removeChild(c),s)t=e,Object.prototype.hasOwnProperty.call(s,t)&&((t=s[e])&&(0,u.removeEventListener)(r,e,t),delete s[e]);"function"==typeof i&&i(n)}var t}function h(e){(e=e.target)===c||(0,u.isChildOf)(e,c)||d()}return c.className="jsoneditor-anchor",c.style.position="absolute",c.style.left=a.left-l.left+"px",c.style.top=a.top-l.top+"px",c.style.width=a.width-2+"px",c.style.height=a.height-2+"px",c.style.boxSizing="border-box",e.appendChild(c),s.mousedown=(0,u.addEventListener)(r,"mousedown",h),s.mousewheel=(0,u.addEventListener)(r,"mousewheel",h),o&&(t=null,c.onmouseover=function(){clearTimeout(t),t=null},c.onmouseout=function(){t=t||setTimeout(d,200)}),c.destroy=d,c}},907:function(e,t,n){"use strict";n.d(t,{Iu:function(){return d},cC:function(){return c},m0:function(){return l}});n(987);var r={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},es:{array:"Matriz",auto:"Auto",appendText:"Agregar",appendTitle:"Agregue un nuevo campo con el tipo 'auto' después de este campo (Ctrl + Shift + Ins)",appendSubmenuTitle:"Seleccione el tipo de campo que se agregará",appendTitleAuto:"Agregue un nuevo campo con el tipo 'auto' (Ctrl + Shift + Ins)",ascending:"Ascendente",ascendingTitle:"Ordene los elementos secundarios de este ${type} en orden ascendente",actionsMenu:"Haga clic para abrir el menú de acciones (Ctrl + M)",cannotParseFieldError:"No se puede parsear el campo en JSON",cannotParseValueError:"No se puede parsear el valor en JSON",collapseAll:"Contraer todos los campos",compactTitle:"Compactar datos JSON, eliminar todos los espacios en blanco (Ctrl + Shift + I)",descending:"Descendente",descendingTitle:"Ordene los hijos de este ${type} en orden descendente",drag:"Arrastre para mover este campo (Alt + Mayús + Flechas)",duplicateKey:"llave duplicada",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos seleccionados (Ctrl + D)",duplicateField:"Duplicar este campo (Ctrl + D)",duplicateFieldError:"Nombre de campo duplicado",empty:"vacio",expandAll:"Expandir todos los campos",expandTitle:"Haga clic para expandir/contraer este campo (Ctrl + E). \n  Ctrl+Clic para expandir/contraer incluyendo todos los niños.",formatTitle:"Formatee los datos JSON, con la sangría y los avances de línea adecuados (Ctrl + I)",insert:"Insertar",insertTitle:"Inserte un nuevo campo con el tipo 'auto' antes de este campo (Ctrl + Ins)",insertSub:"Seleccione el tipo de campo a insertar",object:"Objeto",ok:"Ok",redo:"Rehacer (Ctrl+Mayús+Z)",removeText:"Eliminar",removeTitle:"Eliminar campos seleccionados (Ctrl+Supr)",removeField:"Eliminar este campo (Ctrl+Supr)",repairTitle:"Reparar JSON: corrija comillas y caracteres de escape, elimine comentarios y notación JSONP, convierta objetos JavaScript en JSON.",searchTitle:"Campos de búsqueda y valores",searchNextResultTitle:"Siguiente resultado (Entrar)",searchPreviousResultTitle:"Resultado anterior (Shift + Enter)",selectNode:"Seleccione un nodo...",showAll:"mostrar todo",showMore:"mostrar más",showMoreStatus:"mostrando ${visibleChilds} de ${totalChilds} elementos.",sort:"Ordenar",sortTitle:"Ordene los hijos de este ${type}",sortTitleShort:"Ordenar contenidos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dirección:",sortFieldTitle:"Seleccione el campo anidado por el cual ordenar la matriz u objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar el campo seleccionado en orden ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar por el campo seleccionado, en orden descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar o transformar los hijos de este ${type}",transformTitleShort:"Filtrar, ordenar o transformar contenidos",extract:"Extraer",extractTitle:"Extrae este ${type}",transformQueryTitle:"Ingrese una consulta JMESPath",transformWizardLabel:"Wizard",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Seleccione un campo",transformQueryLabel:"Consulta",transformPreviewLabel:"Vista Previa",type:"Tipo",typeTitle:"Cambiar el tipo de campo",openUrl:"Ctrl+Click o Ctrl+Enter para abrir la URL en una nueva ventana",undo:"Deshacer la última acción (Ctrl+Z)",validationCannotMove:"No se puede mover un campo a un hijo de sí mismo.",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Tipo de campo "objeto".  Un objeto contiene un conjunto desordenado de pares clave/valor.',arrayType:'Tipo de campo "matriz".  Una matriz contiene una colección ordenada de valores.',stringType:'Tipo de campo "cadena".  El tipo de campo no se determina a partir del valor,  pero siempre se devuelve como una cadena.',modeEditorTitle:"Cambiar modo de editor",modeCodeText:"Codigo",modeCodeTitle:"Cambiar al resaltador de código",modeFormText:"Formulario",modeFormTitle:"Cambiar al editor de formularios",modeTextText:"Texto",modeTextTitle:"Cambiar al editor de texto sin formato",modeTreeText:"Arbol",modeTreeTitle:"Cambiar al editor de árbol",modeViewText:"Vista",modeViewTitle:"Cambiar a la vista de árbol",modePreviewText:"Vista Previa",modePreviewTitle:"Cambiar al modo de vista previa",examples:"Ejemplos",default:"Predeterminado",containsInvalidProperties:"Contiene propiedades no validas",containsInvalidItems:"Contiene items no validos"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",collapseAll:"缩进所有字段",compactTitle:"压缩JSON数据，删除所有空格 (Ctrl+Shift+I)",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",formatTitle:"使用适当的缩进和换行符格式化JSON数据 (Ctrl+I)",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",repairTitle:"修复JSON：修复引号和转义符，删除注释和JSONP表示法，将JavaScript对象转换为JSON。",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省",containsInvalidProperties:"包含无效的属性",containsInvalidItems:"包含无效项目"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espaços em branco (Ctrl+Shift+I)",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova comentários e notação JSONP, transforme objetos JavaScript em JSON.",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia",containsInvalidProperties:"Contém propriedades inválidas",containsInvalidItems:"Contém itens inválidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan",containsInvalidProperties:"Geçersiz özellikler içeriyor",containsInvalidItems:"Geçersiz öğeler içeriyor"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:"クリックしてフィールドを展開/折りたたむ (Ctrl+E). \nCtrl+Click ですべての子要素を展開/折りたたむ",insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト",containsInvalidProperties:"無効なプロパティが含まれています",containsInvalidItems:"無効なアイテムが含まれています"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:"Étendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour étendre/regrouper avec tous les champs.",insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:'Champ de type "chaîne". Ce type de champ n\'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.',modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut",containsInvalidProperties:"Contient des propriétés non valides",containsInvalidItems:"Contient des éléments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anhängen",appendTitle:"Fügen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",appendSubmenuTitle:"Wählen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzufügen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum Öffnen des Aktionsmenüs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schlüssel",duplicateText:"Duplikat",duplicateTitle:"Ausgewählte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:"Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). \nStrg+Klicken Sie, um dieses Feld einschließlich aller Elemente zu erweitern/zu kollabieren.",formatTitle:"JSON-Daten mit korrekter Einrückung und Zeilenvorschüben formatieren (Strg+\\)",insert:"einfügen",insertTitle:"Fügen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"Wählen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgewählte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anführungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",searchTitle:"Suchfelder und Werte",searchNextResultTitle:"Nächstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"Wählen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"Wählen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgewählte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgewählte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder auswählen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"Ändern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu öffnen",undo:"Letzte Aktion rückgängig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enthält eine ungeordnete Menge von Schlüssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enthält eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zurückgegeben.',modeEditorTitle:"Editor-Modus umschalten",modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor für einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele",default:"Standardmäßig",containsInvalidProperties:"Enthält ungültige Eigenschaften",containsInvalidItems:"Enthält ungültige Elemente"},ru:{array:"Массив",auto:"Авто",appendText:"Добавить",appendTitle:"Добавить новое поле с типом 'авто' после этого поля (Ctrl+Shift+Ins)",appendSubmenuTitle:"Выбрать тип поля для добавления",appendTitleAuto:"Добавить новое поле с типом 'авто' (Ctrl+Shift+Ins)",ascending:"По возрастанию",ascendingTitle:"Сортировать ${type} по возрастанию",actionsMenu:"Нажмите для открытия меню действий (Ctrl+M)",cannotParseFieldError:"Невозможно преобразовать поле в JSON",cannotParseValueError:"Невозможно преобразовать значение в JSON",collapseAll:"Свернуть все",compactTitle:"Минификация JSON (Ctrl+Shift+I)",descending:"По убыванию",descendingTitle:"Сортировать ${type} по убыванию",drag:"Потяните для перемещения этого поля (Alt+Shift+Arrows)",duplicateKey:"повторяющийся ключ",duplicateText:"Дублировать",duplicateTitle:"Дублирование полей (Ctrl+D)",duplicateField:"Дублировать поле (Ctrl+D)",duplicateFieldError:"Дублирование названия поля",empty:"пустой",expandAll:"Развернуть все",expandTitle:"Нажмите для раскрытия/скрытия поля (Ctrl+E)\nили Ctrl+Click для раскрытия/скрытия всех потомков.",formatTitle:"Форматирование JSON (Ctrl+I)",insert:"Вставить",insertTitle:"Вставить новое поле с типом 'авто' перед этим полем (Ctrl+Ins)",insertSub:"Выбрать тип поля для вставки",object:"Объект",ok:"ОК",redo:"Повторить (Ctrl+Shift+Z)",removeText:"Удалить",removeTitle:"Удалить выбранные поля (Ctrl+Del)",removeField:"Удалить поле (Ctrl+Del)",repairTitle:"Восстановите JSON: исправьте кавычки и escape-символы, удалите комментарии и нотацию JSONP, модифицируйте объекты JavaScript в JSON.",searchTitle:"Поиск",searchNextResultTitle:"Следующий результат (Enter)",searchPreviousResultTitle:"Предыдущий результат (Shift + Enter)",selectNode:"Выбор узла...",showAll:"показать все",showMore:"больше",showMoreStatus:"${visibleChilds} из ${totalChilds}",sort:"Сортировка",sortTitle:"Сортировка потомков типа ${type}",sortTitleShort:"Сортировка содержимого",sortFieldLabel:"Поле:",sortDirectionLabel:"Направление:",sortFieldTitle:"Выберите поле для сортировки массива или объекта",sortAscending:"По возрастанию",sortAscendingTitle:"Сортировка выбранного поря по возрастанию",sortDescending:"По убыванию",sortDescendingTitle:"Сортировка выбранного поря по убыванию",string:"Строка",transform:"Модификация",transformTitle:"Фильтрация, сортировка или модификация данных типа ${type}",transformTitleShort:"Фильтрация, сортировка или модификация данных",extract:"Извлечение",extractTitle:"Извлечь тип ${type}",transformQueryTitle:"Введите JMESpath запрос",transformWizardLabel:"Мастер",transformWizardFilter:"Фильтр",transformWizardSortBy:"Сортировка",transformWizardSelectFields:"Поля",transformQueryLabel:"Запрос",transformPreviewLabel:"Просмотр",type:"Тип",typeTitle:"Изменить тип этого поля",openUrl:"Ctrl+Click или Ctrl+Enter для открытия url в новом окне",undo:"Отменить (Ctrl+Z)",validationCannotMove:"Поле не может быть перемещено в потомка",autoType:"Тип поля автоматически определяется по значению и может быть строкой, числом, логическим значением или null.",objectType:"Объект содержит неупорядоченный набор пар ключ/значение.",arrayType:"Массив содержит упорядоченный набор значений.",stringType:"Тип поля не определяется из значения, но всегда возвращается как строка.",modeEditorTitle:"Переключение режима редактора",modeCodeText:"Код",modeCodeTitle:"Переключить в режим редактора кода",modeFormText:"Форма",modeFormTitle:"Переключить в режим формы",modeTextText:"Текст",modeTextTitle:"Переключить в режим редактора текста",modeTreeText:"Дерево",modeTreeTitle:"Переключить в режим редактора дерева",modeViewText:"Просмотр дерева",modeViewTitle:"Переключить в режим просмотра дерева",modePreviewText:"Просмотр",modePreviewTitle:"Переключить в режим просмотра",examples:"Примеры",default:"По умолчанию",containsInvalidProperties:"Содержит недопустимые свойства",containsInvalidItems:"Содержит недопустимые элементы"},ko:{array:"배열",auto:"자동",appendText:"추가",appendTitle:'선택한 요소 아래에 "자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',appendSubmenuTitle:"추가할 요소의 유형을 선택해주세요.",appendTitleAuto:'"자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',ascending:"오름차순",ascendingTitle:"선택한 ${type}의 하위 요소를 오름차순 정렬합니다.",actionsMenu:"메뉴 열기 (Ctrl + M)",cannotParseFieldError:"JSON의 요소를 해석할 수 없습니다.",cannotParseValueError:"JSON의 값을 해석할 수 없습니다.",collapseAll:"모두 접기",compactTitle:"모든 공백을 제거하여 JSON 데이터를 작게 만듭니다. (Ctrl + Shift + I)",descending:"내림차순",descendingTitle:"선택한 ${type}의 하위 요소를 내림차순으로 정렬",drag:"드래그하여 요소를 이동합니다. (Alt + Shift + Arrows)",duplicateKey:"복제키",duplicateText:"복제",duplicateTitle:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateField:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateFieldError:"요소 이름이 중복되었습니다.",empty:"비어있음",expandAll:"모두 열기",expandTitle:"클릭하여 요소를 열거나 닫습니다. (Ctrl + E) \nCtrl + Click으로 모든 하위 요소를 열거나 닫습니다.",formatTitle:"적절한 들여쓰기 및 줄바꿈으로 JSON 데이터를 정형화합니다. (Ctrl + I)",insert:"삽입",insertTitle:"선택한 요소 위에 새요소를 삽입합니다. (Ctrl + Ins)",insertSub:"삽입할 요소의 유형을 선택해주세요.",object:"객체",ok:"확인",redo:"다시 실행 (Ctrl + Shift + Z)",removeText:"삭제",removeTitle:"선택한 요소를 삭제합니다. (Ctrl + Del)",removeField:"선택한 요소를 삭제합니다. (Ctrl + Del)",repairTitle:"JSON 교정: JSON 내의 주석과 JSONP 표기법을 지우고 따옴표와 이스케이프 문자를 수정합니다.",searchTitle:"요소 또는 값 찾기",searchNextResultTitle:"다음으로 찾기 (Enter)",searchPreviousResultTitle:"이전으로 찾기 (Shift + Enter)",selectNode:"요소를 선택해주세요...",showAll:"모두보기",showMore:"더보기",showMoreStatus:"${totalChilds} 개의 항목 중 ${visibleChilds} 개를 표시합니다.",sort:"정렬",sortTitle:"선택한 ${type}의 하위 요소를 정렬합니다.",sortTitleShort:"정렬",sortFieldLabel:"요소:",sortDirectionLabel:"순서:",sortFieldTitle:"배열이나 객체를 정렬하는 요소를 선택해주세요.",sortAscending:"오름차순",sortAscendingTitle:"선택한 요소를 오름차순으로 정렬합니다.",sortDescending:"내림차순",sortDescendingTitle:"선택한 요소를 내림차순으로 정렬합니다.",string:"문자",transform:"변환",transformTitle:"선택한 ${type}의 하위 요소를 필터하거나 정렬 또는 변환합니다.",transformTitleShort:"내용을 필터하거나 정렬 또는 변환합니다.",extract:"추출",extractTitle:"선택한 ${type}의 값을 최상위에 위치시킵니다.",transformQueryTitle:"JMESPath 쿼리를 입력해주세요.",transformWizardLabel:"마법사",transformWizardFilter:"필터",transformWizardSortBy:"정렬",transformWizardSelectFields:"요소를 선택해주세요.",transformQueryLabel:"쿼리",transformPreviewLabel:"미리보기",type:"유형",typeTitle:"선택한 요소의 유형을 변경합니다.",openUrl:"Ctrl + Click 또는 Ctrl + Enter로 새 창에서 URL 열기",undo:"실행 취소 (Ctrl + Z)",validationCannotMove:"하위 요소로 이동할 수 없습니다.",autoType:"자동: 요소의 형식이 값의 유형으로 결정됩니다. 문자, 숫자, 부울, 또는 null만 허용됩니다.",objectType:"객체: 순서대로 나열되지 않은 이름/값 쌍으로 이루어진 집합입니다.",arrayType:"배열: 순서대로 나열된 값의 집합입니다.",stringType:"문자: 요소의 유형이 값에서 결정되지 않지만 항상 문자로 반환됩니다.",modeEditorTitle:"편집기 유형 변경",modeCodeText:"코드",modeCodeTitle:"형식 교정을 도와주는 기능이 포함된 문자 편집기",modeFormText:"입력 양식",modeFormTitle:"정해진 요소에 값을 입력하는 편집기",modeTextText:"문자",modeTextTitle:"단순 문자 편집기",modeTreeText:"트리",modeTreeTitle:"트리 구조로 표시되는 편집기",modeViewText:"보기",modeViewTitle:"읽기전용 트리 구조로 JSON을 표시",modePreviewText:"미리보기",modePreviewTitle:"읽기전용 문자로 JSON을 표시",examples:"예제",default:"기본값",containsInvalidProperties:"잘못된 속성이 포함되어 있습니다.",containsInvalidItems:"잘못된 항목이 포함되어 있습니다"}},i=Object.keys(r),s="en",o="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0,a=i.find(function(e){return e===o})||s;function l(t){var e;t&&((e=i.find(function(e){return e===t}))?a=e:console.error("Language not found"))}function c(e){if(e)for(var t in e)!function(t){i.find(function(e){return e===t})||i.push(t),r[t]=Object.assign({},r[s],r[t],e[t])}(t)}function d(e,t,n){var i=r[n=n||a][e]||r[s][e]||e;if(t)for(var o in t)i=i.replace("${"+o+"}",t[o]);return i}},56:function(e,t,n){"use strict";n.d(t,{J:function(){return r},r:function(){return o}});var t=n(156),i=n.n(t),s=n(791);function o(e,t){var n,i=t.sort,o=t.filter,t=t.projection,r="";return o?(n="@"!==o.field?["0"].concat((0,s.parsePath)("."+o.field)):["0"],n="string"==typeof(0,s.get)(e,n)?o.value:(0,s.parseString)(o.value),r+="[? "+o.field+" "+o.relation+" `"+JSON.stringify(n)+"`]"):r+=Array.isArray(e)?"[*]":"@",i&&("desc"===i.direction?r+=" | reverse(sort_by(@, &"+i.field+"))":r+=" | sort_by(@, &"+i.field+")"),t&&("]"!==r[r.length-1]&&(r+=" | [*]"),1===t.fields.length?r+="."+t.fields[0]:1<t.fields.length&&(r+=".{"+t.fields.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")),r}function r(e,t){return i().search(e,t)}},987:function(){function e(e){void 0===e||"remove"in e||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&(void 0!==window.Element&&e(window.Element.prototype),void 0!==window.CharacterData&&e(window.CharacterData.prototype),void 0!==window.DocumentType)&&e(window.DocumentType.prototype),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(e){for(var t=0;t<this.length;t++){var n=this[t];if(e.call(this,n,t,this))return t}return-1},configurable:!0,writable:!0}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){e=this.findIndex(e);return this[e]},configurable:!0,writable:!0}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(e,t,n){"use strict";n.r(t),n.d(t,{previewModeMixins:function(){return g}});var i=n(304),s=n(188),o=n(436),r=n(474);function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function l(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=a(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=a(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==a(e)?e:String(e)}(i.key),i)}}var c=function(){function i(e,t,n){if(!(this instanceof i))throw new TypeError("Cannot call a class as a function");this.onChange=e,this.calculateItemSize=t||function(){return 1},this.limit=n,this.items=[],this.index=-1}var e,t,n;return e=i,(t=[{key:"add",value:function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var t=this.calculateItemSize,n=0;return this.items.forEach(function(e){n+=t(e)}),n}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}])&&l(e.prototype,t),n&&l(e,n),Object.defineProperty(e,"prototype",{writable:!1}),i}(),d=n(907),h=n(56),u=n(617),p=n(210),m=n(558),t=n(458),f=n(791),n=t.textModeMixins[0].mixin,t={create:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=(void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,t.createQuery=t.createQuery||h.r,t.executeQuery=t.executeQuery||h.J,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2,(0,d.cC)(this.options.languages),(0,d.m0)(this.options.language),this.mode="preview",this),e=(this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=(0,f.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(e){e.preventDefault()},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),e=(this.frameFocusTracker=new r.R(e),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.textContent="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar&&((0,f.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-format",e.title=(0,d.Iu)("formatTitle"),this.menu.appendChild(e),e.onclick=function(){n.executeWithBusyMessage(function(){try{n.format()}catch(e){n._onError(e)}},"formatting...")},(e=document.createElement("button")).type="button",e.className="jsoneditor-compact",e.title=(0,d.Iu)("compactTitle"),this.menu.appendChild(e),e.onclick=function(){n.executeWithBusyMessage(function(){try{n.compact()}catch(e){n._onError(e)}},"compacting...")},this.options.enableSort&&((e=document.createElement("button")).type="button",e.className="jsoneditor-sort",e.title=(0,d.Iu)("sortTitleShort"),e.onclick=function(){n._showSortModal()},this.menu.appendChild(e)),this.options.enableTransform&&((e=document.createElement("button")).type="button",e.title=(0,d.Iu)("transformTitleShort"),e.className="jsoneditor-transform",e.onclick=function(){n._showTransformModal()},this.dom.transform=e,this.menu.appendChild(e)),(e=document.createElement("button")).type="button",e.className="jsoneditor-repair",e.title=(0,d.Iu)("repairTitle"),this.menu.appendChild(e),!(e.onclick=function(){void 0===n.json&&n.executeWithBusyMessage(function(){try{n.repair()}catch(e){n._onError(e)}},"repairing...")})!==this.options.history&&(this.history=new c(function(){n.dom.undo.disabled=!n.history.canUndo(),n.dom.redo.disabled=!n.history.canRedo()},function(e){return 2*e.text.length},s.oW),(e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,d.Iu)("undo"),e.onclick=function(){var e=n.history.undo();e&&n._applyHistory(e)},this.menu.appendChild(e),this.dom.undo=e,(e=document.createElement("button")).type="button",e.className="jsoneditor-redo",e.title=(0,d.Iu)("redo"),e.onclick=function(){var e=n.history.redo();e&&n._applyHistory(e)},this.menu.appendChild(e),this.dom.redo=e,this.history.onChange()),this.options)&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new u.x(this.menu,this.options.modes,this.options.mode,function(e){try{n.setMode(e),n.modeSwitcher.focus()}catch(e){n._onError(e)}})),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):!0===this.options.showErrorTable);this.errorTable=new o.Q({errorTableVisible:e,onToggleVisibility:function(){n.validate()},onFocusLine:null,onChangeHeight:function(e){e=e+(n.dom.statusBar?n.dom.statusBar.clientHeight:0)+1;n.content.style.marginBottom=-e+"px",n.content.style.paddingBottom=e+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),t.statusBar&&((0,f.addClassName)(this.content,"has-status-bar"),e=document.createElement("div"),(this.dom.statusBar=e).className="jsoneditor-statusbar",this.frame.appendChild(e),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",e.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",e.appendChild(this.dom.arrayInfo),e.appendChild(this.errorTable.getErrorCounter()),e.appendChild(this.errorTable.getWarningIcon()),e.appendChild(this.errorTable.getErrorIcon())),this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var e=this.getText();this.dom.previewText.nodeValue=(0,f.limitCharacters)(e,s.WF),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,f.formatSize)(e.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},g=(t._showSortModal=function(){var r=this;this.executeWithBusyMessage(function(){var e=r.options.modalAnchor||s.qD,o=r.get();r._renderPreview(),(0,p.showSortModal)(e,o,function(i){r.executeWithBusyMessage(function(){var e,t,n;e=o,t=i,Array.isArray(e)&&(n=(0,f.sort)(e,t.path,t.direction),r.sortedBy=t,r._setAndFireOnChange(n)),(0,f.isObject)(e)&&(n=(0,f.sortObjectKeys)(e,t.direction),r.sortedBy=t,r._setAndFireOnChange(n))},"sorting...")},r.sortedBy)},"parsing...")},t._showTransformModal=function(){var r=this;this.executeWithBusyMessage(function(){var e=r.options,t=e.createQuery,n=e.executeQuery,i=e.modalAnchor,e=e.queryDescription,o=r.get();r._renderPreview(),(0,m.showTransformModal)({container:i||s.qD,json:o,queryDescription:e,createQuery:t,executeQuery:n,onTransform:function(t){r.executeWithBusyMessage(function(){var e=n(o,t);r._setAndFireOnChange(e)},"transforming...")}})},"parsing...")},t.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history&&(this.history.clear(),this.history=null),this.frameFocusTracker.destroy()},t.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setTextAndFireOnChange(t,e)},t.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setTextAndFireOnChange(t,e)},t.repair=function(){var e=this.getText();try{var t=(0,i.K)(e);this._setTextAndFireOnChange(t)}catch(e){}},t.focus=function(){this.dom.transform.focus()},t.set=function(e){this.history&&this.history.clear(),this._set(e)},t.update=function(e){this._set(e)},t._set=function(e){this.text=void 0,this.json=e,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},t._setAndFireOnChange=function(e){this._set(e),this._onChange()},t.get=function(){var e;return void 0===this.json&&(e=this.getText(),this.json=(0,f.parse)(e)),this.json},t.getText=function(){return void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode)&&(this.text=(0,f.escapeUnicodeChars)(this.text)),this.text},t.setText=function(e){this.history&&this.history.clear(),this._setText(e)},t.updateText=function(e){this.getText()!==e&&this._setText(e)},t._setText=function(e,t){var n;!0===this.options.escapeUnicode?this.text=(0,f.escapeUnicodeChars)(e):this.text=e,this.json=t,this._renderPreview(),void 0===this.json?(n=this).executeWithBusyMessage(function(){try{n.json=n.get(),n._renderPreview(),n._pushHistory()}catch(e){}},"parsing..."):this._pushHistory(),this._debouncedValidate()},t._setTextAndFireOnChange=function(e,t){this._setText(e,t),this._onChange()},t._applyHistory=function(e){this.json=e.json,this.text=e.text,this._renderPreview(),this._debouncedValidate()},t._pushHistory=function(){var e;this.history&&(e={text:this.text,json:this.json},this.history.add(e))},t.executeWithBusyMessage=function(e,t){var n;this.getText().length>s.EX?((0,f.addClassName)((n=this).frame,"busy"),n.dom.busyContent.innerText=t,setTimeout(function(){e(),(0,f.removeClassName)(n.frame,"busy"),n.dom.busyContent.innerText=""},100)):e()},t.validate=n.validate,t._renderErrors=n._renderErrors,[{mode:"preview",mixin:t,data:"json"}])},210:function(e,t,n){"use strict";n.r(t),n.d(t,{showSortModal:function(){return s}});var t=n(483),i=n.n(t),o=n(907),r=n(791);function s(e,t,s,n){var a=Array.isArray(t)?(0,r.getChildPaths)(t):[""],l=n&&n.path&&(0,r.contains)(a,n.path)?n.path:a[0],c=n&&n.direction||"asc",t='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,o.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,o.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+(0,o.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,o.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,o.Iu)("sortAscending")+'" title="'+(0,o.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,o.Iu)("sortDescending")+'" title="'+(0,o.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,o.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';i()({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){var e=t.modalElem().querySelector("form"),n=t.modalElem().querySelector("#ok"),i=t.modalElem().querySelector("#field"),o=t.modalElem().querySelector("#direction");function r(e){o.value=e,o.className="jsoneditor-button-group jsoneditor-button-group-value-"+o.value}a.forEach(function(e){var t,n=document.createElement("option");n.text=""===(t=e)?"@":"."===t[0]?t.slice(1):t,n.value=e,i.appendChild(n)}),i.value=l||a[0],r(c||"asc"),o.onclick=function(e){r(e.target.getAttribute("data-value"))},n.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),s({path:i.value,direction:o.value})},e&&(e.onsubmit=n.onclick)}).afterClose(function(e){e.destroy()}).show()}},558:function(e,t,n){"use strict";n.r(t),n.d(t,{showTransformModal:function(){return s}});var t=n(483),i=n.n(t),t=n(879),w=n.n(t),o=n(907);function x(e){return(x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function _(e,t,n,i){if("boolean"==typeof e||e instanceof Boolean||null===e||"number"==typeof e||e instanceof Number||"string"==typeof e||e instanceof String||e instanceof Date)return JSON.stringify(e);if(Array.isArray(e)){for(var o=e,r=t,s=n,a=i,l=r?s+r:void 0,c=r?"[\n":"[",d=0;d<o.length;d++){var h=o[d];if(r&&(c+=l),c+=void 0!==h&&"function"!=typeof h?_(h,r,l,a):"null",d<o.length-1&&(c+=r?",\n":","),c.length>a)return c+"..."}return c+=r?"\n"+s+"]":"]"}if(e&&"object"===x(e)){var u,p=e,m=t,s=n,f=i,g=m?s+m:void 0,v=!0,y=m?"{\n":"{";if("function"==typeof p.toJSON)return _(p.toJSON(),m,s,f);for(u in p)if(function(e,t){return Object.prototype.hasOwnProperty.call(e,t)}(p,u)){var b=p[u];if(v?v=!1:y+=m?",\n":",",(y=(y+=m?g+'"'+u+'": ':'"'+u+'":')+_(b,m,g,f)).length>f)return y+"..."}return y+=m?"\n"+s+"}":"}"}}function N(e,t){for(var n="";0<t--;)n+=e;return n}var k=n(791),I=n(188),r='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';function s(e){var t=e.container,x=e.json,n=e.queryDescription,n=void 0===n?r:n,C=e.createQuery,T=e.executeQuery,E=e.onTransform,S=x,e='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,o.Iu)("transform")+"</div><p>"+n+'</p><div class="jsoneditor-jmespath-label">'+(0,o.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+(0,o.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+(0,o.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+(0,o.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,o.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+(0,o.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,o.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,o.Iu)("ok")+'" autofocus /></div></div>';i()({parent:t,content:e,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){var e=t.modalElem(),n=e.querySelector("#wizard"),r=e.querySelector("#ok"),o=e.querySelector("#filterField"),s=e.querySelector("#filterRelation"),a=e.querySelector("#filterValue"),l=e.querySelector("#sortField"),c=e.querySelector("#sortOrder"),d=e.querySelector("#selectFields"),h=e.querySelector("#query"),u=e.querySelector("#preview");Array.isArray(S)||(n.style.fontStyle="italic",n.textContent="(wizard not available for objects, only for arrays)");(0,k.getChildPaths)(x).forEach(function(e){var e=g(e),t=document.createElement("option"),t=(t.text=e,t.value=e,o.appendChild(t),document.createElement("option"));t.text=e,t.value=e,l.appendChild(t)});var n=(0,k.getChildPaths)(x,!0).filter(function(e){return""!==e}),n=(0<n.length?n.forEach(function(e){var e=g(e),t=document.createElement("option");t.text=e,t.value=e,d.appendChild(t)}):(n=e.querySelector("#selectFieldsPart"))&&(n.style.display="none"),new(w())(o,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."})),i=new(w())(s,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),p=new(w())(l,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),m=new(w())(c,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),f=new(w())(d,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function g(e){return""===e?"@":"."===e[0]?e.slice(1):e}n.on("selectr.change",b),i.on("selectr.change",b),a.oninput=b,p.on("selectr.change",b),m.on("selectr.change",b),f.on("selectr.change",b),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()};var v=(0,k.debounce)(function(){try{var e=T(S,h.value);u.className="jsoneditor-transform-preview",u.value=(t=e,n=2,i=I.WF,"number"==typeof n?10<n?o=N(" ",10):1<=n&&(o=N(" ",n)):"string"==typeof n&&""!==n&&(o=n),(n=_(t,o,"",i)).length>i?(t=n,("number"==typeof(o=i)?t.slice(0,o):t)+"..."):n),r.disabled=!1}catch(e){u.className="jsoneditor-transform-preview jsoneditor-error",u.value=e.toString(),r.disabled=!0}var t,n,i,o},300);function y(t,e){try{h.value=C(t,e),r.disabled=!1,v()}catch(e){t='Error: an error happened when executing "createQuery": '+(e.message||e.toString());h.value="",r.disabled=!0,u.className="jsoneditor-transform-preview jsoneditor-error",u.value=t}}function b(){var e={};if(o.value&&s.value&&a.value&&(e.filter={field:o.value,relation:s.value,value:a.value}),l.value&&c.value&&(e.sort={field:l.value,direction:c.value}),d.value){for(var t,n=[],i=0;i<d.options.length;i++)d.options[i].selected&&(t=d.options[i].value,n.push(t));e.projection={fields:n}}y(x,e)}h.oninput=v,r.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),E(h.value)},y(x,{}),setTimeout(function(){h.select(),h.focus(),h.selectionStart=3,h.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}},458:function(e,t,n){"use strict";n.r(t),n.d(t,{textModeMixins:function(){return T}});var i=n(304),t=n(170),l=n.n(t),a=n(188),c=n(436),d=n(474),h=n(907),u=n(56),p=n(617),o=n(210),m=n(558),f=n(49),g=n(26),v=n(791);function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function s(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=r(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=r(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==r(e)?e:String(e)}(i.key),i)}}var y=function(){function n(e,t){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");this.schema=e,this.schemaRefs=t||{},this.suggestions={},this.suggestionsRefs={},this._buildSuggestions()}var e,t,i;return e=n,(t=[{key:"_buildSuggestions",value:function(){for(var e in this._handleSchemaEntry("",this.schema,this.suggestions),this.schemaRefs)this.suggestionsRefs[e]={},this._handleSchemaEntry("",this.schemaRefs[e],this.suggestionsRefs[e])}},{key:"_handleRef",value:function(e,t,n){n[e]=n[e]||{},n[e].refs=n[e].refs||[],n[e].refs=(0,v.uniqueMergeArrays)(n[e].refs,[t])}},{key:"_handleSchemaEntry",value:function(e,t,n){if(t)if(t.$ref)this._handleRef(e,t.$ref,n);else{var i=this._checkOfConditon(t);if(i)this._handleOfCondition(e,t[i],n);else switch(t.type){case"object":this._handleObject(e,t,n);break;case"string":case"number":case"integer":this._handlePrimitive(e,t,n);break;case"boolean":this._handleBoolean(e,t,n);break;case"array":this._handleArray(e,t,n)}}else console.error("SchemaTextCompleter: schema node is missing for path",e)}},{key:"_handleObject",value:function(t,n,i){var e,o=this;(0,v.isObject)(n.properties)&&(e=Object.keys(n.properties),i[t]=i[t]||{},i[t].props=i[t].props||[],i[t].props=(0,v.uniqueMergeArrays)(i[t].props,e),e.forEach(function(e){(0,v.asyncExec)(function(){o._handleSchemaEntry("".concat(t,"/").concat(e),n.properties[e],i)})}))}},{key:"_handlePrimitive",value:function(e,t,n){n[e]=n[e]||{},(0,v.isArray)(t.examples)&&(n[e].examples=n[e].examples||[],n[e].examples=(0,v.uniqueMergeArrays)(n[e].examples,t.examples)),(0,v.isArray)(t.enum)&&(n[e].enum=n[e].enum||[],n[e].enum=(0,v.uniqueMergeArrays)(n[e].enum,t.enum))}},{key:"_handleBoolean",value:function(e,t,n){n[e]||(n[e]={bool:[!0,!1]})}},{key:"_handleArray",value:function(e,t,n){var i=this;t.items&&(0,v.asyncExec)(function(){i._handleSchemaEntry("".concat(e,"/\\d+"),t.items,n)})}},{key:"_handleOfCondition",value:function(t,e,n){var i=this;e&&e.length&&e.forEach(function(e){(0,v.asyncExec)(function(){i._handleSchemaEntry(t,e,n)})})}},{key:"_checkOfConditon",value:function(e){if(e)return e.oneOf?"oneOf":e.anyOf?"anyOf":e.allOf?"allOf":void 0}},{key:"getCompletions",value:function(e,t,i,n,s){var c=this;try{var o=g.parse(t.getValue()).pointers||{},r=function(i){function e(t){var e,n={props:"property",enum:"enum",bool:"boolean",examples:"examples"};i&&null!=(e=i[t])&&e.length&&(o=o.concat(i[t].map(function(e){return{caption:e+"",meta:"schema [".concat(n[t],"]"),score:r++,value:e+""}})))}var o=[],r=0;e("props"),e("enum"),e("bool"),e("examples"),o.length&&s(null,o)};Object.keys(o).forEach(function(n){(0,v.asyncExec)(function(){function l(n,e,i){var t,o=Object.keys(e).reduce(function(e,t){return new RegExp("^".concat(i).concat(t)).test(n)&&(!e||e.length<t.length)?t:e});if("string"==typeof o){if(null!=(t=e[o])&&null!=(t=t.refs)&&t.length){var r,s={};for(r in e[o].refs){var a=e[o].refs[r];c.suggestionsRefs[a]&&(null!=(a=l(n,c.suggestionsRefs[a],"".concat(i).concat(o)))&&a.enum&&(s.enum=(0,v.uniqueMergeArrays)(s.enum,a.enum)),null!=a&&a.examples&&(s.examples=(0,v.uniqueMergeArrays)(s.examples,a.examples)),null!=a&&a.bool&&(s.bool=(0,v.uniqueMergeArrays)(s.bool,a.bool)),null!=a)&&a.props&&(s.props=(0,v.uniqueMergeArrays)(s.props,a.props))}return s}if(new RegExp("^".concat(i).concat(o,"$")).test(n))return e[o]}}var e,t;(null==(t=o[n].key)?void 0:t.line)===i.row&&i.column>=o[n
].key.column&&i.column<=o[n].keyEnd.column&&(e=n.slice(0,n.lastIndexOf("/"))),(e=(null==(t=o[n].value)?void 0:t.line)===i.row&&(null==(t=o[n].value)?void 0:t.line)===(null==(t=o[n].valueEnd)?void 0:t.line)&&i.column>=o[n].value.column&&i.column<=o[n].valueEnd.column?n:e)&&(t=l(e,c.suggestions,""),r(t))})})}catch(e){}}}])&&s(e.prototype,t),i&&s(e,i),Object.defineProperty(e,"prototype",{writable:!1}),n}();function b(e){return(b="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var t={},x="ace/theme/jsoneditor";function C(){try{this.format()}catch(e){}}t.create=function(e){var t,n,i,o=this,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},s=(void 0===r.statusBar&&(r.statusBar=!0),r.mainMenuBar=!1!==r.mainMenuBar,r.enableSort=!1!==r.enableSort,r.enableTransform=!1!==r.enableTransform,r.createQuery=r.createQuery||u.r,r.executeQuery=r.executeQuery||u.J,r.showErrorTable=void 0!==r.showErrorTable?r.showErrorTable:["text","preview"],"number"==typeof(this.options=r).indentation?this.indentation=Number(r.indentation):this.indentation=2,(0,h.cC)(this.options.languages),(0,h.m0)(this.options.language),r.ace||l()),a=(this.mode="code"===r.mode?"code":"text","code"===this.mode&&void 0===s&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=r.theme||x,this.theme===x&&s&&(0,f.O)(),r.onTextSelectionChange&&this.onTextSelectionChange(r.onTextSelectionChange),this),e=(this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this.lastSchemaErrors=void 0,this._debouncedValidate=(0,v.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){a._onKeyDown(e)},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),e=(this.frameFocusTracker=new d.R(e),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar&&((0,v.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-format",e.title=(0,h.Iu)("formatTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.format(),a._onChange()}catch(e){a._onError(e)}},(e=document.createElement("button")).type="button",e.className="jsoneditor-compact",e.title=(0,h.Iu)("compactTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.compact(),a._onChange()}catch(e){a._onError(e)}},this.options.enableSort&&((e=document.createElement("button")).type="button",e.className="jsoneditor-sort",e.title=(0,h.Iu)("sortTitleShort"),e.onclick=function(){a._showSortModal()},this.menu.appendChild(e)),this.options.enableTransform&&((e=document.createElement("button")).type="button",e.title=(0,h.Iu)("transformTitleShort"),e.className="jsoneditor-transform",e.onclick=function(){a._showTransformModal()},this.menu.appendChild(e)),(e=document.createElement("button")).type="button",e.className="jsoneditor-repair",e.title=(0,h.Iu)("repairTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.repair(),a._onChange()}catch(e){a._onError(e)}},"code"===this.mode&&((e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,h.Iu)("undo"),e.onclick=function(){o.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(e),this.dom.undo=e,(e=document.createElement("button")).type="button",e.className="jsoneditor-redo",e.title=(0,h.Iu)("redo"),e.onclick=function(){o.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(e),this.dom.redo=e),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new p.x(this.menu,this.options.modes,this.options.mode,function(e){try{a.setMode(e),a.modeSwitcher.focus()}catch(e){a._onError(e)}})),"code"===this.mode)&&((t=document.createElement("a")).appendChild(document.createTextNode("powered by ace")),t.href="https://ace.c9.io/",t.target="_blank",t.className="jsoneditor-poweredBy",t.onclick=function(){window.open(t.href,t.target,"noreferrer")},this.menu.appendChild(t)),this.options.onEditable&&b("function"===this.options.onEditable)&&!this.options.onEditable({})),s=(this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"===this.mode?(this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom),i=(s=s.edit(this.editorDom)).getSession(),s.$blockScrolling=1/0,s.setTheme(this.theme),s.setOptions({readOnly:e}),s.setShowPrintMargin(!1),s.setFontSize("14px"),i.setMode("ace/mode/json"),i.setTabSize(this.indentation),i.setUseSoftTabs(!0),i.setUseWrapMode(!0),n=i.setAnnotations,i.setAnnotations=function(e){n.call(this,e&&e.length?e:a.annotations)},s.commands.bindKey("Ctrl-L",null),s.commands.bindKey("Command-L",null),s.commands.bindKey("Ctrl-\\",null),s.commands.bindKey("Command-\\",null),s.commands.bindKey("Ctrl-Shift-\\",null),s.commands.bindKey("Command-Shift-\\",null),(this.aceEditor=s).on("change",this._onChange.bind(this)),s.on("changeSelection",this._onSelect.bind(this))):((i=document.createElement("textarea")).className="jsoneditor-text",i.spellcheck=!1,this.content.appendChild(i),this.textarea=i,this.textarea.readOnly=e,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),i.onselect=this._onSelect.bind(this),i.onmousedown=this._onMouseDown.bind(this),i.onblur=this._onBlur.bind(this)),this._updateHistoryButtons(),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):!0===this.options.showErrorTable);this.errorTable=new c.Q({errorTableVisible:s,onToggleVisibility:function(){a._validateAndCatch()},onFocusLine:function(e){a.isFocused=!0,isNaN(e)||a.setTextSelection({row:e,column:1},{row:e,column:1e3})},onChangeHeight:function(e){e=e+(a.dom.statusBar?a.dom.statusBar.clientHeight:0)+1;a.content.style.marginBottom=-e+"px",a.content.style.paddingBottom=e+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),r.statusBar&&((0,v.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},e=document.createElement("div"),(this.dom.statusBar=e).className="jsoneditor-statusbar",this.frame.appendChild(e),(i=document.createElement("span")).className="jsoneditor-curserinfo-label",i.innerText="Ln:",(s=document.createElement("span")).className="jsoneditor-curserinfo-val",s.innerText="1",e.appendChild(i),e.appendChild(s),(r=document.createElement("span")).className="jsoneditor-curserinfo-label",r.innerText="Col:",(i=document.createElement("span")).className="jsoneditor-curserinfo-val",i.innerText="1",e.appendChild(r),e.appendChild(i),this.curserInfoElements.colVal=i,this.curserInfoElements.lnVal=s,(r=document.createElement("span")).className="jsoneditor-curserinfo-label",r.innerText="characters selected",r.style.display="none",(i=document.createElement("span")).className="jsoneditor-curserinfo-count",i.innerText="0",i.style.display="none",this.curserInfoElements.countLabel=r,this.curserInfoElements.countVal=i,e.appendChild(i),e.appendChild(r),e.appendChild(this.errorTable.getErrorCounter()),e.appendChild(this.errorTable.getWarningIcon()),e.appendChild(this.errorTable.getErrorIcon())),this.setSchema(this.options.schema,this.options.schemaRefs)},t._onSchemaChange=function(e,t){this.aceEditor&&(this.options.allowSchemaSuggestions&&e?(this.aceEditor.setOption("enableBasicAutocompletion",[new y(e,t)]),this.aceEditor.setOption("enableLiveAutocompletion",!0)):(this.aceEditor.setOption("enableBasicAutocompletion",void 0),this.aceEditor.setOption("enableLiveAutocompletion",!1)))},t._onChange=function(){var e=this;if(!this.onChangeDisabled){if(setTimeout(function(){e._updateHistoryButtons&&e._updateHistoryButtons()}),this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},t._updateHistoryButtons=function(){var e;this.aceEditor&&this.dom.undo&&this.dom.redo&&(e=this.aceEditor.getSession().getUndoManager())&&e.hasUndo&&e.hasRedo&&(this.dom.undo.disabled=!e.hasUndo(),this.dom.redo.disabled=!e.hasRedo())},t._showSortModal=function(){try{var n=this,e=this.options.modalAnchor||a.qD,i=this.get();(0,o.showSortModal)(e,i,function(e){var t;Array.isArray(i)&&(t=(0,v.sort)(i,e.path,e.direction),n.sortedBy=e,n.update(t)),(0,v.isObject)(i)&&(t=(0,v.sortObjectKeys)(i,e.direction),n.sortedBy=e,n.update(t))},n.sortedBy)}catch(e){this._onError(e)}},t._showTransformModal=function(){var t=this;try{var e=this.options,n=e.modalAnchor,i=e.createQuery,o=e.executeQuery,r=e.queryDescription,s=this.get();(0,m.showTransformModal)({container:n||a.qD,json:s,queryDescription:r,createQuery:i,executeQuery:o,onTransform:function(e){e=o(s,e);t.update(e)}})}catch(e){this._onError(e)}},t._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},t._onKeyDown=function(e){var t=!1;73===(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},t._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},t._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},t._updateCursorInfo=function(){var e,t,n,i,o,r=this;function s(){r.curserInfoElements.countVal.innerText!==o&&(r.curserInfoElements.countVal.innerText=o,r.curserInfoElements.countVal.style.display=o?"inline":"none",r.curserInfoElements.countLabel.style.display=o?"inline":"none"),r.curserInfoElements.lnVal.innerText=n,r.curserInfoElements.colVal.innerText=i}this.textarea?setTimeout(function(){var e=(0,v.getInputSelection)(r.textarea);e.startIndex!==e.endIndex&&(o=e.endIndex-e.startIndex),i=(o&&r.cursorInfo&&r.cursorInfo.line===e.end.row&&r.cursorInfo.column===e.end.column?(n=e.start.row,e.start):(n=e.end.row,e.end)).column,r.cursorInfo={line:n,column:i,count:o},r.options.statusBar&&s()},0):this.aceEditor&&this.curserInfoElements&&(e=this.aceEditor.getCursorPosition(),t=this.aceEditor.getSelectedText(),n=e.row+1,i=e.column+1,o=t.length,r.cursorInfo={line:n,column:i,count:o},this.options.statusBar)&&s()},t._emitSelectionChange=function(){var e;this._selectionChangedHandler&&(e=this.getTextSelection(),this._selectionChangedHandler(e.start,e.end,e.text))},t._refreshAnnotations=function(){var e,t=this.aceEditor&&this.aceEditor.getSession();t&&(e=t.getAnnotations().filter(function(e){return"error"===e.type}),t.setAnnotations(e))},t.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null,this.frameFocusTracker.destroy()},t.compact=function(){var e=this.get(),e=JSON.stringify(e);this.updateText(e)},t.format=function(){var e=this.get(),e=JSON.stringify(e,null,this.indentation);this.updateText(e)},t.repair=function(){var e=this.getText();try{var t=(0,i.K)(e);this.updateText(t)}catch(e){}},t.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},t.resize=function(){this.aceEditor&&this.aceEditor.resize(!1)},t.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},t.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},t.get=function(){var e=this.getText();return(0,v.parse)(e)},t.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},t._setText=function(e,t){var n,i=this,e=!0===this.options.escapeUnicode?(0,v.escapeUnicodeChars)(e):e;this.textarea&&(this.textarea.value=e),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(e,-1),this.onChangeDisabled=!1,t&&(n=this,setTimeout(function(){n.aceEditor&&n.aceEditor.session.getUndoManager().reset()})),setTimeout(function(){i._updateHistoryButtons&&i._updateHistoryButtons()})),this._debouncedValidate()},t.setText=function(e){this._setText(e,!0)},t.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},t.validate=function(){var t,n=this,i=[],o=[];try{var r=this.get(),s=(this.validateSchema&&!this.validateSchema(r)&&(i=this.validateSchema.errors.map(function(e){return e.type="validation",(0,v.improveSchemaError)(e)})),this.validationSequence=(this.validationSequence||0)+1,this),a=this.validationSequence;return function(e,t){if(!t)return Promise.resolve([]);try{var n=t(e);return((0,v.isPromise)(n)?n:Promise.resolve(n)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=(0,v.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:(0,v.stringifyPath)(e.path),message:e.message,type:"customValidation"}}):[]})}catch(e){return Promise.reject(e)}}(r,this.options.onValidate).then(function(e){return a===s.validationSequence&&(e=i.concat(o).concat(e),s._renderErrors(e),"function"==typeof n.options.onValidationError&&(0,v.isValidationErrorChanged)(e,n.lastSchemaErrors)&&n.options.onValidationError.call(n,e),n.lastSchemaErrors=e),n.lastSchemaErrors})}catch(e){return this.getText()&&((r=/\w*line\s*(\d+)\w*/g.exec(e.message))&&(t=+r[1]),o=[{type:"error",message:e.message.replace(/\n/g,"<br>"),line:t}]),this._renderErrors(o),"function"==typeof this.options.onValidationError&&(0,v.isValidationErrorChanged)(o,this.lastSchemaErrors)&&this.options.onValidationError.call(this,o),this.lastSchemaErrors=o,Promise.resolve(this.lastSchemaErrors)}},t._validateAndCatch=function(){this.validate().catch(function(e){console.error("Error running validation:",e)})},t._renderErrors=function(i){var e=this.getText(),t=[],e=(i.reduce(function(e,t){return"string"==typeof t.dataPath&&-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},t),(0,v.getPositionForPath)(e,t));this.aceEditor&&(this.annotations=e.map(function(t){var e=i.filter(function(e){return e.dataPath===t.path}),n=e.map(function(e){return e.message}).join("\n");return n?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+n,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(i,e),this.aceEditor&&this.aceEditor.resize(!1)},t.getTextSelection=function(){var e,t,n,i={};return this.textarea?(n=(0,v.getInputSelection)(this.textarea),this.cursorInfo&&this.cursorInfo.line===n.end.row&&this.cursorInfo.column===n.end.column?(i.start=n.end,i.end=n.start):i=n,{start:i.start,end:i.end,text:this.textarea.value.substring(n.startIndex,n.endIndex)}):this.aceEditor?(n=this.aceEditor.getSelection(),e=this.aceEditor.getSelectedText(),t=n.getRange(),(n=n.getSelectionLead()).row===t.end.row&&n.column===t.end.column?i=t:(i.start=t.end,i.end=t.start),{start:{row:i.start.row+1,column:i.start.column+1},end:{row:i.end.row+1,column:i.end.column+1},text:e}):void 0},t.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=(0,v.debounce)(e,this.DEBOUNCE_INTERVAL))},t.setTextSelection=function(e,t){var n,i,o;e&&t&&(this.textarea?(n=(0,v.getIndexForPosition)(this.textarea,e.row,e.column),o=(0,v.getIndexForPosition)(this.textarea,t.row,t.column),-1<n&&-1<o&&(this.textarea.setSelectionRange?(this.textarea.focus(),this.textarea.setSelectionRange(n,o)):this.textarea.createTextRange&&((i=this.textarea.createTextRange()).collapse(!0),i.moveEnd("character",o),i.moveStart("character",n),i.select()),o=(this.textarea.value.match(/\n/g)||[]).length+1,n=this.textarea.scrollHeight/o,i=e.row*n,this.textarea.scrollTop=i>this.textarea.clientHeight?i-this.textarea.clientHeight/2:0)):this.aceEditor&&(o={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}},this.aceEditor.selection.setRange(o),this.aceEditor.scrollToLine(e.row-1,!0)))};var T=[{mode:"text",mixin:t,data:"text",load:C},{mode:"code",mixin:t,data:"text",load:C}]},38:function(M,e,t){"use strict";t.r(e),t.d(e,{treeModeMixins:function(){return U}});var E={start:function(e,t,n){return 0===t.indexOf(e)},contain:function(e,t,n){return-1<t.indexOf(e)}};var s=t(897),a=t(474);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}var S=function(){function e(){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");this.locked=!1}var t,n,i;return t=e,(n=[{key:"highlight",value:function(e){this.locked||(this.node!==e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){var e;this.locked||(e=this).node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}])&&r(t.prototype,n),i&&r(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}(),l=t(907),i=t(56),c=t(617),e=t(233),d=t.n(e),h=t(602),_=t(791);var u=t(210),p=t(558),m=t(188);function V(e){return function(e){if(Array.isArray(e))return g(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||f(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function L(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var i,o,r,s,a=[],l=!0,c=!1;try{if(r=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(i=r.call(n)).done)&&(a.push(i.value),a.length!==t);l=!0);}catch(e){c=!0,o=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw o}}return a}}(e,t)||f(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function w(e,t){var n,i,o,r,s="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(s)return i=!(n=!0),{s:function(){s=s.call(e)},n:function(){var e=s.next();return n=e.done,e},e:function(e){i=!0,o=e},f:function(){try{n||null==s.return||s.return()}finally{if(i)throw o}}};if(Array.isArray(e)||(s=f(e))||t&&e&&"number"==typeof e.length)return s&&(e=s),r=0,{s:t=function(){},n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function f(e,t){var n;if(e)return"string"==typeof e?g(e,t):"Map"===(n="Object"===(n=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?g(e,t):void 0}function g(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function N(e){return(N="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function v(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=N(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=N(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==N(e)?e:String(e)}(i.key),i)}}var k=function(){function w(e,t){if(!(this instanceof w))throw new TypeError("Cannot call a class as a function");this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=(0,_.debounce)(this._onChangeValue.bind(this),w.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=(0,_.debounce)(this._onChangeField.bind(this),w.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}var e,t,n;return e=w,(t=[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:R}},{key:"_updateEditability",value:function(){var e,t;this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,"tree"!==this.editor.options.mode&&"form"!==this.editor.options.mode||"function"!=typeof this.editor.options.onEditable||(e=this.getValue.bind(this),"boolean"==typeof(t=this.editor.options.onEditable({field:this.field,get value(){return e()},path:this.getPath()}))?(this.editable.field=t,this.editable.value=t):"object"===N(t)&&null!==t?("boolean"==typeof t.field&&(this.editable.field=t.field),"boolean"==typeof t.value&&(this.editable.value=t.value)):(console.error("Invalid return value for function onEditable.","Actual value:",t,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)))}},{key:"getPath",value:function(){for(var e=this,t=[];e;){var n=e.getName();void 0!==n&&t.unshift(n),e=e.parent}return t}},{key:"getInternalPath",value:function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(e){if(e){if(0===e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}}},{key:"findNodeByInternalPath",value:function(e){if(e){for(var t=this,n=0;n<e.length&&t;n++)var i=e[n],t=t.childs[i];return t}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(e){for(var n=(0,_.parsePath)(e),i=this;i&&0<n.length;)!function(){var t=n.shift();if("number"==typeof t){if("array"!==i.type)throw new Error("Cannot get child node at index "+t+": node is no array");i=i.childs[t]}else{if("object"!==i.type)throw new Error("Cannot get child node "+t+": node is no object");i=i.childs.filter(function(e){return e.field===t})[0]}}();return i}},{key:"findParents",value:function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e}},{key:"setError",value:function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var n=this,i=this.fieldError||this.valueError||this.error,e=this.dom.tdError;if(i&&this.dom&&this.dom.tr){(0,_.addClassName)(this.dom.tr,"jsoneditor-validation-error"),e||(e=document.createElement("td"),this.dom.tdError=e,this.dom.tdValue.parentNode.appendChild(e));var o=document.createElement("button"),t=(o.type="button",o.className="jsoneditor-button jsoneditor-schema-error",function(){n.dom.popupAnchor&&n.dom.popupAnchor.destroy()}),r=function(){delete n.dom.popupAnchor},s=function(e){var t=n.editor.frame,e=(n.dom.popupAnchor=(0,h.w)(o,n.editor.getPopupAnchor(),r,e),o.getBoundingClientRect()),t=120<t.getBoundingClientRect().width-e.x?"jsoneditor-above":"jsoneditor-left",e=document.createElement("div");e.className="jsoneditor-popover "+t,e.appendChild(document.createTextNode(i.message)),n.dom.popupAnchor.appendChild(e)},a=(o.onmouseover=function(){n.dom.popupAnchor||s(!0)},o.onfocus=function(){t(),s(!1)},o.onblur=function(){t()},this.errorChild);for(a&&(o.onclick=function(){a.findParents().forEach(function(e){e.expand(!1)}),a.scrollTo(function(){a.focus()})});e.firstChild;)e.removeChild(e.firstChild);e.appendChild(o)}else this.dom.tr&&(0,_.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),e&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){var e;return this.parent?-1!==(e=this.parent.childs.indexOf(this))?e:null:-1}},{key:"setParent",value:function(e){this.parent=e}},{key:"setField",value:function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t}},{key:"getField",value:function(){return void 0===this.field&&this._getDomField(),this.field}},{key:"setValue",value:function(e,t){var n,i,o,r,s,a,l=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),n=0;n<e.length;n++)void 0===(s=e[n])||s instanceof Function||(n<this.childs.length?((o=this.childs[n]).fieldEditable=!1,o.index=n,o.setValue(s)):(o=new w(this.editor,{value:s}),r=n<this.getMaxVisibleChilds(),this.appendChild(o,r,!1)));for(i=this.childs.length;i>=e.length;i--)this.removeChild(this.childs[i],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),i=this.childs.length-1;0<=i;i--)b(e,this.childs[i].field)||this.removeChild(this.childs[i],!1);for(var c in n=0,e)b(e,c)&&(void 0===(s=e[c])||s instanceof Function||((a=this.findChildByProperty(c))?(a.setField(c,!0),a.setValue(s)):(a=new w(this.editor,{field:c,value:s}),c=n<this.getMaxVisibleChilds(),this.appendChild(a,c,!1))),n++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(l)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(e){var t,n,i,o,r,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?((n=this.childs[o]).fieldEditable=!1,n.index=o,n.setInternalValue(t)):(n=new w(this.editor,{internalValue:t}),i=o<this.getMaxVisibleChilds(),this.appendChild(n,i,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?(delete(n=this.childs[o]).index,n.setField(t.field,!0),n.setInternalValue(t.value)):(n=new w(this.editor,{field:t.field,internalValue:t.value}),i=o<this.getMaxVisibleChilds(),this.appendChild(n,i,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){var e;this.dom&&this.dom.tr&&this.dom.tr.parentNode?(e=this._detachFromDom(),this.clearDom(),this._attachToDom(e)):this.clearDom()}},{key:"getValue",value:function(){var t,n;return"array"===this.type?(t=[],this.childs.forEach(function(e){t.push(e.getValue())}),t):"object"===this.type?(n={},this.childs.forEach(function(e){n[e.getField()]=e.getValue()}),n):(void 0===this.value&&this._getDomValue(),this.value)}},{key:"getInternalValue",value:function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e}},{key:"clone",value:function(){var t,n;return(t=new w(this.editor)).type=this.type,t.field=this.field,t.fieldInnerText=this.fieldInnerText,t.fieldEditable=this.fieldEditable,t.previousField=this.previousField,t.value=this.value,t.valueInnerText=this.valueInnerText,t.previousValue=this.previousValue,t.expanded=this.expanded,t.visibleChilds=this.visibleChilds,this.childs?(n=[],this.childs.forEach(function(e){e=e.clone();e.setParent(t),n.push(e)}),t.childs=n):t.childs=void 0,t}},{key:"expand",value:function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){var e=this.childs;if(e&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){for(var n=this.getAppendDom(),i=(n.parentNode||((o=e.nextSibling)?t.insertBefore(n,o):t.appendChild(n)),Math.min(this.childs.length,this.visibleChilds)),o=this._getNextTr(),r=0;r<i;r++){var s=this.childs[r];s.getDom().parentNode||t.insertBefore(s.getDom(),o),s.showChilds()}e=this.getShowMoreDom();o=this._getNextTr(),e.parentNode||t.insertBefore(e,o),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(e){var t=this.dom.tr,n=t?t.parentNode:void 0;n&&n.removeChild(t),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(e)}},{key:"hideChilds",value:function(e){var t;this.childs&&this.expanded&&((t=this.getAppendDom()).parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()}),(t=this.getShowMoreDom()).parentNode&&t.parentNode.removeChild(t),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds()))}},{key:"_updateCssClassName",value:function(){var e,t;this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree&&((0,_.removeAllClassNames)(this.dom.tree),e=this.getValue.bind(this),t=this.editor.options.onClassName({path:this.getPath(),field:this.field,get value(){return e()}})||"",(0,_.addClassName)(this.dom.tree,"jsoneditor-values "+t))}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent}},{key:"appendChild",value:function(e,t,n){var i,o;this._hasChilds()&&(e.setParent(this),e.fieldEditable="object"===this.type,"array"===this.type&&(e.index=this.childs.length),"object"===this.type&&void 0===e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t&&(t=e.getDom(),o=(i=this._getNextTr())?i.parentNode:void 0,i&&o&&o.insertBefore(t,i),e.showChilds(),this.visibleChilds++),!1!==n)&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}},{key:"moveBefore",value:function(e,t,n){var i,o,r;this._hasChilds()&&((i=this.dom.tr?this.dom.tr.parentNode:void 0)&&((o=document.createElement("tr")).style.height=i.clientHeight+"px",i.appendChild(o)),e.parent&&e.parent.removeChild(e),t instanceof j||!t?this.childs.length+1>this.visibleChilds?(r=this.childs[this.visibleChilds-1],this.insertBefore(e,r,n)):this.appendChild(e,!0,n):this.insertBefore(e,t,n),i)&&o&&i.removeChild(o)}},{key:"insertBefore",value:function(e,t,n){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&void 0===e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"===this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1===i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"===this.type,this.childs.splice(i,0,e)}var o;this.expanded&&(i=e.getDom(),o=(t=t.getDom())?t.parentNode:void 0,t&&o&&o.insertBefore(i,t),e.showChilds(),this.showChilds()),!1!==n&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(e,t){this._hasChilds()&&(t=this.childs.indexOf(t),(t=this.childs[t+1])?this.insertBefore(e,t):this.appendChild(e))}},{key:"search",value:function(t,n){Array.isArray(n)||(n=[]);var e=t?t.toLowerCase():void 0;return delete this.searchField,delete this.searchValue,void 0!==this.field&&n.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,n.push({node:this,elem:"field"})),this._updateDomField()),this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,n)}):void 0!==this.value&&n.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,n.push({node:this,elem:"value"})),this._updateDomValue()),n}},{key:"scrollTo",value:function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)}},{key:"expandPathToNode",value:function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}}},{key:"focus",value:function(e){if(w.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":(t.drag||t.menu).focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),(0,_.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),(0,_.selectContentEditable)(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),(0,_.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),(0,_.selectContentEditable)(t.value)):(this._hasChilds()?t.expand:t.menu).focus();break;default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),(0,_.selectContentEditable)(t.value)):t.field&&this.fieldEditable?(t.field.focus(),(0,_.selectContentEditable)(t.field)):(this._hasChilds()?t.expand:t.menu).focus()}}}},{key:"containsNode",value:function(e){if(this===e)return!0;var t=this.childs;if(t)for(var n=0,i=t.length;n<i;n++)if(t[n].containsNode(e))return!0;return!1}},{key:"removeChild",value:function(e,t){if(this.childs){var n=this.childs.indexOf(e);if(-1!==n)return n<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue,(e=this.childs.splice(n,1)[0]).parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),e}}},{key:"_remove",value:function(e){this.removeChild(e)}},{key:"changeType",value:function(e){var t,n=this.type;n!==e&&("string"!==e&&"auto"!==e||"string"!==n&&"auto"!==n?(t=this._detachFromDom(),this.clearDom(),"object"===(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0===e.field&&(e.field="")}),"string"!==n&&"auto"!==n||(this.expanded=!0)):"array"===e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!==n&&"auto"!==n||(this.expanded=!0)):this.expanded=!1,this._attachToDom(t)):this.type=e,"auto"!==e&&"string"!==e||(this.value="string"===e?String(this.value):(0,_.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0}))}},{key:"deepEqual",value:function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!==N(e)||!e)return!1;var n=Object.keys(e);if(this.childs.length!==n.length)return!1;for(t=0;t<n.length;t++){var i=this.childs[t];if(i.field!==n[t]||!i.deepEqual(e[i.field]))return!1}}else if(this.value!==e)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=(0,_.getInnerText)(this.dom.value),""===this.valueInnerText)&&""!==this.dom.value.innerHTML&&(this.dom.value.textContent=""),void 0!==this.valueInnerText)try{var e,t;(t="string"===this.type?this._unescapeHTML(this.valueInnerText):(e=this._unescapeHTML(this.valueInnerText),(0,_.parseString)(e)))!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(e){this._setValueError((0,l.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(e){this.valueError={message:e},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(e){this.fieldError={message:e},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var e,t=this.editor.getDomSelection(),n=(t.range&&(n=(0,_.textDiff)(String(this.value),String(this.previousValue)),t.range.startOffset=n.start,t.range.endOffset=n.end),this.editor.getDomSelection());n.range&&(e=(0,_.textDiff)(String(this.previousValue),String(this.value)),n.range.startOffset=e.start,n.range.endOffset=e.end),this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:t,newSelection:n}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var e=this.editor.getDomSelection(),t=this.previousField||"",n=(e.range&&(n=(0,_.textDiff)(this.field,t),e.range.startOffset=n.start,e.range.endOffset=n.end),this.editor.getDomSelection());n.range&&(t=(0,_.textDiff)(t,this.field),n.range.startOffset=t.start,n.range.endOffset=t.end),this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],n=this.value,i="auto"===this.type?(0,_.getType)(n):this.type,o="string"===i&&(0,_.isUrl)(n);if(t.push("jsoneditor-"+i),o&&t.push("jsoneditor-url"),""===String(this.value)&&"array"!==this.type&&"object"!==this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"===i||"object"===i?(t=this.childs?this.childs.length:0,e.title=this.type+" containing "+t+" items"):o&&this.editable.value?e.title=(0,l.Iu)("openUrl"):e.title="","boolean"===i&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value?(this.dom.select||(this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,(t=document.createElement("option")).value="",t.textContent="--",this.dom.select.appendChild(t),this._updateEnumOptions(),this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)),this.dom.select.value=-1!==this.enum.indexOf(this.value)?this.value:"",!this.schema||b(this.schema,"oneOf")||b(this.schema,"anyOf")||b(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")):this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML,this.dom.tdValue.appendChild(this.dom.value)),this.editor.options.colorPicker&&"string"==typeof n&&(0,_.isValidColor)(n)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,_.addClassName)(this.dom.value,"jsoneditor-color-value"),(this.editable.value?(0,_.removeClassName):(0,_.addClassName))(this.dom.color,"jsoneditor-color-readonly"),this.dom.color.style.backgroundColor=n):this._deleteDomColor(),this._showTimestampTag()){this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date));o=null;if(o="function"==typeof this.editor.options.timestampFormat?this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()}):o){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(o))}else this.dom.date.textContent=new Date(n).toISOString();this.dom.date.title=new Date(n).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,_.stripFormatting)(e),this._updateDomDefault()}}},{key:"_updateEnumOptions",value:function(){if(this.enum&&this.dom.select){this.dom.select.innerHTML="";for(var e=0;e<this.enum.length;e++){var t=document.createElement("option");t.value=this.enum[e],t.textContent=this.enum[e],this.dom.select.appendChild(t)}}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,(0,_.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var e,t=this.dom.field;t&&((e=(0,_.makeFieldTooltip)(this.schema,this.editor.options.language))&&(t.title=e),(""===String(this.field)&&this.parent&&"array"!==this.parent.type?(0,_.addClassName):(0,_.removeClassName))(t,"jsoneditor-empty"),(this.searchFieldActive?(0,_.addClassName):(0,_.removeClassName))(t,"jsoneditor-highlight-active"),(this.searchField?(0,_.addClassName):(0,_.removeClassName))(t,"jsoneditor-highlight"),(0,_.stripFormatting)(t))}},{key:"_getDomField",value:function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,_.getInnerText)(this.dom.field),""===this.fieldInnerText)&&""!==this.dom.field.innerHTML&&(this.dom.field.textContent=""),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),n=this.parent.getFieldNames(this);-1!==n.indexOf(t)?e?(t=(0,_.findUniqueName)(t,n))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError((0,l.Iu)("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError((0,l.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){var e;this.schema&&void 0!==this.schema.default&&!this._hasChilds()&&(e=this.dom.select||this.dom.value)&&(this.value===this.schema.default?(e.title=(0,l.Iu)("default"),(0,_.addClassName)(e,"jsoneditor-is-default"),_.removeClassName):(e.removeAttribute("title"),(0,_.removeClassName)(e,"jsoneditor-is-default"),_.addClassName))(e,"jsoneditor-is-not-default")}},{key:"_showTimestampTag",value:function(){var e,t;return"number"==typeof this.value&&("function"==typeof(e=this.editor.options.timestampTag)?"boolean"==typeof(t=e({field:this.field,value:this.value,path:this.getPath()}))?t:(0,_.isTimestamp)(this.field,this.value):!0===e&&(0,_.isTimestamp)(this.field,this.value))}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var e,t,n=this.dom;return n.tr||(this._updateEditability(),n.tr=document.createElement("tr"),"tree"===(n.tr.node=this).editor.options.mode&&(t=document.createElement("td"),this.editable.field&&this.parent&&((e=document.createElement("button")).type="button",(n.drag=e).className="jsoneditor-button jsoneditor-dragarea",e.title=(0,l.Iu)("drag"),t.appendChild(e)),n.tr.appendChild(t),e=document.createElement("td"),(t=document.createElement("button")).type="button",(n.menu=t).className="jsoneditor-button jsoneditor-contextmenu-button",t.title=(0,l.Iu)("actionsMenu"),e.appendChild(n.menu),n.tr.appendChild(e)),t=document.createElement("td"),n.tr.appendChild(t),n.tree=this._createDomTree(),t.appendChild(n.tree),this.updateDom({updateIndexes:!0})),n.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(e){for(var t=this.parent;t;){if(t===e)return!0;t=t.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(t){this.dom.tr&&((t?(0,_.addClassName):(0,_.removeClassName))(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs)&&this.childs.forEach(function(e){e.setHighlight(t)})}},{key:"setSelected",value:function(t,e){this.selected=t,this.dom.tr&&((t?(0,_.addClassName):(0,_.removeClassName))(this.dom.tr,"jsoneditor-selected"),(e?(0,_.addClassName):(0,_.removeClassName))(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs)&&this.childs.forEach(function(e){e.setSelected(t)})}},{key:"updateValue",value:function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(t){var e,n=this.dom.tree,n=(n&&(n.style.marginLeft=24*this.getLevel()+"px"),this.dom.field),n=(n&&(this.fieldEditable?(n.contentEditable=this.editable.field,n.spellcheck=!1,n.className="jsoneditor-field"):(n.contentEditable=!1,n.className="jsoneditor-readonly"),e=void 0!==this.index?this.index:void 0!==this.field?this.field:(e=this.editor.options.schema?w._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&e.title?e.title:this._hasChilds()?this.type:"",e=this._escapeHTML(e),document.activeElement!==n&&e!==this._unescapeHTML((0,_.getInnerText)(n))&&(n.innerHTML=e),this._updateSchema(),this._updateEnumOptions()),this.dom.value),n=(n&&("array"===this.type||"object"===this.type?this.updateNodeName():(e=this._escapeHTML(this.value),document.activeElement!==n&&e!==this._unescapeHTML((0,_.getInnerText)(n))&&(n.innerHTML=e))),this.dom.tr);n&&("array"===this.type||"object"===this.type?((0,_.addClassName)(n,"jsoneditor-expandable"),this.expanded?((0,_.addClassName)(n,"jsoneditor-expanded"),(0,_.removeClassName)(n,"jsoneditor-collapsed")):((0,_.addClassName)(n,"jsoneditor-collapsed"),(0,_.removeClassName)(n,"jsoneditor-expanded"))):((0,_.removeClassName)(n,"jsoneditor-expandable"),(0,_.removeClassName)(n,"jsoneditor-expanded"),(0,_.removeClassName)(n,"jsoneditor-collapsed"))),this._updateDomField(),this._updateDomValue(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom(),this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?w._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=w._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var e=this.dom.value,t=this.childs;e&&t&&("array"===this.type?t.forEach(function(e,t){e.index=t;e=e.dom.field;e&&(e.textContent=t)}):"object"===this.type&&t.forEach(function(e){void 0!==e.index&&(delete e.index,void 0===e.field)&&(e.field="")}))}},{key:"_createDomValue",value:function(){var e;return"array"===this.type?(e=document.createElement("div")).textContent="[...]":"object"===this.type?(e=document.createElement("div")).textContent="{...}":(!this.editable.value&&(0,_.isUrl)(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e}},{key:"_createDomExpandButton",value:function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=(0,l.Iu)("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e}},{key:"_createDomTree",value:function(){var e=this.dom,t=document.createElement("table"),n=document.createElement("tbody"),i=(t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(n),document.createElement("tr")),n=(n.appendChild(i),document.createElement("td")),n=(n.className="jsoneditor-tree",i.appendChild(n),e.expand=this._createDomExpandButton(),n.appendChild(e.expand),e.tdExpand=n,document.createElement("td")),n=(n.className="jsoneditor-tree",i.appendChild(n),e.field=this._createDomField(),n.appendChild(e.field),e.tdField=n,document.createElement("td")),n=(n.className="jsoneditor-tree",i.appendChild(n),"object"!==this.type&&"array"!==this.type&&(n.appendChild(document.createTextNode(":")),n.className="jsoneditor-separator"),e.tdSeparator=n,document.createElement("td"));return n.className="jsoneditor-tree",i.appendChild(n),e.value=this._createDomValue(),n.appendChild(e.value),e.tdValue=n,t}},{key:"onEvent",value:function(e){var t,n=e.type,i=e.target||e.srcElement,o=this.dom,r=this,s=this._hasChilds(),a=(i!==o.drag&&i!==o.menu||("mouseover"===n?this.editor.highlighter.highlight(this):"mouseout"===n&&this.editor.highlighter.unhighlight()),"click"===n&&i===o.menu&&((t=r.editor.highlighter).highlight(r),t.lock(),(0,_.addClassName)(o.menu,"jsoneditor-selected"),this.showContextMenu(o.menu,function(){(0,_.removeClassName)(o.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"click"===n&&i===o.expand&&s&&(h=e.ctrlKey,this._onExpand(h)),"click"!==n||e.target!==r.dom.tdColor&&e.target!==r.dom.color||!this.editable.value||this._showColorPicker(),"change"===n&&i===o.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault()),"change"===n&&i===o.select&&(this.dom.value.innerHTML=this._escapeHTML(o.select.value),this._getDomValue(),this._updateDomValue()),o.value);if(i===a)switch(n){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var l=this._escapeHTML(this.value);l!==this._unescapeHTML((0,_.getInnerText)(a))&&(a.innerHTML=l);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&(0,_.isUrl)(this.value)&&(e.preventDefault(),window.open(this.value,"_blank","noreferrer"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){r._getDomValue(),r._updateDomValue()},1)}var c=o.field;if(i===c)switch(n){case"blur":this._getDomField(!0),this._updateDomField();var d=this._escapeHTML(this.field);d!==this._unescapeHTML((0,_.getInnerText)(c))&&(c.innerHTML=d);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){r._getDomField(),r._updateDomField()},1)}var h=o.tree;h&&i===h.parentNode&&"click"===n&&!e.hasMoved&&((void 0!==e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<(0,_.getAbsoluteLeft)(o.tdSeparator))||s?c&&((0,_.setEndOfContentEditable)(c),c.focus()):a&&!this.enum&&((0,_.setEndOfContentEditable)(a),a.focus())),(i!==o.tdExpand||s)&&i!==o.tdField&&i!==o.tdSeparator||"click"!==n||e.hasMoved||c&&((0,_.setEndOfContentEditable)(c),c.focus()),"keydown"===n&&this.onKeyDown(e),"function"==typeof this.editor.options.onEvent&&this._onEvent(e)}},{key:"_onEvent",value:function(e){var t=e.target,n=t===this.dom.field,t=t===this.dom.value||t===this.dom.checkbox||t===this.dom.select;(n||t)&&(n={field:this.getField(),path:this.getPath()},t&&!this._hasChilds()&&(n.value=this.getValue()),this.editor.options.onEvent(n,e))}},{key:"onKeyDown",value:function(e){var t,n,i,o,r,s,a,l,c,d,h,u,p,m,f=e.which||e.keyCode,g=e.target||e.srcElement,v=e.ctrlKey,y=e.shiftKey,b=e.altKey,x=!1,C="tree"===this.editor.options.mode,T=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],E=T[0],S=T[T.length-1];13===f?g===this.dom.value?this.editable.value&&!e.ctrlKey||(0,_.isUrl)(this.value)&&(window.open(this.value,"_blank","noreferrer"),x=!0):g===this.dom.expand&&this._hasChilds()&&(p=e.ctrlKey,this._onExpand(p),g.focus(),x=!0):68===f?v&&C&&(w.onDuplicate(T),x=!0):69===f?v&&(this._onExpand(y),g.focus(),x=!0):77===f&&C?v&&(this.showContextMenu(g),x=!0):46===f&&C?v&&(w.onRemove(T),x=!0):45===f&&C?v&&!y?(this._onInsertBefore(),x=!0):v&&y&&(this._onInsertAfter(),x=!0):35===f?b&&((p=this._lastNode())&&p.focus(w.focusElement||this._getElementName(g)),x=!0):36===f?b&&((p=this._firstNode())&&p.focus(w.focusElement||this._getElementName(g)),x=!0):37===f?b&&!y?((p=this._previousElement(g))&&this.focus(this._getElementName(p)),x=!0):b&&y&&C&&(p=S.expanded?(p=S.getAppendDom())?p.nextSibling:void 0:S.getDom().nextSibling)&&(h=w.getNodeFromTarget(p),p=p.nextSibling,u=w.getNodeFromTarget(p),h)&&h instanceof j&&1!==S.parent.childs.length&&u&&u.parent&&(n=this.editor.getDomSelection(),i=(o=E.parent).childs[S.getIndex()+1]||o.append,r=E.getIndex(),s=u.getIndex(),a=o.getInternalPath(),l=u.parent.getInternalPath(),T.forEach(function(e){u.parent.moveBefore(e,u)}),this.focus(w.focusElement||this._getElementName(g)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(I),oldParentPath:o.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldIndex:i.getIndex(),newIndex:E.getIndex(),oldIndexRedo:r,newIndexRedo:s,oldParentPathRedo:a,newParentPathRedo:l,oldSelection:n,newSelection:this.editor.getDomSelection()})):38===f?b&&!y?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(w.focusElement||this._getElementName(g))),x=!0):!b&&v&&y&&C?((t=this._previousNode())&&((d=this.editor.multiselection).start=d.start||this,d.end=t,c=this.editor._findTopLevelNodes(d.start,d.end),this.editor.select(c),t.focus("field")),x=!0):b&&y&&C&&((t=E._previousNode())&&t.parent&&(n=this.editor.getDomSelection(),i=(o=E.parent).childs[S.getIndex()+1]||o.append,r=E.getIndex(),s=t.getIndex(),a=o.getInternalPath(),l=t.parent.getInternalPath(),T.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(w.focusElement||this._getElementName(g)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(I),oldParentPath:o.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldIndex:i.getIndex(),newIndex:E.getIndex(),oldIndexRedo:r,newIndexRedo:s,oldParentPathRedo:a,newParentPathRedo:l,oldSelection:n,newSelection:this.editor.getDomSelection()})),x=!0):39===f?b&&!y?((p=this._nextElement(g))&&this.focus(this._getElementName(p)),x=!0):b&&y&&C&&(p=E.getDom().previousSibling)&&(t=w.getNodeFromTarget(p))&&t.parent&&!t.isVisible()&&(n=this.editor.getDomSelection(),i=(o=E.parent).childs[S.getIndex()+1]||o.append,r=E.getIndex(),s=t.getIndex(),a=o.getInternalPath(),l=t.parent.getInternalPath(),T.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(w.focusElement||this._getElementName(g)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(I),oldParentPath:o.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldIndex:i.getIndex(),newIndex:E.getIndex(),oldIndexRedo:r,newIndexRedo:s,oldParentPathRedo:a,newParentPathRedo:l,oldSelection:n,newSelection:this.editor.getDomSelection()})):40===f&&(b&&!y?((h=this._nextNode())&&(this.editor.deselect(!0),h.focus(w.focusElement||this._getElementName(g))),x=!0):!b&&v&&y&&C?((h=this._nextNode())&&((d=this.editor.multiselection).start=d.start||this,d.end=h,c=this.editor._findTopLevelNodes(d.start,d.end),this.editor.select(c),h.focus("field")),x=!0):b&&y&&C&&((m=(h=(h=(h=S.expanded?S.append?S.append._nextNode():void 0:S._nextNode())&&!h.isVisible()?h.parent.showMore:h)&&h instanceof j?S:h)&&(h._nextNode()||h.parent.append))&&m.parent&&(n=this.editor.getDomSelection(),i=(o=E.parent).childs[S.getIndex()+1]||o.append,r=E.getIndex(),s=m.getIndex(),a=o.getInternalPath(),l=m.parent.getInternalPath(),T.forEach(function(e){m.parent.moveBefore(e,m)}),this.focus(w.focusElement||this._getElementName(g)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(I),oldParentPath:o.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldParentPathRedo:a,newParentPathRedo:l,oldIndexRedo:r,newIndexRedo:s,oldIndex:i.getIndex(),newIndex:E.getIndex(),oldSelection:n,newSelection:this.editor.getDomSelection()})),x=!0)),x&&(e.preventDefault(),e.stopPropagation())}},{key:"_onExpand",value:function(e){var t,n,i;e&&(i=(n=(t=this.dom.tr.parentNode).parentNode).scrollTop,n.removeChild(t)),this.expanded?this.collapse(e):this.expand(e),e&&(n.appendChild(t),n.scrollTop=i),"function"==typeof this.editor.options.onExpand&&this.editor.options.onExpand({path:this.getPath(),isExpand:this.expanded,recursive:e})}},{key:"_showColorPicker",value:function(){var t,e;"function"==typeof this.editor.options.onColorPicker&&this.dom.color&&((t=this)._deleteDomColor(),t.updateDom(),e=(0,h.w)(this.dom.color,this.editor.getPopupAnchor()),this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())}))}},{key:"getFieldNames",value:function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]}},{key:"_onInsertBefore",value:function(e,t,n){var i=this.editor.getDomSelection(),e=new w(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:n}),t=(e.expand(!0),this.getInternalPath()),n=(this.parent.insertBefore(e,this),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertBeforeNodes",{nodes:[e],paths:[e.getInternalPath()],beforePath:t,parentPath:this.parent.getInternalPath(),oldSelection:i,newSelection:n})}},{key:"_onInsertAfter",value:function(e,t,n){var i=this.editor.getDomSelection(),e=new w(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:n}),t=(e.expand(!0),this.parent.insertAfter(e,this),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertAfterNodes",{nodes:[e],paths:[e.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:i,newSelection:t})}},{key:"_onAppend",value:function(e,t,n){var i=this.editor.getDomSelection(),e=new w(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:n}),t=(e.expand(!0),this.parent.appendChild(e),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("appendNodes",{nodes:[e],paths:[e.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:i,newSelection:t})}},{key:"_onChangeType",value:function(e){var t,n,i=this.type;e!==i&&(t=this.editor.getDomSelection(),this.changeType(e),n=this.editor.getDomSelection(),this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:i,newType:e,oldSelection:t,newSelection:n}))}},{key:"sort",value:function(n,e){var t,i,o=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];"string"==typeof n&&(n=(0,_.parsePath)(n)),this._hasChilds()&&(this.hideChilds(),t=this.childs,this.childs=this.childs.concat(),i="desc"===e?-1:1,"object"===this.type?this.childs.sort(function(e,t){return i*d()(e.field,t.field)}):this.childs.sort(function(e,t){var e=e.getNestedChild(n),t=t.getNestedChild(n);return e?t?(e=e.value,t=t.value,"string"!=typeof e&&"string"!=typeof t?t<e?i:e<t?-i:0:i*d()(e,t)):-i:i}),this._updateDomIndexes(),this.showChilds(),!0===o)&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:t,newChilds:this.childs})}},{key:"update",value:function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var e=this.dom.tr?this.dom.tr.parentNode:void 0,t=this.expanded?this.getAppendDom():this.getDom(),t=t&&t.parentNode?t.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:e,nextTr:t}}},{key:"_attachToDom",value:function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),n=this.getValue(),i=this.editor.options.executeQuery(n,e),o=(this.setValue(i),this.getInternalValue());this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:o}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var e=this.editor.node.getInternalValue(),t=(this.editor._setRoot(this),this.editor.node.getInternalValue());this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:e,newValue:t})}catch(e){this.editor._onError(e)}finally{this.updateDom({recurse:!0}),
this.showChilds()}}},{key:"getNestedChild",value:function(e){for(var t=0,n=this;n&&t<e.length;)n=n.findChildByProperty(e[t]),t++;return n}},{key:"findChildByProperty",value:function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new j(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new B(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append}},{key:"_previousNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var n=t;n=n.previousSibling,e=w.getNodeFromTarget(n),n&&e&&e instanceof j&&!e.isVisible(););return e}},{key:"_nextNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var n=t;n=n.nextSibling,e=w.getNodeFromTarget(n),n&&e&&e instanceof j&&!e.isVisible(););return e}},{key:"_firstNode",value:function(){var e=null,t=this.getDom();return t&&t.parentNode&&(t=t.parentNode.firstChild,e=w.getNodeFromTarget(t)),e}},{key:"_lastNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var n=t.parentNode.lastChild,e=w.getNodeFromTarget(n);n&&e&&!e.isVisible();)n=n.previousSibling,e=w.getNodeFromTarget(n);return e}},{key:"_previousElement",value:function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}}},{key:"_nextElement",value:function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}}},{key:"_getElementName",value:function(t){var n=this;return Object.keys(this.dom).find(function(e){return n.dom[e]===t})}},{key:"_hasChilds",value:function(){return"array"===this.type||"object"===this.type}},{key:"addTemplates",value:function(t,n){var i=this,e=i.editor.options.templates;null!=e&&(e.length&&t.push({type:"separator"}),e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:(n?function(e,t){i._onAppend(e,t)}:function(e,t){i._onInsertBefore(e,t)}).bind(this,e.field,e.value)})}))}},{key:"showContextMenu",value:function(e,t){var n,i=this,o=[];this.editable.value&&o.push({text:(0,l.Iu)("type"),title:(0,l.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("autoType"),click:function(){i._onChangeType("auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("arrayType"),click:function(){i._onChangeType("array")}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object"+("object"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("objectType"),click:function(){i._onChangeType("object")}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("stringType"),click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&o.push({text:(0,l.Iu)("sort"),title:(0,l.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){i.showSortModal()}}),this.editor.options.enableTransform&&o.push({text:(0,l.Iu)("transform"),title:(0,l.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){i.showTransformModal()}}),this.parent)&&o.push({text:(0,l.Iu)("extract"),title:(0,l.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){i.extract()}}),this.parent&&this.parent._hasChilds()&&(o.length&&o.push({type:"separator"}),n=i.parent.childs,i===n[n.length-1]&&(n=[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,l.Iu)("autoType"),click:function(){i._onAppend("","","auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array",title:(0,l.Iu)("arrayType"),click:function(){i._onAppend("",[])}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object",title:(0,l.Iu)("objectType"),click:function(){i._onAppend("",{})}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string",title:(0,l.Iu)("stringType"),click:function(){i._onAppend("","","string")}}],i.addTemplates(n,!0),o.push({text:(0,l.Iu)("appendText"),title:(0,l.Iu)("appendTitle"),submenuTitle:(0,l.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:n})),n=[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,l.Iu)("autoType"),click:function(){i._onInsertBefore("","","auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array",title:(0,l.Iu)("arrayType"),click:function(){i._onInsertBefore("",[])}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object",title:(0,l.Iu)("objectType"),click:function(){i._onInsertBefore("",{})}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string",title:(0,l.Iu)("stringType"),click:function(){i._onInsertBefore("","","string")}}],i.addTemplates(n,!1),o.push({text:(0,l.Iu)("insert"),title:(0,l.Iu)("insertTitle"),submenuTitle:(0,l.Iu)("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:n}),this.editable.field)&&(o.push({text:(0,l.Iu)("duplicateText"),title:(0,l.Iu)("duplicateField"),className:"jsoneditor-duplicate",click:function(){w.onDuplicate(i)}}),o.push({text:(0,l.Iu)("removeText"),title:(0,l.Iu)("removeField"),className:"jsoneditor-remove",click:function(){w.onRemove(i)}})),this.editor.options.onCreateMenu&&(n=i.getPath(),o=this.editor.options.onCreateMenu(o,{type:"single",path:n,paths:[n]})),new s.x(o,{close:t}).show(e,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var n=this,e=this.editor.options.modalAnchor||m.qD,t=this.getValue();(0,u.showSortModal)(e,t,function(e){var t=e.path,t=(0,_.parsePath)(t);n.sortedBy=e,n.sort(t,e.direction)},n.sortedBy)}},{key:"showTransformModal",value:function(){var t=this,e=this.editor.options,n=e.modalAnchor,i=e.createQuery,o=e.executeQuery,e=e.queryDescription,r=this.getValue();(0,p.showTransformModal)({container:n||m.qD,json:r,queryDescription:e,createQuery:i,executeQuery:o,onTransform:function(e){t.transform(e)}})}},{key:"_getType",value:function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof(0,_.parseString)(e)?"string":"auto"}},{key:"_escapeHTML",value:function(e){return"string"!=typeof e?String(e):(e=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),e=(e=JSON.stringify(e)).substring(1,e.length-1),!0===this.editor.options.escapeUnicode?(0,_.escapeUnicodeChars)(e):e)}},{key:"_unescapeHTML",value:function(e){e='"'+this._escapeJSON(e)+'"';return(0,_.parse)(e).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(e){for(var t="",n=0;n<e.length;){var i=e.charAt(n);"\n"===i?t+="\\n":"\\"===i?(t+=i,n++,""!==(i=e.charAt(n))&&-1!=='"\\/bfnrtu'.indexOf(i)||(t+="\\"),t+=i):t+='"'===i?'\\"':i,n++}return t}},{key:"updateNodeName",value:function(){var e=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{var t=this.getValue.bind(this),n=this.editor.options.onNodeName({path:this.getPath(),size:e,type:this.type,get value(){return t()}})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.textContent="object"===this.type?"{"+(n||e)+"}":"["+(n||e)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(var e in this.childs)this.childs[e].recursivelyUpdateNodeName()}}])&&v(e.prototype,t),n&&v(e,n),Object.defineProperty(e,"prototype",{writable:!1}),w}(),R=(k.prototype.DEBOUNCE_INTERVAL=150,k.prototype.MAX_SEARCH_RESULTS=999,100);function y(e){return e.getInternalPath()}function I(e){return e.getField()}function b(e,t){return Object.prototype.hasOwnProperty.call(e,t)}k.focusElement=void 0,k.select=function(e){setTimeout(function(){(0,_.selectContentEditable)(e)},0)},k.onDragStart=function(t,e){if(!Array.isArray(t))return k.onDragStart([t],e);var n,i,o,r,s;0!==t.length&&(n=t[0],i=t[t.length-1],o=n.parent,s=k.getNodeFromTarget(e.target),r=n.editor,s=(0,_.getAbsoluteTop)(s.dom.tr)-(0,_.getAbsoluteTop)(n.dom.tr),r.mousemove||(r.mousemove=(0,_.addEventListener)(e.view,"mousemove",function(e){k.onDrag(t,e)})),r.mouseup||(r.mouseup=(0,_.addEventListener)(e.view,"mouseup",function(e){k.onDragEnd(t,e)})),r.highlighter.lock(),r.drag={oldCursor:document.body.style.cursor,oldSelection:r.getDomSelection(),oldPaths:t.map(y),oldParent:o,oldNextNode:o.childs[i.getIndex()+1]||o.append,oldParentPathRedo:o.getInternalPath(),oldIndexRedo:n.getIndex(),mouseX:e.pageX,offsetY:s,level:n.getLevel()},document.body.style.cursor="move",e.preventDefault())},k.onDrag=function(e,t){if(!Array.isArray(e))return k.onDrag([e],t);if(0!==e.length){var n,i,o,r,s,a=e[0].editor,l=t.pageY-a.drag.offsetY,c=t.pageX,d=!1,h=e[0],u=h.dom.tr,p=(0,_.getAbsoluteTop)(u),m=u.offsetHeight;if(l<p){for(y=u;y=y.previousSibling,b=k.getNodeFromTarget(y),o=y?(0,_.getAbsoluteTop)(y):0,y&&l<o;);(b=b&&!b.parent?void 0:b)||(y=(u=u.parentNode.firstChild)?u.nextSibling:void 0,(b=k.getNodeFromTarget(y))===h&&(b=void 0)),!(b=b&&b.isVisible()&&(o=(y=b.dom.tr)?(0,_.getAbsoluteTop)(y):0)+m<l?void 0:b)||!1!==a.options.limitDragging&&b.parent!==e[0].parent||(e.forEach(function(e){b.parent.moveBefore(e,b)}),d=!0)}else{var f=e[e.length-1];if(m=(u=f.expanded&&f.append?f.append.getDom():f.dom.tr)?u.nextSibling:void 0){for(r=(0,_.getAbsoluteTop)(m),n=m;i=k.getNodeFromTarget(n),n&&(s=n.nextSibling?(0,_.getAbsoluteTop)(n.nextSibling):0,s=n?s-r:0,i&&i.parent.childs.length===e.length&&i.parent.childs[e.length-1]===f&&(p+=27),n=n.nextSibling),n&&p+s<l;);if(i&&i.parent){for(var m=c-a.drag.mouseX,m=Math.round(m/24/2),g=a.drag.level+m,v=i.getLevel(),y=i.dom.tr&&i.dom.tr.previousSibling;v<g&&y;){var b=k.getNodeFromTarget(y),x=e.some(function(e){return e===b||b.isDescendantOf(e)});if(!x){if(!(b instanceof j))break;x=b.parent.childs;if(x.length===e.length&&x[e.length-1]===f)break;v=(i=k.getNodeFromTarget(y)).getLevel()}y=y.previousSibling}(i=i instanceof j&&!i.isVisible()&&i.parent.showMore.isVisible()?i._nextNode():i)&&(!1===a.options.limitDragging||i.parent===e[0].parent)&&i.dom.tr&&i.dom.tr!==u.nextSibling&&(e.forEach(function(e){i.parent.moveBefore(e,i)}),d=!0)}}}d&&(a.drag.mouseX=c,a.drag.level=h.getLevel()),a.startAutoScroll(l),t.preventDefault()}},k.onDragEnd=function(e,t){if(!Array.isArray(e))return k.onDrag([e],t);var n,i,o,r,s,a,l,c,d;0!==e.length&&(a=e[0],n=a.editor,a&&a.dom.menu&&a.dom.menu.focus(),i=n.drag.oldParent.getInternalPath(),o=a.parent.getInternalPath(),r=n.drag.oldParent===a.parent,s=n.drag.oldNextNode.getIndex(),a=a.getIndex(),l=n.drag.oldParentPathRedo,c=n.drag.oldIndexRedo,d=r&&c<a?a+e.length:a,r&&c===a||n._onAction("moveNodes",{count:e.length,fieldNames:e.map(I),oldParentPath:i,newParentPath:o,oldIndex:s,newIndex:a,oldIndexRedo:c,newIndexRedo:d,oldParentPathRedo:l,newParentPathRedo:null,oldSelection:n.drag.oldSelection,newSelection:n.getDomSelection()}),document.body.style.cursor=n.drag.oldCursor,n.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&n.highlighter.unhighlight()}),delete n.drag,n.mousemove&&((0,_.removeEventListener)(t.view,"mousemove",n.mousemove),delete n.mousemove),n.mouseup&&((0,_.removeEventListener)(t.view,"mouseup",n.mouseup),delete n.mouseup),n.stopAutoScroll(),t.preventDefault())},k._findEnum=function(e){if(e.enum)return e.enum;e=e.oneOf||e.anyOf||e.allOf;if(e){e=e.filter(function(e){return e.enum});if(0<e.length)return e[0].enum}return null},k._findSchema=function(e,t,n){for(var i=3<arguments.length&&void 0!==arguments[3]?arguments[3]:e,o=n.slice(1,n.length),r=n[0],s=[i],a=0,l=[i.oneOf,i.anyOf,i.allOf];a<l.length;a++){var c=l[a];Array.isArray(c)&&(s=s.concat(c))}var d,h=w(s);try{for(h.s();!(d=h.n()).done;){if("$ref"in(i=d.value)&&"string"==typeof i.$ref){var u,p=i.$ref;if(p in t)i=t[p];else{if(!p.startsWith("#/")){if(1===(null==(u=p.match(/#\//g))?void 0:u.length)){var m,f,g,v=L(p.split("#/"),2),y=v[0],b=v[1];if(y in t)return m=t[y],f={$ref:"#/".concat(b)},(g=[]).push(r),0<o.length&&g.push.apply(g,V(o)),k._findSchema(m,t,g,f)}throw Error("Unable to resolve reference ".concat(p))}var x,C=p.substring(2).split("/"),i=e,T=w(C);try{for(T.s();!(x=T.n()).done;){var E=x.value;if(!(E in i))throw Error("Unable to resolve reference ".concat(p));i=i[E]}}catch(e){T.e(e)}finally{T.f()}}}if(void 0===r)return i;if("string"==typeof r){if("object"===N(i.properties)&&null!==i.properties&&r in i.properties)return i=i.properties[r],k._findSchema(e,t,o,i);if("object"===N(i.patternProperties)&&null!==i.patternProperties)for(var S in i.patternProperties)if(r.match(S))return i=i.patternProperties[S],k._findSchema(e,t,o,i);if("object"===N(i.additionalProperties))return i=i.additionalProperties,k._findSchema(e,t,o,i)}else if("number"==typeof r&&"object"===N(i.items)&&null!==i.items)return i=i.items,k._findSchema(e,t,o,i)}}catch(e){h.e(e)}finally{h.f()}return null},k.onRemove=function(e){if(!Array.isArray(e))return k.onRemove([e]);var t,n,i,o,r,s;e&&0<e.length&&(t=(i=e[0]).parent,n=i.editor,i=i.getIndex(),n.highlighter.unhighlight(),o=n.getDomSelection(),k.blurNodes(e),r=n.getDomSelection(),s=e.map(y),e.forEach(function(e){e.parent._remove(e)}),n._onAction("removeNodes",{nodes:e,paths:s,parentPath:t.getInternalPath(),index:i,oldSelection:o,newSelection:r}))},k.onDuplicate=function(e){if(!Array.isArray(e))return k.onDuplicate([e]);var t,i,n,o,r,s,a;e&&0<e.length&&(t=e[e.length-1],i=t.parent,(n=t.editor).deselect(n.multiselection.nodes),o=n.getDomSelection(),r=t,s=e.map(function(e){var t,n=e.clone();return"object"===e.parent.type&&(t=e.parent.getFieldNames(),n.field=(0,_.findUniqueName)(e.field,t)),i.insertAfter(n,r),r=n}),1===e.length?"object"===s[0].parent.type?(s[0].dom.field.innerHTML=e[0]._escapeHTML(e[0].field),s[0].focus("field")):s[0].focus():n.select(s),a=n.getDomSelection(),n._onAction("duplicateNodes",{paths:e.map(y),clonePaths:s.map(y),afterPath:t.getInternalPath(),parentPath:i.getInternalPath(),oldSelection:o,newSelection:a}))},k.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},k.targetIsColorPicker=function(e){var t=k.getNodeFromTarget(e);if(t)for(var n=e&&e.parentNode;n;){if(n===t.dom.color)return!0;n=n.parentNode}return!1},k.blurNodes=function(e){var t,n;Array.isArray(e)?(t=(n=e[0]).parent,n=n.getIndex(),(t.childs[n+e.length]?t.childs[n+e.length]:t.childs[n-1]||t).focus()):k.blurNodes([e])};(n.prototype=new k).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr"),n=(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode&&(e.tdDrag=document.createElement("td"),i=document.createElement("td"),e.tdMenu=i,(n=document.createElement("button")).type="button",n.className="jsoneditor-button jsoneditor-contextmenu-button",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)),document.createElement("td")),i=document.createElement("div");return i.appendChild(document.createTextNode("("+(0,l.Iu)("empty")+")")),i.className="jsoneditor-readonly",n.appendChild(i),e.td=n,e.text=i,this.updateDom(),t},n.prototype.getPath=function(){return null},n.prototype.getIndex=function(){return null},n.prototype.updateDom=function(e){var t=this.dom,n=t.td,i=(n&&(n.style.paddingLeft=24*this.getLevel()+26+"px"),t.text),i=(i&&(i.firstChild.nodeValue="("+(0,l.Iu)("empty")+" "+this.parent.type+")"),t.tr);this.isVisible()?t.tr.firstChild||(t.tdDrag&&i.appendChild(t.tdDrag),t.tdMenu&&i.appendChild(t.tdMenu),i.appendChild(n)):t.tr.firstChild&&(t.tdDrag&&i.removeChild(t.tdDrag),t.tdMenu&&i.removeChild(t.tdMenu),i.removeChild(n))},n.prototype.isVisible=function(){return 0===this.parent.childs.length},n.prototype.showContextMenu=function(e,t){var n,i=this,o=[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,l.Iu)("autoType"),click:function(){i._onAppend("","","auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array",title:(0,l.Iu)("arrayType"),click:function(){i._onAppend("",[])}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object",title:(0,l.Iu)("objectType"),click:function(){i._onAppend("",{})}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string",title:(0,l.Iu)("stringType"),click:function(){i._onAppend("","","string")}}],o=(i.addTemplates(o,!0),[{text:(0,l.Iu)("appendText"),title:(0,l.Iu)("appendTitleAuto"),submenuTitle:(0,l.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:o}]);this.editor.options.onCreateMenu&&(n=i.parent.getPath(),o=this.editor.options.onCreateMenu(o,{type:"append",path:n,paths:[n]})),new s.x(o,{close:t}).show(e,this.editor.getPopupAnchor())},n.prototype.onEvent=function(e){var t,n=e.type,i=e.target||e.srcElement,o=this.dom;i===o.menu&&("mouseover"===n?this.editor.highlighter.highlight(this.parent):"mouseout"===n&&this.editor.highlighter.unhighlight()),"click"===n&&i===o.menu&&((t=this.editor.highlighter).highlight(this.parent),t.lock(),(0,_.addClassName)(o.menu,"jsoneditor-selected"),this.showContextMenu(o.menu,function(){(0,_.removeClassName)(o.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"keydown"===n&&this.onKeyDown(e)};var j=n;function n(e){this.editor=e,this.dom={}}(x.prototype=new k).getDom=function(){var t,n,e,i,o,r;return this.dom.tr||(this._updateEditability(),this.dom.tr||(n=(t=this).parent,(o=document.createElement("a")).appendChild(document.createTextNode((0,l.Iu)("showMore"))),o.href="#",o.onclick=function(e){return n.visibleChilds=Math.floor(n.visibleChilds/n.getMaxVisibleChilds()+1)*n.getMaxVisibleChilds(),t.updateDom(),n.showChilds(),e.preventDefault(),!1},(r=document.createElement("a")).appendChild(document.createTextNode((0,l.Iu)("showAll"))),r.href="#",r.onclick=function(e){return n.visibleChilds=1/0,t.updateDom(),n.showChilds(),e.preventDefault(),!1},e=document.createElement("div"),i=document.createTextNode(this._getShowMoreText()),e.className="jsoneditor-show-more",e.appendChild(i),e.appendChild(o),e.appendChild(document.createTextNode(". ")),e.appendChild(r),e.appendChild(document.createTextNode(". ")),(o=document.createElement("td")).appendChild(e),r=document.createElement("tr"),"tree"===this.editor.options.mode&&(r.appendChild(document.createElement("td")),r.appendChild(document.createElement("td"))),r.appendChild(o),r.className="jsoneditor-show-more",this.dom.tr=r,this.dom.moreContents=e,this.dom.moreText=i),this.updateDom()),this.dom.tr},x.prototype.updateDom=function(e){var t;this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(t=this.parent._getNextTr())&&t.parentNode.insertBefore(this.dom.tr,t),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},x.prototype._getShowMoreText=function(){return(0,l.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},x.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},x.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)};var B=x;function x(e,t){this.editor=e,this.parent=t,this.dom={}}function C(e){return(C="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function T(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=C(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=C(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==C(e)?e:String(e)}(i.key),i)}}var z=function(){function e(t){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");function r(e){return t.node.findNodeByInternalPath(e)}this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){r(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){r(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){r(e.path).updateValue(e.oldValue)},redo:function(e){r(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){r(e.path).changeType(e.oldType)},redo:function(e){r(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),n=r(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,n)})}},insertAfterNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),n=r(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,n),n=e})}},removeNodes:{undo:function(e){var t=r(e.parentPath),n=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,n)})},redo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=r(e.parentPath);e.clonePaths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var i=r(e.parentPath),o=r(e.afterPath);e.paths.map(r).forEach(function(e){var t,n=e.clone();"object"===i.type&&(t=i.getFieldNames(),n.field=(0,_.findUniqueName)(e.field,t)),i.insertAfter(n,o),o=n})}},moveNodes:{undo:function(n){var i=r(n.oldParentPath),e=r(n.newParentPath),o=i.childs[n.oldIndex]||i.append;e.childs.slice(n.newIndex,n.newIndex+n.count).forEach(function(e,t){e.field=n.fieldNames[t],i.moveBefore(e,o)}),null===n.newParentPathRedo&&(n.newParentPathRedo=e.getInternalPath())},redo:function(n){var e=r(n.oldParentPathRedo),i=r(n.newParentPathRedo),o=i.childs[n.newIndexRedo]||i.append;e.childs.slice(n.oldIndexRedo,n.oldIndexRedo+n.count).forEach(function(e,t){e.field=n.fieldNames[t],i.moveBefore(e,o)})}},sort:{undo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){r(e.path).setInternalValue(e.oldValue)},redo:function(e){r(e.path).setInternalValue(e.newValue)}}}}var t,n,i;return t=e,(n=[{key:"onChange",value:function(){}},{key:"add",value:function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}])&&T(t.prototype,n),i&&T(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}();function A(e){return(A="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function P(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=A(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=A(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==A(e)?e:String(e)}(i.key),i)}}var H=function(){function o(e,t){if(!(this instanceof o))throw new TypeError("Cannot call a class as a function");var n=this,e=(this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=t,document.createElement("div")),t=((this.dom.wrapper=e).className="jsoneditor-search",t.appendChild(e),document.createElement("div")),t=((this.dom.results=t).className="jsoneditor-results",e.appendChild(t),document.createElement("div")),e=((this.dom.input=t).className="jsoneditor-frame",t.title=(0,l.Iu)("searchTitle"),e.appendChild(t),document.createElement("button")),i=(e.type="button",e.className="jsoneditor-refresh",t.appendChild(e),document.createElement("input")),e=(i.type="text",(this.dom.search=i).oninput=function(e){n._onDelayedSearch(e)},i.onchange=function(e){n._onSearch()},i.onkeydown=function(e){n._onKeyDown(e)},i.onkeyup=function(e){n._onKeyUp(e)},e.onclick=function(e){i.select()},t.appendChild(i),document.createElement("button")),e=(e.type="button",e.title=(0,l.Iu)("searchNextResultTitle"),e.className="jsoneditor-next",e.onclick=function(){n.next()},t.appendChild(e),document.createElement("button"));e.type="button",e.title=(0,l.Iu)("searchPreviousResultTitle"),e.className="jsoneditor-previous",e.onclick=function(){n.previous()},t.appendChild(e)}var e,t,n;return e=o,(t=[{key:"next",value:function(e){var t;this.results&&((t=null!==this.resultIndex?this.resultIndex+1:0)>this.results.length-1&&(t=0),this._setActiveResult(t,e))}},{key:"previous",value:function(e){var t,n;this.results&&(t=this.results.length-1,n=null!==this.resultIndex?this.resultIndex-1:t,this._setActiveResult(n=n<0?t:n,e))}},{key:"_setActiveResult",value:function(e,t){var n,i,o;this.activeResult&&(n=this.activeResult.node,"field"===this.activeResult.elem?delete n.searchFieldActive:delete n.searchValueActive,n.updateDom()),this.results&&this.results[e]?(this.resultIndex=e,i=this.results[this.resultIndex].node,"field"===(o=this.results[this.resultIndex].elem)?i.searchFieldActive=!0:i.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],i.updateDom(),i.scrollTo(function(){t&&i.focus(o)})):(this.resultIndex=void 0,this.activeResult=void 0)}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)}},{key:"_onSearch",value:function(e){this._clearDelay();var t=this.dom.search.value,t=0<t.length?t:void 0;if(t!==this.lastText||e){this.lastText=t,this.results=this.editor.search(t);var e=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,n=0;if(this.activeResult)for(var i=0;i<this.results.length;i++)if(this.results[i].node===this.activeResult.node){n=i;break}this._setActiveResult(n,!1),void 0!==t?(t=this.results.length,this.dom.results.textContent=0===t?"no results":1===t?"1 result":e<t?e+"+ results":t+" results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(e){var t=e.which;27===t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13===t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())}},{key:"_onKeyUp",value:function(e){var t=e.keyCode;27!==t&&13!==t&&this._onDelayedSearch(e)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}])&&P(e.prototype,t),n&&P(e,n),Object.defineProperty(e,"prototype",{writable:!1}),o}();function D(e){return(D="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function O(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=D(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=D(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==D(e)?e:String(e)}(i.key),i)}}var J=function(){function n(e,t){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,e.appendChild(this.path),this.reset())}var e,t,i;return e=n,(t=[{key:"reset",value:function(){this.path.textContent=(0,l.Iu)("selectNode")}},{key:"setPath",value:function(o){var r=this;this.path.textContent="",o&&o.length&&o.forEach(function(n,i){var e,t=document.createElement("span");t.className="jsoneditor-treepath-element",t.innerText=n.name,t.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(r,n),r.path.appendChild(t),n.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.textContent="►",e.onclick=function(){r.contentMenuClicked=!0;var t=[];n.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(o[i+1]+1&&o[i+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(r,n,e.name)})}),new s.x(t,{limitHeight:!0}).show(e,r.root,!0)},r.path.appendChild(e)),i===o.length-1&&(t=(e||t).getBoundingClientRect().right,r.path.offsetWidth<t&&(r.path.scrollLeft=t),r.path.scrollLeft)&&((t=document.createElement("span")).className="jsoneditor-treepath-show-all-btn",t.title="show all path",t.textContent="...",t.onclick=function(e){(r.contentMenuClicked=!1,_.addClassName)(r.path,"show-all"),r.path.style.width=r.path.parentNode.getBoundingClientRect().width-10+"px",r.path.onblur=function(){r.contentMenuClicked?(r.contentMenuClicked=!1,r.path.focus()):((0,_.removeClassName)(r.path,"show-all"),r.path.onblur=void 0,r.path.style.width="",r.setPath(e))}}.bind(r,o),r.path.insertBefore(t,r.path.firstChild))})}},{key:"onSectionSelected",value:function(e){"function"==typeof e&&(this.selectionCallback=e)}},{key:"onContextMenuItemSelected",value:function(e){"function"==typeof e&&(this.contextMenuCallback=e)}}])&&O(e.prototype,t),i&&O(e,i),Object.defineProperty(e,"prototype",{writable:!1}),n}(),e=t(37),F=t.n(e),t={},U=(t.create=function(e,t){if(!e)throw new Error("No container element provided.");function r(e){var t,n;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(n=window.getSelection()).removeAllRanges(),n.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function s(e){return void 0===n&&((n=document.createElement("span")).style.visibility="hidden",n.style.position="fixed",n.style.outline="0",n.style.margin="0",n.style.padding="0",n.style.border="0",n.style.left="0",n.style.whiteSpace="pre",n.style.fontSize=o,n.style.fontFamily=u,n.style.fontWeight="normal",document.body.appendChild(n)),n.textContent=e,n.getBoundingClientRect().right}function a(){this.style.backgroundColor="#ddd"}function l(){this.style.backgroundColor=""}function c(){y.hide(),y.onmouseselection(this.__hint,y.rs)}var d,n,h,o,u,p,m,f,g,v,i,y,b,x,C,T;this.container=e,this.dom={},this.highlighter=new S,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.lastSchemaErrors=void 0,this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=((d=(d=t.autocomplete)||{}).filter=d.filter||"start",d.trigger=d.trigger||"keydown",d.confirmKeys=d.confirmKeys||[39,35,9],d.caseSensitive=d.caseSensitive||!1,u=o="",(p=document.createElement("div")).style.position="relative",p.style.outline="0",p.style.border="0",p.style.margin="0",p.style.padding="0",(m=document.createElement("div")).className="autocomplete dropdown",m.style.position="absolute",m.style.visibility="hidden",f=m,g=[],i=-1,x=y={rs:b={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:v=0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:p,show:function(e,t,n){var i=this;this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""===o&&(o=window.getComputedStyle(e).getPropertyValue("font-size")),""===u&&(u=window.getComputedStyle(e).getPropertyValue("font-family")),m.style.marginLeft="0",m.style.marginTop=e.getBoundingClientRect().height+"px",this.options=n.map(String),this.element!==e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){i.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",C),this.element.addEventListener("keydown",C,!1),this.element.removeEventListener("blur",T),this.element.addEventListener("blur",T,!1)),p.appendChild(this.elementHint),p.appendChild(m),e.parentElement.appendChild(p),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,x.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var e=(e=e.innerText).replace("\n",""),t=this.options.length,n=e.substring(this.startFrom);h=e.substring(0,this.startFrom);for(var i=0;i<t;i++){var o=this.options[i];if(!d.caseSensitive&&0===o.toLowerCase().indexOf(n.toLowerCase())||d.caseSensitive&&0===o.indexOf(n)){this.elementHint.innerText=h+n+o.substring(n.length),this.elementHint.realInnerText=h+o;break}}m.style.left=s(h)+"px",x.refresh(n,this.options),this.elementHint.style.width=s(this.elementHint.innerText)+10+"px","hidden"!==m.style.visibility&&(this.elementHint.style.width=s(this.elementHint.innerText)+m.clientWidth+"px")}},hide:function(){f.style.visibility="hidden"},refresh:function(i,e){f.style.visibility="hidden",v=0,f.textContent="";var t=window.innerHeight||document.documentElement.clientHeight,n=f.parentNode.getBoundingClientRect(),o=n.top-6,t=t-n.bottom-6,r=(g=[],"function"==typeof d.filter?d.filter:E[d.filter]),n=r?e.filter(function(e){return r(d.caseSensitive?i:i.toLowerCase(),d.caseSensitive?e:e.toLowerCase(),d)}):[];0===(g=n.map(function(e){var t=document.createElement("div"),n=(t.className="item",t.onmouseover=a,t.onmouseout=l,t.onmousedown=c,t.__hint=e,t.textContent="",t.appendChild(document.createTextNode(e.substring(0,i.length))),document.createElement("b"));return n.appendChild(document.createTextNode(e.substring(i.length))),t.appendChild(n),f.appendChild(t),t})).length||1===g.length&&(i.toLowerCase()===g[0].__hint.toLowerCase()&&!d.caseSensitive||i===g[0].__hint&&d.caseSensitive)||g.length<2||(y.highlight(0),3*t<o?(f.style.maxHeight=o+"px",f.style.top="",f.style.bottom="100%"):(f.style.top="100%",f.style.bottom="",f.style.maxHeight=t+"px"),f.style.visibility="visible")},highlight:function(e){-1!==i&&g[i]&&(g[i].className="item"),g[e].className="item hover",i=e},move:function(e){return"hidden"===f.style.visibility?"":(v+e!==-1&&v+e!==g.length&&(v+=e,y.highlight(v)),g[v].__hint)},onmouseselection:function(){}},C=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!==t&&34!==t)if(27===t)b.hideDropDown(),b.element.focus(),e.preventDefault(),e.stopPropagation();else{var n,i=(i=this.element.innerText).replace("\n","");if(0<=d.confirmKeys.indexOf(t))9===t&&0===this.elementHint.innerText.length&&b.onTab(),0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,b.hideDropDown(),r(this.element),9===t)&&(b.element.focus(),e.preventDefault(),e.stopPropagation());else if(13===t)if(0===this.elementHint.innerText.length)b.onEnter();else{var o="hidden"===m.style.visibility;if(x.hide(),o)return b.hideDropDown(),b.element.focus(),void b.onEnter();this.element.innerText=this.elementHint.realInnerText,b.hideDropDown(),r(this.element),e.preventDefault(),e.stopPropagation()}else 40===t?(o=i.substring(this.startFrom),""===(n=x.move(1))&&b.onArrowDown(),this.elementHint.innerText=h+o+n.substring(o.length),this.elementHint.realInnerText=h+n,e.preventDefault(),e.stopPropagation()):38===t&&(o=i.substring(this.startFrom),""===(n=x.move(-1))&&b.onArrowUp(),this.elementHint.innerText=h+o+n.substring(o.length),this.elementHint.realInnerText=h+n,e.preventDefault(),e.stopPropagation())}}.bind(b),T=function(e){b.hideDropDown()},x.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=h+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),r(t.element)},1)},b)),this.options.history&&"view"!==this.options.mode&&(this.history=new z(this)),this._createFrame(),this._createTable()},t.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.frameFocusTracker.destroy()},t._setOptions=function(t){var n=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,n){var i;F()?(i=e.getBoundingClientRect().top,i=(0,_.getWindow)(e).innerHeight-i<300&&300<i,new(F())({parent:e,color:t,popup:i?"top":"bottom",onDone:function(e){e=1===e.rgba[3]?e.hex.substr(0,7):e.hex;n(e)}}).show()):console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:i.r,executeQuery:i.J,onEvent:null,enableSort:!0,enableTransform:!0},t&&(Object.keys(t).forEach(function(e){n.options[e]=t[e]}),null==t.limitDragging)&&null!=t.schema&&(this.options.limitDragging=!0),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=(0,_.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),t.onSelectionChange&&this.onSelectionChange(t.onSelectionChange),(0,l.cC)(this.options.languages),(0,l.m0)(this.options.language)},t.set=function(e){e instanceof Function||void 0===e?this.clear():(this.content.removeChild(this.table),e={field:this.options.name,value:e},e=new k(this,e),this._setRoot(e),this._validateAndCatch(),this.node.expand(!1),this.content.appendChild(this.table)),this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},t.update=function(e){var t,n;this.node.deepEqual(e)||(t=this.getSelection(),this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this._validateAndCatch(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end&&(e=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path),e)&&n?this.setSelection(t.start,t.end):this.setSelection({},{}))},t.get=function(){if(this.node)return this.node.getValue()},t.getText=function(){return JSON.stringify(this.get())},t.setText=function(t){try{this.set((0,_.parse)(t))}catch(e){t=(0,_.tryJsonRepair)(t);this.set((0,_.parse)(t))}},t.updateText=function(t){try{this.update((0,_.parse)(t))}catch(e){t=(0,_.tryJsonRepair)(t);this.update((0,_.parse)(t))}},t.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},t.getName=function(){return this.options.name},t.focus=function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},t.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},t._setRoot=function(e){this.clear(),(this.node=e).setParent(null),e.setField(this.getName(),!1),delete e.index,this.tbody.appendChild(e.getDom())},t.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},t.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},t.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},t.expand=function(e){var t;e&&(t=this.node?this.node.findNodeByPath(e.path):null)&&(e.isExpand?t.expand(e.recursive):t.collapse(e.recursive))},t._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},t._onChange=function(){if(!this.onChangeDisabled){var e;if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath&&((e=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0)?this._updateTreePath(e.getNodePath()):this.treePath.reset()),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},t.validate=function(){var t=this,n=this.node;if(n){var e=n.getValue(),i=[];this.validateSchema&&!this.validateSchema(e)&&(i=this.validateSchema.errors.map(function(e){return(0,_.improveSchemaError)(e)}).map(function(e){return{node:n.findNode(e.dataPath),error:e,type:"validation"}}).filter(function(e){return null!=e.node}));try{this.validationSequence++;var o=this,r=this.validationSequence;return this._validateCustom(e).then(function(e){return r===o.validationSequence&&(e=[].concat(i,e||[]),o._renderValidationErrors(e),"function"==typeof t.options.onValidationError&&(0,_.isValidationErrorChanged)(e,t.lastSchemaErrors)&&t.options.onValidationError.call(t,e),t.lastSchemaErrors=e),t.lastSchemaErrors})}catch(e){return Promise.reject(e)}}},t._validateAndCatch=function(){this.validate().catch(function(e){console.error("Error running validation:",e)})},t._renderValidationErrors=function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?(0,l.Iu)("containsInvalidProperties"):(0,l.Iu)("containsInvalidItems")}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},t._validateCustom=function(e){try{var n,t;if(this.options.onValidate)return n=this.node,t=this.options.onValidate(e),((0,_.isPromise)(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=(0,_.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?n.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e,type:"customValidation"}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}catch(e){return Promise.reject(e)}return Promise.resolve(null)},t.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},t.startAutoScroll=function(e){var t=this,n=this.scrollableContent,i=(0,_.getAbsoluteTop)(n),o=n.clientHeight,r=i+o;e<i+24&&0<n.scrollTop?this.autoScrollStep=(i+24-e)/3:r-24<e&&o+n.scrollTop<n.scrollHeight?this.autoScrollStep=(r-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?n.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},t.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},t.setDomSelection=function(e){var t,n,i;e&&("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths?(t=this,n=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)}),this.select(n)):(i=(n=e.path?this.node.findNodeByInternalPath(e.path):null)&&e.domName?n.dom[e.domName]:null,e.range&&i?(e=Object.assign({},e.range,{container:i}),(0,_.setSelectionOffset)(e)):n&&n.focus()))},t.getDomSelection=function(){var t=k.getNodeFromTarget(this.focusTarget),n=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===n}):null,i=(0,_.getSelectionOffset)();return(i=(i=i&&"DIV"!==i.container.nodeName?null:i)&&i.container!==n?null:i)&&delete i.container,{path:t?t.getInternalPath():null,domName:e,range:i,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},t.scrollTo=function(e,n){var i,t,o,r,s=this.scrollableContent;s?((i=this).animateTimeout&&(clearTimeout(i.animateTimeout),delete i.animateTimeout),i.animateCallback&&(i.animateCallback(!1),delete i.animateCallback),t=s.clientHeight,o=s.scrollHeight-t,r=Math.min(Math.max(e-t/4,0),o),function e(){var t=s.scrollTop,t=r-t;3<Math.abs(t)?(s.scrollTop+=t/3,i.animateCallback=n,i.animateTimeout=setTimeout(e,50)):(n&&n(!0),s.scrollTop=r,delete i.animateTimeout,delete i.animateCallback)}()):n&&n(!1)},t._createFrame=function(){var e=this,t=(this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer",this);function n(e){t._onEvent&&t._onEvent(e)}var i,o,r,s={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new a.R(s),this.frame.onclick=function(e){var t=e.target;n(e),"BUTTON"===t.nodeName&&e.preventDefault()},this.frame.oninput=n,this.frame.onchange=n,this.frame.onkeydown=n,this.frame.onkeyup=n,this.frame.oncut=n,this.frame.onpaste=n,this.frame.onmousedown=n,this.frame.onmouseup=n,this.frame.onmouseover=n,this.frame.onmouseout=n,(0,_.addEventListener)(this.frame,"focus",n,!0),(0,_.addEventListener)(this.frame,"blur",n,!0),this.frame.onfocusin=n,this.frame.onfocusout=n,this.options.mainMenuBar&&((0,_.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(s=document.createElement("button")).type="button",s.className="jsoneditor-expand-all",s.title=(0,l.Iu)("expandAll"),s.onclick=function(){t.expandAll(),"function"==typeof e.options.onExpand&&e.options.onExpand({path:[],isExpand:!0,recursive:!0})},this.menu.appendChild(s),(s=document.createElement("button")).type="button",s.title=(0,l.Iu)("collapseAll"),s.className="jsoneditor-collapse-all",s.onclick=function(){t.collapseAll(),"function"==typeof e.options.onExpand&&e.options.onExpand({path:[],isExpand:!1,recursive:!0})},this.menu.appendChild(s),this.options.enableSort&&((s=document.createElement("button")).type="button",s.className="jsoneditor-sort",s.title=(0,l.Iu)("sortTitleShort"),s.onclick=function(){t.node.showSortModal()},this.menu.appendChild(s)),this.options.enableTransform&&((s=document.createElement("button")).type="button",s.title=(0,l.Iu)("transformTitleShort"),s.className="jsoneditor-transform",s.onclick=function(){t.node.showTransformModal()},this.menu.appendChild(s)),this.history&&((i=document.createElement("button")).type="button",i.className="jsoneditor-undo jsoneditor-separator",i.title=(0,l.Iu)("undo"),i.onclick=function(){t._onUndo()},this.menu.appendChild(i),this.dom.undo=i,(o=document.createElement("button")).type="button",o.className="jsoneditor-redo",o.title=(0,l.Iu)("redo"),o.onclick=function(){t._onRedo()},this.menu.appendChild(o),this.dom.redo=o,this.history.onChange=function(){i.disabled=!t.history.canUndo(),o.disabled=!t.history.canRedo()},this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&((r=this).modeSwitcher=new c.x(this.menu,this.options.modes,this.options.mode,function(e){try{r.setMode(e),r.modeSwitcher.focus()}catch(e){r._onError(e)}})),this.options.search)&&(this.searchBox=new H(this,this.menu)),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new J(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},t._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},t._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},t._onEvent=function(e){if(!k.targetIsColorPicker(e.target)){var t,n=k.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),n&&"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete)&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),n&&this.options&&this.options.navigationBar&&n&&("keydown"===e.type||"mousedown"===e.type)&&(t=this,setTimeout(function(){t._updateTreePath(n.getNodePath())})),n&&n.selected){if("click"===e.type){if(e.target===n.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&k.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&(0,_.hasParentNode)(e.target,this.content)&&(this.deselect(),n&&e.target===n.dom.drag?k.onDragStart(n,e):n&&(e.target===n.dom.field||e.target===n.dom.value||e.target===n.dom.select)||this._onMultiSelectStart(e));n&&n.onEvent(e)}},t._updateTreePath=function(e){var n;function i(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.field||e.type}e&&e.length?((0,_.removeClassName)(this.navBar,"nav-bar-empty"),n=[],e.forEach(function(e){var t={name:i(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:i(e),node:e})}),n.push(t)}),this.treePath.setPath(n)):(0,_.addClassName)(this.navBar,"nav-bar-empty")},t._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},t._onTreePathMenuItemSelected=function(e,t){e&&e.children.length&&(e=e.children.find(function(e){return e.name===t}))&&e.node&&(this._updateTreePath(e.node.getNodePath()),e.node.expandTo(),e.node.focus())},t._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},t._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,n=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+n*n),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},t._onMultiSelectStart=function(e){var t,n=k.getNodeFromTarget(e.target);"tree"===this.options.mode&&void 0===this.options.onEditable&&(this.multiselection={start:n||null,end:null,nodes:[]},this._startDragDistance(e),(t=this).mousemove||(this.mousemove=(0,_.addEventListener)(e.view,"mousemove",function(e){t._onMultiSelect(e)})),this.mouseup||(this.mouseup=(0,_.addEventListener)(e.view,"mouseup",function(e){t._onMultiSelectEnd(e)})),e.preventDefault())},t._onMultiSelect=function(e){var t;e.preventDefault(),this._updateDragDistance(e),e.hasMoved&&((e=k.getNodeFromTarget(e.target))&&(null==this.multiselection.start&&(this.multiselection.start=e),this.multiselection.end=e),this.deselect(),e=this.multiselection.start,t=this.multiselection.end||this.multiselection.start,e)&&t&&(this.multiselection.nodes=this._findTopLevelNodes(e,t),this.multiselection.nodes&&this.multiselection.nodes.length&&(e=this.multiselection.nodes[0],this.multiselection.start===e||this.multiselection.start.isDescendantOf(e)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes))},t._onMultiSelectEnd=function(e){var t=this.multiselection.nodes[0];t&&t.dom.menu&&t.dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&((0,_.removeEventListener)(e.view,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&((0,_.removeEventListener)(e.view,"mouseup",this.mouseup),delete this.mouseup)},t.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},t.select=function(e){if(!Array.isArray(e))return this.select([e]);var t;e&&(this.deselect(),this.multiselection.nodes=e.slice(0),t=e[0],e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler)&&(e=this.getSelection(),this._selectionChangedHandler(e.start,e.end))},t._findTopLevelNodes=function(e,t){for(var n=e.getNodePath(),i=t.getNodePath(),o=0;o<n.length&&n[o]===i[o];)o++;var r,e=n[o-1],t=n[o],s=i[o];return t&&s||(e.parent?e=(s=t=e).parent:(t=e.childs[0],s=e.childs[e.childs.length-1])),e&&t&&s?(t=e.childs.indexOf(t),s=e.childs.indexOf(s),r=Math.min(t,s),t=Math.max(t,s),e.childs.slice(r,t+1)):[]},t._showAutoComplete=function(t){var n,i=k.getNodeFromTarget(t),o="";0<=t.className.indexOf("jsoneditor-value")&&(o="value"),""!==(o=0<=t.className.indexOf("jsoneditor-field")?"field":o)&&(n=this,setTimeout(function(){var e;!i||!("focus"===n.options.autocomplete.trigger||0<t.innerText.length)||null===(e=n.options.autocomplete.getOptions(t.innerText,i.getPath(),o,i.editor))?n.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?n.autocomplete.hideDropDown():e.options?n.autocomplete.show(t,e.startFrom,e.options):n.autocomplete.show(t,0,e)}).catch(function(e){console.error(e)}):e.options?n.autocomplete.show(t,e.startFrom,e.options):n.autocomplete.show(t,0,e)},50))},t._onKeyDown=function(e){var t,n=e.which||e.keyCode,i=e.altKey,o=e.ctrlKey,r=e.metaKey,s=e.shiftKey,a=!1,l=this.focusTarget;9===n&&(t=this,setTimeout(function(){t.focusTarget!==l&&(0,_.selectContentEditable)(t.focusTarget)},0)),this.searchBox&&(o&&70===n?(this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),a=!0):(114===n||o&&71===n)&&(s?this.searchBox.previous(!0):this.searchBox.next(!0),a=!0)),this.history&&(o&&!s&&90===n?(this._onUndo(),a=!0):o&&s&&90===n&&(this._onRedo(),a=!0)),!this.options.autocomplete||a||o||i||r||1!==e.key.length&&8!==n&&46!==n||(a=!1,this._showAutoComplete(e.target)),a&&(e.preventDefault(),e.stopPropagation())},t._createTable=function(){var e;this.options.navigationBar&&(0,_.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},t.showContextMenu=function(e,t){var n,i=[],o=this.multiselection.nodes.slice();i.push({text:(0,l.Iu)("duplicateText"),title:(0,l.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){k.onDuplicate(o)}}),i.push({text:(0,l.Iu)("remove"),title:(0,l.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){k.onRemove(o)}}),this.options.onCreateMenu&&(n=o.map(function(e){return e.getPath()}),i=this.options.onCreateMenu(i,{type:"multiple",path:n[0],paths:n})),new s.x(i,{close:t}).show(e,this.getPopupAnchor())},t.getPopupAnchor=function(){return this.options.popupAnchor||this.frame},t.getSelection=function(){var e,t,n={start:null,end:null};return this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length&&(e=this.multiselection.nodes[0],t=this.multiselection.nodes[this.multiselection.nodes.length-1],"down"===this.multiselection.direction?(n.start=e.serialize(),n.end=t.serialize()):(n.start=t.serialize(),n.end=e.serialize())),n},t.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=(0,_.debounce)(e,this.DEBOUNCE_INTERVAL))},t.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));e=this._getNodeInstancesByRange(e,t);e.forEach(function(e){e.expandTo()}),this.select(e)},t._getNodeInstancesByRange=function(e,t){e&&e.path&&(n=this.node.findNodeByPath(e.path),t)&&t.path&&(i=this.node.findNodeByPath(t.path));var n,i,o=[];if(n instanceof k)if(i instanceof k&&i!==n)if(n.parent===i.parent){t=n.getIndex()<i.getIndex()?(e=n,i):(e=i,n);var r=e;for(o.push(r);r=r.nextSibling(),o.push(r),r&&r!==t;);}else o=this._findTopLevelNodes(n,i);else o.push(n);return o},t.getNodesByRange=function(e,t){var e=this._getNodeInstancesByRange(e,t),n=[];return e.forEach(function(e){n.push(e.serialize())}),n},[{mode:"tree",mixin:t,data:"json"},{mode:"view",mixin:t,data:"json"},{mode:"form",mixin:t,data:"json"}])},744:function(e,t,n){t.tryRequireAjv=function(){try{return n(Object(function(){var e=new Error("Cannot find module 'ajv'");throw e.code="MODULE_NOT_FOUND",e}()))}catch(e){}}},49:function(e,t,n){t.O=function(){try{n(864)}catch(e){console.error(e)}}},791:function(M,e,t){"use strict";t.r(e),t.d(e,{addClassName:function(){return R},addEventListener:function(){return K},asyncExec:function(){return xe},clear:function(){return v},compileJSONPointer:function(){return A},contains:function(){return ve},debounce:function(){return ne},escapeUnicodeChars:function(){return m},extend:function(){return g},findUniqueName:function(){return ce},formatSize:function(){return fe},get:function(){return D},getAbsoluteLeft:function(){return V},getAbsoluteTop:function(){return L},getChildPaths:function(){return de},getColorCSS:function(){return P},getIndexForPosition:function(){return re},getInnerText:function(){return _},getInputSelection:function(){return oe},getInternetExplorerVersion:function(){return W},getPositionForPath:function(){return se},getSelection:function(){return S},getSelectionOffset:function(){return U},getType:function(){return y},getWindow:function(){return T},hasParentNode:function(){return q},improveSchemaError:function(){return G},insideRect:function(){return te},isArray:function(){return C},isChildOf:function(){return Z},isFirefox:function(){return I},isObject:function(){return O},isPromise:function(){return Y},isTimestamp:function(){return me},isUrl:function(){return x},isValidColor:function(){return ae},isValidValidationError:function(){return ee},isValidationErrorChanged:function(){return ye},limitCharacters:function(){return ge},makeFieldTooltip:function(){return le},parse:function(){return u},parsePath:function(){return j},parseString:function(){return pe},removeAllClassNames:function(){return B},removeClassName:function(){return z},removeEventListener:function(){return Q},removeReturnsAndSurroundingWhitespace:function(){return N},selectContentEditable:function(){return J},setEndOfContentEditable:function(){return H},setSelection:function(){return w},setSelectionOffset:function(){return $},sort:function(){return he},sortObjectKeys:function(){return ue},stringifyPath:function(){return X},stripFormatting:function(){return E},textDiff:function(){return ie},tryJsonRepair:function(){return p},uniqueMergeArrays:function(){return be},validate:function(){return f}});t(987);var e=t(233),o=t.n(e),n=t(304),i=t(589),r=t(26),s=t(907);function a(e){return function(e){if(Array.isArray(e))return l(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){var n;if(e
)return"string"==typeof e?l(e,t):"Map"===(n="Object"===(n=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?l(e,t):void 0}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function l(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function c(e){return(c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var d=1e4,h=9466848e5;function u(t){try{return JSON.parse(t)}catch(e){throw f(t),e}}function p(t){try{return(0,n.K)(t)}catch(e){return t}}function m(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})}function f(e){(void 0!==i?i:JSON).parse(e)}function g(e,t){for(var n in t)F(t,n)&&(e[n]=t[n]);return e}function v(e){for(var t in e)F(e,t)&&delete e[t];return e}function y(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp?"regexp":C(e)?"array":"object"}var b=/^https?:\/\/\S+$/;function x(e){return("string"==typeof e||e instanceof String)&&b.test(e)}function C(e){return"[object Array]"===Object.prototype.toString.call(e)}function T(e){return e.ownerDocument.defaultView}function V(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function L(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function R(e,t){var n=e.className.split(" ");-1===n.indexOf(t)&&(n.push(t),e.className=n.join(" "))}function B(e){e.className=""}function z(e,t){var n=e.className.split(" "),t=n.indexOf(t);-1!==t&&(n.splice(t,1),e.className=n.join(" "))}function E(e){for(var t=e.childNodes,n=0,i=t.length;n<i;n++){var o=t[n],r=(o.style&&o.removeAttribute("style"),o.attributes);if(r)for(var s=r.length-1;0<=s;s--){var a=r[s];!0===a.specified&&o.removeAttribute(a.name)}E(o)}}function H(e){var t;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(e=window.getSelection()).removeAllRanges(),e.addRange(t))}function J(e){var t;e&&"DIV"===e.nodeName&&window.getSelection&&document.createRange&&((t=document.createRange()).selectNodeContents(e),(e=window.getSelection()).removeAllRanges(),e.addRange(t))}function S(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null}function w(e){var t;e&&window.getSelection&&((t=window.getSelection()).removeAllRanges(),t.addRange(e))}function U(){var e=S();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer===e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null}function $(e){var t;document.createRange&&window.getSelection&&window.getSelection()&&(t=document.createRange(),e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),w(t))}function _(e,t){var n;if(void 0===t&&(t={_text:"",flush:function(){var e=this._text;return this._text="",e},set:function(e){this._text=e}}),e.nodeValue)return""!==(n=N(e.nodeValue))?t.flush()+n:"";if(e.hasChildNodes()){for(var i=e.childNodes,o="",r=0,s=i.length;r<s;r++){var a,l=i[r];"DIV"===l.nodeName||"P"===l.nodeName?((a=(a=i[r-1])?a.nodeName:void 0)&&"DIV"!==a&&"P"!==a&&"BR"!==a&&(""!==o&&(o+="\n"),t.flush()),o+=_(l,t),t.set("\n")):"BR"===l.nodeName?(o+=t.flush(),t.set("\n")):o+=_(l,t)}return o}return""}function N(e){return e.replace(/(\b|^)\s*(\b|$)/g,function(e){return/\n/.exec(e)?"":e})}function q(e,t){for(var n=e?e.parentNode:void 0;n;){if(n===t)return!0;n=n.parentNode}return!1}function W(){var e;return-1===k&&(e=-1,"undefined"!=typeof navigator&&"Microsoft Internet Explorer"===navigator.appName&&null!=/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)&&(e=parseFloat(RegExp.$1)),k=e),k}var k=-1;function I(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}function K(e,t,n,i){return e.addEventListener?(void 0===i&&(i=!1),"mousewheel"===t&&I()&&(t="DOMMouseScroll"),e.addEventListener(t,n,i),n):e.attachEvent?(e.attachEvent("on"+t,i=function(){return n.call(e,window.event)}),i):void 0}function Q(e,t,n,i){e.removeEventListener?(void 0===i&&(i=!1),"mousewheel"===t&&I()&&(t="DOMMouseScroll"),e.removeEventListener(t,n,i)):e.detachEvent&&e.detachEvent("on"+t,n)}function Z(e,t){for(var n=e.parentNode;n;){if(n===t)return!0;n=n.parentNode}return!1}function j(n){var e=[],i=0;function t(e){for(var t="";void 0!==n[i]&&n[i]!==e;)t+=n[i],i++;if(n[i]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==n[i];)if("."===n[i])i++,e.push(function(){for(var e="";void 0!==n[i]&&/[\w$]/.test(n[i]);)e+=n[i],i++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+i);return e}());else{if("["!==n[i])throw new Error('Invalid JSON path: unexpected character "'+n[i]+'" at index '+i);if("'"===n[++i]||'"'===n[i]){var o=n[i];if(i++,e.push(t(o)),n[i]!==o)throw new Error("Invalid JSON path: closing quote ' expected at index "+i);i++}else{o=t("]").trim();if(0===o.length)throw new Error("Invalid JSON path: array value expected at index "+i);o="*"===o?o:JSON.parse(o),e.push(o)}if("]"!==n[i])throw new Error("Invalid JSON path: closing bracket ] expected at index "+i);i++}return e}function X(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")}function G(e){var t,n;return"enum"===e.keyword&&Array.isArray(e.schema)&&(n=e.schema)&&(5<(n=n.map(function(e){return JSON.stringify(e)})).length&&(t=["("+(n.length-5)+" more...)"],(n=n.slice(0,5)).push(t)),e.message="should be equal to one of: "+n.join(", ")),"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e}function Y(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}function ee(e){return"object"===c(e)&&Array.isArray(e.path)&&"string"==typeof e.message}function te(e,t,n){n=void 0!==n?n:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom}function ne(i,o,r){var s;return function(){var e=this,t=arguments,n=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||i.apply(e,t)},o),n&&i.apply(e,t)}}function ie(e,t){for(var n=t.length,i=0,o=e.length,r=t.length;t.charAt(i)===e.charAt(i)&&i<n;)i++;for(;t.charAt(r-1)===e.charAt(o-1)&&i<r&&0<o;)r--,o--;return{start:i,end:r}}function oe(t){var e,n,i,o,r=0,s=0;return"number"==typeof t.selectionStart&&"number"==typeof t.selectionEnd?(r=t.selectionStart,s=t.selectionEnd):(o=document.selection.createRange())&&o.parentElement()===t&&(i=t.value.length,e=t.value.replace(/\r\n/g,"\n"),(n=t.createTextRange()).moveToBookmark(o.getBookmark()),(o=t.createTextRange()).collapse(!1),-1<n.compareEndPoints("StartToEnd",o)?r=s=i:(r=-n.moveStart("character",-i),r+=e.slice(0,r).split("\n").length-1,-1<n.compareEndPoints("EndToEnd",o)?s=i:(s=-n.moveEnd("character",-i),s+=e.slice(0,s).split("\n").length-1))),{startIndex:r,endIndex:s,start:a(r),end:a(s)};function a(e){e=t.value.substring(0,e);return{row:(e.match(/\n/g)||[]).length+1,column:e.length-e.lastIndexOf("\n")}}}function re(e,t,n){var e=e.value||"";return 0<t&&0<n?(e=e.split("\n",t),t=Math.min(e.length,t),n=Math.min(e[t-1].length,n-1),n=1===t?n:n+1,e.slice(0,t-1).join("\n").length+n):-1}function se(e,t){var n,i=[];if(t&&t.length){try{n=r.parse(e)}catch(e){return i}t.forEach(function(e){var t=A(j(e)),t=n.pointers[t];t&&i.push({path:e,line:t.key?t.key.line:t.value?t.value.line:0,column:t.key?t.key.column:t.value?t.value.column:0})})}return i}function A(e){return e.map(function(e){return"/"+String(e).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function P(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null}function ae(e){return!!P(e)}function le(n,e){var i;return n?(i="",n.title&&(i+=n.title),n.description&&(0<i.length&&(i+="\n"),i+=n.description),n.default&&(0<i.length&&(i+="\n\n"),i=(i+=(0,s.Iu)("default",void 0,e)+"\n")+JSON.stringify(n.default,null,2)),Array.isArray(n.examples)&&0<n.examples.length&&(0<i.length&&(i+="\n\n"),i+=(0,s.Iu)("examples",void 0,e)+"\n",n.examples.forEach(function(e,t){i+=JSON.stringify(e,null,2),t!==n.examples.length-1&&(i+="\n")})),i):""}function D(e,t){for(var n=e,i=0;i<t.length&&null!=n;i++)n=n[t[i]];return n}function ce(e,t){for(var n=e.replace(/ \(copy( \d+)?\)$/,""),i=n,o=1;-1!==t.indexOf(i);){i=n+" ("+("copy"+(1<o?" "+o:""))+")";o++}return i}function de(e,t){var n={};if(Array.isArray(e))for(var i=Math.min(e.length,d),o=0;o<i;o++)!function t(n,i,o,r){(Array.isArray(n)||O(n))&&!r||(i[o||""]=!0),O(n)&&Object.keys(n).forEach(function(e){t(n[e],i,o+"."+e,r)})}(e[o],n,"",t);else n[""]=!0;return Object.keys(n).sort()}function he(e,t,n){var i=t&&"."!==t?j(t):[],o="desc"===n?-1:1,t=e.slice();return t.sort(function(e,t){e=D(e,i),t=D(t,i);return o*(t<e?1:e<t?-1:0)}),t}function ue(t,e){var n="desc"===e?-1:1,e=Object.keys(t).sort(function(e,t){return n*o()(e,t)}),i={};return e.forEach(function(e){i[e]=t[e]}),i}function pe(e){var t,n;return""===e?"":"null"===(t=e.toLowerCase())?null:"true"===t||"false"!==t&&(/^0\d+$/.test(e)||(t=Number(e),n=parseFloat(e),isNaN(t))||isNaN(n)?e:t)}function me(e,t){return"number"==typeof t&&h<t&&isFinite(t)&&Math.floor(t)===t&&!isNaN(new Date(t).valueOf())}function fe(e){return e<900?e.toFixed()+" B":(e=e/1e3)<900?e.toFixed(1)+" KB":(e=e/1e3)<900?e.toFixed(1)+" MB":(e=e/1e3)<900?e.toFixed(1)+" GB":(e/1e3).toFixed(1)+" TB"}function ge(e,t){return e.length<=t?e:e.slice(0,t)+"..."}function O(e){return"object"===c(e)&&null!==e&&!Array.isArray(e)}function ve(e,t){return-1!==e.indexOf(t)}function ye(n,i){if(i||n){if(i&&!n||!i&&n)return!0;if(i.length!==n.length)return!0;for(var e,t=0;t<n.length;++t)if(e=function(t){var e="error"===n[t].type?i.find(function(e){return e.line===n[t].line}):i.find(function(e){return e.dataPath===n[t].dataPath&&e.schemaPath===n[t].schemaPath});if(!e)return{v:!0}}(t))return e.v}return!1}function be(e,t){e=null!=e&&e.length?e:[],t=null!=t&&t.length?t:[];return a(new Set(e.concat(t)))}function xe(e){setTimeout(e)}function F(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},37:function(e,t,n){var i;if(window.Picker)i=window.Picker;else try{i=n(Object(function(){var e=new Error("Cannot find module 'vanilla-picker'");throw e.code="MODULE_NOT_FOUND",e}()))}catch(e){}e.exports=i},233:function(e){e.exports=function t(e,n){"use strict";function i(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var o,r,s=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,a=/(^[ ]*|[ ]*$)/g,l=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,d=/^0/,e=i(e).replace(a,"")||"",n=i(n).replace(a,"")||"",h=e.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),u=n.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),a=parseInt(e.match(c),16)||1!==h.length&&e.match(l)&&Date.parse(e),s=parseInt(n.match(c),16)||a&&n.match(l)&&Date.parse(n)||null;if(s){if(a<s)return-1;if(s<a)return 1}for(var p=0,m=Math.max(h.length,u.length);p<m;p++){if(o=!(h[p]||"").match(d)&&parseFloat(h[p])||h[p]||0,r=!(u[p]||"").match(d)&&parseFloat(u[p])||u[p]||0,isNaN(o)!==isNaN(r))return isNaN(o)?1:-1;if(typeof o!=typeof r&&(o+="",r+=""),o<r)return-1;if(r<o)return 1}return 0}},156:function(e,t){!function(e){"use strict";function E(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function S(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function w(e,t){if(e!==t){if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===E(e)){if(e.length!==t.length)return!1;for(var n=0;n<e.length;n++)if(!1===w(e[n],t[n]))return!1}else{if(!0!==S(e))return!1;var i,o,r={};for(i in e)if(hasOwnProperty.call(e,i)){if(!1===w(e[i],t[i]))return!1;r[i]=!0}for(o in t)if(hasOwnProperty.call(t,o)&&!0!==r[o])return!1}}return!0}function _(e){if(""===e||!1===e||null===e)return!0;if(E(e)&&0===e.length)return!0;if(S(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var o="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]},d={0:"number",1:"any",2:"string",3:"array",4:"object",5:"boolean",6:"expression",7:"null",8:"Array<number>",9:"Array<string>"},s="UnquotedIdentifier",a="QuotedIdentifier",l="Rbracket",c="Rparen",h="Comma",u="Colon",r="Rbrace",p="Number",N="Current",k="Expref",I="Pipe",j="GTE",A="LTE",P="Flatten",m="Star",f="Filter",g="Dot",v="Lbrace",y="Lbracket",b="Lparen",x="Literal",C={".":g,"*":m,",":h,":":u,"{":v,"}":r,"]":l,"(":b,")":c,"@":N},T={"<":!0,">":!0,"=":!0,"!":!0},L={" ":!0,"\t":!0,"\n":!0};function D(e){return"0"<=e&&e<="9"||"-"===e}function n(){}n.prototype={tokenize:function(e){var t,n,i=[];for(this._current=0;this._current<e.length;)if("a"<=(r=e[this._current])&&r<="z"||"A"<=r&&r<="Z"||"_"===r)o=this._current,t=this._consumeUnquotedIdentifier(e),i.push({type:s,value:t,start:o});else if(void 0!==C[e[this._current]])i.push({type:C[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(D(e[this._current]))n=this._consumeNumber(e),i.push(n);else if("["===e[this._current])n=this._consumeLBracket(e),i.push(n);else if('"'===e[this._current])o=this._current,t=this._consumeQuotedIdentifier(e),i.push({type:a,value:t,start:o});else if("'"===e[this._current])o=this._current,t=this._consumeRawStringLiteral(e),i.push({type:x,value:t,start:o});else if("`"===e[this._current]){var o=this._current,r=this._consumeLiteral(e);i.push({type:x,value:r,start:o})}else if(void 0!==T[e[this._current]])i.push(this._consumeOperator(e));else if(void 0!==L[e[this._current]])this._current++;else if("&"===e[this._current])o=this._current,this._current++,"&"===e[this._current]?(this._current++,i.push({type:"And",value:"&&",start:o})):i.push({type:k,value:"&",start:o});else{if("|"!==e[this._current])throw(r=new Error("Unknown character:"+e[this._current])).name="LexerError",r;o=this._current,this._current++,"|"===e[this._current]?(this._current++,i.push({type:"Or",value:"||",start:o})):i.push({type:I,value:"|",start:o})}return i},_consumeUnquotedIdentifier:function(e){var t,n=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(n,this._current)},_consumeQuotedIdentifier:function(e){for(var t=this._current,n=(this._current++,e.length);'"'!==e[this._current]&&this._current<n;){var i=this._current;"\\"!==e[i]||"\\"!==e[i+1]&&'"'!==e[i+1]?i++:i+=2,this._current=i}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){for(var t=this._current,n=(this._current++,e.length);"'"!==e[this._current]&&this._current<n;){var i=this._current;"\\"!==e[i]||"\\"!==e[i+1]&&"'"!==e[i+1]?i++:i+=2,this._current=i}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){for(var t=this._current,n=(this._current++,e.length);D(e[this._current])&&this._current<n;)this._current++;var i=parseInt(e.slice(t,this._current));return{type:p,value:i,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:f,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:P,value:"[]",start:t}):{type:y,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,n=e[t];return this._current++,"!"===n?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===n?"="===e[this._current]?(this._current++,{type:A,value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===n?"="===e[this._current]?(this._current++,{type:j,value:">=",start:t}):{type:"GT",value:">",start:t}:"="===n&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var i=this._current;"\\"!==e[i]||"\\"!==e[i+1]&&"`"!==e[i+1]?i++:i+=2,this._current=i}t=(t=o(e.slice(t,this._current))).replace("\\`","`"),t=this._looksLikeJSON(t)?JSON.parse(t):JSON.parse('"'+t+'"');return this._current++,t},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var O={};function F(){}function M(e){this.runtime=e}function V(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}O.EOF=0,O[s]=0,O[a]=0,O[l]=0,O[c]=0,O[h]=0,O[r]=0,O[p]=0,O[N]=0,O[k]=0,O[I]=1,O.Or=2,O.And=3,O.EQ=5,O.GT=5,O.LT=5,O.GTE=5,O.LTE=5,O.NE=5,O[P]=9,O[m]=20,O[f]=21,O.Dot=40,O.Not=45,O[v]=50,O[y]=55,O[b]=60,F.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t,e=this.expression(0);if("EOF"!==this._lookahead(0))throw t=this._lookaheadToken(0),(t=new Error("Unexpected token type: "+t.type+", value: "+t.value)).name="ParserError",t;return e},_loadTokens:function(e){var t=(new n).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){for(var t=this._lookaheadToken(0),n=(this._advance(),this.nud(t)),i=this._lookahead(0);e<O[i];)this._advance(),n=this.led(i,n),i=this._lookahead(0);return n},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,n;switch(e.type){case x:return{type:"Literal",value:e.value};case s:return{type:"Field",name:e.value};case a:var i={type:"Field",name:e.value};if(this._lookahead(0)===b)throw new Error("Quoted identifier not allowed for function names.");return i;case"Not":return{type:"NotExpression",children:[t=this.expression(O.Not)]};case m:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===l?{type:"Identity"}:this._parseProjectionRHS(O.Star)]};case f:return this.led(e.type,{type:"Identity"});case v:return this._parseMultiselectHash();case P:return{type:"Projection",children:[{type:P,children:[{type:"Identity"}]},t=this._parseProjectionRHS(O.Flatten)]};case y:return this._lookahead(0)===p||this._lookahead(0)===u?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===m&&this._lookahead(1)===l?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(O.Star)]}):this._parseMultiselectList();case N:return{type:N};case k:return{type:"ExpressionReference",children:[n=this.expression(O.Expref)]};case b:for(var o=[];this._lookahead(0)!==c;)this._lookahead(0)===N?(n={type:N},this._advance()):n=this.expression(0),o.push(n);return this._match(c),o[0];default:this._errorToken(e)}},led:function(e,t){var n;switch(e){case g:var i=O.Dot;return this._lookahead(0)!==m?{type:"Subexpression",children:[t,n=this._parseDotRHS(i)]}:(this._advance(),{type:"ValueProjection",children:[t,n=this._parseProjectionRHS(i)]});case I:return n=this.expression(O.Pipe),{type:I,children:[t,n]};case"Or":return{type:"OrExpression",children:[t,n=this.expression(O.Or)]};case"And":return{type:"AndExpression",children:[t,n=this.expression(O.And)]};case b:for(var o,i=t.name,r=[];this._lookahead(0)!==c;)this._lookahead(0)===N?(o={type:N},this._advance()):o=this.expression(0),this._lookahead(0)===h&&this._match(h),r.push(o);return this._match(c),{type:"Function",name:i,children:r};case f:i=this.expression(0);return this._match(l),{type:"FilterProjection",children:[t,n=this._lookahead(0)===P?{type:"Identity"}:this._parseProjectionRHS(O.Filter),i]};case P:return{type:"Projection",children:[{type:P,children:[t]},this._parseProjectionRHS(O.Flatten)]};case"EQ":case"NE":case"GT":case j:case"LT":case A:return this._parseComparator(t,e);case y:i=this._lookaheadToken(0);return i.type===p||i.type===u?(n=this._parseIndexExpression(),this._projectIfSlice(t,n)):(this._match(m),this._match(l),{type:"Projection",children:[t,n=this._parseProjectionRHS(O.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){var t;if(this._lookahead(0)!==e)throw t=this._lookaheadToken(0),(e=new Error("Expected "+e+", got: "+t.type)).name="ParserError",e;this._advance()},_errorToken:function(e){e=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw e.name="ParserError",e},_parseIndexExpression:function(){var e;return this._lookahead(0)===u||this._lookahead(1)===u?this._parseSliceExpression():(e={type:"Index",value:this._lookaheadToken(0).value},this._advance(),this._match(l),e)},_projectIfSlice:function(e,t){e={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[e,this._parseProjectionRHS(O.Star)]}:e},_parseSliceExpression:function(){for(var e,t=[null,null,null],n=0,i=this._lookahead(0);i!==l&&n<3;){if(i===u)n++;else{if(i!==p)throw e=this._lookahead(0),(e=new Error("Syntax error, unexpected token: "+e.value+"("+e.type+")")).name="Parsererror",e;t[n]=this._lookaheadToken(0).value}this._advance(),i=this._lookahead(0)}return this._match(l),{type:"Slice",children:t}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(O[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[s,a,m].indexOf(t)?this.expression(e):t===y?(this._match(y),this._parseMultiselectList()):t===v?(this._match(v),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t,n;if(O[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===y)t=this.expression(e);else if(this._lookahead(0)===f)t=this.expression(e);else{if(this._lookahead(0)!==g)throw n=this._lookaheadToken(0),(n=new Error("Sytanx error, unexpected token: "+n.value+"("+n.type+")")).name="ParserError",n;this._match(g),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==l;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===h&&(this._match(h),this._lookahead(0)===l))throw new Error("Unexpected token Rbracket")}return this._match(l),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,n=[],i=[s,a];;){if(e=this._lookaheadToken(0),i.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(e=e.value,this._advance(),this._match(u),t=this.expression(0),n.push({type:"KeyValuePair",name:e,value:t}),this._lookahead(0)===h)this._match(h);else if(this._lookahead(0)===r){this._match(r);break}}return{type:"MultiSelectHash",children:n}}},M.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var n,i,o,r,s,a;switch(e.type){case"Field":return null!==t&&S(t)?void 0===(l=t[e.name])?null:l:null;case"Subexpression":for(u=this.visit(e.children[0],t),g=1;g<e.children.length;g++)if(null===(u=this.visit(e.children[1],u)))return null;return u;case"IndexExpression":return s=this.visit(e.children[0],t),this.visit(e.children[1],s);case"Index":return E(t)?void 0===(u=t[l=(l=e.value)<0?t.length+l:l])?null:u:null;case"Slice":if(!E(t))return null;var l=e.children.slice(0),l=this.computeSliceParams(t.length,l),c=l[0],d=l[1],h=l[2],u=[];if(0<h)for(g=c;g<d;g+=h)u.push(t[g]);else for(g=c;d<g;g+=h)u.push(t[g]);return u;case"Projection":var p=this.visit(e.children[0],t);if(!E(p))return null;for(m=[],g=0;g<p.length;g++)null!==(i=this.visit(e.children[1],p[g]))&&m.push(i);return m;case"ValueProjection":if(!S(p=this.visit(e.children[0],t)))return null;for(var m=[],f=function(e){for(var t=Object.keys(e),n=[],i=0;i<t.length;i++)n.push(e[t[i]]);return n}(p),g=0;g<f.length;g++)null!==(i=this.visit(e.children[1],f[g]))&&m.push(i);return m;case"FilterProjection":if(!E(p=this.visit(e.children[0],t)))return null;var v=[],y=[];for(g=0;g<p.length;g++)_(n=this.visit(e.children[2],p[g]))||v.push(p[g]);for(var b=0;b<v.length;b++)null!==(i=this.visit(e.children[1],v[b]))&&y.push(i);return y;case"Comparator":switch(o=this.visit(e.children[0],t),r=this.visit(e.children[1],t),e.name){case"EQ":u=w(o,r);break;case"NE":u=!w(o,r);break;case"GT":u=r<o;break;case j:u=r<=o;break;case"LT":u=o<r;break;case A:u=o<=r;break;default:throw new Error("Unknown comparator: "+e.name)}return u;case P:var x=this.visit(e.children[0],t);if(!E(x))return null;var C=[];for(g=0;g<x.length;g++)E(i=x[g])?C.push.apply(C,i):C.push(i);return C;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(m=[],g=0;g<e.children.length;g++)m.push(this.visit(e.children[g],t));return m;case"MultiSelectHash":if(null===t)return null;for(m={},g=0;g<e.children.length;g++)m[(a=e.children[g]).name]=this.visit(a.value,t);return m;case"OrExpression":return n=_(n=this.visit(e.children[0],t))?this.visit(e.children[1],t):n;case"AndExpression":return!0===_(o=this.visit(e.children[0],t))?o:this.visit(e.children[1],t);case"NotExpression":return _(o=this.visit(e.children[0],t));case"Literal":return e.value;case I:return s=this.visit(e.children[0],t),this.visit(e.children[1],s);case N:return t;case"Function":var T=[];for(g=0;g<e.children.length;g++)T.push(this.visit(e.children[g],t));return this.runtime.callFunction(e.name,T);case"ExpressionReference":l=e.children[0];return l.jmespathType=k,l;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var n=t[0],i=t[1],t=t[2],o=[null,null,null];if(null===t)t=1;else if(0===t)throw(r=new Error("Invalid slice, step cannot be 0")).name="RuntimeError",r;var r=t<0,n=null===n?r?e-1:0:this.capSliceRange(e,n,t),i=null===i?r?-1:e:this.capSliceRange(e,i,t);return o[0]=n,o[1]=i,o[2]=t,o},capSliceRange:function(e,t,n){return t<0?(t+=e)<0&&(t=n<0?-1:0):e<=t&&(t=n<0?e-1:e),t}},V.prototype={callFunction:function(e,t){var n=this.functionTable[e];if(void 0===n)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,n._signature),n._func.call(this,t)},_validateArgs:function(e,t,n){var i;if(n[n.length-1].variadic){if(t.length<n.length)throw i=1===n.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+n.length+i+" but received "+t.length)}else if(t.length!==n.length)throw i=1===n.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+n.length+i+" but received "+t.length);for(var o=0;o<n.length;o++){for(var r,s=!1,a=n[o].types,l=this._getTypeName(t[o]),c=0;c<a.length;c++)if(this._typeMatches(l,a[c],t[o])){s=!0;break}if(!s)throw r=a.map(function(e){return d[e]}).join(","),new Error("TypeError: "+e+"() expected argument "+(o+1)+" to be type "+r+" but received type "+d[l]+" instead.")}},_typeMatches:function(e,t,n){if(1===t)return!0;if(9!==t&&8!==t&&3!==t)return e===t;if(3===t)return 3===e;if(3===e){var i;8===t?i=0:9===t&&(i=2);for(var o=0;o<n.length;o++)if(!this._typeMatches(this._getTypeName(n[o]),i,n[o]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return 2;case"[object Number]":return 0;case"[object Array]":return 3;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===k?6:4}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],e=e[1];return-1!==t.indexOf(e,t.length-e.length)},_functionReverse:function(e){var t;if(2!==this._getTypeName(e[0]))return(t=e[0].slice(0)).reverse(),t;for(var n=e[0],i="",o=n.length-1;0<=o;o--)i+=n[o];return i},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,n=e[0],i=0;i<n.length;i++)t+=n[i];return t/n.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return(S(e[0])?Object.keys(e[0]):e[0]).length},_functionMap:function(e){for(var t=[],n=this._interpreter,i=e[0],o=e[1],r=0;r<o.length;r++)t.push(n.visit(i,o[r]));return t},_functionMerge:function(e){for(var t={},n=0;n<e.length;n++){var i,o=e[n];for(i in o)t[i]=o[i]}return t},_functionMax:function(e){if(0<e[0].length){if(0===this._getTypeName(e[0][0]))return Math.max.apply(Math,e[0]);for(var t=e[0],n=t[0],i=1;i<t.length;i++)n.localeCompare(t[i])<0&&(n=t[i]);return n}return null},_functionMin:function(e){if(0<e[0].length){if(0===this._getTypeName(e[0][0]))return Math.min.apply(Math,e[0]);for(var t=e[0],n=t[0],i=1;i<t.length;i++)t[i].localeCompare(n)<0&&(n=t[i]);return n}return null},_functionSum:function(e){for(var t=0,n=e[0],i=0;i<n.length;i++)t+=n[i];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],n=Object.keys(t),i=[],o=0;o<n.length;o++)i.push(t[n[o]]);return i},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return 3===this._getTypeName(e[0])?e[0]:[e[0]]},_functionToString:function(e){return 2===this._getTypeName(e[0])?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t=this._getTypeName(e[0]);return 0===t?e[0]:2!==t||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){e=e[0].slice(0);return e.sort(),e},_functionSortBy:function(e){var t=e[0].slice(0);if(0!==t.length){var o=this._interpreter,r=e[1],s=this._getTypeName(o.visit(r,t[0]));if([0,2].indexOf(s)<0)throw new Error("TypeError");for(var a=this,n=[],i=0;i<t.length;i++)n.push([i,t[i]]);n.sort(function(e,t){var n=o.visit(r,e[1]),i=o.visit(r,t[1]);if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));return i<n?1:n<i?-1:e[0]-t[0]});for(var l=0;l<n.length;l++)t[l]=n[l][1]}return t},_functionMaxBy:function(e){for(var t,n,i=e[1],o=e[0],r=this.createKeyFunction(i,[0,2]),s=-1/0,a=0;a<o.length;a++)s<(n=r(o[a]))&&(s=n,t=o[a]);return t},_functionMinBy:function(e){for(var t,n,i=e[1],o=e[0],r=this.createKeyFunction(i,[0,2]),s=1/0,a=0;a<o.length;a++)(n=r(o[a]))<s&&(s=n,t=o[a]);return t},createKeyFunction:function(n,i){var o=this,r=this._interpreter;return function(e){var t,e=r.visit(n,e);if(i.indexOf(o._getTypeName(e))<0)throw t="TypeError: expected one of "+i+", received "+o._getTypeName(e),new Error(t);return e}}},e.tokenize=function(e){return(new n).tokenize(e)},e.compile=function(e){return(new F).parse(e)},e.search=function(e,t){var n=new F,i=new M(o=new V),o=(o._interpreter=i,n.parse(t));return i.search(o,e)},e.strictDeepEqual=w}(t)},26:function(e,t){"use strict";var C={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},T="a".charCodeAt(),n=(t.parse=function(o,e,t){var i={},n=0,r=0,s=0,a=t&&t.bigint&&"undefined"!=typeof BigInt;return{data:l("",!0),pointers:i};function l(e,t){c(),f(e,"value");var n,i=u();switch(i){case"t":h("rue"),n=!0;break;case"f":h("alse"),n=!1;break;case"n":h("ull"),n=null;break;case'"':n=d();break;case"[":n=function(e){c();var t=[],n=0;if("]"!=u())for(p();;){t.push(l(e+"/"+n)),c();var i=u();if("]"==i)break;","!=i&&b(),c(),n++}return t}(e);break;case"{":n=function(e){c();var t={};if("}"!=u())for(p();;){var n=v(),i=('"'!=u()&&b(),d()),o=e+"/"+E(i),n=(g(o,"key",n),f(o,"keyEnd"),c(),":"!=u()&&b(),c(),t[i]=l(o),c(),u());if("}"==n)break;","!=n&&b(),c()}return t}(e);break;default:p(),0<="-0123456789".indexOf(i)?n=function(){var e="",t=!0;"-"==o[s]&&(e+=u());e+=("0"==o[s]?u:m)(),"."==o[s]&&(e+=u()+m(),t=!1);"e"!=o[s]&&"E"!=o[s]||(e+=u(),"+"!=o[s]&&"-"!=o[s]||(e+=u()),e+=m(),t=!1);var n=+e;return a&&t&&(n>Number.MAX_SAFE_INTEGER||n<Number.MIN_SAFE_INTEGER)?BigInt(e):n}():y()}return f(e,"valueEnd"),c(),t&&s<o.length&&y(),n}function c(){e:for(;s<o.length;){switch(o[s]){case" ":r++;break;case"\t":r+=4;break;case"\r":r=0;break;case"\n":r=0,n++;break;default:break e}s++}}function d(){for(var e,t="";'"'!=(e=u());)"\\"==e?(e=u())in C?t+=C[e]:"u"==e?t+=function(){var e=4,t=0;for(;e--;){t<<=4;var n=u().toLowerCase();"a"<=n&&n<="f"?t+=n.charCodeAt()-T+10:"0"<=n&&n<="9"?t+=+n:b()}return String.fromCharCode(t)}():b():t+=e;return t}function h(e){for(var t=0;t<e.length;t++)u()!==e[t]&&b()}function u(){x();var e=o[s];return s++,r++,e}function p(){s--,r--}function m(){for(var e="";"0"<=o[s]&&o[s]<="9";)e+=u();if(e.length)return e;x(),y()}function f(e,t){g(e,t,v())}function g(e,t,n){i[e]=i[e]||{},i[e][t]=n}function v(){return{line:n,column:r,pos:s}}function y(){throw new SyntaxError("Unexpected token "+o[s]+" in JSON at position "+s)}function b(){p(),y()}function x(){if(s>=o.length)throw new SyntaxError("Unexpected end of JSON input")}},t.stringify=function(e,t,n){if(b(e)){var i=0;switch(typeof(u="object"==typeof n?n.space:n)){case"number":var o=10<u?10:u<0?0:Math.floor(u),u=o&&y(o," "),r=o,s=o;break;case"string":u=u.slice(0,10);for(var a=s=r=0;a<u.length;a++){switch(u[a]){case" ":s++;break;case"\t":s+=4;break;case"\r":s=0;break;case"\n":s=0,i++;break;default:throw new Error("whitespace characters not allowed in JSON")}r++}break;default:u=void 0}var l="",c={},d=0,h=0,p=0,m=n&&n.es6&&"function"==typeof Map;return function l(c,d,h){v(h,"value");switch(typeof c){case"number":case"bigint":case"boolean":f(""+c);break;case"string":f(x(c));break;case"object":null===c?f("null"):"function"==typeof c.toJSON?f(x(c.toJSON())):Array.isArray(c)?e():m?c.constructor.BYTES_PER_ELEMENT?e():c instanceof Map?n():c instanceof Set?n(!0):t():t()}v(h,"valueEnd");function e(){if(c.length){f("[");for(var e=d+1,t=0;t<c.length;t++){t&&f(","),g(e);var n=b(c[t])?c[t]:null,i=h+"/"+t;l(n,e,i)}g(d),f("]")}else f("[]")}function t(){var e=Object.keys(c);if(e.length){f("{");for(var t=d+1,n=0;n<e.length;n++){var i,o=e[n],r=c[o];b(r)&&(n&&f(","),i=h+"/"+E(o),g(t),v(i,"key"),f(x(o)),v(i,"keyEnd"),f(":"),u&&f(" "),l(r,t,i))}g(d),f("}")}else f("{}")}function n(e){if(c.size){f("{");for(var t=d+1,n=!0,i=c.entries(),o=i.next();!o.done;){var r,s=o.value,a=s[0],s=!!e||s[1];b(s)&&(n||f(","),n=!1,r=h+"/"+E(a),g(t),v(r,"key"),f(x(a)),v(r,"keyEnd"),f(":"),u&&f(" "),l(s,t,r)),o=i.next()}g(d),f("}")}else f("{}")}}(e,0,""),{json:l,pointers:c}}function f(e){h+=e.length,p+=e.length,l+=e}function g(e){if(u){for(l+="\n"+y(e,u),d++,h=0;e--;)i?(d+=i,h=s):h+=s,p+=r;p+=1}}function v(e,t){c[e]=c[e]||{},c[e][t]={line:d,column:h,pos:p}}function y(e,t){return Array(e+1).join(t)}},["number","bigint","boolean","string","object"]);function b(e){return 0<=n.indexOf(typeof e)}var i=/"|\\/g,o=/[\b]/g,r=/\f/g,s=/\n/g,a=/\r/g,l=/\t/g;function x(e){return'"'+(e=e.replace(i,"\\$&").replace(r,"\\f").replace(o,"\\b").replace(s,"\\n").replace(a,"\\r").replace(l,"\\t"))+'"'}var c=/~/g,d=/\//g;function E(e){return e.replace(c,"~0").replace(d,"~1")}},483:function(e,t){var n,i;!function(){"use strict";i=[],void 0!==(i="function"==typeof(n=function(){"use strict";function v(e){if(typeof Node==="object")return e instanceof Node;else return e&&typeof e==="object"&&typeof e.nodeType==="number"}function y(e){return typeof e==="string"}function b(){var r=[];return{watch:r.push.bind(r),trigger:function(e,t){var n=true;var i={detail:t,preventDefault:function e(){n=false}};for(var o=0;o<r.length;o++)r[o](e,i);return n}}}function o(e){return window.getComputedStyle(e).display==="none"}function r(e){this.elem=e}function x(e,t){return r.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){if(e("overlayClose",true))t()})}r.make=function(e,t){if(typeof e==="string")e=document.querySelector(e);var n=document.createElement(t||"div");(e||document.body).appendChild(n);return new r(n)},r.prototype={child:function(e){return r.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined")e.filter="alpha(opacity="+e.opacity*100+")";for(var t in e)if(e.hasOwnProperty(t))this.elem.style[t]=e[t];return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(v(e))this.elem.appendChild(e);else this.elem.innerHTML=e;return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined)this.elem.setAttribute(e,t);return this},anyAncestor:function(e){var t=this.elem;while(t)if(e(new r(t)))return true;else t=t.parentNode;return false},isVisible:function(){return!o(this.elem)}};var s=1;function C(e,n){var t=e("width","auto");if(typeof t==="number")t=""+t+"px";var i=e("modalId","pico-"+s++);var o=r.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:t,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",i).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",i)).onClick(function(e){var t=new r(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)});if(t)n()});return o}function T(e,t){if(t("closeButton",true))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function E(e){return function(){return e().elem}}var S=b(),c=b();function w(r,s){function t(e,t){var n=e.msMatchesSelector||e.webkitMatchesSelector||e.matches;return n.call(e,t)}function i(e){if(o(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))return false;else return e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe")}function a(e){var t=e.getElementsByTagName("*");for(var n=0;n<t.length;n++)if(i(t[n]))return t[n]}function l(e){var t=e.getElementsByTagName("*");for(var n=t.length;n--;)if(i(t[n]))return t[n]}var n;r.beforeShow(function e(){n=document.activeElement});r.afterShow(function e(){if(s()){var t=a(r.modalElem());if(t)t.focus()}});r.afterClose(function e(){if(s()&&n)n.focus();n=null});c.watch(function e(t){if(s()&&r.isVisible()){var n=a(r.modalElem());var i=l(r.modalElem());var o=t.shiftKey?n:i;if(o===document.activeElement){(t.shiftKey?i:n).focus();t.preventDefault()}}})}function _(e,t){var n;var i=new r(document.body);e.beforeShow(function(){n=i.elem.style.overflow;if(t())i.stylize({overflow:"hidden"})});e.afterClose(function(){i.stylize({overflow:n})})}return document.documentElement.addEventListener("keydown",function e(t){var n=t.which||t.keyCode;if(n===27)S.trigger();else if(n===9)c.trigger(t)}),function e(i){if(y(i)||v(i))i={content:i};var o=b();var t=b();var n=b();var r=b();var s=b();function a(e,t){var n=i[e];if(typeof n==="function")n=n(t);return n===undefined?t:n}var l=g.bind(window,"modal");var c=g.bind(window,"overlay");var d=g.bind(window,"close");var h;function u(e){c().hide();l().hide();s.trigger(h,e)}function p(e){if(r.trigger(h,e))u(e)}function m(e){return function(){e.apply(this,arguments);return h}}var f;function g(e,t){if(!f){var n=C(a,p);f={modal:n,overlay:x(a,p),close:T(n,a)};o.trigger(h,t)}return f[e]}h={modalElem:E(l),closeElem:E(d),overlayElem:E(c),buildDom:m(g.bind(null,null)),isVisible:function(){return!!(f&&l&&l().isVisible())},show:function(e){if(t.trigger(h,e)){c().show();d();l().show();n.trigger(h,e)}return this},close:m(p),forceClose:m(u),destroy:function(){l().destroy();c().destroy();c=l=d=undefined},options:function(t){Object.keys(t).map(function(e){i[e]=t[e]})},afterCreate:m(o.watch),beforeShow:m(t.watch),afterShow:m(n.watch),beforeClose:m(r.watch),afterClose:m(s.watch)};w(h,a.bind(null,"focus",true));_(h,a.bind(null,"bodyOverflow",true));S.watch(function e(){if(a("escCloses",true)&&h.isVisible())h.close()});return h}})?n.apply(t,i):n)&&(e.exports=i)}()},304:function(o,e,t){"use strict";t.d(e,{K:function(){return v}});class b extends Error{constructor(e,t){super(e+" at position "+t),this.position=t}}const x=92,c=47,d=42,h=123,u=125,C=91,T=93,E=40,S=41,n=32,w=10,_=9,N=13,k=8,I=12,j=34,A=43,P=45,i=39,D=48,O=57,F=44,W=46,K=58,Q=59,Z=65,X=97,G=69,Y=101,ee=70,te=102,ne=160,ie=8192,oe=8202,re=8239,se=8287,ae=12288,r=8220,s=8221,a=8216,l=8217,p=96,m=180;function M(e){return e>=D&&e<=O}function V(e){return f.test(e)||B(e.charCodeAt(0))}const f=/^[,:[\]{}()\n+]$/;function L(e){return g.test(e)||e&&B(e.charCodeAt(0))}const g=/^[[{\w-]$/;function R(e){return e===n||e===w||e===_||e===N}function B(e){return z(e)||J(e)}function z(e){return e===j||e===r||e===s}function H(e){return e===j}function J(e){return e===i||e===a||e===l||e===p||e===m}function U(e){return e===i}function $(e,t,n){n=2<arguments.length&&void 0!==n&&n,t=e.lastIndexOf(t);return-1!==t?e.substring(0,t)+(n?"":e.substring(t+1)):e}function q(e,t){let n=e.length;if(!R(e.charCodeAt(n-1)))return e+t;for(;R(e.charCodeAt(n-1));)n--;return e.substring(0,n)+t+e.substring(n)}const le={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"},ce={'"':'"',"\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"\t"};function v(p){let m=0,f="";if(!r())throw new b("Unexpected end of json string",p.length);var e=s(F);if(e&&g(),L(p[m])&&/[,\n][ \t\r]*$/.test(f)){e||(f=q(f,","));{let e=!0,t=!0;for(;t;)e?e=!1:s(F)||(f=q(f,",")),t=r();t||(f=$(f,","));f=`[
${f}
]`}}else e&&(f=$(f,","));for(;p.charCodeAt(m)===u||p.charCodeAt(m)===T;)m++,g();if(m>=p.length)return f;throw new b("Unexpected character "+JSON.stringify(p[m]),m);function r(){g();var e=function(){if(p.charCodeAt(m)!==h)return!1;{f+="{",m++,g();let t=!0;for(;m<p.length&&p.charCodeAt(m)!==u;){let e;if(t?(e=!0,t=!1):((e=s(F))||(f=q(f,",")),g()),!(y()||a())){p.charCodeAt(m)===u||p.charCodeAt(m)===h||p.charCodeAt(m)===T||p.charCodeAt(m)===C||void 0===p[m]?f=$(f,","):function(){throw new b("Object key expected",m)}();break}g();var n=s(K),i=m>=p.length,o=(n||(L(p[m])||i?f=q(f,":"):l()),r());o||(n||i?f+="null":l())}return p.charCodeAt(m)===u?(f+="}",m++):f=q(f,"}"),!0}}()||function(){if(p.charCodeAt(m)!==C)return!1;{f+="[",m++,g();let e=!0;for(;m<p.length&&p.charCodeAt(m)!==T;){e?e=!1:s(F)||(f=q(f,","));var t=r();if(!t){f=$(f,",");break}}return p.charCodeAt(m)===T?(f+="]",m++):f=q(f,"]"),!0}}()||y()||function(){var e=m;if(p.charCodeAt(m)===P&&(m++,o(e)))return!0;for(;M(p.charCodeAt(m));)m++;if(p.charCodeAt(m)===W){if(m++,o(e))return!0;for(;M(p.charCodeAt(m));)m++}if(p.charCodeAt(m)===Y||p.charCodeAt(m)===G){if(m++,p.charCodeAt(m)!==P&&p.charCodeAt(m)!==A||m++,o(e))return!0;for(;M(p.charCodeAt(m));)m++}{var t;if(m>e)return e=p.slice(e,m),t=/^0\d/.test(e),f+=t?`"${e}"`:e,!0}return!1}()||n("true","true")||n("false","false")||n("null","null")||n("True","true")||n("False","false")||n("None","null")||a();return g(),e}function g(){m;let e=t();for(;e=(e=function(){if(p.charCodeAt(m)===c&&p.charCodeAt(m+1)===d){for(;m<p.length&&!function(e,t){return"*"===e[t]&&"/"===e[t+1]}(p,m);)m++;m+=2}else{if(p.charCodeAt(m)!==c||p.charCodeAt(m+1)!==c)return!1;for(;m<p.length&&p.charCodeAt(m)!==w;)m++}return!0}())&&t(););m}function t(){let e="";for(var t,n;(t=R(p.charCodeAt(m)))||(n=p.charCodeAt(m))===ne||n>=ie&&n<=oe||n===re||n===se||n===ae;)e+=t?p[m]:" ",m++;return 0<e.length&&(f+=e,!0)}function s(e){return p.charCodeAt(m)===e&&(f+=p[m],m++,!0)}function v(){return e=x,p.charCodeAt(m)===e&&(m++,!0);var e}function y(e){var n,e=0<arguments.length&&void 0!==e&&e;let i=p.charCodeAt(m)===x;if(i&&(m++,i=!0),B(p.charCodeAt(m))){const u=H(p.charCodeAt(m))?H:U(p.charCodeAt(m))?U:J(p.charCodeAt(m))?J:z;var o=m;let t='"';m++;for(var r=e?e=>V(p[e]):e=>u(p.charCodeAt(e));m<p.length&&!r(m);){if(p.charCodeAt(m)===x){var s=p.charAt(m+1);if(void 0!==ce[s])t+=p.slice(m,m+2),m+=2;else if("u"===s){let e=2;for(;e<6&&((n=p.charCodeAt(m+e))>=D&&n<=O||n>=Z&&n<=ee||n>=X&&n<=te);)e++;if(6===e)t+=p.slice(m,m+6),m+=6;else{if(!(m+e>=p.length))throw l=void 0,l=p.slice(m,m+6),new b(`Invalid unicode character "${l}"`,m);m=p.length}}else t+=s,m+=2}else{var a,l=p.charAt(m),s=p.charCodeAt(m);if(s===j&&p.charCodeAt(m-1)!==x)t+="\\"+l;else if((a=s)===w||a===N||a===_||a===k||a===I)t+=le[l];else{if(!(32<=(a=s)&&a<=1114111))throw a=void 0,a=l,new b("Invalid character "+JSON.stringify(a),m);t+=l}m++}i&&v()}var c=B(p.charCodeAt(m));if(!(c&&(m+1>=p.length||V(function(e,t){let n=t;for(;R(e.charCodeAt(n));)n++;return e.charAt(n)}(p,m+1))))&&!e)return m=o,y(!0);c?(t+='"',m++):t=q(t,'"'),f+=t;{let e=!1;g();for(;p.charCodeAt(m)===A;){e=!0,m++,g();var d=(f=$(f,'"',!0)).length,h=y();f=h?function(e,t,n){return e.substring(0,t)+e.substring(t+n)}(f,d,1):q(f,'"')}e}return!0}return!1}function n(e,t){return p.slice(m,m+e.length)===e&&(f+=t,m+=e.length,!0)}function a(){for(var e=m;m<p.length&&!V(p[m]);)m++;if(m>e){if(p.charCodeAt(m)===E)m++,r(),p.charCodeAt(m)===S&&(m++,p.charCodeAt(m)===Q)&&m++;else{for(;R(p.charCodeAt(m-1))&&0<m;)m--;e=p.slice(e,m);f+="undefined"===e?"null":JSON.stringify(e),p.charCodeAt(m)===j&&m++}return!0}}function i(e){if(!M(p.charCodeAt(m)))throw e=p.slice(e,m),new b(`Invalid number '${e}', expecting a digit `+(p[m]?`but got '${p[m]}'`:"but reached end of input"),m)}function o(e){if(m>=p.length)return f+=p.slice(e,m)+"0",1;i(e)}function l(){throw new b("Colon expected",m)}}}},o={},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,{a:t}),t},i.d=function(e,t){for(var n in t)i.o(t,n)&&!i.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i(161);function i(e){var t=o[e];return void 0!==t||(t=o[e]={exports:{}},n[e].call(t.exports,t,t.exports,i)),t.exports}var n,o});
//# sourceMappingURL=jsoneditor-minimalist.map