/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Edge
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2023 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 10.0.0
 * @date    2023-12-21
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(self,function(){return n={897:function(e,t,n){"use strict";n.d(t,{x:function(){return r}});var c=n(2602),h=n(9791),d=n(7907);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}var r=function(){function l(t,e){if(!(this instanceof l))throw new TypeError("Cannot call a class as a function");this.dom={};var h=this,n=this.dom,e=(this.anchor=void 0,this.items=t,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0,this.limitHeight=!!e&&e.limitHeight,document.createElement("div")),i=(e.className="jsoneditor-contextmenu-root",n.root=e,document.createElement("div")),e=(i.className="jsoneditor-contextmenu",n.menu=i,e.appendChild(i),document.createElement("ul")),i=(e.className="jsoneditor-menu",i.appendChild(e),n.list=e,n.items=[],document.createElement("button")),n=(i.type="button",n.focusButton=i,document.createElement("li"));n.style.overflow="hidden",n.style.height="0",n.appendChild(i),e.appendChild(n),function a(l,c,e){e.forEach(function(t){var n,e,i,o,r,s;"separator"===t.type?((r=document.createElement("div")).className="jsoneditor-separator",(e=document.createElement("li")).appendChild(r),l.appendChild(e)):(n={},r=document.createElement("li"),l.appendChild(r),(e=document.createElement("button")).type="button",e.className=t.className,n.button=e,t.title&&(e.title=t.title),t.click&&(e.onclick=function(e){e.preventDefault(),h.hide(),t.click()}),r.appendChild(e),t.submenu?((o=document.createElement("div")).className="jsoneditor-icon",e.appendChild(o),(o=document.createElement("div")).className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),o.appendChild(document.createTextNode(t.text)),e.appendChild(o),(i=t.click?(e.className+=" jsoneditor-default",(o=document.createElement("button")).type="button",(n.buttonExpand=o).className="jsoneditor-expand",(s=document.createElement("div")).className="jsoneditor-expand",o.appendChild(s),r.appendChild(o),t.submenuTitle&&(o.title=t.submenuTitle),o):((s=document.createElement("div")).className="jsoneditor-expand",e.appendChild(s),e)).onclick=function(e){e.preventDefault(),h._onExpandItem(n),i.focus()},n.subItems=o=[],s=document.createElement("ul"),(n.ul=s).className="jsoneditor-menu",s.style.height="0",r.appendChild(s),a(s,o,t.submenu)):((r=document.createElement("div")).className="jsoneditor-icon",e.appendChild(r),(s=document.createElement("div")).className="jsoneditor-text",s.appendChild(document.createTextNode((0,d.Iu)(t.text))),e.appendChild(s)),c.push(n))})}(e,this.dom.items,t),this.maxHeight=0,t.forEach(function(e){e=24*(t.length+(e.submenu?e.submenu.length:0));h.maxHeight=Math.max(h.maxHeight,e)})}var e,t,n;return e=l,(t=[{key:"_getVisibleButtons",value:function(){var t=[],n=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e===n.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t}},{key:"show",value:function(e,t,n){this.hide();var i=!0,o=e.parentNode,r=e.getBoundingClientRect(),o=o.getBoundingClientRect(),s=t.getBoundingClientRect(),a=this,t=(this.dom.absoluteAnchor=(0,c.w)(e,t,function(){a.hide()}),r.bottom+this.maxHeight<s.bottom||r.top-this.maxHeight>s.top&&(i=!1),n?0:r.top-o.top);i?(n=e.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=t+n+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px"),this.limitHeight&&(o=i?s.bottom-r.bottom-10:r.top-s.top-10,this.dom.list.style.maxHeight=o+"px",this.dom.list.style.overflowY="auto"),this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=(0,h.getSelection)(),this.anchor=e,setTimeout(function(){a.dom.focusButton.focus()},0),l.visibleMenu&&l.visibleMenu.hide(),l.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose)&&this.onClose(),l.visibleMenu===this&&(l.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(n){var i,o=this,e=n===this.expandedItem,t=this.expandedItem;t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){o.expandedItem!==t&&(t.ul.style.display="",h.removeClassName)(t.ul.parentNode,"jsoneditor-selected")},300),this.expandedItem=void 0),e||((i=n.ul).style.display="block",i.clientHeight,setTimeout(function(){if(o.expandedItem===n){for(var e=0,t=0;t<i.childNodes.length;t++)e+=i.childNodes[t].clientHeight;i.style.height=e+"px",i.style.padding="5px 10px"}},0),(0,h.addClassName)(i.parentNode,"jsoneditor-selected"),this.expandedItem=n)}},{key:"_onKeyDown",value:function(e){var t,n,i,o,r=e.target,s=e.which,a=!1;27===s?(this.selection&&(0,h.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9===s?e.shiftKey?0===(n=(t=this._getVisibleButtons()).indexOf(r))&&(t[t.length-1].focus(),a=!0):(n=(t=this._getVisibleButtons()).indexOf(r))===t.length-1&&(t[0].focus(),a=!0):37===s?("jsoneditor-expand"===r.className&&(n=(t=this._getVisibleButtons()).indexOf(r),i=t[n-1])&&i.focus(),a=!0):38===s?(n=(t=this._getVisibleButtons()).indexOf(r),(i=(i=(i=t[n-1])&&"jsoneditor-expand"===i.className?t[n-2]:i)||t[t.length-1])&&i.focus(),a=!0):39===s?(n=(t=this._getVisibleButtons()).indexOf(r),(o=t[n+1])&&"jsoneditor-expand"===o.className&&o.focus(),a=!0):40===s&&(n=(t=this._getVisibleButtons()).indexOf(r),(o=(o=(o=t[n+1])&&"jsoneditor-expand"===o.className?t[n+2]:o)||t[0])&&(o.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())}}])&&i(e.prototype,t),n&&i(e,n),Object.defineProperty(e,"prototype",{writable:!1}),l}();r.visibleMenu=void 0},6436:function(e,t,n){"use strict";function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}n.d(t,{Q:function(){return i}});var i=function(){function n(e){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=e.errorTableVisible,this.onToggleVisibility=e.onToggleVisibility,this.onFocusLine=e.onFocusLine||function(){},this.onChangeHeight=e.onChangeHeight,this.dom={};var e=document.createElement("div"),t=(e.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=e,document.createElement("div")),e=(t.style.display="none",t.className="jsoneditor-additional-errors fadein",t.textContent="Scroll for more ▿",this.dom.additionalErrorsIndication=t,e.appendChild(t),document.createElement("span")),t=(e.className="jsoneditor-validation-error-icon",e.style.display="none",this.dom.validationErrorIcon=e,document.createElement("span"));t.className="jsoneditor-validation-error-count",t.style.display="none",this.dom.validationErrorCount=t,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}var e,t,i;return e=n,(t=[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(e,r){var s,t,a=this,n=(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<e.length?((n=document.createElement("div")).className="jsoneditor-validation-errors",(t=document.createElement("table")).className="jsoneditor-text-errors",n.appendChild(t),s=document.createElement("tbody"),t.appendChild(s),e.forEach(function(t){isNaN(t.line)?t.dataPath&&(n=r.find(function(e){return e.path===t.dataPath}))&&(e=n.line+1):e=t.line;var e,n=document.createElement("tr"),i=(n.className=isNaN(e)?"":"jump-to-line","error"===t.type?n.className+=" parse-error":n.className+=" validation-error",document.createElement("td")),o=document.createElement("button"),o=(o.className="jsoneditor-schema-error",i.appendChild(o),n.appendChild(i),document.createElement("td"));o.style="white-space: nowrap;",o.textContent=isNaN(e)?"":"Ln "+e,n.appendChild(o),"string"==typeof t?((i=document.createElement("td")).colSpan=2,(o=document.createElement("pre")).appendChild(document.createTextNode(t)),i.appendChild(o),n.appendChild(i)):((o=document.createElement("td")).appendChild(document.createTextNode(t.dataPath||"")),n.appendChild(o),i=document.createElement("td"),(o=document.createElement("pre")).appendChild(document.createTextNode(t.message.replace(/<br>/gi,"\n"))),i.appendChild(o),n.appendChild(i)),n.onclick=function(){a.onFocusLine(e)},s.appendChild(n)}),this.dom.validationErrors=n,this.dom.validationErrorsContainer.appendChild(n),this.dom.additionalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){a.dom.additionalErrorsIndication.style.display=0<a.dom.validationErrorsContainer.clientHeight&&0===a.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0,t=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0),this.onChangeHeight(t)):this.onChangeHeight(0),e.filter(function(e){return"error"!==e.type}).length);0<n?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=n,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=n+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),e.some(function(e){return"error"===e.type})?(t=e[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(t)?"parse error - check that the json is valid":"parse error on line "+t,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}])&&r(e.prototype,t),i&&r(e,i),Object.defineProperty(e,"prototype",{writable:!1}),n}()},2474:function(e,t,n){"use strict";function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}n.d(t,{R:function(){return i}});var i=function(){function t(e){if(!(this instanceof t))throw new TypeError("Cannot call a class as a function");if(this.target=e.target||null,!this.target)throw new Error('FocusTracker constructor called without a "target" to track.');this.onFocus="function"==typeof e.onFocus?e.onFocus:null,this.onBlur="function"==typeof e.onBlur?e.onBlur:null,this._onClick=this._onEvent.bind(this),this._onKeyUp=function(e){9!==e.which&&9!==e.keyCode||this._onEvent(e)}.bind(this),this._onBlur=this._onEvent.bind(this),this.focusFlag=!1,this.firstEventFlag=!0,(this.onFocus||this.onBlur)&&(document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp),document.addEventListener("blur",this._onBlur))}var e,n,i;return e=t,(n=[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick),document.removeEventListener("keyup",this._onKeyUp),document.removeEventListener("blur",this._onBlur),this._onEvent({target:document.body})}},{key:"_onEvent",value:function(e){e=e.target,e=e===this.target||!(!this.target.contains(e)&&!this.target.contains(document.activeElement));e?this.focusFlag||(this.onFocus&&this.onFocus({type:"focus",target:this.target}),this.focusFlag=!0):(this.focusFlag||this.firstEventFlag)&&(this.onBlur&&this.onBlur({type:"blur",target:this.target}),this.focusFlag=!1,this.firstEventFlag)&&(this.firstEventFlag=!1)}}])&&r(e.prototype,n),i&&r(e,i),Object.defineProperty(e,"prototype",{writable:!1}),t}()},3161:function(e,t,o){"use strict";var n=o(8170),i=o(8037),r=o(8038).treeModeMixins,s=o(8458).textModeMixins,a=o(341).previewModeMixins,l=o(9791),c=l.clear,h=l.extend,d=l.getInnerText,u=l.getInternetExplorerVersion,g=l.parse,l=o(2744).tryRequireAjv,p=o(2558).showTransformModal,m=o(6210).showSortModal,f=l();function C(e,t,n){if(!(this instanceof C))throw new Error('JSONEditor constructor called without "new".');var i=u();if(-1!==i&&i<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"===t.mode||"code"===t.mode||t.modes&&(-1!==t.modes.indexOf("text")||-1!==t.modes.indexOf("code")))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),t)&&Object.keys(t).forEach(function(e){-1===C.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')}),arguments.length&&this._create(e,t,n)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),C.modes={},C.prototype.DEBOUNCE_INTERVAL=150,C.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onExpand","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","onFocus","onBlur","colorPicker","onColorPicker","timestampTag","timestampFormat","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","limitDragging","maxVisibleChilds","onValidationError","modalAnchor","popupAnchor","createQuery","executeQuery","queryDescription","allowSchemaSuggestions","showErrorTable"],C.prototype._create=function(e,t,n){this.container=e,this.options=t||{},this.json=n||{};e=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(e)},C.prototype.destroy=function(){},C.prototype.set=function(e){this.json=e},C.prototype.get=function(){return this.json},C.prototype.setText=function(e){this.json=g(e)},C.prototype.getText=function(){return JSON.stringify(this.json)},C.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},C.prototype.getName=function(){return this.options&&this.options.name},C.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t=this.container,n=h({},this.options),i=n.mode,o=(n.mode=e,C.modes[e]);if(!o)throw new Error('Unknown mode "'+n.mode+'"');var r="text"===o.data,s=this.getName(),a=this[r?"getText":"get"]();if(this.destroy(),c(this),h(this,o.mixin),this.create(t,n),this.setName(s),this[r?"setText":"set"](a),"function"==typeof o.load)try{o.load.call(this)}catch(e){console.error(e)}if("function"==typeof n.onModeChange&&e!==i)try{n.onModeChange(e,i)}catch(e){console.error(e)}}},C.prototype.getMode=function(){return this.options.mode},C.prototype._onError=function(e){this.options&&"function"==typeof this.options.onError?this.options.onError(e):window.alert(e.toString())},C.prototype.setSchema=function(e,t){if(e){var n;try{this.options.ajv?n=this.options.ajv:((n=f({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(o(7171)),n.addMetaSchema(o(6273)))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(n){if(t){for(var i in t)n.removeSchema(i),t[i]&&n.addSchema(t[i],i);this.options.schemaRefs=t}this.validateSchema=n.compile(e),this.options.schema=e,this.options.schemaRefs=t,this.validate()}}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate();this.refresh(),"function"==typeof this._onSchemaChange&&this._onSchemaChange(e,t)},C.prototype.validate=function(){},C.prototype.refresh=function(){},(C.registerMode=function(e){var t;if(Array.isArray(e))for(o=0;o<e.length;o++)C.registerMode(e[o]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var n=e.mode;if(n in C.modes)throw new Error('Mode "'+n+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');for(var i=["setMode","registerMode","modes"],o=0;o<i.length;o++)if((t=i[o])in e.mixin)throw new Error('Reserved property "'+t+'" not allowed in mixin');C.modes[n]=e}})(r),C.registerMode(s),C.registerMode(a),C.ace=n,C.Ajv=f,C.VanillaPicker=i,C.showTransformModal=p,C.showSortModal=m,C.getInnerText=d,e.exports=C.default=C},6617:function(e,t,n){"use strict";n.d(t,{x:function(){return r}});var u=n(897),g=n(7907);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}var r=function(){function d(e,t,n,i){if(!(this instanceof d))throw new TypeError("Cannot call a class as a function");for(var o={code:{text:(0,g.Iu)("modeCodeText"),title:(0,g.Iu)("modeCodeTitle"),click:function(){i("code")}},form:{text:(0,g.Iu)("modeFormText"),title:(0,g.Iu)("modeFormTitle"),click:function(){i("form")}},text:{text:(0,g.Iu)("modeTextText"),title:(0,g.Iu)("modeTextTitle"),click:function(){i("text")}},tree:{text:(0,g.Iu)("modeTreeText"),title:(0,g.Iu)("modeTreeTitle"),click:function(){i("tree")}},view:{text:(0,g.Iu)("modeViewText"),title:(0,g.Iu)("modeViewTitle"),click:function(){i("view")}},preview:{text:(0,g.Iu)("modePreviewText"),title:(0,g.Iu)("modePreviewTitle"),click:function(){i("preview")}}},r=[],s=0;s<t.length;s++){var a=t[s],l=o[a];if(!l)throw new Error('Unknown mode "'+a+'"');l.className="jsoneditor-type-modes"+(n===a?" jsoneditor-selected":""),r.push(l)}var c=o[n];if(!c)throw new Error('Unknown mode "'+n+'"');var c=c.text,h=document.createElement("button"),c=(h.type="button",h.className="jsoneditor-modes jsoneditor-separator",h.textContent=c+" ▾",h.title=(0,g.Iu)("modeEditorTitle"),h.onclick=function(){new u.x(r).show(h,e)},document.createElement("div"));c.className="jsoneditor-modes",c.style.position="relative",c.appendChild(h),e.appendChild(c),this.dom={container:e,box:h,frame:c}}var e,t,n;return e=d,(t=[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}])&&i(e.prototype,t),n&&i(e,n),Object.defineProperty(e,"prototype",{writable:!1}),d}()},8170:function(e,t,n){var i;if(window.ace)i=window.ace;else try{i=n(6225),n(4091),n(3330),n(4317);var o=n(7923);i.config.setModuleUrl("ace/mode/json_worker",o)}catch(e){}e.exports=i},4864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,n){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})},6589:function(e,t){(n={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,n,i,o,r,s){var a=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[a-1];case 13:this.$={};break;case 14:this.$=r[a-1];break;case 15:this.$=[r[a-2],r[a]];break;case 16:this.$={},this.$[r[a][0]]=r[a][1];break;case 17:this.$=r[a-2],r[a-2][r[a][0]]=r[a][1];break;case 18:this.$=[];break;case 19:this.$=r[a-1];break;case 20:this.$=[r[a]];break;case 21:this.$=r[a-2],r[a-2].push(r[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){var t=this,n=[0],i=[null],o=[],r=this.table,s="",a=0,l=0,c=0,h=(this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={}),this.lexer.yylloc);function d(){var e=t.lexer.lex()||1;return e="number"!=typeof e?t.symbols_[e]||e:e}o.push(h),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var u,g,p,m,f,C,y,v,I,b={};;){if(p=n[n.length-1],void 0===(m=this.defaultActions[p]||(null==u&&(u=d()),r[p]&&r[p][u]))||!m.length||!m[0]){if(!c){for(f in v=[],r[p])this.terminals_[f]&&2<f&&v.push("'"+this.terminals_[f]+"'");var A="",A=this.lexer.showPosition?"Parse error on line "+(a+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+v.join(", ")+", got '"+this.terminals_[u]+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==u?"end of input":"'"+(this.terminals_[u]||u)+"'");this.parseError(A,{text:this.lexer.match,token:this.terminals_[u]||u,line:this.lexer.yylineno,loc:h,expected:v})}if(3==c){if(1==u)throw new Error(A||"Parsing halted.");l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,u=d()}for(;;){if(2..toString()in r[p])break;if(0==p)throw new Error(A||"Parsing halted.");I=1,n.length=n.length-2*I,i.length=i.length-I,o.length=o.length-I,p=n[n.length-1]}g=u,u=2,m=r[p=n[n.length-1]]&&r[p][2],c=3}if(m[0]instanceof Array&&1<m.length)throw new Error("Parse Error: multiple actions possible at state: "+p+", token: "+u);switch(m[0]){case 1:n.push(u),i.push(this.lexer.yytext),o.push(this.lexer.yylloc),n.push(m[1]),u=null,g?(u=g,g=null):(l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,0<c&&c--);break;case 2:if(C=this.productions_[m[1]][1],b.$=i[i.length-C],b._$={first_line:o[o.length-(C||1)].first_line,last_line:o[o.length-1].last_line,first_column:o[o.length-(C||1)].first_column,last_column:o[o.length-1].last_column},void 0!==(y=this.performAction.call(b,s,l,a,this.yy,m[1],i,o)))return y;C&&(n=n.slice(0,-1*C*2),i=i.slice(0,-1*C),o=o.slice(0,-1*C)),n.push(this.productions_[m[1]][0]),i.push(b.$),o.push(b._$),y=r[n[n.length-2]][n[n.length-1]],n.push(y);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var e,t,n,i,o=this._currentRules(),r=0;r<o.length&&(!(t=this._input.match(this.rules[o[r]]))||e&&!(t[0].length>e[0].length)||(e=t,n=r,this.options.flex));r++);return e?((i=e[0].match(/\n.*/g))&&(this.yylineno+=i.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:i?i[i.length-1].length-1:this.yylloc.last_column+e[0].length},this.yytext+=e[0],this.match+=e[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(e[0].length),this.matched+=e[0],i=this.performAction.call(this,this.yy,this,o[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),i||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,n,i){switch(n){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}};var n;t.parser=n,t.parse=n.parse.bind(n)},3879:function(e){"use strict";function i(){}i.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},i.mixin=function(e){for(var t=["on","off","emit"],n=0;n<t.length;n++)"function"==typeof e?e.prototype[t[n]]=i.prototype[t[n]]:e[t[n]]=i.prototype[t[n]];return e};var u={escapeRegExp:function(e){var t=/[\\^$.*+?()[\]{}|]/g,n=new RegExp(t.source);return e&&n.test(e)?e.replace(t,"\\$&"):e},extend:function(e,t){for(var n in t){var i;t.hasOwnProperty(n)&&((i=t[n])&&"[object Object]"===Object.prototype.toString.call(i)?(e[n]=e[n]||{},u.extend(e[n],i)):e[n]=i)}return e},each:function(e,t,n){if("[object Object]"===Object.prototype.toString.call(e))for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&t.call(n,i,e[i],e);else for(var o=0,r=e.length;o<r;o++)t.call(n,o,e[o],e)},createElement:function(e,t){var n,i=document.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(n in t)n in i?i[n]=t[n]:"html"===n?i.innerHTML=t[n]:i.setAttribute(n,t[n]);return i},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){u.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){u.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:u.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(i,o,r){var s;return function(){var e=this,t=arguments,n=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||i.apply(e,t)},o),n&&i.apply(e,t)}},rect:function(e,t){var n=window,e=e.getBoundingClientRect(),i=t?n.pageXOffset:0,t=t?n.pageYOffset:0;return{bottom:e.bottom+t,height:e.height,left:e.left+i,right:e.right+i,top:e.top+t,width:e.width}},includes:function(e,t){return-1<e.indexOf(t)},startsWith:function(e,t){return e.substr(0,t.length)===t},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}};function h(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function g(e,t,n){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),u.removeClass(e,"excluded"),n||(e.textContent=e.textContent)}function o(){var n,e;this.items.length&&(n=document.createDocumentFragment(),this.config.pagination?(e=this.pages.slice(0,this.pageIndex),u.each(e,function(e,t){u.each(t,function(e,t){g(t,n,this.customOption)},this)},this)):u.each(this.items,function(e,t){g(t,n,this.customOption)},this),n.childElementCount&&(u.removeClass(this.items[this.navIndex],"active"),this.navIndex=(n.querySelector(".selectr-option.selected")||n.querySelector(".selectr-option")).idx,u.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(n))}function d(e,t){t=t||e;var n={class:"selectr-option",role:"treeitem","aria-selected":!1};return this.customOption?n.html=this.config.renderOption(t):n.textContent=e.textContent,(t=u.createElement("li",n)).idx=e.idx,this.items.push(t),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(t.disabled=!0,u.addClass(t,"disabled")),t}function r(){var n,e=this.tree,t=e.scrollTop;e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length&&(n=document.createDocumentFragment(),u.each(this.pages[this.pageIndex],function(e,t){g(t,n,this.customOption)},this),e.appendChild(n),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length}))}function s(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&u.removeClass(this.inputContainer,"active"),u.hasClass(this.container,"notice")&&(u.removeClass(this.container,"notice"),u.addClass(this.container,"open"),this.input.focus()),u.each(this.items,function(e,t){u.removeClass(t,"excluded"),this.customOption||(t.textContent=t.textContent)},this))}function t(e,t){if(!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}t.prototype.render=function(e){var t;this.rendered||((this.el.selectr=this).config=u.extend({defaultSelected:!0,width:"auto",disabled:!1,disabledMobile:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,nativeKeyboard:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag...",messages:{noResults:"No results.",noOptions:"No options available.",maxSelections:"A maximum of {max} items can be selected.",tagDuplicate:"That tag is already in use.",searchPlaceholder:"Search options..."}},e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=h(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,!this.config.disabledMobile&&/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,this.supportsEventPassiveOption=this.detectEventPassiveOption(),i.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,h(this.config,"width")&&(u.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":u.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=u.createElement("div",{class:"selectr-container"}),this.config.customClass&&u.addClass(this.container,this.config.customClass),this.mobileDevice?u.addClass(this.container,"selectr-mobile"):u.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?u.addClass(this.el,"selectr-visible"):u.addClass(this.el,"selectr-hidden"),this.selected=u.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:0,"aria-expanded":!1}),this.label=u.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=u.createElement("div",{class:"selectr-options-container"});if(this.tree=u.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=u.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple?(u.addClass(this.label,"selectr-tags"),u.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.config.defaultSelected?this.getSelectedProperties("value"):[],this.selectedIndexes=this.getSelectedProperties("idx")):(this.selectedValue=null,this.selectedIndex=-1),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=u.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),u.addClass(this.container,"clearable")),this.config.taggable){var t=u.createElement("li",{class:"input-tag"});if(this.input=u.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),u.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators){this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators);for(var n=[],i=0;i<this.tagSeperators.length;i++)n.push(u.escapeRegExp(this.tagSeperators[i]));this.tagSeperatorsRegex=new RegExp(n.join("|"),"i")}else this.tagSeperatorsRegex=new RegExp(",","i")}this.config.searchable&&(this.input=u.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search",placeholder:this.config.messages.searchPlaceholder}),this.inputClear=u.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=u.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var o,r,s,a=!1,l=0;this.el.children.length&&u.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(a=u.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),u.each(t.children,function(e,t){t.idx=l,a.appendChild(d.call(this,t,a)),l++},this)):(t.idx=l,d.call(this,t),l++)},this),this.config.data&&Array.isArray(this.config.data)&&(o=!(this.data=[]),a=!1,l=0,u.each(this.config.data,function(e,t){h(t,"children")?(o=u.createElement("optgroup",{label:t.text}),a=u.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),u.each(t.children,function(e,t){(r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=h(t,"disabled"),this.options.push(r),o.appendChild(r),r.idx=l,a.appendChild(d.call(this,r,t)),this.data[l]=t,l++},this),this.el.appendChild(o)):((r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=h(t,"disabled"),this.options.push(r),r.idx=l,d.call(this,r,t),this.data[l]=t,l++)},this)),this.setSelected(!0);for(var c=this.navIndex=0;c<this.items.length;c++)if(s=this.items[c],!u.hasClass(s,"disabled")){u.addClass(s,"active"),this.navIndex=c;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=u.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=u.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex),t=this,setTimeout(function(){t.emit("selectr.init")},20))},t.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},t.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},t.prototype.detectEventPassiveOption=function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){e=!0}});window.addEventListener("test",null,t)}catch(e){}return e},t.prototype.bindEvents=function(){var n,i=this;this.events={},this.events.dismiss=function(e){e=e.target;this.container.contains(e)||!this.opened&&!u.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&u.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.noResults||this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,n=this.items[this.navIndex],i=this.navIndex;switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:this.navIndex<this.items.length-(t=1)&&this.navIndex++}for(this.navigating=!0;u.hasClass(this.items[this.navIndex],"disabled")||u.hasClass(this.items[this.navIndex],"excluded");){if(!(0<this.navIndex&&this.navIndex<this.items.length-1)){this.navIndex=i;break}if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}}e=u.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:e.top+e.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(e.top+e.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&r.call(this)):0===this.navIndex?this.tree.scrollTop=0:e.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(e.top-this.optsRect.top)),n&&u.removeClass(n,"active"),u.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),(this.config.nativeDropdown||this.mobileDevice)&&(this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===i.el&&i.toggle()},!!this.supportsEventPassiveOption&&{passive:!0}),this.container.addEventListener("click",function(e){e.target===i.el&&i.toggle()}),this.el.addEventListener("change",function(e){e.__selfTriggered||(i.el.multiple?(e=i.getSelectedProperties("idx"),e=function(e,t){for(var n,i=[],o=e.slice(0),r=0;r<t.length;r++)-1<(n=o.indexOf(t[r]))?o.splice(n,1):i.push(t[r]);return[i,o]}(i.selectedIndexes,e),u.each(e[0],function(e,t){i.select(t)},i),u.each(e[1],function(e,t){i.deselect(t)},i)):-1<i.el.selectedIndex&&i.select(i.el.selectedIndex))})),this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&i.selected===document.activeElement&&(i.toggle(),setTimeout(function(){i.el.focus()},200))}),this.selected.addEventListener("click",function(e){i.disabled||i.toggle(),e.preventDefault()}),this.config.nativeKeyboard&&(n="",this.selected.addEventListener("keydown",function(e){var t;i.disabled||i.selected!==document.activeElement||e.altKey||e.ctrlKey||e.metaKey||(" "===e.key||!i.opened&&-1<["Enter","ArrowUp","ArrowDown"].indexOf(e.key)?(i.toggle(),e.preventDefault(),e.stopPropagation()):e.key.length<=2&&String[String.fromCodePoint?"fromCodePoint":"fromCharCode"](e.key[String.codePointAt?"codePointAt":"charCodeAt"](0))===e.key&&(i.config.multiple?(i.open(),i.config.searchable&&(i.input.value=e.key,i.input.focus(),i.search(null,!0))):(n+=e.key,(t=i.search(n,!0))&&t.length&&(i.clear(),i.setValue(t[0].value)),setTimeout(function(){n=""},1e3)),e.preventDefault(),e.stopPropagation()))}),this.container.addEventListener("keyup",function(e){i.opened&&"Escape"===e.key&&(i.close(),e.stopPropagation(),i.selected.focus())})),this.label.addEventListener("click",function(e){u.hasClass(e.target,"selectr-tag-remove")&&i.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){var t=u.closest(e.target,function(e){return e&&u.hasClass(e,"selectr-option")});t&&!u.hasClass(t,"disabled")&&(u.hasClass(t,"selected")?(i.el.multiple||!i.el.multiple&&i.config.allowDeselect)&&i.deselect(t.idx):i.select(t.idx),i.opened&&!i.el.multiple)&&i.close(),e.preventDefault(),e.stopPropagation()}),this.tree.addEventListener("mouseover",function(e){!u.hasClass(e.target,"selectr-option")||u.hasClass(e.target,"disabled")||(u.removeClass(i.items[i.navIndex],"active"),u.addClass(e.target,"active"),i.navIndex=[].slice.call(i.items).indexOf(e.target))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){i.searching=!0}),this.input.addEventListener("blur",function(e){i.searching=!1}),this.input.addEventListener("keyup",function(e){i.search(),i.config.taggable||(this.value.length?u.addClass(this.parentNode,"active"):u.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){i.input.value=null,s.call(i),i.tree.childElementCount||o.call(i)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){var t,n;i.search(),i.config.taggable&&this.value.length&&(t=this.value.trim()).length&&(13===e.which||i.tagSeperatorsRegex.test(t))&&(e=t.replace(i.tagSeperatorsRegex,""),(n=(e=(e=u.escapeRegExp(e)).trim()).length?i.add({value:e,textContent:e,selected:!0},!0):n)?(i.close(),s.call(i)):(this.value="",i.setMessage(i.config.messages.tagDuplicate)))}),this.update=u.debounce(function(){i.opened&&i.config.closeOnScroll&&i.close(),i.width&&(i.container.style.width=i.width),i.invert()},50),this.requiresPagination&&(this.paginateItems=u.debounce(function(){r.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.on("selectr.destroy",function(){document.removeEventListener("click",this.events.dismiss),window.removeEventListener("keydown",this.events.navigate),window.removeEventListener("resize",this.update),window.removeEventListener("scroll",this.update)}),this.el.form&&(this.el.form.addEventListener("reset",this.events.reset),this.on("selectr.destroy",function(){this.el.form.removeEventListener("reset",this.events.reset)}))},t.prototype.setSelected=function(e){var n;this.config.data||this.el.multiple||!this.el.options.length||(0!==this.el.selectedIndex||this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),u.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data&&(!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&0<this.config.data.length&&this.select(0),n=0,u.each(this.config.data,function(e,t){h(t,"children")?u.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(n),n++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(n),n++)},this))},t.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),u.removeClass(this.el,"selectr-hidden"),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1,delete this.el.selectr)},t.prototype.change=function(e){var t=this.items[e],n=this.options[e];n.disabled||(n.selected&&u.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},t.prototype.select=function(i){var e=this.items[i],t=[].slice.call(this.el.options),n=this.options[i];if(this.el.multiple){if(u.includes(this.selectedIndexes,i))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage(this.config.messages.maxSelections.replace("{max}",this.config.maxSelections),!0),!1;this.selectedValues.push(n.value),this.selectedIndexes.push(i),!function(e){var l,c=this,n=document.createDocumentFragment(),t=this.options[e.idx],i=this.data?this.data[e.idx]:t,o={class:"selectr-tag"},i=(this.customSelected?o.html=this.config.renderSelection(i):o.textContent=t.textContent,u.createElement("li",o)),o=u.createElement("button",{class:"selectr-tag-remove",type:"button"});i.appendChild(o),i.idx=e.idx,i.tag=t.value,this.tags.push(i),this.config.sortSelected?(o=this.tags.slice(),l=function(e,i){e.replace(/(\d+)|(\D+)/g,function(e,t,n){i.push([t||1/0,n||""])})},o.sort(function(e,t){var n,i,o=[],r=[];for(!0===c.config.sortSelected?(n=e.tag,i=t.tag):"text"===c.config.sortSelected&&(n=e.textContent,i=t.textContent),l(n,o),l(i,r);o.length&&r.length;){var s=o.shift(),a=r.shift(),s=s[0]-a[0]||s[1].localeCompare(a[1]);if(s)return s}return o.length-r.length}),u.each(o,function(e,t){n.appendChild(t)}),this.label.innerHTML=""):n.appendChild(i),this.config.taggable?this.label.insertBefore(n,this.input.parentNode):this.label.appendChild(n)}.call(this,e)}else{var o=this.data?this.data[i]:n;this.customSelected?this.label.innerHTML=this.config.renderSelection(o):this.label.textContent=n.textContent,this.selectedValue=n.value,this.selectedIndex=i,u.each(this.options,function(e,t){var n=this.items[e];e!==i&&(n&&u.removeClass(n,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}u.includes(t,n)||this.el.add(n),e.setAttribute("aria-selected",!0),u.addClass(e,"selected"),u.addClass(this.container,"has-selected"),n.selected=!0,n.setAttribute("selected",""),this.emit("selectr.change",n),this.emit("selectr.select",n),"createEvent"in document?((o=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),o.__selfTriggered=!0,this.el.dispatchEvent(o)):this.el.fireEvent("onchange")},t.prototype.deselect=function(e,t){var n=this.items[e],i=this.options[e];if(this.el.multiple){var o=this.selectedIndexes.indexOf(e),o=(this.selectedIndexes.splice(o,1),this.selectedValues.indexOf(i.value));this.selectedValues.splice(o,1),!function(n){var i=!1;u.each(this.tags,function(e,t){t.idx===n.idx&&(i=t)},this),i&&(this.label.removeChild(i),this.tags.splice(this.tags.indexOf(i),1))}.call(this,n),this.tags.length||u.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,u.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),u.removeClass(this.items[e],"selected"),i.selected=!1,i.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",i),"createEvent"in document?((o=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),o.__selfTriggered=!0,this.el.dispatchEvent(o)):this.el.fireEvent("onchange")},t.prototype.setValue=function(n){var i=Array.isArray(n);if(i||(n=n.toString().trim()),!this.el.multiple&&i)return!1;u.each(this.options,function(e,t){(i&&-1<n.indexOf(t.value)||t.value===n)&&this.change(t.idx)},this)},t.prototype.getValue=function(e,t){var n,i;return this.el.multiple?e?this.selectedIndexes.length&&(i={values:[]},u.each(this.selectedIndexes,function(e,t){t=this.options[t];i.values[e]={value:t.value,text:t.textContent}},this)):i=this.selectedValues.slice():i=e?{value:(n=this.options[this.selectedIndex]).value,text:n.textContent}:this.selectedValue,i=e&&t?JSON.stringify(i):i},t.prototype.add=function(n,i){if(n){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(n))u.each(n,function(e,t){this.add(t,i)},this);else if("[object Object]"===Object.prototype.toString.call(n)){if(i){var o=!1;if(u.each(this.options,function(e,t){t.value.toLowerCase()===n.value.toLowerCase()&&(o=!0)}),o)return!1}var e=u.createElement("option",n);return this.data.push(n),this.mobileDevice&&this.el.add(e),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,d.call(this,e),n.selected&&this.select(e.idx),this.setPlaceholder(),e}return this.config.pagination&&this.paginate(),!0}},t.prototype.remove=function(e){var n,i=[];Array.isArray(e)?u.each(e,function(e,t){u.isInt(t)?i.push(this.getOptionByIndex(t)):"string"==typeof t&&i.push(this.getOptionByValue(t))},this):u.isInt(e)?i.push(this.getOptionByIndex(e)):"string"==typeof e&&i.push(this.getOptionByValue(e)),i.length&&(u.each(i,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);t=this.items[n].parentNode;t&&t.removeChild(this.items[n]),this.items.splice(n,1),u.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination)&&this.paginate()},t.prototype.removeAll=function(){this.clear(!0),u.each(this.el.options,function(e,t){this.el.remove(t)},this),u.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},t.prototype.search=function(a,e){var l,c,h,d,t;if(!this.navigating)return l=!1,a||(a=this.input.value,l=!0,this.removeMessage(),u.truncate(this.tree)),c=[],h=document.createDocumentFragment(),0<(a=a.trim().toLowerCase()).length?(d=e?u.startsWith:u.includes,u.each(this.options,function(e,t){var n,i,o,r,s=this.items[t.idx];d(t.textContent.trim().toLowerCase(),a)&&!t.disabled?(c.push({text:t.textContent,value:t.value}),l&&(g(s,h,this.customOption),u.removeClass(s,"excluded"),!this.customOption)&&(n=a,o=(t=t).textContent,n=new RegExp(n,"ig"),r=n.exec(o))&&(t.innerHTML="",(i=document.createElement("span")).classList.add("selectr-match"),i.textContent=r[0],t.appendChild(document.createTextNode(o.substring(0,r.index))),t.appendChild(i),t.appendChild(document.createTextNode(o.substring(n.lastIndex))))):l&&u.addClass(s,"excluded")},this),l&&(h.childElementCount?(e=this.items[this.navIndex],t=h.querySelector(".selectr-option:not(.excluded)"),this.noResults=!1,u.removeClass(e,"active"),this.navIndex=t.idx,u.addClass(t,"active")):this.config.taggable||(this.noResults=!0,this.setMessage(this.config.messages.noResults)),this.tree.appendChild(h))):o.call(this),c},t.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},t.prototype.open=function(){var e=this;if(!this.options.length)return!1;this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(u.addClass(this.container,"native-open"),this.config.data&&u.each(this.options,function(e,t){this.el.add(t)},this)):(u.addClass(this.container,"open"),o.call(this),this.invert(),this.tree.scrollTop=0,u.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))},t.prototype.close=function(){var e;this.opened&&this.emit("selectr.close"),this.opened=!1,this.navigating=!1,this.mobileDevice||this.config.nativeDropdown?u.removeClass(this.container,"native-open"):(e=u.hasClass(this.container,"notice"),this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(u.removeClass(this.container,"notice"),this.notice.textContent=""),u.removeClass(this.container,"open"),u.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),u.truncate(this.tree),s.call(this))},t.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&u.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),u.removeClass(this.container,"selectr-disabled")},t.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&u.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,u.addClass(this.container,"selectr-disabled")},t.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),u.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},t.prototype.clear=function(e,t){var n;this.el.multiple?this.selectedIndexes.length&&(n=this.selectedIndexes.slice(),t?this.deselect(n.slice(-1)[0]):u.each(n,function(e,t){this.deselect(t)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,e),this.emit("selectr.clear")},t.prototype.serialise=function(e){var i=[];return u.each(this.options,function(e,t){var n={value:t.value,text:t.textContent};t.selected&&(n.selected=!0),t.disabled&&(n.disabled=!0),i[e]=n}),e?JSON.stringify(i):i},t.prototype.serialize=function(e){return this.serialise(e)},t.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e=this.config.messages.noOptions),this.placeEl.innerHTML=e},t.prototype.paginate=function(){var n;if(this.items.length)return(n=this).pages=this.items.map(function(e,t){return t%n.config.pagination==0?n.items.slice(t,t+n.config.pagination):null}).filter(function(e){return e}),this.pages},t.prototype.setMessage=function(e,t){t&&this.close(),u.addClass(this.container,"notice"),this.notice.textContent=e},t.prototype.removeMessage=function(){u.removeClass(this.container,"notice"),this.notice.innerHTML=""},t.prototype.invert=function(){var e=u.rect(this.selected),t=this.tree.parentNode.offsetHeight,n=window.innerHeight;e.top+e.height+t>n?(u.addClass(this.container,"inverted"),this.isInverted=!0):(u.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=u.rect(this.tree)},t.prototype.getOptionByIndex=function(e){return this.options[e]},t.prototype.getOptionByValue=function(e){for(var t=!1,n=0,i=this.options.length;n<i;n++)if(this.options[n].value.trim()===e.toString().trim()){t=this.options[n];break}return t},e.exports=t},4188:function(e,t,n){"use strict";n.d(t,{EX:function(){return o},WF:function(){return r},oW:function(){return s},qD:function(){return i}});var i=document.body,o=10485760,r=2e4,s=2147483648},2602:function(e,t,n){"use strict";n.d(t,{w:function(){return i}});var u=n(9791);function i(n,e,i){var t,o=3<arguments.length&&void 0!==arguments[3]&&arguments[3],r="function"==typeof(a=n).getRootNode?a.getRootNode():window,s={},a=n.getBoundingClientRect(),l=e.getBoundingClientRect(),c=document.createElement("div");function h(){if(c&&c.parentNode){for(var e in c.parentNode.removeChild(c),s)t=e,Object.prototype.hasOwnProperty.call(s,t)&&((t=s[e])&&(0,u.removeEventListener)(r,e,t),delete s[e]);"function"==typeof i&&i(n)}var t}function d(e){(e=e.target)===c||(0,u.isChildOf)(e,c)||h()}return c.className="jsoneditor-anchor",c.style.position="absolute",c.style.left=a.left-l.left+"px",c.style.top=a.top-l.top+"px",c.style.width=a.width-2+"px",c.style.height=a.height-2+"px",c.style.boxSizing="border-box",e.appendChild(c),s.mousedown=(0,u.addEventListener)(r,"mousedown",d),s.mousewheel=(0,u.addEventListener)(r,"mousewheel",d),o&&(t=null,c.onmouseover=function(){clearTimeout(t),t=null},c.onmouseout=function(){t=t||setTimeout(h,200)}),c.destroy=h,c}},7923:function(e){
e.exports="data:application/javascript;base64,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"
},7907:function(e,t,n){"use strict";n.d(t,{Iu:function(){return h},cC:function(){return c},m0:function(){return l}});n(4987);var r={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},es:{array:"Matriz",auto:"Auto",appendText:"Agregar",appendTitle:"Agregue un nuevo campo con el tipo 'auto' después de este campo (Ctrl + Shift + Ins)",appendSubmenuTitle:"Seleccione el tipo de campo que se agregará",appendTitleAuto:"Agregue un nuevo campo con el tipo 'auto' (Ctrl + Shift + Ins)",ascending:"Ascendente",ascendingTitle:"Ordene los elementos secundarios de este ${type} en orden ascendente",actionsMenu:"Haga clic para abrir el menú de acciones (Ctrl + M)",cannotParseFieldError:"No se puede parsear el campo en JSON",cannotParseValueError:"No se puede parsear el valor en JSON",collapseAll:"Contraer todos los campos",compactTitle:"Compactar datos JSON, eliminar todos los espacios en blanco (Ctrl + Shift + I)",descending:"Descendente",descendingTitle:"Ordene los hijos de este ${type} en orden descendente",drag:"Arrastre para mover este campo (Alt + Mayús + Flechas)",duplicateKey:"llave duplicada",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos seleccionados (Ctrl + D)",duplicateField:"Duplicar este campo (Ctrl + D)",duplicateFieldError:"Nombre de campo duplicado",empty:"vacio",expandAll:"Expandir todos los campos",expandTitle:"Haga clic para expandir/contraer este campo (Ctrl + E). \n  Ctrl+Clic para expandir/contraer incluyendo todos los niños.",formatTitle:"Formatee los datos JSON, con la sangría y los avances de línea adecuados (Ctrl + I)",insert:"Insertar",insertTitle:"Inserte un nuevo campo con el tipo 'auto' antes de este campo (Ctrl + Ins)",insertSub:"Seleccione el tipo de campo a insertar",object:"Objeto",ok:"Ok",redo:"Rehacer (Ctrl+Mayús+Z)",removeText:"Eliminar",removeTitle:"Eliminar campos seleccionados (Ctrl+Supr)",removeField:"Eliminar este campo (Ctrl+Supr)",repairTitle:"Reparar JSON: corrija comillas y caracteres de escape, elimine comentarios y notación JSONP, convierta objetos JavaScript en JSON.",searchTitle:"Campos de búsqueda y valores",searchNextResultTitle:"Siguiente resultado (Entrar)",searchPreviousResultTitle:"Resultado anterior (Shift + Enter)",selectNode:"Seleccione un nodo...",showAll:"mostrar todo",showMore:"mostrar más",showMoreStatus:"mostrando ${visibleChilds} de ${totalChilds} elementos.",sort:"Ordenar",sortTitle:"Ordene los hijos de este ${type}",sortTitleShort:"Ordenar contenidos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dirección:",sortFieldTitle:"Seleccione el campo anidado por el cual ordenar la matriz u objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar el campo seleccionado en orden ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar por el campo seleccionado, en orden descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar o transformar los hijos de este ${type}",transformTitleShort:"Filtrar, ordenar o transformar contenidos",extract:"Extraer",extractTitle:"Extrae este ${type}",transformQueryTitle:"Ingrese una consulta JMESPath",transformWizardLabel:"Wizard",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Seleccione un campo",transformQueryLabel:"Consulta",transformPreviewLabel:"Vista Previa",type:"Tipo",typeTitle:"Cambiar el tipo de campo",openUrl:"Ctrl+Click o Ctrl+Enter para abrir la URL en una nueva ventana",undo:"Deshacer la última acción (Ctrl+Z)",validationCannotMove:"No se puede mover un campo a un hijo de sí mismo.",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Tipo de campo "objeto".  Un objeto contiene un conjunto desordenado de pares clave/valor.',arrayType:'Tipo de campo "matriz".  Una matriz contiene una colección ordenada de valores.',stringType:'Tipo de campo "cadena".  El tipo de campo no se determina a partir del valor,  pero siempre se devuelve como una cadena.',modeEditorTitle:"Cambiar modo de editor",modeCodeText:"Codigo",modeCodeTitle:"Cambiar al resaltador de código",modeFormText:"Formulario",modeFormTitle:"Cambiar al editor de formularios",modeTextText:"Texto",modeTextTitle:"Cambiar al editor de texto sin formato",modeTreeText:"Arbol",modeTreeTitle:"Cambiar al editor de árbol",modeViewText:"Vista",modeViewTitle:"Cambiar a la vista de árbol",modePreviewText:"Vista Previa",modePreviewTitle:"Cambiar al modo de vista previa",examples:"Ejemplos",default:"Predeterminado",containsInvalidProperties:"Contiene propiedades no validas",containsInvalidItems:"Contiene items no validos"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",collapseAll:"缩进所有字段",compactTitle:"压缩JSON数据，删除所有空格 (Ctrl+Shift+I)",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",formatTitle:"使用适当的缩进和换行符格式化JSON数据 (Ctrl+I)",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",repairTitle:"修复JSON：修复引号和转义符，删除注释和JSONP表示法，将JavaScript对象转换为JSON。",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省",containsInvalidProperties:"包含无效的属性",containsInvalidItems:"包含无效项目"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espaços em branco (Ctrl+Shift+I)",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova comentários e notação JSONP, transforme objetos JavaScript em JSON.",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia",containsInvalidProperties:"Contém propriedades inválidas",containsInvalidItems:"Contém itens inválidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan",containsInvalidProperties:"Geçersiz özellikler içeriyor",containsInvalidItems:"Geçersiz öğeler içeriyor"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:"クリックしてフィールドを展開/折りたたむ (Ctrl+E). \nCtrl+Click ですべての子要素を展開/折りたたむ",insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト",containsInvalidProperties:"無効なプロパティが含まれています",containsInvalidItems:"無効なアイテムが含まれています"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:"Étendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour étendre/regrouper avec tous les champs.",insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:'Champ de type "chaîne". Ce type de champ n\'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.',modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut",containsInvalidProperties:"Contient des propriétés non valides",containsInvalidItems:"Contient des éléments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anhängen",appendTitle:"Fügen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",appendSubmenuTitle:"Wählen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzufügen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum Öffnen des Aktionsmenüs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schlüssel",duplicateText:"Duplikat",duplicateTitle:"Ausgewählte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:"Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). \nStrg+Klicken Sie, um dieses Feld einschließlich aller Elemente zu erweitern/zu kollabieren.",formatTitle:"JSON-Daten mit korrekter Einrückung und Zeilenvorschüben formatieren (Strg+\\)",insert:"einfügen",insertTitle:"Fügen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"Wählen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgewählte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anführungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",searchTitle:"Suchfelder und Werte",searchNextResultTitle:"Nächstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"Wählen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"Wählen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgewählte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgewählte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder auswählen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"Ändern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu öffnen",undo:"Letzte Aktion rückgängig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enthält eine ungeordnete Menge von Schlüssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enthält eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zurückgegeben.',modeEditorTitle:"Editor-Modus umschalten",modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor für einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele",default:"Standardmäßig",containsInvalidProperties:"Enthält ungültige Eigenschaften",containsInvalidItems:"Enthält ungültige Elemente"},ru:{array:"Массив",auto:"Авто",appendText:"Добавить",appendTitle:"Добавить новое поле с типом 'авто' после этого поля (Ctrl+Shift+Ins)",appendSubmenuTitle:"Выбрать тип поля для добавления",appendTitleAuto:"Добавить новое поле с типом 'авто' (Ctrl+Shift+Ins)",ascending:"По возрастанию",ascendingTitle:"Сортировать ${type} по возрастанию",actionsMenu:"Нажмите для открытия меню действий (Ctrl+M)",cannotParseFieldError:"Невозможно преобразовать поле в JSON",cannotParseValueError:"Невозможно преобразовать значение в JSON",collapseAll:"Свернуть все",compactTitle:"Минификация JSON (Ctrl+Shift+I)",descending:"По убыванию",descendingTitle:"Сортировать ${type} по убыванию",drag:"Потяните для перемещения этого поля (Alt+Shift+Arrows)",duplicateKey:"повторяющийся ключ",duplicateText:"Дублировать",duplicateTitle:"Дублирование полей (Ctrl+D)",duplicateField:"Дублировать поле (Ctrl+D)",duplicateFieldError:"Дублирование названия поля",empty:"пустой",expandAll:"Развернуть все",expandTitle:"Нажмите для раскрытия/скрытия поля (Ctrl+E)\nили Ctrl+Click для раскрытия/скрытия всех потомков.",formatTitle:"Форматирование JSON (Ctrl+I)",insert:"Вставить",insertTitle:"Вставить новое поле с типом 'авто' перед этим полем (Ctrl+Ins)",insertSub:"Выбрать тип поля для вставки",object:"Объект",ok:"ОК",redo:"Повторить (Ctrl+Shift+Z)",removeText:"Удалить",removeTitle:"Удалить выбранные поля (Ctrl+Del)",removeField:"Удалить поле (Ctrl+Del)",repairTitle:"Восстановите JSON: исправьте кавычки и escape-символы, удалите комментарии и нотацию JSONP, модифицируйте объекты JavaScript в JSON.",searchTitle:"Поиск",searchNextResultTitle:"Следующий результат (Enter)",searchPreviousResultTitle:"Предыдущий результат (Shift + Enter)",selectNode:"Выбор узла...",showAll:"показать все",showMore:"больше",showMoreStatus:"${visibleChilds} из ${totalChilds}",sort:"Сортировка",sortTitle:"Сортировка потомков типа ${type}",sortTitleShort:"Сортировка содержимого",sortFieldLabel:"Поле:",sortDirectionLabel:"Направление:",sortFieldTitle:"Выберите поле для сортировки массива или объекта",sortAscending:"По возрастанию",sortAscendingTitle:"Сортировка выбранного поря по возрастанию",sortDescending:"По убыванию",sortDescendingTitle:"Сортировка выбранного поря по убыванию",string:"Строка",transform:"Модификация",transformTitle:"Фильтрация, сортировка или модификация данных типа ${type}",transformTitleShort:"Фильтрация, сортировка или модификация данных",extract:"Извлечение",extractTitle:"Извлечь тип ${type}",transformQueryTitle:"Введите JMESpath запрос",transformWizardLabel:"Мастер",transformWizardFilter:"Фильтр",transformWizardSortBy:"Сортировка",transformWizardSelectFields:"Поля",transformQueryLabel:"Запрос",transformPreviewLabel:"Просмотр",type:"Тип",typeTitle:"Изменить тип этого поля",openUrl:"Ctrl+Click или Ctrl+Enter для открытия url в новом окне",undo:"Отменить (Ctrl+Z)",validationCannotMove:"Поле не может быть перемещено в потомка",autoType:"Тип поля автоматически определяется по значению и может быть строкой, числом, логическим значением или null.",objectType:"Объект содержит неупорядоченный набор пар ключ/значение.",arrayType:"Массив содержит упорядоченный набор значений.",stringType:"Тип поля не определяется из значения, но всегда возвращается как строка.",modeEditorTitle:"Переключение режима редактора",modeCodeText:"Код",modeCodeTitle:"Переключить в режим редактора кода",modeFormText:"Форма",modeFormTitle:"Переключить в режим формы",modeTextText:"Текст",modeTextTitle:"Переключить в режим редактора текста",modeTreeText:"Дерево",modeTreeTitle:"Переключить в режим редактора дерева",modeViewText:"Просмотр дерева",modeViewTitle:"Переключить в режим просмотра дерева",modePreviewText:"Просмотр",modePreviewTitle:"Переключить в режим просмотра",examples:"Примеры",default:"По умолчанию",containsInvalidProperties:"Содержит недопустимые свойства",containsInvalidItems:"Содержит недопустимые элементы"},ko:{array:"배열",auto:"자동",appendText:"추가",appendTitle:'선택한 요소 아래에 "자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',appendSubmenuTitle:"추가할 요소의 유형을 선택해주세요.",appendTitleAuto:'"자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',ascending:"오름차순",ascendingTitle:"선택한 ${type}의 하위 요소를 오름차순 정렬합니다.",actionsMenu:"메뉴 열기 (Ctrl + M)",cannotParseFieldError:"JSON의 요소를 해석할 수 없습니다.",cannotParseValueError:"JSON의 값을 해석할 수 없습니다.",collapseAll:"모두 접기",compactTitle:"모든 공백을 제거하여 JSON 데이터를 작게 만듭니다. (Ctrl + Shift + I)",descending:"내림차순",descendingTitle:"선택한 ${type}의 하위 요소를 내림차순으로 정렬",drag:"드래그하여 요소를 이동합니다. (Alt + Shift + Arrows)",duplicateKey:"복제키",duplicateText:"복제",duplicateTitle:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateField:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateFieldError:"요소 이름이 중복되었습니다.",empty:"비어있음",expandAll:"모두 열기",expandTitle:"클릭하여 요소를 열거나 닫습니다. (Ctrl + E) \nCtrl + Click으로 모든 하위 요소를 열거나 닫습니다.",formatTitle:"적절한 들여쓰기 및 줄바꿈으로 JSON 데이터를 정형화합니다. (Ctrl + I)",insert:"삽입",insertTitle:"선택한 요소 위에 새요소를 삽입합니다. (Ctrl + Ins)",insertSub:"삽입할 요소의 유형을 선택해주세요.",object:"객체",ok:"확인",redo:"다시 실행 (Ctrl + Shift + Z)",removeText:"삭제",removeTitle:"선택한 요소를 삭제합니다. (Ctrl + Del)",removeField:"선택한 요소를 삭제합니다. (Ctrl + Del)",repairTitle:"JSON 교정: JSON 내의 주석과 JSONP 표기법을 지우고 따옴표와 이스케이프 문자를 수정합니다.",searchTitle:"요소 또는 값 찾기",searchNextResultTitle:"다음으로 찾기 (Enter)",searchPreviousResultTitle:"이전으로 찾기 (Shift + Enter)",selectNode:"요소를 선택해주세요...",showAll:"모두보기",showMore:"더보기",showMoreStatus:"${totalChilds} 개의 항목 중 ${visibleChilds} 개를 표시합니다.",sort:"정렬",sortTitle:"선택한 ${type}의 하위 요소를 정렬합니다.",sortTitleShort:"정렬",sortFieldLabel:"요소:",sortDirectionLabel:"순서:",sortFieldTitle:"배열이나 객체를 정렬하는 요소를 선택해주세요.",sortAscending:"오름차순",sortAscendingTitle:"선택한 요소를 오름차순으로 정렬합니다.",sortDescending:"내림차순",sortDescendingTitle:"선택한 요소를 내림차순으로 정렬합니다.",string:"문자",transform:"변환",transformTitle:"선택한 ${type}의 하위 요소를 필터하거나 정렬 또는 변환합니다.",transformTitleShort:"내용을 필터하거나 정렬 또는 변환합니다.",extract:"추출",extractTitle:"선택한 ${type}의 값을 최상위에 위치시킵니다.",transformQueryTitle:"JMESPath 쿼리를 입력해주세요.",transformWizardLabel:"마법사",transformWizardFilter:"필터",transformWizardSortBy:"정렬",transformWizardSelectFields:"요소를 선택해주세요.",transformQueryLabel:"쿼리",transformPreviewLabel:"미리보기",type:"유형",typeTitle:"선택한 요소의 유형을 변경합니다.",openUrl:"Ctrl + Click 또는 Ctrl + Enter로 새 창에서 URL 열기",undo:"실행 취소 (Ctrl + Z)",validationCannotMove:"하위 요소로 이동할 수 없습니다.",autoType:"자동: 요소의 형식이 값의 유형으로 결정됩니다. 문자, 숫자, 부울, 또는 null만 허용됩니다.",objectType:"객체: 순서대로 나열되지 않은 이름/값 쌍으로 이루어진 집합입니다.",arrayType:"배열: 순서대로 나열된 값의 집합입니다.",stringType:"문자: 요소의 유형이 값에서 결정되지 않지만 항상 문자로 반환됩니다.",modeEditorTitle:"편집기 유형 변경",modeCodeText:"코드",modeCodeTitle:"형식 교정을 도와주는 기능이 포함된 문자 편집기",modeFormText:"입력 양식",modeFormTitle:"정해진 요소에 값을 입력하는 편집기",modeTextText:"문자",modeTextTitle:"단순 문자 편집기",modeTreeText:"트리",modeTreeTitle:"트리 구조로 표시되는 편집기",modeViewText:"보기",modeViewTitle:"읽기전용 트리 구조로 JSON을 표시",modePreviewText:"미리보기",modePreviewTitle:"읽기전용 문자로 JSON을 표시",examples:"예제",default:"기본값",containsInvalidProperties:"잘못된 속성이 포함되어 있습니다.",containsInvalidItems:"잘못된 항목이 포함되어 있습니다"}},i=Object.keys(r),s="en",o="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0,a=i.find(function(e){return e===o})||s;function l(t){var e;t&&((e=i.find(function(e){return e===t}))?a=e:console.error("Language not found"))}function c(e){if(e)for(var t in e)!function(t){i.find(function(e){return e===t})||i.push(t),r[t]=Object.assign({},r[s],r[t],e[t])}(t)}function h(e,t,n){var i=r[n=n||a][e]||r[s][e]||e;if(t)for(var o in t)i=i.replace("${"+o+"}",t[o]);return i}},6056:function(e,t,n){"use strict";n.d(t,{J:function(){return r},r:function(){return o}});var t=n(5156),i=n.n(t),s=n(9791);function o(e,t){var n,i=t.sort,o=t.filter,t=t.projection,r="";return o?(n="@"!==o.field?["0"].concat((0,s.parsePath)("."+o.field)):["0"],n="string"==typeof(0,s.get)(e,n)?o.value:(0,s.parseString)(o.value),r+="[? "+o.field+" "+o.relation+" `"+JSON.stringify(n)+"`]"):r+=Array.isArray(e)?"[*]":"@",i&&("desc"===i.direction?r+=" | reverse(sort_by(@, &"+i.field+"))":r+=" | sort_by(@, &"+i.field+")"),t&&("]"!==r[r.length-1]&&(r+=" | [*]"),1===t.fields.length?r+="."+t.fields[0]:1<t.fields.length&&(r+=".{"+t.fields.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")),r}function r(e,t){return i().search(e,t)}},4987:function(){function e(e){void 0===e||"remove"in e||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&(void 0!==window.Element&&e(window.Element.prototype),void 0!==window.CharacterData&&e(window.CharacterData.prototype),void 0!==window.DocumentType)&&e(window.DocumentType.prototype),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(e){for(var t=0;t<this.length;t++){var n=this[t];if(e.call(this,n,t,this))return t}return-1},configurable:!0,writable:!0}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){e=this.findIndex(e);return this[e]},configurable:!0,writable:!0}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(e,t,n){"use strict";n.r(t),n.d(t,{previewModeMixins:function(){return f}});var i=n(7304),s=n(4188),o=n(6436),r=n(2474);function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function l(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=a(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=a(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==a(e)?e:String(e)}(i.key),i)}}var c=function(){function i(e,t,n){if(!(this instanceof i))throw new TypeError("Cannot call a class as a function");this.onChange=e,this.calculateItemSize=t||function(){return 1},this.limit=n,this.items=[],this.index=-1}var e,t,n;return e=i,(t=[{key:"add",value:function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var t=this.calculateItemSize,n=0;return this.items.forEach(function(e){n+=t(e)}),n}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}])&&l(e.prototype,t),n&&l(e,n),Object.defineProperty(e,"prototype",{writable:!1}),i}(),h=n(7907),d=n(6056),u=n(6617),g=n(6210),p=n(2558),t=n(8458),m=n(9791),n=t.textModeMixins[0].mixin,t={create:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=(void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,t.createQuery=t.createQuery||d.r,t.executeQuery=t.executeQuery||d.J,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2,(0,h.cC)(this.options.languages),(0,h.m0)(this.options.language),this.mode="preview",this),e=(this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=(0,m.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(e){e.preventDefault()},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),e=(this.frameFocusTracker=new r.R(e),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.textContent="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar&&((0,m.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-format",e.title=(0,h.Iu)("formatTitle"),this.menu.appendChild(e),e.onclick=function(){n.executeWithBusyMessage(function(){try{n.format()}catch(e){n._onError(e)}},"formatting...")},(e=document.createElement("button")).type="button",e.className="jsoneditor-compact",e.title=(0,h.Iu)("compactTitle"),this.menu.appendChild(e),e.onclick=function(){n.executeWithBusyMessage(function(){try{n.compact()}catch(e){n._onError(e)}},"compacting...")},this.options.enableSort&&((e=document.createElement("button")).type="button",e.className="jsoneditor-sort",e.title=(0,h.Iu)("sortTitleShort"),e.onclick=function(){n._showSortModal()},this.menu.appendChild(e)),this.options.enableTransform&&((e=document.createElement("button")).type="button",e.title=(0,h.Iu)("transformTitleShort"),e.className="jsoneditor-transform",e.onclick=function(){n._showTransformModal()},this.dom.transform=e,this.menu.appendChild(e)),(e=document.createElement("button")).type="button",e.className="jsoneditor-repair",e.title=(0,h.Iu)("repairTitle"),this.menu.appendChild(e),!(e.onclick=function(){void 0===n.json&&n.executeWithBusyMessage(function(){try{n.repair()}catch(e){n._onError(e)}},"repairing...")})!==this.options.history&&(this.history=new c(function(){n.dom.undo.disabled=!n.history.canUndo(),n.dom.redo.disabled=!n.history.canRedo()},function(e){return 2*e.text.length},s.oW),(e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,h.Iu)("undo"),e.onclick=function(){var e=n.history.undo();e&&n._applyHistory(e)},this.menu.appendChild(e),this.dom.undo=e,(e=document.createElement("button")).type="button",e.className="jsoneditor-redo",e.title=(0,h.Iu)("redo"),e.onclick=function(){var e=n.history.redo();e&&n._applyHistory(e)},this.menu.appendChild(e),this.dom.redo=e,this.history.onChange()),this.options)&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new u.x(this.menu,this.options.modes,this.options.mode,function(e){try{n.setMode(e),n.modeSwitcher.focus()}catch(e){n._onError(e)}})),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):!0===this.options.showErrorTable);this.errorTable=new o.Q({errorTableVisible:e,onToggleVisibility:function(){n.validate()},onFocusLine:null,onChangeHeight:function(e){e=e+(n.dom.statusBar?n.dom.statusBar.clientHeight:0)+1;n.content.style.marginBottom=-e+"px",n.content.style.paddingBottom=e+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),t.statusBar&&((0,m.addClassName)(this.content,"has-status-bar"),e=document.createElement("div"),(this.dom.statusBar=e).className="jsoneditor-statusbar",this.frame.appendChild(e),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",e.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",e.appendChild(this.dom.arrayInfo),e.appendChild(this.errorTable.getErrorCounter()),e.appendChild(this.errorTable.getWarningIcon()),e.appendChild(this.errorTable.getErrorIcon())),this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var e=this.getText();this.dom.previewText.nodeValue=(0,m.limitCharacters)(e,s.WF),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,m.formatSize)(e.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},f=(t._showSortModal=function(){var r=this;this.executeWithBusyMessage(function(){var e=r.options.modalAnchor||s.qD,o=r.get();r._renderPreview(),(0,g.showSortModal)(e,o,function(i){r.executeWithBusyMessage(function(){var e,t,n;e=o,t=i,Array.isArray(e)&&(n=(0,m.sort)(e,t.path,t.direction),r.sortedBy=t,r._setAndFireOnChange(n)),(0,m.isObject)(e)&&(n=(0,m.sortObjectKeys)(e,t.direction),r.sortedBy=t,r._setAndFireOnChange(n))},"sorting...")},r.sortedBy)},"parsing...")},t._showTransformModal=function(){var r=this;this.executeWithBusyMessage(function(){var e=r.options,t=e.createQuery,n=e.executeQuery,i=e.modalAnchor,e=e.queryDescription,o=r.get();r._renderPreview(),(0,p.showTransformModal)({container:i||s.qD,json:o,queryDescription:e,createQuery:t,executeQuery:n,onTransform:function(t){r.executeWithBusyMessage(function(){var e=n(o,t);r._setAndFireOnChange(e)},"transforming...")}})},"parsing...")},t.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history&&(this.history.clear(),this.history=null),this.frameFocusTracker.destroy()},t.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setTextAndFireOnChange(t,e)},t.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setTextAndFireOnChange(t,e)},t.repair=function(){var e=this.getText();try{var t=(0,i.K)(e);this._setTextAndFireOnChange(t)}catch(e){}},t.focus=function(){this.dom.transform.focus()},t.set=function(e){this.history&&this.history.clear(),this._set(e)},t.update=function(e){this._set(e)},t._set=function(e){this.text=void 0,this.json=e,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},t._setAndFireOnChange=function(e){this._set(e),this._onChange()},t.get=function(){var e;return void 0===this.json&&(e=this.getText(),this.json=(0,m.parse)(e)),this.json},t.getText=function(){return void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode)&&(this.text=(0,m.escapeUnicodeChars)(this.text)),this.text},t.setText=function(e){this.history&&this.history.clear(),this._setText(e)},t.updateText=function(e){this.getText()!==e&&this._setText(e)},t._setText=function(e,t){var n;!0===this.options.escapeUnicode?this.text=(0,m.escapeUnicodeChars)(e):this.text=e,this.json=t,this._renderPreview(),void 0===this.json?(n=this).executeWithBusyMessage(function(){try{n.json=n.get(),n._renderPreview(),n._pushHistory()}catch(e){}},"parsing..."):this._pushHistory(),this._debouncedValidate()},t._setTextAndFireOnChange=function(e,t){this._setText(e,t),this._onChange()},t._applyHistory=function(e){this.json=e.json,this.text=e.text,this._renderPreview(),this._debouncedValidate()},t._pushHistory=function(){var e;this.history&&(e={text:this.text,json:this.json},this.history.add(e))},t.executeWithBusyMessage=function(e,t){var n;this.getText().length>s.EX?((0,m.addClassName)((n=this).frame,"busy"),n.dom.busyContent.innerText=t,setTimeout(function(){e(),(0,m.removeClassName)(n.frame,"busy"),n.dom.busyContent.innerText=""},100)):e()},t.validate=n.validate,t._renderErrors=n._renderErrors,[{mode:"preview",mixin:t,data:"json"}])},6210:function(e,t,n){"use strict";n.r(t),n.d(t,{showSortModal:function(){return s}});var t=n(483),i=n.n(t),o=n(7907),r=n(9791);function s(e,t,s,n){var a=Array.isArray(t)?(0,r.getChildPaths)(t):[""],l=n&&n.path&&(0,r.contains)(a,n.path)?n.path:a[0],c=n&&n.direction||"asc",t='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,o.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,o.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+(0,o.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,o.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,o.Iu)("sortAscending")+'" title="'+(0,o.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,o.Iu)("sortDescending")+'" title="'+(0,o.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,o.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';i()({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){var e=t.modalElem().querySelector("form"),n=t.modalElem().querySelector("#ok"),i=t.modalElem().querySelector("#field"),o=t.modalElem().querySelector("#direction");function r(e){o.value=e,o.className="jsoneditor-button-group jsoneditor-button-group-value-"+o.value}a.forEach(function(e){var t,n=document.createElement("option");n.text=""===(t=e)?"@":"."===t[0]?t.slice(1):t,n.value=e,i.appendChild(n)}),i.value=l||a[0],r(c||"asc"),o.onclick=function(e){r(e.target.getAttribute("data-value"))},n.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),s({path:i.value,direction:o.value})},e&&(e.onsubmit=n.onclick)}).afterClose(function(e){e.destroy()}).show()}},2558:function(e,t,n){"use strict";n.r(t),n.d(t,{showTransformModal:function(){return s}});var t=n(483),i=n.n(t),t=n(3879),x=n.n(t),o=n(7907);function I(e){return(I="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function k(e,t,n,i){if("boolean"==typeof e||e instanceof Boolean||null===e||"number"==typeof e||e instanceof Number||"string"==typeof e||e instanceof String||e instanceof Date)return JSON.stringify(e);if(Array.isArray(e)){for(var o=e,r=t,s=n,a=i,l=r?s+r:void 0,c=r?"[\n":"[",h=0;h<o.length;h++){var d=o[h];if(r&&(c+=l),c+=void 0!==d&&"function"!=typeof d?k(d,r,l,a):"null",h<o.length-1&&(c+=r?",\n":","),c.length>a)return c+"..."}return c+=r?"\n"+s+"]":"]"}if(e&&"object"===I(e)){var u,g=e,p=t,s=n,m=i,f=p?s+p:void 0,C=!0,y=p?"{\n":"{";if("function"==typeof g.toJSON)return k(g.toJSON(),p,s,m);for(u in g)if(function(e,t){return Object.prototype.hasOwnProperty.call(e,t)}(g,u)){var v=g[u];if(C?C=!1:y+=p?",\n":",",(y=(y+=p?f+'"'+u+'": ':'"'+u+'":')+k(v,p,f,m)).length>m)return y+"..."}return y+=p?"\n"+s+"}":"}"}}function E(e,t){for(var n="";0<t--;)n+=e;return n}var T=n(9791),R=n(4188),r='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';function s(e){var t=e.container,I=e.json,n=e.queryDescription,n=void 0===n?r:n,b=e.createQuery,A=e.executeQuery,w=e.onTransform,S=I,e='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,o.Iu)("transform")+"</div><p>"+n+'</p><div class="jsoneditor-jmespath-label">'+(0,o.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+(0,o.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+(0,o.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+(0,o.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,o.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+(0,o.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,o.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,o.Iu)("ok")+'" autofocus /></div></div>';i()({parent:t,content:e,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){var e=t.modalElem(),n=e.querySelector("#wizard"),r=e.querySelector("#ok"),o=e.querySelector("#filterField"),s=e.querySelector("#filterRelation"),a=e.querySelector("#filterValue"),l=e.querySelector("#sortField"),c=e.querySelector("#sortOrder"),h=e.querySelector("#selectFields"),d=e.querySelector("#query"),u=e.querySelector("#preview");Array.isArray(S)||(n.style.fontStyle="italic",n.textContent="(wizard not available for objects, only for arrays)");(0,T.getChildPaths)(I).forEach(function(e){var e=f(e),t=document.createElement("option"),t=(t.text=e,t.value=e,o.appendChild(t),document.createElement("option"));t.text=e,t.value=e,l.appendChild(t)});var n=(0,T.getChildPaths)(I,!0).filter(function(e){return""!==e}),n=(0<n.length?n.forEach(function(e){var e=f(e),t=document.createElement("option");t.text=e,t.value=e,h.appendChild(t)}):(n=e.querySelector("#selectFieldsPart"))&&(n.style.display="none"),new(x())(o,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."})),i=new(x())(s,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),g=new(x())(l,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),p=new(x())(c,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),m=new(x())(h,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function f(e){return""===e?"@":"."===e[0]?e.slice(1):e}n.on("selectr.change",v),i.on("selectr.change",v),a.oninput=v,g.on("selectr.change",v),p.on("selectr.change",v),m.on("selectr.change",v),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()};var C=(0,T.debounce)(function(){try{var e=A(S,d.value);u.className="jsoneditor-transform-preview",u.value=(t=e,n=2,i=R.WF,"number"==typeof n?10<n?o=E(" ",10):1<=n&&(o=E(" ",n)):"string"==typeof n&&""!==n&&(o=n),(n=k(t,o,"",i)).length>i?(t=n,("number"==typeof(o=i)?t.slice(0,o):t)+"..."):n),r.disabled=!1}catch(e){u.className="jsoneditor-transform-preview jsoneditor-error",u.value=e.toString(),r.disabled=!0}var t,n,i,o},300);function y(t,e){try{d.value=b(t,e),r.disabled=!1,C()}catch(e){t='Error: an error happened when executing "createQuery": '+(e.message||e.toString());d.value="",r.disabled=!0,u.className="jsoneditor-transform-preview jsoneditor-error",u.value=t}}function v(){var e={};if(o.value&&s.value&&a.value&&(e.filter={field:o.value,relation:s.value,value:a.value}),l.value&&c.value&&(e.sort={field:l.value,direction:c.value}),h.value){for(var t,n=[],i=0;i<h.options.length;i++)h.options[i].selected&&(t=h.options[i].value,n.push(t));e.projection={fields:n}}y(I,e)}d.oninput=C,r.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),w(d.value)},y(I,{}),setTimeout(function(){d.select(),d.focus(),d.selectionStart=3,d.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}},8458:function(e,t,n){"use strict";n.r(t),n.d(t,{textModeMixins:function(){return A}});var i=n(7304),t=n(8170),l=n.n(t),a=n(4188),c=n(6436),h=n(2474),d=n(7907),u=n(6056),g=n(6617),o=n(6210),p=n(2558),m=n(9125),f=n(7026),C=n(9791);function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function s(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=r(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=r(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==r(e)?e:String(e)}(i.key),i)}}var y=function(){function n(e,t){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");this.schema=e,this.schemaRefs=t||{},this.suggestions={},this.suggestionsRefs={},this._buildSuggestions()}var e,t,i;return e=n,(t=[{key:"_buildSuggestions",value:function(){for(var e in this._handleSchemaEntry("",this.schema,this.suggestions),this.schemaRefs)this.suggestionsRefs[e]={},this._handleSchemaEntry("",this.schemaRefs[e],this.suggestionsRefs[e])}},{key:"_handleRef",value:function(e,t,n){n[e]=n[e]||{},n[e].refs=n[e].refs||[],n[e].refs=(0,C.uniqueMergeArrays)(n[e].refs,[t])}},{key:"_handleSchemaEntry",value:function(e,t,n){if(t)if(t.$ref)this._handleRef(e,t.$ref,n);else{var i=this._checkOfConditon(t);if(i)this._handleOfCondition(e,t[i],n);else switch(t.type){case"object":this._handleObject(e,t,n);break;case"string":case"number":case"integer":this._handlePrimitive(e,t,n);break;case"boolean":this._handleBoolean(e,t,n);break;case"array":this._handleArray(e,t,n)}}else console.error("SchemaTextCompleter: schema node is missing for path",e)}},{key:"_handleObject",value:function(t,n,i){var e,o=this;(0,C.isObject)(n.properties)&&(e=Object.keys(n.properties),i[t]=i[t]||{},i[t].props=i[t].props||[],i[t].props=(0,C.uniqueMergeArrays)(i[t].props,e),e.forEach(function(e){(0,C.asyncExec)(function(){o._handleSchemaEntry("".concat(t,"/").concat(e),n.properties[e],i)})}))}},{key:"_handlePrimitive",value:function(e,t,n){n[e]=n[e]||{},(0,C.isArray)(t.examples)&&(n[e].examples=n[e].examples||[],n[e].examples=(0,C.uniqueMergeArrays)(n[e].examples,t.examples)),(0,C.isArray)(t.enum)&&(n[e].enum=n[e].enum||[],n[e].enum=(0,C.uniqueMergeArrays)(n[e].enum,t.enum))}},{key:"_handleBoolean",value:function(e,t,n){n[e]||(n[e]={bool:[!0,!1]})}},{key:"_handleArray",value:function(e,t,n){var i=this;t.items&&(0,C.asyncExec)(function(){i._handleSchemaEntry("".concat(e,"/\\d+"),t.items,n)})}},{key:"_handleOfCondition",value:function(t,e,n){var i=this;e&&e.length&&e.forEach(function(e){(0,C.asyncExec)(function(){i._handleSchemaEntry(t,e,n)})})}},{key:"_checkOfConditon",value:function(e){if(e)return e.oneOf?"oneOf":e.anyOf?"anyOf":e.allOf?"allOf":void 0}},{key:"getCompletions",value:function(e,t,i,n,s){var c=this;try{var o=f.parse(t.getValue()).pointers||{},r=function(i){function e(t){var e,n={props:"property",enum:"enum",bool:"boolean",examples:"examples"};i&&null!=(e=i[t])&&e.length&&(o=o.concat(i[t].map(function(e){return{caption:e+"",meta:"schema [".concat(n[t],"]"),score:r++,value:e+""}})))}var o=[],r=0;e("props"),e("enum"),e("bool"),e("examples"),o.length&&s(null,o)};Object.keys(o).forEach(function(n){(0,C.asyncExec)(function(){function l(n,e,i){var t,o=Object.keys(e).reduce(function(e,t){return new RegExp("^".concat(i).concat(t)).test(n)&&(!e||e.length<t.length)?t:e});if("string"==typeof o){if(null!=(t=e[o])&&null!=(t=t.refs)&&t.length){var r,s={};for(r in e[o].refs){var a=e[o].refs[r];c.suggestionsRefs[a]&&(null!=(a=l(n,c.suggestionsRefs[a],"".concat(i).concat(o)))&&a.enum&&(s.enum=(0,C.uniqueMergeArrays)(s.enum,a.enum)),null!=a&&a.examples&&(s.examples=(0,C.uniqueMergeArrays)(s.examples,a.examples)),null!=a&&a.bool&&(s.bool=(0,C.uniqueMergeArrays)(s.bool,a.bool)),null!=a)&&a.props&&(s.props=(0,C.uniqueMergeArrays)(s.props,a.props))}return s}if(new RegExp("^".concat(i).concat(o,"$")).test(n))return e[o]}}var e,t;(null==(t=o[n].key)?void 0:t.line)===i.row&&i.column>=o[n].key.column&&i.column<=o[n].keyEnd.column&&(e=n.slice(0,n.lastIndexOf("/"))),(e=(null==(t=o[n].value)?void 0:t.line)===i.row&&(null==(t=o[n].value)?void 0:t.line)===(null==(t=o[n].valueEnd)?void 0:t.line)&&i.column>=o[n].value.column&&i.column<=o[n].valueEnd.column?n:e)&&(t=l(e,c.suggestions,""),r(t))})})}catch(e){}}}])&&s(e.prototype,t),i&&s(e,i),Object.defineProperty(e,"prototype",{writable:!1}),n}();function v(e){return(v="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var t={},I="ace/theme/jsoneditor";function b(){try{
this.format()}catch(e){}}t.create=function(e){var t,n,i,o=this,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},s=(void 0===r.statusBar&&(r.statusBar=!0),r.mainMenuBar=!1!==r.mainMenuBar,r.enableSort=!1!==r.enableSort,r.enableTransform=!1!==r.enableTransform,r.createQuery=r.createQuery||u.r,r.executeQuery=r.executeQuery||u.J,r.showErrorTable=void 0!==r.showErrorTable?r.showErrorTable:["text","preview"],"number"==typeof(this.options=r).indentation?this.indentation=Number(r.indentation):this.indentation=2,(0,d.cC)(this.options.languages),(0,d.m0)(this.options.language),r.ace||l()),a=(this.mode="code"===r.mode?"code":"text","code"===this.mode&&void 0===s&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=r.theme||I,this.theme===I&&s&&(0,m.O)(),r.onTextSelectionChange&&this.onTextSelectionChange(r.onTextSelectionChange),this),e=(this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this.lastSchemaErrors=void 0,this._debouncedValidate=(0,C.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){a._onKeyDown(e)},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),e=(this.frameFocusTracker=new h.R(e),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar&&((0,C.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-format",e.title=(0,d.Iu)("formatTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.format(),a._onChange()}catch(e){a._onError(e)}},(e=document.createElement("button")).type="button",e.className="jsoneditor-compact",e.title=(0,d.Iu)("compactTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.compact(),a._onChange()}catch(e){a._onError(e)}},this.options.enableSort&&((e=document.createElement("button")).type="button",e.className="jsoneditor-sort",e.title=(0,d.Iu)("sortTitleShort"),e.onclick=function(){a._showSortModal()},this.menu.appendChild(e)),this.options.enableTransform&&((e=document.createElement("button")).type="button",e.title=(0,d.Iu)("transformTitleShort"),e.className="jsoneditor-transform",e.onclick=function(){a._showTransformModal()},this.menu.appendChild(e)),(e=document.createElement("button")).type="button",e.className="jsoneditor-repair",e.title=(0,d.Iu)("repairTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.repair(),a._onChange()}catch(e){a._onError(e)}},"code"===this.mode&&((e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,d.Iu)("undo"),e.onclick=function(){o.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(e),this.dom.undo=e,(e=document.createElement("button")).type="button",e.className="jsoneditor-redo",e.title=(0,d.Iu)("redo"),e.onclick=function(){o.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(e),this.dom.redo=e),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new g.x(this.menu,this.options.modes,this.options.mode,function(e){try{a.setMode(e),a.modeSwitcher.focus()}catch(e){a._onError(e)}})),"code"===this.mode)&&((t=document.createElement("a")).appendChild(document.createTextNode("powered by ace")),t.href="https://ace.c9.io/",t.target="_blank",t.className="jsoneditor-poweredBy",t.onclick=function(){window.open(t.href,t.target,"noreferrer")},this.menu.appendChild(t)),this.options.onEditable&&v("function"===this.options.onEditable)&&!this.options.onEditable({})),s=(this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"===this.mode?(this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom),i=(s=s.edit(this.editorDom)).getSession(),s.$blockScrolling=1/0,s.setTheme(this.theme),s.setOptions({readOnly:e}),s.setShowPrintMargin(!1),s.setFontSize("14px"),i.setMode("ace/mode/json"),i.setTabSize(this.indentation),i.setUseSoftTabs(!0),i.setUseWrapMode(!0),n=i.setAnnotations,i.setAnnotations=function(e){n.call(this,e&&e.length?e:a.annotations)},s.commands.bindKey("Ctrl-L",null),s.commands.bindKey("Command-L",null),s.commands.bindKey("Ctrl-\\",null),s.commands.bindKey("Command-\\",null),s.commands.bindKey("Ctrl-Shift-\\",null),s.commands.bindKey("Command-Shift-\\",null),(this.aceEditor=s).on("change",this._onChange.bind(this)),s.on("changeSelection",this._onSelect.bind(this))):((i=document.createElement("textarea")).className="jsoneditor-text",i.spellcheck=!1,this.content.appendChild(i),this.textarea=i,this.textarea.readOnly=e,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),i.onselect=this._onSelect.bind(this),i.onmousedown=this._onMouseDown.bind(this),i.onblur=this._onBlur.bind(this)),this._updateHistoryButtons(),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):!0===this.options.showErrorTable);this.errorTable=new c.Q({errorTableVisible:s,onToggleVisibility:function(){a._validateAndCatch()},onFocusLine:function(e){a.isFocused=!0,isNaN(e)||a.setTextSelection({row:e,column:1},{row:e,column:1e3})},onChangeHeight:function(e){e=e+(a.dom.statusBar?a.dom.statusBar.clientHeight:0)+1;a.content.style.marginBottom=-e+"px",a.content.style.paddingBottom=e+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),r.statusBar&&((0,C.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},e=document.createElement("div"),(this.dom.statusBar=e).className="jsoneditor-statusbar",this.frame.appendChild(e),(i=document.createElement("span")).className="jsoneditor-curserinfo-label",i.innerText="Ln:",(s=document.createElement("span")).className="jsoneditor-curserinfo-val",s.innerText="1",e.appendChild(i),e.appendChild(s),(r=document.createElement("span")).className="jsoneditor-curserinfo-label",r.innerText="Col:",(i=document.createElement("span")).className="jsoneditor-curserinfo-val",i.innerText="1",e.appendChild(r),e.appendChild(i),this.curserInfoElements.colVal=i,this.curserInfoElements.lnVal=s,(r=document.createElement("span")).className="jsoneditor-curserinfo-label",r.innerText="characters selected",r.style.display="none",(i=document.createElement("span")).className="jsoneditor-curserinfo-count",i.innerText="0",i.style.display="none",this.curserInfoElements.countLabel=r,this.curserInfoElements.countVal=i,e.appendChild(i),e.appendChild(r),e.appendChild(this.errorTable.getErrorCounter()),e.appendChild(this.errorTable.getWarningIcon()),e.appendChild(this.errorTable.getErrorIcon())),this.setSchema(this.options.schema,this.options.schemaRefs)},t._onSchemaChange=function(e,t){this.aceEditor&&(this.options.allowSchemaSuggestions&&e?(this.aceEditor.setOption("enableBasicAutocompletion",[new y(e,t)]),this.aceEditor.setOption("enableLiveAutocompletion",!0)):(this.aceEditor.setOption("enableBasicAutocompletion",void 0),this.aceEditor.setOption("enableLiveAutocompletion",!1)))},t._onChange=function(){var e=this;if(!this.onChangeDisabled){if(setTimeout(function(){e._updateHistoryButtons&&e._updateHistoryButtons()}),this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},t._updateHistoryButtons=function(){var e;this.aceEditor&&this.dom.undo&&this.dom.redo&&(e=this.aceEditor.getSession().getUndoManager())&&e.hasUndo&&e.hasRedo&&(this.dom.undo.disabled=!e.hasUndo(),this.dom.redo.disabled=!e.hasRedo())},t._showSortModal=function(){try{var n=this,e=this.options.modalAnchor||a.qD,i=this.get();(0,o.showSortModal)(e,i,function(e){var t;Array.isArray(i)&&(t=(0,C.sort)(i,e.path,e.direction),n.sortedBy=e,n.update(t)),(0,C.isObject)(i)&&(t=(0,C.sortObjectKeys)(i,e.direction),n.sortedBy=e,n.update(t))},n.sortedBy)}catch(e){this._onError(e)}},t._showTransformModal=function(){var t=this;try{var e=this.options,n=e.modalAnchor,i=e.createQuery,o=e.executeQuery,r=e.queryDescription,s=this.get();(0,p.showTransformModal)({container:n||a.qD,json:s,queryDescription:r,createQuery:i,executeQuery:o,onTransform:function(e){e=o(s,e);t.update(e)}})}catch(e){this._onError(e)}},t._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},t._onKeyDown=function(e){var t=!1;73===(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},t._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},t._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},t._updateCursorInfo=function(){var e,t,n,i,o,r=this;function s(){r.curserInfoElements.countVal.innerText!==o&&(r.curserInfoElements.countVal.innerText=o,r.curserInfoElements.countVal.style.display=o?"inline":"none",r.curserInfoElements.countLabel.style.display=o?"inline":"none"),r.curserInfoElements.lnVal.innerText=n,r.curserInfoElements.colVal.innerText=i}this.textarea?setTimeout(function(){var e=(0,C.getInputSelection)(r.textarea);e.startIndex!==e.endIndex&&(o=e.endIndex-e.startIndex),i=(o&&r.cursorInfo&&r.cursorInfo.line===e.end.row&&r.cursorInfo.column===e.end.column?(n=e.start.row,e.start):(n=e.end.row,e.end)).column,r.cursorInfo={line:n,column:i,count:o},r.options.statusBar&&s()},0):this.aceEditor&&this.curserInfoElements&&(e=this.aceEditor.getCursorPosition(),t=this.aceEditor.getSelectedText(),n=e.row+1,i=e.column+1,o=t.length,r.cursorInfo={line:n,column:i,count:o},this.options.statusBar)&&s()},t._emitSelectionChange=function(){var e;this._selectionChangedHandler&&(e=this.getTextSelection(),this._selectionChangedHandler(e.start,e.end,e.text))},t._refreshAnnotations=function(){var e,t=this.aceEditor&&this.aceEditor.getSession();t&&(e=t.getAnnotations().filter(function(e){return"error"===e.type}),t.setAnnotations(e))},t.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null,this.frameFocusTracker.destroy()},t.compact=function(){var e=this.get(),e=JSON.stringify(e);this.updateText(e)},t.format=function(){var e=this.get(),e=JSON.stringify(e,null,this.indentation);this.updateText(e)},t.repair=function(){var e=this.getText();try{var t=(0,i.K)(e);this.updateText(t)}catch(e){}},t.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},t.resize=function(){this.aceEditor&&this.aceEditor.resize(!1)},t.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},t.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},t.get=function(){var e=this.getText();return(0,C.parse)(e)},t.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},t._setText=function(e,t){var n,i=this,e=!0===this.options.escapeUnicode?(0,C.escapeUnicodeChars)(e):e;this.textarea&&(this.textarea.value=e),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(e,-1),this.onChangeDisabled=!1,t&&(n=this,setTimeout(function(){n.aceEditor&&n.aceEditor.session.getUndoManager().reset()})),setTimeout(function(){i._updateHistoryButtons&&i._updateHistoryButtons()})),this._debouncedValidate()},t.setText=function(e){this._setText(e,!0)},t.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},t.validate=function(){var t,n=this,i=[],o=[];try{var r=this.get(),s=(this.validateSchema&&!this.validateSchema(r)&&(i=this.validateSchema.errors.map(function(e){return e.type="validation",(0,C.improveSchemaError)(e)})),this.validationSequence=(this.validationSequence||0)+1,this),a=this.validationSequence;return function(e,t){if(!t)return Promise.resolve([]);try{var n=t(e);return((0,C.isPromise)(n)?n:Promise.resolve(n)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=(0,C.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:(0,C.stringifyPath)(e.path),message:e.message,type:"customValidation"}}):[]})}catch(e){return Promise.reject(e)}}(r,this.options.onValidate).then(function(e){return a===s.validationSequence&&(e=i.concat(o).concat(e),s._renderErrors(e),"function"==typeof n.options.onValidationError&&(0,C.isValidationErrorChanged)(e,n.lastSchemaErrors)&&n.options.onValidationError.call(n,e),n.lastSchemaErrors=e),n.lastSchemaErrors})}catch(e){return this.getText()&&((r=/\w*line\s*(\d+)\w*/g.exec(e.message))&&(t=+r[1]),o=[{type:"error",message:e.message.replace(/\n/g,"<br>"),line:t}]),this._renderErrors(o),"function"==typeof this.options.onValidationError&&(0,C.isValidationErrorChanged)(o,this.lastSchemaErrors)&&this.options.onValidationError.call(this,o),this.lastSchemaErrors=o,Promise.resolve(this.lastSchemaErrors)}},t._validateAndCatch=function(){this.validate().catch(function(e){console.error("Error running validation:",e)})},t._renderErrors=function(i){var e=this.getText(),t=[],e=(i.reduce(function(e,t){return"string"==typeof t.dataPath&&-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},t),(0,C.getPositionForPath)(e,t));this.aceEditor&&(this.annotations=e.map(function(t){var e=i.filter(function(e){return e.dataPath===t.path}),n=e.map(function(e){return e.message}).join("\n");return n?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+n,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(i,e),this.aceEditor&&this.aceEditor.resize(!1)},t.getTextSelection=function(){var e,t,n,i={};return this.textarea?(n=(0,C.getInputSelection)(this.textarea),this.cursorInfo&&this.cursorInfo.line===n.end.row&&this.cursorInfo.column===n.end.column?(i.start=n.end,i.end=n.start):i=n,{start:i.start,end:i.end,text:this.textarea.value.substring(n.startIndex,n.endIndex)}):this.aceEditor?(n=this.aceEditor.getSelection(),e=this.aceEditor.getSelectedText(),t=n.getRange(),(n=n.getSelectionLead()).row===t.end.row&&n.column===t.end.column?i=t:(i.start=t.end,i.end=t.start),{start:{row:i.start.row+1,column:i.start.column+1},end:{row:i.end.row+1,column:i.end.column+1},text:e}):void 0},t.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=(0,C.debounce)(e,this.DEBOUNCE_INTERVAL))},t.setTextSelection=function(e,t){var n,i,o;e&&t&&(this.textarea?(n=(0,C.getIndexForPosition)(this.textarea,e.row,e.column),o=(0,C.getIndexForPosition)(this.textarea,t.row,t.column),-1<n&&-1<o&&(this.textarea.setSelectionRange?(this.textarea.focus(),this.textarea.setSelectionRange(n,o)):this.textarea.createTextRange&&((i=this.textarea.createTextRange()).collapse(!0),i.moveEnd("character",o),i.moveStart("character",n),i.select()),o=(this.textarea.value.match(/\n/g)||[]).length+1,n=this.textarea.scrollHeight/o,i=e.row*n,this.textarea.scrollTop=i>this.textarea.clientHeight?i-this.textarea.clientHeight/2:0)):this.aceEditor&&(o={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}},this.aceEditor.selection.setRange(o),this.aceEditor.scrollToLine(e.row-1,!0)))};var A=[{mode:"text",mixin:t,data:"text",load:b},{mode:"code",mixin:t,data:"text",load:b}]},8038:function(W,e,t){"use strict";t.r(e),t.d(e,{treeModeMixins:function(){return D}});var w={start:function(e,t,n){return 0===t.indexOf(e)},contain:function(e,t,n){return-1<t.indexOf(e)}};var s=t(897),a=t(2474);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=o(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=o(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==o(e)?e:String(e)}(i.key),i)}}var S=function(){function e(){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");this.locked=!1}var t,n,i;return t=e,(n=[{key:"highlight",value:function(e){this.locked||(this.node!==e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){var e;this.locked||(e=this).node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}])&&r(t.prototype,n),i&&r(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}(),l=t(7907),i=t(6056),c=t(6617),e=t(233),h=t.n(e),d=t(2602),k=t(9791);var u=t(6210),g=t(2558),p=t(4188);function P(e){return function(e){if(Array.isArray(e))return f(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||m(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function H(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var i,o,r,s,a=[],l=!0,c=!1;try{if(r=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(i=r.call(n)).done)&&(a.push(i.value),a.length!==t);l=!0);}catch(e){c=!0,o=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw o}}return a}}(e,t)||m(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function x(e,t){var n,i,o,r,s="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(s)return i=!(n=!0),{s:function(){s=s.call(e)},n:function(){var e=s.next();return n=e.done,e},e:function(e){i=!0,o=e},f:function(){try{n||null==s.return||s.return()}finally{if(i)throw o}}};if(Array.isArray(e)||(s=m(e))||t&&e&&"number"==typeof e.length)return s&&(e=s),r=0,{s:t=function(){},n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function m(e,t){var n;if(e)return"string"==typeof e?f(e,t):"Map"===(n="Object"===(n=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?f(e,t):void 0}function f(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function E(e){return(E="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function C(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=E(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=E(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==E(e)?e:String(e)}(i.key),i)}}var T=function(){function x(e,t){if(!(this instanceof x))throw new TypeError("Cannot call a class as a function");this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=(0,k.debounce)(this._onChangeValue.bind(this),x.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=(0,k.debounce)(this._onChangeField.bind(this),x.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}var e,t,n;return e=x,(t=[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:G}},{key:"_updateEditability",value:function(){var e,t;this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,"tree"!==this.editor.options.mode&&"form"!==this.editor.options.mode||"function"!=typeof this.editor.options.onEditable||(e=this.getValue.bind(this),"boolean"==typeof(t=this.editor.options.onEditable({field:this.field,get value(){return e()},path:this.getPath()}))?(this.editable.field=t,this.editable.value=t):"object"===E(t)&&null!==t?("boolean"==typeof t.field&&(this.editable.field=t.field),"boolean"==typeof t.value&&(this.editable.value=t.value)):(console.error("Invalid return value for function onEditable.","Actual value:",t,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)))}},{key:"getPath",value:function(){for(var e=this,t=[];e;){var n=e.getName();void 0!==n&&t.unshift(n),e=e.parent}return t}},{key:"getInternalPath",value:function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(e){if(e){if(0===e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}}},{key:"findNodeByInternalPath",value:function(e){if(e){for(var t=this,n=0;n<e.length&&t;n++)var i=e[n],t=t.childs[i];return t}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(e){for(var n=(0,k.parsePath)(e),i=this;i&&0<n.length;)!function(){var t=n.shift();if("number"==typeof t){if("array"!==i.type)throw new Error("Cannot get child node at index "+t+": node is no array");i=i.childs[t]}else{if("object"!==i.type)throw new Error("Cannot get child node "+t+": node is no object");i=i.childs.filter(function(e){return e.field===t})[0]}}();return i}},{key:"findParents",value:function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e}},{key:"setError",value:function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var n=this,i=this.fieldError||this.valueError||this.error,e=this.dom.tdError;if(i&&this.dom&&this.dom.tr){(0,k.addClassName)(this.dom.tr,"jsoneditor-validation-error"),e||(e=document.createElement("td"),this.dom.tdError=e,this.dom.tdValue.parentNode.appendChild(e));var o=document.createElement("button"),t=(o.type="button",o.className="jsoneditor-button jsoneditor-schema-error",function(){n.dom.popupAnchor&&n.dom.popupAnchor.destroy()}),r=function(){delete n.dom.popupAnchor},s=function(e){var t=n.editor.frame,e=(n.dom.popupAnchor=(0,d.w)(o,n.editor.getPopupAnchor(),r,e),o.getBoundingClientRect()),t=120<t.getBoundingClientRect().width-e.x?"jsoneditor-above":"jsoneditor-left",e=document.createElement("div");e.className="jsoneditor-popover "+t,e.appendChild(document.createTextNode(i.message)),n.dom.popupAnchor.appendChild(e)},a=(o.onmouseover=function(){n.dom.popupAnchor||s(!0)},o.onfocus=function(){t(),s(!1)},o.onblur=function(){t()},this.errorChild);for(a&&(o.onclick=function(){a.findParents().forEach(function(e){e.expand(!1)}),a.scrollTo(function(){a.focus()})});e.firstChild;)e.removeChild(e.firstChild);e.appendChild(o)}else this.dom.tr&&(0,k.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),e&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){var e;return this.parent?-1!==(e=this.parent.childs.indexOf(this))?e:null:-1}},{key:"setParent",value:function(e){this.parent=e}},{key:"setField",value:function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t}},{key:"getField",value:function(){return void 0===this.field&&this._getDomField(),this.field}},{key:"setValue",value:function(e,t){var n,i,o,r,s,a,l=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),n=0;n<e.length;n++)void 0===(s=e[n])||s instanceof Function||(n<this.childs.length?((o=this.childs[n]).fieldEditable=!1,o.index=n,o.setValue(s)):(o=new x(this.editor,{value:s}),r=n<this.getMaxVisibleChilds(),this.appendChild(o,r,!1)));for(i=this.childs.length;i>=e.length;i--)this.removeChild(this.childs[i],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),i=this.childs.length-1;0<=i;i--)v(e,this.childs[i].field)||this.removeChild(this.childs[i],!1);for(var c in n=0,e)v(e,c)&&(void 0===(s=e[c])||s instanceof Function||((a=this.findChildByProperty(c))?(a.setField(c,!0),a.setValue(s)):(a=new x(this.editor,{field:c,value:s}),c=n<this.getMaxVisibleChilds(),this.appendChild(a,c,!1))),n++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(l)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(e){var t,n,i,o,r,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?((n=this.childs[o]).fieldEditable=!1,n.index=o,n.setInternalValue(t)):(n=new x(this.editor,{internalValue:t}),i=o<this.getMaxVisibleChilds(),this.appendChild(n,i,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?(delete(n=this.childs[o]).index,n.setField(t.field,!0),n.setInternalValue(t.value)):(n=new x(this.editor,{field:t.field,internalValue:t.value}),i=o<this.getMaxVisibleChilds(),this.appendChild(n,i,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){var e;this.dom&&this.dom.tr&&this.dom.tr.parentNode?(e=this._detachFromDom(),this.clearDom(),this._attachToDom(e)):this.clearDom()}},{key:"getValue",value:function(){var t,n;return"array"===this.type?(t=[],this.childs.forEach(function(e){t.push(e.getValue())}),t):"object"===this.type?(n={},this.childs.forEach(function(e){n[e.getField()]=e.getValue()}),n):(void 0===this.value&&this._getDomValue(),this.value)}},{key:"getInternalValue",value:function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e}},{key:"clone",value:function(){var t,n;return(t=new x(this.editor)).type=this.type,t.field=this.field,t.fieldInnerText=this.fieldInnerText,t.fieldEditable=this.fieldEditable,t.previousField=this.previousField,t.value=this.value,t.valueInnerText=this.valueInnerText,t.previousValue=this.previousValue,t.expanded=this.expanded,t.visibleChilds=this.visibleChilds,this.childs?(n=[],this.childs.forEach(function(e){e=e.clone();e.setParent(t),n.push(e)}),t.childs=n):t.childs=void 0,t}},{key:"expand",value:function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){var e=this.childs;if(e&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){for(var n=this.getAppendDom(),i=(n.parentNode||((o=e.nextSibling)?t.insertBefore(n,o):t.appendChild(n)),Math.min(this.childs.length,this.visibleChilds)),o=this._getNextTr(),r=0;r<i;r++){var s=this.childs[r];s.getDom().parentNode||t.insertBefore(s.getDom(),o),s.showChilds()}e=this.getShowMoreDom();o=this._getNextTr(),e.parentNode||t.insertBefore(e,o),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(e){var t=this.dom.tr,n=t?t.parentNode:void 0;n&&n.removeChild(t),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(e)}},{key:"hideChilds",value:function(e){var t;this.childs&&this.expanded&&((t=this.getAppendDom()).parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()}),(t=this.getShowMoreDom()).parentNode&&t.parentNode.removeChild(t),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds()))}},{key:"_updateCssClassName",value:function(){var e,t;this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree&&((0,k.removeAllClassNames)(this.dom.tree),e=this.getValue.bind(this),t=this.editor.options.onClassName({path:this.getPath(),field:this.field,get value(){return e()}})||"",(0,k.addClassName)(this.dom.tree,"jsoneditor-values "+t))}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent}},{key:"appendChild",value:function(e,t,n){var i,o;this._hasChilds()&&(e.setParent(this),e.fieldEditable="object"===this.type,"array"===this.type&&(e.index=this.childs.length),"object"===this.type&&void 0===e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t&&(t=e.getDom(),o=(i=this._getNextTr())?i.parentNode:void 0,i&&o&&o.insertBefore(t,i),e.showChilds(),this.visibleChilds++),!1!==n)&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}},{key:"moveBefore",value:function(e,t,n){var i,o,r;this._hasChilds()&&((i=this.dom.tr?this.dom.tr.parentNode:void 0)&&((o=document.createElement("tr")).style.height=i.clientHeight+"px",i.appendChild(o)),e.parent&&e.parent.removeChild(e),t instanceof _||!t?this.childs.length+1>this.visibleChilds?(r=this.childs[this.visibleChilds-1],this.insertBefore(e,r,n)):this.appendChild(e,!0,n):this.insertBefore(e,t,n),i)&&o&&i.removeChild(o)}},{key:"insertBefore",value:function(e,t,n){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&void 0===e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"===this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1===i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"===this.type,this.childs.splice(i,0,e)}var o;this.expanded&&(i=e.getDom(),o=(t=t.getDom())?t.parentNode:void 0,t&&o&&o.insertBefore(i,t),e.showChilds(),this.showChilds()),!1!==n&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(e,t){this._hasChilds()&&(t=this.childs.indexOf(t),(t=this.childs[t+1])?this.insertBefore(e,t):this.appendChild(e))}},{key:"search",value:function(t,n){Array.isArray(n)||(n=[]);var e=t?t.toLowerCase():void 0;return delete this.searchField,delete this.searchValue,void 0!==this.field&&n.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,n.push({node:this,elem:"field"})),this._updateDomField()),this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,n)}):void 0!==this.value&&n.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,n.push({node:this,elem:"value"})),this._updateDomValue()),n}},{key:"scrollTo",value:function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)}},{key:"expandPathToNode",value:function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}}},{key:"focus",value:function(e){if(x.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":(t.drag||t.menu).focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),(0,k.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),(0,k.selectContentEditable)(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),(0,k.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),(0,k.selectContentEditable)(t.value)):(this._hasChilds()?t.expand:t.menu).focus();break;default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),(0,k.selectContentEditable)(t.value)):t.field&&this.fieldEditable?(t.field.focus(),(0,k.selectContentEditable)(t.field)):(this._hasChilds()?t.expand:t.menu).focus()}}}},{key:"containsNode",value:function(e){if(this===e)return!0;var t=this.childs;if(t)for(var n=0,i=t.length;n<i;n++)if(t[n].containsNode(e))return!0;return!1}},{key:"removeChild",value:function(e,t){if(this.childs){var n=this.childs.indexOf(e);if(-1!==n)return n<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue,(e=this.childs.splice(n,1)[0]).parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),e}}},{key:"_remove",value:function(e){this.removeChild(e)}},{key:"changeType",value:function(e){var t,n=this.type;n!==e&&("string"!==e&&"auto"!==e||"string"!==n&&"auto"!==n?(t=this._detachFromDom(),this.clearDom(),"object"===(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0===e.field&&(e.field="")}),"string"!==n&&"auto"!==n||(this.expanded=!0)):"array"===e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!==n&&"auto"!==n||(this.expanded=!0)):this.expanded=!1,this._attachToDom(t)):this.type=e,"auto"!==e&&"string"!==e||(this.value="string"===e?String(this.value):(0,k.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0}))}},{key:"deepEqual",value:function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!==E(e)||!e)return!1;var n=Object.keys(e);if(this.childs.length!==n.length)return!1;for(t=0;t<n.length;t++){var i=this.childs[t];if(i.field!==n[t]||!i.deepEqual(e[i.field]))return!1}}else if(this.value!==e)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=(0,k.getInnerText)(this.dom.value),""===this.valueInnerText)&&""!==this.dom.value.innerHTML&&(this.dom.value.textContent=""),void 0!==this.valueInnerText)try{var e,t;(t="string"===this.type?this._unescapeHTML(this.valueInnerText):(e=this._unescapeHTML(this.valueInnerText),(0,k.parseString)(e)))!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(e){this._setValueError((0,l.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(e){this.valueError={message:e},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(e){this.fieldError={message:e},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var e,t=this.editor.getDomSelection(),n=(t.range&&(n=(0,k.textDiff)(String(this.value),String(this.previousValue)),t.range.startOffset=n.start,t.range.endOffset=n.end),this.editor.getDomSelection());n.range&&(e=(0,k.textDiff)(String(this.previousValue),String(this.value)),n.range.startOffset=e.start,n.range.endOffset=e.end),this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:t,newSelection:n}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var e=this.editor.getDomSelection(),t=this.previousField||"",n=(e.range&&(n=(0,k.textDiff)(this.field,t),e.range.startOffset=n.start,e.range.endOffset=n.end),this.editor.getDomSelection());n.range&&(t=(0,k.textDiff)(t,this.field),n.range.startOffset=t.start,n.range.endOffset=t.end),this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],n=this.value,i="auto"===this.type?(0,k.getType)(n):this.type,o="string"===i&&(0,k.isUrl)(n);if(t.push("jsoneditor-"+i),o&&t.push("jsoneditor-url"),""===String(this.value)&&"array"!==this.type&&"object"!==this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"===i||"object"===i?(t=this.childs?this.childs.length:0,e.title=this.type+" containing "+t+" items"):o&&this.editable.value?e.title=(0,l.Iu)("openUrl"):e.title="","boolean"===i&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value?(this.dom.select||(this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,(t=document.createElement("option")).value="",t.textContent="--",this.dom.select.appendChild(t),this._updateEnumOptions(),this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)),this.dom.select.value=-1!==this.enum.indexOf(this.value)?this.value:"",!this.schema||v(this.schema,"oneOf")||v(this.schema,"anyOf")||v(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")):this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML,this.dom.tdValue.appendChild(this.dom.value)),this.editor.options.colorPicker&&"string"==typeof n&&(0,k.isValidColor)(n)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,k.addClassName)(this.dom.value,"jsoneditor-color-value"),(this.editable.value?(0,k.removeClassName):(0,k.addClassName))(this.dom.color,"jsoneditor-color-readonly"),this.dom.color.style.backgroundColor=n):this._deleteDomColor(),this._showTimestampTag()){this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date));o=null;if(o="function"==typeof this.editor.options.timestampFormat?this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()}):o){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(o))}else this.dom.date.textContent=new Date(n).toISOString();this.dom.date.title=new Date(n).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,k.stripFormatting)(e),this._updateDomDefault()}}},{key:"_updateEnumOptions",value:function(){if(this.enum&&this.dom.select){this.dom.select.innerHTML="";for(var e=0;e<this.enum.length;e++){var t=document.createElement("option");t.value=this.enum[e],t.textContent=this.enum[e],this.dom.select.appendChild(t)}}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,(0,k.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var e,t=this.dom.field;t&&((e=(0,k.makeFieldTooltip)(this.schema,this.editor.options.language))&&(t.title=e),(""===String(this.field)&&this.parent&&"array"!==this.parent.type?(0,k.addClassName):(0,k.removeClassName))(t,"jsoneditor-empty"),(this.searchFieldActive?(0,k.addClassName):(0,k.removeClassName))(t,"jsoneditor-highlight-active"),(this.searchField?(0,k.addClassName):(0,k.removeClassName))(t,"jsoneditor-highlight"),(0,k.stripFormatting)(t))}},{key:"_getDomField",value:function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,k.getInnerText)(this.dom.field),""===this.fieldInnerText)&&""!==this.dom.field.innerHTML&&(this.dom.field.textContent=""),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),n=this.parent.getFieldNames(this);-1!==n.indexOf(t)?e?(t=(0,k.findUniqueName)(t,n))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError((0,l.Iu)("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError((0,l.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){var e;this.schema&&void 0!==this.schema.default&&!this._hasChilds()&&(e=this.dom.select||this.dom.value)&&(this.value===this.schema.default?(e.title=(0,l.Iu)("default"),(0,k.addClassName)(e,"jsoneditor-is-default"),k.removeClassName):(e.removeAttribute("title"),(0,k.removeClassName)(e,"jsoneditor-is-default"),k.addClassName))(e,"jsoneditor-is-not-default")}},{key:"_showTimestampTag",value:function(){var e,t;return"number"==typeof this.value&&("function"==typeof(e=this.editor.options.timestampTag)?"boolean"==typeof(t=e({field:this.field,value:this.value,path:this.getPath()}))?t:(0,k.isTimestamp)(this.field,this.value):!0===e&&(0,k.isTimestamp)(this.field,this.value))}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var e,t,n=this.dom;return n.tr||(this._updateEditability(),n.tr=document.createElement("tr"),"tree"===(n.tr.node=this).editor.options.mode&&(t=document.createElement("td"),this.editable.field&&this.parent&&((e=document.createElement("button")).type="button",(n.drag=e).className="jsoneditor-button jsoneditor-dragarea",e.title=(0,l.Iu)("drag"),t.appendChild(e)),n.tr.appendChild(t),e=document.createElement("td"),(t=document.createElement("button")).type="button",(n.menu=t).className="jsoneditor-button jsoneditor-contextmenu-button",t.title=(0,l.Iu)("actionsMenu"),e.appendChild(n.menu),n.tr.appendChild(e)),t=document.createElement("td"),n.tr.appendChild(t),n.tree=this._createDomTree(),t.appendChild(n.tree),this.updateDom({updateIndexes:!0})),n.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(e){for(var t=this.parent;t;){if(t===e)return!0;t=t.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(t){this.dom.tr&&((t?(0,k.addClassName):(0,k.removeClassName))(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs)&&this.childs.forEach(function(e){e.setHighlight(t)})}},{key:"setSelected",value:function(t,e){this.selected=t,this.dom.tr&&((t?(0,k.addClassName):(0,k.removeClassName))(this.dom.tr,"jsoneditor-selected"),(e?(0,k.addClassName):(0,k.removeClassName))(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs)&&this.childs.forEach(function(e){e.setSelected(t)})}},{key:"updateValue",value:function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(t){var e,n=this.dom.tree,n=(n&&(n.style.marginLeft=24*this.getLevel()+"px"),this.dom.field),n=(n&&(this.fieldEditable?(n.contentEditable=this.editable.field,n.spellcheck=!1,n.className="jsoneditor-field"):(n.contentEditable=!1,n.className="jsoneditor-readonly"),e=void 0!==this.index?this.index:void 0!==this.field?this.field:(e=this.editor.options.schema?x._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&e.title?e.title:this._hasChilds()?this.type:"",e=this._escapeHTML(e),document.activeElement!==n&&e!==this._unescapeHTML((0,k.getInnerText)(n))&&(n.innerHTML=e),this._updateSchema(),this._updateEnumOptions()),this.dom.value),n=(n&&("array"===this.type||"object"===this.type?this.updateNodeName():(e=this._escapeHTML(this.value),document.activeElement!==n&&e!==this._unescapeHTML((0,k.getInnerText)(n))&&(n.innerHTML=e))),this.dom.tr);n&&("array"===this.type||"object"===this.type?((0,k.addClassName)(n,"jsoneditor-expandable"),this.expanded?((0,k.addClassName)(n,"jsoneditor-expanded"),(0,k.removeClassName)(n,"jsoneditor-collapsed")):((0,k.addClassName)(n,"jsoneditor-collapsed"),(0,k.removeClassName)(n,"jsoneditor-expanded"))):((0,k.removeClassName)(n,"jsoneditor-expandable"),(0,k.removeClassName)(n,"jsoneditor-expanded"),(0,k.removeClassName)(n,"jsoneditor-collapsed"))),this._updateDomField(),this._updateDomValue(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom(),this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?x._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=x._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var e=this.dom.value,t=this.childs;e&&t&&("array"===this.type?t.forEach(function(e,t){e.index=t;e=e.dom.field;e&&(e.textContent=t)}):"object"===this.type&&t.forEach(function(e){void 0!==e.index&&(delete e.index,void 0===e.field)&&(e.field="")}))}},{key:"_createDomValue",value:function(){var e;return"array"===this.type?(e=document.createElement("div")).textContent="[...]":"object"===this.type?(e=document.createElement("div")).textContent="{...}":(!this.editable.value&&(0,k.isUrl)(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e}},{key:"_createDomExpandButton",value:function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=(0,l.Iu)("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e}},{key:"_createDomTree",value:function(){var e=this.dom,t=document.createElement("table"),n=document.createElement("tbody"),i=(t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(n),document.createElement("tr")),n=(n.appendChild(i),document.createElement("td")),n=(n.className="jsoneditor-tree",i.appendChild(n),e.expand=this._createDomExpandButton(),n.appendChild(e.expand),e.tdExpand=n,document.createElement("td")),n=(n.className="jsoneditor-tree",i.appendChild(n),e.field=this._createDomField(),n.appendChild(e.field),e.tdField=n,document.createElement("td")),n=(n.className="jsoneditor-tree",i.appendChild(n),"object"!==this.type&&"array"!==this.type&&(n.appendChild(document.createTextNode(":")),n.className="jsoneditor-separator"),e.tdSeparator=n,document.createElement("td"));return n.className="jsoneditor-tree",i.appendChild(n),e.value=this._createDomValue(),n.appendChild(e.value),e.tdValue=n,t}},{key:"onEvent",value:function(e){var t,n=e.type,i=e.target||e.srcElement,o=this.dom,r=this,s=this._hasChilds(),a=(i!==o.drag&&i!==o.menu||("mouseover"===n?this.editor.highlighter.highlight(this):"mouseout"===n&&this.editor.highlighter.unhighlight()),"click"===n&&i===o.menu&&((t=r.editor.highlighter).highlight(r),t.lock(),(0,k.addClassName)(o.menu,"jsoneditor-selected"),this.showContextMenu(o.menu,function(){(0,k.removeClassName)(o.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"click"===n&&i===o.expand&&s&&(d=e.ctrlKey,this._onExpand(d)),"click"!==n||e.target!==r.dom.tdColor&&e.target!==r.dom.color||!this.editable.value||this._showColorPicker(),"change"===n&&i===o.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault()),"change"===n&&i===o.select&&(this.dom.value.innerHTML=this._escapeHTML(o.select.value),this._getDomValue(),this._updateDomValue()),o.value);if(i===a)switch(n){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var l=this._escapeHTML(this.value);l!==this._unescapeHTML((0,k.getInnerText)(a))&&(a.innerHTML=l);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&(0,k.isUrl)(this.value)&&(e.preventDefault(),window.open(this.value,"_blank","noreferrer"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){r._getDomValue(),r._updateDomValue()},1)}var c=o.field;if(i===c)switch(n){case"blur":this._getDomField(!0),this._updateDomField();var h=this._escapeHTML(this.field);h!==this._unescapeHTML((0,k.getInnerText)(c))&&(c.innerHTML=h);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){r._getDomField(),r._updateDomField()},1)}var d=o.tree;d&&i===d.parentNode&&"click"===n&&!e.hasMoved&&((void 0!==e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<(0,k.getAbsoluteLeft)(o.tdSeparator))||s?c&&((0,k.setEndOfContentEditable)(c),c.focus()):a&&!this.enum&&((0,k.setEndOfContentEditable)(a),a.focus())),(i!==o.tdExpand||s)&&i!==o.tdField&&i!==o.tdSeparator||"click"!==n||e.hasMoved||c&&((0,k.setEndOfContentEditable)(c),c.focus()),"keydown"===n&&this.onKeyDown(e),"function"==typeof this.editor.options.onEvent&&this._onEvent(e)}},{key:"_onEvent",value:function(e){var t=e.target,n=t===this.dom.field,t=t===this.dom.value||t===this.dom.checkbox||t===this.dom.select;(n||t)&&(n={field:this.getField(),path:this.getPath()},t&&!this._hasChilds()&&(n.value=this.getValue()),this.editor.options.onEvent(n,e))}},{key:"onKeyDown",value:function(e){var t,n,i,o,r,s,a,l,c,h,d,u,g,p,m=e.which||e.keyCode,f=e.target||e.srcElement,C=e.ctrlKey,y=e.shiftKey,v=e.altKey,I=!1,b="tree"===this.editor.options.mode,A=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],w=A[0],S=A[A.length-1];13===m?f===this.dom.value?this.editable.value&&!e.ctrlKey||(0,k.isUrl)(this.value)&&(window.open(this.value,"_blank","noreferrer"),I=!0):f===this.dom.expand&&this._hasChilds()&&(g=e.ctrlKey,this._onExpand(g),f.focus(),I=!0):68===m?C&&b&&(x.onDuplicate(A),I=!0):69===m?C&&(this._onExpand(y),f.focus(),I=!0):77===m&&b?C&&(this.showContextMenu(f),I=!0):46===m&&b?C&&(x.onRemove(A),I=!0):45===m&&b?C&&!y?(this._onInsertBefore(),I=!0):C&&y&&(this._onInsertAfter(),I=!0):35===m?v&&((g=this._lastNode())&&g.focus(x.focusElement||this._getElementName(f)),I=!0):36===m?v&&((g=this._firstNode())&&g.focus(x.focusElement||this._getElementName(f)),I=!0):37===m?v&&!y?((g=this._previousElement(f))&&this.focus(this._getElementName(g)),I=!0):v&&y&&b&&(g=S.expanded?(g=S.getAppendDom())?g.nextSibling:void 0:S.getDom().nextSibling)&&(d=x.getNodeFromTarget(g),g=g.nextSibling,u=x.getNodeFromTarget(g),d)&&d instanceof _&&1!==S.parent.childs.length&&u&&u.parent&&(n=this.editor.getDomSelection(),i=(o=w.parent).childs[S.getIndex()+1]||o.append,r=w.getIndex(),s=u.getIndex(),a=o.getInternalPath(),l=u.parent.getInternalPath(),A.forEach(function(e){u.parent.moveBefore(e,u)}),this.focus(x.focusElement||this._getElementName(f)),this.editor._onAction("moveNodes",{count:A.length,fieldNames:A.map(R),oldParentPath:o.getInternalPath(),newParentPath:w.parent.getInternalPath(),oldIndex:i.getIndex(),newIndex:w.getIndex(),oldIndexRedo:r,newIndexRedo:s,oldParentPathRedo:a,newParentPathRedo:l,oldSelection:n,newSelection:this.editor.getDomSelection()})):38===m?v&&!y?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(x.focusElement||this._getElementName(f))),I=!0):!v&&C&&y&&b?((t=this._previousNode())&&((h=this.editor.multiselection).start=h.start||this,h.end=t,c=this.editor._findTopLevelNodes(h.start,h.end),this.editor.select(c),t.focus("field")),I=!0):v&&y&&b&&((t=w._previousNode())&&t.parent&&(n=this.editor.getDomSelection(),i=(o=w.parent).childs[S.getIndex()+1]||o.append,r=w.getIndex(),s=t.getIndex(),a=o.getInternalPath(),l=t.parent.getInternalPath(),A.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(x.focusElement||this._getElementName(f)),this.editor._onAction("moveNodes",{count:A.length,fieldNames:A.map(R),oldParentPath:o.getInternalPath(),newParentPath:w.parent.getInternalPath(),oldIndex:i.getIndex(),newIndex:w.getIndex(),oldIndexRedo:r,newIndexRedo:s,oldParentPathRedo:a,newParentPathRedo:l,oldSelection:n,newSelection:this.editor.getDomSelection()})),I=!0):39===m?v&&!y?((g=this._nextElement(f))&&this.focus(this._getElementName(g)),I=!0):v&&y&&b&&(g=w.getDom().previousSibling)&&(t=x.getNodeFromTarget(g))&&t.parent&&!t.isVisible()&&(n=this.editor.getDomSelection(),i=(o=w.parent).childs[S.getIndex()+1]||o.append,r=w.getIndex(),s=t.getIndex(),a=o.getInternalPath(),l=t.parent.getInternalPath(),A.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(x.focusElement||this._getElementName(f)),this.editor._onAction("moveNodes",{count:A.length,fieldNames:A.map(R),oldParentPath:o.getInternalPath(),newParentPath:w.parent.getInternalPath(),oldIndex:i.getIndex(),newIndex:w.getIndex(),oldIndexRedo:r,newIndexRedo:s,oldParentPathRedo:a,newParentPathRedo:l,oldSelection:n,newSelection:this.editor.getDomSelection()})):40===m&&(v&&!y?((d=this._nextNode())&&(this.editor.deselect(!0),d.focus(x.focusElement||this._getElementName(f))),I=!0):!v&&C&&y&&b?((d=this._nextNode())&&((h=this.editor.multiselection).start=h.start||this,h.end=d,c=this.editor._findTopLevelNodes(h.start,h.end),this.editor.select(c),d.focus("field")),I=!0):v&&y&&b&&((p=(d=(d=(d=S.expanded?S.append?S.append._nextNode():void 0:S._nextNode())&&!d.isVisible()?d.parent.showMore:d)&&d instanceof _?S:d)&&(d._nextNode()||d.parent.append))&&p.parent&&(n=this.editor.getDomSelection(),i=(o=w.parent).childs[S.getIndex()+1]||o.append,r=w.getIndex(),s=p.getIndex(),a=o.getInternalPath(),l=p.parent.getInternalPath(),A.forEach(function(e){p.parent.moveBefore(e,p)}),this.focus(x.focusElement||this._getElementName(f)),this.editor._onAction("moveNodes",{count:A.length,fieldNames:A.map(R),oldParentPath:o.getInternalPath(),newParentPath:w.parent.getInternalPath(),oldParentPathRedo:a,newParentPathRedo:l,oldIndexRedo:r,newIndexRedo:s,oldIndex:i.getIndex(),newIndex:w.getIndex(),oldSelection:n,newSelection:this.editor.getDomSelection()})),I=!0)),I&&(e.preventDefault(),e.stopPropagation())}},{key:"_onExpand",value:function(e){var t,n,i;e&&(i=(n=(t=this.dom.tr.parentNode).parentNode).scrollTop,n.removeChild(t)),this.expanded?this.collapse(e):this.expand(e),e&&(n.appendChild(t),n.scrollTop=i),"function"==typeof this.editor.options.onExpand&&this.editor.options.onExpand({path:this.getPath(),isExpand:this.expanded,recursive:e})}},{key:"_showColorPicker",value:function(){var t,e;"function"==typeof this.editor.options.onColorPicker&&this.dom.color&&((t=this)._deleteDomColor(),t.updateDom(),e=(0,d.w)(this.dom.color,this.editor.getPopupAnchor()),this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())}))}},{key:"getFieldNames",value:function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]}},{key:"_onInsertBefore",value:function(e,t,n){var i=this.editor.getDomSelection(),e=new x(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:n}),t=(e.expand(!0),this.getInternalPath()),n=(this.parent.insertBefore(e,this),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertBeforeNodes",{nodes:[e],paths:[e.getInternalPath()],beforePath:t,parentPath:this.parent.getInternalPath(),oldSelection:i,newSelection:n})}},{key:"_onInsertAfter",value:function(e,t,n){var i=this.editor.getDomSelection(),e=new x(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:n}),t=(e.expand(!0),this.parent.insertAfter(e,this),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertAfterNodes",{nodes:[e],paths:[e.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:i,newSelection:t})}},{key:"_onAppend",value:function(e,t,n){var i=this.editor.getDomSelection(),e=new x(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:n}),t=(e.expand(!0),this.parent.appendChild(e),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("appendNodes",{nodes:[e],paths:[e.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:i,newSelection:t})}},{key:"_onChangeType",value:function(e){var t,n,i=this.type;e!==i&&(t=this.editor.getDomSelection(),this.changeType(e),n=this.editor.getDomSelection(),this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:i,newType:e,oldSelection:t,newSelection:n}))}},{key:"sort",value:function(n,e){var t,i,o=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];"string"==typeof n&&(n=(0,k.parsePath)(n)),this._hasChilds()&&(this.hideChilds(),t=this.childs,this.childs=this.childs.concat(),i="desc"===e?-1:1,"object"===this.type?this.childs.sort(function(e,t){return i*h()(e.field,t.field)}):this.childs.sort(function(e,t){var e=e.getNestedChild(n),t=t.getNestedChild(n);return e?t?(e=e.value,t=t.value,"string"!=typeof e&&"string"!=typeof t?t<e?i:e<t?-i:0:i*h()(e,t)):-i:i}),this._updateDomIndexes(),this.showChilds(),!0===o)&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:t,newChilds:this.childs})}},{key:"update",value:function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var e=this.dom.tr?this.dom.tr.parentNode:void 0,t=this.expanded?this.getAppendDom():this.getDom(),t=t&&t.parentNode?t.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:e,nextTr:t}}},{key:"_attachToDom",value:function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),n=this.getValue(),i=this.editor.options.executeQuery(n,e),o=(this.setValue(i),this.getInternalValue());this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:o}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var e=this.editor.node.getInternalValue(),t=(this.editor._setRoot(this),this.editor.node.getInternalValue());this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:e,newValue:t})}catch(e){this.editor._onError(e)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(e){for(var t=0,n=this;n&&t<e.length;)n=n.findChildByProperty(e[t]),t++;return n}},{key:"findChildByProperty",value:function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new _(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new F(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append}},{
key:"_previousNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var n=t;n=n.previousSibling,e=x.getNodeFromTarget(n),n&&e&&e instanceof _&&!e.isVisible(););return e}},{key:"_nextNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var n=t;n=n.nextSibling,e=x.getNodeFromTarget(n),n&&e&&e instanceof _&&!e.isVisible(););return e}},{key:"_firstNode",value:function(){var e=null,t=this.getDom();return t&&t.parentNode&&(t=t.parentNode.firstChild,e=x.getNodeFromTarget(t)),e}},{key:"_lastNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var n=t.parentNode.lastChild,e=x.getNodeFromTarget(n);n&&e&&!e.isVisible();)n=n.previousSibling,e=x.getNodeFromTarget(n);return e}},{key:"_previousElement",value:function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}}},{key:"_nextElement",value:function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}}},{key:"_getElementName",value:function(t){var n=this;return Object.keys(this.dom).find(function(e){return n.dom[e]===t})}},{key:"_hasChilds",value:function(){return"array"===this.type||"object"===this.type}},{key:"addTemplates",value:function(t,n){var i=this,e=i.editor.options.templates;null!=e&&(e.length&&t.push({type:"separator"}),e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:(n?function(e,t){i._onAppend(e,t)}:function(e,t){i._onInsertBefore(e,t)}).bind(this,e.field,e.value)})}))}},{key:"showContextMenu",value:function(e,t){var n,i=this,o=[];this.editable.value&&o.push({text:(0,l.Iu)("type"),title:(0,l.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("autoType"),click:function(){i._onChangeType("auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("arrayType"),click:function(){i._onChangeType("array")}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object"+("object"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("objectType"),click:function(){i._onChangeType("object")}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:(0,l.Iu)("stringType"),click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&o.push({text:(0,l.Iu)("sort"),title:(0,l.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){i.showSortModal()}}),this.editor.options.enableTransform&&o.push({text:(0,l.Iu)("transform"),title:(0,l.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){i.showTransformModal()}}),this.parent)&&o.push({text:(0,l.Iu)("extract"),title:(0,l.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){i.extract()}}),this.parent&&this.parent._hasChilds()&&(o.length&&o.push({type:"separator"}),n=i.parent.childs,i===n[n.length-1]&&(n=[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,l.Iu)("autoType"),click:function(){i._onAppend("","","auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array",title:(0,l.Iu)("arrayType"),click:function(){i._onAppend("",[])}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object",title:(0,l.Iu)("objectType"),click:function(){i._onAppend("",{})}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string",title:(0,l.Iu)("stringType"),click:function(){i._onAppend("","","string")}}],i.addTemplates(n,!0),o.push({text:(0,l.Iu)("appendText"),title:(0,l.Iu)("appendTitle"),submenuTitle:(0,l.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:n})),n=[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,l.Iu)("autoType"),click:function(){i._onInsertBefore("","","auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array",title:(0,l.Iu)("arrayType"),click:function(){i._onInsertBefore("",[])}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object",title:(0,l.Iu)("objectType"),click:function(){i._onInsertBefore("",{})}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string",title:(0,l.Iu)("stringType"),click:function(){i._onInsertBefore("","","string")}}],i.addTemplates(n,!1),o.push({text:(0,l.Iu)("insert"),title:(0,l.Iu)("insertTitle"),submenuTitle:(0,l.Iu)("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:n}),this.editable.field)&&(o.push({text:(0,l.Iu)("duplicateText"),title:(0,l.Iu)("duplicateField"),className:"jsoneditor-duplicate",click:function(){x.onDuplicate(i)}}),o.push({text:(0,l.Iu)("removeText"),title:(0,l.Iu)("removeField"),className:"jsoneditor-remove",click:function(){x.onRemove(i)}})),this.editor.options.onCreateMenu&&(n=i.getPath(),o=this.editor.options.onCreateMenu(o,{type:"single",path:n,paths:[n]})),new s.x(o,{close:t}).show(e,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var n=this,e=this.editor.options.modalAnchor||p.qD,t=this.getValue();(0,u.showSortModal)(e,t,function(e){var t=e.path,t=(0,k.parsePath)(t);n.sortedBy=e,n.sort(t,e.direction)},n.sortedBy)}},{key:"showTransformModal",value:function(){var t=this,e=this.editor.options,n=e.modalAnchor,i=e.createQuery,o=e.executeQuery,e=e.queryDescription,r=this.getValue();(0,g.showTransformModal)({container:n||p.qD,json:r,queryDescription:e,createQuery:i,executeQuery:o,onTransform:function(e){t.transform(e)}})}},{key:"_getType",value:function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof(0,k.parseString)(e)?"string":"auto"}},{key:"_escapeHTML",value:function(e){return"string"!=typeof e?String(e):(e=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),e=(e=JSON.stringify(e)).substring(1,e.length-1),!0===this.editor.options.escapeUnicode?(0,k.escapeUnicodeChars)(e):e)}},{key:"_unescapeHTML",value:function(e){e='"'+this._escapeJSON(e)+'"';return(0,k.parse)(e).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(e){for(var t="",n=0;n<e.length;){var i=e.charAt(n);"\n"===i?t+="\\n":"\\"===i?(t+=i,n++,""!==(i=e.charAt(n))&&-1!=='"\\/bfnrtu'.indexOf(i)||(t+="\\"),t+=i):t+='"'===i?'\\"':i,n++}return t}},{key:"updateNodeName",value:function(){var e=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{var t=this.getValue.bind(this),n=this.editor.options.onNodeName({path:this.getPath(),size:e,type:this.type,get value(){return t()}})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.textContent="object"===this.type?"{"+(n||e)+"}":"["+(n||e)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(var e in this.childs)this.childs[e].recursivelyUpdateNodeName()}}])&&C(e.prototype,t),n&&C(e,n),Object.defineProperty(e,"prototype",{writable:!1}),x}(),G=(T.prototype.DEBOUNCE_INTERVAL=150,T.prototype.MAX_SEARCH_RESULTS=999,100);function y(e){return e.getInternalPath()}function R(e){return e.getField()}function v(e,t){return Object.prototype.hasOwnProperty.call(e,t)}T.focusElement=void 0,T.select=function(e){setTimeout(function(){(0,k.selectContentEditable)(e)},0)},T.onDragStart=function(t,e){if(!Array.isArray(t))return T.onDragStart([t],e);var n,i,o,r,s;0!==t.length&&(n=t[0],i=t[t.length-1],o=n.parent,s=T.getNodeFromTarget(e.target),r=n.editor,s=(0,k.getAbsoluteTop)(s.dom.tr)-(0,k.getAbsoluteTop)(n.dom.tr),r.mousemove||(r.mousemove=(0,k.addEventListener)(e.view,"mousemove",function(e){T.onDrag(t,e)})),r.mouseup||(r.mouseup=(0,k.addEventListener)(e.view,"mouseup",function(e){T.onDragEnd(t,e)})),r.highlighter.lock(),r.drag={oldCursor:document.body.style.cursor,oldSelection:r.getDomSelection(),oldPaths:t.map(y),oldParent:o,oldNextNode:o.childs[i.getIndex()+1]||o.append,oldParentPathRedo:o.getInternalPath(),oldIndexRedo:n.getIndex(),mouseX:e.pageX,offsetY:s,level:n.getLevel()},document.body.style.cursor="move",e.preventDefault())},T.onDrag=function(e,t){if(!Array.isArray(e))return T.onDrag([e],t);if(0!==e.length){var n,i,o,r,s,a=e[0].editor,l=t.pageY-a.drag.offsetY,c=t.pageX,h=!1,d=e[0],u=d.dom.tr,g=(0,k.getAbsoluteTop)(u),p=u.offsetHeight;if(l<g){for(y=u;y=y.previousSibling,v=T.getNodeFromTarget(y),o=y?(0,k.getAbsoluteTop)(y):0,y&&l<o;);(v=v&&!v.parent?void 0:v)||(y=(u=u.parentNode.firstChild)?u.nextSibling:void 0,(v=T.getNodeFromTarget(y))===d&&(v=void 0)),!(v=v&&v.isVisible()&&(o=(y=v.dom.tr)?(0,k.getAbsoluteTop)(y):0)+p<l?void 0:v)||!1!==a.options.limitDragging&&v.parent!==e[0].parent||(e.forEach(function(e){v.parent.moveBefore(e,v)}),h=!0)}else{var m=e[e.length-1];if(p=(u=m.expanded&&m.append?m.append.getDom():m.dom.tr)?u.nextSibling:void 0){for(r=(0,k.getAbsoluteTop)(p),n=p;i=T.getNodeFromTarget(n),n&&(s=n.nextSibling?(0,k.getAbsoluteTop)(n.nextSibling):0,s=n?s-r:0,i&&i.parent.childs.length===e.length&&i.parent.childs[e.length-1]===m&&(g+=27),n=n.nextSibling),n&&g+s<l;);if(i&&i.parent){for(var p=c-a.drag.mouseX,p=Math.round(p/24/2),f=a.drag.level+p,C=i.getLevel(),y=i.dom.tr&&i.dom.tr.previousSibling;C<f&&y;){var v=T.getNodeFromTarget(y),I=e.some(function(e){return e===v||v.isDescendantOf(e)});if(!I){if(!(v instanceof _))break;I=v.parent.childs;if(I.length===e.length&&I[e.length-1]===m)break;C=(i=T.getNodeFromTarget(y)).getLevel()}y=y.previousSibling}(i=i instanceof _&&!i.isVisible()&&i.parent.showMore.isVisible()?i._nextNode():i)&&(!1===a.options.limitDragging||i.parent===e[0].parent)&&i.dom.tr&&i.dom.tr!==u.nextSibling&&(e.forEach(function(e){i.parent.moveBefore(e,i)}),h=!0)}}}h&&(a.drag.mouseX=c,a.drag.level=d.getLevel()),a.startAutoScroll(l),t.preventDefault()}},T.onDragEnd=function(e,t){if(!Array.isArray(e))return T.onDrag([e],t);var n,i,o,r,s,a,l,c,h;0!==e.length&&(a=e[0],n=a.editor,a&&a.dom.menu&&a.dom.menu.focus(),i=n.drag.oldParent.getInternalPath(),o=a.parent.getInternalPath(),r=n.drag.oldParent===a.parent,s=n.drag.oldNextNode.getIndex(),a=a.getIndex(),l=n.drag.oldParentPathRedo,c=n.drag.oldIndexRedo,h=r&&c<a?a+e.length:a,r&&c===a||n._onAction("moveNodes",{count:e.length,fieldNames:e.map(R),oldParentPath:i,newParentPath:o,oldIndex:s,newIndex:a,oldIndexRedo:c,newIndexRedo:h,oldParentPathRedo:l,newParentPathRedo:null,oldSelection:n.drag.oldSelection,newSelection:n.getDomSelection()}),document.body.style.cursor=n.drag.oldCursor,n.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&n.highlighter.unhighlight()}),delete n.drag,n.mousemove&&((0,k.removeEventListener)(t.view,"mousemove",n.mousemove),delete n.mousemove),n.mouseup&&((0,k.removeEventListener)(t.view,"mouseup",n.mouseup),delete n.mouseup),n.stopAutoScroll(),t.preventDefault())},T._findEnum=function(e){if(e.enum)return e.enum;e=e.oneOf||e.anyOf||e.allOf;if(e){e=e.filter(function(e){return e.enum});if(0<e.length)return e[0].enum}return null},T._findSchema=function(e,t,n){for(var i=3<arguments.length&&void 0!==arguments[3]?arguments[3]:e,o=n.slice(1,n.length),r=n[0],s=[i],a=0,l=[i.oneOf,i.anyOf,i.allOf];a<l.length;a++){var c=l[a];Array.isArray(c)&&(s=s.concat(c))}var h,d=x(s);try{for(d.s();!(h=d.n()).done;){if("$ref"in(i=h.value)&&"string"==typeof i.$ref){var u,g=i.$ref;if(g in t)i=t[g];else{if(!g.startsWith("#/")){if(1===(null==(u=g.match(/#\//g))?void 0:u.length)){var p,m,f,C=H(g.split("#/"),2),y=C[0],v=C[1];if(y in t)return p=t[y],m={$ref:"#/".concat(v)},(f=[]).push(r),0<o.length&&f.push.apply(f,P(o)),T._findSchema(p,t,f,m)}throw Error("Unable to resolve reference ".concat(g))}var I,b=g.substring(2).split("/"),i=e,A=x(b);try{for(A.s();!(I=A.n()).done;){var w=I.value;if(!(w in i))throw Error("Unable to resolve reference ".concat(g));i=i[w]}}catch(e){A.e(e)}finally{A.f()}}}if(void 0===r)return i;if("string"==typeof r){if("object"===E(i.properties)&&null!==i.properties&&r in i.properties)return i=i.properties[r],T._findSchema(e,t,o,i);if("object"===E(i.patternProperties)&&null!==i.patternProperties)for(var S in i.patternProperties)if(r.match(S))return i=i.patternProperties[S],T._findSchema(e,t,o,i);if("object"===E(i.additionalProperties))return i=i.additionalProperties,T._findSchema(e,t,o,i)}else if("number"==typeof r&&"object"===E(i.items)&&null!==i.items)return i=i.items,T._findSchema(e,t,o,i)}}catch(e){d.e(e)}finally{d.f()}return null},T.onRemove=function(e){if(!Array.isArray(e))return T.onRemove([e]);var t,n,i,o,r,s;e&&0<e.length&&(t=(i=e[0]).parent,n=i.editor,i=i.getIndex(),n.highlighter.unhighlight(),o=n.getDomSelection(),T.blurNodes(e),r=n.getDomSelection(),s=e.map(y),e.forEach(function(e){e.parent._remove(e)}),n._onAction("removeNodes",{nodes:e,paths:s,parentPath:t.getInternalPath(),index:i,oldSelection:o,newSelection:r}))},T.onDuplicate=function(e){if(!Array.isArray(e))return T.onDuplicate([e]);var t,i,n,o,r,s,a;e&&0<e.length&&(t=e[e.length-1],i=t.parent,(n=t.editor).deselect(n.multiselection.nodes),o=n.getDomSelection(),r=t,s=e.map(function(e){var t,n=e.clone();return"object"===e.parent.type&&(t=e.parent.getFieldNames(),n.field=(0,k.findUniqueName)(e.field,t)),i.insertAfter(n,r),r=n}),1===e.length?"object"===s[0].parent.type?(s[0].dom.field.innerHTML=e[0]._escapeHTML(e[0].field),s[0].focus("field")):s[0].focus():n.select(s),a=n.getDomSelection(),n._onAction("duplicateNodes",{paths:e.map(y),clonePaths:s.map(y),afterPath:t.getInternalPath(),parentPath:i.getInternalPath(),oldSelection:o,newSelection:a}))},T.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},T.targetIsColorPicker=function(e){var t=T.getNodeFromTarget(e);if(t)for(var n=e&&e.parentNode;n;){if(n===t.dom.color)return!0;n=n.parentNode}return!1},T.blurNodes=function(e){var t,n;Array.isArray(e)?(t=(n=e[0]).parent,n=n.getIndex(),(t.childs[n+e.length]?t.childs[n+e.length]:t.childs[n-1]||t).focus()):T.blurNodes([e])};(n.prototype=new T).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr"),n=(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode&&(e.tdDrag=document.createElement("td"),i=document.createElement("td"),e.tdMenu=i,(n=document.createElement("button")).type="button",n.className="jsoneditor-button jsoneditor-contextmenu-button",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)),document.createElement("td")),i=document.createElement("div");return i.appendChild(document.createTextNode("("+(0,l.Iu)("empty")+")")),i.className="jsoneditor-readonly",n.appendChild(i),e.td=n,e.text=i,this.updateDom(),t},n.prototype.getPath=function(){return null},n.prototype.getIndex=function(){return null},n.prototype.updateDom=function(e){var t=this.dom,n=t.td,i=(n&&(n.style.paddingLeft=24*this.getLevel()+26+"px"),t.text),i=(i&&(i.firstChild.nodeValue="("+(0,l.Iu)("empty")+" "+this.parent.type+")"),t.tr);this.isVisible()?t.tr.firstChild||(t.tdDrag&&i.appendChild(t.tdDrag),t.tdMenu&&i.appendChild(t.tdMenu),i.appendChild(n)):t.tr.firstChild&&(t.tdDrag&&i.removeChild(t.tdDrag),t.tdMenu&&i.removeChild(t.tdMenu),i.removeChild(n))},n.prototype.isVisible=function(){return 0===this.parent.childs.length},n.prototype.showContextMenu=function(e,t){var n,i=this,o=[{text:(0,l.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,l.Iu)("autoType"),click:function(){i._onAppend("","","auto")}},{text:(0,l.Iu)("array"),className:"jsoneditor-type-array",title:(0,l.Iu)("arrayType"),click:function(){i._onAppend("",[])}},{text:(0,l.Iu)("object"),className:"jsoneditor-type-object",title:(0,l.Iu)("objectType"),click:function(){i._onAppend("",{})}},{text:(0,l.Iu)("string"),className:"jsoneditor-type-string",title:(0,l.Iu)("stringType"),click:function(){i._onAppend("","","string")}}],o=(i.addTemplates(o,!0),[{text:(0,l.Iu)("appendText"),title:(0,l.Iu)("appendTitleAuto"),submenuTitle:(0,l.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:o}]);this.editor.options.onCreateMenu&&(n=i.parent.getPath(),o=this.editor.options.onCreateMenu(o,{type:"append",path:n,paths:[n]})),new s.x(o,{close:t}).show(e,this.editor.getPopupAnchor())},n.prototype.onEvent=function(e){var t,n=e.type,i=e.target||e.srcElement,o=this.dom;i===o.menu&&("mouseover"===n?this.editor.highlighter.highlight(this.parent):"mouseout"===n&&this.editor.highlighter.unhighlight()),"click"===n&&i===o.menu&&((t=this.editor.highlighter).highlight(this.parent),t.lock(),(0,k.addClassName)(o.menu,"jsoneditor-selected"),this.showContextMenu(o.menu,function(){(0,k.removeClassName)(o.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"keydown"===n&&this.onKeyDown(e)};var _=n;function n(e){this.editor=e,this.dom={}}(I.prototype=new T).getDom=function(){var t,n,e,i,o,r;return this.dom.tr||(this._updateEditability(),this.dom.tr||(n=(t=this).parent,(o=document.createElement("a")).appendChild(document.createTextNode((0,l.Iu)("showMore"))),o.href="#",o.onclick=function(e){return n.visibleChilds=Math.floor(n.visibleChilds/n.getMaxVisibleChilds()+1)*n.getMaxVisibleChilds(),t.updateDom(),n.showChilds(),e.preventDefault(),!1},(r=document.createElement("a")).appendChild(document.createTextNode((0,l.Iu)("showAll"))),r.href="#",r.onclick=function(e){return n.visibleChilds=1/0,t.updateDom(),n.showChilds(),e.preventDefault(),!1},e=document.createElement("div"),i=document.createTextNode(this._getShowMoreText()),e.className="jsoneditor-show-more",e.appendChild(i),e.appendChild(o),e.appendChild(document.createTextNode(". ")),e.appendChild(r),e.appendChild(document.createTextNode(". ")),(o=document.createElement("td")).appendChild(e),r=document.createElement("tr"),"tree"===this.editor.options.mode&&(r.appendChild(document.createElement("td")),r.appendChild(document.createElement("td"))),r.appendChild(o),r.className="jsoneditor-show-more",this.dom.tr=r,this.dom.moreContents=e,this.dom.moreText=i),this.updateDom()),this.dom.tr},I.prototype.updateDom=function(e){var t;this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(t=this.parent._getNextTr())&&t.parentNode.insertBefore(this.dom.tr,t),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},I.prototype._getShowMoreText=function(){return(0,l.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},I.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},I.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)};var F=I;function I(e,t){this.editor=e,this.parent=t,this.dom={}}function b(e){return(b="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function A(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=b(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=b(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==b(e)?e:String(e)}(i.key),i)}}var O=function(){function e(t){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");function r(e){return t.node.findNodeByInternalPath(e)}this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){r(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){r(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){r(e.path).updateValue(e.oldValue)},redo:function(e){r(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){r(e.path).changeType(e.oldType)},redo:function(e){r(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),n=r(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,n)})}},insertAfterNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),n=r(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,n),n=e})}},removeNodes:{undo:function(e){var t=r(e.parentPath),n=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,n)})},redo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=r(e.parentPath);e.clonePaths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var i=r(e.parentPath),o=r(e.afterPath);e.paths.map(r).forEach(function(e){var t,n=e.clone();"object"===i.type&&(t=i.getFieldNames(),n.field=(0,k.findUniqueName)(e.field,t)),i.insertAfter(n,o),o=n})}},moveNodes:{undo:function(n){var i=r(n.oldParentPath),e=r(n.newParentPath),o=i.childs[n.oldIndex]||i.append;e.childs.slice(n.newIndex,n.newIndex+n.count).forEach(function(e,t){e.field=n.fieldNames[t],i.moveBefore(e,o)}),null===n.newParentPathRedo&&(n.newParentPathRedo=e.getInternalPath())},redo:function(n){var e=r(n.oldParentPathRedo),i=r(n.newParentPathRedo),o=i.childs[n.newIndexRedo]||i.append;e.childs.slice(n.oldIndexRedo,n.oldIndexRedo+n.count).forEach(function(e,t){e.field=n.fieldNames[t],i.moveBefore(e,o)})}},sort:{undo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){r(e.path).setInternalValue(e.oldValue)},redo:function(e){r(e.path).setInternalValue(e.newValue)}}}}var t,n,i;return t=e,(n=[{key:"onChange",value:function(){}},{key:"add",value:function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}])&&A(t.prototype,n),i&&A(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}();function $(e){return($="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function L(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=$(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=$(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==$(e)?e:String(e)}(i.key),i)}}var V=function(){function o(e,t){if(!(this instanceof o))throw new TypeError("Cannot call a class as a function");var n=this,e=(this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=t,document.createElement("div")),t=((this.dom.wrapper=e).className="jsoneditor-search",t.appendChild(e),document.createElement("div")),t=((this.dom.results=t).className="jsoneditor-results",e.appendChild(t),document.createElement("div")),e=((this.dom.input=t).className="jsoneditor-frame",t.title=(0,l.Iu)("searchTitle"),e.appendChild(t),document.createElement("button")),i=(e.type="button",e.className="jsoneditor-refresh",t.appendChild(e),document.createElement("input")),e=(i.type="text",(this.dom.search=i).oninput=function(e){n._onDelayedSearch(e)},i.onchange=function(e){n._onSearch()},i.onkeydown=function(e){n._onKeyDown(e)},i.onkeyup=function(e){n._onKeyUp(e)},e.onclick=function(e){i.select()},t.appendChild(i),document.createElement("button")),e=(e.type="button",e.title=(0,l.Iu)("searchNextResultTitle"),e.className="jsoneditor-next",e.onclick=function(){n.next()},t.appendChild(e),document.createElement("button"));e.type="button",e.title=(0,l.Iu)("searchPreviousResultTitle"),e.className="jsoneditor-previous",e.onclick=function(){n.previous()},t.appendChild(e)}var e,t,n;return e=o,(t=[{key:"next",value:function(e){var t;this.results&&((t=null!==this.resultIndex?this.resultIndex+1:0)>this.results.length-1&&(t=0),this._setActiveResult(t,e))}},{key:"previous",value:function(e){var t,n;this.results&&(t=this.results.length-1,n=null!==this.resultIndex?this.resultIndex-1:t,this._setActiveResult(n=n<0?t:n,e))}},{key:"_setActiveResult",value:function(e,t){var n,i,o;this.activeResult&&(n=this.activeResult.node,"field"===this.activeResult.elem?delete n.searchFieldActive:delete n.searchValueActive,n.updateDom()),this.results&&this.results[e]?(this.resultIndex=e,i=this.results[this.resultIndex].node,"field"===(o=this.results[this.resultIndex].elem)?i.searchFieldActive=!0:i.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],i.updateDom(),i.scrollTo(function(){t&&i.focus(o)})):(this.resultIndex=void 0,this.activeResult=void 0)}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)}},{key:"_onSearch",value:function(e){this._clearDelay();var t=this.dom.search.value,t=0<t.length?t:void 0;if(t!==this.lastText||e){this.lastText=t,this.results=this.editor.search(t);var e=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,n=0;if(this.activeResult)for(var i=0;i<this.results.length;i++)if(this.results[i].node===this.activeResult.node){n=i;break}this._setActiveResult(n,!1),void 0!==t?(t=this.results.length,this.dom.results.textContent=0===t?"no results":1===t?"1 result":e<t?e+"+ results":t+" results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(e){var t=e.which;27===t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13===t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())}},{key:"_onKeyUp",value:function(e){var t=e.keyCode;27!==t&&13!==t&&this._onDelayedSearch(e)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}])&&L(e.prototype,t),n&&L(e,n),Object.defineProperty(e,"prototype",{writable:!1}),o}();function N(e){return(N="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function M(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,function(e){e=function(e,t){if("object"!=N(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return("string"===t?String:Number)(e);n=n.call(e,t||"default");if("object"!=N(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}(e,"string");return"symbol"==N(e)?e:String(e)}(i.key),i)}}var Z=function(){function n(e,t){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,e.appendChild(this.path),this.reset())}var e,t,i;return e=n,(t=[{key:"reset",value:function(){this.path.textContent=(0,l.Iu)("selectNode")}},{key:"setPath",value:function(o){var r=this;this.path.textContent="",o&&o.length&&o.forEach(function(n,i){var e,t=document.createElement("span");t.className="jsoneditor-treepath-element",t.innerText=n.name,t.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(r,n),r.path.appendChild(t),n.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.textContent="►",e.onclick=function(){r.contentMenuClicked=!0;var t=[];n.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(o[i+1]+1&&o[i+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(r,n,e.name)})}),new s.x(t,{limitHeight:!0}).show(e,r.root,!0)},r.path.appendChild(e)),i===o.length-1&&(t=(e||t).getBoundingClientRect().right,r.path.offsetWidth<t&&(r.path.scrollLeft=t),r.path.scrollLeft)&&((t=document.createElement("span")).className="jsoneditor-treepath-show-all-btn",t.title="show all path",t.textContent="...",t.onclick=function(e){(r.contentMenuClicked=!1,k.addClassName)(r.path,"show-all"),r.path.style.width=r.path.parentNode.getBoundingClientRect().width-10+"px",r.path.onblur=function(){r.contentMenuClicked?(r.contentMenuClicked=!1,r.path.focus()):((0,k.removeClassName)(r.path,"show-all"),r.path.onblur=void 0,r.path.style.width="",r.setPath(e))}}.bind(r,o),r.path.insertBefore(t,r.path.firstChild))})}},{key:"onSectionSelected",value:function(e){"function"==typeof e&&(this.selectionCallback=e)}},{key:"onContextMenuItemSelected",value:function(e){"function"==typeof e&&(this.contextMenuCallback=e)}}])&&M(e.prototype,t),i&&M(e,i),Object.defineProperty(e,"prototype",{writable:!1}),n}(),e=t(8037),B=t.n(e),t={},D=(t.create=function(e,t){if(!e)throw new Error("No container element provided.");function r(e){var t,n;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(n=window.getSelection()).removeAllRanges(),n.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function s(e){return void 0===n&&((n=document.createElement("span")).style.visibility="hidden",n.style.position="fixed",n.style.outline="0",n.style.margin="0",n.style.padding="0",n.style.border="0",n.style.left="0",n.style.whiteSpace="pre",n.style.fontSize=o,n.style.fontFamily=u,n.style.fontWeight="normal",document.body.appendChild(n)),n.textContent=e,n.getBoundingClientRect().right}function a(){this.style.backgroundColor="#ddd"}function l(){this.style.backgroundColor=""}function c(){y.hide(),y.onmouseselection(this.__hint,y.rs)}var h,n,d,o,u,g,p,m,f,C,i,y,v,I,b,A;this.container=e,this.dom={},this.highlighter=new S,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.lastSchemaErrors=void 0,this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=((h=(h=t.autocomplete)||{}).filter=h.filter||"start",h.trigger=h.trigger||"keydown",h.confirmKeys=h.confirmKeys||[39,35,9],h.caseSensitive=h.caseSensitive||!1,u=o="",(g=document.createElement("div")).style.position="relative",g.style.outline="0",g.style.border="0",g.style.margin="0",g.style.padding="0",(p=document.createElement("div")).className="autocomplete dropdown",p.style.position="absolute",p.style.visibility="hidden",m=p,f=[],i=-1,I=y={rs:v={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:C=0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:g,show:function(e,t,n){var i=this;this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""===o&&(o=window.getComputedStyle(e).getPropertyValue("font-size")),""===u&&(u=window.getComputedStyle(e).getPropertyValue("font-family")),p.style.marginLeft="0",p.style.marginTop=e.getBoundingClientRect().height+"px",this.options=n.map(String),this.element!==e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){i.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",b),this.element.addEventListener("keydown",b,!1),this.element.removeEventListener("blur",A),this.element.addEventListener("blur",A,!1)),g.appendChild(this.elementHint),g.appendChild(p),e.parentElement.appendChild(g),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,I.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var e=(e=e.innerText).replace("\n",""),t=this.options.length,n=e.substring(this.startFrom);d=e.substring(0,this.startFrom);for(var i=0;i<t;i++){var o=this.options[i];if(!h.caseSensitive&&0===o.toLowerCase().indexOf(n.toLowerCase())||h.caseSensitive&&0===o.indexOf(n)){this.elementHint.innerText=d+n+o.substring(n.length),this.elementHint.realInnerText=d+o;break}}p.style.left=s(d)+"px",I.refresh(n,this.options),this.elementHint.style.width=s(this.elementHint.innerText)+10+"px","hidden"!==p.style.visibility&&(this.elementHint.style.width=s(this.elementHint.innerText)+p.clientWidth+"px")}},hide:function(){m.style.visibility="hidden"},refresh:function(i,e){m.style.visibility="hidden",C=0,m.textContent="";var t=window.innerHeight||document.documentElement.clientHeight,n=m.parentNode.getBoundingClientRect(),o=n.top-6,t=t-n.bottom-6,r=(f=[],"function"==typeof h.filter?h.filter:w[h.filter]),n=r?e.filter(function(e){return r(h.caseSensitive?i:i.toLowerCase(),h.caseSensitive?e:e.toLowerCase(),h)}):[];0===(f=n.map(function(e){var t=document.createElement("div"),n=(t.className="item",t.onmouseover=a,t.onmouseout=l,t.onmousedown=c,t.__hint=e,t.textContent="",t.appendChild(document.createTextNode(e.substring(0,i.length))),document.createElement("b"));return n.appendChild(document.createTextNode(e.substring(i.length))),t.appendChild(n),m.appendChild(t),t})).length||1===f.length&&(i.toLowerCase()===f[0].__hint.toLowerCase()&&!h.caseSensitive||i===f[0].__hint&&h.caseSensitive)||f.length<2||(y.highlight(0),3*t<o?(m.style.maxHeight=o+"px",m.style.top="",m.style.bottom="100%"):(m.style.top="100%",m.style.bottom="",m.style.maxHeight=t+"px"),m.style.visibility="visible")},highlight:function(e){-1!==i&&f[i]&&(f[i].className="item"),f[e].className="item hover",i=e},move:function(e){return"hidden"===m.style.visibility?"":(C+e!==-1&&C+e!==f.length&&(C+=e,y.highlight(C)),f[C].__hint)},onmouseselection:function(){}},b=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!==t&&34!==t)if(27===t)v.hideDropDown(),v.element.focus(),e.preventDefault(),e.stopPropagation();else{var n,i=(i=this.element.innerText).replace("\n","");if(0<=h.confirmKeys.indexOf(t))9===t&&0===this.elementHint.innerText.length&&v.onTab(),0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,v.hideDropDown(),r(this.element),9===t)&&(v.element.focus(),e.preventDefault(),e.stopPropagation());else if(13===t)if(0===this.elementHint.innerText.length)v.onEnter();else{var o="hidden"===p.style.visibility;if(I.hide(),o)return v.hideDropDown(),v.element.focus(),void v.onEnter();this.element.innerText=this.elementHint.realInnerText,v.hideDropDown(),r(this.element),e.preventDefault(),e.stopPropagation()}else 40===t?(o=i.substring(this.startFrom),""===(n=I.move(1))&&v.onArrowDown(),this.elementHint.innerText=d+o+n.substring(o.length),this.elementHint.realInnerText=d+n,e.preventDefault(),e.stopPropagation()):38===t&&(o=i.substring(this.startFrom),""===(n=I.move(-1))&&v.onArrowUp(),this.elementHint.innerText=d+o+n.substring(o.length),this.elementHint.realInnerText=d+n,e.preventDefault(),e.stopPropagation())}}.bind(v),A=function(e){v.hideDropDown()},I.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=d+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),r(t.element)},1)},v)),this.options.history&&"view"!==this.options.mode&&(this.history=new O(this)),this._createFrame(),this._createTable()},t.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.frameFocusTracker.destroy()},t._setOptions=function(t){var n=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,n){var i;B()?(i=e.getBoundingClientRect().top,i=(0,k.getWindow)(e).innerHeight-i<300&&300<i,new(B())({parent:e,color:t,popup:i?"top":"bottom",onDone:function(e){e=1===e.rgba[3]?e.hex.substr(0,7):e.hex;n(e)}}).show()):console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:i.r,executeQuery:i.J,onEvent:null,enableSort:!0,enableTransform:!0},t&&(Object.keys(t).forEach(function(e){n.options[e]=t[e]}),null==t.limitDragging)&&null!=t.schema&&(this.options.limitDragging=!0),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=(0,k.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),t.onSelectionChange&&this.onSelectionChange(t.onSelectionChange),(0,l.cC)(this.options.languages),(0,l.m0)(this.options.language)},t.set=function(e){e instanceof Function||void 0===e?this.clear():(this.content.removeChild(this.table),e={field:this.options.name,value:e},e=new T(this,e),this._setRoot(e),this._validateAndCatch(),this.node.expand(!1),this.content.appendChild(this.table)),this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},t.update=function(e){var t,n;this.node.deepEqual(e)||(t=this.getSelection(),this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this._validateAndCatch(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end&&(e=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path),e)&&n?this.setSelection(t.start,t.end):this.setSelection({},{}))},t.get=function(){if(this.node)return this.node.getValue()},t.getText=function(){return JSON.stringify(this.get())},t.setText=function(t){try{this.set((0,k.parse)(t))}catch(e){t=(0,k.tryJsonRepair)(t);this.set((0,k.parse)(t))}},t.updateText=function(t){try{this.update((0,k.parse)(t))}catch(e){t=(0,k.tryJsonRepair)(t);this.update((0,k.parse)(t))}},t.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},t.getName=function(){return this.options.name},t.focus=function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},t.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},t._setRoot=function(e){this.clear(),(this.node=e).setParent(null),e.setField(this.getName(),!1),delete e.index,this.tbody.appendChild(e.getDom())},t.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},t.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},t.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},t.expand=function(e){var t;e&&(t=this.node?this.node.findNodeByPath(e.path):null)&&(e.isExpand?t.expand(e.recursive):t.collapse(e.recursive))},t._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},t._onChange=function(){if(!this.onChangeDisabled){var e;if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath&&((e=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0)?this._updateTreePath(e.getNodePath()):this.treePath.reset()),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},t.validate=function(){var t=this,n=this.node;if(n){var e=n.getValue(),i=[];this.validateSchema&&!this.validateSchema(e)&&(i=this.validateSchema.errors.map(function(e){return(0,k.improveSchemaError)(e)}).map(function(e){return{node:n.findNode(e.dataPath),error:e,type:"validation"}}).filter(function(e){return null!=e.node}));try{this.validationSequence++;var o=this,r=this.validationSequence;return this._validateCustom(e).then(function(e){return r===o.validationSequence&&(e=[].concat(i,e||[]),o._renderValidationErrors(e),"function"==typeof t.options.onValidationError&&(0,k.isValidationErrorChanged)(e,t.lastSchemaErrors)&&t.options.onValidationError.call(t,e),t.lastSchemaErrors=e),t.lastSchemaErrors})}catch(e){return Promise.reject(e)}}},t._validateAndCatch=function(){this.validate().catch(function(e){console.error("Error running validation:",e)})},t._renderValidationErrors=function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?(0,l.Iu)("containsInvalidProperties"):(0,l.Iu)("containsInvalidItems")}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},t._validateCustom=function(e){try{var n,t;if(this.options.onValidate)return n=this.node,t=this.options.onValidate(e),((0,k.isPromise)(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=(0,k.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?n.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e,type:"customValidation"}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}catch(e){return Promise.reject(e)}return Promise.resolve(null)},t.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},t.startAutoScroll=function(e){var t=this,n=this.scrollableContent,i=(0,k.getAbsoluteTop)(n),o=n.clientHeight,r=i+o;e<i+24&&0<n.scrollTop?this.autoScrollStep=(i+24-e)/3:r-24<e&&o+n.scrollTop<n.scrollHeight?this.autoScrollStep=(r-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?n.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},t.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},t.setDomSelection=function(e){var t,n,i;e&&("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths?(t=this,n=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)}),this.select(n)):(i=(n=e.path?this.node.findNodeByInternalPath(e.path):null)&&e.domName?n.dom[e.domName]:null,e.range&&i?(e=Object.assign({},e.range,{container:i}),(0,k.setSelectionOffset)(e)):n&&n.focus()))},t.getDomSelection=function(){var t=T.getNodeFromTarget(this.focusTarget),n=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===n}):null,i=(0,k.getSelectionOffset)();return(i=(i=i&&"DIV"!==i.container.nodeName?null:i)&&i.container!==n?null:i)&&delete i.container,{path:t?t.getInternalPath():null,domName:e,range:i,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},t.scrollTo=function(e,n){var i,t,o,r,s=this.scrollableContent;s?((i=this).animateTimeout&&(clearTimeout(i.animateTimeout),delete i.animateTimeout),i.animateCallback&&(i.animateCallback(!1),delete i.animateCallback),t=s.clientHeight,o=s.scrollHeight-t,r=Math.min(Math.max(e-t/4,0),o),function e(){var t=s.scrollTop,t=r-t;3<Math.abs(t)?(s.scrollTop+=t/3,i.animateCallback=n,i.animateTimeout=setTimeout(e,50)):(n&&n(!0),s.scrollTop=r,delete i.animateTimeout,delete i.animateCallback)}()):n&&n(!1)},t._createFrame=function(){var e=this,t=(this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer",this);function n(e){t._onEvent&&t._onEvent(e)}var i,o,r,s={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new a.R(s),this.frame.onclick=function(e){var t=e.target;n(e),"BUTTON"===t.nodeName&&e.preventDefault()},this.frame.oninput=n,this.frame.onchange=n,this.frame.onkeydown=n,this.frame.onkeyup=n,this.frame.oncut=n,this.frame.onpaste=n,this.frame.onmousedown=n,this.frame.onmouseup=n,this.frame.onmouseover=n,this.frame.onmouseout=n,(0,k.addEventListener)(this.frame,"focus",n,!0),(0,k.addEventListener)(this.frame,"blur",n,!0),this.frame.onfocusin=n,this.frame.onfocusout=n,this.options.mainMenuBar&&((0,k.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(s=document.createElement("button")).type="button",s.className="jsoneditor-expand-all",s.title=(0,l.Iu)("expandAll"),s.onclick=function(){t.expandAll(),"function"==typeof e.options.onExpand&&e.options.onExpand({path:[],isExpand:!0,recursive:!0})},this.menu.appendChild(s),(s=document.createElement("button")).type="button",s.title=(0,l.Iu)("collapseAll"),s.className="jsoneditor-collapse-all",s.onclick=function(){t.collapseAll(),"function"==typeof e.options.onExpand&&e.options.onExpand({path:[],isExpand:!1,recursive:!0})},this.menu.appendChild(s),this.options.enableSort&&((s=document.createElement("button")).type="button",s.className="jsoneditor-sort",s.title=(0,l.Iu)("sortTitleShort"),s.onclick=function(){t.node.showSortModal()},this.menu.appendChild(s)),this.options.enableTransform&&((s=document.createElement("button")).type="button",s.title=(0,l.Iu)("transformTitleShort"),s.className="jsoneditor-transform",s.onclick=function(){t.node.showTransformModal()},this.menu.appendChild(s)),this.history&&((i=document.createElement("button")).type="button",i.className="jsoneditor-undo jsoneditor-separator",i.title=(0,l.Iu)("undo"),i.onclick=function(){t._onUndo()},this.menu.appendChild(i),this.dom.undo=i,(o=document.createElement("button")).type="button",o.className="jsoneditor-redo",o.title=(0,l.Iu)("redo"),o.onclick=function(){t._onRedo()},this.menu.appendChild(o),this.dom.redo=o,this.history.onChange=function(){i.disabled=!t.history.canUndo(),o.disabled=!t.history.canRedo()},this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&((r=this).modeSwitcher=new c.x(this.menu,this.options.modes,this.options.mode,function(e){try{r.setMode(e),r.modeSwitcher.focus()}catch(e){r._onError(e)}})),this.options.search)&&(this.searchBox=new V(this,this.menu)),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new Z(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},t._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},t._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},t._onEvent=function(e){if(!T.targetIsColorPicker(e.target)){var t,n=T.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),n&&"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete)&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),n&&this.options&&this.options.navigationBar&&n&&("keydown"===e.type||"mousedown"===e.type)&&(t=this,setTimeout(function(){t._updateTreePath(n.getNodePath())})),n&&n.selected){if("click"===e.type){if(e.target===n.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&T.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&(0,k.hasParentNode)(e.target,this.content)&&(this.deselect(),n&&e.target===n.dom.drag?T.onDragStart(n,e):n&&(e.target===n.dom.field||e.target===n.dom.value||e.target===n.dom.select)||this._onMultiSelectStart(e));n&&n.onEvent(e)}},t._updateTreePath=function(e){var n;function i(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.field||e.type}e&&e.length?((0,k.removeClassName)(this.navBar,"nav-bar-empty"),n=[],e.forEach(function(e){var t={name:i(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:i(e),node:e})}),n.push(t)}),this.treePath.setPath(n)):(0,k.addClassName)(this.navBar,"nav-bar-empty")},t._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},t._onTreePathMenuItemSelected=function(e,t){e&&e.children.length&&(e=e.children.find(function(e){return e.name===t}))&&e.node&&(this._updateTreePath(e.node.getNodePath()),e.node.expandTo(),e.node.focus())},t._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},t._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,n=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+n*n),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},t._onMultiSelectStart=function(e){var t,n=T.getNodeFromTarget(e.target);"tree"===this.options.mode&&void 0===this.options.onEditable&&(this.multiselection={start:n||null,end:null,nodes:[]},this._startDragDistance(e),(t=this).mousemove||(this.mousemove=(0,k.addEventListener)(e.view,"mousemove",function(e){t._onMultiSelect(e)})),this.mouseup||(this.mouseup=(0,k.addEventListener)(e.view,"mouseup",function(e){t._onMultiSelectEnd(e)})),e.preventDefault())},t._onMultiSelect=function(e){var t;e.preventDefault(),this._updateDragDistance(e),e.hasMoved&&((e=T.getNodeFromTarget(e.target))&&(null==this.multiselection.start&&(this.multiselection.start=e),this.multiselection.end=e),this.deselect(),e=this.multiselection.start,t=this.multiselection.end||this.multiselection.start,e)&&t&&(this.multiselection.nodes=this._findTopLevelNodes(e,t),this.multiselection.nodes&&this.multiselection.nodes.length&&(e=this.multiselection.nodes[0],this.multiselection.start===e||this.multiselection.start.isDescendantOf(e)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes))},t._onMultiSelectEnd=function(e){var t=this.multiselection.nodes[0];t&&t.dom.menu&&t.dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&((0,k.removeEventListener)(e.view,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&((0,k.removeEventListener)(e.view,"mouseup",this.mouseup),delete this.mouseup)},t.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},t.select=function(e){if(!Array.isArray(e))return this.select([e]);var t;e&&(this.deselect(),this.multiselection.nodes=e.slice(0),t=e[0],e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler)&&(e=this.getSelection(),this._selectionChangedHandler(e.start,e.end))},t._findTopLevelNodes=function(e,t){for(var n=e.getNodePath(),i=t.getNodePath(),o=0;o<n.length&&n[o]===i[o];)o++;var r,e=n[o-1],t=n[o],s=i[o];return t&&s||(e.parent?e=(s=t=e).parent:(t=e.childs[0],s=e.childs[e.childs.length-1])),e&&t&&s?(t=e.childs.indexOf(t),s=e.childs.indexOf(s),r=Math.min(t,s),t=Math.max(t,s),e.childs.slice(r,t+1)):[]},t._showAutoComplete=function(t){var n,i=T.getNodeFromTarget(t),o="";0<=t.className.indexOf("jsoneditor-value")&&(o="value"),""!==(o=0<=t.className.indexOf("jsoneditor-field")?"field":o)&&(n=this,setTimeout(function(){var e;!i||!("focus"===n.options.autocomplete.trigger||0<t.innerText.length)||null===(e=n.options.autocomplete.getOptions(t.innerText,i.getPath(),o,i.editor))?n.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?n.autocomplete.hideDropDown():e.options?n.autocomplete.show(t,e.startFrom,e.options):n.autocomplete.show(t,0,e)}).catch(function(e){console.error(e)}):e.options?n.autocomplete.show(t,e.startFrom,e.options):n.autocomplete.show(t,0,e)},50))},t._onKeyDown=function(e){var t,n=e.which||e.keyCode,i=e.altKey,o=e.ctrlKey,r=e.metaKey,s=e.shiftKey,a=!1,l=this.focusTarget;9===n&&(t=this,setTimeout(function(){t.focusTarget!==l&&(0,k.selectContentEditable)(t.focusTarget)},0)),this.searchBox&&(o&&70===n?(this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),a=!0):(114===n||o&&71===n)&&(s?this.searchBox.previous(!0):this.searchBox.next(!0),a=!0)),this.history&&(o&&!s&&90===n?(this._onUndo(),a=!0):o&&s&&90===n&&(this._onRedo(),a=!0)),!this.options.autocomplete||a||o||i||r||1!==e.key.length&&8!==n&&46!==n||(a=!1,this._showAutoComplete(e.target)),a&&(e.preventDefault(),e.stopPropagation())},t._createTable=function(){var e;this.options.navigationBar&&(0,k.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},t.showContextMenu=function(e,t){var n,i=[],o=this.multiselection.nodes.slice();i.push({text:(0,l.Iu)("duplicateText"),title:(0,l.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){T.onDuplicate(o)}}),i.push({text:(0,l.Iu)("remove"),title:(0,l.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){T.onRemove(o)}}),this.options.onCreateMenu&&(n=o.map(function(e){return e.getPath()}),i=this.options.onCreateMenu(i,{type:"multiple",path:n[0],paths:n})),new s.x(i,{close:t}).show(e,this.getPopupAnchor())},t.getPopupAnchor=function(){return this.options.popupAnchor||this.frame},t.getSelection=function(){var e,t,n={start:null,end:null};return this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length&&(e=this.multiselection.nodes[0],t=this.multiselection.nodes[this.multiselection.nodes.length-1],"down"===this.multiselection.direction?(n.start=e.serialize(),n.end=t.serialize()):(n.start=t.serialize(),n.end=e.serialize())),n},t.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=(0,k.debounce)(e,this.DEBOUNCE_INTERVAL))},t.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));e=this._getNodeInstancesByRange(e,t);e.forEach(function(e){e.expandTo()}),this.select(e)},t._getNodeInstancesByRange=function(e,t){e&&e.path&&(n=this.node.findNodeByPath(e.path),t)&&t.path&&(i=this.node.findNodeByPath(t.path));var n,i,o=[];if(n instanceof T)if(i instanceof T&&i!==n)if(n.parent===i.parent){t=n.getIndex()<i.getIndex()?(e=n,i):(e=i,n);var r=e;for(o.push(r);r=r.nextSibling(),o.push(r),r&&r!==t;);}else o=this._findTopLevelNodes(n,i);else o.push(n);return o},t.getNodesByRange=function(e,t){var e=this._getNodeInstancesByRange(e,t),n=[];return e.forEach(function(e){n.push(e.serialize())}),n},[{mode:"tree",mixin:t,data:"json"},{mode:"view",mixin:t,data:"json"},{mode:"form",mixin:t,data:"json"}])},2744:function(e,t,n){t.tryRequireAjv=function(){try{return n(8903)}catch(e){}}},9125:function(e,t,n){t.O=function(){try{n(4864)}catch(e){console.error(e)}}},9791:function(W,e,t){"use strict";t.r(e),t.d(e,{addClassName:function(){return G},addEventListener:function(){return X},asyncExec:function(){return Ie},clear:function(){return C},compileJSONPointer:function(){return $},contains:function(){return Ce},debounce:function(){return ne},escapeUnicodeChars:function(){return p},extend:function(){return f},findUniqueName:function(){return ce},formatSize:function(){return me},get:function(){return N},getAbsoluteLeft:function(){return P},getAbsoluteTop:function(){return H},getChildPaths:function(){return he},getColorCSS:function(){return L},getIndexForPosition:function(){return re},getInnerText:function(){return k},getInputSelection:function(){return oe},getInternetExplorerVersion:function(){return z},getPositionForPath:function(){return se},getSelection:function(){return S},getSelectionOffset:function(){return D},getType:function(){return y},getWindow:function(){return A},hasParentNode:function(){return K},improveSchemaError:function(){return Q},insideRect:function(){return te},isArray:function(){return b},isChildOf:function(){return J},isFirefox:function(){return R},isObject:function(){return M},isPromise:function(){return q},isTimestamp:function(){return pe},isUrl:function(){return I},isValidColor:function(){return ae},isValidValidationError:function(){return ee},isValidationErrorChanged:function(){return ye},limitCharacters:function(){return fe},makeFieldTooltip:function(){return le},parse:function(){return u},parsePath:function(){return _},parseString:function(){return ge},removeAllClassNames:function(){return F},removeClassName:function(){return O},removeEventListener:function(){return Y},removeReturnsAndSurroundingWhitespace:function(){return E},selectContentEditable:function(){return Z},setEndOfContentEditable:function(){return V},setSelection:function(){return x},setSelectionOffset:function(){return j},sort:function(){return de},sortObjectKeys:function(){return ue},stringifyPath:function(){return U},stripFormatting:function(){return w},textDiff:function(){return ie},tryJsonRepair:function(){return g},uniqueMergeArrays:function(){return ve},validate:function(){return m}});t(4987);var e=t(233),o=t.n(e),n=t(7304),i=t(6589),r=t(7026),s=t(7907);function a(e){return function(e){if(Array.isArray(e))return l(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){var n;if(e)return"string"==typeof e?l(e,t):"Map"===(n="Object"===(n=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?l(e,t):void 0}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function l(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function c(e){return(c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var h=1e4,
d=9466848e5;function u(t){try{return JSON.parse(t)}catch(e){throw m(t),e}}function g(t){try{return(0,n.K)(t)}catch(e){return t}}function p(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})}function m(e){(void 0!==i?i:JSON).parse(e)}function f(e,t){for(var n in t)B(t,n)&&(e[n]=t[n]);return e}function C(e){for(var t in e)B(e,t)&&delete e[t];return e}function y(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp?"regexp":b(e)?"array":"object"}var v=/^https?:\/\/\S+$/;function I(e){return("string"==typeof e||e instanceof String)&&v.test(e)}function b(e){return"[object Array]"===Object.prototype.toString.call(e)}function A(e){return e.ownerDocument.defaultView}function P(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function H(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function G(e,t){var n=e.className.split(" ");-1===n.indexOf(t)&&(n.push(t),e.className=n.join(" "))}function F(e){e.className=""}function O(e,t){var n=e.className.split(" "),t=n.indexOf(t);-1!==t&&(n.splice(t,1),e.className=n.join(" "))}function w(e){for(var t=e.childNodes,n=0,i=t.length;n<i;n++){var o=t[n],r=(o.style&&o.removeAttribute("style"),o.attributes);if(r)for(var s=r.length-1;0<=s;s--){var a=r[s];!0===a.specified&&o.removeAttribute(a.name)}w(o)}}function V(e){var t;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(e=window.getSelection()).removeAllRanges(),e.addRange(t))}function Z(e){var t;e&&"DIV"===e.nodeName&&window.getSelection&&document.createRange&&((t=document.createRange()).selectNodeContents(e),(e=window.getSelection()).removeAllRanges(),e.addRange(t))}function S(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null}function x(e){var t;e&&window.getSelection&&((t=window.getSelection()).removeAllRanges(),t.addRange(e))}function D(){var e=S();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer===e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null}function j(e){var t;document.createRange&&window.getSelection&&window.getSelection()&&(t=document.createRange(),e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),x(t))}function k(e,t){var n;if(void 0===t&&(t={_text:"",flush:function(){var e=this._text;return this._text="",e},set:function(e){this._text=e}}),e.nodeValue)return""!==(n=E(e.nodeValue))?t.flush()+n:"";if(e.hasChildNodes()){for(var i=e.childNodes,o="",r=0,s=i.length;r<s;r++){var a,l=i[r];"DIV"===l.nodeName||"P"===l.nodeName?((a=(a=i[r-1])?a.nodeName:void 0)&&"DIV"!==a&&"P"!==a&&"BR"!==a&&(""!==o&&(o+="\n"),t.flush()),o+=k(l,t),t.set("\n")):"BR"===l.nodeName?(o+=t.flush(),t.set("\n")):o+=k(l,t)}return o}return""}function E(e){return e.replace(/(\b|^)\s*(\b|$)/g,function(e){return/\n/.exec(e)?"":e})}function K(e,t){for(var n=e?e.parentNode:void 0;n;){if(n===t)return!0;n=n.parentNode}return!1}function z(){var e;return-1===T&&(e=-1,"undefined"!=typeof navigator&&"Microsoft Internet Explorer"===navigator.appName&&null!=/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)&&(e=parseFloat(RegExp.$1)),T=e),T}var T=-1;function R(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}function X(e,t,n,i){return e.addEventListener?(void 0===i&&(i=!1),"mousewheel"===t&&R()&&(t="DOMMouseScroll"),e.addEventListener(t,n,i),n):e.attachEvent?(e.attachEvent("on"+t,i=function(){return n.call(e,window.event)}),i):void 0}function Y(e,t,n,i){e.removeEventListener?(void 0===i&&(i=!1),"mousewheel"===t&&R()&&(t="DOMMouseScroll"),e.removeEventListener(t,n,i)):e.detachEvent&&e.detachEvent("on"+t,n)}function J(e,t){for(var n=e.parentNode;n;){if(n===t)return!0;n=n.parentNode}return!1}function _(n){var e=[],i=0;function t(e){for(var t="";void 0!==n[i]&&n[i]!==e;)t+=n[i],i++;if(n[i]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==n[i];)if("."===n[i])i++,e.push(function(){for(var e="";void 0!==n[i]&&/[\w$]/.test(n[i]);)e+=n[i],i++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+i);return e}());else{if("["!==n[i])throw new Error('Invalid JSON path: unexpected character "'+n[i]+'" at index '+i);if("'"===n[++i]||'"'===n[i]){var o=n[i];if(i++,e.push(t(o)),n[i]!==o)throw new Error("Invalid JSON path: closing quote ' expected at index "+i);i++}else{o=t("]").trim();if(0===o.length)throw new Error("Invalid JSON path: array value expected at index "+i);o="*"===o?o:JSON.parse(o),e.push(o)}if("]"!==n[i])throw new Error("Invalid JSON path: closing bracket ] expected at index "+i);i++}return e}function U(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")}function Q(e){var t,n;return"enum"===e.keyword&&Array.isArray(e.schema)&&(n=e.schema)&&(5<(n=n.map(function(e){return JSON.stringify(e)})).length&&(t=["("+(n.length-5)+" more...)"],(n=n.slice(0,5)).push(t)),e.message="should be equal to one of: "+n.join(", ")),"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e}function q(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}function ee(e){return"object"===c(e)&&Array.isArray(e.path)&&"string"==typeof e.message}function te(e,t,n){n=void 0!==n?n:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom}function ne(i,o,r){var s;return function(){var e=this,t=arguments,n=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||i.apply(e,t)},o),n&&i.apply(e,t)}}function ie(e,t){for(var n=t.length,i=0,o=e.length,r=t.length;t.charAt(i)===e.charAt(i)&&i<n;)i++;for(;t.charAt(r-1)===e.charAt(o-1)&&i<r&&0<o;)r--,o--;return{start:i,end:r}}function oe(t){var e,n,i,o,r=0,s=0;return"number"==typeof t.selectionStart&&"number"==typeof t.selectionEnd?(r=t.selectionStart,s=t.selectionEnd):(o=document.selection.createRange())&&o.parentElement()===t&&(i=t.value.length,e=t.value.replace(/\r\n/g,"\n"),(n=t.createTextRange()).moveToBookmark(o.getBookmark()),(o=t.createTextRange()).collapse(!1),-1<n.compareEndPoints("StartToEnd",o)?r=s=i:(r=-n.moveStart("character",-i),r+=e.slice(0,r).split("\n").length-1,-1<n.compareEndPoints("EndToEnd",o)?s=i:(s=-n.moveEnd("character",-i),s+=e.slice(0,s).split("\n").length-1))),{startIndex:r,endIndex:s,start:a(r),end:a(s)};function a(e){e=t.value.substring(0,e);return{row:(e.match(/\n/g)||[]).length+1,column:e.length-e.lastIndexOf("\n")}}}function re(e,t,n){var e=e.value||"";return 0<t&&0<n?(e=e.split("\n",t),t=Math.min(e.length,t),n=Math.min(e[t-1].length,n-1),n=1===t?n:n+1,e.slice(0,t-1).join("\n").length+n):-1}function se(e,t){var n,i=[];if(t&&t.length){try{n=r.parse(e)}catch(e){return i}t.forEach(function(e){var t=$(_(e)),t=n.pointers[t];t&&i.push({path:e,line:t.key?t.key.line:t.value?t.value.line:0,column:t.key?t.key.column:t.value?t.value.column:0})})}return i}function $(e){return e.map(function(e){return"/"+String(e).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function L(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null}function ae(e){return!!L(e)}function le(n,e){var i;return n?(i="",n.title&&(i+=n.title),n.description&&(0<i.length&&(i+="\n"),i+=n.description),n.default&&(0<i.length&&(i+="\n\n"),i=(i+=(0,s.Iu)("default",void 0,e)+"\n")+JSON.stringify(n.default,null,2)),Array.isArray(n.examples)&&0<n.examples.length&&(0<i.length&&(i+="\n\n"),i+=(0,s.Iu)("examples",void 0,e)+"\n",n.examples.forEach(function(e,t){i+=JSON.stringify(e,null,2),t!==n.examples.length-1&&(i+="\n")})),i):""}function N(e,t){for(var n=e,i=0;i<t.length&&null!=n;i++)n=n[t[i]];return n}function ce(e,t){for(var n=e.replace(/ \(copy( \d+)?\)$/,""),i=n,o=1;-1!==t.indexOf(i);){i=n+" ("+("copy"+(1<o?" "+o:""))+")";o++}return i}function he(e,t){var n={};if(Array.isArray(e))for(var i=Math.min(e.length,h),o=0;o<i;o++)!function t(n,i,o,r){(Array.isArray(n)||M(n))&&!r||(i[o||""]=!0),M(n)&&Object.keys(n).forEach(function(e){t(n[e],i,o+"."+e,r)})}(e[o],n,"",t);else n[""]=!0;return Object.keys(n).sort()}function de(e,t,n){var i=t&&"."!==t?_(t):[],o="desc"===n?-1:1,t=e.slice();return t.sort(function(e,t){e=N(e,i),t=N(t,i);return o*(t<e?1:e<t?-1:0)}),t}function ue(t,e){var n="desc"===e?-1:1,e=Object.keys(t).sort(function(e,t){return n*o()(e,t)}),i={};return e.forEach(function(e){i[e]=t[e]}),i}function ge(e){var t,n;return""===e?"":"null"===(t=e.toLowerCase())?null:"true"===t||"false"!==t&&(/^0\d+$/.test(e)||(t=Number(e),n=parseFloat(e),isNaN(t))||isNaN(n)?e:t)}function pe(e,t){return"number"==typeof t&&d<t&&isFinite(t)&&Math.floor(t)===t&&!isNaN(new Date(t).valueOf())}function me(e){return e<900?e.toFixed()+" B":(e=e/1e3)<900?e.toFixed(1)+" KB":(e=e/1e3)<900?e.toFixed(1)+" MB":(e=e/1e3)<900?e.toFixed(1)+" GB":(e/1e3).toFixed(1)+" TB"}function fe(e,t){return e.length<=t?e:e.slice(0,t)+"..."}function M(e){return"object"===c(e)&&null!==e&&!Array.isArray(e)}function Ce(e,t){return-1!==e.indexOf(t)}function ye(n,i){if(i||n){if(i&&!n||!i&&n)return!0;if(i.length!==n.length)return!0;for(var e,t=0;t<n.length;++t)if(e=function(t){var e="error"===n[t].type?i.find(function(e){return e.line===n[t].line}):i.find(function(e){return e.dataPath===n[t].dataPath&&e.schemaPath===n[t].schemaPath});if(!e)return{v:!0}}(t))return e.v}return!1}function ve(e,t){e=null!=e&&e.length?e:[],t=null!=t&&t.length?t:[];return a(new Set(e.concat(t)))}function Ie(e){setTimeout(e)}function B(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},8037:function(e,t,n){var i;if(window.Picker)i=window.Picker;else try{i=n(4049)}catch(e){}e.exports=i},6225:function(i,e,C){function l(e,n){var t,i;return n=a(e,n),(e=r.modules[n])||("function"==typeof(e=r.payloads[n])&&(t={id:n,uri:"",exports:i={},packaged:!0},i=e(function(e,t){return s(n,e,t)},i,t)||t.exports,r.modules[n]=i,delete r.payloads[n]),e=r.modules[n]=i||e),e}var t,n,o,r,s,c,a;i=C.nmd(i),(o=function(){return this}())||"undefined"==typeof window||(o=window),(r=function(e,t,n){"string"!=typeof e?r.original?r.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace()):(2==arguments.length&&(n=t),r.modules[e]||(r.payloads[e]=n,r.modules[e]=null))}).modules={},r.payloads={},s=function(e,t,n){if("string"==typeof t){var i=l(e,t);if(null!=i)return n&&n(),i}else if("[object Array]"===Object.prototype.toString.call(t)){for(var o=[],r=0,s=t.length;r<s;++r){var a=l(e,t[r]);if(null==a&&c.original)return;o.push(a)}return n&&n.apply(null,o)||!0}},c=function(e,t){var n=s("",e,t);return null==n&&c.original?c.original.apply(this,arguments):n},a=function(e,t){var n;if(-1!==t.indexOf("!"))return n=t.split("!"),a(e,n[0])+"!"+a(e,n[1]);if("."==t.charAt(0))for(t=e.split("/").slice(0,-1).join("/")+"/"+t;-1!==t.indexOf(".")&&i!=t;){var i=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return t},n=o,(t="ace")&&(o[t]||(o[t]={}),n=o[t]),n.define&&n.define.packaged||(r.original=n.define,n.define=r,n.define.packaged=!0),n.require&&n.require.packaged||(c.original=n.require,n.require=c,n.require.packaged=!0),ace.define("ace/lib/es6-shim",["require","exports","module"],function(e,t,n){function i(e,t,n){Object.defineProperty(e,t,{value:n,enumerable:!1,writable:!0,configurable:!0})}String.prototype.startsWith||i(String.prototype,"startsWith",function(e,t){return this.lastIndexOf(e,t=t||0)===t}),String.prototype.endsWith||i(String.prototype,"endsWith",function(e,t){(void 0===t||t>this.length)&&(t=this.length),t-=e.length;e=this.indexOf(e,t);return-1!==e&&e===t}),String.prototype.repeat||i(String.prototype,"repeat",function(e){for(var t="",n=this;0<e;)1&e&&(t+=n),(e>>=1)&&(n+=n);return t}),String.prototype.includes||i(String.prototype,"includes",function(e,t){return-1!=this.indexOf(e,t)}),Object.assign||(Object.assign=function(e){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),n=1;n<arguments.length;n++){var i=arguments[n];null!=i&&Object.keys(i).forEach(function(e){t[e]=i[e]})}return t}),Object.values||(Object.values=function(t){return Object.keys(t).map(function(e){return t[e]})}),Array.prototype.find||i(Array.prototype,"find",function(e){for(var t=this.length,n=arguments[1],i=0;i<t;i++){var o=this[i];if(e.call(n,o,i,this))return o}}),Array.prototype.findIndex||i(Array.prototype,"findIndex",function(e){for(var t=this.length,n=arguments[1],i=0;i<t;i++){var o=this[i];if(e.call(n,o,i,this))return i}}),Array.prototype.includes||i(Array.prototype,"includes",function(e,t){return-1!=this.indexOf(e,t)}),Array.prototype.fill||i(Array.prototype,"fill",function(e){for(var t=this.length>>>0,n=arguments[1]>>0,i=n<0?Math.max(t+n,0):Math.min(n,t),n=arguments[2],n=void 0===n?t:n>>0,o=n<0?Math.max(t+n,0):Math.min(n,t);i<o;)this[i]=e,i++;return this}),Array.of||i(Array,"of",function(){return Array.prototype.slice.call(arguments)})}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/es6-shim"],function(e,t,n){"use strict";e("./es6-shim")}),ace.define("ace/lib/deep_copy",["require","exports","module"],function(e,t,n){t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;if(Array.isArray(t))for(var n=[],i=0;i<t.length;i++)n[i]=e(t[i]);else{if("[object Object]"!==Object.prototype.toString.call(t))return t;for(var i in n={},t)n[i]=e(t[i])}return n}}),ace.define("ace/lib/lang",["require","exports","module","ace/lib/deep_copy"],function(e,t,n){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var n="";0<t;)1&t&&(n+=e),(t>>=1)&&(e+=e);return n};var i=/^\s\s*/,o=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(i,"")},t.stringTrimRight=function(e){return e.replace(o,"")},t.copyObject=function(e){var t,n={};for(t in e)n[t]=e[t];return n},t.copyArray=function(e){for(var t=[],n=0,i=e.length;n<i;n++)e[n]&&"object"==typeof e[n]?t[n]=this.copyObject(e[n]):t[n]=e[n];return t},t.deepCopy=e("./deep_copy").deepCopy,t.arrayToMap=function(e){for(var t={},n=0;n<e.length;n++)t[e[n]]=1;return t},t.createMap=function(e){var t,n=Object.create(null);for(t in e)n[t]=e[t];return n},t.arrayRemove=function(e,t){for(var n=0;n<=e.length;n++)t===e[n]&&e.splice(n,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return(""+e).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var n=[];return e.replace(t,function(e){n.push({offset:arguments[arguments.length-2],length:e.length})}),n},t.deferredCall=function(e){function t(){i=null,e()}function n(e){return n.cancel(),i=setTimeout(t,e||0),n}var i=null;return(n.schedule=n).call=function(){return this.cancel(),e(),n},n.cancel=function(){return clearTimeout(i),i=null,n},n.isPending=function(){return i},n},t.delayedCall=function(e,t){function n(){o=null,e()}function i(e){null==o&&(o=setTimeout(n,e||t))}var o=null;return i.delay=function(e){o&&clearTimeout(o),o=setTimeout(n,e||t)},(i.schedule=i).call=function(){this.cancel(),e()},i.cancel=function(){o&&clearTimeout(o),o=null},i.isPending=function(){return o},i},t.supportsLookbehind=function(){try{new RegExp("(?<=.)")}catch(e){return!1}return!0},t.skipEmptyMatch=function(e,t,n){return n&&65535<e.codePointAt(t)?2:1}}),ace.define("ace/lib/useragent",["require","exports","module"],function(e,t,n){"use strict";t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS};var i="object"==typeof navigator?navigator:{},o=(/mac|win|linux/i.exec(i.platform)||["other"])[0].toLowerCase(),r=i.userAgent||"",i=i.appName||"";t.isWin="win"==o,t.isMac="mac"==o,t.isLinux="linux"==o,t.isIE="Microsoft Internet Explorer"==i||0<=i.indexOf("MSAppHost")?parseFloat((r.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((r.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=r.match(/ Gecko\/\d+/),t.isOpera="object"==typeof opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(r.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(r.split(" Chrome/")[1])||void 0,t.isSafari=parseFloat(r.split(" Safari/")[1])&&!t.isChrome||void 0,t.isEdge=parseFloat(r.split(" Edge/")[1])||void 0,t.isAIR=0<=r.indexOf("AdobeAIR"),t.isAndroid=0<=r.indexOf("Android"),t.isChromeOS=0<=r.indexOf(" CrOS "),t.isIOS=/iPad|iPhone|iPod/.test(r)&&!window.MSStream,t.isIOS&&(t.isMac=!0),t.isMobile=t.isIOS||t.isAndroid}),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(e,r,t){"use strict";var s,n,e=e("./useragent"),a=(r.buildDom=function e(t,n,i){if("string"==typeof t&&t)return c=document.createTextNode(t),n&&n.appendChild(c),c;if(!Array.isArray(t))return t&&t.appendChild&&n&&n.appendChild(t),t;if("string"!=typeof t[0]||!t[0]){for(var o=[],r=0;r<t.length;r++){var s=e(t[r],n,i);s&&o.push(s)}return o}for(var a=document.createElement(t[0]),l=t[1],c=1,r=c=l&&"object"==typeof l&&!Array.isArray(l)?2:c;r<t.length;r++)e(t[r],a,i);return 2==c&&Object.keys(l).forEach(function(e){var t=l[e];"class"===e?a.className=Array.isArray(t)?t.join(" "):t:"function"==typeof t||"value"==e||"$"==e[0]?a[e]=t:"ref"===e?i&&(i[t]=a):"style"===e?"string"==typeof t&&(a.style.cssText=t):null!=t&&a.setAttribute(e,t)}),n&&n.appendChild(a),a},r.getDocumentHead=function(e){return(e=e||document).head||e.getElementsByTagName("head")[0]||e.documentElement},r.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},r.removeChildren=function(e){e.innerHTML=""},r.createTextNode=function(e,t){return(t?t.ownerDocument:document).createTextNode(e)},r.createFragment=function(e){return(e?e.ownerDocument:document).createDocumentFragment()},r.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},r.addCssClass=function(e,t){r.hasCssClass(e,t)||(e.className+=" "+t)},r.removeCssClass=function(e,t){for(var n=e.className.split(/\s+/g);;){var i=n.indexOf(t);if(-1==i)break;n.splice(i,1)}e.className=n.join(" ")},r.toggleCssClass=function(e,t){for(var n=e.className.split(/\s+/g),i=!0;;){var o=n.indexOf(t);if(-1==o)break;i=!1,n.splice(o,1)}return i&&n.push(t),e.className=n.join(" "),i},r.setCssClass=function(e,t,n){n?r.addCssClass(e,t):r.removeCssClass(e,t)},r.hasCssString=function(e,t){var n,i=0;if(n=(t=t||document).querySelectorAll("style"))for(;i<n.length;)if(n[i++].id===e)return!0},r.removeElementById=function(e,t){(t=t||document).getElementById(e)&&t.getElementById(e).remove()},[]);function l(){var e=a;a=null,e&&e.forEach(function(e){i(e[0],e[1])})}function i(e,t,n){if("undefined"!=typeof document){if(a)if(n)l();else if(!1===n)return a.push([e,t]);if(!s){var i=n,n=(i=n&&n.getRootNode&&(i=n.getRootNode())&&i!=n?i:document).ownerDocument||i;if(t&&r.hasCssString(t,i))return null;t&&(e+="\n/*# sourceURL=ace/css/"+t+" */");var o=r.createElement("style");o.appendChild(n.createTextNode(e)),t&&(o.id=t),(i=i==n?r.getDocumentHead(n):i).insertBefore(o,i.firstChild)}}}r.useStrictCSP=function(e){0==(s=e)?l():a=a||[]},r.importCssString=i,r.importCssStylsheet=function(e,t){r.buildDom(["link",{rel:"stylesheet",href:e}],r.getDocumentHead(t))},r.scrollbarWidth=function(e){var t=r.createElement("ace_inner"),n=(t.style.width="100%",t.style.minWidth="0px",t.style.height="200px",t.style.display="block",r.createElement("ace_outer")),i=n.style,e=(i.position="absolute",i.left="-10000px",i.overflow="hidden",i.width="200px",i.minWidth="0px",i.height="150px",i.display="block",n.appendChild(t),e&&e.documentElement||document&&document.documentElement);if(!e)return 0;e.appendChild(n);var o=t.offsetWidth,i=(i.overflow="scroll",t.offsetWidth);return o===i&&(i=n.clientWidth),e.removeChild(n),o-i},r.computedStyle=function(e,t){return window.getComputedStyle(e,"")||{}},r.setStyle=function(e,t,n){e[t]!==n&&(e[t]=n)},r.HAS_CSS_ANIMATION=!1,r.HAS_CSS_TRANSFORMS=!1,r.HI_DPI=!e.isWin||"undefined"!=typeof window&&1.5<=window.devicePixelRatio,e.isChromeOS&&(r.HI_DPI=!1),"undefined"!=typeof document&&(n=document.createElement("div"),r.HI_DPI&&void 0!==n.style.transform&&(r.HAS_CSS_TRANSFORMS=!0),e.isEdge||void 0===n.style.animationName||(r.HAS_CSS_ANIMATION=!0),n=null),r.HAS_CSS_TRANSFORMS?r.translate=function(e,t,n){e.style.transform="translate("+Math.round(t)+"px, "+Math.round(n)+"px)"}:r.translate=function(e,t,n){e.style.top=Math.round(n)+"px",e.style.left=Math.round(t)+"px"}}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(e,t,n){
/*
 * based on code from:
 *
 * @license RequireJS text 0.25.0 Copyright (c) 2010-2011, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/requirejs for details
 */
"use strict";var o=e("./dom");t.get=function(e,t){var n=new XMLHttpRequest;n.open("GET",e,!0),n.onreadystatechange=function(){4===n.readyState&&t(n.responseText)},n.send(null)},t.loadScript=function(e,n){var t=o.getDocumentHead(),i=document.createElement("script");i.src=e,t.appendChild(i),i.onload=i.onreadystatechange=function(e,t){!t&&i.readyState&&"loaded"!=i.readyState&&"complete"!=i.readyState||(i=i.onload=i.onreadystatechange=null,t)||n()}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}}),ace.define("ace/lib/oop",["require","exports","module"],function(e,n,t){"use strict";n.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},n.mixin=function(e,t){for(var n in t)e[n]=t[n];return e},n.implement=function(e,t){n.mixin(e,t)}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(e,t,n){"use strict";function r(){this.propagationStopped=!0}function s(){this.defaultPrevented=!0}var i={};i._emit=i._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var n=this._eventRegistry[e]||[],i=this._defaultHandlers[e];if(n.length||i){(t="object"==typeof t&&t?t:{}).type||(t.type=e),t.stopPropagation||(t.stopPropagation=r),t.preventDefault||(t.preventDefault=s);for(var n=n.slice(),o=0;o<n.length&&(n[o](t,this),!t.propagationStopped);o++);return i&&!t.defaultPrevented?i(t,this):void 0}},i._signal=function(e,t){if(n=(this._eventRegistry||{})[e])for(var n=n.slice(),i=0;i<n.length;i++)n[i](t,this)},i.once=function(t,n){var i=this;if(this.on(t,function e(){i.off(t,e),n.apply(null,arguments)}),!n)return new Promise(function(e){n=e})},i.setDefaultHandler=function(e,t){var n,i,o=this._defaultHandlers;(o=o||(this._defaultHandlers={_disabled_:{}}))[e]&&(i=o[e],(n=o._disabled_[e])||(o._disabled_[e]=n=[]),n.push(i),-1!=(i=n.indexOf(t)))&&n.splice(i,1),o[e]=t},i.removeDefaultHandler=function(e,t){var n,i=this._defaultHandlers;i&&(n=i._disabled_[e],i[e]==t?n&&this.setDefaultHandler(e,n.pop()):n&&-1!=(i=n.indexOf(t))&&n.splice(i,1))},i.on=i.addEventListener=function(e,t,n){this._eventRegistry=this._eventRegistry||{};var i=this._eventRegistry[e];return-1==(i=i||(this._eventRegistry[e]=[])).indexOf(t)&&i[n?"unshift":"push"](t),t},i.off=i.removeListener=i.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};e=this._eventRegistry[e];e&&-1!==(t=e.indexOf(t))&&e.splice(t,1)},i.removeAllListeners=function(e){e||(this._eventRegistry=this._defaultHandlers=void 0),this._eventRegistry&&(this._eventRegistry[e]=void 0),this._defaultHandlers&&(this._defaultHandlers[e]=void 0)},t.EventEmitter=i}),ace.define("ace/lib/report_error",["require","exports","module"],function(e,t,n){t.reportError=function(e,t){var n=new Error(e);n.data=t,"object"==typeof console&&console.error&&console.error(n),setTimeout(function(){throw n})}}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter","ace/lib/report_error"],function(e,t,n){var i,o=e("./oop"),r=e("./event_emitter").EventEmitter,e=e("./report_error").reportError,s={setOptions:function(t){Object.keys(t).forEach(function(e){this.setOption(e,t[e])},this)},getOptions:function(e){var t,n={};return e?Array.isArray(e)||(n=e,e=Object.keys(n)):(t=this.$options,e=Object.keys(t).filter(function(e){return!t[e].hidden})),e.forEach(function(e){n[e]=this.getOption(e)},this),n},setOption:function(e,t){var n;if(this["$"+e]!==t)return(n=this.$options[e])?n.forwardTo?this[n.forwardTo]&&this[n.forwardTo].setOption(e,t):(n.handlesSet||(this["$"+e]=t),void(n&&n.set&&n.set.call(this,t))):a('misspelled option "'+e+'"')},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:a('misspelled option "'+e+'"')}};function a(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}c.prototype.defineOptions=function(n,e,i){return n.$options||(this.$defaultOptions[e]=n.$options={}),Object.keys(i).forEach(function(e){var t=i[e];(t="string"==typeof t?{forwardTo:t}:t).name||(t.name=e),"initialValue"in(n.$options[t.name]=t)&&(n["$"+t.name]=t.initialValue)}),o.implement(n,s),this},c.prototype.resetOptions=function(n){Object.keys(n.$options).forEach(function(e){var t=n.$options[e];"value"in t&&n.setOption(e,t.value)})},c.prototype.setDefaultValue=function(e,t,n){if(!e){for(e in this.$defaultOptions)if(this.$defaultOptions[e][t])break;if(!this.$defaultOptions[e][t])return!1}var i=this.$defaultOptions[e]||(this.$defaultOptions[e]={});i[t]&&(i.forwardTo?this.setDefaultValue(i.forwardTo,t,n):i[t].value=n)},c.prototype.setDefaultValues=function(t,n){Object.keys(n).forEach(function(e){this.setDefaultValue(t,e,n[e])},this)},c.prototype.setMessages=function(e){i=e},c.prototype.nls=function(e,n){i&&!i[e]&&a("No message found for '"+e+"' in the provided messages, falling back to default English message.");e=i&&i[e]||e;return e=n?e.replace(/\$(\$|[\d]+)/g,function(e,t){return"$"==t?"$":n[t]}):e};var l=c;function c(){this.$defaultOptions={}}l.prototype.warn=a,l.prototype.reportError=e,o.implement(l.prototype,r),t.AppConfig=l}),ace.define("ace/theme/textmate-css",["require","exports","module"],function(e,t,n){n.exports='.ace-tm .ace_gutter {\n  background: #f0f0f0;\n  color: #333;\n}\n\n.ace-tm .ace_print-margin {\n  width: 1px;\n  background: #e8e8e8;\n}\n\n.ace-tm .ace_fold {\n    background-color: #6B72E6;\n}\n\n.ace-tm {\n  background-color: #FFFFFF;\n  color: black;\n}\n\n.ace-tm .ace_cursor {\n  color: black;\n}\n        \n.ace-tm .ace_invisible {\n  color: rgb(191, 191, 191);\n}\n\n.ace-tm .ace_storage,\n.ace-tm .ace_keyword {\n  color: blue;\n}\n\n.ace-tm .ace_constant {\n  color: rgb(197, 6, 11);\n}\n\n.ace-tm .ace_constant.ace_buildin {\n  color: rgb(88, 72, 246);\n}\n\n.ace-tm .ace_constant.ace_language {\n  color: rgb(88, 92, 246);\n}\n\n.ace-tm .ace_constant.ace_library {\n  color: rgb(6, 150, 14);\n}\n\n.ace-tm .ace_invalid {\n  background-color: rgba(255, 0, 0, 0.1);\n  color: red;\n}\n\n.ace-tm .ace_support.ace_function {\n  color: rgb(60, 76, 114);\n}\n\n.ace-tm .ace_support.ace_constant {\n  color: rgb(6, 150, 14);\n}\n\n.ace-tm .ace_support.ace_type,\n.ace-tm .ace_support.ace_class {\n  color: rgb(109, 121, 222);\n}\n\n.ace-tm .ace_keyword.ace_operator {\n  color: rgb(104, 118, 135);\n}\n\n.ace-tm .ace_string {\n  color: rgb(3, 106, 7);\n}\n\n.ace-tm .ace_comment {\n  color: rgb(76, 136, 107);\n}\n\n.ace-tm .ace_comment.ace_doc {\n  color: rgb(0, 102, 255);\n}\n\n.ace-tm .ace_comment.ace_doc.ace_tag {\n  color: rgb(128, 159, 191);\n}\n\n.ace-tm .ace_constant.ace_numeric {\n  color: rgb(0, 0, 205);\n}\n\n.ace-tm .ace_variable {\n  color: rgb(49, 132, 149);\n}\n\n.ace-tm .ace_xml-pe {\n  color: rgb(104, 104, 91);\n}\n\n.ace-tm .ace_entity.ace_name.ace_function {\n  color: #0000A2;\n}\n\n\n.ace-tm .ace_heading {\n  color: rgb(12, 7, 255);\n}\n\n.ace-tm .ace_list {\n  color:rgb(185, 6, 144);\n}\n\n.ace-tm .ace_meta.ace_tag {\n  color:rgb(0, 22, 142);\n}\n\n.ace-tm .ace_string.ace_regex {\n  color: rgb(255, 0, 0)\n}\n\n.ace-tm .ace_marker-layer .ace_selection {\n  background: rgb(181, 213, 255);\n}\n.ace-tm.ace_multiselect .ace_selection.ace_start {\n  box-shadow: 0 0 3px 0px white;\n}\n.ace-tm .ace_marker-layer .ace_step {\n  background: rgb(252, 255, 0);\n}\n\n.ace-tm .ace_marker-layer .ace_stack {\n  background: rgb(164, 229, 101);\n}\n\n.ace-tm .ace_marker-layer .ace_bracket {\n  margin: -1px 0 0 -1px;\n  border: 1px solid rgb(192, 192, 192);\n}\n\n.ace-tm .ace_marker-layer .ace_active-line {\n  background: rgba(0, 0, 0, 0.07);\n}\n\n.ace-tm .ace_gutter-active-line {\n    background-color : #dcdcdc;\n}\n\n.ace-tm .ace_marker-layer .ace_selected-word {\n  background: rgb(250, 250, 255);\n  border: 1px solid rgb(200, 200, 250);\n}\n\n.ace-tm .ace_indent-guide {\n  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;\n}\n\n.ace-tm .ace_indent-guide-active {\n  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAAZSURBVHjaYvj///9/hivKyv8BAAAA//8DACLqBhbvk+/eAAAAAElFTkSuQmCC") right repeat-y;\n}\n'}),ace.define("ace/theme/textmate",["require","exports","module","ace/theme/textmate-css","ace/lib/dom"],function(e,t,n){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText=e("./textmate-css"),t.$id="ace/theme/textmate",e("../lib/dom").importCssString(t.cssText,t.cssClass,!1)}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/net","ace/lib/dom","ace/lib/app_config","ace/theme/textmate"],function(s,a,t){var l,e=s("./lib/lang"),c=s("./lib/net"),n=s("./lib/dom"),i=s("./lib/app_config").AppConfig,r=(t.exports=a=new i,{packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1,useStrictCSP:null}),h=(a.get=function(e){if(r.hasOwnProperty(e))return r[e];throw new Error("Unknown config key: "+e)},a.set=function(e,t){if(r.hasOwnProperty(e))r[e]=t;else if(0==this.setDefaultValue("",e,t))throw new Error("Unknown config key: "+e);"useStrictCSP"==e&&n.useStrictCSP(t)},a.all=function(){return e.copyObject(r)},a.$modes={},a.moduleUrl=function(e,t){var n,i,o;return r.$moduleUrls[e]||(e=e.split("/"),n="snippets"==(t=t||e[e.length-2]||"")?"/":"-",i=e[e.length-1],"worker"==t&&"-"==n&&(o=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g"),i=i.replace(o,"")),(!i||i==t)&&1<e.length&&(i=e[e.length-2]),null==(o=r[t+"Path"])?o=r.basePath:"/"==n&&(t=n=""),o&&"/"!=o.slice(-1)&&(o+="/"),o+t+n+i+this.get("suffix"))},a.setModuleUrl=function(e,t){return r.$moduleUrls[e]=t},a.setLoader=function(e){l=e},a.dynamicModules=Object.create(null),a.$loading={},a.$loaded={},a.loadModule=function(e,n){function t(e){if(e&&!a.$loading[r])return n&&n(e);if(a.$loading[r]||(a.$loading[r]=[]),a.$loading[r].push(n),!(1<a.$loading[r].length)){function t(){var e,t;t=function(e,t){t&&(a.$loaded[r]=t),a._emit("load.module",{name:r,module:t});var n=a.$loading[r];a.$loading[r]=null,n.forEach(function(e){e&&e(t)})},"ace/theme/textmate"===(e=r)||"./theme/textmate"===e?t(null,s("./theme/textmate")):l?l(e,t):console.error("loader is not configured")}if(!a.get("packaged"))return t();c.loadScript(a.moduleUrl(r,o),t),h()}}var i,o,r;Array.isArray(e)?(o=e[0],r=e[1]):"string"==typeof e&&(r=e);if(a.dynamicModules[r])a.dynamicModules[r]().then(function(e){e.default?t(e.default):t(e)});else{try{i=this.$require(r)}catch(e){}t(i||a.$loaded[r])}},a.$require=function(e){if("function"==typeof t.require)return t.require(e)},a.setModuleLoader=function(e,t){a.dynamicModules[e]=t},function(){r.basePath||r.workerPath||r.modePath||r.themePath||Object.keys(r.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),h=function(){})});a.version="1.32.2"}),ace.define("ace/loader_build",["require","exports","module","ace/lib/fixoldbrowsers","ace/config"],function(g,e,p){"use strict";g("./lib/fixoldbrowsers");var m=g("./config"),f=(m.setLoader(function(e,t){g([e],function(e){t(null,e)})}),function(){return this||"undefined"!=typeof window&&window}());function t(e){if(f&&f.document){m.set("packaged",e||g.packaged||p.packaged||f.define&&C.amdD.packaged);for(var t,n={},i="",e=document.currentScript||document._currentScript,o=e&&e.ownerDocument||document,r=(e&&e.src&&(i=e.src.split(/[?#]/)[0].split("/").slice(0,-1).join("/")||""),o.getElementsByTagName("script")),s=0;s<r.length;s++){var a=r[s],l=a.src||a.getAttribute("src");if(l){for(var c=a.attributes,h=0,d=c.length;h<d;h++){var u=c[h];0===u.name.indexOf("data-ace-")&&(n[u.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(e,t){return t.toUpperCase()})]=u.value)}a=l.match(/^(.*)\/ace([\-.]\w+)?\.js(\?|$)/);a&&(i=a[1])}}for(t in i&&(n.base=n.base||i,n.packaged=!0),n.basePath=n.base,n.workerPath=n.workerPath||n.base,n.modePath=n.modePath||n.base,n.themePath=n.themePath||n.base,delete n.base,n)void 0!==n[t]&&m.set(t,n[t])}}p.exports=function(e){m.init=t,m.$require=g,e.require=g,e.define=C.amdD},t(!0)}),ace.define("ace/range",["require","exports","module"],function(e,t,n){"use strict";r.prototype.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},r.prototype.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},r.prototype.contains=function(e,t){return 0==this.compare(e,t)},r.prototype.compareRange=function(e){var t=e.end,e=e.start,t=this.compare(t.row,t.column);return 1==t?1==(t=this.compare(e.row,e.column))?2:0==t?1:0:-1==t?-2:-1==(t=this.compare(e.row,e.column))?-1:1==t?42:0},r.prototype.comparePoint=function(e){return this.compare(e.row,e.column)},r.prototype.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},r.prototype.intersects=function(e){e=this.compareRange(e);return-1==e||0==e||1==e},r.prototype.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},r.prototype.isStart=function(e,t){return this.start.row==e&&this.start.column==t},r.prototype.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},r.prototype.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},r.prototype.inside=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)&&!this.isStart(e,t)},r.prototype.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},r.prototype.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},r.prototype.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row!==e||t<=this.end.column?0:1:t<this.start.column?-1:t>this.end.column?1:0},r.prototype.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},r.prototype.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},r.prototype.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},r.prototype.clipRows=function(e,t){var n,i;return this.end.row>t?n={row:t+1,column:0}:this.end.row<e&&(n={row:e,column:0}),this.start.row>t?i={row:t+1,column:0}:this.start.row<e&&(i={row:e,column:0}),r.fromPoints(i||this.start,n||this.end)},r.prototype.extend=function(e,t){var n,i,o=this.compare(e,t);return 0==o?this:(-1==o?n={row:e,column:t}:i={row:e,column:t},r.fromPoints(n||this.start,i||this.end))},r.prototype.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},r.prototype.isMultiLine=function(){return this.start.row!==this.end.row},r.prototype.clone=function(){return r.fromPoints(this.start,this.end)},r.prototype.collapseRows=function(){return 0==this.end.column?new r(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new r(this.start.row,0,this.end.row,0)},r.prototype.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),e=e.documentToScreenPosition(this.end);return new r(t.row,t.column,e.row,e.column)},r.prototype.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t};var i=r;function r(e,t,n,i){this.start={row:e,column:t},this.end={row:n,column:i}}i.fromPoints=function(e,t){return new i(e.row,e.column,t.row,t.column)},i.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=i}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(e,t,n){
/*! @license
==========================================================================
SproutCore -- JavaScript Application Framework
copyright 2006-2009, Sprout Systems Inc., Apple Inc. and contributors.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

SproutCore and the SproutCore logo are trademarks of Sprout Systems, Inc.

For more information about SproutCore, visit http://www.sproutcore.com


==========================================================================
@license */
"use strict";var r=e("./oop"),i=function(){var e,t,n={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8,control:1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in n.PRINTABLE_KEYS[173]="-",n.FUNCTION_KEYS)e=n.FUNCTION_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);for(t in n.PRINTABLE_KEYS)e=n.PRINTABLE_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);r.mixin(n,n.MODIFIER_KEYS),r.mixin(n,n.PRINTABLE_KEYS),r.mixin(n,n.FUNCTION_KEYS),n.enter=n.return,n.escape=n.esc,n.del=n.delete;for(var i=["cmd","ctrl","alt","shift"],o=Math.pow(2,i.length);o--;)n.KEY_MODS[o]=i.filter(function(e){return o&n.KEY_MODS[e]}).join("-")+"-";return n.KEY_MODS[0]="",n.KEY_MODS[-1]="input-",n}();r.mixin(t,i),(t.default=t).keyCodeToString=function(e){var t=i[e];return(t="string"!=typeof t?String.fromCharCode(e):t).toLowerCase()}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,d,t){"use strict";var n,r=e("./keys"),u=e("./useragent"),s=null,a=0;function o(){if(null==n){n=!1;try{document.createComment("").addEventListener("test",function(){},{get passive(){return n={passive:!1},!0}})}catch(e){}}return n}function l(e,t,n){this.elem=e,this.type=t,this.callback=n}l.prototype.destroy=function(){p(this.elem,this.type,this.callback),this.elem=this.type=this.callback=void 0};function c(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)}var h,g=d.addListener=function(e,t,n,i){e.addEventListener(t,n,o()),i&&i.$toDestroy.push(new l(e,t,n))},p=d.removeListener=function(e,t,n){e.removeEventListener(t,n,o())};d.stopEvent=function(e){return d.stopPropagation(e),d.preventDefault(e),!1},d.stopPropagation=function(e){e.stopPropagation&&e.stopPropagation()},d.preventDefault=function(e){e.preventDefault&&e.preventDefault()},d.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||u.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.button},d.capture=function(e,t,n){var i=e&&e.ownerDocument||document;function o(e){t&&t(e),n&&n(e),p(i,"mousemove",t),p(i,"mouseup",o),p(i,"dragstart",o)}return g(i,"mousemove",t),g(i,"mouseup",o),g(i,"dragstart",o),o},d.addMouseWheelListener=function(e,i,t){g(e,"wheel",function(e){var t=e.deltaX||0,n=e.deltaY||0;switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.15*t,e.wheelY=.15*n;break;case e.DOM_DELTA_LINE:e.wheelX=15*t,e.wheelY=15*n;break;case e.DOM_DELTA_PAGE:e.wheelX=150*t,e.wheelY=150*n}i(e)},t)},d.addMultiMouseDownListener=function(e,n,i,o,t){var r,s,a,l=0,c={2:"dblclick",3:"tripleclick",4:"quadclick"};function h(e){var t;if(0!==d.getButton(e)?l=0:1<e.detail&&!(4<++l)||(l=1),u.isIE&&(t=5<Math.abs(e.clientX-r)||5<Math.abs(e.clientY-s),a&&!t||(l=1),a&&clearTimeout(a),a=setTimeout(function(){a=null},n[l-1]||600),1==l)&&(r=e.clientX,s=e.clientY),e._clicks=l,i[o]("mousedown",e),4<l)l=0;else if(1<l)return i[o](c[l],e)}(e=Array.isArray(e)?e:[e]).forEach(function(e){g(e,"mousedown",h,t)})};function m(){s=Object.create(null)}d.getModifierString=function(e){return r.KEY_MODS[c(e)]},d.addCommandKeyListener=function(e,n,t){var i=null;g(e,"keydown",function(e){s[e.keyCode]=(s[e.keyCode]||0)+1;var t=function(e,t,n){var i=c(t);if(!u.isMac&&s){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(i|=8),s.altGr){if(3==(3&i))return;s.altGr=0}18!==n&&17!==n||(o="location"in t?t.location:t.keyLocation,17===n&&1===o?1==s[n]&&(a=t.timeStamp):18===n&&3===i&&2===o&&t.timeStamp-a<50&&(s.altGr=!0))}if(n in r.MODIFIER_KEYS&&(n=-1),!i&&13===n){var o="location"in t?t.location:t.keyLocation;if(3===o&&(e(t,i,-n),t.defaultPrevented))return}if(u.isChromeOS&&8&i){if(e(t,i,n),t.defaultPrevented)return;i&=-9}return!!(i||n in r.FUNCTION_KEYS||n in r.PRINTABLE_KEYS)&&e(t,i,n)}(n,e,e.keyCode);return i=e.defaultPrevented,t},t),g(e,"keypress",function(e){i&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(d.stopEvent(e),i=null)},t),g(e,"keyup",function(e){s[e.keyCode]=null},t),s||(m(),g(window,"focus",m))},"object"==typeof window&&window.postMessage&&!u.isOldIE&&(h=1,d.nextTick=function(t,n){n=n||window;function i(e){e.data==o&&(d.stopPropagation(e),p(n,"message",i),t())}var o="zero-timeout-message-"+h++;g(n,"message",i),n.postMessage(o,"*")}),d.$idleBlocked=!1,d.onIdle=function(t,e){return setTimeout(function e(){d.$idleBlocked?setTimeout(e,100):t()},e)},d.$idleBlockId=null,d.blockIdle=function(e){d.$idleBlockId&&clearTimeout(d.$idleBlockId),d.$idleBlocked=!0,d.$idleBlockId=setTimeout(function(){d.$idleBlocked=!1},e||100)},d.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),d.nextFrame?d.nextFrame=d.nextFrame.bind(window):d.nextFrame=function(e){setTimeout(e,17)}}),ace.define("ace/clipboard",["require","exports","module"],function(e,t,n){"use strict";var i;n.exports={lineMode:!1,pasteCancelled:function(){return!!(i&&i>Date.now()-50)||(i=!1)},cancel:function(){i=Date.now()}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/config","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],function(e,t,n){"use strict";var V=e("../lib/event"),Z=e("../config").nls,D=e("../lib/useragent"),j=e("../lib/dom"),K=e("../lib/lang"),z=e("../clipboard"),X=D.isChrome<18,Y=D.isIE,J=63<D.isChrome,U=e("../lib/keys"),Q=U.KEY_MODS,q=D.isIOS,ee=q?/\s/:/\n/,te=D.isMobile;t.TextInput=function(e,d){var u=j.createElement("textarea"),r=(u.className="ace_text-input",u.setAttribute("wrap","off"),u.setAttribute("autocorrect","off"),u.setAttribute("autocapitalize","off"),u.setAttribute("spellcheck","false"),u.style.opacity="0",e.insertBefore(u,e.firstChild),!1),g=!1,l=!1,p=!1,a="",m=(te||(u.style.fontSize="1px"),!1),t=!1,f="",C=0,y=0,v=0,c=Number.MAX_SAFE_INTEGER,h=Number.MIN_SAFE_INTEGER,I=0;try{var b=document.activeElement===u}catch(e){}this.setNumberOfExtraLines=function(e){c=Number.MAX_SAFE_INTEGER,h=Number.MIN_SAFE_INTEGER,I=e<0?0:e},this.setAriaOptions=function(e){e.activeDescendant?(u.setAttribute("aria-haspopup","true"),u.setAttribute("aria-autocomplete",e.inline?"both":"list"),u.setAttribute("aria-activedescendant",e.activeDescendant)):(u.setAttribute("aria-haspopup","false"),u.setAttribute("aria-autocomplete","both"),u.removeAttribute("aria-activedescendant")),e.role&&u.setAttribute("role",e.role),e.setLabel&&(u.setAttribute("aria-roledescription",Z("editor")),d.session)&&(e=d.session.selection.cursor.row,u.setAttribute("aria-label",Z("Cursor at row $0",[e+1])))},this.setAriaOptions({role:"textbox"}),V.addListener(u,"blur",function(e){t||(d.onBlur(e),b=!1)},d),V.addListener(u,"focus",function(e){if(!t){if(b=!0,D.isEdge)try{if(!document.hasFocus())return}catch(e){}d.onFocus(e),D.isEdge?setTimeout(w):w()}},d),this.$focusScroll=!1,this.focus=function(){if(this.setAriaOptions({setLabel:d.renderer.enableKeyboardAccessibility}),a||J||"browser"==this.$focusScroll)return u.focus({preventScroll:!0});var e=u.style.top;u.style.position="fixed",u.style.top="0px";try{var t=0!=u.getBoundingClientRect().top}catch(e){return}var n=[];if(t)for(var i=u.parentElement;i&&1==i.nodeType;)n.push(i),i.setAttribute("ace_nocontext","true"),i=!i.parentElement&&i.getRootNode?i.getRootNode().host:i.parentElement;u.focus({preventScroll:!0}),t&&n.forEach(function(e){e.removeAttribute("ace_nocontext")}),setTimeout(function(){u.style.position="","0px"==u.style.top&&(u.style.top=e)},0)},this.blur=function(){u.blur()},this.isFocused=function(){return b},d.on("beforeEndOperation",function(){var e=d.curOp,t=e&&e.command&&e.command.name;"insertstring"!=t&&(t=t&&(e.docChanged||e.selectionChanged),l&&t&&(f=u.value="",G()),w())});function A(e,t){for(var n=t,i=1;i<=e-c&&i<2*I+1;i++)n+=d.session.getLine(e-i).length+1;return n}function n(e){H(e,!0)}function i(e){H(e,!1)}function o(e){var t=k(e);z.pasteCancelled()||("string"==typeof t?(t&&d.onPaste(t,e),D.isIE&&setTimeout(w),V.preventDefault(e)):(u.value="",g=!0))}var w=q?function(e){var t;!b||r&&!e||p||((t="\n ab"+(e=e||"")+"cde fg\n")!=u.value&&(u.value=f=t),t=4+(e.length||(d.selection.isEmpty()?0:1)),4==C&&y==t||u.setSelectionRange(4,t),C=4,y=t)}:function(){if(!l&&!p&&(b||S)){l=!0;var e=0,t=0,n="";if(d.session){for(var i,o=d.selection,r=o.getRange(),o=o.cursor.row,s=(o===h+1?h=(c=h+1)+2*I:o===c-1?c=(h=c-1)-2*I:(o<c-1||h+1<o)&&(c=I<o?o-I:0,h=I<o?o+I:2*I),[]),a=c;a<=h;a++)s.push(d.session.getLine(a));n=s.join("\n"),e=A(r.start.row,r.start.column),t=A(r.end.row,r.end.column),r.start.row<c?(i=d.session.getLine(c-1),e=r.start.row<c-1?0:e,t+=i.length+1,n=i+"\n"+n):r.end.row>h?(i=d.session.getLine(h+1),t=r.end.row>h+1?i.length:r.end.column,t+=n.length+1,n=n+"\n"+i):te&&0<o&&(n="\n"+n,t+=1,e+=1),400<n.length&&(e<400&&t<400?n=n.slice(0,400):(n="\n",e==t?e=t=0:(e=0,t=1)));r=n+"\n\n";r!=f&&(u.value=f=r,C=y=r.length)}if(S&&(C=u.selectionStart,y=u.selectionEnd),y!=t||C!=e||u.selectionEnd!=y)try{u.setSelectionRange(e,t),C=e,y=t}catch(e){}l=!1}},W=(this.resetSelection=w,b&&d.onFocus(),function(e){return 0===e.selectionStart&&e.selectionEnd>=f.length&&e.value===f&&f&&e.selectionEnd!==y}),s=null,S=(this.setInputHandler=function(e){s=e},!(this.getInputHandler=function(){return s})),x=function(e,t){if(S=S&&!1,g)return w(),e&&d.onPaste(e),g=!1,"";for(var n=u.selectionStart,i=u.selectionEnd,o=C,r=f.length-y,s=e,a=e.length-n,l=e.length-i,c=0;0<o&&f[c]==e[c];)c++,o--;for(s=s.slice(c),c=1;0<r&&f.length-c>C-1&&f[f.length-c]==e[e.length-c];)c++,r--;a-=c-1,l-=c-1;var h=s.length-c+1;return h<0&&(o=-h,h=0),s=s.slice(0,h),t||s||a||o||r||l?(h=!(p=!0),D.isAndroid&&". "==s&&(s="  ",h=!0),s&&!o&&!r&&!a&&!l||m?d.onTextInput(s):d.onTextInput(s,{extendLeft:o,extendRight:r,restoreStart:a,restoreEnd:l}),p=!1,f=e,C=n,y=i,v=l,h?"\n":s):""},P=function(e){if(l)return E();if(e&&e.inputType){if("historyUndo"==e.inputType)return d.execCommand("undo");if("historyRedo"==e.inputType)return d.execCommand("redo")}var e=u.value,t=x(e,!0);(500<e.length||ee.test(t)||te&&C<1&&C==y)&&w()},k=function(e,t,n){var i=e.clipboardData||window.clipboardData;if(i&&!X){var o=Y||n?"Text":"text/plain";try{return t?!1!==i.setData(o,t):i.getData(o)}catch(e){if(!n)return k(e,t,!0)}}},H=function(e,t){var n=d.getCopyText();if(!n)return V.preventDefault(e);k(e,n)?(q&&(w(n),r=n,setTimeout(function(){r=!1},10)),t?d.onCut():d.onCopy(),V.preventDefault(e)):(r=!0,u.value=n,u.select(),setTimeout(function(){r=!1,w(),t?d.onCut():d.onCopy()}))},E=(V.addCommandKeyListener(u,d.onCommandKey.bind(d),d),V.addListener(u,"select",function(e){l||(r?r=!1:W(u)?(d.selectAll(),w()):te&&u.selectionStart!=C&&w())},d),V.addListener(u,"input",P,d),V.addListener(u,"cut",n,d),V.addListener(u,"copy",i,d),V.addListener(u,"paste",o,d),"oncut"in u&&"oncopy"in u&&"onpaste"in u||V.addListener(e,"keydown",function(e){if((!D.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:i(e);break;case 86:o(e);break;case 88:n(e)}},d),function(){var e;if(l&&d.onCompositionUpdate&&!d.$readOnly)return m?T():void(l.useTextareaForIME?d.onCompositionUpdate(u.value):(e=u.value,x(e),l.markerRange&&(l.context&&(l.markerRange.start.column=l.selectionStart=l.context.compositionStartOffset),l.markerRange.end.column=l.markerRange.start.column+y-l.selectionStart+v)))}),G=function(e){d.onCompositionEnd&&!d.$readOnly&&(l=!1,d.onCompositionEnd(),d.off("mousedown",T),e)&&P()};function T(){t=!0,u.blur(),u.focus(),t=!1}var R,F=K.delayedCall(E,50).schedule.bind(null,null);function _(){clearTimeout(R),R=setTimeout(function(){a&&(u.style.cssText=a,a=""),d.renderer.$isMousePressed=!1,d.renderer.$keepTextAreaAtCursor&&d.renderer.$moveTextAreaToCursor()},0)}V.addListener(u,"compositionstart",function(e){l||!d.onCompositionStart||d.$readOnly||(l={},m)||(e.data&&(l.useTextareaForIME=!1),setTimeout(E,0),d._signal("compositionStart"),d.on("mousedown",T),(e=d.getSelectionRange()).end.row=e.start.row,e.end.column=e.start.column,l.markerRange=e,l.selectionStart=C,d.onCompositionStart(l),l.useTextareaForIME?(f=u.value="",y=C=0):(u.msGetInputContext&&(l.context=u.msGetInputContext()),u.getInputContext&&(l.context=u.getInputContext())))},d),V.addListener(u,"compositionupdate",E,d),V.addListener(u,"keyup",function(e){27==e.keyCode&&u.value.length<u.selectionStart&&(l||(f=u.value),C=y=-1,w()),F()},d),V.addListener(u,"keydown",F,d),V.addListener(u,"compositionend",G,d),this.getElement=function(){return u},this.setCommandMode=function(e){m=e,u.readOnly=!1},this.setReadOnly=function(e){m||(u.readOnly=e)},this.setCopyWithEmptySelection=function(e){},this.onContextMenu=function(e){S=!0,w(),d._emit("nativecontextmenu",{target:d,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,t){a=a||u.style.cssText,u.style.cssText=(t?"z-index:100000;":"")+(D.isIE?"opacity:0.1;":"")+"text-indent: -"+(C+y)*d.renderer.characterWidth*.5+"px;";function n(e){j.translate(u,e.clientX-r-2,Math.min(e.clientY-o-2,s))}var t=d.container.getBoundingClientRect(),i=j.computedStyle(d.container),o=t.top+(parseInt(i.borderTopWidth)||0),r=t.left+(parseInt(t.borderLeftWidth)||0),s=t.bottom-o-u.clientHeight-2;n(e),"mousedown"==e.type&&(d.renderer.$isMousePressed=!0,clearTimeout(R),D.isWin)&&V.capture(d.container,n,_)},this.onContextMenuClose=_;function $(e){d.textInput.onContextMenu(e),_()}if(V.addListener(u,"mouseup",$,d),V.addListener(u,"mousedown",function(e){e.preventDefault(),_()},d),V.addListener(d.renderer.scroller,"contextmenu",$,d),V.addListener(u,"contextmenu",$,d),q){var L=d,N=u;function O(e){var t,n,i,o;document.activeElement!==N||B||l||L.$mouseHandler.isMousePressed||r||(t=N.selectionStart,n=N.selectionEnd,i=null,(o=0)==t?i=U.up:1==t?i=U.home:y<n&&"\n"==f[n]?i=U.end:t<C&&" "==f[t-1]?(i=U.left,o=Q.option):t<C||t==C&&y!=C&&t==n?i=U.left:y<n&&2<f.slice(0,n).split("\n").length?i=U.down:y<n&&" "==f[n-1]?(i=U.right,o=Q.option):(y<n||n==y&&y!=C&&t==n)&&(i=U.right),t!==n&&(o|=Q.shift),i&&(!L.onCommandKey({},o,i)&&L.commands&&(i=U.keyCodeToString(i),o=L.commands.findKeyCommand(o,i))&&L.execCommand(o),C=t,y=n,w("")))}var M=null,B=!1;N.addEventListener("keydown",function(e){M&&clearTimeout(M),B=!0},!0),N.addEventListener("keyup",function(e){M=setTimeout(function(){B=!1},100)},!0),document.addEventListener("selectionchange",O),L.on("destroy",function(){document.removeEventListener("selectionchange",O)})}this.destroy=function(){u.parentElement&&u.parentElement.removeChild(u)}},t.$setUserAgentForTests=function(e,t){te=e,q=t}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(e,t,n){"use strict";var r=e("../lib/useragent"),e=(i.prototype.onMouseDown=function(e){var t=e.inSelection(),n=e.getDocumentPosition(),i=(this.mousedownEvent=e,this.editor),o=e.getButton();if(0!==o)!i.getSelectionRange().isEmpty()&&1!=o||i.selection.moveToPosition(n),2==o&&(i.textInput.onContextMenu(e.domEvent),r.isMozilla||e.preventDefault());else{if(this.mousedownEvent.time=Date.now(),!t||i.isFocused()||(i.focus(),!this.$focusTimeout)||this.$clickSelection||i.inMultiSelectMode)return this.captureMouse(e),this.startSelect(n,1<e.domEvent._clicks),e.preventDefault();this.setState("focusWait"),this.captureMouse(e)}},i.prototype.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var n=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?n.selection.selectToPosition(e):t||n.selection.moveToPosition(e),t||this.select(),n.setStyle("ace_selecting"),this.setState("select"))},i.prototype.select=function(){var e,t=this.editor,n=t.renderer.screenToTextCoordinates(this.x,this.y);this.$clickSelection&&(e=-1==(e=this.$clickSelection.comparePoint(n))?this.$clickSelection.end:1==e?this.$clickSelection.start:(n=(e=s(this.$clickSelection,n)).cursor,e.anchor),t.selection.setSelectionAnchor(e.row,e.column)),t.selection.selectToPosition(n),t.renderer.scrollCursorIntoView()},i.prototype.extendSelectionBy=function(e){var t,n,i,o=this.editor,r=o.renderer.screenToTextCoordinates(this.x,this.y),e=o.selection[e](r.row,r.column);this.$clickSelection&&(n=this.$clickSelection.comparePoint(e.start),t=this.$clickSelection.comparePoint(e.end),-1==n&&t<=0?(i=this.$clickSelection.end,e.end.row==r.row&&e.end.column==r.column||(r=e.start)):1==t&&0<=n?(i=this.$clickSelection.start,e.start.row==r.row&&e.start.column==r.column||(r=e.end)):i=-1==n&&1==t?(r=e.end,e.start):(r=(n=s(this.$clickSelection,r)).cursor,n.anchor),o.selection.setSelectionAnchor(i.row,i.column)),o.selection.selectToPosition(r),o.renderer.scrollCursorIntoView()},i.prototype.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting")},i.prototype.focusWait=function(){i=this.mousedownEvent.x,e=this.mousedownEvent.y,n=this.x,t=this.y;var e,t,n=Math.sqrt(Math.pow(n-i,2)+Math.pow(t-e,2)),i=Date.now();(0<n||i-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},i.prototype.onDoubleClick=function(e){var e=e.getDocumentPosition(),t=this.editor,n=t.session.getBracketRange(e);n?(n.isEmpty()&&(n.start.column--,n.end.column++),this.setState("select")):(n=t.selection.getWordRange(e.row,e.column),this.setState("selectByWords")),this.$clickSelection=n,this.select()},i.prototype.onTripleClick=function(e){var e=e.getDocumentPosition(),t=this.editor,n=(this.setState("selectByLines"),t.getSelectionRange());n.isMultiLine()&&n.contains(e.row,e.column)?(this.$clickSelection=t.selection.getLineRange(n.start.row),this.$clickSelection.end=t.selection.getLineRange(n.end.row).end):this.$clickSelection=t.selection.getLineRange(e.row),this.select()},i.prototype.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},i.prototype.onMouseWheel=function(e){var t,n,i,o,r,s,a;if(!e.getAccelKey())return e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0),t=this.editor,this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0}),n=this.$lastScroll,o=(a=(i=e.domEvent.timeStamp)-n.t)?e.wheelX/a:n.vx,r=a?e.wheelY/a:n.vy,a<550&&(o=(o+n.vx)/2,r=(r+n.vy)/2),a=!1,1<=(s=Math.abs(o/r))&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(a=!0),(a=s<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)?!0:a)?n.allowed=i:i-n.allowed<550&&(Math.abs(o)<=1.5*Math.abs(n.vx)&&Math.abs(r)<=1.5*Math.abs(n.vy)?(a=!0,n.allowed=i):n.allowed=0),n.t=i,n.vx=o,n.vy=r,a?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0},i);function i(t){t.$clickSelection=null;var e=t.editor;e.setDefaultHandler("mousedown",this.onMouseDown.bind(t)),e.setDefaultHandler("dblclick",this.onDoubleClick.bind(t)),e.setDefaultHandler("tripleclick",this.onTripleClick.bind(t)),e.setDefaultHandler("quadclick",this.onQuadClick.bind(t)),e.setDefaultHandler("mousewheel",this.onMouseWheel.bind(t));["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(e){t[e]=this[e]},this),t.selectByLines=this.extendSelectionBy.bind(t,"getLineRange"),t.selectByWords=this.extendSelectionBy.bind(t,"getWordRange")}function s(e,t){return(e.start.row==e.end.row?2*t.column-e.start.column-e.end.column:e.start.row!=e.end.row-1||e.start.column||e.end.column?2*t.row-e.start.row-e.end.row:t.column-4)<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}e.prototype.selectEnd=e.prototype.selectByLinesEnd,e.prototype.selectAllEnd=e.prototype.selectByLinesEnd,e.prototype.selectByWordsEnd=e.prototype.selectByLinesEnd,t.DefaultHandlers=e}),ace.define("ace/lib/scroll",["require","exports","module"],function(e,t,n){t.preventParentScroll=function(e){e.stopPropagation();var t=e.currentTarget;t.scrollHeight>t.clientHeight||e.preventDefault()}}),ace.define("ace/tooltip",["require","exports","module","ace/lib/dom","ace/lib/event","ace/range","ace/lib/scroll"],function(e,t,n){"use strict";var i,o=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(e,t){e.__proto__=t}:function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}))(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),u=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],i=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return{value:(e=e&&i>=e.length?void 0:e)&&e[i++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")},r=e("./lib/dom"),a=(e("./lib/event"),e("./range").Range),s=e("./lib/scroll").preventParentScroll,l="ace_tooltip",e=(c.prototype.$init=function(){return this.$element=r.createElement("div"),this.$element.className=l,this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},c.prototype.getElement=function(){return this.$element||this.$init()},c.prototype.setText=function(e){this.getElement().textContent=e},c.prototype.setHtml=function(e){this.getElement().innerHTML=e},c.prototype.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},c.prototype.setClassName=function(e){r.addCssClass(this.getElement(),e)},c.prototype.setTheme=function(e){this.$element.className=l+" "+(e.isDark?"ace_dark ":"")+(e.cssClass||"")},c.prototype.show=function(e,t,n){null!=e&&this.setText(e),null!=t&&null!=n&&this.setPosition(t,n),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},c.prototype.hide=function(e){this.isOpen&&(this.getElement().style.display="none",this.getElement().className=l,this.isOpen=!1)},c.prototype.getHeight=function(){return this.getElement().offsetHeight},c.prototype.getWidth=function(){return this.getElement().offsetWidth},c.prototype.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)},c);function c(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}function h(){this.popups=[]}h.prototype.addPopup=function(e){this.popups.push(e),this.updatePopups()},h.prototype.removePopup=function(e){e=this.popups.indexOf(e);-1!==e&&(this.popups.splice(e,1),this.updatePopups())},h.prototype.updatePopups=function(){this.popups.sort(function(e,t){return t.priority-e.priority});var t,e,n,i,o=[];try{for(var r=u(this.popups),s=r.next();!s.done;s=r.next()){var a=s.value,l=!0;try{n=void 0;for(var c=u(o),h=c.next();!h.done;h=c.next()){var d=h.value;if(this.doPopupsOverlap(d,a)){l=!1;break}}}catch(e){n={error:e}}finally{try{h&&!h.done&&(i=c.return)&&i.call(c)}finally{if(n)throw n.error}}l?o.push(a):a.hide()}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}},h.prototype.doPopupsOverlap=function(e,t){e=e.getElement().getBoundingClientRect(),t=t.getElement().getBoundingClientRect();return e.left<t.right&&e.right>t.left&&e.top<t.bottom&&e.bottom>t.top};var d,g=new h,o=(t.popupManager=g,t.Tooltip=e,o(p,d=e),p.prototype.addToEditor=function(e){e.on("mousemove",this.onMouseMove),e.on("mousedown",this.hide),e.renderer.getMouseEventTarget().addEventListener("mouseout",this.onMouseOut,!0)},p.prototype.removeFromEditor=function(e){e.off("mousemove",this.onMouseMove),e.off("mousedown",this.hide),e.renderer.getMouseEventTarget().removeEventListener("mouseout",this.onMouseOut,!0),this.timeout&&(clearTimeout(this.timeout),this.timeout=null)},p.prototype.onMouseMove=function(e,t){this.lastEvent=e,this.lastT=Date.now();var n,t=t.$mouseHandler.isMousePressed;this.isOpen&&(n=this.lastEvent&&this.lastEvent.getDocumentPosition(),this.range&&this.range.contains(n.row,n.column)&&!t&&!this.isOutsideOfText(this.lastEvent)||this.hide()),this.timeout||t||(this.lastEvent=e,this.timeout=setTimeout(this.waitForHover,this.idleTime))},p.prototype.waitForHover=function(){this.timeout&&clearTimeout(this.timeout);var e=Date.now()-this.lastT;10<this.idleTime-e?this.timeout=setTimeout(this.waitForHover,this.idleTime-e):(this.timeout=null,this.lastEvent&&!this.isOutsideOfText(this.lastEvent)&&this.$gatherData(this.lastEvent,this.lastEvent.editor))},p.prototype.isOutsideOfText=function(e){var t=e.editor,n=e.getDocumentPosition(),i=t.session.getLine(n.row);if(n.column==i.length){i=t.renderer.pixelToScreenCoordinates(e.clientX,e.clientY),e=t.session.documentToScreenPosition(n.row,n.column);if(e.column!=i.column||e.row!=i.row)return!0}return!1},p.prototype.setDataProvider=function(e){this.$gatherData=e},p.prototype.showForRange=function(e,t,n,i){var o,r,s;i&&i!=this.lastEvent||this.isOpen&&document.activeElement==this.getElement()||(i=e.renderer,this.isOpen||(g.addPopup(this),this.$registerCloseEvents(),this.setTheme(i.theme)),this.isOpen=!0,this.addMarker(t,e.session),this.range=a.fromPoints(t.start,t.end),e=i.textToScreenCoordinates(t.start.row,t.start.column),t=i.scroller.getBoundingClientRect(),e.pageX<t.left&&(e.pageX=t.left),(t=this.getElement()).innerHTML="",t.appendChild(n),t.style.maxHeight="",t.style.display="block",n=t.clientHeight,o=t.clientWidth,r=window.innerHeight-e.pageY-i.lineHeight,s=!0,e.pageY-n<0&&e.pageY<r&&(s=!1),t.style.maxHeight=(s?e.pageY:r)-10+"px",t.style.top=s?"":e.pageY+i.lineHeight+"px",t.style.bottom=s?window.innerHeight-e.pageY+"px":"",t.style.left=Math.min(e.pageX,window.innerWidth-o-10)+"px")},p.prototype.addMarker=function(e,t){this.marker&&this.$markerSession.removeMarker(this.marker),this.$markerSession=t,this.marker=t&&t.addMarker(e,"ace_highlight-marker","text")},p.prototype.hide=function(e){!e&&document.activeElement==this.getElement()||e&&e.target&&("keydown"!=e.type||e.ctrlKey||e.metaKey)&&this.$element.contains(e.target)||(this.lastEvent=null,this.timeout&&clearTimeout(this.timeout),this.timeout=null,this.addMarker(null),this.isOpen&&(this.$removeCloseEvents(),this.getElement().style.display="none",this.isOpen=!1,g.removePopup(this)))},p.prototype.$registerCloseEvents=function(){window.addEventListener("keydown",this.hide,!0),window.addEventListener("wheel",this.hide,!0),window.addEventListener("mousedown",this.hide,!0)},p.prototype.$removeCloseEvents=function(){window.removeEventListener("keydown",this.hide,!0),window.removeEventListener("wheel",this.hide,!0),window.removeEventListener("mousedown",this.hide,!0)},p.prototype.onMouseOut=function(e){this.timeout&&(clearTimeout(this.timeout),this.timeout=null),this.lastEvent=null,!this.isOpen||!e.relatedTarget||this.getElement().contains(e.relatedTarget)||e&&e.currentTarget.contains(e.relatedTarget)||e.relatedTarget.classList.contains("ace_content")||this.hide()},p);function p(e){void 0===e&&(e=document.body);var e=d.call(this,e)||this,t=(e.timeout=void 0,e.lastT=0,e.idleTime=350,e.lastEvent=void 0,e.onMouseOut=e.onMouseOut.bind(e),e.onMouseMove=e.onMouseMove.bind(e),e.waitForHover=e.waitForHover.bind(e),e.hide=e.hide.bind(e),e.getElement());return t.style.whiteSpace="pre-wrap",t.style.pointerEvents="auto",t.addEventListener("mouseout",e.onMouseOut),t.tabIndex=-1,t.addEventListener("blur",function(){t.contains(document.activeElement)||this.hide()}.bind(e)),t.addEventListener("wheel",s),e}t.HoverTooltip=o}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/tooltip","ace/config"],function(e,t,n){"use strict";var i,o=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(e,t){e.__proto__=t}:function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}))(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),l=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],i=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return{value:(e=e&&i>=e.length?void 0:e)&&e[i++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")},d=e("../lib/dom"),u=e("../lib/event"),s=e("../tooltip").Tooltip,r=e("../config").nls;t.GutterHandler=function(i){var o,r,s=i.editor,a=s.renderer.$gutterLayer,l=new g(s);function c(){o=o&&clearTimeout(o),l.isOpen&&(l.hideTooltip(),s.off("mousewheel",c))}function h(e){l.setPosition(e.x,e.y)}i.editor.setDefaultHandler("guttermousedown",function(e){if(s.isFocused()&&0==e.getButton()){var t=a.getRegion(e);if("foldWidgets"!=t){var t=e.getDocumentPosition().row,n=s.session.selection;if(e.getShiftKey())n.selectTo(t,0);else{if(2==e.domEvent.detail)return s.selectAll(),e.preventDefault();i.$clickSelection=s.selection.getLineRange(t)}return i.setState("selectByLines"),i.captureMouse(e),e.preventDefault()}}}),i.editor.setDefaultHandler("guttermousemove",function(e){var t=e.domEvent.target||e.domEvent.srcElement;if(d.hasCssClass(t,"ace_fold-widget"))return c();l.isOpen&&i.$tooltipFollowsMouse&&h(e),r=e,o=o||setTimeout(function(){if(o=null,r&&!i.isMousePressed){var e=r.getDocumentPosition().row;if(e==s.session.getLength()){var t=s.renderer.pixelToScreenCoordinates(0,r.y).row,n=r.$pos;if(t>s.session.documentToScreenRow(n.row,n.column))return void c()}l.showTooltip(e),l.isOpen&&(s.on("mousewheel",c),!i.$tooltipFollowsMouse&&(t=r.getGutterRow(),n=a.$lines.get(t))?(e=n.element.querySelector(".ace_gutter_annotation").getBoundingClientRect(),(t=l.getElement().style).left=e.right+"px",t.top=e.bottom+"px"):h(r))}else c()},50)}),u.addListener(s.renderer.$gutter,"mouseout",function(e){r=null,l.isOpen&&(o=o||setTimeout(function(){o=null,c()},50))},s),s.on("changeSession",c),s.on("input",c)};o(p,a=s),p.prototype.setPosition=function(e,t){var n=window.innerWidth||document.documentElement.clientWidth,i=window.innerHeight||document.documentElement.clientHeight,o=this.getWidth(),r=this.getHeight();n<(e+=15)+o&&(e-=e+o-n),i<(t+=15)+r&&(t-=20+r),s.prototype.setPosition.call(this,e,t)},Object.defineProperty(p,"annotationLabels",{get:function(){return{error:{singular:r("error"),plural:r("errors")},warning:{singular:r("warning"),plural:r("warnings")},info:{singular:r("information message"),plural:r("information messages")}}},enumerable:!1,configurable:!0}),p.prototype.showTooltip=function(e){var t=this.editor.renderer.$gutterLayer,n=t.$annotations[e],i=n?{text:Array.from(n.text),type:Array.from(n.type)}:{text:[],type:[]},o=t.session.getFoldLine(e);if(o&&t.$showFoldedAnnotations){for(var r,s={error:[],warning:[],info:[]},a=e+1;a<=o.end.row;a++)if(t.$annotations[a])for(var l=0;l<t.$annotations[a].text.length;l++){var c=t.$annotations[a].type[l];s[c].push(t.$annotations[a].text[l]),"error"===c?r="error_fold":"warning"===c&&(r="warning_fold")}"error_fold"!==r&&"warning_fold"!==r||(n="".concat(p.annotationsToSummaryString(s)," in folded code."),i.text.push(n),i.type.push(r))}if(0===i.text.length)return this.hide();for(var h={error:[],warning:[],info:[]},d=t.$useSvgGutterIcons?"ace_icon_svg":"ace_icon",a=0;a<i.text.length;a++){var u="<span class='ace_".concat(i.type[a]," ").concat(d,"' aria-label='").concat(p.annotationLabels[i.type[a].replace("_fold","")].singular,"' role=img> </span> ").concat(i.text[a]);h[i.type[a].replace("_fold","")].push(u)}e=[].concat(h.error,h.warning,h.info).join("<br>");this.setHtml(e),this.$element.setAttribute("aria-live","polite"),this.isOpen||(this.setTheme(this.editor.renderer.theme),this.setClassName("ace_gutter-tooltip")),this.show(),this.editor._signal("showGutterTooltip",this)},p.prototype.hideTooltip=function(){this.$element.removeAttribute("aria-live"),this.hide(),this.editor._signal("hideGutterTooltip",this)},p.annotationsToSummaryString=function(e){var t,n,i=[];try{for(var o=l(["error","warning","info"]),r=o.next();!r.done;r=o.next()){var s,a=r.value;e[a].length&&(s=1===e[a].length?p.annotationLabels[a].singular:p.annotationLabels[a].plural,i.push("".concat(e[a].length," ").concat(s)))}}catch(e){t={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(t)throw t.error}}return i.join(", ")};var a,g=p;function p(e){var t=a.call(this,e.container)||this;return t.editor=e,t}t.GutterTooltip=g}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,n){"use strict";var i=e("../lib/event"),o=e("../lib/useragent");function r(e,t){this.speed,this.wheelX,this.wheelY,this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1}r.prototype.stopPropagation=function(){i.stopPropagation(this.domEvent),this.propagationStopped=!0},r.prototype.preventDefault=function(){i.preventDefault(this.domEvent),this.defaultPrevented=!0},r.prototype.stop=function(){this.stopPropagation(),this.preventDefault()},r.prototype.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},r.prototype.getGutterRow=function(){var e=this.getDocumentPosition().row;return this.editor.session.documentToScreenRow(e,0)-this.editor.session.documentToScreenRow(this.editor.renderer.$gutterLayer.$lines.get(0).row,0)},r.prototype.inSelection=function(){var e,t;return null===this.$inSelection&&((e=this.editor.getSelectionRange()).isEmpty()?this.$inSelection=!1:(t=this.getDocumentPosition(),this.$inSelection=e.contains(t.row,t.column))),this.$inSelection},r.prototype.getButton=function(){return i.getButton(this.domEvent)},r.prototype.getShiftKey=function(){return this.domEvent.shiftKey},r.prototype.getAccelKey=function(){return o.isMac?this.domEvent.metaKey:this.domEvent.ctrlKey},t.MouseEvent=r}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,n){"use strict";var w=e("../lib/dom"),S=e("../lib/event"),x=e("../lib/useragent");function i(t){var n,c,h,e,i,d,o,r,u,g,p,m=t.editor,s=w.createElement("div"),a=(s.style.cssText="top:-100px;position:absolute;z-index:2147483647;opacity:0.5",s.textContent=" ",["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(e){t[e]=this[e]},this),m.on("mousedown",this.onMouseDown.bind(t)),m.container),l=0;function f(){var e,t,n,i,o,r,s,a,l=d;d=m.renderer.screenToTextCoordinates(c,h),n=d,t=l,i=Date.now(),e=!t||n.row!=t.row,t=!t||n.column!=t.column,!g||e||t?(m.moveCursorToPosition(n),g=i,p={x:c,y:h}):5<k(p.x,p.y,c,h)?g=null:200<=i-g&&(m.renderer.scrollCursorIntoView(),g=null),e=d,t=l,n=Date.now(),i=m.renderer.layerConfig.lineHeight,l=m.renderer.layerConfig.characterWidth,o=m.renderer.scroller.getBoundingClientRect(),o={x:{left:c-o.left,right:o.right-c},y:{top:h-o.top,bottom:o.bottom-h}},r=Math.min(o.x.left,o.x.right),s=Math.min(o.y.top,o.y.bottom),a={row:e.row,column:e.column},r/l<=2&&(a.column+=o.x.left<o.x.right?-3:2),s/i<=1&&(a.row+=o.y.top<o.y.bottom?-1:1),r=e.row!=a.row,l=e.column!=a.column,s=!t||e.row!=t.row,r||l&&!s?u?200<=n-u&&m.renderer.scrollCursorIntoView(a):u=n:u=null}function C(){i=m.selection.toOrientedRange(),n=m.session.addMarker(i,"ace_selection",m.getSelectionStyle()),m.clearSelection(),m.isFocused()&&m.renderer.$cursorLayer.setBlinking(!1),clearInterval(e),f(),e=setInterval(f,20),l=0,S.addListener(document,"mousemove",I)}function y(){clearInterval(e),m.session.removeMarker(n),n=null,m.selection.fromOrientedRange(i),m.isFocused()&&!r&&m.$resetCursorStyle(),l=0,g=u=d=i=null,S.removeListener(document,"mousemove",I)}this.onDragStart=function(e){var t;if(this.cancelDrag||!a.draggable)return t=this,setTimeout(function(){t.startSelect(),t.captureMouse(e)},0),e.preventDefault();i=m.getSelectionRange();var n=e.dataTransfer;n.effectAllowed=m.getReadOnly()?"copy":"copyMove",m.container.appendChild(s),n.setDragImage&&n.setDragImage(s,0,0),setTimeout(function(){m.container.removeChild(s)}),n.clearData(),n.setData("Text",m.session.getTextRange()),r=!0,this.setState("drag")},this.onDragEnd=function(e){a.draggable=!1,r=!1,this.setState(null),m.getReadOnly()||(e=e.dataTransfer.dropEffect,o||"move"!=e||m.session.remove(m.getSelectionRange()),m.$resetCursorStyle()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!m.getReadOnly()&&b(e.dataTransfer))return c=e.clientX,h=e.clientY,n||C(),l++,e.dataTransfer.dropEffect=o=A(e),S.preventDefault(e)},this.onDragOver=function(e){if(!m.getReadOnly()&&b(e.dataTransfer))return c=e.clientX,h=e.clientY,n||(C(),l++),null!==v&&(v=null),e.dataTransfer.dropEffect=o=A(e),S.preventDefault(e)},this.onDragLeave=function(e){if(--l<=0&&n)return y(),o=null,S.preventDefault(e)},this.onDrop=function(e){if(d){var t=e.dataTransfer;if(r)switch(o){case"move":i=i.contains(d.row,d.column)?{start:d,end:d}:m.moveText(i,d);break;case"copy":i=m.moveText(i,d,!0)}else{t=t.getData("Text");i={start:d,end:m.session.insert(d,t)},m.focus(),o=null}return y(),S.preventDefault(e)}},S.addListener(a,"dragstart",this.onDragStart.bind(t),m),S.addListener(a,"dragend",this.onDragEnd.bind(t),m),S.addListener(a,"dragenter",this.onDragEnter.bind(t),m),S.addListener(a,"dragover",this.onDragOver.bind(t),m),S.addListener(a,"dragleave",this.onDragLeave.bind(t),m),S.addListener(a,"drop",this.onDrop.bind(t),m);var v=null;function I(){null==v&&(v=setTimeout(function(){null!=v&&n&&y()},20))}function b(e){e=e.types;return!e||Array.prototype.some.call(e,function(e){return"text/plain"==e||"Text"==e})}function A(e){var t=["copy","copymove","all","uninitialized"],n=x.isMac?e.altKey:e.ctrlKey,i="uninitialized";try{i=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var o="none";return n&&0<=t.indexOf(i)?o="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(i)?o="move":0<=t.indexOf(i)&&(o="copy"),o}}function k(e,t,n,i){return Math.sqrt(Math.pow(n-e,2)+Math.pow(i-t,2))}!function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor,t=(e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging"),x.isWin?"default":"move");e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;x.isIE&&"dragReady"==this.state&&3<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&t.dragDrop(),"dragWait"===this.state&&0<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(e){var t,n,i;this.$dragEnabled&&(this.mousedownEvent=e,t=this.editor,n=e.inSelection(),i=e.getButton(),1!==(e.domEvent.detail||1)||0!==i||!n||e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey())||(this.mousedownEvent.time=Date.now(),"unselectable"in(i=e.domEvent.target||e.domEvent.srcElement)&&(i.unselectable="on"),t.getDragDelay()?(x.isWebKit&&(this.cancelDrag=!0,t.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0))}}.call(i.prototype),t.DragdropHandler=i}),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/event","ace/lib/dom"],function(e,t,n){"use strict";var S=e("./mouse_event").MouseEvent,i=e("../lib/event"),a=e("../lib/dom");t.addTouchListeners=function(e,h){var d,u,g,p,m,t,f,C,r,y="scroll",v=0,I=0,b=0,A=0;function o(){function t(e){var t,n=e.target.getAttribute("action");"more"!=n&&o?("paste"==n?i.readText().then(function(e){h.execCommand(n,e)}):n&&("cut"!=n&&"copy"!=n||(i?i.writeText(h.getCopyText()):document.execCommand("copy")),h.execCommand(n)),r.firstChild.style.display="none",o=!1,"openCommandPalette"!=n&&h.focus()):(o=!o,e=h.getCopyText(),t=h.session.getUndoManager().hasUndo(),r.replaceChild(a.buildDom(o?["span",!e&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],e&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],e&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],i&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],t&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPalette"},"Palette"]]:["span"]),r.firstChild))}var i=window.navigator&&window.navigator.clipboard,o=!1;r=a.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(e){y="menu",e.stopPropagation(),e.preventDefault(),h.textInput.focus()},ontouchend:function(e){e.stopPropagation(),e.preventDefault(),t(e)},onclick:t},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],h.container)}function n(){r||o();var e=h.selection.cursor,e=h.renderer.textToScreenCoordinates(e.row,e.column),t=h.renderer.textToScreenCoordinates(0,0).pageX,n=h.renderer.scrollLeft,i=h.container.getBoundingClientRect();r.style.top=e.pageY-i.top-3+"px",e.pageX-i.left<i.width-70?(r.style.left="",r.style.right="10px"):(r.style.right="",r.style.left=t+n-i.left+"px"),r.style.display="",r.firstChild.style.display="none",h.on("input",s)}function s(e){r&&(r.style.display="none"),h.off("input",s)}function w(){m=null,clearTimeout(m);var e=h.selection.getRange(),t=e.contains(f.row,f.column);!e.isEmpty()&&t||(h.selection.moveToPosition(f),h.selection.selectWord()),y="wait",n()}i.addListener(e,"contextmenu",function(e){C&&h.textInput.getElement().focus()},h),i.addListener(e,"touchstart",function(e){var t=e.touches;if(m||1<t.length)clearTimeout(m),m=null,g=-1,y="zoom";else{C=h.$mouseHandler.isMousePressed=!0;var n=h.renderer.layerConfig.lineHeight,i=h.renderer.layerConfig.lineHeight,o=e.timeStamp,r=(p=o,t[0]),s=r.clientX,r=r.clientY,s=(Math.abs(d-s)+Math.abs(u-r)>n&&(g=-1),d=e.clientX=s,u=e.clientY=r,b=A=0,new S(e,h));if(f=s.getDocumentPosition(),o-g<500&&1==t.length&&!v)I++,e.preventDefault(),e.button=0,m=null,clearTimeout(m),h.selection.moveToPosition(f),(r=2<=I?h.selection.getLineRange(f.row):h.session.getBracketRange(f))&&!r.isEmpty()?h.selection.setRange(r):h.selection.selectWord(),y="wait";else{I=0;var s=h.selection.cursor,t=h.selection.isEmpty()?s:h.selection.anchor,r=h.renderer.$cursorLayer.getPixelPosition(s,!0),s=h.renderer.$cursorLayer.getPixelPosition(t,!0),t=h.renderer.scroller.getBoundingClientRect(),a=h.renderer.layerConfig.offset,l=h.renderer.scrollLeft,c=function(e,t){return(e/=i)*e+(t=t/n-.75)*t};if(e.clientX<t.left)return void(y="zoom");r=c(e.clientX-t.left-r.left+l,e.clientY-t.top-r.top+a),c=c(e.clientX-t.left-s.left+l,e.clientY-t.top-s.top+a);r<3.5&&c<3.5&&(y=c<r?"cursor":"anchor"),y=c<3.5?"anchor":r<3.5?"cursor":"scroll",m=setTimeout(w,450)}g=o}},h),i.addListener(e,"touchend",function(e){C=h.$mouseHandler.isMousePressed=!1,t&&clearInterval(t),"zoom"==y?(y="",v=0):(m?(h.selection.moveToPosition(f),v=0,n):"scroll"==y?(v+=60,t=setInterval(function(){v--<=0&&(clearInterval(t),t=null),Math.abs(b)<.01&&(b=0),Math.abs(A)<.01&&(A=0),v<20&&(b*=.9),v<20&&(A*=.9);var e=h.session.getScrollTop();h.renderer.scrollBy(10*b,10*A),e==h.session.getScrollTop()&&(v=0)},10),s):n)(),clearTimeout(m),m=null},h),i.addListener(e,"touchmove",function(e){m&&(clearTimeout(m),m=null);var t=e.touches;if(!(1<t.length||"zoom"==y)){var t=t[0],n=d-t.clientX,i=u-t.clientY;if("wait"==y){if(!(4<n*n+i*i))return e.preventDefault();y="cursor"}d=t.clientX,u=t.clientY,e.clientX=t.clientX,e.clientY=t.clientY;var t=e.timeStamp,o=t-p;p=t,"scroll"==y?((t=new S(e,h)).speed=1,t.wheelX=n,t.wheelY=i,10*Math.abs(n)<Math.abs(i)&&(n=0),10*Math.abs(i)<Math.abs(n)&&(i=0),0!=o&&(b=n/o,A=i/o),h._emit("mousewheel",t),t.propagationStopped||(b=A=0)):(n=new S(e,h).getDocumentPosition(),"cursor"==y?h.selection.moveCursorToPosition(n):"anchor"==y&&h.selection.setSelectionAnchor(n.row,n.column),h.renderer.scrollCursorIntoView(n),e.preventDefault())}},h)}}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],function(e,t,n){"use strict";var h=e("../lib/event"),d=e("../lib/useragent"),r=e("./default_handlers").DefaultHandlers,s=e("./default_gutter_handler").GutterHandler,u=e("./mouse_event").MouseEvent,a=e("./dragdrop_handler").DragdropHandler,l=e("./touch_handler").addTouchListeners,e=e("../config"),i=(o.prototype.onMouseEvent=function(e,t){this.editor.session&&this.editor._emit(e,new u(t,this.editor))},o.prototype.onMouseMove=function(e,t){var n=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;n&&n.length&&this.editor._emit(e,new u(t,this.editor))},o.prototype.onMouseWheel=function(e,t){var n=new u(t,this.editor);n.speed=2*this.$scrollSpeed,n.wheelX=t.wheelX,n.wheelY=t.wheelY,this.editor._emit(e,n)},o.prototype.setState=function(e){this.state=e},o.prototype.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;function n(e){if(e){if(d.isWebKit&&!e.which&&a.releaseMouse)return a.releaseMouse();a.x=e.clientX,a.y=e.clientY,t&&t(e),a.mouseEvent=new u(e,a.editor),a.$mouseMoved=!0}}function i(e){r.off("beforeEndOperation",l),clearInterval(c),r.session&&o(),a[a.state+"End"]&&a[a.state+"End"](e),a.state="",a.isMousePressed=s.$isMousePressed=!1,s.$keepTextAreaAtCursor&&s.$moveTextAreaToCursor(),a.$onCaptureMouseMove=a.releaseMouse=null,e&&a.onMouseEvent("mouseup",e),r.endOperation()}function o(){a[a.state]&&a[a.state](),a.$mouseMoved=!1}var r=this.editor,s=this.editor.renderer,a=(s.$isMousePressed=!0,this);if(d.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout(function(){i(e)});var l=function(e){a.releaseMouse&&r.curOp.command.name&&r.curOp.selectionChanged&&(a[a.state+"End"]&&a[a.state+"End"](),a.state="",a.releaseMouse())},c=(r.on("beforeEndOperation",l),r.startOperation({command:{name:"mouse"}}),a.$onCaptureMouseMove=n,a.releaseMouse=h.capture(this.editor.container,n,i),setInterval(o,20))},o.prototype.cancelContextMenu=function(){var t=function(e){e&&e.domEvent&&"contextmenu"!=e.domEvent.type||(this.editor.off("nativecontextmenu",t),e&&e.domEvent&&h.stopEvent(e.domEvent))}.bind(this);setTimeout(t,10),this.editor.on("nativecontextmenu",t)},o.prototype.destroy=function(){this.releaseMouse&&this.releaseMouse()},o);function o(i){this.$dragDelay,this.$dragEnabled,this.$mouseMoved,this.mouseEvent,this.$focusTimeout;function e(e){document.hasFocus&&document.hasFocus()&&(i.isFocused()||document.activeElement!=(i.textInput&&i.textInput.getElement()))||window.focus(),i.focus(),setTimeout(function(){i.isFocused()||i.focus()})}var o=this,t=(this.editor=i,new r(this),new s(this),new a(this),i.renderer.getMouseEventTarget()),n=(h.addListener(t,"click",this.onMouseEvent.bind(this,"click"),i),h.addListener(t,"mousemove",this.onMouseMove.bind(this,"mousemove"),i),h.addMultiMouseDownListener([t,i.renderer.scrollBarV&&i.renderer.scrollBarV.inner,i.renderer.scrollBarH&&i.renderer.scrollBarH.inner,i.textInput&&i.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",i),h.addMouseWheelListener(i.container,this.onMouseWheel.bind(this,"mousewheel"),i),l(i.container,i),i.renderer.$gutter);h.addListener(n,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),i),h.addListener(n,"click",this.onMouseEvent.bind(this,"gutterclick"),i),h.addListener(n,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),i),h.addListener(n,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),i),h.addListener(t,"mousedown",e,i),h.addListener(n,"mousedown",e,i),d.isIE&&i.renderer.scrollBarV&&(h.addListener(i.renderer.scrollBarV.element,"mousedown",e,i),h.addListener(i.renderer.scrollBarH.element,"mousedown",e,i)),i.on("mousemove",function(e){var t,n;o.state||o.$dragDelay||!o.$dragEnabled||(e=i.renderer.screenToTextCoordinates(e.x,e.y),t=i.session.selection.getRange(),n=i.renderer,!t.isEmpty()&&t.insideStart(e.row,e.column)?n.setCursorStyle("default"):n.setCursorStyle(""))},i)}i.prototype.releaseMouse=null,e.defineOptions(i.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:d.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=i}),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(e,t,n){"use strict";var i=e("../lib/dom");t.FoldHandler=function(o){o.on("click",function(e){var t=e.getDocumentPosition(),n=o.session,t=n.getFoldAt(t.row,t.column,1),t=(t&&(e.getAccelKey()?n.removeFold(t):n.expandFold(t),e.stop()),e.domEvent&&e.domEvent.target);t&&i.hasCssClass(t,"ace_inline_button")&&i.hasCssClass(t,"ace_toggle_wrap")&&(n.setOption("wrap",!n.getUseWrapMode()),o.renderer.scrollCursorIntoView())}),o.on("gutterclick",function(e){var t,n;"foldWidgets"==o.renderer.$gutterLayer.getRegion(e)&&(t=e.getDocumentPosition().row,(n=o.session).foldWidgets&&n.foldWidgets[t]&&o.session.onFoldWidgetClick(t,e),o.isFocused()||o.focus(),e.stop())}),o.on("gutterdblclick",function(e){var t,n,i;"foldWidgets"==o.renderer.$gutterLayer.getRegion(e)&&(i=e.getDocumentPosition().row,(n=(n=(t=o.session).getParentFoldRangeData(i,!0)).range||n.firstRange)&&(i=n.start.row,(i=t.getFoldAt(i,t.getLine(i).length,1))?t.removeFold(i):(t.addFold("...",n),o.renderer.scrollCursorIntoView({row:n.start.row,column:0}))),e.stop())})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(e,t,n){"use strict";var o=e("../lib/keys"),l=e("../lib/event");function i(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)}i.prototype.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},i.prototype.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},i.prototype.addKeyboardHandler=function(e,t){var n;e&&("function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e),-1!=(n=this.$handlers.indexOf(e))&&this.$handlers.splice(n,1),null==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==n)&&e.attach&&e.attach(this.$editor)},i.prototype.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},i.prototype.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},i.prototype.getStatusText=function(){var t=this.$data,n=t.editor;return this.$handlers.map(function(e){return e.getStatusText&&e.getStatusText(n,t)||""}).filter(Boolean).join(" ")},i.prototype.$callKeyboardHandlers=function(e,t,n,i){for(var o,r=!1,s=this.$editor.commands,a=this.$handlers.length;a--&&!((o=this.$handlers[a].handleKeyboard(this.$data,e,t,n,i))&&o.command&&((r="null"==o.command||s.exec(o.command,this.$editor,o.args,i))&&i&&-1!=e&&1!=o.passEvent&&1!=o.command.passEvent&&l.stopEvent(i),r)););return r||-1!=e||(o={command:"insertstring"},r=s.exec("insertstring",this.$editor,t)),r&&this.$editor._signal&&this.$editor._signal("keyboardActivity",o),r},i.prototype.onCommandKey=function(e,t,n){var i=o.keyCodeToString(n);return this.$callKeyboardHandlers(t,i,n,e)},i.prototype.onTextInput=function(e){return this.$callKeyboardHandlers(-1,e)},t.KeyBinding=i}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(e,l,t){"use strict";var p=0,m=0,f=!1,C=!1,y=!1,v=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],I=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],b=0,A=1,w=2,S=3,x=4,k=5,E=6,T=7,R=8,_=9,$=10,L=11,N=12,M=13,B=14,W=15,P=16,H=17,G=18,i=[G,G,G,G,G,G,G,G,G,E,k,E,R,k,G,G,G,G,G,G,G,G,G,G,G,G,G,G,k,k,k,E,R,x,x,L,L,L,x,x,x,x,x,$,_,$,_,_,w,w,w,w,w,w,w,w,w,w,_,x,x,x,x,x,x,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x,x,x,x,x,x,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x,x,x,x,G,G,G,G,G,G,k,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,G,_,x,L,L,L,L,x,x,x,x,b,x,x,G,x,x,L,L,w,w,x,b,x,x,x,w,b,x,x,x,x,x],o=[R,R,R,R,R,R,R,R,R,R,R,G,G,G,b,A,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,R,k,M,B,W,P,H,_,L,L,L,L,L,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,_,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,R];function c(e,t,n,i){var o,r,s,a=p?I:v,l=0,c=-1,h=null,d=null,u=[];if(!i)for(h=0,i=[];h<n;h++)i[h]=F(e[h]);for(m=p,y=C=f=!1,d=0;d<n;d++){if(s=l,u[d]=o=function(e,t,n,i){var o,r,s,a=t[i];switch(a){case b:case A:f=!1;case x:case S:return a;case w:return f?S:w;case T:return f=!0,A;case R:return x;case _:return i<1||i+1>=t.length||(o=n[i-1])!=w&&o!=S||(l=t[i+1])!=w&&l!=S?x:(l=f?S:l)==o?l:x;case $:return(o=0<i?n[i-1]:k)==w&&i+1<t.length&&t[i+1]==w?w:x;case L:if(0<i&&n[i-1]==w)return w;if(f)return x;for(s=i+1,r=t.length;s<r&&t[s]==L;)s++;return s<r&&t[s]==w?w:x;case N:for(r=t.length,s=i+1;s<r&&t[s]==N;)s++;if(s<r){var l=e[i],l=1425<=l&&l<=2303||64286==l;if(o=t[s],l&&(o==A||o==T))return A}return i<1||(o=t[i-1])==k?x:n[i-1];case k:return C=!(f=!1),p;case E:return y=!0,x;case M:case B:case P:case H:case W:f=!1;case G:return x}}(e,i,u,d),s=240&(l=a[s][o]),l&=15,t[d]=r=a[l][5],0<s){if(16==s)for(h=c;h<d;h++)t[h]=1;c=-1}if(a[l][6])-1==c&&(c=d);else if(-1<c){for(h=c;h<d;h++)t[h]=r;c=-1}i[d]==k&&(t[d]=0),m|=r}if(y)for(h=0;h<n;h++)if(i[h]==E){t[h]=p;for(var g=h-1;0<=g&&i[g]==R;g--)t[g]=p}}function h(e,t,n){if(!(m<e))if(1!=e||1!=p||C)for(var i,o,r,s,a=n.length,l=0;l<a;){if(t[l]>=e){for(i=l+1;i<a&&t[i]>=e;)i++;for(o=l,r=i-1;o<r;o++,r--)s=n[o],n[o]=n[r],n[r]=s;l=i}l++}else n.reverse()}function F(e){var t=e.charCodeAt(0),n=t>>8;return 0==n?191<t?b:i[t]:5==n?/[\u0591-\u05f4]/.test(e)?A:b:6==n?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?N:/[\u0660-\u0669\u066b-\u066c]/.test(e)?S:1642==t?L:/[\u06f0-\u06f9]/.test(e)?w:T:32==n&&t<=8287?o[255&t]:254==n&&65136<=t?T:x}l.L=b,l.R=A,l.EN=w,l.ON_R=3,l.AN=4,l.R_H=5,l.B=6,l.RLE=7,l.DOT="·",l.doBidiReorder=function(e,t,n){if(e.length<2)return{};var i=e.split(""),o=new Array(i.length),r=new Array(i.length),s=[];p=n?1:0,c(i,s,i.length,t);for(var a=0;a<o.length;o[a]=a,a++);h(2,s,o),h(1,s,o);for(a=0;a<o.length-1;a++)t[a]===S?s[a]=l.AN:s[a]===A&&(t[a]>T&&t[a]<M||t[a]===x||t[a]===G)?s[a]=l.ON_R:0<a&&"ل"===i[a-1]&&/\u0622|\u0623|\u0625|\u0627/.test(i[a])&&(s[a-1]=s[a]=l.R_H,a++);i[i.length-1]===l.DOT&&(s[i.length-1]=l.B),"‫"===i[0]&&(s[0]=l.RLE);for(a=0;a<o.length;a++)r[a]=s[o[a]];return{logicalFromVisual:o,bidiLevels:r}},l.hasBidiCharacters=function(e,t){for(var n=!1,i=0;i<e.length;i++)t[i]=F(e.charAt(i)),n||t[i]!=A&&t[i]!=T&&t[i]!=S||(n=!0);return n},l.getVisualFromLogicalIdx=function(e,t){for(var n=0;n<t.logicalFromVisual.length;n++)if(t.logicalFromVisual[n]==e)return n;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(e,t,n){"use strict";var a=e("./lib/bidiutil"),s=e("./lib/lang"),i=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;function o(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=a,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="¶",this.RLE="‫",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=i.test(e.getValue())}o.prototype.isBidiRow=function(e,t,n){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,n),this.updateBidiMap()),this.bidiMap.bidiLevels)},o.prototype.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&i.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},o.prototype.getDocumentRow=function(){var e=0,t=this.session.$screenRowCache;return e=t.length&&0<=(t=this.session.$getRowCacheIndex(t,this.currentRow))?this.session.$docRowCache[t]:e},o.prototype.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var n,i=this.session.$getRowCacheIndex(t,this.currentRow);0<this.currentRow-e&&(n=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===i;)i=n,e++;else e=this.currentRow;return e},o.prototype.updateRowLine=function(e,t){var n,i=(e=void 0===e?this.getDocumentRow():e)===this.session.getLength()-1?this.EOF:this.EOL,o=(this.wrapIndent=0,this.line=this.session.getLine(e),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,(!this.session.$useWrapMode||(e=this.session.$wrapData[e])&&(0<(t=void 0===t?this.getSplitIndex():t)&&e.length?(this.wrapIndent=e.indent,this.wrapOffset=this.wrapIndent*this.charWidths[a.L],this.line=t<e.length?this.line.substring(e[t-1],e[t]):this.line.substring(e[e.length-1])):this.line=this.line.substring(0,e[t]),t==e.length))&&(this.line+=this.showInvisibles?i:a.DOT),this.session),r=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(e,t){return"\t"===e||o.isFullWidth(e.charCodeAt(0))?(n="\t"===e?o.getScreenTabSize(t+r):2,r+=n-1,s.stringRepeat(a.DOT,n)):e}),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==a.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},o.prototype.updateBidiMap=function(){var e=[];a.hasBidiCharacters(this.line,e)||this.isRtlDir?this.bidiMap=a.doBidiReorder(this.line,e,this.isRtlDir):this.bidiMap={}},o.prototype.markAsDirty=function(){this.currentRow=null},o.prototype.updateCharacterWidths=function(e){var t;this.characterWidth!==e.$characterSize.width&&(this.fontMetrics=e,t=this.characterWidth=e.$characterSize.width,e=e.$measureCharWidth("ה"),this.charWidths[a.L]=this.charWidths[a.EN]=this.charWidths[a.ON_R]=t,this.charWidths[a.R]=this.charWidths[a.AN]=e,this.charWidths[a.R_H]=.45*e,this.charWidths[a.B]=this.charWidths[a.RLE]=0,this.currentRow=null)},o.prototype.setShowInvisibles=function(e){this.showInvisibles=e,this.currentRow=null},o.prototype.setEolChar=function(e){this.EOL=e},o.prototype.setContentWidth=function(e){this.contentWidth=e},o.prototype.isRtlLine=function(e){return!!this.$isRtl||(null!=e?this.session.getLine(e).charAt(0)==this.RLE:this.isRtlDir)},o.prototype.setRtlDirection=function(e,t){for(var n=e.getCursorPosition(),i=e.selection.getSelectionAnchor().row;i<=n.row;i++)t||e.session.getLine(i).charAt(0)!==e.session.$bidiHandler.RLE?t&&e.session.getLine(i).charAt(0)!==e.session.$bidiHandler.RLE&&e.session.doc.insert({column:0,row:i},e.session.$bidiHandler.RLE):e.session.doc.removeInLine(i,0,1)},o.prototype.getPosLeft=function(e){e-=this.wrapIndent;var t=this.line.charAt(0)===this.RLE?1:0,n=t<e?this.session.getOverwrite()?e:e-1:t,i=a.getVisualFromLogicalIdx(n,this.bidiMap),o=this.bidiMap.bidiLevels,r=0;!this.session.getOverwrite()&&e<=t&&o[i]%2!=0&&i++;for(var s=0;s<i;s++)r+=this.charWidths[o[s]];return!this.session.getOverwrite()&&t<e&&o[i]%2==0&&(r+=this.charWidths[o[i]]),this.wrapIndent&&(r+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(r+=this.rtlLineOffset),r},o.prototype.getSelections=function(e,t){var n,i=this.bidiMap,o=i.bidiLevels,r=[],s=0,a=Math.min(e,t)-this.wrapIndent,l=Math.max(e,t)-this.wrapIndent,c=!1,h=!1,d=0;this.wrapIndent&&(s+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var u,g=0;g<o.length;g++)u=i.logicalFromVisual[g],n=o[g],(c=a<=u&&u<l)&&!h?d=s:!c&&h&&r.push({left:d,width:s-d}),s+=this.charWidths[n],h=c;if(c&&g===o.length&&r.push({left:d,width:s-d}),this.isRtlDir)for(var p=0;p<r.length;p++)r[p].left+=this.rtlLineOffset;return r},o.prototype.offsetToCol=function(e){this.isRtlDir&&(e-=this.rtlLineOffset);var t=0,e=Math.max(e,0),n=0,i=0,o=this.bidiMap.bidiLevels,r=this.charWidths[o[i]];for(this.wrapIndent&&(e-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);n+r/2<e;){if(n+=r,i===o.length-1){r=0;break}r=this.charWidths[o[++i]]}return 0===(t=0<i&&o[i-1]%2!=0&&o[i]%2==0?(e<n&&i--,this.bidiMap.logicalFromVisual[i]):0<i&&o[i-1]%2==0&&o[i]%2!=0?1+(n<e?this.bidiMap.logicalFromVisual[i]:this.bidiMap.logicalFromVisual[i-1]):this.isRtlDir&&i===o.length-1&&0===r&&o[i-1]%2==0||!this.isRtlDir&&0===i&&o[i]%2!=0?1+this.bidiMap.logicalFromVisual[i]:(0<i&&o[i-1]%2!=0&&0!==r&&i--,this.bidiMap.logicalFromVisual[i]))&&this.isRtlDir&&t++,t+this.wrapIndent},t.BidiHandler=o}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(e,t,n){"use strict";var i=e("./lib/oop"),o=e("./lib/lang"),r=e("./lib/event_emitter").EventEmitter,s=e("./range").Range,e=(a.prototype.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},a.prototype.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},a.prototype.getCursor=function(){return this.lead.getPosition()},a.prototype.setAnchor=function(e,t){this.$isEmpty=!1,this.anchor.setPosition(e,t)},a.prototype.getAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},a.prototype.getSelectionLead=function(){return this.lead.getPosition()},a.prototype.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},a.prototype.getRange=function(){var e=this.anchor,t=this.lead;return this.$isEmpty?s.fromPoints(t,t):this.isBackwards()?s.fromPoints(t,e):s.fromPoints(e,t)},a.prototype.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},a.prototype.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},a.prototype.setRange=function(e,t){var n=t?e.end:e.start,t=t?e.start:e.end;this.$setSelection(n.row,n.column,t.row,t.column)},a.prototype.$setSelection=function(e,t,n,i){var o,r;!this.$silent&&(o=this.$isEmpty,r=this.inMultiSelectMode,this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(e,t),this.cursor.setPosition(n,i),this.$isEmpty=!s.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),this.$cursorChanged||this.$anchorChanged||o!=this.$isEmpty||r)&&this._emit("changeSelection")},a.prototype.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},a.prototype.selectTo=function(e,t){this.$moveSelection(function(){this.moveCursorTo(e,t)})},a.prototype.selectToPosition=function(e){this.$moveSelection(function(){this.moveCursorToPosition(e)})},a.prototype.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},a.prototype.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},a.prototype.selectUp=function(){
this.$moveSelection(this.moveCursorUp)},a.prototype.selectDown=function(){this.$moveSelection(this.moveCursorDown)},a.prototype.selectRight=function(){this.$moveSelection(this.moveCursorRight)},a.prototype.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},a.prototype.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},a.prototype.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},a.prototype.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},a.prototype.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},a.prototype.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},a.prototype.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},a.prototype.getWordRange=function(e,t){var n;return void 0===t&&(e=(n=e||this.lead).row,t=n.column),this.session.getWordRange(e,t)},a.prototype.selectWord=function(){this.setSelectionRange(this.getWordRange())},a.prototype.selectAWord=function(){var e=this.getCursor(),e=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(e)},a.prototype.getLineRange=function(e,t){var e="number"==typeof e?e:this.lead.row,n=this.session.getFoldLine(e),n=n?(e=n.start.row,n.end.row):e;return!0===t?new s(e,0,n,this.session.getLine(n).length):new s(e,0,n+1,0)},a.prototype.selectLine=function(){this.setSelectionRange(this.getLineRange())},a.prototype.moveCursorUp=function(){this.moveCursorBy(-1,0)},a.prototype.moveCursorDown=function(){this.moveCursorBy(1,0)},a.prototype.wouldMoveIntoSoftTab=function(e,t,n){var i=e.column,o=e.column+t;return n<0&&(i=e.column-t,o=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(i,o).split(" ").length-1==t},a.prototype.moveCursorLeft=function(){var e,t=this.lead.getPosition();(e=this.session.getFoldAt(t.row,t.column,-1))?this.moveCursorTo(e.start.row,e.start.column):0===t.column?0<t.row&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length):(e=this.session.getTabSize(),this.wouldMoveIntoSoftTab(t,e,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-e):this.moveCursorBy(0,-1))},a.prototype.moveCursorRight=function(){var e,t=this.lead.getPosition();(e=this.session.getFoldAt(t.row,t.column,1))?this.moveCursorTo(e.end.row,e.end.column):this.lead.column==this.doc.getLine(this.lead.row).length?this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0):(e=this.session.getTabSize(),t=this.lead,this.wouldMoveIntoSoftTab(t,e,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,e):this.moveCursorBy(0,1))},a.prototype.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,n=this.session.documentToScreenRow(e,t),n=this.session.screenToDocumentPosition(n,0),e=this.session.getDisplayLine(e,null,n.row,n.column).match(/^\s*/);e[0].length==t||this.session.$useEmacsStyleLineStart||(n.column+=e[0].length),this.moveCursorToPosition(n)},a.prototype.moveCursorLineEnd=function(){var e,t=this.lead,t=this.session.getDocumentLastRowColumnPosition(t.row,t.column);this.lead.column==t.column&&(e=this.session.getLine(t.row),t.column==e.length)&&0<(e=e.search(/\s+$/))&&(t.column=e),this.moveCursorTo(t.row,t.column)},a.prototype.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},a.prototype.moveCursorFileStart=function(){this.moveCursorTo(0,0)},a.prototype.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,n=this.doc.getLine(e),i=n.substring(t),o=(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.getFoldAt(e,t,1));o?this.moveCursorTo(o.end.row,o.end.column):(this.session.nonTokenRe.exec(i)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,i=n.substring(t)),t>=n.length?(this.moveCursorTo(e,n.length),this.moveCursorRight(),e<this.doc.getLength()-1&&this.moveCursorWordRight()):(this.session.tokenRe.exec(i)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)))},a.prototype.moveCursorLongWordLeft=function(){var e,t=this.lead.row,n=this.lead.column;(e=this.session.getFoldAt(t,n,-1))?this.moveCursorTo(e.start.row,e.start.column):(null==(e=this.session.getFoldStringAt(t,n,-1))&&(e=this.doc.getLine(t).substring(0,n)),e=o.stringReverse(e),this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(e)&&(n-=this.session.nonTokenRe.lastIndex,e=e.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),n<=0?(this.moveCursorTo(t,0),this.moveCursorLeft(),0<t&&this.moveCursorWordLeft()):(this.session.tokenRe.exec(e)&&(n-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,n)))},a.prototype.$shortWordEndIndex=function(e){var t,n=0,i=/\s/,o=this.session.tokenRe;if(o.lastIndex=0,this.session.tokenRe.exec(e))n=this.session.tokenRe.lastIndex;else{for(;(t=e[n])&&i.test(t);)n++;if(n<1)for(o.lastIndex=0;(t=e[n])&&!o.test(t);)if(o.lastIndex=0,n++,i.test(t)){if(2<n){n--;break}for(;(t=e[n])&&i.test(t);)n++;if(2<n)break}}return o.lastIndex=0,n},a.prototype.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,n=this.doc.getLine(e),i=n.substring(t),o=this.session.getFoldAt(e,t,1);if(o)return this.moveCursorTo(o.end.row,o.end.column);if(t==n.length){for(var r=this.doc.getLength();i=this.doc.getLine(++e),e<r&&/^\s*$/.test(i););/^\s+/.test(i)||(i=""),t=0}o=this.$shortWordEndIndex(i);this.moveCursorTo(e,t+o)},a.prototype.moveCursorShortWordLeft=function(){var e=this.lead.row,t=this.lead.column;if(i=this.session.getFoldAt(e,t,-1))return this.moveCursorTo(i.start.row,i.start.column);var n=this.session.getLine(e).substring(0,t);if(0===t){for(;n=this.doc.getLine(--e),0<e&&/^\s*$/.test(n););t=n.length,/\s+$/.test(n)||(n="")}var i=o.stringReverse(n),i=this.$shortWordEndIndex(i);return this.moveCursorTo(e,t-i)},a.prototype.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},a.prototype.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},a.prototype.moveCursorBy=function(e,t){var n,i=this.session.documentToScreenPosition(this.lead.row,this.lead.column),o=(0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(i.row,this.lead.row)?(n=this.session.$bidiHandler.getPosLeft(i.column),i.column=Math.round(n/this.session.$bidiHandler.charWidths[0])):n=i.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?i.column=this.$desiredColumn:this.$desiredColumn=i.column),0!=e&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]&&(o=this.session.lineWidgets[this.lead.row],e<0?e-=o.rowsAbove||0:0<e&&(e+=o.rowCount-(o.rowsAbove||0))),this.session.screenToDocumentPosition(i.row+e,i.column,n));0!==e&&0===t&&o.row===this.lead.row&&(o.column,this.lead.column),this.moveCursorTo(o.row,o.column+t,0===t)},a.prototype.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},a.prototype.moveCursorTo=function(e,t,n){var i=this.session.getFoldAt(e,t,1),i=(i&&(e=i.start.row,t=i.start.column),this.$keepDesiredColumnOnChange=!0,this.session.getLine(e));/[\uDC00-\uDFFF]/.test(i.charAt(t))&&i.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,n||(this.$desiredColumn=null)},a.prototype.moveCursorToScreen=function(e,t,n){e=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(e.row,e.column,n)},a.prototype.detach=function(){this.lead.detach(),this.anchor.detach()},a.prototype.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},a.prototype.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},a.prototype.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var n=this.getCursor();return s.fromPoints(t,n)}catch(e){return s.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},a.prototype.toJSON=function(){var e;return this.rangeCount?e=this.ranges.map(function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t}):(e=this.getRange()).isBackwards=this.isBackwards(),e},a.prototype.fromJSON=function(e){if(null==e.start){if(this.rangeList&&1<e.length){this.toSingleRange(e[0]);for(var t=e.length;t--;){var n=s.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(n.cursor=n.start),this.addRange(n,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},a.prototype.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0},a);function a(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var t=this;this.cursor.on("change",function(e){t.$cursorChanged=!0,t.$silent||t._emit("changeCursor"),t.$isEmpty||t.$silent||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.anchor.on("change",function(){t.$anchorChanged=!0,t.$isEmpty||t.$silent||t._emit("changeSelection")})}e.prototype.setSelectionAnchor=e.prototype.setAnchor,e.prototype.getSelectionAnchor=e.prototype.getAnchor,e.prototype.setSelectionRange=e.prototype.setRange,i.implement(e.prototype,r),t.Selection=e}),ace.define("ace/tokenizer",["require","exports","module","ace/lib/report_error"],function(e,t,n){"use strict";var e=e("./lib/report_error").reportError,y=2e3,i=(o.prototype.$setMaxTokenCount=function(e){y=0|e},o.prototype.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),n=this.token.apply(this,t);if("string"==typeof n)return[{type:n,value:e}];for(var i=[],o=0,r=n.length;o<r;o++)t[o]&&(i[i.length]={type:n[o],value:t[o]});return i},o.prototype.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var n=[],i=this.tokenArray,o=0,r=i.length;o<r;o++)t[o+1]&&(n[n.length]={type:i[o],value:t[o+1]});return n},o.prototype.removeCapturingGroups=function(e){return e.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!<]|(\()/g,function(e,t){return t?"(?:":e})},o.prototype.createSplitterRegexp=function(e,t){var s,a,l;return"$"!=(e="^"!=(e=-1!=e.indexOf("(?=")&&(s=0,a=!1,l={},e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(e,t,n,i,o,r){return a?a="]"!=o:o?a=!0:i?(s==l.stack&&(l.end=r+1,l.stack=-1),s--):n&&(s++,1!=n.length)&&(l.stack=s,l.start=r),e}),null!=l.end)&&/^\)*$/.test(e.substr(l.end))?e.substring(0,l.start)+e.substr(l.end):e).charAt(0)?"^"+e:e).charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},o.prototype.getLineTokens=function(e,t){t&&"string"!=typeof t?"#tmp"===(t=(n=t.slice(0))[0])&&(n.shift(),t=n.shift()):n=[];for(var n,i,o=t||"start",r=(r=this.states[o])||this.states[o="start"],s=this.matchMappings[o],a=this.regExps[o],l=[],c=a.lastIndex=0,h=0,d={type:null,value:""};i=a.exec(e);){var u,g=s.defaultToken,p=null,m=i[0],f=a.lastIndex;f-m.length>c&&(u=e.substring(c,f-m.length),d.type==g?d.value+=u:(d.type&&l.push(d),d={type:g,value:u}));for(var C=0;C<i.length-2;C++)if(void 0!==i[C+1]){g=(p=r[s[C]]).onMatch?p.onMatch(m,o,n,e):p.token,p.next&&(o="string"==typeof p.next?p.next:p.next(o,n),(r=this.states[o])||(this.reportError("state doesn't exist",o),r=this.states[o="start"]),s=this.matchMappings[o],(a=this.regExps[o]).lastIndex=c=f),p.consumeLineEnd&&(c=f);break}if(m)if("string"==typeof g)p&&!1===p.merge||d.type!==g?(d.type&&l.push(d),d={type:g,value:m}):d.value+=m;else if(g){d.type&&l.push(d);for(d={type:null,value:""},C=0;C<g.length;C++)l.push(g[C])}if(c==e.length)break;if(c=f,h++>y){for(h>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});c<e.length;)d.type&&l.push(d),d={value:e.substring(c,c+=500),type:"overflow"};o="start",n=[];break}}return d.type&&l.push(d),1<n.length&&n[0]!==o&&n.unshift("#tmp",o),{tokens:l,state:n.length?n:o}},o);function o(e){for(var t in this.splitRegex,this.states=e,this.regExps={},this.matchMappings={},this.states){for(var n=this.states[t],i=[],o=0,r=this.matchMappings[t]={defaultToken:"text"},s="g",a=[],l=0;l<n.length;l++){var c,h,d=n[l];d.defaultToken&&(r.defaultToken=d.defaultToken),d.caseInsensitive&&-1===s.indexOf("i")&&(s+="i"),d.unicode&&-1===s.indexOf("u")&&(s+="u"),null==d.regex||(d.regex instanceof RegExp&&(d.regex=d.regex.toString().slice(1,-1)),c=d.regex,h=new RegExp("(?:("+c+")|(.))").exec("a").length-2,Array.isArray(d.token)?1==d.token.length||1==h?d.token=d.token[0]:h-1!=d.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:d,groupCount:h-1}),d.token=d.token[0]):(d.tokenArray=d.token,d.token=null,d.onMatch=this.$arrayTokens):"function"!=typeof d.token||d.onMatch||(d.onMatch=1<h?this.$applyToken:d.token),1<h&&(c=/\\\d/.test(d.regex)?d.regex.replace(/\\([0-9]+)/g,function(e,t){return"\\"+(parseInt(t,10)+o+1)}):(h=1,this.removeCapturingGroups(d.regex)),d.splitRegex||"string"==typeof d.token||a.push(d)),r[o]=l,o+=h,i.push(c),d.onMatch)||(d.onMatch=null)}i.length||(r[0]=0,i.push("$")),a.forEach(function(e){e.splitRegex=this.createSplitterRegexp(e.regex,s)},this),this.regExps[t]=new RegExp("("+i.join(")|(")+")|($)",s)}}i.prototype.reportError=e,t.Tokenizer=i}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/deep_copy"],function(e,t,n){"use strict";var l=e("../lib/deep_copy").deepCopy,e=function(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}};!function(){this.addRules=function(e,t){if(t)for(var n in e){for(var i=e[n],o=0;o<i.length;o++){var r=i[o];(r.next||r.onMatch)&&("string"==typeof r.next&&0!==r.next.indexOf(t)&&(r.next=t+r.next),r.nextState)&&0!==r.nextState.indexOf(t)&&(r.nextState=t+r.nextState)}this.$rules[t+n]=i}else for(var n in e)this.$rules[n]=e[n]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,n,i,o){e="function"==typeof e?(new e).getRules():e;if(i)for(var r=0;r<i.length;r++)i[r]=t+i[r];else for(var s in i=[],e)i.push(t+s);if(this.addRules(e,t),n)for(var a=Array.prototype[o?"push":"unshift"],r=0;r<i.length;r++)a.apply(this.$rules[i[r]],l(n));this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};function d(e,t){return"start"==e&&!t.length||t.unshift(this.nextState,e),this.nextState}function u(e,t){return t.shift(),t.shift()||"start"}this.normalizeRules=function(){var c=0,h=this.$rules;Object.keys(h).forEach(function e(t){var n=h[t];n.processed=!0;for(var i=0;i<n.length;i++){var o=n[i],r=null,s=(Array.isArray(o)&&(r=o,o={}),!o.regex&&o.start&&(o.regex=o.start,o.next||(o.next=[]),o.next.push({defaultToken:o.token},{token:o.token+".end",regex:o.end||o.start,next:"pop"}),o.token=o.token+".start",o.push=!0),o.next||o.push);if(s&&Array.isArray(s)?((l=o.stateName)||("string"!=typeof(l=o.token)&&(l=l[0]||""),h[l]&&(l+=c++)),h[l]=s,e(o.next=l)):"pop"==s&&(o.next=u),o.push&&(o.nextState=o.next||o.push,o.next=d,delete o.push),o.rules)for(var a in o.rules)h[a]?h[a].push&&h[a].push.apply(h[a],o.rules[a]):h[a]=o.rules[a];var l="string"==typeof o?o:o.include;l&&("$self"===l&&(l="start"),r=Array.isArray(l)?l.map(function(e){return h[e]}):h[l]),r&&(s=[i,1].concat(r),o.noEscape&&(s=s.filter(function(e){return!e.next})),n.splice.apply(n,s),i--),o.keywordMap&&(o.token=this.createKeywordMapper(o.keywordMap,o.defaultToken||"text",o.caseInsensitive),delete o.defaultToken)}},this)},this.createKeywordMapper=function(o,t,r,s){var a=Object.create(null);return this.$keywordList=[],Object.keys(o).forEach(function(e){for(var t=o[e].split(s||"|"),n=t.length;n--;){var i=t[n];this.$keywordList.push(i),r&&(i=i.toLowerCase()),a[i]=e}},this),o=null,r?function(e){return a[e.toLowerCase()]||t}:function(e){return a[e]||t}},this.getKeywords=function(){return this.$keywords}}.call(e.prototype),t.TextHighlightRules=e}),ace.define("ace/mode/behaviour",["require","exports","module"],function(e,t,n){"use strict";var i=function(){this.$behaviours={}};!function(){this.add=function(e,t,n){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=n},this.addBehaviours=function(e){for(var t in e)for(var n in e[t])this.add(t,n,e[t][n])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){e=("function"==typeof e?new e:e).getBehaviours(t),this.addBehaviours(e)},this.getBehaviours=function(e){if(e){for(var t={},n=0;n<e.length;n++)this.$behaviours[e[n]]&&(t[e[n]]=this.$behaviours[e[n]]);return t}return this.$behaviours}}.call(i.prototype),t.Behaviour=i}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(e,t,n){"use strict";var i=e("./range").Range;function o(e,t,n){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);e=e.getTokenAt(t,n);this.$tokenIndex=e?e.index:-1}o.prototype.stepBackward=function(){for(--this.$tokenIndex;this.$tokenIndex<0;){if(--this.$row,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},o.prototype.stepForward=function(){var e;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e=e||this.$session.getLength(),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},o.prototype.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},o.prototype.getCurrentTokenRow=function(){return this.$row},o.prototype.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,n=e[t].start;if(void 0===n)for(n=0;0<t;)n+=e[--t].value.length;return n},o.prototype.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},o.prototype.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new i(this.$row,t,this.$row,t+e.value.length)},t.TokenIterator=o}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t,n){"use strict";function u(e){var t=-1;if((l=e.multiSelect&&(t=e.selection.index,l.rangeCount!=e.multiSelect.rangeCount)?{rangeCount:e.multiSelect.rangeCount}:l)[t])return p=l[t];p=l[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function g(e,t,n,i){var o=e.end.row-e.start.row;return{text:n+t+i,selection:[0,e.start.column+1,o,e.end.column+(o?0:1)]}}var p,i=e("../../lib/oop"),o=e("../behaviour").Behaviour,r=e("../../token_iterator").TokenIterator,m=e("../../lib/lang"),s=["text","paren.rparen","rparen","paren","punctuation.operator"],a=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],l={},f={'"':'"',"'":"'"},C=function(d){d=d||{},this.add("braces","insertion",function(e,t,n,i,o){var r=n.getCursorPosition(),s=i.doc.getLine(r.row);if("{"==o)return u(n),l=n.getSelectionRange(),""!==(c=i.doc.getTextRange(l))&&"{"!==c&&n.getWrapBehavioursEnabled()?g(l,c,"{","}"):C.isSaneInsertion(n,i)?/[\]\}\)]/.test(s[r.column])||n.inMultiSelectMode||d.braces?(C.recordAutoInsert(n,i,"}"),{text:"{}",selection:[1,1]}):(C.recordMaybeInsert(n,i,"{"),{text:"{",selection:[1,1]}):void 0;if("}"==o){u(n);var a=s.substring(r.column,r.column+1);if("}"==a)if(null!==i.$findOpeningBracket("}",{column:r.column+1,row:r.row})&&C.isAutoInsertedClosing(r,s,o))return C.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==o||"\r\n"==o){u(n);var l="";if(C.isMaybeInsertedClosing(r,s)&&(l=m.stringRepeat("}",p.maybeInsertedBrackets),C.clearMaybeInsertedClosing()),"}"===(a=s.substring(r.column,r.column+1))){var c=i.findMatchingBracket({row:r.row,column:r.column+1},"}");if(!c)return null;var h=this.$getIndent(i.getLine(c.row))}else{if(!l)return void C.clearMaybeInsertedClosing();h=this.$getIndent(s)}o=h+i.getTabString();return{text:"\n"+o+"\n"+h+l,selection:[1,o.length,1,o.length]}}C.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,n,i,o){var r=i.doc.getTextRange(o);if(!o.isMultiLine()&&"{"==r){if(u(n),"}"==i.doc.getLine(o.start.row).substring(o.end.column,o.end.column+1))return o.end.column++,o;p.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,n,i,o){if("("==o)return u(n),r=n.getSelectionRange(),""!==(s=i.doc.getTextRange(r))&&n.getWrapBehavioursEnabled()?g(r,s,"(",")"):C.isSaneInsertion(n,i)?(C.recordAutoInsert(n,i,")"),{text:"()",selection:[1,1]}):void 0;if(")"==o){u(n);var r=n.getCursorPosition(),s=i.doc.getLine(r.row),n=s.substring(r.column,r.column+1);if(")"==n)if(null!==i.$findOpeningBracket(")",{column:r.column+1,row:r.row})&&C.isAutoInsertedClosing(r,s,o))return C.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(e,t,n,i,o){var r=i.doc.getTextRange(o);if(!o.isMultiLine()&&"("==r&&(u(n),")"==i.doc.getLine(o.start.row).substring(o.start.column+1,o.start.column+2)))return o.end.column++,o}),this.add("brackets","insertion",function(e,t,n,i,o){if("["==o)return u(n),r=n.getSelectionRange(),""!==(s=i.doc.getTextRange(r))&&n.getWrapBehavioursEnabled()?g(r,s,"[","]"):C.isSaneInsertion(n,i)?(C.recordAutoInsert(n,i,"]"),{text:"[]",selection:[1,1]}):void 0;if("]"==o){u(n);var r=n.getCursorPosition(),s=i.doc.getLine(r.row),n=s.substring(r.column,r.column+1);if("]"==n)if(null!==i.$findOpeningBracket("]",{column:r.column+1,row:r.row})&&C.isAutoInsertedClosing(r,s,o))return C.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(e,t,n,i,o){var r=i.doc.getTextRange(o);if(!o.isMultiLine()&&"["==r&&(u(n),"]"==i.doc.getLine(o.start.row).substring(o.start.column+1,o.start.column+2)))return o.end.column++,o}),this.add("string_dquotes","insertion",function(e,t,n,i,o){var r=i.$mode.$quotes||f;if(1==o.length&&r[o]&&(!this.lineCommentStart||-1==this.lineCommentStart.indexOf(o))){u(n);var s=n.getSelectionRange(),a=i.doc.getTextRange(s);if(!(""===a||1==a.length&&r[a])&&n.getWrapBehavioursEnabled())return g(s,a,o,o);if(!a){var r=n.getCursorPosition(),s=i.doc.getLine(r.row),a=s.substring(r.column-1,r.column),n=s.substring(r.column,r.column+1),l=i.getTokenAt(r.row,r.column),c=i.getTokenAt(r.row,r.column+1);if("\\"==a&&l&&/escape/.test(l.type))return null;var h,l=l&&/string|escape/.test(l.type),d=!c||/string|escape/.test(c.type);if(n==o)(h=l!==d)&&/string\.end/.test(c.type)&&(h=!1);else{if(l&&!d)return null;if(l&&d)return null;c=i.$mode.tokenRe,l=(c.lastIndex=0,c.test(a)),d=(c.lastIndex=0,c.test(n)),i=i.$mode.$pairQuotesAfter;if(!(i&&i[o]&&i[o].test(a))&&l||d)return null;if(n&&!/[\s;,.})\]\\]/.test(n))return null;i=s[r.column-2];if(a==o&&(i==o||c.test(i)))return null;h=!0}return{text:h?o+o:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,n,i,o){var r=i.$mode.$quotes||f,s=i.doc.getTextRange(o);if(!o.isMultiLine()&&r.hasOwnProperty(s)&&(u(n),i.doc.getLine(o.start.row).substring(o.start.column+1,o.start.column+2)==s))return o.end.column++,o}),!1!==d.closeDocComment&&this.add("doc comment end","insertion",function(e,t,n,i,o){var r;if("doc-start"===e&&("\n"===o||"\r\n"===o)&&n.selection.isEmpty())return e=n.getCursorPosition(),n=i.doc.getLine(e.row),i=i.doc.getLine(e.row+1),r=this.$getIndent(n),/\s*\*/.test(i)?/^\s*\*/.test(n)?{text:o+r+"* ",selection:[1,3+r.length,1,3+r.length]}:{text:o+r+" * ",selection:[1,3+r.length,1,3+r.length]}:/\/\*\*/.test(n.substring(0,e.column))?{text:o+r+" * "+o+" "+r+"*/",selection:[1,4+r.length,1,4+r.length]}:void 0})};C.isSaneInsertion=function(e,t){var n=e.getCursorPosition(),i=new r(t,n.row,n.column);if(!this.$matchTokenType(i.getCurrentToken()||"text",s)){if(/[)}\]]/.test(e.session.getLine(n.row)[n.column]))return!0;e=new r(t,n.row,n.column+1);if(!this.$matchTokenType(e.getCurrentToken()||"text",s))return!1}return i.stepForward(),i.getCurrentTokenRow()!==n.row||this.$matchTokenType(i.getCurrentToken()||"text",a)},C.$matchTokenType=function(e,t){return-1<t.indexOf(e.type||e)},C.recordAutoInsert=function(e,t,n){e=e.getCursorPosition(),t=t.doc.getLine(e.row);this.isAutoInsertedClosing(e,t,p.autoInsertedLineEnd[0])||(p.autoInsertedBrackets=0),p.autoInsertedRow=e.row,p.autoInsertedLineEnd=n+t.substr(e.column),p.autoInsertedBrackets++},C.recordMaybeInsert=function(e,t,n){e=e.getCursorPosition(),t=t.doc.getLine(e.row);this.isMaybeInsertedClosing(e,t)||(p.maybeInsertedBrackets=0),p.maybeInsertedRow=e.row,p.maybeInsertedLineStart=t.substr(0,e.column)+n,p.maybeInsertedLineEnd=t.substr(e.column),p.maybeInsertedBrackets++},C.isAutoInsertedClosing=function(e,t,n){return 0<p.autoInsertedBrackets&&e.row===p.autoInsertedRow&&n===p.autoInsertedLineEnd[0]&&t.substr(e.column)===p.autoInsertedLineEnd},C.isMaybeInsertedClosing=function(e,t){return 0<p.maybeInsertedBrackets&&e.row===p.maybeInsertedRow&&t.substr(e.column)===p.maybeInsertedLineEnd&&t.substr(0,e.column)==p.maybeInsertedLineStart},C.popAutoInsertedClosing=function(){p.autoInsertedLineEnd=p.autoInsertedLineEnd.substr(1),p.autoInsertedBrackets--},C.clearMaybeInsertedClosing=function(){p&&(p.maybeInsertedBrackets=0,p.maybeInsertedRow=-1)},i.inherits(C,o),t.CstyleBehaviour=C}),ace.define("ace/unicode",["require","exports","module"],function(e,t,n){"use strict";for(var i=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],o=0,r=[],s=0;s<i.length;s+=2)r.push(o+=i[s]),i[s+1]&&r.push(45,o+=i[s+1]);t.wordChars=String.fromCharCode.apply(null,r)}),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(e,t,n){"use strict";var a=e("../config"),i=e("../tokenizer").Tokenizer,o=e("./text_highlight_rules").TextHighlightRules,r=e("./behaviour/cstyle").CstyleBehaviour,s=e("../unicode"),b=e("../lib/lang"),m=e("../token_iterator").TokenIterator,f=e("../range").Range,e=function(){this.HighlightRules=o};!function(){this.$defaultBehaviour=new r,this.tokenRe=new RegExp("^["+s.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+s.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new i(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,o,n,i){var r=o.doc,s=!0,a=!0,l=1/0,c=o.getTabSize(),t=!1;if(this.lineCommentStart){m=Array.isArray(this.lineCommentStart)?(C=this.lineCommentStart.map(b.escapeRegExp).join("|"),this.lineCommentStart[0]):(C=b.escapeRegExp(this.lineCommentStart),this.lineCommentStart),C=new RegExp("^(\\s*)(?:"+C+") ?"),t=o.getUseSoftTabs();var h=function(e,t){var n,i,o=e.match(C);o&&(n=o[1].length,i=o[0].length,p(e,n,i)||" "!=o[0][i-1]||i--,r.removeInLine(t,n,i))},d=m+" ",u=function(e,t){s&&!/\S/.test(e)||(p(e,l,l)?r.insertInLine({row:t,column:l},d):r.insertInLine({row:t,column:l},m))},g=function(e,t){return C.test(e)},p=function(e,t,n){for(var i=0;t--&&" "==e.charAt(t);)i++;if(i%c!=0)return!1;for(i=0;" "==e.charAt(n++);)i++;return 2<c?i%c!=c-1:i%c==0}}else{if(!this.blockComment)return!1;var m=this.blockComment.start,f=this.blockComment.end,C=new RegExp("^(\\s*)(?:"+b.escapeRegExp(m)+")"),y=new RegExp("(?:"+b.escapeRegExp(f)+")\\s*$"),u=function(e,t){g(e,t)||s&&!/\S/.test(e)||(r.insertInLine({row:t,column:e.length},f),r.insertInLine({row:t,column:l},m))},h=function(e,t){var n;(n=e.match(y))&&r.removeInLine(t,e.length-n[0].length,e.length),(n=e.match(C))&&r.removeInLine(t,n[1].length,n[0].length)},g=function(e,t){if(C.test(e))return!0;for(var n=o.getTokens(t),i=0;i<n.length;i++)if("comment"===n[i].type)return!0}}function v(e){for(var t=n;t<=i;t++)e(r.getLine(t),t)}var I=1/0;v(function(e,t){var n=e.search(/\S/);-1!==n?(n<l&&(l=n),a&&!g(e,t)&&(a=!1)):I>e.length&&(I=e.length)}),l==1/0&&(l=I,a=s=!1),t&&l%c!=0&&(l=Math.floor(l/c)*c),v(a?h:u)},this.toggleBlockComment=function(e,t,n,i){var o=this.blockComment;if(o){!o.start&&o[0]&&(o=o[0]);var r,s,a=(u=new m(t,i.row,i.column)).getCurrentToken(),l=(t.selection,t.selection.toOrientedRange());if(a&&/comment/.test(a.type)){for(;a&&/comment/.test(a.type);){if(-1!=(g=a.value.indexOf(o.start))){var c=u.getCurrentTokenRow(),h=u.getCurrentTokenColumn()+g,d=new f(c,h,c,h+o.start.length);break}a=u.stepBackward()}for(var u,g,a=(u=new m(t,i.row,i.column)).getCurrentToken();a&&/comment/.test(a.type);){if(-1!=(g=a.value.indexOf(o.end))){var c=u.getCurrentTokenRow(),h=u.getCurrentTokenColumn()+g,p=new f(c,h,c,h+o.end.length);break}a=u.stepForward()}p&&t.remove(p),d&&(t.remove(d),r=d.start.row,s=-o.start.length)}else s=o.start.length,r=n.start.row,t.insert(n.end,o.end),t.insert(n.start,o.start);l.start.row==r&&(l.start.column+=s),l.end.row==r&&(l.end.column+=s),t.selection.fromOrientedRange(l)}},this.getNextLineIndent=function(e,t,n){return this.$getIndent(t)},this.checkOutdent=function(e,t,n){return!1},this.autoOutdent=function(e,t,n){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){for(var t in this.$embeds=[],this.$modes={},e){var n,i,o;e[t]&&(i=(n=e[t]).prototype.$id,(o=a.$modes[i])||(a.$modes[i]=o=new n),a.$modes[t]||(a.$modes[t]=o),this.$embeds.push(t),this.$modes[t]=o)}for(var r=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],s=this,t=0;t<r.length;t++)!function(e){var t,n;t=r[e],n=s[t],s[r[e]]=function(){return this.$delegator(t,arguments,n)}}(t)},this.$delegator=function(e,t,n){var i=t[0]||"start";if("string"!=typeof i){if(Array.isArray(i[2])){var o=i[2][i[2].length-1];if(s=this.$modes[o])return s[e].apply(s,[i[1]].concat([].slice.call(t,1)))}i=i[0]||"start"}for(var r=0;r<this.$embeds.length;r++)if(this.$modes[this.$embeds[r]]){var s,a=i.split(this.$embeds[r]);if(!a[0]&&a[1])return t[0]=a[1],(s=this.$modes[this.$embeds[r]])[e].apply(s,t)}o=n.apply(this,t);return n?o:void 0},this.transformAction=function(e,t,n,i,o){if(this.$behaviour){var r,s=this.$behaviour.getBehaviours();for(r in s)if(s[r][t]){var a=s[r][t].apply(this,arguments);if(a)return a}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,n=[];for(s in t)for(var i=t[s],o=0,r=i.length;o<r;o++)if("string"==typeof i[o].token)/keyword|support|storage/.test(i[o].token)&&n.push(i[o].regex);else if("object"==typeof i[o].token)for(var s,a=0,l=i[o].token.length;a<l;a++)/keyword|support|storage/.test(i[o].token[a])&&(s=i[o].regex.match(/\(.+?\)/g)[a],n.push(s.substr(1,s.length-2)));this.completionKeywords=n}return e?n.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,n,i){return(this.$keywordList||this.$createKeywordList()).map(function(e){return{name:e,value:e,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}.call(e.prototype),t.Mode=e}),ace.define("ace/apply_delta",["require","exports","module"],function(e,t,n){"use strict";t.applyDelta=function(e,t,n){var i=t.start.row,o=t.start.column,r=e[i]||"";switch(t.action){case"insert":1===t.lines.length?e[i]=r.substring(0,o)+t.lines[0]+r.substring(o):(s=[i,1].concat(t.lines),e.splice.apply(e,s),e[i]=r.substring(0,o)+e[i],e[i+t.lines.length-1]+=r.substring(o));break;case"remove":var s=t.end.column,a=t.end.row;i===a?e[i]=r.substring(0,o)+r.substring(s):e.splice(i,a-i+1,r.substring(0,o)+e[a].substring(s))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,n){"use strict";var i=e("./lib/oop"),e=e("./lib/event_emitter").EventEmitter,o=(r.prototype.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},r.prototype.getDocument=function(){return this.document},r.prototype.onChange=function(e){e.start.row==e.end.row&&e.start.row!=this.row||e.start.row>this.row||(e=function(e,t,n){var i="insert"==e.action,o=(i?1:-1)*(e.end.row-e.start.row),r=(i?1:-1)*(e.end.column-e.start.column),s=e.start,i=i?s:e.end;if(a(t,s,n))return{row:t.row,column:t.column};if(a(i,t,!n))return{row:t.row+o,column:t.column+(t.row==i.row?r:0)};return{row:s.row,column:s.column}}(e,{row:this.row,column:this.column},this.$insertRight),this.setPosition(e.row,e.column,!0))},r.prototype.setPosition=function(e,t,n){n=n?{row:e,column:t}:this.$clipPositionToDocument(e,t);this.row==n.row&&this.column==n.column||(e={row:this.row,column:this.column},this.row=n.row,this.column=n.column,this._signal("change",{old:e,value:n}))},r.prototype.detach=function(){this.document.off("change",this.$onChange)},r.prototype.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},r.prototype.$clipPositionToDocument=function(e,t){var n={};return e>=this.document.getLength()?(n.row=Math.max(0,this.document.getLength()-1),n.column=this.document.getLine(n.row).length):e<0?(n.row=0,n.column=0):(n.row=e,n.column=Math.min(this.document.getLine(n.row).length,Math.max(0,t))),t<0&&(n.column=0),n},r);function r(e,t,n){this.$onChange=this.onChange.bind(this),this.attach(e),"number"!=typeof t?this.setPosition(t.row,t.column):this.setPosition(t,n)}function a(e,t,n){n=n?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&n}o.prototype.$insertRight=!1,i.implement(o.prototype,e),t.Anchor=o}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(e,t,n){"use strict";var i=e("./lib/oop"),o=e("./apply_delta").applyDelta,r=e("./lib/event_emitter").EventEmitter,s=e("./range").Range,a=e("./anchor").Anchor,e=(l.prototype.setValue=function(e){var t=this.getLength()-1;this.remove(new s(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e||"")},l.prototype.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},l.prototype.createAnchor=function(e,t){return new a(this,e,t)},l.prototype.$detectNewLine=function(e){e=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=e?e[1]:"\n",this._signal("changeNewLineMode")},l.prototype.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},l.prototype.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},l.prototype.getNewLineMode=function(){return this.$newLineMode},l.prototype.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},l.prototype.getLine=function(e){return this.$lines[e]||""},l.prototype.getLines=function(e,t){return this.$lines.slice(e,t+1)},l.prototype.getAllLines=function(){return this.getLines(0,this.getLength())},l.prototype.getLength=function(){return this.$lines.length},l.prototype.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},l.prototype.getLinesForRange=function(e){var t,n;return e.start.row===e.end.row?t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)]:((t=this.getLines(e.start.row,e.end.row))[0]=(t[0]||"").substring(e.start.column),n=t.length-1,e.end.row-e.start.row==n&&(t[n]=t[n].substring(0,e.end.column))),t},l.prototype.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},l.prototype.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},l.prototype.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},l.prototype.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},l.prototype.insertInLine=function(e,t){var n=this.clippedPos(e.row,e.column),e=this.pos(e.row,e.column+t.length);return this.applyDelta({start:n,end:e,action:"insert",lines:[t]},!0),this.clonePos(e)},l.prototype.clippedPos=function(e,t){var n=this.getLength(),n=(void 0===e?e=n:e<0?e=0:n<=e&&(e=n-1,t=void 0),this.getLine(e));return null==t&&(t=n.length),{row:e,column:t=Math.min(Math.max(t,0),n.length)}},l.prototype.clonePos=function(e){return{row:e.row,column:e.column}},l.prototype.pos=function(e,t){return{row:e,column:t}},l.prototype.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},l.prototype.insertFullLines=function(e,t){var n=0,n=(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(t=t.concat([""]),0):(t=[""].concat(t),this.$lines[--e].length);this.insertMergedLines({row:e,column:n},t)},l.prototype.insertMergedLines=function(e,t){var e=this.clippedPos(e.row,e.column),n={row:e.row+t.length-1,column:(1==t.length?e.column:0)+t[t.length-1].length};return this.applyDelta({start:e,end:n,action:"insert",lines:t}),this.clonePos(n)},l.prototype.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),e=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:e,action:"remove",lines:this.getLinesForRange({start:t,end:e})}),this.clonePos(t)},l.prototype.removeInLine=function(e,t,n){t=this.clippedPos(e,t),e=this.clippedPos(e,n);return this.applyDelta({start:t,end:e,action:"remove",lines:this.getLinesForRange({start:t,end:e})},!0),this.clonePos(t)},l.prototype.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1);var n=(t=Math.min(Math.max(0,t),this.getLength()-1))==this.getLength()-1&&0<e,i=t<this.getLength()-1,o=n?e-1:e,n=n?this.getLine(o).length:0,r=i?t+1:t,i=i?0:this.getLine(r).length,o=new s(o,n,r,i),n=this.$lines.slice(e,t+1);return this.applyDelta({start:o.start,end:o.end,action:"remove",lines:this.getLinesForRange(o)}),n},l.prototype.removeNewLine=function(e){e<this.getLength()-1&&0<=e&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},l.prototype.replace=function(e,t){return e instanceof s||(e=s.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty()?e.start:t==this.getTextRange(e)?e.end:(this.remove(e),t?this.insert(e.start,t):e.start)},l.prototype.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},l.prototype.revertDeltas=function(e){for(var t=e.length-1;0<=t;t--)this.revertDelta(e[t])},l.prototype.applyDelta=function(e,t){var n="insert"==e.action;(n?e.lines.length<=1&&!e.lines[0]:!s.comparePoints(e.start,e.end))||(n&&2e4<e.lines.length?this.$splitAndapplyLargeDelta(e,2e4):(o(this.$lines,e,t),this._signal("change",e)))},l.prototype.$safeApplyDelta=function(e){var t=this.$lines.length;("remove"==e.action&&e.start.row<t&&e.end.row<t||"insert"==e.action&&e.start.row<=t)&&this.applyDelta(e)},l.prototype.$splitAndapplyLargeDelta=function(e,t){for(var n=e.lines,i=n.length-t+1,o=e.start.row,r=e.start.column,s=0,a=0;s<i;s=a){a+=t-1;var l=n.slice(s,a);l.push(""),this.applyDelta({start:this.pos(o+s,r),end:this.pos(o+a,r=0),action:e.action,lines:l},!0)}e.lines=n.slice(s),e.start.row=o+s,e.start.column=r,this.applyDelta(e,!0)},l.prototype.revertDelta=function(e){this.$safeApplyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},l.prototype.indexToPosition=function(e,t){for(var n=this.$lines||this.getAllLines(),i=this.getNewLineCharacter().length,o=t||0,r=n.length;o<r;o++)if((e-=n[o].length+i)<0)return{row:o,column:e+n[o].length+i};return{row:r-1,column:e+n[r-1].length+i}},l.prototype.positionToIndex=function(e,t){for(var n=this.$lines||this.getAllLines(),i=this.getNewLineCharacter().length,o=0,r=Math.min(e.row,n.length),s=t||0;s<r;++s)o+=n[s].length+i;return o+e.column},l.prototype.$split=function(e){return e.split(/\r\n|\r|\n/)},l);function l(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)}e.prototype.$autoNewLine="",e.prototype.$newLineMode="auto",i.implement(e.prototype,r),t.Document=e}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,n){"use strict";var i=e("./lib/oop"),e=e("./lib/event_emitter").EventEmitter,o=(r.prototype.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},r.prototype.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},r.prototype.fireUpdateEvent=function(e,t){this._signal("update",{data:{first:e,last:t}})},r.prototype.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},r.prototype.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},r.prototype.$updateOnChange=function(e){var t=e.start.row,n=e.end.row-t;0==n?this.lines[t]=null:"remove"==e.action?(this.lines.splice(t,1+n,null),this.states.splice(t,1+n,null)):((e=Array(1+n)).unshift(t,1),this.lines.splice.apply(this.lines,e),this.states.splice.apply(this.states,e)),this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},r.prototype.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},r.prototype.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},r.prototype.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},r.prototype.$tokenizeRow=function(e){var t=this.doc.getLine(e),n=this.states[e-1],t=this.tokenizer.getLineTokens(t,n,e);return this.states[e]+""!=t.state+""?(this.states[e]=t.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=t.tokens},r.prototype.cleanup=function(){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.removeAllListeners()},r);function r(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var a=this;this.$worker=function(){if(a.running){for(var e=new Date,t=a.currentLine,n=-1,i=a.doc,o=t;a.lines[t];)t++;var r=i.getLength(),s=0;for(a.running=!1;t<r;){for(a.$tokenizeRow(t),n=t;t++,a.lines[t];);if(++s%5==0&&20<new Date-e){a.running=setTimeout(a.$worker,20);break}}a.currentLine=t,o<=(n=-1==n?t:n)&&a.fireUpdateEvent(o,n)}}}i.implement(o.prototype,e),t.BackgroundTokenizer=o}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/range"],function(e,t,n){"use strict";var u=e("./lib/lang"),g=e("./range").Range,e=(i.prototype.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},i.prototype.update=function(e,t,n,i){if(this.regExp)for(var o=i.firstRow,r=i.lastRow,s={},a=o;a<=r;a++){var l=this.cache[a];null==l&&(l=(l=(l=u.getMatchOffsets(n.getLine(a),this.regExp)).length>this.MAX_RANGES?l.slice(0,this.MAX_RANGES):l).map(function(e){return new g(a,e.offset,a,e.offset+e.length)}),this.cache[a]=l.length?l:"");for(var c=l.length;c--;){var h=l[c].toScreenRange(n),d=h.toString();s[d]||(s[d]=!0,t.drawSingleLineMarker(e,h,this.clazz,i))}}},i);function i(e,t,n){void 0===n&&(n="text"),this.setRegexp(e),this.clazz=t,this.type=n}e.prototype.MAX_RANGES=500,t.SearchHighlight=e}),ace.define("ace/undomanager",["require","exports","module","ace/range"],function(e,t,n){"use strict";o.prototype.addSession=function(e){this.$session=e},o.prototype.add=function(e,t,n){this.$fromUndo||e!=this.$lastDelta&&(this.$keepRedoStack||(this.$redoStack.length=0),!1!==t&&this.lastDeltas||(this.lastDeltas=[],(t=this.$undoStack.length)>this.$undoDepth-1&&this.$undoStack.splice(0,t-this.$undoDepth+1),this.$undoStack.push(this.lastDeltas),e.id=this.$rev=++this.$maxRev),"remove"!=e.action&&"insert"!=e.action||(this.$lastDelta=e),this.lastDeltas.push(e))},o.prototype.addSelection=function(e,t){this.selections.push({value:e,rev:t||this.$rev})},o.prototype.startNewGroup=function(){return this.lastDeltas=null,this.$rev},o.prototype.markIgnored=function(e,t){null==t&&(t=this.$rev+1);for(var n=this.$undoStack,i=n.length;i--;){var o=n[i][0];if(o.id<=e)break;o.id<t&&(o.ignore=!0)}this.lastDeltas=null},o.prototype.getSelection=function(e,t){for(var n=this.selections,i=n.length;i--;){var o=n[i];if(o.rev<e)return o=t?n[i+1]:o}},o.prototype.getRevision=function(){return this.$rev},o.prototype.getDeltas=function(e,t){null==t&&(t=this.$rev+1);for(var n=this.$undoStack,i=null,o=0,r=n.length;r--;){var s=n[r][0];if(s.id<t&&!i&&(i=r+1),s.id<=e){o=r+1;break}}return n.slice(o,i)},o.prototype.getChangedRanges=function(e,t){null==t&&this.$rev},o.prototype.getChangedLines=function(e,t){null==t&&this.$rev},o.prototype.undo=function(e,t){this.lastDeltas=null;var n,i=this.$undoStack;if(function(e,t){for(var n=t;n--;){var i=e[n];if(i&&!i[0].ignore){for(;n<t-1;){var o=function(e,t){for(var n=e.length;n--;)for(var i=0;i<t.length;i++)if(!a(e[n],t[i])){for(;n<e.length;){for(;i--;)a(t[i],e[n]);i=t.length,n++}return[e,t]}return e.selectionBefore=t.selectionBefore=e.selectionAfter=t.selectionAfter=null,[t,e]}(e[n],e[n+1]);e[n]=o[0],e[n+1]=o[1],n++}return 1}}}(i,i.length))return e=e||this.$session,this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0,n=null,(i=i.pop())&&(n=e.undoChanges(i,t),this.$redoStack.push(i),this.$syncRev()),this.$fromUndo=!1,n},o.prototype.redo=function(e,t){if(this.lastDeltas=null,e=e||this.$session,this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev){for(var n=this.getDeltas(this.$redoStackBaseRev,this.$rev+1),i=this.$redoStack,o=n,r=0;r<o.length;r++)for(var s=o[r],a=0;a<s.length;a++){l=void 0;c=void 0;h=void 0;d=void 0;u=void 0;g=void 0;var l=i;var c=s[a];c=function(e){return{start:C(e.start),end:C(e.end),action:e.action,lines:e.lines.slice()}}(c);for(var h=l.length;h--;){for(var d=l[h],u=0;u<d.length;u++){var g=function(e,t){var n,i,o="insert"==e.action,r="insert"==t.action;if(o&&r)f(e.start,t.start)<0?y(t,e,1):y(e,t,1);else if(o&&!r)0<=f(e.start,t.end)?y(e,t,-1):(f(e.start,t.start)<=0||y(e,m.fromPoints(t.start,e.start),-1),y(t,e,1));else if(!o&&r)0<=f(t.start,e.end)?y(t,e,-1):(f(t.start,e.start)<=0||y(t,m.fromPoints(e.start,t.start),-1),y(e,t,1));else if(!o&&!r)if(0<=f(t.start,e.end))y(t,e,-1);else{if(!(f(t.end,e.start)<=0))return f(e.start,t.start)<0&&(e=I(n=e,t.start)),0<f(e.end,t.end)&&(i=I(e,t.end)),v(t.end,e.start,e.end,-1),i&&!n&&(e.lines=i.lines,e.start=i.start,e.end=i.end,i=e),[t,n,i].filter(Boolean);y(e,t,-1)}return[t,e]}(d[u],c);c=g[0],2!=g.length&&(g[2]?(d.splice(u+1,1,g[1],g[2]),u++):g[1]||(d.splice(u,1),u--))}d.length||l.splice(h,1)}}this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach(function(e){e[0].id=++this.$maxRev},this)}var n=this.$redoStack.pop(),p=null;return n&&(p=e.redoChanges(n,t),this.$undoStack.push(n),this.$syncRev()),this.$fromUndo=!1,p},o.prototype.$syncRev=function(){var e=this.$undoStack,e=e[e.length-1],e=e&&e[0].id||0;this.$redoStackBaseRev=e,this.$rev=e},o.prototype.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},o.prototype.canUndo=function(){return 0<this.$undoStack.length},o.prototype.canRedo=function(){return 0<this.$redoStack.length},o.prototype.bookmark=function(e){null==e&&(e=this.$rev),this.mark=e},o.prototype.isAtBookmark=function(){return this.$rev===this.mark},o.prototype.toJSON=function(){return{$redoStack:this.$redoStack,$undoStack:this.$undoStack}},o.prototype.fromJSON=function(e){this.reset(),this.$undoStack=e.$undoStack,this.$redoStack=e.$redoStack},o.prototype.$prettyPrint=function(e){return e?r(e):r(this.$undoStack)+"\n---\n"+r(this.$redoStack)};var i=o;function o(){this.$keepRedoStack,this.$maxRev=0,this.$fromUndo=!1,this.$undoDepth=1/0,this.reset()}i.prototype.hasUndo=i.prototype.canUndo,i.prototype.hasRedo=i.prototype.canRedo,i.prototype.isClean=i.prototype.isAtBookmark,i.prototype.markClean=i.prototype.bookmark;var m=e("./range").Range,f=m.comparePoints;m.comparePoints;function C(e){return{row:e.row,column:e.column}}function r(e){var t;return e=e||this,Array.isArray(e)?e.map(r).join("\n"):(t="",e.action?(t="insert"==e.action?"+":"-",t+="["+e.lines+"]"):e.value&&(t=Array.isArray(e.value)?e.value.map(s).join("\n"):s(e.value)),e.start&&(t+=s(e)),(e.id||e.rev)&&(t+="\t("+(e.id||e.rev)+")"),t)}function s(e){return e.start.row+":"+e.start.column+"=>"+e.end.row+":"+e.end.column}function a(e,t){var n="insert"==e.action,i="insert"==t.action;if(n&&i)if(0<=f(t.start,e.end))y(t,e,-1);else{if(!(f(t.start,e.start)<=0))return;y(e,t,1)}else if(n&&!i)if(0<=f(t.start,e.end))y(t,e,-1);else{if(!(f(t.end,e.start)<=0))return;y(e,t,-1)}else if(!n&&i)if(0<=f(t.start,e.start))y(t,e,1);else{if(!(f(t.start,e.start)<=0))return;y(e,t,1)}else if(!n&&!i)if(0<=f(t.start,e.start))y(t,e,1);else{if(!(f(t.end,e.start)<=0))return;y(e,t,-1)}return 1}function y(e,t,n){v(e.start,t.start,t.end,n),v(e.end,t.start,t.end,n)}function v(e,t,n,i){e.row==(1==i?t:n).row&&(e.column+=i*(n.column-t.column)),e.row+=i*(n.row-t.row)}function I(e,t){var n=e.lines,i=e.end,o=(e.end=C(t),e.end.row-e.start.row),r=n.splice(o,n.length),o=o?t.column:t.column-e.start.column;return n.push(r[0].substring(0,o)),r[0]=r[0].substr(o),{start:C(t),end:i,lines:r,action:e.action}}t.UndoManager=i}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(e,t,n){"use strict";var i=e("../range").Range;function o(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];e=t[t.length-1];this.range=new i(t[0].start.row,t[0].start.column,e.end.row,e.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(e){e.setFoldLine(this)},this)}o.prototype.shiftRow=function(t){this.start.row+=t,this.end.row+=t,this.folds.forEach(function(e){e.start.row+=t,e.end.row+=t})},o.prototype.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort(function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)}),0<this.range.compareEnd(e.start.row,e.start.column)?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},o.prototype.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},o.prototype.walk=function(e,t,n){var i,o,r=0,s=this.folds,a=!0;null==t&&(t=this.end.row,n=this.end.column);for(var l=0;l<s.length;l++){if(-1==(o=(i=s[l]).range.compareStart(t,n)))return void e(null,t,n,r,a);if(!e(null,i.start.row,i.start.column,r,a)&&e(i.placeholder,i.start.row,i.start.column,r)||0===o)return;a=!i.sameRow,r=i.end.column}e(null,t,n,r,a)},o.prototype.getNextFoldTo=function(e,t){for(var n,i,o=0;o<this.folds.length;o++){if(-1==(i=(n=this.folds[o]).range.compareEnd(e,t)))return{fold:n,kind:"after"};if(0===i)return{fold:n,kind:"inside"}}return null},o.prototype.addRemoveChars=function(e,t,n){var i,o=this.getNextFoldTo(e,t);if(o)if(i=o.fold,"inside"==o.kind&&i.start.column!=t&&i.start.row!=e)window.console&&window.console.log(e,t,i);else if(i.start.row==e){var r,s=(r=this.folds).indexOf(i);for(0===s&&(this.start.column+=n);s<r.length;s++){if((i=r[s]).start.column+=n,!i.sameRow)return;i.end.column+=n}this.end.column+=n}},o.prototype.split=function(e,t){var n,i,e=this.getNextFoldTo(e,t);return e&&"inside"!=e.kind?(t=e.fold,e=this.folds,n=this.foldData,t=e.indexOf(t),i=e[t-1],this.end.row=i.end.row,this.end.column=i.end.column,i=new o(n,e=e.splice(t,e.length-t)),n.splice(n.indexOf(this)+1,0,i),i):null},o.prototype.merge=function(e){for(var t=e.folds,n=0;n<t.length;n++)this.addFold(t[n]);var i=this.foldData;i.splice(i.indexOf(e),1)},o.prototype.toString=function(){var t=[this.range.toString()+": ["];return this.folds.forEach(function(e){t.push("  "+e.toString())}),t.push("]"),t.join("\n")},o.prototype.idxToPosition=function(e){for(var t=0,n=0;n<this.folds.length;n++){var i=this.folds[n];if((e-=i.start.column-t)<0)return{row:i.start.row,column:i.start.column+e};if((e-=i.placeholder.length)<0)return i.start;t=i.end.column}return{row:this.end.row,column:this.end.column+e}},t.FoldLine=o}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(e,t,n){"use strict";var a=e("./range").Range.comparePoints,e=(i.prototype.pointIndex=function(e,t,n){for(var i=this.ranges,o=n||0;o<i.length;o++){var r=i[o],s=a(e,r.end);if(!(0<s))return r=a(e,r.start),0===s?t&&0!==r?-o-2:o:0<r||0===r&&!t?o:-o-1}return-o-1},i.prototype.add=function(e){var t=!e.isEmpty(),n=this.pointIndex(e.start,t),t=this.pointIndex(e.end,t,n=n<0?-n-1:n);return t<0?t=-t-1:t++,this.ranges.splice(n,t-n,e)},i.prototype.addList=function(e){for(var t=[],n=e.length;n--;)t.push.apply(t,this.add(e[n]));return t},i.prototype.substractPoint=function(e){e=this.pointIndex(e);if(0<=e)return this.ranges.splice(e,1)},i.prototype.merge=function(){for(var e=[],t=this.ranges,n=(t=t.sort(function(e,t){return a(e.start,t.start)}))[0],i=1;i<t.length;i++){var o=n,n=t[i],r=a(o.end,n.start);r<0||(0!=r||o.isEmpty()||n.isEmpty())&&(a(o.end,n.end)<0&&(o.end.row=n.end.row,o.end.column=n.end.column),t.splice(i,1),e.push(n),n=o,i--)}return this.ranges=t,e},i.prototype.contains=function(e,t){return 0<=this.pointIndex({row:e,column:t})},i.prototype.containsPoint=function(e){return 0<=this.pointIndex(e)},i.prototype.rangeAtPoint=function(e){e=this.pointIndex(e);if(0<=e)return this.ranges[e]},i.prototype.clipRows=function(e,t){var n=this.ranges;if(n[0].start.row>t||n[n.length-1].start.row<e)return[];for(var e=this.pointIndex({row:e,column:0}),i=this.pointIndex({row:t,column:0},e=e<0?-e-1:e),o=(i<0&&(i=-i-1),[]),r=e;r<i;r++)o.push(n[r]);return o},i.prototype.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},i.prototype.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},i.prototype.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},i.prototype.$onChange=function(e){for(var t=e.start,n=e.end,i=t.row,o=n.row,r=this.ranges,s=0,a=r.length;s<a&&!((h=r[s]).end.row>=i);s++);if("insert"==e.action)for(var l=o-i,c=-t.column+n.column;s<a;s++){if((h=r[s]).start.row>i)break;h.start.row==i&&h.start.column>=t.column&&(h.start.column==t.column&&this.$bias<=0||(h.start.column+=c,h.start.row+=l)),h.end.row==i&&h.end.column>=t.column&&(h.end.column==t.column&&this.$bias<0||(h.end.column==t.column&&0<c&&s<a-1&&h.end.column>h.start.column&&h.end.column==r[s+1].start.column&&(h.end.column-=c),h.end.column+=c,h.end.row+=l))}else for(var h,l=i-o,c=t.column-n.column;s<a;s++){if((h=r[s]).start.row>o)break;h.end.row<o&&(i<h.end.row||i==h.end.row&&t.column<h.end.column)?(h.end.row=i,h.end.column=t.column):h.end.row==o?h.end.column<=n.column?(l||h.end.column>t.column)&&(h.end.column=t.column,h.end.row=t.row):(h.end.column+=c,h.end.row+=l):h.end.row>o&&(h.end.row+=l),h.start.row<o&&(i<h.start.row||i==h.start.row&&t.column<h.start.column)?(h.start.row=i,h.start.column=t.column):h.start.row==o?h.start.column<=n.column?(l||h.start.column>t.column)&&(h.start.column=t.column,h.start.row=t.row):(h.start.column+=c,h.start.row+=l):h.start.row>o&&(h.start.row+=l)}if(0!=l&&s<a)for(;s<a;s++)(h=r[s]).start.row+=l,h.end.row+=l},i);function i(){this.ranges=[],this.$bias=1}e.prototype.comparePoints=a,t.RangeList=e}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list"],function(e,t,n){"use strict";var i,o,r=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(e,t){e.__proto__=t}:function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}))(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),e=e("../range_list").RangeList,r=(r(s,o=e),s.prototype.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},s.prototype.setFoldLine=function(t){this.foldLine=t,this.subFolds.forEach(function(e){e.setFoldLine(t)})},s.prototype.clone=function(){var t=new s(this.range.clone(),this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},s.prototype.addSubFold=function(e){if(!this.range.isEqual(e)){r=e,s=this.start,d(r.start,s),d(r.end,s);for(var t=e.start.row,n=e.start.column,i=0,o=-1;i<this.subFolds.length&&1==(o=this.subFolds[i].range.compare(t,n));i++);var r=this.subFolds[i],s=0;if(0==o){if(r.range.containsRange(e))return r.addSubFold(e);s=1}for(var t=e.range.end.row,n=e.range.end.column,a=i,o=-1;a<this.subFolds.length&&1==(o=this.subFolds[a].range.compare(t,n));a++);0==o&&a++;for(var l=this.subFolds.splice(i,a-i,e),c=0==o?l.length-1:l.length,h=s;h<c;h++)e.addSubFold(l[h]);return e.setFoldLine(this.foldLine),e}},s.prototype.restoreRange=function(e){return e=e,t=this.start,a(e.start,t),void a(e.end,t);var t},s);function s(e,t){var n=o.call(this)||this;return n.foldLine=null,n.placeholder=t,n.range=e,n.start=e.start,n.end=e.end,n.sameRow=e.start.row==e.end.row,n.subFolds=n.ranges=[],n}function d(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function a(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}t.Fold=r}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator","ace/mouse/mouse_event"],function(e,t,n){"use strict";var c=e("../range").Range,u=e("./fold_line").FoldLine,g=e("./fold").Fold,h=e("../token_iterator").TokenIterator,i=e("../mouse/mouse_event").MouseEvent;t.Folding=function(){this.getFoldAt=function(e,t,n){var i=this.getFoldLine(e);if(!i)return null;for(var o=i.folds,r=0;r<o.length;r++){var s=o[r].range;if(s.contains(e,t)&&(1!=n||!s.isEnd(e,t)||s.isEmpty())&&(-1!=n||!s.isStart(e,t)||s.isEmpty()))return o[r]}},this.getFoldsInRange=function(e){var t=e.start,n=e.end,i=this.$foldData,o=[];t.column+=1,--n.column;for(var r=0;r<i.length;r++){var s=i[r].range.compareRange(e);if(2!=s){if(-2==s)break;for(var a=i[r].folds,l=0;l<a.length;l++){var c=a[l];if(-2==(s=c.range.compareRange(e)))break;if(2!=s){if(42==s)break;o.push(c)}}}}return--t.column,n.column+=1,o},this.getFoldsInRangeList=function(e){var t;return Array.isArray(e)?(t=[],e.forEach(function(e){t=t.concat(this.getFoldsInRange(e))},this)):t=this.getFoldsInRange(e),t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,n=0;n<t.length;n++)for(var i=0;i<t[n].folds.length;i++)e.push(t[n].folds[i]);return e},this.getFoldStringAt=function(e,t,n,i){if(!(i=i||this.getFoldLine(e)))return null;for(var o,r={end:{column:0}},s=0;s<i.folds.length;s++){var a,l=(a=i.folds[s]).range.compareEnd(e,t);if(-1==l){o=this.getLine(a.start.row).substring(r.end.column,a.start.column);break}if(0===l)return null;r=a}return o=o||this.getLine(a.start.row).substring(r.end.column),-1==n?o.substring(0,t-r.end.column):1==n?o.substring(t-r.end.column):o},this.getFoldLine=function(e,t){var n=this.$foldData,i=0;for(-1==(i=t?n.indexOf(t):i)&&(i=0);i<n.length;i++){var o=n[i];if(o.start.row<=e&&o.end.row>=e)return o;if(o.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var n=this.$foldData,i=0;for(-1==(i=t?n.indexOf(t):i)&&(i=0);i<n.length;i++){var o=n[i];if(o.end.row>=e)return o}return null},this.getFoldedRowCount=function(e,t){for(var n=this.$foldData,i=t-e+1,o=0;o<n.length;o++){var r=n[o],s=r.end.row,r=r.start.row;if(t<=s){r<t&&(e<=r?i-=t-r:i=0);break}e<=s&&(i-=e<=r?s-r:s-e+1)}return i},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort(function(e,t){return e.start.row-t.start.row}),e},this.addFold=function(e,t){var n,i=this.$foldData,o=!1,r=(e instanceof g?n=e:(n=new g(t,e)).collapseChildren=t.collapseChildren,this.$clipRangeToDocument(n.range),n.start.row),e=n.start.column,s=n.end.row,t=n.end.column,a=this.getFoldAt(r,e,1),l=this.getFoldAt(s,t,-1);if(a&&l==a)return a.addSubFold(n);a&&!a.range.isStart(r,e)&&this.removeFold(a),l&&!l.range.isEnd(s,t)&&this.removeFold(l);e=this.getFoldsInRange(n.range);0<e.length&&(this.removeFolds(e),n.collapseChildren||e.forEach(function(e){n.addSubFold(e)}));for(var c=0;c<i.length;c++){var h=i[c];if(s==h.start.row){h.addFold(n),o=!0;break}if(r==h.end.row){if(h.addFold(n),o=!0,!n.sameRow){var d=i[c+1];if(d&&d.start.row==s){h.merge(d);break}}break}if(s<=h.start.row)break}return o||(h=this.$addFoldLine(new u(this.$foldData,n))),this.$useWrapMode?this.$updateWrapData(h.start.row,h.start.row):this.$updateRowLengthCache(h.start.row,h.start.row),this.$modified=!0,this._signal("changeFold",{data:n,action:"add"}),n},
this.addFolds=function(e){e.forEach(function(e){this.addFold(e)},this)},this.removeFold=function(e){var t=e.foldLine,n=t.start.row,i=t.end.row,o=this.$foldData,r=t.folds;1==r.length?o.splice(o.indexOf(t),1):t.range.isEnd(e.end.row,e.end.column)?(r.pop(),t.end.row=r[r.length-1].end.row,t.end.column=r[r.length-1].end.column):t.range.isStart(e.start.row,e.start.column)?(r.shift(),t.start.row=r[0].start.row,t.start.column=r[0].start.column):e.sameRow?r.splice(r.indexOf(e),1):((r=(o=t.split(e.start.row,e.start.column)).folds).shift(),o.start.row=r[0].start.row,o.start.column=r[0].start.column),this.$updating||(this.$useWrapMode?this.$updateWrapData(n,i):this.$updateRowLengthCache(n,i)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],n=0;n<e.length;n++)t.push(e[n]);t.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(t){this.removeFold(t),t.subFolds.forEach(function(e){t.restoreRange(e),this.addFold(e)},this),0<t.collapseChildren&&this.foldAll(t.start.row+1,t.end.row,t.collapseChildren-1),t.subFolds=[]},this.expandFolds=function(e){e.forEach(function(e){this.expandFold(e)},this)},this.unfold=function(e,t){var n;if(null==e)n=new c(0,0,this.getLength(),0),null==t&&(t=!0);else if("number"==typeof e)n=new c(e,0,e,this.getLine(e).length);else if("row"in e)n=c.fromPoints(e,e);else{if(Array.isArray(e))return i=[],e.forEach(function(e){i=i.concat(this.unfold(e))},this),i;n=e}for(var i,e=i=this.getFoldsInRangeList(n);1==i.length&&c.comparePoints(i[0].start,n.start)<0&&0<c.comparePoints(i[0].end,n.end);)this.expandFolds(i),i=this.getFoldsInRangeList(n);if(0!=t?this.removeFolds(i):this.expandFolds(i),e.length)return e},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){t=this.getFoldLine(e,t);return t?t.end.row:e},this.getRowFoldStart=function(e,t){t=this.getFoldLine(e,t);return t?t.start.row:e},this.getFoldDisplayLine=function(e,t,n,o,r){null==o&&(o=e.start.row),null==r&&(r=0),null==t&&(t=e.end.row),null==n&&(n=this.getLine(t).length);var s=this.doc,a="";return e.walk(function(e,t,n,i){if(!(t<o)){if(t==o){if(n<r)return;i=Math.max(r,i)}a+=null!=e?e:s.getLine(t).substring(i,n)}},t,n),a},this.getDisplayLine=function(e,t,n,i){var o=this.getFoldLine(e);return o?this.getFoldDisplayLine(o,e,t,n,i):(o=this.doc.getLine(e)).substring(i||0,t||o.length)},this.$cloneFoldData=function(){var t=[];return t=this.$foldData.map(function(e){e=e.folds.map(function(e){return e.clone()});return new u(t,e)})},this.toggleFold=function(e){var t=this.selection.getRange();if(t.isEmpty()){var n,i=t.start;if(n=this.getFoldAt(i.row,i.column))return void this.expandFold(n);(o=this.findMatchingBracket(i))?1==t.comparePoint(o)?t.end=o:(t.start=o,t.start.column++,t.end.column--):(o=this.findMatchingBracket({row:i.row,column:i.column+1}))?(1==t.comparePoint(o)?t.end=o:t.start=o,t.start.column++):t=this.getCommentFoldRange(i.row,i.column)||t}else{var o=this.getFoldsInRange(t);if(e&&o.length)return void this.expandFolds(o);1==o.length&&(n=o[0])}if((n=n||this.getFoldAt(t.start.row,t.start.column))&&n.range.toString()==t.toString())this.expandFold(n);else{i="...";if(!t.isMultiLine()){if((i=this.getTextRange(t)).length<4)return;i=i.trim().substring(0,2)+".."}this.addFold(i,t)}},this.getCommentFoldRange=function(e,t,n){var i=new h(this,e,t),o=i.getCurrentToken(),r=o&&o.type;if(o&&/^comment|string/.test(r)){"comment"==(r=r.match(/comment|string/)[0])&&(r+="|doc-start|\\.doc");var s=new RegExp(r),r=new c;if(1!=n){for(;(o=i.stepBackward())&&s.test(o.type)&&!/^comment.end/.test(o.type););o=i.stepForward()}if(r.start.row=i.getCurrentTokenRow(),r.start.column=i.getCurrentTokenColumn()+(/^comment.start/.test(o.type)?o.value.length:2),i=new h(this,e,t),-1!=n){var a=-1;do{if(o=i.stepForward(),-1==a){var l=this.getState(i.$row);s.test(l)||(a=i.$row)}else if(i.$row>a)break}while(o&&s.test(o.type)&&!/^comment.start/.test(o.type));o=i.stepBackward()}else o=i.getCurrentToken();return r.end.row=i.getCurrentTokenRow(),r.end.column=i.getCurrentTokenColumn(),/^comment.end/.test(o.type)||(r.end.column+=o.value.length-2),r}},this.foldAll=function(e,t,n,i){null==n&&(n=1e5);var o=this.foldWidgets;if(o){t=t||this.getLength();for(var r,s=e=e||0;s<t;s++)null==o[s]&&(o[s]=this.getFoldWidget(s)),"start"!=o[s]||i&&!i(s)||(r=this.getFoldWidgetRange(s))&&r.isMultiLine()&&r.end.row<=t&&r.start.row>=e&&(s=r.end.row,r.collapseChildren=n,this.addFold("...",r))}},this.foldToLevel=function(e){for(this.foldAll();0<e--;)this.unfold(null,!1)},this.foldAllComments=function(){var o=this;this.foldAll(null,null,null,function(e){for(var t=o.getTokens(e),n=0;n<t.length;n++){var i=t[n];if("text"!=i.type||!/^\s+$/.test(i.value))return!!/comment/.test(i.type)}})},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");this.$foldStyle!=e&&("manual"==(this.$foldStyle=e)&&this.unfold(),e=this.$foldMode,this.$setFolding(null),this.$setFolding(e))},this.$setFolding=function(e){this.$foldMode!=e&&(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),e&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(e,t){var n=this.foldWidgets;if(!n||t&&n[e])return{};for(var i=e-1;0<=i;){var o=n[i];if("start"==(o=null==o?n[i]=this.getFoldWidget(i):o)){var r=this.getFoldWidgetRange(i),s=s||r;if(r&&r.end.row>=e)break}i--}return{range:-1!==i&&r,firstRange:s}},this.onFoldWidgetClick=function(e,t){var n={children:(t=t instanceof i?t.domEvent:t).shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};this.$toggleFoldWidget(e,n)||(e=t.target||t.srcElement)&&/ace_fold-widget/.test(e.className)&&(e.className+=" ace_invalid")},this.$toggleFoldWidget=function(e,t){var n,i,o,r;if(this.getFoldWidget)return n=this.getFoldWidget(e),i=this.getLine(e),(i=this.getFoldAt(e,-1==(n="end"===n?-1:1)?0:i.length,n))?(t.children||t.all?this.removeFold(i):this.expandFold(i),i):(n=this.getFoldWidgetRange(e,!0))&&!n.isMultiLine()&&(i=this.getFoldAt(n.start.row,n.start.column,1))&&n.isEqual(i.range)?(this.removeFold(i),i):(t.siblings?((i=this.getParentFoldRangeData(e)).range&&(o=i.range.start.row+1,r=i.range.end.row),this.foldAll(o,r,t.all?1e4:0)):t.children?(r=n?n.end.row:this.getLength(),this.foldAll(e+1,r,t.all?1e4:0)):n&&(t.all&&(n.collapseChildren=1e4),this.addFold("...",n)),n)},this.toggleFoldWidget=function(e){var t,n=this.selection.getCursor().row;n=this.getRowFoldStart(n),!this.$toggleFoldWidget(n,{})&&(t=(t=this.getParentFoldRangeData(n,!0)).range||t.firstRange)&&(n=t.start.row,(n=this.getFoldAt(n,this.getLine(n).length,1))?this.removeFold(n):this.addFold("...",t))},this.updateFoldWidgets=function(e){var t=e.start.row,n=e.end.row-t;0==n?this.foldWidgets[t]=null:"remove"==e.action?this.foldWidgets.splice(t,1+n,null):((e=Array(1+n)).unshift(t,1),this.foldWidgets.splice.apply(this.foldWidgets,e))},this.tokenizerUpdateFoldWidgets=function(e){e=e.data;e.first!=e.last&&this.foldWidgets.length>e.first&&this.foldWidgets.splice(e.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(e,t,n){"use strict";var d=e("../token_iterator").TokenIterator,C=e("../range").Range;t.BracketMatch=function(){this.findMatchingBracket=function(e,t){return 0!=e.column&&""!=(t=t||this.getLine(e.row).charAt(e.column-1))&&(t=t.match(/([\(\[\{])|([\)\]\}])/))?t[1]?this.$findClosingBracket(t[1],e):this.$findOpeningBracket(t[2],e):null},this.getBracketRange=function(e){var t,n,i=this.getLine(e.row),o=!0,r=i.charAt(e.column-1),s=r&&r.match(/([\(\[\{])|([\)\]\}])/);if(s||(r=i.charAt(e.column),e={row:e.row,column:e.column+1},s=r&&r.match(/([\(\[\{])|([\)\]\}])/),o=!1),!s)return null;if(s[1]){if(!(n=this.$findClosingBracket(s[1],e)))return null;t=C.fromPoints(e,n),o||(t.end.column++,t.start.column--),t.cursor=t.end}else{if(!(n=this.$findOpeningBracket(s[2],e)))return null;t=C.fromPoints(n,e),o||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.getMatchingBracketRanges=function(e,t){var n=this.getLine(e.row),i=/([\(\[\{])|([\)\]\}])/,o=!t&&n.charAt(e.column-1),r=o&&o.match(i);return r||(o=(void 0===t||t)&&n.charAt(e.column),e={row:e.row,column:e.column+1},r=o&&o.match(i)),r?(t=new C(e.row,e.column-1,e.row,e.column),(n=r[1]?this.$findClosingBracket(r[1],e):this.$findOpeningBracket(r[2],e))?[t,new C(n.row,n.column,n.row,n.column+1)]:[t]):null},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(e,t,n){var i=this.$brackets[e],o=1,r=new d(this,t.row,t.column),s=r.getCurrentToken();if(s=s||r.stepForward()){n=n||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)").replace(/-close\b/,"-(close|open)")+")+");for(var a=t.column-r.getCurrentTokenColumn()-2,l=s.value;;){for(;0<=a;){var c=l.charAt(a);if(c==i){if(0==--o)return{row:r.getCurrentTokenRow(),column:a+r.getCurrentTokenColumn()}}else c==e&&(o+=1);--a}for(;(s=r.stepBackward())&&!n.test(s.type););if(null==s)break;a=(l=s.value).length-1}return null}},this.$findClosingBracket=function(e,t,n){var i=this.$brackets[e],o=1,r=new d(this,t.row,t.column),s=r.getCurrentToken();if(s=s||r.stepForward()){n=n||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)").replace(/-open\b/,"-(close|open)")+")+");for(var a=t.column-r.getCurrentTokenColumn();;){for(var l=s.value,c=l.length;a<c;){var h=l.charAt(a);if(h==i){if(0==--o)return{row:r.getCurrentTokenRow(),column:a+r.getCurrentTokenColumn()}}else h==e&&(o+=1);a+=1}for(;(s=r.stepForward())&&!n.test(s.type););if(null==s)break;a=0}return null}},this.getMatchingTags=function(e){var e=new d(this,e.row,e.column),t=this.$findTagName(e);if(t)return"<"===e.stepBackward().value?this.$findClosingTag(e,t):this.$findOpeningTag(e,t)},this.$findTagName=function(e){var t=e.getCurrentToken(),n=!1,i=!1;if(t&&-1===t.type.indexOf("tag-name"))for(;(t=i?e.stepBackward():e.stepForward())&&("/>"===t.value?i=!0:-1!==t.type.indexOf("tag-name")&&(n=!0)),t&&!n;);return t},this.$findClosingTag=function(e,t){var n=t.value,i=t.value,o=0,r=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+1),s=(t=e.stepForward(),new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+t.value.length)),a=!1;do{var l,c=t;if(t=e.stepForward())if(">"!==t.value||a||(l=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+1),a=!0),-1!==t.type.indexOf("tag-name")){if(i===(n=t.value))if("<"===c.value)o++;else if("</"===c.value&&--o<0){e.stepBackward();var h=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+2),d=(t=e.stepForward(),new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+t.value.length));if(!(t=e.stepForward())||">"!==t.value)return;var u=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+1)}}else i===n&&"/>"===t.value&&--o<0&&(u=d=h=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+2),l=new C(s.end.row,s.end.column,s.end.row,s.end.column+1))}while(t&&0<=o);if(r&&l&&h&&u&&s&&d)return{openTag:new C(r.start.row,r.start.column,l.end.row,l.end.column),closeTag:new C(h.start.row,h.start.column,u.end.row,u.end.column),openTagName:s,closeTagName:d}},this.$findOpeningTag=function(e,t){var n,i=e.getCurrentToken(),o=t.value,r=0,s=e.getCurrentTokenRow(),a=e.getCurrentTokenColumn(),l=new C(s,a,s,a+2),c=(e.stepForward(),new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+t.value.length));if((t=e.stepForward())&&">"===t.value){var h=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+1);e.stepBackward(),e.stepBackward();do{if(t=i,s=e.getCurrentTokenRow(),n=(a=e.getCurrentTokenColumn())+t.value.length,i=e.stepBackward(),t)if(-1!==t.type.indexOf("tag-name")){if(o===t.value)if("<"===i.value){if(0<++r){for(var d=new C(s,a,s,n),u=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+1);(t=e.stepForward())&&">"!==t.value;);var g=new C(e.getCurrentTokenRow(),e.getCurrentTokenColumn(),e.getCurrentTokenRow(),e.getCurrentTokenColumn()+1)}}else"</"===i.value&&r--}else if("/>"===t.value){for(var p=0,m=i;m;){if(-1!==m.type.indexOf("tag-name")&&m.value===o){r--;break}if("<"===m.value)break;m=e.stepBackward(),p++}for(var f=0;f<p;f++)e.stepForward()}}while(i&&r<=0);return u&&g&&l&&h&&d&&c?{openTag:new C(u.start.row,u.start.column,g.end.row,g.end.column),closeTag:new C(l.start.row,l.start.column,h.end.row,h.end.column),openTagName:d,closeTagName:c}:void 0}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/undomanager","ace/edit_session/folding","ace/edit_session/bracket_match"],function(e,t,n){"use strict";var i=e("./lib/oop"),o=e("./lib/lang"),r=e("./bidihandler").BidiHandler,s=e("./config"),a=e("./lib/event_emitter").EventEmitter,l=e("./selection").Selection,c=e("./mode/text").Mode,h=e("./range").Range,d=e("./document").Document,u=e("./background_tokenizer").BackgroundTokenizer,g=e("./search_highlight").SearchHighlight,p=e("./undomanager").UndoManager,m=(f.prototype.setDocument=function(e){this.doc&&this.doc.off("change",this.$onChange),(this.doc=e).on("change",this.$onChange,!0),this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},f.prototype.getDocument=function(){return this.doc},f.prototype.$resetRowCache=function(e){var t;e?(t=this.$docRowCache.length,(e=this.$getRowCacheIndex(this.$docRowCache,e)+1)<t&&(this.$docRowCache.splice(e,t),this.$screenRowCache.splice(e,t))):(this.$docRowCache=[],this.$screenRowCache=[])},f.prototype.$getRowCacheIndex=function(e,t){for(var n=0,i=e.length-1;n<=i;){var o=n+i>>1,r=e[o];if(r<t)n=1+o;else{if(!(t<r))return o;i=o-1}}return n-1},f.prototype.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.destroyed||this.bgTokenizer.start(0)},f.prototype.onChangeFold=function(e){e=e.data;this.$resetRowCache(e.start.row)},f.prototype.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);!this.$fromUndo&&this.$undoManager&&(t&&t.length&&(this.$undoManager.add({action:"removeFolds",folds:t},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(e,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},f.prototype.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},f.fromJSON=function(e){"string"==typeof e&&(e=JSON.parse(e));var t=new p,n=(t.$undoStack=e.history.undo,t.$redoStack=e.history.redo,t.mark=e.history.mark,t.$rev=e.history.rev,new f(e.value));return e.folds.forEach(function(e){n.addFold("...",h.fromPoints(e.start,e.end))}),n.setAnnotations(e.annotations),n.setBreakpoints(e.breakpoints),n.setMode(e.mode),n.setScrollLeft(e.scrollLeft),n.setScrollTop(e.scrollTop),n.setUndoManager(t),n.selection.fromJSON(e.selection),n},f.prototype.toJSON=function(){return{annotations:this.$annotations,breakpoints:this.$breakpoints,folds:this.getAllFolds().map(function(e){return e.range}),history:this.getUndoManager(),mode:this.$mode.$id,scrollLeft:this.$scrollLeft,scrollTop:this.$scrollTop,selection:this.selection.toJSON(),value:this.doc.getValue()}},f.prototype.toString=function(){return this.doc.getValue()},f.prototype.getSelection=function(){return this.selection},f.prototype.getState=function(e){return this.bgTokenizer.getState(e)},f.prototype.getTokens=function(e){return this.bgTokenizer.getTokens(e)},f.prototype.getTokenAt=function(e,t){var n=this.bgTokenizer.getTokens(e),i=0;if(null==t)var o=n.length-1,i=this.getLine(e).length;else for(o=0;o<n.length&&!(t<=(i+=n[o].value.length));o++);return(e=n[o])?(e.index=o,e.start=i-e.value.length,e):null},f.prototype.setUndoManager=function(e){var t;this.$undoManager=e,this.$informUndoManager&&this.$informUndoManager.cancel(),e?(e.addSession(t=this),this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.mergeUndoDeltas=!1},this.$informUndoManager=o.delayedCall(this.$syncInformUndoManager)):this.$syncInformUndoManager=function(){}},f.prototype.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},f.prototype.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},f.prototype.getTabString=function(){return this.getUseSoftTabs()?o.stringRepeat(" ",this.getTabSize()):"\t"},f.prototype.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},f.prototype.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},f.prototype.setTabSize=function(e){this.setOption("tabSize",e)},f.prototype.getTabSize=function(){return this.$tabSize},f.prototype.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},f.prototype.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},f.prototype.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},f.prototype.setOverwrite=function(e){this.setOption("overwrite",e)},f.prototype.getOverwrite=function(){return this.$overwrite},f.prototype.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},f.prototype.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},f.prototype.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},f.prototype.getBreakpoints=function(){return this.$breakpoints},f.prototype.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},f.prototype.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},f.prototype.setBreakpoint=function(e,t){(t=void 0===t?"ace_breakpoint":t)?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},f.prototype.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},f.prototype.addMarker=function(e,t,n,i){var o=this.$markerId++,e={range:e,type:n||"line",renderer:"function"==typeof n?n:null,clazz:t,inFront:!!i,id:o};return i?(this.$frontMarkers[o]=e,this._signal("changeFrontMarker")):(this.$backMarkers[o]=e,this._signal("changeBackMarker")),o},f.prototype.addDynamicMarker=function(e,t){var n;if(e.update)return n=this.$markerId++,e.id=n,e.inFront=!!t,t?(this.$frontMarkers[n]=e,this._signal("changeFrontMarker")):(this.$backMarkers[n]=e,this._signal("changeBackMarker")),e},f.prototype.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];t&&(delete(t.inFront?this.$frontMarkers:this.$backMarkers)[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))},f.prototype.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},f.prototype.highlight=function(e){var t;this.$searchHighlight||(t=new g(null,"ace_selected-word","text"),this.$searchHighlight=this.addDynamicMarker(t)),this.$searchHighlight.setRegexp(e)},f.prototype.highlightLines=function(e,t,n,i){"number"!=typeof t&&(n=t,t=e),n=n||"ace_step";e=new h(e,0,t,1/0);return e.id=this.addMarker(e,n,"fullLine",i),e},f.prototype.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},f.prototype.getAnnotations=function(){return this.$annotations||[]},f.prototype.clearAnnotations=function(){this.setAnnotations([])},f.prototype.$detectNewLine=function(e){e=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=e?e[1]:"\n"},f.prototype.getWordRange=function(e,t){var n,i=this.getLine(e),o=!1,r=(n=(o=(o=0<t?!!i.charAt(t-1).match(this.tokenRe):o)||!!i.charAt(t).match(this.tokenRe))?this.tokenRe:/^\s+$/.test(i.slice(t-1,t+1))?/\s/:this.nonTokenRe,t);if(0<r){for(;0<=--r&&i.charAt(r).match(n););r++}for(var s=t;s<i.length&&i.charAt(s).match(n);)s++;return new h(e,r,e,s)},f.prototype.getAWordRange=function(e,t){for(var n=this.getWordRange(e,t),i=this.getLine(n.end.row);i.charAt(n.end.column).match(/[ \t]/);)n.end.column+=1;return n},f.prototype.setNewLineMode=function(e){this.doc.setNewLineMode(e)},f.prototype.getNewLineMode=function(){return this.doc.getNewLineMode()},f.prototype.setUseWorker=function(e){this.setOption("useWorker",e)},f.prototype.getUseWorker=function(){return this.$useWorker},f.prototype.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},f.prototype.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var n=e,i=n.path}else i=e||"ace/mode/text";this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new c),this.$modes[i]&&!n?(this.$onChangeMode(this.$modes[i]),t&&t()):(this.$modeId=i,s.loadModule(["mode",i],function(e){if(this.$modeId!==i)return t&&t();this.$modes[i]&&!n?this.$onChangeMode(this.$modes[i]):e&&e.Mode&&(e=new e.Mode(n),n||((this.$modes[i]=e).$id=i),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0))},f.prototype.$onChangeMode=function(e,t){var n,i,o;t||(this.$modeId=e.$id),this.$mode===e||(n=this.$mode,this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker(),void 0!==(i=e.getTokenizer()).on&&(o=this.onReloadTokenizer.bind(this),i.on("update",o)),this.bgTokenizer.setTokenizer(i),this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t)||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode",{oldMode:n,mode:e}))},f.prototype.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},f.prototype.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){s.warn("Could not load worker",e),this.$worker=null}},f.prototype.getMode=function(){return this.$mode},f.prototype.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},f.prototype.getScrollTop=function(){return this.$scrollTop},f.prototype.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},f.prototype.getScrollLeft=function(){return this.$scrollLeft},f.prototype.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},f.prototype.getLineWidgetMaxWidth=function(){var t;return null!=this.lineWidgetsWidth?this.lineWidgetsWidth:(t=0,this.lineWidgets.forEach(function(e){e&&e.screenWidth>t&&(t=e.screenWidth)}),this.lineWidgetWidth=t)},f.prototype.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),n=this.$rowLengthCache,i=0,o=0,r=this.$foldData[o],s=r?r.start.row:1/0,a=t.length,l=0;l<a;l++){if(s<l){if(a<=(l=r.end.row+1))break;s=(r=this.$foldData[o++])?r.start.row:1/0}null==n[l]&&(n[l]=this.$getStringScreenWidth(t[l])[0]),n[l]>i&&(i=n[l])}this.screenWidth=i}},f.prototype.getLine=function(e){return this.doc.getLine(e)},f.prototype.getLines=function(e,t){return this.doc.getLines(e,t)},f.prototype.getLength=function(){return this.doc.getLength()},f.prototype.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},f.prototype.insert=function(e,t){return this.doc.insert(e,t)},f.prototype.remove=function(e){return this.doc.remove(e)},f.prototype.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},f.prototype.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var n=e.length-1;-1!=n;n--){var i=e[n];"insert"==i.action||"remove"==i.action?this.doc.revertDelta(i):i.folds&&this.addFolds(i.folds)}!t&&this.$undoSelect&&(e.selectionBefore?this.selection.fromJSON(e.selectionBefore):this.selection.setRange(this.$getUndoSelection(e,!0))),this.$fromUndo=!1}},f.prototype.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var n=0;n<e.length;n++){var i=e[n];"insert"!=i.action&&"remove"!=i.action||this.doc.$safeApplyDelta(i)}!t&&this.$undoSelect&&(e.selectionAfter?this.selection.fromJSON(e.selectionAfter):this.selection.setRange(this.$getUndoSelection(e,!1))),this.$fromUndo=!1}},f.prototype.setUndoSelect=function(e){this.$undoSelect=e},f.prototype.$getUndoSelection=function(e,t){function n(e){return t?"insert"!==e.action:"insert"===e.action}for(var i,o,r=0;r<e.length;r++){var s=e[r];s.start&&(i?n(s)?(o=s.start,-1==i.compare(o.row,o.column)&&i.setStart(o),o=s.end,1==i.compare(o.row,o.column)&&i.setEnd(o)):(o=s.start,-1==i.compare(o.row,o.column)&&(i=h.fromPoints(s.start,s.start))):i=n(s)?h.fromPoints(s.start,s.end):h.fromPoints(s.start,s.start))}return i},f.prototype.replace=function(e,t){return this.doc.replace(e,t)},f.prototype.moveText=function(e,t,n){var i,o,r,s=this.getTextRange(e),a=this.getFoldsInRange(e),t=h.fromPoints(t,t);return n||(this.remove(e),o=e.start.row-e.end.row,(r=o?-e.end.column:e.start.column-e.end.column)&&(t.start.row==e.end.row&&t.start.column>e.end.column&&(t.start.column+=r),t.end.row==e.end.row)&&t.end.column>e.end.column&&(t.end.column+=r),o&&t.start.row>=e.end.row&&(t.start.row+=o,t.end.row+=o)),t.end=this.insert(t.start,s),a.length&&(i=e.start,n=t.start,o=n.row-i.row,r=n.column-i.column,this.addFolds(a.map(function(e){return(e=e.clone()).start.row==i.row&&(e.start.column+=r),e.end.row==i.row&&(e.end.column+=r),e.start.row+=o,e.end.row+=o,e}))),t},f.prototype.indentRows=function(e,t,n){n=n.replace(/\t/g,this.getTabString());for(var i=e;i<=t;i++)this.doc.insertInLine({row:i,column:0},n)},f.prototype.outdentRows=function(e){for(var t=e.collapseRows(),n=new h(0,0,0,0),i=this.getTabSize(),o=t.start.row;o<=t.end.row;++o){var r=this.getLine(o);n.start.row=o,n.end.row=o;for(var s=0;s<i&&" "==r.charAt(s);++s);s<i&&"\t"==r.charAt(s)?(n.start.column=s,n.end.column=s+1):(n.start.column=0,n.end.column=s),this.remove(n)}},f.prototype.$moveLines=function(e,t,n){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),n<0){if((o=this.getRowFoldStart(e+n))<0)return 0;var i=o-e}else if(0<n){if((o=this.getRowFoldEnd(t+n))>this.doc.getLength()-1)return 0;i=o-t}else{e=this.$clipRowToDocument(e);i=(t=this.$clipRowToDocument(t))-e+1}var o=new h(e,0,t,Number.MAX_VALUE),o=this.getFoldsInRange(o).map(function(e){return(e=e.clone()).start.row+=i,e.end.row+=i,e}),n=0==n?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+i,n),o.length&&this.addFolds(o),i},f.prototype.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},f.prototype.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},f.prototype.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},f.prototype.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},f.prototype.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},f.prototype.$clipPositionToDocument=function(e,t){var n;return t=Math.max(0,t),t=e<0?e=0:(n=this.doc.getLength())<=e?this.doc.getLine(e=n-1).length:Math.min(this.doc.getLine(e).length,t),{row:e,column:t}},f.prototype.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},f.prototype.setUseWrapMode=function(e){e!=this.$useWrapMode&&(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e&&(e=this.getLength(),this.$wrapData=Array(e),this.$updateWrapData(0,e-1)),this._signal("changeWrapMode"))},f.prototype.getUseWrapMode=function(){return this.$useWrapMode},f.prototype.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},f.prototype.adjustWrapLimit=function(e,t){var n=this.$wrapLimitRange,t=(n.max<0&&(n={min:t,max:t}),this.$constrainWrapLimit(e,n.min,n.max));return t!=this.$wrapLimit&&1<t&&(this.$wrapLimit=t,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},f.prototype.$constrainWrapLimit=function(e,t,n){return t&&(e=Math.max(t,e)),e=n?Math.min(n,e):e},f.prototype.getWrapLimit=function(){return this.$wrapLimit},f.prototype.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},f.prototype.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},f.prototype.$updateInternalDataOnChange=function(e){var t=this.$useWrapMode,n=e.action,i=e.start,o=e.end,r=i.row,s=o.row,a=s-r,l=null;if(this.$updating=!0,0!=a)if("remove"===n){this[t?"$wrapData":"$rowLengthCache"].splice(r,a);var c=this.$foldData,l=this.getFoldsInRange(e);this.removeFolds(l);var h=0;for((g=this.getFoldLine(o.row))&&(g.addRemoveChars(o.row,o.column,i.column-o.column),g.shiftRow(-a),(d=this.getFoldLine(r))&&d!==g&&(d.merge(g),g=d),h=c.indexOf(g)+1);h<c.length;h++)(g=c[h]).start.row>=o.row&&g.shiftRow(-a);s=r}else{var d=Array(a),u=(d.unshift(r,0),t?this.$wrapData:this.$rowLengthCache),c=(u.splice.apply(u,d),this.$foldData),h=0;for((g=this.getFoldLine(r))&&(0==(u=g.range.compareInside(i.row,i.column))?(g=g.split(i.row,i.column))&&(g.shiftRow(a),g.addRemoveChars(s,0,o.column-i.column)):-1==u&&(g.addRemoveChars(r,0,o.column-i.column),g.shiftRow(a)),h=c.indexOf(g)+1);h<c.length;h++)(g=c[h]).start.row>=r&&g.shiftRow(a)}else{var g,a=Math.abs(e.start.column-e.end.column);"remove"===n&&(l=this.getFoldsInRange(e),this.removeFolds(l),a=-a),(g=this.getFoldLine(r))&&g.addRemoveChars(r,i.column,a)}return t&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,t?this.$updateWrapData(r,s):this.$updateRowLengthCache(r,s),l},f.prototype.$updateRowLengthCache=function(e,t){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},f.prototype.$updateWrapData=function(e,t){var s,n,a=this.doc.getAllLines(),i=this.getTabSize(),o=this.$wrapData,r=this.$wrapLimit,l=e;for(t=Math.min(t,a.length-1);l<=t;)(n=this.getFoldLine(l,n))?(s=[],n.walk(function(e,t,n,i){var o;if(null!=e){(o=this.$getDisplayTokens(e,s.length))[0]=v;for(var r=1;r<o.length;r++)o[r]=I}else o=this.$getDisplayTokens(a[t].substring(i,n),s.length);s=s.concat(o)}.bind(this),n.end.row,a[n.end.row].length+1),o[n.start.row]=this.$computeWrapSplits(s,r,i),l=n.end.row+1):(s=this.$getDisplayTokens(a[l]),o[l]=this.$computeWrapSplits(s,r,i),l++)},f.prototype.$computeWrapSplits=function(o,e,r){if(0==o.length)return[];var s=[],t=o.length,a=0,l=0,c=this.$wrapAsCode,h=this.$indentedSoftWrap,d=e<=Math.max(2*r,8)||!1===h?0:Math.floor(e/2);function n(e){for(var t=e-a,n=a;n<e;n++){var i=o[n];12!==i&&2!==i||--t}s.length||(u=function(){var e=0;if(0===d)return e;if(h)for(var t=0;t<o.length;t++){var n=o[t];if(n==A)e+=1;else if(n==w)e+=r;else if(n!=S)break}return c&&!1!==h&&(e+=r),Math.min(e,d)}(),s.indent=u),l+=t,s.push(l),a=e}for(var u=0;e-u<t-a;){var i=a+e-u;if(o[i-1]>=A&&o[i]>=A)n(i);else if(o[i]==v||o[i]==I){for(;i!=a-1&&o[i]!=v;i--);if(a<i);else{for(i=a+e;i<o.length&&o[i]==I;i++);if(i==o.length)break}n(i)}else{for(var g=Math.max(i-(e-(e>>2)),a-1);g<i&&o[i]<v;)i--;if(c){for(;g<i&&o[i]<v;)i--;for(;g<i&&o[i]==b;)i--}else for(;g<i&&o[i]<A;)i--;g<i?n(++i):(o[i=a+e]==y&&i--,n(i-u))}}return s},f.prototype.$getDisplayTokens=function(e,t){var n,i=[];t=t||0;for(var o=0;o<e.length;o++){var r=e.charCodeAt(o);if(9==r){n=this.getScreenTabSize(i.length+t),i.push(w);for(var s=1;s<n;s++)i.push(S)}else 32==r?i.push(A):39<r&&r<48||57<r&&r<64?i.push(b):4352<=r&&x(r)?i.push(C,y):i.push(C)}return i},f.prototype.$getStringScreenWidth=function(e,t,n){if(0==t)return[0,0];var i,o;for(null==t&&(t=1/0),n=n||0,o=0;o<e.length&&(9==(i=e.charCodeAt(o))?n+=this.getScreenTabSize(n):4352<=i&&x(i)?n+=2:n+=1,!(t<n));o++);return[n,o]},f.prototype.getRowLength=function(e){var t=1;return this.lineWidgets&&(t+=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0),this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+t:t},f.prototype.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},f.prototype.getRowWrapIndent=function(e){var t;return this.$useWrapMode&&(e=this.screenToDocumentPosition(e,Number.MAX_VALUE),(t=this.$wrapData[e.row]).length)&&t[0]<e.column?t.indent:0},f.prototype.getScreenLastRowColumn=function(e){e=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(e.row,e.column)},f.prototype.getDocumentLastRowColumn=function(e,t){e=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(e)},f.prototype.getDocumentLastRowColumnPosition=function(e,t){e=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(e,Number.MAX_VALUE/10)},f.prototype.getRowSplitData=function(e){if(this.$useWrapMode)return this.$wrapData[e]},f.prototype.getScreenTabSize=function(e){return this.$tabSize-(e%this.$tabSize|0)},f.prototype.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},f.prototype.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},f.prototype.screenToDocumentPosition=function(e,t,n){if(e<0)return{row:0,column:0};for(var i,o,r,s=0,a=0,l=0,c=0,h=this.$screenRowCache,d=this.$getRowCacheIndex(h,e),u=h.length,g=(r=u&&0<=d?(l=h[d],s=this.$docRowCache[d],e>h[u-1]):!u,this.getLength()-1),p=this.getNextFoldLine(s),m=p?p.start.row:1/0;l<=e&&!(e<l+(c=this.getRowLength(s))||g<=s);)l+=c,m<++s&&(s=p.end.row+1,m=(p=this.getNextFoldLine(s,p))?p.start.row:1/0),r&&(this.$docRowCache.push(s),this.$screenRowCache.push(l));if(p&&p.start.row<=s)i=this.getFoldDisplayLine(p),s=p.start.row;else{if(l+c<=e||g<s)return{row:g,column:this.getLine(g).length};i=this.getLine(s),p=null}d=0,h=Math.floor(e-l);return this.$useWrapMode&&(u=this.$wrapData[s])&&(o=u[h],0<h)&&u.length&&(d=u.indent,a=u[h-1]||u[u.length-1],i=i.substring(a)),void 0!==n&&this.$bidiHandler.isBidiRow(l+h,s,h)&&(t=this.$bidiHandler.offsetToCol(n)),a+=this.$getStringScreenWidth(i,t-d)[1],this.$useWrapMode&&o<=a&&(a=o-1),p?p.idxToPosition(a):{row:s,column:a}},f.prototype.documentToScreenPosition=function(e,t){var n=void 0===t?this.$clipPositionToDocument(e.row,e.column):this.$clipPositionToDocument(e,t),i=(e=n.row,t=n.column,0),n=null;(a=this.getFoldAt(e,t,1))&&(e=a.start.row,t=a.start.column);for(var o,r,s=0,a=this.$docRowCache,l=this.$getRowCacheIndex(a,e),c=a.length,h=(r=c&&0<=l?(s=a[l],i=this.$screenRowCache[l],e>a[c-1]):!c,this.getNextFoldLine(s)),d=h?h.start.row:1/0;s<e;){if(d<=s){if(e<(o=h.end.row+1))break;d=(h=this.getNextFoldLine(o,h))?h.start.row:1/0}else o=s+1;i+=this.getRowLength(s),s=o,r&&(this.$docRowCache.push(s),this.$screenRowCache.push(i))}var u="",n=h&&d<=s?(u=this.getFoldDisplayLine(h,e,t),h.start.row):(u=this.getLine(e).substring(0,t),e),l=0;if(this.$useWrapMode){var g=this.$wrapData[n];if(g){for(var p=0;u.length>=g[p];)i++,p++;u=u.substring(g[p-1]||0,u.length),l=0<p?g.indent:0}}return this.lineWidgets&&this.lineWidgets[s]&&this.lineWidgets[s].rowsAbove&&(i+=this.lineWidgets[s].rowsAbove),{row:i,column:l+this.$getStringScreenWidth(u)[0]}},f.prototype.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},f.prototype.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},f.prototype.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var n=this.$wrapData.length,i=0,o=0,r=(t=this.$foldData[o++])?t.start.row:1/0;i<n;){var s=this.$wrapData[i];e+=s?s.length+1:1,r<++i&&(i=t.end.row+1,r=(t=this.$foldData[o++])?t.start.row:1/0)}else for(var e=this.getLength(),a=this.$foldData,o=0;o<a.length;o++)e-=(t=a[o]).end.row-t.start.row;return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},f.prototype.$setFontMetrics=function(r){this.$enableVarChar&&(this.$getStringScreenWidth=function(e,t,n){if(0===t)return[0,0];var i,o;for(t=t||1/0,n=n||0,o=0;o<e.length&&!(t<(n+="\t"===(i=e.charAt(o))?this.getScreenTabSize(n):r.getCharacterWidth(i)));o++);return[n,o]})},f.prototype.destroy=function(){this.destroyed||(this.bgTokenizer.setDocument(null),this.bgTokenizer.cleanup(),this.destroyed=!0),this.$stopWorker(),this.removeAllListeners(),this.doc&&this.doc.off("change",this.$onChange),this.selection.detach()},f);function f(e,t){this.doc,this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++f.$uid,this.$foldData.toString=function(){return this.join("\n")},this.bgTokenizer=new u((new c).getTokenizer(),this);var n=this;this.bgTokenizer.on("update",function(e){n._signal("tokenizerUpdate",e)}),this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new d(e)),this.setDocument(e),this.selection=new l(this),this.$bidiHandler=new r(this),s.resetOptions(this),this.setMode(t),s._signal("session",this),this.destroyed=!1}m.$uid=0,m.prototype.$modes=s.$modes,m.prototype.getValue=m.prototype.toString,m.prototype.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},m.prototype.$overwrite=!1,m.prototype.$mode=null,m.prototype.$modeId=null,m.prototype.$scrollTop=0,m.prototype.$scrollLeft=0,m.prototype.$wrapLimit=80,m.prototype.$useWrapMode=!1,m.prototype.$wrapLimitRange={min:null,max:null},m.prototype.lineWidgets=null,m.prototype.isFullWidth=x,i.implement(m.prototype,a);var C=1,y=2,v=3,I=4,b=9,A=10,w=11,S=12;function x(e){return!(e<4352)&&(4352<=e&&e<=4447||4515<=e&&e<=4519||4602<=e&&e<=4607||9001<=e&&e<=9002||11904<=e&&e<=11929||11931<=e&&e<=12019||12032<=e&&e<=12245||12272<=e&&e<=12283||12288<=e&&e<=12350||12353<=e&&e<=12438||12441<=e&&e<=12543||12549<=e&&e<=12589||12593<=e&&e<=12686||12688<=e&&e<=12730||12736<=e&&e<=12771||12784<=e&&e<=12830||12832<=e&&e<=12871||12880<=e&&e<=13054||13056<=e&&e<=19903||19968<=e&&e<=42124||42128<=e&&e<=42182||43360<=e&&e<=43388||44032<=e&&e<=55203||55216<=e&&e<=55238||55243<=e&&e<=55291||63744<=e&&e<=64255||65040<=e&&e<=65049||65072<=e&&e<=65106||65108<=e&&e<=65126||65128<=e&&e<=65131||65281<=e&&e<=65376||65504<=e&&e<=65510)}e("./edit_session/folding").Folding.call(m.prototype),e("./edit_session/bracket_match").BracketMatch.call(m.prototype),s.defineOptions(m.prototype,"session",{wrap:{set:function(e){e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e&&((this.$wrap=e)?(this.setWrapLimitRange(e="number"==typeof e?e:null,e),this.setUseWrapMode(!0)):this.setUseWrapMode(!1))},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode)&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){0<(e=parseInt(e))&&this.$tabSize!==e&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(e){this.setFoldStyle(e)},handlesSet:!0},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId},handlesSet:!0}}),t.EditSession=m}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,n){"use strict";var v=e("./lib/lang"),i=e("./lib/oop"),I=e("./range").Range;function o(){this.$options={}}o.prototype.set=function(e){return i.mixin(this.$options,e),this},o.prototype.getOptions=function(){return v.copyObject(this.$options)},o.prototype.setOptions=function(e){this.$options=e},o.prototype.find=function(e){var o,r=this.$options,e=this.$matchIterator(e,r);return!!e&&(o=null,e.forEach(function(e,t,n,i){return o=new I(e,t,n,i),!(t==i&&r.start&&r.start.start&&0!=r.skipCurrent&&o.isEqual(r.start)&&(o=null,1))}),o)},o.prototype.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var n=t.range,i=n?e.getLines(n.start.row,n.end.row):e.doc.getAllLines(),o=[],r=t.re;if(t.$isMultiLine){var s,a=r.length,l=i.length-a;e:for(var c=r.offset||0;c<=l;c++){for(var h=0;h<a;h++)if(-1==i[c+h].search(r[h]))continue e;var d=i[c],u=i[c+a-1],d=d.length-d.match(r[0])[0].length,u=u.match(r[a-1])[0].length;s&&s.end.row===c&&s.end.column>d||(o.push(s=new I(c,d,c+a-1,u)),2<a&&(c=c+a-2))}}else for(var g=0;g<i.length;g++)for(var p=v.getMatchOffsets(i[g],r),h=0;h<p.length;h++){var m=p[h];o.push(new I(g,m.offset,g,m.offset+m.length))}if(n){for(var f=n.start.column,C=n.end.column,g=0,h=o.length-1;g<h&&o[g].start.column<f&&0==o[g].start.row;)g++;for(var y=n.end.row-n.start.row;g<h&&o[h].end.column>C&&o[h].end.row==y;)h--;for(o=o.slice(g,h+1),g=0,h=o.length;g<h;g++)o[g].start.row+=n.start.row,o[g].end.row+=n.start.row}return o},o.prototype.replace=function(e,t){var n=this.$options,i=this.$assembleRegExp(n);if(n.$isMultiLine)return t;if(i){var o=i.exec(e);if(!o||o[0].length!=e.length)return null;if(t=e.replace(i,t),n.preserveCase){t=t.split("");for(var r=Math.min(e.length,e.length);r--;){var s=e[r];s&&s.toLowerCase()!=s?t[r]=t[r].toUpperCase():t[r]=t[r].toLowerCase()}t=t.join("")}return t}},o.prototype.$assembleRegExp=function(t,e){if(t.needle instanceof RegExp)return t.re=t.needle;var n=t.needle;if(!t.needle)return t.re=!1;t.regExp||(n=v.escapeRegExp(n));var i,o,r,s,a,l=t.caseSensitive?"gm":"gmi";try{new RegExp(n,"u"),t.$supportsUnicodeFlag=!0,l+="u"}catch(e){t.$supportsUnicodeFlag=!1}function c(e,t){return void 0===t&&(t=!0),(r&&o.$supportsUnicodeFlag?new RegExp("[\\p{L}\\p{N}_]","u"):new RegExp("\\w")).test(e)||o.regExp?r&&o.$supportsUnicodeFlag?t?"(?<=^|[^\\p{L}\\p{N}_])":"(?=[^\\p{L}\\p{N}_]|$)":"\\b":""}if(t.wholeWord&&(i=n,o=t,r=v.supportsLookbehind(),s=Array.from(i),a=s[0],s=s[s.length-1],n=c(a)+i+c(s,!1)),t.$isMultiLine=!e&&/[\n\r]/.test(n),t.$isMultiLine)return t.re=this.$assembleMultilineRegExp(n,l);try{var h=new RegExp(n,l)}catch(e){h=!1}return t.re=h},o.prototype.$assembleMultilineRegExp=function(e,t){for(var n=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),i=[],o=0;o<n.length;o++)try{i.push(new RegExp(n[o],t))}catch(e){return!1}return i},o.prototype.$matchIterator=function(h,n){var a,e,d,t,i,o,r,l,s,u=this.$assembleRegExp(n);return!!u&&(a=1==n.backwards,e=0!=n.skipCurrent,d=u.unicode,t=n.range,(i=(i=n.start)||(t?t[a?"end":"start"]:h.selection.getRange())).start&&(i=i[e!=a?"end":"start"]),o=t?t.start.row:0,r=t?t.end.row:h.getLength()-1,s=n.$isMultiLine?(l=u.length,function(e,t,n){var i=a?e-l+1:e;if(!(i<0||i+l>h.getLength())){var o=h.getLine(i),e=o.search(u[0]);if(!(!a&&e<t||-1===e)){for(var r=1;r<l;r++)if(-1==(o=h.getLine(i+r)).search(u[r]))return;var s=o.match(u[l-1])[0].length;if(!(a&&t<s))return!!n(i,e,i+l-1,s)||void 0}}}):a?function(e,t,n){var i,o=h.getLine(e),r=[];for(u.lastIndex=0;i=u.exec(o);){var s=i[0].length,a=i.index;if(!s){if(a>=o.length)break;u.lastIndex=a+=v.skipEmptyMatch(o,a,d)}if(i.index+s>t)break;r.push(i.index,s)}for(var l=r.length-1;0<=l;l-=2){var c=r[l-1];if(n(e,c,e,c+(s=r[l])))return!0}}:function(e,t,n){var i=h.getLine(e);for(u.lastIndex=t;o=u.exec(i);){var o,r=o[0].length;if(n(e,o=o.index,e,o+r))return!0;if(!r&&(u.lastIndex=o+=v.skipEmptyMatch(i,o,d),o>=i.length))return!1}},{forEach:a?function(e){var t=i.row;if(!s(t,i.column,e)){for(t--;o<=t;t--)if(s(t,Number.MAX_VALUE,e))return;if(0!=n.wrap)for(t=r,o=i.row;o<=t;t--)if(s(t,Number.MAX_VALUE,e))return}}:function(e){var t=i.row;if(!s(t,i.column,e)){for(t+=1;t<=r;t++)if(s(t,0,e))return;if(0!=n.wrap)for(t=o,r=i.row;t<=r;t++)if(s(t,0,e))return}}})},t.Search=o}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t,n){"use strict";var i,o=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(e,t){e.__proto__=t}:function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}))(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),a=e("../lib/keys"),r=e("../lib/useragent"),s=a.KEY_MODS,l=(c.prototype.$init=function(e,t,n){this.platform=t||(r.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=n},c.prototype.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),(this.commands[e.name]=e).bindKey&&this._buildKeyHash(e)},c.prototype.removeCommand=function(e,t){var n,i=e&&("string"==typeof e?e:e.name),o=(e=this.commands[i],t||delete this.commands[i],this.commandKeyBinding);for(n in o){var r,s=o[n];s==e?delete o[n]:Array.isArray(s)&&-1!=(r=s.indexOf(e))&&(s.splice(r,1),1==s.length)&&(o[n]=s[0])}},c.prototype.bindKey=function(e,i,o){if("object"==typeof e&&e&&(null==o&&(o=e.position),e=e[this.platform]),e)return"function"==typeof i?this.addCommand({exec:i,bindKey:e,name:i.name||e}):void e.split("|").forEach(function(e){var t="",n=(-1!=e.indexOf(" ")&&(e=(n=e.split(/\s+/)).pop(),n.forEach(function(e){e=this.parseKeys(e),e=s[e.hashId]+e.key;t+=(t?" ":"")+e,this._addCommandToBinding(t,"chainKeys")},this),t+=" "),this.parseKeys(e)),e=s[n.hashId]+n.key;this._addCommandToBinding(t+e,i,o)},this)},c.prototype._addCommandToBinding=function(e,t,n){var i=this.commandKeyBinding;if(t)if(!i[e]||this.$singleCommand)i[e]=t;else{Array.isArray(i[e])?-1!=(r=i[e].indexOf(t))&&i[e].splice(r,1):i[e]=[i[e]],"number"!=typeof n&&(n=h(t));for(var o=i[e],r=0;r<o.length;r++)if(n<h(o[r]))break;o.splice(r,0,t)}else delete i[e]},c.prototype.addCommands=function(n){n&&Object.keys(n).forEach(function(e){var t=n[e];if(t){if("string"==typeof t)return this.bindKey(t,e);"object"==typeof(t="function"==typeof t?{exec:t}:t)&&(t.name||(t.name=e),this.addCommand(t))}},this)},c.prototype.removeCommands=function(t){Object.keys(t).forEach(function(e){this.removeCommand(t[e])},this)},c.prototype.bindKeys=function(t){Object.keys(t).forEach(function(e){this.bindKey(e,t[e])},this)},c.prototype._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},c.prototype.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(e){return e}),n=t.pop(),i=a[n];if(a.FUNCTION_KEYS[i])n=a.FUNCTION_KEYS[i].toLowerCase();else{if(!t.length)return{key:n,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:n.toUpperCase(),hashId:-1}}for(var o=0,r=t.length;r--;){var s=a.KEY_MODS[t[r]];if(null==s)return"undefined"!=typeof console&&console.error("invalid modifier "+t[r]+" in "+e),!1;o|=s}return{key:n,hashId:o}},c.prototype.findKeyCommand=function(e,t){e=s[e]+t;return this.commandKeyBinding[e]},c.prototype.handleKeyboard=function(e,t,n,i){var o,r;if(!(i<0))return o=s[t]+n,r=this.commandKeyBinding[o],e.$keyChain&&(e.$keyChain+=" "+o,r=this.commandKeyBinding[e.$keyChain]||r),!r||"chainKeys"!=r&&"chainKeys"!=r[r.length-1]?(e.$keyChain&&(t&&4!=t||1!=n.length?(-1==t||0<i)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-o.length-1)),{command:r}):(e.$keyChain=e.$keyChain||o,{command:"null"})},c.prototype.getStatusText=function(e,t){return t.$keyChain||""},c);function c(e,t){this.$init(e,t,!1)}function h(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}o(u,d=l);var d,e=u;function u(e,t){e=d.call(this,e,t)||this;return e.$singleCommand=!0,e}e.call=function(e,t,n){l.prototype.$init.call(e,t,n,!0)},l.call=function(e,t,n){l.prototype.$init.call(e,t,n,!1)},t.HashHandler=e,t.MultiHashHandler=l}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(e,t,n){"use strict";var i,o,r=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(e,t){e.__proto__=t}:function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}))(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),s=e("../lib/oop"),a=e("../keyboard/hash_handler").MultiHashHandler,e=e("../lib/event_emitter").EventEmitter,r=(r(l,o=a),l.prototype.exec=function(e,t,n){if(Array.isArray(e)){for(var i=e.length;i--;)if(this.exec(e[i],t,n))return!0;return!1}var o;return!!(e="string"==typeof e?this.commands[e]:e)&&!(t&&t.$readOnly&&!e.readOnly||0!=this.$checkCommandState&&e.isAvailable&&!e.isAvailable(t)||((o={editor:t,command:e,args:n}).returnValue=this._emit("exec",o),this._signal("afterExec",o),!1===o.returnValue))},l.prototype.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.off("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},l.prototype.replay=function(t){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(t);try{this.$inReplay=!0,this.macro.forEach(function(e){"string"==typeof e?this.exec(e,t):this.exec(e[0],t,e[1])},this)}finally{this.$inReplay=!1}}},l.prototype.trimMacro=function(e){return e.map(function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e=e[1]?e:e[0]})},l);function l(e,t){t=o.call(this,t,e)||this;return t.byName=t.commands,t.setDefaultHandler("exec",function(e){return e.args?e.command.exec(e.editor,e.args,e.event,!1):e.command.exec(e.editor,{},e.event,!0)}),t}s.implement(r.prototype,e),t.CommandManager=r}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(e,t,n){"use strict";var l=e("../lib/lang"),i=e("../config"),c=e("../range").Range;function o(e,t){return{win:e,mac:t}}t.commands=[{name:"showSettingsMenu",description:"Show settings menu",bindKey:o("Ctrl-,","Command-,"),exec:function(t){i.loadModule("ace/ext/settings_menu",function(e){e.init(t),t.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",description:"Go to next error",bindKey:o("Alt-E","F4"),exec:function(t){i.loadModule("ace/ext/error_marker",function(e){e.showErrorMarker(t,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",description:"Go to previous error",bindKey:o("Alt-Shift-E","Shift-F4"),exec:function(t){i.loadModule("ace/ext/error_marker",function(e){e.showErrorMarker(t,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:o("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:o(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:o("Ctrl-L","Command-L"),exec:function(e,t){"number"!=typeof t||isNaN(t)||e.gotoLine(t),e.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:o("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:o("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",description:"Toggle fold widget",bindKey:o("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",description:"Toggle parent fold widget",bindKey:o("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:o(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldAllComments",description:"Fold all comments",bindKey:o(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAllComments()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:o("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:o("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:o("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:o("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:o("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:o("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:o("Ctrl-F","Command-F"),exec:function(t){i.loadModule("ace/ext/searchbox",function(e){e.Search(t)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:o("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:o("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:o("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:o("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:o("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:o("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:o("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:o("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:o("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:o("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:o("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:o("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:o("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:o("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:o("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:o("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:o("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:o("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:o("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:o("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:o(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:o("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:o(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:o("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:o("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:o("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:o("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:o("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:o("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:o("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:o(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(e){},readOnly:!0},{name:"cut",description:"Cut",exec:function(e){var t=e.$copyWithEmptySelection&&e.selection.isEmpty()?e.selection.getLineRange():e.selection.getRange();e._emit("cut",t),t.isEmpty()||e.session.remove(t),e.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:o("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:o("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:o("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:o("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:o("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},
multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:o("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:o("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:o("Ctrl-H","Command-Option-F"),exec:function(t){i.loadModule("ace/ext/searchbox",function(e){e.Search(t,!0)})}},{name:"undo",description:"Undo",bindKey:o("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",description:"Redo",bindKey:o("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:o("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:o("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:o("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:o("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:o("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:o("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:o("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:o("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:o("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:o("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:o("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:o("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:o("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:o("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:o("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:o("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:o("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(e,t){e.insert(l.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:o(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:o("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:o("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:o("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:o(null,null),exec:function(e){e.autoIndent()},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:o("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"openlink",bindKey:o("Ctrl+F3","F3"),exec:function(e){e.openLink()}},{name:"joinlines",description:"Join lines",bindKey:o(null,null),exec:function(e){for(var t=e.selection.isBackwards(),n=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),i=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),t=e.session.doc.getLine(n.row).length,o=e.session.doc.getTextRange(e.selection.getRange()).replace(/\n\s*/," ").length,r=e.session.doc.getLine(n.row),s=n.row+1;s<=i.row+1;s++){var a=l.stringTrimLeft(l.stringTrimRight(e.session.doc.getLine(s)));r+=a=0!==a.length?" "+a:a}i.row+1<e.session.doc.getLength()-1&&(r+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new c(n.row,0,i.row+2,0),r),0<o?(e.selection.moveCursorTo(n.row,n.column),e.selection.selectTo(n.row,n.column+o)):(t=e.session.doc.getLine(n.row).length>t?t+1:t,e.selection.moveCursorTo(n.row,t))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:o(null,null),exec:function(e){var t=e.session.doc.getLength()-1,n=e.session.doc.getLine(t).length,i=e.selection.rangeList.ranges,o=[];i.length<1&&(i=[e.selection.getRange()]);for(var r=0;r<i.length;r++)r!=i.length-1||i[r].end.row===t&&i[r].end.column===n||o.push(new c(i[r].end.row,i[r].end.column,t,n)),0===r?0===i[r].start.row&&0===i[r].start.column||o.push(new c(0,0,i[r].start.row,i[r].start.column)):o.push(new c(i[r-1].end.row,i[r-1].end.column,i[r].start.row,i[r].start.column));e.exitMultiSelectMode(),e.clearSelection();for(r=0;r<o.length;r++)e.selection.addRange(o[r],!1)},readOnly:!0,scrollIntoView:"none"},{name:"addLineAfter",description:"Add new line after the current line",exec:function(e){e.selection.clearSelection(),e.navigateLineEnd(),e.insert("\n")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",description:"Add new line before the current line",exec:function(e){e.selection.clearSelection();var t=e.getCursorPosition();e.selection.moveTo(t.row-1,Number.MAX_VALUE),e.insert("\n"),0===t.row&&e.navigateUp()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"openCommandPallete",exec:function(e){console.warn("This is an obsolete command. Please use `openCommandPalette` instead."),e.prompt({$type:"commands"})},readOnly:!0},{name:"openCommandPalette",description:"Open command palette",bindKey:o("F1","F1"),exec:function(e){e.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:o(null,null),exec:function(e){e.prompt({$type:"modes"})},readOnly:!0}];for(var r=1;r<9;r++)t.commands.push({name:"foldToLevel"+r,description:"Fold To Level "+r,level:r,exec:function(e){e.session.foldToLevel(this.level)},scrollIntoView:"center",readOnly:!0})}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/dom"],function(e,t,n){"use strict";var o=e("./lib/dom");function i(e){this.session=e,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}i.prototype.getRowLength=function(e){var t=this.lineWidgets&&this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},i.prototype.$getWidgetScreenLength=function(){var t=0;return this.lineWidgets.forEach(function(e){e&&e.rowCount&&!e.hidden&&(t+=e.rowCount)}),t},i.prototype.$onChangeEditor=function(e){this.attach(e.editor)},i.prototype.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),this.editor=e)&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets))},i.prototype.detach=function(e){var t=this.editor;t&&(this.editor=null,t.widgetManager=null,t.renderer.off("beforeRender",this.measureWidgets),t.renderer.off("afterRender",this.renderWidgets),t=this.session.lineWidgets)&&t.forEach(function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))})},i.prototype.updateOnFold=function(e,t){var n=t.lineWidgets;if(n&&e.action){for(var t=e.data,i=t.start.row,o=t.end.row,r="add"==e.action,s=i+1;s<o;s++)n[s]&&(n[s].hidden=r);n[o]&&(r?n[i]?n[o].hidden=r:n[i]=n[o]:(n[i]==n[o]&&(n[i]=void 0),n[o].hidden=r))}},i.prototype.updateOnChange=function(e){var t,n,i,o=this.session.lineWidgets;o&&(t=e.start.row,0!=(n=e.end.row-t))&&("remove"==e.action?(i=o.splice(t+1,n),!o[t]&&i[i.length-1]&&(o[t]=i.pop()),i.forEach(function(e){e&&this.removeLineWidget(e)},this)):(i=new Array(n),o[t]&&null!=o[t].column&&e.start.column>o[t].column&&t++,i.unshift(t,0),o.splice.apply(o,i)),this.$updateRows())},i.prototype.$updateRows=function(){var n,e=this.session.lineWidgets;e&&(n=!0,e.forEach(function(e,t){if(e)for(n=!1,e.row=t;e.$oldWidget;)e.$oldWidget.row=t,e=e.$oldWidget}),n)&&(this.session.lineWidgets=null)},i.prototype.$registerLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];return t&&(e.$oldWidget=t).el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1),this.session.lineWidgets[e.row]=e},i.prototype.addLineWidget=function(e){var t,n,i;return this.$registerLineWidget(e),e.session=this.session,this.editor&&(t=this.editor.renderer,e.html&&!e.el&&(e.el=o.createElement("div"),e.el.innerHTML=e.html),e.text&&!e.el&&(e.el=o.createElement("div"),e.el.textContent=e.text),e.el&&(o.addCssClass(e.el,"ace_lineWidgetContainer"),e.className&&o.addCssClass(e.el,e.className),e.el.style.position="absolute",e.el.style.zIndex="5",t.container.appendChild(e.el),e._inDocument=!0,e.coverGutter||(e.el.style.zIndex="3"),null==e.pixelHeight)&&(e.pixelHeight=e.el.offsetHeight),null==e.rowCount&&(e.rowCount=e.pixelHeight/t.layerConfig.lineHeight),n=this.session.getFoldAt(e.row,0),(e.$fold=n)&&(i=this.session.lineWidgets,e.row!=n.end.row||i[n.start.row]?e.hidden=!0:i[n.start.row]=e),this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,t),this.onWidgetChanged(e)),e},i.prototype.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},i.prototype.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,n=t&&t[e],i=[];n;)i.push(n),n=n.$oldWidget;return i},i.prototype.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},i.prototype.measureWidgets=function(e,t){var n=this.session._changedWidgets,i=t.layerConfig;if(n&&n.length){for(var o=1/0,r=0;r<n.length;r++){var s=n[r];if(s&&s.el&&s.session==this.session){if(!s._inDocument){if(this.session.lineWidgets[s.row]!=s)continue;s._inDocument=!0,t.container.appendChild(s.el)}s.h=s.el.offsetHeight,s.fixedWidth||(s.w=s.el.offsetWidth,s.screenWidth=Math.ceil(s.w/i.characterWidth));var a=s.h/i.lineHeight;s.coverLine&&(a-=this.session.getRowLineCount(s.row))<0&&(a=0),s.rowCount!=a&&(s.rowCount=a,s.row<o)&&(o=s.row)}}o!=1/0&&(this.session._emit("changeFold",{data:{start:{row:o}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},i.prototype.renderWidgets=function(e,t){var n=t.layerConfig,i=this.session.lineWidgets;if(i){for(var o=Math.min(this.firstRow,n.firstRow),r=Math.max(this.lastRow,n.lastRow,i.length);0<o&&!i[o];)o--;this.firstRow=n.firstRow,this.lastRow=n.lastRow,t.$cursorLayer.config=n;for(var s=o;s<=r;s++){var a,l=i[s];l&&l.el&&(l.hidden?l.el.style.top=-100-(l.pixelHeight||0)+"px":(l._inDocument||(l._inDocument=!0,t.container.appendChild(l.el)),a=t.$cursorLayer.getPixelPosition({row:s,column:0},!0).top,l.coverLine||(a+=n.lineHeight*this.session.getRowLineCount(l.row)),l.el.style.top=a-n.offset+"px",a=l.coverGutter?0:t.gutterWidth,l.fixedWidth||(a-=t.scrollLeft),l.el.style.left=a+"px",l.fullWidth&&l.screenWidth&&(l.el.style.minWidth=n.width+2*n.padding+"px"),l.fixedWidth?l.el.style.right=t.scrollBar.getWidth()+"px":l.el.style.right=""))}}},t.LineWidgets=i}),ace.define("ace/keyboard/gutter_handler",["require","exports","module","ace/lib/keys","ace/mouse/default_gutter_handler"],function(e,t,n){"use strict";var o=e("../lib/keys"),i=e("../mouse/default_gutter_handler").GutterTooltip;function r(e){this.editor=e,this.gutterLayer=e.renderer.$gutterLayer,this.element=e.renderer.$gutter,this.lines=e.renderer.$gutterLayer.$lines,this.activeRowIndex=null,this.activeLane=null,this.annotationTooltip=new i(this.editor)}r.prototype.addListener=function(){this.element.addEventListener("keydown",this.$onGutterKeyDown.bind(this)),this.element.addEventListener("focusout",this.$blurGutter.bind(this)),this.editor.on("mousewheel",this.$blurGutter.bind(this))},r.prototype.removeListener=function(){this.element.removeEventListener("keydown",this.$onGutterKeyDown.bind(this)),this.element.removeEventListener("focusout",this.$blurGutter.bind(this)),this.editor.off("mousewheel",this.$blurGutter.bind(this))},r.prototype.$onGutterKeyDown=function(e){var t;this.annotationTooltip.isOpen?(e.preventDefault(),e.keyCode===o.escape&&this.annotationTooltip.hideTooltip()):e.target===this.element?e.keyCode==o.enter&&(e.preventDefault(),t=this.editor.getCursorPosition().row,this.editor.isRowVisible(t)||this.editor.scrollToLine(t,!0,!0),setTimeout(function(){var e=this.$rowToRowIndex(this.gutterLayer.$cursorCell.row),t=this.$findNearestFoldWidget(e),n=this.$findNearestAnnotation(e);null===t&&null===n||(null===t&&null!==n||(null===t||null!==n)&&Math.abs(n-e)<Math.abs(t-e)?(this.activeRowIndex=n,this.activeLane="annotation",this.$focusAnnotation(this.activeRowIndex)):(this.activeRowIndex=t,this.activeLane="fold",this.$focusFoldWidget(this.activeRowIndex)))}.bind(this),10)):(this.$handleGutterKeyboardInteraction(e),setTimeout(function(){this.editor._signal("gutterkeydown",new s(e,this))}.bind(this),10))},r.prototype.$handleGutterKeyboardInteraction=function(e){if(e.keyCode===o.tab)e.preventDefault();else if(e.keyCode===o.escape)e.preventDefault(),this.$blurGutter(),this.element.focus(),this.lane=null;else if(e.keyCode===o.up)switch(e.preventDefault(),this.activeLane){case"fold":this.$moveFoldWidgetUp();break;case"annotation":this.$moveAnnotationUp()}else if(e.keyCode===o.down)switch(e.preventDefault(),this.activeLane){case"fold":this.$moveFoldWidgetDown();break;case"annotation":this.$moveAnnotationDown()}else if(e.keyCode===o.left)e.preventDefault(),this.$switchLane("annotation");else if(e.keyCode===o.right)e.preventDefault(),this.$switchLane("fold");else if(e.keyCode===o.enter||e.keyCode===o.space)switch(e.preventDefault(),this.activeLane){case"fold":if("start"===this.gutterLayer.session.foldWidgets[this.$rowIndexToRow(this.activeRowIndex)]){var t=this.$rowIndexToRow(this.activeRowIndex);this.editor.session.onFoldWidgetClick(this.$rowIndexToRow(this.activeRowIndex),e),setTimeout(function(){this.$rowIndexToRow(this.activeRowIndex)!==t&&(this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=this.$rowToRowIndex(t),this.$focusFoldWidget(this.activeRowIndex))}.bind(this),10);break}if("end"===this.gutterLayer.session.foldWidgets[this.$rowIndexToRow(this.activeRowIndex)])break;return;case"annotation":var n=this.lines.cells[this.activeRowIndex].element.childNodes[2].getBoundingClientRect(),i=this.annotationTooltip.getElement().style;i.left=n.right+"px",i.top=n.bottom+"px",this.annotationTooltip.showTooltip(this.$rowIndexToRow(this.activeRowIndex))}},r.prototype.$blurGutter=function(){if(null!==this.activeRowIndex)switch(this.activeLane){case"fold":this.$blurFoldWidget(this.activeRowIndex);break;case"annotation":this.$blurAnnotation(this.activeRowIndex)}this.annotationTooltip.isOpen&&this.annotationTooltip.hideTooltip()},r.prototype.$isFoldWidgetVisible=function(e){var t=this.editor.isRowFullyVisible(this.$rowIndexToRow(e)),e="none"!==this.$getFoldWidget(e).style.display;return t&&e},r.prototype.$isAnnotationVisible=function(e){var t=this.editor.isRowFullyVisible(this.$rowIndexToRow(e)),e="none"!==this.$getAnnotation(e).style.display;return t&&e},r.prototype.$getFoldWidget=function(e){return this.lines.get(e).element.childNodes[1]},r.prototype.$getAnnotation=function(e){return this.lines.get(e).element.childNodes[2]},r.prototype.$findNearestFoldWidget=function(e){if(this.$isFoldWidgetVisible(e))return e;for(var t=0;0<e-t||e+t<this.lines.getLength()-1;){if(0<=e-++t&&this.$isFoldWidgetVisible(e-t))return e-t;if(e+t<=this.lines.getLength()-1&&this.$isFoldWidgetVisible(e+t))return e+t}return null},r.prototype.$findNearestAnnotation=function(e){if(this.$isAnnotationVisible(e))return e;for(var t=0;0<e-t||e+t<this.lines.getLength()-1;){if(0<=e-++t&&this.$isAnnotationVisible(e-t))return e-t;if(e+t<=this.lines.getLength()-1&&this.$isAnnotationVisible(e+t))return e+t}return null},r.prototype.$focusFoldWidget=function(e){null!=e&&((e=this.$getFoldWidget(e)).classList.add(this.editor.renderer.keyboardFocusClassName),e.focus())},r.prototype.$focusAnnotation=function(e){null!=e&&((e=this.$getAnnotation(e)).classList.add(this.editor.renderer.keyboardFocusClassName),e.focus())},r.prototype.$blurFoldWidget=function(e){e=this.$getFoldWidget(e);e.classList.remove(this.editor.renderer.keyboardFocusClassName),e.blur()},r.prototype.$blurAnnotation=function(e){e=this.$getAnnotation(e);e.classList.remove(this.editor.renderer.keyboardFocusClassName),e.blur()},r.prototype.$moveFoldWidgetUp=function(){for(var e=this.activeRowIndex;0<e;)if(this.$isFoldWidgetVisible(--e))return this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=e,void this.$focusFoldWidget(this.activeRowIndex)},r.prototype.$moveFoldWidgetDown=function(){for(var e=this.activeRowIndex;e<this.lines.getLength()-1;)if(this.$isFoldWidgetVisible(++e))return this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=e,void this.$focusFoldWidget(this.activeRowIndex)},r.prototype.$moveAnnotationUp=function(){for(var e=this.activeRowIndex;0<e;)if(this.$isAnnotationVisible(--e))return this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=e,void this.$focusAnnotation(this.activeRowIndex)},r.prototype.$moveAnnotationDown=function(){for(var e=this.activeRowIndex;e<this.lines.getLength()-1;)if(this.$isAnnotationVisible(++e))return this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=e,void this.$focusAnnotation(this.activeRowIndex)},r.prototype.$switchLane=function(e){switch(e){case"annotation":"annotation"!==this.activeLane&&null!=(t=this.$findNearestAnnotation(this.activeRowIndex))&&(this.activeLane="annotation",this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=t,this.$focusAnnotation(this.activeRowIndex));break;case"fold":var t;"fold"!==this.activeLane&&null!=(t=this.$findNearestFoldWidget(this.activeRowIndex))&&(this.activeLane="fold",this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=t,this.$focusFoldWidget(this.activeRowIndex))}},r.prototype.$rowIndexToRow=function(e){e=this.lines.get(e);return e?e.row:null},r.prototype.$rowToRowIndex=function(e){for(var t=0;t<this.lines.getLength();t++)if(this.lines.get(t).row==e)return t;return null},t.GutterKeyboardHandler=r;a.prototype.getKey=function(){return o.keyCodeToString(this.domEvent.keyCode)},a.prototype.getRow=function(){return this.gutterKeyboardHandler.$rowIndexToRow(this.gutterKeyboardHandler.activeRowIndex)},a.prototype.isInAnnotationLane=function(){return"annotation"===this.gutterKeyboardHandler.activeLane},a.prototype.isInFoldLane=function(){return"fold"===this.gutterKeyboardHandler.activeLane};var s=a;function a(e,t){this.gutterKeyboardHandler=t,this.domEvent=e}t.GutterKeyboardEvent=s}),ace.define("ace/editor",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/line_widgets","ace/keyboard/gutter_handler","ace/config","ace/clipboard","ace/lib/keys"],function(e,t,n){"use strict";var d=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],i=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return{value:(e=e&&i>=e.length?void 0:e)&&e[i++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")},o=e("./lib/oop"),i=e("./lib/dom"),m=e("./lib/lang"),r=e("./lib/useragent"),s=e("./keyboard/textinput").TextInput,a=e("./mouse/mouse_handler").MouseHandler,l=e("./mouse/fold_handler").FoldHandler,c=e("./keyboard/keybinding").KeyBinding,h=e("./edit_session").EditSession,u=e("./search").Search,f=e("./range").Range,g=e("./lib/event_emitter").EventEmitter,p=e("./commands/command_manager").CommandManager,C=e("./commands/default_commands").commands,y=e("./config"),v=e("./token_iterator").TokenIterator,I=e("./line_widgets").LineWidgets,b=e("./keyboard/gutter_handler").GutterKeyboardHandler,A=e("./config").nls,w=e("./clipboard"),S=e("./lib/keys"),e=(x.prototype.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=m.delayedCall(this.endOperation.bind(this,!0)),this.on("change",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}.bind(this),!0)},x.prototype.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},x.prototype.endOperation=function(e){if(this.curOp&&this.session){if(e&&!1===e.returnValue||!this.session)return this.curOp=null;if((1!=e||!this.curOp.command||"mouse"!=this.curOp.command.name)&&(this._signal("beforeEndOperation"),this.curOp)){var e=this.curOp.command,t=e&&e.scrollIntoView;if(t){switch(t){case"center-animate":t="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var n=this.selection.getRange(),i=this.renderer.layerConfig;(n.start.row>=i.lastRow||n.end.row<=i.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==t&&this.renderer.animateScrolling(this.curOp.scrollTop)}e=this.selection.toJSON();this.curOp.selectionAfter=e,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(e),this.prevOp=this.curOp,this.curOp=null}}},x.prototype.$historyTracker=function(e){var t,n,i,o;this.$mergeUndoDeltas&&(t=this.prevOp,n=this.$mergeableCommands,i=t.command&&e.command.name==t.command.name,"insertstring"==e.command.name?(o=e.args,void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),i=i&&this.mergeNextCommand&&(!/\s/.test(o)||/\s/.test(t.args)),this.mergeNextCommand=!0):i=i&&-1!==n.indexOf(e.command.name),(i="always"!=this.$mergeUndoDeltas&&2e3<Date.now()-this.sequenceStartTime?!1:i)?this.session.mergeUndoDeltas=!0:-1!==n.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now()))},x.prototype.setKeyboardHandler=function(t,n){var i;t&&"string"==typeof t&&"ace"!=t?(this.$keybindingId=t,i=this,y.loadModule(["keybinding",t],function(e){i.$keybindingId==t&&i.keyBinding.setKeyboardHandler(e&&e.handler),n&&n()})):(this.$keybindingId=null,this.keyBinding.setKeyboardHandler(t),n&&n())},x.prototype.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},x.prototype.setSession=function(e){var t,n;this.session!=e&&(this.curOp&&this.endOperation(),this.curOp={},(t=this.session)&&(this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange),(n=this.session.getSelection()).off("changeCursor",this.$onCursorChange),n.off("changeSelection",this.$onSelectionChange)),(this.session=e)?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e)&&!e.destroyed&&e.bgTokenizer.scheduleStart()},x.prototype.getSession=function(){return this.session},x.prototype.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},x.prototype.getValue=function(){return this.session.getValue()},x.prototype.getSelection=function(){return this.selection},x.prototype.resize=function(e){this.renderer.onResize(e)},x.prototype.setTheme=function(e,t){this.renderer.setTheme(e,t)},x.prototype.getTheme=function(){return this.renderer.getTheme()},x.prototype.setStyle=function(e){this.renderer.setStyle(e)},x.prototype.unsetStyle=function(e){this.renderer.unsetStyle(e)},x.prototype.getFontSize=function(){return this.getOption("fontSize")||i.computedStyle(this.container).fontSize},x.prototype.setFontSize=function(e){this.setOption("fontSize",e)},x.prototype.$highlightBrackets=function(){var r;this.$highlightPending||((r=this).$highlightPending=!0,setTimeout(function(){r.$highlightPending=!1;var e,t,n,i,o=r.session;o&&!o.destroyed&&(o.$bracketHighlight&&(o.$bracketHighlight.markerIds.forEach(function(e){o.removeMarker(e)}),o.$bracketHighlight=null),e=r.getCursorPosition(),t=(t=r.getKeyboardHandler())&&t.$getDirectionForHighlight&&t.$getDirectionForHighlight(r),(t=o.getMatchingBracketRanges(e,t))||(n=new v(o,e.row,e.column).getCurrentToken())&&/\b(?:tag-open|tag-name)/.test(n.type)&&(n=o.getMatchingTags(e))&&(t=[n.openTagName,n.closeTagName]),(t=!t&&o.$mode.getMatching?o.$mode.getMatching(r.session):t)&&(i="ace_bracket",Array.isArray(t)?1==t.length&&(i="ace_error_bracket"):t=[t],2==t.length&&(0==f.comparePoints(t[0].end,t[1].start)?t=[f.fromPoints(t[0].start,t[1].end)]:0==f.comparePoints(t[0].start,t[1].end)&&(t=[f.fromPoints(t[1].start,t[0].end)])),o.$bracketHighlight={ranges:t,markerIds:t.map(function(e){return o.addMarker(e,i,"text")})}),r.getHighlightIndentGuides())&&r.renderer.$textLayer.$highlightIndentGuide()},50))},x.prototype.focus=function(){this.textInput.focus()},x.prototype.isFocused=function(){return this.textInput.isFocused()},x.prototype.blur=function(){this.textInput.blur()},x.prototype.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},x.prototype.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},x.prototype.$cursorChange=function(){this.renderer.updateCursor(),this.$highlightBrackets(),this.$updateHighlightActiveLine()},x.prototype.onDocumentChange=function(e){var t=this.session.$useWrapMode,n=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,n,t),this._signal("change",e),this.$cursorChange()},x.prototype.onTokenizerUpdate=function(e){e=e.data;this.renderer.updateLines(e.first,e.last)},x.prototype.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},x.prototype.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},x.prototype.onCursorChange=function(){this.$cursorChange(),this._signal("changeSelection")},x.prototype.$updateHighlightActiveLine=function(){var e,t,n=this.getSession();this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(e=!1),!this.renderer.$maxLines||1!==this.session.getLength()||1<this.renderer.$minLines||(e=!1)),n.$highlightLineMarker&&!e?(n.removeMarker(n.$highlightLineMarker.id),n.$highlightLineMarker=null):!n.$highlightLineMarker&&e?((t=new f(e.row,e.column,e.row,1/0)).id=n.addMarker(t,"ace_active-line","screenLine"),n.$highlightLineMarker=t):e&&(n.$highlightLineMarker.start.row=e.row,n.$highlightLineMarker.end.row=e.row,n.$highlightLineMarker.start.column=e.column,n._signal("changeBackMarker"))},x.prototype.onSelectionChange=function(e){var t,n,i=this.session,i=(i.$selectionMarker&&i.removeMarker(i.$selectionMarker),i.$selectionMarker=null,this.selection.isEmpty()?this.$updateHighlightActiveLine():(t=this.selection.getRange(),n=this.getSelectionStyle(),i.$selectionMarker=i.addMarker(t,"ace_selection",n)),this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp());this.session.highlight(i),this._signal("changeSelection")},x.prototype.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var n=t.start.column,i=t.end.column,e=e.getLine(t.start.row),t=e.substring(n,i);if(!(5e3<t.length)&&/[\w\d]/.test(t)){t=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:t}),e=e.substring(n-1,i+1);if(t.test(e))return t}}},x.prototype.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},x.prototype.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},x.prototype.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},x.prototype.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},x.prototype.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},x.prototype.onChangeWrapLimit=function(){this.renderer.updateFull()},x.prototype.onChangeWrapMode=function(){this.renderer.onResize(!0)},x.prototype.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},x.prototype.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},x.prototype.getCopyText=function(){var e=this.getSelectedText(),t=this.session.doc.getNewLineCharacter(),n=!1;if(!e&&this.$copyWithEmptySelection)for(var n=!0,i=this.selection.getAllRanges(),o=0;o<i.length;o++){var r=i[o];o&&i[o-1].start.row==r.start.row||(e+=this.session.getLine(r.start.row)+t)}var s={text:e};return this._signal("copy",s),w.lineMode=!!n&&s.text,s.text},x.prototype.onCopy=function(){this.commands.exec("copy",this)},x.prototype.onCut=function(){this.commands.exec("cut",this)},x.prototype.onPaste=function(e,t){this.commands.exec("paste",this,{text:e,event:t})},x.prototype.$handlePaste=function(e){this._signal("paste",e="string"==typeof e?{text:e}:e);var t=e.text,e=t===w.lineMode,n=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)e?n.insert({row:this.selection.lead.row,column:0},t):this.insert(t);else if(e)this.selection.rangeList.ranges.forEach(function(e){n.insert({row:e.start.row,column:0},t)});else{var i=t.split(/\r\n|\r|\n/),o=this.selection.rangeList.ranges,e=!(2!=i.length||i[0]&&i[1]);if(i.length!=o.length||e)return this.commands.exec("insertstring",this,t);for(var r=o.length;r--;){var s=o[r];s.isEmpty()||n.remove(s),n.insert(s.start,i[r])}}},x.prototype.execCommand=function(e,t){return this.commands.exec(e,this,t)},x.prototype.insert=function(e,t){var n,i=this.session,o=i.getMode(),r=this.getCursorPosition(),s=(this.getBehavioursEnabled()&&!t&&(n=o.transformAction(i.getState(r.row),"insertion",this,i,e))&&(e===n.text||this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1),e=n.text),"\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty()?this.session.getOverwrite()&&-1==e.indexOf("\n")&&((s=f.fromPoints(r,r)).end.column+=e.length,this.session.remove(s)):(s=this.getSelectionRange(),r=this.session.remove(s),this.clearSelection()),"\n"!=e&&"\r\n"!=e||(a=i.getLine(r.row),r.column>a.search(/\S|$/)&&(t=a.substr(r.column).search(/\S|$/),i.doc.removeInLine(r.row,r.column,r.column+t))),this.clearSelection(),r.column),t=i.getState(r.row),a=i.getLine(r.row),l=o.checkOutdent(t,a,e);i.insert(r,e),n&&n.selection&&(2==n.selection.length?this.selection.setSelectionRange(new f(r.row,s+n.selection[0],r.row,s+n.selection[1])):this.selection.setSelectionRange(new f(r.row+n.selection[0],n.selection[1],r.row+n.selection[2],n.selection[3]))),this.$enableAutoIndent&&(i.getDocument().isNewLine(e)&&(s=o.getNextLineIndent(t,a.slice(0,r.column),i.getTabString()),i.insert({row:r.row+1,column:0},s)),l)&&o.autoOutdent(t,i,r.row)},x.prototype.autoIndent=function(){for(var e,t,n,i,o,r=this.session,s=r.getMode(),a=(n=this.selection.isEmpty()?(t=0,r.doc.getLength()-1):(t=(e=this.getSelectionRange()).start.row,e.end.row),""),l="",c=r.getTabString(),h=t;h<=n;h++)0<h&&(a=r.getState(h-1),i=r.getLine(h-1),l=s.getNextLineIndent(a,i,c)),i=r.getLine(h),l!==(o=s.$getIndent(i))&&(0<o.length&&(o=new f(h,0,h,o.length),r.remove(o)),0<l.length)&&r.insert({row:h,column:0},l),s.autoOutdent(a,r,h)},x.prototype.onTextInput=function(e,t){if(!t)return this.keyBinding.onTextInput(e);this.startOperation({command:{name:"insertstring"}});e=this.applyComposition.bind(this,e,t);this.selection.rangeCount?this.forEachSelection(e):e(),this.endOperation()},x.prototype.applyComposition=function(e,t){var n;(t.extendLeft||t.extendRight)&&((n=this.selection.getRange()).start.column-=t.extendLeft,n.end.column+=t.extendRight,n.start.column<0&&(n.start.row--,n.start.column+=this.session.getLine(n.start.row).length+1),this.selection.setRange(n),e||n.isEmpty()||this.remove()),!e&&this.selection.isEmpty()||this.insert(e,!0),(t.restoreStart||t.restoreEnd)&&((n=this.selection.getRange()).start.column-=t.restoreStart,n.end.column-=t.restoreEnd,this.selection.setRange(n))},x.prototype.onCommandKey=function(e,t,n){return this.keyBinding.onCommandKey(e,t,n)},x.prototype.setOverwrite=function(e){this.session.setOverwrite(e)},x.prototype.getOverwrite=function(){return this.session.getOverwrite()},x.prototype.toggleOverwrite=function(){this.session.toggleOverwrite()},x.prototype.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},x.prototype.getScrollSpeed=function(){return this.getOption("scrollSpeed")},x.prototype.setDragDelay=function(e){this.setOption("dragDelay",e)},x.prototype.getDragDelay=function(){return this.getOption("dragDelay")},x.prototype.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},x.prototype.getSelectionStyle=function(){return this.getOption("selectionStyle")},x.prototype.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},x.prototype.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},x.prototype.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},x.prototype.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},x.prototype.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},x.prototype.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},x.prototype.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},x.prototype.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},x.prototype.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},x.prototype.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},x.prototype.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},x.prototype.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},x.prototype.setHighlightIndentGuides=function(e){this.renderer.setHighlightIndentGuides(e)},x.prototype.getHighlightIndentGuides=function(){return this.renderer.getHighlightIndentGuides()},x.prototype.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},x.prototype.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},x.prototype.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},x.prototype.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},x.prototype.setReadOnly=function(e){this.setOption("readOnly",e)},x.prototype.getReadOnly=function(){return this.getOption("readOnly")},x.prototype.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},x.prototype.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},x.prototype.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},x.prototype.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},x.prototype.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},x.prototype.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},x.prototype.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},x.prototype.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},x.prototype.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t,n,i,e=this.getSelectionRange();this.getBehavioursEnabled()&&(n=(t=this.session).getState(e.start.row),n=t.getMode().transformAction(n,"deletion",this,t,e),0===e.end.column&&"\n"==(i=t.getTextRange(e))[i.length-1]&&(i=t.getLine(e.end.row),/^\s+$/.test(i))&&(e.end.column=i.length),n)&&(e=n),this.session.remove(e),this.clearSelection()},x.prototype.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},x.prototype.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},x.prototype.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},x.prototype.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},x.prototype.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},x.prototype.setGhostText=function(e,t){this.session.widgetManager||(this.session.widgetManager=new I(this.session),this.session.widgetManager.attach(this)),this.renderer.setGhostText(e,t)},x.prototype.removeGhostText=function(){this.session.widgetManager&&this.renderer.removeGhostText()},x.prototype.transposeLetters=function(){var e,t,n,i;this.selection.isEmpty()&&0!==(t=(e=this.getCursorPosition()).column)&&(i=t<(i=this.session.getLine(e.row)).length?(n=i.charAt(t)+i.charAt(t-1),new f(e.row,t-1,e.row,t+1)):(n=i.charAt(t-1)+i.charAt(t-2),new f(e.row,t-2,e.row,t)),this.session.replace(i,n),this.session.selection.moveToPosition(i.end))},x.prototype.toLowerCase=function(){var e=this.getSelectionRange(),t=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),n=this.session.getTextRange(t);this.session.replace(t,n.toLowerCase()),this.selection.setSelectionRange(e)},x.prototype.toUpperCase=function(){var e=this.getSelectionRange(),t=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),n=this.session.getTextRange(t);this.session.replace(t,n.toUpperCase()),this.selection.setSelectionRange(e)},x.prototype.indent=function(){var e=this.session,t=this.getSelectionRange();if(!(t.start.row<t.end.row)){if(t.start.column<t.end.column){var n,i=e.getTextRange(t);if(!/^\s+$/.test(i))return n=this.$getSelectedRows(),void e.indentRows(n.first,n.last,"\t")}var o=e.getLine(t.start.row),i=t.start,r=e.getTabSize(),i=e.documentToScreenColumn(i.row,i.column);if(this.session.getUseSoftTabs())var s=r-i%r,a=m.stringRepeat(" ",s);else{for(s=i%r;" "==o[t.start.column-1]&&s;)t.start.column--,s--;this.selection.setSelectionRange(t),a="\t"}return this.insert(a)}n=this.$getSelectedRows(),e.indentRows(n.first,n.last,"\t")},x.prototype.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},x.prototype.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},x.prototype.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,n=[],i=e.first;i<=e.last;i++)n.push(t.getLine(i));n.sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0});for(var o=new f(0,0,0,0),i=e.first;i<=e.last;i++){var r=t.getLine(i);o.start.row=i,o.end.row=i,o.end.column=r.length,t.replace(o,n[i-e.first])}},x.prototype.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},x.prototype.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),n=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,n,e)},x.prototype.getNumberAt=function(e,t){for(var n=/[\-]?[0-9]+(?:\.[0-9]+)?/g,i=(n.lastIndex=0,this.session.getLine(e));n.lastIndex<t;){var o=n.exec(i);if(o.index<=t&&o.index+o[0].length>=t)return{value:o[0],start:o.index,end:o.index+o[0].length}}return null},x.prototype.modifyNumber=function(e){var t,n,i,o=this.selection.getCursor().row,r=this.selection.getCursor().column,s=new f(o,r-1,o,r),s=this.session.getTextRange(s);!isNaN(parseFloat(s))&&isFinite(s)?(s=this.getNumberAt(o,r))&&(i=0<=s.value.indexOf(".")?s.start+s.value.indexOf(".")+1:s.end,t=s.start+s.value.length-i,n=parseFloat(s.value),n*=Math.pow(10,t),i!==s.end&&r<i?e*=Math.pow(10,s.end-r-1):e*=Math.pow(10,s.end-r),i=(n=(n+=e)/Math.pow(10,t)).toFixed(t),e=new f(o,s.start,o,s.end),this.session.replace(e,i),this.moveCursorTo(o,Math.max(s.start+1,r+i.length-s.value.length))):this.toggleWord()},x.prototype.toggleWord=function(){for(var n,i=this.selection.getCursor().row,e=this.selection.getCursor().column,o=(this.selection.selectWord(),this.getSelectedText()),r=this.selection.getWordRange().start.column,t=o.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),s=e-r-1,a=(s<0&&(s=0),0),l=this,c=(o.match(/[A-Za-z0-9_]+/)&&t.forEach(function(e,t){n=a+e.length,a<=s&&s<=n&&(o=e,l.selection.clearSelection(),l.moveCursorTo(i,a+r),l.selection.selectTo(i,n+r)),a=n}),this.$toggleWordPairs),h=0;h<c.length;h++)for(var d=c[h],u=0;u<=1;u++){var g=+!u,p=o.match(new RegExp("^\\s?_?("+m.escapeRegExp(d[u])+")\\s?$","i"));p&&o.match(new RegExp("([_]|^|\\s)("+m.escapeRegExp(p[1])+")($|\\s)","g"))&&(p=o.replace(new RegExp(m.escapeRegExp(d[u]),"i"),function(e){var t=d[g];return e.toUpperCase()==e?t=t.toUpperCase():e.charAt(0).toUpperCase()==e.charAt(0)&&(t=t.substr(0,0)+d[g].charAt(0).toUpperCase()+t.substr(1)),t}),this.insert(p))}},x.prototype.findLinkAt=function(e,t){var n,i,o,e=this.session.getLine(e).split(/((?:https?|ftp):\/\/[\S]+)/),r=t,s=(r<0&&(r=0),0);try{for(var a=d(e),l=a.next();!l.done;l=a.next()){var c=l.value,h=s+c.length;if(s<=r&&r<=h&&c.match(/((?:https?|ftp):\/\/[\S]+)/)){o=c.replace(/[\s:.,'";}\]]+$/,"");break}s=h}}catch(e){n={error:e}}finally{try{l&&!l.done&&(i=a.return)&&i.call(a)}finally{if(n)throw n.error}}return o},x.prototype.openLink=function(){var e=this.selection.getCursor(),e=this.findLinkAt(e.row,e.column);return e&&window.open(e,"_blank"),null!=e},x.prototype.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},x.prototype.duplicateSelection=function(){var e,t=this.selection,n=this.session,i=t.getRange(),o=t.isBackwards();i.isEmpty()?(e=i.start.row,n.duplicateLines(e,e)):(e=o?i.start:i.end,n=n.insert(e,n.getTextRange(i)),i.start=e,i.end=n,t.setSelectionRange(i,o))},x.prototype.moveLinesDown=function(){this.$moveLines(1,!1)},x.prototype.moveLinesUp=function(){this.$moveLines(-1,!1)},x.prototype.moveText=function(e,t,n){return this.session.moveText(e,t,n)},x.prototype.copyLinesUp=function(){this.$moveLines(-1,!0)},x.prototype.copyLinesDown=function(){this.$moveLines(1,!0)},x.prototype.$moveLines=function(e,t){var n=this.selection;if(!n.inMultiSelectMode||this.inVirtualSelectionMode){var i=n.toOrientedRange(),o=this.$getSelectedRows(i),r=this.session.$moveLines(o.first,o.last,t?0:e);i.moveBy(r=t&&-1==e?0:r,0),n.fromOrientedRange(i)}else{for(var s=n.rangeList.ranges,a=(n.rangeList.detach(this.session),this.inVirtualSelectionMode=!0,0),l=0,c=s.length,h=0;h<c;h++){for(var d=h,u=(s[h].moveBy(a,0),(o=this.$getSelectedRows(s[h])).first),g=o.last;++h<c;){l&&s[h].moveBy(l,0);var p=this.$getSelectedRows(s[h]);if(t&&p.first!=g)break;if(!t&&p.first>g+1)break;g=p.last}for(h--,a=this.session.$moveLines(u,g,t?0:e),t&&-1==e&&(d=h+1);d<=h;)s[d].moveBy(a,0),d++;l+=a=t?a:0}n.fromOrientedRange(n.ranges[0]),n.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},x.prototype.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},x.prototype.onCompositionStart=function(e){this.renderer.showComposition(e)},x.prototype.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},x.prototype.onCompositionEnd=function(){this.renderer.hideComposition()},x.prototype.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},x.prototype.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},x.prototype.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},x.prototype.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},x.prototype.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},x.prototype.$moveByPage=function(e,t){var n=this.renderer,i=this.renderer.layerConfig,o=e*Math.floor(i.height/i.lineHeight),e=(!0===t?this.selection.$moveSelection(function(){this.moveCursorBy(o,0)}):!1===t&&(this.selection.moveCursorBy(o,0),this.selection.clearSelection()),n.scrollTop);n.scrollBy(0,o*i.lineHeight),null!=t&&n.scrollCursorIntoView(null,.5),n.animateScrolling(e)},x.prototype.selectPageDown=function(){this.$moveByPage(1,!0)},x.prototype.selectPageUp=function(){this.$moveByPage(-1,!0)},x.prototype.gotoPageDown=function(){this.$moveByPage(1,!1)},x.prototype.gotoPageUp=function(){this.$moveByPage(-1,!1)},x.prototype.scrollPageDown=function(){this.$moveByPage(1)},x.prototype.scrollPageUp=function(){this.$moveByPage(-1)},x.prototype.scrollToRow=function(e){this.renderer.scrollToRow(e)},x.prototype.scrollToLine=function(e,t,n,i){this.renderer.scrollToLine(e,t,n,i)},x.prototype.centerSelection=function(){var e=this.getSelectionRange(),e={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(e,.5)},x.prototype.getCursorPosition=function(){return this.selection.getCursor()},x.prototype.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},x.prototype.getSelectionRange=function(){return this.selection.getRange()},x.prototype.selectAll=function(){this.selection.selectAll()},x.prototype.clearSelection=function(){this.selection.clearSelection()},x.prototype.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},x.prototype.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},x.prototype.jumpToMatching=function(e,t){var n=this.getCursorPosition(),i=new v(this.session,n.row,n.column),o=i.getCurrentToken(),r=0,s=(o=o&&-1!==o.type.indexOf("tag-name")?i.stepBackward():o)||i.stepForward();if(s){var a,l,c=!1,h={},d=n.column-s.start,u={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(s.value.match(/[{}()\[\]]/g)){for(;d<s.value.length&&!c;d++)if(u[s.value[d]])switch(l=u[s.value[d]]+"."+s.type.replace("rparen","lparen"),isNaN(h[l])&&(h[l]=0),s.value[d]){case"(":case"[":case"{":h[l]++;break;case")":case"]":case"}":h[l]--,-1===h[l]&&(a="bracket",c=!0)}}else-1!==s.type.indexOf("tag-name")&&(isNaN(h[s.value])&&(h[s.value]=0),"<"===o.value&&1<r?h[s.value]++:"</"===o.value&&h[s.value]--,-1===h[s.value])&&(a="tag",c=!0)}while(c||(o=s,r++,s=i.stepForward(),d=0),s&&!c);if(a){if("bracket"===a)!(p=this.session.getBracketRange(n))&&(m=(p=new f(i.getCurrentTokenRow(),i.getCurrentTokenColumn()+d-1,i.getCurrentTokenRow(),i.getCurrentTokenColumn()+d-1)).start,t||m.row===n.row&&Math.abs(m.column-n.column)<2)&&(p=this.session.getBracketRange(m));else if("tag"===a){if(!s||-1===s.type.indexOf("tag-name"))return;var g,p,m=(m=0===(p=new f(i.getCurrentTokenRow(),i.getCurrentTokenColumn()-2,i.getCurrentTokenRow(),i.getCurrentTokenColumn()-2)).compare(n.row,n.column)&&(g=this.session.getMatchingTags(n))?g.openTag.contains(n.row,n.column)?(p=g.closeTag).start:(p=g.openTag,g.closeTag.start.row===n.row&&g.closeTag.start.column===n.column?p.end:p.start):m)||p.start}(m=p&&p.cursor||m)&&(e?p&&t?this.selection.setRange(p):p&&p.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(m.row,m.column):this.selection.moveTo(m.row,m.column))}}},x.prototype.gotoLine=function(e,t,n){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,n)},x.prototype.navigateTo=function(e,t){this.selection.moveTo(e,t)},x.prototype.navigateUp=function(e){var t;if(this.selection.isMultiLine()&&!this.selection.isBackwards())return t=this.selection.anchor.getPosition(),this.moveCursorToPosition(t);this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},x.prototype.navigateDown=function(e){var t;if(this.selection.isMultiLine()&&this.selection.isBackwards())return t=this.selection.anchor.getPosition(),this.moveCursorToPosition(t);this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},x.prototype.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},x.prototype.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},x.prototype.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},x.prototype.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},x.prototype.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},x.prototype.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},x.prototype.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},x.prototype.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},x.prototype.replace=function(e,t){t&&this.$search.set(t);var t=this.$search.find(this.session),n=0;return t&&(this.$tryReplace(t,e)&&(n=1),this.selection.setSelectionRange(t),this.renderer.scrollSelectionIntoView(t.start,t.end)),n},x.prototype.replaceAll=function(e,t){t&&this.$search.set(t);var n=this.$search.findAll(this.session),i=0;if(n.length){t=this.getSelectionRange();this.selection.moveTo(0,0);for(var o=n.length-1;0<=o;--o)this.$tryReplace(n[o],e)&&i++;this.selection.setSelectionRange(t)}return i},x.prototype.$tryReplace=function(e,t){var n=this.session.getTextRange(e);return null!==(t=this.$search.replace(n,t))?(e.end=this.session.replace(e,t),e):null},x.prototype.getLastSearchOptions=function(){return this.$search.getOptions()},x.prototype.find=function(e,t,n){t=t||{},"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&o.mixin(t,e);var i=this.selection.getRange(),e=(null==t.needle&&((e=this.session.getTextRange(i)||this.$search.$options.needle)||(i=this.session.getWordRange(i.start.row,i.start.column),e=this.session.getTextRange(i)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:i}),this.$search.find(this.session));return t.preventScroll?e:e?(this.revealRange(e,n),e):(t.backwards?i.start=i.end:i.end=i.start,void this.selection.setRange(i))},x.prototype.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},x.prototype.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},x.prototype.revealRange=function(e,t){this.session.unfold(e),this.selection.setSelectionRange(e);var n=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(n)},x.prototype.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},x.prototype.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},x.prototype.destroy=function(){this.$toDestroy&&(this.$toDestroy.forEach(function(e){e.destroy()}),this.$toDestroy=null),this.$mouseHandler&&this.$mouseHandler.destroy(),this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy(),this._$emitInputEvent&&this._$emitInputEvent.cancel(),this.removeAllListeners()},x.prototype.setAutoScrollEditorIntoView=function(e){var i,o,r,s,t,n,a;e&&(r=!1,(o=this).$scrollAnchor||(this.$scrollAnchor=document.createElement("div")),(s=this.$scrollAnchor).style.cssText="position:absolute",this.container.insertBefore(s,this.container.firstChild),t=this.on("changeSelection",function(){r=!0}),n=this.renderer.on("beforeRender",function(){r&&(i=o.renderer.container.getBoundingClientRect())}),a=this.renderer.on("afterRender",function(){var e,t,n;r&&i&&(o.isFocused()||o.searchBox&&o.searchBox.isFocused())&&(e=(t=o.renderer).$cursorLayer.$pixelPos,t=t.layerConfig,n=e.top-t.offset,null!=(r=0<=e.top&&n+i.top<0||!(e.top<t.height&&e.top+i.top+t.lineHeight>window.innerHeight)&&null)&&(s.style.top=n+"px",s.style.left=e.left+"px",s.style.height=t.lineHeight+"px",s.scrollIntoView(r)),r=i=null)}),this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",t),this.renderer.off("afterRender",a),this.renderer.off("beforeRender",n))})},x.prototype.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,i.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))},x.prototype.prompt=function(t,n,i){var o=this;y.loadModule("ace/ext/prompt",function(e){e.prompt(o,t,n,i)})},x);function x(e,t,n){this.session,this.$toDestroy=[];var i=e.getContainerElement();this.container=i,this.renderer=e,this.id="editor"+ ++x.$uid,this.commands=new p(r.isMac?"mac":"win",C),"object"==typeof document&&(this.textInput=new s(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new a(this),new l(this)),this.keyBinding=new c(this),this.$search=(new u).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=m.delayedCall(function(){this._signal("input",{}),this.session&&!this.session.destroyed&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(e,t){t._$emitInputEvent.schedule(31)}),this.setSession(t||n&&n.session||new h("")),y.resetOptions(this),n&&this.setOptions(n),y._signal("editor",this)}e.$uid=0,e.prototype.curOp=null,e.prototype.prevOp={},e.prototype.$mergeableCommands=["backspace","del","insertstring"],e.prototype.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],o.implement(e.prototype,g),y.defineOptions(e.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.textInput.setReadOnly(e),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(e){this.textInput.setCopyWithEmptySelection(e)},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},enableAutoIndent:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(e){this.session.setValue(e)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(e){this.setSession(e)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(e){this.renderer.$gutterLayer.setShowLineNumbers(e),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),e&&this.$relativeLineNumbers?k.attach(this):k.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(e){this.$showLineNumbers&&e?k.attach(this):k.detach(this)}},placeholder:{set:function(e){this.$updatePlaceholder||(this.$updatePlaceholder=function(){var e=this.session&&(this.renderer.$composition||1<this.session.getLength()||0<this.session.getLine(0).length);e&&this.renderer.placeholderNode?(this.renderer.off("afterRender",this.$updatePlaceholder),i.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null):e||this.renderer.placeholderNode?!e&&this.renderer.placeholderNode&&(this.renderer.placeholderNode.textContent=this.$placeholder||""):(this.renderer.on("afterRender",this.$updatePlaceholder),i.addCssClass(this.container,"ace_hasPlaceholder"),(e=i.createElement("div")).className="ace_placeholder",e.textContent=this.$placeholder||"",this.renderer.placeholderNode=e,this.renderer.content.appendChild(this.renderer.placeholderNode))}.bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},enableKeyboardAccessibility:{set:function(e){function t(e){e.target==this.renderer.scroller&&e.keyCode===S.enter&&(e.preventDefault(),e=this.getCursorPosition().row,this.isRowVisible(e)||this.scrollToLine(e,!0,!0),this.focus())}var n,i={name:"blurTextInput",description:"Set focus to the editor content div to allow tabbing through the page",bindKey:"Esc",exec:function(e){e.blur(),e.renderer.scroller.focus()},
readOnly:!0};e?(this.renderer.enableKeyboardAccessibility=!0,this.renderer.keyboardFocusClassName="ace_keyboard-focus",this.textInput.getElement().setAttribute("tabindex",-1),this.textInput.setNumberOfExtraLines(r.isWin?3:0),this.renderer.scroller.setAttribute("tabindex",0),this.renderer.scroller.setAttribute("role","group"),this.renderer.scroller.setAttribute("aria-roledescription",A("editor")),this.renderer.scroller.classList.add(this.renderer.keyboardFocusClassName),this.renderer.scroller.setAttribute("aria-label",A("Editor content, press Enter to start editing, press Escape to exit")),this.renderer.scroller.addEventListener("keyup",t.bind(this)),this.commands.addCommand(i),this.renderer.$gutter.setAttribute("tabindex",0),this.renderer.$gutter.setAttribute("aria-hidden",!1),this.renderer.$gutter.setAttribute("role","group"),this.renderer.$gutter.setAttribute("aria-roledescription",A("editor")),this.renderer.$gutter.setAttribute("aria-label",A("Editor gutter, press Enter to interact with controls using arrow keys, press Escape to exit")),this.renderer.$gutter.classList.add(this.renderer.keyboardFocusClassName),this.renderer.content.setAttribute("aria-hidden",!0),(n=n||new b(this)).addListener()):(this.renderer.enableKeyboardAccessibility=!1,this.textInput.getElement().setAttribute("tabindex",0),this.textInput.setNumberOfExtraLines(0),this.renderer.scroller.setAttribute("tabindex",-1),this.renderer.scroller.removeAttribute("role"),this.renderer.scroller.removeAttribute("aria-roledescription"),this.renderer.scroller.classList.remove(this.renderer.keyboardFocusClassName),this.renderer.scroller.removeAttribute("aria-label"),this.renderer.scroller.removeEventListener("keyup",t.bind(this)),this.commands.removeCommand(i),this.renderer.content.removeAttribute("aria-hidden"),this.renderer.$gutter.setAttribute("tabindex",-1),this.renderer.$gutter.setAttribute("aria-hidden",!0),this.renderer.$gutter.removeAttribute("role"),this.renderer.$gutter.removeAttribute("aria-roledescription"),this.renderer.$gutter.removeAttribute("aria-label"),this.renderer.$gutter.classList.remove(this.renderer.keyboardFocusClassName),n&&n.removeListener())},initialValue:!1},customScrollbar:"renderer",hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",highlightIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",useResizeObserver:"renderer",useSvgGutterIcons:"renderer",showFoldedAnnotations:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});var k={getText:function(e,t){return(Math.abs(e.selection.lead.row-t)||t+1+(t<9?"·":""))+""},getWidth:function(e,t,n){return Math.max(t.toString().length,(n.lastRow+1).toString().length,2)*n.characterWidth},update:function(e,t){t.renderer.$loop.schedule(t.renderer.CHANGE_GUTTER)},attach:function(e){e.renderer.$gutterLayer.$renderer=this,e.on("changeSelection",this.update),this.update(null,e)},detach:function(e){e.renderer.$gutterLayer.$renderer==this&&(e.renderer.$gutterLayer.$renderer=null),e.off("changeSelection",this.update),this.update(null,e)}};t.Editor=e}),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],function(e,t,n){"use strict";var s=e("../lib/dom");function i(e,t){this.element=e,this.canvasHeight=t||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0}i.prototype.moveContainer=function(e){s.translate(this.element,0,-(e.firstRowScreen*e.lineHeight%this.canvasHeight)-e.offset*this.$offsetCoefficient)},i.prototype.pageChanged=function(e,t){return Math.floor(e.firstRowScreen*e.lineHeight/this.canvasHeight)!==Math.floor(t.firstRowScreen*t.lineHeight/this.canvasHeight)},i.prototype.computeLineTop=function(e,t,n){var i=t.firstRowScreen*t.lineHeight,i=Math.floor(i/this.canvasHeight);return n.documentToScreenRow(e,0)*t.lineHeight-i*this.canvasHeight},i.prototype.computeLineHeight=function(e,t,n){return t.lineHeight*n.getRowLineCount(e)},i.prototype.getLength=function(){return this.cells.length},i.prototype.get=function(e){return this.cells[e]},i.prototype.shift=function(){this.$cacheCell(this.cells.shift())},i.prototype.pop=function(){this.$cacheCell(this.cells.pop())},i.prototype.push=function(e){if(Array.isArray(e)){this.cells.push.apply(this.cells,e);for(var t=s.createFragment(this.element),n=0;n<e.length;n++)t.appendChild(e[n].element);this.element.appendChild(t)}else this.cells.push(e),this.element.appendChild(e.element)},i.prototype.unshift=function(e){if(Array.isArray(e)){this.cells.unshift.apply(this.cells,e);for(var t=s.createFragment(this.element),n=0;n<e.length;n++)t.appendChild(e[n].element);this.element.firstChild?this.element.insertBefore(t,this.element.firstChild):this.element.appendChild(t)}else this.cells.unshift(e),this.element.insertAdjacentElement("afterbegin",e.element)},i.prototype.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},i.prototype.$cacheCell=function(e){e&&(e.element.remove(),this.cellCache.push(e))},i.prototype.createCell=function(e,t,n,i){var o,r=this.cellCache.pop();return r||(o=s.createElement("div"),i&&i(o),this.element.appendChild(o),r={element:o,text:"",row:e}),r.row=e,r},t.Lines=i}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines","ace/config"],function(e,t,n){"use strict";var w=e("../lib/dom"),i=e("../lib/oop"),s=e("../lib/lang"),o=e("../lib/event_emitter").EventEmitter,r=e("./lines").Lines,S=e("../config").nls,e=(a.prototype.setSession=function(e){this.session&&this.session.off("change",this.$updateAnnotations),(this.session=e)&&e.on("change",this.$updateAnnotations)},a.prototype.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},a.prototype.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},a.prototype.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var n=e[t],i=n.row,o=(o=this.$annotations[i])||(this.$annotations[i]={text:[],type:[]}),i=n.text,r=n.type,i=i?s.escapeHTML(i):n.html||"",i=(-1===o.text.indexOf(i)&&(o.text.push(i),o.type.push(r)),n.className);i?o.className=i:"error"==r?o.className=" ace_error":"warning"==r&&" ace_error"!=o.className?o.className=" ace_warning":"info"!=r||o.className||(o.className=" ace_info")}},a.prototype.$updateAnnotations=function(e){var t,n;this.$annotations.length&&(t=e.start.row,0!=(n=e.end.row-t))&&("remove"==e.action?this.$annotations.splice(t,1+n,null):((e=new Array(1+n)).unshift(t,1),this.$annotations.splice.apply(this.$annotations,e)))},a.prototype.update=function(e){this.config=e;for(var t=this.session,n=e.firstRow,i=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1),o=(this.oldLastRow=i,this.config=e,this.$lines.moveContainer(e),this.$updateCursorRow(),t.getNextFoldLine(n)),r=o?o.start.row:1/0,s=null,a=-1,l=n;;){if(r<l&&(l=o.end.row+1,r=(o=t.getNextFoldLine(l,o))?o.start.row:1/0),i<l){for(;this.$lines.getLength()>a+1;)this.$lines.pop();break}(s=this.$lines.get(++a))?s.row=l:(s=this.$lines.createCell(l,e,this.session,c),this.$lines.push(s)),this.$renderCell(s,e,o,l),l++}this._signal("afterRender"),this.$updateGutterWidth(e)},a.prototype.$updateGutterWidth=function(e){var t=this.session,n=t.gutterRenderer||this.$renderer,i=t.$firstLineNumber,o=this.$lines.last()?this.$lines.last().text:"",i=((this.$fixedWidth||t.$useWrapMode)&&(o=t.getLength()+i-1),n?n.getWidth(t,o,e):o.toString().length*e.characterWidth),n=this.$padding||this.$computePadding();(i+=n.left+n.right)===this.gutterWidth||isNaN(i)||(this.gutterWidth=i,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",i))},a.prototype.$updateCursorRow=function(){var e;this.$highlightGutterLine&&(e=this.session.selection.getCursor(),this.$cursorRow!==e.row)&&(this.$cursorRow=e.row)},a.prototype.updateLineHighlight=function(){if(this.$highlightGutterLine){var e=this.session.selection.cursor.row;if(this.$cursorRow=e,!this.$cursorCell||this.$cursorCell.row!=e){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var t=this.$lines.cells;this.$cursorCell=null;for(var n=0;n<t.length;n++){var i=t[n];if(i.row>=this.$cursorRow){if(i.row>this.$cursorRow){var o=this.session.getFoldLine(this.$cursorRow);if(!(0<n&&o&&o.start.row==t[n-1].row))break;i=t[n-1]}i.element.className="ace_gutter-active-line "+i.element.className,this.$cursorCell=i;break}}}}},a.prototype.scrollLines=function(e){var t=this.config;if(this.config=e,this.$updateCursorRow(),this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var n=Math.min(e.lastRow+e.gutterOffset,this.session.getLength()-1),i=this.oldLastRow;if(this.oldLastRow=n,!t||i<e.firstRow)return this.update(e);if(n<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var o=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<o;o--)this.$lines.shift();if(n<i)for(o=this.session.getFoldedRowCount(n+1,i);0<o;o--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLines(e,e.firstRow,t.firstRow-1)),i<n&&this.$lines.push(this.$renderLines(e,i+1,n)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(e)},a.prototype.$renderLines=function(e,t,n){for(var i=[],o=t,r=this.session.getNextFoldLine(o),s=r?r.start.row:1/0;s<o&&(o=r.end.row+1,s=(r=this.session.getNextFoldLine(o,r))?r.start.row:1/0),!(n<o);){var a=this.$lines.createCell(o,e,this.session,c);this.$renderCell(a,e,r,o),i.push(a),o++}return i},a.prototype.$renderCell=function(e,t,n,i){var o,r=e.element,s=this.session,a=r.childNodes[0],l=r.childNodes[1],c=r.childNodes[2],h=c.firstChild,d=s.$firstLineNumber,u=s.$breakpoints,g=s.$decorations,p=s.gutterRenderer||this.$renderer,m=this.$showFoldWidgets&&s.foldWidgets,f=n?n.start.row:Number.MAX_VALUE,C=t.lineHeight+"px",y=this.$useSvgGutterIcons?"ace_gutter-cell_svg-icons ":"ace_gutter-cell ",v=this.$useSvgGutterIcons?"ace_icon_svg":"ace_icon",p=(p?p.getText(s,i):i+d).toString();if(this.$highlightGutterLine&&(i==this.$cursorRow||n&&i<this.$cursorRow&&f<=i&&this.$cursorRow<=n.end.row)&&(y+="ace_gutter-active-line ",this.$cursorCell!=e)&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=e),u[i]&&(y+=u[i]),g[i]&&(y+=g[i]),this.$annotations[i]&&i!==f&&(y+=this.$annotations[i].className),o=m&&null==(o=m[i])?m[i]=s.getFoldWidget(i):o){d="ace_fold-widget ace_"+o,u="start"==o&&i==f&&i<n.end.row;if(u){d+=" ace_closed";for(var I="",b=!1,A=i+1;A<=n.end.row;A++)if(this.$annotations[A]){if(" ace_error"===this.$annotations[A].className){b=!0,I=" ace_error_fold";break}" ace_warning"===this.$annotations[A].className&&(b=!0,I=" ace_warning_fold")}y+=I}else d+=" ace_open";l.className!=d&&(l.className=d),w.setStyle(l.style,"height",C),w.setStyle(l.style,"display","inline-block"),l.setAttribute("role","button"),l.setAttribute("tabindex","-1");g=s.getFoldWidgetRange(i);g?l.setAttribute("aria-label",S("Toggle code folding, rows $0 through $1",[g.start.row+1,g.end.row+1])):n?l.setAttribute("aria-label",S("Toggle code folding, rows $0 through $1",[n.start.row+1,n.end.row+1])):l.setAttribute("aria-label",S("Toggle code folding, row $0",[i+1])),u?(l.setAttribute("aria-expanded","false"),l.setAttribute("title",S("Unfold code"))):(l.setAttribute("aria-expanded","true"),l.setAttribute("title",S("Fold code")))}else l&&(w.setStyle(l.style,"display","none"),l.setAttribute("tabindex","0"),l.removeAttribute("role"),l.removeAttribute("aria-label"));return b&&this.$showFoldedAnnotations?(c.className="ace_gutter_annotation",h.className=v,h.className+=I,w.setStyle(h.style,"height",C),w.setStyle(c.style,"display","block"),w.setStyle(c.style,"height",C),c.setAttribute("aria-label",S("Read annotations row $0",[p])),c.setAttribute("tabindex","-1"),c.setAttribute("role","button")):this.$annotations[i]?(c.className="ace_gutter_annotation",h.className=v,this.$useSvgGutterIcons?h.className+=this.$annotations[i].className:r.classList.add(this.$annotations[i].className.replace(" ","")),w.setStyle(h.style,"height",C),w.setStyle(c.style,"display","block"),w.setStyle(c.style,"height",C),c.setAttribute("aria-label",S("Read annotations row $0",[p])),c.setAttribute("tabindex","-1"),c.setAttribute("role","button")):(w.setStyle(c.style,"display","none"),c.removeAttribute("aria-label"),c.removeAttribute("role"),c.setAttribute("tabindex","0")),p!==a.data&&(a.data=p),r.className!=y&&(r.className=y),w.setStyle(e.element.style,"height",this.$lines.computeLineHeight(i,t,s)+"px"),w.setStyle(e.element.style,"top",this.$lines.computeLineTop(i,t,s)+"px"),e.text=p,"none"===c.style.display&&"none"===l.style.display?e.element.setAttribute("aria-hidden",!0):e.element.setAttribute("aria-hidden",!1),e},a.prototype.setHighlightGutterLine=function(e){this.$highlightGutterLine=e},a.prototype.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return 0},getText:function(){return""}}},a.prototype.getShowLineNumbers=function(){return this.$showLineNumbers},a.prototype.setShowFoldWidgets=function(e){e?w.addCssClass(this.element,"ace_folding-enabled"):w.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},a.prototype.getShowFoldWidgets=function(){return this.$showFoldWidgets},a.prototype.$computePadding=function(){var e;return this.element.firstChild?(e=w.computedStyle(this.element.firstChild),this.$padding={},this.$padding.left=(parseInt(e.borderLeftWidth)||0)+(parseInt(e.paddingLeft)||0)+1,this.$padding.right=(parseInt(e.borderRightWidth)||0)+(parseInt(e.paddingRight)||0),this.$padding):{left:0,right:0}},a.prototype.getRegion=function(e){var t=this.$padding||this.$computePadding(),n=this.element.getBoundingClientRect();return e.x<t.left+n.left?"markers":this.$showFoldWidgets&&e.x>n.right-t.right?"foldWidgets":void 0},a);function a(e){this.element=w.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new r(this.element),this.$lines.$offsetCoefficient=1}function c(e){var t=document.createTextNode(""),t=(e.appendChild(t),w.createElement("span")),t=(e.appendChild(t),w.createElement("span")),n=(e.appendChild(t),w.createElement("span"));return t.appendChild(n),e}e.prototype.$fixedWidth=!1,e.prototype.$highlightGutterLine=!0,e.prototype.$renderer="",e.prototype.$showLineNumbers=!0,e.prototype.$showFoldWidgets=!0,i.implement(e.prototype,o),t.Gutter=e}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(e,t,n){"use strict";var g=e("../range").Range,i=e("../lib/dom"),e=(o.prototype.setPadding=function(e){this.$padding=e},o.prototype.setSession=function(e){this.session=e},o.prototype.setMarkers=function(e){this.markers=e},o.prototype.elt=function(e,t){var n=-1!=this.i&&this.element.childNodes[this.i];n?this.i++:(n=document.createElement("div"),this.element.appendChild(n),this.i=-1),n.style.cssText=t,n.className=e},o.prototype.update=function(e){if(e){var t,n;for(n in this.config=e,this.i=0,this.markers){var i,o,r,s=this.markers[n];s.range?(r=s.range.clipRows(e.firstRow,e.lastRow)).isEmpty()||(r=r.toScreenRange(this.session),s.renderer?(i=this.$getTop(r.start.row,e),o=this.$padding+r.start.column*e.characterWidth,s.renderer(t,r,o,i,e)):"fullLine"==s.type?this.drawFullLineMarker(t,r,s.clazz,e):"screenLine"==s.type?this.drawScreenLineMarker(t,r,s.clazz,e):r.isMultiLine()?"text"==s.type?this.drawTextMarker(t,r,s.clazz,e):this.drawMultiLineMarker(t,r,s.clazz,e):this.drawSingleLineMarker(t,r,s.clazz+" ace_start ace_br15",e)):s.update(t,this,this.session,e)}if(-1!=this.i)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},o.prototype.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},o.prototype.drawTextMarker=function(e,t,n,i,o){for(var r,s=this.session,a=t.start.row,l=t.end.row,c=a,h=0,d=s.getScreenLastRowColumn(c),u=new g(c,t.start.column,c,h);c<=l;c++)u.start.row=u.end.row=c,u.start.column=c==a?t.start.column:s.getRowWrapIndent(c),u.end.column=d,r=h,h=d,d=c+1<l?s.getScreenLastRowColumn(c+1):c==l?0:t.end.column,this.drawSingleLineMarker(e,u,n+(c==a?" ace_start":"")+" ace_br"+((c==a||c==a+1&&t.start.column?1:0)|(r<h?2:0)|(d<h?4:0)|(c==l?8:0)),i,c==l?0:1,o)},o.prototype.drawMultiLineMarker=function(e,t,n,i,o){var r,s=this.$padding,a=i.lineHeight,l=this.$getTop(t.start.row,i),c=s+t.start.column*i.characterWidth;o=o||"",this.session.$bidiHandler.isBidiRow(t.start.row)?((r=t.clone()).end.row=r.start.row,r.end.column=this.session.getLine(r.start.row).length,this.drawBidiSingleLineMarker(e,r,n+" ace_br1 ace_start",i,null,o)):this.elt(n+" ace_br1 ace_start","height:"+a+"px;right:0;top:"+l+"px;left:"+c+"px;"+(o||"")),this.session.$bidiHandler.isBidiRow(t.end.row)?((r=t.clone()).start.row=r.end.row,r.start.column=0,this.drawBidiSingleLineMarker(e,r,n+" ace_br12",i,null,o)):(l=this.$getTop(t.end.row,i),c=t.end.column*i.characterWidth,this.elt(n+" ace_br12","height:"+a+"px;width:"+c+"px;top:"+l+"px;left:"+s+"px;"+(o||""))),(a=(t.end.row-t.start.row-1)*i.lineHeight)<=0||(l=this.$getTop(t.start.row+1,i),e=(t.start.column?1:0)|(t.end.column?0:8),this.elt(n+(e?" ace_br"+e:""),"height:"+a+"px;right:0;top:"+l+"px;left:"+s+"px;"+(o||"")))},o.prototype.drawSingleLineMarker=function(e,t,n,i,o,r){if(this.session.$bidiHandler.isBidiRow(t.start.row))return this.drawBidiSingleLineMarker(e,t,n,i,o,r);var e=i.lineHeight,o=(t.end.column+(o||0)-t.start.column)*i.characterWidth,s=this.$getTop(t.start.row,i),t=this.$padding+t.start.column*i.characterWidth;this.elt(n,"height:"+e+"px;width:"+o+"px;top:"+s+"px;left:"+t+"px;"+(r||""))},o.prototype.drawBidiSingleLineMarker=function(e,t,n,i,o,r){var s=i.lineHeight,a=this.$getTop(t.start.row,i),l=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach(function(e){this.elt(n,"height:"+s+"px;width:"+(e.width+(o||0))+"px;top:"+a+"px;left:"+(l+e.left)+"px;"+(r||""))},this)},o.prototype.drawFullLineMarker=function(e,t,n,i,o){var r=this.$getTop(t.start.row,i),s=i.lineHeight;t.start.row!=t.end.row&&(s+=this.$getTop(t.end.row,i)-r),this.elt(n,"height:"+s+"px;top:"+r+"px;left:0;right:0;"+(o||""))},o.prototype.drawScreenLineMarker=function(e,t,n,i,o){t=this.$getTop(t.start.row,i),i=i.lineHeight;this.elt(n,"height:"+i+"px;top:"+t+"px;left:0;right:0;"+(o||""))},o);function o(e){this.element=i.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)}e.prototype.$padding=0,t.Marker=e}),ace.define("ace/layer/text_util",["require","exports","module"],function(e,t,n){var i=new Set(["text","rparen","lparen"]);t.isTextToken=function(e){return i.has(e)}}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter","ace/config","ace/layer/text_util"],function(e,t,n){"use strict";var i=e("../lib/oop"),c=e("../lib/dom"),C=e("../lib/lang"),o=e("./lines").Lines,r=e("../lib/event_emitter").EventEmitter,y=e("../config").nls,v=e("./text_util").isTextToken,e=(s.prototype.$updateEolChar=function(){var e=this.session.doc,e="\n"==e.getNewLineCharacter()&&"windows"!=e.getNewLineMode()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=e)return this.EOL_CHAR=e,!0},s.prototype.setPadding=function(e){this.$padding=e,this.element.style.margin="0 "+e+"px"},s.prototype.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},s.prototype.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},s.prototype.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},s.prototype.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},s.prototype.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},s.prototype.setSession=function(e){(this.session=e)&&this.$computeTabString()},s.prototype.setShowInvisibles=function(e){return this.showInvisibles!=e&&("string"==typeof(this.showInvisibles=e)?(this.showSpaces=/tab/i.test(e),this.showTabs=/space/i.test(e),this.showEOL=/eol/i.test(e)):this.showSpaces=this.showTabs=this.showEOL=e,this.$computeTabString(),!0)},s.prototype.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},s.prototype.setHighlightIndentGuides=function(e){return this.$highlightIndentGuides!==e&&(this.$highlightIndentGuides=e)},s.prototype.$computeTabString=function(){for(var e,t,n,i,o,r,s=this.session.getTabSize(),a=(this.tabSize=s,this.$tabStrings=[0]),l=1;l<s+1;l++)this.showTabs?((r=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",r.textContent=C.stringRepeat(this.TAB_CHAR,l),a.push(r)):a.push(this.dom.createTextNode(C.stringRepeat(" ",l),this.element));this.displayIndentGuides&&(this.$indentGuideRe=/\s\S| \t|\t |\s$/,e="ace_indent-guide",t=this.showSpaces?" ace_invisible ace_invisible_space":"",n=this.showSpaces?C.stringRepeat(this.SPACE_CHAR,this.tabSize):C.stringRepeat(" ",this.tabSize),i=this.showTabs?" ace_invisible ace_invisible_tab":"",o=this.showTabs?C.stringRepeat(this.TAB_CHAR,this.tabSize):n,(r=this.dom.createElement("span")).className=e+t,r.textContent=n,this.$tabStrings[" "]=r,(r=this.dom.createElement("span")).className=e+i,r.textContent=o,this.$tabStrings["\t"]=r)},s.prototype.updateLines=function(e,t,n){if(this.config.lastRow!=e.lastRow||this.config.firstRow!=e.firstRow)return this.update(e);this.config=e;for(var i=Math.max(t,e.firstRow),o=Math.min(n,e.lastRow),r=this.element.childNodes,s=0,a=e.firstRow;a<i;a++){if(l=this.session.getFoldLine(a)){if(l.containsRow(i)){i=l.start.row;break}a=l.end.row}s++}for(var l,c=!1,a=i,h=(l=this.session.getNextFoldLine(a))?l.start.row:1/0;h<a&&(a=l.end.row+1,h=(l=this.session.getNextFoldLine(a,l))?l.start.row:1/0),!(o<a);){var d,u=r[s++];u&&(this.dom.removeChildren(u),this.$renderLine(u,a,a==h&&l),c&&(u.style.top=this.$lines.computeLineTop(a,e,this.session)+"px"),d=e.lineHeight*this.session.getRowLength(a)+"px",u.style.height!=d)&&(c=!0,u.style.height=d),a++}if(c)for(;s<this.$lines.cells.length;){var g=this.$lines.cells[s++];g.element.style.top=this.$lines.computeLineTop(g.row,e,this.session)+"px"}},s.prototype.scrollLines=function(e){var t=this.config;if(this.config=e,this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var n=e.lastRow,i=t?t.lastRow:-1;if(!t||i<e.firstRow)return this.update(e);if(n<t.firstRow)return this.update(e);if(!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var o=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<o;o--)this.$lines.shift();if(t.lastRow>e.lastRow)for(o=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);0<o;o--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLinesFragment(e,e.firstRow,t.firstRow-1)),e.lastRow>t.lastRow&&this.$lines.push(this.$renderLinesFragment(e,t.lastRow+1,e.lastRow)),this.$highlightIndentGuide()},s.prototype.$renderLinesFragment=function(e,t,n){for(var i=[],o=t,r=this.session.getNextFoldLine(o),s=r?r.start.row:1/0;s<o&&(o=r.end.row+1,s=(r=this.session.getNextFoldLine(o,r))?r.start.row:1/0),!(n<o);){var a=this.$lines.createCell(o,e,this.session),l=a.element;this.dom.removeChildren(l),c.setStyle(l.style,"height",this.$lines.computeLineHeight(o,e,this.session)+"px"),c.setStyle(l.style,"top",this.$lines.computeLineTop(o,e,this.session)+"px"),this.$renderLine(l,o,o==s&&r),this.$useLineGroups()?l.className="ace_line_group":l.className="ace_line",i.push(a),o++}return i},s.prototype.update=function(e){this.$lines.moveContainer(e);for(var t=(this.config=e).firstRow,n=e.lastRow,i=this.$lines;i.getLength();)i.pop();i.push(this.$renderLinesFragment(e,t,n))},s.prototype.$renderToken=function(e,t,n,i){for(var o,r,s=this,a=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC\u2066\u2067\u2068\u202A\u202B\u202D\u202E\u202C\u2069]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,l=this.dom.createFragment(this.element),c=0;o=a.exec(i);){var h,d,u=o[1],g=o[2],p=o[3],m=o[4],f=o[5];!s.showSpaces&&g||(h=c!=o.index?i.slice(c,o.index):"",c=o.index+o[0].length,h&&l.appendChild(this.dom.createTextNode(h,this.element)),u?(h=s.session.getScreenTabSize(t+o.index),l.appendChild(s.$tabStrings[h].cloneNode(!0)),t+=h-1):g?s.showSpaces?((d=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",d.textContent=C.stringRepeat(s.SPACE_CHAR,g.length),l.appendChild(d)):l.appendChild(this.dom.createTextNode(g,this.element)):p?((d=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",d.textContent=C.stringRepeat(s.SPACE_CHAR,p.length),l.appendChild(d)):m?(t+=1,(d=this.dom.createElement("span")).style.width=2*s.config.characterWidth+"px",d.className=s.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",d.textContent=s.showSpaces?s.SPACE_CHAR:m,l.appendChild(d)):f&&(t+=1,(d=this.dom.createElement("span")).style.width=2*s.config.characterWidth+"px",d.className="ace_cjk",d.textContent=f,l.appendChild(d)))}return l.appendChild(this.dom.createTextNode(c?i.slice(c):i,this.element)),v(n.type)?e.appendChild(l):(r="ace_"+n.type.replace(/\./g," ace_"),d=this.dom.createElement("span"),"fold"==n.type&&(d.style.width=n.value.length*this.config.characterWidth+"px",d.setAttribute("title",y("Unfold code"))),d.className=r,d.appendChild(l),e.appendChild(d)),t+i.length},s.prototype.renderIndentGuide=function(e,t,n){var i=t.search(this.$indentGuideRe);if(!(i<=0||n<=i)){if(" "==t[0]){for(var o=(i-=i%this.tabSize)/this.tabSize,r=0;r<o;r++)e.appendChild(this.$tabStrings[" "].cloneNode(!0));return this.$highlightIndentGuide(),t.substr(i)}if("\t"==t[0]){for(r=0;r<i;r++)e.appendChild(this.$tabStrings["\t"].cloneNode(!0));return this.$highlightIndentGuide(),t.substr(i)}this.$highlightIndentGuide()}return t},s.prototype.$highlightIndentGuide=function(){if(this.$highlightIndentGuides&&this.displayIndentGuides){this.$highlightIndentGuideMarker={indentLevel:void 0,start:void 0,end:void 0,dir:void 0};var e=this.session.doc.$lines;if(e){var t=this.session.selection.getCursor(),n=/^\s*/.exec(this.session.doc.getLine(t.row))[0].length,i=Math.floor(n/this.tabSize);if(this.$highlightIndentGuideMarker={indentLevel:i,start:t.row},this.session.$bracketHighlight)for(var o=this.session.$bracketHighlight.ranges,r=0;r<o.length;r++)if(t.row!==o[r].start.row){this.$highlightIndentGuideMarker.end=o[r].start.row,t.row>o[r].start.row?this.$highlightIndentGuideMarker.dir=-1:this.$highlightIndentGuideMarker.dir=1;break}if(!this.$highlightIndentGuideMarker.end&&""!==e[t.row]&&t.column===e[t.row].length){this.$highlightIndentGuideMarker.dir=1;for(r=t.row+1;r<e.length;r++){var s=e[r],a=/^\s*/.exec(s)[0].length;if(""!==s&&(this.$highlightIndentGuideMarker.end=r,a<=n))break}}this.$renderHighlightIndentGuide()}}},s.prototype.$clearActiveIndentGuide=function(){for(var e=this.$lines.cells,t=0;t<e.length;t++){var n=e[t].element.childNodes;if(0<n.length)for(var i=0;i<n.length;i++)if(n[i].classList&&n[i].classList.contains("ace_indent-guide-active")){n[i].classList.remove("ace_indent-guide-active");break}}},s.prototype.$setIndentGuideActive=function(e,t){""!==this.session.doc.getLine(e.row)&&(e=e.element.childNodes)&&(e=e[t-1])&&e.classList&&e.classList.contains("ace_indent-guide")&&e.classList.add("ace_indent-guide-active")},s.prototype.$renderHighlightIndentGuide=function(){if(this.$lines){var e=this.$lines.cells,t=(this.$clearActiveIndentGuide(),this.$highlightIndentGuideMarker.indentLevel);if(0!==t)if(1===this.$highlightIndentGuideMarker.dir)for(var n=0;n<e.length;n++){var i=e[n];if(this.$highlightIndentGuideMarker.end&&i.row>=this.$highlightIndentGuideMarker.start+1){if(i.row>=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(i,t)}}else for(n=e.length-1;0<=n;n--){i=e[n];if(this.$highlightIndentGuideMarker.end&&i.row<this.$highlightIndentGuideMarker.start){if(i.row<=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(i,t)}}}},s.prototype.$createLineElement=function(e){var t=this.dom.createElement("div");return t.className="ace_line",t.style.height=this.config.lineHeight+"px",t},s.prototype.$renderWrappedLine=function(e,t,n){var i=0,o=0,r=n[0],s=0,a=this.$createLineElement();e.appendChild(a);for(var l=0;l<t.length;l++){var c=t[l],h=c.value;if(0==l&&this.displayIndentGuides){if(i=h.length,!(h=this.renderIndentGuide(a,h,r)))continue;i-=h.length}if(i+h.length<r)s=this.$renderToken(a,s,c,h),i+=h.length;else{for(;i+h.length>=r;)s=this.$renderToken(a,s,c,h.substring(0,r-i)),h=h.substring(r-i),i=r,a=this.$createLineElement(),e.appendChild(a),a.appendChild(this.dom.createTextNode(C.stringRepeat(" ",n.indent),this.element)),s=0,r=n[++o]||Number.MAX_VALUE;0!=h.length&&(i+=h.length,s=this.$renderToken(a,s,c,h))}}n[n.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(a,s,null,"",!0)},s.prototype.$renderSimpleLine=function(e,t){for(var n=0,i=0;i<t.length;i++){var o=t[i],r=o.value;if(0!=i||!this.displayIndentGuides||(r=this.renderIndentGuide(e,r))){if(n+r.length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(e,n,o,r);n=this.$renderToken(e,n,o,r)}}},s.prototype.$renderOverflowMessage=function(e,t,n,i,o){n&&this.$renderToken(e,t,n,i.slice(0,this.MAX_LINE_LENGTH-t));n=this.dom.createElement("span");n.className="ace_inline_button ace_keyword ace_toggle_wrap",n.textContent=o?"<hide>":"<click to see more...>",e.appendChild(n)},s.prototype.$renderLine=function(e,t,n){var i,o,r=e;(i=(n=n||0==n?n:this.session.getFoldLine(t))?this.$getFoldLineTokens(t,n):this.session.getTokens(t)).length?(o=this.session.getRowSplitData(t))&&o.length?(this.$renderWrappedLine(e,i,o),r=e.lastChild):(r=e,this.$useLineGroups()&&(r=this.$createLineElement(),e.appendChild(r)),this.$renderSimpleLine(r,i)):this.$useLineGroups()&&(r=this.$createLineElement(),e.appendChild(r)),this.showEOL&&r&&(n&&(t=n.end.row),(o=this.dom.createElement("span")).className="ace_invisible ace_invisible_eol",o.textContent=t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,r.appendChild(o))},s.prototype.$getFoldLineTokens=function(e,t){var d=this.session,u=[];var g=d.getTokens(e);return t.walk(function(e,t,n,i,o){if(null!=e)u.push({type:"fold",value:e});else if((g=o?d.getTokens(t):g).length){for(var r,s=g,a=i,l=n,c=0,h=0;h+s[c].value.length<a;)if(h+=s[c].value.length,++c==s.length)return void!void 0;for(h!=a&&((r=s[c].value.substring(a-h)).length>l-a&&(r=r.substring(0,l-a)),u.push({type:s[c].type,value:r}),h=a+r.length,c+=1);h<l&&c<s.length;)(r=s[c].value).length+h>l?u.push({type:s[c].type,value:r.substring(0,l-h)}):u.push(s[c]),h+=r.length,c+=1}},t.end.row,this.session.getLine(t.end.row).length),u},s.prototype.$useLineGroups=function(){return this.session.getUseWrapMode()},s);function s(e){this.dom=c,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new o(this.element)}e.prototype.EOF_CHAR="¶",e.prototype.EOL_CHAR_LF="¬",e.prototype.EOL_CHAR_CRLF="¤",e.prototype.EOL_CHAR=e.prototype.EOL_CHAR_LF,e.prototype.TAB_CHAR="—",e.prototype.SPACE_CHAR="·",e.prototype.$padding=0,e.prototype.MAX_LINE_LENGTH=1e4,e.prototype.showInvisibles=!1,e.prototype.showSpaces=!1,e.prototype.showTabs=!1,e.prototype.showEOL=!1,e.prototype.displayIndentGuides=!0,e.prototype.$highlightIndentGuides=!0,e.prototype.$tabStrings=[],e.prototype.destroy={},e.prototype.onChangeTabSize=e.prototype.$computeTabString,i.implement(e.prototype,r),t.Text=e}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(e,t,n){"use strict";var c=e("../lib/dom"),e=(i.prototype.$updateOpacity=function(e){for(var t=this.cursors,n=t.length;n--;)c.setStyle(t[n].style,"opacity",e?"":"0")},i.prototype.$startCssAnimation=function(){for(var e=this.cursors,t=e.length;t--;)e[t].style.animationDuration=this.blinkInterval+"ms";this.$isAnimating=!0,setTimeout(function(){this.$isAnimating&&c.addCssClass(this.element,"ace_animate-blinking")}.bind(this))},i.prototype.$stopCssAnimation=function(){this.$isAnimating=!1,c.removeCssClass(this.element,"ace_animate-blinking")},i.prototype.setPadding=function(e){this.$padding=e},i.prototype.setSession=function(e){this.session=e},i.prototype.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},i.prototype.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},i.prototype.setSmoothBlinking=function(e){e!=this.smoothBlinking&&(this.smoothBlinking=e,c.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.restartTimer())},i.prototype.addCursor=function(){var e=c.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},i.prototype.removeCursor=function(){var e;if(1<this.cursors.length)return(e=this.cursors.pop()).parentNode.removeChild(e),e},i.prototype.hideCursor=function(){this.isVisible=!1,c.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},i.prototype.showCursor=function(){this.isVisible=!0,c.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},i.prototype.restartTimer=function(){var e,t=this.$updateCursors;clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&(this.$isSmoothBlinking=!1,c.removeCssClass(this.element,"ace_smooth-blinking")),t(!0),this.isBlinking&&this.blinkInterval&&this.isVisible?(this.smoothBlinking&&(this.$isSmoothBlinking=!0,setTimeout(function(){this.$isSmoothBlinking&&c.addCssClass(this.element,"ace_smooth-blinking")}.bind(this))),c.HAS_CSS_ANIMATION?this.$startCssAnimation():(e=function(){this.timeoutId=setTimeout(function(){t(!1)},.6*this.blinkInterval)}.bind(this),this.intervalId=setInterval(function(){t(!0),e()},this.blinkInterval),e())):this.$stopCssAnimation()},i.prototype.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e=e||this.session.selection.getCursor();var n=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,e.row)?this.session.$bidiHandler.getPosLeft(n.column):n.column*this.config.characterWidth),top:(n.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},i.prototype.isCursorInView=function(e,t){return 0<=e.top&&e.top<t.maxHeight},i.prototype.update=function(e){this.config=e;for(var t=this.session.$selectionMarkers,n=0,i=0,n=0,o=(t=void 0!==t&&0!==t.length?t:[{cursor:null}]).length;n<o;n++){var r,s,a=this.getPixelPosition(t[n].cursor,!0);(a.top>e.height+e.offset||a.top<0)&&1<n||(s=(r=this.cursors[i++]||this.addCursor()).style,this.drawCursor?this.drawCursor(r,a,e,t[n],this.session):this.isCursorInView(a,e)?(c.setStyle(s,"display","block"),c.translate(r,a.left,a.top),c.setStyle(s,"width",Math.round(e.characterWidth)+"px"),c.setStyle(s,"height",e.lineHeight+"px")):c.setStyle(s,"display","none"))}for(;this.cursors.length>i;)this.removeCursor();var l=this.session.getOverwrite();this.$setOverwrite(l),this.$pixelPos=a,this.restartTimer()},i.prototype.$setOverwrite=function(e){e!=this.overwrite&&((this.overwrite=e)?c.addCssClass(this.element,"ace_overwrite-cursors"):c.removeCssClass(this.element,"ace_overwrite-cursors"))},i.prototype.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)},i);function i(e){this.element=c.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),c.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)}e.prototype.$padding=0,e.prototype.drawCursor=null,t.Cursor=e}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t,n){"use strict";var i,o=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(e,t){e.__proto__=t}:function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}))(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),r=e("./lib/oop"),s=e("./lib/dom"),a=e("./lib/event"),e=e("./lib/event_emitter").EventEmitter,l=(c.prototype.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1},c);function c(e,t){this.element=s.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+t,this.inner=s.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent=" ",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,a.addListener(this.element,"scroll",this.onScroll.bind(this)),a.addListener(this.element,"mousedown",a.preventDefault)}r.implement(l.prototype,e);o(d,h=l),d.prototype.onScroll=function(){var e;this.skipEvent||(this.scrollTop=this.element.scrollTop,1!=this.coeff&&(e=this.element.clientHeight/this.scrollHeight,this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)),this._emit("scroll",{data:this.scrollTop})),this.skipEvent=!1},d.prototype.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},d.prototype.setHeight=function(e){this.element.style.height=e+"px"},d.prototype.setScrollHeight=function(e){32768<(this.scrollHeight=e)?(this.coeff=32768/e,e=32768):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},d.prototype.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)};var h,r=d;function d(e,t){var n=h.call(this,e,"-v")||this;return n.scrollTop=0,n.scrollHeight=0,t.$scrollbarWidth=n.width=s.scrollbarWidth(e.ownerDocument),n.inner.style.width=n.element.style.width=(n.width||15)+5+"px",n.$minWidth=0,n}r.prototype.setInnerHeight=r.prototype.setScrollHeight;o(g,u=l),g.prototype.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},g.prototype.getHeight=function(){return this.isVisible?this.height:0},g.prototype.setWidth=function(e){this.element.style.width=e+"px"},g.prototype.setInnerWidth=function(e){this.inner.style.width=e+"px"},g.prototype.setScrollWidth=function(e){this.inner.style.width=e+"px"},g.prototype.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)};var u,e=g;function g(e,t){e=u.call(this,e,"-h")||this;return e.scrollLeft=0,e.height=t.$scrollbarWidth,e.inner.style.height=e.element.style.height=(e.height||15)+5+"px",e}t.ScrollBar=r,t.ScrollBarV=r,t.ScrollBarH=e,t.VScrollBar=r,t.HScrollBar=e}),ace.define("ace/scrollbar_custom",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t,n){"use strict";var i,o=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(e,t){e.__proto__=t}:function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}))(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),r=e("./lib/oop"),s=e("./lib/dom"),a=e("./lib/event"),e=e("./lib/event_emitter").EventEmitter,l=(s.importCssString(".ace_editor>.ace_sb-v div, .ace_editor>.ace_sb-h div{\n  position: absolute;\n  background: rgba(128, 128, 128, 0.6);\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n  border: 1px solid #bbb;\n  border-radius: 2px;\n  z-index: 8;\n}\n.ace_editor>.ace_sb-v, .ace_editor>.ace_sb-h {\n  position: absolute;\n  z-index: 6;\n  background: none;\n  overflow: hidden!important;\n}\n.ace_editor>.ace_sb-v {\n  z-index: 6;\n  right: 0;\n  top: 0;\n  width: 12px;\n}\n.ace_editor>.ace_sb-v div {\n  z-index: 8;\n  right: 0;\n  width: 100%;\n}\n.ace_editor>.ace_sb-h {\n  bottom: 0;\n  left: 0;\n  height: 12px;\n}\n.ace_editor>.ace_sb-h div {\n  bottom: 0;\n  height: 100%;\n}\n.ace_editor>.ace_sb_grabbed {\n  z-index: 8;\n  background: #000;\n}","ace_scrollbar.css",!1),c.prototype.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1},c);function c(e,t){this.element=s.createElement("div"),this.element.className="ace_sb"+t,this.inner=s.createElement("div"),this.inner.className="",this.element.appendChild(this.inner),this.VScrollWidth=12,this.HScrollHeight=12,e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,a.addMultiMouseDownListener(this.element,[500,300,300],this,"onMouseDown")}r.implement(l.prototype,e);o(d,h=l),d.prototype.onMouseDown=function(e,t){var n,i,o,r,s;if("mousedown"===e&&(0===a.getButton(t)&&2!==t.detail))return t.target===this.inner?(n=this,i=t.clientY,o=t.clientY,r=this.thumbTop,a.capture(this.inner,function(e){i=e.clientY},function(){clearInterval(s)}),s=setInterval(function(){var e;void 0!==i&&(e=n.scrollTopFromThumbTop(r+i-o))!==n.scrollTop&&n._emit("scroll",{data:e})},20)):(e=t.clientY-this.element.getBoundingClientRect().top-this.thumbHeight/2,this._emit("scroll",{data:this.scrollTopFromThumbTop(e)})),a.preventDefault(t)},d.prototype.getHeight=function(){return this.height},d.prototype.scrollTopFromThumbTop=function(e){e=e*(this.pageHeight-this.viewHeight)/(this.slideHeight-this.thumbHeight);return(e>>=0)<0?e=0:e>this.pageHeight-this.viewHeight&&(e=this.pageHeight-this.viewHeight),e},d.prototype.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},d.prototype.setHeight=function(e){this.height=Math.max(0,e),this.slideHeight=this.height,this.viewHeight=this.height,this.setScrollHeight(this.pageHeight,!0)},d.prototype.setScrollHeight=function(e,t){(this.pageHeight!==e||t)&&(this.pageHeight=e,this.thumbHeight=this.slideHeight*this.viewHeight/this.pageHeight,this.thumbHeight>this.slideHeight&&(this.thumbHeight=this.slideHeight),this.thumbHeight<15&&(this.thumbHeight=15),this.inner.style.height=this.thumbHeight+"px",this.scrollTop>this.pageHeight-this.viewHeight)&&(this.scrollTop=this.pageHeight-this.viewHeight,this.scrollTop<0&&(this.scrollTop=0),this._emit("scroll",{data:this.scrollTop}))},d.prototype.setScrollTop=function(e){this.scrollTop=e,this.thumbTop=(e=e<0?0:e)*(this.slideHeight-this.thumbHeight)/(this.pageHeight-this.viewHeight),this.inner.style.top=this.thumbTop+"px"};var h,r=d;function d(e,t){var n=h.call(this,e,"-v")||this;return n.scrollTop=0,n.scrollHeight=0,n.parent=e,n.width=n.VScrollWidth,n.renderer=t,n.inner.style.width=n.element.style.width=(n.width||15)+"px",n.$minWidth=0,n}r.prototype.setInnerHeight=r.prototype.setScrollHeight;o(g,u=l),g.prototype.onMouseDown=function(e,t){var n,i,o,r,s;if("mousedown"===e&&(0===a.getButton(t)&&2!==t.detail))return t.target===this.inner?(n=this,i=t.clientX,o=t.clientX,r=this.thumbLeft,a.capture(this.inner,function(e){i=e.clientX},function(){clearInterval(s)}),s=setInterval(function(){var e;void 0!==i&&(e=n.scrollLeftFromThumbLeft(r+i-o))!==n.scrollLeft&&n._emit("scroll",{data:e})},20)):(e=t.clientX-this.element.getBoundingClientRect().left-this.thumbWidth/2,this._emit("scroll",{data:this.scrollLeftFromThumbLeft(e)})),a.preventDefault(t)},g.prototype.getHeight=function(){return this.isVisible?this.height:0},g.prototype.scrollLeftFromThumbLeft=function(e){e=e*(this.pageWidth-this.viewWidth)/(this.slideWidth-this.thumbWidth);return(e>>=0)<0?e=0:e>this.pageWidth-this.viewWidth&&(e=this.pageWidth-this.viewWidth),e},g.prototype.setWidth=function(e){this.width=Math.max(0,e),this.element.style.width=this.width+"px",this.slideWidth=this.width,this.viewWidth=this.width,this.setScrollWidth(this.pageWidth,!0)},g.prototype.setScrollWidth=function(e,t){(this.pageWidth!==e||t)&&(this.pageWidth=e,this.thumbWidth=this.slideWidth*this.viewWidth/this.pageWidth,this.thumbWidth>this.slideWidth&&(this.thumbWidth=this.slideWidth),this.thumbWidth<15&&(this.thumbWidth=15),this.inner.style.width=this.thumbWidth+"px",this.scrollLeft>this.pageWidth-this.viewWidth)&&(this.scrollLeft=this.pageWidth-this.viewWidth,this.scrollLeft<0&&(this.scrollLeft=0),this._emit("scroll",{data:this.scrollLeft}))},g.prototype.setScrollLeft=function(e){this.scrollLeft=e,this.thumbLeft=(e=e<0?0:e)*(this.slideWidth-this.thumbWidth)/(this.pageWidth-this.viewWidth),this.inner.style.left=this.thumbLeft+"px"};var u,e=g;function g(e,t){e=u.call(this,e,"-h")||this;return e.scrollLeft=0,e.scrollWidth=0,e.height=e.HScrollHeight,e.inner.style.height=e.element.style.height=(e.height||12)+"px",e.renderer=t,e}e.prototype.setInnerWidth=e.prototype.setScrollWidth,t.ScrollBar=r,t.ScrollBarV=r,t.ScrollBarH=e,t.VScrollBar=r,t.HScrollBar=e}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(e,t,n){"use strict";var i=e("./lib/event");function o(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=t||window;var n=this;this._flush=function(e){n.pending=!1;var t=n.changes;t&&(i.blockIdle(100),n.changes=0,n.onRender(t)),n.changes?n.$recursionLimit--<0||n.schedule():n.$recursionLimit=2}}o.prototype.schedule=function(e){this.changes=this.changes|e,this.changes&&!this.pending&&(i.nextFrame(this._flush),this.pending=!0)},o.prototype.clear=function(e){var t=this.changes;return this.changes=0,t},t.RenderLoop=o}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,n){var i=e("../lib/oop"),o=e("../lib/dom"),r=e("../lib/lang"),s=e("../lib/event"),a=e("../lib/useragent"),e=e("../lib/event_emitter").EventEmitter,l="function"==typeof ResizeObserver,c=(h.prototype.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",a.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},h.prototype.checkForSizeChanges=function(e){var t;!(e=void 0===e?this.$measureSizes():e)||this.$characterSize.width===e.width&&this.$characterSize.height===e.height||(this.$measureNode.style.fontWeight="bold",t=this.$measureSizes(),this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e}))},h.prototype.$addObserver=function(){var t=this;this.$observer=new window.ResizeObserver(function(e){t.checkForSizeChanges()}),this.$observer.observe(this.$measureNode)},h.prototype.$pollSizeChanges=function(){var t;return this.$pollSizeChangesTimer||this.$observer?this.$pollSizeChangesTimer:(t=this).$pollSizeChangesTimer=s.onIdle(function e(){t.checkForSizeChanges(),s.onIdle(e,500)},500)},h.prototype.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},h.prototype.$measureSizes=function(e){e={height:(e||this.$measureNode).clientHeight,width:(e||this.$measureNode).clientWidth/512};return 0===e.width||0===e.height?null:e},h.prototype.$measureCharWidth=function(e){return this.$main.textContent=r.stringRepeat(e,512),this.$main.getBoundingClientRect().width/512},h.prototype.getCharacterWidth=function(e){var t=this.charSizes[e];return t=void 0===t?this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width:t},h.prototype.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},h.prototype.$getZoom=function(e){return e&&e.parentElement?(window.getComputedStyle(e).zoom||1)*this.$getZoom(e.parentElement):1},h.prototype.$initTransformMeasureNodes=function(){function e(e,t){return["div",{style:"position: absolute;top:"+e+"px;left:"+t+"px;"}]}this.els=o.buildDom([e(0,0),e(200,0),e(0,200),e(200,200)],this.el)},h.prototype.transformCoordinates=function(e,t){function n(e,t,n){var i=e[1]*t[0]-e[0]*t[1];return[(-t[1]*n[0]+t[0]*n[1])/i,(+e[1]*n[0]-e[0]*n[1])/i]}function i(e,t){return[e[0]-t[0],e[1]-t[1]]}function o(e,t){return[e[0]+t[0],e[1]+t[1]]}function r(e,t){return[e*t[0],e*t[1]]}function s(e){e=e.getBoundingClientRect();return[e.left,e.top]}e=e&&r(1/this.$getZoom(this.el),e),this.els||this.$initTransformMeasureNodes();var a,l=s(this.els[0]),c=s(this.els[1]),h=s(this.els[2]),d=s(this.els[3]),d=n(i(d,c),i(d,h),i(o(c,h),o(d,l))),c=r(1+d[0],i(c,l)),h=r(1+d[1],i(h,l));return t?(a=d[0]*t[0]/200+d[1]*t[1]/200+1,t=o(r(t[0],c),r(t[1],h)),o(r(1/a/200,t),l)):(a=i(e,l),t=n(i(c,r(d[0],a)),i(h,r(d[1],a)),a),r(200,t))},h);function h(e){this.el=o.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=o.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=o.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),this.$measureNode.textContent=r.stringRepeat("X",512),this.$characterSize={width:0,height:0},l?this.$addObserver():this.checkForSizeChanges()}c.prototype.$characterSize={width:0,height:0},i.implement(c.prototype,e),t.FontMetrics=c}),ace.define("ace/css/editor-css",["require","exports","module"],function(e,t,n){
n.exports='\n.ace_br1 {border-top-left-radius    : 3px;}\n.ace_br2 {border-top-right-radius   : 3px;}\n.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}\n.ace_br4 {border-bottom-right-radius: 3px;}\n.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}\n.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}\n.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}\n.ace_br8 {border-bottom-left-radius : 3px;}\n.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}\n.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}\n.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}\n.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\n.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\n.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\n.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}\n\n\n.ace_editor {\n    position: relative;\n    overflow: hidden;\n    padding: 0;\n    font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'Source Code Pro\', \'source-code-pro\', monospace;\n    direction: ltr;\n    text-align: left;\n    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n}\n\n.ace_scroller {\n    position: absolute;\n    overflow: hidden;\n    top: 0;\n    bottom: 0;\n    background-color: inherit;\n    -ms-user-select: none;\n    -moz-user-select: none;\n    -webkit-user-select: none;\n    user-select: none;\n    cursor: text;\n}\n\n.ace_content {\n    position: absolute;\n    box-sizing: border-box;\n    min-width: 100%;\n    contain: style size layout;\n    font-variant-ligatures: no-common-ligatures;\n}\n\n.ace_keyboard-focus:focus {\n    box-shadow: inset 0 0 0 2px #5E9ED6;\n    outline: none;\n}\n\n.ace_dragging .ace_scroller:before{\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    content: \'\';\n    background: rgba(250, 250, 250, 0.01);\n    z-index: 1000;\n}\n.ace_dragging.ace_dark .ace_scroller:before{\n    background: rgba(0, 0, 0, 0.01);\n}\n\n.ace_gutter {\n    position: absolute;\n    overflow : hidden;\n    width: auto;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    cursor: default;\n    z-index: 4;\n    -ms-user-select: none;\n    -moz-user-select: none;\n    -webkit-user-select: none;\n    user-select: none;\n    contain: style size layout;\n}\n\n.ace_gutter-active-line {\n    position: absolute;\n    left: 0;\n    right: 0;\n}\n\n.ace_scroller.ace_scroll-left:after {\n    content: "";\n    position: absolute;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;\n    pointer-events: none;\n}\n\n.ace_gutter-cell, .ace_gutter-cell_svg-icons {\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    padding-left: 19px;\n    padding-right: 6px;\n    background-repeat: no-repeat;\n}\n\n.ace_gutter-cell_svg-icons .ace_gutter_annotation {\n    margin-left: -14px;\n    float: left;\n}\n\n.ace_gutter-cell .ace_gutter_annotation {\n    margin-left: -19px;\n    float: left;\n}\n\n.ace_gutter-cell.ace_error, .ace_icon.ace_error, .ace_icon.ace_error_fold {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");\n    background-repeat: no-repeat;\n    background-position: 2px center;\n}\n\n.ace_gutter-cell.ace_warning, .ace_icon.ace_warning, .ace_icon.ace_warning_fold {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");\n    background-repeat: no-repeat;\n    background-position: 2px center;\n}\n\n.ace_gutter-cell.ace_info, .ace_icon.ace_info {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");\n    background-repeat: no-repeat;\n    background-position: 2px center;\n}\n.ace_dark .ace_gutter-cell.ace_info, .ace_dark .ace_icon.ace_info {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");\n}\n\n.ace_icon_svg.ace_error {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJyZWQiIHNoYXBlLXJlbmRlcmluZz0iZ2VvbWV0cmljUHJlY2lzaW9uIj4KPGNpcmNsZSBmaWxsPSJub25lIiBjeD0iOCIgY3k9IjgiIHI9IjciIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGxpbmUgeDE9IjExIiB5MT0iNSIgeDI9IjUiIHkyPSIxMSIvPgo8bGluZSB4MT0iMTEiIHkxPSIxMSIgeDI9IjUiIHkyPSI1Ii8+CjwvZz4KPC9zdmc+");\n    background-color: crimson;\n}\n.ace_icon_svg.ace_warning {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJkYXJrb3JhbmdlIiBzaGFwZS1yZW5kZXJpbmc9Imdlb21ldHJpY1ByZWNpc2lvbiI+Cjxwb2x5Z29uIHN0cm9rZS1saW5lam9pbj0icm91bmQiIGZpbGw9Im5vbmUiIHBvaW50cz0iOCAxIDE1IDE1IDEgMTUgOCAxIi8+CjxyZWN0IHg9IjgiIHk9IjEyIiB3aWR0aD0iMC4wMSIgaGVpZ2h0PSIwLjAxIi8+CjxsaW5lIHgxPSI4IiB5MT0iNiIgeDI9IjgiIHkyPSIxMCIvPgo8L2c+Cjwvc3ZnPg==");\n    background-color: darkorange;\n}\n.ace_icon_svg.ace_info {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJibHVlIiBzaGFwZS1yZW5kZXJpbmc9Imdlb21ldHJpY1ByZWNpc2lvbiI+CjxjaXJjbGUgZmlsbD0ibm9uZSIgY3g9IjgiIGN5PSI4IiByPSI3IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjxwb2x5bGluZSBwb2ludHM9IjggMTEgOCA4Ii8+Cjxwb2x5bGluZSBwb2ludHM9IjkgOCA2IDgiLz4KPGxpbmUgeDE9IjEwIiB5MT0iMTEiIHgyPSI2IiB5Mj0iMTEiLz4KPHJlY3QgeD0iOCIgeT0iNSIgd2lkdGg9IjAuMDEiIGhlaWdodD0iMC4wMSIvPgo8L2c+Cjwvc3ZnPg==");\n    background-color: royalblue;\n}\n\n.ace_icon_svg.ace_error_fold {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiIgZmlsbD0ibm9uZSI+CiAgPHBhdGggZD0ibSAxOC45Mjk4NTEsNy44Mjk4MDc2IGMgMC4xNDYzNTMsNi4zMzc0NjA0IC02LjMyMzE0Nyw3Ljc3Nzg0NDQgLTcuNDc3OTEyLDcuNzc3ODQ0NCAtMi4xMDcyNzI2LC0wLjEyODc1IDUuMTE3Njc4LDAuMzU2MjQ5IDUuMDUxNjk4LC03Ljg3MDA2MTggLTAuNjA0NjcyLC04LjAwMzk3MzQ5IC03LjA3NzI3MDYsLTcuNTYzMTE4OSAtNC44NTczLC03LjQzMDM5NTU2IDEuNjA2LC0wLjExNTE0MjI1IDYuODk3NDg1LDEuMjYyNTQ1OTYgNy4yODM1MTQsNy41MjI2MTI5NiB6IiBmaWxsPSJjcmltc29uIiBzdHJva2Utd2lkdGg9IjIiLz4KICA8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0ibSA4LjExNDc1NjIsMi4wNTI5ODI4IGMgMy4zNDkxNjk4LDAgNi4wNjQxMzI4LDIuNjc2ODYyNyA2LjA2NDEzMjgsNS45Nzg5NTMgMCwzLjMwMjExMjIgLTIuNzE0OTYzLDUuOTc4OTIwMiAtNi4wNjQxMzI4LDUuOTc4OTIwMiAtMy4zNDkxNDczLDAgLTYuMDY0MTc3MiwtMi42NzY4MDggLTYuMDY0MTc3MiwtNS45Nzg5MjAyIDAuMDA1MzksLTMuMjk5ODg2MSAyLjcxNzI2NTYsLTUuOTczNjQwOCA2LjA2NDE3NzIsLTUuOTc4OTUzIHogbSAwLC0xLjczNTgyNzE5IGMgLTQuMzIxNDgzNiwwIC03LjgyNDc0MDM4LDMuNDU0MDE4NDkgLTcuODI0NzQwMzgsNy43MTQ3ODAxOSAwLDQuMjYwNzI4MiAzLjUwMzI1Njc4LDcuNzE0NzQ1MiA3LjgyNDc0MDM4LDcuNzE0NzQ1MiA0LjMyMTQ0OTgsMCA3LjgyNDY5OTgsLTMuNDU0MDE3IDcuODI0Njk5OCwtNy43MTQ3NDUyIDAsLTIuMDQ2MDkxNCAtMC44MjQzOTIsLTQuMDA4MzY3MiAtMi4yOTE3NTYsLTUuNDU1MTc0NiBDIDEyLjE4MDIyNSwxLjEyOTk2NDggMTAuMTkwMDEzLDAuMzE3MTU1NjEgOC4xMTQ3NTYyLDAuMzE3MTU1NjEgWiBNIDYuOTM3NDU2Myw4LjI0MDU5ODUgNC42NzE4Njg1LDEwLjQ4NTg1MiA2LjAwODY4MTQsMTEuODc2NzI4IDguMzE3MDAzNSw5LjYwMDc5MTEgMTAuNjI1MzM3LDExLjg3NjcyOCAxMS45NjIxMzgsMTAuNDg1ODUyIDkuNjk2NTUwOCw4LjI0MDU5ODUgMTEuOTYyMTM4LDYuMDA2ODA2NiAxMC41NzMyNDYsNC42Mzc0MzM1IDguMzE3MDAzNSw2Ljg3MzQyOTcgNi4wNjA3NjA3LDQuNjM3NDMzNSA0LjY3MTg2ODUsNi4wMDY4MDY2IFoiIGZpbGw9ImNyaW1zb24iIHN0cm9rZS13aWR0aD0iMiIvPgo8L3N2Zz4=");\n    background-color: crimson;\n}\n.ace_icon_svg.ace_warning_fold {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAyMCAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNC43NzY5IDE0LjczMzdMOC42NTE5MiAyLjQ4MzY5QzguMzI5NDYgMS44Mzg3NyA3LjQwOTEzIDEuODM4NzcgNy4wODY2NyAyLjQ4MzY5TDAuOTYxNjY5IDE0LjczMzdDMC42NzA3NzUgMTUuMzE1NSAxLjA5MzgzIDE2IDEuNzQ0MjkgMTZIMTMuOTk0M0MxNC42NDQ4IDE2IDE1LjA2NzggMTUuMzE1NSAxNC43NzY5IDE0LjczMzdaTTMuMTYwMDcgMTQuMjVMNy44NjkyOSA0LjgzMTU2TDEyLjU3ODUgMTQuMjVIMy4xNjAwN1pNOC43NDQyOSAxMS42MjVWMTMuMzc1SDYuOTk0MjlWMTEuNjI1SDguNzQ0MjlaTTYuOTk0MjkgMTAuNzVWNy4yNUg4Ljc0NDI5VjEwLjc1SDYuOTk0MjlaIiBmaWxsPSIjRUM3MjExIi8+CjxwYXRoIGQ9Ik0xMS4xOTkxIDIuOTUyMzhDMTAuODgwOSAyLjMxNDY3IDEwLjM1MzcgMS44MDUyNiA5LjcwNTUgMS41MDlMMTEuMDQxIDEuMDY5NzhDMTEuNjg4MyAwLjk0OTgxNCAxMi4zMzcgMS4yNzI2MyAxMi42MzE3IDEuODYxNDFMMTcuNjEzNiAxMS44MTYxQzE4LjM1MjcgMTMuMjkyOSAxNy41OTM4IDE1LjA4MDQgMTYuMDE4IDE1LjU3NDVDMTYuNDA0NCAxNC40NTA3IDE2LjMyMzEgMTMuMjE4OCAxNS43OTI0IDEyLjE1NTVMMTEuMTk5MSAyLjk1MjM4WiIgZmlsbD0iI0VDNzIxMSIvPgo8L3N2Zz4=");\n    background-color: darkorange;\n}\n\n.ace_scrollbar {\n    contain: strict;\n    position: absolute;\n    right: 0;\n    bottom: 0;\n    z-index: 6;\n}\n\n.ace_scrollbar-inner {\n    position: absolute;\n    cursor: text;\n    left: 0;\n    top: 0;\n}\n\n.ace_scrollbar-v{\n    overflow-x: hidden;\n    overflow-y: scroll;\n    top: 0;\n}\n\n.ace_scrollbar-h {\n    overflow-x: scroll;\n    overflow-y: hidden;\n    left: 0;\n}\n\n.ace_print-margin {\n    position: absolute;\n    height: 100%;\n}\n\n.ace_text-input {\n    position: absolute;\n    z-index: 0;\n    width: 0.5em;\n    height: 1em;\n    opacity: 0;\n    background: transparent;\n    -moz-appearance: none;\n    appearance: none;\n    border: none;\n    resize: none;\n    outline: none;\n    overflow: hidden;\n    font: inherit;\n    padding: 0 1px;\n    margin: 0 -1px;\n    contain: strict;\n    -ms-user-select: text;\n    -moz-user-select: text;\n    -webkit-user-select: text;\n    user-select: text;\n    /*with `pre-line` chrome inserts &nbsp; instead of space*/\n    white-space: pre!important;\n}\n.ace_text-input.ace_composition {\n    background: transparent;\n    color: inherit;\n    z-index: 1000;\n    opacity: 1;\n}\n.ace_composition_placeholder { color: transparent }\n.ace_composition_marker { \n    border-bottom: 1px solid;\n    position: absolute;\n    border-radius: 0;\n    margin-top: 1px;\n}\n\n[ace_nocontext=true] {\n    transform: none!important;\n    filter: none!important;\n    clip-path: none!important;\n    mask : none!important;\n    contain: none!important;\n    perspective: none!important;\n    mix-blend-mode: initial!important;\n    z-index: auto;\n}\n\n.ace_layer {\n    z-index: 1;\n    position: absolute;\n    overflow: hidden;\n    /* workaround for chrome bug https://github.com/ajaxorg/ace/issues/2312*/\n    word-wrap: normal;\n    white-space: pre;\n    height: 100%;\n    width: 100%;\n    box-sizing: border-box;\n    /* setting pointer-events: auto; on node under the mouse, which changes\n        during scroll, will break mouse wheel scrolling in Safari */\n    pointer-events: none;\n}\n\n.ace_gutter-layer {\n    position: relative;\n    width: auto;\n    text-align: right;\n    pointer-events: auto;\n    height: 1000000px;\n    contain: style size layout;\n}\n\n.ace_text-layer {\n    font: inherit !important;\n    position: absolute;\n    height: 1000000px;\n    width: 1000000px;\n    contain: style size layout;\n}\n\n.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {\n    contain: style size layout;\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n}\n\n.ace_hidpi .ace_text-layer,\n.ace_hidpi .ace_gutter-layer,\n.ace_hidpi .ace_content,\n.ace_hidpi .ace_gutter {\n    contain: strict;\n}\n.ace_hidpi .ace_text-layer > .ace_line, \n.ace_hidpi .ace_text-layer > .ace_line_group {\n    contain: strict;\n}\n\n.ace_cjk {\n    display: inline-block;\n    text-align: center;\n}\n\n.ace_cursor-layer {\n    z-index: 4;\n}\n\n.ace_cursor {\n    z-index: 4;\n    position: absolute;\n    box-sizing: border-box;\n    border-left: 2px solid;\n    /* workaround for smooth cursor repaintng whole screen in chrome */\n    transform: translatez(0);\n}\n\n.ace_multiselect .ace_cursor {\n    border-left-width: 1px;\n}\n\n.ace_slim-cursors .ace_cursor {\n    border-left-width: 1px;\n}\n\n.ace_overwrite-cursors .ace_cursor {\n    border-left-width: 0;\n    border-bottom: 1px solid;\n}\n\n.ace_hidden-cursors .ace_cursor {\n    opacity: 0.2;\n}\n\n.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {\n    opacity: 0;\n}\n\n.ace_smooth-blinking .ace_cursor {\n    transition: opacity 0.18s;\n}\n\n.ace_animate-blinking .ace_cursor {\n    animation-duration: 1000ms;\n    animation-timing-function: step-end;\n    animation-name: blink-ace-animate;\n    animation-iteration-count: infinite;\n}\n\n.ace_animate-blinking.ace_smooth-blinking .ace_cursor {\n    animation-duration: 1000ms;\n    animation-timing-function: ease-in-out;\n    animation-name: blink-ace-animate-smooth;\n}\n    \n@keyframes blink-ace-animate {\n    from, to { opacity: 1; }\n    60% { opacity: 0; }\n}\n\n@keyframes blink-ace-animate-smooth {\n    from, to { opacity: 1; }\n    45% { opacity: 1; }\n    60% { opacity: 0; }\n    85% { opacity: 0; }\n}\n\n.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {\n    position: absolute;\n    z-index: 3;\n}\n\n.ace_marker-layer .ace_selection {\n    position: absolute;\n    z-index: 5;\n}\n\n.ace_marker-layer .ace_bracket {\n    position: absolute;\n    z-index: 6;\n}\n\n.ace_marker-layer .ace_error_bracket {\n    position: absolute;\n    border-bottom: 1px solid #DE5555;\n    border-radius: 0;\n}\n\n.ace_marker-layer .ace_active-line {\n    position: absolute;\n    z-index: 2;\n}\n\n.ace_marker-layer .ace_selected-word {\n    position: absolute;\n    z-index: 4;\n    box-sizing: border-box;\n}\n\n.ace_line .ace_fold {\n    box-sizing: border-box;\n\n    display: inline-block;\n    height: 11px;\n    margin-top: -2px;\n    vertical-align: middle;\n\n    background-image:\n        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),\n        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");\n    background-repeat: no-repeat, repeat-x;\n    background-position: center center, top left;\n    color: transparent;\n\n    border: 1px solid black;\n    border-radius: 2px;\n\n    cursor: pointer;\n    pointer-events: auto;\n}\n\n.ace_dark .ace_fold {\n}\n\n.ace_fold:hover{\n    background-image:\n        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),\n        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");\n}\n\n.ace_tooltip {\n    background-color: #f5f5f5;\n    border: 1px solid gray;\n    border-radius: 1px;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\n    color: black;\n    max-width: 100%;\n    padding: 3px 4px;\n    position: fixed;\n    z-index: 999999;\n    box-sizing: border-box;\n    cursor: default;\n    white-space: pre-wrap;\n    word-wrap: break-word;\n    line-height: normal;\n    font-style: normal;\n    font-weight: normal;\n    letter-spacing: normal;\n    pointer-events: none;\n    overflow: auto;\n    max-width: min(60em, 66vw);\n    overscroll-behavior: contain;\n}\n.ace_tooltip pre {\n    white-space: pre-wrap;\n}\n\n.ace_tooltip.ace_dark {\n    background-color: #636363;\n    color: #fff;\n}\n\n.ace_tooltip:focus {\n    outline: 1px solid #5E9ED6;\n}\n\n.ace_icon {\n    display: inline-block;\n    width: 18px;\n    vertical-align: top;\n}\n\n.ace_icon_svg {\n    display: inline-block;\n    width: 12px;\n    vertical-align: top;\n    -webkit-mask-repeat: no-repeat;\n    -webkit-mask-size: 12px;\n    -webkit-mask-position: center;\n}\n\n.ace_folding-enabled > .ace_gutter-cell, .ace_folding-enabled > .ace_gutter-cell_svg-icons {\n    padding-right: 13px;\n}\n\n.ace_fold-widget {\n    box-sizing: border-box;\n\n    margin: 0 -12px 0 1px;\n    display: none;\n    width: 11px;\n    vertical-align: top;\n\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");\n    background-repeat: no-repeat;\n    background-position: center;\n\n    border-radius: 3px;\n    \n    border: 1px solid transparent;\n    cursor: pointer;\n}\n\n.ace_folding-enabled .ace_fold-widget {\n    display: inline-block;   \n}\n\n.ace_fold-widget.ace_end {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");\n}\n\n.ace_fold-widget.ace_closed {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");\n}\n\n.ace_fold-widget:hover {\n    border: 1px solid rgba(0, 0, 0, 0.3);\n    background-color: rgba(255, 255, 255, 0.2);\n    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);\n}\n\n.ace_fold-widget:active {\n    border: 1px solid rgba(0, 0, 0, 0.4);\n    background-color: rgba(0, 0, 0, 0.05);\n    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);\n}\n/**\n * Dark version for fold widgets\n */\n.ace_dark .ace_fold-widget {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");\n}\n.ace_dark .ace_fold-widget.ace_end {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");\n}\n.ace_dark .ace_fold-widget.ace_closed {\n    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");\n}\n.ace_dark .ace_fold-widget:hover {\n    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);\n    background-color: rgba(255, 255, 255, 0.1);\n}\n.ace_dark .ace_fold-widget:active {\n    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);\n}\n\n.ace_inline_button {\n    border: 1px solid lightgray;\n    display: inline-block;\n    margin: -1px 8px;\n    padding: 0 5px;\n    pointer-events: auto;\n    cursor: pointer;\n}\n.ace_inline_button:hover {\n    border-color: gray;\n    background: rgba(200,200,200,0.2);\n    display: inline-block;\n    pointer-events: auto;\n}\n\n.ace_fold-widget.ace_invalid {\n    background-color: #FFB4B4;\n    border-color: #DE5555;\n}\n\n.ace_fade-fold-widgets .ace_fold-widget {\n    transition: opacity 0.4s ease 0.05s;\n    opacity: 0;\n}\n\n.ace_fade-fold-widgets:hover .ace_fold-widget {\n    transition: opacity 0.05s ease 0.05s;\n    opacity:1;\n}\n\n.ace_underline {\n    text-decoration: underline;\n}\n\n.ace_bold {\n    font-weight: bold;\n}\n\n.ace_nobold .ace_bold {\n    font-weight: normal;\n}\n\n.ace_italic {\n    font-style: italic;\n}\n\n\n.ace_error-marker {\n    background-color: rgba(255, 0, 0,0.2);\n    position: absolute;\n    z-index: 9;\n}\n\n.ace_highlight-marker {\n    background-color: rgba(255, 255, 0,0.2);\n    position: absolute;\n    z-index: 8;\n}\n\n.ace_mobile-menu {\n    position: absolute;\n    line-height: 1.5;\n    border-radius: 4px;\n    -ms-user-select: none;\n    -moz-user-select: none;\n    -webkit-user-select: none;\n    user-select: none;\n    background: white;\n    box-shadow: 1px 3px 2px grey;\n    border: 1px solid #dcdcdc;\n    color: black;\n}\n.ace_dark > .ace_mobile-menu {\n    background: #333;\n    color: #ccc;\n    box-shadow: 1px 3px 2px grey;\n    border: 1px solid #444;\n\n}\n.ace_mobile-button {\n    padding: 2px;\n    cursor: pointer;\n    overflow: hidden;\n}\n.ace_mobile-button:hover {\n    background-color: #eee;\n    opacity:1;\n}\n.ace_mobile-button:active {\n    background-color: #ddd;\n}\n\n.ace_placeholder {\n    font-family: arial;\n    transform: scale(0.9);\n    transform-origin: left;\n    white-space: pre;\n    opacity: 0.7;\n    margin: 0 10px;\n}\n\n.ace_ghost_text {\n    opacity: 0.5;\n    font-style: italic;\n    white-space: pre;\n}\n\n.ace_screenreader-only {\n    position:absolute;\n    left:-10000px;\n    top:auto;\n    width:1px;\n    height:1px;\n    overflow:hidden;\n}'}),ace.define("ace/layer/decorators",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter"],function(e,t,n){"use strict";var i=e("../lib/dom"),o=e("../lib/oop"),e=e("../lib/event_emitter").EventEmitter,r=(s.prototype.$updateDecorators=function(e){var t=!0===this.renderer.theme.isDark?this.colors.dark:this.colors.light,n=(e&&(this.maxHeight=e.maxHeight,this.lineHeight=e.lineHeight,this.canvasHeight=e.height,(e.lastRow+1)*this.lineHeight<this.canvasHeight?this.heightRatio=1:this.heightRatio=this.canvasHeight/this.maxHeight),this.canvas.getContext("2d"));var i=this.renderer.session.$annotations;if(n.clearRect(0,0,this.canvas.width,this.canvas.height),i)for(var o={info:1,warning:2,error:3},r=(i.forEach(function(e){e.priority=o[e.type]||null}),i=i.sort(function(e,t){return e.priority<t.priority?-1:e.priority>t.priority?1:0}),this.renderer.session.$foldData),s=0;s<i.length;s++){var a,l=i[s].row,c=this.compensateFoldRows(l,r),h=Math.round((l-c)*this.lineHeight*this.heightRatio),d=Math.round((l-c)*this.lineHeight*this.heightRatio),l=Math.round(((l-c)*this.lineHeight+this.lineHeight)*this.heightRatio);l-d<this.minDecorationHeight&&((a=(d+l)/2|0)<this.halfMinDecorationHeight?a=this.halfMinDecorationHeight:a+this.halfMinDecorationHeight>this.canvasHeight&&(a=this.canvasHeight-this.halfMinDecorationHeight),d=Math.round(a-this.halfMinDecorationHeight),l=Math.round(a+this.halfMinDecorationHeight)),n.fillStyle=t[i[s].type]||null,n.fillRect(0,h,this.canvasWidth,l-d)}e=this.renderer.session.selection.getCursor();e&&(c=this.compensateFoldRows(e.row,r),h=Math.round((e.row-c)*this.lineHeight*this.heightRatio),n.fillStyle="rgba(0, 0, 0, 0.5)",n.fillRect(0,h,this.canvasWidth,2))},s.prototype.compensateFoldRows=function(e,t){var n=0;if(t&&0<t.length)for(var i=0;i<t.length;i++)e>t[i].start.row&&e<t[i].end.row?n+=e-t[i].start.row:e>=t[i].end.row&&(n+=t[i].end.row-t[i].start.row);return n},s);function s(e,t){this.canvas=i.createElement("canvas"),this.renderer=t,this.pixelRatio=1,this.maxHeight=t.layerConfig.maxHeight,this.lineHeight=t.layerConfig.lineHeight,this.canvasHeight=e.parent.scrollHeight,this.heightRatio=this.canvasHeight/this.maxHeight,this.canvasWidth=e.width,this.minDecorationHeight=2*this.pixelRatio|0,this.halfMinDecorationHeight=this.minDecorationHeight/2|0,this.canvas.width=this.canvasWidth,this.canvas.height=this.canvasHeight,this.canvas.style.top="0px",this.canvas.style.right="0px",this.canvas.style.zIndex="7px",this.canvas.style.position="absolute",this.colors={},this.colors.dark={error:"rgba(255, 18, 18, 1)",warning:"rgba(18, 136, 18, 1)",info:"rgba(18, 18, 136, 1)"},this.colors.light={error:"rgb(255,51,51)",warning:"rgb(32,133,72)",info:"rgb(35,68,138)"},e.element.appendChild(this.canvas)}o.implement(r.prototype,e),t.Decorator=r}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/scrollbar_custom","ace/scrollbar_custom","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/css/editor-css","ace/layer/decorators","ace/lib/useragent"],function(e,t,n){"use strict";var i=e("./lib/oop"),a=e("./lib/dom"),o=e("./lib/lang"),r=e("./config"),s=e("./layer/gutter").Gutter,l=e("./layer/marker").Marker,c=e("./layer/text").Text,h=e("./layer/cursor").Cursor,d=e("./scrollbar").HScrollBar,u=e("./scrollbar").VScrollBar,g=e("./scrollbar_custom").HScrollBar,p=e("./scrollbar_custom").VScrollBar,m=e("./renderloop").RenderLoop,f=e("./layer/font_metrics").FontMetrics,C=e("./lib/event_emitter").EventEmitter,y=e("./css/editor-css"),v=e("./layer/decorators").Decorator,I=e("./lib/useragent"),e=(a.importCssString(y,"ace_editor.css",!1),b.prototype.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),a.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},b.prototype.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=e)&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},b.prototype.updateLines=function(e,t,n){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!n)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},b.prototype.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},b.prototype.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},b.prototype.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},b.prototype.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},b.prototype.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},b.prototype.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},b.prototype.onResize=function(e,t,n,i){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=e?1:0;var o=this.container,o=(i=i||o.clientHeight||o.scrollHeight,n=n||o.clientWidth||o.scrollWidth,this.$updateCachedSize(e,t,n,i));if(this.$resizeTimer&&this.$resizeTimer.cancel(),!this.$size.scrollerHeight||!n&&!i)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(o|this.$changes,!0):this.$loop.schedule(o|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.$customScrollbar&&this.$updateCustomScrollbar(!0)}},b.prototype.$updateCachedSize=function(e,t,n,i){i-=this.$extraHeight||0;var o=0,r=this.$size,s={width:r.width,height:r.height,scrollerHeight:r.scrollerHeight,scrollerWidth:r.scrollerWidth};return i&&(e||r.height!=i)&&(r.height=i,o|=this.CHANGE_SIZE,r.scrollerHeight=r.height,this.$horizScroll&&(r.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.setHeight(r.scrollerHeight),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",o|=this.CHANGE_SCROLL),n&&(e||r.width!=n)&&(o|=this.CHANGE_SIZE,r.width=n,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,a.setStyle(this.scrollBarH.element.style,"left",t+"px"),a.setStyle(this.scroller.style,"left",t+this.margin.left+"px"),r.scrollerWidth=Math.max(0,n-t-this.scrollBarV.getWidth()-this.margin.h),a.setStyle(this.$gutter.style,"left",this.margin.left+"px"),t=this.scrollBarV.getWidth()+"px",a.setStyle(this.scrollBarH.element.style,"right",t),a.setStyle(this.scroller.style,"right",t),a.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),this.scrollBarH.setWidth(r.scrollerWidth),this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(o|=this.CHANGE_FULL),r.$dirty=!n||!i,o&&this._signal("resize",s),o},b.prototype.onGutterResize=function(e){e=this.$showGutter?e:0;e!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,e,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},b.prototype.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,e=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(e,this.$showPrintMargin&&this.$printMarginColumn)},b.prototype.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},b.prototype.getAnimatedScroll=function(){return this.$animatedScroll},b.prototype.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},b.prototype.getShowInvisibles=function(){return this.getOption("showInvisibles")},b.prototype.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},b.prototype.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},b.prototype.getHighlightIndentGuides=function(){return this.getOption("highlightIndentGuides")},b.prototype.setHighlightIndentGuides=function(e){this.setOption("highlightIndentGuides",e)},b.prototype.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},b.prototype.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},b.prototype.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},b.prototype.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},b.prototype.getShowGutter=function(){return this.getOption("showGutter")},b.prototype.setShowGutter=function(e){return this.setOption("showGutter",e)},b.prototype.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},b.prototype.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},b.prototype.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},b.prototype.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},b.prototype.$updatePrintMargin=function(){var e;(this.$showPrintMargin||this.$printMarginEl)&&(this.$printMarginEl||((e=a.createElement("div")).className="ace_layer ace_print-margin-layer",this.$printMarginEl=a.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)),(e=this.$printMarginEl.style).left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",e.visibility=this.$showPrintMargin?"visible":"hidden",this.session)&&-1==this.session.$wrap&&this.adjustWrapLimit()},b.prototype.getContainerElement=function(){return this.container},b.prototype.getMouseEventTarget=function(){return this.scroller},b.prototype.getTextAreaContainer=function(){return this.container},b.prototype.$moveTextAreaToCursor=function(){var e,t,n,i,o,r,s;this.$isMousePressed||(e=this.textarea.style,r=this.$composition,this.$keepTextAreaAtCursor||r?(n=this.$cursorLayer.$pixelPos)&&(r&&r.markerRange&&(n=this.$cursorLayer.getPixelPosition(r.markerRange.start,!0)),s=this.layerConfig,t=n.top,n=n.left,t-=s.offset,i=r&&r.useTextareaForIME||I.isMobile?this.lineHeight:1,t<0||t>s.height-i?a.translate(this.textarea,0,0):(s=1,o=this.$size.height-i,r?r.useTextareaForIME?(r=this.textarea.value,s=this.characterWidth*this.session.$getStringScreenWidth(r)[0]):t+=this.lineHeight+2:t+=this.lineHeight,(n-=this.scrollLeft)>this.$size.scrollerWidth-s&&(n=this.$size.scrollerWidth-s),n+=this.gutterWidth+this.margin.left,a.setStyle(e,"height",i+"px"),a.setStyle(e,"width",s+"px"),a.translate(this.textarea,Math.min(n,this.$size.scrollerWidth-s),Math.min(t,o)))):a.translate(this.textarea,-100,0))},b.prototype.getFirstVisibleRow=function(){return this.layerConfig.firstRow},b.prototype.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},b.prototype.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},b.prototype.getLastVisibleRow=function(){return this.layerConfig.lastRow},b.prototype.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},b.prototype.setScrollMargin=function(e,t,n,i){var o=this.scrollMargin;o.top=0|e,o.bottom=0|t,o.right=0|i,o.left=0|n,o.v=o.top+o.bottom,o.h=o.left+o.right,o.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-o.top),this.updateFull()},b.prototype.setMargin=function(e,t,n,i){var o=this.margin;o.top=0|e,o.bottom=0|t,o.right=0|i,o.left=0|n,o.v=o.top+o.bottom,o.h=o.left+o.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},b.prototype.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},b.prototype.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},b.prototype.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},b.prototype.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},b.prototype.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t)&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},b.prototype.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},b.prototype.freeze=function(){this.$frozen=!0},b.prototype.unfreeze=function(){this.$frozen=!1},b.prototype.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(e||t)){if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender",e),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var n,i,t=this.layerConfig;(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL)&&(e|=this.$computeLayerConfig()|this.$loop.clear(),t.firstRow!=this.layerConfig.firstRow&&t.firstRowScreen==this.layerConfig.firstRowScreen&&0<(n=this.scrollTop+(t.firstRow-Math.max(this.layerConfig.firstRow,0))*this.lineHeight)&&(this.scrollTop=n,e=(e|=this.CHANGE_SCROLL)|(this.$computeLayerConfig()|this.$loop.clear())),t=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),a.translate(this.content,-this.scrollLeft,-t.offset),n=t.width+2*this.$padding+"px",i=t.minHeight+"px",a.setStyle(this.content.style,"width",n),a.setStyle(this.content.style,"height",i)),e&this.CHANGE_H_SCROLL&&(a.translate(this.content,-this.scrollLeft,-t.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller ":"ace_scroller ace_scroll-left ",this.enableKeyboardAccessibility)&&(this.scroller.className+=this.keyboardFocusClassName),e&this.CHANGE_FULL?(this.$changedLines=null,this.$textLayer.update(t),this.$showGutter&&this.$gutterLayer.update(t),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(t),this.$markerBack.update(t),this.$markerFront.update(t),this.$cursorLayer.update(t),this.$moveTextAreaToCursor()):e&this.CHANGE_SCROLL?(this.$changedLines=null,e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(t):this.$textLayer.scrollLines(t),this.$showGutter&&(e&this.CHANGE_GUTTER||e&this.CHANGE_LINES?this.$gutterLayer.update(t):this.$gutterLayer.scrollLines(t)),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(t),this.$markerBack.update(t),this.$markerFront.update(t),this.$cursorLayer.update(t),this.$moveTextAreaToCursor()):(e&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(t),this.$showGutter&&this.$gutterLayer.update(t),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(t)):e&this.CHANGE_LINES?((this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(t),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(t)):e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER?(this.$showGutter&&this.$gutterLayer.update(t),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(t)):e&this.CHANGE_CURSOR&&(this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(t),this.$customScrollbar)&&this.$scrollDecorator.$updateDecorators(t),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(t),this.$moveTextAreaToCursor()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(t),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(t)),this._signal("afterRender",e)}else this.$changes|=e},b.prototype.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,n=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(n+=this.scrollBarH.getHeight());t=!((n=this.$maxPixelHeight&&n>this.$maxPixelHeight?this.$maxPixelHeight:n)<=2*this.lineHeight)&&t<e;n==this.desiredHeight&&this.$size.height==this.desiredHeight&&t==this.$vScroll||(t!=this.$vScroll&&(this.$vScroll=t,this.scrollBarV.setVisible(t)),e=this.container.clientWidth,this.container.style.height=n+"px",this.$updateCachedSize(!0,this.$gutterWidth,e,n),this.desiredHeight=n,this._signal("autosize"))},b.prototype.$computeLayerConfig=function(){var e,t=this.session,n=this.$size,i=n.height<=2*this.lineHeight,o=this.session.getScreenLength()*this.lineHeight,r=this.$getLongestLine(),s=!i&&(this.$hScrollBarAlwaysVisible||n.scrollerWidth-r-2*this.$padding<0),a=this.$horizScroll!==s,s=(a&&(this.$horizScroll=s,this.scrollBarH.setVisible(s)),this.$vScroll),l=(this.$maxLines&&1<this.lineHeight&&this.$autosize(),n.scrollerHeight+this.lineHeight),c=!this.$maxLines&&this.$scrollPastEnd?(n.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0,h=(o+=c,this.scrollMargin),i=(this.session.setScrollTop(Math.max(-h.top,Math.min(this.scrollTop,o-n.scrollerHeight+h.bottom))),this.session.setScrollLeft(Math.max(-h.left,Math.min(this.scrollLeft,r+2*this.$padding-n.scrollerWidth+h.right))),!i&&(this.$vScrollBarAlwaysVisible||n.scrollerHeight-o+c<0||this.scrollTop>h.top)),c=s!==i,h=(c&&(this.$vScroll=i,this.scrollBarV.setVisible(i)),this.scrollTop%this.lineHeight),s=Math.ceil(l/this.lineHeight)-1,s=(i=Math.max(0,Math.round((this.scrollTop-h)/this.lineHeight)))+s,d=this.lineHeight,i=t.screenToDocumentRow(i,0),u=t.getFoldLine(i),t=(u&&(i=u.start.row),u=t.documentToScreenRow(i,0),e=t.getRowLength(i)*d,s=Math.min(t.screenToDocumentRow(s,0),t.getLength()-1),l=n.scrollerHeight+t.getRowLength(s)*d+e,h=this.scrollTop-u*d,0);return this.layerConfig.width==r&&!a||(t=this.CHANGE_H_SCROLL),(a||c)&&(t|=this.$updateCachedSize(!0,this.gutterWidth,n.width,n.height),this._signal("scrollbarVisibilityChanged"),c)&&(r=this.$getLongestLine()),this.layerConfig={width:r,padding:this.$padding,firstRow:i,firstRowScreen:u,lastRow:s,lineHeight:d,characterWidth:this.characterWidth,minHeight:l,maxHeight:o,offset:h,gutterOffset:d?Math.max(0,Math.ceil((h+n.height-n.scrollerHeight)/d)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(r-this.$padding),t},b.prototype.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow,n=(this.$changedLines=null,this.layerConfig);if(!(e>n.lastRow+1||t<n.firstRow)){if(t!==1/0)return this.$textLayer.updateLines(n,e,t),!0;this.$showGutter&&this.$gutterLayer.update(n),this.$textLayer.update(n)}}},b.prototype.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),this.$textLayer&&e>this.$textLayer.MAX_LINE_LENGTH&&(e=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},b.prototype.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},b.prototype.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},b.prototype.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},b.prototype.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},b.prototype.updateBreakpoints=function(e){this._rows=e,this.$loop.schedule(this.CHANGE_GUTTER)},b.prototype.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},b.prototype.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},b.prototype.hideCursor=function(){this.$cursorLayer.hideCursor()},b.prototype.showCursor=function(){this.$cursorLayer.showCursor()},b.prototype.scrollSelectionIntoView=function(e,t,n){this.scrollCursorIntoView(e,n),this.scrollCursorIntoView(t,n)},b.prototype.scrollCursorIntoView=function(e,t,n){var i,o,r;0!==this.$size.scrollerHeight&&(i=(e=this.$cursorLayer.getPixelPosition(e)).left,e=e.top,o=n&&n.top||0,n=n&&n.bottom||0,this.$scrollAnimation&&(this.$stopAnimation=!0),e<(r=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop)+o?(t&&r+o>e+this.lineHeight&&(e-=t*this.$size.scrollerHeight),0===e&&(e=-this.scrollMargin.top),this.session.setScrollTop(e)):r+this.$size.scrollerHeight-n<e+this.lineHeight&&(t&&r+this.$size.scrollerHeight-n<e-this.lineHeight&&(e+=t*this.$size.scrollerHeight),this.session.setScrollTop(e+this.lineHeight+n-this.$size.scrollerHeight)),o=this.scrollLeft,i-(r=2*this.layerConfig.characterWidth)<o?((i-=r)<this.$padding+r&&(i=-this.scrollMargin.left),this.session.setScrollLeft(i)):o+this.$size.scrollerWidth<(i+=r)+this.characterWidth?this.session.setScrollLeft(Math.round(i+this.characterWidth-this.$size.scrollerWidth)):o<=this.$padding&&i-o<this.characterWidth&&this.session.setScrollLeft(0))},b.prototype.getScrollTop=function(){return this.session.getScrollTop()},b.prototype.getScrollLeft=function(){return this.session.getScrollLeft()},b.prototype.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},b.prototype.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},b.prototype.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},b.prototype.alignCursor=function(e,t){var e=this.$cursorLayer.getPixelPosition(e="number"==typeof e?{row:e,column:0}:e),n=this.$size.scrollerHeight-this.lineHeight,e=e.top-n*(t||0);return this.session.setScrollTop(e),e},b.prototype.$calcSteps=function(e,t){for(var n,i,o=0,r=this.STEPS,s=[],o=0;o<r;++o)s.push((n=o/this.STEPS,(t-(i=e))*(Math.pow(n-1,3)+1)+i));return s},b.prototype.scrollToLine=function(e,t,n,i){e=this.$cursorLayer.getPixelPosition({row:e,column:0}).top,t&&(e-=this.$size.scrollerHeight/2),t=this.scrollTop;this.session.setScrollTop(e),!1!==n&&this.animateScrolling(t,i)},b.prototype.animateScrolling=function(e,t){var n=this.scrollTop;if(this.$animatedScroll){var i=this;if(e!=n){if(this.$scrollAnimation){var o=this.$scrollAnimation.steps;if(o.length&&(e=o[0])==n)return}var r=i.$calcSteps(e,n);this.$scrollAnimation={from:e,to:n,steps:r},clearInterval(this.$timer),i.session.setScrollTop(r.shift()),i.session.$scrollTop=n,this.$timer=setInterval(function(){if(!i.$stopAnimation)return i.session?void(r.length?(i.session.setScrollTop(r.shift()),i.session.$scrollTop=n):null!=n?(i.session.$scrollTop=-1,i.session.setScrollTop(n),n=null):s()):clearInterval(i.$timer);s()},10)}}function s(){i.$timer=clearInterval(i.$timer),i.$scrollAnimation=null,i.$stopAnimation=!1,t&&t()}},b.prototype.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},b.prototype.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},b.prototype.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(e)},b.prototype.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},b.prototype.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||0<t&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||0<e&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0},b.prototype.pixelToScreenCoordinates=function(e,t){this.$hasCssTransforms?(i={top:0,left:0},e=(n=this.$fontMetrics.transformCoordinates([e,t]))[1]-this.gutterWidth-this.margin.left,t=n[0]):i=this.scroller.getBoundingClientRect();var n=e+this.scrollLeft-i.left-this.$padding,e=n/this.characterWidth,t=Math.floor((t+this.scrollTop-i.top)/this.lineHeight),i=this.$blockCursor?Math.floor(e):Math.round(e);return{row:t,column:i,side:0<e-i?1:-1,offsetX:n}},b.prototype.screenToTextCoordinates=function(e,t){this.$hasCssTransforms?(n={top:0,left:0},e=(i=this.$fontMetrics.transformCoordinates([e,t]))[1]-this.gutterWidth-this.margin.left,t=i[0]):n=this.scroller.getBoundingClientRect();var n,i=e+this.scrollLeft-n.left-this.$padding,e=i/this.characterWidth,e=this.$blockCursor?Math.floor(e):Math.round(e),t=Math.floor((t+this.scrollTop-n.top)/this.lineHeight);return this.session.screenToDocumentPosition(t,Math.max(e,0),i)},b.prototype.textToScreenCoordinates=function(e,t){var n=this.scroller.getBoundingClientRect(),t=this.session.documentToScreenPosition(e,t),e=this.$padding+(this.session.$bidiHandler.isBidiRow(t.row,e)?this.session.$bidiHandler.getPosLeft(t.column):Math.round(t.column*this.characterWidth)),t=t.row*this.lineHeight;return{pageX:n.left+e-this.scrollLeft,pageY:n.top+t-this.scrollTop}},b.prototype.visualizeFocus=function(){a.addCssClass(this.container,"ace_focus")},b.prototype.visualizeBlur=function(){a.removeCssClass(this.container,"ace_focus")},b.prototype.showComposition=function(e){(this.$composition=e).cssText||(e.cssText=this.textarea.style.cssText),null==e.useTextareaForIME&&(e.useTextareaForIME=this.$useTextareaForIME),this.$useTextareaForIME?(a.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):e.markerId=this.session.addMarker(e.markerRange,"ace_composition_marker","text")},b.prototype.setCompositionText=function(e){var t=this.session.selection.cursor;this.addToken(e,"composition_placeholder",t.row,t.column),this.$moveTextAreaToCursor()},b.prototype.hideComposition=function(){var e;this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),a.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,e=this.session.selection.cursor,this.removeExtraToken(e.row,e.column),this.$composition=null,this.$cursorLayer.element.style.display="")},b.prototype.setGhostText=function(e,t){var n,i=this.session.selection.cursor,t=t||{row:i.row,column:i.column},i=(this.removeGhostText(),e.split("\n"));this.addToken(i[0],"ghost_text",t.row,t.column),this.$ghostText={text:e,position:{row:t.row,column:t.column}},1<i.length&&(this.$ghostTextWidget={text:i.slice(1).join("\n"),row:t.row,column:t.column,className:"ace_ghost_text"},this.session.widgetManager.addLineWidget(this.$ghostTextWidget),e=this.$cursorLayer.getPixelPosition(t,!0),t=this.container.getBoundingClientRect().height,(n=i.length*this.lineHeight)<t-e.top||(n<t?this.scrollBy(0,(i.length-1)*this.lineHeight):this.scrollBy(0,e.top)))},b.prototype.removeGhostText=function(){var e;this.$ghostText&&(e=this.$ghostText.position,this.removeExtraToken(e.row,e.column),this.$ghostTextWidget&&(this.session.widgetManager.removeLineWidget(this.$ghostTextWidget),this.$ghostTextWidget=null),this.$ghostText=null)},b.prototype.addToken=function(e,t,n,i){var o=this.session,r=(o.bgTokenizer.lines[n]=null,{type:t,value:e}),s=o.getTokens(n);if(null!=i&&s.length)for(var a=0,l=0;l<s.length;l++){var c=s[l];if(i<=(a+=c.value.length)){var h=c.value.length-(a-i),d=c.value.slice(0,h),h=c.value.slice(h);s.splice(l,1,{type:c.type,value:d},r,{type:c.type,value:h});break}}else s.push(r);this.updateLines(n,n)},b.prototype.removeExtraToken=function(e,t){this.session.bgTokenizer.lines[e]=null,this.updateLines(e,e)},b.prototype.setTheme=function(n,i){var e,o=this;function t(e){if(o.$themeId!=n)return i&&i();if(!e||!e.cssClass)throw new Error("couldn't load module "+n+" or it didn't call define");e.$id&&(o.$themeId=e.$id),a.importCssString(e.cssText,e.cssClass,o.container),o.theme&&a.removeCssClass(o.container,o.theme.cssClass);var t="padding"in e?e.padding:"padding"in(o.theme||{})?4:o.$padding;o.$padding&&t!=o.$padding&&o.setPadding(t),o.$theme=e.cssClass,o.theme=e,a.addCssClass(o.container,e.cssClass),a.setCssClass(o.container,"ace_dark",e.isDark),o.$size&&(o.$size.width=0,o.$updateSizeAsync()),o._dispatchEvent("themeLoaded",{theme:e}),i&&i()}this.$themeId=n,o._dispatchEvent("themeChange",{theme:n}),n&&"string"!=typeof n?t(n):(e=n||this.$options.theme.initialValue,r.loadModule(["theme",e],t))},b.prototype.getTheme=function(){return this.$themeId},b.prototype.setStyle=function(e,t){a.setCssClass(this.container,e,!1!==t)},b.prototype.unsetStyle=function(e){a.removeCssClass(this.container,e)},b.prototype.setCursorStyle=function(e){a.setStyle(this.scroller.style,"cursor",e)},b.prototype.setMouseCursor=function(e){a.setStyle(this.scroller.style,"cursor",e)},b.prototype.attachToShadowRoot=function(){a.importCssString(y,"ace_editor.css",this.container)},b.prototype.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy(),this.removeAllListeners(),this.container.textContent="",this.setOption("useResizeObserver",!1)},b.prototype.$updateCustomScrollbar=function(e){var t=this;this.$horizScroll=this.$vScroll=null,this.scrollBarV.element.remove(),this.scrollBarH.element.remove(),this.$scrollDecorator&&delete this.$scrollDecorator,!0===e?(this.scrollBarV=new p(this.container,this),this.scrollBarH=new g(this.container,this),this.scrollBarV.setHeight(this.$size.scrollerHeight),this.scrollBarH.setWidth(this.$size.scrollerWidth),this.scrollBarV.addEventListener("scroll",function(e){t.$scrollAnimation||t.session.setScrollTop(e.data-t.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(e){t.$scrollAnimation||t.session.setScrollLeft(e.data-t.scrollMargin.left)}),this.$scrollDecorator=new v(this.scrollBarV,this),this.$scrollDecorator.$updateDecorators()):(this.scrollBarV=new u(this.container,this),this.scrollBarH=new d(this.container,this),this.scrollBarV.addEventListener("scroll",function(e){t.$scrollAnimation||t.session.setScrollTop(e.data-t.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(e){t.$scrollAnimation||t.session.setScrollLeft(e.data-t.scrollMargin.left)}))},b.prototype.$addResizeObserver=function(){var n;window.ResizeObserver&&!this.$resizeObserver&&((n=this).$resizeTimer=o.delayedCall(function(){n.destroyed||n.onResize()},50),this.$resizeObserver=new window.ResizeObserver(function(e){var t=e[0].contentRect.width,e=e[0].contentRect.height;1<Math.abs(n.$size.width-t)||1<Math.abs(n.$size.height-e)?n.$resizeTimer.delay():n.$resizeTimer.cancel()}),this.$resizeObserver.observe(this.container))},b);function b(e,t){var n=this,e=(this.container=e||a.createElement("div"),a.addCssClass(this.container,"ace_editor"),a.HI_DPI&&a.addCssClass(this.container,"ace_hidpi"),this.setTheme(t),null==r.get("useStrictCSP")&&r.set("useStrictCSP",!1),this.$gutter=a.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden","true"),this.scroller=a.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=a.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new s(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new l(this.content),this.$textLayer=new c(this.content));this.canvas=e.element,this.$markerFront=new l(this.content),this.$cursorLayer=new h(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new u(this.container,this),this.scrollBarH=new d(this.container,this),this.scrollBarV.on("scroll",function(e){n.$scrollAnimation||n.session.setScrollTop(e.data-n.scrollMargin.top)}),this.scrollBarH.on("scroll",function(e){n.$scrollAnimation||n.session.setScrollLeft(e.data-n.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new f(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.on("changeCharacterSize",function(e){n.updateCharacterSize(),n.onResize(!0,n.gutterWidth,n.$size.width,n.$size.height),n._signal("changeCharacterSize",e)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!I.isIOS,this.$loop=new m(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),this.$addResizeObserver(),r.resetOptions(this),r._signal("renderer",this)}e.prototype.CHANGE_CURSOR=1,e.prototype.CHANGE_MARKER=2,e.prototype.CHANGE_GUTTER=4,e.prototype.CHANGE_SCROLL=8,e.prototype.CHANGE_LINES=16,e.prototype.CHANGE_TEXT=32,e.prototype.CHANGE_SIZE=64,e.prototype.CHANGE_MARKER_BACK=128,e.prototype.CHANGE_MARKER_FRONT=256,e.prototype.CHANGE_FULL=512,e.prototype.CHANGE_H_SCROLL=1024,e.prototype.$changes=0,e.prototype.$padding=null,e.prototype.$frozen=!1,e.prototype.STEPS=8,i.implement(e.prototype,C),r.defineOptions(e.prototype,"renderer",{useResizeObserver:{set:function(e){!e&&this.$resizeObserver?(this.$resizeObserver.disconnect(),this.$resizeTimer.cancel(),this.$resizeTimer=this.$resizeObserver=null):e&&!this.$resizeObserver&&this.$addResizeObserver()}},animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},useSvgGutterIcons:{set:function(e){this.$gutterLayer.$useSvgGutterIcons=e},initialValue:!1},showFoldedAnnotations:{set:function(e){this.$gutterLayer.$showFoldedAnnotations=e},initialValue:!1},fadeFoldWidgets:{set:function(e){a.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightIndentGuides:{set:function(e){1==this.$textLayer.setHighlightIndentGuides(e)?this.$textLayer.$highlightIndentGuide():this.$textLayer.$clearActiveIndentGuide(this.$textLayer.$lines.cells)},initialValue:!0},highlightGutterLine:{set:function(e){this.$gutterLayer.setHighlightGutterLine(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){this.$scrollPastEnd!=(e=+e||0)&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},customScrollbar:{set:function(e){this.$updateCustomScrollbar(e)},initialValue:!1},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!I.isMobile&&!I.isIE}}),t.VirtualRenderer=e}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(a,e,t){"use strict";var n=a("../lib/oop"),i=a("../lib/net"),c=a("../lib/event_emitter").EventEmitter,h=a("../config");function l(e){var t;return"undefined"==typeof Worker?{postMessage:function(){},terminate:function(){}}:h.get("loadWorkerFromBlob")?(t=function(t){t="importScripts('"+i.qualifyURL(t)+"');";try{return new Blob([t],{type:"application/javascript"})}catch(e){var n=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return n.append(t),n.getBlob("application/javascript")}}(e),t=(window.URL||window.webkitURL).createObjectURL(t),new Worker(t)):new Worker(e)}function d(e){e.postMessage||(e=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=e,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){n.implement(this,c),this.$createWorkerFromOldConfig=function(e,t,n,i,o){var r,s;return a.nameToUrl&&!a.toUrl&&(a.toUrl=a.nameToUrl),h.get("packaged")||!a.toUrl?i=i||h.moduleUrl(t,"worker"):(r=this.$normalizePath,i=i||r(a.toUrl("ace/worker/worker.js",null,"_")),s={},e.forEach(function(e){s[e]=r(a.toUrl(e,null,"_").replace(/(\.js)?(\?.*)?$/,""))})),this.$worker=l(i),o&&this.send("importScripts",o),this.$worker.postMessage({init:!0,tlns:s,module:t,classname:n}),this.$worker},this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var n=this.callbacks[t.id];n&&(n(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return i.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker.onerror=function(e){e.preventDefault()},this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,n){var i;n&&(i=this.callbackId++,this.callbacks[i]=n,t.push(i)),this.send(e,t)},this.emit=function(e,t){try{t.data&&t.data.err&&(t.data.err={message:t.data.err.message,stack:t.data.err.stack,code:t.data.err.code}),this.$worker&&this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener,!0)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,50<e.length&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(d.prototype);e.UIWorkerClient=function(e,t,n){var i=null,o=!1,r=Object.create(c),s=[],a=new d({messageBuffer:s,terminate:function(){},postMessage:function(e){s.push(e),i&&(o?setTimeout(l):l())}}),l=(a.setEmitSync=function(e){o=e},function(){var e=s.shift();
e.command?i[e.command].apply(i,e.args):e.event&&r._signal(e.event,e.data)});return r.postMessage=function(e){a.onMessage({data:e})},r.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},r.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},h.loadModule(["worker",t],function(e){for(i=new e[n](r);s.length;)l()}),a},e.WorkerClient=d,e.createWorker=l}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(e,t,n){"use strict";var l=e("./range").Range,i=e("./lib/event_emitter").EventEmitter,e=e("./lib/oop"),o=(r.prototype.setup=function(){var t=this,n=this.doc,e=this.session,i=(this.selectionBefore=e.selection.toJSON(),e.selection.inMultiSelectMode&&e.selection.toSingleRange(),this.pos=n.createAnchor(this.$pos.row,this.$pos.column),this.pos);i.$insertRight=!0,i.detach(),i.markerId=e.addMarker(new l(i.row,i.column,i.row,i.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(e){e=n.createAnchor(e.row,e.column);e.$insertRight=!0,e.detach(),t.others.push(e)}),e.setUndoSelect(!1)},r.prototype.showOtherMarkers=function(){var t,n;this.othersActive||(t=this.session,(n=this).othersActive=!0,this.others.forEach(function(e){e.markerId=t.addMarker(new l(e.row,e.column,e.row,e.column+n.length),n.othersClass,null,!1)}))},r.prototype.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},r.prototype.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var n="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,i=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,o=t.start.column-this.pos.column;if(this.updateAnchors(e),i&&(this.length+=n),i&&!this.session.$fromUndo)if("insert"===e.action)for(var r=this.others.length-1;0<=r;r--){var s={row:(a=this.others[r]).row,column:a.column+o};this.doc.insertMergedLines(s,e.lines)}else if("remove"===e.action)for(r=this.others.length-1;0<=r;r--){var a,s={row:(a=this.others[r]).row,column:a.column+o};this.doc.remove(new l(s.row,s.column,s.row,s.column-n))}this.$updating=!1,this.updateMarkers()}},r.prototype.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},r.prototype.updateMarkers=function(){if(!this.$updating){var n=this,i=this.session,e=function(e,t){i.removeMarker(e.markerId),e.markerId=i.addMarker(new l(e.row,e.column,e.row,e.column+n.length),t,null,!1)};e(this.pos,this.mainClass);for(var t=this.others.length;t--;)e(this.others[t],this.othersClass)}},r.prototype.onCursorChange=function(e){var t;!this.$updating&&this.session&&((t=this.session.selection.getCursor()).row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e)))},r.prototype.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.off("change",this.$onUpdate),this.session.selection.off("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},r.prototype.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,n=0;n<t;n++)e.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}},r);function r(e,t,n,i,o,r){var s=this,t=(this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=o,this.othersClass=r,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate,!0),this.$others=i,this.$onCursorChange=function(){setTimeout(function(){s.onCursorChange()})},this.$pos=n,e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1});this.$undoStackDepth=t.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)}e.implement(o.prototype,i),t.PlaceHolder=o}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,n){var x=e("../lib/event"),k=e("../lib/useragent");function E(e,t){return e.row==t.row&&e.column==t.column}t.onMouseDown=function(e){var t=e.domEvent,n=t.altKey,i=t.shiftKey,o=t.ctrlKey,r=e.getAccelKey(),s=e.getButton();if(o&&k.isMac&&(s=t.button),e.editor.inMultiSelectMode&&2==s)e.editor.textInput.onContextMenu(e.domEvent);else if(o||n||r){if(0===s){var a,l,c,h,d,u,g,p,m=e.editor,f=m.selection,C=m.inMultiSelectMode,y=e.getDocumentPosition(),v=f.getCursor(),v=e.inSelection()||f.isEmpty()&&E(y,v),I=e.x,b=e.y,A=m.session,w=m.renderer.pixelToScreenCoordinates(I,b),S=w;if(m.$mouseHandler.$enableJumpToDef)o&&n||r&&n?a=i?"block":"add":n&&m.$blockSelectEnabled&&(a="block");else if(r&&!n){if(a="add",!C&&i)return}else n&&m.$blockSelectEnabled&&(a="block");if(a&&k.isMac&&t.ctrlKey&&m.$mouseHandler.cancelContextMenu(),"add"==a)!C&&v||(C||(l=f.toOrientedRange(),m.addSelectionMarker(l)),c=f.rangeList.rangeAtPoint(y),m.inVirtualSelectionMode=!0,i&&(c=null,l=f.ranges[0]||l,m.removeSelectionMarker(l)),m.once("mouseup",function(){var e=f.toOrientedRange();c&&e.isEmpty()&&E(c.cursor,e.cursor)?f.substractPoint(e.cursor):(i?f.substractPoint(l.cursor):l&&(m.removeSelectionMarker(l),f.addRange(l)),f.addRange(e)),m.inVirtualSelectionMode=!1}));else if("block"==a)return e.stop(),m.inVirtualSelectionMode=!0,d=[],u=function(){var e=m.renderer.pixelToScreenCoordinates(I,b),t=A.screenToDocumentPosition(e.row,e.column,e.offsetX);E(S,e)&&E(t,f.lead)||(S=e,m.selection.moveToPosition(t),m.renderer.scrollCursorIntoView(),m.removeSelectionMarkers(d),d=f.rectangularRangeBlock(S,w),m.$mouseHandler.$clickSelection&&1==d.length&&d[0].isEmpty()&&(d[0]=m.$mouseHandler.$clickSelection.clone()),d.forEach(m.addSelectionMarker,m),m.updateSelectionMarkers())},C&&!r?f.toSingleRange():!C&&r&&(h=f.toOrientedRange(),m.addSelectionMarker(h)),i?w=A.documentToScreenPosition(f.lead):f.moveToPosition(y),S={row:-1,column:-1},g=u,x.capture(m.container,function(e){I=e.clientX,b=e.clientY},function(e){u(),clearInterval(p),m.removeSelectionMarkers(d),d.length||(d=[f.toOrientedRange()]),h&&(m.removeSelectionMarker(h),f.toSingleRange(h));for(var t=0;t<d.length;t++)f.addRange(d[t]);m.inVirtualSelectionMode=!1,m.$mouseHandler.$clickSelection=null}),p=setInterval(function(){g()},20),e.preventDefault()}}else 0===s&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(e,t,n){t.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"toggleSplitSelectionIntoLines",description:"Split selection into lines",exec:function(e){1<e.multiSelect.rangeCount?e.multiSelect.joinSelections():e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(e){e.multiSelect.splitIntoLines()},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];e=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new e(t.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(e,o,t){var n=e("./range_list").RangeList,I=e("./range").Range,u=e("./selection").Selection,r=e("./mouse/multi_select_handler").onMouseDown,s=e("./lib/event"),g=e("./lib/lang"),a=e("./commands/multi_select_commands");o.commands=a.defaultCommands.concat(a.multiSelectCommands);var l=new(e("./search").Search);var i=e("./edit_session").EditSession,i=(!function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}.call(i.prototype),!function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var n=this.toOrientedRange();if(this.rangeList.add(n),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(n),this.$onAddRange(n)}e.cursor||(e.cursor=e.end);n=this.rangeList.add(e);return this.$onAddRange(e),n.length&&this.$onRemoveRange(n),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){e=this.rangeList.substractPoint(e);if(e)return this.$onRemoveRange(e),e[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length&&this.$onRemoveRange(e)},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){var t;this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode&&(t=this.rangeList.ranges.pop(),e.push(t),this.rangeCount=0);for(var n=e.length;n--;){var i=this.ranges.indexOf(e[n]);this.ranges.splice(i,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new n,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){for(var e=this.ranges.length?this.ranges:[this.getRange()],t=[],n=0;n<e.length;n++){var i=e[n],o=i.start.row,r=i.end.row;if(o===r)t.push(i.clone());else{for(t.push(new I(o,i.start.column,o,this.session.getLine(o).length));++o<r;)t.push(this.getLineRange(o,!0));t.push(new I(r,0,r,i.end.column))}0!=n||this.isBackwards()||(t=t.reverse())}this.toSingleRange();for(n=t.length;n--;)this.addRange(t[n])},this.joinSelections=function(){var e=this.rangeList.ranges,t=e[e.length-1],e=I.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(e,t.cursor==t.start)},this.toggleBlockSelection=function(){var e,t;1<this.rangeCount?(t=(e=this.rangeList.ranges)[e.length-1],e=I.fromPoints(e[0].start,t.end),this.toSingleRange(),this.setSelectionRange(e,t.cursor==t.start)):(e=this.session.documentToScreenPosition(this.cursor),t=this.session.documentToScreenPosition(this.anchor),this.rectangularRangeBlock(e,t).forEach(this.addRange,this))},this.rectangularRangeBlock=function(e,t,n){var i,o,r,s,a,l,c,h=[],d=e.column<t.column,u=(s=(d?(i=e.column,o=t.column,r=e.offsetX,t):(i=t.column,o=e.column,r=t.offsetX,e)).offsetX,e.row<t.row);l=(u?(a=e.row,t):(a=t.row,e)).row,i<0&&(i=0),(a=a<0?0:a)==l&&(n=!0);for(var g,p,m=a;m<=l;m++){var f=I.fromPoints(this.session.screenToDocumentPosition(m,i,r),this.session.screenToDocumentPosition(m,o,s));if(f.isEmpty()){if(c&&(g=f.end,p=c,g.row==p.row)&&g.column==p.column)break;c=f.end}f.cursor=d?f.start:f.end,h.push(f)}if(u&&h.reverse(),!n){for(var C=h.length-1;h[C].isEmpty()&&0<C;)C--;if(0<C)for(var y=0;h[y].isEmpty();)y++;for(var v=C;y<=v;v--)h[v].isEmpty()&&h.splice(v,1)}return h}}.call(u.prototype),e("./editor").Editor);function c(e){var t,n;function i(e){n&&(t.renderer.setMouseCursor(""),n=!1)}e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=o.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",r),e.commands.addCommands(a.defaultCommands),(t=e).textInput&&(e=t.textInput.getElement(),n=!1,s.addListener(e,"keydown",function(e){e=18==e.keyCode&&!(e.ctrlKey||e.shiftKey||e.metaKey);t.$blockSelectEnabled&&e?n||(t.renderer.setMouseCursor("crosshair"),n=!0):n&&i()},t),s.addListener(e,"keyup",i,t),s.addListener(e,"blur",i,t)))}!function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){e.marker&&(this.session.removeMarker(e.marker),-1!=(e=this.session.$selectionMarkers.indexOf(e))&&this.session.$selectionMarkers.splice(e,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length)},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,n=e.length;n--;){var i=e[n];i.marker&&(this.session.removeMarker(i.marker),-1!=(i=t.indexOf(i)))&&t.splice(i,1)}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(a.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(a.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t,n=e.command,i=e.editor;if(i.multiSelect)return n.multiSelectAction?t="forEach"==n.multiSelectAction?i.forEachSelection(n,e.args):"forEachLine"==n.multiSelectAction?i.forEachSelection(n,e.args,!0):"single"==n.multiSelectAction?(i.exitMultiSelectMode(),n.exec(i,e.args||{})):n.multiSelectAction(i,e.args||{}):(t=n.exec(i,e.args||{}),i.multiSelect.addRange(i.multiSelect.toOrientedRange()),i.multiSelect.mergeOverlappingRanges()),t},this.forEachSelection=function(e,t,n){if(!this.inVirtualSelectionMode){var i,o=n&&n.keepOrder,r=1==n||n&&n.$byLines,s=this.session,n=this.selection,a=n.rangeList,l=(o?n:a).ranges;if(!l.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var o=n._eventRegistry,c=(n._eventRegistry={},new u(s));this.inVirtualSelectionMode=!0;for(var h=l.length;h--;){if(r)for(;0<h&&l[h].start.row==l[h-1].end.row;)h--;c.fromOrientedRange(l[h]),c.index=h,this.selection=s.selection=c;var d=e.exec?e.exec(this,t||{}):e(this,t||{});i||void 0===d||(i=d),c.toOrientedRange(l[h])}c.detach(),this.selection=s.selection=n,this.inVirtualSelectionMode=!1,n._eventRegistry=o,n.mergeOverlappingRanges(),n.ranges[0]&&n.fromOrientedRange(n.ranges[0]);a=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),a&&a.from==a.to&&this.renderer.animateScrolling(a.from),i}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,n=[],i=0;i<t.length;i++)n.push(this.session.getTextRange(t[i]));var o=this.session.getDocument().getNewLineCharacter();(e=n.join(o)).length==(n.length-1)*o.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){var n;this.inMultiSelectMode&&!this.inVirtualSelectionMode&&(n=this.multiSelect.ranges[0],this.multiSelect.isEmpty()&&t==this.multiSelect.anchor||((n=t==this.multiSelect.anchor?n.cursor==n.start?n.end:n.start:n.cursor).row!=t.row||this.session.$clipPositionToDocument(n.row,n.column).column!=t.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()))},this.findAll=function(e,t,n){(t=t||{}).needle=e||t.needle,null==t.needle&&(i=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange(),t.needle=this.session.getTextRange(i)),this.$search.set(t);var i,o=this.$search.findAll(this.session);if(!o.length)return 0;var r=this.multiSelect;n||r.toSingleRange(o[0]);for(var s=o.length;s--;)r.addRange(o[s],!0);return i&&r.rangeList.rangeAtPoint(i.start)&&r.addRange(i,!0),o.length},this.selectMoreLines=function(e,t){var n,i,o,r=this.selection.toOrientedRange(),s=r.cursor==r.end,a=this.session.documentToScreenPosition(r.cursor),l=(this.selection.$desiredColumn&&(a.column=this.selection.$desiredColumn),this.session.screenToDocumentPosition(a.row+e,a.column));e=r.isEmpty()?l:(n=this.session.documentToScreenPosition(s?r.end:r.start),this.session.screenToDocumentPosition(n.row+e,n.column)),s?(i=I.fromPoints(l,e)).cursor=i.start:(i=I.fromPoints(e,l)).cursor=i.end,i.desiredColumn=a.column,this.selection.inMultiSelectMode?t&&(o=r.cursor):this.selection.addRange(r),this.selection.addRange(i),o&&this.selection.substractPoint(o)},this.transposeSelections=function(e){for(var t,n=this.session,i=n.multiSelect,o=i.ranges,r=o.length;r--;)(a=o[r]).isEmpty()&&(t=n.getWordRange(a.start.row,a.start.column),a.start.row=t.start.row,a.start.column=t.start.column,a.end.row=t.end.row,a.end.column=t.end.column);i.mergeOverlappingRanges();for(var s=[],r=o.length;r--;){var a=o[r];s.unshift(n.getTextRange(a))}e<0?s.unshift(s.pop()):s.push(s.shift());for(r=o.length;r--;){var l=(a=o[r]).clone();n.replace(a,s[r]),a.start.row=l.start.row,a.start.column=l.start.column}i.fromOrientedRange(i.ranges[0])},this.selectMore=function(e,t,n){var i,o=this.session,r=o.multiSelect.toOrientedRange();r.isEmpty()&&((r=o.getWordRange(r.start.row,r.start.column)).cursor=-1==e?r.start:r.end,this.multiSelect.addRange(r),n)||(n=o.getTextRange(r),o=o,n=n,i=e,l.$options.wrap=!0,l.$options.needle=n,l.$options.backwards=-1==i,(n=l.find(o))&&(n.cursor=-1==e?n.start:n.end,this.session.unfold(n),this.multiSelect.addRange(n),this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(r.cursor))},this.alignCursors=function(){var o=this.session,t=o.multiSelect,e=t.ranges,n=-1,i=e.filter(function(e){if(e.cursor.row==n)return!0;n=e.cursor.row});if(e.length&&i.length!=e.length-1){i.forEach(function(e){t.substractPoint(e.cursor)});var r=0,s=1/0,a=e.map(function(e){var e=e.cursor,t=o.getLine(e.row).substr(e.column).search(/\S/g);return e.column>r&&(r=e.column),(t=-1==t?0:t)<s&&(s=t),t});e.forEach(function(e,t){var n=e.cursor,i=r-n.column,t=a[t]-s;t<i?o.insert(n,g.stringRepeat(" ",i-t)):o.remove(new I(n.row,n.column,n.row,n.column-i+t)),e.start.column=e.end.column=r,e.start.row=e.end.row=n.row,e.cursor=e.end}),t.fromOrientedRange(e[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var i=this.selection.getRange(),l=i.start.row,c=i.end.row,e=l==c;if(e){for(var h,d=this.session.getLength();h=this.session.getLine(c),/[=:]/.test(h)&&++c<d;);for(;h=this.session.getLine(l),/[=:]/.test(h)&&0<--l;);l<0&&(l=0),d<=c&&(c=d-1)}var u=this.session.removeFullLines(l,c),u=this.$reAlignText(u,e);this.session.insert({row:l,column:0},u.join("\n")+"\n"),e||(i.start.column=0,i.end.column=u[u.length-1].length),this.selection.setRange(i)}},this.$reAlignText=function(e,t){var n,i,o,r=!0,s=!0;return e.map(function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?(null==n?(n=t[1].length,i=t[2].length,o=t[3].length):(n+i+o!=t[1].length+t[2].length+t[3].length&&(s=!1),n!=t[1].length&&(r=!1),n>t[1].length&&(n=t[1].length),i<t[2].length&&(i=t[2].length),o>t[3].length&&(o=t[3].length)),t):[e]}).map(t?l:r?s?function(e){return e[2]?a(n+i-e[2].length)+e[2]+a(o)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}:l:function(e){return e[2]?a(n)+e[2]+a(o)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]});function a(e){return g.stringRepeat(" ",e)}function l(e){return e[2]?a(n)+e[2]+a(i-e[2].length+o)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}}}.call(i.prototype),o.onSessionChange=function(e){var t=e.session,e=(t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect,e.oldSession);e&&(e.multiSelect.off("addRange",this.$onAddRange),e.multiSelect.off("removeRange",this.$onRemoveRange),e.multiSelect.off("multiSelect",this.$onMultiSelect),e.multiSelect.off("singleSelect",this.$onSingleSelect),e.multiSelect.lead.off("change",this.$checkMultiselectChange),e.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},o.MultiSelect=c,e("./config").defineOptions(i.prototype,"editor",{enableMultiselect:{set:function(e){c(this),e?this.on("mousedown",r):this.off("mousedown",r)},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(e,t,n){"use strict";var h=e("../../range").Range,e=t.FoldMode=function(){};!function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,n){e=e.getLine(n);return this.foldingStartMarker.test(e)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(e)?"end":""},this.getFoldWidgetRange=function(e,t,n){return null},this.indentationBlock=function(e,t,n){var i=/\S/,o=e.getLine(t),r=o.search(i);if(-1!=r){for(var s,n=n||o.length,a=e.getLength(),o=t,l=t;++t<a;){var c=e.getLine(t).search(i);if(-1!=c){if(c<=r){c=e.getTokenAt(t,0);if(!c||"string"!==c.type)break}l=t}}return o<l?(s=e.getLine(l).length,new h(o,n,l,s)):void 0}},this.openingBracketBlock=function(e,t,n,i,o){n={row:n,column:i+1},i=e.$findClosingBracket(t,n,o);if(i)return"start"==(t=null==(t=e.foldWidgets[i.row])?e.getFoldWidget(i.row):t)&&i.row>n.row&&(i.row--,i.column=e.getLine(i.row).length),h.fromPoints(n,i)},this.closingBracketBlock=function(e,t,n,i,o){n={row:n,column:i},i=e.$findOpeningBracket(t,n);if(i)return i.column++,n.column--,h.fromPoints(i,n)}}.call(e.prototype)}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range","ace/config"],function(e,t,n){"use strict";var c=e("../line_widgets").LineWidgets,h=e("../lib/dom"),a=e("../range").Range,d=e("../config").nls;function u(e,t,n){var i=e.getAnnotations().sort(a.comparePoints);if(i.length){var o=function(e,t,n){for(var i=0,o=e.length-1;i<=o;){var r=i+o>>1,s=n(t,e[r]);if(0<s)i=1+r;else{if(!(s<0))return r;o=r-1}}return-(i+1)}(i,{row:t,column:-1},a.comparePoints),r=((o=o<0?-o-1:o)>=i.length?o=0<n?0:i.length-1:0===o&&n<0&&(o=i.length-1),i[o]);if(r&&n){if(r.row===t){for(;(r=i[o+=n])&&r.row===t;);if(!r)return i.slice()}var s=[];for(t=r.row;s[n<0?"unshift":"push"](r),(r=i[o+=n])&&r.row==t;);return s.length&&s}}}t.showErrorMarker=function(e,t){var n,i=e.session,o=(i.widgetManager||(i.widgetManager=new c(i),i.widgetManager.attach(e)),e.getCursorPosition()),r=o.row,s=i.widgetManager.getWidgetsAtRow(r).filter(function(e){return"errorMarker"==e.type})[0],r=(s?s.destroy():r-=t,u(i,r,t));if(r){t=r[0];o.column=(t.pos&&"number"!=typeof t.column?t.pos.sc:t.column)||0,o.row=t.row,n=e.renderer.$gutterLayer.$annotations[o.row]}else{if(s)return;n={text:[d("Looks good!")],className:"ace_ok"}}e.session.unfold(o.row),e.selection.moveToPosition(o);function a(e,t,n){if(0===t&&("esc"===n||"return"===n))return l.destroy(),{command:"null"}}var l={row:o.row,fixedWidth:!0,coverGutter:!0,el:h.createElement("div"),type:"errorMarker"},r=l.el.appendChild(h.createElement("div")),t=l.el.appendChild(h.createElement("div")),s=(t.className="error_widget_arrow "+n.className,e.renderer.$cursorLayer.getPixelPosition(o).left);t.style.left=s+e.renderer.gutterWidth-5+"px",l.el.className="error_widget_wrapper",r.className="error_widget "+n.className,r.innerHTML=n.text.join("<br>"),r.appendChild(h.createElement("div"));l.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(a),i.widgetManager.removeLineWidget(l),e.off("changeSelection",l.destroy),e.off("changeSession",l.destroy),e.off("mouseup",l.destroy),e.off("change",l.destroy))},e.keyBinding.addKeyboardHandler(a),e.on("changeSelection",l.destroy),e.on("changeSession",l.destroy),e.on("mouseup",l.destroy),e.on("change",l.destroy),e.session.widgetManager.addLineWidget(l),l.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:l.el.offsetHeight})},h.importCssString("\n    .error_widget_wrapper {\n        background: inherit;\n        color: inherit;\n        border:none\n    }\n    .error_widget {\n        border-top: solid 2px;\n        border-bottom: solid 2px;\n        margin: 5px 0;\n        padding: 10px 40px;\n        white-space: pre-wrap;\n    }\n    .error_widget.ace_error, .error_widget_arrow.ace_error{\n        border-color: #ff5a5a\n    }\n    .error_widget.ace_warning, .error_widget_arrow.ace_warning{\n        border-color: #F1D817\n    }\n    .error_widget.ace_info, .error_widget_arrow.ace_info{\n        border-color: #5a5a5a\n    }\n    .error_widget.ace_ok, .error_widget_arrow.ace_ok{\n        border-color: #5aaa5a\n    }\n    .error_widget_arrow {\n        position: absolute;\n        border: solid 5px;\n        border-top-color: transparent!important;\n        border-right-color: transparent!important;\n        border-left-color: transparent!important;\n        top: -5px;\n    }\n","error_marker.css",!1)}),ace.define("ace/ace",["require","exports","module","ace/lib/dom","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config","ace/loader_build"],function(e,r,t){"use strict";e("./loader_build")(r);var s=e("./lib/dom"),n=e("./range").Range,a=e("./editor").Editor,i=e("./edit_session").EditSession,o=e("./undomanager").UndoManager,l=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),r.config=e("./config"),r.edit=function(e,t){if("string"==typeof e){var n=e;if(!(e=document.getElementById(n)))throw new Error("ace.edit can't find div #"+n)}var i,o;return e&&e.env&&e.env.editor instanceof a?e.env.editor:(n="",e&&/input|textarea/i.test(e.tagName)?(n=(i=e).value,e=s.createElement("pre"),i.parentNode.replaceChild(e,i)):e&&(n=e.textContent,e.innerHTML=""),n=r.createEditSession(n),e=new a(new l(e),n,t),o={document:n,editor:e,onResize:e.resize.bind(e,null)},i&&(o.textarea=i),e.on("destroy",function(){o.editor.container.env=null}),e.container.env=e.env=o,e)},r.createEditSession=function(e,t){e=new i(e,t);return e.setUndoManager(new o),e},r.Range=n,r.Editor=a,r.EditSession=i,r.UndoManager=o,r.VirtualRenderer=l,r.version=r.config.version}),ace.require(["ace/ace"],function(e){e&&(e.config.init(!0),e.define=ace.define);var t,n=function(){return this}();for(t in(n=(n=n||"undefined"==typeof window?n:window)||"undefined"==typeof self?n:self).ace||(n.ace=e),e)e.hasOwnProperty(t)&&(n.ace[t]=e[t]);n.ace.default=n.ace,i&&(i.exports=n.ace)})},4317:function(t,e,n){t=n.nmd(t),ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(e,s,t){"use strict";var n=e("./lib/dom"),i=e("./lib/oop"),o=e("./lib/event_emitter").EventEmitter,c=e("./lib/lang"),h=e("./range").Range,d=e("./range_list").RangeList,r=e("./keyboard/hash_handler").HashHandler,a=e("./tokenizer").Tokenizer,l=e("./clipboard"),u={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,t,n){e=e.session.getTextRange();return n?e.replace(/\n\r?([ \t]*\S)/g,"\n"+n+"$1"):e},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return l.getText&&l.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){e=e.session.$mode||{};return e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(e){e=e.session.$mode||{};return e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:g.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:g.bind(null,{year:"2-digit"}),CURRENT_MONTH:g.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:g.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:g.bind(null,{month:"short"}),CURRENT_DATE:g.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:g.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:g.bind(null,{weekday:"short"}),CURRENT_HOUR:g.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:g.bind(null,{minute:"2-digit"}),CURRENT_SECOND:g.bind(null,{second:"2-digit"})};function g(e){e=(new Date).toLocaleString("en-us",e);return 1==e.length?"0"+e:e}u.SELECTED_TEXT=u.SELECTION;m.prototype.getTokenizer=function(){return m.$tokenizer||this.createTokenizer()},m.prototype.createTokenizer=function(){function i(e){return e=e.substr(1),/^\d+$/.test(e)?[{tabstopId:parseInt(e,10)}]:[{text:e}]}function e(e){return"(?:[^\\\\"+e+"]|\\\\.)"}var t={regex:"/("+e("/")+"+)/",onMatch:function(e,t,n){n=n[0];return n.fmtString=!0,n.guard=e.slice(1,-1),n.flag=""},next:"formatString"};return m.$tokenizer=new a({start:[{regex:/\\./,onMatch:function(e,t,n){var i=e[1];return[e="}"==i&&n.length||-1!="`$\\".indexOf(i)?i:e]}},{regex:/}/,onMatch:function(e,t,n){return[n.length?n.shift():e]}},{regex:/\$(?:\d+|\w+)/,onMatch:i},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(e,t,n){e=i(e.substr(1));return n.unshift(e[0]),e},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+e("\\|")+"*\\|",onMatch:function(e,t,n){e=e.slice(1,-1).replace(/\\[,|\\]|,/g,function(e){return 2==e.length?e[1]:"\0"}).split("\0").map(function(e){return{value:e}});return[(n[0].choices=e)[0]]},next:"start"},t,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(e,t,n){return n.length&&n[0].expectElse?(n[0].expectElse=!1,n[0].ifEnd={elseEnd:n[0]},[n[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(e,t,n){var i=e[1];return"}"==i&&n.length||-1!="`$\\".indexOf(i)?e=i:"n"==i?e="\n":"t"==i?e="\t":-1!="ulULE".indexOf(i)&&(e={changeCase:i,local:"a"<i}),[e]}},{regex:"/\\w*}",onMatch:function(e,t,n){n=n.shift();return n&&(n.flag=e.slice(1,-1)),this.next=n&&n.tabstopId?"start":"",[n||e]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(e,t,n){return[{text:e.slice(1)}]}},{regex:/\${\w+/,onMatch:function(e,t,n){e={text:e.slice(2)};return n.unshift(e),[e]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(e,t,n){n=n.shift();return this.next=n&&n.tabstopId?"start":"",[n||e]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(e,t,n){return n[0].formatFunction=e.slice(2,-1),[n.shift()]},next:"formatString"},t,{regex:/:[\?\-+]?/,onMatch:function(e,t,n){"+"==e[1]&&(n[0].ifEnd=n[0]),"?"==e[1]&&(n[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},m.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(e){return e.value||e})},m.prototype.getVariableValue=function(e,t,n){var i;return/^\d+$/.test(t)?(this.variables.__||{})[t]||"":/^[A-Z]\d+$/.test(t)?(this.variables[t[0]+"__"]||{})[t.substr(1)]||"":(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t)||null==(i="function"==typeof(i=this.variables[t])?this.variables[t](e,t,n):i)?"":i)},m.prototype.tmStrFormat=function(e,t,s){var n,i,a,l;return t.fmt?(n=t.flag||"",i=t.guard,i=new RegExp(i,n.replace(/[^gim]/g,"")),a="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,l=this,e.replace(i,function(){for(var e=l.variables.__,t=(l.variables.__=[].slice.call(arguments),l.resolveVariables(a,s)),n="E",i=0;i<t.length;i++){var o,r=t[i];"object"==typeof r?(t[i]="",r.changeCase&&r.local?(o=t[i+1])&&"string"==typeof o&&("u"==r.changeCase?t[i]=o[0].toUpperCase():t[i]=o[0].toLowerCase(),t[i+1]=o.substr(1)):r.changeCase&&(n=r.changeCase)):"U"==n?t[i]=r.toUpperCase():"L"==n&&(t[i]=r.toLowerCase())}return l.variables.__=e,t.join("")})):e},m.prototype.tmFormatFunction=function(e,t,n){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},m.prototype.resolveVariables=function(t,e){for(var n=[],i="",o=!0,r=0;r<t.length;r++){var s,a=t[r];"string"==typeof a?(n.push(a),"\n"==a?(o=!0,i=""):o&&(i=/^\t*/.exec(a)[0],o=/\S/.test(a))):a&&(o=!1,a.fmtString&&(-1==(s=t.indexOf(a,r+1))&&(s=t.length),a.fmt=t.slice(r+1,s),r=s),a.text?(s=this.getVariableValue(e,a.text,i)+"",a.fmtString&&(s=this.tmStrFormat(s,a,e)),(s=a.formatFunction?this.tmFormatFunction(s,a,e):s)&&!a.ifEnd?(n.push(s),l(a)):!s&&a.ifEnd&&l(a.ifEnd)):a.elseEnd?l(a.elseEnd):null==a.tabstopId&&null==a.changeCase||n.push(a))}function l(e){e=t.indexOf(e,r+1);-1!=e&&(r=e)}return n},m.prototype.getDisplayTextForSnippet=function(e,t){return f.call(this,e,t).text},m.prototype.insertSnippetForSelection=function(e,t,n){var t=f.call(this,e,t,n=void 0===n?{}:n),n=e.getSelectionRange(),i=e.session.replace(n,t.text),o=new C(e),e=e.inVirtualSelectionMode&&e.selection.index;o.addTabstops(t.tabstops,n.start,i,e)},m.prototype.insertSnippet=function(e,t,n){void 0===n&&(n={});var i=this;if(e.inVirtualSelectionMode)return i.insertSnippetForSelection(e,t,n);e.forEachSelection(function(){i.insertSnippetForSelection(e,t,n)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},m.prototype.$getScope=function(e){var t,n=e.session.$mode.$id||"";return"html"!==(n=n.split("/").pop())&&"php"!==n||("php"!==n||e.session.$mode.inlinePhp||(n="html"),t=e.getCursorPosition(),(e="object"==typeof(e=e.session.getState(t.row))?e[0]:e).substring&&("js-"==e.substring(0,3)?n="javascript":"css-"==e.substring(0,4)?n="css":"php-"==e.substring(0,4)&&(n="php"))),n},m.prototype.getActiveScopes=function(e){var e=this.$getScope(e),t=[e],n=this.snippetMap;return n[e]&&n[e].includeScopes&&t.push.apply(t,n[e].includeScopes),t.push("_"),t},m.prototype.expandWithTab=function(e,t){var n=this,i=e.forEachSelection(function(){return n.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return i&&e.tabstopManager&&e.tabstopManager.tabNext(),i},m.prototype.expandSnippetForSelection=function(e,t){var n,i=e.getCursorPosition(),o=e.session.getLine(i.row),r=o.substring(0,i.column),s=o.substr(i.column),a=this.snippetMap;return this.getActiveScopes(e).some(function(e){e=a[e];return!!(n=e?this.findMatchingSnippet(e,r,s):n)},this),!!n&&(t&&t.dryRun||(e.session.doc.removeInLine(i.row,i.column-n.replaceBefore.length,i.column+n.replaceAfter.length),this.variables.M__=n.matchBefore,this.variables.T__=n.matchAfter,this.insertSnippetForSelection(e,n.content),this.variables.M__=this.variables.T__=null),!0)},m.prototype.findMatchingSnippet=function(e,t,n){for(var i=e.length;i--;){var o=e[i];if((!o.startRe||o.startRe.test(t))&&((!o.endRe||o.endRe.test(n))&&(o.startRe||o.endRe)))return o.matchBefore=o.startRe?o.startRe.exec(t):[""],o.matchAfter=o.endRe?o.endRe.exec(n):[""],o.replaceBefore=o.triggerRe?o.triggerRe.exec(t)[0]:"",o.replaceAfter=o.endTriggerRe?o.endTriggerRe.exec(n)[0]:"",o}},m.prototype.register=function(t,i){var o=this.snippetMap,r=this.snippetNameMap,s=this;function a(e){return(e=e&&!/^\^?\(.*\)\$?$|^\\b$/.test(e)?"(?:"+e+")":e)||""}function l(e,t,n){return e=a(e),t=a(t),n?(e=t+e)&&"$"!=e[e.length-1]&&(e+="$"):(e+=t)&&"^"!=e[0]&&(e="^"+e),new RegExp(e)}function n(e){e.scope||(e.scope=i||"_"),i=e.scope,o[i]||(o[i]=[],r[i]={});var t,n=r[i];e.name&&((t=n[e.name])&&s.unregister(t),n[e.name]=e),o[i].push(e),e.prefix&&(e.tabTrigger=e.prefix),!e.content&&e.body&&(e.content=Array.isArray(e.body)?e.body.join("\n"):e.body),e.tabTrigger&&!e.trigger&&(!e.guard&&/^\w/.test(e.tabTrigger)&&(e.guard="\\b"),e.trigger=c.escapeRegExp(e.tabTrigger)),(e.trigger||e.guard||e.endTrigger||e.endGuard)&&(e.startRe=l(e.trigger,e.guard,!0),e.triggerRe=new RegExp(e.trigger),e.endRe=l(e.endTrigger,e.endGuard,!0),e.endTriggerRe=new RegExp(e.endTrigger))}t=t||[],Array.isArray(t)?t.forEach(n):Object.keys(t).forEach(function(e){n(t[e])}),this._signal("registerSnippets",{scope:i})},m.prototype.unregister=function(e,n){var i=this.snippetMap,o=this.snippetNameMap;function t(e){var t=o[e.scope||n];t&&t[e.name]&&(delete t[e.name],0<=(e=(t=i[e.scope||n])&&t.indexOf(e)))&&t.splice(e,1)}e.content?t(e):Array.isArray(e)&&e.forEach(t)},m.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var t,n,i,o=[],r={},s=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;n=s.exec(e);){if(n[1])try{r=JSON.parse(n[1]),o.push(r)}catch(e){}n[4]?(r.content=n[4].replace(/^\t/gm,""),o.push(r),r={}):(t=n[2],n=n[3],"regex"==t?(r.guard=(i=/\/((?:[^\/\\]|\\.)*)|$/g).exec(n)[1],r.trigger=i.exec(n)[1],r.endTrigger=i.exec(n)[1],r.endGuard=i.exec(n)[1]):"snippet"==t?(r.tabTrigger=n.match(/^\S*/)[0],r.name||(r.name=n)):t&&(r[t]=n))}return o},m.prototype.getSnippetByName=function(t,e){var n,i=this.snippetNameMap;return this.getActiveScopes(e).some(function(e){e=i[e];return!!(n=e?e[t]:n)},this),n};var p=m;function m(){this.snippetMap={},this.snippetNameMap={},this.variables=u}i.implement(p.prototype,o);var f=function(e,t,n){void 0===n&&(n={});var i=e.getCursorPosition(),o=e.session.getLine(i.row),r=e.session.getTabString(),s=o.match(/^\s*/)[0],a=(i.column<s.length&&(s=s.slice(0,i.column)),t=t.replace(/\r/g,""),this.tokenizeTmSnippet(t)),l=(a=(a=this.resolveVariables(a,e)).map(function(e){return"\n"!=e||n.excludeExtraIndent?"string"==typeof e?e.replace(/\t/g,r):e:e+s}),[]),c=(a.forEach(function(e,t){var n,i,o;"object"==typeof e&&(o=e.tabstopId,(n=l[o])||((n=l[o]=[]).index=o,n.value="",n.parents={}),-1===n.indexOf(e))&&(e.choices&&!n.choices&&(n.choices=e.choices),n.push(e),-1!==(i=a.indexOf(e,t+1)))&&((o=a.slice(t+1,i)).some(function(e){return"object"==typeof e})&&!n.value?n.value=o:!o.length||n.value&&"string"==typeof n.value||(n.value=o.join("")))}),l.forEach(function(e){e.length=0}),{});for(var h=0;h<a.length;h++){var d,u,g,p=a[h];"object"==typeof p&&(g=p.tabstopId,d=l[g],u=a.indexOf(p,h+1),c[g]?c[g]===p&&(delete c[g],Object.keys(c).forEach(function(e){d.parents[e]=!0})):(c[g]=p,"string"!=typeof(g=d.value)?g=function(e){for(var t=[],n=0;n<e.length;n++){if("object"==typeof(i=e[n])){if(c[i.tabstopId])continue;var i=t[e.lastIndexOf(i,n-1)]||{tabstopId:i.tabstopId}}t[n]=i}return t}(g):p.fmt&&(g=this.tmStrFormat(g,p,e)),a.splice.apply(a,[h+1,Math.max(0,u-h)].concat(g,p)),-1===d.indexOf(p)&&d.push(p)))}var m=0,f=0,C="";return a.forEach(function(e){var t;"string"==typeof e?(1<(t=e.split("\n")).length?(f=t[t.length-1].length,m+=t.length-1):f+=e.length,C+=e):e&&(e.start?e.end={row:m,column:f}:e.start={row:m,column:f})}),{text:C,tabstops:l,tokens:a}},C=(y.prototype.attach=function(e){this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.session=e.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},y.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},y.prototype.onChange=function(e){for(var t="r"==e.action[0],n=this.selectedTabstop||{},i=n.parents||{},o=this.tabstops.slice(),r=0;r<o.length;r++){var s=o[r],a=s==n||i[s.index];if(s.rangeList.$bias=a?0:1,"remove"==e.action&&s!==n)for(var a=s.parents&&s.parents[n.index],l=(l=s.rangeList.pointIndex(e.start,a))<0?-l-1:l+1,a=s.rangeList.pointIndex(e.end,a),c=s.rangeList.ranges.slice(l,a<0?-a-1:a-1),h=0;h<c.length;h++)this.removeRange(c[h]);s.rangeList.$onChange(e)}var d=this.session;this.$inChange||!t||1!=d.getLength()||d.getValue()||this.detach()},y.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var t=this.session,n=t.getTextRange(e.firstNonLinked),i=0;i<e.length;i++){var o,r=e[i];r.linked&&(o=r.original,o=s.snippetManager.tmStrFormat(n,o,this.editor),t.replace(r,o))}this.$inChange=!1}},y.prototype.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},y.prototype.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,n=this.editor.selection.isEmpty(),i=0;i<this.ranges.length;i++)if(!this.ranges[i].linked){var o=this.ranges[i].contains(e.row,e.column),r=n||this.ranges[i].contains(t.row,t.column);if(o&&r)return}this.detach()}},y.prototype.onChangeSession=function(){this.detach()},y.prototype.tabNext=function(e){var t=this.tabstops.length,e=this.index+(e||1),e=Math.min(Math.max(e,1),t);this.selectTabstop(e=e==t?0:e),0===e&&this.detach()},y.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){e=(this.selectedTabstop=t).firstNonLinked||t;if(t.choices&&(e.cursor=e.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(e);else{var n=this.editor.multiSelect;n.toSingleRange(e);for(var i=0;i<t.length;i++)t.hasLinkedRanges&&t[i].linked||n.addRange(t[i].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},y.prototype.addTabstops=function(e,s,t){var a=this.useLink||!this.editor.getOption("enableMultiselect");this.$openTabstops||(this.$openTabstops=[]),e[0]||(t=h.fromPoints(t,t),I(t.start,s),I(t.end,s),e[0]=[t],e[0].index=0);var l=[this.index+1,0],c=this.ranges;e.forEach(function(e,t){for(var n=this.$openTabstops[t]||e,i=0;i<e.length;i++){var o=e[i],r=h.fromPoints(o.start,o.end||o.start);v(r.start,s),v(r.end,s),r.original=o,r.tabstop=n,c.push(r),n!=e?n.unshift(r):n[i]=r,o.fmtString||n.firstNonLinked&&a?(r.linked=!0,n.hasLinkedRanges=!0):n.firstNonLinked||(n.firstNonLinked=r)}n.firstNonLinked||(n.hasLinkedRanges=!1),n===e&&(l.push(n),this.$openTabstops[t]=n),this.addTabstopMarkers(n),n.rangeList=n.rangeList||new d,n.rangeList.$bias=0,n.rangeList.addList(n)},this),2<l.length&&(this.tabstops.length&&l.push(l.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,l))},y.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){e.markerId||(e.markerId=t.addMarker(e,"ace_snippet-marker","text"))})},y.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){t.removeMarker(e.markerId),e.markerId=null})},y.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);-1!=t&&e.tabstop.splice(t,1),-1!=(t=this.ranges.indexOf(e))&&this.ranges.splice(t,1),-1!=(t=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(t,1),this.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(t=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(t,1),this.tabstops.length)||this.detach()},y);function y(e){if(this.index=0,this.ranges=[],this.tabstops=[],e.tabstopManager)return e.tabstopManager;(e.tabstopManager=this).$onChange=this.onChange.bind(this),this.$onChangeSelection=c.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)}C.prototype.keyboardHandler=new r,C.prototype.keyboardHandler.bindKeys({Tab:function(e){s.snippetManager&&s.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}});var v=function(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row},I=function(e,t){e.row==t.row&&(e.column-=t.column),e.row-=t.row},i=(n.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),s.snippetManager=new p,e("./editor").Editor);!function(){this.insertSnippet=function(e,t){return s.snippetManager.insertSnippet(this,e,t)},this.expandSnippet=function(e){return s.snippetManager.expandWithTab(this,e)}}.call(i.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config","ace/lib/useragent"],function(e,t,n){"use strict";function a(e){return"suggest-aria-id:".concat(e)}function l(e){return(e=new o(e)).$maxLines=4,(e=new r(e)).setHighlightActiveLine(!1),e.setShowPrintMargin(!1),e.renderer.setShowGutter(!1),e.renderer.setHighlightGutterLine(!1),e.$mouseHandler.$focusTimeout=0,e.$highlightTagPending=!0,e}function i(e){function t(){}function n(){s(-1)}var u,i=p.createElement("div"),g=l(i),o=(e&&e.appendChild(i),i.style.display="none",g.renderer.content.style.cursor="default",g.renderer.setStyle("ace_autocomplete"),g.renderer.$textLayer.element.setAttribute("role",f),g.renderer.$textLayer.element.setAttribute("aria-roledescription",m("Autocomplete suggestions")),g.renderer.$textLayer.element.setAttribute("aria-label",m("Autocomplete suggestions")),g.renderer.textarea.setAttribute("aria-hidden","true"),g.setOption("displayIndentGuides",!1),g.setOption("dragDelay",150),g.focus=t,g.$isFocused=!0,g.renderer.$cursorLayer.restartTimer=t,g.renderer.$cursorLayer.element.style.opacity="0",g.renderer.$maxLines=8,g.renderer.$keepTextAreaAtCursor=!1,g.setHighlightActiveLine(!1),g.session.highlight(""),g.session.$searchHighlight.clazz="ace_highlight-marker",g.on("mousedown",function(e){var t=e.getDocumentPosition();g.selection.moveToPosition(t),r.start.row=r.end.row=t.row,e.stop()}),new c(-1,0,-1,1/0)),r=new c(-1,0,-1,1/0),s=(r.id=g.session.addMarker(r,"ace_active-line","fullLine"),g.setSelectOnHover=function(e){e?o.id&&(g.session.removeMarker(o.id),o.id=null):o.id=g.session.addMarker(o,"ace_line-hover","fullLine")},g.setSelectOnHover(!1),g.on("mousemove",function(e){var t;u?u.x==e.x&&u.y==e.y||((u=e).scrollTop=g.renderer.scrollTop,g.isMouseOver=!0,t=u.getDocumentPosition().row,o.start.row!=t&&(o.id||g.setRow(t),s(t))):u=e}),g.renderer.on("beforeRender",function(){var e;u&&-1!=o.start.row&&(u.$pos=null,e=u.getDocumentPosition().row,o.id||g.setRow(e),s(e,!0))}),g.renderer.on("afterRender",function(){var e,t=g.getRow(),n=g.renderer.$textLayer,i=n.element.childNodes[t-n.config.firstRow],o=document.activeElement;i!==g.selectedNode&&g.selectedNode&&(p.removeCssClass(g.selectedNode,"ace_selected"),o.removeAttribute("aria-activedescendant"),g.selectedNode.removeAttribute(y),g.selectedNode.removeAttribute("id")),(g.selectedNode=i)&&(p.addCssClass(i,"ace_selected"),e=a(t),i.id=e,n.element.setAttribute("aria-activedescendant",e),o.setAttribute("aria-activedescendant",e),i.setAttribute("role",C),i.setAttribute("aria-roledescription",m("item")),i.setAttribute("aria-label",g.getData(t).value),i.setAttribute("aria-setsize",g.data.length),i.setAttribute("aria-posinset",t+1),i.setAttribute("aria-describedby","doc-tooltip"),i.setAttribute(y,"true"))}),function(e,t){e!==o.start.row&&(o.start.row=o.end.row=e,t||g.session._emit("changeBackMarker"),g._emit("changeHoverMarker"))});return g.getHoveredRow=function(){return o.start.row},h.addListener(g.container,"mouseout",function(){g.isMouseOver=!1,n()}),g.on("hide",n),g.on("changeSelection",n),g.session.doc.getLength=function(){return g.data.length},g.session.doc.getLine=function(e){e=g.data[e];return"string"==typeof e?e:e&&e.value||""},(e=g.session.bgTokenizer).$tokenizeRow=function(e){var n=g.data[e],i=[];if(n){for(var t,o,r=(n="string"==typeof n?{value:n}:n).caption||n.value||n.name,s=r.toLowerCase(),a=(g.filterText||"").toLowerCase(),l=0,c=0,h=0;h<=a.length;h++)h!=c&&(n.matchMask&1<<h||h==a.length)&&(t=a.slice(c,h),c=h,-1!=(o=s.indexOf(t,l)))&&(d(r.slice(l,o),""),l=o+t.length,d(r.slice(o,l),"completion-highlight"));d(r.slice(l,r.length),""),i.push({type:"completion-spacer",value:" "}),n.meta&&i.push({type:"completion-meta",value:n.meta}),n.message&&i.push({type:"completion-message",value:n.message})}return i;function d(e,t){e&&i.push({type:(n.className||"")+(t||""),value:e})}},e.$updateOnChange=t,e.start=t,g.session.$computeWidth=function(){return this.screenWidth=0},g.isOpen=!1,g.isTopdown=!1,g.autoSelect=!0,g.filterText="",g.isMouseOver=!1,g.data=[],g.setData=function(e,t){g.filterText=t||"",g.setValue(d.stringRepeat("\n",e.length),-1),g.data=e||[],g.setRow(0)},g.getData=function(e){return g.data[e]},g.getRow=function(){return r.start.row},g.setRow=function(e){e=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,e)),r.start.row!=e&&(g.selection.clearSelection(),r.start.row=r.end.row=e||0,g.session._emit("changeBackMarker"),g.moveCursorTo(e||0,0),g.isOpen)&&g._signal("select")},g.on("changeSelection",function(){g.isOpen&&g.setRow(g.selection.lead.row),g.renderer.scrollCursorIntoView()}),g.hide=function(){this.container.style.display="none",g.anchorPos=null,g.anchor=null,g.isOpen&&(g.isOpen=!1,this._signal("hide"))},g.tryShow=function(e,t,n,i){if(i||!g.isOpen||!g.anchorPos||!g.anchor||g.anchorPos.top!==e.top||g.anchorPos.left!==e.left||g.anchor!==n){var o=this.container,r=window.innerHeight,s=window.innerWidth,a=this.renderer,l=a.$maxLines*t*1.4,c={top:0,bottom:0,left:0},h=r-e.top-3*this.$borderSize-t,d=e.top-3*this.$borderSize,t=("top"===(n=n||(d<=h||l<=h?"bottom":"top"))?(c.bottom=e.top-this.$borderSize,c.top=c.bottom-l):"bottom"===n&&(c.top=e.top+t+this.$borderSize,c.bottom=c.top+l),0<=c.top&&c.bottom<=r);if(!i&&!t)return!1;a.$maxPixelHeight=t?null:"top"===n?d:h,"top"===n?(o.style.top="",o.style.bottom=r-c.bottom+"px",g.isTopdown=!1):(o.style.top=c.top+"px",o.style.bottom="",g.isTopdown=!0),o.style.display="";l=e.left;l+o.offsetWidth>s&&(l=s-o.offsetWidth),o.style.left=l+"px",o.style.right="",g.isOpen||(g.isOpen=!0,this._signal("show"),u=null),g.anchorPos=e,g.anchor=n}return!0},g.show=function(e,t,n){this.tryShow(e,t,n?"bottom":void 0,!0)},g.goTo=function(e){var t=this.getRow(),n=this.session.getLength()-1;switch(e){case"up":t=t<=0?n:t-1;break;case"down":t=n<=t?-1:t+1;break;case"start":t=0;break;case"end":t=n}this.setRow(t)},g.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},g.$imageSize=0,g.$borderSize=1,g}var o=e("../virtual_renderer").VirtualRenderer,r=e("../editor").Editor,c=e("../range").Range,h=e("../lib/event"),d=e("../lib/lang"),p=e("../lib/dom"),m=e("../config").nls,e=e("./../lib/useragent"),f=e.isSafari?"menu":"listbox",C=e.isSafari?"menuitem":"option",y=e.isSafari?"aria-current":"aria-selected";p.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",!1),t.AcePopup=i,t.$singleLineEditor=l,t.getAriaId=a}),ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(e,t,n){"use strict";function i(e){this.editor=e,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}i.prototype.setScreenReaderContent=function(e){for(!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",function(){var e=this.popup.getRow(),t=this.popup.renderer.$textLayer,e=t.element.childNodes[e-t.config.firstRow];if(e){for(var n="doc-tooltip ",i=0;i<this._lines.length;i++)n+="ace-inline-screenreader-line-".concat(i," ");e.setAttribute("aria-describedby",n)}}.bind(this)));this.screenReaderDiv.firstChild;)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=e.split(/\r\n|\r|\n/);e=this.createCodeBlock();this.screenReaderDiv.appendChild(e)},i.prototype.destroy=function(){this.screenReaderDiv.remove()},i.prototype.createCodeBlock=function(){var e=document.createElement("pre");e.setAttribute("id","ace-inline-screenreader");for(var t=0;t<this._lines.length;t++){var n=document.createElement("code"),i=(n.setAttribute("id","ace-inline-screenreader-line-".concat(t)),document.createTextNode(this._lines[t]));n.appendChild(i),e.appendChild(n)}return e},t.AceInlineScreenReader=i}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(e,t,n){"use strict";var o=e("../snippets").snippetManager,r=e("./inline_screenreader").AceInlineScreenReader;function i(){this.editor=null}i.prototype.show=function(e,t,n){if(n=n||"",e&&this.editor&&this.editor!==e&&(this.hide(),this.editor=null,this.inlineScreenReader=null),!e||!t)return!1;this.inlineScreenReader||(this.inlineScreenReader=new r(e));var i=t.snippet?o.getDisplayTextForSnippet(e,t.snippet):t.value;return!(t.hideInlinePreview||!i||!i.startsWith(n)||(this.editor=e,this.inlineScreenReader.setScreenReaderContent(i),""===(i=i.slice(n.length))?e.removeGhostText():e.setGhostText(i),0))},i.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},i.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},i.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},t.AceInline=i}),ace.define("ace/autocomplete/util",["require","exports","module"],function(e,t,n){"use strict";t.parForEach=function(e,t,n){var i=0,o=e.length;0===o&&n();for(var r=0;r<o;r++)t(e[r],function(e,t){++i===o&&n(e,t)})};var r=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;t.retrievePrecedingIdentifier=function(e,t,n){n=n||r;for(var i=[],o=t-1;0<=o&&n.test(e[o]);o--)i.push(e[o]);return i.reverse().join("")},t.retrieveFollowingIdentifier=function(e,t,n){n=n||r;for(var i=[],o=t;o<e.length&&n.test(e[o]);o++)i.push(e[o]);return i},t.getCompletionPrefix=function(e){var t,n=e.getCursorPosition(),i=e.session.getLine(n.row);return e.completers.forEach(function(e){e.identifierRegexps&&e.identifierRegexps.forEach(function(e){!t&&e&&(t=this.retrievePrecedingIdentifier(i,n.column,e))}.bind(this))}.bind(this)),t||this.retrievePrecedingIdentifier(i,n.column)},t.triggerAutocomplete=function(e){var t=e.getCursorPosition(),n=e.session.getLine(t.row)[0===t.column?0:t.column-1];return e.completers.some(function(e){if(e.triggerCharacters&&Array.isArray(e.triggerCharacters))return e.triggerCharacters.includes(n)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event","ace/lib/scroll"],function(e,t,n){"use strict";function i(e,t){t.completer&&t.completer.destroy()}var o=e("./keyboard/hash_handler").HashHandler,r=e("./autocomplete/popup").AcePopup,s=e("./autocomplete/inline").AceInline,a=e("./autocomplete/popup").getAriaId,c=e("./autocomplete/util"),l=e("./lib/lang"),h=e("./lib/dom"),d=e("./snippets").snippetManager,u=e("./config"),g=e("./lib/event"),p=e("./lib/scroll").preventParentScroll,m=(Object.defineProperty(f,"completionsForLoading",{get:function(){return[{caption:u.nls("Loading..."),value:""}]},enumerable:!1,configurable:!0}),f.prototype.$init=function(){return this.popup=new r(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(e){this.insertMatch(),e.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),g.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup.renderer.on("afterRender",this.$onPopupRender.bind(this)),this.popup},f.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new s,this.inlineRenderer},f.prototype.getPopup=function(){return this.popup||this.$init()},f.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.popupTimer.cancel(),this.stickySelection=!1},f.prototype.$seen=function(e){!this.hasSeen.has(e)&&e&&e.completer&&e.completer.onSeen&&"function"==typeof e.completer.onSeen&&(e.completer.onSeen(this.editor,e),this.hasSeen.add(e))},f.prototype.$onPopupChange=function(e){var t;this.inlineRenderer&&this.inlineEnabled?(e=e?null:this.popup.getData(this.popup.getRow()),t=c.getCompletionPrefix(this.editor),this.inlineRenderer.show(this.editor,e,t)?this.$seen(e):this.inlineRenderer.hide(),this.popup.isMouseOver&&this.setSelectOnHover?this.tooltipTimer.call(null,null):(this.popupTimer.schedule(),this.tooltipTimer.schedule())):(this.popupTimer.call(null,null),this.tooltipTimer.call(null,null))},f.prototype.$onPopupRender=function(){var e=this.inlineRenderer&&this.inlineEnabled;if(this.completions&&this.completions.filtered&&0<this.completions.filtered.length)for(var t=this.popup.getFirstVisibleRow();t<=this.popup.getLastVisibleRow();t++){var n=this.popup.getData(t);!n||e&&!n.hideInlinePreview||this.$seen(n)}},f.prototype.$onPopupShow=function(e){this.$onPopupChange(e),this.stickySelection=!1,
0<=this.stickySelectionDelay&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},f.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var e=this.editor.container.parentNode,t=[];e;)t.push(e),e.addEventListener("scroll",this.onLayoutChange,{passive:!0}),e=e.parentNode;this.$elements=t}},f.prototype.unObserveLayoutChanges=function(){var t=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(e){e.removeEventListener("scroll",t.onLayoutChange,{passive:!0})}),this.$elements=null},f.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},f.prototype.$updatePopupPosition=function(){var e=this.editor,t=e.renderer,n=t.layerConfig.lineHeight,i=t.$cursorLayer.getPixelPosition(this.base,!0),o=(i.left-=this.popup.getTextLeftOffset(),e.container.getBoundingClientRect()),o=(i.top+=o.top-t.layerConfig.offset,i.left+=o.left-e.renderer.scrollLeft,i.left+=t.gutterWidth,{top:i.top,left:i.left}),t=(t.$ghostText&&t.$ghostTextWidget&&this.base.row===t.$ghostText.position.row&&(o.top+=t.$ghostTextWidget.el.offsetHeight),e.container.getBoundingClientRect().bottom-n);this.popup.tryShow(t<o.top?{top:t,left:o.left}:o,n,"bottom")||this.popup.tryShow(i,n,"top")||this.popup.show(i,n)},f.prototype.openPopup=function(e,t,n){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var i,o=this.popup.getRow(),r=this.popup.data[o];this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:a(this.popup.getRow()),inline:this.inlineEnabled}),e.keyBinding.addKeyboardHandler(this.keyboardHandler),(i=this.stickySelection?this.popup.data.indexOf(r):i)&&-1!==i||(i=0),this.popup.setRow(this.autoSelect?i:-1),i===o&&r!==this.completions.filtered[i]&&this.$onPopupChange(),n?t||this.detach():(this.popup.setTheme(e.getTheme()),this.popup.setFontSize(e.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},f.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.popup&&this.popup.renderer&&this.popup.renderer.off("afterRender",this.$onPopupRender),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},f.prototype.changeListener=function(e){var t=this.editor.selection.lead;(t.row!=this.base.row||t.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},f.prototype.blurListener=function(e){var t=document.activeElement,n=this.editor.textInput.getElement(),i=e.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(e.relatedTarget),o=this.popup&&this.popup.container;t==n||t.parentNode==o||i||t==this.tooltipNode||e.relatedTarget==n||this.detach()},f.prototype.mousedownListener=function(e){this.detach()},f.prototype.mousewheelListener=function(e){this.popup.isMouseOver||this.detach()},f.prototype.mouseOutListener=function(e){this.popup.isOpen&&this.$updatePopupPosition()},f.prototype.goTo=function(e){this.popup.goTo(e)},f.prototype.insertMatch=function(e,t){var n;return!!(e=e||this.popup.getData(this.popup.getRow()))&&(""===e.value?this.detach():(n=this.completions,e=this.getCompletionProvider().insertMatch(this.editor,e,n.filterText,t),this.completions==n&&this.detach(),e))},f.prototype.showPopup=function(e,t){this.editor&&this.detach(),this.activated=!0,(this.editor=e).completer!=this&&(e.completer&&e.completer.detach(),e.completer=this),e.on("changeSelection",this.changeListener),e.on("blur",this.blurListener),e.on("mousedown",this.mousedownListener),e.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,t)},f.prototype.getCompletionProvider=function(e){return this.completionProvider||(this.completionProvider=new C(e)),this.completionProvider},f.prototype.gatherCompletions=function(e,t){return this.getCompletionProvider().gatherCompletions(e,t)},f.prototype.updateCompletions=function(s,e){var t,n;return s&&this.base&&this.completions?(t=this.editor.getCursorPosition(),(n=this.editor.session.getTextRange({start:this.base,end:t}))==this.completions.filterText?void 0:(this.completions.setFilter(n),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=n||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,n,s):this.detach())):e&&e.matches?(t=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(t.row,t.column),this.base.$insertRight=!0,this.completions=new v(e.matches),this.openPopup(this.editor,"",s)):(e=this.editor.getSession(),t=this.editor.getCursorPosition(),n=c.getCompletionPrefix(this.editor),this.base=e.doc.createAnchor(t.row,t.column-n.length),this.base.$insertRight=!0,e={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption},this.getCompletionProvider({prefix:n,pos:t}).provideCompletions(this.editor,e,function(e,t,n){var i,o=t.filtered,r=c.getCompletionPrefix(this.editor);if(this.$firstOpenTimer.cancel(),n){if(!o.length)return(i="function"==typeof(i=!this.autoShown&&this.emptyMessage)?this.emptyMessage(r):i)?(this.completions=new v([{caption:i,value:""}]),this.openPopup(this.editor,r,s),void this.popup.renderer.setStyle("ace_loading",!1)):this.detach();if(1==o.length&&o[0].value==r&&!o[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&1==o.length)return this.insertMatch(o[0])}this.completions=!n&&this.showLoadingState?new v(f.completionsForLoading.concat(o),t.filterText):t,this.openPopup(this.editor,r,s),this.popup.renderer.setStyle("ace_loading",!n)}.bind(this)),void(!this.showLoadingState||this.autoShown||this.popup&&this.popup.isOpen||this.$firstOpenTimer.delay(this.stickySelectionDelay/2)))},f.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},f.prototype.updateDocTooltip=function(){var e=this.popup,t=this.completions.filtered,n=t&&(t[e.getHoveredRow()]||t[e.getRow()]),i=null;if(!n||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var o=this.editor.completers.length,r=0;r<o;r++){var s=this.editor.completers[r];if(s.getDocTooltip&&n.completerId===s.id){i=s.getDocTooltip(n);break}}if(!(i="string"==typeof(i=i||"string"==typeof n?i:n)?{docText:i}:i)||!i.docHTML&&!i.docText)return this.hideDocTooltip();this.showDocTooltip(i)},f.prototype.showDocTooltip=function(e){this.tooltipNode||(this.tooltipNode=h.createElement("div"),this.tooltipNode.style.margin="0",this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.style.overscrollBehavior="contain",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"),this.tooltipNode.addEventListener("wheel",p));var t=this.editor.renderer.theme,t=(this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(t.isDark?"ace_dark ":"")+(t.cssClass||""),this.tooltipNode),e=(e.docHTML?t.innerHTML=e.docHTML:e.docText&&(t.textContent=e.docText),t.parentNode||this.popup.container.appendChild(this.tooltipNode),this.popup),n=e.container.getBoundingClientRect();t.style.top=e.container.style.top,t.style.bottom=e.container.style.bottom,t.style.display="block",window.innerWidth-n.right<320?n.left<320?(e.isTopdown?t.style.top=n.bottom+"px":t.style.top=e.container.offsetTop-t.offsetHeight+"px",t.style.left=n.left+"px",t.style.right="",t.style.bottom=""):(t.style.right=window.innerWidth-n.left+"px",t.style.left=""):(t.style.left=n.right+1+"px",t.style.right="")},f.prototype.hideDocTooltip=function(){var e;this.tooltipTimer.cancel(),this.tooltipNode&&(e=this.tooltipNode,this.editor.isFocused()||document.activeElement!=e||this.editor.focus(),this.tooltipNode=null,e.parentNode)&&e.parentNode.removeChild(e)},f.prototype.onTooltipClick=function(e){for(var t=e.target;t&&t!=this.tooltipNode;){if("A"==t.nodeName&&t.href){t.rel="noreferrer",t.target="_blank";break}t=t.parentNode}},f.prototype.destroy=function(){var e;this.detach(),this.popup&&(this.popup.destroy(),e=this.popup.container)&&e.parentNode&&e.parentNode.removeChild(e),this.editor&&this.editor.completer==this&&(this.editor.off("destroy",i),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},f);function f(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new o,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.hasSeen=new Set,this.showLoadingState=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=l.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=l.delayedCall(this.updateDocTooltip.bind(this),50),this.popupTimer=l.delayedCall(this.$updatePopupPosition.bind(this),50),this.stickySelectionTimer=l.delayedCall(function(){this.stickySelection=!0}.bind(this),this.stickySelectionDelay),this.$firstOpenTimer=l.delayedCall(function(){var e=this.completionProvider&&this.completionProvider.initialPosition;this.autoShown||this.popup&&this.popup.isOpen||!e||0===this.editor.completers.length||(this.completions=new v(f.completionsForLoading),this.openPopup(this.editor,e.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0))}.bind(this),this.stickySelectionDelay)}m.prototype.commands={Up:function(e){e.completer.goTo("up")},Down:function(e){e.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(e){e.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(e){e.completer.goTo("end")},Esc:function(e){e.completer.detach()},Return:function(e){return e.completer.insertMatch()},"Shift-Return":function(e){e.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(e){var t=e.completer.insertMatch();if(t||e.tabstopManager)return t;e.completer.goTo("down")},PageUp:function(e){e.completer.popup.gotoPageUp()},PageDown:function(e){e.completer.popup.gotoPageDown()}},m.for=function(e){return e.completer instanceof m||(e.completer&&(e.completer.destroy(),e.completer=null),u.get("sharedPopups")?(m.$sharedInstance||(m.$sharedInstance=new m),e.completer=m.$sharedInstance):(e.completer=new m,e.once("destroy",i))),e.completer},m.startCommand={name:"startAutocomplete",exec:function(e,t){var n=m.for(e);n.autoInsert=!1,n.autoSelect=!0,n.autoShown=!1,n.showPopup(e,t),n.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};y.prototype.insertByIndex=function(e,t,n){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(e,this.completions.filtered[t],n)},y.prototype.insertMatch=function(e,t,n){if(!t)return!1;if(e.startOperation({command:{name:"insertMatch"}}),t.completer&&t.completer.insertMatch)t.completer.insertMatch(e,t);else{if(!this.completions)return!1;var i=this.completions.filterText.length,o=0;if(t.range&&t.range.start.row===t.range.end.row&&(i=(i-=this.initialPosition.prefix.length)+(this.initialPosition.pos.column-t.range.start.column),o+=t.range.end.column-this.initialPosition.pos.column),i||o)for(var r,s=e.selection.getAllRanges?e.selection.getAllRanges():[e.getSelectionRange()],a=0;r=s[a];a++)r.start.column-=i,r.end.column+=o,e.session.remove(r);t.snippet?d.insertSnippet(e,t.snippet):this.$insertString(e,t),t.completer&&t.completer.onInsert&&"function"==typeof t.completer.onInsert&&t.completer.onInsert(e,t),t.command&&"startAutocomplete"===t.command&&e.execCommand(t.command)}return e.endOperation(),!0},y.prototype.$insertString=function(e,t){t=t.value||t;e.execCommand("insertstring",t)},y.prototype.gatherCompletions=function(i,o){var t=i.getSession(),r=i.getCursorPosition(),s=c.getCompletionPrefix(i),a=[],l=(this.completers=i.completers,i.completers.length);return i.completers.forEach(function(n,e){n.getCompletions(i,t,r,s,function(e,t){n.hideInlinePreview&&(t=t.map(function(e){return Object.assign(e,{hideInlinePreview:n.hideInlinePreview})})),!e&&t&&(a=a.concat(t)),o(null,{prefix:c.getCompletionPrefix(i),matches:a,finished:0==--l})})}),!0},y.prototype.provideCompletions=function(e,i,o){var n=function(e){var t=e.prefix,n=e.matches;this.completions=new v(n),i.exactMatch&&(this.completions.exactMatch=!0),i.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(t),(e.finished||this.completions.filtered.length)&&o(null,this.completions,e.finished)}.bind(this),r=!0,s=null;this.gatherCompletions(e,function(e,t){this.active&&(e&&(o(e,[],!0),this.detach()),0===t.prefix.indexOf(t.prefix))&&(r?s=t:n(t))}.bind(this)),r=!1,s&&(e=s,s=null,n(e))},y.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(e){"function"==typeof e.cancel&&e.cancel()})};var C=y;function y(e){this.initialPosition=e,this.active=!0}I.prototype.setFilter=function(e){t=e.length>this.filterText&&0===e.lastIndexOf(this.filterText,0)?this.filtered:this.all,this.filterText=e,t=(t=this.filterCompletions(t,this.filterText)).sort(function(e,t){return t.exactMatch-e.exactMatch||t.$score-e.$score||(e.caption||e.value).localeCompare(t.caption||t.value)});var t,n=null;t=t.filter(function(e){e=e.snippet||e.caption||e.value;return e!==n&&(n=e,!0)}),this.filtered=t},I.prototype.filterCompletions=function(e,t){var n=[],i=t.toUpperCase(),o=t.toLowerCase();e:for(var r,s=0;r=e[s];s++){var a=!this.ignoreCaption&&r.caption||r.value||r.snippet;if(a){var l=-1,c=0,h=0;if(this.exactMatch){if(t!==a.substr(0,t.length))continue}else{var d=a.toLowerCase().indexOf(o);if(-1<d)h=d;else for(var u=0;u<t.length;u++){var g=a.indexOf(o[u],l+1),p=a.indexOf(i[u],l+1);if((g=0<=g&&(p<0||g<p)?g:p)<0)continue e;0<(p=g-l-1)&&(-1===l&&(h+=10),h+=p,c|=1<<u),l=g}}r.matchMask=c,r.exactMatch=h?0:1,r.$score=(r.score||0)-h,n.push(r)}}return n};var v=I;function I(e,t){this.all=e,this.filtered=e,this.filterText=t||"",this.exactMatch=!1,this.ignoreCaption=!1}t.Autocomplete=m,t.CompletionProvider=C,t.FilteredList=v}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(e,t,n){var s=e("../range").Range,a=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;function l(e,t){var n=e.getTextRange(s.fromPoints({row:0,column:0},t)).split(a).length-1,i=e.getValue().split(a),o=Object.create(null),r=i[n];return i.forEach(function(e,t){e&&e!==r&&(t=Math.abs(n-t),t=i.length-t,o[e]?o[e]=Math.max(t,o[e]):o[e]=t)}),o}t.getCompletions=function(e,t,n,i,o){var r=l(t,n);o(null,Object.keys(r).map(function(e){return{caption:e,value:e,score:r[e],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(e,t,n){"use strict";function i(e,t){f(t.session.$mode)}function o(e){var t=e.editor,n=t.completer&&t.completer.activated;"backspace"===e.command.name?n&&!h.getCompletionPrefix(t)&&t.completer.detach():"insertstring"!==e.command.name||n||((t=(r=e).editor.$liveAutocompletionDelay)?y.delay(t):v(e))}var r,l=e("../snippets").snippetManager,s=e("../autocomplete").Autocomplete,a=e("../config"),c=e("../lib/lang"),h=e("../autocomplete/util"),d=e("../autocomplete/text_completer"),u={getCompletions:function(e,t,n,i,o){if(t.$mode.completer)return t.$mode.completer.getCompletions(e,t,n,i,o);e=e.session.getState(n.row);o(null,t.$mode.getCompletions(e,t,n,i).map(function(e){return e.completerId=u.id,e}))},id:"keywordCompleter"},g={getCompletions:function(e,t,n,i,o){var r=[],t=t.getTokenAt(n.row,n.column),s=(t&&t.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?r.push("html-tag"):r=l.getActiveScopes(e),l.snippetMap),a=[];r.forEach(function(e){for(var t=s[e]||[],n=t.length;n--;){var i=t[n],o=i.name||i.tabTrigger;o&&a.push({caption:o,snippet:i.content,meta:i.tabTrigger&&!i.name?i.tabTrigger+"⇥ ":"snippet",completerId:g.id})}},this),o(null,a)},getDocTooltip:function(e){var o;e.snippet&&!e.docHTML&&(e.docHTML=["<b>",c.escapeHTML(e.caption),"</b>","<hr></hr>",c.escapeHTML((e=e.snippet,o={},e.replace(/\${(\d+)(:(.*?))?}/g,function(e,t,n,i){return o[t]=i||""}).replace(/\$(\d+?)/g,function(e,t){return o[t]})))].join(""))},id:"snippetCompleter"},p=[g,d,u],m=(t.setCompleters=function(e){p.length=0,e&&p.push.apply(p,e)},t.addCompleter=function(e){p.push(e)},t.textCompleter=d,t.keyWordCompleter=u,t.snippetCompleter=g,{name:"expandSnippet",exec:function(e){return l.expandWithTab(e)},bindKey:"Tab"}),f=function(e){(e="string"==typeof e?a.$modes[e]:e)&&(l.files||(l.files={}),C(e.$id,e.snippetFileId),e.modes)&&e.modes.forEach(f)},C=function(t,e){e&&t&&!l.files[t]&&(l.files[t]={},a.loadModule(e,function(e){e&&(!(l.files[t]=e).snippets&&e.snippetText&&(e.snippets=l.parseSnippetFile(e.snippetText)),l.register(e.snippets||[],e.scope),e.includeScopes)&&(l.snippetMap[e.scope].includeScopes=e.includeScopes,e.includeScopes.forEach(function(e){f("ace/mode/"+e)}))}))},y=c.delayedCall(function(){v(r)},0),v=function(e){var e=e.editor,t=h.getCompletionPrefix(e),n=h.triggerAutocomplete(e);(t&&t.length>=e.$liveAutocompletionThreshold||n)&&((t=s.for(e)).autoShown=!0,t.showPopup(e))},d=e("../editor").Editor;e("../config").defineOptions(d.prototype,"editor",{enableBasicAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:p),this.commands.addCommand(s.startCommand)):this.commands.removeCommand(s.startCommand)},value:!1},enableLiveAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:p),this.commands.on("afterExec",o)):this.commands.off("afterExec",o)},value:!1},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(e){e?(this.commands.addCommand(m),this.on("changeMode",i),i(0,this)):(this.commands.removeCommand(m),this.off("changeMode",i))},value:!1}})}),ace.require(["ace/ext/language_tools"],function(e){t&&(t.exports=e)})},3330:function(t,e,n){t=n.nmd(t),ace.define("ace/ext/searchbox-css",["require","exports","module"],function(e,t,n){n.exports='\n\n/* ------------------------------------------------------------------------------------------\n * Editor Search Form\n * --------------------------------------------------------------------------------------- */\n.ace_search {\n    background-color: #ddd;\n    color: #666;\n    border: 1px solid #cbcbcb;\n    border-top: 0 none;\n    overflow: hidden;\n    margin: 0;\n    padding: 4px 6px 0 4px;\n    position: absolute;\n    top: 0;\n    z-index: 99;\n    white-space: normal;\n}\n.ace_search.left {\n    border-left: 0 none;\n    border-radius: 0px 0px 5px 0px;\n    left: 0;\n}\n.ace_search.right {\n    border-radius: 0px 0px 0px 5px;\n    border-right: 0 none;\n    right: 0;\n}\n\n.ace_search_form, .ace_replace_form {\n    margin: 0 20px 4px 0;\n    overflow: hidden;\n    line-height: 1.9;\n}\n.ace_replace_form {\n    margin-right: 0;\n}\n.ace_search_form.ace_nomatch {\n    outline: 1px solid red;\n}\n\n.ace_search_field {\n    border-radius: 3px 0 0 3px;\n    background-color: white;\n    color: black;\n    border: 1px solid #cbcbcb;\n    border-right: 0 none;\n    outline: 0;\n    padding: 0;\n    font-size: inherit;\n    margin: 0;\n    line-height: inherit;\n    padding: 0 6px;\n    min-width: 17em;\n    vertical-align: top;\n    min-height: 1.8em;\n    box-sizing: content-box;\n}\n.ace_searchbtn {\n    border: 1px solid #cbcbcb;\n    line-height: inherit;\n    display: inline-block;\n    padding: 0 6px;\n    background: #fff;\n    border-right: 0 none;\n    border-left: 1px solid #dcdcdc;\n    cursor: pointer;\n    margin: 0;\n    position: relative;\n    color: #666;\n}\n.ace_searchbtn:last-child {\n    border-radius: 0 3px 3px 0;\n    border-right: 1px solid #cbcbcb;\n}\n.ace_searchbtn:disabled {\n    background: none;\n    cursor: default;\n}\n.ace_searchbtn:hover {\n    background-color: #eef1f6;\n}\n.ace_searchbtn.prev, .ace_searchbtn.next {\n     padding: 0px 0.7em\n}\n.ace_searchbtn.prev:after, .ace_searchbtn.next:after {\n     content: "";\n     border: solid 2px #888;\n     width: 0.5em;\n     height: 0.5em;\n     border-width:  2px 0 0 2px;\n     display:inline-block;\n     transform: rotate(-45deg);\n}\n.ace_searchbtn.next:after {\n     border-width: 0 2px 2px 0 ;\n}\n.ace_searchbtn_close {\n    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;\n    border-radius: 50%;\n    border: 0 none;\n    color: #656565;\n    cursor: pointer;\n    font: 16px/16px Arial;\n    padding: 0;\n    height: 14px;\n    width: 14px;\n    top: 9px;\n    right: 7px;\n    position: absolute;\n}\n.ace_searchbtn_close:hover {\n    background-color: #656565;\n    background-position: 50% 100%;\n    color: white;\n}\n\n.ace_button {\n    margin-left: 2px;\n    cursor: pointer;\n    -webkit-user-select: none;\n    -moz-user-select: none;\n    -o-user-select: none;\n    -ms-user-select: none;\n    user-select: none;\n    overflow: hidden;\n    opacity: 0.7;\n    border: 1px solid rgba(100,100,100,0.23);\n    padding: 1px;\n    box-sizing:    border-box!important;\n    color: black;\n}\n\n.ace_button:hover {\n    background-color: #eee;\n    opacity:1;\n}\n.ace_button:active {\n    background-color: #ddd;\n}\n\n.ace_button.checked {\n    border-color: #3399ff;\n    opacity:1;\n}\n\n.ace_search_options{\n    margin-bottom: 3px;\n    text-align: right;\n    -webkit-user-select: none;\n    -moz-user-select: none;\n    -o-user-select: none;\n    -ms-user-select: none;\n    user-select: none;\n    clear: both;\n}\n\n.ace_search_counter {\n    float: left;\n    font-family: arial;\n    padding: 0 8px;\n}'}),ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/ext/searchbox-css","ace/keyboard/hash_handler","ace/lib/keys","ace/config"],function(e,t,n){"use strict";var o=e("../lib/dom"),c=e("../lib/lang"),r=e("../lib/event"),s=e("./searchbox-css"),i=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys"),h=e("../config").nls,l=(o.importCssString(s,"ace_searchbox",!1),d.prototype.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},d.prototype.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},d.prototype.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},d.prototype.$init=function(){var e=this.element,i=(this.$initElements(e),this);r.addListener(e,"mousedown",function(e){setTimeout(function(){i.activeInput.focus()},0),r.stopPropagation(e)}),r.addListener(e,"click",function(e){var t=(e.target||e.srcElement).getAttribute("action");t&&i[t]?i[t]():i.$searchBarKb.commands[t]&&i.$searchBarKb.commands[t].exec(i),r.stopPropagation(e)}),r.addCommandKeyListener(e,function(e,t,n){n=a.keyCodeToString(n),t=i.$searchBarKb.findKeyCommand(t,n);t&&t.exec&&(t.exec(i),r.stopEvent(e))}),this.$onChange=c.delayedCall(function(){i.find(!1,!1)}),r.addListener(this.searchInput,"input",function(){i.$onChange.schedule(20)}),r.addListener(this.searchInput,"focus",function(){i.activeInput=i.searchInput,i.searchInput.value&&i.highlight()}),r.addListener(this.replaceInput,"focus",function(){i.activeInput=i.replaceInput,i.searchInput.value&&i.highlight()})},d.prototype.setSearchRange=function(e){(this.searchRange=e)?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},d.prototype.$syncOptions=function(e){o.setCssClass(this.replaceOption,"checked",this.searchRange),o.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",o.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),o.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),o.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var t=this.editor.getReadOnly();this.replaceOption.style.display=t?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!t?"":"none",this.find(!1,!1,e)},d.prototype.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},d.prototype.find=function(e,t,n){e=!this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:n,range:this.searchRange})&&this.searchInput.value;o.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.updateCounter()},d.prototype.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,n=t.unicode,i=0,o=0;if(t){var r,s,a=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),l=e.session.doc.positionToIndex(e.selection.anchor);for(this.searchRange&&(l-=e.session.doc.positionToIndex(this.searchRange.start)),t.lastIndex=0;(s=t.exec(a))&&((r=s.index)<=l&&o++,!(999<++i))&&(s[0]||(t.lastIndex=r+=c.skipEmptyMatch(a,r,n),!(r>=a.length))););}this.searchCounter.textContent=h("$0 of $1",[o,999<i?"999+":i])},d.prototype.findNext=function(){this.find(!0,!1)},d.prototype.findPrev=function(){this.find(!0,!0)},d.prototype.findAll=function(){var e=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;o.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.hide()},d.prototype.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},d.prototype.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},d.prototype.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},d.prototype.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},d.prototype.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},d.prototype.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput},d);function d(e,t,n){this.activeInput;var i=o.createElement("div");o.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:h("Search for"),spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"​"],["span",{action:"findNext",class:"ace_searchbtn next"},"​"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},h("All")]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:h("Replace with"),spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},h("Replace")],["span",{action:"replaceAll",class:"ace_searchbtn"},h("All")]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:h("Toggle Replace mode"),style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:h("RegExp Search")},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:h("CaseSensitive Search")},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:h("Whole Word Search")},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:h("Search In Selection")},"S"]]],i),this.element=i.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e),o.importCssString(s,"ace_searchbox",e.container)}e=new i,e.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.editor.getReadOnly()||(e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus())},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),e.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),i=new i([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]);l.prototype.$searchBarKb=e,l.prototype.$closeSearchBarKb=i,t.SearchBox=l,t.Search=function(e,t){(e.searchBox||new l(e)).show(e.session.getTextRange(),t)}}),ace.require(["ace/ext/searchbox"],function(e){t&&(t.exports=e)})},4091:function(t,e,n){t=n.nmd(t),ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,n){"use strict";function i(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"punctuation.operator",regex:/[,]/},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var o=e("../lib/oop"),e=e("./text_highlight_rules").TextHighlightRules;o.inherits(i,e),t.JsonHighlightRules=i}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,n){"use strict";function i(){}var o=e("../range").Range;!function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var n,i=e.getLine(t).match(/^(\s*\})/);return i&&(i=i[1].length,n=e.findMatchingBracket({row:t,column:i}))&&n.row!=t?(n=this.$getIndent(e.getLine(n.row)),void e.replace(new o(t,0,t,i-1),n)):0},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}.call(i.prototype),t.MatchingBraceOutdent=i}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,n){"use strict";var i=e("../../lib/oop"),h=e("../../range").Range,e=e("./fold_mode").FoldMode,t=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};i.inherits(t,e),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,n){var i=e.getLine(n);return!this.singleLineBlockCommentRe.test(i)||this.startRegionRe.test(i)||this.tripleStarBlockCommentRe.test(i)?!(e=this._getFoldWidgetBase(e,t,n))&&this.startRegionRe.test(i)?"start":e:""},this.getFoldWidgetRange=function(e,t,n,i){var o,r,s,a=e.getLine(n);return this.startRegionRe.test(a)?this.getCommentRegionBlock(e,a,n):(r=a.match(this.foldingStartMarker))?(s=r.index,r[1]?this.openingBracketBlock(e,r[1],n,s):((o=e.getCommentFoldRange(n,s+r[0].length,1))&&!o.isMultiLine()&&(i?o=this.getSectionRange(e,n):"all"!=t&&(o=null)),o)):"markbegin"!==t&&(r=a.match(this.foldingStopMarker))?(s=r.index+r[0].length,r[1]?this.closingBracketBlock(e,r[1],n,s):e.getCommentFoldRange(n,s,-1)):void 0},this.getSectionRange=function(e,t){for(var n=(a=e.getLine(t)).search(/\S/),i=t,o=a.length,r=t+=1,s=e.getLength();++t<s;){var a,l=(a=e.getLine(t)).search(/\S/);if(-1!==l){if(l<n)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=i)break;if(c.isMultiLine())t=c.end.row;else if(n==l)break}r=t}}return new h(i,o,r,e.getLine(r).length)},this.getCommentRegionBlock=function(e,t,n){for(var i=t.search(/\s*$/),o=e.getLength(),r=n,s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++n<o;){t=e.getLine(n);var l=s.exec(t);if(l&&(l[1]?a--:a++,!a))break}if(r<n)return new h(r,i,n,t.length)}}.call(t.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,n){"use strict";function i(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=this.$defaultBehaviour,this.foldingRules=new l}var o=e("../lib/oop"),r=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./folding/cstyle").FoldMode,c=e("../worker/worker_client").WorkerClient;o.inherits(i,r),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(e,t,n){var i=this.$getIndent(t);return"start"==e&&t.match(/^.*[\{\(\[]\s*$/)&&(i+=n),i},this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)},this.createWorker=function(t){var e=new c(["ace"],"ace/mode/json_worker","JsonWorker");return e.attachToDocument(t.getDocument()),e.on("annotate",function(e){t.setAnnotations(e.data)}),e.on("terminate",function(){t.clearAnnotations()}),e},this.$id="ace/mode/json"}.call(i.prototype),t.Mode=i}),ace.require(["ace/mode/json"],function(e){t&&(t.exports=e)})},8903:function(e,t,g){"use strict";var s=g(5689),l=g(3969),p=g(5255),c=g(4293),m=g(3508),f=g(3368),C=g(742),y=g(9394),v=g(3724),e=((e.exports=w).prototype.validate=function(e,t){var n;if("string"==typeof e){if(!(n=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{e=this._addSchema(e);n=e.validate||this._compile(e)}e=n(t);!0!==n.$async&&(this.errors=n.errors);return e},w.prototype.compile=function(e,t){e=this._addSchema(e,void 0,t);return e.validate||this._compile(e)},w.prototype.addSchema=function(e,t,n,i){if(Array.isArray(e))for(var o=0;o<e.length;o++)this.addSchema(e[o],void 0,n,i);else{var r=this._getId(e);if(void 0!==r&&"string"!=typeof r)throw new Error("schema id must be string");h(this,t=l.normalizeId(t||r)),this._schemas[t]=this._addSchema(e,n,i,!0)}return this},w.prototype.addMetaSchema=function(e,t,n){return this.addSchema(e,t,n,!0),this},w.prototype.validateSchema=function(e,t){var n=e.$schema;if(void 0!==n&&"string"!=typeof n)throw new Error("$schema must be a string");if(!(n=n||this._opts.defaultMeta||function(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(I)?I:void 0,e._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);n=this.validate(n,e);if(!n&&t){e="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(e);this.logger.error(e)}return n},w.prototype.getSchema=function(e){var t=n(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return function(e,t){var n=l.schema.call(e,{schema:{}},t);{var i,o,r;if(n)return i=n.schema,o=n.root,n=n.baseId,r=s.call(e,i,o,void 0,n),e._fragments[t]=new c({ref:t,fragment:!0,schema:i,root:o,baseId:n,validate:r}),r}}(this,e)}},w.prototype.removeSchema=function(e){if(e instanceof RegExp)i(this,this._schemas,e),i(this,this._refs,e);else switch(typeof e){case"undefined":return i(this,this._schemas),i(this,this._refs),this._cache.clear(),this;case"string":var t=n(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":t=this._opts.serialize,t=t?t(e):e,t=(this._cache.del(t),this._getId(e));t&&(t=l.normalizeId(t),delete this._schemas[t],delete this._refs[t])}return this},w.prototype.addFormat=function(e,t){"string"==typeof t&&(t=new RegExp(t));return this._formats[e]=t,this},w.prototype.errorsText=function(e,t){if(!(e=e||this.errors))return"No errors";for(var n=void 0===(t=t||{}).separator?", ":t.separator,i=void 0===t.dataVar?"data":t.dataVar,o="",r=0;r<e.length;r++){var s=e[r];s&&(o+=i+s.dataPath+" "+s.message+n)}return o.slice(0,-n.length)},w.prototype._addSchema=function(e,t,n,i){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var o=this._opts.serialize,o=o?o(e):e,r=this._cache.get(o);if(r)return r;i=i||!1!==this._opts.addUsedSchema;r=l.normalizeId(this._getId(e));r&&i&&h(this,r);var s,t=!1!==this._opts.validateSchema&&!t;t&&!(s=r&&r==l.normalizeId(e.$schema))&&this.validateSchema(e,!0);var a=l.ids.call(this,e),a=new c({id:r,schema:e,localRefs:a,cacheKey:o,meta:n});"#"!=r[0]&&i&&(this._refs[r]=a);this._cache.put(o,a),t&&s&&this.validateSchema(e,!0);return a},w.prototype._compile=function(n,e){if(n.compiling)return(n.validate=o).schema=n.schema,o.errors=null,o.root=e||o,!0===n.schema.$async&&(o.$async=!0),o;var t,i;n.compiling=!0,n.meta&&(t=this._opts,this._opts=this._metaOpts);try{i=s.call(this,n.schema,e,n.localRefs)}catch(e){throw delete n.validate,e}finally{n.compiling=!1,n.meta&&(this._opts=t)}return n.validate=i,n.refs=i.refs,n.refVal=i.refVal,n.root=i.root,i;function o(){var e=n.validate,t=e.apply(this,arguments);return o.errors=e.errors,t}},w.prototype.compileAsync=g(9677),g(7931)),e=(w.prototype.addKeyword=e.add,w.prototype.getKeyword=e.get,w.prototype.removeKeyword=e.remove,w.prototype.validateKeyword=e.validate,g(5359)),I=(w.ValidationError=e.Validation,w.MissingRefError=e.MissingRef,w.$dataMetaSchema=y,"http://json-schema.org/draft-07/schema"),b=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],A=["/properties"];function w(e){if(!(this instanceof w))return new w(e);e=this._opts=v.copy(e)||{};var t=this,n=t._opts.logger;if(!1===n)t.logger={log:E,warn:E,error:E};else{if(!("object"==typeof(n=void 0===n?console:n)&&n.log&&n.warn&&n.error))throw new Error("logger must implement log, warn and error methods");t.logger=n}if(this._schemas={},this._refs={},this._fragments={},this._formats=f(e.format),this._cache=e.cache||new p,this._loadingSchemas={},this._compilations=[],this.RULES=C(),this._getId=function(e){switch(e.schemaId){case"auto":return k;case"id":return S;default:return x}}(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=m),this._metaOpts=function(e){for(var t=v.copy(e._opts),n=0;n<b.length;n++)delete t[b[n]];return t}(this),e.formats){var i,o=this;for(i in o._opts.formats){var r=o._opts.formats[i];o.addFormat(i,r)}}if(e.keywords){var s,a=this;for(s in a._opts.keywords){var l=a._opts.keywords[s];a.addKeyword(s,l)}}var c,t=this,h=(t._opts.$data&&(c=g(894),t.addMetaSchema(c,c.$id,!0)),!1!==t._opts.meta&&(c=g(6680),t._opts.$data&&(c=y(c,A)),t.addMetaSchema(c,I,!0),t._refs["http://json-schema.org/schema"]=I),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),this),d=h._opts.schemas;if(d)if(Array.isArray(d))h.addSchema(d);else for(var u in d)h.addSchema(d[u],u)}function n(e,t){return t=l.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function i(e,t,n){for(var i in t){var o=t[i];o.meta||n&&!n.test(i)||(e._cache.del(o.cacheKey),delete t[i])}}function S(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function x(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function k(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function h(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function E(){}},5255:function(e){"use strict";e=e.exports=function(){this._cache={}};e.prototype.put=function(e,t){this._cache[e]=t},e.prototype.get=function(e){return this._cache[e]},e.prototype.del=function(e){delete this._cache[e]},e.prototype.clear=function(){this._cache={}}},9677:function(e,t,n){"use strict";var i=n(5359).MissingRef;function o(t,s,n){var a=this;if("function"!=typeof this._opts.loadSchema)throw new Error("options.loadSchema should be a function");"function"==typeof s&&(n=s,s=void 0);var e=l(t).then(function(){var e=a._addSchema(t,void 0,s);return e.validate||function o(r){try{return a._compile(r)}catch(e){if(e instanceof i)return t(e);throw e}function t(e){var t=e.missingSchema;if(i(t))throw new Error("Schema "+t+" is loaded but "+e.missingRef+" cannot be resolved");e=a._loadingSchemas[t];return e||(e=a._loadingSchemas[t]=a._opts.loadSchema(t)).then(n,n),e.then(function(e){if(!i(t))return l(e).then(function(){i(t)||a.addSchema(e,t,void 0,s)})}).then(function(){return o(r)});function n(){delete a._loadingSchemas[t]}function i(e){return a._refs[e]||a._schemas[e]}}}(e)});return n&&e.then(function(e){n(null,e)},n),e;function l(e){e=e.$schema;return e&&!a.getSchema(e)?o.call(a,{$ref:e},!0):Promise.resolve()}}e.exports=o},5359:function(e,t,n){"use strict";var i=n(3969);function o(e,t,n){this.message=n||o.message(e,t),this.missingRef=i.url(e,t),this.missingSchema=i.normalizeId(i.fullPath(this.missingRef))}function r(e){return e.prototype=Object.create(Error.prototype),e.prototype.constructor=e}e.exports={Validation:r(function(e){this.message="validation failed",this.errors=e,this.ajv=this.validation=!0}),MissingRef:r(o)},o.message=function(e,t){return"can't resolve reference "+t+" from id "+e}},3368:function(e,t,n){"use strict";var i=n(3724),o=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,r=[0,31,28,31,30,31,30,31,31,30,31,30,31],s=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i,n=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,a=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,l=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,c=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,h=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,d=/^(?:\/(?:[^~/]|~0|~1)*)*$/,u=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,g=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function p(e){return i.copy(p[e="full"==e?"full":"fast"])}function m(e){var t,n,e=e.match(o);return!!e&&(t=+e[1],n=+e[2],e=+e[3],1<=n)&&n<=12&&1<=e&&e<=(2!=n||(e=t)%4!=0||e%100==0&&e%400!=0?r[n]:29)}function f(e,t){var n,i,o,e=e.match(s);return!!e&&(n=e[1],i=e[2],o=e[3],e=e[5],n<=23&&i<=59&&o<=59||23==n&&59==i&&60==o)&&(!t||e)}(e.exports=p).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":l,url:c,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:n,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:I,uuid:h,"json-pointer":d,"json-pointer-uri-fragment":u,"relative-json-pointer":g},p.full={date:m,time:f,"date-time":function(e){e=e.split(C);return 2==e.length&&m(e[0])&&f(e[1],!0)},uri:function(e){return y.test(e)&&a.test(e)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":l,url:c,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:n,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:I,uuid:h,"json-pointer":d,"json-pointer-uri-fragment":u,"relative-json-pointer":g};var C=/t|\s/i;var y=/\/|:/;var v=/[^\\]\\Z/;function I(e){if(v.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}}},5689:function(e,t,n){"use strict";var E=n(3969),T=n(3724),R=n(5359),_=n(3508),$=n(1869),L=T.ucs2length,N=n(2303),M=R.Validation;function B(e,s,a,t){var l=this,c=this._opts,h=[void 0],d={},u=[],n={},g=[],i={},p=[],o=(s=s||{schema:e,refVal:h,refs:d},function(e,t,n){var i=W.call(this,e,t,n);return 0<=i?{index:i,compiling:!0}:(i=this._compilations.length,this._compilations[i]={schema:e,root:t,baseId:n},{index:i,compiling:!1})}.call(this,e,s,t)),r=this._compilations[o.index];if(o.compiling)return r.callValidate=v;var m=this._formats,f=this.RULES;try{var C=I(e,s,a,t),y=(r.validate=C,r.callValidate);return y&&(y.schema=C.schema,y.errors=null,y.refs=C.refs,y.refVal=C.refVal,y.root=C.root,y.$async=C.$async,c.sourceCode)&&(y.source=C.source),C}finally{!function(e,t,n){e=W.call(this,e,t,n);0<=e&&this._compilations.splice(e,1)}.call(this,e,s,t)}function v(){var e=r.validate,t=e.apply(this,arguments);return v.errors=e.errors,t}function I(e,t,n,i){var o=!t||t.schema==e;if(t.schema!=s.schema)return B.call(l,e,t,n,i);n=!0===e.$async,i=$({isTop:!0,schema:e,isRoot:o,baseId:i,root:t,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:R.MissingRef,RULES:f,validate:$,util:T,resolve:E,resolveRef:b,usePattern:S,useDefault:x,useCustomRule:k,opts:c,formats:m,logger:l.logger,self:l}),i=O(h,G)+O(u,P)+O(g,H)+O(p,F)+i;c.processCode&&(i=c.processCode(i,e));try{var r=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",i)(l,f,m,s,h,g,p,N,L,M);h[0]=r}catch(e){throw l.logger.error("Error compiling schema, function code:",i),e}return r.schema=e,r.errors=null,r.refs=d,r.refVal=h,r.root=o?r:t,n&&(r.$async=!0),!0===c.sourceCode&&(r.source={code:i,patterns:u,defaults:g}),r}function b(e,t,n){t=E.url(e,t);var i=d[t];if(void 0!==i)return w(o=h[i],r="refVal["+i+"]");if(!n&&s.refs){i=s.refs[t];if(void 0!==i)return w(o=s.refVal[i],r=A(t,o))}var o,r=A(t),n=E.call(l,I,s,t);if(void 0!==(n=void 0===n&&(i=a&&a[t])?E.inlineRef(i,c.inlineRefs)?i:B.call(l,i,s,a,e):n))return o=n,i=d[i=t],h[i]=o,w(n,r);delete d[t]}function A(e,t){var n=h.length;return h[n]=t,"refVal"+(d[e]=n)}function w(e,t){return"object"==typeof e||"boolean"==typeof e?{code:t,schema:e,inline:!0}:{code:t,$async:e&&!!e.$async}}function S(e){var t=n[e];return void 0===t&&(t=n[e]=u.length,u[t]=e),"pattern"+t}function x(e){switch(typeof e){case"boolean":case"number":return""+e;case"string":return T.toQuotedString(e);case"object":var t,n;return null===e?"null":(t=_(e),void 0===(n=i[t])&&(n=i[t]=g.length,g[n]=e),"default"+n)}}function k(e,t,n,i){if(!1!==l._opts.validateSchema){var o=e.definition.dependencies;if(o&&!o.every(function(e){return Object.prototype.hasOwnProperty.call(n,e)}))throw new Error("parent schema must have all required keywords: "+o.join(","));o=e.definition.validateSchema;if(o)if(!o(t)){o="keyword schema is invalid: "+l.errorsText(o.errors);if("log"!=l._opts.validateSchema)throw new Error(o);l.logger.error(o)}}var r,o=e.definition.compile,s=e.definition.inline,a=e.definition.macro;if(o)r=o.call(l,t,n,i);else if(a)r=a.call(l,t,n,i),!1!==c.validateSchema&&l.validateSchema(r,!0);else if(s)r=s.call(l,i,e.keyword,t,n);else if(!(r=e.definition.validate))return;if(void 0===r)throw new Error('custom keyword "'+e.keyword+'"failed to compile');o=p.length;return{code:"customRule"+o,validate:p[o]=r}}}function W(e,t,n){for(var i=0;i<this._compilations.length;i++){var o=this._compilations[i];if(o.schema==e&&o.root==t&&o.baseId==n)return i}return-1}function P(e,t){return"var pattern"+e+" = new RegExp("+T.toQuotedString(t[e])+");"}function H(e){return"var default"+e+" = defaults["+e+"];"}function G(e,t){return void 0===t[e]?"":"var refVal"+e+" = refVal["+e+"];"}function F(e){return"var customRule"+e+" = customRules["+e+"];"}function O(e,t){if(!e.length)return"";for(var n="",i=0;i<e.length;i++)n+=t(i,e);return n}e.exports=B},3969:function(e,t,n){"use strict";var g=n(7533),p=n(2303),m=n(3724),a=n(4293),i=n(500);function l(e,t,n){var i,o,r,s=this._refs[n];if("string"==typeof s){if(!this._refs[s])return l.call(this,e,t,s);s=this._refs[s]}return(s=s||this._schemas[n])instanceof a?u(s.schema,this._opts.inlineRefs)?s.schema:s.validate||this._compile(s):((s=c.call(this,t,n))&&(i=s.schema,t=s.root,r=s.baseId),i instanceof a?o=i.validate||e.call(this,i.schema,t,void 0,r):void 0!==i&&(o=u(i,this._opts.inlineRefs)?i:e.call(this,i,t,void 0,r)),o)}function c(e,t){var n=g.parse(t),i=C(n),o=f(this._getId(e.schema));if(0===Object.keys(e.schema).length||i!==o){var i=y(i),r=this._refs[i];if("string"==typeof r)return function(e,t,n){t=c.call(this,e,t);{var i,o;if(t)return i=t.schema,o=t.baseId,e=t.root,(t=this._getId(i))&&(o=v(o,t)),s.call(this,n,o,i,e)}}.call(this,e,r,n);if(r instanceof a)r.validate||this._compile(r);else{if(!((r=this._schemas[i])instanceof a))return;if(r.validate||this._compile(r),i==y(t))return{schema:r,root:e,baseId:o}}if(!(e=r).schema)return;o=f(this._getId(e.schema))}return s.call(this,n,o,e.schema,e)}(e.exports=l).normalizeId=y,l.fullPath=f,l.url=v,l.ids=function(e){var t=y(this._getId(e)),c={"":t},h={"":f(t,!1)},d={},u=this;return i(e,{allKeys:!0},function(e,t,n,i,o,r,s){if(""!==t){var a=u._getId(e),l=c[i],i=h[i]+"/"+o;if(void 0!==s&&(i+="/"+("number"==typeof s?s:m.escapeFragment(s))),"string"==typeof a){a=l=y(l?g.resolve(l,a):a),o=u._refs[a];if((o="string"==typeof o?u._refs[o]:o)&&o.schema){if(!p(e,o.schema))throw new Error('id "'+a+'" resolves to more than one schema')}else if(a!=y(i))if("#"==a[0]){if(d[a]&&!p(e,d[a]))throw new Error('id "'+a+'" resolves to more than one schema');d[a]=e}else u._refs[a]=i}c[t]=l,h[t]=i}}),d},l.inlineRef=u,l.schema=c;var h=m.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function s(e,t,n,i){if(e.fragment=e.fragment||"","/"==e.fragment.slice(0,1)){for(var o=e.fragment.split("/"),r=1;r<o.length;r++){var s=o[r];if(s){if(void 0===(n=n[s=m.unescapeFragment(s)]))break;h[s]||((s=this._getId(n))&&(t=v(t,s)),n.$ref&&(s=v(t,n.$ref),s=c.call(this,i,s))&&(n=s.schema,i=s.root,t=s.baseId))}}return void 0!==n&&n!==i.schema?{schema:n,root:i,baseId:t}:void 0}}var d=m.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function u(e,t){return!1!==t&&(void 0===t||!0===t?function e(t){var n;if(Array.isArray(t)){for(var i=0;i<t.length;i++)if("object"==typeof(n=t[i])&&!e(n))return!1}else for(var o in t){if("$ref"==o)return!1;if("object"==typeof(n=t[o])&&!e(n))return!1}return!0}(e):t?function e(t){var n,i=0;if(Array.isArray(t)){for(var o=0;o<t.length;o++)if("object"==typeof(n=t[o])&&(i+=e(n)),i==1/0)return 1/0}else for(var r in t){if("$ref"==r)return 1/0;if(d[r])i++;else if("object"==typeof(n=t[r])&&(i+=e(n)+1),i==1/0)return 1/0}return i}(e)<=t:void 0)}function f(e,t){return!1!==t&&(e=y(e)),C(g.parse(e))}function C(e){return g.serialize(e).split("#")[0]+"#"}var o=/#\/?$/;function y(e){return e?e.replace(o,""):""}function v(e,t){return t=y(t),g.resolve(e,t)}},742:function(e,t,n){"use strict";var r=n(9646),s=n(3724).toHash;e.exports=function(){var i=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],o=["type","$comment"];return i.all=s(o),i.types=s(["number","integer","string","array","object","boolean","null"]),i.forEach(function(e){e.rules=e.rules.map(function(e){var t,n;return"object"==typeof e&&(n=e[t=Object.keys(e)[0]],e=t,n.forEach(function(e){o.push(e),i.all[e]=!0})),o.push(e),i.all[e]={keyword:e,code:r[e],implements:n}}),i.all.$comment={keyword:"$comment",code:r.$comment},e.type&&(i.types[e.type]=e)}),i.keywords=s(o.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),i.custom={},i}},4293:function(e,t,n){"use strict";var i=n(3724);e.exports=function(e){i.copy(e,this)}},6887:function(e){"use strict";e.exports=function(e){for(var t,n=0,i=e.length,o=0;o<i;)n++,55296<=(t=e.charCodeAt(o++))&&t<=56319&&o<i&&56320==(64512&e.charCodeAt(o))&&o++;return n}},3724:function(e,t,n){"use strict";function r(e,t,n,i){var o=i?" !== ":" === ",r=i?" || ":" && ",s=i?"!":"",a=i?"":"!";switch(e){case"null":return t+o+"null";case"array":return s+"Array.isArray("+t+")";case"object":return"("+s+t+r+"typeof "+t+o+'"object"'+r+a+"Array.isArray("+t+"))";case"integer":return"(typeof "+t+o+'"number"'+r+a+"("+t+" % 1)"+r+t+o+t+(n?r+s+"isFinite("+t+")":"")+")";case"number":return"(typeof "+t+o+'"'+e+'"'+(n?r+s+"isFinite("+t+")":"")+")";default:return"typeof "+t+o+'"'+e+'"'}}e.exports={copy:function(e,t){for(var n in t=t||{},e)t[n]=e[n];return t},checkDataType:r,checkDataTypes:function(e,t,n){{if(1===e.length)return r(e[0],t,n,!0);var i,o="",e=a(e);for(i in e.array&&e.object&&(o=e.null?"(":"(!"+t+" || ",o+="typeof "+t+' !== "object")',delete e.null,delete e.array,delete e.object),e.number&&delete e.integer,e)o+=(o?" && ":"")+r(i,t,n,!0);return o}},coerceToTypes:function(e,t){{if(!Array.isArray(t))return s[t]?[t]:"array"===e&&"array"===t?["array"]:void 0;for(var n=[],i=0;i<t.length;i++){var o=t[i];(s[o]||"array"===e&&"array"===o)&&(n[n.length]=o)}return n.length?n:void 0}},toHash:a,getProperty:h,escapeQuotes:l,equal:n(2303),ucs2length:n(6887),varOccurences:function(e,t){t+="[^0-9]";e=e.match(new RegExp(t,"g"));return e?e.length:0},varReplace:function(e,t,n){return t+="([^0-9])",n=n.replace(/\$/g,"$$$$"),e.replace(new RegExp(t,"g"),n+"$1")},schemaHasRules:function(e,t){if("boolean"==typeof e)return!e;for(var n in e)if(t[n])return!0},schemaHasRulesExcept:function(e,t,n){if("boolean"==typeof e)return!e&&"not"!=n;for(var i in e)if(i!=n&&t[i])return!0},schemaUnknownRules:function(e,t){if(
"boolean"!=typeof e)for(var n in e)if(!t[n])return n},toQuotedString:c,getPathExpr:function(e,t,n,i){return g(e,n?"'/' + "+t+(i?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):i?"'[' + "+t+" + ']'":"'[\\'' + "+t+" + '\\']'")},getPath:function(e,t,n){n=c(n?"/"+p(t):h(t));return g(e,n)},getData:function(e,t,n){var i,o,r;if(""===e)return"rootData";if("/"==e[0]){if(!d.test(e))throw new Error("Invalid JSON-pointer: "+e);i=e,o="rootData"}else{if(!(r=e.match(u)))throw new Error("Invalid JSON-pointer: "+e);if(e=+r[1],"#"==(i=r[2])){if(t<=e)throw new Error("Cannot access property/index "+e+" levels up, current level is "+t);return n[t-e]}if(t<e)throw new Error("Cannot access data "+e+" levels up, current level is "+t);if(o="data"+(t-e||""),!i)return o}for(var s=o,a=i.split("/"),l=0;l<a.length;l++){var c=a[l];c&&(o+=h(m(c)),s+=" && "+o)}return s},unescapeFragment:function(e){return m(decodeURIComponent(e))},unescapeJsonPointer:m,escapeFragment:function(e){return encodeURIComponent(p(e))},escapeJsonPointer:p};var s=a(["string","number","integer","boolean","null"]);function a(e){for(var t={},n=0;n<e.length;n++)t[e[n]]=!0;return t}var i=/^[a-z$_][a-z$_0-9]*$/i,o=/'|\\/g;function h(e){return"number"==typeof e?"["+e+"]":i.test(e)?"."+e:"['"+l(e)+"']"}function l(e){return e.replace(o,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function c(e){return"'"+l(e)+"'"}var d=/^\/(?:[^~]|~0|~1)*$/,u=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function g(e,t){return'""'==e?t:(e+" + "+t).replace(/([^\\])' \+ '/g,"$1")}function p(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}function m(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}},9394:function(e){"use strict";var l=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];e.exports=function(e,t){for(var n=0;n<t.length;n++){e=JSON.parse(JSON.stringify(e));for(var i=t[n].split("/"),o=e,r=1;r<i.length;r++)o=o[i[r]];for(r=0;r<l.length;r++){var s=l[r],a=o[s];a&&(o[s]={anyOf:[a,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]})}}return e}},5868:function(e,t,n){"use strict";n=n(6680);e.exports={$id:"https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:n.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:n.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},1796:function(e){"use strict";e.exports=function(e,t,n){var i,o,r,s,a,l=" ",c=e.level,h=e.dataLevel,d=e.schema[t],u=e.schemaPath+e.util.getProperty(t),g=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,m="data"+(h||""),f=e.opts.$data&&d&&d.$data,C=f?(l+=" var schema"+c+" = "+e.util.getData(d.$data,h,e.dataPathArr)+"; ","schema"+c):d,y="maximum"==t,v=y?"exclusiveMaximum":"exclusiveMinimum",I=e.schema[v],b=e.opts.$data&&I&&I.$data,A=y?"<":">",w=y?">":"<",S=void 0;if(!f&&"number"!=typeof d&&void 0!==d)throw new Error(t+" must be number");if(!b&&void 0!==I&&"number"!=typeof I&&"boolean"!=typeof I)throw new Error(v+" must be number or boolean");b?(h=e.util.getData(I.$data,h,e.dataPathArr),r="exclIsNumber"+c,s="' + "+(a="op"+c)+" + '",S=v,(x=x||[]).push(l=l+(" var schemaExcl"+c+" = "+h+"; ")+(" var "+(i="exclusive"+c)+"; var "+(o="exclType"+c)+" = typeof "+(h="schemaExcl"+c)+"; if ("+o+" != 'boolean' && "+o+" != 'undefined' && "+o+" != 'number') { ")),l="",!1!==e.createErrors?(l+=" { keyword: '"+(S||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: {} ",!1!==e.opts.messages&&(l+=" , message: '"+v+" should be boolean' "),e.opts.verbose&&(l+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+m+" "),l+=" } "):l+=" {} ",k=l,l=x.pop(),!e.compositeRule&&p?e.async?l+=" throw new ValidationError(["+k+"]); ":l+=" validate.errors = ["+k+"]; return false; ":l+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l+=" } else if ( ",f&&(l+=" ("+C+" !== undefined && typeof "+C+" != 'number') || "),l+=" "+o+" == 'number' ? ( ("+i+" = "+C+" === undefined || "+h+" "+A+"= "+C+") ? "+m+" "+w+"= "+h+" : "+m+" "+w+" "+C+" ) : ( ("+i+" = "+h+" === true) ? "+m+" "+w+"= "+C+" : "+m+" "+w+" "+C+" ) || "+m+" !== "+m+") { var op"+c+" = "+i+" ? '"+A+"' : '"+A+"='; ",void 0===d&&(g=e.errSchemaPath+"/"+(S=v),C=h,f=b)):(s=A,(r="number"==typeof I)&&f?(a="'"+s+"'",l+=" if ( ",f&&(l+=" ("+C+" !== undefined && typeof "+C+" != 'number') || "),l+=" ( "+C+" === undefined || "+I+" "+A+"= "+C+" ? "+m+" "+w+"= "+I+" : "+m+" "+w+" "+C+" ) || "+m+" !== "+m+") { "):(r&&void 0===d?(i=!0,g=e.errSchemaPath+"/"+(S=v),C=I,w+="="):(r&&(C=Math[y?"min":"max"](I,d)),I===(!r||C)?(i=!0,g=e.errSchemaPath+"/"+(S=v),w+="="):(i=!1,s+="=")),a="'"+s+"'",l+=" if ( ",f&&(l+=" ("+C+" !== undefined && typeof "+C+" != 'number') || "),l+=" "+m+" "+w+" "+C+" || "+m+" !== "+m+") { ")),S=S||t;(x=x||[]).push(l),l="",!1!==e.createErrors?(l+=" { keyword: '"+(S||"_limit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { comparison: "+a+", limit: "+C+", exclusive: "+i+" } ",!1!==e.opts.messages&&(l=l+" , message: 'should be "+s+" "+(f?"' + "+C:C+"'")),e.opts.verbose&&(l=(l+=" , schema:  ")+(f?"validate.schema"+u:""+d)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+m+" "),l+=" } "):l+=" {} ";var x,k=l;return l=x.pop(),!e.compositeRule&&p?e.async?l+=" throw new ValidationError(["+k+"]); ":l+=" validate.errors = ["+k+"]; return false; ":l+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l+=" } ",p&&(l+=" else { "),l}},2407:function(e){"use strict";e.exports=function(e,t,n){var i,o=" ",r=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data,s=u?(o+=" var schema"+r+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+r):a;if(u||"number"==typeof a)return o+="if ( ",u&&(o+=" ("+s+" !== undefined && typeof "+s+" != 'number') || "),(r=[]).push(o+=" "+d+".length "+("maxItems"==(i=t)?">":"<")+" "+s+") { "),o="",!1!==e.createErrors?(o+=" { keyword: '"+(i||"_limitItems")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { limit: "+s+" } ",!1!==e.opts.messages&&(o=(o=(o+=" , message: 'should NOT have ")+("maxItems"==t?"more":"fewer")+" than ")+(u?"' + "+s+" + '":""+a)+" items' "),e.opts.verbose&&(o=(o+=" , schema:  ")+(u?"validate.schema"+l:""+a)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),o+=" } "):o+=" {} ",i=o,o=r.pop(),!e.compositeRule&&h?e.async?o+=" throw new ValidationError(["+i+"]); ":o+=" validate.errors = ["+i+"]; return false; ":o+=" var err = "+i+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+="} ",h&&(o+=" else { "),o;throw new Error(t+" must be number")}},1250:function(e){"use strict";e.exports=function(e,t,n){var i,o=" ",r=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data,s=u?(o+=" var schema"+r+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+r):a;if(u||"number"==typeof a)return o+="if ( ",u&&(o+=" ("+s+" !== undefined && typeof "+s+" != 'number') || "),!1===e.opts.unicode?o+=" "+d+".length ":o+=" ucs2length("+d+") ",(r=[]).push(o+=" "+("maxLength"==(i=t)?">":"<")+" "+s+") { "),o="",!1!==e.createErrors?(o+=" { keyword: '"+(i||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { limit: "+s+" } ",!1!==e.opts.messages&&(o=(o=(o+=" , message: 'should NOT be ")+("maxLength"==t?"longer":"shorter")+" than ")+(u?"' + "+s+" + '":""+a)+" characters' "),e.opts.verbose&&(o=(o+=" , schema:  ")+(u?"validate.schema"+l:""+a)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),o+=" } "):o+=" {} ",i=o,o=r.pop(),!e.compositeRule&&h?e.async?o+=" throw new ValidationError(["+i+"]); ":o+=" validate.errors = ["+i+"]; return false; ":o+=" var err = "+i+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+="} ",h&&(o+=" else { "),o;throw new Error(t+" must be number")}},2596:function(e){"use strict";e.exports=function(e,t,n){var i,o=" ",r=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data,s=u?(o+=" var schema"+r+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+r):a;if(u||"number"==typeof a)return o+="if ( ",u&&(o+=" ("+s+" !== undefined && typeof "+s+" != 'number') || "),(r=[]).push(o+=" Object.keys("+d+").length "+("maxProperties"==(i=t)?">":"<")+" "+s+") { "),o="",!1!==e.createErrors?(o+=" { keyword: '"+(i||"_limitProperties")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { limit: "+s+" } ",!1!==e.opts.messages&&(o=(o=(o+=" , message: 'should NOT have ")+("maxProperties"==t?"more":"fewer")+" than ")+(u?"' + "+s+" + '":""+a)+" properties' "),e.opts.verbose&&(o=(o+=" , schema:  ")+(u?"validate.schema"+l:""+a)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),o+=" } "):o+=" {} ",i=o,o=r.pop(),!e.compositeRule&&h?e.async?o+=" throw new ValidationError(["+i+"]); ":o+=" validate.errors = ["+i+"]; return false; ":o+=" var err = "+i+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+="} ",h&&(o+=" else { "),o;throw new Error(t+" must be number")}},9486:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.schema[t],r=e.schemaPath+e.util.getProperty(t),s=e.errSchemaPath+"/"+t,a=!e.opts.allErrors,l=e.util.copy(e),c="",h=(l.level++,"valid"+l.level),d=l.baseId,u=!0,g=o;if(g)for(var p,m=-1,f=g.length-1;m<f;)p=g[m+=1],(e.opts.strictKeywords?"object"==typeof p&&0<Object.keys(p).length||!1===p:e.util.schemaHasRules(p,e.RULES.all))&&(u=!1,l.schema=p,l.schemaPath=r+"["+m+"]",l.errSchemaPath=s+"/"+m,i+="  "+e.validate(l)+" ",l.baseId=d,a)&&(i+=" if ("+h+") { ",c+="}");return a&&(i+=u?" if (true) { ":" "+c.slice(0,-1)+" "),i}},5347:function(e){"use strict";e.exports=function(t,e,n){var i=" ",o=t.level,r=t.dataLevel,s=t.schema[e],a=t.schemaPath+t.util.getProperty(e),l=t.errSchemaPath+"/"+e,e=!t.opts.allErrors,r="data"+(r||""),c="valid"+o,o="errs__"+o,h=t.util.copy(t),d="",u=(h.level++,"valid"+h.level);if(s.every(function(e){return t.opts.strictKeywords?"object"==typeof e&&0<Object.keys(e).length||!1===e:t.util.schemaHasRules(e,t.RULES.all)})){var g=h.baseId,p=(i+=" var "+o+" = errors; var "+c+" = false;  ",t.compositeRule),m=(t.compositeRule=h.compositeRule=!0,s);if(m)for(var f,C=-1,y=m.length-1;C<y;)f=m[C+=1],h.schema=f,h.schemaPath=a+"["+C+"]",h.errSchemaPath=l+"/"+C,i+="  "+t.validate(h)+" ",h.baseId=g,i+=" "+c+" = "+c+" || "+u+"; if (!"+c+") { ",d+="}";t.compositeRule=h.compositeRule=p,i+=" "+d+" if (!"+c+") {   var err =   ",!1!==t.createErrors?(i+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+t.errorPath+" , schemaPath: "+t.util.toQuotedString(l)+" , params: {} ",!1!==t.opts.messages&&(i+=" , message: 'should match some schema in anyOf' "),t.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+t.schemaPath+" , data: "+r+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!t.compositeRule&&e&&(t.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+=" } else {  errors = "+o+"; if (vErrors !== null) { if ("+o+") vErrors.length = "+o+"; else vErrors = null; } ",t.opts.allErrors&&(i+=" } ")}else e&&(i+=" if (true) { ");return i}},923:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.schema[t],t=e.errSchemaPath+"/"+t,o=(e.opts.allErrors,e.util.toQuotedString(o));return!0===e.opts.$comment?i+=" console.log("+o+");":"function"==typeof e.opts.$comment&&(i+=" self._opts.$comment("+o+", "+e.util.toQuotedString(t)+", validate.root.schema);"),i}},2617:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+o,d=e.opts.$data&&s&&s.$data,s=(d&&(i+=" var schema"+o+" = "+e.util.getData(s.$data,r,e.dataPathArr)+"; "),d||(i+=" var schema"+o+" = validate.schema"+a+";"),[]),r=(s.push(i+="var "+h+" = equal("+c+", schema"+o+"); if (!"+h+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'const' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { allowedValue: schema"+o+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to constant' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i),i=s.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+r+"]); ":i+=" validate.errors = ["+r+"]; return false; ":i+=" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",l&&(i+=" else { "),i}},2119:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,r="data"+(r||""),c="valid"+o,h="errs__"+o,d=e.util.copy(e),u=(d.level++,"valid"+d.level),o="i"+o,g=d.dataLevel=e.dataLevel+1,p="data"+g,m=e.baseId,f=e.opts.strictKeywords?"object"==typeof s&&0<Object.keys(s).length||!1===s:e.util.schemaHasRules(s,e.RULES.all),o=(i+="var "+h+" = errors;var "+c+";",f?(c=e.compositeRule,e.compositeRule=d.compositeRule=!0,d.schema=s,d.schemaPath=a,d.errSchemaPath=t,i+=" var "+u+" = false; for (var "+o+" = 0; "+o+" < "+r+".length; "+o+"++) { ",d.errorPath=e.util.getPathExpr(e.errorPath,o,e.opts.jsonPointers,!0),s=r+"["+o+"]",d.dataPathArr[g]=o,g=e.validate(d),d.baseId=m,e.util.varOccurences(g,p)<2?i+=" "+e.util.varReplace(g,p,s)+" ":i+=" var "+p+" = "+s+"; "+g+" ",i+=" if ("+u+") break; }  ",e.compositeRule=d.compositeRule=c,i+="  if (!"+u+") {"):i+=" if ("+r+".length == 0) {",[]),m=(o.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should contain a valid item' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+r+" "),i+=" } "):i+=" {} ",i),i=o.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+m+"]); ":i+=" validate.errors = ["+m+"]; return false; ":i+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { ",f&&(i+="  errors = "+h+"; if (vErrors !== null) { if ("+h+") vErrors.length = "+h+"; else vErrors = null; } "),e.opts.allErrors&&(i+=" } "),i}},1793:function(e){"use strict";e.exports=function(e,t,n){var i,o,r,s=" ",a=e.level,l=e.dataLevel,c=e.schema[t],h=e.schemaPath+e.util.getProperty(t),d=e.errSchemaPath+"/"+t,u=!e.opts.allErrors,g="data"+(l||""),p="valid"+a,m="errs__"+a,f=e.opts.$data&&c&&c.$data,C=f?(s+=" var schema"+a+" = "+e.util.getData(c.$data,l,e.dataPathArr)+"; ","schema"+a):c,y="definition"+a,v=this.definition,I="";if(f&&v.$data){var b="keywordValidate"+a,A=v.validateSchema;s+=" var "+y+" = RULES.custom['"+t+"'].definition; var "+b+" = "+y+".validate;"}else{if(!(k=e.useCustomRule(this,c,e.schema,e)))return;C="validate.schema"+h,b=k.code,i=v.compile,o=v.inline,r=v.macro}var w,S,x,k,E,t=b+".errors",c="i"+a,T="ruleErr"+a,R=v.async;if(R&&!e.async)throw new Error("async keyword in sync schema");return o||r||(s+=t+" = null;"),s+="var "+m+" = errors;var "+p+";",f&&v.$data&&(I+="}",s+=" if ("+C+" === undefined) { "+p+" = true; } else { ",A)&&(I+="}",s+=" "+p+" = "+y+".validateSchema("+C+"); if ("+p+") { "),o?v.statements?s+=" "+k.validate+" ":s+=" "+p+" = "+k.validate+"; ":r?(I="",(f=e.util.copy(e)).level++,w="valid"+f.level,f.schema=k.validate,f.schemaPath="",A=e.compositeRule,e.compositeRule=f.compositeRule=!0,y=e.validate(f).replace(/validate\.schema/g,b),e.compositeRule=f.compositeRule=A,s+=" "+y):((E=E||[]).push(s),s="",s+="  "+b+".call( ",e.opts.passContext?s+="this":s+="self",i||!1===v.schema?s+=" , "+g+" ":s+=" , "+C+" , "+g+" , validate.schema"+e.schemaPath+" ",s+=" , (dataPath || '')",'""'!=e.errorPath&&(s+=" + "+e.errorPath),k=s+=" , "+(S=l?"data"+(l-1||""):"parentData")+" , "+(x=l?e.dataPathArr[l]:"parentDataProperty")+" , rootData )  ",s=E.pop(),!1===v.errors?(s+=" "+p+" = ",R&&(s+="await "),s+=k+"; "):s+=R?" var "+(t="customErrors"+a)+" = null; try { "+p+" = await "+k+"; } catch (e) { "+p+" = false; if (e instanceof ValidationError) "+t+" = e.errors; else throw e; } ":" "+t+" = null; "+p+" = "+k+"; "),v.modifying&&(s+=" if ("+S+") "+g+" = "+S+"["+x+"];"),s+=""+I,v.valid?u&&(s+=" if (true) { "):(s+=" if ( ",void 0===v.valid?s=s+" !"+(r?""+w:p):s+=" "+!v.valid+" ",f=this.keyword,(E=E||[]).push(s+=") { "),(E=E||[]).push(s=""),s="",!1!==e.createErrors?(s+=" { keyword: '"+(f||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(d)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(s+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(s+=" , schema: validate.schema"+h+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+g+" "),s+=" } "):s+=" {} ",A=s,s=E.pop(),!e.compositeRule&&u?e.async?s+=" throw new ValidationError(["+A+"]); ":s+=" validate.errors = ["+A+"]; return false; ":s+=" var err = "+A+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",y=s,s=E.pop(),o?v.errors?"full"!=v.errors&&(s+="  for (var "+c+"="+m+"; "+c+"<errors; "+c+"++) { var "+T+" = vErrors["+c+"]; if ("+T+".dataPath === undefined) "+T+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+T+".schemaPath === undefined) { "+T+'.schemaPath = "'+d+'"; } ',e.opts.verbose&&(s+=" "+T+".schema = "+C+"; "+T+".data = "+g+"; "),s+=" } "):!1===v.errors?s+=" "+y+" ":(s+=" if ("+m+" == errors) { "+y+" } else {  for (var "+c+"="+m+"; "+c+"<errors; "+c+"++) { var "+T+" = vErrors["+c+"]; if ("+T+".dataPath === undefined) "+T+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+T+".schemaPath === undefined) { "+T+'.schemaPath = "'+d+'"; } ',e.opts.verbose&&(s+=" "+T+".schema = "+C+"; "+T+".data = "+g+"; "),s+=" } } "):r?(s+="   var err =   ",!1!==e.createErrors?(s+=" { keyword: '"+(f||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(d)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(s+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(s+=" , schema: validate.schema"+h+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+g+" "),s+=" } "):s+=" {} ",s+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&u&&(e.async?s+=" throw new ValidationError(vErrors); ":s+=" validate.errors = vErrors; return false; ")):!1===v.errors?s+=" "+y+" ":(s+=" if (Array.isArray("+t+")) { if (vErrors === null) vErrors = "+t+"; else vErrors = vErrors.concat("+t+"); errors = vErrors.length;  for (var "+c+"="+m+"; "+c+"<errors; "+c+"++) { var "+T+" = vErrors["+c+"]; if ("+T+".dataPath === undefined) "+T+".dataPath = (dataPath || '') + "+e.errorPath+";  "+T+'.schemaPath = "'+d+'";  ',e.opts.verbose&&(s+=" "+T+".schema = "+C+"; "+T+".data = "+g+"; "),s+=" } } else { "+y+" } "),s+=" } ",u&&(s+=" else { ")),s}},9115:function(e){"use strict";e.exports=function(e,t,n){var i,o=" ",r=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),t="errs__"+r,u=e.util.copy(e),g="",p=(u.level++,"valid"+u.level),m={},f={},C=e.opts.ownProperties;for($ in a)"__proto__"!=$&&(N=a[$],(i=Array.isArray(N)?f:m)[$]=N);var y=e.errorPath;for($ in o=o+("var "+t+" = errors;")+("var missing"+r+";"),f)if((i=f[$]).length){if(o+=" if ( "+d+e.util.getProperty($)+" !== undefined ",C&&(o+=" && Object.prototype.hasOwnProperty.call("+d+", '"+e.util.escapeQuotes($)+"') "),h){o+=" && ( ";var v=i;if(v)for(var I=-1,b=v.length-1;I<b;)k=v[I+=1],I&&(o+=" || "),o+=" ( ( "+(_=d+(R=e.util.getProperty(k)))+" === undefined ",C&&(o+=" || ! Object.prototype.hasOwnProperty.call("+d+", '"+e.util.escapeQuotes(k)+"') "),o+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?k:R)+") ) ";o+=")) {  ";var A="missing"+r,w="' + "+A+" + '",S=(e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(y,A,!0):y+" + "+A),S||[]),A=(S.push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { property: '"+e.util.escapeQuotes($)+"', missingProperty: '"+w+"', depsCount: "+i.length+", deps: '"+e.util.escapeQuotes(1==i.length?i[0]:i.join(", "))+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should have ",1==i.length?o+="property "+e.util.escapeQuotes(i[0]):o+="properties "+e.util.escapeQuotes(i.join(", ")),o+=" when property "+e.util.escapeQuotes($)+" is present' "),e.opts.verbose&&(o+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),o+=" } "):o+=" {} ",o),o=S.pop();!e.compositeRule&&h?e.async?o+=" throw new ValidationError(["+A+"]); ":o+=" validate.errors = ["+A+"]; return false; ":o+=" var err = "+A+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{o+=" ) { ";var x=i;if(x)for(var k,E=-1,T=x.length-1;E<T;){k=x[E+=1];var R=e.util.getProperty(k),w=e.util.escapeQuotes(k),_=d+R;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(y,k,e.opts.jsonPointers)),o+=" if ( "+_+" === undefined ",C&&(o+=" || ! Object.prototype.hasOwnProperty.call("+d+", '"+e.util.escapeQuotes(k)+"') "),o+=") {  var err =   ",!1!==e.createErrors?(o+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { property: '"+e.util.escapeQuotes($)+"', missingProperty: '"+w+"', depsCount: "+i.length+", deps: '"+e.util.escapeQuotes(1==i.length?i[0]:i.join(", "))+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should have ",1==i.length?o+="property "+e.util.escapeQuotes(i[0]):o+="properties "+e.util.escapeQuotes(i.join(", ")),o+=" when property "+e.util.escapeQuotes($)+" is present' "),e.opts.verbose&&(o+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}o+=" }   ",h&&(g+="}",o+=" else { ")}e.errorPath=y;var $,L=u.baseId;for($ in m){var N=m[$];(e.opts.strictKeywords?"object"==typeof N&&0<Object.keys(N).length||!1===N:e.util.schemaHasRules(N,e.RULES.all))&&(o+=" "+p+" = true; if ( "+d+e.util.getProperty($)+" !== undefined ",C&&(o+=" && Object.prototype.hasOwnProperty.call("+d+", '"+e.util.escapeQuotes($)+"') "),o+=") { ",u.schema=N,u.schemaPath=l+e.util.getProperty($),u.errSchemaPath=c+"/"+e.util.escapeFragment($),o+="  "+e.validate(u)+" ",u.baseId=L,o+=" }  ",h)&&(o+=" if ("+p+") { ",g+="}")}return h&&(o+="   "+g+" if ("+t+" == errors) {"),o}},9317:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+o,d=e.opts.$data&&s&&s.$data,s=(d&&(i+=" var schema"+o+" = "+e.util.getData(s.$data,r,e.dataPathArr)+"; "),"i"+o),r="schema"+o,r=(d||(i+=" var "+r+" = validate.schema"+a+";"),i+="var "+h+";",d&&(i+=" if (schema"+o+" === undefined) "+h+" = true; else if (!Array.isArray(schema"+o+")) "+h+" = false; else {"),i+=h+" = false;for (var "+s+"=0; "+s+"<"+r+".length; "+s+"++) if (equal("+c+", "+r+"["+s+"])) { "+h+" = true; break; }",d&&(i+="  }  "),[]),s=(r.push(i+=" if (!"+h+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { allowedValues: schema"+o+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i),i=r.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+s+"]); ":i+=" validate.errors = ["+s+"]; return false; ":i+=" var err = "+s+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",l&&(i+=" else { "),i}},8327:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||"");if(!1===e.opts.format)l&&(i+=" if (true) { ");else{var h,d=e.opts.$data&&s&&s.$data,r=d?(i+=" var schema"+o+" = "+e.util.getData(s.$data,r,e.dataPathArr)+"; ","schema"+o):s,u=e.opts.unknownFormats,g=Array.isArray(u);if(d)i+=" var "+(h="format"+o)+" = formats["+r+"]; var "+(p="isObject"+o)+" = typeof "+h+" == 'object' && !("+h+" instanceof RegExp) && "+h+".validate; var "+(f="formatType"+o)+" = "+p+" && "+h+".type || 'string'; if ("+p+") { ",e.async&&(i+=" var async"+o+" = "+h+".async; "),i+=" "+h+" = "+h+".validate; } if (  ",d&&(i+=" ("+r+" !== undefined && typeof "+r+" != 'string') || "),i+=" (","ignore"!=u&&(i+=" ("+r+" && !"+h+" ",g&&(i+=" && self._opts.unknownFormats.indexOf("+r+") == -1 "),i+=") || "),i+=" ("+h+" && "+f+" == '"+n+"' && !(typeof "+h+" == 'function' ? ",e.async?i+=" (async"+o+" ? await "+h+"("+c+") : "+h+"("+c+")) ":i+=" "+h+"("+c+") ",i+=" : "+h+".test("+c+"))))) {";else{if(!(h=e.formats[s])){if("ignore"==u)return e.logger.warn('unknown format "'+s+'" ignored in schema at path "'+e.errSchemaPath+'"'),l&&(i+=" if (true) { "),i;if(g&&0<=u.indexOf(s))return l&&(i+=" if (true) { "),i;throw new Error('unknown format "'+s+'" is used in schema at path "'+e.errSchemaPath+'"')}var p,m,f=(p="object"==typeof h&&!(h instanceof RegExp)&&h.validate)&&h.type||"string";if(p&&(m=!0===h.async,h=h.validate),f!=n)return l&&(i+=" if (true) { "),i;if(m){if(!e.async)throw new Error("async format in sync schema");i+=" if (!(await "+(C="formats"+e.util.getProperty(s)+".validate")+"("+c+"))) { "}else{i+=" if (! ";var C="formats"+e.util.getProperty(s);p&&(C+=".validate"),i=i+("function"==typeof h?" "+C+"("+c+") ":" "+C+".test("+c+") ")+") { "}}o=[],g=(o.push(i),i="",!1!==e.createErrors?(i=(i+=" { keyword: 'format' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { format:  ")+(d?""+r:""+e.util.toQuotedString(s))+"  } ",!1!==e.opts.messages&&(i=(i+=" , message: 'should match format \"")+(d?"' + "+r+" + '":""+e.util.escapeQuotes(s))+"\"' "),e.opts.verbose&&(i=(i=(i+=" , schema:  ")+(d?"validate.schema"+a:""+e.util.toQuotedString(s)))+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i),i=o.pop();!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+g+"]); ":i+=" validate.errors = ["+g+"]; return false; ":i+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } ",l&&(i+=" else { ")}return i}},5926:function(e){"use strict";e.exports=function(e,t,n){var i,o=" ",r=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,s="data"+(s||""),h="valid"+r,d="errs__"+r,u=e.util.copy(e),g=(u.level++,"valid"+u.level),p=e.schema.then,m=e.schema.else,p=void 0!==p&&(e.opts.strictKeywords?"object"==typeof p&&0<Object.keys(p).length||!1===p:e.util.schemaHasRules(p,e.RULES.all)),m=void 0!==m&&(e.opts.strictKeywords?"object"==typeof m&&0<Object.keys(m).length||!1===m:e.util.schemaHasRules(m,e.RULES.all)),f=u.baseId;return p||m?(u.createErrors=!1,u.schema=a,u.schemaPath=l,u.errSchemaPath=t,o+=" var "+d+" = errors; var "+h+" = true;  ",a=e.compositeRule,e.compositeRule=u.compositeRule=!0,o+="  "+e.validate(u)+" ",u.baseId=f,u.createErrors=!0,o+="  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; }  ",e.compositeRule=u.compositeRule=a,p?(o+=" if ("+g+") {  ",u.schema=e.schema.then,u.schemaPath=e.schemaPath+".then",u.errSchemaPath=e.errSchemaPath+"/then",o+="  "+e.validate(u)+" ",u.baseId=f,o+=" "+h+" = "+g+"; ",p&&m?o+=" var "+(i="ifClause"+r)+" = 'then'; ":i="'then'",o+=" } ",m&&(o+=" else { ")):o+=" if (!"+g+") { ",m&&(u.schema=e.schema.else,u.schemaPath=e.schemaPath+".else",u.errSchemaPath=e.errSchemaPath+"/else",o+="  "+e.validate(u)+" ",u.baseId=f,o+=" "+h+" = "+g+"; ",p&&m?o+=" var "+(i="ifClause"+r)+" = 'else'; ":i="'else'",o+=" } "),o+=" if (!"+h+") {   var err =   ",!1!==e.createErrors?(o+=" { keyword: 'if' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { failingKeyword: "+i+" } ",!1!==e.opts.messages&&(o+=" , message: 'should match \"' + "+i+" + '\" schema' "),e.opts.verbose&&(o+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+s+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&c&&(e.async?o+=" throw new ValidationError(vErrors); ":o+=" validate.errors = vErrors; return false; "),o+=" }   ",c&&(o+=" else { ")):c&&(o+=" if (true) { "),o}},9646:function(e,t,n){"use strict";e.exports={$ref:n(2331),allOf:n(9486),anyOf:n(5347),$comment:n(923),const:n(2617),contains:n(2119),dependencies:n(9115),enum:n(9317),format:n(8327),if:n(5926),items:n(392),maximum:n(1796),minimum:n(1796),maxItems:n(2407),minItems:n(2407),maxLength:n(1250),minLength:n(1250),maxProperties:n(2596),minProperties:n(2596),multipleOf:n(6039),not:n(7946),oneOf:n(9344),pattern:n(9737),properties:n(2537),propertyNames:n(2127),required:n(1204),uniqueItems:n(1985),validate:n(1869)}},392:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(r||""),t="valid"+o,r="errs__"+o,d=e.util.copy(e),u="",g=(d.level++,"valid"+d.level),o="i"+o,p=d.dataLevel=e.dataLevel+1,m="data"+p,f=e.baseId;if(i+="var "+r+" = errors;var "+t+";",Array.isArray(s)){var C,y,v=e.schema.additionalItems,I=(!1===v&&(i+=" "+t+" = "+h+".length <= "+s.length+"; ",C=l,l=e.errSchemaPath+"/additionalItems",(y=y||[]).push(i+="  if (!"+t+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { limit: "+s.length+" } ",!1!==e.opts.messages&&(i+=" , message: 'should NOT have more than "+s.length+" items' "),e.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),i+=" } "):i+=" {} ",t=i,i=y.pop(),!e.compositeRule&&c?e.async?i+=" throw new ValidationError(["+t+"]); ":i+=" validate.errors = ["+t+"]; return false; ":i+=" var err = "+t+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } ",l=C,c)&&(u+="}",i+=" else { "),s);if(I)for(var b=-1,A=I.length-1;b<A;){var w,S,x=I[b+=1];(e.opts.strictKeywords?"object"==typeof x&&0<Object.keys(x).length||!1===x:e.util.schemaHasRules(x,e.RULES.all))&&(i+=" "+g+" = true; if ("+h+".length > "+b+") { ",w=h+"["+b+"]",d.schema=x,d.schemaPath=a+"["+b+"]",d.errSchemaPath=l+"/"+b,d.errorPath=e.util.getPathExpr(e.errorPath,b,e.opts.jsonPointers,!0),d.dataPathArr[p]=b,S=e.validate(d),d.baseId=f,e.util.varOccurences(S,m)<2?i+=" "+e.util.varReplace(S,m,w)+" ":i+=" var "+m+" = "+w+"; "+S+" ",i+=" }  ",c)&&(i+=" if ("+g+") { ",u+="}")}"object"==typeof v&&(e.opts.strictKeywords?"object"==typeof v&&0<Object.keys(v).length||!1===v:e.util.schemaHasRules(v,e.RULES.all))&&(d.schema=v,d.schemaPath=e.schemaPath+".additionalItems",d.errSchemaPath=e.errSchemaPath+"/additionalItems",i+=" "+g+" = true; if ("+h+".length > "+s.length+") {  for (var "+o+" = "+s.length+"; "+o+" < "+h+".length; "+o+"++) { ",d.errorPath=e.util.getPathExpr(e.errorPath,o,e.opts.jsonPointers,!0),w=h+"["+o+"]",d.dataPathArr[p]=o,S=e.validate(d),d.baseId=f,e.util.varOccurences(S,m)<2?i+=" "+e.util.varReplace(S,m,w)+" ":i+=" var "+m+" = "+w+"; "+S+" ",c&&(i+=" if (!"+g+") break; "),i+=" } }  ",c)&&(i+=" if ("+g+") { ",u+="}")}else(e.opts.strictKeywords?"object"==typeof s&&0<Object.keys(s).length||!1===s:e.util.schemaHasRules(s,e.RULES.all))&&(d.schema=s,d.schemaPath=a,d.errSchemaPath=l,i+="  for (var "+o+" = 0; "+o+" < "+h+".length; "+o+"++) { ",d.errorPath=e.util.getPathExpr(e.errorPath,o,e.opts.jsonPointers,!0),w=h+"["+o+"]",d.dataPathArr[p]=o,S=e.validate(d),d.baseId=f,e.util.varOccurences(S,m)<2?i+=" "+e.util.varReplace(S,m,w)+" ":i+=" var "+m+" = "+w+"; "+S+" ",c&&(i+=" if (!"+g+") break; "),i+=" }");return c&&(i+=" "+u+" if ("+r+" == errors) {"),i}},6039:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(r||""),d=e.opts.$data&&s&&s.$data,r=d?(i+=" var schema"+o+" = "+e.util.getData(s.$data,r,e.dataPathArr)+"; ","schema"+o):s;if(!d&&"number"!=typeof s)throw new Error(t+" must be number");i+="var division"+o+";if (",d&&(i+=" "+r+" !== undefined && ( typeof "+r+" != 'number' || "),i+=" (division"+o+" = "+h+" / "+r+", ",e.opts.multipleOfPrecision?i+=" Math.abs(Math.round(division"+o+") - division"+o+") > 1e-"+e.opts.multipleOfPrecision+" ":i+=" division"+o+" !== parseInt(division"+o+") ",i+=" ) ",d&&(i+="  )  ");t=[],t.push(i+=" ) {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { multipleOf: "+r+" } ",!1!==e.opts.messages&&(i=i+" , message: 'should be multiple of "+(d?"' + "+r:r+"'")),e.opts.verbose&&(i=(i+=" , schema:  ")+(d?"validate.schema"+a:""+s)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),i+=" } "):i+=" {} ",o=i,i=t.pop();return!e.compositeRule&&c?e.async?i+=" throw new ValidationError(["+o+"]); ":i+=" validate.errors = ["+o+"]; return false; ":i+=" var err = "+o+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",c&&(i+=" else { "),i}},7946:function(e){"use strict";e.exports=function(e,t,n){var i,o,r=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,a="data"+(a||""),s="errs__"+s,d=e.util.copy(e),u=(d.level++,"valid"+d.level);return(e.opts.strictKeywords?"object"==typeof l&&0<Object.keys(l).length||!1===l:e.util.schemaHasRules(l,e.RULES.all))?(d.schema=l,d.schemaPath=c,d.errSchemaPath=t,r+=" var "+s+" = errors;  ",l=e.compositeRule,e.compositeRule=d.compositeRule=!0,d.createErrors=!1,d.opts.allErrors&&(o=d.opts.allErrors,d.opts.allErrors=!1),r+=" "+e.validate(d)+" ",d.createErrors=!0,o&&(d.opts.allErrors=o),e.compositeRule=d.compositeRule=l,(i=i||[]).push(r+=" if ("+u+") {   "),r="",!1!==e.createErrors?(r+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: {} ",!1!==e.opts.messages&&(r+=" , message: 'should NOT be valid' "),e.opts.verbose&&(r+=" , schema: validate.schema"+c+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),r+=" } "):r+=" {} ",o=r,r=i.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+o+"]); ":r+=" validate.errors = ["+o+"]; return false; ":r+=" var err = "+o+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+=" } else {  errors = "+s+"; if (vErrors !== null) { if ("+s+") vErrors.length = "+s+"; else vErrors = null; } ",e.opts.allErrors&&(r+=" } ")):(r+="  var err =   ",!1!==e.createErrors?(r+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: {} ",!1!==e.opts.messages&&(r+=" , message: 'should NOT be valid' "),e.opts.verbose&&(r+=" , schema: validate.schema"+c+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),r+=" } "):r+=" {} ",r+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",h&&(r+=" if (false) { ")),r}},9344:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,t=!e.opts.allErrors,r="data"+(r||""),c="valid"+o,h="errs__"+o,d=e.util.copy(e),u="",g=(d.level++,"valid"+d.level),p=d.baseId,m="prevValid"+o,f="passingSchemas"+o,o=(i+="var "+h+" = errors , "+m+" = false , "+c+" = false , "+f+" = null; ",e.compositeRule),C=(e.compositeRule=d.compositeRule=!0,s);if(C)for(var y,v=-1,I=C.length-1;v<I;)y=C[v+=1],(e.opts.strictKeywords?"object"==typeof y&&0<Object.keys(y).length||!1===y:e.util.schemaHasRules(y,e.RULES.all))?(d.schema=y,d.schemaPath=a+"["+v+"]",d.errSchemaPath=l+"/"+v,i+="  "+e.validate(d)+" ",d.baseId=p):i+=" var "+g+" = true; ",v&&(i+=" if ("+g+" && "+m+") { "+c+" = false; "+f+" = ["+f+", "+v+"]; } else { ",u+="}"),i+=" if ("+g+") { "+c+" = "+m+" = true; "+f+" = "+v+"; }";return e.compositeRule=d.compositeRule=o,i+=u+"if (!"+c+") {   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { passingSchemas: "+f+" } ",!1!==e.opts.messages&&(i+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+r+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&t&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+="} else {  errors = "+h+"; if (vErrors !== null) { if ("+h+") vErrors.length = "+h+"; else vErrors = null; }",e.opts.allErrors&&(i+=" } "),i}},9737:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h=e.opts.$data&&s&&s.$data,r=h?(i+=" var schema"+o+" = "+e.util.getData(s.$data,r,e.dataPathArr)+"; ","schema"+o):s,o=h?"(new RegExp("+r+"))":e.usePattern(s),d=(i+="if ( ",h&&(i+=" ("+r+" !== undefined && typeof "+r+" != 'string') || "),[]),o=(d.push(i+=" !"+o+".test("+c+") ) {   "),i="",!1!==e.createErrors?(i=(i+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { pattern:  ")+(h?""+r:""+e.util.toQuotedString(s))+"  } ",!1!==e.opts.messages&&(i=(i+=" , message: 'should match pattern \"")+(h?"' + "+r+" + '":""+e.util.escapeQuotes(s))+"\"' "),e.opts.verbose&&(i=(i=(i+=" , schema:  ")+(h?"validate.schema"+a:""+e.util.toQuotedString(s)))+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i),i=d.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+o+"]); ":i+=" validate.errors = ["+o+"]; return false; ":i+=" var err = "+o+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",l&&(i+=" else { "),i}},2537:function(e){"use strict";e.exports=function(e,t,W){var n,i=" ",o=e.level,r=e.dataLevel,P=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),t="errs__"+o,h=e.util.copy(e),d="",u=(h.level++,"valid"+h.level),g="key"+o,p="idx"+o,m=h.dataLevel=e.dataLevel+1,f="data"+m,C="dataProperties"+o,r=Object.keys(P||{}).filter(V),H=e.schema.patternProperties||{},y=Object.keys(H).filter(V),v=e.schema.additionalProperties,G=r.length||y.length,F=!1===v,O="object"==typeof v&&Object.keys(v).length,I=e.opts.removeAdditional,b=F||O||I,A=e.opts.ownProperties,w=e.baseId,S=e.schema.required;function V(e){return"__proto__"!==e}if(S&&(!e.opts.$data||!S.$data)&&S.length<e.opts.loopRequired&&(n=e.util.toHash(S)),i+="var "+t+" = errors;var "+u+" = true;",A&&(i+=" var "+C+" = undefined;"),b){if(i+=A?" "+C+" = "+C+" || Object.keys("+c+"); for (var "+p+"=0; "+p+"<"+C+".length; "+p+"++) { var "+g+" = "+C+"["+p+"]; ":" for (var "+g+" in "+c+") { ",G){if(i+=" var isAdditional"+o+" = !(false ",r.length)if(8<r.length)i+=" || validate.schema"+s+".hasOwnProperty("+g+") ";else{var Z=r;if(Z)for(var D=-1,j=Z.length-1;D<j;)x=Z[D+=1],i+=" || "+g+" == "+e.util.toQuotedString(x)+" "}if(y.length){var K=y;if(K)for(var z=-1,X=K.length-1;z<X;)N=K[z+=1],i+=" || "+e.usePattern(N)+".test("+g+") "}i+=" ); if (isAdditional"+o+") { "}"all"==I?i+=" delete "+c+"["+g+"]; ":(E=e.errorPath,S="' + "+g+" + '",e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers)),F?I?i+=" delete "+c+"["+g+"]; ":(T=a,a=e.errSchemaPath+"/additionalProperties",(_=_||[]).push(i+=" "+u+" = false; "),i="",!1!==e.createErrors?(i+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { additionalProperty: '"+S+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is an invalid additional property":i+="should NOT have additional properties",i+="' "),e.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",$=i,i=_.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+$+"]); ":i+=" validate.errors = ["+$+"]; return false; ":i+=" var err = "+$+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a=T,l&&(i+=" break; ")):O&&("failing"==I?(i+=" var "+t+" = errors;  ",b=e.compositeRule,e.compositeRule=h.compositeRule=!0,h.schema=v,h.schemaPath=e.schemaPath+".additionalProperties",h.errSchemaPath=e.errSchemaPath+"/additionalProperties",h.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers),M=c+"["+g+"]",h.dataPathArr[m]=g,B=e.validate(h),h.baseId=w,e.util.varOccurences(B,f)<2?i+=" "+e.util.varReplace(B,f,M)+" ":i+=" var "+f+" = "+M+"; "+B+" ",i+=" if (!"+u+") { errors = "+t+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+c+"["+g+"]; }  ",e.compositeRule=h.compositeRule=b):(h.schema=v,h.schemaPath=e.schemaPath+".additionalProperties",h.errSchemaPath=e.errSchemaPath+"/additionalProperties",h.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers),M=c+"["+g+"]",h.dataPathArr[m]=g,B=e.validate(h),h.baseId=w,e.util.varOccurences(B,f)<2?i+=" "+e.util.varReplace(B,f,M)+" ":i+=" var "+f+" = "+M+"; "+B+" ",l&&(i+=" if (!"+u+") break; "))),e.errorPath=E),G&&(i+=" } "),i+=" }  ",l&&(i+=" if ("+u+") { ",d+="}")}var Y=e.opts.useDefaults&&!e.compositeRule;if(r.length){var J=r;if(J)for(var x,U=-1,Q=J.length-1;U<Q;){var q,k,E,T,R,_,$,L=P[x=J[U+=1]];(e.opts.strictKeywords?"object"==typeof L&&0<Object.keys(L).length||!1===L:e.util.schemaHasRules(L,e.RULES.all))&&(M=c+(R=e.util.getProperty(x)),q=Y&&void 0!==L.default,h.schema=L,h.schemaPath=s+R,h.errSchemaPath=a+"/"+e.util.escapeFragment(x),h.errorPath=e.util.getPath(e.errorPath,x,e.opts.jsonPointers),h.dataPathArr[m]=e.util.toQuotedString(x),B=e.validate(h),h.baseId=w,e.util.varOccurences(B,f)<2?(B=e.util.varReplace(B,f,M),k=M):i+=" var "+(k=f)+" = "+M+"; ",q?i+=" "+B+" ":(n&&n[x]?(i+=" if ( "+k+" === undefined ",A&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(x)+"') "),i+=") { "+u+" = false; ",E=e.errorPath,T=a,R=e.util.escapeQuotes(x),e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(E,x,e.opts.jsonPointers)),a=e.errSchemaPath+"/required",(_=_||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+R+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+R+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",$=i,i=_.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+$+"]); ":i+=" validate.errors = ["+$+"]; return false; ":i+=" var err = "+$+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a=T,e.errorPath=E,i+=" } else { "):l?(i+=" if ( "+k+" === undefined ",A&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(x)+"') "),i+=") { "+u+" = true; } else { "):(i+=" if ("+k+" !== undefined ",A&&(i+=" &&   Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(x)+"') "),i+=" ) { "),i+=" "+B+" } ")),l&&(i+=" if ("+u+") { ",d+="}")}}if(y.length){var ee=y;if(ee)for(var N,te=-1,ne=ee.length-1;te<ne;){var M,B,L=H[N=ee[te+=1]];(e.opts.strictKeywords?"object"==typeof L&&0<Object.keys(L).length||!1===L:e.util.schemaHasRules(L,e.RULES.all))&&(h.schema=L,h.schemaPath=e.schemaPath+".patternProperties"+e.util.getProperty(N),h.errSchemaPath=e.errSchemaPath+"/patternProperties/"+e.util.escapeFragment(N),i=(i+=A?" "+C+" = "+C+" || Object.keys("+c+"); for (var "+p+"=0; "+p+"<"+C+".length; "+p+"++) { var "+g+" = "+C+"["+p+"]; ":" for (var "+g+" in "+c+") { ")+" if ("+e.usePattern(N)+".test("+g+")) { ",h.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers),M=c+"["+g+"]",h.dataPathArr[m]=g,B=e.validate(h),h.baseId=w,e.util.varOccurences(B,f)<2?i+=" "+e.util.varReplace(B,f,M)+" ":i+=" var "+f+" = "+M+"; "+B+" ",l&&(i+=" if (!"+u+") break; "),i+=" } ",l&&(i+=" else "+u+" = true; "),i+=" }  ",l)&&(i+=" if ("+u+") { ",d+="}")}}return l&&(i+=" "+d+" if ("+t+" == errors) {"),i}},2127:function(e){"use strict";e.exports=function(e,t,n){var i,o,r,s,a,l,c,h=" ",d=e.level,u=e.dataLevel,g=e.schema[t],p=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,m=!e.opts.allErrors,u="data"+(u||""),f="errs__"+d,C=e.util.copy(e),y=(C.level++,"valid"+C.level);return h+="var "+f+" = errors;",(e.opts.strictKeywords?"object"==typeof g&&0<Object.keys(g).length||!1===g:e.util.schemaHasRules(g,e.RULES.all))&&(C.schema=g,C.schemaPath=p,C.errSchemaPath=t,g="idx"+d,o="i"+d,r="' + "+(i="key"+d)+" + '",s="data"+(C.dataLevel=e.dataLevel+1),c="dataProperties"+d,l=e.opts.ownProperties,a=e.baseId,l&&(h+=" var "+c+" = undefined; "),h=h+(l?" "+c+" = "+c+" || Object.keys("+u+"); for (var "+g+"=0; "+g+"<"+c+".length; "+g+"++) { var "+i+" = "+c+"["+g+"]; ":" for (var "+i+" in "+u+") { ")+" var startErrs"+d+" = errors; ",l=i,c=e.compositeRule,e.compositeRule=C.compositeRule=!0,g=e.validate(C),C.baseId=a,e.util.varOccurences(g,s)<2?h+=" "+e.util.varReplace(g,s,l)+" ":h+=" var "+s+" = "+l+"; "+g+" ",e.compositeRule=C.compositeRule=c,h+=" if (!"+y+") { for (var "+o+"=startErrs"+d+"; "+o+"<errors; "+o+"++) { vErrors["+o+"].propertyName = "+i+"; }   var err =   ",!1!==e.createErrors?(h+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { propertyName: '"+r+"' } ",!1!==e.opts.messages&&(h+=" , message: 'property name \\'"+r+"\\' is invalid' "),e.opts.verbose&&(h+=" , schema: validate.schema"+p+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),h+=" } "):h+=" {} ",h+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&m&&(e.async?h+=" throw new ValidationError(vErrors); ":h+=" validate.errors = vErrors; return false; "),m&&(h+=" break; "),h+=" } }"),m&&(h+="  if ("+f+" == errors) {"),h}},2331:function(e){"use strict";e.exports=function(e,t,n){var i,o,r=" ",s=e.level,a=e.dataLevel,l=e.schema[t],t=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(a||""),s="valid"+s;if("#"==l||"#/"==l)o=e.isRoot?(i=e.async,"validate"):(i=!0===e.root.schema.$async,"root.refVal[0]");else{var d=e.resolveRef(e.baseId,l,e.isRoot);if(void 0===d){var u=e.MissingRefError.message(e.baseId,l);if("fail"==e.opts.missingRefs){e.logger.error(u);(g=g||[]).push(r),r="",!1!==e.createErrors?(r+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { ref: '"+e.util.escapeQuotes(l)+"' } ",!1!==e.opts.messages&&(r+=" , message: 'can\\'t resolve reference "+e.util.escapeQuotes(l)+"' "),e.opts.verbose&&(r+=" , schema: "+e.util.toQuotedString(l)+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),r+=" } "):r+=" {} ";t=r,r=g.pop();!e.compositeRule&&c?e.async?r+=" throw new ValidationError(["+t+"]); ":r+=" validate.errors = ["+t+"]; return false; ":r+=" var err = "+t+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c&&(r+=" if (false) { ")}else{if("ignore"!=e.opts.missingRefs)throw new e.MissingRefError(e.baseId,l,u);e.logger.warn(u),c&&(r+=" if (true) { ")}}else d.inline?((t=e.util.copy(e)).level++,u="valid"+t.level,t.schema=d.schema,t.schemaPath="",t.errSchemaPath=l,r+=" "+e.validate(t).replace(/validate\.schema/g,d.code)+" ",c&&(r+=" if ("+u+") { ")):(i=!0===d.$async||e.async&&!1!==d.$async,o=d.code)}if(o){(g=g||[]).push(r),r="",e.opts.passContext?r+=" "+o+".call(this, ":r+=" "+o+"( ",r+=" "+h+", (dataPath || '')",'""'!=e.errorPath&&(r+=" + "+e.errorPath);var g,l=a?"data"+(a-1||""):"parentData",t=r+=" , "+l+" , "+(a?e.dataPathArr[a]:"parentDataProperty")+", rootData)  ";if(r=g.pop(),i){if(!e.async)throw new Error("async schema referenced by sync schema");c&&(r+=" var "+s+"; "),r+=" try { await "+t+"; ",c&&(r+=" "+s+" = true; "),r+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",c&&(r+=" "+s+" = false; "),r+=" } ",c&&(r+=" if ("+s+") { ")}else r+=" if (!"+t+") { if (vErrors === null) vErrors = "+o+".errors; else vErrors = vErrors.concat("+o+".errors); errors = vErrors.length; } ",c&&(r+=" else { ")}return r}},1204:function(e){"use strict";e.exports=function(e,t,n){var i=" ",o=e.level,r=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,t=!e.opts.allErrors,c="data"+(r||""),h="valid"+o,d=e.opts.$data&&s&&s.$data,r=(d&&(i+=" var schema"+o+" = "+e.util.getData(s.$data,r,e.dataPathArr)+"; "),"schema"+o);if(!d)if(s.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var u=[],g=s;if(g)for(var p=-1,m=g.length-1;p<m;){var f=g[p+=1],C=e.schema.properties[f];C&&(e.opts.strictKeywords?"object"==typeof C&&0<Object.keys(C).length||!1===C:e.util.schemaHasRules(C,e.RULES.all))||(u[u.length]=f)}}else u=s;if(d||u.length){var y=e.errorPath,s=d||u.length>=e.opts.loopRequired,v=e.opts.ownProperties;if(t){if(i+=" var missing"+o+"; ",s){d||(i+=" var "+r+" = validate.schema"+a+"; ");var I="' + "+(k="schema"+o+"["+(w="i"+o)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(y,k,e.opts.jsonPointers)),i+=" var "+h+" = true; ",d&&(i+=" if (schema"+o+" === undefined) "+h+" = true; else if (!Array.isArray(schema"+o+")) "+h+" = false; else {"),i+=" for (var "+w+" = 0; "+w+" < "+r+".length; "+w+"++) { "+h+" = "+c+"["+r+"["+w+"]] !== undefined ",v&&(i+=" &&   Object.prototype.hasOwnProperty.call("+c+", "+r+"["+w+"]) "),i+="; if (!"+h+") break; } ",d&&(i+="  }  ");(x=x||[]).push(i+="  if (!"+h+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+I+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+I+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var b=i,i=x.pop()}else{i+=" if ( ";var A=u;if(A)for(var w=-1,S=A.length-1;w<S;)T=A[w+=1],w&&(i+=" || "),i+=" ( ( "+(L=c+($=e.util.getProperty(T)))+" === undefined ",v&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(T)+"') "),i+=") && (missing"+o+" = "+e.util.toQuotedString(e.opts.jsonPointers?T:$)+") ) ";i+=") {  ";I="' + "+(k="missing"+o)+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(y,k,!0):y+" + "+k);(x=x||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+I+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+I+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var x,b=i;i=x.pop()}!e.compositeRule&&t?e.async?i+=" throw new ValidationError(["+b+"]); ":i+=" validate.errors = ["+b+"]; return false; ":i+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { "}else if(s){d||(i+=" var "+r+" = validate.schema"+a+"; ");var k,I="' + "+(k="schema"+o+"["+(w="i"+o)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(y,k,e.opts.jsonPointers)),d&&(i+=" if ("+r+" && !Array.isArray("+r+")) {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+I+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+I+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+r+" !== undefined) { "),i+=" for (var "+w+" = 0; "+w+" < "+r+".length; "+w+"++) { if ("+c+"["+r+"["+w+"]] === undefined ",v&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", "+r+"["+w+"]) "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+I+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+I+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",d&&(i+="  }  ")}else{var E=u;if(E)for(var T,R=-1,_=E.length-1;R<_;){T=E[R+=1];var $=e.util.getProperty(T),I=e.util.escapeQuotes(T),L=c+$;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(y,T,e.opts.jsonPointers)),i+=" if ( "+L+" === undefined ",v&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(T)+"') "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+I+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+I+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}e.errorPath=y}else t&&(i+=" if (true) {");return i}},1985:function(e){"use strict";e.exports=function(e,t,n){var i,o=" ",r=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(s||""),d="valid"+r,u=e.opts.$data&&a&&a.$data,s=u?(o+=" var schema"+r+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+r):a;return(a||u)&&!1!==e.opts.uniqueItems?(u&&(o+=" var "+d+"; if ("+s+" === false || "+s+" === undefined) "+d+" = true; else if (typeof "+s+" != 'boolean') "+d+" = false; else { "),o+=" var i = "+h+".length , "+d+" = true , j; if (i > 1) { ",r=e.schema.items&&e.schema.items.type,s=Array.isArray(r),!r||"object"==r||"array"==r||s&&(0<=r.indexOf("object")||0<=r.indexOf("array"))?o+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+h+"[i], "+h+"[j])) { "+d+" = false; break outer; } } } ":(o=(o+=" var itemIndices = {}, item; for (;i--;) { var item = "+h+"[i]; ")+" if ("+e.util["checkDataType"+(s?"s":"")](r,"item",e.opts.strictNumbers,!0)+") continue; ",s&&(o+=" if (typeof item == 'string') item = '\"' + item; "),o+=" if (typeof itemIndices[item] == 'number') { "+d+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "),o+=" } ",u&&(o+="  }  "),(i=i||[]).push(o+=" if (!"+d+") {   "),o="",!1!==e.createErrors?(o+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(o+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(o=(o+=" , schema:  ")+(u?"validate.schema"+l:""+a)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),o+=" } "):o+=" {} ",r=o,o=i.pop(),!e.compositeRule&&c?e.async?o+=" throw new ValidationError(["+r+"]); ":o+=" validate.errors = ["+r+"]; return false; ":o+=" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } ",c&&(o+=" else { ")):c&&(o+=" if (true) { "),o}},1869:function(e){"use strict";e.exports=function(i,e,W){var t="",n=!0===i.schema.$async,o=i.util.schemaHasRulesExcept(i.schema,i.RULES.all,"$ref"),r=i.self._getId(i.schema);if(i.opts.strictKeywords){var s=i.util.schemaUnknownRules(i.schema,i.RULES.keywords);if(s){s="unknown keyword: "+s;if("log"!==i.opts.strictKeywords)throw new Error(s);i.logger.warn(s)}}if(i.isTop&&(t+=" var validate = ",n&&(i.async=!0,t+="async "),t+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",r)&&(i.opts.sourceCode||i.opts.processCode)&&(t+=" /*# sourceURL="+r+" */ "),"boolean"==typeof i.schema||!o&&!i.schema.$ref)l=i.level,c=i.dataLevel,R=i.schema[e="false schema"],I=i.schemaPath+i.util.getProperty(e),b=i.errSchemaPath+"/"+e,g=!i.opts.allErrors,h="data"+(c||""),u="valid"+l,!1===i.schema?(i.isTop?g=!0:t+=" var "+u+" = false; ",(M=M||[]).push(t),t="",!1!==i.createErrors?(t+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+i.errorPath+" , schemaPath: "+i.util.toQuotedString(b)+" , params: {} ",!1!==i.opts.messages&&(t+=" , message: 'boolean schema is false' "),i.opts.verbose&&(t+=" , schema: false , parentSchema: validate.schema"+i.schemaPath+" , data: "+h+" "),t+=" } "):t+=" {} ",E=t,t=M.pop(),!i.compositeRule&&g?i.async?t+=" throw new ValidationError(["+E+"]); ":t+=" validate.errors = ["+E+"]; return false; ":t+=" var err = "+E+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "):i.isTop?t+=n?" return data; ":" validate.errors = null; return true; ":t+=" var "+u+" = true; ",i.isTop&&(t+=" }; return validate; ");else{if(i.isTop){var a=i.isTop,l=i.level=0,c=i.dataLevel=0,h="data";if(i.rootId=i.resolve.fullPath(i.self._getId(i.root.schema)),i.baseId=i.baseId||i.rootId,delete i.isTop,i.dataPathArr=[""],void 0!==i.schema.default&&i.opts.useDefaults&&i.opts.strictDefaults){var d="default is ignored in the schema root";if("log"!==i.opts.strictDefaults)throw new Error(d);i.logger.warn(d)}t=(t+=" var vErrors = null; ")+" var errors = 0;     "+" if (rootData === undefined) rootData = data; "}else{l=i.level,h="data"+((c=i.dataLevel)||"");if(r&&(i.baseId=i.resolve.url(i.baseId,r)),n&&!i.async)throw new Error("async schema in sync schema");t+=" var errs_"+l+" = errors;"}var u="valid"+l,g=!i.opts.allErrors,p="",m="",f=i.schema.type,C=Array.isArray(f);if(f&&i.opts.nullable&&!0===i.schema.nullable&&(C?-1==f.indexOf("null")&&(f=f.concat("null")):"null"!=f&&(f=[f,"null"],C=!0)),C&&1==f.length&&(f=f[0],C=!1),i.schema.$ref&&o){if("fail"==i.opts.extendRefs)throw new Error('$ref: validation keywords used in schema at path "'+i.errSchemaPath+'" (see option extendRefs)');!0!==i.opts.extendRefs&&(o=!1,i.logger.warn('$ref: keywords ignored in schema at path "'+i.errSchemaPath+'"'))}if(i.schema.$comment&&i.opts.$comment&&(t+=" "+i.RULES.all.$comment.code(i,"$comment")),f){i.opts.coerceTypes&&(y=i.util.coerceToTypes(i.opts.coerceTypes,f));var y,v=i.RULES.types[f];if(y||C||!0===v||v&&!z(v)){var I=i.schemaPath+".type",b=i.errSchemaPath+"/type",I=i.schemaPath+".type",b=i.errSchemaPath+"/type";if(t+=" if ("+i.util[C?"checkDataTypes":"checkDataType"](f,h,i.opts.strictNumbers,!0)+") { ",y){var A="dataType"+l,w="coerced"+l,S=(t+=" var "+A+" = typeof "+h+"; var "+w+" = undefined; ","array"==i.opts.coerceTypes&&(t+=" if ("+A+" == 'object' && Array.isArray("+h+") && "+h+".length == 1) { "+h+" = "+h+"[0]; "+A+" = typeof "+h+"; if ("+i.util.checkDataType(i.schema.type,h,i.opts.strictNumbers)+") "+w+" = "+h+"; } "),t+=" if ("+w+" !== undefined) ; ",y);if(S)for(var x,k=-1,P=S.length-1;k<P;)"string"==(x=S[k+=1])?t+=" else if ("+A+" == 'number' || "+A+" == 'boolean') "+w+" = '' + "+h+"; else if ("+h+" === null) "+w+" = ''; ":"number"==x||"integer"==x?(t+=" else if ("+A+" == 'boolean' || "+h+" === null || ("+A+" == 'string' && "+h+" && "+h+" == +"+h+" ","integer"==x&&(t+=" && !("+h+" % 1)"),t+=")) "+w+" = +"+h+"; "):"boolean"==x?t+=" else if ("+h+" === 'false' || "+h+" === 0 || "+h+" === null) "+w+" = false; else if ("+h+" === 'true' || "+h+" === 1) "+w+" = true; ":"null"==x?t+=" else if ("+h+" === '' || "+h+" === 0 || "+h+" === false) "+w+" = null; ":"array"==i.opts.coerceTypes&&"array"==x&&(t+=" else if ("+A+" == 'string' || "+A+" == 'number' || "+A+" == 'boolean' || "+h+" == null) "+w+" = ["+h+"]; ");(M=M||[]).push(t+=" else {   "),t="",!1!==i.createErrors?(t=(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+i.errorPath+" , schemaPath: "+i.util.toQuotedString(b)+" , params: { type: '")+(C?""+f.join(","):""+f)+"' } ",!1!==i.opts.messages&&(t=(t+=" , message: 'should be ")+(C?""+f.join(","):""+f)+"' "),i.opts.verbose&&(t+=" , schema: validate.schema"+I+" , parentSchema: validate.schema"+i.schemaPath+" , data: "+h+" "),t+=" } "):t+=" {} ";var E=t,s=(t=M.pop(),!i.compositeRule&&g?i.async?t+=" throw new ValidationError(["+E+"]); ":t+=" validate.errors = ["+E+"]; return false; ":t+=" var err = "+E+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c?"data"+(c-1||""):"parentData");t=t+(" } if ("+w+" !== undefined) {  ")+(" "+h+" = "+w+"; "),c||(t+="if ("+s+" !== undefined)"),t+=" "+s+"["+(c?i.dataPathArr[c]:"parentDataProperty")+"] = "+w+"; } "}else{E=((M=M||[]).push(t),t="",!1!==i.createErrors?(t=(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+i.errorPath+" , schemaPath: "+i.util.toQuotedString(b)+" , params: { type: '")+(C?""+f.join(","):""+f)+"' } ",!1!==i.opts.messages&&(t=(t+=" , message: 'should be ")+(C?""+f.join(","):""+f)+"' "),i.opts.verbose&&(t+=" , schema: validate.schema"+I+" , parentSchema: validate.schema"+i.schemaPath+" , data: "+h+" "),
t+=" } "):t+=" {} ",t);t=M.pop(),!i.compositeRule&&g?i.async?t+=" throw new ValidationError(["+E+"]); ":t+=" validate.errors = ["+E+"]; return false; ":t+=" var err = "+E+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}t+=" } "}}if(i.schema.$ref&&!o)t+=" "+i.RULES.all.$ref.code(i,"$ref")+" ",g&&(t=(t+=" } if (errors === ")+(a?"0":"errs_"+l)+") { ",m+="}");else{var T=i.RULES;if(T)for(var H=-1,G=T.length-1;H<G;)if(z(v=T[H+=1])){if(v.type&&(t+=" if ("+i.util.checkDataType(v.type,h,i.opts.strictNumbers)+") { "),i.opts.useDefaults)if("object"==v.type&&i.schema.properties){var R=i.schema.properties,_=Object.keys(R);if(_)for(var F,O=-1,V=_.length-1;O<V;)if(void 0!==(N=R[F=_[O+=1]]).default){var $=h+i.util.getProperty(F);if(i.compositeRule){if(i.opts.strictDefaults){d="default is ignored for: "+$;if("log"!==i.opts.strictDefaults)throw new Error(d);i.logger.warn(d)}}else t+=" if ("+$+" === undefined ","empty"==i.opts.useDefaults&&(t+=" || "+$+" === null || "+$+" === '' "),t+=" ) "+$+" = ","shared"==i.opts.useDefaults?t+=" "+i.useDefault(N.default)+" ":t+=" "+JSON.stringify(N.default)+" ",t+="; "}}else if("array"==v.type&&Array.isArray(i.schema.items)){var L=i.schema.items;if(L)for(var N,k=-1,Z=L.length-1;k<Z;)if(void 0!==(N=L[k+=1]).default){$=h+"["+k+"]";if(i.compositeRule){if(i.opts.strictDefaults){d="default is ignored for: "+$;if("log"!==i.opts.strictDefaults)throw new Error(d);i.logger.warn(d)}}else t+=" if ("+$+" === undefined ","empty"==i.opts.useDefaults&&(t+=" || "+$+" === null || "+$+" === '' "),t+=" ) "+$+" = ","shared"==i.opts.useDefaults?t+=" "+i.useDefault(N.default)+" ":t+=" "+JSON.stringify(N.default)+" ",t+="; "}}var M,D=v.rules;if(D)for(var B,j=-1,K=D.length-1;j<K;)X(B=D[j+=1])&&(B=B.code(i,B.keyword,v.type))&&(t+=" "+B+" ",g)&&(p+="}");g&&(t+=" "+p+" ",p=""),v.type&&(t+=" } ",f)&&f===v.type&&!y&&(t+=" else { ",I=i.schemaPath+".type",b=i.errSchemaPath+"/type",(M=M||[]).push(t),t="",!1!==i.createErrors?(t=(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+i.errorPath+" , schemaPath: "+i.util.toQuotedString(b)+" , params: { type: '")+(C?""+f.join(","):""+f)+"' } ",!1!==i.opts.messages&&(t=(t+=" , message: 'should be ")+(C?""+f.join(","):""+f)+"' "),i.opts.verbose&&(t+=" , schema: validate.schema"+I+" , parentSchema: validate.schema"+i.schemaPath+" , data: "+h+" "),t+=" } "):t+=" {} ",E=t,t=M.pop(),!i.compositeRule&&g?i.async?t+=" throw new ValidationError(["+E+"]); ":t+=" validate.errors = ["+E+"]; return false; ":t+=" var err = "+E+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } "),g&&(t=(t+=" if (errors === ")+(a?"0":"errs_"+l)+") { ",m+="}")}}g&&(t+=" "+m+" "),a?t=t+(n?" if (errors === 0) return data;            else throw new ValidationError(vErrors); ":" validate.errors = vErrors;  return errors === 0;       ")+" }; return validate;":t+=" var "+u+" = errors === errs_"+l+";"}return t;function z(e){for(var t=e.rules,n=0;n<t.length;n++)if(X(t[n]))return 1}function X(e){return void 0!==i.schema[e.keyword]||e.implements&&function(e){for(var t=e.implements,n=0;n<t.length;n++)if(void 0!==i.schema[t[n]])return 1}(e)}}},7931:function(e,t,n){"use strict";var a=/^[a-z_$][a-z0-9_$-]*$/i,l=n(1793),i=n(5868);function o(e,t){o.errors=null;var n=this._validateKeyword=this._validateKeyword||this.compile(i,!0);if(n(e))return!0;if(o.errors=n.errors,t)throw new Error("custom keyword definition is invalid: "+this.errorsText(n.errors));return!1}e.exports={add:function(e,t){var s=this.RULES;if(s.keywords[e])throw new Error("Keyword "+e+" is already defined");if(!a.test(e))throw new Error("Keyword "+e+" is not a valid identifier");if(t){this.validateKeyword(t,!0);var n=t.type;if(Array.isArray(n))for(var i=0;i<n.length;i++)r(e,n[i],t);else r(e,n,t);var o=t.metaSchema;o&&(t.$data&&this._opts.$data&&(o={anyOf:[o,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]}),t.validateSchema=this.compile(o,!0))}function r(e,t,n){for(var i,o=0;o<s.length;o++){var r=s[o];if(r.type==t){i=r;break}}i||s.push(i={type:t,rules:[]});n={keyword:e,definition:n,custom:!0,code:l,implements:n.implements};i.rules.push(n),s.custom[e]=n}return s.keywords[e]=s.all[e]=!0,this},get:function(e){var t=this.RULES.custom[e];return t?t.definition:this.RULES.keywords[e]||!1},remove:function(e){var t=this.RULES;delete t.keywords[e],delete t.all[e],delete t.custom[e];for(var n=0;n<t.length;n++)for(var i=t[n].rules,o=0;o<i.length;o++)if(i[o].keyword==e){i.splice(o,1);break}return this},validate:o}},2303:function(e){"use strict";e.exports=function e(t,n){if(t===n)return!0;if(t&&n&&"object"==typeof t&&"object"==typeof n){if(t.constructor!==n.constructor)return!1;var i,o,r;if(Array.isArray(t)){if((i=t.length)!=n.length)return!1;for(o=i;0!=o--;)if(!e(t[o],n[o]))return!1}else{if(t.constructor===RegExp)return t.source===n.source&&t.flags===n.flags;if(t.valueOf!==Object.prototype.valueOf)return t.valueOf()===n.valueOf();if(t.toString!==Object.prototype.toString)return t.toString()===n.toString();if((i=(r=Object.keys(t)).length)!==Object.keys(n).length)return!1;for(o=i;0!=o--;)if(!Object.prototype.hasOwnProperty.call(n,r[o]))return!1;for(o=i;0!=o--;){var s=r[o];if(!e(t[s],n[s]))return!1}}return!0}return t!=t&&n!=n}},3508:function(e){"use strict";e.exports=function(e,t){var i,l="boolean"==typeof(t="function"==typeof(t=t||{})?{cmp:t}:t).cycles&&t.cycles,c=t.cmp&&(i=t.cmp,function(n){return function(e,t){e={key:e,value:n[e]},t={key:t,value:n[t]};return i(e,t)}}),h=[];return function e(t){if(void 0!==(t=t&&t.toJSON&&"function"==typeof t.toJSON?t.toJSON():t)){if("number"==typeof t)return isFinite(t)?""+t:"null";if("object"!=typeof t)return JSON.stringify(t);if(Array.isArray(t)){for(o="[",r=0;r<t.length;r++)r&&(o+=","),o+=e(t[r])||"null";return o+"]"}if(null===t)return"null";if(-1!==h.indexOf(t)){if(l)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}for(var n=h.push(t)-1,i=Object.keys(t).sort(c&&c(t)),o="",r=0;r<i.length;r++){var s=i[r],a=e(t[s]);a&&(o&&(o+=","),o+=JSON.stringify(s)+":"+a)}return h.splice(n,1),"{"+o+"}"}}(e)}},233:function(e){e.exports=function t(e,n){"use strict";function i(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var o,r,s=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,a=/(^[ ]*|[ ]*$)/g,l=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,h=/^0/,e=i(e).replace(a,"")||"",n=i(n).replace(a,"")||"",d=e.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),u=n.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),a=parseInt(e.match(c),16)||1!==d.length&&e.match(l)&&Date.parse(e),s=parseInt(n.match(c),16)||a&&n.match(l)&&Date.parse(n)||null;if(s){if(a<s)return-1;if(s<a)return 1}for(var g=0,p=Math.max(d.length,u.length);g<p;g++){if(o=!(d[g]||"").match(h)&&parseFloat(d[g])||d[g]||0,r=!(u[g]||"").match(h)&&parseFloat(u[g])||u[g]||0,isNaN(o)!==isNaN(r))return isNaN(o)?1:-1;if(typeof o!=typeof r&&(o+="",r+=""),o<r)return-1;if(r<o)return 1}return 0}},5156:function(e,t){!function(e){"use strict";function w(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function S(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function x(e,t){if(e!==t){if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===w(e)){if(e.length!==t.length)return!1;for(var n=0;n<e.length;n++)if(!1===x(e[n],t[n]))return!1}else{if(!0!==S(e))return!1;var i,o,r={};for(i in e)if(hasOwnProperty.call(e,i)){if(!1===x(e[i],t[i]))return!1;r[i]=!0}for(o in t)if(hasOwnProperty.call(t,o)&&!0!==r[o])return!1}}return!0}function k(e){if(""===e||!1===e||null===e)return!0;if(w(e)&&0===e.length)return!0;if(S(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var o="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]},h={0:"number",1:"any",2:"string",3:"array",4:"object",5:"boolean",6:"expression",7:"null",8:"Array<number>",9:"Array<string>"},s="UnquotedIdentifier",a="QuotedIdentifier",l="Rbracket",c="Rparen",d="Comma",u="Colon",r="Rbrace",g="Number",E="Current",T="Expref",R="Pipe",_="Flatten",p="Star",m="Filter",f="Lbrace",C="Lbracket",y="Lparen",v="Literal",I={".":"Dot","*":p,",":d,":":u,"{":f,"}":r,"]":l,"(":y,")":c,"@":E},b={"<":!0,">":!0,"=":!0,"!":!0},A={" ":!0,"\t":!0,"\n":!0};function $(e){return"0"<=e&&e<="9"||"-"===e}function n(){}n.prototype={tokenize:function(e){var t,n,i=[];for(this._current=0;this._current<e.length;)if("a"<=(r=e[this._current])&&r<="z"||"A"<=r&&r<="Z"||"_"===r)o=this._current,t=this._consumeUnquotedIdentifier(e),i.push({type:s,value:t,start:o});else if(void 0!==I[e[this._current]])i.push({type:I[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if($(e[this._current]))n=this._consumeNumber(e),i.push(n);else if("["===e[this._current])n=this._consumeLBracket(e),i.push(n);else if('"'===e[this._current])o=this._current,t=this._consumeQuotedIdentifier(e),i.push({type:a,value:t,start:o});else if("'"===e[this._current])o=this._current,t=this._consumeRawStringLiteral(e),i.push({type:v,value:t,start:o});else if("`"===e[this._current]){var o=this._current,r=this._consumeLiteral(e);i.push({type:v,value:r,start:o})}else if(void 0!==b[e[this._current]])i.push(this._consumeOperator(e));else if(void 0!==A[e[this._current]])this._current++;else if("&"===e[this._current])o=this._current,this._current++,"&"===e[this._current]?(this._current++,i.push({type:"And",value:"&&",start:o})):i.push({type:T,value:"&",start:o});else{if("|"!==e[this._current])throw(r=new Error("Unknown character:"+e[this._current])).name="LexerError",r;o=this._current,this._current++,"|"===e[this._current]?(this._current++,i.push({type:"Or",value:"||",start:o})):i.push({type:R,value:"|",start:o})}return i},_consumeUnquotedIdentifier:function(e){var t,n=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(n,this._current)},_consumeQuotedIdentifier:function(e){for(var t=this._current,n=(this._current++,e.length);'"'!==e[this._current]&&this._current<n;){var i=this._current;"\\"!==e[i]||"\\"!==e[i+1]&&'"'!==e[i+1]?i++:i+=2,this._current=i}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){for(var t=this._current,n=(this._current++,e.length);"'"!==e[this._current]&&this._current<n;){var i=this._current;"\\"!==e[i]||"\\"!==e[i+1]&&"'"!==e[i+1]?i++:i+=2,this._current=i}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){for(var t=this._current,n=(this._current++,e.length);$(e[this._current])&&this._current<n;)this._current++;var i=parseInt(e.slice(t,this._current));return{type:g,value:i,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:m,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:_,value:"[]",start:t}):{type:C,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,n=e[t];return this._current++,"!"===n?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===n?"="===e[this._current]?(this._current++,{type:"LTE",value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===n?"="===e[this._current]?(this._current++,{type:"GTE",value:">=",start:t}):{type:"GT",value:">",start:t}:"="===n&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var i=this._current;"\\"!==e[i]||"\\"!==e[i+1]&&"`"!==e[i+1]?i++:i+=2,this._current=i}t=(t=o(e.slice(t,this._current))).replace("\\`","`"),t=this._looksLikeJSON(t)?JSON.parse(t):JSON.parse('"'+t+'"');return this._current++,t},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var L={};function N(){}function M(e){this.runtime=e}function B(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}L.EOF=0,L[s]=0,L[a]=0,L[l]=0,L[c]=0,L[d]=0,L[r]=0,L[g]=0,L[E]=0,L[T]=0,L.Pipe=1,L.Or=2,L.And=3,L.EQ=5,L.GT=5,L.LT=5,L.GTE=5,L.LTE=5,L.NE=5,L[_]=9,L.Star=20,L[m]=21,L.Dot=40,L.Not=45,L[f]=50,L[C]=55,L[y]=60,N.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t,e=this.expression(0);if("EOF"!==this._lookahead(0))throw t=this._lookaheadToken(0),(t=new Error("Unexpected token type: "+t.type+", value: "+t.value)).name="ParserError",t;return e},_loadTokens:function(e){var t=(new n).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){for(var t=this._lookaheadToken(0),n=(this._advance(),this.nud(t)),i=this._lookahead(0);e<L[i];)this._advance(),n=this.led(i,n),i=this._lookahead(0);return n},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,n;switch(e.type){case v:return{type:"Literal",value:e.value};case s:return{type:"Field",name:e.value};case a:var i={type:"Field",name:e.value};if(this._lookahead(0)===y)throw new Error("Quoted identifier not allowed for function names.");return i;case"Not":return{type:"NotExpression",children:[t=this.expression(L.Not)]};case p:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===l?{type:"Identity"}:this._parseProjectionRHS(L.Star)]};case m:return this.led(e.type,{type:"Identity"});case f:return this._parseMultiselectHash();case _:return{type:"Projection",children:[{type:_,children:[{type:"Identity"}]},t=this._parseProjectionRHS(L.Flatten)]};case C:return this._lookahead(0)===g||this._lookahead(0)===u?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===p&&this._lookahead(1)===l?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(L.Star)]}):this._parseMultiselectList();case E:return{type:E};case T:return{type:"ExpressionReference",children:[n=this.expression(L.Expref)]};case y:for(var o=[];this._lookahead(0)!==c;)this._lookahead(0)===E?(n={type:E},this._advance()):n=this.expression(0),o.push(n);return this._match(c),o[0];default:this._errorToken(e)}},led:function(e,t){var n;switch(e){case"Dot":var i=L.Dot;return this._lookahead(0)!==p?{type:"Subexpression",children:[t,n=this._parseDotRHS(i)]}:(this._advance(),{type:"ValueProjection",children:[t,n=this._parseProjectionRHS(i)]});case R:return n=this.expression(L.Pipe),{type:R,children:[t,n]};case"Or":return{type:"OrExpression",children:[t,n=this.expression(L.Or)]};case"And":return{type:"AndExpression",children:[t,n=this.expression(L.And)]};case y:for(var o,i=t.name,r=[];this._lookahead(0)!==c;)this._lookahead(0)===E?(o={type:E},this._advance()):o=this.expression(0),this._lookahead(0)===d&&this._match(d),r.push(o);return this._match(c),{type:"Function",name:i,children:r};case m:i=this.expression(0);return this._match(l),{type:"FilterProjection",children:[t,n=this._lookahead(0)===_?{type:"Identity"}:this._parseProjectionRHS(L.Filter),i]};case _:return{type:"Projection",children:[{type:_,children:[t]},this._parseProjectionRHS(L.Flatten)]};case"EQ":case"NE":case"GT":case"GTE":case"LT":case"LTE":return this._parseComparator(t,e);case C:i=this._lookaheadToken(0);return i.type===g||i.type===u?(n=this._parseIndexExpression(),this._projectIfSlice(t,n)):(this._match(p),this._match(l),{type:"Projection",children:[t,n=this._parseProjectionRHS(L.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){var t;if(this._lookahead(0)!==e)throw t=this._lookaheadToken(0),(e=new Error("Expected "+e+", got: "+t.type)).name="ParserError",e;this._advance()},_errorToken:function(e){e=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw e.name="ParserError",e},_parseIndexExpression:function(){var e;return this._lookahead(0)===u||this._lookahead(1)===u?this._parseSliceExpression():(e={type:"Index",value:this._lookaheadToken(0).value},this._advance(),this._match(l),e)},_projectIfSlice:function(e,t){e={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[e,this._parseProjectionRHS(L.Star)]}:e},_parseSliceExpression:function(){for(var e,t=[null,null,null],n=0,i=this._lookahead(0);i!==l&&n<3;){if(i===u)n++;else{if(i!==g)throw e=this._lookahead(0),(e=new Error("Syntax error, unexpected token: "+e.value+"("+e.type+")")).name="Parsererror",e;t[n]=this._lookaheadToken(0).value}this._advance(),i=this._lookahead(0)}return this._match(l),{type:"Slice",children:t}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(L[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[s,a,p].indexOf(t)?this.expression(e):t===C?(this._match(C),this._parseMultiselectList()):t===f?(this._match(f),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t,n;if(L[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===C)t=this.expression(e);else if(this._lookahead(0)===m)t=this.expression(e);else{if("Dot"!==this._lookahead(0))throw n=this._lookaheadToken(0),(n=new Error("Sytanx error, unexpected token: "+n.value+"("+n.type+")")).name="ParserError",n;this._match("Dot"),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==l;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===d&&(this._match(d),this._lookahead(0)===l))throw new Error("Unexpected token Rbracket")}return this._match(l),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,n=[],i=[s,a];;){if(e=this._lookaheadToken(0),i.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(e=e.value,this._advance(),this._match(u),t=this.expression(0),n.push({type:"KeyValuePair",name:e,value:t}),this._lookahead(0)===d)this._match(d);else if(this._lookahead(0)===r){this._match(r);break}}return{type:"MultiSelectHash",children:n}}},M.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var n,i,o,r,s,a;switch(e.type){case"Field":return null!==t&&S(t)?void 0===(l=t[e.name])?null:l:null;case"Subexpression":for(u=this.visit(e.children[0],t),f=1;f<e.children.length;f++)if(null===(u=this.visit(e.children[1],u)))return null;return u;case"IndexExpression":return s=this.visit(e.children[0],t),this.visit(e.children[1],s);case"Index":return w(t)?void 0===(u=t[l=(l=e.value)<0?t.length+l:l])?null:u:null;case"Slice":if(!w(t))return null;var l=e.children.slice(0),l=this.computeSliceParams(t.length,l),c=l[0],h=l[1],d=l[2],u=[];if(0<d)for(f=c;f<h;f+=d)u.push(t[f]);else for(f=c;h<f;f+=d)u.push(t[f]);return u;case"Projection":var g=this.visit(e.children[0],t);if(!w(g))return null;for(p=[],f=0;f<g.length;f++)null!==(i=this.visit(e.children[1],g[f]))&&p.push(i);return p;case"ValueProjection":if(!S(g=this.visit(e.children[0],t)))return null;for(var p=[],m=function(e){for(var t=Object.keys(e),n=[],i=0;i<t.length;i++)n.push(e[t[i]]);return n}(g),f=0;f<m.length;f++)null!==(i=this.visit(e.children[1],m[f]))&&p.push(i);return p;case"FilterProjection":if(!w(g=this.visit(e.children[0],t)))return null;var C=[],y=[];for(f=0;f<g.length;f++)k(n=this.visit(e.children[2],g[f]))||C.push(g[f]);for(var v=0;v<C.length;v++)null!==(i=this.visit(e.children[1],C[v]))&&y.push(i);return y;case"Comparator":switch(o=this.visit(e.children[0],t),r=this.visit(e.children[1],t),e.name){case"EQ":u=x(o,r);break;case"NE":u=!x(o,r);break;case"GT":u=r<o;break;case"GTE":u=r<=o;break;case"LT":u=o<r;break;case"LTE":u=o<=r;break;default:throw new Error("Unknown comparator: "+e.name)}return u;case _:var I=this.visit(e.children[0],t);if(!w(I))return null;var b=[];for(f=0;f<I.length;f++)w(i=I[f])?b.push.apply(b,i):b.push(i);return b;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(p=[],f=0;f<e.children.length;f++)p.push(this.visit(e.children[f],t));return p;case"MultiSelectHash":if(null===t)return null;for(p={},f=0;f<e.children.length;f++)p[(a=e.children[f]).name]=this.visit(a.value,t);return p;case"OrExpression":return n=k(n=this.visit(e.children[0],t))?this.visit(e.children[1],t):n;case"AndExpression":return!0===k(o=this.visit(e.children[0],t))?o:this.visit(e.children[1],t);case"NotExpression":return k(o=this.visit(e.children[0],t));case"Literal":return e.value;case R:return s=this.visit(e.children[0],t),this.visit(e.children[1],s);case E:return t;case"Function":var A=[];for(f=0;f<e.children.length;f++)A.push(this.visit(e.children[f],t));return this.runtime.callFunction(e.name,A);case"ExpressionReference":l=e.children[0];return l.jmespathType=T,l;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var n=t[0],i=t[1],t=t[2],o=[null,null,null];if(null===t)t=1;else if(0===t)throw(r=new Error("Invalid slice, step cannot be 0")).name="RuntimeError",r;var r=t<0,n=null===n?r?e-1:0:this.capSliceRange(e,n,t),i=null===i?r?-1:e:this.capSliceRange(e,i,t);return o[0]=n,o[1]=i,o[2]=t,o},capSliceRange:function(e,t,n){return t<0?(t+=e)<0&&(t=n<0?-1:0):e<=t&&(t=n<0?e-1:e),t}},B.prototype={callFunction:function(e,t){var n=this.functionTable[e];if(void 0===n)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,n._signature),n._func.call(this,t)},_validateArgs:function(e,t,n){var i;if(n[n.length-1].variadic){if(t.length<n.length)throw i=1===n.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+n.length+i+" but received "+t.length)}else if(t.length!==n.length)throw i=1===n.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+n.length+i+" but received "+t.length);for(var o=0;o<n.length;o++){for(var r,s=!1,a=n[o].types,l=this._getTypeName(t[o]),c=0;c<a.length;c++)if(this._typeMatches(l,a[c],t[o])){s=!0;break}if(!s)throw r=a.map(function(e){return h[e]}).join(","),new Error("TypeError: "+e+"() expected argument "+(o+1)+" to be type "+r+" but received type "+h[l]+" instead.")}},_typeMatches:function(e,t,n){if(1===t)return!0;if(9!==t&&8!==t&&3!==t)return e===t;if(3===t)return 3===e;if(3===e){var i;8===t?i=0:9===t&&(i=2);for(var o=0;o<n.length;o++)if(!this._typeMatches(this._getTypeName(n[o]),i,n[o]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return 2;case"[object Number]":return 0;case"[object Array]":return 3;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===T?6:4}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],e=e[1];return-1!==t.indexOf(e,t.length-e.length)},_functionReverse:function(e){var t;if(2!==this._getTypeName(e[0]))return(t=e[0].slice(0)).reverse(),t;for(var n=e[0],i="",o=n.length-1;0<=o;o--)i+=n[o];return i},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,n=e[0],i=0;i<n.length;i++)t+=n[i];return t/n.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return(S(e[0])?Object.keys(e[0]):e[0]).length},_functionMap:function(e){for(var t=[],n=this._interpreter,i=e[0],o=e[1],r=0;r<o.length;r++)t.push(n.visit(i,o[r]));return t},_functionMerge:function(e){for(var t={},n=0;n<e.length;n++){var i,o=e[n];for(i in o)t[i]=o[i]}return t},_functionMax:function(e){if(0<e[0].length){if(0===this._getTypeName(e[0][0]))return Math.max.apply(Math,e[0]);for(var t=e[0],n=t[0],i=1;i<t.length;i++)n.localeCompare(t[i])<0&&(n=t[i]);return n}return null},_functionMin:function(e){if(0<e[0].length){if(0===this._getTypeName(e[0][0]))return Math.min.apply(Math,e[0]);for(var t=e[0],n=t[0],i=1;i<t.length;i++)t[i].localeCompare(n)<0&&(n=t[i]);return n}return null},_functionSum:function(e){for(var t=0,n=e[0],i=0;i<n.length;i++)t+=n[i];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],n=Object.keys(t),i=[],o=0;o<n.length;o++)i.push(t[n[o]]);return i},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return 3===this._getTypeName(e[0])?e[0]:[e[0]]},_functionToString:function(e){return 2===this._getTypeName(e[0])?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t=this._getTypeName(e[0]);return 0===t?e[0]:2!==t||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){e=e[0].slice(0);return e.sort(),e},_functionSortBy:function(e){var t=e[0].slice(0);if(0!==t.length){var o=this._interpreter,r=e[1],s=this._getTypeName(o.visit(r,t[0]));if([0,2].indexOf(s)<0)throw new Error("TypeError");for(var a=this,n=[],i=0;i<t.length;i++)n.push([i,t[i]]);n.sort(function(e,t){var n=o.visit(r,e[1]),i=o.visit(r,t[1]);if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));return i<n?1:n<i?-1:e[0]-t[0]});for(var l=0;l<n.length;l++)t[l]=n[l][1]}return t},_functionMaxBy:function(e){for(var t,n,i=e[1],o=e[0],r=this.createKeyFunction(i,[0,2]),s=-1/0,a=0;a<o.length;a++)s<(n=r(o[a]))&&(s=n,t=o[a]);return t},_functionMinBy:function(e){for(var t,n,i=e[1],o=e[0],r=this.createKeyFunction(i,[0,2]),s=1/0,a=0;a<o.length;a++)(n=r(o[a]))<s&&(s=n,t=o[a]);return t},createKeyFunction:function(n,i){var o=this,r=this._interpreter;return function(e){var t,e=r.visit(n,e);if(i.indexOf(o._getTypeName(e))<0)throw t="TypeError: expected one of "+i+", received "+o._getTypeName(e),new Error(t);return e}}},e.tokenize=function(e){return(new n).tokenize(e)},e.compile=function(e){return(new N).parse(e)},e.search=function(e,t){var n=new N,i=new M(o=new B),o=(o._interpreter=i,n.parse(t));return i.search(o,e)},e.strictDeepEqual=x}(t)},500:function(e){"use strict";var m=e.exports=function(e,t,n){"function"==typeof t&&(n=t,t={}),function e(t,n,i,o,r,s,a,l,c,h){if(o&&"object"==typeof o&&!Array.isArray(o)){for(var d in n(o,r,s,a,l,c,h),o){var u=o[d];if(Array.isArray(u)){if(d in m.arrayKeywords)for(var g=0;g<u.length;g++)e(t,n,i,u[g],r+"/"+d+"/"+g,s,r,d,o,g)}else if(d in m.propsKeywords){if(u&&"object"==typeof u)for(var p in u)e(t,n,i,u[p],r+"/"+d+"/"+f(p),s,r,d,o,p)}else(d in m.keywords||t.allKeys&&!(d in m.skipKeywords))&&e(t,n,i,u,r+"/"+d,s,r,d,o)}i(o,r,s,a,l,c,h)}}(t,"function"==typeof(n=t.cb||n)?n:n.pre||function(){},n.post||function(){},e,"",e)};function f(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}m.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},m.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},m.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},m.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},7026:function(e,t){"use strict";var b={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},A="a".charCodeAt(),n=(t.parse=function(o,e,t){var i={},n=0,r=0,s=0,a=t&&t.bigint&&"undefined"!=typeof BigInt;return{data:l("",!0),pointers:i};function l(e,t){c(),m(e,"value");var n,i=u();switch(i){case"t":d("rue"),n=!0;break;case"f":d("alse"),n=!1;break;case"n":d("ull"),n=null;break;case'"':n=h();break;case"[":n=function(e){c();var t=[],n=0;if("]"!=u())for(g();;){t.push(l(e+"/"+n)),c();var i=u();if("]"==i)break;","!=i&&v(),c(),n++}return t}(e);break;case"{":n=function(e){c();var t={};if("}"!=u())for(g();;){var n=C(),i=('"'!=u()&&v(),h()),o=e+"/"+w(i),n=(f(o,"key",n),m(o,"keyEnd"),c(),":"!=u()&&v(),c(),t[i]=l(o),c(),u());if("}"==n)break;","!=n&&v(),c()}return t}(e);break;default:g(),0<="-0123456789".indexOf(i)?n=function(){var e="",t=!0;"-"==o[s]&&(e+=u());e+=("0"==o[s]?u:p)(),"."==o[s]&&(e+=u()+p(),t=!1);"e"!=o[s]&&"E"!=o[s]||(e+=u(),"+"!=o[s]&&"-"!=o[s]||(e+=u()),e+=p(),t=!1);var n=+e;return a&&t&&(n>Number.MAX_SAFE_INTEGER||n<Number.MIN_SAFE_INTEGER)?BigInt(e):n}():y()}return m(e,"valueEnd"),c(),t&&s<o.length&&y(),n}function c(){e:for(;s<o.length;){switch(o[s]){case" ":r++;break;case"\t":r+=4;break;case"\r":r=0;break;case"\n":r=0,n++;break;default:break e}s++}}function h(){for(var e,t="";'"'!=(e=u());)"\\"==e?(e=u())in b?t+=b[e]:"u"==e?t+=function(){var e=4,t=0;for(;e--;){t<<=4;var n=u().toLowerCase();"a"<=n&&n<="f"?t+=n.charCodeAt()-A+10:"0"<=n&&n<="9"?t+=+n:v()}return String.fromCharCode(t)}():v():t+=e;return t}function d(e){for(var t=0;t<e.length;t++)u()!==e[t]&&v()}function u(){I();var e=o[s];return s++,r++,e}function g(){s--,r--}function p(){for(var e="";"0"<=o[s]&&o[s]<="9";)e+=u();if(e.length)return e;I(),y()}function m(e,t){f(e,t,C())}function f(e,t,n){i[e]=i[e]||{},i[e][t]=n}function C(){return{line:n,column:r,pos:s}}function y(){throw new SyntaxError("Unexpected token "+o[s]+" in JSON at position "+s)}function v(){g(),y()}function I(){if(s>=o.length)throw new SyntaxError("Unexpected end of JSON input")}},t.stringify=function(e,t,n){if(v(e)){var i=0;switch(typeof(u="object"==typeof n?n.space:n)){case"number":var o=10<u?10:u<0?0:Math.floor(u),u=o&&y(o," "),r=o,s=o;break;case"string":u=u.slice(0,10);for(var a=s=r=0;a<u.length;a++){switch(u[a]){case" ":s++;break;case"\t":s+=4;break;case"\r":s=0;break;case"\n":s=0,i++;break;default:throw new Error("whitespace characters not allowed in JSON")}r++}break;default:u=void 0}var l="",c={},h=0,d=0,g=0,p=n&&n.es6&&"function"==typeof Map;return function l(c,h,d){C(d,"value");switch(typeof c){case"number":case"bigint":case"boolean":m(""+c);break;case"string":m(I(c));break;case"object":null===c?m("null"):"function"==typeof c.toJSON?m(I(c.toJSON())):Array.isArray(c)?e():p?c.constructor.BYTES_PER_ELEMENT?e():c instanceof Map?n():c instanceof Set?n(!0):t():t()}C(d,"valueEnd");function e(){if(c.length){m("[");for(var e=h+1,t=0;t<c.length;t++){t&&m(","),f(e);var n=v(c[t])?c[t]:null,i=d+"/"+t;l(n,e,i)}f(h),m("]")}else m("[]")}function t(){var e=Object.keys(c);if(e.length){m("{");for(var t=h+1,n=0;n<e.length;n++){var i,o=e[n],r=c[o];v(r)&&(n&&m(","),i=d+"/"+w(o),f(t),C(i,"key"),m(I(o)),C(i,"keyEnd"),m(":"),u&&m(" "),l(r,t,i))}f(h),m("}")}else m("{}")}function n(e){if(c.size){m("{");for(var t=h+1,n=!0,i=c.entries(),o=i.next();!o.done;){var r,s=o.value,a=s[0],s=!!e||s[1];v(s)&&(n||m(","),n=!1,r=d+"/"+w(a),f(t),C(r,"key"),m(I(a)),C(r,"keyEnd"),m(":"),u&&m(" "),l(s,t,r)),o=i.next()}f(h),m("}")}else m("{}")}}(e,0,""),{json:l,pointers:c}}function m(e){d+=e.length,g+=e.length,l+=e}function f(e){if(u){for(l+="\n"+y(e,u),h++,d=0;e--;)i?(h+=i,d=s):d+=s,g+=r;g+=1}}function C(e,t){c[e]=c[e]||{},c[e][t]={line:h,column:d,pos:g}}function y(e,t){return Array(e+1).join(t)}},["number","bigint","boolean","string","object"]);function v(e){return 0<=n.indexOf(typeof e)}var i=/"|\\/g,o=/[\b]/g,r=/\f/g,s=/\n/g,a=/\r/g,l=/\t/g;function I(e){return'"'+(e=e.replace(i,"\\$&").replace(r,"\\f").replace(o,"\\b").replace(s,"\\n").replace(a,"\\r").replace(l,"\\t"))+'"'}var c=/~/g,h=/\//g;function w(e){return e.replace(c,"~0").replace(h,"~1")}},483:function(e,t){var n,i;!function(){"use strict";i=[],void 0!==(i="function"==typeof(n=function(){"use strict";function C(e){if(typeof Node==="object")return e instanceof Node;else return e&&typeof e==="object"&&typeof e.nodeType==="number"}function y(e){return typeof e==="string"}function v(){var r=[];return{watch:r.push.bind(r),trigger:function(e,t){var n=true;var i={detail:t,preventDefault:function e(){n=false}};for(var o=0;o<r.length;o++)r[o](e,i);return n}}}function o(e){return window.getComputedStyle(e).display==="none"}function r(e){this.elem=e}function I(e,t){return r.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){if(e("overlayClose",true))t()})}r.make=function(e,t){if(typeof e==="string")e=document.querySelector(e);var n=document.createElement(t||"div");(e||document.body).appendChild(n);return new r(n)},r.prototype={child:function(e){return r.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined")e.filter="alpha(opacity="+e.opacity*100+")";for(var t in e)if(e.hasOwnProperty(t))this.elem.style[t]=e[t];return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(C(e))this.elem.appendChild(e);else this.elem.innerHTML=e;return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined)this.elem.setAttribute(e,t);return this},anyAncestor:function(e){var t=this.elem;while(t)if(e(new r(t)))return true;else t=t.parentNode;return false},isVisible:function(){return!o(this.elem)}};var s=1;function b(e,n){var t=e("width","auto");if(typeof t==="number")t=""+t+"px";var i=e("modalId","pico-"+s++);var o=r.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:t,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",i).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",i)).onClick(function(e){var t=new r(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)});if(t)n()});return o}function A(e,t){if(t("closeButton",true))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function w(e){return function(){return e().elem}}var S=v(),c=v();function x(r,s){function t(e,t){var n=e.msMatchesSelector||e.webkitMatchesSelector||e.matches;return n.call(e,t)}function i(e){if(o(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))return false;else return e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe")}function a(e){var t=e.getElementsByTagName("*");for(var n=0;n<t.length;n++)if(i(t[n]))return t[n]}function l(e){var t=e.getElementsByTagName("*");for(var n=t.length;n--;)if(i(t[n]))return t[n]}var n;r.beforeShow(function e(){n=document.activeElement});r.afterShow(function e(){if(s()){var t=a(r.modalElem());if(t)t.focus()}});r.afterClose(function e(){if(s()&&n)n.focus();n=null});c.watch(function e(t){if(s()&&r.isVisible()){var n=a(r.modalElem());var i=l(r.modalElem());var o=t.shiftKey?n:i;if(o===document.activeElement){(t.shiftKey?i:n).focus();t.preventDefault()}}})}function k(e,t){var n;var i=new r(document.body);e.beforeShow(function(){n=i.elem.style.overflow;if(t())i.stylize({overflow:"hidden"})});e.afterClose(function(){i.stylize({overflow:n})})}return document.documentElement.addEventListener("keydown",function e(t){var n=t.which||t.keyCode;if(n===27)S.trigger();else if(n===9)c.trigger(t)}),function e(i){if(y(i)||C(i))i={content:i};var o=v();var t=v();var n=v();var r=v();var s=v();function a(e,t){var n=i[e];if(typeof n==="function")n=n(t);return n===undefined?t:n}var l=f.bind(window,"modal");var c=f.bind(window,"overlay");var h=f.bind(window,"close");var d;function u(e){c().hide();l().hide();s.trigger(d,e)}function g(e){if(r.trigger(d,e))u(e)}function p(e){return function(){e.apply(this,arguments);return d}}var m;function f(e,t){if(!m){var n=b(a,g);m={modal:n,overlay:I(a,g),close:A(n,a)};o.trigger(d,t)}return m[e]}d={modalElem:w(l),closeElem:w(h),overlayElem:w(c),buildDom:p(f.bind(null,null)),isVisible:function(){return!!(m&&l&&l().isVisible())},show:function(e){if(t.trigger(d,e)){c().show();h();l().show();n.trigger(d,e)}return this},close:p(g),forceClose:p(u),destroy:function(){l().destroy();c().destroy();c=l=h=undefined},options:function(t){Object.keys(t).map(function(e){i[e]=t[e]})},afterCreate:p(o.watch),beforeShow:p(t.watch),afterShow:p(n.watch),beforeClose:p(r.watch),afterClose:p(s.watch)};x(d,a.bind(null,"focus",true));k(d,a.bind(null,"bodyOverflow",true));S.watch(function e(){if(a("escCloses",true)&&d.isVisible())d.close()});return d}})?n.apply(t,i):n)&&(e.exports=i)}()},7533:function(e,t){
/** @license URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */
!function(e){"use strict";function he(){for(var e=arguments.length,t=Array(e),n=0;n<e;n++)t[n]=arguments[n];if(t.length>1){t[0]=t[0].slice(0,-1);var i=t.length-1;for(var o=1;o<i;++o)t[o]=t[o].slice(1,-1);t[i]=t[i].slice(1);return t.join("")}else return t[0]}function de(e){return"(?:"+e+")"}function i(e){return e===undefined?"undefined":e===null?"null":Object.prototype.toString.call(e).split(" ").pop().split("]").shift().toLowerCase()}function p(e){return e.toUpperCase()}function b(e){return e!==undefined&&e!==null?e instanceof Array?e:typeof e.length!=="number"||e.split||e.setInterval||e.call?[e]:Array.prototype.slice.call(e):[]}function x(e,t){var n=e;if(t)for(var i in t)n[i]=t[i];return n}function t(e){var t="[A-Za-z]",W="[\\x0D]",n="[0-9]",P="[\\x22]",i=he(n,"[A-Fa-f]"),H="[\\x0A]",G="[\\x20]",o=de(de("%[EFef]"+i+"%"+i+i+"%"+i+i)+"|"+de("%[89A-Fa-f]"+i+"%"+i+i)+"|"+de("%"+i+i)),r="[\\:\\/\\?\\#\\[\\]\\@]",s="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",a=he(r,s),l=e?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",c=e?"[\\uE000-\\uF8FF]":"[]",h=he(t,n,"[\\-\\.\\_\\~]",l),d=de(t+he(t,n,"[\\+\\-\\.]")+"*"),u=de(de(o+"|"+he(h,s,"[\\:]"))+"*"),F=de(de("25[0-5]")+"|"+de("2[0-4]"+n)+"|"+de("1"+n+n)+"|"+de("[1-9]"+n)+"|"+n),g=de(de("25[0-5]")+"|"+de("2[0-4]"+n)+"|"+de("1"+n+n)+"|"+de("0?[1-9]"+n)+"|0?0?"+n),p=de(g+"\\."+g+"\\."+g+"\\."+g),m=de(i+"{1,4}"),f=de(de(m+"\\:"+m)+"|"+p),C=de(de(m+"\\:")+"{6}"+f),y=de("\\:\\:"+de(m+"\\:")+"{5}"+f),v=de(de(m)+"?\\:\\:"+de(m+"\\:")+"{4}"+f),O=de(de(de(m+"\\:")+"{0,1}"+m)+"?\\:\\:"+de(m+"\\:")+"{3}"+f),V=de(de(de(m+"\\:")+"{0,2}"+m)+"?\\:\\:"+de(m+"\\:")+"{2}"+f),Z=de(de(de(m+"\\:")+"{0,3}"+m)+"?\\:\\:"+m+"\\:"+f),D=de(de(de(m+"\\:")+"{0,4}"+m)+"?\\:\\:"+f),j=de(de(de(m+"\\:")+"{0,5}"+m)+"?\\:\\:"+m),K=de(de(de(m+"\\:")+"{0,6}"+m)+"?\\:\\:"),I=de([C,y,v,O,V,Z,D,j,K].join("|")),b=de(de(h+"|"+o)+"+"),z=de(I+"\\%25"+b),X=de(I+de("\\%25|\\%(?!"+i+"{2})")+b),Y=de("[vV]"+i+"+\\."+he(h,s,"[\\:]")+"+"),J=de("\\["+de(X+"|"+I+"|"+Y)+"\\]"),A=de(de(o+"|"+he(h,s))+"*"),w=de(J+"|"+p+"(?!"+A+")"+"|"+A),S=de(n+"*"),x=de(de(u+"@")+"?"+w+de("\\:"+S)+"?"),k=de(o+"|"+he(h,s,"[\\:\\@]")),U=de(k+"*"),E=de(k+"+"),Q=de(de(o+"|"+he(h,s,"[\\@]"))+"+"),T=de(de("\\/"+U)+"*"),R=de("\\/"+de(E+T)+"?"),_=de(Q+T),$=de(E+T),L="(?!"+k+")",q=de(T+"|"+R+"|"+_+"|"+$+"|"+L),N=de(de(k+"|"+he("[\\/\\?]",c))+"*"),M=de(de(k+"|[\\/\\?]")+"*"),B=de(de("\\/\\/"+x+T)+"|"+R+"|"+$+"|"+L),ee=de(d+"\\:"+B+de("\\?"+N)+"?"+de("\\#"+M)+"?"),te=de(de("\\/\\/"+x+T)+"|"+R+"|"+_+"|"+L),ne=de(te+de("\\?"+N)+"?"+de("\\#"+M)+"?"),ie=de(ee+"|"+ne),oe=de(d+"\\:"+B+de("\\?"+N)+"?"),re="^("+d+")\\:"+de(de("\\/\\/("+de("("+u+")@")+"?("+w+")"+de("\\:("+S+")")+"?)")+"?("+T+"|"+R+"|"+$+"|"+L+")")+de("\\?("+N+")")+"?"+de("\\#("+M+")")+"?$",se="^(){0}"+de(de("\\/\\/("+de("("+u+")@")+"?("+w+")"+de("\\:("+S+")")+"?)")+"?("+T+"|"+R+"|"+_+"|"+L+")")+de("\\?("+N+")")+"?"+de("\\#("+M+")")+"?$",ae="^("+d+")\\:"+de(de("\\/\\/("+de("("+u+")@")+"?("+w+")"+de("\\:("+S+")")+"?)")+"?("+T+"|"+R+"|"+$+"|"+L+")")+de("\\?("+N+")")+"?$",le="^"+de("\\#("+M+")")+"?$",ce="^"+de("("+u+")@")+"?("+w+")"+de("\\:("+S+")")+"?$";return{NOT_SCHEME:new RegExp(he("[^]",t,n,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(he("[^\\%\\:]",h,s),"g"),NOT_HOST:new RegExp(he("[^\\%\\[\\]\\:]",h,s),"g"),NOT_PATH:new RegExp(he("[^\\%\\/\\:\\@]",h,s),"g"),NOT_PATH_NOSCHEME:new RegExp(he("[^\\%\\/\\@]",h,s),"g"),NOT_QUERY:new RegExp(he("[^\\%]",h,s,"[\\:\\@\\/\\?]",c),"g"),NOT_FRAGMENT:new RegExp(he("[^\\%]",h,s,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(he("[^]",h,s),"g"),UNRESERVED:new RegExp(h,"g"),OTHER_CHARS:new RegExp(he("[^\\%]",h,a),"g"),PCT_ENCODED:new RegExp(o,"g"),IPV4ADDRESS:new RegExp("^("+p+")$"),IPV6ADDRESS:new RegExp("^\\[?("+I+")"+de(de("\\%25|\\%(?!"+i+"{2})")+"("+b+")")+"?\\]?$")}}var a=t(false),l=t(true),A=function(){function n(e,t){var n=[];var i=true;var o=false;var r=undefined;try{for(var s=e[Symbol.iterator](),a;!(i=(a=s.next()).done);i=true){n.push(a.value);if(t&&n.length===t)break}}catch(e){o=true;r=e}finally{try{if(!i&&s["return"])s["return"]()}finally{if(o)throw r}}return n}return function(e,t){if(Array.isArray(e))return e;else if(Symbol.iterator in Object(e))return n(e,t);else throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),k=function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t];return n}else return Array.from(e)},M=2147483647,B=36,W=1,P=26,E=38,T=700,H=72,G=128,F="-",R=/^xn--/,_=/[^\0-\x7E]/,$=/[\x2E\u3002\uFF0E\uFF61]/g,L={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},r=B-W,O=Math.floor,V=String.fromCharCode;function Z(e){throw new RangeError(L[e])}function N(e,t){var n=[];var i=e.length;while(i--)n[i]=t(e[i]);return n}function D(e,t){var n=e.split("@");var i="";if(n.length>1){i=n[0]+"@";e=n[1]}e=e.replace($,".");var o=e.split(".");var r=N(o,t).join(".");return i+r}function j(e){var t=[];var n=0;var i=e.length;while(n<i){var o=e.charCodeAt(n++);if(o>=55296&&o<=56319&&n<i){var r=e.charCodeAt(n++);if((r&64512)==56320)t.push(((o&1023)<<10)+(r&1023)+65536);else{t.push(o);n--}}else t.push(o)}return t}var K,z=function e(t){if(t-48<10)return t-22;if(t-65<26)return t-65;if(t-97<26)return t-97;return B},X=function e(t,n){return t+22+75*(t<26)-((n!=0)<<5)},Y=function e(t,n,i){var o=0;t=i?O(t/T):t>>1;t+=O(t/n);for(;t>r*P>>1;o+=B)t=O(t/r);return O(o+(r+1)*t/(t+E))},J=function e(t){var n=[];var i=t.length;var o=0;var r=G;var s=H;var a=t.lastIndexOf(F);if(a<0)a=0;for(var l=0;l<a;++l){if(t.charCodeAt(l)>=128)Z("not-basic");n.push(t.charCodeAt(l))}for(var c=a>0?a+1:0;c<i;){var h=o;for(var d=1,u=B;;u+=B){if(c>=i)Z("invalid-input");var g=z(t.charCodeAt(c++));if(g>=B||g>O((M-o)/d))Z("overflow");o+=g*d;var p=u<=s?W:u>=s+P?P:u-s;if(g<p)break;var m=B-p;if(d>O(M/m))Z("overflow");d*=m}var f=n.length+1;s=Y(o-h,f,h==0);if(O(o/f)>M-r)Z("overflow");r+=O(o/f);o%=f;n.splice(o++,0,r)}return String.fromCodePoint.apply(String,n)},U=function e(t){var n=[];t=j(t);var i=t.length;var o=G;var r=0;var s=H;var a=true;var l=false;var c=undefined;try{for(var h=t[Symbol.iterator](),d;!(a=(d=h.next()).done);a=true){var u=d.value;if(u<128)n.push(V(u))}}catch(e){l=true;c=e}finally{try{if(!a&&h.return)h.return()}finally{if(l)throw c}}var g=n.length;var p=g;if(g)n.push(F);while(p<i){var m=M;var f=true;var C=false;var y=undefined;try{for(var v=t[Symbol.iterator](),I;!(f=(I=v.next()).done);f=true){var b=I.value;if(b>=o&&b<m)m=b}}catch(e){C=true;y=e}finally{try{if(!f&&v.return)v.return()}finally{if(C)throw y}}var A=p+1;if(m-o>O((M-r)/A))Z("overflow");r+=(m-o)*A;o=m;var w=true;var S=false;var x=undefined;try{for(var k=t[Symbol.iterator](),E;!(w=(E=k.next()).done);w=true){var T=E.value;if(T<o&&++r>M)Z("overflow");if(T==o){var R=r;for(var _=B;;_+=B){var $=_<=s?W:_>=s+P?P:_-s;if(R<$)break;var L=R-$;var N=B-$;n.push(V(X($+L%N,0)));R=O(L/N)}n.push(V(X(R,0)));s=Y(r,A,p==g);r=0;++p}}}catch(e){S=true;x=e}finally{try{if(!w&&k.return)k.return()}finally{if(S)throw x}}++r;++o}return n.join("")},Q,q,C={version:"2.1.0",ucs2:{decode:j,encode:function e(t){return String.fromCodePoint.apply(String,k(t))}},decode:J,encode:U,toASCII:function e(t){return D(t,function(e){return _.test(e)?"xn--"+U(e):e})},toUnicode:function e(t){return D(t,function(e){return R.test(e)?J(e.slice(4).toLowerCase()):e})}},h={};function m(e){var t=e.charCodeAt(0);var n=void 0;if(t<16)n="%0"+t.toString(16).toUpperCase();else if(t<128)n="%"+t.toString(16).toUpperCase();else if(t<2048)n="%"+(t>>6|192).toString(16).toUpperCase()+"%"+(t&63|128).toString(16).toUpperCase();else n="%"+(t>>12|224).toString(16).toUpperCase()+"%"+(t>>6&63|128).toString(16).toUpperCase()+"%"+(t&63|128).toString(16).toUpperCase();return n}function c(e){var t="";var n=0;var i=e.length;while(n<i){var o=parseInt(e.substr(n+1,2),16);if(o<128){t+=String.fromCharCode(o);n+=3}else if(o>=194&&o<224){if(i-n>=6){var r=parseInt(e.substr(n+4,2),16);t+=String.fromCharCode((o&31)<<6|r&63)}else t+=e.substr(n,6);n+=6}else if(o>=224){if(i-n>=9){var s=parseInt(e.substr(n+4,2),16);var a=parseInt(e.substr(n+7,2),16);t+=String.fromCharCode((o&15)<<12|(s&63)<<6|a&63)}else t+=e.substr(n,9);n+=9}else{t+=e.substr(n,3);n+=3}}return t}function d(e,n){function t(e){var t=c(e);return!t.match(n.UNRESERVED)?e:t}if(e.scheme)e.scheme=String(e.scheme).replace(n.PCT_ENCODED,t).toLowerCase().replace(n.NOT_SCHEME,"");if(e.userinfo!==undefined)e.userinfo=String(e.userinfo).replace(n.PCT_ENCODED,t).replace(n.NOT_USERINFO,m).replace(n.PCT_ENCODED,p);if(e.host!==undefined)e.host=String(e.host).replace(n.PCT_ENCODED,t).toLowerCase().replace(n.NOT_HOST,m).replace(n.PCT_ENCODED,p);if(e.path!==undefined)e.path=String(e.path).replace(n.PCT_ENCODED,t).replace(e.scheme?n.NOT_PATH:n.NOT_PATH_NOSCHEME,m).replace(n.PCT_ENCODED,p);if(e.query!==undefined)e.query=String(e.query).replace(n.PCT_ENCODED,t).replace(n.NOT_QUERY,m).replace(n.PCT_ENCODED,p);if(e.fragment!==undefined)e.fragment=String(e.fragment).replace(n.PCT_ENCODED,t).replace(n.NOT_FRAGMENT,m).replace(n.PCT_ENCODED,p);return e}function w(e){return e.replace(/^0*(.*)/,"$1")||"0"}function S(e,t){var n=e.match(t.IPV4ADDRESS)||[];var i=A(n,2),o=i[1];if(o)return o.split(".").map(w).join(".");else return e}function ee(e,t){var n=e.match(t.IPV6ADDRESS)||[];var i=A(n,3),o=i[1],r=i[2];if(o){var s=o.toLowerCase().split("::").reverse(),a=A(s,2),l=a[0],c=a[1];var h=c?c.split(":").map(w):[];var d=l.split(":").map(w);var u=t.IPV4ADDRESS.test(d[d.length-1]);var g=u?7:8;var p=d.length-g;var m=Array(g);for(var f=0;f<g;++f)m[f]=h[f]||d[p+f]||"";if(u)m[g-1]=S(m[g-1],t);var C=m.reduce(function(e,t,n){if(!t||t==="0"){var i=e[e.length-1];if(i&&i.index+i.length===n)i.length++;else e.push({index:n,length:1})}return e},[]);var y=C.sort(function(e,t){return t.length-e.length})[0];var v=void 0;if(y&&y.length>1){var I=m.slice(0,y.index);var b=m.slice(y.index+y.length);v=I.join(":")+"::"+b.join(":")}else v=m.join(":");if(r)v+="%"+r;return v}else return e}var te=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,ne="".match(/(){0}/)[1]===undefined;function s(e){var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var n={};var i=t.iri!==false?l:a;if(t.reference==="suffix")e=(t.scheme?t.scheme+":":"")+"//"+e;var o=e.match(te);if(o){if(ne){n.scheme=o[1];n.userinfo=o[3];n.host=o[4];n.port=parseInt(o[5],10);n.path=o[6]||"";n.query=o[7];n.fragment=o[8];if(isNaN(n.port))n.port=o[5]}else{n.scheme=o[1]||undefined;n.userinfo=e.indexOf("@")!==-1?o[3]:undefined;n.host=e.indexOf("//")!==-1?o[4]:undefined;n.port=parseInt(o[5],10);n.path=o[6]||"";n.query=e.indexOf("?")!==-1?o[7]:undefined;n.fragment=e.indexOf("#")!==-1?o[8]:undefined;if(isNaN(n.port))n.port=e.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?o[4]:undefined}if(n.host)n.host=ee(S(n.host,i),i);if(n.scheme===undefined&&n.userinfo===undefined&&n.host===undefined&&n.port===undefined&&!n.path&&n.query===undefined)n.reference="same-document";else if(n.scheme===undefined)n.reference="relative";else if(n.fragment===undefined)n.reference="absolute";else n.reference="uri";if(t.reference&&t.reference!=="suffix"&&t.reference!==n.reference)n.error=n.error||"URI is not a "+t.reference+" reference.";var r=h[(t.scheme||n.scheme||"").toLowerCase()];if(!t.unicodeSupport&&(!r||!r.unicodeSupport)){if(n.host&&(t.domainHost||r&&r.domainHost))try{n.host=C.toASCII(n.host.replace(i.PCT_ENCODED,c).toLowerCase())}catch(e){n.error=n.error||"Host's domain name can not be converted to ASCII via punycode: "+e}d(n,a)}else d(n,i);if(r&&r.parse)r.parse(n,t)}else n.error=n.error||"URI can not be parsed.";return n}function ie(e,t){var n=t.iri!==false?l:a;var i=[];if(e.userinfo!==undefined){i.push(e.userinfo);i.push("@")}if(e.host!==undefined)i.push(ee(S(String(e.host),n),n).replace(n.IPV6ADDRESS,function(e,t,n){return"["+t+(n?"%25"+n:"")+"]"}));if(typeof e.port==="number"||typeof e.port==="string"){i.push(":");i.push(String(e.port))}return i.length?i.join(""):undefined}var oe=/^\.\.?\//,re=/^\/\.(\/|$)/,se=/^\/\.\.(\/|$)/,ae=/^\/?(?:.|\n)*?(?=\/|$)/;function u(e){var t=[];while(e.length)if(e.match(oe))e=e.replace(oe,"");else if(e.match(re))e=e.replace(re,"/");else if(e.match(se)){e=e.replace(se,"/");t.pop()}else if(e==="."||e==="..")e="";else{var n=e.match(ae);if(n){var i=n[0];e=e.slice(i.length);t.push(i)}else throw new Error("Unexpected dot segment condition")}return t.join("")}function g(t){var n=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var e=n.iri?l:a;var i=[];var o=h[(n.scheme||t.scheme||"").toLowerCase()];if(o&&o.serialize)o.serialize(t,n);if(t.host)if(e.IPV6ADDRESS.test(t.host));else if(n.domainHost||o&&o.domainHost)try{t.host=!n.iri?C.toASCII(t.host.replace(e.PCT_ENCODED,c).toLowerCase()):C.toUnicode(t.host)}catch(e){t.error=t.error||"Host's domain name can not be converted to "+(!n.iri?"ASCII":"Unicode")+" via punycode: "+e}d(t,e);if(n.reference!=="suffix"&&t.scheme){i.push(t.scheme);i.push(":")}var r=ie(t,n);if(r!==undefined){if(n.reference!=="suffix")i.push("//");i.push(r);if(t.path&&t.path.charAt(0)!=="/")i.push("/")}if(t.path!==undefined){var s=t.path;if(!n.absolutePath&&(!o||!o.absolutePath))s=u(s);if(r===undefined)s=s.replace(/^\/\//,"/%2F");i.push(s)}if(t.query!==undefined){i.push("?");i.push(t.query)}if(t.fragment!==undefined){i.push("#");i.push(t.fragment)}return i.join("")}function le(e,t){var n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var i=arguments[3];var o={};if(!i){e=s(g(e,n),n);t=s(g(t,n),n)}n=n||{};if(!n.tolerant&&t.scheme){o.scheme=t.scheme;o.userinfo=t.userinfo;o.host=t.host;o.port=t.port;o.path=u(t.path||"");o.query=t.query}else{if(t.userinfo!==undefined||t.host!==undefined||t.port!==undefined){o.userinfo=t.userinfo;o.host=t.host;o.port=t.port;o.path=u(t.path||"");o.query=t.query}else{if(!t.path){o.path=e.path;if(t.query!==undefined)o.query=t.query;else o.query=e.query}else{if(t.path.charAt(0)==="/")o.path=u(t.path);else{if((e.userinfo!==undefined||e.host!==undefined||e.port!==undefined)&&!e.path)o.path="/"+t.path;else if(!e.path)o.path=t.path;else o.path=e.path.slice(0,e.path.lastIndexOf("/")+1)+t.path;o.path=u(o.path)}o.query=t.query}o.userinfo=e.userinfo;o.host=e.host;o.port=e.port}o.scheme=e.scheme}o.fragment=t.fragment;return o}function ce(e,t,n){var i=x({scheme:"null"},n);return g(le(s(e,i),s(t,i),i,true),i)}function ue(e,t){if(typeof e==="string")e=g(s(e,t),t);else if(i(e)==="object")e=s(g(e,t),t);return e}function ge(e,t,n){if(typeof e==="string")e=g(s(e,n),n);else if(i(e)==="object")e=g(e,n);if(typeof t==="string")t=g(s(t,n),n);else if(i(t)==="object")t=g(t,n);return e===t}function pe(e,t){return e&&e.toString().replace(!t||!t.iri?a.ESCAPE:l.ESCAPE,m)}function y(e,t){return e&&e.toString().replace(!t||!t.iri?a.PCT_ENCODED:l.PCT_ENCODED,c)}var n={scheme:"http",domainHost:true,parse:function e(t,n){if(!t.host)t.error=t.error||"HTTP URIs must have a host.";return t},serialize:function e(t,n){var i=String(t.scheme).toLowerCase()==="https";if(t.port===(i?443:80)||t.port==="")t.port=undefined;if(!t.path)t.path="/";return t}},me={scheme:"https",domainHost:n.domainHost,parse:n.parse,serialize:n.serialize};function fe(e){return typeof e.secure==="boolean"?e.secure:String(e.scheme).toLowerCase()==="wss"}var o={scheme:"ws",domainHost:true,parse:function e(t,n){var i=t;i.secure=fe(i);i.resourceName=(i.path||"/")+(i.query?"?"+i.query:"");i.path=undefined;i.query=undefined;return i},serialize:function e(t,n){if(t.port===(fe(t)?443:80)||t.port==="")t.port=undefined;if(typeof t.secure==="boolean"){t.scheme=t.secure?"wss":"ws";t.secure=undefined}if(t.resourceName){var i=t.resourceName.split("?"),o=A(i,2),r=o[0],s=o[1];t.path=r&&r!=="/"?r:undefined;t.query=s;t.resourceName=undefined}t.fragment=undefined;return t}},Ce={scheme:"wss",domainHost:o.domainHost,parse:o.parse,serialize:o.serialize},ye={},ve,Ie="[A-Za-z0-9\\-\\.\\_\\~"+(true?"\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF":"")+"]",f="[0-9A-Fa-f]",be=de(de("%[EFef]"+f+"%"+f+f+"%"+f+f)+"|"+de("%[89A-Fa-f]"+f+"%"+f+f)+"|"+de("%"+f+f)),Ae="[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]",we,Se=he("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),xe="[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]",ke=new RegExp(Ie,"g"),v=new RegExp(be,"g"),Ee=new RegExp(he("[^]",Ae,"[\\.]",'[\\"]',Se),"g"),Te=new RegExp(he("[^]",Ie,xe),"g"),Re=Te;function I(e){var t=c(e);return!t.match(ke)?e:t}var _e={scheme:"mailto",parse:function e(t,n){var i=t;var o=i.to=i.path?i.path.split(","):[];i.path=undefined;if(i.query){var r=false;var s={};var a=i.query.split("&");for(var l=0,c=a.length;l<c;++l){var h=a[l].split("=");switch(h[0]){case"to":var d=h[1].split(",");for(var u=0,g=d.length;u<g;++u)o.push(d[u]);break;case"subject":i.subject=y(h[1],n);break;case"body":i.body=y(h[1],n);break;default:r=true;s[y(h[0],n)]=y(h[1],n);break}}if(r)i.headers=s}i.query=undefined;for(var p=0,m=o.length;p<m;++p){var f=o[p].split("@");f[0]=y(f[0]);if(!n.unicodeSupport)try{f[1]=C.toASCII(y(f[1],n).toLowerCase())}catch(e){i.error=i.error||"Email address's domain name can not be converted to ASCII via punycode: "+e}else f[1]=y(f[1],n).toLowerCase();o[p]=f.join("@")}return i},serialize:function e(t,n){var i=t;var o=b(t.to);if(o){for(var r=0,s=o.length;r<s;++r){var a=String(o[r]);var l=a.lastIndexOf("@");var c=a.slice(0,l).replace(v,I).replace(v,p).replace(Ee,m);var h=a.slice(l+1);try{h=!n.iri?C.toASCII(y(h,n).toLowerCase()):C.toUnicode(h)}catch(e){i.error=i.error||"Email address's domain name can not be converted to "+(!n.iri?"ASCII":"Unicode")+" via punycode: "+e}o[r]=c+"@"+h}i.path=o.join(",")}var d=t.headers=t.headers||{};if(t.subject)d["subject"]=t.subject;if(t.body)d["body"]=t.body;var u=[];for(var g in d)if(d[g]!==ye[g])u.push(g.replace(v,I).replace(v,p).replace(Te,m)+"="+d[g].replace(v,I).replace(v,p).replace(Re,m));if(u.length)i.query=u.join("&");return i}},$e=/^([^\:]+)\:(.*)/,Le={scheme:"urn",parse:function e(t,n){var i=t.path&&t.path.match($e);var o=t;if(i){var r=n.scheme||o.scheme||"urn";var s=i[1].toLowerCase();var a=i[2];var l=r+":"+(n.nid||s);var c=h[l];o.nid=s;o.nss=a;o.path=undefined;if(c)o=c.parse(o,n)}else o.error=o.error||"URN can not be parsed.";return o},serialize:function e(t,n){var i=n.scheme||t.scheme||"urn";var o=t.nid;var r=i+":"+(n.nid||o);var s=h[r];if(s)t=s.serialize(t,n);var a=t;var l=t.nss;a.path=(o||n.nid)+":"+l;return a}},Ne=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,Me={scheme:"urn:uuid",parse:function e(t,n){var i=t;i.uuid=i.nss;i.nss=undefined;if(!n.tolerant&&(!i.uuid||!i.uuid.match(Ne)))i.error=i.error||"UUID is not valid.";return i},serialize:function e(t,n){var i=t;i.nss=(t.uuid||"").toLowerCase();return i}};h[n.scheme]=n,h[me.scheme]=me,h[o.scheme]=o,h[Ce.scheme]=Ce,h[_e.scheme]=_e,h[Le.scheme]=Le,h[Me.scheme]=Me,e.SCHEMES=h,e.pctEncChar=m,e.pctDecChars=c,e.parse=s,e.removeDotSegments=u,e.serialize=g,e.resolveComponents=le,e.resolve=ce,e.normalize=ue,e.equal=ge,e.escapeComponent=pe,e.unescapeComponent=y,Object.defineProperty(e,"__esModule",{value:true})}(t)},4049:function(e){e.exports=function(){"use strict";var s=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},e=function(){function i(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||false;i.configurable=true;if("value"in i)i.writable=true;Object.defineProperty(e,i.key,i)}}return function(e,t,n){if(t)i(e.prototype,t);if(n)i(e,n);return e}}(),m=function(){function n(e,t){var n=[];var i=true;var o=false;var r=undefined;try{for(var s=e[Symbol.iterator](),a;!(i=(a=s.next()).done);i=true){n.push(a.value);if(t&&n.length===t)break}}catch(e){o=true;r=e}finally{try{if(!i&&s["return"])s["return"]()}finally{if(o)throw r}}return n}return function(e,t){if(Array.isArray(e))return e;else if(Symbol.iterator in Object(e))return n(e,t);else throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),o=(String.prototype.startsWith=String.prototype.startsWith||function(e){return this.indexOf(e)===0},String.prototype.padStart=String.prototype.padStart||function(e,t){var n=this;while(n.length<e)n=t+n;return n},{cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"});function a(e){var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;var n=t>0?e.toFixed(t).replace(/0+$/,"").replace(/\.$/,""):e.toString();return n||"0"}var r=function(){function p(e,t,n,i){s(this,p);var g=this;function o(e){if(e.startsWith("hsl")){var t=e.match(/([\-\d\.e]+)/g).map(Number),n=m(t,4),i=n[0],o=n[1],r=n[2],s=n[3];if(s===undefined)s=1;i/=360;o/=100;r/=100;g.hsla=[i,o,r,s]}else if(e.startsWith("rgb")){var a=e.match(/([\-\d\.e]+)/g).map(Number),l=m(a,4),c=l[0],h=l[1],d=l[2],u=l[3];if(u===undefined)u=1;g.rgba=[c,h,d,u]}else if(e.startsWith("#"))g.rgba=p.hexToRgb(e);else g.rgba=p.nameToRgb(e)||p.hexToRgb(e)}if(e===undefined);else if(Array.isArray(e))this.rgba=e;else if(n===undefined){var r=e&&""+e;if(r)o(r.toLowerCase())}else this.rgba=[e,t,n,i===undefined?1:i]}e(p,[{key:"printRGB",value:function e(t){var n=t?this.rgba:this.rgba.slice(0,3),i=n.map(function(e,t){return a(e,t===3?3:0)});return t?"rgba("+i+")":"rgb("+i+")"}},{key:"printHSL",value:function e(t){var n=[360,100,100,1],i=["","%","%",""];var o=t?this.hsla:this.hsla.slice(0,3),r=o.map(function(e,t){return a(e*n[t],t===3?3:1)+i[t]});return t?"hsla("+r+")":"hsl("+r+")"}},{key:"printHex",value:function e(t){var n=this.hex;return t?n:n.substring(0,7)}},{key:"rgba",get:function e(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=p.hslToRgb(this._hsla)},set:function e(t){if(t.length===3)t[3]=1;this._rgba=t;this._hsla=null}},{key:"rgbString",get:function e(){return this.printRGB()}},{key:"rgbaString",get:function e(){return this.printRGB(true)}},{key:"hsla",get:function e(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=p.rgbToHsl(this._rgba)},set:function e(t){if(t.length===3)t[3]=1;this._hsla=t;this._rgba=null}},{key:"hslString",get:function e(){return this.printHSL()}},{key:"hslaString",get:function e(){return this.printHSL(true)}},{key:"hex",get:function e(){var t=this.rgba,n=t.map(function(e,t){return t<3?e.toString(16):Math.round(e*255).toString(16)});return"#"+n.map(function(e){return e.padStart(2,"0")}).join("")},set:function e(t){this.rgba=p.hexToRgb(t)}}],[{key:"hexToRgb",value:function e(t){var n=(t.startsWith("#")?t.slice(1):t).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!n.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+t);var i=n.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(e){return parseInt(e,16)});i[3]=i[3]/255;return i}},{key:"nameToRgb",value:function e(t){var n=t.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght","L").replace("rk","D").slice(-5,4),i=o[n];return i===undefined?i:p.hexToRgb(i.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function e(t){var n=m(t,4),i=n[0],o=n[1],r=n[2],s=n[3];i/=255;o/=255;r/=255;var a=Math.max(i,o,r),l=Math.min(i,o,r);var c=void 0,h=void 0,d=(a+l)/2;if(a===l)c=h=0;else{var u=a-l;h=d>.5?u/(2-a-l):u/(a+l);switch(a){case i:c=(o-r)/u+(o<r?6:0);break;case o:c=(r-i)/u+2;break;case r:c=(i-o)/u+4;break}c/=6}return[c,h,d,s]}},{key:"hslToRgb",value:function e(t){var n=m(t,4),i=n[0],o=n[1],r=n[2],s=n[3];var a=void 0,l=void 0,c=void 0;if(o===0)a=l=c=r;else{var h=function e(t,n,i){if(i<0)i+=1;if(i>1)i-=1;if(i<1/6)return t+(n-t)*6*i;if(i<1/2)return n;if(i<2/3)return t+(n-t)*(2/3-i)*6;return t};var d=r<.5?r*(1+o):r+o-r*o,u=2*r-d;a=h(u,d,i+1/3);l=h(u,d,i);c=h(u,d,i-1/3)}var g=[a*255,l*255,c*255].map(Math.round);g[3]=s;return g}}]);return p}(),n=function(){function r(){s(this,r);this._events=[]}e(r,[{key:"add",value:function e(t,n,i){t.addEventListener(n,i,false);this._events.push({target:t,type:n,handler:i})}},{key:"remove",value:function e(n,i,o){this._events=this._events.filter(function(e){var t=true;if(n&&n!==e.target)t=false;if(i&&i!==e.type)t=false;if(o&&o!==e.handler)t=false;if(t)r._doRemove(e.target,e.type,e.handler);return!t})}},{key:"destroy",value:function e(){this._events.forEach(function(e){return r._doRemove(e.target,e.type,e.handler)});this._events=[]}}],[{key:"_doRemove",value:function e(t,n,i){t.removeEventListener(n,i,false)}}]);return r}();function l(e){var t=document.createElement("div");t.innerHTML=e;return t.firstElementChild}function c(e,h,d){var u=false;function g(e,t,n){return Math.max(t,Math.min(e,n))}function i(e,t,n){if(n)u=true;if(!u)return;e.preventDefault();var i=h.getBoundingClientRect(),o=i.width,r=i.height,s=t.clientX,a=t.clientY;var l=g(s-i.left,0,o),c=g(a-i.top,0,r);d(l/o,c/r)}function t(e,t){var n=e.buttons===undefined?e.which:e.buttons;if(n===1)i(e,e,t);else u=false}function n(e,t){if(e.touches.length===1)i(e,e.touches[0],t);else u=false}e.add(h,"mousedown",function(e){t(e,true)});e.add(h,"touchstart",function(e){n(e,true)});e.add(window,"mousemove",t);e.add(h,"touchmove",n);e.add(window,"mouseup",function(e){u=false});e.add(h,"touchend",function(e){u=false});e.add(h,"touchcancel",function(e){u=false})}var b="linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0 / 2em 2em,\n                   linear-gradient(45deg, lightgrey 25%,       white 25%,       white 75%, lightgrey 75%) 1em 1em / 2em 2em",A=360,h="keydown",d="mousedown",u="focusin";function w(e,t){return(t||document).querySelector(e)}function g(e){e.preventDefault();e.stopPropagation()}function p(e,t,n,i,o){e.add(t,h,function(e){if(n.indexOf(e.key)>=0){if(o)g(e);i(e)}})}var t=function(){function t(e){s(this,t);this.settings={popup:"right",layout:"default",alpha:true,editor:true,editorFormat:"hex",cancelButton:false,defaultColor:"#0cf"};this._events=new n;this.onChange=null;this.onDone=null;this.onOpen=null;this.onClose=null;this.setOptions(e)}e(t,[{key:"setOptions",value:function e(t){var n=this;if(!t)return;var i=this.settings;function o(e,t,n){for(var i in e){if(n&&n.indexOf(i)>=0)continue;t[i]=e[i]}}if(t instanceof HTMLElement)i.parent=t;else{if(i.parent&&t.parent&&i.parent!==t.parent){this._events.remove(i.parent);this._popupInited=false}o(t,i);if(t.onChange)this.onChange=t.onChange;if(t.onDone)this.onDone=t.onDone;if(t.onOpen)this.onOpen=t.onOpen;if(t.onClose)this.onClose=t.onClose;var r=t.color||t.colour;if(r)this._setColor(r)}var s=i.parent;if(s&&i.popup&&!this._popupInited){var a=function e(t){return n.openHandler(t)};this._events.add(s,"click",a);p(this._events,s,[" ","Spacebar","Enter"],a);this._popupInited=true}else if(t.parent&&!i.popup)this.show()}},{key:"openHandler",value:function e(t){if(this.show()){t&&t.preventDefault();this.settings.parent.style.pointerEvents="none";var n=t&&t.type===h?this._domEdit:this.domElement;setTimeout(function(){return n.focus()},100);if(this.onOpen)this.onOpen(this.colour)}}},{key:"closeHandler",value:function e(t){var n=t&&t.type;var i=false;if(!t)i=true;else if(n===d||n===u){var o=(this.__containedEvent||0)+100;if(t.timeStamp>o)i=true}else{g(t);i=true}if(i&&this.hide()){this.settings.parent.style.pointerEvents="";if(n!==d)this.settings.parent.focus();if(this.onClose)this.onClose(this.colour)}}},{key:"movePopup",value:function e(t,n){this.closeHandler();this.setOptions(t);if(n)this.openHandler()}},{key:"setColor",value:function e(t,n){this._setColor(t,{silent:n})}},{key:"_setColor",value:function e(t,n){if(typeof t==="string")t=t.trim();if(!t)return;n=n||{};var i=void 0;try{i=new r(t)}catch(e){if(n.failSilently)return;throw e}if(!this.settings.alpha){var o=i.hsla;o[3]=1;i.hsla=o}this.colour=this.color=i;this._setHSLA(null,null,null,null,n)}},{key:"setColour",value:function e(t,n){this.setColor(t,n)}},{key:"show",value:function e(){var t=this.settings.parent;if(!t)return false;if(this.domElement){var n=this._toggleDOM(true);this._setPosition();return n}var i=this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>';var o=l(i);this.domElement=o;this._domH=w(".picker_hue",o);this._domSL=w(".picker_sl",o);this._domA=w(".picker_alpha",o);this._domEdit=w(".picker_editor input",o);this._domSample=w(".picker_sample",o);this._domOkay=w(".picker_done button",o);this._domCancel=w(".picker_cancel button",o);o.classList.add("layout_"+this.settings.layout);if(!this.settings.alpha)o.classList.add("no_alpha");if(!this.settings.editor)o.classList.add("no_editor");if(!this.settings.cancelButton)o.classList.add("no_cancel");this._ifPopup(function(){return o.classList.add("popup")});this._setPosition();if(this.colour)this._updateUI();else this._setColor(this.settings.defaultColor);this._bindEvents();return true}},{key:"hide",value:function e(){return this._toggleDOM(false)}},{key:"destroy",value:function e(){this._events.destroy();if(this.domElement)this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function e(){var n=this;var i=this,o=this.domElement,r=this._events;function s(e,t,n){r.add(e,t,n)}s(o,"click",function(e){return e.preventDefault()});c(r,this._domH,function(e,t){return i._setHSLA(e)});c(r,this._domSL,function(e,t){return i._setHSLA(null,e,1-t)});if(this.settings.alpha)c(r,this._domA,function(e,t){return i._setHSLA(null,null,null,