/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2017 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 5.17.1
 * @date    2018-06-03
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(this,function(){return function(e){function t(i){if(n[i])return n[i].exports;var o=n[i]={exports:{},id:i,loaded:!1};return e[i].call(o.exports,o,o.exports,t),o.loaded=!0,o.exports}var n={};return t.m=e,t.c=n,t.p="",t(0)}([function(e,t,n){"use strict";function i(e,t,n){if(!(this instanceof i))throw new Error('JSONEditor constructor called without "new".');var o=a.getInternetExplorerVersion();if(-1!=o&&o<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");if(t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t)){var r=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onEditable","onError","onModeChange","onSelectionChange","onTextSelectionChange","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","languages","language"];Object.keys(t).forEach(function(e){-1===r.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})}arguments.length&&this._create(e,t,n)}var o;try{o=n(!function(){var e=new Error('Cannot find module "ajv"');throw e.code="MODULE_NOT_FOUND",e}())}catch(e){}var r=n(1),s=n(17),a=n(4);i.modes={},i.prototype.DEBOUNCE_INTERVAL=150,i.prototype._create=function(e,t,n){this.container=e,this.options=t||{},this.json=n||{};var i=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(i)},i.prototype.destroy=function(){},i.prototype.set=function(e){this.json=e},i.prototype.get=function(){return this.json},i.prototype.setText=function(e){this.json=a.parse(e)},i.prototype.getText=function(){return JSON.stringify(this.json)},i.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},i.prototype.getName=function(){return this.options&&this.options.name},i.prototype.setMode=function(e){var t,n,o=this.container,r=a.extend({},this.options),s=r.mode;r.mode=e;var l=i.modes[e];if(!l)throw new Error('Unknown mode "'+r.mode+'"');try{var c="text"==l.data;if(n=this.getName(),t=this[c?"getText":"get"](),this.destroy(),a.clear(this),a.extend(this,l.mixin),this.create(o,r),this.setName(n),this[c?"setText":"set"](t),"function"==typeof l.load)try{l.load.call(this)}catch(e){console.error(e)}if("function"==typeof r.onModeChange&&e!==s)try{r.onModeChange(e,s)}catch(e){console.error(e)}}catch(e){this._onError(e)}},i.prototype.getMode=function(){return this.options.mode},i.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},i.prototype.setSchema=function(e,t){if(e){var n;try{n=this.options.ajv||o({allErrors:!0,verbose:!0})}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(n){if(t){for(var i in t)n.removeSchema(i),t[i]&&n.addSchema(t[i],i);this.options.schemaRefs=t}this.validateSchema=n.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},i.prototype.validate=function(){},i.prototype.refresh=function(){},i.registerMode=function(e){var t,n;if(a.isArray(e))for(t=0;t<e.length;t++)i.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var o=e.mode;if(o in i.modes)throw new Error('Mode "'+o+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var r=["setMode","registerMode","modes"];for(t=0;t<r.length;t++)if((n=r[t])in e.mixin)throw new Error('Reserved property "'+n+'" not allowed in mixin');i.modes[o]=e}},i.registerMode(r),i.registerMode(s),e.exports=i},function(e,t,n){"use strict";var i=n(2),o=n(3),r=n(6),s=n(7),a=n(9),l=n(10),c=n(15),d=n(4),h=n(16),u=n(8).translate,p=n(8).setLanguages,m=n(8).setLanguage,f={};f.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new i,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=new h(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new o(this)),this._createFrame(),this._createTable()},f.destroy=function(){this.frame&&this.container&&this.frame.parentNode==this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},f._setOptions=function(e){if(this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,onSelectionChange:null},e)for(var t in e)e.hasOwnProperty(t)&&(this.options[t]=e[t]);this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=d.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),e.onSelectionChange&&this.onSelectionChange(e.onSelectionChange),p(this.options.languages),m(this.options.language)},f.set=function(e,t){if(t&&(console.warn('Second parameter "name" is deprecated. Use setName(name) instead.'),this.options.name=t),e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var n={field:this.options.name,value:e},i=new l(this,n);this._setRoot(i),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},f.get=function(){if(this.focusTarget){var e=l.getNodeFromTarget(this.focusTarget);e&&e.blur()}return this.node?this.node.getValue():void 0},f.getText=function(){return JSON.stringify(this.get())},f.setText=function(e){try{this.set(d.parse(e))}catch(n){var t=d.sanitize(e);this.set(d.parse(t))}},f.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},f.getName=function(){return this.options.name},f.focus=function(){var e=this.content.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},f.clear=function(){this.node&&(this.node.collapse(),this.tbody.removeChild(this.node.getDom()),delete this.node),this.treePath&&this.treePath.reset()},f._setRoot=function(e){this.clear(),this.node=e,this.tbody.appendChild(e.getDom())},f.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},f.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},f.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},f._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},f._onChange=function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}},f.validate=function(){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var e=this.node;if(e){var t=e.validate(),n=[];if(this.validateSchema){this.validateSchema(e.getValue())||(n=this.validateSchema.errors.map(function(e){return d.improveSchemaError(e)}).map(function(t){return{node:e.findNode(t.dataPath),error:t}}).filter(function(e){return null!=e.node}))}var i=t.concat(n),o=i.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=o.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(i).map(function(e){return e.node.setError(e.error,e.child),e.node})}},f.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},f.startAutoScroll=function(e){var t=this,n=this.content,i=d.getAbsoluteTop(n),o=n.clientHeight,r=i+o;e<i+24&&n.scrollTop>0?this.autoScrollStep=(i+24-e)/3:e>r-24&&o+n.scrollTop<n.scrollHeight?this.autoScrollStep=(r-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?n.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},f.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},f.setDomSelection=function(e){e&&("scrollTop"in e&&this.content&&(this.content.scrollTop=e.scrollTop),e.nodes&&this.select(e.nodes),e.range&&d.setSelectionOffset(e.range),e.dom&&e.dom.focus())},f.getDomSelection=function(){var e=d.getSelectionOffset();return e&&"DIV"!==e.container.nodeName&&(e=null),{dom:this.focusTarget,range:e,nodes:this.multiselection.nodes.slice(0),scrollTop:this.content?this.content.scrollTop:0}},f.scrollTo=function(e,t){var n=this.content;if(n){var i=this;i.animateTimeout&&(clearTimeout(i.animateTimeout),delete i.animateTimeout),i.animateCallback&&(i.animateCallback(!1),delete i.animateCallback);var o=n.clientHeight,r=n.scrollHeight-o,s=Math.min(Math.max(e-o/4,0),r),a=function(){var e=n.scrollTop,o=s-e;Math.abs(o)>3?(n.scrollTop+=o/3,i.animateCallback=t,i.animateTimeout=setTimeout(a,50)):(t&&t(!0),n.scrollTop=s,delete i.animateTimeout,delete i.animateCallback)};a()}else t&&t(!1)},f._createFrame=function(){function e(e){t._onEvent&&t._onEvent(e)}this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame);var t=this;this.frame.onclick=function(t){var n=t.target;e(t),"BUTTON"==n.nodeName&&t.preventDefault()},this.frame.oninput=e,this.frame.onchange=e,this.frame.onkeydown=e,this.frame.onkeyup=e,this.frame.oncut=e,this.frame.onpaste=e,this.frame.onmousedown=e,this.frame.onmouseup=e,this.frame.onmouseover=e,this.frame.onmouseout=e,d.addEventListener(this.frame,"focus",e,!0),d.addEventListener(this.frame,"blur",e,!0),this.frame.onfocusin=e,this.frame.onfocusout=e,this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var n=document.createElement("button");n.type="button",n.className="jsoneditor-expand-all",n.title=u("expandAll"),n.onclick=function(){t.expandAll()},this.menu.appendChild(n);var i=document.createElement("button");if(i.type="button",i.title=u("collapseAll"),i.className="jsoneditor-collapse-all",i.onclick=function(){t.collapseAll()},this.menu.appendChild(i),this.history){var o=document.createElement("button");o.type="button",o.className="jsoneditor-undo jsoneditor-separator",o.title=u("undo"),o.onclick=function(){t._onUndo()},this.menu.appendChild(o),this.dom.undo=o;var s=document.createElement("button");s.type="button",s.className="jsoneditor-redo",s.title=u("redo"),s.onclick=function(){t._onRedo()},this.menu.appendChild(s),this.dom.redo=s,this.history.onChange=function(){o.disabled=!t.history.canUndo(),s.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var l=this;this.modeSwitcher=new c(this.menu,this.options.modes,this.options.mode,function(e){l.modeSwitcher.destroy(),l.setMode(e),l.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new r(this,this.menu)),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new a(this.navBar),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},f._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},f._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},f._onEvent=function(e){"keydown"===e.type&&this._onKeyDown(e),"focus"===e.type&&(this.focusTarget=e.target),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e);var t=l.getNodeFromTarget(e.target);if(t&&this.options&&this.options.navigationBar&&t&&("keydown"===e.type||"mousedown"===e.type)){var n=this;setTimeout(function(){n._updateTreePath(t.getNodePath())})}if(t&&t.selected){if("click"===e.type){if(e.target===t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&l.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&(this.deselect(),t&&e.target===t.dom.drag?l.onDragStart(t,e):(!t||e.target!==t.dom.field&&e.target!==t.dom.value&&e.target!==t.dom.select)&&this._onMultiSelectStart(e));t&&t.onEvent(e)},f._updateTreePath=function(e){function t(e){return void 0!==e.field?e._escapeHTML(e.field):isNaN(e.index)?e.type:e.index}if(e&&e.length){d.removeClassName(this.navBar,"nav-bar-empty");var n=[];e.forEach(function(e){var i={name:t(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){i.children.push({name:t(e),node:e})}),n.push(i)}),this.treePath.setPath(n)}else d.addClassName(this.navBar,"nav-bar-empty")},f._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},f._onTreePathMenuItemSelected=function(e,t){if(e&&e.children.length){var n=e.children.find(function(e){return e.name===t});n&&n.node&&(this._updateTreePath(n.node.getNodePath()),n.node.expandTo(),n.node.focus())}},f._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},f._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,n=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+n*n),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||this.dragDistanceEvent.dragDistance>10,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},f._onMultiSelectStart=function(e){var t=l.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var n=this;this.mousemove||(this.mousemove=d.addEventListener(window,"mousemove",function(e){n._onMultiSelect(e)})),this.mouseup||(this.mouseup=d.addEventListener(window,"mouseup",function(e){n._onMultiSelectEnd(e)}))}},f._onMultiSelect=function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=l.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var n=this.multiselection.start,i=this.multiselection.end||this.multiselection.start;if(n&&i){if(this.multiselection.nodes=this._findTopLevelNodes(n,i),this.multiselection.nodes&&this.multiselection.nodes.length){var o=this.multiselection.nodes[0];this.multiselection.start===o||this.multiselection.start.isDescendantOf(o)?this.multiselection.direction="down":this.multiselection.direction="up"}this.select(this.multiselection.nodes)}}},f._onMultiSelectEnd=function(e){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(d.removeEventListener(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(d.removeEventListener(window,"mouseup",this.mouseup),delete this.mouseup)},f.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},f.select=function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];if(e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler){var n=this.getSelection();this._selectionChangedHandler(n.start,n.end)}}},f._findTopLevelNodes=function(e,t){for(var n=e.getNodePath(),i=t.getNodePath(),o=0;o<n.length&&n[o]===i[o];)o++;var r=n[o-1],s=n[o],a=i[o];if(s&&a||(r.parent?(s=r,a=r,r=r.parent):(s=r.childs[0],a=r.childs[r.childs.length-1])),r&&s&&a){var l=r.childs.indexOf(s),c=r.childs.indexOf(a),d=Math.min(l,c),h=Math.max(l,c);return r.childs.slice(d,h+1)}return[]},f._onKeyDown=function(e){var t=e.which||e.keyCode,n=e.altKey,i=e.ctrlKey,o=e.metaKey,r=e.shiftKey,s=!1;if(9==t){var a=this;setTimeout(function(){d.selectContentEditable(a.focusTarget)},0)}if(this.searchBox)if(i&&70==t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),s=!0;else if(114==t||i&&71==t){r?this.searchBox.previous(!0):this.searchBox.next(!0),s=!0}if(this.history&&(i&&!r&&90==t?(this._onUndo(),s=!0):i&&r&&90==t&&(this._onRedo(),s=!0)),this.options.autocomplete&&!s&&!(i||n||o||1!=e.key.length&&8!=t&&46!=t)){s=!1;var c="";e.target.className.indexOf("jsoneditor-value")>=0&&(c="value"),e.target.className.indexOf("jsoneditor-field")>=0&&(c="field");var h=l.getNodeFromTarget(e.target);setTimeout(function(e,t){if(t.innerText.length>0){var n=this.options.autocomplete.getOptions(t.innerText,e.getPath(),c,e.editor);null===n?this.autocomplete.hideDropDown():"function"==typeof n.then?n.then(function(e){null===e?this.autocomplete.hideDropDown():e.options?this.autocomplete.show(t,e.startFrom,e.options):this.autocomplete.show(t,0,e)}.bind(this)):n.options?this.autocomplete.show(t,n.startFrom,n.options):this.autocomplete.show(t,0,n)}else this.autocomplete.hideDropDown()}.bind(this,h,e.target),50)}s&&(e.preventDefault(),e.stopPropagation())},f._createTable=function(){var e=document.createElement("div");e.className="jsoneditor-outer",this.options.navigationBar&&d.addClassName(e,"has-nav-bar"),this.contentOuter=e,this.content=document.createElement("div"),this.content.className="jsoneditor-tree",e.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table);var t;this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&(t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t)),t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t),t=document.createElement("col"),this.colgroupContent.appendChild(t),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(e)},f.showContextMenu=function(e,t){var n=[],i=this;n.push({text:u("duplicateText"),title:u("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){l.onDuplicate(i.multiselection.nodes)}}),n.push({text:u("remove"),title:u("removeTitle"),className:"jsoneditor-remove",click:function(){l.onRemove(i.multiselection.nodes)}}),new s(n,{close:t}).show(e,this.content)},f.getSelection=function(){var e={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var t=this.multiselection.nodes[0],n=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(e.start=t.serialize(),e.end=n.serialize()):(e.start=n.serialize(),e.end=t.serialize())}return e},f.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=d.debounce(e,this.DEBOUNCE_INTERVAL))},f.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is depracated and should not be used, see documantaion for supported selection options"),this.setDomSelection(e));var n=this._getNodeIntsncesByRange(e,t);n.forEach(function(e){e.expandTo()}),this.select(n)},f._getNodeIntsncesByRange=function(e,t){var n,i;e&&e.path&&(n=this.node.findNodeByPath(e.path),t&&t.path&&(i=this.node.findNodeByPath(t.path)));var o=[];if(n instanceof l)if(i instanceof l&&i!==n)if(n.parent===i.parent){var e,t;n.getIndex()<i.getIndex()?(e=n,t=i):(e=i,t=n);var r=e;o.push(r);do{r=r.nextSibling(),o.push(r)}while(r&&r!==t)}else o=this._findTopLevelNodes(n,i);else o.push(n);return o},f.getNodesByRange=function(e,t){var n=this._getNodeIntsncesByRange(e,t),i=[];return n.forEach(function(e){i.push(e.serialize())}),i},e.exports=[{mode:"tree",mixin:f,data:"json"},{mode:"view",mixin:f,data:"json"},{mode:"form",mixin:f,data:"json"}]},function(e,t){"use strict";function n(){this.locked=!1}n.prototype.highlight=function(e){this.locked||(this.node!=e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())},n.prototype.unhighlight=function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},n.prototype._cancelUnhighlight=function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)},n.prototype.lock=function(){this.locked=!0},n.prototype.unlock=function(){this.locked=!1},e.exports=n},function(e,t,n){"use strict";function i(e){this.editor=e,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){e.node.updateField(e.oldValue)},redo:function(e){e.node.updateField(e.newValue)}},editValue:{undo:function(e){e.node.updateValue(e.oldValue)},redo:function(e){e.node.updateValue(e.newValue)}},changeType:{undo:function(e){e.node.changeType(e.oldType)},redo:function(e){e.node.changeType(e.newType)}},appendNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){e.nodes.forEach(function(t){e.parent.appendChild(t)})}},insertBeforeNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){e.nodes.forEach(function(t){e.parent.insertBefore(t,e.beforeNode)})}},insertAfterNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){var t=e.afterNode;e.nodes.forEach(function(n){e.parent.insertAfter(e.node,t),t=n})}},removeNodes:{undo:function(e){var t=e.parent,n=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,n)})},redo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})}},duplicateNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){var t=e.afterNode;e.nodes.forEach(function(n){e.parent.insertAfter(n,t),t=n})}},moveNodes:{undo:function(e){e.nodes.forEach(function(t){e.oldBeforeNode.parent.moveBefore(t,e.oldBeforeNode)})},redo:function(e){e.nodes.forEach(function(t){e.newBeforeNode.parent.moveBefore(t,e.newBeforeNode)})}},sort:{undo:function(e){var t=e.node;t.hideChilds(),t.childs=e.oldChilds,t._updateDomIndexes(),t.showChilds()},redo:function(e){var t=e.node;t.hideChilds(),t.childs=e.newChilds,t._updateDomIndexes(),t.showChilds()}}}}n(4);i.prototype.onChange=function(){},i.prototype.add=function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()},i.prototype.clear=function(){this.history=[],this.index=-1,this.onChange()},i.prototype.canUndo=function(){return this.index>=0},i.prototype.canRedo=function(){return this.index<this.history.length-1},i.prototype.undo=function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.undo?(t.undo(e.params),e.params.oldSelection&&this.editor.setDomSelection(e.params.oldSelection)):console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}},i.prototype.redo=function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.redo?(t.redo(e.params),e.params.newSelection&&this.editor.setDomSelection(e.params.newSelection)):console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}},i.prototype.destroy=function(){this.editor=null,this.history=[],this.index=-1},e.exports=i},function(e,t,n){"use strict";var i=n(5);t.parse=function(e){try{return JSON.parse(e)}catch(n){throw t.validate(e),n}},t.sanitize=function(e){function t(){return e.charAt(s)}function n(){return e.charAt(s+1)}function i(){return e.charAt(s-1)}function o(n){r.push('"'),s++;for(var o=t();s<e.length&&o!==n;)'"'===o&&"\\"!==i()?r.push('\\"'):l.hasOwnProperty(o)?r.push(l[o]):"\\"===o?(s++,o=t(),"'"!==o&&r.push("\\"),r.push(o)):r.push(o),s++,o=t();o===n&&(r.push('"'),s++)}var r=[],s=0,a=e.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);a&&(e=a[3]);for(var l={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};s<e.length;){var c=t();"/"===c&&"*"===n()?function(){for(s+=2;s<e.length&&("*"!==t()||"/"!==n());)s++;s+=2}():"/"===c&&"/"===n()?function(){for(s+=2;s<e.length&&"\n"!==t();)s++}():" "===c||c>=" "&&c<=" "||" "===c||" "===c||"　"===c?(r.push(" "),s++):"'"===c?o("'"):'"'===c?o('"'):"`"===c?o("´"):"‘"===c?o("’"):"“"===c?o("”"):/[a-zA-Z_$]/.test(c)&&-1!==["{",","].indexOf(function(){for(var e=r.length-1;e>=0;){var t=r[e];if(" "!==t&&"\n"!==t&&"\r"!==t&&"\t"!==t)return t;e--}return""}())?function(){for(var e=["null","true","false"],n="",i=t(),o=/[a-zA-Z_$\d]/;o.test(i);)n+=i,s++,i=t();-1===e.indexOf(n)?r.push('"'+n+'"'):r.push(n)}():(r.push(c),s++)}return r.join("")},t.escapeUnicodeChars=function(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})},t.validate=function(e){void 0!==i?i.parse(e):JSON.parse(e)},t.extend=function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n]);return e},t.clear=function(e){for(var t in e)e.hasOwnProperty(t)&&delete e[t];return e},t.type=function(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp||"regexp"==typeof e?"regexp":t.isArray(e)?"array":"object"};var o=/^https?:\/\/\S+$/;t.isUrl=function(e){return("string"==typeof e||e instanceof String)&&o.test(e)},t.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)},t.getAbsoluteLeft=function(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0},t.getAbsoluteTop=function(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0},t.addClassName=function(e,t){var n=e.className.split(" ");-1==n.indexOf(t)&&(n.push(t),e.className=n.join(" "))},t.removeClassName=function(e,t){var n=e.className.split(" "),i=n.indexOf(t);-1!=i&&(n.splice(i,1),e.className=n.join(" "))},t.stripFormatting=function(e){for(var n=e.childNodes,i=0,o=n.length;i<o;i++){var r=n[i];r.style&&r.removeAttribute("style");var s=r.attributes;if(s)for(var a=s.length-1;a>=0;a--){var l=s[a];!0===l.specified&&r.removeAttribute(l.name)}t.stripFormatting(r)}},t.setEndOfContentEditable=function(e){var t,n;document.createRange&&(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),n=window.getSelection(),n.removeAllRanges(),n.addRange(t))},t.selectContentEditable=function(e){if(e&&"DIV"==e.nodeName){var t,n;window.getSelection&&document.createRange&&(n=document.createRange(),n.selectNodeContents(e),t=window.getSelection(),t.removeAllRanges(),t.addRange(n))}},t.getSelection=function(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null},t.setSelection=function(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}},t.getSelectionOffset=function(){var e=t.getSelection();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer==e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null},t.setSelectionOffset=function(e){if(document.createRange&&window.getSelection){if(window.getSelection()){var n=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),n.setStart(e.container.firstChild,e.startOffset),n.setEnd(e.container.firstChild,e.endOffset),t.setSelection(n)}}},t.getInnerText=function(e,n){if(void 0==n&&(n={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return n.flush()+e.nodeValue;if(e.hasChildNodes()){for(var i=e.childNodes,o="",r=0,s=i.length;r<s;r++){var a=i[r];if("DIV"==a.nodeName||"P"==a.nodeName){var l=i[r-1],c=l?l.nodeName:void 0;c&&"DIV"!=c&&"P"!=c&&"BR"!=c&&(o+="\n",n.flush()),o+=t.getInnerText(a,n),n.set("\n")}else"BR"==a.nodeName?(o+=n.flush(),n.set("\n")):o+=t.getInnerText(a,n)}return o}return"P"==e.nodeName&&-1!=t.getInternetExplorerVersion()?n.flush():""},t.getInternetExplorerVersion=function(){if(-1==r){var e=-1;if("Microsoft Internet Explorer"==navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})").exec(t)&&(e=parseFloat(RegExp.$1))}r=e}return r},t.isFirefox=function(){return-1!=navigator.userAgent.indexOf("Firefox")};var r=-1;t.addEventListener=function(e,n,i,o){if(e.addEventListener)return void 0===o&&(o=!1),"mousewheel"===n&&t.isFirefox()&&(n="DOMMouseScroll"),e.addEventListener(n,i,o),i;if(e.attachEvent){var r=function(){return i.call(e,window.event)};return e.attachEvent("on"+n,r),r}},t.removeEventListener=function(e,n,i,o){e.removeEventListener?(void 0===o&&(o=!1),"mousewheel"===n&&t.isFirefox()&&(n="DOMMouseScroll"),e.removeEventListener(n,i,o)):e.detachEvent&&e.detachEvent("on"+n,i)},t.parsePath=function e(t){var n,i;if(0===t.length)return[];var o=t.match(/^\.(\w+)/);if(o)n=o[1],i=t.substr(n.length+1);else{if("["!==t[0])throw new SyntaxError("Failed to parse path");var r=t.indexOf("]");if(-1===r)throw new SyntaxError("Character ] expected in path");if(1===r)throw new SyntaxError("Index expected after [");var s=t.substring(1,r);"'"===s[0]&&(s='"'+s.substring(1,s.length-1)+'"'),n="*"===s?s:JSON.parse(s),i=t.substr(r+1)}return[n].concat(e(i))},t.improveSchemaError=function(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(t=t.map(function(e){return JSON.stringify(e)}),t.length>5){var n=["("+(t.length-5)+" more...)"];t=t.slice(0,5),t.push(n)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e},t.insideRect=function(e,t,n){var i=void 0!==n?n:0;return t.left-i>=e.left&&t.right+i<=e.right&&t.top-i>=e.top&&t.bottom+i<=e.bottom},t.debounce=function(e,t,n){var i;return function(){var o=this,r=arguments,s=function(){i=null,n||e.apply(o,r)},a=n&&!i;clearTimeout(i),i=setTimeout(s,t),a&&e.apply(o,r)}},t.textDiff=function(e,t){for(var n=t.length,i=0,o=e.length,r=t.length;t.charAt(i)===e.charAt(i)&&i<n;)i++;for(;t.charAt(r-1)===e.charAt(o-1)&&r>i&&o>0;)r--,o--;return{start:i,end:r}},t.getInputSelection=function(e){function t(t){var n=e.value.substring(0,t);return{row:(n.match(/\n/g)||[]).length+1,column:n.length-n.lastIndexOf("\n")}}var n,i,o,r,s,a=0,l=0;return"number"==typeof e.selectionStart&&"number"==typeof e.selectionEnd?(a=e.selectionStart,l=e.selectionEnd):(i=document.selection.createRange())&&i.parentElement()==e&&(r=e.value.length,n=e.value.replace(/\r\n/g,"\n"),o=e.createTextRange(),o.moveToBookmark(i.getBookmark()),s=e.createTextRange(),s.collapse(!1),o.compareEndPoints("StartToEnd",s)>-1?a=l=r:(a=-o.moveStart("character",-r),a+=n.slice(0,a).split("\n").length-1,o.compareEndPoints("EndToEnd",s)>-1?l=r:(l=-o.moveEnd("character",-r),l+=n.slice(0,l).split("\n").length-1))),{startIndex:a,endIndex:l,start:t(a),end:t(l)}},t.getIndexForPosition=function(e,t,n){var i=e.value||"";if(t>0&&n>0){var o=i.split("\n",t);t=Math.min(o.length,t),n=Math.min(o[t-1].length,n-1);var r=1==t?n:n+1;return o.slice(0,t-1).join("\n").length+r}return-1},"undefined"!=typeof Element&&function(){function e(e){e.hasOwnProperty("remove")||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){null!=this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&e(Element.prototype),"undefined"!=typeof CharacterData&&e(CharacterData.prototype),"undefined"!=typeof DocumentType&&e(DocumentType.prototype)}(),String.prototype.startsWith||(String.prototype.startsWith=function(e,t){return t=t||0,this.substr(t,e.length)===e}),Array.prototype.find||(Array.prototype.find=function(e){for(var t=0;t<this.length;t++){var n=this[t];if(e.call(this,n,t,this))return n}})},function(e,t,n){var i=function(){var e={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,n,i,o,r,s){var a=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[a-1];case 13:this.$={};break;case 14:this.$=r[a-1];break;case 15:this.$=[r[a-2],r[a]];break;case 16:this.$={},this.$[r[a][0]]=r[a][1];break;case 17:this.$=r[a-2],r[a-2][r[a][0]]=r[a][1];break;case 18:this.$=[];break;case 19:this.$=r[a-1];break;case 20:this.$=[r[a]];break;case 21:this.$=r[a-2],r[a-2].push(r[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){function t(){var e;return e=n.lexer.lex()||1,"number"!=typeof e&&(e=n.symbols_[e]||e),e}var n=this,i=[0],o=[null],r=[],s=this.table,a="",l=0,c=0,d=0,h=2;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var u=this.lexer.yylloc;r.push(u),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var p,m,f,g,v,y,b,w,x,_={};;){if(f=i[i.length-1],this.defaultActions[f]?g=this.defaultActions[f]:(null==p&&(p=t()),g=s[f]&&s[f][p]),void 0===g||!g.length||!g[0]){if(!d){x=[];for(y in s[f])this.terminals_[y]&&y>2&&x.push("'"+this.terminals_[y]+"'");var C="";C=this.lexer.showPosition?"Parse error on line "+(l+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+x.join(", ")+", got '"+this.terminals_[p]+"'":"Parse error on line "+(l+1)+": Unexpected "+(1==p?"end of input":"'"+(this.terminals_[p]||p)+"'"),this.parseError(C,{text:this.lexer.match,token:this.terminals_[p]||p,line:this.lexer.yylineno,loc:u,expected:x})}if(3==d){if(1==p)throw new Error(C||"Parsing halted.");c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,p=t()}for(;;){if(h.toString()in s[f])break;if(0==f)throw new Error(C||"Parsing halted.");!function(e){i.length=i.length-2*e,o.length=o.length-e,r.length=r.length-e}(1),f=i[i.length-1]}m=p,p=h,f=i[i.length-1],g=s[f]&&s[f][h],d=3}if(g[0]instanceof Array&&g.length>1)throw new Error("Parse Error: multiple actions possible at state: "+f+", token: "+p);switch(g[0]){case 1:i.push(p),o.push(this.lexer.yytext),r.push(this.lexer.yylloc),i.push(g[1]),p=null,m?(p=m,m=null):(c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,d>0&&d--);break;case 2:if(b=this.productions_[g[1]][1],_.$=o[o.length-b],_._$={first_line:r[r.length-(b||1)].first_line,last_line:r[r.length-1].last_line,first_column:r[r.length-(b||1)].first_column,last_column:r[r.length-1].last_column},void 0!==(v=this.performAction.call(_,a,c,l,this.yy,g[1],o,r)))return v;b&&(i=i.slice(0,-1*b*2),o=o.slice(0,-1*b),r=r.slice(0,-1*b)),i.push(this.productions_[g[1]][0]),o.push(_.$),r.push(_._$),w=s[i[i.length-2]][i[i.length-1]],i.push(w);break;case 3:return!0}}return!0}},t=function(){var e={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(e.length>20?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(e.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0);var e,t,n,i,o;this._more||(this.yytext="",this.match="");for(var r=this._currentRules(),s=0;s<r.length&&(!(n=this._input.match(this.rules[r[s]]))||t&&!(n[0].length>t[0].length)||(t=n,i=s,this.options.flex));s++);return t?(o=t[0].match(/\n.*/g),o&&(this.yylineno+=o.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:o?o[o.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,r[i],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)}};return e.options={},e.performAction=function(e,t,n,i){switch(n){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},e.rules=[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt\/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],e.conditions={INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}},e}();return e.lexer=t,e}();t.parser=i,t.parse=i.parse.bind(i)},function(e,t){"use strict";function n(e,t){var n=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.dom={},this.dom.container=t;var i=document.createElement("table");this.dom.table=i,i.className="jsoneditor-search",t.appendChild(i);var o=document.createElement("tbody");this.dom.tbody=o,i.appendChild(o);var r=document.createElement("tr");o.appendChild(r);var s=document.createElement("td");r.appendChild(s);var a=document.createElement("div");this.dom.results=a,a.className="jsoneditor-results",s.appendChild(a),s=document.createElement("td"),r.appendChild(s);var l=document.createElement("div");this.dom.input=l,l.className="jsoneditor-frame",l.title="Search fields and values",s.appendChild(l);var c=document.createElement("table");l.appendChild(c);var d=document.createElement("tbody");c.appendChild(d),r=document.createElement("tr"),d.appendChild(r);var h=document.createElement("button");h.type="button",h.className="jsoneditor-refresh",s=document.createElement("td"),s.appendChild(h),r.appendChild(s);var u=document.createElement("input");this.dom.search=u,u.oninput=function(e){n._onDelayedSearch(e)},u.onchange=function(e){n._onSearch()},u.onkeydown=function(e){n._onKeyDown(e)},u.onkeyup=function(e){n._onKeyUp(e)},h.onclick=function(e){u.select()},s=document.createElement("td"),s.appendChild(u),r.appendChild(s);var p=document.createElement("button");p.type="button",p.title="Next result (Enter)",p.className="jsoneditor-next",p.onclick=function(){n.next()},s=document.createElement("td"),s.appendChild(p),r.appendChild(s);var m=document.createElement("button");m.type="button",m.title="Previous result (Shift+Enter)",m.className="jsoneditor-previous",m.onclick=function(){n.previous()},s=document.createElement("td"),s.appendChild(m),r.appendChild(s)}n.prototype.next=function(e){if(void 0!=this.results){var t=void 0!=this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}},n.prototype.previous=function(e){if(void 0!=this.results){var t=this.results.length-1,n=void 0!=this.resultIndex?this.resultIndex-1:t;n<0&&(n=t),this._setActiveResult(n,e)}},n.prototype._setActiveResult=function(e,t){if(this.activeResult){var n=this.activeResult.node;"field"==this.activeResult.elem?delete n.searchFieldActive:delete n.searchValueActive,n.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var i=this.results[this.resultIndex].node,o=this.results[this.resultIndex].elem;"field"==o?i.searchFieldActive=!0:i.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],i.updateDom(),i.scrollTo(function(){t&&i.focus(o)})},n.prototype._clearDelay=function(){void 0!=this.timeout&&(clearTimeout(this.timeout),delete this.timeout)},n.prototype._onDelayedSearch=function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)},n.prototype._onSearch=function(e){this._clearDelay();var t=this.dom.search.value,n=t.length>0?t:void 0;if(n!==this.lastText||e){this.lastText=n,this.results=this.editor.search(n);var i=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0;if(this._setActiveResult(0,!1),void 0!==n){var o=this.results.length;this.dom.results.innerHTML=0===o?"no&nbsp;results":1===o?"1&nbsp;result":o>i?i+"+&nbsp;results":o+"&nbsp;results"}else this.dom.results.innerHTML=""}},n.prototype._onKeyDown=function(e){var t=e.which;27==t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13==t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())},n.prototype._onKeyUp=function(e){var t=e.keyCode;27!=t&&13!=t&&this._onDelayedSearch(e)},n.prototype.clear=function(){this.dom.search.value="",this._onSearch()},n.prototype.destroy=function(){this.editor=null,this.dom.container.removeChild(this.dom.table),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()},e.exports=n},function(e,t,n){"use strict";function i(e){return e.getRootNode&&e.getRootNode()||window}function o(e,t){function n(e,t,o){o.forEach(function(o){if("separator"==o.type){var r=document.createElement("div");r.className="jsoneditor-separator",l=document.createElement("li"),l.appendChild(r),e.appendChild(l)}else{var a={},l=document.createElement("li");e.appendChild(l);var c=document.createElement("button");if(c.type="button",c.className=o.className,a.button=c,o.title&&(c.title=o.title),o.click&&(c.onclick=function(e){e.preventDefault(),i.hide(),o.click()}),l.appendChild(c),o.submenu){var d=document.createElement("div");d.className="jsoneditor-icon",c.appendChild(d);var h=document.createElement("div");h.className="jsoneditor-text"+(o.click?"":" jsoneditor-right-margin"),h.appendChild(document.createTextNode(o.text)),c.appendChild(h);var u;if(o.click){c.className+=" jsoneditor-default";var p=document.createElement("button");p.type="button",a.buttonExpand=p,p.className="jsoneditor-expand",p.innerHTML='<div class="jsoneditor-expand"></div>',l.appendChild(p),o.submenuTitle&&(p.title=o.submenuTitle),u=p}else{var m=document.createElement("div");m.className="jsoneditor-expand",c.appendChild(m),u=c}u.onclick=function(e){e.preventDefault(),i._onExpandItem(a),u.focus()};var f=[];a.subItems=f;var g=document.createElement("ul");a.ul=g,g.className="jsoneditor-menu",g.style.height="0",l.appendChild(g),n(g,f,o.submenu)}else c.innerHTML='<div class="jsoneditor-icon"></div><div class="jsoneditor-text">'+s(o.text)+"</div>";t.push(a)}})}this.dom={};var i=this,o=this.dom;this.anchor=void 0,this.items=e,this.eventListeners={},this.selection=void 0,this.onClose=t?t.close:void 0;var r=document.createElement("div");r.className="jsoneditor-contextmenu-root",o.root=r;var a=document.createElement("div");a.className="jsoneditor-contextmenu",o.menu=a,r.appendChild(a);var l=document.createElement("ul");l.className="jsoneditor-menu",a.appendChild(l),o.list=l,o.items=[];var c=document.createElement("button");c.type="button",o.focusButton=c;var d=document.createElement("li");d.style.overflow="hidden",d.style.height="0",d.appendChild(c),l.appendChild(d),n(l,this.dom.items,e),this.maxHeight=0,e.forEach(function(t){var n=24*(e.length+(t.submenu?t.submenu.length:0));i.maxHeight=Math.max(i.maxHeight,n)})}var r=n(4),s=n(8).translate;o.prototype._getVisibleButtons=function(){var e=[],t=this;return this.dom.items.forEach(function(n){e.push(n.button),n.buttonExpand&&e.push(n.buttonExpand),n.subItems&&n==t.expandedItem&&n.subItems.forEach(function(t){e.push(t.button),t.buttonExpand&&e.push(t.buttonExpand)})}),e},o.visibleMenu=void 0,o.prototype.show=function(e,t){this.hide();var n=!0,s=e.parentNode,a=e.getBoundingClientRect(),l=s.getBoundingClientRect();if(t){var c=t.getBoundingClientRect();a.bottom+this.maxHeight<c.bottom||a.top-this.maxHeight>c.top&&(n=!1)}var d=a.left-l.left,h=a.top-l.top;if(n){var u=e.offsetHeight;this.dom.menu.style.left=d+"px",this.dom.menu.style.top=h+u+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left=d+"px",this.dom.menu.style.top=h+"px",this.dom.menu.style.bottom="0px";this.rootNode=i(e),s.insertBefore(this.dom.root,s.firstChild);var p=this,m=this.dom.list;this.eventListeners.mousedown=r.addEventListener(this.rootNode,"mousedown",function(e){var t=e.target;t==m||p._isChildOf(t,m)||(p.hide(),e.stopPropagation(),e.preventDefault())}),this.eventListeners.keydown=r.addEventListener(this.rootNode,"keydown",function(e){p._onKeyDown(e)}),this.selection=r.getSelection(),this.anchor=e,setTimeout(function(){p.dom.focusButton.focus()},0),o.visibleMenu&&o.visibleMenu.hide(),o.visibleMenu=this},o.prototype.hide=function(){this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose());for(var e in this.eventListeners)if(this.eventListeners.hasOwnProperty(e)){var t=this.eventListeners[e];t&&r.removeEventListener(this.rootNode,e,t),delete this.eventListeners[e]}o.visibleMenu==this&&(o.visibleMenu=void 0)},o.prototype._onExpandItem=function(e){var t=this,n=e==this.expandedItem,i=this.expandedItem;if(i&&(i.ul.style.height="0",i.ul.style.padding="",setTimeout(function(){t.expandedItem!=i&&(i.ul.style.display="",r.removeClassName(i.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!n){var o=e.ul;o.style.display="block";o.clientHeight;setTimeout(function(){if(t.expandedItem==e){for(var n=0,i=0;i<o.childNodes.length;i++)n+=o.childNodes[i].clientHeight;o.style.height=n+"px",o.style.padding="5px 10px"}},0),r.addClassName(o.parentNode,"jsoneditor-selected"),this.expandedItem=e}},o.prototype._onKeyDown=function(e){var t,n,i,o,s=e.target,a=e.which,l=!1;27==a?(this.selection&&r.setSelection(this.selection),this.anchor&&this.anchor.focus(),this.hide(),l=!0):9==a?e.shiftKey?(t=this._getVisibleButtons(),0==(n=t.indexOf(s))&&(t[t.length-1].focus(),l=!0)):(t=this._getVisibleButtons(),(n=t.indexOf(s))==t.length-1&&(t[0].focus(),l=!0)):37==a?("jsoneditor-expand"==s.className&&(t=this._getVisibleButtons(),n=t.indexOf(s),(i=t[n-1])&&i.focus()),l=!0):38==a?(t=this._getVisibleButtons(),n=t.indexOf(s),i=t[n-1],i&&"jsoneditor-expand"==i.className&&(i=t[n-2]),i||(i=t[t.length-1]),i&&i.focus(),l=!0):39==a?(t=this._getVisibleButtons(),n=t.indexOf(s),o=t[n+1],o&&"jsoneditor-expand"==o.className&&o.focus(),l=!0):40==a&&(t=this._getVisibleButtons(),n=t.indexOf(s),o=t[n+1],o&&"jsoneditor-expand"==o.className&&(o=t[n+2]),o||(o=t[0]),o&&(o.focus(),l=!0),l=!0),l&&(e.stopPropagation(),e.preventDefault())},o.prototype._isChildOf=function(e,t){for(var n=e.parentNode;n;){if(n==t)return!0;n=n.parentNode}return!1},e.exports=o},function(e,t){"use strict";var n,i=["en","pt-BR"],o={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",collapseAll:"Collapse all fields",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.'},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",collapseAll:"Fechar todos campos",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",selectNode:"Select a node...",showAll:"mostre tudo",showMore:"mostre mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"Texto",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.'}},r=navigator.language||navigator.userLanguage;n=i.find(function(e){return e===r}),n||(n="en"),e.exports={_locales:i,_defs:o,_lang:n,setLanguage:function(e){if(e){var t=i.find(function(t){return t===e});t?n=t:console.error("Language not found")}},setLanguages:function(e){if(e)for(var t in e){var n=i.find(function(e){return e===t});n||i.push(t),o[t]=Object.assign({},o.en,o[t],e[t])}},translate:function(e,t,i){i||(i=n);var r=o[i][e];if(t)for(e in t)r=r.replace("${"+e+"}",t[e]);return r||e}}},function(e,t,n){"use strict";function i(e){e&&(this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",e.appendChild(this.path),this.reset())}var o=n(7),r=n(8).translate;i.prototype.reset=function(){this.path.innerHTML=r("selectNode")},i.prototype.setPath=function(e){function t(e){this.selectionCallback&&this.selectionCallback(e)}function n(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}var i=this;this.path.innerHTML="",e&&e.length&&e.forEach(function(r,s){var a,l=document.createElement("span");if(l.className="jsoneditor-treepath-element",l.innerText=r.name,l.onclick=t.bind(i,r),i.path.appendChild(l),r.children.length&&(a=document.createElement("span"),a.className="jsoneditor-treepath-seperator",a.innerHTML="&#9658;",a.onclick=function(){var t=[];r.children.forEach(function(o){t.push({text:o.name,className:"jsoneditor-type-modes"+(e[s+1]+1&&e[s+1].name===o.name?" jsoneditor-selected":""),click:n.bind(i,r,o.name)})}),new o(t).show(a)},i.path.appendChild(a,i.container)),s===e.length-1){var c=(a||l).getBoundingClientRect().left;i.path.offsetWidth<c&&(i.path.scrollLeft=c)}})},i.prototype.onSectionSelected=function(e){"function"==typeof e&&(this.selectionCallback=e)},i.prototype.onContextMenuItemSelected=function(e){"function"==typeof e&&(this.contextMenuCallback=e)},e.exports=i},function(e,t,n){"use strict";function i(e,t){this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),this.setValue(t.value,t.type)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=c.debounce(this._onChangeValue.bind(this),i.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=c.debounce(this._onChangeField.bind(this),i.prototype.DEBOUNCE_INTERVAL)}var o=n(11),r=n(12),s=n(7),a=n(13),l=n(14),c=n(4),d=n(8).translate;i.prototype.DEBOUNCE_INTERVAL=150,i.prototype.MAX_SEARCH_RESULTS=999,i.prototype.MAX_VISIBLE_CHILDS=100,i.prototype.visibleChilds=i.prototype.MAX_VISIBLE_CHILDS,i.prototype._updateEditability=function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}},i.prototype.getPath=function(){for(var e=this,t=[];e;){var n=e.getName();void 0!==n&&t.unshift(n),e=e.parent}return t},i.prototype.getName=function(){return this.parent?"array"!=this.parent.type?this.field:this.index:void 0},i.prototype.findNodeByPath=function(e){if(e){if(0==e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}},i.prototype.serialize=function(){return{value:this.getValue(),path:this.getPath()}},i.prototype.findNode=function(e){for(var t=c.parsePath(e),n=this;n&&t.length>0;){var i=t.shift();if("number"==typeof i){if("array"!==n.type)throw new Error("Cannot get child node at index "+i+": node is no array");n=n.childs[i]}else{if("object"!==n.type)throw new Error("Cannot get child node "+i+": node is no object");n=n.childs.filter(function(e){return e.field===i})[0]}}return n},i.prototype.findParents=function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e},i.prototype.setError=function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()},i.prototype.updateError=function(){var e=this.error,t=this.dom.tdError;if(e&&this.dom&&this.dom.tr&&!t){t||(t=document.createElement("td"),this.dom.tdError=t,this.dom.tdValue.parentNode.appendChild(t));var n=document.createElement("div");n.className="jsoneditor-popover jsoneditor-right",n.appendChild(document.createTextNode(e.message));var i=document.createElement("button");i.type="button",i.className="jsoneditor-schema-error",i.appendChild(n),i.onmouseover=i.onfocus=function(){for(var e=["right","above","below","left"],t=0;t<e.length;t++){var i=e[t];n.className="jsoneditor-popover jsoneditor-"+i;var o=this.editor.content.getBoundingClientRect(),r=n.getBoundingClientRect();if(c.insideRect(o,r,20))break}}.bind(this);var o=this.errorChild;for(o&&(i.onclick=function(){o.findParents().forEach(function(e){e.expand(!1)}),o.scrollTo(function(){o.focus()})});t.firstChild;)t.removeChild(t.firstChild);t.appendChild(i)}else t&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)},i.prototype.getIndex=function(){return this.parent?this.parent.childs.indexOf(this):-1},i.prototype.setParent=function(e){this.parent=e},i.prototype.setField=function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t},i.prototype.getField=function(){return void 0===this.field&&this._getDomField(),this.field},i.prototype.setValue=function(e,t){var n,o,r,s=this.childs;if(s)for(;s.length;)this.removeChild(s[0]);if(this.type=this._getType(e),t&&t!=this.type){if("string"!=t||"auto"!=this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"==this.type){this.childs=[];for(var a=0,l=e.length;a<l;a++)void 0===(n=e[a])||n instanceof Function||(o=new i(this.editor,{value:n}),r=a<this.MAX_VISIBLE_CHILDS,this.appendChild(o,r));this.value=""}else if("object"==this.type){this.childs=[],a=0;for(var c in e)e.hasOwnProperty(c)&&(n=e[c],void 0===n||n instanceof Function||(o=new i(this.editor,{field:c,value:n}),r=a<this.MAX_VISIBLE_CHILDS,this.appendChild(o,r)),a++);this.value="",!0===this.editor.options.sortObjectKeys&&this.sort([],"asc")}else this.childs=void 0,this.value=e;this.previousValue=this.value},i.prototype.getValue=function(){if("array"==this.type){var e=[];return this.childs.forEach(function(t){e.push(t.getValue())}),e}if("object"==this.type){var t={};return this.childs.forEach(function(e){t[e.getField()]=e.getValue()}),t}return void 0===this.value&&this._getDomValue(),this.value},i.prototype.getLevel=function(){return this.parent?this.parent.getLevel()+1:0},i.prototype.getNodePath=function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e},i.prototype.clone=function(){var e=new i(this.editor);if(e.type=this.type,e.field=this.field,e.fieldInnerText=this.fieldInnerText,e.fieldEditable=this.fieldEditable,e.value=this.value,e.valueInnerText=this.valueInnerText,e.expanded=this.expanded,e.visibleChilds=this.visibleChilds,this.childs){var t=[];this.childs.forEach(function(n){var i=n.clone();i.setParent(e),t.push(i)}),e.childs=t}else e.childs=void 0;return e},i.prototype.expand=function(e){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-expanded"),this.showChilds(),!1!==e&&this.childs.forEach(function(t){t.expand(e)}))},i.prototype.collapse=function(e){this.childs&&(this.hideChilds(),
!1!==e&&this.childs.forEach(function(t){t.collapse(e)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-collapsed"),this.expanded=!1)},i.prototype.showChilds=function(){if(this.childs&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){var n=this.getAppendDom();if(!n.parentNode){var i=e.nextSibling;i?t.insertBefore(n,i):t.appendChild(n)}for(var o=Math.min(this.childs.length,this.visibleChilds),i=this._getNextTr(),r=0;r<o;r++){var s=this.childs[r];s.getDom().parentNode||t.insertBefore(s.getDom(),i),s.showChilds()}var a=this.getShowMoreDom(),i=this._getNextTr();a.parentNode||t.insertBefore(a,i),this.showMore.updateDom()}}},i.prototype._getNextTr=function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0},i.prototype.hide=function(e){var t=this.dom.tr,n=t?t.parentNode:void 0;n&&n.removeChild(t),this.hideChilds(e)},i.prototype.hideChilds=function(e){if(this.childs&&this.expanded){var t=this.getAppendDom();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()});var n=this.getShowMoreDom();n.parentNode&&n.parentNode.removeChild(n),e&&!e.resetVisibleChilds||delete this.visibleChilds}},i.prototype.expandTo=function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent},i.prototype.appendChild=function(e,t){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"==this.type,"array"==this.type&&(e.index=this.childs.length),this.childs.push(e),this.expanded&&!1!==t){var n=e.getDom(),i=this.getAppendDom(),o=i?i.parentNode:void 0;i&&o&&o.insertBefore(n,i),e.showChilds(),this.visibleChilds++}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},i.prototype.moveBefore=function(e,t){if(this._hasChilds()){var n=this.dom.tr?this.dom.tr.parentNode:void 0;if(n){var i=document.createElement("tr");i.style.height=n.clientHeight+"px",n.appendChild(i)}if(e.parent&&e.parent.removeChild(e),t instanceof h)if(this.childs.length+1>this.visibleChilds){var o=this.childs[this.visibleChilds-1];this.insertBefore(e,o)}else this.appendChild(e);else this.insertBefore(e,t);n&&n.removeChild(i)}},i.prototype.moveTo=function(e,t){if(e.parent==this){this.childs.indexOf(e)<t&&t++}var n=this.childs[t]||this.append;this.moveBefore(e,n)},i.prototype.insertBefore=function(e,t){if(this._hasChilds()){if(this.visibleChilds++,t==this.append)e.setParent(this),e.fieldEditable="object"==this.type,this.childs.push(e);else{var n=this.childs.indexOf(t);if(-1==n)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"==this.type,this.childs.splice(n,0,e)}if(this.expanded){var i=e.getDom(),o=t.getDom(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(i,o),e.showChilds(),this.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},i.prototype.insertAfter=function(e,t){if(this._hasChilds()){var n=this.childs.indexOf(t),i=this.childs[n+1];i?this.insertBefore(e,i):this.appendChild(e)}},i.prototype.search=function(e,t){Array.isArray(t)||(t=[]);var n,i=e?e.toLowerCase():void 0;if(delete this.searchField,delete this.searchValue,void 0!==this.field&&t.length<=this.MAX_SEARCH_RESULTS){n=String(this.field).toLowerCase().indexOf(i),-1!==n&&(this.searchField=!0,t.push({node:this,elem:"field"})),this._updateDomField()}if(this._hasChilds())this.childs&&this.childs.forEach(function(n){n.search(e,t)});else if(void 0!==this.value&&t.length<=this.MAX_SEARCH_RESULTS){var o=String(this.value).toLowerCase();n=o.indexOf(i),-1!==n&&(this.searchValue=!0,t.push({node:this,elem:"value"})),this._updateDomValue()}return t},i.prototype.scrollTo=function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)},i.prototype.expandPathToNode=function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=i.prototype.MAX_VISIBLE_CHILDS;e.parent.expand(!1),e=e.parent}},i.focusElement=void 0,i.prototype.focus=function(e){if(i.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),c.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),c.selectContentEditable(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),c.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),c.selectContentEditable(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),c.selectContentEditable(t.value)):t.field&&this.fieldEditable?(t.field.focus(),c.selectContentEditable(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}},i.select=function(e){setTimeout(function(){c.selectContentEditable(e)},0)},i.prototype.blur=function(){this._getDomValue(!1),this._getDomField(!1)},i.prototype.containsNode=function(e){if(this==e)return!0;var t=this.childs;if(t)for(var n=0,i=t.length;n<i;n++)if(t[n].containsNode(e))return!0;return!1},i.prototype._move=function(e,t){if(e!=t){if(e.containsNode(this))throw new Error(d("validationCannotMove"));e.parent&&e.parent.removeChild(e);var n=e.clone();e.clearDom(),t?this.insertBefore(n,t):this.appendChild(n)}},i.prototype.removeChild=function(e){if(this.childs){var t=this.childs.indexOf(e);if(-1!==t){this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(t,1)[0];return n.parent=null,this.updateDom({updateIndexes:!0}),n}}},i.prototype._remove=function(e){this.removeChild(e)},i.prototype.changeType=function(e){var t=this.type;if(t!=e){if("string"!=e&&"auto"!=e||"string"!=t&&"auto"!=t){var n,i=this.dom.tr?this.dom.tr.parentNode:void 0;n=this.expanded?this.getAppendDom():this.getDom();var o=n&&n.parentNode?n.nextSibling:void 0;this.hide({resetVisibleChilds:!1}),this.clearDom(),this.type=e,"object"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0==e.field&&(e.field="")}),"string"!=t&&"auto"!=t||(this.expanded=!0)):"array"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!=t&&"auto"!=t||(this.expanded=!0)):this.expanded=!1,i&&(o?i.insertBefore(this.getDom(),o):i.appendChild(this.getDom())),this.showChilds()}else this.type=e;"auto"!=e&&"string"!=e||(this.value="string"==e?String(this.value):this._stringCast(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}},i.prototype._getDomValue=function(e){if(this.dom.value&&"array"!=this.type&&"object"!=this.type&&(this.valueInnerText=c.getInnerText(this.dom.value)),void 0!=this.valueInnerText)try{var t;if("string"==this.type)t=this._unescapeHTML(this.valueInnerText);else{var n=this._unescapeHTML(this.valueInnerText);t=this._stringCast(n)}t!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(t){if(this.value=void 0,!0!==e)throw t}},i.prototype._onChangeValue=function(){var e=this.editor.getDomSelection();if(e.range){var t=c.textDiff(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var n=this.editor.getDomSelection();if(n.range){var i=c.textDiff(String(this.previousValue),String(this.value));n.range.startOffset=i.start,n.range.endOffset=i.end}this.editor._onAction("editValue",{node:this,oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:n}),this.previousValue=this.value},i.prototype._onChangeField=function(){var e=this.editor.getDomSelection(),t=this.previousField||"";if(e.range){var n=c.textDiff(this.field,t);e.range.startOffset=n.start,e.range.endOffset=n.end}var i=this.editor.getDomSelection();if(i.range){var o=c.textDiff(t,this.field);i.range.startOffset=o.start,i.range.endOffset=o.end}this.editor._onAction("editField",{node:this,oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:i}),this.previousField=this.field},i.prototype._updateDomValue=function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],n=this.value,i="auto"==this.type?c.type(n):this.type,o="string"==i&&c.isUrl(n);t.push("jsoneditor-"+i),o&&t.push("jsoneditor-url");if(""==String(this.value)&&"array"!=this.type&&"object"!=this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"==i||"object"==i){var r=this.childs?this.childs.length:0;e.title=this.type+" containing "+r+" items"}else o&&this.editable.value?e.title=d("openUrl"):e.title="";if("boolean"===i&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value==this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||this.schema.hasOwnProperty("oneOf")||this.schema.hasOwnProperty("anyOf")||this.schema.hasOwnProperty("allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);c.stripFormatting(e)}},i.prototype._updateDomField=function(){var e=this.dom.field;if(e){""==String(this.field)&&"array"!=this.parent.type?c.addClassName(e,"jsoneditor-empty"):c.removeClassName(e,"jsoneditor-empty"),this.searchFieldActive?c.addClassName(e,"jsoneditor-highlight-active"):c.removeClassName(e,"jsoneditor-highlight-active"),this.searchField?c.addClassName(e,"jsoneditor-highlight"):c.removeClassName(e,"jsoneditor-highlight"),c.stripFormatting(e)}},i.prototype._getDomField=function(e){if(this.dom.field&&this.fieldEditable&&(this.fieldInnerText=c.getInnerText(this.dom.field)),void 0!=this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText);t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(t){if(this.field=void 0,!0!==e)throw t}},i.prototype.validate=function(){var e=[];if("object"===this.type){for(var t={},n=[],i=0;i<this.childs.length;i++){var o=this.childs[i];t.hasOwnProperty(o.field)&&n.push(o.field),t[o.field]=!0}n.length>0&&(e=this.childs.filter(function(e){return-1!==n.indexOf(e.field)}).map(function(e){return{node:e,error:{message:d("duplicateKey")+' "'+e.field+'"'}}}))}if(this.childs)for(var i=0;i<this.childs.length;i++){var r=this.childs[i].validate();r.length>0&&(e=e.concat(r))}return e},i.prototype.clearDom=function(){this.dom={}},i.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),e.tr.node=this,"tree"===this.editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var n=document.createElement("button");n.type="button",e.drag=n,n.className="jsoneditor-dragarea",n.title=d("drag"),t.appendChild(n)}e.tr.appendChild(t);var i=document.createElement("td"),o=document.createElement("button");o.type="button",e.menu=o,o.className="jsoneditor-contextmenu",o.title=d("actionsMenu"),i.appendChild(e.menu),e.tr.appendChild(i)}var r=document.createElement("td");return e.tr.appendChild(r),e.tree=this._createDomTree(),r.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr},i.prototype.isVisible=function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1},i.onDragStart=function(e,t){if(!Array.isArray(e))return i.onDragStart([e],t);if(0!==e.length){var n=e[0],o=e[e.length-1],r=i.getNodeFromTarget(t.target),s=o.nextSibling(),a=n.editor,l=c.getAbsoluteTop(r.dom.tr)-c.getAbsoluteTop(n.dom.tr);a.mousemove||(a.mousemove=c.addEventListener(window,"mousemove",function(t){i.onDrag(e,t)})),a.mouseup||(a.mouseup=c.addEventListener(window,"mouseup",function(t){i.onDragEnd(e,t)})),a.highlighter.lock(),a.drag={oldCursor:document.body.style.cursor,oldSelection:a.getDomSelection(),oldBeforeNode:s,mouseX:t.pageX,offsetY:l,level:n.getLevel()},document.body.style.cursor="move",t.preventDefault()}},i.onDrag=function(e,t){if(!Array.isArray(e))return i.onDrag([e],t);if(0!==e.length){var n,o,r,s,a,l,d,u,p,m,f,g,v,y,b=e[0].editor,w=t.pageY-b.drag.offsetY,x=t.pageX,_=!1,C=e[0];if(n=C.dom.tr,p=c.getAbsoluteTop(n),g=n.offsetHeight,w<p){o=n;do{o=o.previousSibling,d=i.getNodeFromTarget(o),m=o?c.getAbsoluteTop(o):0}while(o&&w<m);d&&!d.parent&&(d=void 0),d||(l=n.parentNode.firstChild,o=l?l.nextSibling:void 0,(d=i.getNodeFromTarget(o))==C&&(d=void 0)),d&&d.isVisible()&&(o=d.dom.tr,m=o?c.getAbsoluteTop(o):0,w>m+g&&(d=void 0)),d&&(e.forEach(function(e){d.parent.moveBefore(e,d)}),_=!0)}else{var E=e[e.length-1];if(a=E.expanded&&E.append?E.append.getDom():E.dom.tr,s=a?a.nextSibling:void 0){f=c.getAbsoluteTop(s),r=s;do{u=i.getNodeFromTarget(r),r&&(v=r.nextSibling?c.getAbsoluteTop(r.nextSibling):0,y=r?v-f:0,u&&u.parent.childs.length==e.length&&u.parent.childs[e.length-1]==E&&(p+=27),r=r.nextSibling)}while(r&&w>p+y);if(u&&u.parent){var S=x-b.drag.mouseX,N=Math.round(S/24/2),j=b.drag.level+N,k=u.getLevel();for(o=u.dom.tr&&u.dom.tr.previousSibling;k<j&&o;){d=i.getNodeFromTarget(o);if(e.some(function(e){return e===d||d.isDescendantOf(e)}));else{if(!(d instanceof h))break;var T=d.parent.childs;if(T.length==e.length&&T[e.length-1]==E)break;u=i.getNodeFromTarget(o),k=u.getLevel()}o=o.previousSibling}u instanceof h&&!u.isVisible()&&u.parent.showMore.isVisible()&&(u=u._nextNode()),u&&u.dom.tr&&a.nextSibling!=u.dom.tr&&(e.forEach(function(e){u.parent.moveBefore(e,u)}),_=!0)}}}_&&(b.drag.mouseX=x,b.drag.level=C.getLevel()),b.startAutoScroll(w),t.preventDefault()}},i.onDragEnd=function(e,t){if(!Array.isArray(e))return i.onDrag([e],t);if(0!==e.length){var n=e[0],o=n.editor,r=n.parent,s=r.childs.indexOf(n),a=r.childs[s+e.length]||r.append;e[0]&&e[0].dom.menu.focus();var l={nodes:e,oldSelection:o.drag.oldSelection,newSelection:o.getDomSelection(),oldBeforeNode:o.drag.oldBeforeNode,newBeforeNode:a};l.oldBeforeNode!=l.newBeforeNode&&o._onAction("moveNodes",l),document.body.style.cursor=o.drag.oldCursor,o.highlighter.unlock(),e.forEach(function(e){t.target!==e.dom.drag&&t.target!==e.dom.menu&&o.highlighter.unhighlight()}),delete o.drag,o.mousemove&&(c.removeEventListener(window,"mousemove",o.mousemove),delete o.mousemove),o.mouseup&&(c.removeEventListener(window,"mouseup",o.mouseup),delete o.mouseup),o.stopAutoScroll(),t.preventDefault()}},i.prototype.isDescendantOf=function(e){for(var t=this.parent;t;){if(t==e)return!0;t=t.parent}return!1},i.prototype._createDomField=function(){return document.createElement("div")},i.prototype.setHighlight=function(e){this.dom.tr&&(e?c.addClassName(this.dom.tr,"jsoneditor-highlight"):c.removeClassName(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(e),this.childs&&this.childs.forEach(function(t){t.setHighlight(e)}))},i.prototype.setSelected=function(e,t){this.selected=e,this.dom.tr&&(e?c.addClassName(this.dom.tr,"jsoneditor-selected"):c.removeClassName(this.dom.tr,"jsoneditor-selected"),t?c.addClassName(this.dom.tr,"jsoneditor-first"):c.removeClassName(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(e),this.showMore&&this.showMore.setSelected(e),this.childs&&this.childs.forEach(function(t){t.setSelected(e)}))},i.prototype.updateValue=function(e){this.value=e,this.updateDom()},i.prototype.updateField=function(e){this.field=e,this.updateDom()},i.prototype.updateDom=function(e){var t=this.dom.tree;t&&(t.style.marginLeft=24*this.getLevel()+"px");var n=this.dom.field;if(n){this.fieldEditable?(n.contentEditable=this.editable.field,n.spellcheck=!1,n.className="jsoneditor-field"):n.className="jsoneditor-readonly";var i;i=void 0!=this.index?this.index:void 0!=this.field?this.field:this._hasChilds()?this.type:"",n.innerHTML=this._escapeHTML(i),this._updateSchema()}var o=this.dom.value;if(o){var r=this.childs?this.childs.length:0;"array"==this.type?(o.innerHTML="["+r+"]",c.addClassName(this.dom.tr,"jsoneditor-expandable")):"object"==this.type?(o.innerHTML="{"+r+"}",c.addClassName(this.dom.tr,"jsoneditor-expandable")):(o.innerHTML=this._escapeHTML(this.value),c.removeClassName(this.dom.tr,"jsoneditor-expandable"))}this._updateDomField(),this._updateDomValue(),e&&!0===e.updateIndexes&&this._updateDomIndexes(),e&&!0===e.recurse&&this.childs&&this.childs.forEach(function(t){t.updateDom(e)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom()},i.prototype._updateSchema=function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?i._findSchema(this.editor.options.schema,this.getPath()):null,this.schema?this.enum=i._findEnum(this.schema):delete this.enum)},i._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var n=t.filter(function(e){return e.enum});if(n.length>0)return n[0].enum}return null},i._findSchema=function(e,t){var n=e,o=n,r=e.oneOf||e.anyOf||e.allOf;r||(r=[e]);for(var s=0;s<r.length;s++){n=r[s];for(var a=0;a<t.length&&n;a++){var l=t[a];if("string"==typeof l&&n.patternProperties&&a==t.length-1)for(var c in n.patternProperties)o=i._findSchema(n.patternProperties[c],t.slice(a,t.length));else n.items&&n.items.properties?(n=n.items.properties[l])&&(o=i._findSchema(n,t.slice(a,t.length))):"string"==typeof l&&n.properties?(n=n.properties[l]||null)&&(o=i._findSchema(n,t.slice(a,t.length))):"number"==typeof l&&n.items&&(n=n.items)&&(o=i._findSchema(n,t.slice(a,t.length)))}}return o},i.prototype._updateDomIndexes=function(){var e=this.dom.value,t=this.childs;e&&t&&("array"==this.type?t.forEach(function(e,t){e.index=t;var n=e.dom.field;n&&(n.innerHTML=t)}):"object"==this.type&&t.forEach(function(e){void 0!=e.index&&(delete e.index,void 0==e.field&&(e.field=""))}))},i.prototype._createDomValue=function(){var e;return"array"==this.type?(e=document.createElement("div"),e.innerHTML="[...]"):"object"==this.type?(e=document.createElement("div"),e.innerHTML="{...}"):!this.editable.value&&c.isUrl(this.value)?(e=document.createElement("a"),e.href=this.value,e.innerHTML=this._escapeHTML(this.value)):(e=document.createElement("div"),e.contentEditable=this.editable.value,e.spellcheck=!1,e.innerHTML=this._escapeHTML(this.value)),e},i.prototype._createDomExpandButton=function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-expanded":"jsoneditor-collapsed",e.title=d("expandTitle")):(e.className="jsoneditor-invisible",e.title=""),e},i.prototype._createDomTree=function(){var e=this.dom,t=document.createElement("table"),n=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(n);var i=document.createElement("tr");n.appendChild(i);var o=document.createElement("td");o.className="jsoneditor-tree",i.appendChild(o),e.expand=this._createDomExpandButton(),o.appendChild(e.expand),e.tdExpand=o;var r=document.createElement("td");r.className="jsoneditor-tree",i.appendChild(r),e.field=this._createDomField(),r.appendChild(e.field),e.tdField=r;var s=document.createElement("td");s.className="jsoneditor-tree",i.appendChild(s),"object"!=this.type&&"array"!=this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",i.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t},i.prototype.onEvent=function(e){var t=e.type,n=e.target||e.srcElement,i=this.dom,o=this,r=this._hasChilds();if(n!=i.drag&&n!=i.menu||("mouseover"==t?this.editor.highlighter.highlight(this):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&n==i.menu){var s=o.editor.highlighter;s.highlight(o),s.lock(),c.addClassName(i.menu,"jsoneditor-selected"),this.showContextMenu(i.menu,function(){c.removeClassName(i.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"==t&&(n==i.expand||("view"===o.editor.options.mode||"form"===o.editor.options.mode)&&"DIV"===n.nodeName)&&r){var a=e.ctrlKey;this._onExpand(a)}"change"==t&&n==i.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue()),"change"==t&&n==i.select&&(this.dom.value.innerHTML=i.select.value,this._getDomValue(),this._updateDomValue());var l=i.value;if(n==l)switch(t){case"blur":case"change":this._getDomValue(!0),this._updateDomValue(),this.value&&(l.innerHTML=this._escapeHTML(this.value));break;case"input":this._getDomValue(!0),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&c.isUrl(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(!0),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){o._getDomValue(!0),o._updateDomValue()},1)}var d=i.field;if(n==d)switch(t){case"blur":case"change":this._getDomField(!0),this._updateDomField(),this.field&&(d.innerHTML=this._escapeHTML(this.field));break;case"input":this._getDomField(!0),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(!0),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){o._getDomField(!0),o._updateDomField()},1)}var h=i.tree;if(h&&n==h.parentNode&&"click"==t&&!e.hasMoved){(void 0!=e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<c.getAbsoluteLeft(i.tdSeparator))||r?d&&(c.setEndOfContentEditable(d),d.focus()):l&&!this.enum&&(c.setEndOfContentEditable(l),l.focus())}(n!=i.tdExpand||r)&&n!=i.tdField&&n!=i.tdSeparator||"click"!=t||e.hasMoved||d&&(c.setEndOfContentEditable(d),d.focus()),"keydown"==t&&this.onKeyDown(e)},i.prototype.onKeyDown=function(e){var t,n,o,r,s,a,l,d,u=e.which||e.keyCode,p=e.target||e.srcElement,m=e.ctrlKey,f=e.shiftKey,g=e.altKey,v=!1,y="tree"===this.editor.options.mode,b=this.editor.multiselection.nodes.length>0?this.editor.multiselection.nodes:[this],w=b[0],x=b[b.length-1];if(13==u){if(p==this.dom.value)this.editable.value&&!e.ctrlKey||c.isUrl(this.value)&&(window.open(this.value,"_blank"),v=!0);else if(p==this.dom.expand){var _=this._hasChilds();if(_){var C=e.ctrlKey;this._onExpand(C),p.focus(),v=!0}}}else if(68==u)m&&y&&(i.onDuplicate(b),v=!0);else if(69==u)m&&(this._onExpand(f),p.focus(),v=!0);else if(77==u&&y)m&&(this.showContextMenu(p),v=!0);else if(46==u&&y)m&&(i.onRemove(b),v=!0);else if(45==u&&y)m&&!f?(this._onInsertBefore(),v=!0):m&&f&&(this._onInsertAfter(),v=!0);else if(35==u){if(g){var E=this._lastNode();E&&E.focus(i.focusElement||this._getElementName(p)),v=!0}}else if(36==u){if(g){var S=this._firstNode();S&&S.focus(i.focusElement||this._getElementName(p)),v=!0}}else if(37==u){if(g&&!f){var N=this._previousElement(p);N&&this.focus(this._getElementName(N)),v=!0}else if(g&&f&&y){if(x.expanded){var j=x.getAppendDom();o=j?j.nextSibling:void 0}else{var k=x.getDom();o=k.nextSibling}o&&(n=i.getNodeFromTarget(o),r=o.nextSibling,O=i.getNodeFromTarget(r),n&&n instanceof h&&1!=x.parent.childs.length&&O&&O.parent&&(s=this.editor.getDomSelection(),a=x.nextSibling(),b.forEach(function(e){O.parent.moveBefore(e,O)}),this.focus(i.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:O,oldSelection:s,newSelection:this.editor.getDomSelection()})))}}else if(38==u)g&&!f?(t=this._previousNode(),t&&(this.editor.deselect(!0),t.focus(i.focusElement||this._getElementName(p))),v=!0):!g&&m&&f&&y?(t=this._previousNode(),t&&(d=this.editor.multiselection,d.start=d.start||this,d.end=t,l=this.editor._findTopLevelNodes(d.start,d.end),this.editor.select(l),t.focus("field")),v=!0):g&&f&&y&&(t=w._previousNode(),t&&t.parent&&(s=this.editor.getDomSelection(),a=x.nextSibling(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(i.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:t,oldSelection:s,newSelection:this.editor.getDomSelection()})),v=!0);else if(39==u){if(g&&!f){var T=this._nextElement(p);T&&this.focus(this._getElementName(T)),v=!0}else if(g&&f&&y){k=w.getDom();var D=k.previousSibling;D&&(t=i.getNodeFromTarget(D))&&t.parent&&!t.isVisible()&&(s=this.editor.getDomSelection(),a=x.nextSibling(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(i.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:t,oldSelection:s,newSelection:this.editor.getDomSelection()}))}}else if(40==u)if(g&&!f)n=this._nextNode(),n&&(this.editor.deselect(!0),n.focus(i.focusElement||this._getElementName(p))),v=!0;else if(!g&&m&&f&&y)n=this._nextNode(),n&&(d=this.editor.multiselection,d.start=d.start||this,d.end=n,l=this.editor._findTopLevelNodes(d.start,d.end),this.editor.select(l),n.focus("field")),v=!0;else if(g&&f&&y){n=x.expanded?x.append?x.append._nextNode():void 0:x._nextNode(),n&&!n.isVisible()&&(n=n.parent.showMore),n&&n instanceof h&&(n=x);var O=n&&(n._nextNode()||n.parent.append);O&&O.parent&&(s=this.editor.getDomSelection(),a=x.nextSibling(),b.forEach(function(e){O.parent.moveBefore(e,O)}),this.focus(i.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:O,oldSelection:s,newSelection:this.editor.getDomSelection()})),v=!0}v&&(e.preventDefault(),e.stopPropagation())},i.prototype._onExpand=function(e){if(e){var t=this.dom.tr.parentNode,n=t.parentNode,i=n.scrollTop;n.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(n.appendChild(t),n.scrollTop=i)},i.onRemove=function(e){if(!Array.isArray(e))return i.onRemove([e]);if(e&&e.length>0){var t=e[0],n=t.parent,o=t.editor,r=t.getIndex();o.highlighter.unhighlight();var s=o.getDomSelection();i.blurNodes(e);var a=o.getDomSelection();e.forEach(function(e){e.parent._remove(e)}),o._onAction("removeNodes",{nodes:e.slice(0),parent:n,index:r,oldSelection:s,newSelection:a})}},i.onDuplicate=function(e){if(!Array.isArray(e))return i.onDuplicate([e]);if(e&&e.length>0){var t=e[e.length-1],n=t.parent,o=t.editor;o.deselect(o.multiselection.nodes);var r=o.getDomSelection(),s=t,a=e.map(function(e){var t=e.clone();return n.insertAfter(t,s),s=t,t});1===e.length?a[0].focus():o.select(a);var l=o.getDomSelection();o._onAction("duplicateNodes",{afterNode:t,nodes:a,parent:n,oldSelection:r,newSelection:l})}},i.prototype._onInsertBefore=function(e,t,n){var o=this.editor.getDomSelection(),r=new i(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:n});r.expand(!0),this.parent.insertBefore(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[r],beforeNode:this,parent:this.parent,oldSelection:o,newSelection:s})},i.prototype._onInsertAfter=function(e,t,n){var o=this.editor.getDomSelection(),r=new i(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:n});r.expand(!0),this.parent.insertAfter(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[r],afterNode:this,parent:this.parent,oldSelection:o,newSelection:s})},i.prototype._onAppend=function(e,t,n){var o=this.editor.getDomSelection(),r=new i(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:n});r.expand(!0),this.parent.appendChild(r),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[r],parent:this.parent,oldSelection:o,newSelection:s})},i.prototype._onChangeType=function(e){var t=this.type;if(e!=t){var n=this.editor.getDomSelection();this.changeType(e);var i=this.editor.getDomSelection();this.editor._onAction("changeType",{node:this,oldType:t,newType:e,oldSelection:n,newSelection:i})}},i.prototype.sort=function(e,t){if(this._hasChilds()){this.hideChilds();var n=this.childs;this.childs=this.childs.concat();var i="desc"===t?-1:1;"object"===this.type?this.childs.sort(function(e,t){return i*o(e.field,t.field)}):this.childs.sort(function(t,n){var r=t.getNestedChild(e),s=n.getNestedChild(e);if(!r)return i;if(!s)return-i;var a=r.value,l=s.value;return"string"!=typeof a&&"string"!=typeof l?a>l?i:a<l?-i:0:i*o(a,l)}),this._updateDomIndexes(),this.editor._onAction("sort",{node:this,oldChilds:n,newChilds:this.childs}),this.showChilds()}},i.prototype.getNestedChild=function(e){for(var t=0,n=this;n&&t<e.length;)n=n.findChildByProperty(e[t]),t++;return n},i.prototype.findChildByProperty=function(e){if("object"===this.type)return this.childs.find(function(t){return t.field===e})},i.prototype.getSortablePaths=function(){if("array"===this.type){if(this.childs.length>0){var e={};return this.childs.forEach(function(t){t._getSortablePaths(e,"")}),Object.keys(e).sort()}return["."]}return"object"===this.type?["."]:[]},i.prototype._getSortablePaths=function(e,t){"array"===this.type||("object"===this.type?this.childs.forEach(function(n){if("object"===n.type)n._getSortablePaths(e,t+"."+n.field);else if("array"===n.type);else{var i=t+"."+n.field;e[i]=!0}}):e[t+"."]=!0)},i.prototype.getAppendDom=function(){return this.append||(this.append=new h(this.editor),this.append.setParent(this)),this.append.getDom()},i.prototype.getShowMoreDom=function(){return this.showMore||(this.showMore=new u(this.editor,this)),this.showMore.getDom()},i.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},i.blurNodes=function(e){if(!Array.isArray(e))return void i.blurNodes([e]);var t=e[0],n=t.parent,o=t.getIndex();n.childs[o+e.length]?n.childs[o+e.length].focus():n.childs[o-1]?n.childs[o-1].focus():n.focus()},i.prototype.nextSibling=function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append},i.prototype._previousNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var n=t;do{n=n.previousSibling,e=i.getNodeFromTarget(n)}while(n&&e&&e instanceof h&&!e.isVisible())}return e},i.prototype._nextNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var n=t;do{n=n.nextSibling,e=i.getNodeFromTarget(n)}while(n&&e&&e instanceof h&&!e.isVisible())}return e},i.prototype._firstNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var n=t.parentNode.firstChild;e=i.getNodeFromTarget(n)}return e},i.prototype._lastNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var n=t.parentNode.lastChild;for(e=i.getNodeFromTarget(n);n&&e&&!e.isVisible();)n=n.previousSibling,e=i.getNodeFromTarget(n)}return e},i.prototype._previousElement=function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}},i.prototype._nextElement=function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}},i.prototype._getElementName=function(e){var t=this.dom;for(var n in t)if(t.hasOwnProperty(n)&&t[n]==e)return n;return null},i.prototype._hasChilds=function(){return"array"==this.type||"object"==this.type},i.TYPE_TITLES={auto:d("autoType"),object:d("objectType"),array:d("arrayType"),string:d("stringType")},i.prototype.addTemplates=function(e,t){var n=this,i=n.editor.options.templates;if(null!=i){i.length&&e.push({type:"separator"});var o=function(e,t){n._onAppend(e,t)},r=function(e,t){n._onInsertBefore(e,t)};i.forEach(function(n){e.push({text:n.text,className:n.className||"jsoneditor-type-object",title:n.title,click:t?o.bind(this,n.field,n.value):r.bind(this,n.field,n.value)})})}},i.prototype.showContextMenu=function(e,t){var n=this,o=i.TYPE_TITLES,r=[];if(this.editable.value&&r.push({text:d("type"),title:d("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:d("auto"),className:"jsoneditor-type-auto"+("auto"==this.type?" jsoneditor-selected":""),title:o.auto,click:function(){n._onChangeType("auto")}},{text:d("array"),className:"jsoneditor-type-array"+("array"==this.type?" jsoneditor-selected":""),title:o.array,click:function(){n._onChangeType("array")}},{text:d("object"),className:"jsoneditor-type-object"+("object"==this.type?" jsoneditor-selected":""),title:o.object,click:function(){n._onChangeType("object")}},{text:d("string"),className:"jsoneditor-type-string"+("string"==this.type?" jsoneditor-selected":""),title:o.string,click:function(){n._onChangeType("string")}}]}),this._hasChilds()&&r.push({text:d("sort"),title:d("sortTitle")+this.type,className:"jsoneditor-sort-asc",click:function(){n._showSortModal()}}),this.parent&&this.parent._hasChilds()){r.length&&r.push({type:"separator"});var a=n.parent.childs;if(n==a[a.length-1]){var l=[{text:d("auto"),className:"jsoneditor-type-auto",title:o.auto,click:function(){n._onAppend("","","auto")}},{text:d("array"),className:"jsoneditor-type-array",title:o.array,click:function(){n._onAppend("",[])}},{text:d("object"),className:"jsoneditor-type-object",title:o.object,click:function(){n._onAppend("",{})}},{text:d("string"),className:"jsoneditor-type-string",title:o.string,click:function(){n._onAppend("","","string")}}];n.addTemplates(l,!0),r.push({text:d("appendText"),title:d("appendTitle"),submenuTitle:d("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){n._onAppend("","","auto")},submenu:l})}var c=[{text:d("auto"),className:"jsoneditor-type-auto",title:o.auto,click:function(){n._onInsertBefore("","","auto")}},{text:d("array"),className:"jsoneditor-type-array",title:o.array,click:function(){n._onInsertBefore("",[])}},{text:d("object"),className:"jsoneditor-type-object",title:o.object,click:function(){n._onInsertBefore("",{})}},{text:d("string"),className:"jsoneditor-type-string",title:o.string,click:function(){n._onInsertBefore("","","string")}}];n.addTemplates(c,!1),r.push({text:d("insert"),title:d("insertTitle"),submenuTitle:d("insertSub"),className:"jsoneditor-insert",click:function(){n._onInsertBefore("","","auto")},submenu:c}),this.editable.field&&(r.push({text:d("duplicateText"),title:d("duplicateField"),className:"jsoneditor-duplicate",click:function(){i.onDuplicate(n)}}),r.push({text:d("removeText"),title:d("removeField"),className:"jsoneditor-remove",click:function(){i.onRemove(n)}}))}new s(r,{close:t}).show(e,this.editor.content)},i.prototype._showSortModal=function(){var e=this,t='<div class="pico-modal-contents"><div class="pico-modal-header">'+d("sort")+"</div><form><table><tbody><tr>  <td>"+d("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+d("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+d("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+d("sortAscending")+'" title="'+d("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+d("sortDescending")+'" title="'+d("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+d("ok")+'" /></td></tr></tbody></table></form></div>';r({parent:this.editor.frame,content:t,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal"}).afterCreate(function(t){function n(e){s.value=e,s.className="jsoneditor-button-group jsoneditor-button-group-value-"+s.value}var i=t.modalElem().querySelector("form"),o=t.modalElem().querySelector("#ok"),r=t.modalElem().querySelector("#field"),s=t.modalElem().querySelector("#direction"),a=e.getSortablePaths().sort();a.forEach(function(e){var t=document.createElement("option");t.text=e,t.value=e,r.appendChild(t)}),r.value=e.sortedBy?e.sortedBy.path:a[0],n(e.sortedBy?e.sortedBy.direction:"asc"),s.onclick=function(e){n(e.target.getAttribute("data-value"))},o.onclick=function(n){n.preventDefault(),n.stopPropagation(),t.close();var i=r.value,o="."===i?[]:i.split(".").slice(1);e.sortedBy={path:i,direction:s.value},e.sort(o,s.value)},i&&(i.onsubmit=o.onclick)}).afterClose(function(e){e.destroy()}).show()},i.prototype._getType=function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof this._stringCast(e)?"string":"auto"},i.prototype._stringCast=function(e){var t=e.toLowerCase(),n=Number(e),i=parseFloat(e);return""==e?"":"null"==t?null:"true"==t||"false"!=t&&(isNaN(n)||isNaN(i)?e:n)},i.prototype._escapeHTML=function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/  /g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),n=JSON.stringify(t),i=n.substring(1,n.length-1);return!0===this.editor.options.escapeUnicode&&(i=c.escapeUnicodeChars(i)),i},i.prototype._unescapeHTML=function(e){var t='"'+this._escapeJSON(e)+'"';return c.parse(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")},i.prototype._escapeJSON=function(e){for(var t="",n=0;n<e.length;){var i=e.charAt(n);"\n"==i?t+="\\n":"\\"==i?(t+=i,n++,i=e.charAt(n),""!==i&&-1!='"\\/bfnrtu'.indexOf(i)||(t+="\\"),t+=i):t+='"'==i?'\\"':i,n++}return t};var h=a(i),u=l(i);e.exports=i},function(e,t){e.exports=function e(t,n){"use strict";var i,o,r=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,s=/(^[ ]*|[ ]*$)/g,a=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,l=/^0x[0-9a-f]+$/i,c=function(t){return e.insensitive&&(""+t).toLowerCase()||""+t},d=c(t).replace(s,"")||"",h=c(n).replace(s,"")||"",u=d.replace(r,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=h.replace(r,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=parseInt(d.match(l),16)||1!==u.length&&d.match(a)&&Date.parse(d),f=parseInt(h.match(l),16)||m&&h.match(a)&&Date.parse(h)||null;if(f){if(m<f)return-1;if(m>f)return 1}for(var g=0,v=Math.max(u.length,p.length);g<v;g++){if(i=!(u[g]||"").match(/^0/)&&parseFloat(u[g])||u[g]||0,o=!(p[g]||"").match(/^0/)&&parseFloat(p[g])||p[g]||0,isNaN(i)!==isNaN(o))return isNaN(i)?1:-1;if(typeof i!=typeof o&&(i+="",o+=""),i<o)return-1;if(i>o)return 1}return 0}},function(e,t,n){var i,o,r;!function(n,s){"use strict";o=[],i=s,void 0!==(r="function"==typeof i?i.apply(t,o):i)&&(e.exports=r)}(0,function(){"use strict";function e(e){return"object"==typeof Node?e instanceof Node:e&&"object"==typeof e&&"number"==typeof e.nodeType}function t(e){return"string"==typeof e}function n(){var e=[];return{watch:e.push.bind(e),trigger:function(t,n){for(var i=!0,o={detail:n,preventDefault:function(){i=!1}},r=0;r<e.length;r++)e[r](t,o);return i}}}function i(e){return"none"===window.getComputedStyle(e).display}function o(e){this.elem=e}function r(e,t){return o.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}function s(e,t){var n=e("width","auto");"number"==typeof n&&(n+="px");var i=e("modalId","pico-"+h++);return o.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:n,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",i).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",i)).onClick(function(e){new o(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function a(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function l(e){return function(){return e().elem}}function c(e,t){function n(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function o(e){return!(i(e)||n(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||n(e,"input,select,textarea,button,a[href],area[href],iframe"))}function r(e){for(var t=e.getElementsByTagName("*"),n=0;n<t.length;n++)if(o(t[n]))return t[n]}function s(e){for(var t=e.getElementsByTagName("*"),n=t.length;n--;)if(o(t[n]))return t[n]}var a;e.beforeShow(function(){a=document.activeElement}),e.afterShow(function(){if(t()){var n=r(e.modalElem());n&&n.focus()}}),e.afterClose(function(){t()&&a&&a.focus(),a=null}),p.watch(function(n){if(t()&&e.isVisible()){var i=r(e.modalElem()),o=s(e.modalElem());(n.shiftKey?i:o)===document.activeElement&&((n.shiftKey?o:i).focus(),n.preventDefault())}})}function d(e,t){var n,i=new o(document.body);e.beforeShow(function(){n=i.elem.style.overflow,t()&&i.stylize({overflow:"hidden"})}),e.afterClose(function(){i.stylize({overflow:n})})}o.make=function(e,t){"string"==typeof e&&(e=document.querySelector(e));var n=document.createElement(t||"div");return(e||document.body).appendChild(n),new o(n)},o.prototype={child:function(e){return o.make(this.elem,e)},stylize:function(e){e=e||{},void 0!==e.opacity&&(e.filter="alpha(opacity="+100*e.opacity+")");for(var t in e)e.hasOwnProperty(t)&&(this.elem.style[t]=e[t]);return this},clazz:function(e){return this.elem.className+=" "+e,this},html:function(t){return e(t)?this.elem.appendChild(t):this.elem.innerHTML=t,this},onClick:function(e){return this.elem.addEventListener("click",e),this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){return void 0!==t&&this.elem.setAttribute(e,t),this},anyAncestor:function(e){for(var t=this.elem;t;){if(e(new o(t)))return!0;t=t.parentNode}return!1},isVisible:function(){return!i(this.elem)}};var h=1,u=n(),p=n();return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?u.trigger():9===t&&p.trigger(e)}),function(i){function o(e,t){var n=i[e];return"function"==typeof n&&(n=n(t)),void 0===n?t:n}function h(e){E().hide(),C().hide(),_.trigger(g,e)}function p(e){x.trigger(g,e)&&h(e)}function m(e){return function(){return e.apply(this,arguments),g}}function f(e,t){if(!v){var n=s(o,p);v={modal:n,overlay:r(o,p),close:a(n,o)},y.trigger(g,t)}return v[e]}(t(i)||e(i))&&(i={content:i});var g,v,y=n(),b=n(),w=n(),x=n(),_=n(),C=f.bind(window,"modal"),E=f.bind(window,"overlay"),S=f.bind(window,"close");return g={modalElem:l(C),closeElem:l(S),overlayElem:l(E),buildDom:m(f.bind(null,null)),isVisible:function(){return!!(v&&C&&C().isVisible())},show:function(e){return b.trigger(g,e)&&(E().show(),S(),C().show(),w.trigger(g,e)),this},close:m(p),forceClose:m(h),destroy:function(){C().destroy(),E().destroy(),E=C=S=void 0},options:function(e){Object.keys(e).map(function(t){i[t]=e[t]})},afterCreate:m(y.watch),beforeShow:m(b.watch),afterShow:m(w.watch),beforeClose:m(x.watch),afterClose:m(_.watch)},c(g,o.bind(null,"focus",!0)),d(g,o.bind(null,"bodyOverflow",!0)),u.watch(function(){o("escCloses",!0)&&g.isVisible()&&g.close()}),g}})},function(e,t,n){"use strict";function i(e){function t(e){this.editor=e,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var n=document.createElement("td");e.tdMenu=n;var i=document.createElement("button");i.type="button",i.className="jsoneditor-contextmenu",i.title="Click to open the actions menu (Ctrl+M)",e.menu=i,n.appendChild(e.menu)}var o=document.createElement("td"),r=document.createElement("div");return r.innerHTML="("+s("empty")+")",r.className="jsoneditor-readonly",o.appendChild(r),e.td=o,e.text=r,this.updateDom(),t},t.prototype.updateDom=function(e){var t=this.dom,n=t.td;n&&(n.style.paddingLeft=24*this.getLevel()+26+"px");var i=t.text;i&&(i.innerHTML="("+s("empty")+" "+this.parent.type+")");var o=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&o.appendChild(t.tdDrag),t.tdMenu&&o.appendChild(t.tdMenu),o.appendChild(n)):t.tr.firstChild&&(t.tdDrag&&o.removeChild(t.tdDrag),t.tdMenu&&o.removeChild(t.tdMenu),o.removeChild(n))},t.prototype.isVisible=function(){return 0==this.parent.childs.length},t.prototype.showContextMenu=function(t,n){var i=this,o=e.TYPE_TITLES,a=[{text:s("auto"),className:"jsoneditor-type-auto",title:o.auto,click:function(){i._onAppend("","","auto")}},{text:s("array"),className:"jsoneditor-type-array",title:o.array,click:function(){i._onAppend("",[])}},{text:s("object"),className:"jsoneditor-type-object",title:o.object,click:function(){i._onAppend("",{})}},{text:s("string"),className:"jsoneditor-type-string",title:o.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(a,!0);var l=[{text:s("appendText"),title:s("appendTitleAuto"),submenuTitle:s("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:a}];new r(l,{close:n}).show(t,this.editor.content)},t.prototype.onEvent=function(e){var t=e.type,n=e.target||e.srcElement,i=this.dom;if(n==i.menu&&("mouseover"==t?this.editor.highlighter.highlight(this.parent):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&n==i.menu){var r=this.editor.highlighter;r.highlight(this.parent),r.lock(),o.addClassName(i.menu,"jsoneditor-selected"),this.showContextMenu(i.menu,function(){o.removeClassName(i.menu,"jsoneditor-selected"),r.unlock(),r.unhighlight()})}"keydown"==t&&this.onKeyDown(e)},t}var o=n(4),r=n(7),s=n(8).translate;e.exports=i},function(e,t,n){"use strict";function i(e){function t(e,t){this.editor=e,this.parent=t,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){if(this.dom.tr)return this.dom.tr;if(this._updateEditability(),!this.dom.tr){var e=this,t=this.parent,n=document.createElement("a");n.appendChild(document.createTextNode(o("showMore"))),n.href="#",n.onclick=function(n){return t.visibleChilds=Math.floor(t.visibleChilds/t.MAX_VISIBLE_CHILDS+1)*t.MAX_VISIBLE_CHILDS,e.updateDom(),t.showChilds(),n.preventDefault(),!1};var i=document.createElement("a");i.appendChild(document.createTextNode(o("showAll"))),i.href="#",i.onclick=function(n){return t.visibleChilds=1/0,e.updateDom(),t.showChilds(),n.preventDefault(),!1};var r=document.createElement("div"),s=document.createTextNode(this._getShowMoreText());r.className="jsoneditor-show-more",r.appendChild(s),r.appendChild(n),r.appendChild(document.createTextNode(". ")),r.appendChild(i),r.appendChild(document.createTextNode(". "));var a=document.createElement("td");a.appendChild(r);var l=document.createElement("tr");l.appendChild(document.createElement("td")),l.appendChild(document.createElement("td")),l.appendChild(a),l.className="jsoneditor-show-more",this.dom.tr=l,this.dom.moreContents=r,this.dom.moreText=s}return this.updateDom(),this.dom.tr},t.prototype.updateDom=function(e){if(this.isVisible()){if(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],!this.dom.tr.parentNode){var t=this.parent._getNextTr();t&&t.parentNode.insertBefore(this.dom.tr,t)}this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"}else this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},t.prototype._getShowMoreText=function(){return o("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},t.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},t.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},t}var o=n(8).translate;e.exports=i},function(e,t,n){"use strict";function i(e,t,n,i){for(var r={code:{text:"Code",title:"Switch to code highlighter",click:function(){i("code")}},form:{text:"Form",title:"Switch to form editor",click:function(){i("form")}},text:{text:"Text",title:"Switch to plain text editor",click:function(){i("text")}},tree:{text:"Tree",title:"Switch to tree editor",click:function(){i("tree")}},view:{text:"View",title:"Switch to tree view",click:function(){i("view")}}},s=[],a=0;a<t.length;a++){var l=t[a],c=r[l];if(!c)throw new Error('Unknown mode "'+l+'"');c.className="jsoneditor-type-modes"+(n==l?" jsoneditor-selected":""),s.push(c)}var d=r[n];if(!d)throw new Error('Unknown mode "'+n+'"');var h=d.text,u=document.createElement("button");u.type="button",u.className="jsoneditor-modes jsoneditor-separator",u.innerHTML=h+" &#x25BE;",u.title="Switch editor mode",u.onclick=function(){new o(s).show(u)};var p=document.createElement("div");p.className="jsoneditor-modes",p.style.position="relative",p.appendChild(u),e.appendChild(p),this.dom={container:e,box:u,frame:p}}var o=n(7);i.prototype.focus=function(){this.dom.box.focus()},i.prototype.destroy=function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null},e.exports=i},function(e,t){"use strict";function n(e){function t(e){var t,n;document.createRange?(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),n=window.getSelection(),n.removeAllRanges(),n.addRange(t)):document.selection&&(t=document.body.createTextRange(),t.moveToElementText(e),t.collapse(!1),t.select())}function n(e){return void 0===a&&(a=document.createElement("span"),a.style.visibility="hidden",a.style.position="fixed",a.style.outline="0",a.style.margin="0",a.style.padding="0",a.style.border="0",a.style.left="0",a.style.whiteSpace="pre",a.style.fontSize=i,a.style.fontFamily=o,a.style.fontWeight="normal",document.body.appendChild(a)),a.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),a.getBoundingClientRect().right}e=e||{},e.confirmKeys=e.confirmKeys||[39,35,9],e.caseSensitive=e.caseSensitive||!1;var i="",o="",r=document.createElement("div");r.style.position="relative",r.style.outline="0",r.style.border="0",r.style.margin="0",r.style.padding="0";var s=document.createElement("div");s.className="autocomplete dropdown",s.style.position="absolute",s.style.visibility="hidden";var a,l,c={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:r,show:function(e,t,n){this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""==i&&(i=window.getComputedStyle(e).getPropertyValue("font-size")),""==o&&(o=window.getComputedStyle(e).getPropertyValue("font-family"));e.getBoundingClientRect().right,e.getBoundingClientRect().left;s.style.marginLeft="0",s.style.marginTop=e.getBoundingClientRect().height+"px",this.options=n,this.element!=e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){this.element.focus()}.bind(this),this.element.addEventListener&&(this.element.removeEventListener("keydown",h),this.element.addEventListener("keydown",h,!1),this.element.removeEventListener("blur",u),this.element.addEventListener("blur",u,!1)),r.appendChild(this.elementHint),r.appendChild(s),e.parentElement.appendChild(r),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,d.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(t){var i=t.innerText;i=i.replace("\n","");var o=(this.startFrom,this.options,this.options.length),r=i.substring(this.startFrom);l=i.substring(0,this.startFrom);for(var a=0;a<o;a++){var c=this.options[a];if(!e.caseSensitive&&0===c.toLowerCase().indexOf(r.toLowerCase())||e.caseSensitive&&0===c.indexOf(r)){this.elementHint.innerText=l+r+c.substring(r.length),this.elementHint.realInnerText=l+c;break}}s.style.left=n(l)+"px",d.refresh(r,this.options),this.elementHint.style.width=n(this.elementHint.innerText)+10+"px","hidden"==s.style.visibility||(this.elementHint.style.width=n(this.elementHint.innerText)+s.clientWidth+"px")}},d=function(t,n){var i=[],o=0,r=-1,s=function(){this.style.outline="1px solid #ddd"},a=function(){this.style.outline="0"},l=function(){c.hide(),c.onmouseselection(this.__hint,c.rs)},c={rs:n,hide:function(){t.style.visibility="hidden"},refresh:function(n,r){t.style.visibility="hidden",o=0,t.innerHTML="";var d=window.innerHeight||document.documentElement.clientHeight,h=t.parentNode.getBoundingClientRect(),u=h.top-6,p=d-h.bottom-6;i=[];for(var m=0;m<r.length;m++)if(!(e.caseSensitive&&0!==r[m].indexOf(n)||!e.caseSensitive&&0!==r[m].toLowerCase().indexOf(n.toLowerCase()))){var f=document.createElement("div");f.className="item",f.onmouseover=s,f.onmouseout=a,f.onmousedown=l,f.__hint=r[m],f.innerHTML=r[m].substring(0,n.length)+"<b>"+r[m].substring(n.length)+"</b>",i.push(f),t.appendChild(f)}0!==i.length&&(1===i.length&&(n.toLowerCase()===i[0].__hint.toLowerCase()&&!e.caseSensitive||n===i[0].__hint&&e.caseSensitive)||i.length<2||(c.highlight(0),u>3*p?(t.style.maxHeight=u+"px",t.style.top="",t.style.bottom="100%"):(t.style.top="100%",t.style.bottom="",t.style.maxHeight=p+"px"),t.style.visibility="visible"))},highlight:function(e){-1!=r&&i[r]&&(i[r].className="item"),i[e].className="item hover",r=e},move:function(e){return"hidden"===t.style.visibility?"":o+e===-1||o+e===i.length?i[o].__hint:(o+=e,c.highlight(o),i[o].__hint)},onmouseselection:function(){}};return c}(s,c),h=function(n){n=n||window.event;var i=n.keyCode;if(null!=this.elementHint&&33!=i&&34!=i){if(27==i)return c.hideDropDown(),c.element.focus(),n.preventDefault(),void n.stopPropagation();var o=this.element.innerText;o=o.replace("\n","");this.startFrom;if(e.confirmKeys.indexOf(i)>=0)return 9==i&&0==this.elementHint.innerText.length&&c.onTab(),void(this.elementHint.innerText.length>0&&this.element.innerText!=this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,c.hideDropDown(),t(this.element),9==i&&(c.element.focus(),n.preventDefault(),n.stopPropagation())));if(13!=i){if(40==i){var r=o.substring(this.startFrom),a=d.move(1);return""==a&&c.onArrowDown(),this.elementHint.innerText=l+r+a.substring(r.length),this.elementHint.realInnerText=l+a,n.preventDefault(),void n.stopPropagation()}if(38==i){var r=o.substring(this.startFrom),a=d.move(-1);return""==a&&c.onArrowUp(),this.elementHint.innerText=l+r+a.substring(r.length),this.elementHint.realInnerText=l+a,n.preventDefault(),void n.stopPropagation()}}else if(0==this.elementHint.innerText.length)c.onEnter();else{var h="hidden"==s.style.visibility;if(d.hide(),h)return c.hideDropDown(),c.element.focus(),void c.onEnter();this.element.innerText=this.elementHint.realInnerText,c.hideDropDown(),t(this.element),n.preventDefault(),n.stopPropagation()}}}.bind(c),u=function(e){c.hideDropDown()}.bind(c);return d.onmouseselection=function(e,n){n.element.innerText=n.elementHint.innerText=l+e,n.hideDropDown(),window.setTimeout(function(){n.element.focus(),t(n.element)},1)},c}e.exports=n},function(e,t,n){"use strict";var i=n(18),o=n(15),r=n(4),s={};s.create=function(e,t){t=t||{},void 0===t.statusBar&&(t.statusBar=!0),this.options=t,t.indentation?this.indentation=Number(t.indentation):this.indentation=2;var s=t.ace?t.ace:i;if(this.mode="code"==t.mode?"code":"text","code"==this.mode&&void 0===s&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||"ace/theme/jsoneditor","ace/theme/jsoneditor"===this.theme&&s)try{n(22)}catch(e){console.error(e)}t.onTextSelectionChange&&this.onTextSelectionChange(t.onTextSelectionChange);var a=this;this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this._debouncedValidate=r.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){a._onKeyDown(e)},this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var l=document.createElement("button");l.type="button",l.className="jsoneditor-format",l.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(l),l.onclick=function(){try{a.format(),a._onChange()}catch(e){a._onError(e)}};var c=document.createElement("button");c.type="button",c.className="jsoneditor-compact",c.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(c),c.onclick=function(){try{a.compact(),a._onChange()}catch(e){a._onError(e)}};var d=document.createElement("button");d.type="button",d.className="jsoneditor-repair",d.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(d),d.onclick=function(){try{a.repair(),a._onChange()}catch(e){a._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new o(this.menu,this.options.modes,this.options.mode,function(e){a.setMode(e),a.modeSwitcher.focus()}));var h={},u=this.options.onEditable&&typeof("function"===this.options.onEditable)&&!this.options.onEditable(h);if(this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"==this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var p=s.edit(this.editorDom);p.$blockScrolling=1/0,p.setTheme(this.theme),p.setOptions({readOnly:u}),p.setShowPrintMargin(!1),p.setFontSize(13),p.getSession().setMode("ace/mode/json"),p.getSession().setTabSize(this.indentation),p.getSession().setUseSoftTabs(!0),p.getSession().setUseWrapMode(!0),p.commands.bindKey("Ctrl-L",null),p.commands.bindKey("Command-L",null),this.aceEditor=p,this.hasOwnProperty("editor")||Object.defineProperty(this,"editor",{get:function(){return console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor},set:function(e){console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor=e}});var m=document.createElement("a");m.appendChild(document.createTextNode("powered by ace")),m.href="http://ace.ajax.org",m.target="_blank",m.className="jsoneditor-poweredBy",m.onclick=function(){window.open(m.href,m.target)},this.menu.appendChild(m),p.on("change",this._onChange.bind(this)),p.on("changeSelection",this._onSelect.bind(this))}else{var f=document.createElement("textarea");f.className="jsoneditor-text",f.spellcheck=!1,this.content.appendChild(f),this.textarea=f,this.textarea.readOnly=u,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),f.onselect=this._onSelect.bind(this),f.onmousedown=this._onMouseDown.bind(this),f.onblur=this._onBlur.bind(this)}var g=document.createElement("div");if(g.className="validation-errors-container",this.dom.validationErrorsContainer=g,this.frame.appendChild(g),t.statusBar){r.addClassName(this.content,"has-status-bar"),this.curserInfoElements={};var v=document.createElement("div");this.dom.statusBar=v,v.className="jsoneditor-statusbar",this.frame.appendChild(v);var y=document.createElement("span");y.className="jsoneditor-curserinfo-label",y.innerText="Ln:";var b=document.createElement("span");b.className="jsoneditor-curserinfo-val",b.innerText="1",v.appendChild(y),v.appendChild(b);var w=document.createElement("span");w.className="jsoneditor-curserinfo-label",w.innerText="Col:";var x=document.createElement("span");x.className="jsoneditor-curserinfo-val",x.innerText="1",v.appendChild(w),v.appendChild(x),this.curserInfoElements.colVal=x,this.curserInfoElements.lnVal=b;var _=document.createElement("span");_.className="jsoneditor-curserinfo-label",_.innerText="characters selected",_.style.display="none";var C=document.createElement("span");C.className="jsoneditor-curserinfo-count",C.innerText="0",C.style.display="none",this.curserInfoElements.countLabel=_,this.curserInfoElements.countVal=C,v.appendChild(C),v.appendChild(_)}this.setSchema(this.options.schema,this.options.schemaRefs)},s._onChange=function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}},s._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},s._onKeyDown=function(e){var t=e.which||e.keyCode,n=!1;220==t&&e.ctrlKey&&(e.shiftKey?(this.compact(),this._onChange()):(this.format(),this._onChange()),n=!0),n&&(e.preventDefault(),
e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},s._onMouseDown=function(e){this._updateCursorInfo(),this._emitSelectionChange()},s._onBlur=function(e){this._updateCursorInfo(),this._emitSelectionChange()},s._updateCursorInfo=function(){function e(){o.curserInfoElements.countVal.innerText!==i&&(o.curserInfoElements.countVal.innerText=i,o.curserInfoElements.countVal.style.display=i?"inline":"none",o.curserInfoElements.countLabel.style.display=i?"inline":"none"),o.curserInfoElements.lnVal.innerText=t,o.curserInfoElements.colVal.innerText=n}var t,n,i,o=this;if(this.textarea)setTimeout(function(){var s=r.getInputSelection(o.textarea);s.startIndex!==s.endIndex&&(i=s.endIndex-s.startIndex),i&&o.cursorInfo&&o.cursorInfo.line===s.end.row&&o.cursorInfo.column===s.end.column?(t=s.start.row,n=s.start.column):(t=s.end.row,n=s.end.column),o.cursorInfo={line:t,column:n,count:i},o.options.statusBar&&e()},0);else if(this.aceEditor&&this.curserInfoElements){var s=this.aceEditor.getCursorPosition(),a=this.aceEditor.getSelectedText();t=s.row+1,n=s.column+1,i=a.length,o.cursorInfo={line:t,column:n,count:i},this.options.statusBar&&e()}},s._emitSelectionChange=function(){if(this._selectionChangedHandler){var e=this.getTextSelection();this._selectionChangedHandler(e.start,e.end,e.text)}},s.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode==this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},s.compact=function(){var e=this.get(),t=JSON.stringify(e);this.setText(t)},s.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this.setText(t)},s.repair=function(){var e=this.getText(),t=r.sanitize(e);this.setText(t)},s.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},s.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},s.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},s.get=function(){var e,t=this.getText();try{e=r.parse(t)}catch(n){t=r.sanitize(t),e=r.parse(t)}return e},s.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},s.setText=function(e){var t;if(t=!0===this.options.escapeUnicode?r.escapeUnicodeChars(e):e,this.textarea&&(this.textarea.value=t),this.aceEditor){var n=this.options.onChange;this.options.onChange=null,this.aceEditor.setValue(t,-1),this.options.onChange=n}this.validate()},s.validate=function(){this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.content.style.marginBottom="",this.content.style.paddingBottom="");var e,t=!1,n=[];try{e=this.get(),t=!0}catch(e){}if(t&&this.validateSchema){this.validateSchema(e)||(n=this.validateSchema.errors.map(function(e){return r.improveSchemaError(e)}))}if(n.length>0){if(n.length>3){n=n.slice(0,3);var i=this.validateSchema.errors.length-3;n.push("("+i+" more errors...)")}var o=document.createElement("div");o.innerHTML='<table class="jsoneditor-text-errors"><tbody>'+n.map(function(e){return'<tr><td><button class="jsoneditor-schema-error"></button></td>'+("string"==typeof e?'<td colspan="2"><pre>'+e+"</pre></td>":"<td>"+e.dataPath+"</td><td>"+e.message+"</td>")+"</tr>"}).join("")+"</tbody></table>",this.dom.validationErrors=o,this.dom.validationErrorsContainer.appendChild(o);var s=o.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0);this.content.style.marginBottom=-s+"px",this.content.style.paddingBottom=s+"px"}if(this.aceEditor){this.aceEditor.resize(!1)}},s.getTextSelection=function(){var e={};if(this.textarea){var t=r.getInputSelection(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var n=this.aceEditor.getSelection(),i=this.aceEditor.getSelectedText(),o=n.getRange(),s=n.getSelectionLead();return s.row===o.end.row&&s.column===o.end.column?e=o:(e.start=o.end,e.end=o.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:i}}},s.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=r.debounce(e,this.DEBOUNCE_INTERVAL))},s.setTextSelection=function(e,t){if(e&&t)if(this.textarea){var n=r.getIndexForPosition(this.textarea,e.row,e.column),i=r.getIndexForPosition(this.textarea,t.row,t.column);if(n>-1&&i>-1)if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(n,i);else if(this.textarea.createTextRange){var o=this.textarea.createTextRange();o.collapse(!0),o.moveEnd("character",i),o.moveStart("character",n),o.select()}}else if(this.aceEditor){var o={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}};this.aceEditor.selection.setRange(o)}},e.exports=[{mode:"text",mixin:s,data:"text",load:s.format},{mode:"code",mixin:s,data:"text",load:s.format}]},function(e,t,n){var i;if(window.ace)i=window.ace;else try{i=n(!function(){var e=new Error('Cannot find module "brace"');throw e.code="MODULE_NOT_FOUND",e}()),n(19),n(21)}catch(e){}e.exports=i},function(e,t,n){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,n){"use strict";var i=e("../lib/oop"),o=e("./text_highlight_rules").TextHighlightRules,r=function(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}};i.inherits(r,o),t.JsonHighlightRules=r}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,n){"use strict";var i=e("../range").Range,o=function(){};(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var n=e.getLine(t),o=n.match(/^(\s*\})/);if(!o)return 0;var r=o[1].length,s=e.findMatchingBracket({row:t,column:r});if(!s||s.row==t)return 0;var a=this.$getIndent(e.getLine(s.row));e.replace(new i(t,0,t,r-1),a)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(o.prototype),t.MatchingBraceOutdent=o}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,n){"use strict";var i=e("../../lib/oop"),o=e("../../range").Range,r=e("./fold_mode").FoldMode,s=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};i.inherits(s,r),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,n){var i=e.getLine(n);if(this.singleLineBlockCommentRe.test(i)&&!this.startRegionRe.test(i)&&!this.tripleStarBlockCommentRe.test(i))return"";var o=this._getFoldWidgetBase(e,t,n);return!o&&this.startRegionRe.test(i)?"start":o},this.getFoldWidgetRange=function(e,t,n,i){var o=e.getLine(n);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,n);var r=o.match(this.foldingStartMarker);if(r){var s=r.index;if(r[1])return this.openingBracketBlock(e,r[1],n,s);var a=e.getCommentFoldRange(n,s+r[0].length,1);return a&&!a.isMultiLine()&&(i?a=this.getSectionRange(e,n):"all"!=t&&(a=null)),a}if("markbegin"!==t){var r=o.match(this.foldingStopMarker);if(r){var s=r.index+r[0].length;return r[1]?this.closingBracketBlock(e,r[1],n,s):e.getCommentFoldRange(n,s,-1)}}},this.getSectionRange=function(e,t){var n=e.getLine(t),i=n.search(/\S/),r=t,s=n.length;t+=1;for(var a=t,l=e.getLength();++t<l;){n=e.getLine(t);var c=n.search(/\S/);if(-1!==c){if(i>c)break;var d=this.getFoldWidgetRange(e,"all",t);if(d){if(d.start.row<=r)break;if(d.isMultiLine())t=d.end.row;else if(i==c)break}a=t}}return new o(r,s,a,e.getLine(a).length)},this.getCommentRegionBlock=function(e,t,n){for(var i=t.search(/\s*$/),r=e.getLength(),s=n,a=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,l=1;++n<r;){t=e.getLine(n);var c=a.exec(t);if(c&&(c[1]?l--:l++,!l))break}var d=n;if(d>s)return new o(s,i,d,t.length)}}.call(s.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,i){"use strict";var o=e("../lib/oop"),r=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,d=e("../worker/worker_client").WorkerClient,h=function(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c};o.inherits(h,r),function(){this.getNextLineIndent=function(e,t,n){var i=this.$getIndent(t);if("start"==e){t.match(/^.*[\{\(\[]\s*$/)&&(i+=n)}return i},this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)},this.createWorker=function(e){var t=new d(["ace"],n(20),"JsonWorker");return t.attachToDocument(e.getDocument()),t.on("annotate",function(t){e.setAnnotations(t.data)}),t.on("terminate",function(){e.clearAnnotations()}),t},this.$id="ace/mode/json"}.call(h.prototype),t.Mode=h})},function(e,t){e.exports.id="ace/mode/json_worker",e.exports.src='"no use strict";!function(window){function resolveModuleId(id,paths){for(var testPath=id,tail="";testPath;){var alias=paths[testPath];if("string"==typeof alias)return alias+tail;if(alias)return alias.location.replace(/\\/*$/,"/")+(tail||alias.main||alias.name);if(alias===!1)return"";var i=testPath.lastIndexOf("/");if(-1===i)break;tail=testPath.substr(i)+tail,testPath=testPath.slice(0,i)}return id}if(!(void 0!==window.window&&window.document||window.acequire&&window.define)){window.console||(window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console),window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,data:err.data,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function acequire(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;if(!window.acequire.tlns)return console.log("unable to load "+id);var path=resolveModuleId(id,window.acequire.tlns);return".js"!=path.slice(-3)&&(path+=".js"),window.acequire.id=id,window.acequire.modules[id]={},importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},acequire.tlns={},window.initBaseUrls=function(topLevelNamespaces){for(var i in topLevelNamespaces)acequire.tlns[i]=topLevelNamespaces[i]},window.initSender=function(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.event&&sender)sender._signal(msg.event,msg.data);else if(msg.command)if(main[msg.command])main[msg.command].apply(main,msg.args);else{if(!window[msg.command])throw Error("Unknown command:"+msg.command);window[msg.command].apply(window,msg.args)}else if(msg.init){window.initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=window.initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}}}}(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/apply_delta",["require","exports","module"],function(acequire,exports){"use strict";exports.applyDelta=function(docLines,delta){var row=delta.start.row,startColumn=delta.start.column,line=docLines[row]||"";switch(delta.action){case"insert":var lines=delta.lines;if(1===lines.length)docLines[row]=line.substring(0,startColumn)+delta.lines[0]+line.substring(startColumn);else{var args=[row,1].concat(delta.lines);docLines.splice.apply(docLines,args),docLines[row]=line.substring(0,startColumn)+docLines[row],docLines[row+delta.lines.length-1]+=line.substring(startColumn)}break;case"remove":var endColumn=delta.end.column,endRow=delta.end.row;row===endRow?docLines[row]=line.substring(0,startColumn)+line.substring(endColumn):docLines.splice(row,endRow-row+1,line.substring(0,startColumn)+docLines[endRow].substring(endColumn))}}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){function $pointsInOrder(point1,point2,equalPointsInOrder){var bColIsAfter=equalPointsInOrder?point1.column<=point2.column:point1.column<point2.column;return point1.row<point2.row||point1.row==point2.row&&bColIsAfter}function $getTransformedPoint(delta,point,moveIfEqual){var deltaIsInsert="insert"==delta.action,deltaRowShift=(deltaIsInsert?1:-1)*(delta.end.row-delta.start.row),deltaColShift=(deltaIsInsert?1:-1)*(delta.end.column-delta.start.column),deltaStart=delta.start,deltaEnd=deltaIsInsert?deltaStart:delta.end;return $pointsInOrder(point,deltaStart,moveIfEqual)?{row:point.row,column:point.column}:$pointsInOrder(deltaEnd,point,!moveIfEqual)?{row:point.row+deltaRowShift,column:point.column+(point.row==deltaEnd.row?deltaColShift:0)}:{row:deltaStart.row,column:deltaStart.column}}oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(delta){if(!(delta.start.row==delta.end.row&&delta.start.row!=this.row||delta.start.row>this.row)){var point=$getTransformedPoint(delta,{row:this.row,column:this.column},this.$insertRight);this.setPosition(point.row,point.column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),applyDelta=acequire("./apply_delta").applyDelta,EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(textOrLines){this.$lines=[""],0===textOrLines.length?this.$lines=[""]:Array.isArray(textOrLines)?this.insertMergedLines({row:0,column:0},textOrLines):this.insert({row:0,column:0},textOrLines)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength()-1;this.remove(new Range(0,0,len,this.getLine(len).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){return this.getLinesForRange(range).join(this.getNewLineCharacter())},this.getLinesForRange=function(range){var lines;if(range.start.row===range.end.row)lines=[this.getLine(range.start.row).substring(range.start.column,range.end.column)];else{lines=this.getLines(range.start.row,range.end.row),lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column))}return lines},this.insertLines=function(row,lines){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(row,lines)},this.removeLines=function(firstRow,lastRow){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(firstRow,lastRow)},this.insertNewLine=function(position){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead."),this.insertMergedLines(position,["",""])},this.insert=function(position,text){return 1>=this.getLength()&&this.$detectNewLine(text),this.insertMergedLines(position,this.$split(text))},this.insertInLine=function(position,text){var start=this.clippedPos(position.row,position.column),end=this.pos(position.row,position.column+text.length);return this.applyDelta({start:start,end:end,action:"insert",lines:[text]},!0),this.clonePos(end)},this.clippedPos=function(row,column){var length=this.getLength();void 0===row?row=length:0>row?row=0:row>=length&&(row=length-1,column=void 0);var line=this.getLine(row);return void 0==column&&(column=line.length),column=Math.min(Math.max(column,0),line.length),{row:row,column:column}},this.clonePos=function(pos){return{row:pos.row,column:pos.column}},this.pos=function(row,column){return{row:row,column:column}},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):(position.row=Math.max(0,position.row),position.column=Math.min(Math.max(position.column,0),this.getLine(position.row).length)),position},this.insertFullLines=function(row,lines){row=Math.min(Math.max(row,0),this.getLength());var column=0;this.getLength()>row?(lines=lines.concat([""]),column=0):(lines=[""].concat(lines),row--,column=this.$lines[row].length),this.insertMergedLines({row:row,column:column},lines)},this.insertMergedLines=function(position,lines){var start=this.clippedPos(position.row,position.column),end={row:start.row+lines.length-1,column:(1==lines.length?start.column:0)+lines[lines.length-1].length};return this.applyDelta({start:start,end:end,action:"insert",lines:lines}),this.clonePos(end)},this.remove=function(range){var start=this.clippedPos(range.start.row,range.start.column),end=this.clippedPos(range.end.row,range.end.column);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})}),this.clonePos(start)},this.removeInLine=function(row,startColumn,endColumn){var start=this.clippedPos(row,startColumn),end=this.clippedPos(row,endColumn);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})},!0),this.clonePos(start)},this.removeFullLines=function(firstRow,lastRow){firstRow=Math.min(Math.max(0,firstRow),this.getLength()-1),lastRow=Math.min(Math.max(0,lastRow),this.getLength()-1);var deleteFirstNewLine=lastRow==this.getLength()-1&&firstRow>0,deleteLastNewLine=this.getLength()-1>lastRow,startRow=deleteFirstNewLine?firstRow-1:firstRow,startCol=deleteFirstNewLine?this.getLine(startRow).length:0,endRow=deleteLastNewLine?lastRow+1:lastRow,endCol=deleteLastNewLine?0:this.getLine(endRow).length,range=new Range(startRow,startCol,endRow,endCol),deletedLines=this.$lines.slice(firstRow,lastRow+1);return this.applyDelta({start:range.start,end:range.end,action:"remove",lines:this.getLinesForRange(range)}),deletedLines},this.removeNewLine=function(row){this.getLength()-1>row&&row>=0&&this.applyDelta({start:this.pos(row,this.getLine(row).length),end:this.pos(row+1,0),action:"remove",lines:["",""]})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0===text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;this.remove(range);var end;return end=text?this.insert(range.start,text):range.start},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++)this.applyDelta(deltas[i])},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--)this.revertDelta(deltas[i])},this.applyDelta=function(delta,doNotValidate){var isInsert="insert"==delta.action;(isInsert?1>=delta.lines.length&&!delta.lines[0]:!Range.comparePoints(delta.start,delta.end))||(isInsert&&delta.lines.length>2e4&&this.$splitAndapplyLargeDelta(delta,2e4),applyDelta(this.$lines,delta,doNotValidate),this._signal("change",delta))},this.$splitAndapplyLargeDelta=function(delta,MAX){for(var lines=delta.lines,l=lines.length,row=delta.start.row,column=delta.start.column,from=0,to=0;;){from=to,to+=MAX-1;var chunk=lines.slice(from,to);if(to>l){delta.lines=chunk,delta.start.row=row+from,delta.start.column=column;break}chunk.push(""),this.applyDelta({start:this.pos(row+from,column),end:this.pos(row+to,column=0),action:delta.action,lines:chunk},!0)}},this.revertDelta=function(delta){this.applyDelta({start:this.clonePos(delta.start),end:this.clonePos(delta.end),action:"insert"==delta.action?"remove":"insert",lines:delta.lines.slice()})},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function deepCopy(obj){if("object"!=typeof obj||!obj)return obj;var copy;if(Array.isArray(obj)){copy=[];for(var key=0;obj.length>key;key++)copy[key]=deepCopy(obj[key]);return copy}if("[object Object]"!==Object.prototype.toString.call(obj))return obj;copy={};for(var key in obj)copy[key]=deepCopy(obj[key]);return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";acequire("../range").Range;var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){var data=e.data;if(data[0].start)doc.applyDeltas(data);else for(var i=0;data.length>i;i+=2){if(Array.isArray(data[i+1]))var d={action:"insert",start:data[i],lines:data[i+1]};else var d={action:"remove",start:data[i],end:data[i+1]};doc.applyDelta(d,!0)}return _self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"\t"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue(),errors=[];try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);errors.push({row:pos.row,column:pos.column,text:e.message,type:"error"})}this.sender.emit("annotate",errors)}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0\n}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;for(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="\t\\n\v\\f\\r   ᠎             　\\u2028\\u2029\ufeff";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});'},function(e,t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,n){"use strict";var i=e("../lib/dom"),o=e("../lib/lang"),r=e("../lib/event"),s=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys");i.importCssString('\t.ace_search {\tbackground-color: #ddd;\tcolor: #666;\tborder: 1px solid #cbcbcb;\tborder-top: 0 none;\toverflow: hidden;\tmargin: 0;\tpadding: 4px 6px 0 4px;\tposition: absolute;\ttop: 0;\tz-index: 99;\twhite-space: normal;\t}\t.ace_search.left {\tborder-left: 0 none;\tborder-radius: 0px 0px 5px 0px;\tleft: 0;\t}\t.ace_search.right {\tborder-radius: 0px 0px 0px 5px;\tborder-right: 0 none;\tright: 0;\t}\t.ace_search_form, .ace_replace_form {\tmargin: 0 20px 4px 0;\toverflow: hidden;\tline-height: 1.9;\t}\t.ace_replace_form {\tmargin-right: 0;\t}\t.ace_search_form.ace_nomatch {\toutline: 1px solid red;\t}\t.ace_search_field {\tborder-radius: 3px 0 0 3px;\tbackground-color: white;\tcolor: black;\tborder: 1px solid #cbcbcb;\tborder-right: 0 none;\tbox-sizing: border-box!important;\toutline: 0;\tpadding: 0;\tfont-size: inherit;\tmargin: 0;\tline-height: inherit;\tpadding: 0 6px;\tmin-width: 17em;\tvertical-align: top;\t}\t.ace_searchbtn {\tborder: 1px solid #cbcbcb;\tline-height: inherit;\tdisplay: inline-block;\tpadding: 0 6px;\tbackground: #fff;\tborder-right: 0 none;\tborder-left: 1px solid #dcdcdc;\tcursor: pointer;\tmargin: 0;\tposition: relative;\tbox-sizing: content-box!important;\tcolor: #666;\t}\t.ace_searchbtn:last-child {\tborder-radius: 0 3px 3px 0;\tborder-right: 1px solid #cbcbcb;\t}\t.ace_searchbtn:disabled {\tbackground: none;\tcursor: default;\t}\t.ace_searchbtn:hover {\tbackground-color: #eef1f6;\t}\t.ace_searchbtn.prev, .ace_searchbtn.next {\tpadding: 0px 0.7em\t}\t.ace_searchbtn.prev:after, .ace_searchbtn.next:after {\tcontent: "";\tborder: solid 2px #888;\twidth: 0.5em;\theight: 0.5em;\tborder-width:  2px 0 0 2px;\tdisplay:inline-block;\ttransform: rotate(-45deg);\t}\t.ace_searchbtn.next:after {\tborder-width: 0 2px 2px 0 ;\t}\t.ace_searchbtn_close {\tbackground: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;\tborder-radius: 50%;\tborder: 0 none;\tcolor: #656565;\tcursor: pointer;\tfont: 16px/16px Arial;\tpadding: 0;\theight: 14px;\twidth: 14px;\ttop: 9px;\tright: 7px;\tposition: absolute;\t}\t.ace_searchbtn_close:hover {\tbackground-color: #656565;\tbackground-position: 50% 100%;\tcolor: white;\t}\t.ace_button {\tmargin-left: 2px;\tcursor: pointer;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\toverflow: hidden;\topacity: 0.7;\tborder: 1px solid rgba(100,100,100,0.23);\tpadding: 1px;\tbox-sizing:    border-box!important;\tcolor: black;\t}\t.ace_button:hover {\tbackground-color: #eee;\topacity:1;\t}\t.ace_button:active {\tbackground-color: #ddd;\t}\t.ace_button.checked {\tborder-color: #3399ff;\topacity:1;\t}\t.ace_search_options{\tmargin-bottom: 3px;\ttext-align: right;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\tclear: both;\t}\t.ace_search_counter {\tfloat: left;\tfont-family: arial;\tpadding: 0 8px;\t}',"ace_searchbox");var l='<div class="ace_search right">\t    <span action="hide" class="ace_searchbtn_close"></span>\t    <div class="ace_search_form">\t        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>\t        <span action="findPrev" class="ace_searchbtn prev"></span>\t        <span action="findNext" class="ace_searchbtn next"></span>\t        <span action="findAll" class="ace_searchbtn" title="Alt-Enter">All</span>\t    </div>\t    <div class="ace_replace_form">\t        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>\t        <span action="replaceAndFindNext" class="ace_searchbtn">Replace</span>\t        <span action="replaceAll" class="ace_searchbtn">All</span>\t    </div>\t    <div class="ace_search_options">\t        <span action="toggleReplace" class="ace_button" title="Toggel Replace mode"\t            style="float:left;margin-top:-2px;padding:0 5px;">+</span>\t        <span class="ace_search_counter"></span>\t        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>\t        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>\t        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>\t        <span action="searchInSelection" class="ace_button" title="Search In Selection">S</span>\t    </div>\t</div>'.replace(/> +/g,">"),c=function(e,t,n){var o=i.createElement("div");o.innerHTML=l,this.element=o.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e)};(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var t=this;r.addListener(e,"mousedown",function(e){setTimeout(function(){t.activeInput.focus()},0),r.stopPropagation(e)}),r.addListener(e,"click",function(e){var n=e.target||e.srcElement,i=n.getAttribute("action");i&&t[i]?t[i]():t.$searchBarKb.commands[i]&&t.$searchBarKb.commands[i].exec(t),r.stopPropagation(e)}),r.addCommandKeyListener(e,function(e,n,i){var o=a.keyCodeToString(i),s=t.$searchBarKb.findKeyCommand(n,o);s&&s.exec&&(s.exec(t),r.stopEvent(e))}),this.$onChange=o.delayedCall(function(){t.find(!1,!1)}),r.addListener(this.searchInput,"input",function(){t.$onChange.schedule(20)}),r.addListener(this.searchInput,"focus",function(){t.activeInput=t.searchInput,t.searchInput.value&&t.highlight()}),r.addListener(this.replaceInput,"focus",function(){t.activeInput=t.replaceInput,t.searchInput.value&&t.highlight()})},this.$closeSearchBarKb=new s([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new s,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus()},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){this.searchRange=e,e?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){i.setCssClass(this.replaceOption,"checked",this.searchRange),i.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",i.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),i.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),i.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked),this.replaceBox.style.display=this.replaceOption.checked?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,n){var o=this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:n,range:this.searchRange}),r=!o&&this.searchInput.value;i.setCssClass(this.searchBox,"ace_nomatch",r),this.editor._emit("findSearchBox",{match:!r}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,n=0,i=0;if(t){var o=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),r=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(r-=e.session.doc.positionToIndex(this.searchRange.start));for(var s,a=t.lastIndex=0;(s=t.exec(o))&&(n++,a=s.index,a<=r&&i++,!(n>999))&&(s[0]||(t.lastIndex=a+=1,!(a>=o.length))););}this.searchCounter.textContent=i+" of "+(n>999?"999+":n)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){
var e=this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked}),t=!e&&this.searchInput.value;i.setCssClass(this.searchBox,"ace_nomatch",t),this.editor._emit("findSearchBox",{match:!t}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){(e.searchBox||new c(e)).show(e.session.getTextRange(),t)}}),function(){ace.acequire(["ace/ext/searchbox"],function(){})}()},function(e,t){ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,n){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\tbackground: #ebebeb;\tcolor: #333\t}\t\t.ace-jsoneditor.ace_editor {\tfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\tline-height: 1.3;\tbackground-color: #fff;\t}\t.ace-jsoneditor .ace_print-margin {\twidth: 1px;\tbackground: #e8e8e8\t}\t.ace-jsoneditor .ace_scroller {\tbackground-color: #FFFFFF\t}\t.ace-jsoneditor .ace_text-layer {\tcolor: gray\t}\t.ace-jsoneditor .ace_variable {\tcolor: #1a1a1a\t}\t.ace-jsoneditor .ace_cursor {\tborder-left: 2px solid #000000\t}\t.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\tborder-left: 0px;\tborder-bottom: 1px solid #000000\t}\t.ace-jsoneditor .ace_marker-layer .ace_selection {\tbackground: lightgray\t}\t.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\tbox-shadow: 0 0 3px 0px #FFFFFF;\tborder-radius: 2px\t}\t.ace-jsoneditor .ace_marker-layer .ace_step {\tbackground: rgb(255, 255, 0)\t}\t.ace-jsoneditor .ace_marker-layer .ace_bracket {\tmargin: -1px 0 0 -1px;\tborder: 1px solid #BFBFBF\t}\t.ace-jsoneditor .ace_marker-layer .ace_active-line {\tbackground: #FFFBD1\t}\t.ace-jsoneditor .ace_gutter-active-line {\tbackground-color : #dcdcdc\t}\t.ace-jsoneditor .ace_marker-layer .ace_selected-word {\tborder: 1px solid lightgray\t}\t.ace-jsoneditor .ace_invisible {\tcolor: #BFBFBF\t}\t.ace-jsoneditor .ace_keyword,\t.ace-jsoneditor .ace_meta,\t.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\tcolor: #AF956F\t}\t.ace-jsoneditor .ace_keyword.ace_operator {\tcolor: #484848\t}\t.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\tcolor: #96DC5F\t}\t.ace-jsoneditor .ace_constant.ace_language {\tcolor: darkorange\t}\t.ace-jsoneditor .ace_constant.ace_numeric {\tcolor: red\t}\t.ace-jsoneditor .ace_constant.ace_character.ace_entity {\tcolor: #BF78CC\t}\t.ace-jsoneditor .ace_invalid {\tcolor: #FFFFFF;\tbackground-color: #FF002A;\t}\t.ace-jsoneditor .ace_fold {\tbackground-color: #AF956F;\tborder-color: #000000\t}\t.ace-jsoneditor .ace_storage,\t.ace-jsoneditor .ace_support.ace_class,\t.ace-jsoneditor .ace_support.ace_function,\t.ace-jsoneditor .ace_support.ace_other,\t.ace-jsoneditor .ace_support.ace_type {\tcolor: #C52727\t}\t.ace-jsoneditor .ace_string {\tcolor: green\t}\t.ace-jsoneditor .ace_comment {\tcolor: #BCC8BA\t}\t.ace-jsoneditor .ace_entity.ace_name.ace_tag,\t.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\tcolor: #606060\t}\t.ace-jsoneditor .ace_markup.ace_underline {\ttext-decoration: underline\t}\t.ace-jsoneditor .ace_indent-guide {\tbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\t}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})}])});
//# sourceMappingURL=jsoneditor-minimalist.map