/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2017 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 5.24.7
 * @date    2018-10-08
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(this,function(){return function(e){function t(n){if(i[n])return i[n].exports;var r=i[n]={exports:{},id:n,loaded:!1};return e[n].call(r.exports,r,r.exports,t),r.loaded=!0,r.exports}var i={};return t.m=e,t.c=i,t.p="",t(0)}([function(e,t,i){"use strict";function n(e,t,i){if(!(this instanceof n))throw new Error('JSONEditor constructor called without "new".');var r=c.getInternetExplorerVersion();if(-1!=r&&r<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"===t.mode||"code"===t.mode||t.modes&&(-1!==t.modes.indexOf("text")||-1!==t.modes.indexOf("code")))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),t&&Object.keys(t).forEach(function(e){-1===n.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})),arguments.length&&this._create(e,t,i)}var r;try{r=i(1)}catch(e){}var o=i(51),s=i(57),a=i(59),l=i(81),c=i(65);"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),n.modes={},n.prototype.DEBOUNCE_INTERVAL=150,n.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onEditable","onError","onEvent","onModeChange","onValidate","onSelectionChange","onTextSelectionChange","colorPicker","onColorPicker","timestampTag","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","languages","language"],n.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(n)},n.prototype.destroy=function(){},n.prototype.set=function(e){this.json=e},n.prototype.get=function(){return this.json},n.prototype.setText=function(e){this.json=c.parse(e)},n.prototype.getText=function(){return JSON.stringify(this.json)},n.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},n.prototype.getName=function(){return this.options&&this.options.name},n.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t,i,r=this.container,o=c.extend({},this.options),s=o.mode;o.mode=e;var a=n.modes[e];if(!a)throw new Error('Unknown mode "'+o.mode+'"');try{var l="text"==a.data;if(i=this.getName(),t=this[l?"getText":"get"](),this.destroy(),c.clear(this),c.extend(this,a.mixin),this.create(r,o),this.setName(i),this[l?"setText":"set"](t),"function"==typeof a.load)try{a.load.call(this)}catch(e){console.error(e)}if("function"==typeof o.onModeChange&&e!==s)try{o.onModeChange(e,s)}catch(e){console.error(e)}}catch(e){this._onError(e)}}},n.prototype.getMode=function(){return this.options.mode},n.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},n.prototype.setSchema=function(e,t){if(e){var i;try{i=this.options.ajv||r({allErrors:!0,verbose:!0})}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},n.prototype.validate=function(){},n.prototype.refresh=function(){},n.registerMode=function(e){var t,i;if(c.isArray(e))for(t=0;t<e.length;t++)n.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var r=e.mode;if(r in n.modes)throw new Error('Mode "'+r+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var o=["setMode","registerMode","modes"];for(t=0;t<o.length;t++)if((i=o[t])in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');n.modes[r]=e}},n.registerMode(a),n.registerMode(l),n.ace=o,n.Ajv=r,n.VanillaPicker=s,n.default=n,e.exports=n},function(e,t,i){"use strict";function n(e){if(!(this instanceof n))return new n(e);e=this._opts=N.copy(e)||{},k(this),this._schemas={},this._refs={},this._fragments={},this._formats=P(e.format);var t=this._schemaUriFormat=this._formats["uri-reference"];this._schemaUriFormatFunc=function(e){return t.test(e)},this._cache=e.cache||new L,this._loadingSchemas={},this._compilations=[],this.RULES=M(),this._getId=v(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=T),this._metaOpts=_(this),e.formats&&x(this),E(this),"object"==typeof e.meta&&this.addMetaSchema(e.meta),F(this),e.patternGroups&&I(this)}function r(e,t){var i;if("string"==typeof e){if(!(i=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{var n=this._addSchema(e);i=n.validate||this._compile(n)}var r=i(t);return!0===i.$async?"*"==this._opts.async?j(r):r:(this.errors=i.errors,r)}function o(e,t){var i=this._addSchema(e,void 0,t);return i.validate||this._compile(i)}function s(e,t,i,n){if(Array.isArray(e)){for(var r=0;r<e.length;r++)this.addSchema(e[r],void 0,i,n);return this}var o=this._getId(e);if(void 0!==o&&"string"!=typeof o)throw new Error("schema id must be string");return t=B.normalizeId(t||o),S(this,t),this._schemas[t]=this._addSchema(e,i,n,!0),this}function a(e,t,i){return this.addSchema(e,t,i,!0),this}function l(e,t){var i=e.$schema;if(void 0!==i&&"string"!=typeof i)throw new Error("$schema must be a string");if(!(i=i||this._opts.defaultMeta||c(this)))return this.logger.warn("meta-schema not available"),this.errors=null,!0;var n=this._formats.uri;this._formats.uri="function"==typeof n?this._schemaUriFormatFunc:this._schemaUriFormat;var r;try{r=this.validate(i,e)}finally{this._formats.uri=n}if(!r&&t){var o="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(o);this.logger.error(o)}return r}function c(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(W)?W:void 0,e._opts.defaultMeta}function h(e){var t=u(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return d(this,e)}}function d(e,t){var i=B.schema.call(e,{schema:{}},t);if(i){var n=i.schema,r=i.root,o=i.baseId,s=$.call(e,n,r,void 0,o);return e._fragments[t]=new R({ref:t,fragment:!0,schema:n,root:r,baseId:o,validate:s}),s}}function u(e,t){return t=B.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function f(e){if(e instanceof RegExp)return p(this,this._schemas,e),p(this,this._refs,e),this;switch(typeof e){case"undefined":return p(this,this._schemas),p(this,this._refs),this._cache.clear(),this;case"string":var t=u(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":var i=this._opts.serialize,n=i?i(e):e;this._cache.del(n);var r=this._getId(e);r&&(r=B.normalizeId(r),delete this._schemas[r],delete this._refs[r])}return this}function p(e,t,i){for(var n in t){var r=t[n];r.meta||i&&!i.test(n)||(e._cache.del(r.cacheKey),delete t[n])}}function m(e,t,i,n){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var r=this._opts.serialize,o=r?r(e):e,s=this._cache.get(o);if(s)return s;n=n||!1!==this._opts.addUsedSchema;var a=B.normalizeId(this._getId(e));a&&n&&S(this,a);var l,c=!1!==this._opts.validateSchema&&!t;c&&!(l=a&&a==B.normalizeId(e.$schema))&&this.validateSchema(e,!0);var h=B.ids.call(this,e),d=new R({id:a,schema:e,localRefs:h,cacheKey:o,meta:i});return"#"!=a[0]&&n&&(this._refs[a]=d),this._cache.put(o,d),c&&l&&this.validateSchema(e,!0),d}function g(e,t){function i(){var t=e.validate,n=t.apply(null,arguments);return i.errors=t.errors,n}if(e.compiling)return e.validate=i,i.schema=e.schema,i.errors=null,i.root=t||i,!0===e.schema.$async&&(i.$async=!0),i;e.compiling=!0;var n;e.meta&&(n=this._opts,this._opts=this._metaOpts);var r;try{r=$.call(this,e.schema,t,e.localRefs)}finally{e.compiling=!1,e.meta&&(this._opts=n)}return e.validate=r,e.refs=r.refs,e.refVal=r.refVal,e.root=r.root,r}function v(e){switch(e.schemaId){case"$id":return w;case"id":return y;default:return b}}function y(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function w(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function b(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function C(e,t){if(!(e=e||this.errors))return"No errors";t=t||{};for(var i=void 0===t.separator?", ":t.separator,n=void 0===t.dataVar?"data":t.dataVar,r="",o=0;o<e.length;o++){var s=e[o];s&&(r+=n+s.dataPath+" "+s.message+i)}return r.slice(0,-i.length)}function A(e,t){return"string"==typeof t&&(t=new RegExp(t)),this._formats[e]=t,this}function E(e){var t;if(e._opts.$data&&(t=i(49),e.addMetaSchema(t,t.$id,!0)),!1!==e._opts.meta){var n=i(50);e._opts.$data&&(n=O(n,U)),e.addMetaSchema(n,W,!0),e._refs["http://json-schema.org/schema"]=W}}function F(e){var t=e._opts.schemas;if(t)if(Array.isArray(t))e.addSchema(t);else for(var i in t)e.addSchema(t[i],i)}function x(e){for(var t in e._opts.formats){var i=e._opts.formats[t];e.addFormat(t,i)}}function S(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function _(e){for(var t=N.copy(e._opts),i=0;i<z.length;i++)delete t[z[i]];return t}function k(e){var t=e._opts.logger;if(!1===t)e.logger={log:D,warn:D,error:D};else{if(void 0===t&&(t=console),!("object"==typeof t&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");e.logger=t}}function D(){}var $=i(2),B=i(3),L=i(19),R=i(13),T=i(16),P=i(20),M=i(21),O=i(44),I=i(45),N=i(11),j=i(18);e.exports=n,n.prototype.validate=r,n.prototype.compile=o,n.prototype.addSchema=s,n.prototype.addMetaSchema=a,n.prototype.validateSchema=l,n.prototype.getSchema=h,n.prototype.removeSchema=f,n.prototype.addFormat=A,n.prototype.errorsText=C,n.prototype._addSchema=m,n.prototype._compile=g,n.prototype.compileAsync=i(46);var H=i(47);n.prototype.addKeyword=H.add,n.prototype.getKeyword=H.get,n.prototype.removeKeyword=H.remove;var V=i(15);n.ValidationError=V.Validation,n.MissingRefError=V.MissingRef,n.$dataMetaSchema=O;var W="http://json-schema.org/draft-06/schema",z=["removeAdditional","useDefaults","coerceTypes"],U=["/properties"]},function(e,t,i){"use strict";function n(e,t,i,s){function C(){var e=H.validate,t=e.apply(null,arguments);return C.errors=e.errors,t}function A(e,i,r,o){var s=!i||i&&i.schema==e;if(i.schema!=t.schema)return n.call(B,e,i,r,o);var m=!0===e.$async,C=g({isTop:!0,schema:e,isRoot:s,baseId:o,root:i,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:p.MissingRef,RULES:W,validate:g,util:f,resolve:u,resolveRef:E,usePattern:k,useDefault:D,useCustomRule:$,opts:L,formats:V,logger:B.logger,self:B});C=d(R,c)+d(P,a)+d(O,l)+d(N,h)+C,L.processCode&&(C=L.processCode(C));var A;try{A=new Function("self","RULES","formats","root","refVal","defaults","customRules","co","equal","ucs2length","ValidationError",C)(B,W,V,t,R,O,N,v,w,y,b),R[0]=A}catch(e){throw B.logger.error("Error compiling schema, function code:",C),e}return A.schema=e,A.errors=null,A.refs=T,A.refVal=R,A.root=s?A:i,m&&(A.$async=!0),!0===L.sourceCode&&(A.source={code:C,patterns:P,defaults:O}),A}function E(e,r,o){r=u.url(e,r);var s,a,l=T[r];if(void 0!==l)return s=R[l],a="refVal["+l+"]",_(s,a);if(!o&&t.refs){var c=t.refs[r];if(void 0!==c)return s=t.refVal[c],a=F(r,s),_(s,a)}a=F(r);var h=u.call(B,A,t,r);if(void 0===h){var d=i&&i[r];d&&(h=u.inlineRef(d,L.inlineRefs)?d:n.call(B,d,t,i,e))}if(void 0!==h)return S(r,h),_(h,a);x(r)}function F(e,t){var i=R.length;return R[i]=t,T[e]=i,"refVal"+i}function x(e){delete T[e]}function S(e,t){var i=T[e];R[i]=t}function _(e,t){return"object"==typeof e||"boolean"==typeof e?{code:t,schema:e,inline:!0}:{code:t,$async:e&&e.$async}}function k(e){var t=M[e];return void 0===t&&(t=M[e]=P.length,P[t]=e),"pattern"+t}function D(e){switch(typeof e){case"boolean":case"number":return""+e;case"string":return f.toQuotedString(e);case"object":if(null===e)return"null";var t=m(e),i=I[t];return void 0===i&&(i=I[t]=O.length,O[i]=e),"default"+i}}function $(e,t,i,n){var r=e.definition.validateSchema;if(r&&!1!==B._opts.validateSchema){if(!r(t)){var o="keyword schema is invalid: "+B.errorsText(r.errors);if("log"!=B._opts.validateSchema)throw new Error(o);B.logger.error(o)}}var s,a=e.definition.compile,l=e.definition.inline,c=e.definition.macro;if(a)s=a.call(B,t,i,n);else if(c)s=c.call(B,t,i,n),!1!==L.validateSchema&&B.validateSchema(s,!0);else if(l)s=l.call(B,n,e.keyword,t,i);else if(!(s=e.definition.validate))return;if(void 0===s)throw new Error('custom keyword "'+e.keyword+'"failed to compile');var h=N.length;return N[h]=s,{code:"customRule"+h,validate:s}}var B=this,L=this._opts,R=[void 0],T={},P=[],M={},O=[],I={},N=[];t=t||{schema:e,refVal:R,refs:T};var j=r.call(this,e,t,s),H=this._compilations[j.index];if(j.compiling)return H.callValidate=C;var V=this._formats,W=this.RULES;try{var z=A(e,t,i,s);H.validate=z;var U=H.callValidate;return U&&(U.schema=z.schema,U.errors=null,U.refs=z.refs,U.refVal=z.refVal,U.root=z.root,U.$async=z.$async,L.sourceCode&&(U.source=z.source)),z}finally{o.call(this,e,t,s)}}function r(e,t,i){var n=s.call(this,e,t,i);return n>=0?{index:n,compiling:!0}:(n=this._compilations.length,this._compilations[n]={schema:e,root:t,baseId:i},{index:n,compiling:!1})}function o(e,t,i){var n=s.call(this,e,t,i);n>=0&&this._compilations.splice(n,1)}function s(e,t,i){for(var n=0;n<this._compilations.length;n++){var r=this._compilations[n];if(r.schema==e&&r.root==t&&r.baseId==i)return n}return-1}function a(e,t){return"var pattern"+e+" = new RegExp("+f.toQuotedString(t[e])+");"}function l(e){return"var default"+e+" = defaults["+e+"];"}function c(e,t){return void 0===t[e]?"":"var refVal"+e+" = refVal["+e+"];"}function h(e){return"var customRule"+e+" = customRules["+e+"];"}function d(e,t){if(!e.length)return"";for(var i="",n=0;n<e.length;n++)i+=t(n,e);return i}var u=i(3),f=i(11),p=i(15),m=i(16),g=i(17),v=i(18),y=f.ucs2length,w=i(10),b=p.Validation;e.exports=n},function(e,t,i){"use strict";function n(e,t,i){var o=this._refs[i];if("string"==typeof o){if(!this._refs[o])return n.call(this,e,t,o);o=this._refs[o]}if((o=o||this._schemas[i])instanceof y)return a(o.schema,this._opts.inlineRefs)?o.schema:o.validate||this._compile(o);var s,l,c,h=r.call(this,t,i);return h&&(s=h.schema,t=h.root,c=h.baseId),s instanceof y?l=s.validate||e.call(this,s.schema,t,void 0,c):void 0!==s&&(l=a(s,this._opts.inlineRefs)?s:e.call(this,s,t,void 0,c)),l}function r(e,t){var i=m.parse(t,!1,!0),n=d(i),r=h(this._getId(e.schema));if(n!==r){var a=u(n),l=this._refs[a];if("string"==typeof l)return o.call(this,e,l,i);if(l instanceof y)l.validate||this._compile(l),e=l;else{if(!((l=this._schemas[a])instanceof y))return;if(l.validate||this._compile(l),a==u(t))return{schema:l,root:e,baseId:r};e=l}if(!e.schema)return;r=h(this._getId(e.schema))}return s.call(this,i,r,e.schema,e)}function o(e,t,i){var n=r.call(this,e,t);if(n){var o=n.schema,a=n.baseId;e=n.root;var l=this._getId(o);return l&&(a=f(a,l)),s.call(this,i,a,o,e)}}function s(e,t,i,n){if(e.hash=e.hash||"","#/"==e.hash.slice(0,2)){for(var o=e.hash.split("/"),s=1;s<o.length;s++){var a=o[s];if(a){if(a=v.unescapeFragment(a),void 0===(i=i[a]))break;var l;if(!b[a]&&(l=this._getId(i),l&&(t=f(t,l)),i.$ref)){var c=f(t,i.$ref),h=r.call(this,n,c);h&&(i=h.schema,n=h.root,t=h.baseId)}}}return void 0!==i&&i!==n.schema?{schema:i,root:n,baseId:t}:void 0}}function a(e,t){return!1!==t&&(void 0===t||!0===t?l(e):t?c(e)<=t:void 0)}function l(e){var t;if(Array.isArray(e)){for(var i=0;i<e.length;i++)if("object"==typeof(t=e[i])&&!l(t))return!1}else for(var n in e){if("$ref"==n)return!1;if("object"==typeof(t=e[n])&&!l(t))return!1}return!0}function c(e){var t,i=0;if(Array.isArray(e)){for(var n=0;n<e.length;n++)if(t=e[n],"object"==typeof t&&(i+=c(t)),i==1/0)return 1/0}else for(var r in e){if("$ref"==r)return 1/0;if(C[r])i++;else if(t=e[r],"object"==typeof t&&(i+=c(t)+1),i==1/0)return 1/0}return i}function h(e,t){return!1!==t&&(e=u(e)),d(m.parse(e,!1,!0))}function d(e){var t=e.protocol||"//"==e.href.slice(0,2)?"//":"";return(e.protocol||"")+t+(e.host||"")+(e.path||"")+"#"}function u(e){return e?e.replace(A,""):""}function f(e,t){return t=u(t),m.resolve(e,t)}function p(e){var t=u(this._getId(e)),i={"":t},n={"":h(t,!1)},r={},o=this;return w(e,{allKeys:!0},function(e,t,s,a,l,c,h){if(""!==t){var d=o._getId(e),f=i[a],p=n[a]+"/"+l;if(void 0!==h&&(p+="/"+("number"==typeof h?h:v.escapeFragment(h))),"string"==typeof d){d=f=u(f?m.resolve(f,d):d);var y=o._refs[d];if("string"==typeof y&&(y=o._refs[y]),y&&y.schema){if(!g(e,y.schema))throw new Error('id "'+d+'" resolves to more than one schema')}else if(d!=u(p))if("#"==d[0]){if(r[d]&&!g(e,r[d]))throw new Error('id "'+d+'" resolves to more than one schema');r[d]=e}else o._refs[d]=p}i[t]=f,n[t]=p}}),r}var m=i(4),g=i(10),v=i(11),y=i(13),w=i(14);e.exports=n,n.normalizeId=u,n.fullPath=h,n.url=f,n.ids=p,n.inlineRef=a,n.schema=r;var b=v.toHash(["properties","patternProperties","enum","dependencies","definitions"]),C=v.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]),A=/#\/?$/},function(e,t,i){function n(){this.protocol=null,this.slashes=null,this.auth=null,this.host=null,this.port=null,this.hostname=null,this.hash=null,this.search=null,this.query=null,this.pathname=null,this.path=null,this.href=null}function r(e,t,i){if(e&&c(e)&&e instanceof n)return e;var r=new n;return r.parse(e,t,i),r}function o(e){return l(e)&&(e=r(e)),e instanceof n?e.format():n.prototype.format.call(e)}function s(e,t){return r(e,!1,!0).resolve(t)}function a(e,t){return e?r(e,!1,!0).resolveObject(t):t}function l(e){return"string"==typeof e}function c(e){return"object"==typeof e&&null!==e}function h(e){return null===e}function d(e){return null==e}var u=i(5);t.parse=r,t.resolve=s,t.resolveObject=a,t.format=o,t.Url=n;var f=/^([a-z0-9.+-]+:)/i,p=/:[0-9]*$/,m=["<",">",'"',"`"," ","\r","\n","\t"],g=["{","}","|","\\","^","`"].concat(m),v=["'"].concat(g),y=["%","/","?",";","#"].concat(v),w=["/","?","#"],b={javascript:!0,"javascript:":!0},C={javascript:!0,"javascript:":!0},A={http:!0,https:!0,ftp:!0,gopher:!0,file:!0,"http:":!0,"https:":!0,"ftp:":!0,"gopher:":!0,"file:":!0},E=i(7);n.prototype.parse=function(e,t,i){if(!l(e))throw new TypeError("Parameter 'url' must be a string, not "+typeof e);var n=e;n=n.trim();var r=f.exec(n);if(r){r=r[0];var o=r.toLowerCase();this.protocol=o,n=n.substr(r.length)}if(i||r||n.match(/^\/\/[^@\/]+@[^@\/]+/)){var s="//"===n.substr(0,2);!s||r&&C[r]||(n=n.substr(2),this.slashes=!0)}if(!C[r]&&(s||r&&!A[r])){for(var a=-1,c=0;c<w.length;c++){var h=n.indexOf(w[c]);-1!==h&&(-1===a||h<a)&&(a=h)}var d,p;p=-1===a?n.lastIndexOf("@"):n.lastIndexOf("@",a),-1!==p&&(d=n.slice(0,p),n=n.slice(p+1),this.auth=decodeURIComponent(d)),a=-1;for(var c=0;c<y.length;c++){var h=n.indexOf(y[c]);-1!==h&&(-1===a||h<a)&&(a=h)}-1===a&&(a=n.length),this.host=n.slice(0,a),n=n.slice(a),this.parseHost(),this.hostname=this.hostname||"";var m="["===this.hostname[0]&&"]"===this.hostname[this.hostname.length-1];if(!m)for(var g=this.hostname.split(/\./),c=0,F=g.length;c<F;c++){var x=g[c];if(x&&!x.match(/^[a-z0-9A-Z_-]{0,63}$/)){for(var S="",_=0,k=x.length;_<k;_++)x.charCodeAt(_)>127?S+="x":S+=x[_];if(!S.match(/^[a-z0-9A-Z_-]{0,63}$/)){var D=g.slice(0,c),$=g.slice(c+1),B=x.match(/^([a-z0-9A-Z_-]{0,63})(.*)$/);B&&(D.push(B[1]),$.unshift(B[2])),$.length&&(n="/"+$.join(".")+n),this.hostname=D.join(".");break}}}if(this.hostname.length>255?this.hostname="":this.hostname=this.hostname.toLowerCase(),!m){for(var L=this.hostname.split("."),R=[],c=0;c<L.length;++c){var T=L[c];R.push(T.match(/[^A-Za-z0-9_-]/)?"xn--"+u.encode(T):T)}this.hostname=R.join(".")}var P=this.port?":"+this.port:"",M=this.hostname||"";this.host=M+P,this.href+=this.host,m&&(this.hostname=this.hostname.substr(1,this.hostname.length-2),"/"!==n[0]&&(n="/"+n))}if(!b[o])for(var c=0,F=v.length;c<F;c++){var O=v[c],I=encodeURIComponent(O);I===O&&(I=escape(O)),n=n.split(O).join(I)}var N=n.indexOf("#");-1!==N&&(this.hash=n.substr(N),n=n.slice(0,N));var j=n.indexOf("?");if(-1!==j?(this.search=n.substr(j),this.query=n.substr(j+1),t&&(this.query=E.parse(this.query)),n=n.slice(0,j)):t&&(this.search="",this.query={}),n&&(this.pathname=n),A[o]&&this.hostname&&!this.pathname&&(this.pathname="/"),this.pathname||this.search){var P=this.pathname||"",T=this.search||"";this.path=P+T}return this.href=this.format(),this},n.prototype.format=function(){var e=this.auth||"";e&&(e=encodeURIComponent(e),e=e.replace(/%3A/i,":"),e+="@");var t=this.protocol||"",i=this.pathname||"",n=this.hash||"",r=!1,o="";this.host?r=e+this.host:this.hostname&&(r=e+(-1===this.hostname.indexOf(":")?this.hostname:"["+this.hostname+"]"),this.port&&(r+=":"+this.port)),this.query&&c(this.query)&&Object.keys(this.query).length&&(o=E.stringify(this.query));var s=this.search||o&&"?"+o||"";return t&&":"!==t.substr(-1)&&(t+=":"),this.slashes||(!t||A[t])&&!1!==r?(r="//"+(r||""),i&&"/"!==i.charAt(0)&&(i="/"+i)):r||(r=""),n&&"#"!==n.charAt(0)&&(n="#"+n),s&&"?"!==s.charAt(0)&&(s="?"+s),i=i.replace(/[?#]/g,function(e){return encodeURIComponent(e)}),s=s.replace("#","%23"),t+r+i+s+n},n.prototype.resolve=function(e){return this.resolveObject(r(e,!1,!0)).format()},n.prototype.resolveObject=function(e){if(l(e)){var t=new n;t.parse(e,!1,!0),e=t}var i=new n;if(Object.keys(this).forEach(function(e){i[e]=this[e]},this),i.hash=e.hash,""===e.href)return i.href=i.format(),i;if(e.slashes&&!e.protocol)return Object.keys(e).forEach(function(t){"protocol"!==t&&(i[t]=e[t])}),A[i.protocol]&&i.hostname&&!i.pathname&&(i.path=i.pathname="/"),i.href=i.format(),i;if(e.protocol&&e.protocol!==i.protocol){if(!A[e.protocol])return Object.keys(e).forEach(function(t){i[t]=e[t]}),i.href=i.format(),i;if(i.protocol=e.protocol,e.host||C[e.protocol])i.pathname=e.pathname;else{for(var r=(e.pathname||"").split("/");r.length&&!(e.host=r.shift()););e.host||(e.host=""),e.hostname||(e.hostname=""),""!==r[0]&&r.unshift(""),r.length<2&&r.unshift(""),i.pathname=r.join("/")}if(i.search=e.search,i.query=e.query,i.host=e.host||"",i.auth=e.auth,i.hostname=e.hostname||e.host,i.port=e.port,i.pathname||i.search){var o=i.pathname||"",s=i.search||"";i.path=o+s}return i.slashes=i.slashes||e.slashes,i.href=i.format(),i}var a=i.pathname&&"/"===i.pathname.charAt(0),c=e.host||e.pathname&&"/"===e.pathname.charAt(0),u=c||a||i.host&&e.pathname,f=u,p=i.pathname&&i.pathname.split("/")||[],r=e.pathname&&e.pathname.split("/")||[],m=i.protocol&&!A[i.protocol];if(m&&(i.hostname="",i.port=null,i.host&&(""===p[0]?p[0]=i.host:p.unshift(i.host)),i.host="",e.protocol&&(e.hostname=null,e.port=null,e.host&&(""===r[0]?r[0]=e.host:r.unshift(e.host)),e.host=null),u=u&&(""===r[0]||""===p[0])),c)i.host=e.host||""===e.host?e.host:i.host,i.hostname=e.hostname||""===e.hostname?e.hostname:i.hostname,i.search=e.search,i.query=e.query,p=r;else if(r.length)p||(p=[]),p.pop(),p=p.concat(r),i.search=e.search,i.query=e.query;else if(!d(e.search)){if(m){i.hostname=i.host=p.shift();var g=!!(i.host&&i.host.indexOf("@")>0)&&i.host.split("@");g&&(i.auth=g.shift(),i.host=i.hostname=g.shift())}return i.search=e.search,i.query=e.query,h(i.pathname)&&h(i.search)||(i.path=(i.pathname?i.pathname:"")+(i.search?i.search:"")),i.href=i.format(),i}if(!p.length)return i.pathname=null,i.search?i.path="/"+i.search:i.path=null,i.href=i.format(),i;for(var v=p.slice(-1)[0],y=(i.host||e.host)&&("."===v||".."===v)||""===v,w=0,b=p.length;b>=0;b--)v=p[b],"."==v?p.splice(b,1):".."===v?(p.splice(b,1),w++):w&&(p.splice(b,1),w--);if(!u&&!f)for(;w--;w)p.unshift("..");!u||""===p[0]||p[0]&&"/"===p[0].charAt(0)||p.unshift(""),y&&"/"!==p.join("/").substr(-1)&&p.push("");var E=""===p[0]||p[0]&&"/"===p[0].charAt(0);if(m){i.hostname=i.host=E?"":p.length?p.shift():"";var g=!!(i.host&&i.host.indexOf("@")>0)&&i.host.split("@");g&&(i.auth=g.shift(),i.host=i.hostname=g.shift())}return u=u||i.host&&p.length,u&&!E&&p.unshift(""),p.length?i.pathname=p.join("/"):(i.pathname=null,i.path=null),h(i.pathname)&&h(i.search)||(i.path=(i.pathname?i.pathname:"")+(i.search?i.search:"")),i.auth=e.auth||i.auth,i.slashes=i.slashes||e.slashes,i.href=i.format(),i},n.prototype.parseHost=function(){var e=this.host,t=p.exec(e);t&&(t=t[0],":"!==t&&(this.port=t.substr(1)),e=e.substr(0,e.length-t.length)),e&&(this.hostname=e)}},function(e,t,i){var n;(function(e,r){!function(o){function s(e){throw RangeError(L[e])}function a(e,t){for(var i=e.length,n=[];i--;)n[i]=t(e[i]);return n}function l(e,t){var i=e.split("@"),n="";return i.length>1&&(n=i[0]+"@",e=i[1]),e=e.replace(B,"."),n+a(e.split("."),t).join(".")}function c(e){for(var t,i,n=[],r=0,o=e.length;r<o;)t=e.charCodeAt(r++),t>=55296&&t<=56319&&r<o?(i=e.charCodeAt(r++),56320==(64512&i)?n.push(((1023&t)<<10)+(1023&i)+65536):(n.push(t),r--)):n.push(t);return n}function h(e){return a(e,function(e){var t="";return e>65535&&(e-=65536,t+=P(e>>>10&1023|55296),e=56320|1023&e),t+=P(e)}).join("")}function d(e){return e-48<10?e-22:e-65<26?e-65:e-97<26?e-97:C}function u(e,t){return e+22+75*(e<26)-((0!=t)<<5)}function f(e,t,i){var n=0;for(e=i?T(e/x):e>>1,e+=T(e/t);e>R*E>>1;n+=C)e=T(e/R);return T(n+(R+1)*e/(e+F))}function p(e){var t,i,n,r,o,a,l,c,u,p,m=[],g=e.length,v=0,y=_,w=S;for(i=e.lastIndexOf(k),i<0&&(i=0),n=0;n<i;++n)e.charCodeAt(n)>=128&&s("not-basic"),m.push(e.charCodeAt(n));for(r=i>0?i+1:0;r<g;){for(o=v,a=1,l=C;r>=g&&s("invalid-input"),c=d(e.charCodeAt(r++)),(c>=C||c>T((b-v)/a))&&s("overflow"),v+=c*a,u=l<=w?A:l>=w+E?E:l-w,!(c<u);l+=C)p=C-u,a>T(b/p)&&s("overflow"),a*=p;t=m.length+1,w=f(v-o,t,0==o),T(v/t)>b-y&&s("overflow"),y+=T(v/t),v%=t,m.splice(v++,0,y)}return h(m)}function m(e){var t,i,n,r,o,a,l,h,d,p,m,g,v,y,w,F=[];for(e=c(e),g=e.length,t=_,i=0,o=S,a=0;a<g;++a)(m=e[a])<128&&F.push(P(m));for(n=r=F.length,r&&F.push(k);n<g;){for(l=b,a=0;a<g;++a)(m=e[a])>=t&&m<l&&(l=m);for(v=n+1,l-t>T((b-i)/v)&&s("overflow"),i+=(l-t)*v,t=l,a=0;a<g;++a)if(m=e[a],m<t&&++i>b&&s("overflow"),m==t){for(h=i,d=C;p=d<=o?A:d>=o+E?E:d-o,!(h<p);d+=C)w=h-p,y=C-p,F.push(P(u(p+w%y,0))),h=T(w/y);F.push(P(u(h,0))),o=f(i,v,n==r),i=0,++n}++i,++t}return F.join("")}function g(e){return l(e,function(e){return D.test(e)?p(e.slice(4).toLowerCase()):e})}function v(e){return l(e,function(e){return $.test(e)?"xn--"+m(e):e})}var y=("object"==typeof t&&t&&t.nodeType,"object"==typeof e&&e&&e.nodeType,"object"==typeof r&&r);var w,b=2147483647,C=36,A=1,E=26,F=38,x=700,S=72,_=128,k="-",D=/^xn--/,$=/[^\x20-\x7E]/,B=/[\x2E\u3002\uFF0E\uFF61]/g,L={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},R=C-A,T=Math.floor,P=String.fromCharCode;w={version:"1.3.2",ucs2:{decode:c,encode:h},decode:p,encode:m,toASCII:v,toUnicode:g},void 0!==(n=function(){return w}.call(t,i,t,e))&&(e.exports=n)}()}).call(t,i(6)(e),function(){return this}())},function(e,t){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children=[],e.webpackPolyfill=1),e}},function(e,t,i){"use strict";t.decode=t.parse=i(8),t.encode=t.stringify=i(9)},function(e,t){"use strict";function i(e,t){return Object.prototype.hasOwnProperty.call(e,t)}e.exports=function(e,t,n,r){t=t||"&",n=n||"=";var o={};if("string"!=typeof e||0===e.length)return o;e=e.split(t);var s=1e3;r&&"number"==typeof r.maxKeys&&(s=r.maxKeys);var a=e.length;s>0&&a>s&&(a=s);for(var l=0;l<a;++l){var c,h,d,u,f=e[l].replace(/\+/g,"%20"),p=f.indexOf(n);p>=0?(c=f.substr(0,p),h=f.substr(p+1)):(c=f,h=""),d=decodeURIComponent(c),u=decodeURIComponent(h),i(o,d)?Array.isArray(o[d])?o[d].push(u):o[d]=[o[d],u]:o[d]=u}return o}},function(e,t){"use strict";var i=function(e){switch(typeof e){case"string":return e;case"boolean":return e?"true":"false";case"number":return isFinite(e)?e:"";default:return""}};e.exports=function(e,t,n,r){return t=t||"&",n=n||"=",null===e&&(e=void 0),"object"==typeof e?Object.keys(e).map(function(r){var o=encodeURIComponent(i(r))+n;return Array.isArray(e[r])?e[r].map(function(e){return o+encodeURIComponent(i(e))}).join(t):o+encodeURIComponent(i(e[r]))}).join(t):r?encodeURIComponent(i(r))+n+encodeURIComponent(i(e)):""}},function(e,t){"use strict";var i=Array.isArray,n=Object.keys,r=Object.prototype.hasOwnProperty;e.exports=function e(t,o){if(t===o)return!0;var s,a,l,c=i(t),h=i(o);if(c&&h){if((a=t.length)!=o.length)return!1;for(s=0;s<a;s++)if(!e(t[s],o[s]))return!1;return!0}if(c!=h)return!1;var d=t instanceof Date,u=o instanceof Date;if(d!=u)return!1;if(d&&u)return t.getTime()==o.getTime();var f=t instanceof RegExp,p=o instanceof RegExp;if(f!=p)return!1;if(f&&p)return t.toString()==o.toString();if(t instanceof Object&&o instanceof Object){var m=n(t);if((a=m.length)!==n(o).length)return!1;for(s=0;s<a;s++)if(!r.call(o,m[s]))return!1;for(s=0;s<a;s++)if(l=m[s],!e(t[l],o[l]))return!1;return!0}return!1}},function(e,t,i){"use strict";function n(e,t){t=t||{};for(var i in e)t[i]=e[i];return t}function r(e,t,i){var n=i?" !== ":" === ",r=i?" || ":" && ",o=i?"!":"",s=i?"":"!";switch(e){case"null":return t+n+"null";case"array":return o+"Array.isArray("+t+")";case"object":return"("+o+t+r+"typeof "+t+n+'"object"'+r+s+"Array.isArray("+t+"))";case"integer":return"(typeof "+t+n+'"number"'+r+s+"("+t+" % 1)"+r+t+n+t+")";default:return"typeof "+t+n+'"'+e+'"'}}function o(e,t){switch(e.length){case 1:return r(e[0],t,!0);default:var i="",n=a(e);n.array&&n.object&&(i=n.null?"(":"(!"+t+" || ",i+="typeof "+t+' !== "object")',delete n.null,delete n.array,delete n.object),n.number&&delete n.integer;for(var o in n)i+=(i?" && ":"")+r(o,t,!0);return i}}function s(e,t){if(Array.isArray(t)){for(var i=[],n=0;n<t.length;n++){var r=t[n];x[r]?i[i.length]=r:"array"===e&&"array"===r&&(i[i.length]=r)}if(i.length)return i}else{if(x[t])return[t];if("array"===e&&"array"===t)return["array"]}}function a(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=!0;return t}function l(e){return"number"==typeof e?"["+e+"]":S.test(e)?"."+e:"['"+c(e)+"']"}function c(e){return e.replace(_,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function h(e,t){t+="[^0-9]";var i=e.match(new RegExp(t,"g"));return i?i.length:0}function d(e,t,i){return t+="([^0-9])",i=i.replace(/\$/g,"$$$$"),e.replace(new RegExp(t,"g"),i+"$1")}function u(e){return e.replace(k,"").replace(D,"").replace($,"if (!($1))")}function f(e,t){var i=e.match(B);return i&&2==i.length&&(e=t?e.replace(R,"").replace(M,O):e.replace(L,"").replace(T,P)),i=e.match(I),i&&3===i.length?e.replace(N,""):e}function p(e,t){if("boolean"==typeof e)return!e;for(var i in e)if(t[i])return!0}function m(e,t,i){if("boolean"==typeof e)return!e&&"not"!=i;for(var n in e)if(n!=i&&t[n])return!0}function g(e){return"'"+c(e)+"'"}function v(e,t,i,n){return b(e,i?"'/' + "+t+(n?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):n?"'[' + "+t+" + ']'":"'[\\'' + "+t+" + '\\']'")}function y(e,t,i){return b(e,g(i?"/"+E(t):l(t)))}function w(e,t,i){var n,r,o,s;if(""===e)return"rootData";if("/"==e[0]){if(!j.test(e))throw new Error("Invalid JSON-pointer: "+e);r=e,o="rootData"}else{if(!(s=e.match(H)))throw new Error("Invalid JSON-pointer: "+e);if(n=+s[1],"#"==(r=s[2])){if(n>=t)throw new Error("Cannot access property/index "+n+" levels up, current level is "+t);return i[t-n]}if(n>t)throw new Error("Cannot access data "+n+" levels up, current level is "+t);if(o="data"+(t-n||""),!r)return o}for(var a=o,c=r.split("/"),h=0;h<c.length;h++){var d=c[h];d&&(o+=l(F(d)),a+=" && "+o)}return a}function b(e,t){return'""'==e?t:(e+" + "+t).replace(/' \+ '/g,"")}function C(e){return F(decodeURIComponent(e))}function A(e){return encodeURIComponent(E(e))}function E(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}function F(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}e.exports={copy:n,checkDataType:r,checkDataTypes:o,coerceToTypes:s,toHash:a,getProperty:l,escapeQuotes:c,equal:i(10),ucs2length:i(12),varOccurences:h,varReplace:d,cleanUpCode:u,finalCleanUpCode:f,schemaHasRules:p,schemaHasRulesExcept:m,toQuotedString:g,getPathExpr:v,getPath:y,getData:w,unescapeFragment:C,unescapeJsonPointer:F,escapeFragment:A,escapeJsonPointer:E};var x=a(["string","number","integer","boolean","null"]),S=/^[a-z$_][a-z$_0-9]*$/i,_=/'|\\/g,k=/else\s*{\s*}/g,D=/if\s*\([^)]+\)\s*\{\s*\}(?!\s*else)/g,$=/if\s*\(([^)]+)\)\s*\{\s*\}\s*else(?!\s*if)/g,B=/[^v.]errors/g,L=/var errors = 0;|var vErrors = null;|validate.errors = vErrors;/g,R=/var errors = 0;|var vErrors = null;/g,T="return errors === 0;",P="validate.errors = null; return true;",M=/if \(errors === 0\) return data;\s*else throw new ValidationError\(vErrors\);/,O="return data;",I=/[^A-Za-z_$]rootData[^A-Za-z0-9_$]/g,N=/if \(rootData === undefined\) rootData = data;/,j=/^\/(?:[^~]|~0|~1)*$/,H=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/},function(e,t){"use strict";e.exports=function(e){for(var t,i=0,n=e.length,r=0;r<n;)i++,(t=e.charCodeAt(r++))>=55296&&t<=56319&&r<n&&56320==(64512&(t=e.charCodeAt(r)))&&r++;return i}},function(e,t,i){"use strict";function n(e){r.copy(e,this)}var r=i(11);e.exports=n},function(e,t){"use strict";function i(e,t,o,s,a,l,c,h,d){if(o&&"object"==typeof o&&!Array.isArray(o)){t(o,s,a,l,c,h,d);for(var u in o){var f=o[u];if(Array.isArray(f)){if(u in r.arrayKeywords)for(var p=0;p<f.length;p++)i(e,t,f[p],s+"/"+u+"/"+p,a,s,u,o,p)}else if(u in r.propsKeywords){if(f&&"object"==typeof f)for(var m in f)i(e,t,f[m],s+"/"+u+"/"+n(m),a,s,u,o,m)}else(u in r.keywords||e.allKeys&&!(u in r.skipKeywords))&&i(e,t,f,s+"/"+u,a,s,u,o)}}}function n(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}var r=e.exports=function(e,t,n){"function"==typeof t&&(n=t,t={}),i(t,n,e,"",e)};r.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},r.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},r.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},r.skipKeywords={enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},function(e,t,i){"use strict";function n(e){this.message="validation failed",this.errors=e,this.ajv=this.validation=!0}function r(e,t,i){this.message=i||r.message(e,t),this.missingRef=s.url(e,t),this.missingSchema=s.normalizeId(s.fullPath(this.missingRef))}function o(e){return e.prototype=Object.create(Error.prototype),e.prototype.constructor=e,e}var s=i(3);e.exports={Validation:o(n),MissingRef:o(r)},r.message=function(e,t){return"can't resolve reference "+t+" from id "+e}},function(e,t){"use strict";e.exports=function(e,t){t||(t={}),"function"==typeof t&&(t={cmp:t});var i="boolean"==typeof t.cycles&&t.cycles,n=t.cmp&&function(e){return function(t){return function(i,n){var r={key:i,value:t[i]},o={key:n,value:t[n]};return e(r,o)}}}(t.cmp),r=[];return function e(t){if(t&&t.toJSON&&"function"==typeof t.toJSON&&(t=t.toJSON()),void 0!==t){if("number"==typeof t)return isFinite(t)?""+t:"null";if("object"!=typeof t)return JSON.stringify(t);var o,s;if(Array.isArray(t)){for(s="[",o=0;o<t.length;o++)o&&(s+=","),s+=e(t[o])||"null";return s+"]"}if(null===t)return"null";if(-1!==r.indexOf(t)){if(i)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}var a=r.push(t)-1,l=Object.keys(t).sort(n&&n(t));for(s="",o=0;o<l.length;o++){var c=l[o],h=e(t[c]);h&&(s&&(s+=","),s+=JSON.stringify(c)+":"+h)}return r.splice(a,1),"{"+s+"}"}}(e)}},function(e,t){"use strict";e.exports=function(e,t,i){function n(e){for(var t=e.rules,i=0;i<t.length;i++)if(r(t[i]))return!0}function r(t){return void 0!==e.schema[t.keyword]||t.implements&&o(t)}function o(t){for(var i=t.implements,n=0;n<i.length;n++)if(void 0!==e.schema[i[n]])return!0}var s="",a=!0===e.schema.$async,l=e.util.schemaHasRulesExcept(e.schema,e.RULES.all,"$ref"),c=e.self._getId(e.schema);if(e.isTop){if(a){e.async=!0;var h="es7"==e.opts.async;e.yieldAwait=h?"await":"yield"}s+=" var validate = ",a?h?s+=" (async function ":("*"!=e.opts.async&&(s+="co.wrap"),s+="(function* "):s+=" (function ",s+=" (data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",c&&(e.opts.sourceCode||e.opts.processCode)&&(s+=" /*# sourceURL="+c+" */ ")}if("boolean"==typeof e.schema||!l&&!e.schema.$ref){var d,u=e.level,f=e.dataLevel,p=e.schema["false schema"],m=e.schemaPath+e.util.getProperty("false schema"),g=e.errSchemaPath+"/false schema",v=!e.opts.allErrors,y="data"+(f||""),w="valid"+u;if(!1===e.schema){e.isTop?v=!0:s+=" var "+w+" = false; ";var b=b||[];b.push(s),s="",!1!==e.createErrors?(s+=" { keyword: '"+(d||"false schema")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: {} ",!1!==e.opts.messages&&(s+=" , message: 'boolean schema is false' "),e.opts.verbose&&(s+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+y+" "),s+=" } "):s+=" {} ";var C=s;s=b.pop(),!e.compositeRule&&v?e.async?s+=" throw new ValidationError(["+C+"]); ":s+=" validate.errors = ["+C+"]; return false; ":s+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else e.isTop?s+=a?" return data; ":" validate.errors = null; return true; ":s+=" var "+w+" = true; ";return e.isTop&&(s+=" }); return validate; "),s}if(e.isTop){var A=e.isTop,u=e.level=0,f=e.dataLevel=0,y="data";e.rootId=e.resolve.fullPath(e.self._getId(e.root.schema)),e.baseId=e.baseId||e.rootId,delete e.isTop,e.dataPathArr=[void 0],s+=" var vErrors = null; ",s+=" var errors = 0;     ",s+=" if (rootData === undefined) rootData = data; "}else{var u=e.level,f=e.dataLevel,y="data"+(f||"");if(c&&(e.baseId=e.resolve.url(e.baseId,c)),a&&!e.async)throw new Error("async schema in sync schema");s+=" var errs_"+u+" = errors;"}var d,w="valid"+u,v=!e.opts.allErrors,E="",F="",x=e.schema.type,S=Array.isArray(x);if(S&&1==x.length&&(x=x[0],S=!1),e.schema.$ref&&l){if("fail"==e.opts.extendRefs)throw new Error('$ref: validation keywords used in schema at path "'+e.errSchemaPath+'" (see option extendRefs)');!0!==e.opts.extendRefs&&(l=!1,e.logger.warn('$ref: keywords ignored in schema at path "'+e.errSchemaPath+'"'))}if(x){if(e.opts.coerceTypes)var _=e.util.coerceToTypes(e.opts.coerceTypes,x);var k=e.RULES.types[x];if(_||S||!0===k||k&&!n(k)){var m=e.schemaPath+".type",g=e.errSchemaPath+"/type",m=e.schemaPath+".type",g=e.errSchemaPath+"/type",D=S?"checkDataTypes":"checkDataType";if(s+=" if ("+e.util[D](x,y,!0)+") { ",_){var $="dataType"+u,B="coerced"+u;s+=" var "+$+" = typeof "+y+"; ","array"==e.opts.coerceTypes&&(s+=" if ("+$+" == 'object' && Array.isArray("+y+")) "+$+" = 'array'; "),s+=" var "+B+" = undefined; ";var L="",R=_;if(R)for(var T,P=-1,M=R.length-1;P<M;)T=R[P+=1],P&&(s+=" if ("+B+" === undefined) { ",L+="}"),"array"==e.opts.coerceTypes&&"array"!=T&&(s+=" if ("+$+" == 'array' && "+y+".length == 1) { "+B+" = "+y+" = "+y+"[0]; "+$+" = typeof "+y+";  } "),"string"==T?s+=" if ("+$+" == 'number' || "+$+" == 'boolean') "+B+" = '' + "+y+"; else if ("+y+" === null) "+B+" = ''; ":"number"==T||"integer"==T?(s+=" if ("+$+" == 'boolean' || "+y+" === null || ("+$+" == 'string' && "+y+" && "+y+" == +"+y+" ","integer"==T&&(s+=" && !("+y+" % 1)"),s+=")) "+B+" = +"+y+"; "):"boolean"==T?s+=" if ("+y+" === 'false' || "+y+" === 0 || "+y+" === null) "+B+" = false; else if ("+y+" === 'true' || "+y+" === 1) "+B+" = true; ":"null"==T?s+=" if ("+y+" === '' || "+y+" === 0 || "+y+" === false) "+B+" = null; ":"array"==e.opts.coerceTypes&&"array"==T&&(s+=" if ("+$+" == 'string' || "+$+" == 'number' || "+$+" == 'boolean' || "+y+" == null) "+B+" = ["+y+"]; ");s+=" "+L+" if ("+B+" === undefined) {   ";var b=b||[];b.push(s),s="",!1!==e.createErrors?(s+=" { keyword: '"+(d||"type")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { type: '",s+=S?""+x.join(","):""+x,s+="' } ",!1!==e.opts.messages&&(s+=" , message: 'should be ",s+=S?""+x.join(","):""+x,s+="' "),e.opts.verbose&&(s+=" , schema: validate.schema"+m+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+y+" "),s+=" } "):s+=" {} ";var C=s;s=b.pop(),!e.compositeRule&&v?e.async?s+=" throw new ValidationError(["+C+"]); ":s+=" validate.errors = ["+C+"]; return false; ":s+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",s+=" } else {  ";var O=f?"data"+(f-1||""):"parentData",I=f?e.dataPathArr[f]:"parentDataProperty";s+=" "+y+" = "+B+"; ",f||(s+="if ("+O+" !== undefined)"),s+=" "+O+"["+I+"] = "+B+"; } "}else{var b=b||[];b.push(s),s="",!1!==e.createErrors?(s+=" { keyword: '"+(d||"type")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { type: '",s+=S?""+x.join(","):""+x,s+="' } ",!1!==e.opts.messages&&(s+=" , message: 'should be ",s+=S?""+x.join(","):""+x,s+="' "),e.opts.verbose&&(s+=" , schema: validate.schema"+m+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+y+" "),s+=" } "):s+=" {} ";var C=s;s=b.pop(),!e.compositeRule&&v?e.async?s+=" throw new ValidationError(["+C+"]); ":s+=" validate.errors = ["+C+"]; return false; ":s+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}s+=" } "}}if(e.schema.$ref&&!l)s+=" "+e.RULES.all.$ref.code(e,"$ref")+" ",v&&(s+=" } if (errors === ",s+=A?"0":"errs_"+u,s+=") { ",F+="}");else{e.opts.v5&&e.schema.patternGroups&&e.logger.warn('keyword "patternGroups" is deprecated and disabled. Use option patternGroups: true to enable.');var N=e.RULES;if(N)for(var k,j=-1,H=N.length-1;j<H;)if(k=N[j+=1],n(k)){if(k.type&&(s+=" if ("+e.util.checkDataType(k.type,y)+") { "),e.opts.useDefaults&&!e.compositeRule)if("object"==k.type&&e.schema.properties){var p=e.schema.properties,V=Object.keys(p),W=V;if(W)for(var z,U=-1,K=W.length-1;U<K;){z=W[U+=1];var q=p[z];if(void 0!==q.default){var G=y+e.util.getProperty(z);s+="  if ("+G+" === undefined) "+G+" = ","shared"==e.opts.useDefaults?s+=" "+e.useDefault(q.default)+" ":s+=" "+JSON.stringify(q.default)+" ",s+="; "}}}else if("array"==k.type&&Array.isArray(e.schema.items)){var Q=e.schema.items;if(Q)for(var q,P=-1,J=Q.length-1;P<J;)if(q=Q[P+=1],void 0!==q.default){var G=y+"["+P+"]";s+="  if ("+G+" === undefined) "+G+" = ","shared"==e.opts.useDefaults?s+=" "+e.useDefault(q.default)+" ":s+=" "+JSON.stringify(q.default)+" ",s+="; "}}var X=k.rules;if(X)for(var Y,Z=-1,ee=X.length-1;Z<ee;)if(Y=X[Z+=1],r(Y)){var te=Y.code(e,Y.keyword,k.type);te&&(s+=" "+te+" ",v&&(E+="}"))}if(v&&(s+=" "+E+" ",E=""),k.type&&(s+=" } ",x&&x===k.type&&!_)){s+=" else { ";var m=e.schemaPath+".type",g=e.errSchemaPath+"/type",b=b||[];b.push(s),s="",!1!==e.createErrors?(s+=" { keyword: '"+(d||"type")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { type: '",s+=S?""+x.join(","):""+x,s+="' } ",!1!==e.opts.messages&&(s+=" , message: 'should be ",s+=S?""+x.join(","):""+x,s+="' "),e.opts.verbose&&(s+=" , schema: validate.schema"+m+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+y+" "),s+=" } "):s+=" {} ";var C=s;s=b.pop(),!e.compositeRule&&v?e.async?s+=" throw new ValidationError(["+C+"]); ":s+=" validate.errors = ["+C+"]; return false; ":s+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",s+=" } "}v&&(s+=" if (errors === ",s+=A?"0":"errs_"+u,s+=") { ",F+="}")}}return v&&(s+=" "+F+" "),A?(a?(s+=" if (errors === 0) return data;           ",s+=" else throw new ValidationError(vErrors); "):(s+=" validate.errors = vErrors; ",s+=" return errors === 0;       "),s+=" }); return validate;"):s+=" var "+w+" = errors === errs_"+u+";",s=e.util.cleanUpCode(s),A&&(s=e.util.finalCleanUpCode(s,a)),s}},function(e,t){function i(e){var t=this,i=d.call(arguments,1);return new Promise(function(r,o){function s(t){var i;try{i=e.next(t)}catch(e){return o(e)}c(i)}function l(t){var i;try{i=e.throw(t)}catch(e){return o(e)}c(i)}function c(e){if(e.done)return r(e.value);var i=n.call(t,e.value);return i&&a(i)?i.then(s,l):l(new TypeError('You may only yield a function, promise, generator, array, or object, but the following object was passed: "'+String(e.value)+'"'))}if("function"==typeof e&&(e=e.apply(t,i)),!e||"function"!=typeof e.next)return r(e);s()})}function n(e){return e?a(e)?e:c(e)||l(e)?i.call(this,e):"function"==typeof e?r.call(this,e):Array.isArray(e)?o.call(this,e):h(e)?s.call(this,e):e:e}function r(e){var t=this;return new Promise(function(i,n){e.call(t,function(e,t){if(e)return n(e);arguments.length>2&&(t=d.call(arguments,1)),i(t)})})}function o(e){return Promise.all(e.map(n,this))}function s(e){for(var t=new e.constructor,i=Object.keys(e),r=[],o=0;o<i.length;o++){var s=i[o],l=n.call(this,e[s]);l&&a(l)?function(e,i){t[i]=void 0,r.push(e.then(function(e){t[i]=e}))}(l,s):t[s]=e[s]}return Promise.all(r).then(function(){return t})}function a(e){return"function"==typeof e.then}function l(e){return"function"==typeof e.next&&"function"==typeof e.throw}function c(e){var t=e.constructor;return!!t&&("GeneratorFunction"===t.name||"GeneratorFunction"===t.displayName||l(t.prototype))}function h(e){return Object==e.constructor}var d=Array.prototype.slice;e.exports=i.default=i.co=i,i.wrap=function(e){function t(){return i.call(this,e.apply(this,arguments))}return t.__generatorFunction__=e,t}},function(e,t){"use strict";var i=e.exports=function(){this._cache={}};i.prototype.put=function(e,t){this._cache[e]=t},i.prototype.get=function(e){return this._cache[e]},i.prototype.del=function(e){delete this._cache[e]},i.prototype.clear=function(){this._cache={}}},function(e,t,i){"use strict";function n(e){return e="full"==e?"full":"fast",h.copy(n[e])}function r(e){var t=e.match(d);if(!t)return!1;var i=+t[1],n=+t[2];return i>=1&&i<=12&&n>=1&&n<=u[i]}function o(e,t){var i=e.match(f);if(!i)return!1;var n=i[1],r=i[2],o=i[3],s=i[5];return n<=23&&r<=59&&o<=59&&(!t||s)}function s(e){var t=e.split(b);return 2==t.length&&r(t[0])&&o(t[1],!0)}function a(e){return e.length<=255&&p.test(e)}function l(e){return C.test(e)&&m.test(e)}function c(e){if(A.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}}var h=i(11),d=/^\d\d\d\d-(\d\d)-(\d\d)$/,u=[0,31,29,31,30,31,30,31,31,30,31,30,31],f=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d:\d\d)?$/i,p=/^[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*$/i,m=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@\/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@\/?]|%[0-9a-f]{2})*)?$/i,g=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#.\/;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,v=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,y=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,w=/^(?:\/(?:[^~\/]|~0|~1)*)*$|^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i;e.exports=n,n.fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^[0-2]\d:[0-5]\d:[0-5]\d(?:\.\d+)?(?:z|[+-]\d\d:\d\d)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s][0-2]\d:[0-5]\d:[0-5]\d(?:\.\d+)?(?:z|[+-]\d\d:\d\d)$/i,uri:/^(?:[a-z][a-z0-9+-.]*)(?::|\/)\/?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+-.]*:)?\/\/)?[^\s]*$/i,"uri-template":g,url:v,email:/^[a-z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:p,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:c,uuid:y,"json-pointer":w,"relative-json-pointer":/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~\/]|~0|~1)*)*)$/},n.full={date:r,time:o,"date-time":s,uri:l,"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@\/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@\/?]|%[0-9a-f]{2})*)?$/i,"uri-template":g,url:v,email:/^[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&''*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:a,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:c,uuid:y,"json-pointer":w,"relative-json-pointer":/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~\/]|~0|~1)*)*)$/};var b=/t|\s/i,C=/\/|:/,A=/[^\\]\\Z/},function(e,t,i){"use strict";var n=i(22),r=i(11).toHash;e.exports=function(){var e=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","uniqueItems","contains","items"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf"]}],t=["type"],i=["additionalItems","$schema","$id","id","title","description","default","definitions"],o=["number","integer","string","array","object","boolean","null"];return e.all=r(t),e.types=r(o),e.forEach(function(i){i.rules=i.rules.map(function(i){var r;if("object"==typeof i){var o=Object.keys(i)[0];r=i[o],i=o,r.forEach(function(i){t.push(i),e.all[i]=!0})}return t.push(i),e.all[i]={keyword:i,code:n[i],implements:r}}),i.type&&(e.types[i.type]=i)}),e.keywords=r(t.concat(i)),e.custom={},e}},function(e,t,i){"use strict";e.exports={$ref:i(23),allOf:i(24),anyOf:i(25),const:i(26),contains:i(27),dependencies:i(28),enum:i(29),format:i(30),items:i(31),maximum:i(32),minimum:i(32),maxItems:i(33),minItems:i(33),maxLength:i(34),minLength:i(34),maxProperties:i(35),minProperties:i(35),multipleOf:i(36),not:i(37),oneOf:i(38),pattern:i(39),properties:i(40),propertyNames:i(41),required:i(42),uniqueItems:i(43),validate:i(17)}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(a||""),u="valid"+s;if("#"==l||"#/"==l)e.isRoot?(n=e.async,r="validate"):(n=!0===e.root.schema.$async,r="root.refVal[0]");else{var f=e.resolveRef(e.baseId,l,e.isRoot);if(void 0===f){var p=e.MissingRefError.message(e.baseId,l);if("fail"==e.opts.missingRefs){e.logger.error(p);var m=m||[];m.push(o),o="",!1!==e.createErrors?(o+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { ref: '"+e.util.escapeQuotes(l)+"' } ",!1!==e.opts.messages&&(o+=" , message: 'can\\'t resolve reference "+e.util.escapeQuotes(l)+"' "),e.opts.verbose&&(o+=" , schema: "+e.util.toQuotedString(l)+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),o+=" } "):o+=" {} ";var g=o;o=m.pop(),!e.compositeRule&&h?e.async?o+=" throw new ValidationError(["+g+"]); ":o+=" validate.errors = ["+g+"]; return false; ":o+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",h&&(o+=" if (false) { ")}else{if("ignore"!=e.opts.missingRefs)throw new e.MissingRefError(e.baseId,l,p);e.logger.warn(p),h&&(o+=" if (true) { ")}}else if(f.inline){var v=e.util.copy(e);v.level++;var y="valid"+v.level;v.schema=f.schema,v.schemaPath="",v.errSchemaPath=l;var w=e.validate(v).replace(/validate\.schema/g,f.code);o+=" "+w+" ",h&&(o+=" if ("+y+") { ")}else n=!0===f.$async,r=f.code}if(r){var m=m||[];m.push(o),o="",e.opts.passContext?o+=" "+r+".call(this, ":o+=" "+r+"( ",o+=" "+d+", (dataPath || '')",'""'!=e.errorPath&&(o+=" + "+e.errorPath);o+=" , "+(a?"data"+(a-1||""):"parentData")+" , "+(a?e.dataPathArr[a]:"parentDataProperty")+", rootData)  ";var b=o;if(o=m.pop(),n){if(!e.async)throw new Error("async schema referenced by sync schema");h&&(o+=" var "+u+"; "),o+=" try { "+e.yieldAwait+" "+b+"; ",h&&(o+=" "+u+" = true; "),o+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",h&&(o+=" "+u+" = false; "),o+=" } ",h&&(o+=" if ("+u+") { ")}else o+=" if (!"+b+") { if (vErrors === null) vErrors = "+r+".errors; else vErrors = vErrors.concat("+r+".errors); errors = vErrors.length; } ",h&&(o+=" else { ")}return o}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.schema[t],o=e.schemaPath+e.util.getProperty(t),s=e.errSchemaPath+"/"+t,a=!e.opts.allErrors,l=e.util.copy(e),c="";l.level++;var h="valid"+l.level,d=l.baseId,u=!0,f=r;if(f)for(var p,m=-1,g=f.length-1;m<g;)p=f[m+=1],e.util.schemaHasRules(p,e.RULES.all)&&(u=!1,l.schema=p,l.schemaPath=o+"["+m+"]",l.errSchemaPath=s+"/"+m,n+="  "+e.validate(l)+" ",l.baseId=d,a&&(n+=" if ("+h+") { ",c+="}"));return a&&(n+=u?" if (true) { ":" "+c.slice(0,-1)+" "),n=e.util.cleanUpCode(n)}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e),p="";f.level++;var m="valid"+f.level;if(s.every(function(t){return e.util.schemaHasRules(t,e.RULES.all)})){var g=f.baseId;n+=" var "+u+" = errors; var "+d+" = false;  ";var v=e.compositeRule;e.compositeRule=f.compositeRule=!0;var y=s;if(y)for(var w,b=-1,C=y.length-1;b<C;)w=y[b+=1],f.schema=w,f.schemaPath=a+"["+b+"]",f.errSchemaPath=l+"/"+b,n+="  "+e.validate(f)+" ",f.baseId=g,n+=" "+d+" = "+d+" || "+m+"; if (!"+d+") { ",p+="}";e.compositeRule=f.compositeRule=v,n+=" "+p+" if (!"+d+") {   var err =   ",!1!==e.createErrors?(n+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should match some schema in anyOf' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&c&&(e.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),n+=" } else {  errors = "+u+"; if (vErrors !== null) { if ("+u+") vErrors.length = "+u+"; else vErrors = null; } ",e.opts.allErrors&&(n+=" } "),n=e.util.cleanUpCode(n)}else c&&(n+=" if (true) { ");return n}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u=e.opts.$data&&s&&s.$data;u&&(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; "),u||(n+=" var schema"+r+" = validate.schema"+a+";"),n+="var "+d+" = equal("+h+", schema"+r+"); if (!"+d+") {   ";var f=f||[];f.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'const' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should be equal to constant' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var p=n;return n=f.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+p+"]); ":n+=" validate.errors = ["+p+"]; return false; ":n+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" }",c&&(n+=" else { "),n}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e);f.level++;var p="valid"+f.level,m="i"+r,g=f.dataLevel=e.dataLevel+1,v="data"+g,y=e.baseId,w=e.util.schemaHasRules(s,e.RULES.all);if(n+="var "+u+" = errors;var "+d+";",w){var b=e.compositeRule;e.compositeRule=f.compositeRule=!0,f.schema=s,f.schemaPath=a,f.errSchemaPath=l,n+=" var "+p+" = false; for (var "+m+" = 0; "+m+" < "+h+".length; "+m+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers,!0);var C=h+"["+m+"]";f.dataPathArr[g]=m;var A=e.validate(f);f.baseId=y,e.util.varOccurences(A,v)<2?n+=" "+e.util.varReplace(A,v,C)+" ":n+=" var "+v+" = "+C+"; "+A+" ",n+=" if ("+p+") break; }  ",e.compositeRule=f.compositeRule=b,n+="  if (!"+p+") {"}else n+=" if ("+h+".length == 0) {";var E=E||[];E.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should contain a valid item' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var F=n;return n=E.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+F+"]); ":n+=" validate.errors = ["+F+"]; return false; ":n+=" var err = "+F+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",
n+=" } else { ",w&&(n+="  errors = "+u+"; if (vErrors !== null) { if ("+u+") vErrors.length = "+u+"; else vErrors = null; } "),e.opts.allErrors&&(n+=" } "),n=e.util.cleanUpCode(n)}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="errs__"+r,u=e.util.copy(e),f="";u.level++;var p="valid"+u.level,m={},g={},v=e.opts.ownProperties;for(C in s){var y=s[C],w=Array.isArray(y)?g:m;w[C]=y}n+="var "+d+" = errors;";var b=e.errorPath;n+="var missing"+r+";";for(var C in g)if(w=g[C],w.length){if(n+=" if ( "+h+e.util.getProperty(C)+" !== undefined ",v&&(n+=" && Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(C)+"') "),c){n+=" && ( ";var A=w;if(A)for(var E,F=-1,x=A.length-1;F<x;){E=A[F+=1],F&&(n+=" || ");var S=e.util.getProperty(E),_=h+S;n+=" ( ( "+_+" === undefined ",v&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(E)+"') "),n+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?E:S)+") ) "}n+=")) {  ";var k="missing"+r,D="' + "+k+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(b,k,!0):b+" + "+k);var $=$||[];$.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { property: '"+e.util.escapeQuotes(C)+"', missingProperty: '"+D+"', depsCount: "+w.length+", deps: '"+e.util.escapeQuotes(1==w.length?w[0]:w.join(", "))+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should have ",1==w.length?n+="property "+e.util.escapeQuotes(w[0]):n+="properties "+e.util.escapeQuotes(w.join(", ")),n+=" when property "+e.util.escapeQuotes(C)+" is present' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var B=n;n=$.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+B+"]); ":n+=" validate.errors = ["+B+"]; return false; ":n+=" var err = "+B+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{n+=" ) { ";var L=w;if(L)for(var E,R=-1,T=L.length-1;R<T;){E=L[R+=1];var S=e.util.getProperty(E),D=e.util.escapeQuotes(E),_=h+S;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(b,E,e.opts.jsonPointers)),n+=" if ( "+_+" === undefined ",v&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(E)+"') "),n+=") {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { property: '"+e.util.escapeQuotes(C)+"', missingProperty: '"+D+"', depsCount: "+w.length+", deps: '"+e.util.escapeQuotes(1==w.length?w[0]:w.join(", "))+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should have ",1==w.length?n+="property "+e.util.escapeQuotes(w[0]):n+="properties "+e.util.escapeQuotes(w.join(", ")),n+=" when property "+e.util.escapeQuotes(C)+" is present' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}n+=" }   ",c&&(f+="}",n+=" else { ")}e.errorPath=b;var P=u.baseId;for(var C in m){var y=m[C];e.util.schemaHasRules(y,e.RULES.all)&&(n+=" "+p+" = true; if ( "+h+e.util.getProperty(C)+" !== undefined ",v&&(n+=" && Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(C)+"') "),n+=") { ",u.schema=y,u.schemaPath=a+e.util.getProperty(C),u.errSchemaPath=l+"/"+e.util.escapeFragment(C),n+="  "+e.validate(u)+" ",u.baseId=P,n+=" }  ",c&&(n+=" if ("+p+") { ",f+="}"))}return c&&(n+="   "+f+" if ("+d+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u=e.opts.$data&&s&&s.$data;u&&(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ");var f="i"+r,p="schema"+r;u||(n+=" var "+p+" = validate.schema"+a+";"),n+="var "+d+";",u&&(n+=" if (schema"+r+" === undefined) "+d+" = true; else if (!Array.isArray(schema"+r+")) "+d+" = false; else {"),n+=d+" = false;for (var "+f+"=0; "+f+"<"+p+".length; "+f+"++) if (equal("+h+", "+p+"["+f+"])) { "+d+" = true; break; }",u&&(n+="  }  "),n+=" if (!"+d+") {   ";var m=m||[];m.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { allowedValues: schema"+r+" } ",!1!==e.opts.messages&&(n+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var g=n;return n=m.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+g+"]); ":n+=" validate.errors = ["+g+"]; return false; ":n+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" }",c&&(n+=" else { "),n}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||"");if(!1===e.opts.format)return c&&(n+=" if (true) { "),n;var d,u=e.opts.$data&&s&&s.$data;u?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ",d="schema"+r):d=s;var f=e.opts.unknownFormats,p=Array.isArray(f);if(u){var m="format"+r,g="isObject"+r,v="formatType"+r;n+=" var "+m+" = formats["+d+"]; var "+g+" = typeof "+m+" == 'object' && !("+m+" instanceof RegExp) && "+m+".validate; var "+v+" = "+g+" && "+m+".type || 'string'; if ("+g+") { ",e.async&&(n+=" var async"+r+" = "+m+".async; "),n+=" "+m+" = "+m+".validate; } if (  ",u&&(n+=" ("+d+" !== undefined && typeof "+d+" != 'string') || "),n+=" (","ignore"!=f&&(n+=" ("+d+" && !"+m+" ",p&&(n+=" && self._opts.unknownFormats.indexOf("+d+") == -1 "),n+=") || "),n+=" ("+m+" && "+v+" == '"+i+"' && !(typeof "+m+" == 'function' ? ",e.async?n+=" (async"+r+" ? "+e.yieldAwait+" "+m+"("+h+") : "+m+"("+h+")) ":n+=" "+m+"("+h+") ",n+=" : "+m+".test("+h+"))))) {"}else{var m=e.formats[s];if(!m){if("ignore"==f)return e.logger.warn('unknown format "'+s+'" ignored in schema at path "'+e.errSchemaPath+'"'),c&&(n+=" if (true) { "),n;if(p&&f.indexOf(s)>=0)return c&&(n+=" if (true) { "),n;throw new Error('unknown format "'+s+'" is used in schema at path "'+e.errSchemaPath+'"')}var g="object"==typeof m&&!(m instanceof RegExp)&&m.validate,v=g&&m.type||"string";if(g){var y=!0===m.async;m=m.validate}if(v!=i)return c&&(n+=" if (true) { "),n;if(y){if(!e.async)throw new Error("async format in sync schema");var w="formats"+e.util.getProperty(s)+".validate";n+=" if (!("+e.yieldAwait+" "+w+"("+h+"))) { "}else{n+=" if (! ";var w="formats"+e.util.getProperty(s);g&&(w+=".validate"),n+="function"==typeof m?" "+w+"("+h+") ":" "+w+".test("+h+") ",n+=") { "}}var b=b||[];b.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'format' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { format:  ",n+=u?""+d:""+e.util.toQuotedString(s),n+="  } ",!1!==e.opts.messages&&(n+=" , message: 'should match format \"",n+=u?"' + "+d+" + '":""+e.util.escapeQuotes(s),n+="\"' "),e.opts.verbose&&(n+=" , schema:  ",n+=u?"validate.schema"+a:""+e.util.toQuotedString(s),n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var C=n;return n=b.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+C+"]); ":n+=" validate.errors = ["+C+"]; return false; ":n+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",c&&(n+=" else { "),n}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e),p="";f.level++;var m="valid"+f.level,g="i"+r,v=f.dataLevel=e.dataLevel+1,y="data"+v,w=e.baseId;if(n+="var "+u+" = errors;var "+d+";",Array.isArray(s)){var b=e.schema.additionalItems;if(!1===b){n+=" "+d+" = "+h+".length <= "+s.length+"; ";var C=l;l=e.errSchemaPath+"/additionalItems",n+="  if (!"+d+") {   ";var A=A||[];A.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { limit: "+s.length+" } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have more than "+s.length+" items' "),e.opts.verbose&&(n+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var E=n;n=A.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+E+"]); ":n+=" validate.errors = ["+E+"]; return false; ":n+=" var err = "+E+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",l=C,c&&(p+="}",n+=" else { ")}var F=s;if(F)for(var x,S=-1,_=F.length-1;S<_;)if(x=F[S+=1],e.util.schemaHasRules(x,e.RULES.all)){n+=" "+m+" = true; if ("+h+".length > "+S+") { ";var k=h+"["+S+"]";f.schema=x,f.schemaPath=a+"["+S+"]",f.errSchemaPath=l+"/"+S,f.errorPath=e.util.getPathExpr(e.errorPath,S,e.opts.jsonPointers,!0),f.dataPathArr[v]=S;var D=e.validate(f);f.baseId=w,e.util.varOccurences(D,y)<2?n+=" "+e.util.varReplace(D,y,k)+" ":n+=" var "+y+" = "+k+"; "+D+" ",n+=" }  ",c&&(n+=" if ("+m+") { ",p+="}")}if("object"==typeof b&&e.util.schemaHasRules(b,e.RULES.all)){f.schema=b,f.schemaPath=e.schemaPath+".additionalItems",f.errSchemaPath=e.errSchemaPath+"/additionalItems",n+=" "+m+" = true; if ("+h+".length > "+s.length+") {  for (var "+g+" = "+s.length+"; "+g+" < "+h+".length; "+g+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers,!0);var k=h+"["+g+"]";f.dataPathArr[v]=g;var D=e.validate(f);f.baseId=w,e.util.varOccurences(D,y)<2?n+=" "+e.util.varReplace(D,y,k)+" ":n+=" var "+y+" = "+k+"; "+D+" ",c&&(n+=" if (!"+m+") break; "),n+=" } }  ",c&&(n+=" if ("+m+") { ",p+="}")}}else if(e.util.schemaHasRules(s,e.RULES.all)){f.schema=s,f.schemaPath=a,f.errSchemaPath=l,n+="  for (var "+g+" = 0; "+g+" < "+h+".length; "+g+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers,!0);var k=h+"["+g+"]";f.dataPathArr[v]=g;var D=e.validate(f);f.baseId=w,e.util.varOccurences(D,y)<2?n+=" "+e.util.varReplace(D,y,k)+" ":n+=" var "+y+" = "+k+"; "+D+" ",c&&(n+=" if (!"+m+") break; "),n+=" }"}return c&&(n+=" "+p+" if ("+u+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.schemaPath+e.util.getProperty(t),h=e.errSchemaPath+"/"+t,d=!e.opts.allErrors,u="data"+(a||""),f=e.opts.$data&&l&&l.$data;f?(o+=" var schema"+s+" = "+e.util.getData(l.$data,a,e.dataPathArr)+"; ",r="schema"+s):r=l;var p="maximum"==t,m=p?"exclusiveMaximum":"exclusiveMinimum",g=e.schema[m],v=e.opts.$data&&g&&g.$data,y=p?"<":">",w=p?">":"<",n=void 0;if(v){var b=e.util.getData(g.$data,a,e.dataPathArr),C="exclusive"+s,A="exclType"+s,E="exclIsNumber"+s,F="op"+s,x="' + "+F+" + '";o+=" var schemaExcl"+s+" = "+b+"; ",b="schemaExcl"+s,o+=" var "+C+"; var "+A+" = typeof "+b+"; if ("+A+" != 'boolean' && "+A+" != 'undefined' && "+A+" != 'number') { ";var n=m,S=S||[];S.push(o),o="",!1!==e.createErrors?(o+=" { keyword: '"+(n||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: {} ",!1!==e.opts.messages&&(o+=" , message: '"+m+" should be boolean' "),e.opts.verbose&&(o+=" , schema: validate.schema"+c+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var _=o;o=S.pop(),!e.compositeRule&&d?e.async?o+=" throw new ValidationError(["+_+"]); ":o+=" validate.errors = ["+_+"]; return false; ":o+=" var err = "+_+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } else if ( ",f&&(o+=" ("+r+" !== undefined && typeof "+r+" != 'number') || "),o+=" "+A+" == 'number' ? ( ("+C+" = "+r+" === undefined || "+b+" "+y+"= "+r+") ? "+u+" "+w+"= "+b+" : "+u+" "+w+" "+r+" ) : ( ("+C+" = "+b+" === true) ? "+u+" "+w+"= "+r+" : "+u+" "+w+" "+r+" ) || "+u+" !== "+u+") { var op"+s+" = "+C+" ? '"+y+"' : '"+y+"=';"}else{var E="number"==typeof g,x=y;if(E&&f){var F="'"+x+"'";o+=" if ( ",f&&(o+=" ("+r+" !== undefined && typeof "+r+" != 'number') || "),o+=" ( "+r+" === undefined || "+g+" "+y+"= "+r+" ? "+u+" "+w+"= "+g+" : "+u+" "+w+" "+r+" ) || "+u+" !== "+u+") { "}else{E&&void 0===l?(C=!0,n=m,h=e.errSchemaPath+"/"+m,r=g,w+="="):(E&&(r=Math[p?"min":"max"](g,l)),g===(!E||r)?(C=!0,n=m,h=e.errSchemaPath+"/"+m,w+="="):(C=!1,x+="="));var F="'"+x+"'";o+=" if ( ",f&&(o+=" ("+r+" !== undefined && typeof "+r+" != 'number') || "),o+=" "+u+" "+w+" "+r+" || "+u+" !== "+u+") { "}}n=n||t;var S=S||[];S.push(o),o="",!1!==e.createErrors?(o+=" { keyword: '"+(n||"_limit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { comparison: "+F+", limit: "+r+", exclusive: "+C+" } ",!1!==e.opts.messages&&(o+=" , message: 'should be "+x+" ",o+=f?"' + "+r:r+"'"),e.opts.verbose&&(o+=" , schema:  ",o+=f?"validate.schema"+c:""+l,o+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var _=o;return o=S.pop(),!e.compositeRule&&d?e.async?o+=" throw new ValidationError(["+_+"]); ":o+=" validate.errors = ["+_+"]; return false; ":o+=" var err = "+_+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } ",d&&(o+=" else { "),o}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.schemaPath+e.util.getProperty(t),h=e.errSchemaPath+"/"+t,d=!e.opts.allErrors,u="data"+(a||""),f=e.opts.$data&&l&&l.$data;f?(o+=" var schema"+s+" = "+e.util.getData(l.$data,a,e.dataPathArr)+"; ",r="schema"+s):r=l;var p="maxItems"==t?">":"<";o+="if ( ",f&&(o+=" ("+r+" !== undefined && typeof "+r+" != 'number') || "),o+=" "+u+".length "+p+" "+r+") { ";var n=t,m=m||[];m.push(o),o="",!1!==e.createErrors?(o+=" { keyword: '"+(n||"_limitItems")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(o+=" , message: 'should NOT have ",o+="maxItems"==t?"more":"less",o+=" than ",o+=f?"' + "+r+" + '":""+l,o+=" items' "),e.opts.verbose&&(o+=" , schema:  ",o+=f?"validate.schema"+c:""+l,o+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var g=o;return o=m.pop(),!e.compositeRule&&d?e.async?o+=" throw new ValidationError(["+g+"]); ":o+=" validate.errors = ["+g+"]; return false; ":o+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+="} ",d&&(o+=" else { "),o}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.schemaPath+e.util.getProperty(t),h=e.errSchemaPath+"/"+t,d=!e.opts.allErrors,u="data"+(a||""),f=e.opts.$data&&l&&l.$data;f?(o+=" var schema"+s+" = "+e.util.getData(l.$data,a,e.dataPathArr)+"; ",r="schema"+s):r=l;var p="maxLength"==t?">":"<";o+="if ( ",f&&(o+=" ("+r+" !== undefined && typeof "+r+" != 'number') || "),!1===e.opts.unicode?o+=" "+u+".length ":o+=" ucs2length("+u+") ",o+=" "+p+" "+r+") { ";var n=t,m=m||[];m.push(o),o="",!1!==e.createErrors?(o+=" { keyword: '"+(n||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(o+=" , message: 'should NOT be ",o+="maxLength"==t?"longer":"shorter",o+=" than ",o+=f?"' + "+r+" + '":""+l,o+=" characters' "),e.opts.verbose&&(o+=" , schema:  ",o+=f?"validate.schema"+c:""+l,o+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var g=o;return o=m.pop(),!e.compositeRule&&d?e.async?o+=" throw new ValidationError(["+g+"]); ":o+=" validate.errors = ["+g+"]; return false; ":o+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+="} ",d&&(o+=" else { "),o}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.schemaPath+e.util.getProperty(t),h=e.errSchemaPath+"/"+t,d=!e.opts.allErrors,u="data"+(a||""),f=e.opts.$data&&l&&l.$data;f?(o+=" var schema"+s+" = "+e.util.getData(l.$data,a,e.dataPathArr)+"; ",r="schema"+s):r=l;var p="maxProperties"==t?">":"<";o+="if ( ",f&&(o+=" ("+r+" !== undefined && typeof "+r+" != 'number') || "),o+=" Object.keys("+u+").length "+p+" "+r+") { ";var n=t,m=m||[];m.push(o),o="",!1!==e.createErrors?(o+=" { keyword: '"+(n||"_limitProperties")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(o+=" , message: 'should NOT have ",o+="maxProperties"==t?"more":"less",o+=" than ",o+=f?"' + "+r+" + '":""+l,o+=" properties' "),e.opts.verbose&&(o+=" , schema:  ",o+=f?"validate.schema"+c:""+l,o+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var g=o;return o=m.pop(),!e.compositeRule&&d?e.async?o+=" throw new ValidationError(["+g+"]); ":o+=" validate.errors = ["+g+"]; return false; ":o+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+="} ",d&&(o+=" else { "),o}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ",n="schema"+o):n=a,r+="var division"+o+";if (",u&&(r+=" "+n+" !== undefined && ( typeof "+n+" != 'number' || "),r+=" (division"+o+" = "+d+" / "+n+", ",e.opts.multipleOfPrecision?r+=" Math.abs(Math.round(division"+o+") - division"+o+") > 1e-"+e.opts.multipleOfPrecision+" ":r+=" division"+o+" !== parseInt(division"+o+") ",r+=" ) ",u&&(r+="  )  "),r+=" ) {   ";var f=f||[];f.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { multipleOf: "+n+" } ",!1!==e.opts.messages&&(r+=" , message: 'should be multiple of ",r+=u?"' + "+n:n+"'"),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var p=r;return r=f.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+p+"]); ":r+=" validate.errors = ["+p+"]; return false; ":r+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",h&&(r+=" else { "),r}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="errs__"+r,u=e.util.copy(e);u.level++;var f="valid"+u.level;if(e.util.schemaHasRules(s,e.RULES.all)){u.schema=s,u.schemaPath=a,u.errSchemaPath=l,n+=" var "+d+" = errors;  ";var p=e.compositeRule;e.compositeRule=u.compositeRule=!0,u.createErrors=!1;var m;u.opts.allErrors&&(m=u.opts.allErrors,u.opts.allErrors=!1),n+=" "+e.validate(u)+" ",u.createErrors=!0,m&&(u.opts.allErrors=m),e.compositeRule=u.compositeRule=p,n+=" if ("+f+") {   ";var g=g||[];g.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should NOT be valid' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var v=n;n=g.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+v+"]); ":n+=" validate.errors = ["+v+"]; return false; ":n+=" var err = "+v+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else {  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; } ",e.opts.allErrors&&(n+=" } ")}else n+="  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should NOT be valid' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c&&(n+=" if (false) { ");return n}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e),p="";f.level++;var m="valid"+f.level;n+="var "+u+" = errors;var prevValid"+r+" = false;var "+d+" = false;";var g=f.baseId,v=e.compositeRule;e.compositeRule=f.compositeRule=!0;var y=s;if(y)for(var w,b=-1,C=y.length-1;b<C;)w=y[b+=1],e.util.schemaHasRules(w,e.RULES.all)?(f.schema=w,f.schemaPath=a+"["+b+"]",f.errSchemaPath=l+"/"+b,n+="  "+e.validate(f)+" ",f.baseId=g):n+=" var "+m+" = true; ",b&&(n+=" if ("+m+" && prevValid"+r+") "+d+" = false; else { ",p+="}"),n+=" if ("+m+") "+d+" = prevValid"+r+" = true;";return e.compositeRule=f.compositeRule=v,n+=p+"if (!"+d+") {   var err =   ",!1!==e.createErrors?(n+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&c&&(e.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),n+="} else {  errors = "+u+"; if (vErrors !== null) { if ("+u+") vErrors.length = "+u+"; else vErrors = null; }",e.opts.allErrors&&(n+=" } "),n}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ",n="schema"+o):n=a;var f=u?"(new RegExp("+n+"))":e.usePattern(a);r+="if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'string') || "),r+=" !"+f+".test("+d+") ) {   ";var p=p||[];p.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { pattern:  ",r+=u?""+n:""+e.util.toQuotedString(a),r+="  } ",!1!==e.opts.messages&&(r+=" , message: 'should match pattern \"",r+=u?"' + "+n+" + '":""+e.util.escapeQuotes(a),r+="\"' "),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+e.util.toQuotedString(a),r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var m=r;return r=p.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+m+"]); ":r+=" validate.errors = ["+m+"]; return false; ":r+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",h&&(r+=" else { "),r}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e),p="";f.level++;var m="valid"+f.level,g="key"+r,v="idx"+r,y=f.dataLevel=e.dataLevel+1,w="data"+y,b="dataProperties"+r,C=Object.keys(s||{}),A=e.schema.patternProperties||{},E=Object.keys(A),F=e.schema.additionalProperties,x=C.length||E.length,S=!1===F,_="object"==typeof F&&Object.keys(F).length,k=e.opts.removeAdditional,D=S||_||k,$=e.opts.ownProperties,B=e.baseId,L=e.schema.required;if(L&&(!e.opts.v5||!L.$data)&&L.length<e.opts.loopRequired)var R=e.util.toHash(L);if(e.opts.patternGroups)var T=e.schema.patternGroups||{},P=Object.keys(T);if(n+="var "+u+" = errors;var "+m+" = true;",$&&(n+=" var "+b+" = undefined;"),D){if(n+=$?" "+b+" = "+b+" || Object.keys("+h+"); for (var "+v+"=0; "+v+"<"+b+".length; "+v+"++) { var "+g+" = "+b+"["+v+"]; ":" for (var "+g+" in "+h+") { ",x){if(n+=" var isAdditional"+r+" = !(false ",C.length)if(C.length>5)n+=" || validate.schema"+a+"["+g+"] ";else{var M=C;if(M)for(var O,I=-1,N=M.length-1;I<N;)O=M[I+=1],n+=" || "+g+" == "+e.util.toQuotedString(O)+" "}if(E.length){var j=E;if(j)for(var H,V=-1,W=j.length-1;V<W;)H=j[V+=1],n+=" || "+e.usePattern(H)+".test("+g+") "}if(e.opts.patternGroups&&P.length){var z=P;if(z)for(var U,V=-1,K=z.length-1;V<K;)U=z[V+=1],n+=" || "+e.usePattern(U)+".test("+g+") "}n+=" ); if (isAdditional"+r+") { "}if("all"==k)n+=" delete "+h+"["+g+"]; ";else{var q=e.errorPath,G="' + "+g+" + '";if(e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers)),S)if(k)n+=" delete "+h+"["+g+"]; ";else{n+=" "+m+" = false; ";var Q=l;l=e.errSchemaPath+"/additionalProperties";var J=J||[];J.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { additionalProperty: '"+G+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have additional properties' "),e.opts.verbose&&(n+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var X=n;n=J.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+X+"]); ":n+=" validate.errors = ["+X+"]; return false; ":n+=" var err = "+X+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l=Q,c&&(n+=" break; ")}else if(_)if("failing"==k){n+=" var "+u+" = errors;  ";var Y=e.compositeRule;e.compositeRule=f.compositeRule=!0,f.schema=F,f.schemaPath=e.schemaPath+".additionalProperties",f.errSchemaPath=e.errSchemaPath+"/additionalProperties",f.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers);var Z=h+"["+g+"]";f.dataPathArr[y]=g;var ee=e.validate(f);f.baseId=B,e.util.varOccurences(ee,w)<2?n+=" "+e.util.varReplace(ee,w,Z)+" ":n+=" var "+w+" = "+Z+"; "+ee+" ",n+=" if (!"+m+") { errors = "+u+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+h+"["+g+"]; }  ",e.compositeRule=f.compositeRule=Y}else{f.schema=F,f.schemaPath=e.schemaPath+".additionalProperties",f.errSchemaPath=e.errSchemaPath+"/additionalProperties",f.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers);var Z=h+"["+g+"]";f.dataPathArr[y]=g;var ee=e.validate(f);f.baseId=B,e.util.varOccurences(ee,w)<2?n+=" "+e.util.varReplace(ee,w,Z)+" ":n+=" var "+w+" = "+Z+"; "+ee+" ",c&&(n+=" if (!"+m+") break; ")}e.errorPath=q}x&&(n+=" } "),n+=" }  ",c&&(n+=" if ("+m+") { ",p+="}")}var te=e.opts.useDefaults&&!e.compositeRule;if(C.length){var ie=C;if(ie)for(var O,ne=-1,re=ie.length-1;ne<re;){O=ie[ne+=1];var oe=s[O];if(e.util.schemaHasRules(oe,e.RULES.all)){var se=e.util.getProperty(O),Z=h+se,ae=te&&void 0!==oe.default;f.schema=oe,f.schemaPath=a+se,f.errSchemaPath=l+"/"+e.util.escapeFragment(O),f.errorPath=e.util.getPath(e.errorPath,O,e.opts.jsonPointers),f.dataPathArr[y]=e.util.toQuotedString(O);var ee=e.validate(f);if(f.baseId=B,e.util.varOccurences(ee,w)<2){ee=e.util.varReplace(ee,w,Z);var le=Z}else{var le=w;n+=" var "+w+" = "+Z+"; "}if(ae)n+=" "+ee+" ";else{if(R&&R[O]){n+=" if ( "+le+" === undefined ",$&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(O)+"') "),n+=") { "+m+" = false; ";var q=e.errorPath,Q=l,ce=e.util.escapeQuotes(O);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(q,O,e.opts.jsonPointers)),l=e.errSchemaPath+"/required";var J=J||[];J.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+ce+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+ce+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var X=n;n=J.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+X+"]); ":n+=" validate.errors = ["+X+"]; return false; ":n+=" var err = "+X+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l=Q,e.errorPath=q,n+=" } else { "}else c?(n+=" if ( "+le+" === undefined ",$&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(O)+"') "),n+=") { "+m+" = true; } else { "):(n+=" if ("+le+" !== undefined ",$&&(n+=" &&   Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(O)+"') "),n+=" ) { ");n+=" "+ee+" } "}}c&&(n+=" if ("+m+") { ",p+="}")}}if(E.length){var he=E;if(he)for(var H,de=-1,ue=he.length-1;de<ue;){H=he[de+=1];var oe=A[H];if(e.util.schemaHasRules(oe,e.RULES.all)){f.schema=oe,f.schemaPath=e.schemaPath+".patternProperties"+e.util.getProperty(H),f.errSchemaPath=e.errSchemaPath+"/patternProperties/"+e.util.escapeFragment(H),n+=$?" "+b+" = "+b+" || Object.keys("+h+"); for (var "+v+"=0; "+v+"<"+b+".length; "+v+"++) { var "+g+" = "+b+"["+v+"]; ":" for (var "+g+" in "+h+") { ",n+=" if ("+e.usePattern(H)+".test("+g+")) { ",f.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers);var Z=h+"["+g+"]";f.dataPathArr[y]=g;var ee=e.validate(f);f.baseId=B,e.util.varOccurences(ee,w)<2?n+=" "+e.util.varReplace(ee,w,Z)+" ":n+=" var "+w+" = "+Z+"; "+ee+" ",c&&(n+=" if (!"+m+") break; "),n+=" } ",c&&(n+=" else "+m+" = true; "),n+=" }  ",c&&(n+=" if ("+m+") { ",p+="}")}}}if(e.opts.patternGroups&&P.length){var fe=P;if(fe)for(var U,pe=-1,me=fe.length-1;pe<me;){U=fe[pe+=1];var ge=T[U],oe=ge.schema;if(e.util.schemaHasRules(oe,e.RULES.all)){f.schema=oe,f.schemaPath=e.schemaPath+".patternGroups"+e.util.getProperty(U)+".schema",f.errSchemaPath=e.errSchemaPath+"/patternGroups/"+e.util.escapeFragment(U)+"/schema",n+=" var pgPropCount"+r+" = 0;  ",n+=$?" "+b+" = "+b+" || Object.keys("+h+"); for (var "+v+"=0; "+v+"<"+b+".length; "+v+"++) { var "+g+" = "+b+"["+v+"]; ":" for (var "+g+" in "+h+") { ",n+=" if ("+e.usePattern(U)+".test("+g+")) { pgPropCount"+r+"++; ",f.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers);var Z=h+"["+g+"]";f.dataPathArr[y]=g;var ee=e.validate(f);f.baseId=B,e.util.varOccurences(ee,w)<2?n+=" "+e.util.varReplace(ee,w,Z)+" ":n+=" var "+w+" = "+Z+"; "+ee+" ",c&&(n+=" if (!"+m+") break; "),n+=" } ",c&&(n+=" else "+m+" = true; "),n+=" }  ",c&&(n+=" if ("+m+") { ",p+="}");var ve=ge.minimum,ye=ge.maximum;if(void 0!==ve||void 0!==ye){n+=" var "+d+" = true; ";var Q=l;if(void 0!==ve){var we=ve,be="minimum",Ce="less";n+=" "+d+" = pgPropCount"+r+" >= "+ve+"; ",l=e.errSchemaPath+"/patternGroups/minimum",n+="  if (!"+d+") {   ";var J=J||[];J.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'patternGroups' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { reason: '"+be+"', limit: "+we+", pattern: '"+e.util.escapeQuotes(U)+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have "+Ce+" than "+we+' properties matching pattern "'+e.util.escapeQuotes(U)+"\"' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var X=n;n=J.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+X+"]); ":n+=" validate.errors = ["+X+"]; return false; ":n+=" var err = "+X+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",void 0!==ye&&(n+=" else ")}if(void 0!==ye){var we=ye,be="maximum",Ce="more";n+=" "+d+" = pgPropCount"+r+" <= "+ye+"; ",l=e.errSchemaPath+"/patternGroups/maximum",n+="  if (!"+d+") {   ";var J=J||[];J.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'patternGroups' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { reason: '"+be+"', limit: "+we+", pattern: '"+e.util.escapeQuotes(U)+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have "+Ce+" than "+we+' properties matching pattern "'+e.util.escapeQuotes(U)+"\"' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var X=n;n=J.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+X+"]); ":n+=" validate.errors = ["+X+"]; return false; ":n+=" var err = "+X+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } "}l=Q,c&&(n+=" if ("+d+") { ",p+="}")}}}}return c&&(n+=" "+p+" if ("+u+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="errs__"+r,u=e.util.copy(e);u.level++;var f="valid"+u.level;if(e.util.schemaHasRules(s,e.RULES.all)){u.schema=s,u.schemaPath=a,u.errSchemaPath=l;var p="key"+r,m="idx"+r,g="i"+r,v="' + "+p+" + '",y=u.dataLevel=e.dataLevel+1,w="data"+y,b="dataProperties"+r,C=e.opts.ownProperties,A=e.baseId;n+=" var "+d+" = errors; ",C&&(n+=" var "+b+" = undefined; "),n+=C?" "+b+" = "+b+" || Object.keys("+h+"); for (var "+m+"=0; "+m+"<"+b+".length; "+m+"++) { var "+p+" = "+b+"["+m+"]; ":" for (var "+p+" in "+h+") { ",n+=" var startErrs"+r+" = errors; ";var E=p,F=e.compositeRule;e.compositeRule=u.compositeRule=!0;var x=e.validate(u);u.baseId=A,e.util.varOccurences(x,w)<2?n+=" "+e.util.varReplace(x,w,E)+" ":n+=" var "+w+" = "+E+"; "+x+" ",e.compositeRule=u.compositeRule=F,n+=" if (!"+f+") { for (var "+g+"=startErrs"+r+"; "+g+"<errors; "+g+"++) { vErrors["+g+"].propertyName = "+p+"; }   var err =   ",!1!==e.createErrors?(n+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { propertyName: '"+v+"' } ",!1!==e.opts.messages&&(n+=" , message: 'property name \\'"+v+"\\' is invalid' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&c&&(e.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),c&&(n+=" break; "),n+=" } }"}return c&&(n+="  if ("+d+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u=e.opts.$data&&s&&s.$data;u&&(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ");var f="schema"+r;if(!u)if(s.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var p=[],m=s;if(m)for(var g,v=-1,y=m.length-1;v<y;){g=m[v+=1];var w=e.schema.properties[g];w&&e.util.schemaHasRules(w,e.RULES.all)||(p[p.length]=g)}}else var p=s;if(u||p.length){var b=e.errorPath,C=u||p.length>=e.opts.loopRequired,A=e.opts.ownProperties;if(c)if(n+=" var missing"+r+"; ",C){u||(n+=" var "+f+" = validate.schema"+a+"; ");var E="i"+r,F="schema"+r+"["+E+"]",x="' + "+F+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(b,F,e.opts.jsonPointers)),n+=" var "+d+" = true; ",u&&(n+=" if (schema"+r+" === undefined) "+d+" = true; else if (!Array.isArray(schema"+r+")) "+d+" = false; else {"),n+=" for (var "+E+" = 0; "+E+" < "+f+".length; "+E+"++) { "+d+" = "+h+"["+f+"["+E+"]] !== undefined ",A&&(n+=" &&   Object.prototype.hasOwnProperty.call("+h+", "+f+"["+E+"]) "),n+="; if (!"+d+") break; } ",u&&(n+="  }  "),n+="  if (!"+d+") {   ";var S=S||[];S.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+x+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+x+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var _=n;n=S.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+_+"]); ":n+=" validate.errors = ["+_+"]; return false; ":n+=" var err = "+_+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else { "}else{n+=" if ( ";var k=p;if(k)for(var D,E=-1,$=k.length-1;E<$;){D=k[E+=1],E&&(n+=" || ");var B=e.util.getProperty(D),L=h+B;n+=" ( ( "+L+" === undefined ",A&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(D)+"') "),n+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?D:B)+") ) "}n+=") {  ";var F="missing"+r,x="' + "+F+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(b,F,!0):b+" + "+F);var S=S||[];S.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+x+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+x+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var _=n;n=S.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+_+"]); ":n+=" validate.errors = ["+_+"]; return false; ":n+=" var err = "+_+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else { "}else if(C){u||(n+=" var "+f+" = validate.schema"+a+"; ");var E="i"+r,F="schema"+r+"["+E+"]",x="' + "+F+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(b,F,e.opts.jsonPointers)),u&&(n+=" if ("+f+" && !Array.isArray("+f+")) {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+x+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+x+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+f+" !== undefined) { "),n+=" for (var "+E+" = 0; "+E+" < "+f+".length; "+E+"++) { if ("+h+"["+f+"["+E+"]] === undefined ",A&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", "+f+"["+E+"]) "),n+=") {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+x+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+x+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",u&&(n+="  }  ")}else{var R=p;if(R)for(var D,T=-1,P=R.length-1;T<P;){D=R[T+=1];var B=e.util.getProperty(D),x=e.util.escapeQuotes(D),L=h+B;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(b,D,e.opts.jsonPointers)),n+=" if ( "+L+" === undefined ",A&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(D)+"') "),n+=") {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+x+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+x+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}e.errorPath=b}else c&&(n+=" if (true) {");return n}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u="valid"+o,f=e.opts.$data&&a&&a.$data;if(f?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ",n="schema"+o):n=a,(a||f)&&!1!==e.opts.uniqueItems){f&&(r+=" var "+u+"; if ("+n+" === false || "+n+" === undefined) "+u+" = true; else if (typeof "+n+" != 'boolean') "+u+" = false; else { "),r+=" var "+u+" = true; if ("+d+".length > 1) { var i = "+d+".length, j; outer: for (;i--;) { for (j = i; j--;) { if (equal("+d+"[i], "+d+"[j])) { "+u+" = false; break outer; } } } } ",f&&(r+="  }  "),r+=" if (!"+u+") {   ";var p=p||[];p.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(r+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(r+=" , schema:  ",r+=f?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var m=r;r=p.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+m+"]); ":r+=" validate.errors = ["+m+"]; return false; ":r+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+=" } ",h&&(r+=" else { ")}else h&&(r+=" if (true) { ");return r}},function(e,t){"use strict";var i=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];e.exports=function(e,t){for(var n=0;n<t.length;n++){e=JSON.parse(JSON.stringify(e));var r,o=t[n].split("/"),s=e;for(r=1;r<o.length;r++)s=s[o[r]];for(r=0;r<i.length;r++){var a=i[r],l=s[a];l&&(s[a]={anyOf:[l,{$ref:"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/$data.json#"}]})}}return e}},function(e,t){"use strict";e.exports=function(e){var t=e._opts.defaultMeta,i="string"==typeof t?{$ref:t}:e.getSchema("http://json-schema.org/draft-06/schema")?{$ref:"http://json-schema.org/draft-06/schema"}:{};e.addKeyword("patternGroups",{metaSchema:{type:"object",additionalProperties:{type:"object",required:["schema"],properties:{maximum:{type:"integer",minimum:0},minimum:{type:"integer",minimum:0},schema:i},additionalProperties:!1}}}),e.RULES.all.properties.implements.push("patternGroups")}},function(e,t,i){"use strict";function n(e,t,i){function o(e){var t=e.$schema;return t&&!a.getSchema(t)?n.call(a,{$ref:t},!0):Promise.resolve()}function s(e){try{return a._compile(e)}catch(i){if(i instanceof r)return function(i){function n(){delete a._loadingSchemas[l]}function r(e){return a._refs[e]||a._schemas[e]}var l=i.missingSchema;if(r(l))throw new Error("Schema "+l+" is loaded but "+i.missingRef+" cannot be resolved");var c=a._loadingSchemas[l];return c||(c=a._loadingSchemas[l]=a._opts.loadSchema(l),c.then(n,n)),c.then(function(e){if(!r(l))return o(e).then(function(){r(l)||a.addSchema(e,l,void 0,t)})}).then(function(){return s(e)})}(i);throw i}}var a=this;if("function"!=typeof this._opts.loadSchema)throw new Error("options.loadSchema should be a function");"function"==typeof t&&(i=t,t=void 0);var l=o(e).then(function(){var i=a._addSchema(e,void 0,t);return i.validate||s(i)});return i&&l.then(function(e){i(null,e)},i),l}var r=i(15).MissingRef;e.exports=n},function(e,t,i){"use strict";function n(e,t){function i(e,t,i){for(var n,o=0;o<r.length;o++){var s=r[o];if(s.type==t){n=s;break}}n||(n={type:t,rules:[]},r.push(n));var l={keyword:e,definition:i,custom:!0,code:a,implements:i.implements};n.rules.push(l),r.custom[e]=l}function n(e){if(!r.types[e])throw new Error("Unknown type "+e)}var r=this.RULES;if(r.keywords[e])throw new Error("Keyword "+e+" is already defined");if(!s.test(e))throw new Error("Keyword "+e+" is not a valid identifier");if(t){if(t.macro&&void 0!==t.valid)throw new Error('"valid" option cannot be used with macro keywords');var o=t.type;if(Array.isArray(o)){var l,c=o.length;for(l=0;l<c;l++)n(o[l]);for(l=0;l<c;l++)i(e,o[l],t)}else o&&n(o),i(e,o,t);var h=!0===t.$data&&this._opts.$data;if(h&&!t.validate)throw new Error('$data support: "validate" function is not defined');var d=t.metaSchema;d&&(h&&(d={anyOf:[d,{$ref:"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/$data.json#"}]}),t.validateSchema=this.compile(d,!0))}return r.keywords[e]=r.all[e]=!0,this}function r(e){var t=this.RULES.custom[e];return t?t.definition:this.RULES.keywords[e]||!1}function o(e){var t=this.RULES;delete t.keywords[e],delete t.all[e],delete t.custom[e];for(var i=0;i<t.length;i++)for(var n=t[i].rules,r=0;r<n.length;r++)if(n[r].keyword==e){n.splice(r,1);break}return this}var s=/^[a-z_$][a-z0-9_$-]*$/i,a=i(48);e.exports={add:n,get:r,remove:o}},function(e,t){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.schemaPath+e.util.getProperty(t),h=e.errSchemaPath+"/"+t,d=!e.opts.allErrors,u="data"+(a||""),f="valid"+s,p="errs__"+s,m=e.opts.$data&&l&&l.$data;m?(o+=" var schema"+s+" = "+e.util.getData(l.$data,a,e.dataPathArr)+"; ",r="schema"+s):r=l;var g,v,y,w,b,C=this,A="definition"+s,E=C.definition,F="";if(m&&E.$data){b="keywordValidate"+s;var x=E.validateSchema;o+=" var "+A+" = RULES.custom['"+t+"'].definition; var "+b+" = "+A+".validate;"}else{if(!(w=e.useCustomRule(C,l,e.schema,e)))return;r="validate.schema"+c,b=w.code,g=E.compile,v=E.inline,y=E.macro}var S=b+".errors",_="i"+s,k="ruleErr"+s,D=E.async;if(D&&!e.async)throw new Error("async keyword in sync schema");if(v||y||(o+=S+" = null;"),o+="var "+p+" = errors;var "+f+";",m&&E.$data&&(F+="}",o+=" if ("+r+" === undefined) { "+f+" = true; } else { ",x&&(F+="}",o+=" "+f+" = "+A+".validateSchema("+r+"); if ("+f+") { ")),v)E.statements?o+=" "+w.validate+" ":o+=" "+f+" = "+w.validate+"; ";else if(y){var $=e.util.copy(e),F="";$.level++;var B="valid"+$.level;$.schema=w.validate,$.schemaPath="";var L=e.compositeRule;e.compositeRule=$.compositeRule=!0;var R=e.validate($).replace(/validate\.schema/g,b);e.compositeRule=$.compositeRule=L,o+=" "+R}else{var T=T||[];T.push(o),o="",o+="  "+b+".call( ",e.opts.passContext?o+="this":o+="self",g||!1===E.schema?o+=" , "+u+" ":o+=" , "+r+" , "+u+" , validate.schema"+e.schemaPath+" ",o+=" , (dataPath || '')",'""'!=e.errorPath&&(o+=" + "+e.errorPath);var P=a?"data"+(a-1||""):"parentData",M=a?e.dataPathArr[a]:"parentDataProperty";o+=" , "+P+" , "+M+" , rootData )  ";var O=o;o=T.pop(),!1===E.errors?(o+=" "+f+" = ",D&&(o+=""+e.yieldAwait),o+=O+"; "):D?(S="customErrors"+s,o+=" var "+S+" = null; try { "+f+" = "+e.yieldAwait+O+"; } catch (e) { "+f+" = false; if (e instanceof ValidationError) "+S+" = e.errors; else throw e; } "):o+=" "+S+" = null; "+f+" = "+O+"; "}if(E.modifying&&(o+=" if ("+P+") "+u+" = "+P+"["+M+"];"),o+=""+F,E.valid)d&&(o+=" if (true) { ");else{o+=" if ( ",void 0===E.valid?(o+=" !",o+=y?""+B:""+f):o+=" "+!E.valid+" ",o+=") { ",n=C.keyword;var T=T||[];T.push(o),o="";var T=T||[];T.push(o),o="",!1!==e.createErrors?(o+=" { keyword: '"+(n||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { keyword: '"+C.keyword+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should pass \""+C.keyword+"\" keyword validation' "),e.opts.verbose&&(o+=" , schema: validate.schema"+c+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var I=o;o=T.pop(),!e.compositeRule&&d?e.async?o+=" throw new ValidationError(["+I+"]); ":o+=" validate.errors = ["+I+"]; return false; ":o+=" var err = "+I+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";var N=o;o=T.pop(),v?E.errors?"full"!=E.errors&&(o+="  for (var "+_+"="+p+"; "+_+"<errors; "+_+"++) { var "+k+" = vErrors["+_+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+k+".schemaPath === undefined) { "+k+'.schemaPath = "'+h+'"; } ',e.opts.verbose&&(o+=" "+k+".schema = "+r+"; "+k+".data = "+u+"; "),o+=" } "):!1===E.errors?o+=" "+N+" ":(o+=" if ("+p+" == errors) { "+N+" } else {  for (var "+_+"="+p+"; "+_+"<errors; "+_+"++) { var "+k+" = vErrors["+_+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+k+".schemaPath === undefined) { "+k+'.schemaPath = "'+h+'"; } ',e.opts.verbose&&(o+=" "+k+".schema = "+r+"; "+k+".data = "+u+"; "),o+=" } } "):y?(o+="   var err =   ",!1!==e.createErrors?(o+=" { keyword: '"+(n||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { keyword: '"+C.keyword+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should pass \""+C.keyword+"\" keyword validation' "),e.opts.verbose&&(o+=" , schema: validate.schema"+c+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&d&&(e.async?o+=" throw new ValidationError(vErrors); ":o+=" validate.errors = vErrors; return false; ")):!1===E.errors?o+=" "+N+" ":(o+=" if (Array.isArray("+S+")) { if (vErrors === null) vErrors = "+S+"; else vErrors = vErrors.concat("+S+"); errors = vErrors.length;  for (var "+_+"="+p+"; "+_+"<errors; "+_+"++) { var "+k+" = vErrors["+_+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+";  "+k+'.schemaPath = "'+h+'";  ',e.opts.verbose&&(o+=" "+k+".schema = "+r+"; "+k+".data = "+u+"; "),o+=" } } else { "+N+" } "),o+=" } ",d&&(o+=" else { ")}return o}},function(e,t){e.exports={$schema:"http://json-schema.org/draft-06/schema#",$id:"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/$data.json#",description:"Meta-schema for $data reference (JSON-schema extension proposal)",type:"object",required:["$data"],properties:{$data:{type:"string",anyOf:[{format:"relative-json-pointer"},{format:"json-pointer"}]}},additionalProperties:!1}},function(e,t){e.exports={$schema:"http://json-schema.org/draft-06/schema#",$id:"http://json-schema.org/draft-06/schema#",title:"Core schema meta-schema",definitions:{schemaArray:{type:"array",minItems:1,items:{$ref:"#"}},nonNegativeInteger:{type:"integer",minimum:0},nonNegativeIntegerDefault0:{allOf:[{$ref:"#/definitions/nonNegativeInteger"},{default:0}]},simpleTypes:{enum:["array","boolean","integer","null","number","object","string"]},stringArray:{type:"array",items:{type:"string"},uniqueItems:!0,default:[]}},type:["object","boolean"],properties:{$id:{type:"string",format:"uri-reference"},$schema:{type:"string",format:"uri"},$ref:{type:"string",format:"uri-reference"},title:{type:"string"},description:{type:"string"},default:{},examples:{type:"array",items:{}},multipleOf:{type:"number",exclusiveMinimum:0},maximum:{type:"number"},exclusiveMaximum:{type:"number"},minimum:{type:"number"},exclusiveMinimum:{type:"number"},maxLength:{$ref:"#/definitions/nonNegativeInteger"},minLength:{$ref:"#/definitions/nonNegativeIntegerDefault0"},pattern:{type:"string",format:"regex"},additionalItems:{$ref:"#"},items:{anyOf:[{$ref:"#"},{$ref:"#/definitions/schemaArray"}],default:{}},maxItems:{$ref:"#/definitions/nonNegativeInteger"},minItems:{$ref:"#/definitions/nonNegativeIntegerDefault0"},uniqueItems:{type:"boolean",default:!1},contains:{$ref:"#"},maxProperties:{$ref:"#/definitions/nonNegativeInteger"},minProperties:{$ref:"#/definitions/nonNegativeIntegerDefault0"},required:{$ref:"#/definitions/stringArray"},additionalProperties:{$ref:"#"},definitions:{type:"object",additionalProperties:{$ref:"#"},default:{}},properties:{type:"object",additionalProperties:{$ref:"#"},default:{}},patternProperties:{type:"object",additionalProperties:{$ref:"#"},default:{}},dependencies:{type:"object",additionalProperties:{anyOf:[{$ref:"#"},{$ref:"#/definitions/stringArray"}]}},propertyNames:{$ref:"#"},const:{},enum:{type:"array",minItems:1,uniqueItems:!0},type:{anyOf:[{$ref:"#/definitions/simpleTypes"},{type:"array",items:{$ref:"#/definitions/simpleTypes"},minItems:1,uniqueItems:!0}]},format:{type:"string"},allOf:{$ref:"#/definitions/schemaArray"},anyOf:{$ref:"#/definitions/schemaArray"},oneOf:{$ref:"#/definitions/schemaArray"},not:{$ref:"#"}},default:{}}},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(52),i(54),i(56)}catch(e){}e.exports=n},function(e,t,i){!function(){var e=function(){return this}();e||"undefined"==typeof window||(e=window);var t=function(e,i,n){if("string"!=typeof e)return void(t.original?t.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace()));2==arguments.length&&(n=i),t.modules[e]||(t.payloads[e]=n,t.modules[e]=null)};t.modules={},t.payloads={};var i=function(e,t,i){if("string"==typeof t){var r=o(e,t);if(void 0!=r)return i&&i(),r}else if("[object Array]"===Object.prototype.toString.call(t)){for(var s=[],a=0,l=t.length;a<l;++a){var c=o(e,t[a]);if(void 0==c&&n.original)return;s.push(c)}return i&&i.apply(null,s)||!0}},n=function(e,t){var r=i("",e,t);return void 0==r&&n.original?n.original.apply(this,arguments):r},r=function(e,t){if(-1!==t.indexOf("!")){var i=t.split("!");return r(e,i[0])+"!"+r(e,i[1])}if("."==t.charAt(0)){var n=e.split("/").slice(0,-1).join("/");for(t=n+"/"+t;-1!==t.indexOf(".")&&o!=t;){var o=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}}return t},o=function(e,n){n=r(e,n);var o=t.modules[n];if(!o){if("function"==typeof(o=t.payloads[n])){var s={},a={id:n,uri:"",exports:s,packaged:!0};s=o(function(e,t){return i(n,e,t)},s,a)||a.exports,t.modules[n]=s,delete t.payloads[n]}o=t.modules[n]=s||o}return o};!function(i){var r=e;i&&(e[i]||(e[i]={}),r=e[i]),r.define&&r.define.packaged||(t.original=r.define,r.define=t,r.define.packaged=!0),r.acequire&&r.acequire.packaged||(n.original=r.acequire,r.acequire=n,r.acequire.packaged=!0)}("ace")}(),ace.define("ace/lib/regexp",["require","exports","module"],function(e,t,i){"use strict";function n(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.extended?"x":"")+(e.sticky?"y":"")}function r(e,t,i){if(Array.prototype.indexOf)return e.indexOf(t,i);for(var n=i||0;n<e.length;n++)if(e[n]===t)return n;return-1}var o={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},s=void 0===o.exec.call(/()??/,"")[1],a=function(){return o.test.call(/^/g,""),!/^/g.lastIndex}();a&&s||(RegExp.prototype.exec=function(e){var t,i,l=o.exec.apply(this,arguments);if("string"==typeof e&&l){if(!s&&l.length>1&&r(l,"")>-1&&(i=RegExp(this.source,o.replace.call(n(this),"g","")),o.replace.call(e.slice(l.index),i,function(){for(var e=1;e<arguments.length-2;e++)void 0===arguments[e]&&(l[e]=void 0)})),this._xregexp&&this._xregexp.captureNames)for(var c=1;c<l.length;c++)(t=this._xregexp.captureNames[c-1])&&(l[t]=l[c]);!a&&this.global&&!l[0].length&&this.lastIndex>l.index&&this.lastIndex--}return l},a||(RegExp.prototype.test=function(e){var t=o.exec.call(this,e);return t&&this.global&&!t[0].length&&this.lastIndex>t.index&&this.lastIndex--,!!t}))}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(e,t,i){function n(){}function r(e){try{return Object.defineProperty(e,"sentinel",{}),"sentinel"in e}catch(e){}}function o(e){return e=+e,e!==e?e=0:0!==e&&e!==1/0&&e!==-1/0&&(e=(e>0||-1)*Math.floor(Math.abs(e))),e}Function.prototype.bind||(Function.prototype.bind=function(e){var t=this;if("function"!=typeof t)throw new TypeError("Function.prototype.bind called on incompatible "+t);var i=p.call(arguments,1),r=function(){if(this instanceof r){var n=t.apply(this,i.concat(p.call(arguments)));return Object(n)===n?n:this}return t.apply(e,i.concat(p.call(arguments)))};return t.prototype&&(n.prototype=t.prototype,r.prototype=new n,n.prototype=null),r});var s,a,l,c,h,d=Function.prototype.call,u=Array.prototype,f=Object.prototype,p=u.slice,m=d.bind(f.toString),g=d.bind(f.hasOwnProperty);if((h=g(f,"__defineGetter__"))&&(s=d.bind(f.__defineGetter__),a=d.bind(f.__defineSetter__),l=d.bind(f.__lookupGetter__),c=d.bind(f.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function e(e){var t=new Array(e+2);return t[0]=t[1]=0,t}var t,i=[];if(i.splice.apply(i,e(20)),i.splice.apply(i,e(26)),t=i.length,i.splice(5,0,"XXX"),i.length,t+1==i.length)return!0}()){var v=Array.prototype.splice;Array.prototype.splice=function(e,t){return arguments.length?v.apply(this,[void 0===e?0:e,void 0===t?this.length-e:t].concat(p.call(arguments,2))):[]}}else Array.prototype.splice=function(e,t){var i=this.length;e>0?e>i&&(e=i):void 0==e?e=0:e<0&&(e=Math.max(i+e,0)),e+t<i||(t=i-e);var n=this.slice(e,e+t),r=p.call(arguments,2),o=r.length;if(e===i)o&&this.push.apply(this,r);else{var s=Math.min(t,i-e),a=e+s,l=a+o-s,c=i-a,h=i-s;if(l<a)for(var d=0;d<c;++d)this[l+d]=this[a+d];else if(l>a)for(d=c;d--;)this[l+d]=this[a+d];if(o&&e===h)this.length=h,this.push.apply(this,r);else for(this.length=h+o,d=0;d<o;++d)this[e+d]=r[d]}return n};Array.isArray||(Array.isArray=function(e){return"[object Array]"==m(e)});var y=Object("a"),w="a"!=y[0]||!(0 in y);if(Array.prototype.forEach||(Array.prototype.forEach=function(e){var t=B(this),i=w&&"[object String]"==m(this)?this.split(""):t,n=arguments[1],r=-1,o=i.length>>>0;if("[object Function]"!=m(e))throw new TypeError;for(;++r<o;)r in i&&e.call(n,i[r],r,t)}),Array.prototype.map||(Array.prototype.map=function(e){var t=B(this),i=w&&"[object String]"==m(this)?this.split(""):t,n=i.length>>>0,r=Array(n),o=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var s=0;s<n;s++)s in i&&(r[s]=e.call(o,i[s],s,t));return r}),Array.prototype.filter||(Array.prototype.filter=function(e){var t,i=B(this),n=w&&"[object String]"==m(this)?this.split(""):i,r=n.length>>>0,o=[],s=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var a=0;a<r;a++)a in n&&(t=n[a],e.call(s,t,a,i)&&o.push(t));return o}),Array.prototype.every||(Array.prototype.every=function(e){var t=B(this),i=w&&"[object String]"==m(this)?this.split(""):t,n=i.length>>>0,r=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var o=0;o<n;o++)if(o in i&&!e.call(r,i[o],o,t))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(e){var t=B(this),i=w&&"[object String]"==m(this)?this.split(""):t,n=i.length>>>0,r=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var o=0;o<n;o++)if(o in i&&e.call(r,i[o],o,t))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(e){var t=B(this),i=w&&"[object String]"==m(this)?this.split(""):t,n=i.length>>>0;if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");if(!n&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var r,o=0;if(arguments.length>=2)r=arguments[1];else for(;;){if(o in i){r=i[o++];break}if(++o>=n)throw new TypeError("reduce of empty array with no initial value")}for(;o<n;o++)o in i&&(r=e.call(void 0,r,i[o],o,t));return r}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(e){var t=B(this),i=w&&"[object String]"==m(this)?this.split(""):t,n=i.length>>>0;if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");if(!n&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var r,o=n-1;if(arguments.length>=2)r=arguments[1];else for(;;){if(o in i){r=i[o--];break}if(--o<0)throw new TypeError("reduceRight of empty array with no initial value")}do{o in this&&(r=e.call(void 0,r,i[o],o,t))}while(o--);return r}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(e){var t=w&&"[object String]"==m(this)?this.split(""):B(this),i=t.length>>>0;if(!i)return-1;var n=0;for(arguments.length>1&&(n=o(arguments[1])),n=n>=0?n:Math.max(0,i+n);n<i;n++)if(n in t&&t[n]===e)return n;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(e){var t=w&&"[object String]"==m(this)?this.split(""):B(this),i=t.length>>>0;if(!i)return-1;var n=i-1;for(arguments.length>1&&(n=Math.min(n,o(arguments[1]))),n=n>=0?n:i-Math.abs(n);n>=0;n--)if(n in t&&e===t[n])return n;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(e){return e.__proto__||(e.constructor?e.constructor.prototype:f)}),!Object.getOwnPropertyDescriptor){Object.getOwnPropertyDescriptor=function(e,t){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.getOwnPropertyDescriptor called on a non-object: "+e);if(g(e,t)){var i,n,r;if(i={enumerable:!0,configurable:!0},h){var o=e.__proto__;e.__proto__=f;var n=l(e,t),r=c(e,t);if(e.__proto__=o,n||r)return n&&(i.get=n),r&&(i.set=r),i}return i.value=e[t],i}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(e){return Object.keys(e)}),!Object.create){var b;b=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var e={};for(var t in e)e[t]=null;return e.constructor=e.hasOwnProperty=e.propertyIsEnumerable=e.isPrototypeOf=e.toLocaleString=e.toString=e.valueOf=e.__proto__=null,e},Object.create=function(e,t){var i;if(null===e)i=b();else{if("object"!=typeof e)throw new TypeError("typeof prototype["+typeof e+"] != 'object'");var n=function(){};n.prototype=e,i=new n,i.__proto__=e}return void 0!==t&&Object.defineProperties(i,t),i}}if(Object.defineProperty){var C=r({}),A="undefined"==typeof document||r(document.createElement("div"));if(!C||!A)var E=Object.defineProperty}if(!Object.defineProperty||E){Object.defineProperty=function(e,t,i){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.defineProperty called on non-object: "+e);if("object"!=typeof i&&"function"!=typeof i||null===i)throw new TypeError("Property description must be an object: "+i);if(E)try{return E.call(Object,e,t,i)}catch(e){}if(g(i,"value"))if(h&&(l(e,t)||c(e,t))){var n=e.__proto__;e.__proto__=f,delete e[t],e[t]=i.value,e.__proto__=n}else e[t]=i.value;else{if(!h)throw new TypeError("getters & setters can not be defined on this javascript engine");g(i,"get")&&s(e,t,i.get),g(i,"set")&&a(e,t,i.set)}return e}}Object.defineProperties||(Object.defineProperties=function(e,t){for(var i in t)g(t,i)&&Object.defineProperty(e,i,t[i]);return e}),Object.seal||(Object.seal=function(e){return e}),Object.freeze||(Object.freeze=function(e){return e});try{Object.freeze(function(){})}catch(e){Object.freeze=function(e){return function(t){return"function"==typeof t?t:e(t)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(e){return e}),Object.isSealed||(Object.isSealed=function(e){return!1}),Object.isFrozen||(Object.isFrozen=function(e){
return!1}),Object.isExtensible||(Object.isExtensible=function(e){if(Object(e)===e)throw new TypeError;for(var t="";g(e,t);)t+="?";e[t]=!0;var i=g(e,t);return delete e[t],i}),!Object.keys){var F=!0,x=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],S=x.length;for(var _ in{toString:null})F=!1;Object.keys=function(e){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.keys called on a non-object");var t=[];for(var i in e)g(e,i)&&t.push(i);if(F)for(var n=0,r=S;n<r;n++){var o=x[n];g(e,o)&&t.push(o)}return t}}Date.now||(Date.now=function(){return(new Date).getTime()});var k="\t\n\v\f\r   ᠎             　\u2028\u2029\ufeff";if(!String.prototype.trim||k.trim()){k="["+k+"]";var D=new RegExp("^"+k+k+"*"),$=new RegExp(k+k+"*$");String.prototype.trim=function(){return String(this).replace(D,"").replace($,"")}}var B=function(e){if(null==e)throw new TypeError("can't convert "+e+" to object");return Object(e)}}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/regexp","ace/lib/es5-shim"],function(e,t,i){"use strict";e("./regexp"),e("./es5-shim")}),ace.define("ace/lib/dom",["require","exports","module"],function(e,t,i){"use strict";if(t.getDocumentHead=function(e){return e||(e=document),e.head||e.getElementsByTagName("head")[0]||e.documentElement},t.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},t.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},t.addCssClass=function(e,i){t.hasCssClass(e,i)||(e.className+=" "+i)},t.removeCssClass=function(e,t){for(var i=e.className.split(/\s+/g);;){var n=i.indexOf(t);if(-1==n)break;i.splice(n,1)}e.className=i.join(" ")},t.toggleCssClass=function(e,t){for(var i=e.className.split(/\s+/g),n=!0;;){var r=i.indexOf(t);if(-1==r)break;n=!1,i.splice(r,1)}return n&&i.push(t),e.className=i.join(" "),n},t.setCssClass=function(e,i,n){n?t.addCssClass(e,i):t.removeCssClass(e,i)},t.hasCssString=function(e,t){var i,n=0;if(t=t||document,t.createStyleSheet&&(i=t.styleSheets)){for(;n<i.length;)if(i[n++].owningElement.id===e)return!0}else if(i=t.getElementsByTagName("style"))for(;n<i.length;)if(i[n++].id===e)return!0;return!1},t.importCssString=function(e,i,n){if(n=n||document,i&&t.hasCssString(i,n))return null;var r;i&&(e+="\n/*# sourceURL=ace/css/"+i+" */"),n.createStyleSheet?(r=n.createStyleSheet(),r.cssText=e,i&&(r.owningElement.id=i)):(r=t.createElement("style"),r.appendChild(n.createTextNode(e)),i&&(r.id=i),t.getDocumentHead(n).appendChild(r))},t.importCssStylsheet=function(e,i){if(i.createStyleSheet)i.createStyleSheet(e);else{var n=t.createElement("link");n.rel="stylesheet",n.href=e,t.getDocumentHead(i).appendChild(n)}},t.getInnerWidth=function(e){return parseInt(t.computedStyle(e,"paddingLeft"),10)+parseInt(t.computedStyle(e,"paddingRight"),10)+e.clientWidth},t.getInnerHeight=function(e){return parseInt(t.computedStyle(e,"paddingTop"),10)+parseInt(t.computedStyle(e,"paddingBottom"),10)+e.clientHeight},t.scrollbarWidth=function(e){var i=t.createElement("ace_inner");i.style.width="100%",i.style.minWidth="0px",i.style.height="200px",i.style.display="block";var n=t.createElement("ace_outer"),r=n.style;r.position="absolute",r.left="-10000px",r.overflow="hidden",r.width="200px",r.minWidth="0px",r.height="150px",r.display="block",n.appendChild(i);var o=e.documentElement;o.appendChild(n);var s=i.offsetWidth;r.overflow="scroll";var a=i.offsetWidth;return s==a&&(a=n.clientWidth),o.removeChild(n),s-a},"undefined"==typeof document)return void(t.importCssString=function(){});void 0!==window.pageYOffset?(t.getPageScrollTop=function(){return window.pageYOffset},t.getPageScrollLeft=function(){return window.pageXOffset}):(t.getPageScrollTop=function(){return document.body.scrollTop},t.getPageScrollLeft=function(){return document.body.scrollLeft}),window.getComputedStyle?t.computedStyle=function(e,t){return t?(window.getComputedStyle(e,"")||{})[t]||"":window.getComputedStyle(e,"")||{}}:t.computedStyle=function(e,t){return t?e.currentStyle[t]:e.currentStyle},t.setInnerHtml=function(e,t){var i=e.cloneNode(!1);return i.innerHTML=t,e.parentNode.replaceChild(i,e),i},"textContent"in document.documentElement?(t.setInnerText=function(e,t){e.textContent=t},t.getInnerText=function(e){return e.textContent}):(t.setInnerText=function(e,t){e.innerText=t},t.getInnerText=function(e){return e.innerText}),t.getParentWindow=function(e){return e.defaultView||e.parentWindow}}),ace.define("ace/lib/oop",["require","exports","module"],function(e,t,i){"use strict";t.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},t.mixin=function(e,t){for(var i in t)e[i]=t[i];return e},t.implement=function(e,i){t.mixin(e,i)}}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop"],function(e,t,i){"use strict";e("./fixoldbrowsers");var n=e("./oop"),r=function(){var e,t,i={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in i.FUNCTION_KEYS)e=i.FUNCTION_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);for(t in i.PRINTABLE_KEYS)e=i.PRINTABLE_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);return n.mixin(i,i.MODIFIER_KEYS),n.mixin(i,i.PRINTABLE_KEYS),n.mixin(i,i.FUNCTION_KEYS),i.enter=i.return,i.escape=i.esc,i.del=i.delete,i[173]="-",function(){for(var e=["cmd","ctrl","alt","shift"],t=Math.pow(2,e.length);t--;)i.KEY_MODS[t]=e.filter(function(e){return t&i.KEY_MODS[e]}).join("-")+"-"}(),i.KEY_MODS[0]="",i.KEY_MODS[-1]="input-",i}();n.mixin(t,r),t.keyCodeToString=function(e){var t=r[e];return"string"!=typeof t&&(t=String.fromCharCode(e)),t.toLowerCase()}}),ace.define("ace/lib/useragent",["require","exports","module"],function(e,t,i){"use strict";if(t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS},"object"==typeof navigator){var n=(navigator.platform.match(/mac|win|linux/i)||["other"])[0].toLowerCase(),r=navigator.userAgent;t.isWin="win"==n,t.isMac="mac"==n,t.isLinux="linux"==n,t.isIE="Microsoft Internet Explorer"==navigator.appName||navigator.appName.indexOf("MSAppHost")>=0?parseFloat((r.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((r.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=(window.Controllers||window.controllers)&&"Gecko"===window.navigator.product,t.isOldGecko=t.isGecko&&parseInt((r.match(/rv:(\d+)/)||[])[1],10)<4,t.isOpera=window.opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(r.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(r.split(" Chrome/")[1])||void 0,t.isAIR=r.indexOf("AdobeAIR")>=0,t.isIPad=r.indexOf("iPad")>=0,t.isChromeOS=r.indexOf(" CrOS ")>=0,t.isIOS=/iPad|iPhone|iPod/.test(r)&&!window.MSStream,t.isIOS&&(t.isMac=!0)}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t,i){"use strict";function n(e,t,i){var n=c(t);if(!s.isMac&&a){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(n|=8),a.altGr){if(3==(3&n))return;a.altGr=0}if(18===i||17===i){var r="location"in t?t.location:t.keyLocation;if(17===i&&1===r)1==a[i]&&(l=t.timeStamp);else if(18===i&&3===n&&2===r){var h=t.timeStamp-l;h<50&&(a.altGr=!0)}}}if(i in o.MODIFIER_KEYS&&(i=-1),8&n&&i>=91&&i<=93&&(i=-1),!n&&13===i){var r="location"in t?t.location:t.keyLocation;if(3===r&&(e(t,n,-i),t.defaultPrevented))return}if(s.isChromeOS&&8&n){if(e(t,n,i),t.defaultPrevented)return;n&=-9}return!!(n||i in o.FUNCTION_KEYS||i in o.PRINTABLE_KEYS)&&e(t,n,i)}function r(){a=Object.create(null)}var o=e("./keys"),s=e("./useragent"),a=null,l=0;t.addListener=function(e,t,i){if(e.addEventListener)return e.addEventListener(t,i,!1);if(e.attachEvent){var n=function(){i.call(e,window.event)};i._wrapper=n,e.attachEvent("on"+t,n)}},t.removeListener=function(e,t,i){if(e.removeEventListener)return e.removeEventListener(t,i,!1);e.detachEvent&&e.detachEvent("on"+t,i._wrapper||i)},t.stopEvent=function(e){return t.stopPropagation(e),t.preventDefault(e),!1},t.stopPropagation=function(e){e.stopPropagation?e.stopPropagation():e.cancelBubble=!0},t.preventDefault=function(e){e.preventDefault?e.preventDefault():e.returnValue=!1},t.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||s.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.preventDefault?e.button:{1:0,2:2,4:1}[e.button]},t.capture=function(e,i,n){function r(e){i&&i(e),n&&n(e),t.removeListener(document,"mousemove",i,!0),t.removeListener(document,"mouseup",r,!0),t.removeListener(document,"dragstart",r,!0)}return t.addListener(document,"mousemove",i,!0),t.addListener(document,"mouseup",r,!0),t.addListener(document,"dragstart",r,!0),r},t.addTouchMoveListener=function(e,i){var n,r;t.addListener(e,"touchstart",function(e){var t=e.touches,i=t[0];n=i.clientX,r=i.clientY}),t.addListener(e,"touchmove",function(e){var t=e.touches;if(!(t.length>1)){var o=t[0];e.wheelX=n-o.clientX,e.wheelY=r-o.clientY,n=o.clientX,r=o.clientY,i(e)}})},t.addMouseWheelListener=function(e,i){"onmousewheel"in e?t.addListener(e,"mousewheel",function(e){void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/8,e.wheelY=-e.wheelDeltaY/8):(e.wheelX=0,e.wheelY=-e.wheelDelta/8),i(e)}):"onwheel"in e?t.addListener(e,"wheel",function(e){switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.35*e.deltaX||0,e.wheelY=.35*e.deltaY||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0)}i(e)}):t.addListener(e,"DOMMouseScroll",function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),i(e)})},t.addMultiMouseDownListener=function(e,i,n,r){function o(e){if(0!==t.getButton(e)?d=0:e.detail>1?++d>4&&(d=1):d=1,s.isIE){var o=Math.abs(e.clientX-l)>5||Math.abs(e.clientY-c)>5;h&&!o||(d=1),h&&clearTimeout(h),h=setTimeout(function(){h=null},i[d-1]||600),1==d&&(l=e.clientX,c=e.clientY)}if(e._clicks=d,n[r]("mousedown",e),d>4)d=0;else if(d>1)return n[r](u[d],e)}function a(e){d=2,h&&clearTimeout(h),h=setTimeout(function(){h=null},i[d-1]||600),n[r]("mousedown",e),n[r](u[d],e)}var l,c,h,d=0,u={2:"dblclick",3:"tripleclick",4:"quadclick"};Array.isArray(e)||(e=[e]),e.forEach(function(e){t.addListener(e,"mousedown",o),s.isOldIE&&t.addListener(e,"dblclick",a)})};var c=!s.isMac||!s.isOpera||"KeyboardEvent"in window?function(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)}:function(e){return 0|(e.metaKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.ctrlKey?8:0)};if(t.getModifierString=function(e){return o.KEY_MODS[c(e)]},t.addCommandKeyListener=function(e,i){var o=t.addListener;if(s.isOldGecko||s.isOpera&&!("KeyboardEvent"in window)){var l=null;o(e,"keydown",function(e){l=e.keyCode}),o(e,"keypress",function(e){return n(i,e,l)})}else{var c=null;o(e,"keydown",function(e){a[e.keyCode]=(a[e.keyCode]||0)+1;var t=n(i,e,e.keyCode);return c=e.defaultPrevented,t}),o(e,"keypress",function(e){c&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(t.stopEvent(e),c=null)}),o(e,"keyup",function(e){a[e.keyCode]=null}),a||(r(),o(window,"focus",r))}},"object"==typeof window&&window.postMessage&&!s.isOldIE){t.nextTick=function(e,i){i=i||window;t.addListener(i,"message",function n(r){"zero-timeout-message-1"==r.data&&(t.stopPropagation(r),t.removeListener(i,"message",n),e())}),i.postMessage("zero-timeout-message-1","*")}}t.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),t.nextFrame?t.nextFrame=t.nextFrame.bind(window):t.nextFrame=function(e){setTimeout(e,17)}}),ace.define("ace/lib/lang",["require","exports","module"],function(e,t,i){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var i="";t>0;)1&t&&(i+=e),(t>>=1)&&(e+=e);return i};t.stringTrimLeft=function(e){return e.replace(/^\s\s*/,"")},t.stringTrimRight=function(e){return e.replace(/\s\s*$/,"")},t.copyObject=function(e){var t={};for(var i in e)t[i]=e[i];return t},t.copyArray=function(e){for(var t=[],i=0,n=e.length;i<n;i++)e[i]&&"object"==typeof e[i]?t[i]=this.copyObject(e[i]):t[i]=e[i];return t},t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;var i;if(Array.isArray(t)){i=[];for(var n=0;n<t.length;n++)i[n]=e(t[n]);return i}if("[object Object]"!==Object.prototype.toString.call(t))return t;i={};for(var n in t)i[n]=e(t[n]);return i},t.arrayToMap=function(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=1;return t},t.createMap=function(e){var t=Object.create(null);for(var i in e)t[i]=e[i];return t},t.arrayRemove=function(e,t){for(var i=0;i<=e.length;i++)t===e[i]&&e.splice(i,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return e.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var i=[];return e.replace(t,function(e){i.push({offset:arguments[arguments.length-2],length:e.length})}),i},t.deferredCall=function(e){var t=null,i=function(){t=null,e()},n=function(e){return n.cancel(),t=setTimeout(i,e||0),n};return n.schedule=n,n.call=function(){return this.cancel(),e(),n},n.cancel=function(){return clearTimeout(t),t=null,n},n.isPending=function(){return t},n},t.delayedCall=function(e,t){var i=null,n=function(){i=null,e()},r=function(e){null==i&&(i=setTimeout(n,e||t))};return r.delay=function(e){i&&clearTimeout(i),i=setTimeout(n,e||t)},r.schedule=r,r.call=function(){this.cancel(),e()},r.cancel=function(){i&&clearTimeout(i),i=null},r.isPending=function(){return i},r}}),ace.define("ace/keyboard/textinput_ios",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/lib/keys"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),o=e("../lib/dom"),s=e("../lib/lang"),a=e("../lib/keys"),l=a.KEY_MODS,c=r.isChrome<18,h=r.isIE,d=function(e,t){function i(e){if(!y){if(y=!0,S)t=0,i=e?0:f.value.length-1;else var t=4,i=5;try{f.setSelectionRange(t,i)}catch(e){}y=!1}}function d(){y||(f.value=p,r.isWebKit&&E.schedule())}function u(){clearTimeout(N),N=setTimeout(function(){w&&(f.style.cssText=w,w=""),null==t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=!0,t.renderer.$moveTextAreaToCursor())},0)}var f=o.createElement("textarea");f.className=r.isIOS?"ace_text-input ace_text-input-ios":"ace_text-input",r.isTouchPad&&f.setAttribute("x-palm-disable-auto-cap",!0),f.setAttribute("wrap","off"),f.setAttribute("autocorrect","off"),f.setAttribute("autocapitalize","off"),f.setAttribute("spellcheck",!1),f.style.opacity="0",e.insertBefore(f,e.firstChild);var p="\n aaaa a\n",m=!1,g=!1,v=!1,y=!1,w="",b=!0;try{var C=document.activeElement===f}catch(e){}n.addListener(f,"blur",function(e){t.onBlur(e),C=!1}),n.addListener(f,"focus",function(e){C=!0,t.onFocus(e),i()}),this.focus=function(){if(w)return f.focus();f.style.position="fixed",f.focus()},this.blur=function(){f.blur()},this.isFocused=function(){return C};var A=s.delayedCall(function(){C&&i(b)}),E=s.delayedCall(function(){y||(f.value=p,C&&i())});r.isWebKit||t.addEventListener("changeSelection",function(){t.selection.isEmpty()!=b&&(b=!b,A.schedule())}),d(),C&&t.onFocus();var F=function(e){return 0===e.selectionStart&&e.selectionEnd===e.value.length},x=function(e){F(f)?(t.selectAll(),i()):S&&i(t.selection.isEmpty())},S=null;this.setInputHandler=function(e){S=e},this.getInputHandler=function(){return S};var _=!1,k=function(e){4===f.selectionStart&&5===f.selectionEnd||(S&&(e=S(e),S=null),v?(i(),e&&t.onPaste(e),v=!1):e==p.substr(0)&&4===f.selectionStart?_?t.execCommand("del",{source:"ace"}):t.execCommand("backspace",{source:"ace"}):m||(e.substring(0,9)==p&&e.length>p.length?e=e.substr(9):e.substr(0,4)==p.substr(0,4)?e=e.substr(4,e.length-p.length+1):e.charAt(e.length-1)==p.charAt(0)&&(e=e.slice(0,-1)),e==p.charAt(0)||e.charAt(e.length-1)==p.charAt(0)&&(e=e.slice(0,-1)),e&&t.onTextInput(e)),m&&(m=!1),_&&(_=!1))},D=function(e){if(!y){var t=f.value;k(t),d()}},$=function(e,t,i){var n=e.clipboardData||window.clipboardData;if(n&&!c){var r=h||i?"Text":"text/plain";try{return t?!1!==n.setData(r,t):n.getData(r)}catch(e){if(!i)return $(e,t,!0)}}},B=function(e,o){var s=t.getCopyText();if(!s)return n.preventDefault(e);$(e,s)?(r.isIOS&&(g=o,f.value="\n aa"+s+"a a\n",f.setSelectionRange(4,4+s.length),m={value:s}),o?t.onCut():t.onCopy(),r.isIOS||n.preventDefault(e)):(m=!0,f.value=s,f.select(),setTimeout(function(){m=!1,d(),i(),o?t.onCut():t.onCopy()}))},L=function(e){B(e,!0)},R=function(e){B(e,!1)},T=function(e){var o=$(e);"string"==typeof o?(o&&t.onPaste(o,e),r.isIE&&setTimeout(i),n.preventDefault(e)):(f.value="",v=!0)};n.addCommandKeyListener(f,t.onCommandKey.bind(t)),n.addListener(f,"select",x),n.addListener(f,"input",D),n.addListener(f,"cut",L),n.addListener(f,"copy",R),n.addListener(f,"paste",T);var P=function(e){y||!t.onCompositionStart||t.$readOnly||(y={},y.canUndo=t.session.$undoManager,t.onCompositionStart(),setTimeout(M,0),t.on("mousedown",O),y.canUndo&&!t.selection.isEmpty()&&(t.insert(""),t.session.markUndoGroup(),t.selection.clearSelection()),t.session.markUndoGroup())},M=function(){if(y&&t.onCompositionUpdate&&!t.$readOnly){var e=f.value.replace(/\x01/g,"");if(y.lastValue!==e&&(t.onCompositionUpdate(e),y.lastValue&&t.undo(),y.canUndo&&(y.lastValue=e),y.lastValue)){var i=t.selection.getRange();t.insert(y.lastValue),t.session.markUndoGroup(),y.range=t.selection.getRange(),t.selection.setRange(i),t.selection.clearSelection()}}},O=function(e){if(t.onCompositionEnd&&!t.$readOnly){var i=y;y=!1;var n=setTimeout(function(){n=null;var e=f.value.replace(/\x01/g,"");y||(e==i.lastValue?d():!i.lastValue&&e&&(d(),k(e)))});S=function(e){return n&&clearTimeout(n),(e=e.replace(/\x01/g,""))==i.lastValue?"":(i.lastValue&&n&&t.undo(),e)},t.onCompositionEnd(),t.removeListener("mousedown",O),"compositionend"==e.type&&i.range&&t.selection.setRange(i.range);(!!r.isChrome&&r.isChrome>=53||!!r.isWebKit&&r.isWebKit>=603)&&D()}},I=s.delayedCall(M,50);n.addListener(f,"compositionstart",P),r.isGecko?n.addListener(f,"text",function(){I.schedule()}):(n.addListener(f,"keyup",function(){I.schedule()}),n.addListener(f,"keydown",function(){I.schedule()})),n.addListener(f,"compositionend",O),this.getElement=function(){return f},this.setReadOnly=function(e){f.readOnly=e},this.onContextMenu=function(e){_=!0,i(t.selection.isEmpty()),t._emit("nativecontextmenu",{target:t,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,i){w||(w=f.style.cssText),f.style.cssText=(i?"z-index:100000;":"")+"height:"+f.style.height+";"+(r.isIE?"opacity:0.1;":"");var s=t.container.getBoundingClientRect(),a=o.computedStyle(t.container),l=s.top+(parseInt(a.borderTopWidth)||0),c=s.left+(parseInt(s.borderLeftWidth)||0),h=s.bottom-l-f.clientHeight-2,d=function(e){f.style.left=e.clientX-c-2+"px",f.style.top=Math.min(e.clientY-l-2,h)+"px"};d(e),"mousedown"==e.type&&(t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=null),clearTimeout(N),r.isWin&&n.capture(t.container,d,u))},this.onContextMenuClose=u;var N,j=function(e){t.textInput.onContextMenu(e),u()};if(n.addListener(f,"mouseup",j),n.addListener(f,"mousedown",function(e){e.preventDefault(),u()}),n.addListener(t.renderer.scroller,"contextmenu",j),n.addListener(f,"contextmenu",j),r.isIOS){var H=null,V=!1;e.addEventListener("keydown",function(e){H&&clearTimeout(H),V=!0}),e.addEventListener("keyup",function(e){H=setTimeout(function(){V=!1},100)});var W=function(e){if(document.activeElement===f&&!V){if(g)return setTimeout(function(){g=!1},100);var i=f.selectionStart,n=f.selectionEnd;if(f.setSelectionRange(4,5),i==n)switch(i){case 0:t.onCommandKey(null,0,a.up);break;case 1:t.onCommandKey(null,0,a.home);break;case 2:t.onCommandKey(null,l.option,a.left);break;case 4:t.onCommandKey(null,0,a.left);break;case 5:t.onCommandKey(null,0,a.right);break;case 7:t.onCommandKey(null,l.option,a.right);break;case 8:t.onCommandKey(null,0,a.end);break;case 9:t.onCommandKey(null,0,a.down)}else{switch(n){case 6:t.onCommandKey(null,l.shift,a.right);break;case 7:t.onCommandKey(null,l.shift|l.option,a.right);break;case 8:t.onCommandKey(null,l.shift,a.end);break;case 9:t.onCommandKey(null,l.shift,a.down)}switch(i){case 0:t.onCommandKey(null,l.shift,a.up);break;case 1:t.onCommandKey(null,l.shift,a.home);break;case 2:t.onCommandKey(null,l.shift|l.option,a.left);break;case 3:t.onCommandKey(null,l.shift,a.left)}}}};document.addEventListener("selectionchange",W),t.on("destroy",function(){document.removeEventListener("selectionchange",W)})}};t.TextInput=d}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/keyboard/textinput_ios"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),o=e("../lib/dom"),s=e("../lib/lang"),a=r.isChrome<18,l=r.isIE,c=e("./textinput_ios").TextInput,h=function(e,t){function i(e){if(!g){if(g=!0,F)var t=0,i=e?0:u.value.length-1;else var t=e?2:1,i=2;try{u.setSelectionRange(t,i)}catch(e){}g=!1}}function h(){g||(u.value=f,r.isWebKit&&C.schedule())}function d(){clearTimeout(O),O=setTimeout(function(){v&&(u.style.cssText=v,v=""),null==t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=!0,t.renderer.$moveTextAreaToCursor())},0)}if(r.isIOS)return c.call(this,e,t);var u=o.createElement("textarea");u.className="ace_text-input",u.setAttribute("wrap","off"),u.setAttribute("autocorrect","off"),u.setAttribute("autocapitalize","off"),u.setAttribute("spellcheck",!1),u.style.opacity="0",e.insertBefore(u,e.firstChild);var f="\u2028\u2028",p=!1,m=!1,g=!1,v="",y=!0;try{var w=document.activeElement===u}catch(e){}n.addListener(u,"blur",function(e){t.onBlur(e),w=!1}),n.addListener(u,"focus",function(e){w=!0,t.onFocus(e),i()}),this.focus=function(){if(v)return u.focus();var e=u.style.top;u.style.position="fixed",u.style.top="0px",u.focus(),setTimeout(function(){u.style.position="","0px"==u.style.top&&(u.style.top=e)},0)},this.blur=function(){u.blur()},this.isFocused=function(){return w};var b=s.delayedCall(function(){w&&i(y)}),C=s.delayedCall(function(){g||(u.value=f,w&&i())});r.isWebKit||t.addEventListener("changeSelection",function(){t.selection.isEmpty()!=y&&(y=!y,b.schedule())}),h(),w&&t.onFocus();var A=function(e){return 0===e.selectionStart&&e.selectionEnd===e.value.length},E=function(e){p?p=!1:A(u)?(t.selectAll(),i()):F&&i(t.selection.isEmpty())},F=null;this.setInputHandler=function(e){F=e},this.getInputHandler=function(){return F};var x=!1,S=function(e){F&&(e=F(e),F=null),m?(i(),e&&t.onPaste(e),m=!1):e==f.charAt(0)?x?t.execCommand("del",{source:"ace"}):t.execCommand("backspace",{source:"ace"}):(e.substring(0,2)==f?e=e.substr(2):e.charAt(0)==f.charAt(0)?e=e.substr(1):e.charAt(e.length-1)==f.charAt(0)&&(e=e.slice(0,-1)),e.charAt(e.length-1)==f.charAt(0)&&(e=e.slice(0,-1)),e&&t.onTextInput(e)),x&&(x=!1)},_=function(e){if(!g){var t=u.value;S(t),h()}},k=function(e,t,i){var n=e.clipboardData||window.clipboardData;if(n&&!a){var r=l||i?"Text":"text/plain";try{return t?!1!==n.setData(r,t):n.getData(r)}catch(e){if(!i)return k(e,t,!0)}}},D=function(e,r){var o=t.getCopyText();if(!o)return n.preventDefault(e);k(e,o)?(r?t.onCut():t.onCopy(),n.preventDefault(e)):(p=!0,u.value=o,u.select(),setTimeout(function(){p=!1,h(),i(),r?t.onCut():t.onCopy()}))},$=function(e){D(e,!0)},B=function(e){D(e,!1)},L=function(e){var o=k(e);"string"==typeof o?(o&&t.onPaste(o,e),r.isIE&&setTimeout(i),n.preventDefault(e)):(u.value="",m=!0)};n.addCommandKeyListener(u,t.onCommandKey.bind(t)),n.addListener(u,"select",E),n.addListener(u,"input",_),n.addListener(u,"cut",$),n.addListener(u,"copy",B),n.addListener(u,"paste",L),"oncut"in u&&"oncopy"in u&&"onpaste"in u||n.addListener(e,"keydown",function(e){if((!r.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:B(e);break;case 86:L(e);break;case 88:$(e)}});var R=function(e){g||!t.onCompositionStart||t.$readOnly||(g={},g.canUndo=t.session.$undoManager,t.onCompositionStart(),setTimeout(T,0),t.on("mousedown",P),g.canUndo&&!t.selection.isEmpty()&&(t.insert(""),t.session.markUndoGroup(),t.selection.clearSelection()),t.session.markUndoGroup())},T=function(){if(g&&t.onCompositionUpdate&&!t.$readOnly){var e=u.value.replace(/\u2028/g,"");if(g.lastValue!==e&&(t.onCompositionUpdate(e),g.lastValue&&t.undo(),g.canUndo&&(g.lastValue=e),g.lastValue)){var i=t.selection.getRange();t.insert(g.lastValue),t.session.markUndoGroup(),g.range=t.selection.getRange(),t.selection.setRange(i),t.selection.clearSelection()}}},P=function(e){if(t.onCompositionEnd&&!t.$readOnly){var i=g;g=!1;var n=setTimeout(function(){n=null;var e=u.value.replace(/\u2028/g,"");g||(e==i.lastValue?h():!i.lastValue&&e&&(h(),S(e)))});F=function(e){return n&&clearTimeout(n),(e=e.replace(/\u2028/g,""))==i.lastValue?"":(i.lastValue&&n&&t.undo(),e)},t.onCompositionEnd(),t.removeListener("mousedown",P),"compositionend"==e.type&&i.range&&t.selection.setRange(i.range);(!!r.isChrome&&r.isChrome>=53||!!r.isWebKit&&r.isWebKit>=603)&&_()}},M=s.delayedCall(T,50);n.addListener(u,"compositionstart",R),r.isGecko?n.addListener(u,"text",function(){M.schedule()}):(n.addListener(u,"keyup",function(){M.schedule()}),n.addListener(u,"keydown",function(){M.schedule()})),n.addListener(u,"compositionend",P),this.getElement=function(){return u},this.setReadOnly=function(e){u.readOnly=e},this.onContextMenu=function(e){x=!0,i(t.selection.isEmpty()),t._emit("nativecontextmenu",{target:t,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,i){v||(v=u.style.cssText),u.style.cssText=(i?"z-index:100000;":"")+"height:"+u.style.height+";"+(r.isIE?"opacity:0.1;":"");var s=t.container.getBoundingClientRect(),a=o.computedStyle(t.container),l=s.top+(parseInt(a.borderTopWidth)||0),c=s.left+(parseInt(s.borderLeftWidth)||0),h=s.bottom-l-u.clientHeight-2,f=function(e){u.style.left=e.clientX-c-2+"px",u.style.top=Math.min(e.clientY-l-2,h)+"px"};f(e),"mousedown"==e.type&&(t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=null),clearTimeout(O),r.isWin&&n.capture(t.container,f,d))},this.onContextMenuClose=d;var O,I=function(e){t.textInput.onContextMenu(e),d()};n.addListener(u,"mouseup",I),n.addListener(u,"mousedown",function(e){e.preventDefault(),d()}),n.addListener(t.renderer.scroller,"contextmenu",I),n.addListener(u,"contextmenu",I)};t.TextInput=h}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";function n(e){e.$clickSelection=null;var t=e.editor;t.setDefaultHandler("mousedown",this.onMouseDown.bind(e)),t.setDefaultHandler("dblclick",this.onDoubleClick.bind(e)),t.setDefaultHandler("tripleclick",this.onTripleClick.bind(e)),t.setDefaultHandler("quadclick",this.onQuadClick.bind(e)),t.setDefaultHandler("mousewheel",this.onMouseWheel.bind(e)),t.setDefaultHandler("touchmove",this.onTouchMove.bind(e)),["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(t){e[t]=this[t]},this),e.selectByLines=this.extendSelectionBy.bind(e,"getLineRange"),e.selectByWords=this.extendSelectionBy.bind(e,"getWordRange")}function r(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}function o(e,t){if(e.start.row==e.end.row)var i=2*t.column-e.start.column-e.end.column;else if(e.start.row!=e.end.row-1||e.start.column||e.end.column)var i=2*t.row-e.start.row-e.end.row;else var i=t.column-4;return i<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}var s=(e("../lib/dom"),e("../lib/event"),e("../lib/useragent"));(function(){this.onMouseDown=function(e){var t=e.inSelection(),i=e.getDocumentPosition();this.mousedownEvent=e;var n=this.editor,r=e.getButton();if(0!==r){var o=n.getSelectionRange(),a=o.isEmpty();return n.$blockScrolling++,(a||1==r)&&n.selection.moveToPosition(i),n.$blockScrolling--,void(2==r&&(n.textInput.onContextMenu(e.domEvent),s.isMozilla||e.preventDefault()))}return this.mousedownEvent.time=Date.now(),!t||n.isFocused()||(n.focus(),!this.$focusTimout||this.$clickSelection||n.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(i,e.domEvent._clicks>1),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var i=this.editor;i.$blockScrolling++,this.mousedownEvent.getShiftKey()?i.selection.selectToPosition(e):t||i.selection.moveToPosition(e),t||this.select(),i.renderer.scroller.setCapture&&i.renderer.scroller.setCapture(),i.setStyle("ace_selecting"),this.setState("select"),i.$blockScrolling--},this.select=function(){var e,t=this.editor,i=t.renderer.screenToTextCoordinates(this.x,this.y);if(t.$blockScrolling++,this.$clickSelection){var n=this.$clickSelection.comparePoint(i);if(-1==n)e=this.$clickSelection.end;else if(1==n)e=this.$clickSelection.start;else{var r=o(this.$clickSelection,i);i=r.cursor,e=r.anchor}t.selection.setSelectionAnchor(e.row,e.column)}t.selection.selectToPosition(i),t.$blockScrolling--,t.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,i=this.editor,n=i.renderer.screenToTextCoordinates(this.x,this.y),r=i.selection[e](n.row,n.column);if(i.$blockScrolling++,this.$clickSelection){var s=this.$clickSelection.comparePoint(r.start),a=this.$clickSelection.comparePoint(r.end);if(-1==s&&a<=0)t=this.$clickSelection.end,r.end.row==n.row&&r.end.column==n.column||(n=r.start);else if(1==a&&s>=0)t=this.$clickSelection.start,r.start.row==n.row&&r.start.column==n.column||(n=r.end);else if(-1==s&&1==a)n=r.end,t=r.start;else{var l=o(this.$clickSelection,n);n=l.cursor,t=l.anchor}i.selection.setSelectionAnchor(t.row,t.column)}i.selection.selectToPosition(n),i.$blockScrolling--,i.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){var e=r(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y),t=Date.now();(e>0||t-this.mousedownEvent.time>this.$focusTimout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var t=e.getDocumentPosition(),i=this.editor,n=i.session,r=n.getBracketRange(t);r?(r.isEmpty()&&(r.start.column--,r.end.column++),this.setState("select")):(r=i.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=r,this.select()},this.onTripleClick=function(e){var t=e.getDocumentPosition(),i=this.editor;this.setState("selectByLines");var n=i.getSelectionRange();n.isMultiLine()&&n.contains(t.row,t.column)?(this.$clickSelection=i.selection.getLineRange(n.start.row),this.$clickSelection.end=i.selection.getLineRange(n.end.row).end):this.$clickSelection=i.selection.getLineRange(t.row),this.select()},this.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){if(!e.getAccelKey()){e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0);var t=this.editor;this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0});var i=this.$lastScroll,n=e.domEvent.timeStamp,r=n-i.t,o=e.wheelX/r,s=e.wheelY/r;r<250&&(o=(o+i.vx)/2,s=(s+i.vy)/2);var a=Math.abs(o/s),l=!1;if(a>=1&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(l=!0),a<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)&&(l=!0),l)i.allowed=n;else if(n-i.allowed<250){var c=Math.abs(o)<=1.1*Math.abs(i.vx)&&Math.abs(s)<=1.1*Math.abs(i.vy);c?(l=!0,i.allowed=n):i.allowed=0}return i.t=n,i.vx=o,i.vy=s,l?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}},this.onTouchMove=function(e){this.editor._emit("mousewheel",e)}}).call(n.prototype),t.DefaultHandlers=n}),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}var r=(e("./lib/oop"),e("./lib/dom"));(function(){this.$init=function(){return this.$element=r.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){r.setInnerText(this.getElement(),e)},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){r.addCssClass(this.getElement(),e)},this.show=function(e,t,i){null!=e&&this.setText(e),null!=t&&null!=i&&this.setPosition(t,i),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(n.prototype),t.Tooltip=n}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],function(e,t,i){"use strict";function n(e){function t(){var t=d.getDocumentPosition().row,r=l.$annotations[t];if(!r)return i();if(t==s.session.getLength()){var o=s.renderer.pixelToScreenCoordinates(0,d.y).row,a=d.$pos;if(o>s.session.documentToScreenRow(a.row,a.column))return i()}if(u!=r)if(u=r.text.join("<br/>"),c.setHtml(u),c.show(),s._signal("showGutterTooltip",c),s.on("mousewheel",i),e.$tooltipFollowsMouse)n(d);else{var h=d.domEvent.target,f=h.getBoundingClientRect(),p=c.getElement().style;p.left=f.right+"px",p.top=f.bottom+"px"}}function i(){h&&(h=clearTimeout(h)),u&&(c.hide(),u=null,s._signal("hideGutterTooltip",c),s.removeEventListener("mousewheel",i))}function n(e){c.setPosition(e.x,e.y)}var s=e.editor,l=s.renderer.$gutterLayer,c=new r(s.container);e.editor.setDefaultHandler("guttermousedown",function(t){if(s.isFocused()&&0==t.getButton()){if("foldWidgets"!=l.getRegion(t)){var i=t.getDocumentPosition().row,n=s.session.selection;if(t.getShiftKey())n.selectTo(i,0);else{if(2==t.domEvent.detail)return s.selectAll(),t.preventDefault();e.$clickSelection=s.selection.getLineRange(i)}return e.setState("selectByLines"),e.captureMouse(t),t.preventDefault()}}});var h,d,u;e.editor.setDefaultHandler("guttermousemove",function(r){var s=r.domEvent.target||r.domEvent.srcElement;if(o.hasCssClass(s,"ace_fold-widget"))return i();u&&e.$tooltipFollowsMouse&&n(r),d=r,h||(h=setTimeout(function(){h=null,d&&!e.isMousePressed?t():i()},50))}),a.addListener(s.renderer.$gutter,"mouseout",function(e){d=null,u&&!h&&(h=setTimeout(function(){h=null,i()},50))}),s.on("changeSession",i)}function r(e){l.call(this,e)}var o=e("../lib/dom"),s=e("../lib/oop"),a=e("../lib/event"),l=e("../tooltip").Tooltip;s.inherits(r,l),function(){this.setPosition=function(e,t){var i=window.innerWidth||document.documentElement.clientWidth,n=window.innerHeight||document.documentElement.clientHeight,r=this.getWidth(),o=this.getHeight();e+=15,t+=15,e+r>i&&(e-=e+r-i),t+o>n&&(t-=20+o),l.prototype.setPosition.call(this,e,t)}}.call(r.prototype),t.GutterHandler=n}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),o=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){n.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){n.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos?this.$pos:(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY),this.$pos)},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e=this.editor,t=e.getSelectionRange();if(t.isEmpty())this.$inSelection=!1;else{var i=this.getDocumentPosition();this.$inSelection=t.contains(i.row,i.column)}return this.$inSelection},this.getButton=function(){return n.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=r.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(o.prototype)}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";function n(e){function t(e,t){var i=Date.now(),n=!t||e.row!=t.row,o=!t||e.column!=t.column;if(!_||n||o)g.$blockScrolling+=1,g.moveCursorToPosition(e),g.$blockScrolling-=1,_=i,k={x:w,y:b};else{r(k.x,k.y,w,b)>h?_=null:i-_>=c&&(g.renderer.scrollCursorIntoView(),_=null)}}function i(e,t){var i=Date.now(),n=g.renderer.layerConfig.lineHeight,r=g.renderer.layerConfig.characterWidth,o=g.renderer.scroller.getBoundingClientRect(),s={x:{left:w-o.left,right:o.right-w},y:{top:b-o.top,bottom:o.bottom-b}},a=Math.min(s.x.left,s.x.right),c=Math.min(s.y.top,s.y.bottom),h={row:e.row,column:e.column};a/r<=2&&(h.column+=s.x.left<s.x.right?-3:2),c/n<=1&&(h.row+=s.y.top<s.y.bottom?-1:1);var d=e.row!=h.row,u=e.column!=h.column,f=!t||e.row!=t.row;d||u&&!f?S?i-S>=l&&g.renderer.scrollCursorIntoView(h):S=i:S=null}function n(){var e=E;E=g.renderer.screenToTextCoordinates(w,b),t(E,e),i(E,e)}function d(){A=g.selection.toOrientedRange(),y=g.session.addMarker(A,"ace_selection",g.getSelectionStyle()),g.clearSelection(),g.isFocused()&&g.renderer.$cursorLayer.setBlinking(!1),clearInterval(C),n(),C=setInterval(n,20),$=0,s.addListener(document,"mousemove",f)}function u(){clearInterval(C),g.session.removeMarker(y),y=null,g.$blockScrolling+=1,g.selection.fromOrientedRange(A),g.$blockScrolling-=1,g.isFocused()&&!x&&g.renderer.$cursorLayer.setBlinking(!g.getReadOnly()),A=null,E=null,$=0,S=null,_=null,s.removeListener(document,"mousemove",f)}function f(){null==B&&(B=setTimeout(function(){null!=B&&y&&u()},20))}function p(e){var t=e.types;return!t||Array.prototype.some.call(t,function(e){return"text/plain"==e||"Text"==e})}function m(e){var t=["copy","copymove","all","uninitialized"],i=["move","copymove","linkmove","all","uninitialized"],n=a.isMac?e.altKey:e.ctrlKey,r="uninitialized";try{r=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var o="none";return n&&t.indexOf(r)>=0?o="copy":i.indexOf(r)>=0?o="move":t.indexOf(r)>=0&&(o="copy"),o}var g=e.editor,v=o.createElement("img");v.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",a.isOpera&&(v.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;"),["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(t){e[t]=this[t]},this),g.addEventListener("mousedown",this.onMouseDown.bind(e));var y,w,b,C,A,E,F,x,S,_,k,D=g.container,$=0;this.onDragStart=function(e){if(this.cancelDrag||!D.draggable){var t=this;return setTimeout(function(){t.startSelect(),t.captureMouse(e)},0),e.preventDefault()}A=g.getSelectionRange();var i=e.dataTransfer;i.effectAllowed=g.getReadOnly()?"copy":"copyMove",a.isOpera&&(g.container.appendChild(v),v.scrollTop=0),i.setDragImage&&i.setDragImage(v,0,0),a.isOpera&&g.container.removeChild(v),i.clearData(),i.setData("Text",g.session.getTextRange()),x=!0,this.setState("drag")},this.onDragEnd=function(e){if(D.draggable=!1,x=!1,this.setState(null),!g.getReadOnly()){var t=e.dataTransfer.dropEffect;F||"move"!=t||g.session.remove(g.getSelectionRange()),g.renderer.$cursorLayer.setBlinking(!0)}this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!g.getReadOnly()&&p(e.dataTransfer))return w=e.clientX,b=e.clientY,y||d(),$++,e.dataTransfer.dropEffect=F=m(e),s.preventDefault(e)},this.onDragOver=function(e){if(!g.getReadOnly()&&p(e.dataTransfer))return w=e.clientX,b=e.clientY,y||(d(),$++),null!==B&&(B=null),e.dataTransfer.dropEffect=F=m(e),s.preventDefault(e)},this.onDragLeave=function(e){if(--$<=0&&y)return u(),F=null,s.preventDefault(e)},this.onDrop=function(e){if(E){var t=e.dataTransfer;if(x)switch(F){case"move":A=A.contains(E.row,E.column)?{start:E,end:E}:g.moveText(A,E);break;case"copy":A=g.moveText(A,E,!0)}else{var i=t.getData("Text");A={start:E,end:g.session.insert(E,i)},g.focus(),F=null}return u(),s.preventDefault(e)}},s.addListener(D,"dragstart",this.onDragStart.bind(e)),s.addListener(D,"dragend",this.onDragEnd.bind(e)),s.addListener(D,"dragenter",this.onDragEnter.bind(e)),s.addListener(D,"dragover",this.onDragOver.bind(e)),s.addListener(D,"dragleave",this.onDragLeave.bind(e)),s.addListener(D,"drop",this.onDrop.bind(e));var B=null}function r(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}var o=e("../lib/dom"),s=e("../lib/event"),a=e("../lib/useragent"),l=200,c=200,h=5;(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.renderer.$cursorLayer.setBlinking(!this.editor.getReadOnly()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor;e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging");var t=a.isWin?"default":"move";e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;if(a.isIE&&"dragReady"==this.state){var i=r(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y);i>3&&t.dragDrop()}if("dragWait"===this.state){var i=r(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y);i>0&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))}},this.onMouseDown=function(e){if(this.$dragEnabled){this.mousedownEvent=e;var t=this.editor,i=e.inSelection(),n=e.getButton();if(1===(e.domEvent.detail||1)&&0===n&&i){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var r=e.domEvent.target||e.domEvent.srcElement;if("unselectable"in r&&(r.unselectable="on"),t.getDragDelay()){if(a.isWebKit){this.cancelDrag=!0;t.container.draggable=!0}this.setState("dragWait")}else this.startDrag();this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0}}}}).call(n.prototype),t.DragdropHandler=n}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var n=e("./dom");t.get=function(e,t){var i=new XMLHttpRequest;i.open("GET",e,!0),i.onreadystatechange=function(){4===i.readyState&&t(i.responseText)},i.send(null)},t.loadScript=function(e,t){var i=n.getDocumentHead(),r=document.createElement("script");r.src=e,i.appendChild(r),r.onload=r.onreadystatechange=function(e,i){!i&&r.readyState&&"loaded"!=r.readyState&&"complete"!=r.readyState||(r=r.onload=r.onreadystatechange=null,i||t())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(e,t,i){"use strict";var n={},r=function(){this.propagationStopped=!0},o=function(){this.defaultPrevented=!0};n._emit=n._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var i=this._eventRegistry[e]||[],n=this._defaultHandlers[e];if(i.length||n){"object"==typeof t&&t||(t={}),t.type||(t.type=e),t.stopPropagation||(t.stopPropagation=r),t.preventDefault||(t.preventDefault=o),i=i.slice();for(var s=0;s<i.length&&(i[s](t,this),!t.propagationStopped);s++);return n&&!t.defaultPrevented?n(t,this):void 0}},n._signal=function(e,t){var i=(this._eventRegistry||{})[e];if(i){i=i.slice();for(var n=0;n<i.length;n++)i[n](t,this)}},n.once=function(e,t){var i=this;t&&this.addEventListener(e,function n(){i.removeEventListener(e,n),t.apply(null,arguments)})},n.setDefaultHandler=function(e,t){var i=this._defaultHandlers;if(i||(i=this._defaultHandlers={_disabled_:{}}),i[e]){var n=i[e],r=i._disabled_[e];r||(i._disabled_[e]=r=[]),r.push(n);var o=r.indexOf(t);-1!=o&&r.splice(o,1)}i[e]=t},n.removeDefaultHandler=function(e,t){var i=this._defaultHandlers;if(i){var n=i._disabled_[e];if(i[e]==t){i[e];n&&this.setDefaultHandler(e,n.pop())}else if(n){var r=n.indexOf(t);-1!=r&&n.splice(r,1)}}},n.on=n.addEventListener=function(e,t,i){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];return n||(n=this._eventRegistry[e]=[]),-1==n.indexOf(t)&&n[i?"unshift":"push"](t),t},n.off=n.removeListener=n.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};var i=this._eventRegistry[e];if(i){var n=i.indexOf(t);-1!==n&&i.splice(n,1)}},n.removeAllListeners=function(e){this._eventRegistry&&(this._eventRegistry[e]=[])},t.EventEmitter=n}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"no use strict";function n(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function r(e,t){var i=new Error(e);i.data=t,"object"==typeof console&&console.error&&console.error(i),setTimeout(function(){throw i})}var o=e("./oop"),s=e("./event_emitter").EventEmitter,a={setOptions:function(e){Object.keys(e).forEach(function(t){this.setOption(t,e[t])},this)},getOptions:function(e){var t={};return e?Array.isArray(e)||(t=e,e=Object.keys(t)):e=Object.keys(this.$options),e.forEach(function(e){t[e]=this.getOption(e)},this),t},setOption:function(e,t){if(this["$"+e]!==t){var i=this.$options[e];if(!i)return n('misspelled option "'+e+'"');if(i.forwardTo)return this[i.forwardTo]&&this[i.forwardTo].setOption(e,t);i.handlesSet||(this["$"+e]=t),i&&i.set&&i.set.call(this,t)}},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:n('misspelled option "'+e+'"')}},l=function(){this.$defaultOptions={}};(function(){o.implement(this,s),this.defineOptions=function(e,t,i){return e.$options||(this.$defaultOptions[t]=e.$options={}),Object.keys(i).forEach(function(t){var n=i[t];"string"==typeof n&&(n={forwardTo:n}),n.name||(n.name=t),e.$options[n.name]=n,"initialValue"in n&&(e["$"+n.name]=n.initialValue)}),o.implement(e,a),this},this.resetOptions=function(e){Object.keys(e.$options).forEach(function(t){var i=e.$options[t];"value"in i&&e.setOption(t,i.value)})},this.setDefaultValue=function(e,t,i){var n=this.$defaultOptions[e]||(this.$defaultOptions[e]={});n[t]&&(n.forwardTo?this.setDefaultValue(n.forwardTo,t,i):n[t].value=i)},this.setDefaultValues=function(e,t){Object.keys(t).forEach(function(i){this.setDefaultValue(e,i,t[i])},this)},this.warn=n,this.reportError=r}).call(l.prototype),t.AppConfig=l}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/app_config"],function(e,t,n){"no use strict";function r(r){if(c&&c.document){h.packaged=r||e.packaged||n.packaged||c.define&&i(53).packaged;for(var s={},a="",l=document.currentScript||document._currentScript,d=l&&l.ownerDocument||document,u=d.getElementsByTagName("script"),f=0;f<u.length;f++){var p=u[f],m=p.src||p.getAttribute("src");if(m){for(var g=p.attributes,v=0,y=g.length;v<y;v++){var w=g[v];0===w.name.indexOf("data-ace-")&&(s[o(w.name.replace(/^data-ace-/,""))]=w.value)}var b=m.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);b&&(a=b[1])}}a&&(s.base=s.base||a,s.packaged=!0),s.basePath=s.base,s.workerPath=s.workerPath||s.base,s.modePath=s.modePath||s.base,s.themePath=s.themePath||s.base,delete s.base;for(var C in s)void 0!==s[C]&&t.set(C,s[C])}}function o(e){return e.replace(/-(.)/g,function(e,t){return t.toUpperCase()})}var s=e("./lib/lang"),a=(e("./lib/oop"),e("./lib/net")),l=e("./lib/app_config").AppConfig;n.exports=t=new l;var c=function(){return this||"undefined"!=typeof window&&window}(),h={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{}};t.get=function(e){if(!h.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return h[e]},t.set=function(e,t){if(!h.hasOwnProperty(e))throw new Error("Unknown config key: "+e);h[e]=t},t.all=function(){return s.copyObject(h)},t.moduleUrl=function(e,t){if(h.$moduleUrls[e])return h.$moduleUrls[e];var i=e.split("/");t=t||i[i.length-2]||"";var n="snippets"==t?"/":"-",r=i[i.length-1];if("worker"==t&&"-"==n){var o=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g");r=r.replace(o,"")}(!r||r==t)&&i.length>1&&(r=i[i.length-2]);var s=h[t+"Path"];return null==s?s=h.basePath:"/"==n&&(t=n=""),s&&"/"!=s.slice(-1)&&(s+="/"),s+t+n+r+this.get("suffix")},t.setModuleUrl=function(e,t){return h.$moduleUrls[e]=t},t.$loading={},t.loadModule=function(i,n){var r,o;Array.isArray(i)&&(o=i[0],i=i[1]);try{r=e(i)}catch(e){}if(r&&!t.$loading[i])return n&&n(r);if(t.$loading[i]||(t.$loading[i]=[]),t.$loading[i].push(n),!(t.$loading[i].length>1)){var s=function(){e([i],function(e){t._emit("load.module",{name:i,module:e});var n=t.$loading[i];t.$loading[i]=null,n.forEach(function(t){t&&t(e)})})};if(!t.get("packaged"))return s();a.loadScript(t.moduleUrl(i,o),s)}},r(!0),t.init=r}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/config"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),o=e("./default_handlers").DefaultHandlers,s=e("./default_gutter_handler").GutterHandler,a=e("./mouse_event").MouseEvent,l=e("./dragdrop_handler").DragdropHandler,c=e("../config"),h=function(e){var t=this;this.editor=e,new o(this),new s(this),new l(this);var i=function(t){(!document.hasFocus||!document.hasFocus()||!e.isFocused()&&document.activeElement==(e.textInput&&e.textInput.getElement()))&&window.focus(),e.focus()},a=e.renderer.getMouseEventTarget();n.addListener(a,"click",this.onMouseEvent.bind(this,"click")),n.addListener(a,"mousemove",this.onMouseMove.bind(this,"mousemove")),n.addMultiMouseDownListener([a,e.renderer.scrollBarV&&e.renderer.scrollBarV.inner,e.renderer.scrollBarH&&e.renderer.scrollBarH.inner,e.textInput&&e.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent"),n.addMouseWheelListener(e.container,this.onMouseWheel.bind(this,"mousewheel")),n.addTouchMoveListener(e.container,this.onTouchMove.bind(this,"touchmove"));var c=e.renderer.$gutter;n.addListener(c,"mousedown",this.onMouseEvent.bind(this,"guttermousedown")),n.addListener(c,"click",this.onMouseEvent.bind(this,"gutterclick")),n.addListener(c,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick")),n.addListener(c,"mousemove",this.onMouseEvent.bind(this,"guttermousemove")),n.addListener(a,"mousedown",i),n.addListener(c,"mousedown",i),r.isIE&&e.renderer.scrollBarV&&(n.addListener(e.renderer.scrollBarV.element,"mousedown",i),n.addListener(e.renderer.scrollBarH.element,"mousedown",i)),e.on("mousemove",function(i){if(!t.state&&!t.$dragDelay&&t.$dragEnabled){var n=e.renderer.screenToTextCoordinates(i.x,i.y),r=e.session.selection.getRange(),o=e.renderer;!r.isEmpty()&&r.insideStart(n.row,n.column)?o.setCursorStyle("default"):o.setCursorStyle("")}})};(function(){this.onMouseEvent=function(e,t){this.editor._emit(e,new a(t,this.editor))},this.onMouseMove=function(e,t){var i=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;i&&i.length&&this.editor._emit(e,new a(t,this.editor))},this.onMouseWheel=function(e,t){var i=new a(t,this.editor);i.speed=2*this.$scrollSpeed,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.onTouchMove=function(e,t){var i=new a(t,this.editor);i.speed=1,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;var i=this.editor.renderer;i.$keepTextAreaAtCursor&&(i.$keepTextAreaAtCursor=null);var o=this,s=function(e){if(e){if(r.isWebKit&&!e.which&&o.releaseMouse)return o.releaseMouse();o.x=e.clientX,o.y=e.clientY,t&&t(e),o.mouseEvent=new a(e,o.editor),o.$mouseMoved=!0}},l=function(e){clearInterval(h),c(),o[o.state+"End"]&&o[o.state+"End"](e),o.state="",null==i.$keepTextAreaAtCursor&&(i.$keepTextAreaAtCursor=!0,i.$moveTextAreaToCursor()),o.isMousePressed=!1,o.$onCaptureMouseMove=o.releaseMouse=null,e&&o.onMouseEvent("mouseup",e)},c=function(){o[o.state]&&o[o.state](),o.$mouseMoved=!1};if(r.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout(function(){l(e)});o.$onCaptureMouseMove=s,o.releaseMouse=n.capture(this.editor.container,s,l);var h=setInterval(c,20)},this.releaseMouse=null,this.cancelContextMenu=function(){var e=function(t){t&&t.domEvent&&"contextmenu"!=t.domEvent.type||(this.editor.off("nativecontextmenu",e),t&&t.domEvent&&n.stopEvent(t.domEvent))}.bind(this);setTimeout(e,10),this.editor.on("nativecontextmenu",e)}}).call(h.prototype),c.defineOptions(h.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:r.isMac?150:0},dragEnabled:{initialValue:!0},focusTimout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=h}),ace.define("ace/mouse/fold_handler",["require","exports","module"],function(e,t,i){"use strict";function n(e){e.on("click",function(t){var i=t.getDocumentPosition(),n=e.session,r=n.getFoldAt(i.row,i.column,1);r&&(t.getAccelKey()?n.removeFold(r):n.expandFold(r),t.stop())}),e.on("gutterclick",function(t){if("foldWidgets"==e.renderer.$gutterLayer.getRegion(t)){var i=t.getDocumentPosition().row,n=e.session;n.foldWidgets&&n.foldWidgets[i]&&e.session.onFoldWidgetClick(i,t),e.isFocused()||e.focus(),t.stop()}}),e.on("gutterdblclick",function(t){if("foldWidgets"==e.renderer.$gutterLayer.getRegion(t)){var i=t.getDocumentPosition().row,n=e.session,r=n.getParentFoldRangeData(i,!0),o=r.range||r.firstRange;if(o){i=o.start.row;var s=n.getFoldAt(i,n.getLine(i).length,1);s?n.removeFold(s):(n.addFold("...",o),e.renderer.scrollCursorIntoView({row:o.start.row,column:0}))}t.stop()}})}t.FoldHandler=n}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(e,t,i){"use strict";var n=e("../lib/keys"),r=e("../lib/event"),o=function(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)};(function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){if(e){"function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e);var i=this.$handlers.indexOf(e);-1!=i&&this.$handlers.splice(i,1),void 0==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==i&&e.attach&&e.attach(this.$editor)}},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var e=this.$data,t=e.editor;return this.$handlers.map(function(i){return i.getStatusText&&i.getStatusText(t,e)||""}).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,i,n){for(var o,s=!1,a=this.$editor.commands,l=this.$handlers.length;l--&&!((o=this.$handlers[l].handleKeyboard(this.$data,e,t,i,n))&&o.command&&(s="null"==o.command||a.exec(o.command,this.$editor,o.args,n),s&&n&&-1!=e&&1!=o.passEvent&&1!=o.command.passEvent&&r.stopEvent(n),s)););return s||-1!=e||(o={command:"insertstring"},s=a.exec("insertstring",this.$editor,t)),s&&this.$editor._signal&&this.$editor._signal("keyboardActivity",o),s},this.onCommandKey=function(e,t,i){var r=n.keyCodeToString(i);this.$callKeyboardHandlers(t,r,i,e)},this.onTextInput=function(e){this.$callKeyboardHandlers(-1,e)}}).call(o.prototype),t.KeyBinding=o}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(e,t,i){"use strict";function n(e,t,i,n){var r=a?p:f,m=null,g=null,v=null,y=0,w=null,b=-1,E=null,x=null,S=[];if(!n)for(E=0,n=[];E<i;E++)n[E]=s(e[E]);for(l=a,c=!1,h=!1,d=!1,u=!1,x=0;x<i;x++){if(m=y,S[x]=g=o(e,n,S,x),y=r[m][g],w=240&y,y&=15,t[x]=v=r[y][5],w>0)if(16==w){for(E=b;E<x;E++)t[E]=1;b=-1}else b=-1;if(r[y][6])-1==b&&(b=x);else if(b>-1){for(E=b;E<x;E++)t[E]=v;b=-1}n[x]==C&&(t[x]=0),l|=v}if(u)for(E=0;E<i;E++)if(n[E]==A){t[E]=a;for(var _=E-1;_>=0&&n[_]==F;_--)t[_]=a}}function r(e,t,i){if(!(l<e)){if(1==e&&a==m&&!d)return void i.reverse();for(var n,r,o,s,c=i.length,h=0;h<c;){if(t[h]>=e){for(n=h+1;n<c&&t[n]>=e;)n++;for(r=h,o=n-1;r<o;r++,o--)s=i[r],i[r]=i[o],i[o]=s;h=n}h++}}}function o(e,t,i,n){var r,o,s,l,f=t[n];switch(f){case g:case v:c=!1;case b:case w:return f;case y:return c?w:y;case E:return c=!0,h=!0,v;case F:return b;case x:return n<1||n+1>=t.length||(r=i[n-1])!=y&&r!=w||(o=t[n+1])!=y&&o!=w?b:(c&&(o=w),o==r?o:b);case S:return r=n>0?i[n-1]:C,r==y&&n+1<t.length&&t[n+1]==y?y:b;case _:if(n>0&&i[n-1]==y)return y;if(c)return b;for(l=n+1,s=t.length;l<s&&t[l]==_;)l++;return l<s&&t[l]==y?y:b;case k:for(s=t.length,l=n+1;l<s&&t[l]==k;)l++;if(l<s){var p=e[n],m=p>=1425&&p<=2303||64286==p;if(r=t[l],m&&(r==v||r==E))return v}return n<1||(r=t[n-1])==C?b:i[n-1];case C:return c=!1,d=!0,a;case A:return u=!0,b;case D:case $:case L:case R:case B:c=!1;case T:return b}}function s(e){var t=e.charCodeAt(0),i=t>>8;return 0==i?t>191?g:P[t]:5==i?/[\u0591-\u05f4]/.test(e)?v:g:6==i?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?k:/[\u0660-\u0669\u066b-\u066c]/.test(e)?w:1642==t?_:/[\u06f0-\u06f9]/.test(e)?y:E:32==i&&t<=8287?M[255&t]:254==i&&t>=65136?E:b}var a=0,l=0,c=!1,h=!1,d=!1,u=!1,f=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],p=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],m=1,g=0,v=1,y=2,w=3,b=4,C=5,A=6,E=7,F=8,x=9,S=10,_=11,k=12,D=13,$=14,B=15,L=16,R=17,T=18,P=[T,T,T,T,T,T,T,T,T,A,C,A,F,C,T,T,T,T,T,T,T,T,T,T,T,T,T,T,C,C,C,A,F,b,b,_,_,_,b,b,b,b,b,S,x,S,x,x,y,y,y,y,y,y,y,y,y,y,x,b,b,b,b,b,b,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,b,b,b,b,b,b,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,g,b,b,b,b,T,T,T,T,T,T,C,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,T,x,b,_,_,_,_,b,b,b,b,g,b,b,T,b,b,_,_,y,y,b,g,b,b,b,y,g,b,b,b,b,b],M=[F,F,F,F,F,F,F,F,F,F,F,T,T,T,g,v,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,F,C,D,$,B,L,R,x,_,_,_,_,_,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,F];t.L=g,t.R=v,t.EN=y,t.ON_R=3,t.AN=4,t.R_H=5,t.B=6,t.DOT="·",t.doBidiReorder=function(e,i,o){if(e.length<2)return{};var s=e.split(""),l=new Array(s.length),c=new Array(s.length),h=[];a=o?m:0,n(s,h,s.length,i);for(var d=0;d<l.length;l[d]=d,d++);r(2,h,l),r(1,h,l);for(var d=0;d<l.length-1;d++)i[d]===w?h[d]=t.AN:h[d]===v&&(i[d]>E&&i[d]<D||i[d]===b||i[d]===T)?h[d]=t.ON_R:d>0&&"ل"===s[d-1]&&/\u0622|\u0623|\u0625|\u0627/.test(s[d])&&(h[d-1]=h[d]=t.R_H,d++);s[s.length-1]===t.DOT&&(h[s.length-1]=t.B);for(var d=0;d<l.length;d++)c[d]=h[l[d]];return{logicalFromVisual:l,bidiLevels:c}},t.hasBidiCharacters=function(e,t){for(var i=!1,n=0;n<e.length;n++)t[n]=s(e.charAt(n)),i||t[n]!=v&&t[n]!=E||(i=!0);return i},t.getVisualFromLogicalIdx=function(e,t){for(var i=0;i<t.logicalFromVisual.length;i++)if(t.logicalFromVisual[i]==e)return i;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("./lib/bidiutil"),r=e("./lib/lang"),o=e("./lib/useragent"),s=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/,a=function(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=n,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.line="",this.wrapIndent=0,this.isLastRow=!1,this.EOF="¶",this.seenBidi=!1};(function(){this.isBidiRow=function(e,t,i){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,i),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&s.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var e=0,t=this.session.$screenRowCache;if(t.length){var i=this.session.$getRowCacheIndex(t,this.currentRow);i>=0&&(e=this.session.$docRowCache[i])}return e},this.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var i,n=this.session.$getRowCacheIndex(t,this.currentRow);this.currentRow-e>0&&(i=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===n;)n=i,e++;return e},this.updateRowLine=function(e,t){if(void 0===e&&(e=this.getDocumentRow()),this.wrapIndent=0,this.isLastRow=e===this.session.getLength()-1,this.line=this.session.getLine(e),this.session.$useWrapMode){var i=this.session.$wrapData[e];i&&(void 0===t&&(t=this.getSplitIndex()),t>0&&i.length?(this.wrapIndent=i.indent,this.line=t<i.length?this.line.substring(i[t-1],i[i.length-1]):this.line.substring(i[i.length-1])):this.line=this.line.substring(0,i[t]))}var o,s=this.session,a=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(e,t){return"\t"===e||s.isFullWidth(e.charCodeAt(0))?(o="\t"===e?s.getScreenTabSize(t+a):2,a+=o-1,r.stringRepeat(n.DOT,o)):e})},this.updateBidiMap=function(){var e=[],t=this.isLastRow?this.EOF:this.EOL,i=this.line+(this.showInvisibles?t:n.DOT);n.hasBidiCharacters(i,e)?this.bidiMap=n.doBidiReorder(i,e,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(e){if(this.seenBidi&&this.characterWidth!==e.$characterSize.width){var t=this.characterWidth=e.$characterSize.width,i=e.$measureCharWidth("ה");this.charWidths[n.L]=this.charWidths[n.EN]=this.charWidths[n.ON_R]=t,this.charWidths[n.R]=this.charWidths[n.AN]=i,this.charWidths[n.R_H]=o.isChrome?i:.45*i,this.charWidths[n.B]=0,this.currentRow=null}},this.getShowInvisibles=function(){return this.showInvisibles},this.setShowInvisibles=function(e){this.showInvisibles=e,
this.currentRow=null},this.setEolChar=function(e){this.EOL=e},this.setTextDir=function(e){this.isRtlDir=e},this.getPosLeft=function(e){e-=this.wrapIndent;var t=n.getVisualFromLogicalIdx(e>0?e-1:0,this.bidiMap),i=this.bidiMap.bidiLevels,r=0;0===e&&i[t]%2!=0&&t++;for(var o=0;o<t;o++)r+=this.charWidths[i[o]];return 0!==e&&i[t]%2==0&&(r+=this.charWidths[i[t]]),this.wrapIndent&&(r+=this.wrapIndent*this.charWidths[n.L]),r},this.getSelections=function(e,t){for(var i,r,o=this.bidiMap,s=o.bidiLevels,a=this.wrapIndent*this.charWidths[n.L],l=[],c=Math.min(e,t)-this.wrapIndent,h=Math.max(e,t)-this.wrapIndent,d=!1,u=!1,f=0,p=0;p<s.length;p++)r=o.logicalFromVisual[p],i=s[p],d=r>=c&&r<h,d&&!u?f=a:!d&&u&&l.push({left:f,width:a-f}),a+=this.charWidths[i],u=d;return d&&p===s.length&&l.push({left:f,width:a-f}),l},this.offsetToCol=function(e){var t=0,e=Math.max(e,0),i=0,r=0,o=this.bidiMap.bidiLevels,s=this.charWidths[o[r]];for(this.wrapIndent&&(e-=this.wrapIndent*this.charWidths[n.L]);e>i+s/2;){if(i+=s,r===o.length-1){s=0;break}s=this.charWidths[o[++r]]}return r>0&&o[r-1]%2!=0&&o[r]%2==0?(e<i&&r--,t=this.bidiMap.logicalFromVisual[r]):r>0&&o[r-1]%2==0&&o[r]%2!=0?t=1+(e>i?this.bidiMap.logicalFromVisual[r]:this.bidiMap.logicalFromVisual[r-1]):this.isRtlDir&&r===o.length-1&&0===s&&o[r-1]%2==0||!this.isRtlDir&&0===r&&o[r]%2!=0?t=1+this.bidiMap.logicalFromVisual[r]:(r>0&&o[r-1]%2!=0&&0!==s&&r--,t=this.bidiMap.logicalFromVisual[r]),t+this.wrapIndent}}).call(a.prototype),t.BidiHandler=a}),ace.define("ace/range",["require","exports","module"],function(e,t,i){"use strict";var n=function(e,t){return e.row-t.row||e.column-t.column},r=function(e,t,i,n){this.start={row:e,column:t},this.end={row:i,column:n}};(function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t,i=e.end,n=e.start;return t=this.compare(i.row,i.column),1==t?(t=this.compare(n.row,n.column),1==t?2:0==t?1:0):-1==t?-2:(t=this.compare(n.row,n.column),-1==t?-1:1==t?42:0)},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){var t=this.compareRange(e);return-1==t||0==t||1==t},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)&&(!this.isEnd(e,t)&&!this.isStart(e,t))},this.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},this.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row===e?t<=this.end.column?0:1:0:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){if(this.end.row>t)var i={row:t+1,column:0};else if(this.end.row<e)var i={row:e,column:0};if(this.start.row>t)var n={row:t+1,column:0};else if(this.start.row<e)var n={row:e,column:0};return r.fromPoints(n||this.start,i||this.end)},this.extend=function(e,t){var i=this.compare(e,t);if(0==i)return this;if(-1==i)var n={row:e,column:t};else var o={row:e,column:t};return r.fromPoints(n||this.start,o||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return r.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new r(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new r(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),i=e.documentToScreenPosition(this.end);return new r(t.row,t.column,i.row,i.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}).call(r.prototype),r.fromPoints=function(e,t){return new r(e.row,e.column,t.row,t.column)},r.comparePoints=n,r.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=r}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/lang"),o=e("./lib/event_emitter").EventEmitter,s=e("./range").Range,a=function(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.lead=this.selectionLead=this.doc.createAnchor(0,0),this.anchor=this.selectionAnchor=this.doc.createAnchor(0,0);var t=this;this.lead.on("change",function(e){t._emit("changeCursor"),t.$isEmpty||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.selectionAnchor.on("change",function(){t.$isEmpty||t._emit("changeSelection")})};(function(){n.implement(this,o),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.isEmpty()&&this.getRange().isMultiLine()},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.anchor.setPosition(e,t),this.$isEmpty&&(this.$isEmpty=!1,this._emit("changeSelection"))},this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.shiftSelection=function(e){if(this.$isEmpty)return void this.moveCursorTo(this.lead.row,this.lead.column+e);var t=this.getSelectionAnchor(),i=this.getSelectionLead(),n=this.isBackwards();n&&0===t.column||this.setSelectionAnchor(t.row,t.column+e),(n||0!==i.column)&&this.$moveSelection(function(){this.moveCursorTo(i.row,i.column+e)})},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.isEmpty()?s.fromPoints(t,t):this.isBackwards()?s.fromPoints(t,e):s.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){var e=this.doc.getLength()-1;this.setSelectionAnchor(0,0),this.moveCursorTo(e,this.doc.getLine(e).length)},this.setRange=this.setSelectionRange=function(e,t){t?(this.setSelectionAnchor(e.end.row,e.end.column),this.selectTo(e.start.row,e.start.column)):(this.setSelectionAnchor(e.start.row,e.start.column),this.selectTo(e.end.row,e.end.column)),this.getRange().isEmpty()&&(this.$isEmpty=!0),this.$desiredColumn=null},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection(function(){this.moveCursorTo(e,t)})},this.selectToPosition=function(e){this.$moveSelection(function(){this.moveCursorToPosition(e)})},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){if(void 0===t){var i=e||this.lead;e=i.row,t=i.column}return this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),t=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(t)},this.getLineRange=function(e,t){var i,n="number"==typeof e?e:this.lead.row,r=this.session.getFoldLine(n);return r?(n=r.start.row,i=r.end.row):i=n,!0===t?new s(n,0,i,this.session.getLine(i).length):new s(n,0,i+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(e,t,i){var n=e.column,r=e.column+t;return i<0&&(n=e.column-t,r=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(n,r).split(" ").length-1==t},this.moveCursorLeft=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,-1))this.moveCursorTo(e.start.row,e.start.column);else if(0===t.column)t.row>0&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length);else{var i=this.session.getTabSize();this.wouldMoveIntoSoftTab(t,i,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-i):this.moveCursorBy(0,-1)}},this.moveCursorRight=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,1))this.moveCursorTo(e.end.row,e.end.column);else if(this.lead.column==this.doc.getLine(this.lead.row).length)this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0);else{var i=this.session.getTabSize(),t=this.lead;this.wouldMoveIntoSoftTab(t,i,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,i):this.moveCursorBy(0,1)}},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,i=this.session.documentToScreenRow(e,t),n=this.session.screenToDocumentPosition(i,0),r=this.session.getDisplayLine(e,null,n.row,n.column),o=r.match(/^\s*/);o[0].length==t||this.session.$useEmacsStyleLineStart||(n.column+=o[0].length),this.moveCursorToPosition(n)},this.moveCursorLineEnd=function(){var e=this.lead,t=this.session.getDocumentLastRowColumnPosition(e.row,e.column);if(this.lead.column==t.column){var i=this.session.getLine(t.row);if(t.column==i.length){var n=i.search(/\s+$/);n>0&&(t.column=n)}}this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t);this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0;var r=this.session.getFoldAt(e,t,1);return r?void this.moveCursorTo(r.end.row,r.end.column):(this.session.nonTokenRe.exec(n)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,n=i.substring(t)),t>=i.length?(this.moveCursorTo(e,i.length),this.moveCursorRight(),void(e<this.doc.getLength()-1&&this.moveCursorWordRight())):(this.session.tokenRe.exec(n)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),void this.moveCursorTo(e,t)))},this.moveCursorLongWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))return void this.moveCursorTo(e.start.row,e.start.column);var n=this.session.getFoldStringAt(t,i,-1);null==n&&(n=this.doc.getLine(t).substring(0,i));var o=r.stringReverse(n);if(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(o)&&(i-=this.session.nonTokenRe.lastIndex,o=o.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),i<=0)return this.moveCursorTo(t,0),this.moveCursorLeft(),void(t>0&&this.moveCursorWordLeft());this.session.tokenRe.exec(o)&&(i-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,i)},this.$shortWordEndIndex=function(e){var t,i=0,n=/\s/,r=this.session.tokenRe;if(r.lastIndex=0,this.session.tokenRe.exec(e))i=this.session.tokenRe.lastIndex;else{for(;(t=e[i])&&n.test(t);)i++;if(i<1)for(r.lastIndex=0;(t=e[i])&&!r.test(t);)if(r.lastIndex=0,i++,n.test(t)){if(i>2){i--;break}for(;(t=e[i])&&n.test(t);)i++;if(i>2)break}}return r.lastIndex=0,i},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t),r=this.session.getFoldAt(e,t,1);if(r)return this.moveCursorTo(r.end.row,r.end.column);if(t==i.length){var o=this.doc.getLength();do{e++,n=this.doc.getLine(e)}while(e<o&&/^\s*$/.test(n));/^\s+/.test(n)||(n=""),t=0}var s=this.$shortWordEndIndex(n);this.moveCursorTo(e,t+s)},this.moveCursorShortWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))return this.moveCursorTo(e.start.row,e.start.column);var n=this.session.getLine(t).substring(0,i);if(0===i){do{t--,n=this.doc.getLine(t)}while(t>0&&/^\s*$/.test(n));i=n.length,/\s+$/.test(n)||(n="")}var o=r.stringReverse(n),s=this.$shortWordEndIndex(o);return this.moveCursorTo(t,i-s)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var i,n=this.session.documentToScreenPosition(this.lead.row,this.lead.column);0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(n.row,this.lead.row)?(i=this.session.$bidiHandler.getPosLeft(n.column),n.column=Math.round(i/this.session.$bidiHandler.charWidths[0])):i=n.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?n.column=this.$desiredColumn:this.$desiredColumn=n.column);var r=this.session.screenToDocumentPosition(n.row+e,n.column,i);0!==e&&0===t&&r.row===this.lead.row&&r.column===this.lead.column&&this.session.lineWidgets&&this.session.lineWidgets[r.row]&&(r.row>0||e>0)&&r.row++,this.moveCursorTo(r.row,r.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,i){var n=this.session.getFoldAt(e,t,1);n&&(e=n.start.row,t=n.start.column),this.$keepDesiredColumnOnChange=!0;var r=this.session.getLine(e);/[\uDC00-\uDFFF]/.test(r.charAt(t))&&r.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,i||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,i){var n=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(n.row,n.column,i)},this.detach=function(){this.lead.detach(),this.anchor.detach(),this.session=this.doc=null},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var i=this.getCursor();return s.fromPoints(t,i)}catch(e){return s.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){if(this.rangeCount)var e=this.ranges.map(function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t});else{var e=this.getRange();e.isBackwards=this.isBackwards()}return e},this.fromJSON=function(e){if(void 0==e.start){if(this.rangeList){this.toSingleRange(e[0]);for(var t=e.length;t--;){var i=s.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(i.cursor=i.start),this.addRange(i,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}).call(a.prototype),t.Selection=a}),ace.define("ace/tokenizer",["require","exports","module","ace/config"],function(e,t,i){"use strict";var n=e("./config"),r=2e3,o=function(e){this.states=e,this.regExps={},this.matchMappings={};for(var t in this.states){for(var i=this.states[t],n=[],r=0,o=this.matchMappings[t]={defaultToken:"text"},s="g",a=[],l=0;l<i.length;l++){var c=i[l];if(c.defaultToken&&(o.defaultToken=c.defaultToken),c.caseInsensitive&&(s="gi"),null!=c.regex){c.regex instanceof RegExp&&(c.regex=c.regex.toString().slice(1,-1));var h=c.regex,d=new RegExp("(?:("+h+")|(.))").exec("a").length-2;Array.isArray(c.token)?1==c.token.length||1==d?c.token=c.token[0]:d-1!=c.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:c,groupCount:d-1}),c.token=c.token[0]):(c.tokenArray=c.token,c.token=null,c.onMatch=this.$arrayTokens):"function"!=typeof c.token||c.onMatch||(c.onMatch=d>1?this.$applyToken:c.token),d>1&&(/\\\d/.test(c.regex)?h=c.regex.replace(/\\([0-9]+)/g,function(e,t){return"\\"+(parseInt(t,10)+r+1)}):(d=1,h=this.removeCapturingGroups(c.regex)),c.splitRegex||"string"==typeof c.token||a.push(c)),o[r]=l,r+=d,n.push(h),c.onMatch||(c.onMatch=null)}}n.length||(o[0]=0,n.push("$")),a.forEach(function(e){e.splitRegex=this.createSplitterRegexp(e.regex,s)},this),this.regExps[t]=new RegExp("("+n.join(")|(")+")|($)",s)}};(function(){this.$setMaxTokenCount=function(e){r=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),i=this.token.apply(this,t);if("string"==typeof i)return[{type:i,value:e}];for(var n=[],r=0,o=i.length;r<o;r++)t[r]&&(n[n.length]={type:i[r],value:t[r]});return n},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var i=[],n=this.tokenArray,r=0,o=n.length;r<o;r++)t[r+1]&&(i[i.length]={type:n[r],value:t[r+1]});return i},this.removeCapturingGroups=function(e){return e.replace(/\[(?:\\.|[^\]])*?\]|\\.|\(\?[:=!]|(\()/g,function(e,t){return t?"(?:":e})},this.createSplitterRegexp=function(e,t){if(-1!=e.indexOf("(?=")){var i=0,n=!1,r={};e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(e,t,o,s,a,l){return n?n="]"!=a:a?n=!0:s?(i==r.stack&&(r.end=l+1,r.stack=-1),i--):o&&(i++,1!=o.length&&(r.stack=i,r.start=l)),e}),null!=r.end&&/^\)*$/.test(e.substr(r.end))&&(e=e.substring(0,r.start)+e.substr(r.end))}return"^"!=e.charAt(0)&&(e="^"+e),"$"!=e.charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){if(t&&"string"!=typeof t){var i=t.slice(0);t=i[0],"#tmp"===t&&(i.shift(),t=i.shift())}else var i=[];var n=t||"start",o=this.states[n];o||(n="start",o=this.states[n]);var s=this.matchMappings[n],a=this.regExps[n];a.lastIndex=0;for(var l,c=[],h=0,d=0,u={type:null,value:""};l=a.exec(e);){var f=s.defaultToken,p=null,m=l[0],g=a.lastIndex;if(g-m.length>h){var v=e.substring(h,g-m.length);u.type==f?u.value+=v:(u.type&&c.push(u),u={type:f,value:v})}for(var y=0;y<l.length-2;y++)if(void 0!==l[y+1]){p=o[s[y]],f=p.onMatch?p.onMatch(m,n,i,e):p.token,p.next&&(n="string"==typeof p.next?p.next:p.next(n,i),o=this.states[n],o||(this.reportError("state doesn't exist",n),n="start",o=this.states[n]),s=this.matchMappings[n],h=g,a=this.regExps[n],a.lastIndex=g),p.consumeLineEnd&&(h=g);break}if(m)if("string"==typeof f)p&&!1===p.merge||u.type!==f?(u.type&&c.push(u),u={type:f,value:m}):u.value+=m;else if(f){u.type&&c.push(u),u={type:null,value:""};for(var y=0;y<f.length;y++)c.push(f[y])}if(h==e.length)break;if(h=g,d++>r){for(d>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});h<e.length;)u.type&&c.push(u),u={value:e.substring(h,h+=2e3),type:"overflow"};n="start",i=[];break}}return u.type&&c.push(u),i.length>1&&i[0]!==n&&i.unshift("#tmp",n),{tokens:c,state:i.length?i:n}},this.reportError=n.reportError}).call(o.prototype),t.Tokenizer=o}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(e,t,i){"use strict";var n=e("../lib/lang"),r=function(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}};(function(){this.addRules=function(e,t){if(t)for(var i in e){for(var n=e[i],r=0;r<n.length;r++){var o=n[r];(o.next||o.onMatch)&&("string"==typeof o.next&&0!==o.next.indexOf(t)&&(o.next=t+o.next),o.nextState&&0!==o.nextState.indexOf(t)&&(o.nextState=t+o.nextState))}this.$rules[t+i]=n}else for(var i in e)this.$rules[i]=e[i]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,i,r,o){var s="function"==typeof e?(new e).getRules():e;if(r)for(var a=0;a<r.length;a++)r[a]=t+r[a];else{r=[];for(var l in s)r.push(t+l)}if(this.addRules(s,t),i)for(var c=Array.prototype[o?"push":"unshift"],a=0;a<r.length;a++)c.apply(this.$rules[r[a]],n.deepCopy(i));this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};var e=function(e,t){return("start"!=e||t.length)&&t.unshift(this.nextState,e),this.nextState},t=function(e,t){return t.shift(),t.shift()||"start"};this.normalizeRules=function(){function i(o){var s=r[o];s.processed=!0;for(var a=0;a<s.length;a++){var l=s[a],c=null;Array.isArray(l)&&(c=l,l={}),!l.regex&&l.start&&(l.regex=l.start,l.next||(l.next=[]),l.next.push({defaultToken:l.token},{token:l.token+".end",regex:l.end||l.start,next:"pop"}),l.token=l.token+".start",l.push=!0);var h=l.next||l.push;if(h&&Array.isArray(h)){var d=l.stateName;d||(d=l.token,"string"!=typeof d&&(d=d[0]||""),r[d]&&(d+=n++)),r[d]=h,l.next=d,i(d)}else"pop"==h&&(l.next=t);if(l.push&&(l.nextState=l.next||l.push,l.next=e,delete l.push),l.rules)for(var u in l.rules)r[u]?r[u].push&&r[u].push.apply(r[u],l.rules[u]):r[u]=l.rules[u];var f="string"==typeof l?l:l.include;if(f&&(c=Array.isArray(f)?f.map(function(e){return r[e]}):r[f]),c){var p=[a,1].concat(c);l.noEscape&&(p=p.filter(function(e){return!e.next})),s.splice.apply(s,p),a--}l.keywordMap&&(l.token=this.createKeywordMapper(l.keywordMap,l.defaultToken||"text",l.caseInsensitive),delete l.defaultToken)}}var n=0,r=this.$rules;Object.keys(r).forEach(i,this)},this.createKeywordMapper=function(e,t,i,n){var r=Object.create(null);return Object.keys(e).forEach(function(t){var o=e[t];i&&(o=o.toLowerCase());for(var s=o.split(n||"|"),a=s.length;a--;)r[s[a]]=t}),Object.getPrototypeOf(r)&&(r.__proto__=null),this.$keywordList=Object.keys(r),e=null,i?function(e){return r[e.toLowerCase()]||t}:function(e){return r[e]||t}},this.getKeywords=function(){return this.$keywords}}).call(r.prototype),t.TextHighlightRules=r}),ace.define("ace/mode/behaviour",["require","exports","module"],function(e,t,i){"use strict";var n=function(){this.$behaviours={}};(function(){this.add=function(e,t,i){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=i},this.addBehaviours=function(e){for(var t in e)for(var i in e[t])this.add(t,i,e[t][i])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){if("function"==typeof e)var i=(new e).getBehaviours(t);else var i=e.getBehaviours(t);this.addBehaviours(i)},this.getBehaviours=function(e){if(e){for(var t={},i=0;i<e.length;i++)this.$behaviours[e[i]]&&(t[e[i]]=this.$behaviours[e[i]]);return t}return this.$behaviours}}).call(n.prototype),t.Behaviour=n}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("./range").Range,r=function(e,t,i){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);var n=e.getTokenAt(t,i);this.$tokenIndex=n?n.index:-1};(function(){this.stepBackward=function(){for(this.$tokenIndex-=1;this.$tokenIndex<0;){if(this.$row-=1,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){this.$tokenIndex+=1;for(var e;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e||(e=this.$session.getLength()),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,i=e[t].start;if(void 0!==i)return i;for(i=0;t>0;)t-=1,i+=e[t].value.length;return i},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new n(this.$row,t,this.$row,t+e.value.length)}}).call(r.prototype),t.TokenIterator=r}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t,i){"use strict";var n,r=e("../../lib/oop"),o=e("../behaviour").Behaviour,s=e("../../token_iterator").TokenIterator,a=e("../../lib/lang"),l=["text","paren.rparen","punctuation.operator"],c=["text","paren.rparen","punctuation.operator","comment"],h={},d={'"':'"',"'":"'"},u=function(e){var t=-1;if(e.multiSelect&&(t=e.selection.index,h.rangeCount!=e.multiSelect.rangeCount&&(h={rangeCount:e.multiSelect.rangeCount})),h[t])return n=h[t];n=h[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}},f=function(e,t,i,n){var r=e.end.row-e.start.row;return{text:i+t+n,selection:[0,e.start.column+1,r,e.end.column+(r?0:1)]}},p=function(e){this.add("braces","insertion",function(t,i,r,o,s){var l=r.getCursorPosition(),c=o.doc.getLine(l.row);if("{"==s){u(r);var h=r.getSelectionRange(),d=o.doc.getTextRange(h);if(""!==d&&"{"!==d&&r.getWrapBehavioursEnabled())return f(h,d,"{","}");if(p.isSaneInsertion(r,o))return/[\]\}\)]/.test(c[l.column])||r.inMultiSelectMode||e&&e.braces?(p.recordAutoInsert(r,o,"}"),{text:"{}",selection:[1,1]}):(p.recordMaybeInsert(r,o,"{"),{text:"{",selection:[1,1]})}else if("}"==s){u(r);var m=c.substring(l.column,l.column+1);if("}"==m){var g=o.$findOpeningBracket("}",{column:l.column+1,row:l.row});if(null!==g&&p.isAutoInsertedClosing(l,c,s))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}else{if("\n"==s||"\r\n"==s){u(r);var v="";p.isMaybeInsertedClosing(l,c)&&(v=a.stringRepeat("}",n.maybeInsertedBrackets),p.clearMaybeInsertedClosing());var m=c.substring(l.column,l.column+1);if("}"===m){var y=o.findMatchingBracket({row:l.row,column:l.column+1},"}");if(!y)return null;var w=this.$getIndent(o.getLine(y.row))}else{if(!v)return void p.clearMaybeInsertedClosing();var w=this.$getIndent(c)}var b=w+o.getTabString();return{text:"\n"+b+"\n"+w+v,selection:[1,b.length,1,b.length]}}p.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,i,r,o){var s=r.doc.getTextRange(o);if(!o.isMultiLine()&&"{"==s){u(i);if("}"==r.doc.getLine(o.start.row).substring(o.end.column,o.end.column+1))return o.end.column++,o;n.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,i,n,r){if("("==r){u(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return f(o,s,"(",")");if(p.isSaneInsertion(i,n))return p.recordAutoInsert(i,n,")"),{text:"()",selection:[1,1]}}else if(")"==r){u(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row),c=l.substring(a.column,a.column+1);if(")"==c){var h=n.$findOpeningBracket(")",{column:a.column+1,row:a.row});if(null!==h&&p.isAutoInsertedClosing(a,l,r))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}}),this.add("parens","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"("==o){u(i);if(")"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2))return r.end.column++,r}}),this.add("brackets","insertion",function(e,t,i,n,r){if("["==r){u(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return f(o,s,"[","]");if(p.isSaneInsertion(i,n))return p.recordAutoInsert(i,n,"]"),{text:"[]",selection:[1,1]}}else if("]"==r){u(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row),c=l.substring(a.column,a.column+1);if("]"==c){var h=n.$findOpeningBracket("]",{column:a.column+1,row:a.row});if(null!==h&&p.isAutoInsertedClosing(a,l,r))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}}),this.add("brackets","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"["==o){u(i);if("]"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2))return r.end.column++,r}}),this.add("string_dquotes","insertion",function(e,t,i,n,r){var o=n.$mode.$quotes||d;if(1==r.length&&o[r]){if(this.lineCommentStart&&-1!=this.lineCommentStart.indexOf(r))return;u(i);var s=r,a=i.getSelectionRange(),l=n.doc.getTextRange(a);if(!(""===l||1==l.length&&o[l])&&i.getWrapBehavioursEnabled())return f(a,l,s,s);if(!l){var c=i.getCursorPosition(),h=n.doc.getLine(c.row),p=h.substring(c.column-1,c.column),m=h.substring(c.column,c.column+1),g=n.getTokenAt(c.row,c.column),v=n.getTokenAt(c.row,c.column+1);if("\\"==p&&g&&/escape/.test(g.type))return null;var y,w=g&&/string|escape/.test(g.type),b=!v||/string|escape/.test(v.type);if(m==s)(y=w!==b)&&/string\.end/.test(v.type)&&(y=!1);else{if(w&&!b)return null;if(w&&b)return null;var C=n.$mode.tokenRe;C.lastIndex=0;var A=C.test(p);C.lastIndex=0;var E=C.test(p);if(A||E)return null;if(m&&!/[\s;,.})\]\\]/.test(m))return null;y=!0}return{text:y?s+s:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&('"'==o||"'"==o)){u(i);if(n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)==o)return r.end.column++,r}})};p.isSaneInsertion=function(e,t){var i=e.getCursorPosition(),n=new s(t,i.row,i.column);if(!this.$matchTokenType(n.getCurrentToken()||"text",l)){var r=new s(t,i.row,i.column+1);if(!this.$matchTokenType(r.getCurrentToken()||"text",l))return!1}return n.stepForward(),n.getCurrentTokenRow()!==i.row||this.$matchTokenType(n.getCurrentToken()||"text",c)},p.$matchTokenType=function(e,t){return t.indexOf(e.type||e)>-1},p.recordAutoInsert=function(e,t,i){var r=e.getCursorPosition(),o=t.doc.getLine(r.row);this.isAutoInsertedClosing(r,o,n.autoInsertedLineEnd[0])||(n.autoInsertedBrackets=0),n.autoInsertedRow=r.row,n.autoInsertedLineEnd=i+o.substr(r.column),n.autoInsertedBrackets++},p.recordMaybeInsert=function(e,t,i){var r=e.getCursorPosition(),o=t.doc.getLine(r.row);this.isMaybeInsertedClosing(r,o)||(n.maybeInsertedBrackets=0),n.maybeInsertedRow=r.row,n.maybeInsertedLineStart=o.substr(0,r.column)+i,n.maybeInsertedLineEnd=o.substr(r.column),n.maybeInsertedBrackets++},p.isAutoInsertedClosing=function(e,t,i){return n.autoInsertedBrackets>0&&e.row===n.autoInsertedRow&&i===n.autoInsertedLineEnd[0]&&t.substr(e.column)===n.autoInsertedLineEnd},p.isMaybeInsertedClosing=function(e,t){return n.maybeInsertedBrackets>0&&e.row===n.maybeInsertedRow&&t.substr(e.column)===n.maybeInsertedLineEnd&&t.substr(0,e.column)==n.maybeInsertedLineStart},p.popAutoInsertedClosing=function(){n.autoInsertedLineEnd=n.autoInsertedLineEnd.substr(1),n.autoInsertedBrackets--},p.clearMaybeInsertedClosing=function(){n&&(n.maybeInsertedBrackets=0,n.maybeInsertedRow=-1)},r.inherits(p,o),t.CstyleBehaviour=p}),ace.define("ace/unicode",["require","exports","module"],function(e,t,i){"use strict";t.packages={},function(e){for(var i in e)t.packages[i]=e[i].replace(/\w{4}/g,"\\u$&")}({L:"0041-005A0061-007A00AA00B500BA00C0-00D600D8-00F600F8-02C102C6-02D102E0-02E402EC02EE0370-037403760377037A-037D03860388-038A038C038E-03A103A3-03F503F7-0481048A-05250531-055605590561-058705D0-05EA05F0-05F20621-064A066E066F0671-06D306D506E506E606EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA07F407F507FA0800-0815081A082408280904-0939093D09500958-0961097109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E460E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EC60EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10A0-10C510D0-10FA10FC1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317D717DC1820-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541AA71B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C7D1CE9-1CEC1CEE-1CF11D00-1DBF1E00-1F151F18-1F1D1F20-1F451F48-1F4D1F50-1F571F591F5B1F5D1F5F-1F7D1F80-1FB41FB6-1FBC1FBE1FC2-1FC41FC6-1FCC1FD0-1FD31FD6-1FDB1FE0-1FEC1FF2-1FF41FF6-1FFC2071207F2090-209421022107210A-211321152119-211D212421262128212A-212D212F-2139213C-213F2145-2149214E218321842C00-2C2E2C30-2C5E2C60-2CE42CEB-2CEE2D00-2D252D30-2D652D6F2D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE2E2F300530063031-3035303B303C3041-3096309D-309F30A1-30FA30FC-30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A48CA4D0-A4FDA500-A60CA610-A61FA62AA62BA640-A65FA662-A66EA67F-A697A6A0-A6E5A717-A71FA722-A788A78BA78CA7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2A9CFAA00-AA28AA40-AA42AA44-AA4BAA60-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADB-AADDABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB00-FB06FB13-FB17FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF21-FF3AFF41-FF5AFF66-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",Ll:"0061-007A00AA00B500BA00DF-00F600F8-00FF01010103010501070109010B010D010F01110113011501170119011B011D011F01210123012501270129012B012D012F01310133013501370138013A013C013E014001420144014601480149014B014D014F01510153015501570159015B015D015F01610163016501670169016B016D016F0171017301750177017A017C017E-0180018301850188018C018D019201950199-019B019E01A101A301A501A801AA01AB01AD01B001B401B601B901BA01BD-01BF01C601C901CC01CE01D001D201D401D601D801DA01DC01DD01DF01E101E301E501E701E901EB01ED01EF01F001F301F501F901FB01FD01FF02010203020502070209020B020D020F02110213021502170219021B021D021F02210223022502270229022B022D022F02310233-0239023C023F0240024202470249024B024D024F-02930295-02AF037103730377037B-037D039003AC-03CE03D003D103D5-03D703D903DB03DD03DF03E103E303E503E703E903EB03ED03EF-03F303F503F803FB03FC0430-045F04610463046504670469046B046D046F04710473047504770479047B047D047F0481048B048D048F04910493049504970499049B049D049F04A104A304A504A704A904AB04AD04AF04B104B304B504B704B904BB04BD04BF04C204C404C604C804CA04CC04CE04CF04D104D304D504D704D904DB04DD04DF04E104E304E504E704E904EB04ED04EF04F104F304F504F704F904FB04FD04FF05010503050505070509050B050D050F05110513051505170519051B051D051F0521052305250561-05871D00-1D2B1D62-1D771D79-1D9A1E011E031E051E071E091E0B1E0D1E0F1E111E131E151E171E191E1B1E1D1E1F1E211E231E251E271E291E2B1E2D1E2F1E311E331E351E371E391E3B1E3D1E3F1E411E431E451E471E491E4B1E4D1E4F1E511E531E551E571E591E5B1E5D1E5F1E611E631E651E671E691E6B1E6D1E6F1E711E731E751E771E791E7B1E7D1E7F1E811E831E851E871E891E8B1E8D1E8F1E911E931E95-1E9D1E9F1EA11EA31EA51EA71EA91EAB1EAD1EAF1EB11EB31EB51EB71EB91EBB1EBD1EBF1EC11EC31EC51EC71EC91ECB1ECD1ECF1ED11ED31ED51ED71ED91EDB1EDD1EDF1EE11EE31EE51EE71EE91EEB1EED1EEF1EF11EF31EF51EF71EF91EFB1EFD1EFF-1F071F10-1F151F20-1F271F30-1F371F40-1F451F50-1F571F60-1F671F70-1F7D1F80-1F871F90-1F971FA0-1FA71FB0-1FB41FB61FB71FBE1FC2-1FC41FC61FC71FD0-1FD31FD61FD71FE0-1FE71FF2-1FF41FF61FF7210A210E210F2113212F21342139213C213D2146-2149214E21842C30-2C5E2C612C652C662C682C6A2C6C2C712C732C742C76-2C7C2C812C832C852C872C892C8B2C8D2C8F2C912C932C952C972C992C9B2C9D2C9F2CA12CA32CA52CA72CA92CAB2CAD2CAF2CB12CB32CB52CB72CB92CBB2CBD2CBF2CC12CC32CC52CC72CC92CCB2CCD2CCF2CD12CD32CD52CD72CD92CDB2CDD2CDF2CE12CE32CE42CEC2CEE2D00-2D25A641A643A645A647A649A64BA64DA64FA651A653A655A657A659A65BA65DA65FA663A665A667A669A66BA66DA681A683A685A687A689A68BA68DA68FA691A693A695A697A723A725A727A729A72BA72DA72F-A731A733A735A737A739A73BA73DA73FA741A743A745A747A749A74BA74DA74FA751A753A755A757A759A75BA75DA75FA761A763A765A767A769A76BA76DA76FA771-A778A77AA77CA77FA781A783A785A787A78CFB00-FB06FB13-FB17FF41-FF5A",Lu:"0041-005A00C0-00D600D8-00DE01000102010401060108010A010C010E01100112011401160118011A011C011E01200122012401260128012A012C012E01300132013401360139013B013D013F0141014301450147014A014C014E01500152015401560158015A015C015E01600162016401660168016A016C016E017001720174017601780179017B017D018101820184018601870189-018B018E-0191019301940196-0198019C019D019F01A001A201A401A601A701A901AC01AE01AF01B1-01B301B501B701B801BC01C401C701CA01CD01CF01D101D301D501D701D901DB01DE01E001E201E401E601E801EA01EC01EE01F101F401F6-01F801FA01FC01FE02000202020402060208020A020C020E02100212021402160218021A021C021E02200222022402260228022A022C022E02300232023A023B023D023E02410243-02460248024A024C024E03700372037603860388-038A038C038E038F0391-03A103A3-03AB03CF03D2-03D403D803DA03DC03DE03E003E203E403E603E803EA03EC03EE03F403F703F903FA03FD-042F04600462046404660468046A046C046E04700472047404760478047A047C047E0480048A048C048E04900492049404960498049A049C049E04A004A204A404A604A804AA04AC04AE04B004B204B404B604B804BA04BC04BE04C004C104C304C504C704C904CB04CD04D004D204D404D604D804DA04DC04DE04E004E204E404E604E804EA04EC04EE04F004F204F404F604F804FA04FC04FE05000502050405060508050A050C050E05100512051405160518051A051C051E0520052205240531-055610A0-10C51E001E021E041E061E081E0A1E0C1E0E1E101E121E141E161E181E1A1E1C1E1E1E201E221E241E261E281E2A1E2C1E2E1E301E321E341E361E381E3A1E3C1E3E1E401E421E441E461E481E4A1E4C1E4E1E501E521E541E561E581E5A1E5C1E5E1E601E621E641E661E681E6A1E6C1E6E1E701E721E741E761E781E7A1E7C1E7E1E801E821E841E861E881E8A1E8C1E8E1E901E921E941E9E1EA01EA21EA41EA61EA81EAA1EAC1EAE1EB01EB21EB41EB61EB81EBA1EBC1EBE1EC01EC21EC41EC61EC81ECA1ECC1ECE1ED01ED21ED41ED61ED81EDA1EDC1EDE1EE01EE21EE41EE61EE81EEA1EEC1EEE1EF01EF21EF41EF61EF81EFA1EFC1EFE1F08-1F0F1F18-1F1D1F28-1F2F1F38-1F3F1F48-1F4D1F591F5B1F5D1F5F1F68-1F6F1FB8-1FBB1FC8-1FCB1FD8-1FDB1FE8-1FEC1FF8-1FFB21022107210B-210D2110-211221152119-211D212421262128212A-212D2130-2133213E213F214521832C00-2C2E2C602C62-2C642C672C692C6B2C6D-2C702C722C752C7E-2C802C822C842C862C882C8A2C8C2C8E2C902C922C942C962C982C9A2C9C2C9E2CA02CA22CA42CA62CA82CAA2CAC2CAE2CB02CB22CB42CB62CB82CBA2CBC2CBE2CC02CC22CC42CC62CC82CCA2CCC2CCE2CD02CD22CD42CD62CD82CDA2CDC2CDE2CE02CE22CEB2CEDA640A642A644A646A648A64AA64CA64EA650A652A654A656A658A65AA65CA65EA662A664A666A668A66AA66CA680A682A684A686A688A68AA68CA68EA690A692A694A696A722A724A726A728A72AA72CA72EA732A734A736A738A73AA73CA73EA740A742A744A746A748A74AA74CA74EA750A752A754A756A758A75AA75CA75EA760A762A764A766A768A76AA76CA76EA779A77BA77DA77EA780A782A784A786A78BFF21-FF3A",Lt:"01C501C801CB01F21F88-1F8F1F98-1F9F1FA8-1FAF1FBC1FCC1FFC",Lm:"02B0-02C102C6-02D102E0-02E402EC02EE0374037A0559064006E506E607F407F507FA081A0824082809710E460EC610FC17D718431AA71C78-1C7D1D2C-1D611D781D9B-1DBF2071207F2090-20942C7D2D6F2E2F30053031-3035303B309D309E30FC-30FEA015A4F8-A4FDA60CA67FA717-A71FA770A788A9CFAA70AADDFF70FF9EFF9F",Lo:"01BB01C0-01C3029405D0-05EA05F0-05F20621-063F0641-064A066E066F0671-06D306D506EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA0800-08150904-0939093D09500958-096109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E450E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10D0-10FA1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317DC1820-18421844-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C771CE9-1CEC1CEE-1CF12135-21382D30-2D652D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE3006303C3041-3096309F30A1-30FA30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A014A016-A48CA4D0-A4F7A500-A60BA610-A61FA62AA62BA66EA6A0-A6E5A7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2AA00-AA28AA40-AA42AA44-AA4BAA60-AA6FAA71-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADBAADCABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF66-FF6FFF71-FF9DFFA0-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",M:"0300-036F0483-04890591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DE-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0903093C093E-094E0951-0955096209630981-098309BC09BE-09C409C709C809CB-09CD09D709E209E30A01-0A030A3C0A3E-0A420A470A480A4B-0A4D0A510A700A710A750A81-0A830ABC0ABE-0AC50AC7-0AC90ACB-0ACD0AE20AE30B01-0B030B3C0B3E-0B440B470B480B4B-0B4D0B560B570B620B630B820BBE-0BC20BC6-0BC80BCA-0BCD0BD70C01-0C030C3E-0C440C46-0C480C4A-0C4D0C550C560C620C630C820C830CBC0CBE-0CC40CC6-0CC80CCA-0CCD0CD50CD60CE20CE30D020D030D3E-0D440D46-0D480D4A-0D4D0D570D620D630D820D830DCA0DCF-0DD40DD60DD8-0DDF0DF20DF30E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F3E0F3F0F71-0F840F860F870F90-0F970F99-0FBC0FC6102B-103E1056-1059105E-10601062-10641067-106D1071-10741082-108D108F109A-109D135F1712-17141732-1734175217531772177317B6-17D317DD180B-180D18A91920-192B1930-193B19B0-19C019C819C91A17-1A1B1A55-1A5E1A60-1A7C1A7F1B00-1B041B34-1B441B6B-1B731B80-1B821BA1-1BAA1C24-1C371CD0-1CD21CD4-1CE81CED1CF21DC0-1DE61DFD-1DFF20D0-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66F-A672A67CA67DA6F0A6F1A802A806A80BA823-A827A880A881A8B4-A8C4A8E0-A8F1A926-A92DA947-A953A980-A983A9B3-A9C0AA29-AA36AA43AA4CAA4DAA7BAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE3-ABEAABECABEDFB1EFE00-FE0FFE20-FE26",Mn:"0300-036F0483-04870591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DF-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0902093C0941-0948094D0951-095509620963098109BC09C1-09C409CD09E209E30A010A020A3C0A410A420A470A480A4B-0A4D0A510A700A710A750A810A820ABC0AC1-0AC50AC70AC80ACD0AE20AE30B010B3C0B3F0B41-0B440B4D0B560B620B630B820BC00BCD0C3E-0C400C46-0C480C4A-0C4D0C550C560C620C630CBC0CBF0CC60CCC0CCD0CE20CE30D41-0D440D4D0D620D630DCA0DD2-0DD40DD60E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F71-0F7E0F80-0F840F860F870F90-0F970F99-0FBC0FC6102D-10301032-10371039103A103D103E10581059105E-10601071-1074108210851086108D109D135F1712-17141732-1734175217531772177317B7-17BD17C617C9-17D317DD180B-180D18A91920-19221927192819321939-193B1A171A181A561A58-1A5E1A601A621A65-1A6C1A73-1A7C1A7F1B00-1B031B341B36-1B3A1B3C1B421B6B-1B731B801B811BA2-1BA51BA81BA91C2C-1C331C361C371CD0-1CD21CD4-1CE01CE2-1CE81CED1DC0-1DE61DFD-1DFF20D0-20DC20E120E5-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66FA67CA67DA6F0A6F1A802A806A80BA825A826A8C4A8E0-A8F1A926-A92DA947-A951A980-A982A9B3A9B6-A9B9A9BCAA29-AA2EAA31AA32AA35AA36AA43AA4CAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE5ABE8ABEDFB1EFE00-FE0FFE20-FE26",Mc:"0903093E-09400949-094C094E0982098309BE-09C009C709C809CB09CC09D70A030A3E-0A400A830ABE-0AC00AC90ACB0ACC0B020B030B3E0B400B470B480B4B0B4C0B570BBE0BBF0BC10BC20BC6-0BC80BCA-0BCC0BD70C01-0C030C41-0C440C820C830CBE0CC0-0CC40CC70CC80CCA0CCB0CD50CD60D020D030D3E-0D400D46-0D480D4A-0D4C0D570D820D830DCF-0DD10DD8-0DDF0DF20DF30F3E0F3F0F7F102B102C10311038103B103C105610571062-10641067-106D108310841087-108C108F109A-109C17B617BE-17C517C717C81923-19261929-192B193019311933-193819B0-19C019C819C91A19-1A1B1A551A571A611A631A641A6D-1A721B041B351B3B1B3D-1B411B431B441B821BA11BA61BA71BAA1C24-1C2B1C341C351CE11CF2A823A824A827A880A881A8B4-A8C3A952A953A983A9B4A9B5A9BAA9BBA9BD-A9C0AA2FAA30AA33AA34AA4DAA7BABE3ABE4ABE6ABE7ABE9ABEAABEC",Me:"0488048906DE20DD-20E020E2-20E4A670-A672",N:"0030-003900B200B300B900BC-00BE0660-066906F0-06F907C0-07C90966-096F09E6-09EF09F4-09F90A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BF20C66-0C6F0C78-0C7E0CE6-0CEF0D66-0D750E50-0E590ED0-0ED90F20-0F331040-10491090-10991369-137C16EE-16F017E0-17E917F0-17F91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C5920702074-20792080-20892150-21822185-21892460-249B24EA-24FF2776-27932CFD30073021-30293038-303A3192-31953220-32293251-325F3280-328932B1-32BFA620-A629A6E6-A6EFA830-A835A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nd:"0030-00390660-066906F0-06F907C0-07C90966-096F09E6-09EF0A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BEF0C66-0C6F0CE6-0CEF0D66-0D6F0E50-0E590ED0-0ED90F20-0F291040-10491090-109917E0-17E91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C59A620-A629A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nl:"16EE-16F02160-21822185-218830073021-30293038-303AA6E6-A6EF",No:"00B200B300B900BC-00BE09F4-09F90BF0-0BF20C78-0C7E0D70-0D750F2A-0F331369-137C17F0-17F920702074-20792080-20892150-215F21892460-249B24EA-24FF2776-27932CFD3192-31953220-32293251-325F3280-328932B1-32BFA830-A835",P:"0021-00230025-002A002C-002F003A003B003F0040005B-005D005F007B007D00A100AB00B700BB00BF037E0387055A-055F0589058A05BE05C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F3A-0F3D0F850FD0-0FD4104A-104F10FB1361-13681400166D166E169B169C16EB-16ED1735173617D4-17D617D8-17DA1800-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD32010-20272030-20432045-20512053-205E207D207E208D208E2329232A2768-277527C527C627E6-27EF2983-299829D8-29DB29FC29FD2CF9-2CFC2CFE2CFF2E00-2E2E2E302E313001-30033008-30113014-301F3030303D30A030FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFD3EFD3FFE10-FE19FE30-FE52FE54-FE61FE63FE68FE6AFE6BFF01-FF03FF05-FF0AFF0C-FF0FFF1AFF1BFF1FFF20FF3B-FF3DFF3FFF5BFF5DFF5F-FF65",Pd:"002D058A05BE140018062010-20152E172E1A301C303030A0FE31FE32FE58FE63FF0D",Ps:"0028005B007B0F3A0F3C169B201A201E2045207D208D23292768276A276C276E27702772277427C527E627E827EA27EC27EE2983298529872989298B298D298F299129932995299729D829DA29FC2E222E242E262E283008300A300C300E3010301430163018301A301DFD3EFE17FE35FE37FE39FE3BFE3DFE3FFE41FE43FE47FE59FE5BFE5DFF08FF3BFF5BFF5FFF62",Pe:"0029005D007D0F3B0F3D169C2046207E208E232A2769276B276D276F27712773277527C627E727E927EB27ED27EF298429862988298A298C298E2990299229942996299829D929DB29FD2E232E252E272E293009300B300D300F3011301530173019301B301E301FFD3FFE18FE36FE38FE3AFE3CFE3EFE40FE42FE44FE48FE5AFE5CFE5EFF09FF3DFF5DFF60FF63",Pi:"00AB2018201B201C201F20392E022E042E092E0C2E1C2E20",Pf:"00BB2019201D203A2E032E052E0A2E0D2E1D2E21",Pc:"005F203F20402054FE33FE34FE4D-FE4FFF3F",Po:"0021-00230025-0027002A002C002E002F003A003B003F0040005C00A100B700BF037E0387055A-055F058905C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F850FD0-0FD4104A-104F10FB1361-1368166D166E16EB-16ED1735173617D4-17D617D8-17DA1800-18051807-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD3201620172020-20272030-2038203B-203E2041-20432047-205120532055-205E2CF9-2CFC2CFE2CFF2E002E012E06-2E082E0B2E0E-2E162E182E192E1B2E1E2E1F2E2A-2E2E2E302E313001-3003303D30FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFE10-FE16FE19FE30FE45FE46FE49-FE4CFE50-FE52FE54-FE57FE5F-FE61FE68FE6AFE6BFF01-FF03FF05-FF07FF0AFF0CFF0EFF0FFF1AFF1BFF1FFF20FF3CFF61FF64FF65",S:"0024002B003C-003E005E0060007C007E00A2-00A900AC00AE-00B100B400B600B800D700F702C2-02C502D2-02DF02E5-02EB02ED02EF-02FF03750384038503F604820606-0608060B060E060F06E906FD06FE07F609F209F309FA09FB0AF10B700BF3-0BFA0C7F0CF10CF20D790E3F0F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-139917DB194019E0-19FF1B61-1B6A1B74-1B7C1FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE20442052207A-207C208A-208C20A0-20B8210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B2140-2144214A-214D214F2190-2328232B-23E82400-24262440-244A249C-24E92500-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE27C0-27C427C7-27CA27CC27D0-27E527F0-29822999-29D729DC-29FB29FE-2B4C2B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F309B309C319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A700-A716A720A721A789A78AA828-A82BA836-A839AA77-AA79FB29FDFCFDFDFE62FE64-FE66FE69FF04FF0BFF1C-FF1EFF3EFF40FF5CFF5EFFE0-FFE6FFE8-FFEEFFFCFFFD",Sm:"002B003C-003E007C007E00AC00B100D700F703F60606-060820442052207A-207C208A-208C2140-2144214B2190-2194219A219B21A021A321A621AE21CE21CF21D221D421F4-22FF2308-230B23202321237C239B-23B323DC-23E125B725C125F8-25FF266F27C0-27C427C7-27CA27CC27D0-27E527F0-27FF2900-29822999-29D729DC-29FB29FE-2AFF2B30-2B442B47-2B4CFB29FE62FE64-FE66FF0BFF1C-FF1EFF5CFF5EFFE2FFE9-FFEC",Sc:"002400A2-00A5060B09F209F309FB0AF10BF90E3F17DB20A0-20B8A838FDFCFE69FF04FFE0FFE1FFE5FFE6",Sk:"005E006000A800AF00B400B802C2-02C502D2-02DF02E5-02EB02ED02EF-02FF0375038403851FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE309B309CA700-A716A720A721A789A78AFF3EFF40FFE3",So:"00A600A700A900AE00B000B60482060E060F06E906FD06FE07F609FA0B700BF3-0BF80BFA0C7F0CF10CF20D790F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-1399194019E0-19FF1B61-1B6A1B74-1B7C210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B214A214C214D214F2195-2199219C-219F21A121A221A421A521A7-21AD21AF-21CD21D021D121D321D5-21F32300-2307230C-231F2322-2328232B-237B237D-239A23B4-23DB23E2-23E82400-24262440-244A249C-24E92500-25B625B8-25C025C2-25F72600-266E2670-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE2800-28FF2B00-2B2F2B452B462B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A828-A82BA836A837A839AA77-AA79FDFDFFE4FFE8FFEDFFEEFFFCFFFD",Z:"002000A01680180E2000-200A20282029202F205F3000",Zs:"002000A01680180E2000-200A202F205F3000",Zl:"2028",Zp:"2029",C:"0000-001F007F-009F00AD03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-0605061C061D0620065F06DD070E070F074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17B417B517DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF200B-200F202A-202E2060-206F20722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-F8FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFD-FF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFFBFFFEFFFF",Cc:"0000-001F007F-009F",Cf:"00AD0600-060306DD070F17B417B5200B-200F202A-202E2060-2064206A-206FFEFFFFF9-FFFB",Co:"E000-F8FF",Cs:"D800-DFFF",Cn:"03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-05FF06040605061C061D0620065F070E074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF2065-206920722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-D7FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFDFEFEFF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFF8FFFEFFFF"})}),ace.define("ace/mode/text",["require","exports","module","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(e,t,i){"use strict";var n=e("../tokenizer").Tokenizer,r=e("./text_highlight_rules").TextHighlightRules,o=e("./behaviour/cstyle").CstyleBehaviour,s=e("../unicode"),a=e("../lib/lang"),l=e("../token_iterator").TokenIterator,c=e("../range").Range,h=function(){this.HighlightRules=r};(function(){this.$defaultBehaviour=new o,this.tokenRe=new RegExp("^["+s.packages.L+s.packages.Mn+s.packages.Mc+s.packages.Nd+s.packages.Pc+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+s.packages.L+s.packages.Mn+s.packages.Mc+s.packages.Nd+s.packages.Pc+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new n(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,t,i,n){function r(e){for(var t=i;t<=n;t++)e(o.getLine(t),t)}var o=t.doc,s=!0,l=!0,c=1/0,h=t.getTabSize(),d=!1;if(this.lineCommentStart){if(Array.isArray(this.lineCommentStart))var u=this.lineCommentStart.map(a.escapeRegExp).join("|"),f=this.lineCommentStart[0];else var u=a.escapeRegExp(this.lineCommentStart),f=this.lineCommentStart;u=new RegExp("^(\\s*)(?:"+u+") ?"),d=t.getUseSoftTabs();var p=function(e,t){var i=e.match(u);if(i){var n=i[1].length,r=i[0].length;y(e,n,r)||" "!=i[0][r-1]||r--,o.removeInLine(t,n,r)}},m=f+" ",g=function(e,t){s&&!/\S/.test(e)||(y(e,c,c)?o.insertInLine({row:t,column:c},m):o.insertInLine({row:t,column:c},f))},v=function(e,t){return u.test(e)},y=function(e,t,i){for(var n=0;t--&&" "==e.charAt(t);)n++;if(n%h!=0)return!1;for(var n=0;" "==e.charAt(i++);)n++;return h>2?n%h!=h-1:n%h==0}}else{if(!this.blockComment)return!1;var f=this.blockComment.start,w=this.blockComment.end,u=new RegExp("^(\\s*)(?:"+a.escapeRegExp(f)+")"),b=new RegExp("(?:"+a.escapeRegExp(w)+")\\s*$"),g=function(e,t){v(e,t)||s&&!/\S/.test(e)||(o.insertInLine({row:t,column:e.length},w),o.insertInLine({row:t,column:c},f))},p=function(e,t){var i;(i=e.match(b))&&o.removeInLine(t,e.length-i[0].length,e.length),(i=e.match(u))&&o.removeInLine(t,i[1].length,i[0].length)},v=function(e,i){if(u.test(e))return!0;for(var n=t.getTokens(i),r=0;r<n.length;r++)if("comment"===n[r].type)return!0}}var C=1/0;r(function(e,t){var i=e.search(/\S/);-1!==i?(i<c&&(c=i),l&&!v(e,t)&&(l=!1)):C>e.length&&(C=e.length)}),c==1/0&&(c=C,s=!1,l=!1),d&&c%h!=0&&(c=Math.floor(c/h)*h),r(l?p:g)},this.toggleBlockComment=function(e,t,i,n){var r=this.blockComment;if(r){!r.start&&r[0]&&(r=r[0]);var o,s,a=new l(t,n.row,n.column),h=a.getCurrentToken(),d=(t.selection,t.selection.toOrientedRange());if(h&&/comment/.test(h.type)){for(var u,f;h&&/comment/.test(h.type);){var p=h.value.indexOf(r.start);if(-1!=p){var m=a.getCurrentTokenRow(),g=a.getCurrentTokenColumn()+p;u=new c(m,g,m,g+r.start.length);break}h=a.stepBackward()}for(var a=new l(t,n.row,n.column),h=a.getCurrentToken();h&&/comment/.test(h.type);){var p=h.value.indexOf(r.end);if(-1!=p){var m=a.getCurrentTokenRow(),g=a.getCurrentTokenColumn()+p;f=new c(m,g,m,g+r.end.length);break}h=a.stepForward()}f&&t.remove(f),u&&(t.remove(u),o=u.start.row,s=-r.start.length)}else s=r.start.length,o=i.start.row,t.insert(i.end,r.end),t.insert(i.start,r.start);d.start.row==o&&(d.start.column+=s),d.end.row==o&&(d.end.column+=s),t.selection.fromOrientedRange(d)}},this.getNextLineIndent=function(e,t,i){return this.$getIndent(t)},this.checkOutdent=function(e,t,i){return!1},this.autoOutdent=function(e,t,i){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){this.$embeds=[],this.$modes={};for(var t in e)e[t]&&(this.$embeds.push(t),this.$modes[t]=new e[t]);for(var i=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],t=0;t<i.length;t++)!function(e){var n=i[t],r=e[n];e[i[t]]=function(){return this.$delegator(n,arguments,r)}}(this)},this.$delegator=function(e,t,i){var n=t[0];"string"!=typeof n&&(n=n[0]);for(var r=0;r<this.$embeds.length;r++)if(this.$modes[this.$embeds[r]]){var o=n.split(this.$embeds[r]);if(!o[0]&&o[1]){t[0]=o[1];var s=this.$modes[this.$embeds[r]];return s[e].apply(s,t)}}var a=i.apply(this,t);return i?a:void 0},this.transformAction=function(e,t,i,n,r){if(this.$behaviour){var o=this.$behaviour.getBehaviours();for(var s in o)if(o[s][t]){var a=o[s][t].apply(this,arguments);if(a)return a}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,i=[];for(var n in t)for(var r=t[n],o=0,s=r.length;o<s;o++)if("string"==typeof r[o].token)/keyword|support|storage/.test(r[o].token)&&i.push(r[o].regex);else if("object"==typeof r[o].token)for(var a=0,l=r[o].token.length;a<l;a++)if(/keyword|support|storage/.test(r[o].token[a])){var n=r[o].regex.match(/\(.+?\)/g)[a];i.push(n.substr(1,n.length-2))}this.completionKeywords=i}return e?i.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,i,n){return(this.$keywordList||this.$createKeywordList()).map(function(e){return{name:e,value:e,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(h.prototype),t.Mode=h}),ace.define("ace/apply_delta",["require","exports","module"],function(e,t,i){"use strict";t.applyDelta=function(e,t,i){var n=t.start.row,r=t.start.column,o=e[n]||"";switch(t.action){case"insert":if(1===t.lines.length)e[n]=o.substring(0,r)+t.lines[0]+o.substring(r);else{var s=[n,1].concat(t.lines);e.splice.apply(e,s),e[n]=o.substring(0,r)+e[n],e[n+t.lines.length-1]+=o.substring(r)}break;case"remove":var a=t.end.column,l=t.end.row;n===l?e[n]=o.substring(0,r)+o.substring(a):e.splice(n,l-n+1,o.substring(0,r)+e[l].substring(a))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,o=t.Anchor=function(e,t,i){
this.$onChange=this.onChange.bind(this),this.attach(e),void 0===i?this.setPosition(t.row,t.column):this.setPosition(t,i)};(function(){function e(e,t,i){var n=i?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&n}function t(t,i,n){var r="insert"==t.action,o=(r?1:-1)*(t.end.row-t.start.row),s=(r?1:-1)*(t.end.column-t.start.column),a=t.start,l=r?a:t.end;return e(i,a,n)?{row:i.row,column:i.column}:e(l,i,!n)?{row:i.row+o,column:i.column+(i.row==l.row?s:0)}:{row:a.row,column:a.column}}n.implement(this,r),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(e){if(!(e.start.row==e.end.row&&e.start.row!=this.row||e.start.row>this.row)){var i=t(e,{row:this.row,column:this.column},this.$insertRight);this.setPosition(i.row,i.column,!0)}},this.setPosition=function(e,t,i){var n;if(n=i?{row:e,column:t}:this.$clipPositionToDocument(e,t),this.row!=n.row||this.column!=n.column){var r={row:this.row,column:this.column};this.row=n.row,this.column=n.column,this._signal("change",{old:r,value:n})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var i={};return e>=this.document.getLength()?(i.row=Math.max(0,this.document.getLength()-1),i.column=this.document.getLine(i.row).length):e<0?(i.row=0,i.column=0):(i.row=e,i.column=Math.min(this.document.getLine(i.row).length,Math.max(0,t))),t<0&&(i.column=0),i}}).call(o.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./apply_delta").applyDelta,o=e("./lib/event_emitter").EventEmitter,s=e("./range").Range,a=e("./anchor").Anchor,l=function(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)};(function(){n.implement(this,o),this.setValue=function(e){var t=this.getLength()-1;this.remove(new s(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new a(this,e,t)},0==="aaa".split(/a/).length?this.$split=function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=t?t[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},this.getLinesForRange=function(e){var t;if(e.start.row===e.end.row)t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)];else{t=this.getLines(e.start.row,e.end.row),t[0]=(t[0]||"").substring(e.start.column);var i=t.length-1;e.end.row-e.start.row==i&&(t[i]=t[i].substring(0,e.end.column))}return t},this.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},this.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},this.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},this.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},this.insertInLine=function(e,t){var i=this.clippedPos(e.row,e.column),n=this.pos(e.row,e.column+t.length);return this.applyDelta({start:i,end:n,action:"insert",lines:[t]},!0),this.clonePos(n)},this.clippedPos=function(e,t){var i=this.getLength();void 0===e?e=i:e<0?e=0:e>=i&&(e=i-1,t=void 0);var n=this.getLine(e);return void 0==t&&(t=n.length),t=Math.min(Math.max(t,0),n.length),{row:e,column:t}},this.clonePos=function(e){return{row:e.row,column:e.column}},this.pos=function(e,t){return{row:e,column:t}},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},this.insertFullLines=function(e,t){e=Math.min(Math.max(e,0),this.getLength());var i=0;e<this.getLength()?(t=t.concat([""]),i=0):(t=[""].concat(t),e--,i=this.$lines[e].length),this.insertMergedLines({row:e,column:i},t)},this.insertMergedLines=function(e,t){var i=this.clippedPos(e.row,e.column),n={row:i.row+t.length-1,column:(1==t.length?i.column:0)+t[t.length-1].length};return this.applyDelta({start:i,end:n,action:"insert",lines:t}),this.clonePos(n)},this.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),i=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:i,action:"remove",lines:this.getLinesForRange({start:t,end:i})}),this.clonePos(t)},this.removeInLine=function(e,t,i){var n=this.clippedPos(e,t),r=this.clippedPos(e,i);return this.applyDelta({start:n,end:r,action:"remove",lines:this.getLinesForRange({start:n,end:r})},!0),this.clonePos(n)},this.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1),t=Math.min(Math.max(0,t),this.getLength()-1);var i=t==this.getLength()-1&&e>0,n=t<this.getLength()-1,r=i?e-1:e,o=i?this.getLine(r).length:0,a=n?t+1:t,l=n?0:this.getLine(a).length,c=new s(r,o,a,l),h=this.$lines.slice(e,t+1);return this.applyDelta({start:c.start,end:c.end,action:"remove",lines:this.getLinesForRange(c)}),h},this.removeNewLine=function(e){e<this.getLength()-1&&e>=0&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},this.replace=function(e,t){if(e instanceof s||(e=s.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty())return e.start;if(t==this.getTextRange(e))return e.end;this.remove(e);return t?this.insert(e.start,t):e.start},this.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},this.revertDeltas=function(e){for(var t=e.length-1;t>=0;t--)this.revertDelta(e[t])},this.applyDelta=function(e,t){var i="insert"==e.action;(i?e.lines.length<=1&&!e.lines[0]:!s.comparePoints(e.start,e.end))||(i&&e.lines.length>2e4&&this.$splitAndapplyLargeDelta(e,2e4),r(this.$lines,e,t),this._signal("change",e))},this.$splitAndapplyLargeDelta=function(e,t){for(var i=e.lines,n=i.length,r=e.start.row,o=e.start.column,s=0,a=0;;){s=a,a+=t-1;var l=i.slice(s,a);if(a>n){e.lines=l,e.start.row=r+s,e.start.column=o;break}l.push(""),this.applyDelta({start:this.pos(r+s,o),end:this.pos(r+a,o=0),action:e.action,lines:l},!0)}},this.revertDelta=function(e){this.applyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},this.indexToPosition=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=t||0,o=i.length;r<o;r++)if((e-=i[r].length+n)<0)return{row:r,column:e+i[r].length+n};return{row:o-1,column:i[o-1].length}},this.positionToIndex=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=0,o=Math.min(e.row,i.length),s=t||0;s<o;++s)r+=i[s].length+n;return r+e.column}}).call(l.prototype),t.Document=l}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,o=function(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var i=this;this.$worker=function(){if(i.running){for(var e=new Date,t=i.currentLine,n=-1,r=i.doc,o=t;i.lines[t];)t++;var s=r.getLength(),a=0;for(i.running=!1;t<s;){i.$tokenizeRow(t),n=t;do{t++}while(i.lines[t]);if(++a%5==0&&new Date-e>20){i.running=setTimeout(i.$worker,20);break}}i.currentLine=t,-1==n&&(n=t),o<=n&&i.fireUpdateEvent(o,n)}}};(function(){n.implement(this,r),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){var i={first:e,last:t};this._signal("update",{data:i})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t=e.start.row,i=e.end.row-t;if(0===i)this.lines[t]=null;else if("remove"==e.action)this.lines.splice(t,i+1,null),this.states.splice(t,i+1,null);else{var n=Array(i+1);n.unshift(t,1),this.lines.splice.apply(this.lines,n),this.states.splice.apply(this.states,n)}this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),i=this.states[e-1],n=this.tokenizer.getLineTokens(t,i,e);return this.states[e]+""!=n.state+""?(this.states[e]=n.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=n.tokens}}).call(o.prototype),t.BackgroundTokenizer=o}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";var n=e("./lib/lang"),r=(e("./lib/oop"),e("./range").Range),o=function(e,t,i){this.setRegexp(e),this.clazz=t,this.type=i||"text"};(function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,i,o){if(this.regExp)for(var s=o.firstRow,a=o.lastRow,l=s;l<=a;l++){var c=this.cache[l];null==c&&(c=n.getMatchOffsets(i.getLine(l),this.regExp),c.length>this.MAX_RANGES&&(c=c.slice(0,this.MAX_RANGES)),c=c.map(function(e){return new r(l,e.offset,l,e.offset+e.length)}),this.cache[l]=c.length?c:"");for(var h=c.length;h--;)t.drawSingleLineMarker(e,c[h].toScreenRange(i),this.clazz,o)}}}).call(o.prototype),t.SearchHighlight=o}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];var i=t[t.length-1];this.range=new r(t[0].start.row,t[0].start.column,i.end.row,i.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(e){e.setFoldLine(this)},this)}var r=e("../range").Range;(function(){this.shiftRow=function(e){this.start.row+=e,this.end.row+=e,this.folds.forEach(function(t){t.start.row+=e,t.end.row+=e})},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort(function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)}),this.range.compareEnd(e.start.row,e.start.column)>0?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,i){var n,r,o,s=0,a=this.folds,l=!0;null==t&&(t=this.end.row,i=this.end.column);for(var c=0;c<a.length;c++){if(n=a[c],-1==(r=n.range.compareStart(t,i)))return void e(null,t,i,s,l);if(o=e(null,n.start.row,n.start.column,s,l),(o=!o&&e(n.placeholder,n.start.row,n.start.column,s))||0===r)return;l=!n.sameRow,s=n.end.column}e(null,t,i,s,l)},this.getNextFoldTo=function(e,t){for(var i,n,r=0;r<this.folds.length;r++){if(i=this.folds[r],-1==(n=i.range.compareEnd(e,t)))return{fold:i,kind:"after"};if(0===n)return{fold:i,kind:"inside"}}return null},this.addRemoveChars=function(e,t,i){var n,r,o=this.getNextFoldTo(e,t);if(o)if(n=o.fold,"inside"==o.kind&&n.start.column!=t&&n.start.row!=e)window.console&&window.console.log(e,t,n);else if(n.start.row==e){r=this.folds;var s=r.indexOf(n);for(0===s&&(this.start.column+=i),s;s<r.length;s++){if(n=r[s],n.start.column+=i,!n.sameRow)return;n.end.column+=i}this.end.column+=i}},this.split=function(e,t){var i=this.getNextFoldTo(e,t);if(!i||"inside"==i.kind)return null;var r=i.fold,o=this.folds,s=this.foldData,a=o.indexOf(r),l=o[a-1];this.end.row=l.end.row,this.end.column=l.end.column,o=o.splice(a,o.length-a);var c=new n(s,o);return s.splice(s.indexOf(this)+1,0,c),c},this.merge=function(e){for(var t=e.folds,i=0;i<t.length;i++)this.addFold(t[i]);var n=this.foldData;n.splice(n.indexOf(e),1)},this.toString=function(){var e=[this.range.toString()+": ["];return this.folds.forEach(function(t){e.push("  "+t.toString())}),e.push("]"),e.join("\n")},this.idxToPosition=function(e){for(var t=0,i=0;i<this.folds.length;i++){var n=this.folds[i];if((e-=n.start.column-t)<0)return{row:n.start.row,column:n.start.column+e};if((e-=n.placeholder.length)<0)return n.start;t=n.end.column}return{row:this.end.row,column:this.end.column+e}}}).call(n.prototype),t.FoldLine=n}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("./range").Range,r=n.comparePoints,o=function(){this.ranges=[]};(function(){this.comparePoints=r,this.pointIndex=function(e,t,i){for(var n=this.ranges,o=i||0;o<n.length;o++){var s=n[o],a=r(e,s.end);if(!(a>0)){var l=r(e,s.start);return 0===a?t&&0!==l?-o-2:o:l>0||0===l&&!t?o:-o-1}}return-o-1},this.add=function(e){var t=!e.isEmpty(),i=this.pointIndex(e.start,t);i<0&&(i=-i-1);var n=this.pointIndex(e.end,t,i);return n<0?n=-n-1:n++,this.ranges.splice(i,n-i,e)},this.addList=function(e){for(var t=[],i=e.length;i--;)t.push.apply(t,this.add(e[i]));return t},this.substractPoint=function(e){var t=this.pointIndex(e);if(t>=0)return this.ranges.splice(t,1)},this.merge=function(){var e=[],t=this.ranges;t=t.sort(function(e,t){return r(e.start,t.start)});for(var i,n=t[0],o=1;o<t.length;o++){i=n,n=t[o];var s=r(i.end,n.start);s<0||(0!=s||i.isEmpty()||n.isEmpty())&&(r(i.end,n.end)<0&&(i.end.row=n.end.row,i.end.column=n.end.column),t.splice(o,1),e.push(n),n=i,o--)}return this.ranges=t,e},this.contains=function(e,t){return this.pointIndex({row:e,column:t})>=0},this.containsPoint=function(e){return this.pointIndex(e)>=0},this.rangeAtPoint=function(e){var t=this.pointIndex(e);if(t>=0)return this.ranges[t]},this.clipRows=function(e,t){var i=this.ranges;if(i[0].start.row>t||i[i.length-1].start.row<e)return[];var n=this.pointIndex({row:e,column:0});n<0&&(n=-n-1);var r=this.pointIndex({row:t,column:0},n);r<0&&(r=-r-1);for(var o=[],s=n;s<r;s++)o.push(i[s]);return o},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(e){if("insert"==e.action)var t=e.start,i=e.end;else var i=e.start,t=e.end;for(var n=t.row,r=i.row,o=r-n,s=-t.column+i.column,a=this.ranges,l=0,c=a.length;l<c;l++){var h=a[l];if(!(h.end.row<n)){if(h.start.row>n)break;if(h.start.row==n&&h.start.column>=t.column&&(h.start.column==t.column&&this.$insertRight||(h.start.column+=s,h.start.row+=o)),h.end.row==n&&h.end.column>=t.column){if(h.end.column==t.column&&this.$insertRight)continue;h.end.column==t.column&&s>0&&l<c-1&&h.end.column>h.start.column&&h.end.column==a[l+1].start.column&&(h.end.column-=s),h.end.column+=s,h.end.row+=o}}}if(0!=o&&l<c)for(;l<c;l++){var h=a[l];h.start.row+=o,h.end.row+=o}}}).call(o.prototype),t.RangeList=o}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range","ace/range_list","ace/lib/oop"],function(e,t,i){"use strict";function n(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function r(e,t){n(e.start,t),n(e.end,t)}function o(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}function s(e,t){o(e.start,t),o(e.end,t)}var a=(e("../range").Range,e("../range_list").RangeList),l=e("../lib/oop"),c=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};l.inherits(c,a),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(e){this.foldLine=e,this.subFolds.forEach(function(t){t.setFoldLine(e)})},this.clone=function(){var e=this.range.clone(),t=new c(e,this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){if(!this.range.containsRange(e))throw new Error("A fold can't intersect already existing fold"+e.range+this.range);r(e,this.start);for(var t=e.start.row,i=e.start.column,n=0,o=-1;n<this.subFolds.length&&1==(o=this.subFolds[n].range.compare(t,i));n++);var s=this.subFolds[n];if(0==o)return s.addSubFold(e);for(var t=e.range.end.row,i=e.range.end.column,a=n,o=-1;a<this.subFolds.length&&1==(o=this.subFolds[a].range.compare(t,i));a++);this.subFolds[a];if(0==o)throw new Error("A fold can't intersect already existing fold"+e.range+this.range);this.subFolds.splice(n,a-n,e);return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return s(e,this.start)}}.call(c.prototype)}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],function(e,t,i){"use strict";function n(){this.getFoldAt=function(e,t,i){var n=this.getFoldLine(e);if(!n)return null;for(var r=n.folds,o=0;o<r.length;o++){var s=r[o];if(s.range.contains(e,t)){if(1==i&&s.range.isEnd(e,t))continue;if(-1==i&&s.range.isStart(e,t))continue;return s}}},this.getFoldsInRange=function(e){var t=e.start,i=e.end,n=this.$foldData,r=[];t.column+=1,i.column-=1;for(var o=0;o<n.length;o++){var s=n[o].range.compareRange(e);if(2!=s){if(-2==s)break;for(var a=n[o].folds,l=0;l<a.length;l++){var c=a[l];if(-2==(s=c.range.compareRange(e)))break;if(2!=s){if(42==s)break;r.push(c)}}}}return t.column-=1,i.column+=1,r},this.getFoldsInRangeList=function(e){if(Array.isArray(e)){var t=[];e.forEach(function(e){t=t.concat(this.getFoldsInRange(e))},this)}else var t=this.getFoldsInRange(e);return t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,i=0;i<t.length;i++)for(var n=0;n<t[i].folds.length;n++)e.push(t[i].folds[n]);return e},this.getFoldStringAt=function(e,t,i,n){if(!(n=n||this.getFoldLine(e)))return null;for(var r,o,s={end:{column:0}},a=0;a<n.folds.length;a++){o=n.folds[a];var l=o.range.compareEnd(e,t);if(-1==l){r=this.getLine(o.start.row).substring(s.end.column,o.start.column);break}if(0===l)return null;s=o}return r||(r=this.getLine(o.start.row).substring(s.end.column)),-1==i?r.substring(0,t-s.end.column):1==i?r.substring(t-s.end.column):r},this.getFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0),n;n<i.length;n++){var r=i[n];if(r.start.row<=e&&r.end.row>=e)return r;if(r.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0),n;n<i.length;n++){var r=i[n];if(r.end.row>=e)return r}return null},this.getFoldedRowCount=function(e,t){for(var i=this.$foldData,n=t-e+1,r=0;r<i.length;r++){var o=i[r],s=o.end.row,a=o.start.row;if(s>=t){a<t&&(a>=e?n-=t-a:n=0);break}s>=e&&(n-=a>=e?s-a:s-e+1)}return n},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort(function(e,t){return e.start.row-t.start.row}),e},this.addFold=function(e,t){var i,n=this.$foldData,r=!1;e instanceof s?i=e:(i=new s(t,e),i.collapseChildren=t.collapseChildren),this.$clipRangeToDocument(i.range);var a=i.start.row,l=i.start.column,c=i.end.row,h=i.end.column;if(!(a<c||a==c&&l<=h-2))throw new Error("The range has to be at least 2 characters width");var d=this.getFoldAt(a,l,1),u=this.getFoldAt(c,h,-1);if(d&&u==d)return d.addSubFold(i);d&&!d.range.isStart(a,l)&&this.removeFold(d),u&&!u.range.isEnd(c,h)&&this.removeFold(u);var f=this.getFoldsInRange(i.range);f.length>0&&(this.removeFolds(f),f.forEach(function(e){i.addSubFold(e)}));for(var p=0;p<n.length;p++){var m=n[p];if(c==m.start.row){m.addFold(i),r=!0;break}if(a==m.end.row){if(m.addFold(i),r=!0,!i.sameRow){var g=n[p+1];if(g&&g.start.row==c){m.merge(g);break}}break}if(c<=m.start.row)break}return r||(m=this.$addFoldLine(new o(this.$foldData,i))),this.$useWrapMode?this.$updateWrapData(m.start.row,m.start.row):this.$updateRowLengthCache(m.start.row,m.start.row),this.$modified=!0,this._signal("changeFold",{data:i,action:"add"}),i},this.addFolds=function(e){e.forEach(function(e){this.addFold(e)},this)},this.removeFold=function(e){var t=e.foldLine,i=t.start.row,n=t.end.row,r=this.$foldData,o=t.folds;if(1==o.length)r.splice(r.indexOf(t),1);else if(t.range.isEnd(e.end.row,e.end.column))o.pop(),t.end.row=o[o.length-1].end.row,t.end.column=o[o.length-1].end.column;else if(t.range.isStart(e.start.row,e.start.column))o.shift(),t.start.row=o[0].start.row,t.start.column=o[0].start.column;else if(e.sameRow)o.splice(o.indexOf(e),1);else{var s=t.split(e.start.row,e.start.column);o=s.folds,o.shift(),s.start.row=o[0].start.row,s.start.column=o[0].start.column}this.$updating||(this.$useWrapMode?this.$updateWrapData(i,n):this.$updateRowLengthCache(i,n)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],i=0;i<e.length;i++)t.push(e[i]);t.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(e){this.removeFold(e),e.subFolds.forEach(function(t){e.restoreRange(t),this.addFold(t)},this),e.collapseChildren>0&&this.foldAll(e.start.row+1,e.end.row,e.collapseChildren-1),e.subFolds=[]},this.expandFolds=function(e){e.forEach(function(e){this.expandFold(e)},this)},this.unfold=function(e,t){var i,n;if(null==e?(i=new r(0,0,this.getLength(),0),t=!0):i="number"==typeof e?new r(e,0,e,this.getLine(e).length):"row"in e?r.fromPoints(e,e):e,n=this.getFoldsInRangeList(i),t)this.removeFolds(n);else for(var o=n;o.length;)this.expandFolds(o),o=this.getFoldsInRangeList(i);if(n.length)return n},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){var i=this.getFoldLine(e,t);return i?i.end.row:e},this.getRowFoldStart=function(e,t){var i=this.getFoldLine(e,t);return i?i.start.row:e},this.getFoldDisplayLine=function(e,t,i,n,r){null==n&&(n=e.start.row),null==r&&(r=0),null==t&&(t=e.end.row),null==i&&(i=this.getLine(t).length);var o=this.doc,s="";return e.walk(function(e,t,i,a){if(!(t<n)){if(t==n){if(i<r)return;a=Math.max(r,a)}s+=null!=e?e:o.getLine(t).substring(a,i)}},t,i),s},this.getDisplayLine=function(e,t,i,n){var r=this.getFoldLine(e);if(r)return this.getFoldDisplayLine(r,e,t,i,n);var o;return o=this.doc.getLine(e),o.substring(n||0,t||o.length)},this.$cloneFoldData=function(){var e=[];return e=this.$foldData.map(function(t){var i=t.folds.map(function(e){return e.clone()});return new o(e,i)})},this.toggleFold=function(e){var t,i,n=this.selection,r=n.getRange();if(r.isEmpty()){var o=r.start;if(t=this.getFoldAt(o.row,o.column))return void this.expandFold(t);(i=this.findMatchingBracket(o))?1==r.comparePoint(i)?r.end=i:(r.start=i,r.start.column++,r.end.column--):(i=this.findMatchingBracket({row:o.row,column:o.column+1}))?(1==r.comparePoint(i)?r.end=i:r.start=i,r.start.column++):r=this.getCommentFoldRange(o.row,o.column)||r}else{var s=this.getFoldsInRange(r);if(e&&s.length)return void this.expandFolds(s);1==s.length&&(t=s[0])}if(t||(t=this.getFoldAt(r.start.row,r.start.column)),t&&t.range.toString()==r.toString())return void this.expandFold(t);var a="...";if(!r.isMultiLine()){if(a=this.getTextRange(r),a.length<4)return;a=a.trim().substring(0,2)+".."}this.addFold(a,r)},this.getCommentFoldRange=function(e,t,i){var n=new a(this,e,t),o=n.getCurrentToken(),s=o.type;if(o&&/^comment|string/.test(s)){s=s.match(/comment|string/)[0],"comment"==s&&(s+="|doc-start");var l=new RegExp(s),c=new r;if(1!=i){do{o=n.stepBackward()}while(o&&l.test(o.type));n.stepForward()}if(c.start.row=n.getCurrentTokenRow(),c.start.column=n.getCurrentTokenColumn()+2,n=new a(this,e,t),-1!=i){var h=-1;do{if(o=n.stepForward(),-1==h){var d=this.getState(n.$row);l.test(d)||(h=n.$row)}else if(n.$row>h)break}while(o&&l.test(o.type));o=n.stepBackward()}else o=n.getCurrentToken();return c.end.row=n.getCurrentTokenRow(),c.end.column=n.getCurrentTokenColumn()+o.value.length-2,c}},this.foldAll=function(e,t,i){void 0==i&&(i=1e5);var n=this.foldWidgets;if(n){t=t||this.getLength(),e=e||0;for(var r=e;r<t;r++)if(null==n[r]&&(n[r]=this.getFoldWidget(r)),"start"==n[r]){var o=this.getFoldWidgetRange(r);if(o&&o.isMultiLine()&&o.end.row<=t&&o.start.row>=e){r=o.end.row;try{var s=this.addFold("...",o);s&&(s.collapseChildren=i)}catch(e){}}}}},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");if(this.$foldStyle!=e){this.$foldStyle=e,"manual"==e&&this.unfold();var t=this.$foldMode;this.$setFolding(null),this.$setFolding(t)}},this.$setFolding=function(e){if(this.$foldMode!=e){if(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),!e||"manual"==this.$foldStyle)return void(this.foldWidgets=null);this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)}},this.getParentFoldRangeData=function(e,t){var i=this.foldWidgets;if(!i||t&&i[e])return{};for(var n,r=e-1;r>=0;){var o=i[r];if(null==o&&(o=i[r]=this.getFoldWidget(r)),"start"==o){var s=this.getFoldWidgetRange(r);if(n||(n=s),s&&s.end.row>=e)break}r--}return{range:-1!==r&&s,firstRange:n}},this.onFoldWidgetClick=function(e,t){t=t.domEvent;var i={children:t.shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};if(!this.$toggleFoldWidget(e,i)){var n=t.target||t.srcElement;n&&/ace_fold-widget/.test(n.className)&&(n.className+=" ace_invalid")}},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var i=this.getFoldWidget(e),n=this.getLine(e),r="end"===i?-1:1,o=this.getFoldAt(e,-1===r?0:n.length,r);if(o)return t.children||t.all?this.removeFold(o):this.expandFold(o),o;var s=this.getFoldWidgetRange(e,!0);if(s&&!s.isMultiLine()&&(o=this.getFoldAt(s.start.row,s.start.column,1))&&s.isEqual(o.range))return this.removeFold(o),o;if(t.siblings){var a=this.getParentFoldRangeData(e);if(a.range)var l=a.range.start.row+1,c=a.range.end.row;this.foldAll(l,c,t.all?1e4:0)}else t.children?(c=s?s.end.row:this.getLength(),this.foldAll(e+1,c,t.all?1e4:0)):s&&(t.all&&(s.collapseChildren=1e4),this.addFold("...",s));return s}},this.toggleFoldWidget=function(e){var t=this.selection.getCursor().row;t=this.getRowFoldStart(t);var i=this.$toggleFoldWidget(t,{});if(!i){var n=this.getParentFoldRangeData(t,!0);if(i=n.range||n.firstRange){t=i.start.row;var r=this.getFoldAt(t,this.getLine(t).length,1);r?this.removeFold(r):this.addFold("...",i)}}},this.updateFoldWidgets=function(e){var t=e.start.row,i=e.end.row-t;if(0===i)this.foldWidgets[t]=null;else if("remove"==e.action)this.foldWidgets.splice(t,i+1,null);else{var n=Array(i+1);n.unshift(t,1),this.foldWidgets.splice.apply(this.foldWidgets,n)}},this.tokenizerUpdateFoldWidgets=function(e){var t=e.data;t.first!=t.last&&this.foldWidgets.length>t.first&&this.foldWidgets.splice(t.first,this.foldWidgets.length)}}var r=e("../range").Range,o=e("./fold_line").FoldLine,s=e("./fold").Fold,a=e("../token_iterator").TokenIterator;t.Folding=n}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(e,t,i){"use strict";function n(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;var i=t||this.getLine(e.row).charAt(e.column-1);if(""==i)return null;var n=i.match(/([\(\[\{])|([\)\]\}])/);return n?n[1]?this.$findClosingBracket(n[1],e):this.$findOpeningBracket(n[2],e):null},this.getBracketRange=function(e){var t,i=this.getLine(e.row),n=!0,r=i.charAt(e.column-1),s=r&&r.match(/([\(\[\{])|([\)\]\}])/);if(s||(r=i.charAt(e.column),e={row:e.row,column:e.column+1},s=r&&r.match(/([\(\[\{])|([\)\]\}])/),n=!1),!s)return null;if(s[1]){var a=this.$findClosingBracket(s[1],e);if(!a)return null;t=o.fromPoints(e,a),n||(t.end.column++,t.start.column--),t.cursor=t.end}else{var a=this.$findOpeningBracket(s[2],e);if(!a)return null;t=o.fromPoints(a,e),n||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{"},this.$findOpeningBracket=function(e,t,i){var n=this.$brackets[e],o=1,s=new r(this,t.row,t.column),a=s.getCurrentToken();if(a||(a=s.stepForward()),a){i||(i=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+"));for(var l=t.column-s.getCurrentTokenColumn()-2,c=a.value;;){for(;l>=0;){var h=c.charAt(l);if(h==n){if(0==(o-=1))return{row:s.getCurrentTokenRow(),column:l+s.getCurrentTokenColumn()}}else h==e&&(o+=1);l-=1}do{a=s.stepBackward()}while(a&&!i.test(a.type));if(null==a)break;c=a.value,l=c.length-1}return null}},this.$findClosingBracket=function(e,t,i){var n=this.$brackets[e],o=1,s=new r(this,t.row,t.column),a=s.getCurrentToken();if(a||(a=s.stepForward()),a){i||(i=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+"));for(var l=t.column-s.getCurrentTokenColumn();;){for(var c=a.value,h=c.length;l<h;){var d=c.charAt(l);if(d==n){if(0==(o-=1))return{row:s.getCurrentTokenRow(),column:l+s.getCurrentTokenColumn()}}else d==e&&(o+=1);l+=1}do{a=s.stepForward()}while(a&&!i.test(a.type));if(null==a)break;l=0}return null}}}var r=e("../token_iterator").TokenIterator,o=e("../range").Range;t.BracketMatch=n}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/lang"),o=e("./bidihandler").BidiHandler,s=e("./config"),a=e("./lib/event_emitter").EventEmitter,l=e("./selection").Selection,c=e("./mode/text").Mode,h=e("./range").Range,d=e("./document").Document,u=e("./background_tokenizer").BackgroundTokenizer,f=e("./search_highlight").SearchHighlight,p=function(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++p.$uid,this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new d(e)),this.$bidiHandler=new o(this),this.setDocument(e),this.selection=new l(this),s.resetOptions(this),this.setMode(t),s._signal("session",this)};p.$uid=0,function(){function e(e){return!(e<4352)&&(e>=4352&&e<=4447||e>=4515&&e<=4519||e>=4602&&e<=4607||e>=9001&&e<=9002||e>=11904&&e<=11929||e>=11931&&e<=12019||e>=12032&&e<=12245||e>=12272&&e<=12283||e>=12288&&e<=12350||e>=12353&&e<=12438||e>=12441&&e<=12543||e>=12549&&e<=12589||e>=12593&&e<=12686||e>=12688&&e<=12730||e>=12736&&e<=12771||e>=12784&&e<=12830||e>=12832&&e<=12871||e>=12880&&e<=13054||e>=13056&&e<=19903||e>=19968&&e<=42124||e>=42128&&e<=42182||e>=43360&&e<=43388||e>=44032&&e<=55203||e>=55216&&e<=55238||e>=55243&&e<=55291||e>=63744&&e<=64255||e>=65040&&e<=65049||e>=65072&&e<=65106||e>=65108&&e<=65126||e>=65128&&e<=65131||e>=65281&&e<=65376||e>=65504&&e<=65510)}n.implement(this,a),this.setDocument=function(e){this.doc&&this.doc.removeListener("change",this.$onChange),this.doc=e,e.on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,i=this.$getRowCacheIndex(this.$docRowCache,e)+1;t>i&&(this.$docRowCache.splice(i,t),this.$screenRowCache.splice(i,t))},this.$getRowCacheIndex=function(e,t){for(var i=0,n=e.length-1;i<=n;){var r=i+n>>1,o=e[r];if(t>o)i=r+1;else{if(!(t<o))return r;n=r-1}}return i-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){var t=e.data;this.$resetRowCache(t.start.row)},this.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);this.$fromUndo||!this.$undoManager||e.ignore||(this.$deltasDoc.push(e),t&&0!=t.length&&this.$deltasFold.push({action:"removeFolds",folds:t}),this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var i,n=this.bgTokenizer.getTokens(e),r=0;if(null==t){var o=n.length-1;r=this.getLine(e).length}else for(var o=0;o<n.length&&!((r+=n[o].value.length)>=t);o++);return(i=n[o])?(i.index=o,i.start=r-i.value.length,i):null},this.setUndoManager=function(e){if(this.$undoManager=e,this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.$informUndoManager&&this.$informUndoManager.cancel(),e){var t=this;this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.$deltasFold.length&&(t.$deltas.push({group:"fold",deltas:t.$deltasFold}),t.$deltasFold=[]),t.$deltasDoc.length&&(t.$deltas.push({group:"doc",deltas:t.$deltasDoc}),t.$deltasDoc=[]),t.$deltas.length>0&&e.execute({action:"aceupdate",args:[t.$deltas,t],merge:t.mergeUndoDeltas}),t.mergeUndoDeltas=!1,t.$deltas=[]},this.$informUndoManager=r.delayedCall(this.$syncInformUndoManager)}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},reset:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?r.stringRepeat(" ",this.getTabSize()):"\t"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){void 0===t&&(t="ace_breakpoint"),t?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,i,n){var r=this.$markerId++,o={range:e,type:i||"line",renderer:"function"==typeof i?i:null,clazz:t,inFront:!!n,id:r};return n?(this.$frontMarkers[r]=o,this._signal("changeFrontMarker")):(this.$backMarkers[r]=o,this._signal("changeBackMarker")),r},this.addDynamicMarker=function(e,t){if(e.update){var i=this.$markerId++;return e.id=i,e.inFront=!!t,t?(this.$frontMarkers[i]=e,this._signal("changeFrontMarker")):(this.$backMarkers[i]=e,this._signal("changeBackMarker")),e}},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];if(t){var i=t.inFront?this.$frontMarkers:this.$backMarkers;t&&(delete i[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))}},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){if(!this.$searchHighlight){var t=new f(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(t)}this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,i,n){"number"!=typeof t&&(i=t,t=e),i||(i="ace_step");var r=new h(e,0,t,1/0);return r.id=this.addMarker(r,i,"fullLine",n),r},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=t?t[1]:"\n"},this.getWordRange=function(e,t){var i=this.getLine(e),n=!1;if(t>0&&(n=!!i.charAt(t-1).match(this.tokenRe)),n||(n=!!i.charAt(t).match(this.tokenRe)),n)var r=this.tokenRe;else if(/^\s+$/.test(i.slice(t-1,t+1)))var r=/\s/;else var r=this.nonTokenRe;var o=t;if(o>0){do{o--}while(o>=0&&i.charAt(o).match(r));o++}for(var s=t;s<i.length&&i.charAt(s).match(r);)s++;return new h(e,o,e,s)},this.getAWordRange=function(e,t){for(var i=this.getWordRange(e,t),n=this.getLine(i.end.row);n.charAt(i.end.column).match(/[ \t]/);)i.end.column+=1;return i},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes={},this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var i=e,n=i.path}else n=e||"ace/mode/text";if(this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new c),this.$modes[n]&&!i)return this.$onChangeMode(this.$modes[n]),void(t&&t());this.$modeId=n,s.loadModule(["mode",n],function(e){if(this.$modeId!==n)return t&&t();this.$modes[n]&&!i?this.$onChangeMode(this.$modes[n]):e&&e.Mode&&(e=new e.Mode(i),i||(this.$modes[n]=e,e.$id=n),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)},this.$onChangeMode=function(e,t){if(t||(this.$modeId=e.$id),this.$mode!==e){this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker();var i=e.getTokenizer();if(void 0!==i.addEventListener){var n=this.onReloadTokenizer.bind(this);i.addEventListener("update",n)}if(this.bgTokenizer)this.bgTokenizer.setTokenizer(i);else{this.bgTokenizer=new u(i);var r=this;this.bgTokenizer.addEventListener("update",function(e){r._signal("tokenizerUpdate",e)})}this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode"))}},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){s.warn("Could not load worker",e),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var e=0;return this.lineWidgets.forEach(function(t){t&&t.screenWidth>e&&(e=t.screenWidth)}),this.lineWidgetWidth=e},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),i=this.$rowLengthCache,n=0,r=0,o=this.$foldData[r],s=o?o.start.row:1/0,a=t.length,l=0;l<a;l++){if(l>s){if((l=o.end.row+1)>=a)break;o=this.$foldData[r++],s=o?o.start.row:1/0}null==i[l]&&(i[l]=this.$getStringScreenWidth(t[l])[0]),i[l]>n&&(n=i[l])}this.screenWidth=n}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=null,n=e.length-1;-1!=n;n--){var r=e[n];"doc"==r.group?(this.doc.revertDeltas(r.deltas),i=this.$getUndoSelection(r.deltas,!0,i)):r.deltas.forEach(function(e){this.addFolds(e.folds)},this)}return this.$fromUndo=!1,i&&this.$undoSelect&&!t&&this.selection.setSelectionRange(i),i}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=null,n=0;n<e.length;n++){var r=e[n];"doc"==r.group&&(this.doc.applyDeltas(r.deltas),i=this.$getUndoSelection(r.deltas,!1,i))}return this.$fromUndo=!1,i&&this.$undoSelect&&!t&&this.selection.setSelectionRange(i),i}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t,i){function n(e){return t?"insert"!==e.action:"insert"===e.action}var r,o,s=e[0];n(s)?r=h.fromPoints(s.start,s.end):r=h.fromPoints(s.start,s.start);for(var a=1;a<e.length;a++)s=e[a],n(s)?(o=s.start,-1==r.compare(o.row,o.column)&&r.setStart(o),o=s.end,1==r.compare(o.row,o.column)&&r.setEnd(o),!0):(o=s.start,-1==r.compare(o.row,o.column)&&(r=h.fromPoints(s.start,s.start)),!1);if(null!=i){0===h.comparePoints(i.start,r.start)&&(i.start.column+=r.end.column-r.start.column,i.end.column+=r.end.column-r.start.column);var l=i.compareRange(r);1==l?r.setStart(i.start):-1==l&&r.setEnd(i.end)}return r},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,i){var n=this.getTextRange(e),r=this.getFoldsInRange(e),o=h.fromPoints(t,t);if(!i){this.remove(e);var s=e.start.row-e.end.row,a=s?-e.end.column:e.start.column-e.end.column;a&&(o.start.row==e.end.row&&o.start.column>e.end.column&&(o.start.column+=a),o.end.row==e.end.row&&o.end.column>e.end.column&&(o.end.column+=a)),s&&o.start.row>=e.end.row&&(o.start.row+=s,o.end.row+=s)}if(o.end=this.insert(o.start,n),r.length){var l=e.start,c=o.start,s=c.row-l.row,a=c.column-l.column;this.addFolds(r.map(function(e){return e=e.clone(),e.start.row==l.row&&(e.start.column+=a),e.end.row==l.row&&(e.end.column+=a),e.start.row+=s,e.end.row+=s,e}))}return o},this.indentRows=function(e,t,i){i=i.replace(/\t/g,this.getTabString());for(var n=e;n<=t;n++)this.doc.insertInLine({row:n,column:0},i)},this.outdentRows=function(e){for(var t=e.collapseRows(),i=new h(0,0,0,0),n=this.getTabSize(),r=t.start.row;r<=t.end.row;++r){var o=this.getLine(r);i.start.row=r,i.end.row=r;for(var s=0;s<n&&" "==o.charAt(s);++s);s<n&&"\t"==o.charAt(s)?(i.start.column=s,i.end.column=s+1):(i.start.column=0,i.end.column=s),this.remove(i)}},this.$moveLines=function(e,t,i){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),i<0){var n=this.getRowFoldStart(e+i);if(n<0)return 0;var r=n-e}else if(i>0){var n=this.getRowFoldEnd(t+i);if(n>this.doc.getLength()-1)return 0;var r=n-t}else{e=this.$clipRowToDocument(e),t=this.$clipRowToDocument(t);var r=t-e+1}var o=new h(e,0,t,Number.MAX_VALUE),s=this.getFoldsInRange(o).map(function(e){return e=e.clone(),e.start.row+=r,e.end.row+=r,e}),a=0==i?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+r,a),s.length&&this.addFolds(s),r},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){if(t=Math.max(0,t),e<0)e=0,t=0;else{var i=this.doc.getLength();e>=i?(e=i-1,t=this.doc.getLine(i-1).length):t=Math.min(this.doc.getLine(e).length,t)}return{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){if(e!=this.$useWrapMode){if(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e){var t=this.getLength();this.$wrapData=Array(t),this.$updateWrapData(0,t-1)}this._signal("changeWrapMode")}},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var i=this.$wrapLimitRange;i.max<0&&(i={min:t,max:t});var n=this.$constrainWrapLimit(e,i.min,i.max);return n!=this.$wrapLimit&&n>1&&(this.$wrapLimit=n,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(e,t,i){return t&&(e=Math.max(t,e)),i&&(e=Math.min(i,e)),e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var t=this.$useWrapMode,i=e.action,n=e.start,r=e.end,o=n.row,s=r.row,a=s-o,l=null;if(this.$updating=!0,0!=a)if("remove"===i){this[t?"$wrapData":"$rowLengthCache"].splice(o,a);var c=this.$foldData;l=this.getFoldsInRange(e),this.removeFolds(l);var h=this.getFoldLine(r.row),d=0;if(h){h.addRemoveChars(r.row,r.column,n.column-r.column),h.shiftRow(-a);var u=this.getFoldLine(o);u&&u!==h&&(u.merge(h),h=u),d=c.indexOf(h)+1}for(d;d<c.length;d++){var h=c[d];h.start.row>=r.row&&h.shiftRow(-a)}s=o}else{var f=Array(a);f.unshift(o,0);var p=t?this.$wrapData:this.$rowLengthCache;p.splice.apply(p,f);var c=this.$foldData,h=this.getFoldLine(o),d=0;if(h){var m=h.range.compareInside(n.row,n.column);0==m?(h=h.split(n.row,n.column))&&(h.shiftRow(a),h.addRemoveChars(s,0,r.column-n.column)):-1==m&&(h.addRemoveChars(o,0,r.column-n.column),h.shiftRow(a)),d=c.indexOf(h)+1}for(d;d<c.length;d++){var h=c[d];h.start.row>=o&&h.shiftRow(a)}}else{a=Math.abs(e.start.column-e.end.column),"remove"===i&&(l=this.getFoldsInRange(e),this.removeFolds(l),a=-a);var h=this.getFoldLine(o);h&&h.addRemoveChars(o,n.column,a)}return t&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,t?this.$updateWrapData(o,s):this.$updateRowLengthCache(o,s),l},this.$updateRowLengthCache=function(e,t,i){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(e,n){var r,o,s=this.doc.getAllLines(),a=this.getTabSize(),l=this.$wrapData,c=this.$wrapLimit,h=e;for(n=Math.min(n,s.length-1);h<=n;)o=this.getFoldLine(h,o),o?(r=[],o.walk(function(e,n,o,a){var l;if(null!=e){l=this.$getDisplayTokens(e,r.length),l[0]=t;for(var c=1;c<l.length;c++)l[c]=i}else l=this.$getDisplayTokens(s[n].substring(a,o),r.length);r=r.concat(l)}.bind(this),o.end.row,s[o.end.row].length+1),l[o.start.row]=this.$computeWrapSplits(r,c,a),h=o.end.row+1):(r=this.$getDisplayTokens(s[h]),l[h]=this.$computeWrapSplits(r,c,a),h++)};var t=3,i=4,o=10,l=11,d=12;this.$computeWrapSplits=function(e,n,r){function s(){var t=0;if(0===g)return t;if(m)for(var i=0;i<e.length;i++){var n=e[i];if(n==o)t+=1;else{if(n!=l){if(n==d)continue;break}t+=r}}return p&&!1!==m&&(t+=r),Math.min(t,g)}function a(t){var i=e.slice(u,t),n=i.length;i.join("").replace(/12/g,function(){n-=1}).replace(/2/g,function(){n-=1}),c.length||(v=s(),c.indent=v),f+=n,c.push(f),u=t}if(0==e.length)return[];for(var c=[],h=e.length,u=0,f=0,p=this.$wrapAsCode,m=this.$indentedSoftWrap,g=n<=Math.max(2*r,8)||!1===m?0:Math.floor(n/2),v=0;h-u>n-v;){var y=u+n-v;if(e[y-1]>=o&&e[y]>=o)a(y);else if(e[y]!=t&&e[y]!=i){for(var w=Math.max(y-(n-(n>>2)),u-1);y>w&&e[y]<t;)y--;if(p){for(;y>w&&e[y]<t;)y--;for(;y>w&&9==e[y];)y--}else for(;y>w&&e[y]<o;)y--;y>w?a(++y):(y=u+n,2==e[y]&&y--,a(y-v))}else{for(y;y!=u-1&&e[y]!=t;y--);if(y>u){a(y);continue}for(y=u+n;y<e.length&&e[y]==i;y++);if(y==e.length)break;a(y)}}return c},this.$getDisplayTokens=function(t,i){var n,r=[];i=i||0;for(var s=0;s<t.length;s++){var a=t.charCodeAt(s);if(9==a){n=this.getScreenTabSize(r.length+i),r.push(l);for(var c=1;c<n;c++)r.push(d)}else 32==a?r.push(o):a>39&&a<48||a>57&&a<64?r.push(9):a>=4352&&e(a)?r.push(1,2):r.push(1)}return r},this.$getStringScreenWidth=function(t,i,n){if(0==i)return[0,0];null==i&&(i=1/0),n=n||0;var r,o;for(o=0;o<t.length&&(r=t.charCodeAt(o),9==r?n+=this.getScreenTabSize(n):r>=4352&&e(r)?n+=2:n+=1,!(n>i));o++);return[n,o]},this.lineWidgets=null,this.getRowLength=function(e){if(this.lineWidgets)var t=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;else t=0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getRowWrapIndent=function(e){if(this.$useWrapMode){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE),i=this.$wrapData[t.row];return i.length&&i[0]<t.column?i.indent:0}return 0},this.getScreenLastRowColumn=function(e){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(t.row,t.column)},this.getDocumentLastRowColumn=function(e,t){var i=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(i)},this.getDocumentLastRowColumnPosition=function(e,t){var i=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(i,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){return this.$useWrapMode?this.$wrapData[e]:void 0},this.getScreenTabSize=function(e){return this.$tabSize-e%this.$tabSize},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,t,i){if(e<0)return{row:0,column:0};var n,r,o=0,s=0,a=0,l=0,c=this.$screenRowCache,h=this.$getRowCacheIndex(c,e),d=c.length;if(d&&h>=0)var a=c[h],o=this.$docRowCache[h],u=e>c[d-1];else var u=!d;for(var f=this.getLength()-1,p=this.getNextFoldLine(o),m=p?p.start.row:1/0;a<=e&&(l=this.getRowLength(o),!(a+l>e||o>=f));)a+=l,++o>m&&(o=p.end.row+1,p=this.getNextFoldLine(o,p),m=p?p.start.row:1/0),u&&(this.$docRowCache.push(o),this.$screenRowCache.push(a));if(p&&p.start.row<=o)n=this.getFoldDisplayLine(p),o=p.start.row;else{if(a+l<=e||o>f)return{row:f,column:this.getLine(f).length};n=this.getLine(o),p=null}var g=0,v=Math.floor(e-a);if(this.$useWrapMode){var y=this.$wrapData[o];y&&(r=y[v],v>0&&y.length&&(g=y.indent,s=y[v-1]||y[y.length-1],n=n.substring(s)))}return void 0!==i&&this.$bidiHandler.isBidiRow(a+v,o,v)&&(t=this.$bidiHandler.offsetToCol(i)),s+=this.$getStringScreenWidth(n,t-g)[1],this.$useWrapMode&&s>=r&&(s=r-1),p?p.idxToPosition(s):{row:o,column:s}},this.documentToScreenPosition=function(e,t){if(void 0===t)var i=this.$clipPositionToDocument(e.row,e.column);else i=this.$clipPositionToDocument(e,t);e=i.row,t=i.column;var n=0,r=null,o=null;(o=this.getFoldAt(e,t,1))&&(e=o.start.row,t=o.start.column);var s,a=0,l=this.$docRowCache,c=this.$getRowCacheIndex(l,e),h=l.length;if(h&&c>=0)var a=l[c],n=this.$screenRowCache[c],d=e>l[h-1];else var d=!h;for(var u=this.getNextFoldLine(a),f=u?u.start.row:1/0;a<e;){if(a>=f){if((s=u.end.row+1)>e)break;u=this.getNextFoldLine(s,u),f=u?u.start.row:1/0}else s=a+1;n+=this.getRowLength(a),a=s,d&&(this.$docRowCache.push(a),this.$screenRowCache.push(n))}var p="";u&&a>=f?(p=this.getFoldDisplayLine(u,e,t),r=u.start.row):(p=this.getLine(e).substring(0,t),r=e);var m=0;if(this.$useWrapMode){var g=this.$wrapData[r];if(g){for(var v=0;p.length>=g[v];)n++,v++;p=p.substring(g[v-1]||0,p.length),m=v>0?g.indent:0}}return{row:n,column:m+this.$getStringScreenWidth(p)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var i=this.$wrapData.length,n=0,r=0,t=this.$foldData[r++],o=t?t.start.row:1/0;n<i;){var s=this.$wrapData[n];e+=s?s.length+1:1,n++,n>o&&(n=t.end.row+1,t=this.$foldData[r++],o=t?t.start.row:1/0)}else{e=this.getLength();for(var a=this.$foldData,r=0;r<a.length;r++)t=a[r],e-=t.end.row-t.start.row}return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(e){this.$enableVarChar&&(this.$getStringScreenWidth=function(t,i,n){if(0===i)return[0,0];i||(i=1/0),n=n||0;var r,o;for(o=0;o<t.length&&(r=t.charAt(o),!((n+="\t"===r?this.getScreenTabSize(n):e.getCharacterWidth(r))>i));o++);return[n,o]})},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker()},this.isFullWidth=e}.call(p.prototype),e("./edit_session/folding").Folding.call(p.prototype),e("./edit_session/bracket_match").BracketMatch.call(p.prototype),s.defineOptions(p.prototype,"session",{wrap:{set:function(e){if(e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e)if(this.$wrap=e,e){var t="number"==typeof e?e:null;this.setWrapLimitRange(t,t),this.setUseWrapMode(!0)}else this.setUseWrapMode(!1)},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$modified=!0,this.$resetRowCache(0),this.$updateWrapData(0,this.getLength()-1)))},initialValue:"auto"},indentedSoftWrap:{initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){isNaN(e)||this.$tabSize===e||(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId}}}),t.EditSession=p}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(e,t){function i(e){return/\w/.test(e)||t.regExp?"\\b":""}return i(e[0])+e+i(e[e.length-1])}var r=e("./lib/lang"),o=e("./lib/oop"),s=e("./range").Range,a=function(){this.$options={}};(function(){this.set=function(e){return o.mixin(this.$options,e),this},this.getOptions=function(){return r.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var t=this.$options,i=this.$matchIterator(e,t);if(!i)return!1;var n=null;return i.forEach(function(e,i,r,o){return n=new s(e,i,r,o),!(i==o&&t.start&&t.start.start&&0!=t.skipCurrent&&n.isEqual(t.start))||(n=null,!1)}),n},this.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var i=t.range,n=i?e.getLines(i.start.row,i.end.row):e.doc.getAllLines(),o=[],a=t.re;if(t.$isMultiLine){var l,c=a.length,h=n.length-c;e:for(var d=a.offset||0;d<=h;d++){for(var u=0;u<c;u++)if(-1==n[d+u].search(a[u]))continue e;var f=n[d],p=n[d+c-1],m=f.length-f.match(a[0])[0].length,g=p.match(a[c-1])[0].length;l&&l.end.row===d&&l.end.column>m||(o.push(l=new s(d,m,d+c-1,g)),c>2&&(d=d+c-2))}}else for(var v=0;v<n.length;v++)for(var y=r.getMatchOffsets(n[v],a),u=0;u<y.length;u++){var w=y[u];o.push(new s(v,w.offset,v,w.offset+w.length))}if(i){for(var b=i.start.column,C=i.start.column,v=0,u=o.length-1;v<u&&o[v].start.column<b&&o[v].start.row==i.start.row;)v++;for(;v<u&&o[u].end.column>C&&o[u].end.row==i.end.row;)u--;for(o=o.slice(v,u+1),v=0,u=o.length;v<u;v++)o[v].start.row+=i.start.row,o[v].end.row+=i.start.row}return o},this.replace=function(e,t){var i=this.$options,n=this.$assembleRegExp(i);if(i.$isMultiLine)return t;if(n){var r=n.exec(e);if(!r||r[0].length!=e.length)return null;if(t=e.replace(n,t),i.preserveCase){t=t.split("");for(var o=Math.min(e.length,e.length);o--;){var s=e[o];s&&s.toLowerCase()!=s?t[o]=t[o].toUpperCase():t[o]=t[o].toLowerCase()}t=t.join("")}return t}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var i=e.needle;if(!e.needle)return e.re=!1;e.regExp||(i=r.escapeRegExp(i)),e.wholeWord&&(i=n(i,e));var o=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(i),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(i,o);try{var s=new RegExp(i,o)}catch(e){s=!1}return e.re=s},this.$assembleMultilineRegExp=function(e,t){for(var i=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),n=[],r=0;r<i.length;r++)try{n.push(new RegExp(i[r],t))}catch(e){return!1}return n},this.$matchIterator=function(e,t){var i=this.$assembleRegExp(t);if(!i)return!1;var n=1==t.backwards,r=0!=t.skipCurrent,o=t.range,s=t.start;s||(s=o?o[n?"end":"start"]:e.selection.getRange()),s.start&&(s=s[r!=n?"end":"start"]);var a=o?o.start.row:0,l=o?o.end.row:e.getLength()-1;if(n)var c=function(e){var i=s.row;if(!d(i,s.column,e)){for(i--;i>=a;i--)if(d(i,Number.MAX_VALUE,e))return;if(0!=t.wrap)for(i=l,a=s.row;i>=a;i--)if(d(i,Number.MAX_VALUE,e))return}};else var c=function(e){var i=s.row;if(!d(i,s.column,e)){for(i+=1;i<=l;i++)if(d(i,0,e))return;if(0!=t.wrap)for(i=a,l=s.row;i<=l;i++)if(d(i,0,e))return}};if(t.$isMultiLine)var h=i.length,d=function(t,r,o){var s=n?t-h+1:t;if(!(s<0)){var a=e.getLine(s),l=a.search(i[0]);if(!(!n&&l<r||-1===l)){for(var c=1;c<h;c++)if(a=e.getLine(s+c),-1==a.search(i[c]))return;var d=a.match(i[h-1])[0].length;if(!(n&&d>r))return!!o(s,l,s+h-1,d)||void 0}}};else if(n)var d=function(t,n,r){var o,s=e.getLine(t),a=[],l=0;for(i.lastIndex=0;o=i.exec(s);){var c=o[0].length;if(l=o.index,!c){if(l>=s.length)break;i.lastIndex=l+=1}if(o.index+c>n)break;a.push(o.index,c)}for(var h=a.length-1;h>=0;h-=2){var d=a[h-1],c=a[h];if(r(t,d,t,d+c))return!0}};else var d=function(t,n,r){var o,s=e.getLine(t),a=n;for(i.lastIndex=n;o=i.exec(s);){var l=o[0].length;if(a=o.index,r(t,a,t,a+l))return!0;if(!l&&(i.lastIndex=a+=1,a>=s.length))return!1}};return{forEach:c}}}).call(a.prototype),t.Search=a}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t,i){"use strict";function n(e,t){this.platform=t||(s.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function r(e,t){n.call(this,e,t),this.$singleCommand=!1}var o=e("../lib/keys"),s=e("../lib/useragent"),a=o.KEY_MODS;r.prototype=n.prototype,function(){function e(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),this.commands[e.name]=e,e.bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var i=e&&("string"==typeof e?e:e.name);e=this.commands[i],t||delete this.commands[i];var n=this.commandKeyBinding;for(var r in n){var o=n[r];if(o==e)delete n[r];else if(Array.isArray(o)){var s=o.indexOf(e);-1!=s&&(o.splice(s,1),1==o.length&&(n[r]=o[0]))}}},this.bindKey=function(e,t,i){if("object"==typeof e&&e&&(void 0==i&&(i=e.position),e=e[this.platform]),e)return"function"==typeof t?this.addCommand({exec:t,bindKey:e,name:t.name||e}):void e.split("|").forEach(function(e){var n="";if(-1!=e.indexOf(" ")){var r=e.split(/\s+/);e=r.pop(),r.forEach(function(e){var t=this.parseKeys(e),i=a[t.hashId]+t.key;n+=(n?" ":"")+i,this._addCommandToBinding(n,"chainKeys")},this),n+=" "}var o=this.parseKeys(e),s=a[o.hashId]+o.key;this._addCommandToBinding(n+s,t,i)},this)},this._addCommandToBinding=function(t,i,n){var r,o=this.commandKeyBinding;if(i)if(!o[t]||this.$singleCommand)o[t]=i;else{Array.isArray(o[t])?-1!=(r=o[t].indexOf(i))&&o[t].splice(r,1):o[t]=[o[t]],"number"!=typeof n&&(n=e(i));var s=o[t];for(r=0;r<s.length;r++){var a=s[r],l=e(a);if(l>n)break}s.splice(r,0,i)
}else delete o[t]},this.addCommands=function(e){e&&Object.keys(e).forEach(function(t){var i=e[t];if(i){if("string"==typeof i)return this.bindKey(i,t);"function"==typeof i&&(i={exec:i}),"object"==typeof i&&(i.name||(i.name=t),this.addCommand(i))}},this)},this.removeCommands=function(e){Object.keys(e).forEach(function(t){this.removeCommand(e[t])},this)},this.bindKeys=function(e){Object.keys(e).forEach(function(t){this.bindKey(t,e[t])},this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(e){return e}),i=t.pop(),n=o[i];if(o.FUNCTION_KEYS[n])i=o.FUNCTION_KEYS[n].toLowerCase();else{if(!t.length)return{key:i,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:i.toUpperCase(),hashId:-1}}for(var r=0,s=t.length;s--;){var a=o.KEY_MODS[t[s]];if(null==a)return"undefined"!=typeof console&&console.error("invalid modifier "+t[s]+" in "+e),!1;r|=a}return{key:i,hashId:r}},this.findKeyCommand=function(e,t){var i=a[e]+t;return this.commandKeyBinding[i]},this.handleKeyboard=function(e,t,i,n){if(!(n<0)){var r=a[t]+i,o=this.commandKeyBinding[r];return e.$keyChain&&(e.$keyChain+=" "+r,o=this.commandKeyBinding[e.$keyChain]||o),!o||"chainKeys"!=o&&"chainKeys"!=o[o.length-1]?(e.$keyChain&&(t&&4!=t||1!=i.length?(-1==t||n>0)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-r.length-1)),{command:o}):(e.$keyChain=e.$keyChain||r,{command:"null"})}},this.getStatusText=function(e,t){return t.$keyChain||""}}.call(n.prototype),t.HashHandler=n,t.MultiHashHandler=r}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("../lib/oop"),r=e("../keyboard/hash_handler").MultiHashHandler,o=e("../lib/event_emitter").EventEmitter,s=function(e,t){r.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",function(e){return e.command.exec(e.editor,e.args||{})})};n.inherits(s,r),function(){n.implement(this,o),this.exec=function(e,t,i){if(Array.isArray(e)){for(var n=e.length;n--;)if(this.exec(e[n],t,i))return!0;return!1}if("string"==typeof e&&(e=this.commands[e]),!e)return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;if(e.isAvailable&&!e.isAvailable(t))return!1;var r={editor:t,command:e,args:i};return r.returnValue=this._emit("exec",r),this._signal("afterExec",r),!1!==r.returnValue},this.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.removeEventListener("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(e){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(e);try{this.$inReplay=!0,this.macro.forEach(function(t){"string"==typeof t?this.exec(t,e):this.exec(t[0],e,t[1])},this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map(function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e[1]||(e=e[0]),e})}}.call(s.prototype),t.CommandManager=s}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(e,t,i){"use strict";function n(e,t){return{win:e,mac:t}}var r=e("../lib/lang"),o=e("../config"),s=e("../range").Range;t.commands=[{name:"showSettingsMenu",bindKey:n("Ctrl-,","Command-,"),exec:function(e){o.loadModule("ace/ext/settings_menu",function(t){t.init(e),e.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",bindKey:n("Alt-E","F4"),exec:function(e){o.loadModule("ace/ext/error_marker",function(t){t.showErrorMarker(e,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:n("Alt-Shift-E","Shift-F4"),exec:function(e){o.loadModule("ace/ext/error_marker",function(t){t.showErrorMarker(e,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",bindKey:n("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",bindKey:n(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",bindKey:n("Ctrl-L","Command-L"),exec:function(e){var t=parseInt(prompt("Enter line number:"),10);isNaN(t)||e.gotoLine(t)},readOnly:!0},{name:"fold",bindKey:n("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:n("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:n("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:n("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",bindKey:n(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",bindKey:n("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",bindKey:n("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",bindKey:n("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",bindKey:n("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",bindKey:n("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",bindKey:n("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",bindKey:n("Ctrl-F","Command-F"),exec:function(e){o.loadModule("ace/ext/searchbox",function(t){t.Search(e)})},readOnly:!0},{name:"overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",bindKey:n("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",bindKey:n("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",bindKey:n("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",bindKey:n("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",bindKey:n("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",bindKey:n("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",bindKey:n("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",bindKey:n("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",bindKey:n("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",bindKey:n("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",bindKey:n("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",bindKey:n("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",bindKey:n("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",bindKey:n("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",bindKey:n("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",bindKey:n("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",bindKey:n("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",bindKey:n("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",bindKey:n("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",bindKey:n("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",bindKey:n(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",bindKey:n("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",bindKey:n(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",bindKey:n("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",bindKey:n("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",bindKey:n("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",bindKey:n("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",bindKey:n("Ctrl-P","Ctrl-P"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",bindKey:n("Ctrl-Shift-P","Ctrl-Shift-P"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",bindKey:n("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",bindKey:n(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",exec:function(e){},readOnly:!0},{name:"cut",exec:function(e){var t=e.getSelectionRange();e._emit("cut",t),e.selection.isEmpty()||(e.session.remove(t),e.clearSelection())},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",bindKey:n("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",bindKey:n("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",bindKey:n("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",bindKey:n("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",bindKey:n("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",bindKey:n("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",bindKey:n("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",bindKey:n("Ctrl-H","Command-Option-F"),exec:function(e){o.loadModule("ace/ext/searchbox",function(t){t.Search(e,!0)})}},{name:"undo",bindKey:n("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",bindKey:n("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",bindKey:n("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",bindKey:n("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",bindKey:n("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",bindKey:n("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",bindKey:n("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",bindKey:n("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",bindKey:n("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",bindKey:n("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",bindKey:n("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",bindKey:n("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",bindKey:n("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",bindKey:n("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",bindKey:n("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",bindKey:n("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",bindKey:n("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",bindKey:n("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",bindKey:n("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",exec:function(e,t){e.insert(r.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",bindKey:n(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",bindKey:n("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",bindKey:n("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",bindKey:n("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"expandtoline",bindKey:n("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",bindKey:n(null,null),exec:function(e){for(var t=e.selection.isBackwards(),i=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),n=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),o=e.session.doc.getLine(i.row).length,a=e.session.doc.getTextRange(e.selection.getRange()),l=a.replace(/\n\s*/," ").length,c=e.session.doc.getLine(i.row),h=i.row+1;h<=n.row+1;h++){var d=r.stringTrimLeft(r.stringTrimRight(e.session.doc.getLine(h)));0!==d.length&&(d=" "+d),c+=d}n.row+1<e.session.doc.getLength()-1&&(c+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new s(i.row,0,n.row+2,0),c),l>0?(e.selection.moveCursorTo(i.row,i.column),e.selection.selectTo(i.row,i.column+l)):(o=e.session.doc.getLine(i.row).length>o?o+1:o,e.selection.moveCursorTo(i.row,o))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",bindKey:n(null,null),exec:function(e){var t=e.session.doc.getLength()-1,i=e.session.doc.getLine(t).length,n=e.selection.rangeList.ranges,r=[];n.length<1&&(n=[e.selection.getRange()]);for(var o=0;o<n.length;o++)o==n.length-1&&(n[o].end.row===t&&n[o].end.column===i||r.push(new s(n[o].end.row,n[o].end.column,t,i))),0===o?0===n[o].start.row&&0===n[o].start.column||r.push(new s(0,0,n[o].start.row,n[o].start.column)):r.push(new s(n[o-1].end.row,n[o-1].end.column,n[o].start.row,n[o].start.column));e.exitMultiSelectMode(),e.clearSelection();for(var o=0;o<r.length;o++)e.selection.addRange(r[o],!1)},readOnly:!0,scrollIntoView:"none"}]}),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator"],function(e,t,i){"use strict";e("./lib/fixoldbrowsers");var n=e("./lib/oop"),r=e("./lib/dom"),o=e("./lib/lang"),s=e("./lib/useragent"),a=e("./keyboard/textinput").TextInput,l=e("./mouse/mouse_handler").MouseHandler,c=e("./mouse/fold_handler").FoldHandler,h=e("./keyboard/keybinding").KeyBinding,d=e("./edit_session").EditSession,u=e("./search").Search,f=e("./range").Range,p=e("./lib/event_emitter").EventEmitter,m=e("./commands/command_manager").CommandManager,g=e("./commands/default_commands").commands,v=e("./config"),y=e("./token_iterator").TokenIterator,w=function(e,t){var i=e.getContainerElement();this.container=i,this.renderer=e,this.id="editor"+ ++w.$uid,this.commands=new m(s.isMac?"mac":"win",g),"object"==typeof document&&(this.textInput=new a(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new l(this),new c(this)),this.keyBinding=new h(this),this.$blockScrolling=0,this.$search=(new u).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=o.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(e,t){t._$emitInputEvent.schedule(31)}),this.setSession(t||new d("")),v.resetOptions(this),v._signal("editor",this)};w.$uid=0,function(){n.implement(this,p),this.$initOperationListeners=function(){this.selections=[],this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=o.delayedCall(this.endOperation.bind(this)),this.on("change",function(){this.curOp||this.startOperation(),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||this.startOperation(),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.command.name&&void 0!==this.curOp.command.scrollIntoView&&this.$blockScrolling++},this.endOperation=function(e){if(this.curOp){if(e&&!1===e.returnValue)return this.curOp=null;this._signal("beforeEndOperation");var t=this.curOp.command;t.name&&this.$blockScrolling>0&&this.$blockScrolling--;var i=t&&t.scrollIntoView;if(i){switch(i){case"center-animate":i="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var n=this.selection.getRange(),r=this.renderer.layerConfig;(n.start.row>=r.lastRow||n.end.row<=r.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==i&&this.renderer.animateScrolling(this.curOp.scrollTop)}this.prevOp=this.curOp,this.curOp=null}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){if(this.$mergeUndoDeltas){var t=this.prevOp,i=this.$mergeableCommands,n=t.command&&e.command.name==t.command.name;if("insertstring"==e.command.name){var r=e.args;void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),n=n&&this.mergeNextCommand&&(!/\s/.test(r)||/\s/.test(t.args)),this.mergeNextCommand=!0}else n=n&&-1!==i.indexOf(e.command.name);"always"!=this.$mergeUndoDeltas&&Date.now()-this.sequenceStartTime>2e3&&(n=!1),n?this.session.mergeUndoDeltas=!0:-1!==i.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now())}},this.setKeyboardHandler=function(e,t){if(e&&"string"==typeof e){this.$keybindingId=e;var i=this;v.loadModule(["keybinding",e],function(n){i.$keybindingId==e&&i.keyBinding.setKeyboardHandler(n&&n.handler),t&&t()})}else this.$keybindingId=null,this.keyBinding.setKeyboardHandler(e),t&&t()},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){if(this.session!=e){this.curOp&&this.endOperation(),this.curOp={};var t=this.session;if(t){this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange);var i=this.session.getSelection();i.off("changeCursor",this.$onCursorChange),i.off("changeSelection",this.$onSelectionChange)}this.session=e,e?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.$blockScrolling+=1,this.onCursorChange(),this.$blockScrolling-=1,this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e&&e.bgTokenizer&&e.bgTokenizer.scheduleStart()}},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||r.computedStyle(this.container,"fontSize")},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){if(this.session.$bracketHighlight&&(this.session.removeMarker(this.session.$bracketHighlight),this.session.$bracketHighlight=null),!this.$highlightPending){var e=this;this.$highlightPending=!0,setTimeout(function(){e.$highlightPending=!1;var t=e.session;if(t&&t.bgTokenizer){var i=t.findMatchingBracket(e.getCursorPosition());if(i)var n=new f(i.row,i.column,i.row,i.column+1);else if(t.$mode.getMatching)var n=t.$mode.getMatching(e.session);n&&(t.$bracketHighlight=t.addMarker(n,"ace_bracket","text"))}},50)}},this.$highlightTags=function(){if(!this.$highlightTagPending){var e=this;this.$highlightTagPending=!0,setTimeout(function(){e.$highlightTagPending=!1;var t=e.session;if(t&&t.bgTokenizer){var i=e.getCursorPosition(),n=new y(e.session,i.row,i.column),r=n.getCurrentToken();if(!r||!/\b(?:tag-open|tag-name)/.test(r.type))return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);if(-1==r.type.indexOf("tag-open")||(r=n.stepForward())){var o=r.value,s=0,a=n.stepBackward();if("<"==a.value)do{a=r,(r=n.stepForward())&&r.value===o&&-1!==r.type.indexOf("tag-name")&&("<"===a.value?s++:"</"===a.value&&s--)}while(r&&s>=0);else{do{r=a,a=n.stepBackward(),r&&r.value===o&&-1!==r.type.indexOf("tag-name")&&("<"===a.value?s++:"</"===a.value&&s--)}while(a&&s<=0);n.stepForward()}if(!r)return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);var l=n.getCurrentTokenRow(),c=n.getCurrentTokenColumn(),h=new f(l,c,l,c+r.value.length),d=t.$backMarkers[t.$tagHighlight];t.$tagHighlight&&void 0!=d&&0!==h.compareRange(d.range)&&(t.removeMarker(t.$tagHighlight),t.$tagHighlight=null),h&&!t.$tagHighlight&&(t.$tagHighlight=t.addMarker(h,"ace_bracket","text"))}}},50)}},this.focus=function(){var e=this;setTimeout(function(){e.textInput.focus()}),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor()},this.onDocumentChange=function(e){var t=this.session.$useWrapMode,i=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,i,t),this._signal("change",e),this.$cursorChange(),this.$updateHighlightActiveLine()},this.onTokenizerUpdate=function(e){var t=e.data;this.renderer.updateLines(t.first,t.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this.$blockScrolling||(v.warn("Automatically scrolling cursor into view after selection change","this will be disabled in the next version","set editor.$blockScrolling = Infinity to disable this message"),this.renderer.scrollCursorIntoView()),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t=this.getSession();if(this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),!this.renderer.$maxLines||1!==this.session.getLength()||this.renderer.$minLines>1||(e=!1)),t.$highlightLineMarker&&!e)t.removeMarker(t.$highlightLineMarker.id),t.$highlightLineMarker=null;else if(!t.$highlightLineMarker&&e){var i=new f(e.row,e.column,e.row,1/0);i.id=t.addMarker(i,"ace_active-line","screenLine"),t.$highlightLineMarker=i}else e&&(t.$highlightLineMarker.start.row=e.row,t.$highlightLineMarker.end.row=e.row,t.$highlightLineMarker.start.column=e.column,t._signal("changeBackMarker"))},this.onSelectionChange=function(e){var t=this.session;if(t.$selectionMarker&&t.removeMarker(t.$selectionMarker),t.$selectionMarker=null,this.selection.isEmpty())this.$updateHighlightActiveLine();else{var i=this.selection.getRange(),n=this.getSelectionStyle();t.$selectionMarker=t.addMarker(i,"ace_selection",n)}var r=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(r),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var i=t.start.column-1,n=t.end.column+1,r=e.getLine(t.start.row),o=r.length,s=r.substring(Math.max(i,0),Math.min(n,o));if(!(i>=0&&/^[\w\d]/.test(s)||n<=o&&/[\w\d]$/.test(s))&&(s=r.substring(t.start.column,t.end.column),/^[\w\d]+$/.test(s))){return this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:s})}}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText();return this._signal("copy",e),e},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e,t){var i={text:e,event:t};this.commands.exec("paste",this,i)},this.$handlePaste=function(e){"string"==typeof e&&(e={text:e}),this._signal("paste",e);var t=e.text;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)this.insert(t);else{var i=t.split(/\r\n|\r|\n/),n=this.selection.rangeList.ranges;if(i.length>n.length||i.length<2||!i[1])return this.commands.exec("insertstring",this,t);for(var r=n.length;r--;){var o=n[r];o.isEmpty()||this.session.remove(o),this.session.insert(o.start,i[r])}}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var i=this.session,n=i.getMode(),r=this.getCursorPosition();if(this.getBehavioursEnabled()&&!t){var o=n.transformAction(i.getState(r.row),"insertion",this,i,e);o&&(e!==o.text&&(this.session.mergeUndoDeltas=!1,this.$mergeNextCommand=!1),e=o.text)}if("\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty()){if(this.session.getOverwrite()&&-1==e.indexOf("\n")){var s=new f.fromPoints(r,r);s.end.column+=e.length,this.session.remove(s)}}else{var s=this.getSelectionRange();r=this.session.remove(s),this.clearSelection()}if("\n"==e||"\r\n"==e){var a=i.getLine(r.row);if(r.column>a.search(/\S|$/)){var l=a.substr(r.column).search(/\S|$/);i.doc.removeInLine(r.row,r.column,r.column+l)}}this.clearSelection();var c=r.column,h=i.getState(r.row),a=i.getLine(r.row),d=n.checkOutdent(h,a,e);i.insert(r,e);if(o&&o.selection&&(2==o.selection.length?this.selection.setSelectionRange(new f(r.row,c+o.selection[0],r.row,c+o.selection[1])):this.selection.setSelectionRange(new f(r.row+o.selection[0],o.selection[1],r.row+o.selection[2],o.selection[3]))),i.getDocument().isNewLine(e)){var u=n.getNextLineIndent(h,a.slice(0,r.column),i.getTabString());i.insert({row:r.row+1,column:0},u)}d&&n.autoOutdent(h,i,r.row)},this.onTextInput=function(e){this.keyBinding.onTextInput(e)},this.onCommandKey=function(e,t,i){this.keyBinding.onCommandKey(e,t,i)},this.setOverwrite=function(e){this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t=this.getSelectionRange();if(this.getBehavioursEnabled()){var i=this.session,n=i.getState(t.start.row),r=i.getMode().transformAction(n,"deletion",this,i,t);if(0===t.end.column){var o=i.getTextRange(t);if("\n"==o[o.length-1]){var s=i.getLine(t.end.row);/^\s+$/.test(s)&&(t.end.column=s.length)}}r&&(t=r)}this.session.remove(t),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){if(this.selection.isEmpty()){var e=this.getCursorPosition(),t=e.column;if(0!==t){var i,n,r=this.session.getLine(e.row);t<r.length?(i=r.charAt(t)+r.charAt(t-1),n=new f(e.row,t-1,e.row,t+1)):(i=r.charAt(t-1)+r.charAt(t-2),n=new f(e.row,t-2,e.row,t)),this.session.replace(n,i),this.session.selection.moveToPosition(n.end)}}},this.toLowerCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(t.start.row<t.end.row){var i=this.$getSelectedRows();return void e.indentRows(i.first,i.last,"\t")}if(t.start.column<t.end.column){if(!/^\s+$/.test(e.getTextRange(t))){var i=this.$getSelectedRows();return void e.indentRows(i.first,i.last,"\t")}}var n=e.getLine(t.start.row),r=t.start,s=e.getTabSize(),a=e.documentToScreenColumn(r.row,r.column);if(this.session.getUseSoftTabs())var l=s-a%s,c=o.stringRepeat(" ",l);else{for(var l=a%s;" "==n[t.start.column-1]&&l;)t.start.column--,l--;this.selection.setSelectionRange(t),c="\t"}return this.insert(c)},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,i=[],n=e.first;n<=e.last;n++)i.push(t.getLine(n));i.sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0});for(var r=new f(0,0,0,0),n=e.first;n<=e.last;n++){var o=t.getLine(n);r.start.row=n,r.end.row=n,r.end.column=o.length,t.replace(r,i[n-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),i=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,i,e)},this.getNumberAt=function(e,t){var i=/[\-]?[0-9]+(?:\.[0-9]+)?/g;i.lastIndex=0;for(var n=this.session.getLine(e);i.lastIndex<t;){var r=i.exec(n);if(r.index<=t&&r.index+r[0].length>=t){return{value:r[0],start:r.index,end:r.index+r[0].length}}}return null},this.modifyNumber=function(e){var t=this.selection.getCursor().row,i=this.selection.getCursor().column,n=new f(t,i-1,t,i),r=this.session.getTextRange(n);if(!isNaN(parseFloat(r))&&isFinite(r)){var o=this.getNumberAt(t,i);if(o){var s=o.value.indexOf(".")>=0?o.start+o.value.indexOf(".")+1:o.end,a=o.start+o.value.length-s,l=parseFloat(o.value);l*=Math.pow(10,a),s!==o.end&&i<s?e*=Math.pow(10,o.end-i-1):e*=Math.pow(10,o.end-i),l+=e,l/=Math.pow(10,a);var c=l.toFixed(a),h=new f(t,o.start,t,o.end);this.session.replace(h,c),this.moveCursorTo(t,Math.max(o.start+1,i+c.length-o.value.length))}}},this.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},this.duplicateSelection=function(){var e=this.selection,t=this.session,i=e.getRange(),n=e.isBackwards();if(i.isEmpty()){var r=i.start.row;t.duplicateLines(r,r)}else{var o=n?i.start:i.end,s=t.insert(o,t.getTextRange(i),!1);i.start=o,i.end=s,e.setSelectionRange(i,n)}},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(e,t,i){return this.session.moveText(e,t,i)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(e,t){var i,n,r=this.selection;if(!r.inMultiSelectMode||this.inVirtualSelectionMode){var o=r.toOrientedRange();i=this.$getSelectedRows(o),n=this.session.$moveLines(i.first,i.last,t?0:e),t&&-1==e&&(n=0),o.moveBy(n,0),r.fromOrientedRange(o)}else{var s=r.rangeList.ranges;r.rangeList.detach(this.session),this.inVirtualSelectionMode=!0;for(var a=0,l=0,c=s.length,h=0;h<c;h++){var d=h;s[h].moveBy(a,0),i=this.$getSelectedRows(s[h]);for(var u=i.first,f=i.last;++h<c;){l&&s[h].moveBy(l,0);var p=this.$getSelectedRows(s[h]);if(t&&p.first!=f)break;if(!t&&p.first>f+1)break;f=p.last}for(h--,a=this.session.$moveLines(u,f,t?0:e),t&&-1==e&&(d=h+1);d<=h;)s[d].moveBy(a,0),d++;t||(a=0),l+=a}r.fromOrientedRange(r.ranges[0]),r.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(e){this.renderer.showComposition(this.getCursorPosition())},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var i=this.renderer,n=this.renderer.layerConfig,r=e*Math.floor(n.height/n.lineHeight);this.$blockScrolling++,!0===t?this.selection.$moveSelection(function(){this.moveCursorBy(r,0)}):!1===t&&(this.selection.moveCursorBy(r,0),this.selection.clearSelection()),this.$blockScrolling--;var o=i.scrollTop;i.scrollBy(0,r*n.lineHeight),null!=t&&i.scrollCursorIntoView(null,.5),i.animateScrolling(o)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,i,n){this.renderer.scrollToLine(e,t,i,n)},this.centerSelection=function(){var e=this.getSelectionRange(),t={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(t,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.$blockScrolling+=1,this.selection.selectAll(),this.$blockScrolling-=1},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(e,t){var i=this.getCursorPosition(),n=new y(this.session,i.row,i.column),r=n.getCurrentToken(),o=r||n.stepForward();if(o){var s,a,l=!1,c={},h=i.column-o.start,d={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(o.value.match(/[{}()\[\]]/g)){for(;h<o.value.length&&!l;h++)if(d[o.value[h]])switch(a=d[o.value[h]]+"."+o.type.replace("rparen","lparen"),isNaN(c[a])&&(c[a]=0),o.value[h]){case"(":case"[":case"{":c[a]++;break;case")":case"]":case"}":c[a]--,-1===c[a]&&(s="bracket",l=!0)}}else o&&-1!==o.type.indexOf("tag-name")&&(isNaN(c[o.value])&&(c[o.value]=0),"<"===r.value?c[o.value]++:"</"===r.value&&c[o.value]--,-1===c[o.value]&&(s="tag",l=!0));l||(r=o,o=n.stepForward(),h=0)}while(o&&!l);if(s){var u,p;if("bracket"===s)(u=this.session.getBracketRange(i))||(u=new f(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1,n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1),p=u.start,(t||p.row===i.row&&Math.abs(p.column-i.column)<2)&&(u=this.session.getBracketRange(p)));else if("tag"===s){if(!o||-1===o.type.indexOf("tag-name"))return;var m=o.value;if(u=new f(n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2,n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2),0===u.compare(i.row,i.column)){l=!1;do{o=r,(r=n.stepBackward())&&(-1!==r.type.indexOf("tag-close")&&u.setEnd(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+1),o.value===m&&-1!==o.type.indexOf("tag-name")&&("<"===r.value?c[m]++:"</"===r.value&&c[m]--,0===c[m]&&(l=!0)))}while(r&&!l)}o&&o.type.indexOf("tag-name")&&(p=u.start,p.row==i.row&&Math.abs(p.column-i.column)<2&&(p=u.end))}p=u&&u.cursor||p,p&&(e?u&&t?this.selection.setRange(u):u&&u.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(p.row,p.column):this.selection.moveTo(p.row,p.column))}}},this.gotoLine=function(e,t,i){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.$blockScrolling+=1,this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.$blockScrolling-=1,this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,i)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var i=this.$search.find(this.session),n=0;return i?(this.$tryReplace(i,e)&&(n=1),null!==i&&(this.selection.setSelectionRange(i),this.renderer.scrollSelectionIntoView(i.start,i.end)),n):n},this.replaceAll=function(e,t){t&&this.$search.set(t);var i=this.$search.findAll(this.session),n=0;if(!i.length)return n;this.$blockScrolling+=1;var r=this.getSelectionRange();this.selection.moveTo(0,0);for(var o=i.length-1;o>=0;--o)this.$tryReplace(i[o],e)&&n++;return this.selection.setSelectionRange(r),this.$blockScrolling-=1,n},this.$tryReplace=function(e,t){var i=this.session.getTextRange(e);return t=this.$search.replace(i,t),null!==t?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,i){t||(t={}),"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&n.mixin(t,e);var r=this.selection.getRange();null==t.needle&&(e=this.session.getTextRange(r)||this.$search.$options.needle,e||(r=this.session.getWordRange(r.start.row,r.start.column),e=this.session.getTextRange(r)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:r});var o=this.$search.find(this.session);return t.preventScroll?o:o?(this.revealRange(o,i),o):(t.backwards?r.start=r.end:r.end=r.start,void this.selection.setRange(r))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.$blockScrolling+=1,this.session.unfold(e),this.selection.setSelectionRange(e),this.$blockScrolling-=1;var i=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(i)},this.undo=function(){this.$blockScrolling++,this.session.getUndoManager().undo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.$blockScrolling++,this.session.getUndoManager().redo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy()},this.setAutoScrollEditorIntoView=function(e){if(e){var t,i=this,n=!1;this.$scrollAnchor||(this.$scrollAnchor=document.createElement("div"));var r=this.$scrollAnchor;r.style.cssText="position:absolute",this.container.insertBefore(r,this.container.firstChild);var o=this.on("changeSelection",function(){n=!0}),s=this.renderer.on("beforeRender",function(){n&&(t=i.renderer.container.getBoundingClientRect())}),a=this.renderer.on("afterRender",function(){if(n&&t&&(i.isFocused()||i.searchBox&&i.searchBox.isFocused())){var e=i.renderer,o=e.$cursorLayer.$pixelPos,s=e.layerConfig,a=o.top-s.offset;n=o.top>=0&&a+t.top<0||!(o.top<s.height&&o.top+t.top+s.lineHeight>window.innerHeight)&&null,null!=n&&(r.style.top=a+"px",r.style.left=o.left+"px",r.style.height=s.lineHeight+"px",r.scrollIntoView(n)),n=t=null}});this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",o),this.renderer.off("afterRender",a),this.renderer.off("beforeRender",s))}}},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,r.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))}}.call(w.prototype),v.defineOptions(w.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.$resetCursorStyle()},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.keybindingId},handlesSet:!0},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",showLineNumbers:"renderer",showGutter:"renderer",displayIndentGuides:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"}),t.Editor=w}),ace.define("ace/undomanager",["require","exports","module"],function(e,t,i){"use strict";var n=function(){this.reset()};(function(){function e(e){return{action:e.action,start:e.start,end:e.end,lines:1==e.lines.length?null:e.lines,text:1==e.lines.length?e.lines[0]:null}}function t(e){return{action:e.action,start:e.start,end:e.end,lines:e.lines||[e.text]}}function i(e,t){for(var i=new Array(e.length),n=0;n<e.length;n++){for(var r=e[n],o={group:r.group,deltas:new Array(r.length)},s=0;s<r.deltas.length;s++){var a=r.deltas[s];o.deltas[s]=t(a)}i[n]=o}return i}this.execute=function(e){var t=e.args[0];this.$doc=e.args[1],e.merge&&this.hasUndo()&&(this.dirtyCounter--,t=this.$undoStack.pop().concat(t)),this.$undoStack.push(t),this.$redoStack=[],this.dirtyCounter<0&&(this.dirtyCounter=NaN),this.dirtyCounter++},this.undo=function(e){var t=this.$undoStack.pop(),i=null;return t&&(i=this.$doc.undoChanges(t,e),this.$redoStack.push(t),this.dirtyCounter--),i},this.redo=function(e){var t=this.$redoStack.pop(),i=null;return t&&(i=this.$doc.redoChanges(this.$deserializeDeltas(t),e),this.$undoStack.push(t),this.dirtyCounter++),i},this.reset=function(){this.$undoStack=[],this.$redoStack=[],this.dirtyCounter=0},this.hasUndo=function(){return this.$undoStack.length>0},this.hasRedo=function(){return this.$redoStack.length>0},this.markClean=function(){this.dirtyCounter=0},this.isClean=function(){return 0===this.dirtyCounter},this.$serializeDeltas=function(t){return i(t,e)},this.$deserializeDeltas=function(e){return i(e,t)}}).call(n.prototype),t.UndoManager=n}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("../lib/dom"),r=e("../lib/oop"),o=e("../lib/lang"),s=e("../lib/event_emitter").EventEmitter,a=function(e){this.element=n.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$cells=[]};(function(){r.implement(this,s),this.setSession=function(e){this.session&&this.session.removeEventListener("change",this.$updateAnnotations),this.session=e,e&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var i=e[t],n=i.row,r=this.$annotations[n];r||(r=this.$annotations[n]={text:[]});var s=i.text;s=s?o.escapeHTML(s):i.html||"",-1===r.text.indexOf(s)&&r.text.push(s);var a=i.type;"error"==a?r.className=" ace_error":"warning"==a&&" ace_error"!=r.className?r.className=" ace_warning":"info"!=a||r.className||(r.className=" ace_info")}},this.$updateAnnotations=function(e){if(this.$annotations.length){var t=e.start.row,i=e.end.row-t;if(0===i);else if("remove"==e.action)this.$annotations.splice(t,i+1,null);else{var n=new Array(i+1);n.unshift(t,1),this.$annotations.splice.apply(this.$annotations,n)}}},this.update=function(e){for(var t=this.session,i=e.firstRow,r=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1),o=t.getNextFoldLine(i),s=o?o.start.row:1/0,a=this.$showFoldWidgets&&t.foldWidgets,l=t.$breakpoints,c=t.$decorations,h=t.$firstLineNumber,d=0,u=t.gutterRenderer||this.$renderer,f=null,p=-1,m=i;;){if(m>s&&(m=o.end.row+1,o=t.getNextFoldLine(m,o),s=o?o.start.row:1/0),m>r){for(;this.$cells.length>p+1;)f=this.$cells.pop(),this.element.removeChild(f.element);break}f=this.$cells[++p],f||(f={element:null,textNode:null,foldWidget:null},f.element=n.createElement("div"),f.textNode=document.createTextNode(""),f.element.appendChild(f.textNode),this.element.appendChild(f.element),this.$cells[p]=f);var g="ace_gutter-cell ";l[m]&&(g+=l[m]),c[m]&&(g+=c[m]),this.$annotations[m]&&(g+=this.$annotations[m].className),f.element.className!=g&&(f.element.className=g);var v=t.getRowLength(m)*e.lineHeight+"px";if(v!=f.element.style.height&&(f.element.style.height=v),a){var y=a[m];null==y&&(y=a[m]=t.getFoldWidget(m))}if(y){f.foldWidget||(f.foldWidget=n.createElement("span"),f.element.appendChild(f.foldWidget));var g="ace_fold-widget ace_"+y;"start"==y&&m==s&&m<o.end.row?g+=" ace_closed":g+=" ace_open",f.foldWidget.className!=g&&(f.foldWidget.className=g);var v=e.lineHeight+"px";f.foldWidget.style.height!=v&&(f.foldWidget.style.height=v)}else f.foldWidget&&(f.element.removeChild(f.foldWidget),f.foldWidget=null);var w=d=u?u.getText(t,m):m+h;w!==f.textNode.data&&(f.textNode.data=w),m++}this.element.style.height=e.minHeight+"px",(this.$fixedWidth||t.$useWrapMode)&&(d=t.getLength()+h);var b=u?u.getWidth(t,d,e):d.toString().length*e.characterWidth,C=this.$padding||this.$computePadding();(b+=C.left+C.right)===this.gutterWidth||isNaN(b)||(this.gutterWidth=b,this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._emit("changeGutterWidth",b))},this.$fixedWidth=!1,this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return""},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?n.addCssClass(this.element,"ace_folding-enabled"):n.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=n.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=parseInt(e.paddingLeft)+1||0,this.$padding.right=parseInt(e.paddingRight)||0,this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),i=this.element.getBoundingClientRect();return e.x<t.left+i.left?"markers":this.$showFoldWidgets&&e.x>i.right-t.right?"foldWidgets":void 0}}).call(a.prototype),t.Gutter=a}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(e,t,i){"use strict";var n=e("../range").Range,r=e("../lib/dom"),o=function(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)};(function(){function e(e,t,i,n){return(e?1:0)|(t?2:0)|(i?4:0)|(n?8:0)}this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.update=function(e){if(e){this.config=e;var t=[];for(var i in this.markers){var n=this.markers[i];if(n.range){var r=n.range.clipRows(e.firstRow,e.lastRow);if(!r.isEmpty())if(r=r.toScreenRange(this.session),n.renderer){var o=this.$getTop(r.start.row,e),s=this.$padding+(this.session.$bidiHandler.isBidiRow(r.start.row)?this.session.$bidiHandler.getPosLeft(r.start.column):r.start.column*e.characterWidth);n.renderer(t,r,s,o,e)}else"fullLine"==n.type?this.drawFullLineMarker(t,r,n.clazz,e):"screenLine"==n.type?this.drawScreenLineMarker(t,r,n.clazz,e):r.isMultiLine()?"text"==n.type?this.drawTextMarker(t,r,n.clazz,e):this.drawMultiLineMarker(t,r,n.clazz,e):this.session.$bidiHandler.isBidiRow(r.start.row)?this.drawBidiSingleLineMarker(t,r,n.clazz+" ace_start ace_br15",e):this.drawSingleLineMarker(t,r,n.clazz+" ace_start ace_br15",e)}else n.update(t,this,this.session,e)}this.element.innerHTML=t.join("")}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(t,i,r,o,s){for(var a=this.session,l=i.start.row,c=i.end.row,h=l,d=0,u=0,f=a.getScreenLastRowColumn(h),p=null,m=new n(h,i.start.column,h,u);h<=c;h++)m.start.row=m.end.row=h,m.start.column=h==l?i.start.column:a.getRowWrapIndent(h),m.end.column=f,d=u,u=f,f=h+1<c?a.getScreenLastRowColumn(h+1):h==c?0:i.end.column,p=r+(h==l?" ace_start":"")+" ace_br"+e(h==l||h==l+1&&i.start.column,d<u,u>f,h==c),this.session.$bidiHandler.isBidiRow(h)?this.drawBidiSingleLineMarker(t,m,p,o,h==c?0:1,s):this.drawSingleLineMarker(t,m,p,o,h==c?0:1,s)},this.drawMultiLineMarker=function(e,t,i,n,r){var o,s,a,l=this.$padding;if(r=r||"",this.session.$bidiHandler.isBidiRow(t.start.row)){var c=t.clone();c.end.row=c.start.row,c.end.column=this.session.getLine(c.start.row).length,this.drawBidiSingleLineMarker(e,c,i+" ace_br1 ace_start",n,null,r)}else o=n.lineHeight,s=this.$getTop(t.start.row,n),
a=l+t.start.column*n.characterWidth,e.push("<div class='",i," ace_br1 ace_start' style='","height:",o,"px;","right:0;","top:",s,"px;","left:",a,"px;",r,"'></div>");if(this.session.$bidiHandler.isBidiRow(t.end.row)){var c=t.clone();c.start.row=c.end.row,c.start.column=0,this.drawBidiSingleLineMarker(e,c,i+" ace_br12",n,null,r)}else{var h=t.end.column*n.characterWidth;o=n.lineHeight,s=this.$getTop(t.end.row,n),e.push("<div class='",i," ace_br12' style='","height:",o,"px;","width:",h,"px;","top:",s,"px;","left:",l,"px;",r,"'></div>")}if(!((o=(t.end.row-t.start.row-1)*n.lineHeight)<=0)){s=this.$getTop(t.start.row+1,n);var d=(t.start.column?1:0)|(t.end.column?0:8);e.push("<div class='",i,d?" ace_br"+d:"","' style='","height:",o,"px;","right:0;","top:",s,"px;","left:",l,"px;",r,"'></div>")}},this.drawSingleLineMarker=function(e,t,i,n,r,o){var s=n.lineHeight,a=(t.end.column+(r||0)-t.start.column)*n.characterWidth,l=this.$getTop(t.start.row,n),c=this.$padding+t.start.column*n.characterWidth;e.push("<div class='",i,"' style='","height:",s,"px;","width:",a,"px;","top:",l,"px;","left:",c,"px;",o||"","'></div>")},this.drawBidiSingleLineMarker=function(e,t,i,n,r,o){var s=n.lineHeight,a=this.$getTop(t.start.row,n),l=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach(function(t){e.push("<div class='",i,"' style='","height:",s,"px;","width:",t.width+(r||0),"px;","top:",a,"px;","left:",l+t.left,"px;",o||"","'></div>")})},this.drawFullLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;t.start.row!=t.end.row&&(s+=this.$getTop(t.end.row,n)-o),e.push("<div class='",i,"' style='","height:",s,"px;","top:",o,"px;","left:0;right:0;",r||"","'></div>")},this.drawScreenLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;e.push("<div class='",i,"' style='","height:",s,"px;","top:",o,"px;","left:0;right:0;",r||"","'></div>")}}).call(o.prototype),t.Marker=o}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("../lib/oop"),r=e("../lib/dom"),o=e("../lib/lang"),s=(e("../lib/useragent"),e("../lib/event_emitter").EventEmitter),a=function(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this)};(function(){n.implement(this,s),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="—",this.SPACE_CHAR="·",this.$padding=0,this.$updateEolChar=function(){var e="\n"==this.session.doc.getNewLineCharacter()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=e)return this.EOL_CHAR=e,!0},this.setPadding=function(e){this.$padding=e,this.element.style.padding="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){this.session=e,e&&this.$computeTabString()},this.showInvisibles=!1,this.setShowInvisibles=function(e){return this.showInvisibles!=e&&(this.showInvisibles=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){var e=this.session.getTabSize();this.tabSize=e;for(var t=this.$tabStrings=[0],i=1;i<e+1;i++)this.showInvisibles?t.push("<span class='ace_invisible ace_invisible_tab'>"+o.stringRepeat(this.TAB_CHAR,i)+"</span>"):t.push(o.stringRepeat(" ",i));if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;var n="ace_indent-guide",r="",s="";if(this.showInvisibles){n+=" ace_invisible",r=" ace_invisible_space",s=" ace_invisible_tab";var a=o.stringRepeat(this.SPACE_CHAR,this.tabSize),l=o.stringRepeat(this.TAB_CHAR,this.tabSize)}else var a=o.stringRepeat(" ",this.tabSize),l=a;this.$tabStrings[" "]="<span class='"+n+r+"'>"+a+"</span>",this.$tabStrings["\t"]="<span class='"+n+s+"'>"+l+"</span>"}},this.updateLines=function(e,t,i){this.config.lastRow==e.lastRow&&this.config.firstRow==e.firstRow||this.scrollLines(e),this.config=e;for(var n=Math.max(t,e.firstRow),r=Math.min(i,e.lastRow),o=this.element.childNodes,s=0,a=e.firstRow;a<n;a++){var l=this.session.getFoldLine(a);if(l){if(l.containsRow(n)){n=l.start.row;break}a=l.end.row}s++}for(var a=n,l=this.session.getNextFoldLine(a),c=l?l.start.row:1/0;;){if(a>c&&(a=l.end.row+1,l=this.session.getNextFoldLine(a,l),c=l?l.start.row:1/0),a>r)break;var h=o[s++];if(h){var d=[];this.$renderLine(d,a,!this.$useLineGroups(),a==c&&l),h.style.height=e.lineHeight*this.session.getRowLength(a)+"px",h.innerHTML=d.join("")}a++}},this.scrollLines=function(e){var t=this.config;if(this.config=e,!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);var i=this.element;if(t.firstRow<e.firstRow)for(var n=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);n>0;n--)i.removeChild(i.firstChild);if(t.lastRow>e.lastRow)for(var n=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);n>0;n--)i.removeChild(i.lastChild);if(e.firstRow<t.firstRow){var r=this.$renderLinesFragment(e,e.firstRow,t.firstRow-1);i.firstChild?i.insertBefore(r,i.firstChild):i.appendChild(r)}if(e.lastRow>t.lastRow){var r=this.$renderLinesFragment(e,t.lastRow+1,e.lastRow);i.appendChild(r)}},this.$renderLinesFragment=function(e,t,i){for(var n=this.element.ownerDocument.createDocumentFragment(),o=t,s=this.session.getNextFoldLine(o),a=s?s.start.row:1/0;;){if(o>a&&(o=s.end.row+1,s=this.session.getNextFoldLine(o,s),a=s?s.start.row:1/0),o>i)break;var l=r.createElement("div"),c=[];if(this.$renderLine(c,o,!1,o==a&&s),l.innerHTML=c.join(""),this.$useLineGroups())l.className="ace_line_group",n.appendChild(l),l.style.height=e.lineHeight*this.session.getRowLength(o)+"px";else for(;l.firstChild;)n.appendChild(l.firstChild);o++}return n},this.update=function(e){this.config=e;for(var t=[],i=e.firstRow,n=e.lastRow,r=i,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;;){if(r>s&&(r=o.end.row+1,o=this.session.getNextFoldLine(r,o),s=o?o.start.row:1/0),r>n)break;this.$useLineGroups()&&t.push("<div class='ace_line_group' style='height:",e.lineHeight*this.session.getRowLength(r),"px'>"),this.$renderLine(t,r,!1,r==s&&o),this.$useLineGroups()&&t.push("</div>"),r++}this.element.innerHTML=t.join("")},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(e,t,i,n){var r=this,s=function(e,i,n,s,a){if(i)return r.showInvisibles?"<span class='ace_invisible ace_invisible_space'>"+o.stringRepeat(r.SPACE_CHAR,e.length)+"</span>":e;if("&"==e)return"&#38;";if("<"==e)return"&#60;";if(">"==e)return"&#62;";if("\t"==e){var l=r.session.getScreenTabSize(t+s);return t+=l-1,r.$tabStrings[l]}if("　"==e){var c=r.showInvisibles?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",h=r.showInvisibles?r.SPACE_CHAR:"";return t+=1,"<span class='"+c+"' style='width:"+2*r.config.characterWidth+"px'>"+h+"</span>"}return n?"<span class='ace_invisible ace_invisible_space ace_invalid'>"+r.SPACE_CHAR+"</span>":(t+=1,"<span class='ace_cjk' style='width:"+2*r.config.characterWidth+"px'>"+e+"</span>")},a=n.replace(/\t|&|<|>|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\u3000\uFEFF\uFFF9-\uFFFC])|[\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3000-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF]/g,s);if(this.$textToken[i.type])e.push(a);else{var l="ace_"+i.type.replace(/\./g," ace_"),c="";"fold"==i.type&&(c=" style='width:"+i.value.length*this.config.characterWidth+"px;' "),e.push("<span class='",l,"'",c,">",a,"</span>")}return t+n.length},this.renderIndentGuide=function(e,t,i){var n=t.search(this.$indentGuideRe);return n<=0||n>=i?t:" "==t[0]?(n-=n%this.tabSize,e.push(o.stringRepeat(this.$tabStrings[" "],n/this.tabSize)),t.substr(n)):"\t"==t[0]?(e.push(o.stringRepeat(this.$tabStrings["\t"],n)),t.substr(n)):t},this.$renderWrappedLine=function(e,t,i,n){for(var r=0,s=0,a=i[0],l=0,c=0;c<t.length;c++){var h=t[c],d=h.value;if(0==c&&this.displayIndentGuides){if(r=d.length,!(d=this.renderIndentGuide(e,d,a)))continue;r-=d.length}if(r+d.length<a)l=this.$renderToken(e,l,h,d),r+=d.length;else{for(;r+d.length>=a;)l=this.$renderToken(e,l,h,d.substring(0,a-r)),d=d.substring(a-r),r=a,n||e.push("</div>","<div class='ace_line' style='height:",this.config.lineHeight,"px'>"),e.push(o.stringRepeat(" ",i.indent)),s++,l=0,a=i[s]||Number.MAX_VALUE;0!=d.length&&(r+=d.length,l=this.$renderToken(e,l,h,d))}}},this.$renderSimpleLine=function(e,t){var i=0,n=t[0],r=n.value;this.displayIndentGuides&&(r=this.renderIndentGuide(e,r)),r&&(i=this.$renderToken(e,i,n,r));for(var o=1;o<t.length;o++)n=t[o],r=n.value,i=this.$renderToken(e,i,n,r)},this.$renderLine=function(e,t,i,n){if(n||0==n||(n=this.session.getFoldLine(t)),n)var r=this.$getFoldLineTokens(t,n);else var r=this.session.getTokens(t);if(i||e.push("<div class='ace_line' style='height:",this.config.lineHeight*(this.$useLineGroups()?1:this.session.getRowLength(t)),"px'>"),r.length){var o=this.session.getRowSplitData(t);o&&o.length?this.$renderWrappedLine(e,r,o,i):this.$renderSimpleLine(e,r)}this.showInvisibles&&(n&&(t=n.end.row),e.push("<span class='ace_invisible ace_invisible_eol'>",t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,"</span>")),i||e.push("</div>")},this.$getFoldLineTokens=function(e,t){function i(e,t,i){for(var n=0,o=0;o+e[n].value.length<t;)if(o+=e[n].value.length,++n==e.length)return;if(o!=t){var s=e[n].value.substring(t-o);s.length>i-t&&(s=s.substring(0,i-t)),r.push({type:e[n].type,value:s}),o=t+s.length,n+=1}for(;o<i&&n<e.length;){var s=e[n].value;s.length+o>i?r.push({type:e[n].type,value:s.substring(0,i-o)}):r.push(e[n]),o+=s.length,n+=1}}var n=this.session,r=[],o=n.getTokens(e);return t.walk(function(e,t,s,a,l){null!=e?r.push({type:"fold",value:e}):(l&&(o=n.getTokens(t)),o.length&&i(o,a,s))},t.end.row,this.session.getLine(t.end.row).length),r},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$measureNode&&this.$measureNode.parentNode.removeChild(this.$measureNode),delete this.$measureNode}}).call(a.prototype),t.Text=a}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var n,r=e("../lib/dom"),o=function(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),void 0===n&&(n=!("opacity"in this.element.style)),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),r.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=(n?this.$updateVisibility:this.$updateOpacity).bind(this)};(function(){this.$updateVisibility=function(e){for(var t=this.cursors,i=t.length;i--;)t[i].style.visibility=e?"":"hidden"},this.$updateOpacity=function(e){for(var t=this.cursors,i=t.length;i--;)t[i].style.opacity=e?"":"0"},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e==this.smoothBlinking||n||(this.smoothBlinking=e,r.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.$updateCursors=this.$updateOpacity.bind(this),this.restartTimer())},this.addCursor=function(){var e=r.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){if(this.cursors.length>1){var e=this.cursors.pop();return e.parentNode.removeChild(e),e}},this.hideCursor=function(){this.isVisible=!1,r.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,r.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e=this.$updateCursors;if(clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.smoothBlinking&&r.removeCssClass(this.element,"ace_smooth-blinking"),e(!0),this.isBlinking&&this.blinkInterval&&this.isVisible){this.smoothBlinking&&setTimeout(function(){r.addCssClass(this.element,"ace_smooth-blinking")}.bind(this));var t=function(){this.timeoutId=setTimeout(function(){e(!1)},.6*this.blinkInterval)}.bind(this);this.intervalId=setInterval(function(){e(!0),t()},this.blinkInterval),t()}},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e||(e=this.session.selection.getCursor());var i=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(i.row,e.row)?this.session.$bidiHandler.getPosLeft(i.column):i.column*this.config.characterWidth),top:(i.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},this.update=function(e){this.config=e;var t=this.session.$selectionMarkers,i=0,n=0;void 0!==t&&0!==t.length||(t=[{cursor:null}]);for(var i=0,r=t.length;i<r;i++){var o=this.getPixelPosition(t[i].cursor,!0);if(!((o.top>e.height+e.offset||o.top<0)&&i>1)){var s=(this.cursors[n++]||this.addCursor()).style;this.drawCursor?this.drawCursor(s,o,e,t[i],this.session):(s.left=o.left+"px",s.top=o.top+"px",s.width=e.characterWidth+"px",s.height=e.lineHeight+"px")}}for(;this.cursors.length>n;)this.removeCursor();var a=this.session.getOverwrite();this.$setOverwrite(a),this.$pixelPos=o,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(e){e!=this.overwrite&&(this.overwrite=e,e?r.addCssClass(this.element,"ace_overwrite-cursors"):r.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(o.prototype),t.Cursor=o}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/dom"),o=e("./lib/event"),s=e("./lib/event_emitter").EventEmitter,a=function(e){this.element=r.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=r.createElement("div"),this.inner.className="ace_scrollbar-inner",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,o.addListener(this.element,"scroll",this.onScroll.bind(this)),o.addListener(this.element,"mousedown",o.preventDefault)};(function(){n.implement(this,s),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}).call(a.prototype);var l=function(e,t){a.call(this,e),this.scrollTop=0,this.scrollHeight=0,t.$scrollbarWidth=this.width=r.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0};n.inherits(l,a),function(){this.classSuffix="-v",this.onScroll=function(){if(!this.skipEvent){if(this.scrollTop=this.element.scrollTop,1!=this.coeff){var e=this.element.clientHeight/this.scrollHeight;this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)}this._emit("scroll",{data:this.scrollTop})}this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){this.scrollHeight=e,e>32768?(this.coeff=32768/e,e=32768):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(l.prototype);var c=function(e,t){a.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"};n.inherits(c,a),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(c.prototype),t.ScrollBar=l,t.ScrollBarV=l,t.ScrollBarH=c,t.VScrollBar=l,t.HScrollBar=c}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(e,t,i){"use strict";var n=e("./lib/event"),r=function(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.window=t||window};(function(){this.schedule=function(e){if(this.changes=this.changes|e,!this.pending&&this.changes){this.pending=!0;var t=this;n.nextFrame(function(){t.pending=!1;for(var e;e=t.changes;)t.changes=0,t.onRender(e)},this.window)}}}).call(r.prototype),t.RenderLoop=r}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,i){var n=e("../lib/oop"),r=e("../lib/dom"),o=e("../lib/lang"),s=e("../lib/useragent"),a=e("../lib/event_emitter").EventEmitter,l=0,c=t.FontMetrics=function(e){this.el=r.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=r.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=r.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),l||this.$testFractionalRect(),this.$measureNode.innerHTML=o.stringRepeat("X",l),this.$characterSize={width:0,height:0},this.checkForSizeChanges()};(function(){n.implement(this,a),this.$characterSize={width:0,height:0},this.$testFractionalRect=function(){var e=r.createElement("div");this.$setMeasureNodeStyles(e.style),e.style.width="0.2px",document.documentElement.appendChild(e);var t=e.getBoundingClientRect().width;l=t>0&&t<1?50:100,e.parentNode.removeChild(e)},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",s.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(){var e=this.$measureSizes();if(e&&(this.$characterSize.width!==e.width||this.$characterSize.height!==e.height)){this.$measureNode.style.fontWeight="bold";var t=this.$measureSizes();this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e})}},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer)return this.$pollSizeChangesTimer;var e=this;return this.$pollSizeChangesTimer=setInterval(function(){e.checkForSizeChanges()},500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(){if(50===l){var e=null;try{e=this.$measureNode.getBoundingClientRect()}catch(t){e={width:0,height:0}}var t={height:e.height,width:e.width/l}}else var t={height:this.$measureNode.clientHeight,width:this.$measureNode.clientWidth/l};return 0===t.width||0===t.height?null:t},this.$measureCharWidth=function(e){return this.$main.innerHTML=o.stringRepeat(e,l),this.$main.getBoundingClientRect().width/l},this.getCharacterWidth=function(e){var t=this.charSizes[e];return void 0===t&&(t=this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width),t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)}}).call(c.prototype)}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/lib/useragent","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/dom"),o=e("./config"),s=e("./lib/useragent"),a=e("./layer/gutter").Gutter,l=e("./layer/marker").Marker,c=e("./layer/text").Text,h=e("./layer/cursor").Cursor,d=e("./scrollbar").HScrollBar,u=e("./scrollbar").VScrollBar,f=e("./renderloop").RenderLoop,p=e("./layer/font_metrics").FontMetrics,m=e("./lib/event_emitter").EventEmitter;r.importCssString('.ace_editor {\tposition: relative;\toverflow: hidden;\tfont: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;\tdirection: ltr;\ttext-align: left;\t-webkit-tap-highlight-color: rgba(0, 0, 0, 0);\t}\t.ace_scroller {\tposition: absolute;\toverflow: hidden;\ttop: 0;\tbottom: 0;\tbackground-color: inherit;\t-ms-user-select: none;\t-moz-user-select: none;\t-webkit-user-select: none;\tuser-select: none;\tcursor: text;\t}\t.ace_content {\tposition: absolute;\t-moz-box-sizing: border-box;\t-webkit-box-sizing: border-box;\tbox-sizing: border-box;\tmin-width: 100%;\t}\t.ace_dragging .ace_scroller:before{\tposition: absolute;\ttop: 0;\tleft: 0;\tright: 0;\tbottom: 0;\tcontent: \'\';\tbackground: rgba(250, 250, 250, 0.01);\tz-index: 1000;\t}\t.ace_dragging.ace_dark .ace_scroller:before{\tbackground: rgba(0, 0, 0, 0.01);\t}\t.ace_selecting, .ace_selecting * {\tcursor: text !important;\t}\t.ace_gutter {\tposition: absolute;\toverflow : hidden;\twidth: auto;\ttop: 0;\tbottom: 0;\tleft: 0;\tcursor: default;\tz-index: 4;\t-ms-user-select: none;\t-moz-user-select: none;\t-webkit-user-select: none;\tuser-select: none;\t}\t.ace_gutter-active-line {\tposition: absolute;\tleft: 0;\tright: 0;\t}\t.ace_scroller.ace_scroll-left {\tbox-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;\t}\t.ace_gutter-cell {\tpadding-left: 19px;\tpadding-right: 6px;\tbackground-repeat: no-repeat;\t}\t.ace_gutter-cell.ace_error {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");\tbackground-repeat: no-repeat;\tbackground-position: 2px center;\t}\t.ace_gutter-cell.ace_warning {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");\tbackground-position: 2px center;\t}\t.ace_gutter-cell.ace_info {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");\tbackground-position: 2px center;\t}\t.ace_dark .ace_gutter-cell.ace_info {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");\t}\t.ace_scrollbar {\tposition: absolute;\tright: 0;\tbottom: 0;\tz-index: 6;\t}\t.ace_scrollbar-inner {\tposition: absolute;\tcursor: text;\tleft: 0;\ttop: 0;\t}\t.ace_scrollbar-v{\toverflow-x: hidden;\toverflow-y: scroll;\ttop: 0;\t}\t.ace_scrollbar-h {\toverflow-x: scroll;\toverflow-y: hidden;\tleft: 0;\t}\t.ace_print-margin {\tposition: absolute;\theight: 100%;\t}\t.ace_text-input {\tposition: absolute;\tz-index: 0;\twidth: 0.5em;\theight: 1em;\topacity: 0;\tbackground: transparent;\t-moz-appearance: none;\tappearance: none;\tborder: none;\tresize: none;\toutline: none;\toverflow: hidden;\tfont: inherit;\tpadding: 0 1px;\tmargin: 0 -1px;\ttext-indent: -1em;\t-ms-user-select: text;\t-moz-user-select: text;\t-webkit-user-select: text;\tuser-select: text;\twhite-space: pre!important;\t}\t.ace_text-input.ace_composition {\tbackground: inherit;\tcolor: inherit;\tz-index: 1000;\topacity: 1;\ttext-indent: 0;\t}\t.ace_layer {\tz-index: 1;\tposition: absolute;\toverflow: hidden;\tword-wrap: normal;\twhite-space: pre;\theight: 100%;\twidth: 100%;\t-moz-box-sizing: border-box;\t-webkit-box-sizing: border-box;\tbox-sizing: border-box;\tpointer-events: none;\t}\t.ace_gutter-layer {\tposition: relative;\twidth: auto;\ttext-align: right;\tpointer-events: auto;\t}\t.ace_text-layer {\tfont: inherit !important;\t}\t.ace_cjk {\tdisplay: inline-block;\ttext-align: center;\t}\t.ace_cursor-layer {\tz-index: 4;\t}\t.ace_cursor {\tz-index: 4;\tposition: absolute;\t-moz-box-sizing: border-box;\t-webkit-box-sizing: border-box;\tbox-sizing: border-box;\tborder-left: 2px solid;\ttransform: translatez(0);\t}\t.ace_multiselect .ace_cursor {\tborder-left-width: 1px;\t}\t.ace_slim-cursors .ace_cursor {\tborder-left-width: 1px;\t}\t.ace_overwrite-cursors .ace_cursor {\tborder-left-width: 0;\tborder-bottom: 1px solid;\t}\t.ace_hidden-cursors .ace_cursor {\topacity: 0.2;\t}\t.ace_smooth-blinking .ace_cursor {\t-webkit-transition: opacity 0.18s;\ttransition: opacity 0.18s;\t}\t.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {\tposition: absolute;\tz-index: 3;\t}\t.ace_marker-layer .ace_selection {\tposition: absolute;\tz-index: 5;\t}\t.ace_marker-layer .ace_bracket {\tposition: absolute;\tz-index: 6;\t}\t.ace_marker-layer .ace_active-line {\tposition: absolute;\tz-index: 2;\t}\t.ace_marker-layer .ace_selected-word {\tposition: absolute;\tz-index: 4;\t-moz-box-sizing: border-box;\t-webkit-box-sizing: border-box;\tbox-sizing: border-box;\t}\t.ace_line .ace_fold {\t-moz-box-sizing: border-box;\t-webkit-box-sizing: border-box;\tbox-sizing: border-box;\tdisplay: inline-block;\theight: 11px;\tmargin-top: -2px;\tvertical-align: middle;\tbackground-image:\turl("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),\turl("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");\tbackground-repeat: no-repeat, repeat-x;\tbackground-position: center center, top left;\tcolor: transparent;\tborder: 1px solid black;\tborder-radius: 2px;\tcursor: pointer;\tpointer-events: auto;\t}\t.ace_dark .ace_fold {\t}\t.ace_fold:hover{\tbackground-image:\turl("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),\turl("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");\t}\t.ace_tooltip {\tbackground-color: #FFF;\tbackground-image: -webkit-linear-gradient(top, transparent, rgba(0, 0, 0, 0.1));\tbackground-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));\tborder: 1px solid gray;\tborder-radius: 1px;\tbox-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\tcolor: black;\tmax-width: 100%;\tpadding: 3px 4px;\tposition: fixed;\tz-index: 999999;\t-moz-box-sizing: border-box;\t-webkit-box-sizing: border-box;\tbox-sizing: border-box;\tcursor: default;\twhite-space: pre;\tword-wrap: break-word;\tline-height: normal;\tfont-style: normal;\tfont-weight: normal;\tletter-spacing: normal;\tpointer-events: none;\t}\t.ace_folding-enabled > .ace_gutter-cell {\tpadding-right: 13px;\t}\t.ace_fold-widget {\t-moz-box-sizing: border-box;\t-webkit-box-sizing: border-box;\tbox-sizing: border-box;\tmargin: 0 -12px 0 1px;\tdisplay: none;\twidth: 11px;\tvertical-align: top;\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");\tbackground-repeat: no-repeat;\tbackground-position: center;\tborder-radius: 3px;\tborder: 1px solid transparent;\tcursor: pointer;\t}\t.ace_folding-enabled .ace_fold-widget {\tdisplay: inline-block;   \t}\t.ace_fold-widget.ace_end {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");\t}\t.ace_fold-widget.ace_closed {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");\t}\t.ace_fold-widget:hover {\tborder: 1px solid rgba(0, 0, 0, 0.3);\tbackground-color: rgba(255, 255, 255, 0.2);\tbox-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);\t}\t.ace_fold-widget:active {\tborder: 1px solid rgba(0, 0, 0, 0.4);\tbackground-color: rgba(0, 0, 0, 0.05);\tbox-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);\t}\t.ace_dark .ace_fold-widget {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");\t}\t.ace_dark .ace_fold-widget.ace_end {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");\t}\t.ace_dark .ace_fold-widget.ace_closed {\tbackground-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");\t}\t.ace_dark .ace_fold-widget:hover {\tbox-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);\tbackground-color: rgba(255, 255, 255, 0.1);\t}\t.ace_dark .ace_fold-widget:active {\tbox-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);\t}\t.ace_fold-widget.ace_invalid {\tbackground-color: #FFB4B4;\tborder-color: #DE5555;\t}\t.ace_fade-fold-widgets .ace_fold-widget {\t-webkit-transition: opacity 0.4s ease 0.05s;\ttransition: opacity 0.4s ease 0.05s;\topacity: 0;\t}\t.ace_fade-fold-widgets:hover .ace_fold-widget {\t-webkit-transition: opacity 0.05s ease 0.05s;\ttransition: opacity 0.05s ease 0.05s;\topacity:1;\t}\t.ace_underline {\ttext-decoration: underline;\t}\t.ace_bold {\tfont-weight: bold;\t}\t.ace_nobold .ace_bold {\tfont-weight: normal;\t}\t.ace_italic {\tfont-style: italic;\t}\t.ace_error-marker {\tbackground-color: rgba(255, 0, 0,0.2);\tposition: absolute;\tz-index: 9;\t}\t.ace_highlight-marker {\tbackground-color: rgba(255, 255, 0,0.2);\tposition: absolute;\tz-index: 8;\t}\t.ace_br1 {border-top-left-radius    : 3px;}\t.ace_br2 {border-top-right-radius   : 3px;}\t.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}\t.ace_br4 {border-bottom-right-radius: 3px;}\t.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}\t.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}\t.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}\t.ace_br8 {border-bottom-left-radius : 3px;}\t.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}\t.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}\t.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}\t.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\t.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\t.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\t.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}\t.ace_text-input-ios {\tposition: absolute !important;\ttop: -100000px !important;\tleft: -100000px !important;\t}\t',"ace_editor.css");var g=function(e,t){var i=this;this.container=e||r.createElement("div"),this.$keepTextAreaAtCursor=!s.isOldIE,r.addCssClass(this.container,"ace_editor"),this.setTheme(t),this.$gutter=r.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=r.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=r.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new a(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new l(this.content);var n=this.$textLayer=new c(this.content);this.canvas=n.element,this.$markerFront=new l(this.content),this.$cursorLayer=new h(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new u(this.container,this),this.scrollBarH=new d(this.container,this),this.scrollBarV.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollTop(e.data-i.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollLeft(e.data-i.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new p(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.addEventListener("changeCharacterSize",function(e){i.updateCharacterSize(),i.onResize(!0,i.gutterWidth,i.$size.width,i.$size.height),i._signal("changeCharacterSize",e)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$loop=new f(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),o.resetOptions(this),o._emit("renderer",this)};(function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,n.implement(this,m),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin()},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),this.session=e,e&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,i){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!i)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,i,n){if(!(this.resizing>2)){this.resizing>0?this.resizing++:this.resizing=e?1:0;var r=this.container;n||(n=r.clientHeight||r.scrollHeight),i||(i=r.clientWidth||r.scrollWidth);var o=this.$updateCachedSize(e,t,i,n);if(!this.$size.scrollerHeight||!i&&!n)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(o|this.$changes,!0):this.$loop.schedule(o|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarV.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(e,t,i,n){n-=this.$extraHeight||0;var r=0,o=this.$size,s={width:o.width,height:o.height,scrollerHeight:o.scrollerHeight,scrollerWidth:o.scrollerWidth};return n&&(e||o.height!=n)&&(o.height=n,r|=this.CHANGE_SIZE,o.scrollerHeight=o.height,this.$horizScroll&&(o.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",r|=this.CHANGE_SCROLL),i&&(e||o.width!=i)&&(r|=this.CHANGE_SIZE,o.width=i,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,this.scrollBarH.element.style.left=this.scroller.style.left=t+"px",o.scrollerWidth=Math.max(0,i-t-this.scrollBarV.getWidth()),this.scrollBarH.element.style.right=this.scroller.style.right=this.scrollBarV.getWidth()+"px",this.scroller.style.bottom=this.scrollBarH.getHeight()+"px",(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(r|=this.CHANGE_FULL)),o.$dirty=!i||!n,r&&this._signal("resize",s),r},this.onGutterResize=function(){var e=this.$showGutter?this.$gutter.offsetWidth:0;e!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,e,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()?this.$loop.schedule(this.CHANGE_FULL):this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):(this.$computeLayerConfig(),this.$loop.schedule(this.CHANGE_MARKER))},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,t=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(t,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updateGutterLineHighlight=function(){var e=this.$cursorLayer.$pixelPos,t=this.layerConfig.lineHeight;if(this.session.getUseWrapMode()){var i=this.session.selection.getCursor();i.column=0,e=this.$cursorLayer.getPixelPosition(i,!0),t*=this.session.getRowLength(i.row)}this.$gutterLineHighlight.style.top=e.top-this.layerConfig.offset+"px",this.$gutterLineHighlight.style.height=t+"px"},this.$updatePrintMargin=function(){if(this.$showPrintMargin||this.$printMarginEl){if(!this.$printMarginEl){var e=r.createElement("div");e.className="ace_layer ace_print-margin-layer",this.$printMarginEl=r.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)}var t=this.$printMarginEl.style;t.left=this.characterWidth*this.$printMarginColumn+this.$padding+"px",t.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit()}},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){if(this.$keepTextAreaAtCursor){var e=this.layerConfig,t=this.$cursorLayer.$pixelPos.top,i=this.$cursorLayer.$pixelPos.left;t-=e.offset;var n=this.textarea.style,r=this.lineHeight;if(t<0||t>e.height-r)return void(n.top=n.left="0");var o=this.characterWidth;if(this.$composition){var s=this.textarea.value.replace(/^\x01+/,"");o*=this.session.$getStringScreenWidth(s)[0]+2,r+=2}i-=this.scrollLeft,i>this.$size.scrollerWidth-o&&(i=this.$size.scrollerWidth-o),i+=this.gutterWidth,n.height=r+"px",n.width=o+"px",n.left=Math.min(i,this.$size.scrollerWidth-o)+"px",n.top=Math.min(t,this.$size.height-r)+"px"}},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,i,n){var r=this.scrollMargin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,r.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-r.top),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),!this.session||!this.container.offsetWidth||this.$frozen||!e&&!t)return void(this.$changes|=e);if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender"),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var i=this.layerConfig;if(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL){if(e|=this.$computeLayerConfig(),i.firstRow!=this.layerConfig.firstRow&&i.firstRowScreen==this.layerConfig.firstRowScreen){var n=this.scrollTop+(i.firstRow-this.layerConfig.firstRow)*this.lineHeight;n>0&&(this.scrollTop=n,e|=this.CHANGE_SCROLL,e|=this.$computeLayerConfig())}i=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),this.$gutterLayer.element.style.marginTop=-i.offset+"px",this.content.style.marginTop=-i.offset+"px",this.content.style.width=i.width+2*this.$padding+"px",this.content.style.height=i.minHeight+"px"}return e&this.CHANGE_H_SCROLL&&(this.content.style.marginLeft=-this.scrollLeft+"px",this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL?(this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),void this._signal("afterRender")):e&this.CHANGE_SCROLL?(e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(i):this.$textLayer.scrollLines(i),this.$showGutter&&this.$gutterLayer.update(i),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),this.$moveTextAreaToCursor(),void this._signal("afterRender")):(e&this.CHANGE_TEXT?(this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(i):(e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER)&&this.$showGutter&&this.$gutterLayer.update(i),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(i),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(i),void this._signal("afterRender"))},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,i=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(i+=this.scrollBarH.getHeight()),this.$maxPixelHeight&&i>this.$maxPixelHeight&&(i=this.$maxPixelHeight);var n=e>t;if(i!=this.desiredHeight||this.$size.height!=this.desiredHeight||n!=this.$vScroll){n!=this.$vScroll&&(this.$vScroll=n,this.scrollBarV.setVisible(n));var r=this.container.clientWidth;this.container.style.height=i+"px",this.$updateCachedSize(!0,this.$gutterWidth,r,i),this.desiredHeight=i,this._signal("autosize")}},this.$computeLayerConfig=function(){var e=this.session,t=this.$size,i=t.height<=2*this.lineHeight,n=this.session.getScreenLength(),r=n*this.lineHeight,o=this.$getLongestLine(),s=!i&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-o-2*this.$padding<0),a=this.$horizScroll!==s;a&&(this.$horizScroll=s,this.scrollBarH.setVisible(s));var l=this.$vScroll;this.$maxLines&&this.lineHeight>1&&this.$autosize();var c=this.scrollTop%this.lineHeight,h=t.scrollerHeight+this.lineHeight,d=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;r+=d;var u=this.scrollMargin;this.session.setScrollTop(Math.max(-u.top,Math.min(this.scrollTop,r-t.scrollerHeight+u.bottom))),this.session.setScrollLeft(Math.max(-u.left,Math.min(this.scrollLeft,o+2*this.$padding-t.scrollerWidth+u.right)));var f=!i&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-r+d<0||this.scrollTop>u.top),p=l!==f;p&&(this.$vScroll=f,this.scrollBarV.setVisible(f));var m,g,v=Math.ceil(h/this.lineHeight)-1,y=Math.max(0,Math.round((this.scrollTop-c)/this.lineHeight)),w=y+v,b=this.lineHeight;y=e.screenToDocumentRow(y,0);var C=e.getFoldLine(y);C&&(y=C.start.row),m=e.documentToScreenRow(y,0),g=e.getRowLength(y)*b,w=Math.min(e.screenToDocumentRow(w,0),e.getLength()-1),h=t.scrollerHeight+e.getRowLength(w)*b+g,c=this.scrollTop-m*b;var A=0;return this.layerConfig.width!=o&&(A=this.CHANGE_H_SCROLL),(a||p)&&(A=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),p&&(o=this.$getLongestLine())),this.layerConfig={width:o,padding:this.$padding,firstRow:y,firstRowScreen:m,lastRow:w,lineHeight:b,characterWidth:this.characterWidth,minHeight:h,maxHeight:r,offset:c,gutterOffset:b?Math.max(0,Math.ceil((c+t.height-t.scrollerHeight)/b)):0,height:this.$size.scrollerHeight},A},this.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow;this.$changedLines=null;var i=this.layerConfig;if(!(e>i.lastRow+1||t<i.firstRow))return t===1/0?(this.$showGutter&&this.$gutterLayer.update(i),void this.$textLayer.update(i)):(this.$textLayer.updateLines(i,e,t),!0)}},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,i){this.scrollCursorIntoView(e,i),this.scrollCursorIntoView(t,i)},this.scrollCursorIntoView=function(e,t,i){if(0!==this.$size.scrollerHeight){var n=this.$cursorLayer.getPixelPosition(e),r=n.left,o=n.top,s=i&&i.top||0,a=i&&i.bottom||0,l=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;l+s>o?(t&&l+s>o+this.lineHeight&&(o-=t*this.$size.scrollerHeight),0===o&&(o=-this.scrollMargin.top),this.session.setScrollTop(o)):l+this.$size.scrollerHeight-a<o+this.lineHeight&&(t&&l+this.$size.scrollerHeight-a<o-this.lineHeight&&(o+=t*this.$size.scrollerHeight),this.session.setScrollTop(o+this.lineHeight-this.$size.scrollerHeight));var c=this.scrollLeft;c>r?(r<this.$padding+2*this.layerConfig.characterWidth&&(r=-this.scrollMargin.left),this.session.setScrollLeft(r)):c+this.$size.scrollerWidth<r+this.characterWidth?this.session.setScrollLeft(Math.round(r+this.characterWidth-this.$size.scrollerWidth)):c<=this.$padding&&r-c<this.characterWidth&&this.session.setScrollLeft(0)}},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){"number"==typeof e&&(e={row:e,column:0});var i=this.$cursorLayer.getPixelPosition(e),n=this.$size.scrollerHeight-this.lineHeight,r=i.top-n*(t||0);return this.session.setScrollTop(r),r},this.STEPS=8,this.$calcSteps=function(e,t){var i=0,n=this.STEPS,r=[];for(i=0;i<n;++i)r.push(function(e,t,i){return i*(Math.pow(e-1,3)+1)+t}(i/this.STEPS,e,t-e));return r},this.scrollToLine=function(e,t,i,n){var r=this.$cursorLayer.getPixelPosition({row:e,column:0}),o=r.top;t&&(o-=this.$size.scrollerHeight/2);var s=this.scrollTop;this.session.setScrollTop(o),!1!==i&&this.animateScrolling(s,n)},this.animateScrolling=function(e,t){var i=this.scrollTop;if(this.$animatedScroll){var n=this;if(e!=i){if(this.$scrollAnimation){var r=this.$scrollAnimation.steps;if(r.length&&(e=r[0])==i)return}var o=n.$calcSteps(e,i);this.$scrollAnimation={from:e,to:i,steps:o},clearInterval(this.$timer),n.session.setScrollTop(o.shift()),n.session.$scrollTop=i,this.$timer=setInterval(function(){o.length?(n.session.setScrollTop(o.shift()),n.session.$scrollTop=i):null!=i?(n.session.$scrollTop=-1,n.session.setScrollTop(i),i=null):(n.$timer=clearInterval(n.$timer),n.$scrollAnimation=null,t&&t())},10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(t)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||(t>0&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||(e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||(e>0&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0)))},this.pixelToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=e+this.scrollLeft-i.left-this.$padding,r=n/this.characterWidth,o=Math.floor((t+this.scrollTop-i.top)/this.lineHeight),s=Math.round(r);return{row:o,column:s,side:r-s>0?1:-1,offsetX:n}},this.screenToTextCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=e+this.scrollLeft-i.left-this.$padding,r=Math.round(n/this.characterWidth),o=(t+this.scrollTop-i.top)/this.lineHeight;return this.session.screenToDocumentPosition(o,Math.max(r,0),n)},this.textToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=this.session.documentToScreenPosition(e,t),r=this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,e)?this.session.$bidiHandler.getPosLeft(n.column):Math.round(n.column*this.characterWidth)),o=n.row*this.lineHeight;return{pageX:i.left+r-this.scrollLeft,pageY:i.top+o-this.scrollTop}},this.visualizeFocus=function(){r.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){r.removeCssClass(this.container,"ace_focus")},this.showComposition=function(e){this.$composition||(this.$composition={keepTextAreaAtCursor:this.$keepTextAreaAtCursor,cssText:this.textarea.style.cssText}),this.$keepTextAreaAtCursor=!0,r.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor()},this.setCompositionText=function(e){this.$moveTextAreaToCursor()},this.hideComposition=function(){this.$composition&&(r.removeCssClass(this.textarea,"ace_composition"),this.$keepTextAreaAtCursor=this.$composition.keepTextAreaAtCursor,this.textarea.style.cssText=this.$composition.cssText,this.$composition=null)},this.setTheme=function(e,t){function i(i){if(n.$themeId!=e)return t&&t();if(!i||!i.cssClass)throw new Error("couldn't load module "+e+" or it didn't call define");r.importCssString(i.cssText,i.cssClass,n.container.ownerDocument),n.theme&&r.removeCssClass(n.container,n.theme.cssClass);var o="padding"in i?i.padding:"padding"in(n.theme||{})?4:n.$padding;n.$padding&&o!=n.$padding&&n.setPadding(o),n.$theme=i.cssClass,n.theme=i,r.addCssClass(n.container,i.cssClass),r.setCssClass(n.container,"ace_dark",i.isDark),n.$size&&(n.$size.width=0,n.$updateSizeAsync()),n._dispatchEvent("themeLoaded",{theme:i}),t&&t()}var n=this;if(this.$themeId=e,n._dispatchEvent("themeChange",{theme:e}),e&&"string"!=typeof e)i(e);else{var s=e||this.$options.theme.initialValue;o.loadModule(["theme",s],i)}},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){r.setCssClass(this.container,e,!1!==t)},this.unsetStyle=function(e){r.removeCssClass(this.container,e)},this.setCursorStyle=function(e){this.scroller.style.cursor!=e&&(this.scroller.style.cursor=e)},this.setMouseCursor=function(e){this.scroller.style.cursor=e},this.destroy=function(){this.$textLayer.destroy(),this.$cursorLayer.destroy()}}).call(g.prototype),o.defineOptions(g.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){r.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e)},initialValue:!0},showLineNumbers:{set:function(e){this.$gutterLayer.setShowLineNumbers(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){if(!this.$gutterLineHighlight)return this.$gutterLineHighlight=r.createElement("div"),this.$gutterLineHighlight.className="ace_gutter-active-line",void this.$gutter.appendChild(this.$gutterLineHighlight);this.$gutterLineHighlight.style.display=e?"":"none",this.$cursorLayer.$pixelPos&&this.$updateGutterLineHighlight()},initialValue:!1,value:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){e=+e||0,this.$scrollPastEnd!=e&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0}}),t.VirtualRenderer=g}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(e,t,i){"use strict";function n(e,t){var i=t.src;s.qualifyURL(e);try{return new Blob([i],{type:"application/javascript"})}catch(e){var n=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder,r=new n;return r.append(i),r.getBlob("application/javascript")}}function r(e,t){var i=n(e,t),r=window.URL||window.webkitURL,o=r.createObjectURL(i);return new Worker(o)}var o=e("../lib/oop"),s=e("../lib/net"),a=e("../lib/event_emitter").EventEmitter,l=e("../config"),c=function(t,i,n,o,s){if(this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),e.nameToUrl&&!e.toUrl&&(e.toUrl=e.nameToUrl),l.get("packaged")||!e.toUrl)o=o||l.moduleUrl(i.id,"worker");else{var a=this.$normalizePath;o=o||a(e.toUrl("ace/worker/worker.js",null,"_"));var c={};t.forEach(function(t){c[t]=a(e.toUrl(t,null,"_").replace(/(\.js)?(\?.*)?$/,""))})}this.$worker=r(o,i),s&&this.send("importScripts",s),this.$worker.postMessage({init:!0,tlns:c,module:i.id,classname:n}),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage};(function(){o.implement(this,a),this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var i=this.callbacks[t.id];i&&(i(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return s.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,i){if(i){var n=this.callbackId++;this.callbacks[n]=i,t.push(n)}this.send(e,t)},this.emit=function(e,t){try{this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),
"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,e.length>50&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(c.prototype);var h=function(e,t,i){this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.callbackId=1,this.callbacks={},this.messageBuffer=[];var n=null,r=!1,o=Object.create(a),s=this;this.$worker={},this.$worker.terminate=function(){},this.$worker.postMessage=function(e){s.messageBuffer.push(e),n&&(r?setTimeout(c):c())},this.setEmitSync=function(e){r=e};var c=function(){var e=s.messageBuffer.shift();e.command?n[e.command].apply(n,e.args):e.event&&o._signal(e.event,e.data)};o.postMessage=function(e){s.onMessage({data:e})},o.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},o.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},l.loadModule(["worker",t],function(e){for(n=new e[i](o);s.messageBuffer.length;)c()})};h.prototype=c.prototype,t.UIWorkerClient=h,t.WorkerClient=c,t.createWorker=r}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(e,t,i){"use strict";var n=e("./range").Range,r=e("./lib/event_emitter").EventEmitter,o=e("./lib/oop"),s=function(e,t,i,n,r,o){var s=this;this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=r,this.othersClass=o,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=n,this.$onCursorChange=function(){setTimeout(function(){s.onCursorChange()})},this.$pos=i;var a=e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=a.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)};(function(){o.implement(this,r),this.setup=function(){var e=this,t=this.doc,i=this.session;this.selectionBefore=i.selection.toJSON(),i.selection.inMultiSelectMode&&i.selection.toSingleRange(),this.pos=t.createAnchor(this.$pos.row,this.$pos.column);var r=this.pos;r.$insertRight=!0,r.detach(),r.markerId=i.addMarker(new n(r.row,r.column,r.row,r.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(i){var n=t.createAnchor(i.row,i.column);n.$insertRight=!0,n.detach(),e.others.push(n)}),i.setUndoSelect(!1)},this.showOtherMarkers=function(){if(!this.othersActive){var e=this.session,t=this;this.othersActive=!0,this.others.forEach(function(i){i.markerId=e.addMarker(new n(i.row,i.column,i.row,i.column+t.length),t.othersClass,null,!1)})}},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var i="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,r=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,o=t.start.column-this.pos.column;if(this.updateAnchors(e),r&&(this.length+=i),r&&!this.session.$fromUndo)if("insert"===e.action)for(var s=this.others.length-1;s>=0;s--){var a=this.others[s],l={row:a.row,column:a.column+o};this.doc.insertMergedLines(l,e.lines)}else if("remove"===e.action)for(var s=this.others.length-1;s>=0;s--){var a=this.others[s],l={row:a.row,column:a.column+o};this.doc.remove(new n(l.row,l.column,l.row,l.column-i))}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var e=this,t=this.session,i=function(i,r){t.removeMarker(i.markerId),i.markerId=t.addMarker(new n(i.row,i.column,i.row,i.column+e.length),r,null,!1)};i(this.pos,this.mainClass);for(var r=this.others.length;r--;)i(this.others[r],this.othersClass)}},this.onCursorChange=function(e){if(!this.$updating&&this.session){var t=this.session.selection.getCursor();t.row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e))}},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.removeEventListener("change",this.$onUpdate),this.session.selection.removeEventListener("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,i=0;i<t;i++)e.undo(!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(s.prototype),t.PlaceHolder=s}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){function n(e,t){return e.row==t.row&&e.column==t.column}function r(e){var t=e.domEvent,i=t.altKey,r=t.shiftKey,a=t.ctrlKey,l=e.getAccelKey(),c=e.getButton();if(a&&s.isMac&&(c=t.button),e.editor.inMultiSelectMode&&2==c)return void e.editor.textInput.onContextMenu(e.domEvent);if(!a&&!i&&!l)return void(0===c&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode());if(0===c){var h,d=e.editor,u=d.selection,f=d.inMultiSelectMode,p=e.getDocumentPosition(),m=u.getCursor(),g=e.inSelection()||u.isEmpty()&&n(p,m),v=e.x,y=e.y,w=function(e){v=e.clientX,y=e.clientY},b=d.session,C=d.renderer.pixelToScreenCoordinates(v,y),A=C;if(d.$mouseHandler.$enableJumpToDef)a&&i||l&&i?h=r?"block":"add":i&&d.$blockSelectEnabled&&(h="block");else if(l&&!i){if(h="add",!f&&r)return}else i&&d.$blockSelectEnabled&&(h="block");if(h&&s.isMac&&t.ctrlKey&&d.$mouseHandler.cancelContextMenu(),"add"==h){if(!f&&g)return;if(!f){var E=u.toOrientedRange();d.addSelectionMarker(E)}var F=u.rangeList.rangeAtPoint(p);d.$blockScrolling++,d.inVirtualSelectionMode=!0,r&&(F=null,E=u.ranges[0]||E,d.removeSelectionMarker(E)),d.once("mouseup",function(){var e=u.toOrientedRange();F&&e.isEmpty()&&n(F.cursor,e.cursor)?u.substractPoint(e.cursor):(r?u.substractPoint(E.cursor):E&&(d.removeSelectionMarker(E),u.addRange(E)),u.addRange(e)),d.$blockScrolling--,d.inVirtualSelectionMode=!1})}else if("block"==h){e.stop(),d.inVirtualSelectionMode=!0;var x,S=[],_=function(){var e=d.renderer.pixelToScreenCoordinates(v,y),t=b.screenToDocumentPosition(e.row,e.column,e.offsetX);n(A,e)&&n(t,u.lead)||(A=e,d.$blockScrolling++,d.selection.moveToPosition(t),d.renderer.scrollCursorIntoView(),d.removeSelectionMarkers(S),S=u.rectangularRangeBlock(A,C),d.$mouseHandler.$clickSelection&&1==S.length&&S[0].isEmpty()&&(S[0]=d.$mouseHandler.$clickSelection.clone()),S.forEach(d.addSelectionMarker,d),d.updateSelectionMarkers(),d.$blockScrolling--)};d.$blockScrolling++,f&&!l?u.toSingleRange():!f&&l&&(x=u.toOrientedRange(),d.addSelectionMarker(x)),r?C=b.documentToScreenPosition(u.lead):u.moveToPosition(p),d.$blockScrolling--,A={row:-1,column:-1};var k=function(e){clearInterval($),d.removeSelectionMarkers(S),S.length||(S=[u.toOrientedRange()]),d.$blockScrolling++,x&&(d.removeSelectionMarker(x),u.toSingleRange(x));for(var t=0;t<S.length;t++)u.addRange(S[t]);d.inVirtualSelectionMode=!1,d.$mouseHandler.$clickSelection=null,d.$blockScrolling--},D=_;o.capture(d.container,w,k);var $=setInterval(function(){D()},20);return e.preventDefault()}}}var o=e("../lib/event"),s=e("../lib/useragent");t.onMouseDown=r}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(e,t,i){t.defaultCommands=[{name:"addCursorAbove",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"splitIntoLines",exec:function(e){e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"alignCursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];var n=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new n(t.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(e,t,i){function n(e,t,i){return m.$options.wrap=!0,m.$options.needle=t,m.$options.backwards=-1==i,m.find(e)}function r(e,t){return e.row==t.row&&e.column==t.column}function o(e){e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=t.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",h),e.commands.addCommands(f.defaultCommands),s(e))}function s(e){function t(t){n&&(e.renderer.setMouseCursor(""),n=!1)}var i=e.textInput.getElement(),n=!1;d.addListener(i,"keydown",function(i){var r=18==i.keyCode&&!(i.ctrlKey||i.shiftKey||i.metaKey);e.$blockSelectEnabled&&r?n||(e.renderer.setMouseCursor("crosshair"),n=!0):n&&t()}),d.addListener(i,"keyup",t),d.addListener(i,"blur",t)}var a=e("./range_list").RangeList,l=e("./range").Range,c=e("./selection").Selection,h=e("./mouse/multi_select_handler").onMouseDown,d=e("./lib/event"),u=e("./lib/lang"),f=e("./commands/multi_select_commands");t.commands=f.defaultCommands.concat(f.multiSelectCommands);var p=e("./search").Search,m=new p,g=e("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(g.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var i=this.toOrientedRange();if(this.rangeList.add(i),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(i),this.$onAddRange(i)}e.cursor||(e.cursor=e.end);var n=this.rangeList.add(e);return this.$onAddRange(e),n.length&&this.$onRemoveRange(n),this.rangeCount>1&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){var t=this.rangeList.substractPoint(e);if(t)return this.$onRemoveRange(t),t[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length?this.$onRemoveRange(e):this.ranges[0]&&this.fromOrientedRange(this.ranges[0])},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){if(this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode){var t=this.rangeList.ranges.pop();e.push(t),this.rangeCount=0}for(var i=e.length;i--;){var n=this.ranges.indexOf(e[i]);this.ranges.splice(n,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new a,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],i=l.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{var i=this.getRange(),n=this.isBackwards(),r=i.start.row,o=i.end.row;if(r==o){if(n)var s=i.end,a=i.start;else var s=i.start,a=i.end;return this.addRange(l.fromPoints(a,a)),void this.addRange(l.fromPoints(s,s))}var c=[],h=this.getLineRange(r,!0);h.start.column=i.start.column,c.push(h);for(var d=r+1;d<o;d++)c.push(this.getLineRange(d,!0));h=this.getLineRange(o,!0),h.end.column=i.end.column,c.push(h),c.forEach(this.addRange,this)}},this.toggleBlockSelection=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],i=l.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{var n=this.session.documentToScreenPosition(this.selectionLead),r=this.session.documentToScreenPosition(this.selectionAnchor);this.rectangularRangeBlock(n,r).forEach(this.addRange,this)}},this.rectangularRangeBlock=function(e,t,i){var n=[],o=e.column<t.column;if(o)var s=e.column,a=t.column,c=e.offsetX,h=t.offsetX;else var s=t.column,a=e.column,c=t.offsetX,h=e.offsetX;var d=e.row<t.row;if(d)var u=e.row,f=t.row;else var u=t.row,f=e.row;s<0&&(s=0),u<0&&(u=0),u==f&&(i=!0);for(var p=u;p<=f;p++){var m=l.fromPoints(this.session.screenToDocumentPosition(p,s,c),this.session.screenToDocumentPosition(p,a,h));if(m.isEmpty()){if(g&&r(m.end,g))break;var g=m.end}m.cursor=o?m.start:m.end,n.push(m)}if(d&&n.reverse(),!i){for(var v=n.length-1;n[v].isEmpty()&&v>0;)v--;if(v>0)for(var y=0;n[y].isEmpty();)y++;for(var w=v;w>=y;w--)n[w].isEmpty()&&n.splice(w,1)}return n}}.call(c.prototype);var v=e("./editor").Editor;(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){if(e.marker){this.session.removeMarker(e.marker);var t=this.session.$selectionMarkers.indexOf(e);-1!=t&&this.session.$selectionMarkers.splice(t,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length}},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,i=e.length;i--;){var n=e[i];if(n.marker){this.session.removeMarker(n.marker);var r=t.indexOf(n);-1!=r&&t.splice(r,1)}}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(f.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(f.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t=e.command,i=e.editor;if(i.multiSelect){if(t.multiSelectAction)"forEach"==t.multiSelectAction?n=i.forEachSelection(t,e.args):"forEachLine"==t.multiSelectAction?n=i.forEachSelection(t,e.args,!0):"single"==t.multiSelectAction?(i.exitMultiSelectMode(),n=t.exec(i,e.args||{})):n=t.multiSelectAction(i,e.args||{});else{var n=t.exec(i,e.args||{});i.multiSelect.addRange(i.multiSelect.toOrientedRange()),i.multiSelect.mergeOverlappingRanges()}return n}},this.forEachSelection=function(e,t,i){if(!this.inVirtualSelectionMode){var n,r=i&&i.keepOrder,o=1==i||i&&i.$byLines,s=this.session,a=this.selection,l=a.rangeList,h=(r?a:l).ranges;if(!h.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var d=a._eventRegistry;a._eventRegistry={};var u=new c(s);this.inVirtualSelectionMode=!0;for(var f=h.length;f--;){if(o)for(;f>0&&h[f].start.row==h[f-1].end.row;)f--;u.fromOrientedRange(h[f]),u.index=f,this.selection=s.selection=u;var p=e.exec?e.exec(this,t||{}):e(this,t||{});n||void 0===p||(n=p),u.toOrientedRange(h[f])}u.detach(),this.selection=s.selection=a,this.inVirtualSelectionMode=!1,a._eventRegistry=d,a.mergeOverlappingRanges();var m=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),m&&m.from==m.to&&this.renderer.animateScrolling(m.from),n}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,i=[],n=0;n<t.length;n++)i.push(this.session.getTextRange(t[n]));var r=this.session.getDocument().getNewLineCharacter();e=i.join(r),e.length==(i.length-1)*r.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var i=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&t==this.multiSelect.anchor)return;var n=t==this.multiSelect.anchor?i.cursor==i.start?i.end:i.start:i.cursor;n.row==t.row&&this.session.$clipPositionToDocument(n.row,n.column).column==t.column||this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange())}},this.findAll=function(e,t,i){if(t=t||{},t.needle=e||t.needle,void 0==t.needle){var n=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();t.needle=this.session.getTextRange(n)}this.$search.set(t);var r=this.$search.findAll(this.session);if(!r.length)return 0;this.$blockScrolling+=1;var o=this.multiSelect;i||o.toSingleRange(r[0]);for(var s=r.length;s--;)o.addRange(r[s],!0);return n&&o.rangeList.rangeAtPoint(n.start)&&o.addRange(n,!0),this.$blockScrolling-=1,r.length},this.selectMoreLines=function(e,t){var i=this.selection.toOrientedRange(),n=i.cursor==i.end,r=this.session.documentToScreenPosition(i.cursor);this.selection.$desiredColumn&&(r.column=this.selection.$desiredColumn);var o=this.session.screenToDocumentPosition(r.row+e,r.column);if(i.isEmpty())var s=o;else var a=this.session.documentToScreenPosition(n?i.end:i.start),s=this.session.screenToDocumentPosition(a.row+e,a.column);if(n){var c=l.fromPoints(o,s);c.cursor=c.start}else{var c=l.fromPoints(s,o);c.cursor=c.end}if(c.desiredColumn=r.column,this.selection.inMultiSelectMode){if(t)var h=i.cursor}else this.selection.addRange(i);this.selection.addRange(c),h&&this.selection.substractPoint(h)},this.transposeSelections=function(e){for(var t=this.session,i=t.multiSelect,n=i.ranges,r=n.length;r--;){var o=n[r];if(o.isEmpty()){var s=t.getWordRange(o.start.row,o.start.column);o.start.row=s.start.row,o.start.column=s.start.column,o.end.row=s.end.row,o.end.column=s.end.column}}i.mergeOverlappingRanges();for(var a=[],r=n.length;r--;){var o=n[r];a.unshift(t.getTextRange(o))}e<0?a.unshift(a.pop()):a.push(a.shift());for(var r=n.length;r--;){var o=n[r],s=o.clone();t.replace(o,a[r]),o.start.row=s.start.row,o.start.column=s.start.column}},this.selectMore=function(e,t,i){var r=this.session,o=r.multiSelect,s=o.toOrientedRange();if(!s.isEmpty()||(s=r.getWordRange(s.start.row,s.start.column),s.cursor=-1==e?s.start:s.end,this.multiSelect.addRange(s),!i)){var a=r.getTextRange(s),l=n(r,a,e);l&&(l.cursor=-1==e?l.start:l.end,this.$blockScrolling+=1,this.session.unfold(l),this.multiSelect.addRange(l),this.$blockScrolling-=1,this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(s.cursor)}},this.alignCursors=function(){var e=this.session,t=e.multiSelect,i=t.ranges,n=-1,r=i.filter(function(e){if(e.cursor.row==n)return!0;n=e.cursor.row});if(i.length&&r.length!=i.length-1){r.forEach(function(e){t.substractPoint(e.cursor)});var o=0,s=1/0,a=i.map(function(t){var i=t.cursor,n=e.getLine(i.row),r=n.substr(i.column).search(/\S/g);return-1==r&&(r=0),i.column>o&&(o=i.column),r<s&&(s=r),r});i.forEach(function(t,i){var n=t.cursor,r=o-n.column,c=a[i]-s;r>c?e.insert(n,u.stringRepeat(" ",r-c)):e.remove(new l(n.row,n.column,n.row,n.column-r+c)),t.start.column=t.end.column=o,t.start.row=t.end.row=n.row,t.cursor=t.end}),t.fromOrientedRange(i[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var c=this.selection.getRange(),h=c.start.row,d=c.end.row,f=h==d;if(f){var p,m=this.session.getLength();do{p=this.session.getLine(d)}while(/[=:]/.test(p)&&++d<m);do{p=this.session.getLine(h)}while(/[=:]/.test(p)&&--h>0);h<0&&(h=0),d>=m&&(d=m-1)}var g=this.session.removeFullLines(h,d);g=this.$reAlignText(g,f),this.session.insert({row:h,column:0},g.join("\n")+"\n"),f||(c.start.column=0,c.end.column=g[g.length-1].length),this.selection.setRange(c)}},this.$reAlignText=function(e,t){function i(e){return u.stringRepeat(" ",e)}function n(e){return e[2]?i(s)+e[2]+i(a-e[2].length+l)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}function r(e){return e[2]?i(s+a-e[2].length)+e[2]+i(l," ")+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}function o(e){return e[2]?i(s)+e[2]+i(l)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}var s,a,l,c=!0,h=!0;return e.map(function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?null==s?(s=t[1].length,a=t[2].length,l=t[3].length,t):(s+a+l!=t[1].length+t[2].length+t[3].length&&(h=!1),s!=t[1].length&&(c=!1),s>t[1].length&&(s=t[1].length),a<t[2].length&&(a=t[2].length),l>t[3].length&&(l=t[3].length),t):[e]}).map(t?n:c?h?r:n:o)}}).call(v.prototype),t.onSessionChange=function(e){var t=e.session;t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect;var i=e.oldSession;i&&(i.multiSelect.off("addRange",this.$onAddRange),i.multiSelect.off("removeRange",this.$onRemoveRange),i.multiSelect.off("multiSelect",this.$onMultiSelect),i.multiSelect.off("singleSelect",this.$onSingleSelect),i.multiSelect.lead.off("change",this.$checkMultiselectChange),i.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},t.MultiSelect=o,e("./config").defineOptions(v.prototype,"editor",{enableMultiselect:{set:function(e){o(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",h)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",h))},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../../range").Range,r=t.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);return this.foldingStartMarker.test(n)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(n)?"end":""},this.getFoldWidgetRange=function(e,t,i){return null},this.indentationBlock=function(e,t,i){var r=e.getLine(t),o=r.search(/\S/);if(-1!=o){for(var s=i||r.length,a=e.getLength(),l=t,c=t;++t<a;){var h=e.getLine(t).search(/\S/);if(-1!=h){if(h<=o)break;c=t}}if(c>l){var d=e.getLine(c).length;return new n(l,s,c,d)}}},this.openingBracketBlock=function(e,t,i,r,o){var s={row:i,column:r+1},a=e.$findClosingBracket(t,s,o);if(a){var l=e.foldWidgets[a.row];return null==l&&(l=e.getFoldWidget(a.row)),"start"==l&&a.row>s.row&&(a.row--,a.column=e.getLine(a.row).length),n.fromPoints(s,a)}},this.closingBracketBlock=function(e,t,i,r,o){var s={row:i,column:r},a=e.$findOpeningBracket(t,s);if(a)return a.column++,s.column--,n.fromPoints(a,s)}}).call(r.prototype)}),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {\tbackground: #f0f0f0;\tcolor: #333;\t}\t.ace-tm .ace_print-margin {\twidth: 1px;\tbackground: #e8e8e8;\t}\t.ace-tm .ace_fold {\tbackground-color: #6B72E6;\t}\t.ace-tm {\tbackground-color: #FFFFFF;\tcolor: black;\t}\t.ace-tm .ace_cursor {\tcolor: black;\t}\t.ace-tm .ace_invisible {\tcolor: rgb(191, 191, 191);\t}\t.ace-tm .ace_storage,\t.ace-tm .ace_keyword {\tcolor: blue;\t}\t.ace-tm .ace_constant {\tcolor: rgb(197, 6, 11);\t}\t.ace-tm .ace_constant.ace_buildin {\tcolor: rgb(88, 72, 246);\t}\t.ace-tm .ace_constant.ace_language {\tcolor: rgb(88, 92, 246);\t}\t.ace-tm .ace_constant.ace_library {\tcolor: rgb(6, 150, 14);\t}\t.ace-tm .ace_invalid {\tbackground-color: rgba(255, 0, 0, 0.1);\tcolor: red;\t}\t.ace-tm .ace_support.ace_function {\tcolor: rgb(60, 76, 114);\t}\t.ace-tm .ace_support.ace_constant {\tcolor: rgb(6, 150, 14);\t}\t.ace-tm .ace_support.ace_type,\t.ace-tm .ace_support.ace_class {\tcolor: rgb(109, 121, 222);\t}\t.ace-tm .ace_keyword.ace_operator {\tcolor: rgb(104, 118, 135);\t}\t.ace-tm .ace_string {\tcolor: rgb(3, 106, 7);\t}\t.ace-tm .ace_comment {\tcolor: rgb(76, 136, 107);\t}\t.ace-tm .ace_comment.ace_doc {\tcolor: rgb(0, 102, 255);\t}\t.ace-tm .ace_comment.ace_doc.ace_tag {\tcolor: rgb(128, 159, 191);\t}\t.ace-tm .ace_constant.ace_numeric {\tcolor: rgb(0, 0, 205);\t}\t.ace-tm .ace_variable {\tcolor: rgb(49, 132, 149);\t}\t.ace-tm .ace_xml-pe {\tcolor: rgb(104, 104, 91);\t}\t.ace-tm .ace_entity.ace_name.ace_function {\tcolor: #0000A2;\t}\t.ace-tm .ace_heading {\tcolor: rgb(12, 7, 255);\t}\t.ace-tm .ace_list {\tcolor:rgb(185, 6, 144);\t}\t.ace-tm .ace_meta.ace_tag {\tcolor:rgb(0, 22, 142);\t}\t.ace-tm .ace_string.ace_regex {\tcolor: rgb(255, 0, 0)\t}\t.ace-tm .ace_marker-layer .ace_selection {\tbackground: rgb(181, 213, 255);\t}\t.ace-tm.ace_multiselect .ace_selection.ace_start {\tbox-shadow: 0 0 3px 0px white;\t}\t.ace-tm .ace_marker-layer .ace_step {\tbackground: rgb(252, 255, 0);\t}\t.ace-tm .ace_marker-layer .ace_stack {\tbackground: rgb(164, 229, 101);\t}\t.ace-tm .ace_marker-layer .ace_bracket {\tmargin: -1px 0 0 -1px;\tborder: 1px solid rgb(192, 192, 192);\t}\t.ace-tm .ace_marker-layer .ace_active-line {\tbackground: rgba(0, 0, 0, 0.07);\t}\t.ace-tm .ace_gutter-active-line {\tbackground-color : #dcdcdc;\t}\t.ace-tm .ace_marker-layer .ace_selected-word {\tbackground: rgb(250, 250, 255);\tborder: 1px solid rgb(200, 200, 250);\t}\t.ace-tm .ace_indent-guide {\tbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;\t}\t',e("../lib/dom").importCssString(t.cssText,t.cssClass)}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/range"],function(e,t,i){"use strict";function n(e){this.session=e,this.session.widgetManager=this,this.session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}var r=(e("./lib/oop"),e("./lib/dom"));e("./range").Range;(function(){this.getRowLength=function(e){var t;return t=this.lineWidgets?this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0:0,this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var e=0;return this.lineWidgets.forEach(function(t){t&&t.rowCount&&!t.hidden&&(e+=t.rowCount)}),e},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),this.editor=e,e&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(e){var t=this.editor;if(t){this.editor=null,t.widgetManager=null,t.renderer.off("beforeRender",this.measureWidgets),t.renderer.off("afterRender",this.renderWidgets);var i=this.session.lineWidgets;i&&i.forEach(function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))})}},this.updateOnFold=function(e,t){var i=t.lineWidgets;if(i&&e.action){for(var n=e.data,r=n.start.row,o=n.end.row,s="add"==e.action,a=r+1;a<o;a++)i[a]&&(i[a].hidden=s);i[o]&&(s?i[r]?i[o].hidden=s:i[r]=i[o]:(i[r]==i[o]&&(i[r]=void 0),i[o].hidden=s))}},this.updateOnChange=function(e){var t=this.session.lineWidgets;if(t){var i=e.start.row,n=e.end.row-i;if(0===n);else if("remove"==e.action){var r=t.splice(i+1,n);r.forEach(function(e){e&&this.removeLineWidget(e)},this),this.$updateRows()}else{var o=new Array(n);o.unshift(i,0),t.splice.apply(t,o),this.$updateRows()}}},this.$updateRows=function(){var e=this.session.lineWidgets;if(e){var t=!0;e.forEach(function(e,i){if(e)for(t=!1,e.row=i;e.$oldWidget;)e.$oldWidget.row=i,e=e.$oldWidget}),t&&(this.session.lineWidgets=null)}},this.addLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];t&&(e.$oldWidget=t,t.el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1)),this.session.lineWidgets[e.row]=e,e.session=this.session;var i=this.editor.renderer;e.html&&!e.el&&(e.el=r.createElement("div"),e.el.innerHTML=e.html),e.el&&(r.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,i.container.appendChild(e.el),e._inDocument=!0),e.coverGutter||(e.el.style.zIndex=3),null==e.pixelHeight&&(e.pixelHeight=e.el.offsetHeight),null==e.rowCount&&(e.rowCount=e.pixelHeight/i.layerConfig.lineHeight);var n=this.session.getFoldAt(e.row,0);if(e.$fold=n,n){var o=this.session.lineWidgets;e.row!=n.end.row||o[n.start.row]?e.hidden=!0:o[n.start.row]=e}return this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,i),this.onWidgetChanged(e),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,i=t&&t[e],n=[];i;)n.push(i),i=i.$oldWidget;return n},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var i=this.session._changedWidgets,n=t.layerConfig;if(i&&i.length){for(var r=1/0,o=0;o<i.length;o++){var s=i[o];if(s&&s.el&&s.session==this.session){if(!s._inDocument){if(this.session.lineWidgets[s.row]!=s)continue;s._inDocument=!0,t.container.appendChild(s.el)}s.h=s.el.offsetHeight,s.fixedWidth||(s.w=s.el.offsetWidth,s.screenWidth=Math.ceil(s.w/n.characterWidth));var a=s.h/n.lineHeight;s.coverLine&&(a-=this.session.getRowLineCount(s.row))<0&&(a=0),s.rowCount!=a&&(s.rowCount=a,s.row<r&&(r=s.row))}}r!=1/0&&(this.session._emit("changeFold",{data:{start:{row:r}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var i=t.layerConfig,n=this.session.lineWidgets;if(n){for(var r=Math.min(this.firstRow,i.firstRow),o=Math.max(this.lastRow,i.lastRow,n.length);r>0&&!n[r];)r--;this.firstRow=i.firstRow,this.lastRow=i.lastRow,t.$cursorLayer.config=i;for(var s=r;s<=o;s++){var a=n[s];if(a&&a.el)if(a.hidden)a.el.style.top=-100-(a.pixelHeight||0)+"px";else{a._inDocument||(a._inDocument=!0,t.container.appendChild(a.el));var l=t.$cursorLayer.getPixelPosition({row:s,column:0},!0).top;a.coverLine||(l+=i.lineHeight*this.session.getRowLineCount(a.row)),a.el.style.top=l-i.offset+"px";var c=a.coverGutter?0:t.gutterWidth;a.fixedWidth||(c-=t.scrollLeft),a.el.style.left=c+"px",a.fullWidth&&a.screenWidth&&(a.el.style.minWidth=i.width+2*i.padding+"px"),a.fixedWidth?a.el.style.right=t.scrollBar.getWidth()+"px":a.el.style.right=""}}}}}).call(n.prototype),t.LineWidgets=n}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],function(e,t,i){"use strict";function n(e,t,i){for(var n=0,r=e.length-1;n<=r;){var o=n+r>>1,s=i(t,e[o]);if(s>0)n=o+1;else{if(!(s<0))return o;r=o-1}}return-(n+1)}function r(e,t,i){var r=e.getAnnotations().sort(a.comparePoints);if(r.length){var o=n(r,{row:t,column:-1},a.comparePoints);o<0&&(o=-o-1),o>=r.length?o=i>0?0:r.length-1:0===o&&i<0&&(o=r.length-1);var s=r[o];if(s&&i){if(s.row===t){do{s=r[o+=i]}while(s&&s.row===t);if(!s)return r.slice()}var l=[];t=s.row;do{l[i<0?"unshift":"push"](s),s=r[o+=i]}while(s&&s.row==t);return l.length&&l}}}var o=e("../line_widgets").LineWidgets,s=e("../lib/dom"),a=e("../range").Range;t.showErrorMarker=function(e,t){var i=e.session;i.widgetManager||(i.widgetManager=new o(i),i.widgetManager.attach(e));var n=e.getCursorPosition(),a=n.row,l=i.widgetManager.getWidgetsAtRow(a).filter(function(e){return"errorMarker"==e.type})[0];l?l.destroy():a-=t;var c,h=r(i,a,t);if(h){var d=h[0];n.column=(d.pos&&"number"!=typeof d.column?d.pos.sc:d.column)||0,n.row=d.row,c=e.renderer.$gutterLayer.$annotations[n.row]}else{if(l)return;c={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(n.row),e.selection.moveToPosition(n);var u={row:n.row,fixedWidth:!0,coverGutter:!0,el:s.createElement("div"),type:"errorMarker"},f=u.el.appendChild(s.createElement("div")),p=u.el.appendChild(s.createElement("div"));p.className="error_widget_arrow "+c.className;var m=e.renderer.$cursorLayer.getPixelPosition(n).left;p.style.left=m+e.renderer.gutterWidth-5+"px",u.el.className="error_widget_wrapper",f.className="error_widget "+c.className,f.innerHTML=c.text.join("<br>"),f.appendChild(s.createElement("div"));var g=function(e,t,i){if(0===t&&("esc"===i||"return"===i))return u.destroy(),{command:"null"}};u.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(g),i.widgetManager.removeLineWidget(u),e.off("changeSelection",u.destroy),e.off("changeSession",u.destroy),e.off("mouseup",u.destroy),e.off("change",u.destroy))},e.keyBinding.addKeyboardHandler(g),e.on("changeSelection",u.destroy),e.on("changeSession",u.destroy),e.on("mouseup",u.destroy),e.on("change",u.destroy),e.session.widgetManager.addLineWidget(u),u.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:u.el.offsetHeight})},s.importCssString("\t    .error_widget_wrapper {\t        background: inherit;\t        color: inherit;\t        border:none\t    }\t    .error_widget {\t        border-top: solid 2px;\t        border-bottom: solid 2px;\t        margin: 5px 0;\t        padding: 10px 40px;\t        white-space: pre-wrap;\t    }\t    .error_widget.ace_error, .error_widget_arrow.ace_error{\t        border-color: #ff5a5a\t    }\t    .error_widget.ace_warning, .error_widget_arrow.ace_warning{\t        border-color: #F1D817\t    }\t    .error_widget.ace_info, .error_widget_arrow.ace_info{\t        border-color: #5a5a5a\t    }\t    .error_widget.ace_ok, .error_widget_arrow.ace_ok{\t        border-color: #5aaa5a\t    }\t    .error_widget_arrow {\t        position: absolute;\t        border: solid 5px;\t        border-top-color: transparent!important;\t        border-right-color: transparent!important;\t        border-left-color: transparent!important;\t        top: -5px;\t    }\t","")}),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],function(e,t,n){"use strict";e("./lib/fixoldbrowsers");var r=e("./lib/dom"),o=e("./lib/event"),s=e("./editor").Editor,a=e("./edit_session").EditSession,l=e("./undomanager").UndoManager,c=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),t.config=e("./config"),t.acequire=e,t.define=i(53),t.edit=function(e){if("string"==typeof e){var i=e;if(!(e=document.getElementById(i)))throw new Error("ace.edit can't find div #"+i)}if(e&&e.env&&e.env.editor instanceof s)return e.env.editor;var n="";if(e&&/input|textarea/i.test(e.tagName)){var a=e;n=a.value,e=r.createElement("pre"),a.parentNode.replaceChild(e,a)}else e&&(n=r.getInnerText(e),e.innerHTML="");var l=t.createEditSession(n),h=new s(new c(e));h.setSession(l);var d={document:l,editor:h,onResize:h.resize.bind(h,null)};return a&&(d.textarea=a),o.addListener(window,"resize",d.onResize),h.on("destroy",function(){o.removeListener(window,"resize",d.onResize),d.editor.container.env=null}),h.container.env=h.env=d,h},t.createEditSession=function(e,t){var i=new a(e,t);return i.setUndoManager(new l),i},t.EditSession=a,t.UndoManager=l,t.version="1.2.9"}),function(){ace.acequire(["ace/ace"],function(e){e&&(e.config.init(!0),e.define=ace.define),window.ace||(window.ace=e);for(var t in e)e.hasOwnProperty(t)&&(window.ace[t]=e[t])})}(),e.exports=window.ace.acequire("ace/ace")},function(e,t){e.exports=function(){throw new Error("define cannot be used indirect")}},function(e,t,i){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";var n=e("../lib/oop"),r=e("./text_highlight_rules").TextHighlightRules,o=function(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}};n.inherits(o,r),t.JsonHighlightRules=o}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../range").Range,r=function(){};(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t),r=i.match(/^(\s*\})/);if(!r)return 0;var o=r[1].length,s=e.findMatchingBracket({row:t,column:o});if(!s||s.row==t)return 0;var a=this.$getIndent(e.getLine(s.row));e.replace(new n(t,0,t,o-1),a)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(r.prototype),t.MatchingBraceOutdent=r}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),r=e("../../range").Range,o=e("./fold_mode").FoldMode,s=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(s,o),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";var r=this._getFoldWidgetBase(e,t,i);return!r&&this.startRegionRe.test(n)?"start":r},this.getFoldWidgetRange=function(e,t,i,n){var r=e.getLine(i);if(this.startRegionRe.test(r))return this.getCommentRegionBlock(e,r,i);var o=r.match(this.foldingStartMarker);if(o){var s=o.index;if(o[1])return this.openingBracketBlock(e,o[1],i,s);var a=e.getCommentFoldRange(i,s+o[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t){var o=r.match(this.foldingStopMarker);if(o){var s=o.index+o[0].length;return o[1]?this.closingBracketBlock(e,o[1],i,s):e.getCommentFoldRange(i,s,-1)}}},this.getSectionRange=function(e,t){var i=e.getLine(t),n=i.search(/\S/),o=t,s=i.length;t+=1;for(var a=t,l=e.getLength();++t<l;){i=e.getLine(t);var c=i.search(/\S/);if(-1!==c){if(n>c)break;var h=this.getFoldWidgetRange(e,"all",t);if(h){if(h.start.row<=o)break;if(h.isMultiLine())t=h.end.row;else if(n==c)break}a=t}}return new r(o,s,a,e.getLine(a).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),o=e.getLength(),s=i,a=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,l=1;++i<o;){t=e.getLine(i);var c=a.exec(t);if(c&&(c[1]?l--:l++,!l))break}var h=i;if(h>s)return new r(s,n,h,t.length)}}.call(s.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,n){"use strict";var r=e("../lib/oop"),o=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,h=e("../worker/worker_client").WorkerClient,d=function(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c};r.inherits(d,o),function(){this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);if("start"==e){t.match(/^.*[\{\(\[]\s*$/)&&(n+=i)}return n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(e){var t=new h(["ace"],i(55),"JsonWorker");return t.attachToDocument(e.getDocument()),t.on("annotate",function(t){e.setAnnotations(t.data)}),t.on("terminate",function(){e.clearAnnotations()}),t},this.$id="ace/mode/json"}.call(d.prototype),t.Mode=d})},function(e,t){e.exports.id="ace/mode/json_worker",
e.exports.src='"no use strict";!function(window){function resolveModuleId(id,paths){for(var testPath=id,tail="";testPath;){var alias=paths[testPath];if("string"==typeof alias)return alias+tail;if(alias)return alias.location.replace(/\\/*$/,"/")+(tail||alias.main||alias.name);if(alias===!1)return"";var i=testPath.lastIndexOf("/");if(-1===i)break;tail=testPath.substr(i)+tail,testPath=testPath.slice(0,i)}return id}if(!(void 0!==window.window&&window.document||window.acequire&&window.define)){window.console||(window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console),window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,data:err.data,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function acequire(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;if(!window.acequire.tlns)return console.log("unable to load "+id);var path=resolveModuleId(id,window.acequire.tlns);return".js"!=path.slice(-3)&&(path+=".js"),window.acequire.id=id,window.acequire.modules[id]={},importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},acequire.tlns={},window.initBaseUrls=function(topLevelNamespaces){for(var i in topLevelNamespaces)acequire.tlns[i]=topLevelNamespaces[i]},window.initSender=function(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.event&&sender)sender._signal(msg.event,msg.data);else if(msg.command)if(main[msg.command])main[msg.command].apply(main,msg.args);else{if(!window[msg.command])throw Error("Unknown command:"+msg.command);window[msg.command].apply(window,msg.args)}else if(msg.init){window.initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=window.initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}}}}(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/apply_delta",["require","exports","module"],function(acequire,exports){"use strict";exports.applyDelta=function(docLines,delta){var row=delta.start.row,startColumn=delta.start.column,line=docLines[row]||"";switch(delta.action){case"insert":var lines=delta.lines;if(1===lines.length)docLines[row]=line.substring(0,startColumn)+delta.lines[0]+line.substring(startColumn);else{var args=[row,1].concat(delta.lines);docLines.splice.apply(docLines,args),docLines[row]=line.substring(0,startColumn)+docLines[row],docLines[row+delta.lines.length-1]+=line.substring(startColumn)}break;case"remove":var endColumn=delta.end.column,endRow=delta.end.row;row===endRow?docLines[row]=line.substring(0,startColumn)+line.substring(endColumn):docLines.splice(row,endRow-row+1,line.substring(0,startColumn)+docLines[endRow].substring(endColumn))}}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){function $pointsInOrder(point1,point2,equalPointsInOrder){var bColIsAfter=equalPointsInOrder?point1.column<=point2.column:point1.column<point2.column;return point1.row<point2.row||point1.row==point2.row&&bColIsAfter}function $getTransformedPoint(delta,point,moveIfEqual){var deltaIsInsert="insert"==delta.action,deltaRowShift=(deltaIsInsert?1:-1)*(delta.end.row-delta.start.row),deltaColShift=(deltaIsInsert?1:-1)*(delta.end.column-delta.start.column),deltaStart=delta.start,deltaEnd=deltaIsInsert?deltaStart:delta.end;return $pointsInOrder(point,deltaStart,moveIfEqual)?{row:point.row,column:point.column}:$pointsInOrder(deltaEnd,point,!moveIfEqual)?{row:point.row+deltaRowShift,column:point.column+(point.row==deltaEnd.row?deltaColShift:0)}:{row:deltaStart.row,column:deltaStart.column}}oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(delta){if(!(delta.start.row==delta.end.row&&delta.start.row!=this.row||delta.start.row>this.row)){var point=$getTransformedPoint(delta,{row:this.row,column:this.column},this.$insertRight);this.setPosition(point.row,point.column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),applyDelta=acequire("./apply_delta").applyDelta,EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(textOrLines){this.$lines=[""],0===textOrLines.length?this.$lines=[""]:Array.isArray(textOrLines)?this.insertMergedLines({row:0,column:0},textOrLines):this.insert({row:0,column:0},textOrLines)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength()-1;this.remove(new Range(0,0,len,this.getLine(len).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){return this.getLinesForRange(range).join(this.getNewLineCharacter())},this.getLinesForRange=function(range){var lines;if(range.start.row===range.end.row)lines=[this.getLine(range.start.row).substring(range.start.column,range.end.column)];else{lines=this.getLines(range.start.row,range.end.row),lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column))}return lines},this.insertLines=function(row,lines){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(row,lines)},this.removeLines=function(firstRow,lastRow){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(firstRow,lastRow)},this.insertNewLine=function(position){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead."),this.insertMergedLines(position,["",""])},this.insert=function(position,text){return 1>=this.getLength()&&this.$detectNewLine(text),this.insertMergedLines(position,this.$split(text))},this.insertInLine=function(position,text){var start=this.clippedPos(position.row,position.column),end=this.pos(position.row,position.column+text.length);return this.applyDelta({start:start,end:end,action:"insert",lines:[text]},!0),this.clonePos(end)},this.clippedPos=function(row,column){var length=this.getLength();void 0===row?row=length:0>row?row=0:row>=length&&(row=length-1,column=void 0);var line=this.getLine(row);return void 0==column&&(column=line.length),column=Math.min(Math.max(column,0),line.length),{row:row,column:column}},this.clonePos=function(pos){return{row:pos.row,column:pos.column}},this.pos=function(row,column){return{row:row,column:column}},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):(position.row=Math.max(0,position.row),position.column=Math.min(Math.max(position.column,0),this.getLine(position.row).length)),position},this.insertFullLines=function(row,lines){row=Math.min(Math.max(row,0),this.getLength());var column=0;this.getLength()>row?(lines=lines.concat([""]),column=0):(lines=[""].concat(lines),row--,column=this.$lines[row].length),this.insertMergedLines({row:row,column:column},lines)},this.insertMergedLines=function(position,lines){var start=this.clippedPos(position.row,position.column),end={row:start.row+lines.length-1,column:(1==lines.length?start.column:0)+lines[lines.length-1].length};return this.applyDelta({start:start,end:end,action:"insert",lines:lines}),this.clonePos(end)},this.remove=function(range){var start=this.clippedPos(range.start.row,range.start.column),end=this.clippedPos(range.end.row,range.end.column);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})}),this.clonePos(start)},this.removeInLine=function(row,startColumn,endColumn){var start=this.clippedPos(row,startColumn),end=this.clippedPos(row,endColumn);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})},!0),this.clonePos(start)},this.removeFullLines=function(firstRow,lastRow){firstRow=Math.min(Math.max(0,firstRow),this.getLength()-1),lastRow=Math.min(Math.max(0,lastRow),this.getLength()-1);var deleteFirstNewLine=lastRow==this.getLength()-1&&firstRow>0,deleteLastNewLine=this.getLength()-1>lastRow,startRow=deleteFirstNewLine?firstRow-1:firstRow,startCol=deleteFirstNewLine?this.getLine(startRow).length:0,endRow=deleteLastNewLine?lastRow+1:lastRow,endCol=deleteLastNewLine?0:this.getLine(endRow).length,range=new Range(startRow,startCol,endRow,endCol),deletedLines=this.$lines.slice(firstRow,lastRow+1);return this.applyDelta({start:range.start,end:range.end,action:"remove",lines:this.getLinesForRange(range)}),deletedLines},this.removeNewLine=function(row){this.getLength()-1>row&&row>=0&&this.applyDelta({start:this.pos(row,this.getLine(row).length),end:this.pos(row+1,0),action:"remove",lines:["",""]})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0===text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;this.remove(range);var end;return end=text?this.insert(range.start,text):range.start},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++)this.applyDelta(deltas[i])},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--)this.revertDelta(deltas[i])},this.applyDelta=function(delta,doNotValidate){var isInsert="insert"==delta.action;(isInsert?1>=delta.lines.length&&!delta.lines[0]:!Range.comparePoints(delta.start,delta.end))||(isInsert&&delta.lines.length>2e4&&this.$splitAndapplyLargeDelta(delta,2e4),applyDelta(this.$lines,delta,doNotValidate),this._signal("change",delta))},this.$splitAndapplyLargeDelta=function(delta,MAX){for(var lines=delta.lines,l=lines.length,row=delta.start.row,column=delta.start.column,from=0,to=0;;){from=to,to+=MAX-1;var chunk=lines.slice(from,to);if(to>l){delta.lines=chunk,delta.start.row=row+from,delta.start.column=column;break}chunk.push(""),this.applyDelta({start:this.pos(row+from,column),end:this.pos(row+to,column=0),action:delta.action,lines:chunk},!0)}},this.revertDelta=function(delta){this.applyDelta({start:this.clonePos(delta.start),end:this.clonePos(delta.end),action:"insert"==delta.action?"remove":"insert",lines:delta.lines.slice()})},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function deepCopy(obj){if("object"!=typeof obj||!obj)return obj;var copy;if(Array.isArray(obj)){copy=[];for(var key=0;obj.length>key;key++)copy[key]=deepCopy(obj[key]);return copy}if("[object Object]"!==Object.prototype.toString.call(obj))return obj;copy={};for(var key in obj)copy[key]=deepCopy(obj[key]);return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";acequire("../range").Range;var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){var data=e.data;if(data[0].start)doc.applyDeltas(data);else for(var i=0;data.length>i;i+=2){if(Array.isArray(data[i+1]))var d={action:"insert",start:data[i],lines:data[i+1]};else var d={action:"remove",start:data[i],end:data[i+1]};doc.applyDelta(d,!0)}return _self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"\t"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue(),errors=[];try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);errors.push({row:pos.row,column:pos.column,text:e.message,type:"error"})}this.sender.emit("annotate",errors)}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0\n}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;for(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="\t\\n\v\\f\\r   ᠎             　\\u2028\\u2029\ufeff";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});'},function(e,t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,i){"use strict";var n=e("../lib/dom"),r=e("../lib/lang"),o=e("../lib/event"),s=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys");n.importCssString('\t.ace_search {\tbackground-color: #ddd;\tcolor: #666;\tborder: 1px solid #cbcbcb;\tborder-top: 0 none;\toverflow: hidden;\tmargin: 0;\tpadding: 4px 6px 0 4px;\tposition: absolute;\ttop: 0;\tz-index: 99;\twhite-space: normal;\t}\t.ace_search.left {\tborder-left: 0 none;\tborder-radius: 0px 0px 5px 0px;\tleft: 0;\t}\t.ace_search.right {\tborder-radius: 0px 0px 0px 5px;\tborder-right: 0 none;\tright: 0;\t}\t.ace_search_form, .ace_replace_form {\tmargin: 0 20px 4px 0;\toverflow: hidden;\tline-height: 1.9;\t}\t.ace_replace_form {\tmargin-right: 0;\t}\t.ace_search_form.ace_nomatch {\toutline: 1px solid red;\t}\t.ace_search_field {\tborder-radius: 3px 0 0 3px;\tbackground-color: white;\tcolor: black;\tborder: 1px solid #cbcbcb;\tborder-right: 0 none;\tbox-sizing: border-box!important;\toutline: 0;\tpadding: 0;\tfont-size: inherit;\tmargin: 0;\tline-height: inherit;\tpadding: 0 6px;\tmin-width: 17em;\tvertical-align: top;\t}\t.ace_searchbtn {\tborder: 1px solid #cbcbcb;\tline-height: inherit;\tdisplay: inline-block;\tpadding: 0 6px;\tbackground: #fff;\tborder-right: 0 none;\tborder-left: 1px solid #dcdcdc;\tcursor: pointer;\tmargin: 0;\tposition: relative;\tbox-sizing: content-box!important;\tcolor: #666;\t}\t.ace_searchbtn:last-child {\tborder-radius: 0 3px 3px 0;\tborder-right: 1px solid #cbcbcb;\t}\t.ace_searchbtn:disabled {\tbackground: none;\tcursor: default;\t}\t.ace_searchbtn:hover {\tbackground-color: #eef1f6;\t}\t.ace_searchbtn.prev, .ace_searchbtn.next {\tpadding: 0px 0.7em\t}\t.ace_searchbtn.prev:after, .ace_searchbtn.next:after {\tcontent: "";\tborder: solid 2px #888;\twidth: 0.5em;\theight: 0.5em;\tborder-width:  2px 0 0 2px;\tdisplay:inline-block;\ttransform: rotate(-45deg);\t}\t.ace_searchbtn.next:after {\tborder-width: 0 2px 2px 0 ;\t}\t.ace_searchbtn_close {\tbackground: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;\tborder-radius: 50%;\tborder: 0 none;\tcolor: #656565;\tcursor: pointer;\tfont: 16px/16px Arial;\tpadding: 0;\theight: 14px;\twidth: 14px;\ttop: 9px;\tright: 7px;\tposition: absolute;\t}\t.ace_searchbtn_close:hover {\tbackground-color: #656565;\tbackground-position: 50% 100%;\tcolor: white;\t}\t.ace_button {\tmargin-left: 2px;\tcursor: pointer;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\toverflow: hidden;\topacity: 0.7;\tborder: 1px solid rgba(100,100,100,0.23);\tpadding: 1px;\tbox-sizing:    border-box!important;\tcolor: black;\t}\t.ace_button:hover {\tbackground-color: #eee;\topacity:1;\t}\t.ace_button:active {\tbackground-color: #ddd;\t}\t.ace_button.checked {\tborder-color: #3399ff;\topacity:1;\t}\t.ace_search_options{\tmargin-bottom: 3px;\ttext-align: right;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\tclear: both;\t}\t.ace_search_counter {\tfloat: left;\tfont-family: arial;\tpadding: 0 8px;\t}',"ace_searchbox");var l='<div class="ace_search right">\t    <span action="hide" class="ace_searchbtn_close"></span>\t    <div class="ace_search_form">\t        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>\t        <span action="findPrev" class="ace_searchbtn prev"></span>\t        <span action="findNext" class="ace_searchbtn next"></span>\t        <span action="findAll" class="ace_searchbtn" title="Alt-Enter">All</span>\t    </div>\t    <div class="ace_replace_form">\t        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>\t        <span action="replaceAndFindNext" class="ace_searchbtn">Replace</span>\t        <span action="replaceAll" class="ace_searchbtn">All</span>\t    </div>\t    <div class="ace_search_options">\t        <span action="toggleReplace" class="ace_button" title="Toggel Replace mode"\t            style="float:left;margin-top:-2px;padding:0 5px;">+</span>\t        <span class="ace_search_counter"></span>\t        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>\t        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>\t        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>\t        <span action="searchInSelection" class="ace_button" title="Search In Selection">S</span>\t    </div>\t</div>'.replace(/> +/g,">"),c=function(e,t,i){var r=n.createElement("div");r.innerHTML=l,this.element=r.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e)};(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var t=this;o.addListener(e,"mousedown",function(e){setTimeout(function(){t.activeInput.focus()},0),o.stopPropagation(e)}),o.addListener(e,"click",function(e){var i=e.target||e.srcElement,n=i.getAttribute("action");n&&t[n]?t[n]():t.$searchBarKb.commands[n]&&t.$searchBarKb.commands[n].exec(t),o.stopPropagation(e)}),o.addCommandKeyListener(e,function(e,i,n){var r=a.keyCodeToString(n),s=t.$searchBarKb.findKeyCommand(i,r);s&&s.exec&&(s.exec(t),o.stopEvent(e))}),this.$onChange=r.delayedCall(function(){t.find(!1,!1)}),o.addListener(this.searchInput,"input",function(){t.$onChange.schedule(20)}),o.addListener(this.searchInput,"focus",function(){t.activeInput=t.searchInput,t.searchInput.value&&t.highlight()}),o.addListener(this.replaceInput,"focus",function(){t.activeInput=t.replaceInput,t.searchInput.value&&t.highlight()})},this.$closeSearchBarKb=new s([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new s,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus()},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){this.searchRange=e,e?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){n.setCssClass(this.replaceOption,"checked",this.searchRange),n.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",n.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),n.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),n.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked),this.replaceBox.style.display=this.replaceOption.checked?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){var r=this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i,range:this.searchRange}),o=!r&&this.searchInput.value;n.setCssClass(this.searchBox,"ace_nomatch",o),this.editor._emit("findSearchBox",{match:!o}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,i=0,n=0;if(t){var r=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),o=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(o-=e.session.doc.positionToIndex(this.searchRange.start));for(var s,a=t.lastIndex=0;(s=t.exec(r))&&(i++,a=s.index,a<=o&&n++,!(i>999))&&(s[0]||(t.lastIndex=a+=1,!(a>=r.length))););}this.searchCounter.textContent=n+" of "+(i>999?"999+":i)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked}),t=!e&&this.searchInput.value;n.setCssClass(this.searchBox,"ace_nomatch",t),this.editor._emit("findSearchBox",{match:!t}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){(e.searchBox||new c(e)).show(e.session.getTextRange(),t)}}),function(){ace.acequire(["ace/ext/searchbox"],function(){})}()},function(e,t,i){var n;if(window.Picker)n=window.Picker;else try{n=i(58)}catch(e){}e.exports=n},function(e,t,i){!function(t,i){e.exports=i()}(0,function(){"use strict";function e(e){function t(e,t,i,n){function r(e,t,i){return Math.max(t,Math.min(e,i))}var o=e.clientX,s=e.clientY;if(t){var a=t.getBoundingClientRect();if(o-=a.left,s-=a.top,i&&(o-=i[0],s-=i[1]),n&&(o=r(o,0,a.width),s=r(s,0,a.height)),t!==f){(null!==E?E:"circle"===t.nodeName||"ellipse"===t.nodeName)&&(o-=a.width/2,s-=a.height/2)}}return b?[Math.round(o),Math.round(s)]:[o,s]}function i(e){e.preventDefault(),w||e.stopPropagation()}function n(e){var n=void 0;if(n=p?p instanceof Element?p.contains(e.target)?p:null:e.target.closest(p):{}){i(e);var r=p&&A?t(e,n):[0,0],o=t(e,f,r);F={target:n,mouseOffset:r,startPos:o,actuallyDragged:!1},g&&g(n,o)}}function r(e){if(F){i(e);var n=F.startPos,r=t(e,f,F.mouseOffset,!C);F.actuallyDragged=F.actuallyDragged||n[0]!==r[0]||n[1]!==r[1],m(F.target,r,n)}}function o(e,i){if(F){if(v||y){var n=!F.actuallyDragged,r=n?F.startPos:t(e,f,F.mouseOffset,!C);y&&n&&!i&&y(F.target,r),v&&v(F.target,r,F.startPos,i||n&&y)}F=null}}function s(e,t){o(d(e),t)}function a(e,t,i){e.addEventListener(t,i)}function l(e){return void 0!==e.buttons?1===e.buttons:1===e.which}function h(e,t){if(1!==e.touches.length)return void o(e,!0);t(d(e))}function d(e){var t=e.targetTouches[0];return t||(t=e.changedTouches[0]),t.preventDefault=e.preventDefault.bind(e),t.stopPropagation=e.stopPropagation.bind(e),t}var u=Element.prototype;u.matches||(u.matches=u.msMatchesSelector||u.webkitMatchesSelector),u.closest||(u.closest=function(e){var t=this;do{if(t.matches(e))return t;t="svg"===t.tagName?t.parentNode:t.parentElement}while(t);return null}),e=e||{};var f=e.container||document.documentElement,p=e.selector,m=e.callback||console.log,g=e.callbackDragStart,v=e.callbackDragEnd,y=e.callbackClick,w=e.propagateEvents,b=!1!==e.roundCoords,C=!1!==e.dragOutside,A=e.handleOffset||!1!==e.handleOffset,E=null;switch(A){case"center":E=!0;break;case"topleft":case"top-left":E=!1}var F=void 0;a(f,"mousedown",function(e){l(e)?n(e):o(e,!0)}),a(f,"touchstart",function(e){return h(e,n)}),a(c,"mousemove",function(e){F&&(l(e)?r(e):o(e))}),a(c,"touchmove",function(e){return h(e,r)}),a(f,"mouseup",function(e){F&&!l(e)&&o(e)}),a(f,"touchend",function(e){return s(e)}),a(f,"touchcancel",function(e){return s(e,!0)})}function t(e){var t=document.createElement("div");return t.innerHTML=e,t.firstElementChild}function i(e,t,i){e.addEventListener(t,i,!1)}var n=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},r=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),o=function(){function e(e,t){var i=[],n=!0,r=!1,o=void 0;try{for(var s,a=e[Symbol.iterator]();!(n=(s=a.next()).done)&&(i.push(s.value),!t||i.length!==t);n=!0);}catch(e){r=!0,o=e}finally{try{!n&&a.return&&a.return()}finally{if(r)throw o}}return i}return function(t,i){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,i);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();String.prototype.startsWith=String.prototype.startsWith||function(e){return 0===this.indexOf(e)},String.prototype.padStart=String.prototype.padStart||function(e,t){for(var i=this;i.length<e;)i=t+i;return i};var s="735AACA770//Xub218Pj/mo5+uvX6mdAP//gtpf//Ur258P//q1d9fXcxop/+TEq9zAAAAqfg/+vN6m1AAD/ngoiiviqt6pSoqzyo3riHxvdX56grk1f/8Aax10mkeqts/39QxbtZJXttkb//jcyxm3BQ86rmAP//wl5AACLwqqAIuL3y8uIYLwv1qampniqAGQAns5vbdrmohiwCLw5uVWsvsdd/4wAsegmTLMqagiwAAsqi6ZZ6uz6j7yPxtzSD2Lxk3L09PudbAM7RwsolADT0kz/xSTfuhAL//vfhaWlpyuxHpD/43rsiIiwn9//rw39uIosi9bp/wD/6w73Nzc9s5+Pj/6v8/9cA3b42qUg6vxgICArmaAIAAtdfrf8vf9n8P/wek3/2m0xnczVxc3bvSwCCsdt///wrvp8OaMs5i5ub6iyk//D1e8ifPwAoui//rNpyxrdjmw9c8ICAq4i4P//mx9+vrSq8t09PTx1ukO6Qqlv/7bBuuy/6B690uILKqpfdh876sd9d4iZnehsMTe0dv///g71lAP8A4nmMs0ys9u+vDmg9d/wD/4pmgAAAcurZs2qzllAADN4lkulXT6txk3Db66qPLNxozre2juokuAPqalj3SNHMgdkxxWF60pGRlwxfl9f/6hr5/+Thx6q/+S1m85/96tutd/fXmszxgIAAe4ma44j8rl/6UAmu0/0UA8so2nDWji87uiqumqmPuY9xbr+7u4rs23CTsb8/+/V95a/9q577xzYU/78z/8DL7b53aDdsu1sODmb11gACAy5nZjOZ1so/wAAlvevI+Pn09QWnhm7ui0UT94q+oBy7ei9KRg5aqLotXad5oFItasmwMDAaihh87r9fdalrN9p9cICQ7gz//r6k5uAP9/4qhRoK01te0rSM7cwAICA91x2L/Yclr/2NHcw1QODQd6w7oLuua09d6zudh////t359fX1enn//8Ao0ims0y",a=void 0,l=function(){function e(t,i,r,s){n(this,e);var a=this;if(void 0===t);else if(Array.isArray(t))this.rgba=t;else if(void 0===r){var l=t&&(""+t).trim();l&&function(t){if(t.startsWith("hsl")){var i=t.match(/([\-\d\.e]+)/g).map(Number),n=o(i,4),r=n[0],s=n[1],l=n[2],c=n[3];void 0===c&&(c=1),r/=360,s/=100,l/=100,a.hsla=[r,s,l,c]}else if(t.startsWith("rgb")){var h=t.match(/([\-\d\.e]+)/g).map(Number),d=o(h,4),u=d[0],f=d[1],p=d[2],m=d[3];void 0===m&&(m=1),a.rgba=[u,f,p,m]}else t.startsWith("#")?a.rgba=e.hexToRgb(t):a.rgba=e.nameToRgb(t)||e.hexToRgb(t)}(l.toLowerCase())}else this.rgba=[t,i,r,void 0===s?1:s]}return r(e,[{key:"rgba",get:function(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=e.hslToRgb(this._hsla)},set:function(e){3===e.length&&(e[3]=1),this._rgba=e,this._hsla=null}},{key:"rgbString",get:function(){return"rgb("+this.rgba.slice(0,3)+")"}},{key:"rgbaString",get:function(){return"rgba("+this.rgba+")"}},{key:"hsla",get:function(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=e.rgbToHsl(this._rgba)},set:function(e){3===e.length&&(e[3]=1),this._hsla=e,this._rgba=null}},{key:"hslString",get:function(){var e=this.hsla;return"hsl("+360*e[0]+","+100*e[1]+"%,"+100*e[2]+"%)"}},{key:"hslaString",get:function(){var e=this.hsla;return"hsla("+360*e[0]+","+100*e[1]+"%,"+100*e[2]+"%,"+e[3]+")"}},{key:"hex",get:function(){return"#"+this.rgba.map(function(e,t){return t<3?e.toString(16):Math.round(255*e).toString(16)}).map(function(e){return e.padStart(2,"0")}).join("")},set:function(t){this.rgba=e.hexToRgb(t)}}],[{key:"hexToRgb",value:function(e){var t=(e.startsWith("#")?e.slice(1):e).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!t.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+e);var i=t.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(e){return parseInt(e,16)});return i[3]=i[3]/255,i}},{key:"nameToRgb",value:function(e){a||(a={},s.match(/.{7}/g).forEach(function(e){return a[e.slice(0,3)]=atob(e.slice(-4)).split("").map(function(e){return e.charCodeAt(0)})}));var t=[].reduce.call(e.replace("ey","ay"),function(e,t){return(e<<2)+t.charCodeAt(0)},0).toString(36).slice(-3);return a[t]}},{key:"rgbToHsl",value:function(e){var t=o(e,4),i=t[0],n=t[1],r=t[2],s=t[3];i/=255,n/=255,r/=255;var a=Math.max(i,n,r),l=Math.min(i,n,r),c=void 0,h=void 0,d=(a+l)/2;if(a===l)c=h=0;else{var u=a-l;switch(h=d>.5?u/(2-a-l):u/(a+l),a){case i:c=(n-r)/u+(n<r?6:0);break;case n:c=(r-i)/u+2;break;case r:c=(i-n)/u+4}c/=6}return[c,h,d,s]}},{key:"hslToRgb",value:function(e){var t=o(e,4),i=t[0],n=t[1],r=t[2],s=t[3],a=void 0,l=void 0,c=void 0;if(0===n)a=l=c=r;else{var h=function(e,t,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?e+6*(t-e)*i:i<.5?t:i<2/3?e+(t-e)*(2/3-i)*6:e},d=r<.5?r*(1+n):r+n-r*n,u=2*r-d;a=h(u,d,i+1/3),l=h(u,d,i),c=h(u,d,i-1/3)}var f=[255*a,255*l,255*c].map(Math.round);return f[3]=s,f}}]),e}(),c=window
;return document.documentElement.firstElementChild.appendChild(document.createElement("style")).textContent=".picker_wrapper.no_alpha .picker_alpha,.picker_wrapper.no_editor .picker_editor{display:none}.layout_default.picker_wrapper{display:flex;flex-flow:row wrap;justify-content:space-between;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:'';display:block;width:100%;height:0;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{flex:1 1 auto}.layout_default .picker_sl::before{content:'';display:block;padding-bottom:100%}.layout_default .picker_editor{order:1;width:6rem}.layout_default .picker_editor input{width:calc(100% + 2px);height:calc(100% + 2px)}.layout_default .picker_sample{order:1;flex:1 1 auto}.layout_default .picker_done{order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;cursor:default;font-family:sans-serif;pointer-events:auto}.picker_wrapper button,.picker_wrapper input{margin:-1px}.picker_selector{position:absolute;z-index:1;display:block;transform:translate(-50%, -50%);border:2px solid white;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:linear-gradient(180deg, white, rgba(255,255,255,0) 50%),linear-gradient(0deg, black, rgba(0,0,0,0) 50%),linear-gradient(90deg, gray, rgba(128,128,128,0))}.picker_alpha,.picker_sample{position:relative;background:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\") left top/contain white;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{box-sizing:border-box;font-family:monospace;padding:.1em .2em}.picker_sample::before{content:'';position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_done button{box-sizing:border-box;padding:.2em .5em;cursor:pointer}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,0.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:\"\";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;transform:skew(45deg);transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}",function(){function o(e){var t=this;n(this,o),this.settings={popup:"right",layout:"default",alpha:!0,editor:!0},this._openProxy=function(e){return t.openHandler(e)},this.onChange=null,this.onDone=null,this.onOpen=null,this.onClose=null,this.setOptions(e)}return r(o,[{key:"setOptions",value:function(e){if(e){var t=this.settings;e instanceof HTMLElement?t.parent=e:(t.parent&&e.parent&&t.parent!==e.parent&&(t.parent.removeEventListener("click",this._openProxy,!1),this._popupInited=!1),function(e,t,i){for(var n in e)i&&i.indexOf(n)>=0||(t[n]=e[n])}(e,t)),e.onChange&&(this.onChange=e.onChange),e.onDone&&(this.onDone=e.onDone),e.onOpen&&(this.onOpen=e.onOpen),e.onClose&&(this.onClose=e.onClose);var n=e.color||e.colour;n&&this._setColor(n),t.parent&&t.popup&&!this._popupInited?(i(t.parent,"click",this._openProxy),this._popupInited=!0):e.parent&&!t.popup&&this.show()}}},{key:"openHandler",value:function(e){this.show()&&(this.settings.parent.style.pointerEvents="none",this.onOpen&&this.onOpen(this.colour))}},{key:"closeHandler",value:function(e){var t=!1;e?"mousedown"===e.type?this.domElement.contains(e.target)||(t=!0):(e.preventDefault(),e.stopPropagation(),t=!0):t=!0,t&&this.hide()&&(this.settings.parent.style.pointerEvents="",this.onClose&&this.onClose(this.colour))}},{key:"movePopup",value:function(e,t){this.closeHandler(),this.setOptions(e),t&&this.openHandler()}},{key:"setColor",value:function(e,t){this._setColor(e,{silent:t})}},{key:"_setColor",value:function(e,t){var i=new l(e);if(!this.settings.alpha){var n=i.hsla;n[3]=1,i.hsla=n}this.colour=this.color=i,this._setHSLA(null,null,null,null,t)}},{key:"setColour",value:function(e,t){this.setColor(e,t)}},{key:"show",value:function(){if(!this.settings.parent)return!1;if(this.domElement){var e=this._toggleDOM(!0);return this._setPosition(),e}var i=this.settings.template||'<div class="picker_wrapper"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div></div>',n=t(i);return this.domElement=n,this._domH=n.querySelector(".picker_hue"),this._domSL=n.querySelector(".picker_sl"),this._domA=n.querySelector(".picker_alpha"),this._domEdit=n.querySelector(".picker_editor input"),this._domSample=n.querySelector(".picker_sample"),this._domOkay=n.querySelector(".picker_done button"),n.classList.add("layout_"+this.settings.layout),this.settings.alpha||n.classList.add("no_alpha"),this.settings.editor||n.classList.add("no_editor"),this._ifPopup(function(){return n.classList.add("popup")}),this._setPosition(),this.colour?this._updateUI():this._setColor("#0cf"),this._bindEvents(),!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"_bindEvents",value:function(){function t(e,t){function i(i,n){var r=n[0]/e.clientWidth,o=n[1]/e.clientHeight;t(r,o)}return{container:e,dragOutside:!1,callback:i,callbackClick:i,callbackDragStart:i,propagateEvents:!0}}var n=this,r=this;e(t(this._domH,function(e,t){return r._setHSLA(e)})),e(t(this._domSL,function(e,t){return r._setHSLA(null,e,1-t)})),this.settings.alpha&&e(t(this._domA,function(e,t){return r._setHSLA(null,null,null,1-t)})),this.settings.editor&&i(this._domEdit,"input",function(e){var t=this.value;try{new l(this.value),r._setColor(t,{fromEditor:!0})}catch(e){}}),i(window,"mousedown",function(e){return n._ifPopup(function(){return n.closeHandler(e)})}),i(this._domOkay,"click",function(e){n._ifPopup(function(){return n.closeHandler(e)}),n.onDone&&n.onDone(n.colour)})}},{key:"_setPosition",value:function(){var e=this.settings.parent,t=this.domElement;e!==t.parentNode&&e.appendChild(t),this._ifPopup(function(i){"static"===getComputedStyle(e).position&&(e.style.position="relative");var n=!0===i?"popup_right":"popup_"+i;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(e){e===n?t.classList.add(e):t.classList.remove(e)}),t.classList.add(n)})}},{key:"_setHSLA",value:function(e,t,i,n,r){r=r||{};var o=this.colour,s=o.hsla;[e,t,i,n].forEach(function(e,t){(e||0===e)&&(s[t]=e)}),o.hsla=s,this._updateUI(r),this.onChange&&!r.silent&&this.onChange(o)}},{key:"_updateUI",value:function(e){function t(e,t,i){t.style.left=100*i+"%"}function i(e,t,i){t.style.top=100*i+"%"}if(this.domElement){e=e||{};var n=this.colour,r=n.hsla,o="hsl("+360*r[0]+", 100%, 50%)",s=n.hslString,a=n.hslaString,l=this._domH,c=this._domSL,h=this._domA;t(l,l.firstElementChild,r[0]),this._domSL.style.backgroundColor=this._domH.style.color=o,t(c,c.firstElementChild,r[1]),i(c,c.firstElementChild,1-r[2]),c.style.color=s,i(h,h.firstElementChild,1-r[3]);var d=s,u=d.replace("hsl","hsla").replace(")",", 0)"),f="linear-gradient("+[d,u]+")";if(this._domA.style.backgroundImage=f+", url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\")",!e.fromEditor){var p=n.hex;this._domEdit.value=this.settings.alpha?p:p.substr(0,7)}this._domSample.style.color=a}}},{key:"_ifPopup",value:function(e,t){this.settings.parent&&this.settings.popup?e&&e(this.settings.popup):t&&t()}},{key:"_toggleDOM",value:function(e){var t=this.domElement;if(!t)return!1;var i=e?"":"none",n=t.style.display!==i;return n&&(t.style.display=i),n}}]),o}()})},function(e,t,i){"use strict";var n=i(57),r=i(60),o=i(61),s=i(62),a=i(63),l=i(69),c=i(70),h=i(79),d=i(65),u=i(80),f=i(75),p=i(77),m=i(68).translate,g=i(68).setLanguages,v=i(68).setLanguage,y=document.body,w={};w.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new r,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=new u(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new o(this)),this._createFrame(),this._createTable()},w.destroy=function(){this.frame&&this.container&&this.frame.parentNode==this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},w._setOptions=function(e){if(this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,i){n?new n({parent:e,color:t,popup:"bottom",onDone:function(e){var t=e.rgba[3],n=1===t?e.hex.substr(0,7):e.hex;i(n)}}).show():console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,onEvent:null},e)for(var t in e)e.hasOwnProperty(t)&&(this.options[t]=e[t]);this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=d.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),e.onSelectionChange&&this.onSelectionChange(e.onSelectionChange),g(this.options.languages),v(this.options.language)},w.set=function(e){if(e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var t={field:this.options.name,value:e},i=new c(this,t);this._setRoot(i),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},w.update=function(e){if(!this.node.deepEqual(e)){var t=this.getSelection();if(this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this.validate(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end){var i=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path);i&&n?this.setSelection(t.start,t.end):this.setSelection({},{})}else this.setSelection({},{})}},w.get=function(){if(this.focusTarget){var e=c.getNodeFromTarget(this.focusTarget);e&&e.blur()}return this.node?this.node.getValue():void 0},w.getText=function(){return JSON.stringify(this.get())},w.setText=function(e){try{this.set(d.parse(e))}catch(i){var t=d.sanitize(e);this.set(d.parse(t))}},w.updateText=function(e){try{this.update(d.parse(e))}catch(i){var t=d.sanitize(e);this.update(d.parse(t))}},w.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},w.getName=function(){return this.options.name},w.focus=function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},w.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},w._setRoot=function(e){this.clear(),this.node=e,this.tbody.appendChild(e.getDom())},w.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},w.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},w.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},w._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},w._onChange=function(){if(!this.onChangeDisabled){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},w.validate=function(){var e=this.node;if(e){var t=e.getValue(),i=e.validate(),n=[];if(this.validateSchema){this.validateSchema(t)||(n=this.validateSchema.errors.map(function(e){return d.improveSchemaError(e)}).map(function(t){return{node:e.findNode(t.dataPath),error:t}}).filter(function(e){return null!=e.node}))}try{this.validationSequence++;var r=this,o=this.validationSequence;this._validateCustom(t).then(function(e){if(o===r.validationSequence){var t=[].concat(i,n,e||[]);r._renderValidationErrors(t)}}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}},w._renderValidationErrors=function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},w._validateCustom=function(e){try{if(this.options.onValidate){var t=this.node,i=this.options.onValidate(e);return(d.isPromise(i)?i:Promise.resolve(i)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=d.isValidValidationError(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var i;try{i=e&&e.path?t.findNodeByPath(e.path):null}catch(e){}return i||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:i,error:e}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}}catch(e){return Promise.reject(e)}return Promise.resolve(null)},w.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},w.startAutoScroll=function(e){var t=this,i=this.scrollableContent,n=d.getAbsoluteTop(i),r=i.clientHeight,o=n+r;e<n+24&&i.scrollTop>0?this.autoScrollStep=(n+24-e)/3:e>o-24&&r+i.scrollTop<i.scrollHeight?this.autoScrollStep=(o-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},w.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},w.setDomSelection=function(e){if(e)if("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths){var t=this,i=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)});this.select(i)}else{var n=e.path?this.node.findNodeByInternalPath(e.path):null,r=n&&e.domName?n.dom[e.domName]:null;if(e.range&&r){var o=Object.assign({},e.range,{container:r});d.setSelectionOffset(o)}else n&&n.focus()}},w.getDomSelection=function(){var e=c.getNodeFromTarget(this.focusTarget),t=this.focusTarget,i=e?Object.keys(e.dom).find(function(i){return e.dom[i]===t}):null,n=d.getSelectionOffset();return n&&"DIV"!==n.container.nodeName&&(n=null),n&&n.container!==t&&(n=null),n&&delete n.container,{path:e?e.getInternalPath():null,domName:i,range:n,paths:this.multiselection.length>0?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},w.scrollTo=function(e,t){var i=this.scrollableContent;if(i){var n=this;n.animateTimeout&&(clearTimeout(n.animateTimeout),delete n.animateTimeout),n.animateCallback&&(n.animateCallback(!1),delete n.animateCallback);var r=i.clientHeight,o=i.scrollHeight-r,s=Math.min(Math.max(e-r/4,0),o),a=function(){var e=i.scrollTop,r=s-e;Math.abs(r)>3?(i.scrollTop+=r/3,n.animateCallback=t,n.animateTimeout=setTimeout(a,50)):(t&&t(!0),i.scrollTop=s,delete n.animateTimeout,delete n.animateCallback)};a()}else t&&t(!1)},w._createFrame=function(){function e(e){t._onEvent&&t._onEvent(e)}this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame);var t=this;this.frame.onclick=function(t){var i=t.target;e(t),"BUTTON"==i.nodeName&&t.preventDefault()},this.frame.oninput=e,this.frame.onchange=e,this.frame.onkeydown=e,this.frame.onkeyup=e,this.frame.oncut=e,this.frame.onpaste=e,this.frame.onmousedown=e,this.frame.onmouseup=e,this.frame.onmouseover=e,this.frame.onmouseout=e,d.addEventListener(this.frame,"focus",e,!0),d.addEventListener(this.frame,"blur",e,!0),this.frame.onfocusin=e,this.frame.onfocusout=e,this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var i=document.createElement("button");i.type="button",i.className="jsoneditor-expand-all",i.title=m("expandAll"),i.onclick=function(){t.expandAll()},this.menu.appendChild(i);var n=document.createElement("button");n.type="button",n.title=m("collapseAll"),n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n);var r=document.createElement("button");r.type="button",r.className="jsoneditor-sort",r.title=m("sortTitleShort"),r.onclick=function(){var e=t.options.modalAnchor||y;f(t.node,e)},this.menu.appendChild(r);var o=document.createElement("button");if(o.type="button",o.title=m("transformTitleShort"),o.className="jsoneditor-transform",o.onclick=function(){var e=t.options.modalAnchor||y;p(t.node,e)},this.menu.appendChild(o),this.history){var a=document.createElement("button");a.type="button",a.className="jsoneditor-undo jsoneditor-separator",a.title=m("undo"),a.onclick=function(){t._onUndo()},this.menu.appendChild(a),this.dom.undo=a;var c=document.createElement("button");c.type="button",c.className="jsoneditor-redo",c.title=m("redo"),c.onclick=function(){t._onRedo()},this.menu.appendChild(c),this.dom.redo=c,this.history.onChange=function(){a.disabled=!t.history.canUndo(),c.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var u=this;this.modeSwitcher=new h(this.menu,this.options.modes,this.options.mode,function(e){u.setMode(e),u.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new s(this,this.menu)),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new l(this.navBar),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},w._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},w._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},w._onEvent=function(e){if(!c.targetIsColorPicker(e.target)){"keydown"===e.type&&this._onKeyDown(e),"focus"===e.type&&(this.focusTarget=e.target),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e);var t=c.getNodeFromTarget(e.target);if(t&&this.options&&this.options.navigationBar&&t&&("keydown"===e.type||"mousedown"===e.type)){var i=this;setTimeout(function(){i._updateTreePath(t.getNodePath())})}if(t&&t.selected){if("click"===e.type){if(e.target===t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&c.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&(this.deselect(),t&&e.target===t.dom.drag?c.onDragStart(t,e):(!t||e.target!==t.dom.field&&e.target!==t.dom.value&&e.target!==t.dom.select)&&this._onMultiSelectStart(e));t&&t.onEvent(e)}},w._updateTreePath=function(e){function t(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.type}if(e&&e.length){d.removeClassName(this.navBar,"nav-bar-empty");var i=[];e.forEach(function(e){var n={name:t(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){n.children.push({name:t(e),node:e})}),i.push(n)}),this.treePath.setPath(i)}else d.addClassName(this.navBar,"nav-bar-empty")},w._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},w._onTreePathMenuItemSelected=function(e,t){if(e&&e.children.length){var i=e.children.find(function(e){return e.name===t});i&&i.node&&(this._updateTreePath(i.node.getNodePath()),i.node.expandTo(),i.node.focus())}},w._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},w._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||this.dragDistanceEvent.dragDistance>10,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},w._onMultiSelectStart=function(e){var t=c.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var i=this;this.mousemove||(this.mousemove=d.addEventListener(window,"mousemove",function(e){i._onMultiSelect(e)})),this.mouseup||(this.mouseup=d.addEventListener(window,"mouseup",function(e){i._onMultiSelectEnd(e)}))}},w._onMultiSelect=function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=c.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start;if(i&&n){if(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.multiselection.nodes&&this.multiselection.nodes.length){var r=this.multiselection.nodes[0];this.multiselection.start===r||this.multiselection.start.isDescendantOf(r)?this.multiselection.direction="down":this.multiselection.direction="up"}this.select(this.multiselection.nodes)}}},w._onMultiSelectEnd=function(e){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(d.removeEventListener(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(d.removeEventListener(window,"mouseup",this.mouseup),delete this.mouseup)},w.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},w.select=function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];if(e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler){var i=this.getSelection();this._selectionChangedHandler(i.start,i.end)}}},w._findTopLevelNodes=function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),r=0;r<i.length&&i[r]===n[r];)r++;var o=i[r-1],s=i[r],a=n[r];if(s&&a||(o.parent?(s=o,a=o,o=o.parent):(s=o.childs[0],a=o.childs[o.childs.length-1])),o&&s&&a){var l=o.childs.indexOf(s),c=o.childs.indexOf(a),h=Math.min(l,c),d=Math.max(l,c);return o.childs.slice(h,d+1)}return[]},w._onKeyDown=function(e){var t=e.which||e.keyCode,i=e.altKey,n=e.ctrlKey,r=e.metaKey,o=e.shiftKey,s=!1;if(9==t){var a=this;setTimeout(function(){d.selectContentEditable(a.focusTarget)},0)}if(this.searchBox)if(n&&70==t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),s=!0;else if(114==t||n&&71==t){o?this.searchBox.previous(!0):this.searchBox.next(!0),s=!0}if(this.history&&(n&&!o&&90==t?(this._onUndo(),s=!0):n&&o&&90==t&&(this._onRedo(),s=!0)),this.options.autocomplete&&!s&&!(n||i||r||1!=e.key.length&&8!=t&&46!=t)){s=!1;var l="";e.target.className.indexOf("jsoneditor-value")>=0&&(l="value"),e.target.className.indexOf("jsoneditor-field")>=0&&(l="field");var h=c.getNodeFromTarget(e.target);setTimeout(function(e,t){if(t.innerText.length>0){var i=this.options.autocomplete.getOptions(t.innerText,e.getPath(),l,e.editor);null===i?this.autocomplete.hideDropDown():"function"==typeof i.then?i.then(function(e){null===e?this.autocomplete.hideDropDown():e.options?this.autocomplete.show(t,e.startFrom,e.options):this.autocomplete.show(t,0,e)}.bind(this)):i.options?this.autocomplete.show(t,i.startFrom,i.options):this.autocomplete.show(t,0,i)}else this.autocomplete.hideDropDown()}.bind(this,h,e.target),50)}s&&(e.preventDefault(),e.stopPropagation())},w._createTable=function(){var e=document.createElement("div");e.className="jsoneditor-outer",this.options.navigationBar&&d.addClassName(e,"has-nav-bar"),this.contentOuter=e,this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",e.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table);var t;this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&(t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t)),t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t),t=document.createElement("col"),this.colgroupContent.appendChild(t),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(e)},w.showContextMenu=function(e,t){var i=[],n=this;i.push({text:m("duplicateText"),title:m("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){c.onDuplicate(n.multiselection.nodes)}}),i.push({text:m("remove"),title:m("removeTitle"),className:"jsoneditor-remove",click:function(){c.onRemove(n.multiselection.nodes)}}),new a(i,{close:t}).show(e,n.frame)},w.getSelection=function(){var e={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var t=this.multiselection.nodes[0],i=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(e.start=t.serialize(),e.end=i.serialize()):(e.start=i.serialize(),e.end=t.serialize())}return e},w.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=d.debounce(e,this.DEBOUNCE_INTERVAL))},w.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is depracated and should not be used, see documantaion for supported selection options"),this.setDomSelection(e));var i=this._getNodeInstancesByRange(e,t);i.forEach(function(e){e.expandTo()}),this.select(i)},w._getNodeInstancesByRange=function(e,t){var i,n;e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var r=[];if(i instanceof c)if(n instanceof c&&n!==i)if(i.parent===n.parent){var e,t;i.getIndex()<n.getIndex()?(e=i,t=n):(e=n,t=i);var o=e;r.push(o);do{o=o.nextSibling(),r.push(o)}while(o&&o!==t)}else r=this._findTopLevelNodes(i,n);else r.push(i);return r},w.getNodesByRange=function(e,t){var i=this._getNodeInstancesByRange(e,t),n=[];return i.forEach(function(e){n.push(e.serialize())}),n},e.exports=[{mode:"tree",mixin:w,data:"json"},{mode:"view",mixin:w,data:"json"},{mode:"form",mixin:w,data:"json"}]},function(e,t){"use strict";function i(){this.locked=!1}i.prototype.highlight=function(e){this.locked||(this.node!=e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())},i.prototype.unhighlight=function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},i.prototype._cancelUnhighlight=function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)},i.prototype.lock=function(){this.locked=!0},i.prototype.unlock=function(){this.locked=!1},e.exports=i},function(e,t){"use strict";function i(e){function t(t){return e.node.findNodeByInternalPath(t)}this.editor=e,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){t(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){t(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){t(e.path).updateValue(e.oldValue)},redo:function(e){t(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){t(e.path).changeType(e.oldType)},redo:function(e){t(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var i=t(e.parentPath);e.paths.map(t).forEach(function(e){i.removeChild(e)})},redo:function(e){var i=t(e.parentPath);e.nodes.forEach(function(e){i.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var i=t(e.parentPath);e.paths.map(t).forEach(function(e){i.removeChild(e)})},redo:function(e){var i=t(e.parentPath),n=t(e.beforePath);e.nodes.forEach(function(e){i.insertBefore(e,n)})}},insertAfterNodes:{undo:function(e){var i=t(e.parentPath);e.paths.map(t).forEach(function(e){i.removeChild(e)})},redo:function(e){var i=t(e.parentPath),n=t(e.afterPath);e.nodes.forEach(function(e){i.insertAfter(e,n),n=e})}},removeNodes:{undo:function(e){var i=t(e.parentPath),n=i.childs[e.index]||i.append;e.nodes.forEach(function(e){i.insertBefore(e,n)})},redo:function(e){var i=t(e.parentPath);e.paths.map(t).forEach(function(e){i.removeChild(e)})}},duplicateNodes:{undo:function(e){var i=t(e.parentPath);e.clonePaths.map(t).forEach(function(e){i.removeChild(e)})},redo:function(e){var i=t(e.parentPath),n=t(e.afterPath);e.paths.map(t).forEach(function(e){var t=e.clone();i.insertAfter(t,n),n=t})}},moveNodes:{undo:function(e){var i=t(e.oldParentPath),n=t(e.newParentPath),r=i.childs[e.oldIndex]||i.append;n.childs.slice(e.newIndex,e.newIndex+e.count).forEach(function(t,n){t.field=e.fieldNames[n],i.moveBefore(t,r)}),null===e.newParentPathRedo&&(e.newParentPathRedo=n.getInternalPath())},redo:function(e){var i=t(e.oldParentPathRedo),n=t(e.newParentPathRedo),r=n.childs[e.newIndexRedo]||n.append;i.childs.slice(e.oldIndexRedo,e.oldIndexRedo+e.count).forEach(function(t,i){t.field=e.fieldNames[i],n.moveBefore(t,r)})}},sort:{undo:function(e){var i=t(e.path);i.hideChilds(),i.childs=e.oldChilds,i.updateDom({updateIndexes:!0}),i.showChilds()},redo:function(e){var i=t(e.path);i.hideChilds(),i.childs=e.newChilds,i.updateDom({updateIndexes:!0}),i.showChilds()}},transform:{undo:function(e){t(e.path).setInternalValue(e.oldValue)},redo:function(e){t(e.path).setInternalValue(e.newValue)}}}}i.prototype.onChange=function(){},i.prototype.add=function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()},i.prototype.clear=function(){this.history=[],this.index=-1,this.onChange()},i.prototype.canUndo=function(){return this.index>=0},i.prototype.canRedo=function(){return this.index<this.history.length-1},i.prototype.undo=function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}},i.prototype.redo=function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}},i.prototype.destroy=function(){this.editor=null,this.history=[],this.index=-1},e.exports=i},function(e,t){"use strict";function i(e,t){var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.dom={},this.dom.container=t;var n=document.createElement("table");this.dom.table=n,n.className="jsoneditor-search",t.appendChild(n);var r=document.createElement("tbody");this.dom.tbody=r,n.appendChild(r);var o=document.createElement("tr");r.appendChild(o);var s=document.createElement("td");o.appendChild(s);var a=document.createElement("div");this.dom.results=a,a.className="jsoneditor-results",s.appendChild(a),s=document.createElement("td"),o.appendChild(s);var l=document.createElement("div");this.dom.input=l,l.className="jsoneditor-frame",l.title="Search fields and values",s.appendChild(l);var c=document.createElement("table");l.appendChild(c);var h=document.createElement("tbody");c.appendChild(h),o=document.createElement("tr"),h.appendChild(o);var d=document.createElement("button");d.type="button",d.className="jsoneditor-refresh",s=document.createElement("td"),s.appendChild(d),o.appendChild(s);var u=document.createElement("input");this.dom.search=u,u.oninput=function(e){i._onDelayedSearch(e)},u.onchange=function(e){i._onSearch()},u.onkeydown=function(e){i._onKeyDown(e)},u.onkeyup=function(e){i._onKeyUp(e)},d.onclick=function(e){u.select()},s=document.createElement("td"),s.appendChild(u),o.appendChild(s);var f=document.createElement("button");f.type="button",f.title="Next result (Enter)",f.className="jsoneditor-next",f.onclick=function(){i.next()},s=document.createElement("td"),s.appendChild(f),o.appendChild(s);var p=document.createElement("button");p.type="button",p.title="Previous result (Shift+Enter)",p.className="jsoneditor-previous",p.onclick=function(){i.previous()},s=document.createElement("td"),s.appendChild(p),o.appendChild(s)}i.prototype.next=function(e){if(void 0!=this.results){var t=void 0!=this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}},i.prototype.previous=function(e){if(void 0!=this.results){var t=this.results.length-1,i=void 0!=this.resultIndex?this.resultIndex-1:t;i<0&&(i=t),this._setActiveResult(i,e)}},i.prototype._setActiveResult=function(e,t){if(this.activeResult){var i=this.activeResult.node;"field"==this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,r=this.results[this.resultIndex].elem;"field"==r?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(r)})},i.prototype._clearDelay=function(){void 0!=this.timeout&&(clearTimeout(this.timeout),delete this.timeout)},i.prototype._onDelayedSearch=function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)},i.prototype._onSearch=function(e){this._clearDelay();var t=this.dom.search.value,i=t.length>0?t:void 0;if(i!==this.lastText||e){this.lastText=i,this.results=this.editor.search(i);var n=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,r=0;if(this.activeResult)for(var o=0;o<this.results.length;o++)if(this.results[o].node===this.activeResult.node){r=o;break}if(this._setActiveResult(r,!1),void 0!==i){var s=this.results.length;this.dom.results.innerHTML=0===s?"no&nbsp;results":1===s?"1&nbsp;result":s>n?n+"+&nbsp;results":s+"&nbsp;results"}else this.dom.results.innerHTML=""}},i.prototype._onKeyDown=function(e){var t=e.which;27==t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13==t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())},i.prototype._onKeyUp=function(e){var t=e.keyCode;27!=t&&13!=t&&this._onDelayedSearch(e)},i.prototype.clear=function(){this.dom.search.value="",this._onSearch()},i.prototype.forceSearch=function(){this._onSearch(!0)},i.prototype.isEmpty=function(){return""===this.dom.search.value},i.prototype.destroy=function(){this.editor=null,this.dom.container.removeChild(this.dom.table),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()},e.exports=i},function(e,t,i){"use strict";function n(e,t){function i(e,t,r){r.forEach(function(r){if("separator"==r.type){var o=document.createElement("div");o.className="jsoneditor-separator",l=document.createElement("li"),l.appendChild(o),e.appendChild(l)}else{var a={},l=document.createElement("li");e.appendChild(l);var c=document.createElement("button");if(c.type="button",c.className=r.className,a.button=c,r.title&&(c.title=r.title),r.click&&(c.onclick=function(e){e.preventDefault(),n.hide(),r.click()}),l.appendChild(c),r.submenu){var h=document.createElement("div");h.className="jsoneditor-icon",c.appendChild(h);var d=document.createElement("div");d.className="jsoneditor-text"+(r.click?"":" jsoneditor-right-margin"),d.appendChild(document.createTextNode(r.text)),c.appendChild(d);var u;if(r.click){c.className+=" jsoneditor-default";var f=document.createElement("button");f.type="button",a.buttonExpand=f,f.className="jsoneditor-expand",f.innerHTML='<div class="jsoneditor-expand"></div>',l.appendChild(f),r.submenuTitle&&(f.title=r.submenuTitle),u=f}else{var p=document.createElement("div");p.className="jsoneditor-expand",c.appendChild(p),u=c}u.onclick=function(e){e.preventDefault(),n._onExpandItem(a),u.focus()};var m=[];a.subItems=m;var g=document.createElement("ul");a.ul=g,g.className="jsoneditor-menu",g.style.height="0",l.appendChild(g),i(g,m,r.submenu)}else c.innerHTML='<div class="jsoneditor-icon"></div><div class="jsoneditor-text">'+s(r.text)+"</div>";t.push(a)}})}this.dom={};var n=this,r=this.dom;this.anchor=void 0,this.items=e,this.eventListeners={},this.selection=void 0,this.onClose=t?t.close:void 0;var o=document.createElement("div");o.className="jsoneditor-contextmenu-root",r.root=o;var a=document.createElement("div");a.className="jsoneditor-contextmenu",r.menu=a,o.appendChild(a);var l=document.createElement("ul");l.className="jsoneditor-menu",a.appendChild(l),r.list=l,r.items=[];var c=document.createElement("button");c.type="button",r.focusButton=c;var h=document.createElement("li");h.style.overflow="hidden",h.style.height="0",h.appendChild(c),l.appendChild(h),i(l,this.dom.items,e),this.maxHeight=0,e.forEach(function(t){var i=24*(e.length+(t.submenu?t.submenu.length:0));n.maxHeight=Math.max(n.maxHeight,i)})}var r=i(64).createAbsoluteAnchor,o=i(65),s=i(68).translate;n.prototype._getVisibleButtons=function(){var e=[],t=this;return this.dom.items.forEach(function(i){e.push(i.button),i.buttonExpand&&e.push(i.buttonExpand),i.subItems&&i==t.expandedItem&&i.subItems.forEach(function(t){e.push(t.button),t.buttonExpand&&e.push(t.buttonExpand)})}),e},n.visibleMenu=void 0,n.prototype.show=function(e,t){this.hide();var i=!0,s=e.parentNode,a=e.getBoundingClientRect(),l=s.getBoundingClientRect(),c=t.getBoundingClientRect(),h=this;this.dom.absoluteAnchor=r(e,t,function(){h.hide()}),a.bottom+this.maxHeight<c.bottom||a.top-this.maxHeight>c.top&&(i=!1);var d=a.top-l.top;if(i){var u=e.offsetHeight;this.dom.menu.style.left="0",this.dom.menu.style.top=d+u+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px";this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=o.getSelection(),this.anchor=e,setTimeout(function(){h.dom.focusButton.focus()},0),n.visibleMenu&&n.visibleMenu.hide(),n.visibleMenu=this},n.prototype.hide=function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),n.visibleMenu==this&&(n.visibleMenu=void 0)},n.prototype._onExpandItem=function(e){var t=this,i=e==this.expandedItem,n=this.expandedItem;if(n&&(n.ul.style.height="0",n.ul.style.padding="",setTimeout(function(){t.expandedItem!=n&&(n.ul.style.display="",o.removeClassName(n.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!i){var r=e.ul;r.style.display="block";r.clientHeight;setTimeout(function(){if(t.expandedItem==e){for(var i=0,n=0;n<r.childNodes.length;n++)i+=r.childNodes[n].clientHeight;r.style.height=i+"px",r.style.padding="5px 10px"}},0),o.addClassName(r.parentNode,"jsoneditor-selected"),this.expandedItem=e}},n.prototype._onKeyDown=function(e){var t,i,n,r,s=e.target,a=e.which,l=!1;27==a?(this.selection&&o.setSelection(this.selection),this.anchor&&this.anchor.focus(),this.hide(),l=!0):9==a?e.shiftKey?(t=this._getVisibleButtons(),0==(i=t.indexOf(s))&&(t[t.length-1].focus(),l=!0)):(t=this._getVisibleButtons(),(i=t.indexOf(s))==t.length-1&&(t[0].focus(),l=!0)):37==a?("jsoneditor-expand"==s.className&&(t=this._getVisibleButtons(),i=t.indexOf(s),(n=t[i-1])&&n.focus()),l=!0):38==a?(t=this._getVisibleButtons(),i=t.indexOf(s),n=t[i-1],n&&"jsoneditor-expand"==n.className&&(n=t[i-2]),n||(n=t[t.length-1]),n&&n.focus(),l=!0):39==a?(t=this._getVisibleButtons(),i=t.indexOf(s),r=t[i+1],r&&"jsoneditor-expand"==r.className&&r.focus(),l=!0):40==a&&(t=this._getVisibleButtons(),i=t.indexOf(s),r=t[i+1],r&&"jsoneditor-expand"==r.className&&(r=t[i+2]),r||(r=t[0]),r&&(r.focus(),l=!0),l=!0),l&&(e.stopPropagation(),e.preventDefault())},e.exports=n},function(e,t,i){function n(e){return"function"==typeof e.getRootNode?e.getRootNode():window}var r=i(65);t.createAbsoluteAnchor=function(e,t,i){function o(){if(h&&h.parentNode){h.parentNode.removeChild(h);for(var t in a)if(a.hasOwnProperty(t)){var n=a[t];n&&r.removeEventListener(s,t,n),delete a[t]}"function"==typeof i&&i(e)}}var s=n(e),a={},l=e.getBoundingClientRect(),c=t.getBoundingClientRect(),h=document.createElement("div");h.className="jsoneditor-anchor",h.style.position="absolute",h.style.left=l.left-c.left+"px",h.style.top=l.top-c.top+"px",h.style.width=l.width-2+"px",h.style.height=l.height-2+"px",h.style.boxSizing="border-box",t.appendChild(h);var d=function(e){var t=e.target;t===h||r.isChildOf(t,h)||o()};return a.mousedown=r.addEventListener(s,"mousedown",d),a.mousewheel=r.addEventListener(s,"mousewheel",d),h.destroy=o,h}},function(e,t,i){"use strict";var n=i(66),r=i(67);t.parse=function(e){try{return JSON.parse(e)}catch(i){throw t.validate(e),i}},t.sanitize=function(e){function t(){return e.charAt(s)}function i(){return e.charAt(s+1)}function n(){return e.charAt(s-1)}function r(i){o.push('"'),s++;for(var r=t();s<e.length&&r!==i;)'"'===r&&"\\"!==n()?o.push('\\"'):l.hasOwnProperty(r)?o.push(l[r]):"\\"===r?(s++,r=t(),"'"!==r&&o.push("\\"),o.push(r)):o.push(r),s++,r=t();r===i&&(o.push('"'),s++)}var o=[],s=0,a=e.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);a&&(e=a[3]);for(var l={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};s<e.length;){var c=t();"/"===c&&"*"===i()?function(){for(s+=2;s<e.length&&("*"!==t()||"/"!==i());)s++;s+=2}():"/"===c&&"/"===i()?function(){for(s+=2;s<e.length&&"\n"!==t();)s++}():" "===c||c>=" "&&c<=" "||" "===c||" "===c||"　"===c?(o.push(" "),s++):"'"===c?r("'"):'"'===c?r('"'):"`"===c?r("´"):"‘"===c?r("’"):"“"===c?r("”"):/[a-zA-Z_$]/.test(c)&&-1!==["{",","].indexOf(function(){for(var e=o.length-1;e>=0;){var t=o[e];if(" "!==t&&"\n"!==t&&"\r"!==t&&"\t"!==t)return t;e--}return""}())?function(){for(var e=["null","true","false"],i="",n=t(),r=/[a-zA-Z_$\d]/;r.test(n);)i+=n,s++,n=t();-1===e.indexOf(i)?o.push('"'+i+'"'):o.push(i)}():(o.push(c),s++)}return o.join("")},t.escapeUnicodeChars=function(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})},t.validate=function(e){void 0!==n?n.parse(e):JSON.parse(e)},t.extend=function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},t.clear=function(e){for(var t in e)e.hasOwnProperty(t)&&delete e[t];return e},t.type=function(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp||"regexp"==typeof e?"regexp":t.isArray(e)?"array":"object"};var o=/^https?:\/\/\S+$/;t.isUrl=function(e){return("string"==typeof e||e instanceof String)&&o.test(e)},t.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)},t.getAbsoluteLeft=function(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0},t.getAbsoluteTop=function(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0},t.addClassName=function(e,t){var i=e.className.split(" ");-1==i.indexOf(t)&&(i.push(t),e.className=i.join(" "))},t.removeClassName=function(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!=n&&(i.splice(n,1),e.className=i.join(" "))},t.stripFormatting=function(e){for(var i=e.childNodes,n=0,r=i.length;n<r;n++){var o=i[n];o.style&&o.removeAttribute("style");var s=o.attributes;if(s)for(var a=s.length-1;a>=0;a--){var l=s[a];!0===l.specified&&o.removeAttribute(l.name)}t.stripFormatting(o)}},t.setEndOfContentEditable=function(e){var t,i;document.createRange&&(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),i=window.getSelection(),i.removeAllRanges(),i.addRange(t))},t.selectContentEditable=function(e){if(e&&"DIV"==e.nodeName){var t,i;window.getSelection&&document.createRange&&(i=document.createRange(),i.selectNodeContents(e),t=window.getSelection(),t.removeAllRanges(),t.addRange(i))}},t.getSelection=function(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null},t.setSelection=function(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}},t.getSelectionOffset=function(){var e=t.getSelection();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer==e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null},t.setSelectionOffset=function(e){if(document.createRange&&window.getSelection){if(window.getSelection()){var i=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),i.setStart(e.container.firstChild,e.startOffset),i.setEnd(e.container.firstChild,e.endOffset),t.setSelection(i)}}},t.getInnerText=function(e,i){if(void 0==i&&(i={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return i.flush()+e.nodeValue;if(e.hasChildNodes()){for(var n=e.childNodes,r="",o=0,s=n.length;o<s;o++){var a=n[o];if("DIV"==a.nodeName||"P"==a.nodeName){var l=n[o-1],c=l?l.nodeName:void 0;c&&"DIV"!=c&&"P"!=c&&"BR"!=c&&(r+="\n",i.flush()),r+=t.getInnerText(a,i),i.set("\n")}else"BR"==a.nodeName?(r+=i.flush(),i.set("\n")):r+=t.getInnerText(a,i)}return r}return"P"==e.nodeName&&-1!=t.getInternetExplorerVersion()?i.flush():""},t.getInternetExplorerVersion=function(){if(-1==s){var e=-1;if("undefined"!=typeof navigator&&"Microsoft Internet Explorer"==navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})").exec(t)&&(e=parseFloat(RegExp.$1))}s=e}return s},t.isFirefox=function(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")};var s=-1;t.addEventListener=function(e,i,n,r){if(e.addEventListener)return void 0===r&&(r=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.addEventListener(i,n,r),n;if(e.attachEvent){var o=function(){return n.call(e,window.event)};return e.attachEvent("on"+i,o),o}},t.removeEventListener=function(e,i,n,r){e.removeEventListener?(void 0===r&&(r=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.removeEventListener(i,n,r)):e.detachEvent&&e.detachEvent("on"+i,n)},t.isChildOf=function(e,t){for(var i=e.parentNode;i;){if(i===t)return!0;i=i.parentNode}return!1},t.parsePath=function e(t){var i,n;if(0===t.length)return[];var r=t.match(/^\.([\w$]+)/);if(r)i=r[1],n=t.substr(i.length+1);else{if("["!==t[0])throw new SyntaxError("Failed to parse path");var o=t.indexOf("]");if(-1===o)throw new SyntaxError("Character ] expected in path");if(1===o)throw new SyntaxError("Index expected after [");var s=t.substring(1,o);"'"===s[0]&&(s='"'+s.substring(1,s.length-1)+'"'),i="*"===s?s:JSON.parse(s),n=t.substr(o+1)}return[i].concat(e(n))},t.stringifyPath=function(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"."+e}).join("")},t.improveSchemaError=function(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(t=t.map(function(e){return JSON.stringify(e)}),t.length>5){var i=["("+(t.length-5)+" more...)"];t=t.slice(0,5),t.push(i)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e},t.isPromise=function(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch},t.isValidValidationError=function(e){return"object"==typeof e&&Array.isArray(e.path)&&"string"==typeof e.message},t.insideRect=function(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom},t.debounce=function(e,t,i){var n;return function(){var r=this,o=arguments,s=function(){n=null,i||e.apply(r,o)},a=i&&!n;clearTimeout(n),n=setTimeout(s,t),a&&e.apply(r,o)}},t.textDiff=function(e,t){for(var i=t.length,n=0,r=e.length,o=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(o-1)===e.charAt(r-1)&&o>n&&r>0;)o--,r--;return{start:n,end:o}},t.getInputSelection=function(e){function t(t){var i=e.value.substring(0,t);return{row:(i.match(/\n/g)||[]).length+1,column:i.length-i.lastIndexOf("\n")}}var i,n,r,o,s,a=0,l=0;return"number"==typeof e.selectionStart&&"number"==typeof e.selectionEnd?(a=e.selectionStart,l=e.selectionEnd):(n=document.selection.createRange())&&n.parentElement()==e&&(o=e.value.length,i=e.value.replace(/\r\n/g,"\n"),r=e.createTextRange(),r.moveToBookmark(n.getBookmark()),s=e.createTextRange(),s.collapse(!1),r.compareEndPoints("StartToEnd",s)>-1?a=l=o:(a=-r.moveStart("character",-o),a+=i.slice(0,a).split("\n").length-1,r.compareEndPoints("EndToEnd",s)>-1?l=o:(l=-r.moveEnd("character",-o),l+=i.slice(0,l).split("\n").length-1))),{startIndex:a,endIndex:l,start:t(a),end:t(l)}},t.getIndexForPosition=function(e,t,i){var n=e.value||"";if(t>0&&i>0){var r=n.split("\n",t);t=Math.min(r.length,t),i=Math.min(r[t-1].length,i-1);var o=1==t?i:i+1;return r.slice(0,t-1).join("\n").length+o}return-1},t.getPositionForPath=function(e,t){var i,n=this,o=[];if(!t||!t.length)return o;try{i=r.parse(e)}catch(e){return o}return t.forEach(function(e){var t=n.parsePath(e),r=t.length?"/"+t.join("/"):"",s=i.pointers[r];s&&o.push({path:e,line:s.key?s.key.line:s.value?s.value.line:0,column:s.key?s.key.column:s.value?s.value.column:0})}),o},t.getColorCSS=function(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null},t.isValidColor=function(e){return!!t.getColorCSS(e)},"undefined"!=typeof Element&&function(){function e(e){e.hasOwnProperty("remove")||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){null!=this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&e(Element.prototype),"undefined"!=typeof CharacterData&&e(CharacterData.prototype),"undefined"!=typeof DocumentType&&e(DocumentType.prototype)}(),String.prototype.startsWith||(String.prototype.startsWith=function(e,t){return t=t||0,this.substr(t,e.length)===e}),Array.prototype.find||(Array.prototype.find=function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return i}})},function(e,t,i){var n=function(){var e={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,r,o,s){var a=o.length-1;switch(r){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=o[a-1];case 13:this.$={};break;case 14:this.$=o[a-1];break;case 15:this.$=[o[a-2],o[a]];break;case 16:this.$={},this.$[o[a][0]]=o[a][1];break;case 17:this.$=o[a-2],o[a-2][o[a][0]]=o[a][1];break;case 18:this.$=[];break;case 19:this.$=o[a-1];break;case 20:this.$=[o[a]];break;case 21:this.$=o[a-2],o[a-2].push(o[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){function t(){var e;return e=i.lexer.lex()||1,"number"!=typeof e&&(e=i.symbols_[e]||e),e}var i=this,n=[0],r=[null],o=[],s=this.table,a="",l=0,c=0,h=0,d=2;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var u=this.lexer.yylloc;o.push(u),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var f,p,m,g,v,y,w,b,C,A={};;){if(m=n[n.length-1],this.defaultActions[m]?g=this.defaultActions[m]:(null==f&&(f=t()),g=s[m]&&s[m][f]),void 0===g||!g.length||!g[0]){if(!h){C=[];for(y in s[m])this.terminals_[y]&&y>2&&C.push("'"+this.terminals_[y]+"'");var E="";E=this.lexer.showPosition?"Parse error on line "+(l+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+C.join(", ")+", got '"+this.terminals_[f]+"'":"Parse error on line "+(l+1)+": Unexpected "+(1==f?"end of input":"'"+(this.terminals_[f]||f)+"'"),this.parseError(E,{text:this.lexer.match,token:this.terminals_[f]||f,line:this.lexer.yylineno,loc:u,expected:C})}if(3==h){if(1==f)throw new Error(E||"Parsing halted.");c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,f=t()}for(;;){if(d.toString()in s[m])break;if(0==m)throw new Error(E||"Parsing halted.");!function(e){n.length=n.length-2*e,r.length=r.length-e,o.length=o.length-e}(1),m=n[n.length-1]}p=f,f=d,m=n[n.length-1],g=s[m]&&s[m][d],h=3}if(g[0]instanceof Array&&g.length>1)throw new Error("Parse Error: multiple actions possible at state: "+m+", token: "+f);switch(g[0]){case 1:n.push(f),r.push(this.lexer.yytext),o.push(this.lexer.yylloc),n.push(g[1]),f=null,p?(f=p,p=null):(c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,h>0&&h--);break;case 2:if(w=this.productions_[g[1]][1],A.$=r[r.length-w],A._$={first_line:o[o.length-(w||1)].first_line,last_line:o[o.length-1].last_line,first_column:o[o.length-(w||1)].first_column,last_column:o[o.length-1].last_column},void 0!==(v=this.performAction.call(A,a,c,l,this.yy,g[1],r,o)))return v;w&&(n=n.slice(0,-1*w*2),r=r.slice(0,-1*w),o=o.slice(0,-1*w)),n.push(this.productions_[g[1]][0]),r.push(A.$),o.push(A._$),b=s[n[n.length-2]][n[n.length-1]],n.push(b);break;case 3:return!0}}return!0}},t=function(){var e={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(e.length>20?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(e.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0);var e,t,i,n,r;this._more||(this.yytext="",this.match="");for(var o=this._currentRules(),s=0;s<o.length&&(!(i=this._input.match(this.rules[o[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?(r=t[0].match(/\n.*/g),r&&(this.yylineno+=r.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:r?r[r.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,o[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)}};return e.options={},e.performAction=function(e,t,i,n){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},e.rules=[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt\/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],e.conditions={INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}},e}();return e.lexer=t,e}();t.parser=n,t.parse=n.parse.bind(n)},function(e,t){"use strict";function i(e){return a.indexOf(typeof e)>=0}function n(e){return'"'+(e=e.replace(l,"\\$&").replace(h,"\\f").replace(c,"\\b").replace(d,"\\n").replace(u,"\\r").replace(f,"\\t"))+'"'}function r(e){return e.replace(p,"~0").replace(m,"~1")}var o={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},s="a".charCodeAt();t.parse=function(e){function t(t,r){i();var o;m(t,"value");var s=d();switch(s){case"t":h("rue"),o=!0;break;case"f":h("alse"),o=!1;break;case"n":h("ull"),o=null;break;case'"':o=n();break;case"[":o=l(t);break;case"{":o=c(t);break;default:u(),"-0123456789".indexOf(s)>=0?o=a():y()}return m(t,"valueEnd"),i(),r&&F<e.length&&y(),o}function i(){e:for(;F<e.length;){switch(e[F]){case" ":E++;break;case"\t":E+=4;break;case"\r":E=0;break;case"\n":E=0,A++;break;default:break e}F++}}function n(){for(var e,t="";;){if('"'==(e=d()))break;"\\"==e?(e=d(),e in o?t+=o[e]:"u"==e?t+=f():w()):t+=e}return t}function a(){var t="";return"-"==e[F]&&(t+=d()),t+="0"==e[F]?d():p(),"."==e[F]&&(t+=d()+p()),"e"!=e[F]&&"E"!=e[F]||(t+=d(),"+"!=e[F]&&"-"!=e[F]||(t+=d()),t+=p()),+t}function l(e){i();var n=[],r=0;if("]"==d())return n;for(u();;){var o=e+"/"+r;n.push(t(o)),i();var s=d();if("]"==s)break;","!=s&&w(),i(),r++}return n}function c(e){i();var o={};if("}"==d())return o;for(u();;){var s=v();'"'!=d()&&w();var a=n(),l=e+"/"+r(a);g(l,"key",s),m(l,"keyEnd"),i(),":"!=d()&&w(),i(),o[a]=t(l),i();var c=d();if("}"==c)break;","!=c&&w(),i()}return o}function h(e){for(var t=0;t<e.length;t++)d()!==e[t]&&w()}function d(){b();var t=e[F];return F++,E++,t}function u(){F--,E--}function f(){for(var e=4,t=0;e--;){t<<=4;var i=d().toLowerCase();i>="a"&&i<="f"?t+=i.charCodeAt()-s+10:i>="0"&&i<="9"?t+=+i:w()}return String.fromCharCode(t)}function p(){for(var t="";e[F]>="0"&&e[F]<="9";)t+=d();if(t.length)return t;b(),y()}function m(e,t){g(e,t,v())}function g(e,t,i){C[e]=C[e]||{},C[e][t]=i}function v(){return{line:A,column:E,pos:F}}function y(){throw new SyntaxError("Unexpected token "+e[F]+" in JSON at position "+F)}function w(){u(),y()}function b(){if(F>=e.length)throw new SyntaxError("Unexpected end of JSON input")}var C={},A=0,E=0,F=0;return{data:t("",!0),
pointers:C}},t.stringify=function(e,t,o){function s(e,t,h){switch(c(h,"value"),typeof e){case"number":case"boolean":a(""+e);break;case"string":a(n(e));break;case"object":null===e?a("null"):"function"==typeof e.toJSON?a(n(e.toJSON())):Array.isArray(e)?function(){if(e.length){a("[");for(var n=t+1,r=0;r<e.length;r++)r&&a(","),l(n),s(i(e[r])?e[r]:null,n,h+"/"+r);l(t),a("]")}else a("[]")}():function(){var d=Object.keys(e);if(d.length){a("{");for(var u=t+1,f=0;f<d.length;f++){var p=d[f],m=e[p];if(i(m)){f&&a(",");var g=h+"/"+r(p);l(u),c(g,"key"),a(n(p)),c(g,"keyEnd"),a(":"),o&&a(" "),s(m,u,g)}}l(t),a("}")}else a("{}")}()}c(h,"valueEnd")}function a(e){w+=e.length,b+=e.length,g+=e}function l(e){if(o){for(g+="\n"+h(e,o),y++,w=0;e--;)f?(y+=f,w=u):w+=u,b+=d;b+=1}}function c(e,t){v[e]=v[e]||{},v[e][t]={line:y,column:w,pos:b}}function h(e,t){return Array(e+1).join(t)}if(i(e)){var d,u,f=0;switch(typeof o){case"number":var p=o>10?10:o<0?0:Math.floor(o);o=p&&h(p," "),d=p,u=p;break;case"string":o=o.slice(0,10),d=0,u=0;for(var m=0;m<o.length;m++){switch(o[m]){case" ":u++;break;case"\t":u+=4;break;case"\r":u=0;break;case"\n":u=0,f++;break;default:throw new Error("whitespace characters not allowed in JSON")}d++}break;default:o=void 0}var g="",v={},y=0,w=0,b=0;return s(e,0,""),{json:g,pointers:v}}};var a=["number","boolean","string","object"],l=/"|\\/g,c=/[\b]/g,h=/\f/g,d=/\n/g,u=/\r/g,f=/\t/g,p=/~/g,m=/\//g},function(e,t){"use strict";var i,n=["en","pt-BR"],r={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",collapseAll:"Collapse all fields",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.'},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",collapseAll:"Fechar todos campos",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",selectNode:"Select a node...",showAll:"mostre tudo",showMore:"mostre mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"Texto",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.'}},o="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0;i=n.find(function(e){return e===o}),i||(i="en"),e.exports={_locales:n,_defs:r,_lang:i,setLanguage:function(e){if(e){var t=n.find(function(t){return t===e});t?i=t:console.error("Language not found")}},setLanguages:function(e){if(e)for(var t in e){var i=n.find(function(e){return e===t});i||n.push(t),r[t]=Object.assign({},r.en,r[t],e[t])}},translate:function(e,t,n){n||(n=i);var o=r[n][e];if(t)for(e in t)o=o.replace("${"+e+"}",t[e]);return o||e}}},function(e,t,i){"use strict";function n(e){e&&(this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",e.appendChild(this.path),this.reset())}var r=i(63),o=i(68).translate;n.prototype.reset=function(){this.path.innerHTML=o("selectNode")},n.prototype.setPath=function(e){function t(e){this.selectionCallback&&this.selectionCallback(e)}function i(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}var n=this;this.path.innerHTML="",e&&e.length&&e.forEach(function(o,s){var a,l=document.createElement("span");if(l.className="jsoneditor-treepath-element",l.innerText=o.name,l.onclick=t.bind(n,o),n.path.appendChild(l),o.children.length&&(a=document.createElement("span"),a.className="jsoneditor-treepath-seperator",a.innerHTML="&#9658;",a.onclick=function(){var t=[];o.children.forEach(function(r){t.push({text:r.name,className:"jsoneditor-type-modes"+(e[s+1]+1&&e[s+1].name===r.name?" jsoneditor-selected":""),click:i.bind(n,o,r.name)})}),new r(t).show(a)},n.path.appendChild(a,n.container)),s===e.length-1){var c=(a||l).getBoundingClientRect().left;n.path.offsetWidth<c&&(n.path.scrollLeft=c)}})},n.prototype.onSectionSelected=function(e){"function"==typeof e&&(this.selectionCallback=e)},n.prototype.onContextMenuItemSelected=function(e){"function"==typeof e&&(this.contextMenuCallback=e)},e.exports=n},function(e,t,i){"use strict";function n(e,t){this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=p.debounce(this._onChangeValue.bind(this),n.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=p.debounce(this._onChangeField.bind(this),n.prototype.DEBOUNCE_INTERVAL)}function r(e){return e.getInternalPath()}function o(e){return e.getField()}var s=i(71),a=i(72),l=i(64).createAbsoluteAnchor,c=i(63),h=i(73),d=i(74),u=i(75),f=i(77),p=i(65),m=i(68).translate,g=document.body;n.prototype.DEBOUNCE_INTERVAL=150,n.prototype.MAX_SEARCH_RESULTS=999,n.prototype.MAX_VISIBLE_CHILDS=100,n.prototype.visibleChilds=n.prototype.MAX_VISIBLE_CHILDS,n.prototype._updateEditability=function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}},n.prototype.getPath=function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t},n.prototype.getInternalPath=function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t},n.prototype.getName=function(){return this.parent?"array"!=this.parent.type?this.field:this.index:void 0},n.prototype.findNodeByPath=function(e){if(e){if(0==e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}},n.prototype.findNodeByInternalPath=function(e){if(e){for(var t=this,i=0;i<e.length&&t;i++){var n=e[i];t=t.childs[n]}return t}},n.prototype.serialize=function(){return{value:this.getValue(),path:this.getPath()}},n.prototype.findNode=function(e){for(var t=p.parsePath(e),i=this;i&&t.length>0;){var n=t.shift();if("number"==typeof n){if("array"!==i.type)throw new Error("Cannot get child node at index "+n+": node is no array");i=i.childs[n]}else{if("object"!==i.type)throw new Error("Cannot get child node "+n+": node is no object");i=i.childs.filter(function(e){return e.field===n})[0]}}return i},n.prototype.findParents=function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e},n.prototype.setError=function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()},n.prototype.updateError=function(){var e=this.error,t=this.dom.tdError;if(e&&this.dom&&this.dom.tr){p.addClassName(this.dom.tr,"jsoneditor-validation-error"),t||(t=document.createElement("td"),this.dom.tdError=t,this.dom.tdValue.parentNode.appendChild(t));var i=document.createElement("div");i.className="jsoneditor-popover jsoneditor-right",i.appendChild(document.createTextNode(e.message));var n=document.createElement("button");n.type="button",n.className="jsoneditor-button jsoneditor-schema-error",n.appendChild(i),n.onmouseover=n.onfocus=function(){for(var e=["right","above","below","left"],t=0;t<e.length;t++){var n=e[t];i.className="jsoneditor-popover jsoneditor-"+n;var r=this.editor.content.getBoundingClientRect(),o=i.getBoundingClientRect();if(p.insideRect(r,o,20))break}}.bind(this);var r=this.errorChild;for(r&&(n.onclick=function(){r.findParents().forEach(function(e){e.expand(!1)}),r.scrollTo(function(){r.focus()})});t.firstChild;)t.removeChild(t.firstChild);t.appendChild(n)}else p.removeClassName(this.dom.tr,"jsoneditor-validation-error"),t&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)},n.prototype.getIndex=function(){if(this.parent){var e=this.parent.childs.indexOf(this);return-1!==e?e:null}return-1},n.prototype.setParent=function(e){this.parent=e},n.prototype.setField=function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t},n.prototype.getField=function(){return void 0===this.field&&this._getDomField(),this.field},n.prototype.setValue=function(e,t){var i,r,o,s,a,l=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),s=0;s<e.length;s++)void 0===(i=e[s])||i instanceof Function||(s<this.childs.length?(r=this.childs[s],r.fieldEditable=!1,r.index=s,r.setValue(i)):(r=new n(this.editor,{value:i}),o=s<this.MAX_VISIBLE_CHILDS,this.appendChild(r,o,!1)));for(a=this.childs.length;a>=e.length;a--)this.removeChild(this.childs[a],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),a=this.childs.length-1;a>=0;a--)e.hasOwnProperty(this.childs[a].field)||this.removeChild(this.childs[a],!1);s=0;for(var c in e)e.hasOwnProperty(c)&&(i=e[c],void 0===i||i instanceof Function||(r=this.findChildByProperty(c),r?(r.setField(c,!0),r.setValue(i)):(r=new n(this.editor,{field:c,value:i}),o=s<this.MAX_VISIBLE_CHILDS,this.appendChild(r,o,!1))),s++);this.value="",!0===this.editor.options.sortObjectKeys&&this.sort([],"asc")}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(l)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value},n.prototype.setInternalValue=function(e){var t,i,r,o,s,a=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?(i=this.childs[o],i.fieldEditable=!1,i.index=o,i.setInternalValue(t)):(i=new n(this.editor,{internalValue:t}),r=o<this.MAX_VISIBLE_CHILDS,this.appendChild(i,r,!1)));for(s=this.childs.length;s>=e.childs.length;s--)this.removeChild(this.childs[s],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?(i=this.childs[o],delete i.index,i.setField(t.field,!0),i.setInternalValue(t.value)):(i=new n(this.editor,{field:t.field,internalValue:t.value}),r=o<this.MAX_VISIBLE_CHILDS,this.appendChild(i,r,!1)));for(s=this.childs.length;s>=e.childs.length;s--)this.removeChild(this.childs[s],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(a)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value},n.prototype.recreateDom=function(){if(this.dom&&this.dom.tr&&this.dom.tr.parentNode){var e=this._detachFromDom();this.clearDom(),this._attachToDom(e)}else this.clearDom()},n.prototype.getValue=function(){if("array"==this.type){var e=[];return this.childs.forEach(function(t){e.push(t.getValue())}),e}if("object"==this.type){var t={};return this.childs.forEach(function(e){t[e.getField()]=e.getValue()}),t}return void 0===this.value&&this._getDomValue(),this.value},n.prototype.getInternalValue=function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})},n.prototype.getLevel=function(){return this.parent?this.parent.getLevel()+1:0},n.prototype.getNodePath=function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e},n.prototype.clone=function(){var e=new n(this.editor);if(e.type=this.type,e.field=this.field,e.fieldInnerText=this.fieldInnerText,e.fieldEditable=this.fieldEditable,e.previousField=this.previousField,e.value=this.value,e.valueInnerText=this.valueInnerText,e.previousValue=this.previousValue,e.expanded=this.expanded,e.visibleChilds=this.visibleChilds,this.childs){var t=[];this.childs.forEach(function(i){var n=i.clone();n.setParent(e),t.push(n)}),e.childs=t}else e.childs=void 0;return e},n.prototype.expand=function(e){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==e&&this.childs.forEach(function(t){t.expand(e)}))},n.prototype.collapse=function(e){this.childs&&(this.hideChilds(),!1!==e&&this.childs.forEach(function(t){t.collapse(e)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1)},n.prototype.showChilds=function(){if(this.childs&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){var i=this.getAppendDom();if(!i.parentNode){var n=e.nextSibling;n?t.insertBefore(i,n):t.appendChild(i)}for(var r=Math.min(this.childs.length,this.visibleChilds),n=this._getNextTr(),o=0;o<r;o++){var s=this.childs[o];s.getDom().parentNode||t.insertBefore(s.getDom(),n),s.showChilds()}var a=this.getShowMoreDom(),n=this._getNextTr();a.parentNode||t.insertBefore(a,n),this.showMore.updateDom()}}},n.prototype._getNextTr=function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0},n.prototype.hide=function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.hideChilds(e)},n.prototype.hideChilds=function(e){if(this.childs&&this.expanded){var t=this.getAppendDom();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()});var i=this.getShowMoreDom();i.parentNode&&i.parentNode.removeChild(i),e&&!e.resetVisibleChilds||delete this.visibleChilds}},n.prototype.expandTo=function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent},n.prototype.appendChild=function(e,t,i){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"==this.type,"array"==this.type&&(e.index=this.childs.length),"object"===this.type&&void 0==e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t){var n=e.getDom(),r=this._getNextTr(),o=r?r.parentNode:void 0;r&&o&&o.insertBefore(n,r),e.showChilds(),this.visibleChilds++}!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}},n.prototype.moveBefore=function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}if(e.parent&&e.parent.removeChild(e),t instanceof v||!t)if(this.childs.length+1>this.visibleChilds){var r=this.childs[this.visibleChilds-1];this.insertBefore(e,r)}else this.appendChild(e);else this.insertBefore(e,t);i&&i.removeChild(n)}},n.prototype.insertBefore=function(e,t){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&void 0==e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"==this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1==i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"==this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),r=t.getDom(),o=r?r.parentNode:void 0;r&&o&&o.insertBefore(n,r),e.showChilds(),this.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},n.prototype.insertAfter=function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}},n.prototype.search=function(e,t){Array.isArray(t)||(t=[]);var i,n=e?e.toLowerCase():void 0;if(delete this.searchField,delete this.searchValue,void 0!==this.field&&t.length<=this.MAX_SEARCH_RESULTS){i=String(this.field).toLowerCase().indexOf(n),-1!==i&&(this.searchField=!0,t.push({node:this,elem:"field"})),this._updateDomField()}if(this._hasChilds())this.childs&&this.childs.forEach(function(i){i.search(e,t)});else if(void 0!==this.value&&t.length<=this.MAX_SEARCH_RESULTS){var r=String(this.value).toLowerCase();i=r.indexOf(n),-1!==i&&(this.searchValue=!0,t.push({node:this,elem:"value"})),this._updateDomValue()}return t},n.prototype.scrollTo=function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)},n.prototype.expandPathToNode=function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=n.prototype.MAX_VISIBLE_CHILDS;e.parent.expand(!1),e=e.parent}},n.focusElement=void 0,n.prototype.focus=function(e){if(n.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),p.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),p.selectContentEditable(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),p.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),p.selectContentEditable(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),p.selectContentEditable(t.value)):t.field&&this.fieldEditable?(t.field.focus(),p.selectContentEditable(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}},n.select=function(e){setTimeout(function(){p.selectContentEditable(e)},0)},n.prototype.blur=function(){this._getDomValue(!1),this._getDomField(!1)},n.prototype.containsNode=function(e){if(this==e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1},n.prototype.removeChild=function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i){i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(i,1)[0];return n.parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),n}}},n.prototype._remove=function(e){this.removeChild(e)},n.prototype.changeType=function(e){var t=this.type;if(t!=e){if("string"!=e&&"auto"!=e||"string"!=t&&"auto"!=t){var i=this._detachFromDom();this.clearDom(),this.type=e,"object"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0==e.field&&(e.field="")}),"string"!=t&&"auto"!=t||(this.expanded=!0)):"array"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!=t&&"auto"!=t||(this.expanded=!0)):this.expanded=!1,this._attachToDom(i)}else this.type=e;"auto"!=e&&"string"!=e||(this.value="string"==e?String(this.value):this._stringCast(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}},n.prototype.deepEqual=function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!=typeof e)return!1;var i={},n=0;for(t=0;t<this.childs.length;t++){var r=this.childs[t];if(!i[r.field]){if(i[r.field]=!0,n++,!(r.field in e))return!1;if(!r.deepEqual(e[r.field]))return!1}}if(n!==Object.keys(e).length)return!1}else if(this.value!==e)return!1;return!0},n.prototype._getDomValue=function(e){if(this.dom.value&&"array"!=this.type&&"object"!=this.type&&(this.valueInnerText=p.getInnerText(this.dom.value)),void 0!=this.valueInnerText)try{var t;if("string"==this.type)t=this._unescapeHTML(this.valueInnerText);else{var i=this._unescapeHTML(this.valueInnerText);t=this._stringCast(i)}t!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(t){if(this.value=void 0,!0!==e)throw t}},n.prototype._onChangeValue=function(){var e=this.editor.getDomSelection();if(e.range){var t=p.textDiff(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getDomSelection();if(i.range){var n=p.textDiff(String(this.previousValue),String(this.value));i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:i}),this.previousValue=this.value},n.prototype._onChangeField=function(){var e=this.editor.getDomSelection(),t=this.previousField||"";if(e.range){var i=p.textDiff(this.field,t);e.range.startOffset=i.start,e.range.endOffset=i.end}var n=this.editor.getDomSelection();if(n.range){var r=p.textDiff(t,this.field);n.range.startOffset=r.start,n.range.endOffset=r.end}this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field},n.prototype._updateDomValue=function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"==this.type?p.type(i):this.type,r="string"==n&&p.isUrl(i);t.push("jsoneditor-"+n),r&&t.push("jsoneditor-url");if(""==String(this.value)&&"array"!=this.type&&"object"!=this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"==n||"object"==n){var o=this.childs?this.childs.length:0;e.title=this.type+" containing "+o+" items"}else r&&this.editable.value?e.title=m("openUrl"):e.title="";if("boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value==this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||this.schema.hasOwnProperty("oneOf")||this.schema.hasOwnProperty("anyOf")||this.schema.hasOwnProperty("allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);this.editable.value&&this.editor.options.colorPicker&&"string"==typeof i&&p.isValidColor(i)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue),this.dom.value.style.color="#1A1A1A"),this.dom.color.style.backgroundColor=i):this._deleteDomColor(),this.editor.options.timestampTag&&"number"==typeof i&&i>9466848e5&&!isNaN(new Date(i).valueOf())?(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),this.dom.date.innerHTML=new Date(i).toISOString(),this.dom.date.title=new Date(i).toString()):this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date),p.stripFormatting(e)}},n.prototype._deleteDomColor=function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,this.dom.value.style.color="")},n.prototype._updateDomField=function(){var e=this.dom.field;if(e){""==String(this.field)&&"array"!=this.parent.type?p.addClassName(e,"jsoneditor-empty"):p.removeClassName(e,"jsoneditor-empty"),this.searchFieldActive?p.addClassName(e,"jsoneditor-highlight-active"):p.removeClassName(e,"jsoneditor-highlight-active"),this.searchField?p.addClassName(e,"jsoneditor-highlight"):p.removeClassName(e,"jsoneditor-highlight"),p.stripFormatting(e)}},n.prototype._getDomField=function(e){if(this.dom.field&&this.fieldEditable&&(this.fieldInnerText=p.getInnerText(this.dom.field)),void 0!=this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText);t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(t){if(this.field=void 0,!0!==e)throw t}},n.prototype.validate=function(){var e=[];if("object"===this.type){for(var t={},i=[],n=0;n<this.childs.length;n++){var r=this.childs[n];t.hasOwnProperty(r.field)&&i.push(r.field),t[r.field]=!0}i.length>0&&(e=this.childs.filter(function(e){return-1!==i.indexOf(e.field)}).map(function(e){return{node:e,error:{message:m("duplicateKey")+' "'+e.field+'"'}}}))}if(this.childs)for(var n=0;n<this.childs.length;n++){var o=this.childs[n].validate();o.length>0&&(e=e.concat(o))}return e},n.prototype.clearDom=function(){this.dom={}},n.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),e.tr.node=this,"tree"===this.editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");i.type="button",e.drag=i,i.className="jsoneditor-button jsoneditor-dragarea",i.title=m("drag"),t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),r=document.createElement("button");r.type="button",e.menu=r,r.className="jsoneditor-button jsoneditor-contextmenu",r.title=m("actionsMenu"),n.appendChild(e.menu),e.tr.appendChild(n)}var o=document.createElement("td");return e.tr.appendChild(o),e.tree=this._createDomTree(),o.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr},n.prototype.isVisible=function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1},n.onDragStart=function(e,t){if(!Array.isArray(e))return n.onDragStart([e],t);if(0!==e.length){var i=e[0],o=e[e.length-1],s=i.parent,a=n.getNodeFromTarget(t.target),l=i.editor,c=p.getAbsoluteTop(a.dom.tr)-p.getAbsoluteTop(i.dom.tr);l.mousemove||(l.mousemove=p.addEventListener(window,"mousemove",function(t){n.onDrag(e,t)})),l.mouseup||(l.mouseup=p.addEventListener(window,"mouseup",function(t){n.onDragEnd(e,t)})),l.highlighter.lock(),l.drag={oldCursor:document.body.style.cursor,oldSelection:l.getDomSelection(),oldPaths:e.map(r),oldParent:s,oldNextNode:s.childs[o.getIndex()+1]||s.append,oldParentPathRedo:s.getInternalPath(),oldIndexRedo:i.getIndex(),mouseX:t.pageX,offsetY:c,level:i.getLevel()},document.body.style.cursor="move",t.preventDefault()}},n.onDrag=function(e,t){if(!Array.isArray(e))return n.onDrag([e],t);if(0!==e.length){var i,r,o,s,a,l,c,h,d,u,f,m,g,y,w=e[0].editor,b=t.pageY-w.drag.offsetY,C=t.pageX,A=!1,E=e[0];if(i=E.dom.tr,d=p.getAbsoluteTop(i),m=i.offsetHeight,b<d){r=i;do{r=r.previousSibling,c=n.getNodeFromTarget(r),u=r?p.getAbsoluteTop(r):0}while(r&&b<u);c&&!c.parent&&(c=void 0),c||(l=i.parentNode.firstChild,r=l?l.nextSibling:void 0,(c=n.getNodeFromTarget(r))==E&&(c=void 0)),c&&c.isVisible()&&(r=c.dom.tr,u=r?p.getAbsoluteTop(r):0,b>u+m&&(c=void 0)),c&&(e.forEach(function(e){c.parent.moveBefore(e,c)}),A=!0)}else{var F=e[e.length-1];if(a=F.expanded&&F.append?F.append.getDom():F.dom.tr,s=a?a.nextSibling:void 0){f=p.getAbsoluteTop(s),o=s;do{h=n.getNodeFromTarget(o),o&&(g=o.nextSibling?p.getAbsoluteTop(o.nextSibling):0,y=o?g-f:0,h&&h.parent.childs.length==e.length&&h.parent.childs[e.length-1]==F&&(d+=27),o=o.nextSibling)}while(o&&b>d+y);if(h&&h.parent){var x=C-w.drag.mouseX,S=Math.round(x/24/2),_=w.drag.level+S,k=h.getLevel();for(r=h.dom.tr&&h.dom.tr.previousSibling;k<_&&r;){c=n.getNodeFromTarget(r);if(e.some(function(e){return e===c||c.isDescendantOf(e)}));else{if(!(c instanceof v))break;var D=c.parent.childs;if(D.length==e.length&&D[e.length-1]==F)break;h=n.getNodeFromTarget(r),k=h.getLevel()}r=r.previousSibling}h instanceof v&&!h.isVisible()&&h.parent.showMore.isVisible()&&(h=h._nextNode()),h&&h.dom.tr&&a.nextSibling!=h.dom.tr&&(e.forEach(function(e){h.parent.moveBefore(e,h)}),A=!0)}}}A&&(w.drag.mouseX=C,w.drag.level=E.getLevel()),w.startAutoScroll(b),t.preventDefault()}},n.onDragEnd=function(e,t){if(!Array.isArray(e))return n.onDrag([e],t);if(0!==e.length){var i=e[0],r=i.editor;e[0]&&e[0].dom.menu.focus();var s=r.drag.oldParent.getInternalPath(),a=i.parent.getInternalPath(),l=r.drag.oldParent===i.parent,c=r.drag.oldNextNode.getIndex(),h=i.getIndex(),d=r.drag.oldParentPathRedo,u=r.drag.oldIndexRedo,f=l&&u<h?h+e.length:h;l&&u===h||r._onAction("moveNodes",{count:e.length,fieldNames:e.map(o),oldParentPath:s,newParentPath:a,oldIndex:c,newIndex:h,oldIndexRedo:u,newIndexRedo:f,oldParentPathRedo:d,newParentPathRedo:null,oldSelection:r.drag.oldSelection,newSelection:r.getDomSelection()}),document.body.style.cursor=r.drag.oldCursor,r.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&r.highlighter.unhighlight()}),delete r.drag,r.mousemove&&(p.removeEventListener(window,"mousemove",r.mousemove),delete r.mousemove),r.mouseup&&(p.removeEventListener(window,"mouseup",r.mouseup),delete r.mouseup),r.stopAutoScroll(),t.preventDefault()}},n.prototype.isDescendantOf=function(e){for(var t=this.parent;t;){if(t==e)return!0;t=t.parent}return!1},n.prototype._createDomField=function(){return document.createElement("div")},n.prototype.setHighlight=function(e){this.dom.tr&&(e?p.addClassName(this.dom.tr,"jsoneditor-highlight"):p.removeClassName(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(e),this.childs&&this.childs.forEach(function(t){t.setHighlight(e)}))},n.prototype.setSelected=function(e,t){this.selected=e,this.dom.tr&&(e?p.addClassName(this.dom.tr,"jsoneditor-selected"):p.removeClassName(this.dom.tr,"jsoneditor-selected"),t?p.addClassName(this.dom.tr,"jsoneditor-first"):p.removeClassName(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(e),this.showMore&&this.showMore.setSelected(e),this.childs&&this.childs.forEach(function(t){t.setSelected(e)}))},n.prototype.updateValue=function(e){this.value=e,this.previousValue=e,this.updateDom()},n.prototype.updateField=function(e){this.field=e,this.previousField=e,this.updateDom()},n.prototype.updateDom=function(e){var t=this.dom.tree;t&&(t.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):(i.contentEditable=!1,i.className="jsoneditor-readonly");var n;n=void 0!=this.index?this.index:void 0!=this.field?this.field:this._hasChilds()?this.type:"",i.innerHTML=this._escapeHTML(n),this._updateSchema()}var r=this.dom.value;if(r){var o=this.childs?this.childs.length:0;"array"==this.type?(r.innerHTML="["+o+"]",p.addClassName(this.dom.tr,"jsoneditor-expandable")):"object"==this.type?(r.innerHTML="{"+o+"}",p.addClassName(this.dom.tr,"jsoneditor-expandable")):(r.innerHTML=this._escapeHTML(this.value),p.removeClassName(this.dom.tr,"jsoneditor-expandable"))}this._updateDomField(),this._updateDomValue(),e&&!0===e.updateIndexes&&this._updateDomIndexes(),e&&!0===e.recurse&&this.childs&&this.childs.forEach(function(t){t.updateDom(e)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom()},n.prototype._updateSchema=function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?n._findSchema(this.editor.options.schema,this.getPath()):null,this.schema?this.enum=n._findEnum(this.schema):delete this.enum)},n._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(i.length>0)return i[0].enum}return null},n._findSchema=function(e,t){var i=e,r=i,o=e.oneOf||e.anyOf||e.allOf;o||(o=[e]);for(var s=0;s<o.length;s++){i=o[s];for(var a=0;a<t.length&&i;a++){var l=t[a];if("string"==typeof l&&i.patternProperties&&a==t.length-1)for(var c in i.patternProperties)r=n._findSchema(i.patternProperties[c],t.slice(a,t.length));else i.items&&i.items.properties?(i=i.items.properties[l])&&(r=n._findSchema(i,t.slice(a,t.length))):"string"==typeof l&&i.properties?(i=i.properties[l]||null)&&(r=n._findSchema(i,t.slice(a,t.length))):"number"==typeof l&&i.items&&(i=i.items)&&(r=n._findSchema(i,t.slice(a,t.length)))}}return r},n.prototype._updateDomIndexes=function(){var e=this.dom.value,t=this.childs;e&&t&&("array"==this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"==this.type&&t.forEach(function(e){void 0!=e.index&&(delete e.index,void 0==e.field&&(e.field=""))}))},n.prototype._createDomValue=function(){var e;return"array"==this.type?(e=document.createElement("div"),e.innerHTML="[...]"):"object"==this.type?(e=document.createElement("div"),e.innerHTML="{...}"):!this.editable.value&&p.isUrl(this.value)?(e=document.createElement("a"),e.href=this.value,e.innerHTML=this._escapeHTML(this.value)):(e=document.createElement("div"),e.contentEditable=this.editable.value,e.spellcheck=!1,e.innerHTML=this._escapeHTML(this.value)),e},n.prototype._createDomExpandButton=function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=m("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e},n.prototype._createDomTree=function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.expand=this._createDomExpandButton(),r.appendChild(e.expand),e.tdExpand=r;var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.field=this._createDomField(),o.appendChild(e.field),e.tdField=o;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!=this.type&&"array"!=this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t},n.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,r=this,o=this._hasChilds();if("function"==typeof this.editor.options.onEvent&&this._onEvent(e),i!=n.drag&&i!=n.menu||("mouseover"==t?this.editor.highlighter.highlight(this):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var s=r.editor.highlighter;s.highlight(r),s.lock(),p.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){p.removeClassName(n.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"==t&&(i==n.expand||("view"===r.editor.options.mode||"form"===r.editor.options.mode)&&"DIV"===i.nodeName)&&o){var a=e.ctrlKey;this._onExpand(a)}"click"!==t||e.target!==r.dom.tdColor&&e.target!==r.dom.color||this._showColorPicker(),"change"==t&&i==n.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue()),"change"==t&&i==n.select&&(this.dom.value.innerHTML=n.select.value,this._getDomValue(),this._updateDomValue());var l=n.value;if(i==l)switch(t){case"blur":case"change":this._getDomValue(!0),this._updateDomValue(),this.value&&(l.innerHTML=this._escapeHTML(this.value));break;case"input":this._getDomValue(!0),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&p.isUrl(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(!0),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){r._getDomValue(!0),r._updateDomValue()},1)}var c=n.field;if(i==c)switch(t){case"blur":case"change":this._getDomField(!0),this._updateDomField(),this.field&&(c.innerHTML=this._escapeHTML(this.field));break;case"input":this._getDomField(!0),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(!0),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){r._getDomField(!0),r._updateDomField()},1)}var h=n.tree;if(h&&i==h.parentNode&&"click"==t&&!e.hasMoved){(void 0!=e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<p.getAbsoluteLeft(n.tdSeparator))||o?c&&(p.setEndOfContentEditable(c),c.focus()):l&&!this.enum&&(p.setEndOfContentEditable(l),l.focus())}(i!=n.tdExpand||o)&&i!=n.tdField&&i!=n.tdSeparator||"click"!=t||e.hasMoved||c&&(p.setEndOfContentEditable(c),c.focus()),"keydown"==t&&this.onKeyDown(e)},n.prototype._onEvent=function(e){var t=e.target;if(t===this.dom.field||t===this.dom.value){var i={field:this.getField(),path:this.getPath()};this._hasChilds()||t!==this.dom.value||(i.value=this.getValue()),this.editor.options.onEvent(i,e)}},n.prototype.onKeyDown=function(e){var t,i,r,s,a,l,c,h,d,u,f,m,g,y=e.which||e.keyCode,w=e.target||e.srcElement,b=e.ctrlKey,C=e.shiftKey,A=e.altKey,E=!1,F="tree"===this.editor.options.mode,x=this.editor.multiselection.nodes.length>0?this.editor.multiselection.nodes:[this],S=x[0],_=x[x.length-1];if(13==y){if(w==this.dom.value)this.editable.value&&!e.ctrlKey||p.isUrl(this.value)&&(window.open(this.value,"_blank"),E=!0);else if(w==this.dom.expand){var k=this._hasChilds();if(k){var D=e.ctrlKey;this._onExpand(D),w.focus(),E=!0}}}else if(68==y)b&&F&&(n.onDuplicate(x),E=!0);else if(69==y)b&&(this._onExpand(C),w.focus(),E=!0);else if(77==y&&F)b&&(this.showContextMenu(w),E=!0);else if(46==y&&F)b&&(n.onRemove(x),E=!0);else if(45==y&&F)b&&!C?(this._onInsertBefore(),E=!0):b&&C&&(this._onInsertAfter(),E=!0);else if(35==y){if(A){var $=this._lastNode();$&&$.focus(n.focusElement||this._getElementName(w)),E=!0}}else if(36==y){if(A){var B=this._firstNode();B&&B.focus(n.focusElement||this._getElementName(w)),E=!0}}else if(37==y){if(A&&!C){var L=this._previousElement(w);L&&this.focus(this._getElementName(L)),E=!0}else if(A&&C&&F){if(_.expanded){var R=_.getAppendDom();r=R?R.nextSibling:void 0}else{var T=_.getDom();r=T.nextSibling}r&&(i=n.getNodeFromTarget(r),s=r.nextSibling,O=n.getNodeFromTarget(s),i&&i instanceof v&&1!=_.parent.childs.length&&O&&O.parent&&(a=this.editor.getDomSelection(),c=S.parent,l=c.childs[_.getIndex()+1]||c.append,h=S.getIndex(),d=O.getIndex(),u=c.getInternalPath(),f=O.parent.getInternalPath(),x.forEach(function(e){O.parent.moveBefore(e,O)}),this.focus(n.focusElement||this._getElementName(w)),this.editor._onAction("moveNodes",{count:x.length,fieldNames:x.map(o),oldParentPath:c.getInternalPath(),newParentPath:S.parent.getInternalPath(),oldIndex:l.getIndex(),newIndex:S.getIndex(),oldIndexRedo:h,newIndexRedo:d,oldParentPathRedo:u,newParentPathRedo:f,oldSelection:a,newSelection:this.editor.getDomSelection()})))}}else if(38==y)A&&!C?(t=this._previousNode(),t&&(this.editor.deselect(!0),t.focus(n.focusElement||this._getElementName(w))),E=!0):!A&&b&&C&&F?(t=this._previousNode(),t&&(g=this.editor.multiselection,g.start=g.start||this,g.end=t,m=this.editor._findTopLevelNodes(g.start,g.end),this.editor.select(m),t.focus("field")),E=!0):A&&C&&F&&(t=S._previousNode(),t&&t.parent&&(a=this.editor.getDomSelection(),c=S.parent,l=c.childs[_.getIndex()+1]||c.append,h=S.getIndex(),d=t.getIndex(),u=c.getInternalPath(),f=t.parent.getInternalPath(),x.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(n.focusElement||this._getElementName(w)),this.editor._onAction("moveNodes",{count:x.length,fieldNames:x.map(o),oldParentPath:c.getInternalPath(),newParentPath:S.parent.getInternalPath(),oldIndex:l.getIndex(),newIndex:S.getIndex(),oldIndexRedo:h,newIndexRedo:d,oldParentPathRedo:u,newParentPathRedo:f,oldSelection:a,newSelection:this.editor.getDomSelection()})),E=!0);else if(39==y){if(A&&!C){var P=this._nextElement(w);P&&this.focus(this._getElementName(P)),E=!0}else if(A&&C&&F){T=S.getDom();var M=T.previousSibling;M&&(t=n.getNodeFromTarget(M))&&t.parent&&!t.isVisible()&&(a=this.editor.getDomSelection(),c=S.parent,l=c.childs[_.getIndex()+1]||c.append,h=S.getIndex(),d=t.getIndex(),u=c.getInternalPath(),f=t.parent.getInternalPath(),x.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(n.focusElement||this._getElementName(w)),this.editor._onAction("moveNodes",{count:x.length,fieldNames:x.map(o),oldParentPath:c.getInternalPath(),newParentPath:S.parent.getInternalPath(),oldIndex:l.getIndex(),newIndex:S.getIndex(),oldIndexRedo:h,newIndexRedo:d,oldParentPathRedo:u,newParentPathRedo:f,oldSelection:a,newSelection:this.editor.getDomSelection()}))}}else if(40==y)if(A&&!C)i=this._nextNode(),i&&(this.editor.deselect(!0),i.focus(n.focusElement||this._getElementName(w))),E=!0;else if(!A&&b&&C&&F)i=this._nextNode(),i&&(g=this.editor.multiselection,g.start=g.start||this,g.end=i,m=this.editor._findTopLevelNodes(g.start,g.end),this.editor.select(m),i.focus("field")),E=!0;else if(A&&C&&F){i=_.expanded?_.append?_.append._nextNode():void 0:_._nextNode(),i&&!i.isVisible()&&(i=i.parent.showMore),i&&i instanceof v&&(i=_);var O=i&&(i._nextNode()||i.parent.append);O&&O.parent&&(a=this.editor.getDomSelection(),c=S.parent,l=c.childs[_.getIndex()+1]||c.append,h=S.getIndex(),d=O.getIndex(),u=c.getInternalPath(),f=O.parent.getInternalPath(),x.forEach(function(e){O.parent.moveBefore(e,O)}),this.focus(n.focusElement||this._getElementName(w)),this.editor._onAction("moveNodes",{count:x.length,fieldNames:x.map(o),oldParentPath:c.getInternalPath(),newParentPath:S.parent.getInternalPath(),oldParentPathRedo:u,newParentPathRedo:f,oldIndexRedo:h,newIndexRedo:d,oldIndex:l.getIndex(),newIndex:S.getIndex(),oldSelection:a,newSelection:this.editor.getDomSelection()})),E=!0}E&&(e.preventDefault(),e.stopPropagation())},n.prototype._onExpand=function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)},n.prototype._showColorPicker=function(){if("function"==typeof this.editor.options.onColorPicker&&this.dom.color){var e=this;e._deleteDomColor(),e.updateDom();var t=l(this.dom.color,this.editor.frame);this.editor.options.onColorPicker(t,this.value,function(t){"string"==typeof t&&t!==e.value&&(e._deleteDomColor(),e.value=t,e.updateDom(),e._debouncedOnChangeValue())})}},n.onRemove=function(e){if(!Array.isArray(e))return n.onRemove([e]);if(e&&e.length>0){var t=e[0],i=t.parent,o=t.editor,s=t.getIndex();o.highlighter.unhighlight();var a=o.getDomSelection();n.blurNodes(e);var l=o.getDomSelection(),c=e.map(r);e.forEach(function(e){e.parent._remove(e)}),o._onAction("removeNodes",{nodes:e,paths:c,parentPath:i.getInternalPath(),index:s,oldSelection:a,newSelection:l})}},n.onDuplicate=function(e){if(!Array.isArray(e))return n.onDuplicate([e]);if(e&&e.length>0){var t=e[e.length-1],i=t.parent,o=t.editor;o.deselect(o.multiselection.nodes);var s=o.getDomSelection(),a=t,l=e.map(function(e){var t=e.clone();return i.insertAfter(t,a),a=t,t});1===e.length?l[0].focus():o.select(l);var c=o.getDomSelection();o._onAction("duplicateNodes",{paths:e.map(r),clonePaths:l.map(r),afterPath:t.getInternalPath(),parentPath:i.getInternalPath(),oldSelection:s,newSelection:c})}},n.prototype._onInsertBefore=function(e,t,i){var r=this.editor.getDomSelection(),o=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});o.expand(!0);var s=this.getInternalPath();this.parent.insertBefore(o,this),this.editor.highlighter.unhighlight(),o.focus("field");var a=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[o],paths:[o.getInternalPath()],beforePath:s,parentPath:this.parent.getInternalPath(),oldSelection:r,newSelection:a})},n.prototype._onInsertAfter=function(e,t,i){var r=this.editor.getDomSelection(),o=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});o.expand(!0),this.parent.insertAfter(o,this),this.editor.highlighter.unhighlight(),o.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[o],paths:[o.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:r,newSelection:s})},n.prototype._onAppend=function(e,t,i){var r=this.editor.getDomSelection(),o=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});o.expand(!0),this.parent.appendChild(o),this.editor.highlighter.unhighlight(),o.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[o],paths:[o.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:r,newSelection:s})},n.prototype._onChangeType=function(e){var t=this.type;if(e!=t){var i=this.editor.getDomSelection();this.changeType(e);var n=this.editor.getDomSelection();this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:t,newType:e,oldSelection:i,newSelection:n})}},n.prototype.sort=function(e,t){if(this._hasChilds()){this.hideChilds();var i=this.childs;this.childs=this.childs.concat();var n="desc"===t?-1:1;"object"===this.type?this.childs.sort(function(e,t){return n*a(e.field,t.field)}):this.childs.sort(function(t,i){var r=t.getNestedChild(e),o=i.getNestedChild(e);if(!r)return n;if(!o)return-n;var s=r.value,l=o.value;return"string"!=typeof s&&"string"!=typeof l?s>l?n:s<l?-n:0:n*a(s,l)}),this._updateDomIndexes(),this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:i,newChilds:this.childs}),this.showChilds()}},n.prototype.update=function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})},n.prototype._detachFromDom=function(){var e,t=this.dom.tr?this.dom.tr.parentNode:void 0;e=this.expanded?this.getAppendDom():this.getDom();var i=e&&e.parentNode?e.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:t,nextTr:i}},n.prototype._attachToDom=function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()},n.prototype.transform=function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),i=this.getValue(),n=s.search(i,e);this.setValue(n);var r=this.getInternalValue();this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:r}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}},n.prototype.getNestedChild=function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i},n.prototype.findChildByProperty=function(e){if("object"===this.type)return this.childs.find(function(t){return t.field===e})},n.prototype.getChildPaths=function(e){var t={};return this._getChildPaths(t,"",e),"array"===this.type&&this.childs.forEach(function(i){i._getChildPaths(t,"",e)}),Object.keys(t).sort()},n.prototype._getChildPaths=function(e,t,i){("auto"===this.type||"string"===this.type||i)&&(e[t||"."]=!0),"object"===this.type&&this.childs.forEach(function(n){n._getChildPaths(e,t+"."+n.field,i)})},n.prototype.getAppendDom=function(){return this.append||(this.append=new v(this.editor),this.append.setParent(this)),this.append.getDom()},n.prototype.getShowMoreDom=function(){return this.showMore||(this.showMore=new y(this.editor,this)),this.showMore.getDom()},n.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},n.targetIsColorPicker=function(e){var t=n.getNodeFromTarget(e);if(t)for(var i=e&&e.parentNode;i;){if(i===t.dom.color)return!0;i=i.parentNode}return!1},n.blurNodes=function(e){if(!Array.isArray(e))return void n.blurNodes([e]);var t=e[0],i=t.parent,r=t.getIndex();i.childs[r+e.length]?i.childs[r+e.length].focus():i.childs[r-1]?i.childs[r-1].focus():i.focus()},n.prototype.nextSibling=function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append},n.prototype._previousNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do{i=i.previousSibling,e=n.getNodeFromTarget(i)}while(i&&e&&e instanceof v&&!e.isVisible())}return e},n.prototype._nextNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do{i=i.nextSibling,e=n.getNodeFromTarget(i)}while(i&&e&&e instanceof v&&!e.isVisible())}return e},n.prototype._firstNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=n.getNodeFromTarget(i)}return e},n.prototype._lastNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=n.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=n.getNodeFromTarget(i)}return e},n.prototype._previousElement=function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}},n.prototype._nextElement=function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}},n.prototype._getElementName=function(e){var t=this.dom;for(var i in t)if(t.hasOwnProperty(i)&&t[i]==e)return i;return null},n.prototype._hasChilds=function(){return"array"==this.type||"object"==this.type},n.TYPE_TITLES={auto:m("autoType"),object:m("objectType"),array:m("arrayType"),string:m("stringType")},n.prototype.addTemplates=function(e,t){var i=this,n=i.editor.options.templates;if(null!=n){n.length&&e.push({type:"separator"});var r=function(e,t){i._onAppend(e,t)},o=function(e,t){i._onInsertBefore(e,t)};n.forEach(function(i){e.push({text:i.text,className:i.className||"jsoneditor-type-object",title:i.title,click:t?r.bind(this,i.field,i.value):o.bind(this,i.field,i.value)})})}},n.prototype.showContextMenu=function(e,t){var i=this,r=n.TYPE_TITLES,o=[];if(this.editable.value&&o.push({text:m("type"),title:m("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:m("auto"),className:"jsoneditor-type-auto"+("auto"==this.type?" jsoneditor-selected":""),title:r.auto,click:function(){i._onChangeType("auto")}},{text:m("array"),className:"jsoneditor-type-array"+("array"==this.type?" jsoneditor-selected":""),title:r.array,click:function(){i._onChangeType("array")}},{text:m("object"),className:"jsoneditor-type-object"+("object"==this.type?" jsoneditor-selected":""),title:r.object,click:function(){i._onChangeType("object")}},{text:m("string"),className:"jsoneditor-type-string"+("string"==this.type?" jsoneditor-selected":""),title:r.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(o.push({text:m("sort"),title:m("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){var e=i.editor.options.modalAnchor||g;u(i,e)}}),o.push({text:m("transform"),title:m("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){var e=i.editor.options.modalAnchor||g;f(i,e)}})),this.parent&&this.parent._hasChilds()){o.length&&o.push({type:"separator"});var s=i.parent.childs;if(i==s[s.length-1]){var a=[{text:m("auto"),className:"jsoneditor-type-auto",title:r.auto,click:function(){i._onAppend("","","auto")}},{text:m("array"),className:"jsoneditor-type-array",title:r.array,click:function(){i._onAppend("",[])}},{text:m("object"),className:"jsoneditor-type-object",title:r.object,click:function(){i._onAppend("",{})}},{text:m("string"),className:"jsoneditor-type-string",title:r.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(a,!0),o.push({text:m("appendText"),title:m("appendTitle"),submenuTitle:m("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:a})}var l=[{text:m("auto"),className:"jsoneditor-type-auto",title:r.auto,click:function(){i._onInsertBefore("","","auto")}},{text:m("array"),className:"jsoneditor-type-array",title:r.array,click:function(){i._onInsertBefore("",[])}},{text:m("object"),className:"jsoneditor-type-object",title:r.object,click:function(){i._onInsertBefore("",{})}},{text:m("string"),className:"jsoneditor-type-string",title:r.string,click:function(){i._onInsertBefore("","","string")}}];i.addTemplates(l,!1),o.push({text:m("insert"),title:m("insertTitle"),submenuTitle:m("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:l}),this.editable.field&&(o.push({text:m("duplicateText"),title:m("duplicateField"),className:"jsoneditor-duplicate",click:function(){n.onDuplicate(i)}}),o.push({text:m("removeText"),title:m("removeField"),className:"jsoneditor-remove",click:function(){n.onRemove(i)}}))}new c(o,{close:t}).show(e,this.editor.frame)},n.prototype._getType=function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof this._stringCast(e)?"string":"auto"},n.prototype._stringCast=function(e){var t=e.toLowerCase(),i=Number(e),n=parseFloat(e);return""==e?"":"null"==t?null:"true"==t||"false"!=t&&(isNaN(i)||isNaN(n)?e:i)},n.prototype._escapeHTML=function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/  /g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=p.escapeUnicodeChars(n)),n},n.prototype._unescapeHTML=function(e){var t='"'+this._escapeJSON(e)+'"';return p.parse(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")},n.prototype._escapeJSON=function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"==n?t+="\\n":"\\"==n?(t+=n,i++,n=e.charAt(i),""!==n&&-1!='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'==n?'\\"':n,i++}return t};var v=h(n),y=d(n);e.exports=n},function(e,t,i){!function(e){"use strict";function t(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function i(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function n(e,r){if(e===r)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(r))return!1;if(!0===t(e)){if(e.length!==r.length)return!1;for(var o=0;o<e.length;o++)if(!1===n(e[o],r[o]))return!1;return!0}if(!0===i(e)){var s={};for(var a in e)if(hasOwnProperty.call(e,a)){if(!1===n(e[a],r[a]))return!1;s[a]=!0}for(var l in r)if(hasOwnProperty.call(r,l)&&!0!==s[l])return!1;return!0}return!1}function r(e){if(""===e||!1===e||null===e)return!0;if(t(e)&&0===e.length)return!0;if(i(e)){for(var n in e)if(e.hasOwnProperty(n))return!1;return!0}return!1}function o(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}function s(e){return e>="a"&&e<="z"||e>="A"&&e<="Z"||"_"===e}function a(e){return e>="0"&&e<="9"||"-"===e}function l(e){return e>="a"&&e<="z"||e>="A"&&e<="Z"||e>="0"&&e<="9"||"_"===e}function c(){}function h(){}function d(e){this.runtime=e}function u(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[v]}]},avg:{_func:this._functionAvg,_signature:[{types:[E]}]},ceil:{_func:this._functionCeil,_signature:[{types:[v]}]},contains:{_func:this._functionContains,_signature:[{types:[w,b]},{types:[y]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[w]},{types:[w]}]},floor:{_func:this._functionFloor,_signature:[{types:[v]}]},length:{_func:this._functionLength,_signature:[{types:[w,b,C]}]},map:{_func:this._functionMap,_signature:[{types:[A]},{types:[b]}]},max:{_func:this._functionMax,_signature:[{types:[E,F]}]},merge:{_func:this._functionMerge,_signature:[{types:[C],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[b]},{types:[A]}]},sum:{_func:this._functionSum,_signature:[{types:[E]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[w]},{types:[w]}]},min:{_func:this._functionMin,_signature:[{types:[E,F]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[b]},{types:[A]}]},type:{_func:this._functionType,_signature:[{types:[y]}]},keys:{_func:this._functionKeys,_signature:[{types:[C]}]},values:{_func:this._functionValues,_signature:[{types:[C]}]},sort:{_func:this._functionSort,_signature:[{types:[F,E]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[b]},{types:[A]}]},join:{_func:this._functionJoin,_signature:[{types:[w]},{types:[F]}]},reverse:{_func:this._functionReverse,_signature:[{types:[w,b]}]},to_array:{_func:this._functionToArray,_signature:[{types:[y]}]},to_string:{_func:this._functionToString,_signature:[{types:[y]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[y]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[y],variadic:!0}]}}}function f(e){return(new h).parse(e)}function p(e){return(new c).tokenize(e)}function m(e,t){var i=new h,n=new u,r=new d(n);n._interpreter=r;var o=i.parse(t);return r.search(o,e)}var g;g="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]};var v=0,y=1,w=2,b=3,C=4,A=6,E=8,F=9,x={".":"Dot","*":"Star",",":"Comma",":":"Colon","{":"Lbrace","}":"Rbrace","]":"Rbracket","(":"Lparen",")":"Rparen","@":"Current"},S={"<":!0,">":!0,"=":!0,"!":!0},_={" ":!0,"\t":!0,"\n":!0};c.prototype={tokenize:function(e){var t=[];this._current=0;for(var i,n,r;this._current<e.length;)if(s(e[this._current]))i=this._current,n=this._consumeUnquotedIdentifier(e),t.push({type:"UnquotedIdentifier",value:n,start:i});else if(void 0!==x[e[this._current]])t.push({type:x[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(a(e[this._current]))r=this._consumeNumber(e),
t.push(r);else if("["===e[this._current])r=this._consumeLBracket(e),t.push(r);else if('"'===e[this._current])i=this._current,n=this._consumeQuotedIdentifier(e),t.push({type:"QuotedIdentifier",value:n,start:i});else if("'"===e[this._current])i=this._current,n=this._consumeRawStringLiteral(e),t.push({type:"Literal",value:n,start:i});else if("`"===e[this._current]){i=this._current;var o=this._consumeLiteral(e);t.push({type:"Literal",value:o,start:i})}else if(void 0!==S[e[this._current]])t.push(this._consumeOperator(e));else if(void 0!==_[e[this._current]])this._current++;else if("&"===e[this._current])i=this._current,this._current++,"&"===e[this._current]?(this._current++,t.push({type:"And",value:"&&",start:i})):t.push({type:"Expref",value:"&",start:i});else{if("|"!==e[this._current]){var l=new Error("Unknown character:"+e[this._current]);throw l.name="LexerError",l}i=this._current,this._current++,"|"===e[this._current]?(this._current++,t.push({type:"Or",value:"||",start:i})):t.push({type:"Pipe",value:"|",start:i})}return t},_consumeUnquotedIdentifier:function(e){var t=this._current;for(this._current++;this._current<e.length&&l(e[this._current]);)this._current++;return e.slice(t,this._current)},_consumeQuotedIdentifier:function(e){var t=this._current;this._current++;for(var i=e.length;'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){var t=this._current;this._current++;for(var i=e.length;"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){var t=this._current;this._current++;for(var i=e.length;a(e[this._current])&&this._current<i;)this._current++;return{type:"Number",value:parseInt(e.slice(t,this._current)),start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:"Filter",value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:"Flatten",value:"[]",start:t}):{type:"Lbracket",value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:"LTE",value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:"GTE",value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t,i=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var r=this._current;"\\"!==e[r]||"\\"!==e[r+1]&&"`"!==e[r+1]?r++:r+=2,this._current=r}var o=g(e.slice(i,this._current));return o=o.replace("\\`","`"),t=this._looksLikeJSON(o)?JSON.parse(o):JSON.parse('"'+o+'"'),this._current++,t},_looksLikeJSON:function(e){var t='[{"',i=["true","false","null"],n="-0123456789";if(""===e)return!1;if(t.indexOf(e[0])>=0)return!0;if(i.indexOf(e)>=0)return!0;if(!(n.indexOf(e[0])>=0))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var k={};k.EOF=0,k.UnquotedIdentifier=0,k.QuotedIdentifier=0,k.Rbracket=0,k.Rparen=0,k.Comma=0,k.Rbrace=0,k.Number=0,k.Current=0,k.Expref=0,k.Pipe=1,k.Or=2,k.And=3,k.EQ=5,k.GT=5,k.LT=5,k.GTE=5,k.LTE=5,k.NE=5,k.Flatten=9,k.Star=20,k.Filter=21,k.Dot=40,k.Not=45,k.Lbrace=50,k.Lbracket=55,k.Lparen=60,h.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t=this.expression(0);if("EOF"!==this._lookahead(0)){var i=this._lookaheadToken(0),n=new Error("Unexpected token type: "+i.type+", value: "+i.value);throw n.name="ParserError",n}return t},_loadTokens:function(e){var t=new c,i=t.tokenize(e);i.push({type:"EOF",value:"",start:e.length}),this.tokens=i},expression:function(e){var t=this._lookaheadToken(0);this._advance();for(var i=this.nud(t),n=this._lookahead(0);e<k[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i,n;switch(e.type){case"Literal":return{type:"Literal",value:e.value};case"UnquotedIdentifier":return{type:"Field",name:e.value};case"QuotedIdentifier":var r={type:"Field",name:e.value};if("Lparen"===this._lookahead(0))throw new Error("Quoted identifier not allowed for function names.");return r;case"Not":return i=this.expression(k.Not),{type:"NotExpression",children:[i]};case"Star":return t={type:"Identity"},i=null,i="Rbracket"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(k.Star),{type:"ValueProjection",children:[t,i]};case"Filter":return this.led(e.type,{type:"Identity"});case"Lbrace":return this._parseMultiselectHash();case"Flatten":return t={type:"Flatten",children:[{type:"Identity"}]},i=this._parseProjectionRHS(k.Flatten),{type:"Projection",children:[t,i]};case"Lbracket":return"Number"===this._lookahead(0)||"Colon"===this._lookahead(0)?(i=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},i)):"Star"===this._lookahead(0)&&"Rbracket"===this._lookahead(1)?(this._advance(),this._advance(),i=this._parseProjectionRHS(k.Star),{type:"Projection",children:[{type:"Identity"},i]}):this._parseMultiselectList();case"Current":return{type:"Current"};case"Expref":return n=this.expression(k.Expref),{type:"ExpressionReference",children:[n]};case"Lparen":for(var o=[];"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(n={type:"Current"},this._advance()):n=this.expression(0),o.push(n);return this._match("Rparen"),o[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case"Dot":var n=k.Dot;return"Star"!==this._lookahead(0)?(i=this._parseDotRHS(n),{type:"Subexpression",children:[t,i]}):(this._advance(),i=this._parseProjectionRHS(n),{type:"ValueProjection",children:[t,i]});case"Pipe":return i=this.expression(k.Pipe),{type:"Pipe",children:[t,i]};case"Or":return i=this.expression(k.Or),{type:"OrExpression",children:[t,i]};case"And":return i=this.expression(k.And),{type:"AndExpression",children:[t,i]};case"Lparen":for(var r,o=t.name,s=[];"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(r={type:"Current"},this._advance()):r=this.expression(0),"Comma"===this._lookahead(0)&&this._match("Comma"),s.push(r);return this._match("Rparen"),{type:"Function",name:o,children:s};case"Filter":var a=this.expression(0);return this._match("Rbracket"),i="Flatten"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(k.Filter),{type:"FilterProjection",children:[t,i,a]};case"Flatten":return{type:"Projection",children:[{type:"Flatten",children:[t]},this._parseProjectionRHS(k.Flatten)]};case"EQ":case"NE":case"GT":case"GTE":case"LT":case"LTE":return this._parseComparator(t,e);case"Lbracket":var l=this._lookaheadToken(0);return"Number"===l.type||"Colon"===l.type?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match("Star"),this._match("Rbracket"),i=this._parseProjectionRHS(k.Star),{type:"Projection",children:[t,i]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){if(this._lookahead(0)!==e){var t=this._lookaheadToken(0),i=new Error("Expected "+e+", got: "+t.type);throw i.name="ParserError",i}this._advance()},_errorToken:function(e){var t=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw t.name="ParserError",t},_parseIndexExpression:function(){if("Colon"===this._lookahead(0)||"Colon"===this._lookahead(1))return this._parseSliceExpression();var e={type:"Index",value:this._lookaheadToken(0).value};return this._advance(),this._match("Rbracket"),e},_projectIfSlice:function(e,t){var i={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[i,this._parseProjectionRHS(k.Star)]}:i},_parseSliceExpression:function(){for(var e=[null,null,null],t=0,i=this._lookahead(0);"Rbracket"!==i&&t<3;){if("Colon"===i)t++,this._advance();else{if("Number"!==i){var n=this._lookahead(0),r=new Error("Syntax error, unexpected token: "+n.value+"("+n.type+")");throw r.name="Parsererror",r}e[t]=this._lookaheadToken(0).value,this._advance()}i=this._lookahead(0)}return this._match("Rbracket"),{type:"Slice",children:e}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(k[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return["UnquotedIdentifier","QuotedIdentifier","Star"].indexOf(t)>=0?this.expression(e):"Lbracket"===t?(this._match("Lbracket"),this._parseMultiselectList()):"Lbrace"===t?(this._match("Lbrace"),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t;if(k[this._lookahead(0)]<10)t={type:"Identity"};else if("Lbracket"===this._lookahead(0))t=this.expression(e);else if("Filter"===this._lookahead(0))t=this.expression(e);else{if("Dot"!==this._lookahead(0)){var i=this._lookaheadToken(0),n=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")");throw n.name="ParserError",n}this._match("Dot"),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];"Rbracket"!==this._lookahead(0);){var t=this.expression(0);if(e.push(t),"Comma"===this._lookahead(0)&&(this._match("Comma"),"Rbracket"===this._lookahead(0)))throw new Error("Unexpected token Rbracket")}return this._match("Rbracket"),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i,n,r=[],o=["UnquotedIdentifier","QuotedIdentifier"];;){if(e=this._lookaheadToken(0),o.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(t=e.value,this._advance(),this._match("Colon"),i=this.expression(0),n={type:"KeyValuePair",name:t,value:i},r.push(n),"Comma"===this._lookahead(0))this._match("Comma");else if("Rbrace"===this._lookahead(0)){this._match("Rbrace");break}}return{type:"MultiSelectHash",children:r}}},d.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,s){var a,l,c,h,d,u,f,p,m;switch(e.type){case"Field":return null===s?null:i(s)?(u=s[e.name],void 0===u?null:u):null;case"Subexpression":for(c=this.visit(e.children[0],s),m=1;m<e.children.length;m++)if(null===(c=this.visit(e.children[1],c)))return null;return c;case"IndexExpression":return f=this.visit(e.children[0],s),this.visit(e.children[1],f);case"Index":if(!t(s))return null;var g=e.value;return g<0&&(g=s.length+g),c=s[g],void 0===c&&(c=null),c;case"Slice":if(!t(s))return null;var v=e.children.slice(0),y=this.computeSliceParams(s.length,v),w=y[0],b=y[1],C=y[2];if(c=[],C>0)for(m=w;m<b;m+=C)c.push(s[m]);else for(m=w;m>b;m+=C)c.push(s[m]);return c;case"Projection":var A=this.visit(e.children[0],s);if(!t(A))return null;for(p=[],m=0;m<A.length;m++)null!==(l=this.visit(e.children[1],A[m]))&&p.push(l);return p;case"ValueProjection":if(A=this.visit(e.children[0],s),!i(A))return null;p=[];var E=o(A);for(m=0;m<E.length;m++)null!==(l=this.visit(e.children[1],E[m]))&&p.push(l);return p;case"FilterProjection":if(A=this.visit(e.children[0],s),!t(A))return null;var F=[],x=[];for(m=0;m<A.length;m++)a=this.visit(e.children[2],A[m]),r(a)||F.push(A[m]);for(var S=0;S<F.length;S++)null!==(l=this.visit(e.children[1],F[S]))&&x.push(l);return x;case"Comparator":switch(h=this.visit(e.children[0],s),d=this.visit(e.children[1],s),e.name){case"EQ":c=n(h,d);break;case"NE":c=!n(h,d);break;case"GT":c=h>d;break;case"GTE":c=h>=d;break;case"LT":c=h<d;break;case"LTE":c=h<=d;break;default:throw new Error("Unknown comparator: "+e.name)}return c;case"Flatten":var _=this.visit(e.children[0],s);if(!t(_))return null;var k=[];for(m=0;m<_.length;m++)l=_[m],t(l)?k.push.apply(k,l):k.push(l);return k;case"Identity":return s;case"MultiSelectList":if(null===s)return null;for(p=[],m=0;m<e.children.length;m++)p.push(this.visit(e.children[m],s));return p;case"MultiSelectHash":if(null===s)return null;p={};var D;for(m=0;m<e.children.length;m++)D=e.children[m],p[D.name]=this.visit(D.value,s);return p;case"OrExpression":return a=this.visit(e.children[0],s),r(a)&&(a=this.visit(e.children[1],s)),a;case"AndExpression":return h=this.visit(e.children[0],s),!0===r(h)?h:this.visit(e.children[1],s);case"NotExpression":return h=this.visit(e.children[0],s),r(h);case"Literal":return e.value;case"Pipe":return f=this.visit(e.children[0],s),this.visit(e.children[1],f);case"Current":return s;case"Function":var $=[];for(m=0;m<e.children.length;m++)$.push(this.visit(e.children[m],s));return this.runtime.callFunction(e.name,$);case"ExpressionReference":var B=e.children[0];return B.jmespathType="Expref",B;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],r=t[2],o=[null,null,null];if(null===r)r=1;else if(0===r){var s=new Error("Invalid slice, step cannot be 0");throw s.name="RuntimeError",s}var a=r<0;return i=null===i?a?e-1:0:this.capSliceRange(e,i,r),n=null===n?a?-1:e:this.capSliceRange(e,n,r),o[0]=i,o[1]=n,o[2]=r,o},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):t>=e&&(t=i<0?e-1:e),t}},u.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var r,o,s,a=0;a<i.length;a++){s=!1,r=i[a].types,o=this._getTypeName(t[a]);for(var l=0;l<r.length;l++)if(this._typeMatches(o,r[l],t[a])){s=!0;break}if(!s)throw new Error("TypeError: "+e+"() expected argument "+(a+1)+" to be type "+r+" but received type "+o+" instead.")}},_typeMatches:function(e,t,i){if(t===y)return!0;if(t!==F&&t!==E&&t!==b)return e===t;if(t===b)return e===b;if(e===b){var n;t===E?n=v:t===F&&(n=w);for(var r=0;r<i.length;r++)if(!this._typeMatches(this._getTypeName(i[r]),n,i[r]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return w;case"[object Number]":return v;case"[object Array]":return b;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return"Expref"===e.jmespathType?A:C}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],i=e[1];return-1!==t.indexOf(i,t.length-i.length)},_functionReverse:function(e){if(this._getTypeName(e[0])===w){for(var t=e[0],i="",n=t.length-1;n>=0;n--)i+=t[n];return i}var r=e[0].slice(0);return r.reverse(),r},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return e[0].indexOf(e[1])>=0},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return i(e[0])?Object.keys(e[0]).length:e[0].length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],r=e[1],o=0;o<r.length;o++)t.push(i.visit(n,r[o]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n=e[i];for(var r in n)t[r]=n[r]}return t},_functionMax:function(e){if(e[0].length>0){if(this._getTypeName(e[0][0])===v)return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(e[0].length>0){if(this._getTypeName(e[0][0])===v)return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case v:return"number";case w:return"string";case b:return"array";case C:return"object";case 5:return"boolean";case A:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],r=0;r<i.length;r++)n.push(t[i[r]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return this._getTypeName(e[0])===b?e[0]:[e[0]]},_functionToString:function(e){return this._getTypeName(e[0])===w?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return i===v?e[0]:i!==w||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){var t=e[0].slice(0);return t.sort(),t},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var i=this._interpreter,n=e[1],r=this._getTypeName(i.visit(n,t[0]));if([v,w].indexOf(r)<0)throw new Error("TypeError");for(var o=this,s=[],a=0;a<t.length;a++)s.push([a,t[a]]);s.sort(function(e,t){var s=i.visit(n,e[1]),a=i.visit(n,t[1]);if(o._getTypeName(s)!==r)throw new Error("TypeError: expected "+r+", received "+o._getTypeName(s));if(o._getTypeName(a)!==r)throw new Error("TypeError: expected "+r+", received "+o._getTypeName(a));return s>a?1:s<a?-1:e[0]-t[0]});for(var l=0;l<s.length;l++)t[l]=s[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[v,w]),s=-1/0,a=0;a<r.length;a++)(i=o(r[a]))>s&&(s=i,t=r[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[v,w]),s=1/0,a=0;a<r.length;a++)(i=o(r[a]))<s&&(s=i,t=r[a]);return t},createKeyFunction:function(e,t){var i=this,n=this._interpreter;return function(r){var o=n.visit(e,r);if(t.indexOf(i._getTypeName(o))<0){var s="TypeError: expected one of "+t+", received "+i._getTypeName(o);throw new Error(s)}return o}}},e.tokenize=p,e.compile=f,e.search=m,e.strictDeepEqual=n}(t)},function(e,t){e.exports=function e(t,i){"use strict";var n,r,o=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,s=/(^[ ]*|[ ]*$)/g,a=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,l=/^0x[0-9a-f]+$/i,c=function(t){return e.insensitive&&(""+t).toLowerCase()||""+t},h=c(t).replace(s,"")||"",d=c(i).replace(s,"")||"",u=h.replace(o,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),f=d.replace(o,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=parseInt(h.match(l),16)||1!==u.length&&h.match(a)&&Date.parse(h),m=parseInt(d.match(l),16)||p&&d.match(a)&&Date.parse(d)||null;if(m){if(p<m)return-1;if(p>m)return 1}for(var g=0,v=Math.max(u.length,f.length);g<v;g++){if(n=!(u[g]||"").match(/^0/)&&parseFloat(u[g])||u[g]||0,r=!(f[g]||"").match(/^0/)&&parseFloat(f[g])||f[g]||0,isNaN(n)!==isNaN(r))return isNaN(n)?1:-1;if(typeof n!=typeof r&&(n+="",r+=""),n<r)return-1;if(n>r)return 1}return 0}},function(e,t,i){"use strict";function n(e){function t(e){this.editor=e,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.type="button",n.className="jsoneditor-button jsoneditor-contextmenu",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var r=document.createElement("td"),o=document.createElement("div");return o.innerHTML="("+s("empty")+")",o.className="jsoneditor-readonly",r.appendChild(o),e.td=r,e.text=o,this.updateDom(),t},t.prototype.getPath=function(){return null},t.prototype.getIndex=function(){return null},t.prototype.updateDom=function(e){var t=this.dom,i=t.td;i&&(i.style.paddingLeft=24*this.getLevel()+26+"px");var n=t.text;n&&(n.innerHTML="("+s("empty")+" "+this.parent.type+")");var r=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&r.appendChild(t.tdDrag),t.tdMenu&&r.appendChild(t.tdMenu),r.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&r.removeChild(t.tdDrag),t.tdMenu&&r.removeChild(t.tdMenu),r.removeChild(i))},t.prototype.isVisible=function(){return 0==this.parent.childs.length},t.prototype.showContextMenu=function(t,i){var n=this,r=e.TYPE_TITLES,a=[{text:s("auto"),className:"jsoneditor-type-auto",title:r.auto,click:function(){n._onAppend("","","auto")}},{text:s("array"),className:"jsoneditor-type-array",title:r.array,click:function(){n._onAppend("",[])}},{text:s("object"),className:"jsoneditor-type-object",title:r.object,click:function(){n._onAppend("",{})}},{text:s("string"),className:"jsoneditor-type-string",title:r.string,click:function(){n._onAppend("","","string")}}];n.addTemplates(a,!0);var l=[{text:s("appendText"),title:s("appendTitleAuto"),submenuTitle:s("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){n._onAppend("","","auto")},submenu:a}];new o(l,{close:i}).show(t,this.editor.content)},t.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom;if(i==n.menu&&("mouseover"==t?this.editor.highlighter.highlight(this.parent):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var o=this.editor.highlighter;o.highlight(this.parent),o.lock(),r.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){r.removeClassName(n.menu,"jsoneditor-selected"),o.unlock(),o.unhighlight()})}"keydown"==t&&this.onKeyDown(e)},t}var r=i(65),o=i(63),s=i(68).translate;e.exports=n},function(e,t,i){"use strict";function n(e){function t(e,t){this.editor=e,this.parent=t,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){if(this.dom.tr)return this.dom.tr;if(this._updateEditability(),!this.dom.tr){var e=this,t=this.parent,i=document.createElement("a");i.appendChild(document.createTextNode(r("showMore"))),i.href="#",i.onclick=function(i){return t.visibleChilds=Math.floor(t.visibleChilds/t.MAX_VISIBLE_CHILDS+1)*t.MAX_VISIBLE_CHILDS,e.updateDom(),t.showChilds(),i.preventDefault(),!1};var n=document.createElement("a");n.appendChild(document.createTextNode(r("showAll"))),n.href="#",n.onclick=function(i){return t.visibleChilds=1/0,e.updateDom(),t.showChilds(),i.preventDefault(),!1};var o=document.createElement("div"),s=document.createTextNode(this._getShowMoreText());o.className="jsoneditor-show-more",o.appendChild(s),o.appendChild(i),o.appendChild(document.createTextNode(". ")),o.appendChild(n),o.appendChild(document.createTextNode(". "));var a=document.createElement("td");a.appendChild(o);var l=document.createElement("tr");"tree"===this.editor.options.mode&&(l.appendChild(document.createElement("td")),l.appendChild(document.createElement("td"))),l.appendChild(a),l.className="jsoneditor-show-more",this.dom.tr=l,this.dom.moreContents=o,this.dom.moreText=s}return this.updateDom(),this.dom.tr},t.prototype.updateDom=function(e){if(this.isVisible()){if(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],!this.dom.tr.parentNode){var t=this.parent._getNextTr();t&&t.parentNode.insertBefore(this.dom.tr,t)}this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"}else this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},t.prototype._getShowMoreText=function(){return r("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},t.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},t.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},t}var r=i(68).translate;e.exports=n},function(e,t,i){function n(e,t){var i='<div class="pico-modal-contents"><div class="pico-modal-header">'+o("sort")+"</div><form><table><tbody><tr>  <td>"+o("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+o("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+o("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+o("sortAscending")+'" title="'+o("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+o("sortDescending")+'" title="'+o("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+o("ok")+'" /></td></tr></tbody></table></form></div>';r({parent:t,content:i,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){function i(e){s.value=e,s.className="jsoneditor-button-group jsoneditor-button-group-value-"+s.value}var n=t.modalElem().querySelector("form"),r=t.modalElem().querySelector("#ok"),o=t.modalElem().querySelector("#field"),s=t.modalElem().querySelector("#direction"),a="array"===e.type?e.getChildPaths():["."];a.forEach(function(e){var t=document.createElement("option");t.text=e,t.value=e,o.appendChild(t)}),o.value=e.sortedBy?e.sortedBy.path:a[0],i(e.sortedBy?e.sortedBy.direction:"asc"),s.onclick=function(e){i(e.target.getAttribute("data-value"))},r.onclick=function(i){i.preventDefault(),i.stopPropagation(),t.close();var n=o.value,r="."===n?[]:n.split(".").slice(1);e.sortedBy={path:n,direction:s.value},e.sort(r,s.value)},n&&(n.onsubmit=r.onclick)}).afterClose(function(e){e.destroy()}).show()}var r=i(76),o=i(68).translate;e.exports=n},function(e,t,i){var n,r,o;!function(i,s){"use strict";r=[],n=s,void 0!==(o="function"==typeof n?n.apply(t,r):n)&&(e.exports=o)}(0,function(){"use strict";function e(e){return"object"==typeof Node?e instanceof Node:e&&"object"==typeof e&&"number"==typeof e.nodeType}function t(e){return"string"==typeof e}function i(){var e=[];return{watch:e.push.bind(e),trigger:function(t,i){for(var n=!0,r={detail:i,preventDefault:function(){n=!1}},o=0;o<e.length;o++)e[o](t,r);return n}}}function n(e){return"none"===window.getComputedStyle(e).display}function r(e){this.elem=e}function o(e,t){return r.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}function s(e,t){var i=e("width","auto");"number"==typeof i&&(i+="px");var n=e("modalId","pico-"+d++);return r.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new r(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function a(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function l(e){return function(){return e().elem}}function c(e,t){function i(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function r(e){return!(n(e)||i(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||i(e,"input,select,textarea,button,a[href],area[href],iframe"))}function o(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(r(t[i]))return t[i]}function s(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(r(t[i]))return t[i]}var a;e.beforeShow(function(){a=document.activeElement}),e.afterShow(function(){if(t()){var i=o(e.modalElem());i&&i.focus()}}),e.afterClose(function(){t()&&a&&a.focus(),a=null}),f.watch(function(i){if(t()&&e.isVisible()){var n=o(e.modalElem()),r=s(e.modalElem());(i.shiftKey?n:r)===document.activeElement&&((i.shiftKey?r:n).focus(),i.preventDefault())}})}function h(e,t){var i,n=new r(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}r.make=function(e,t){"string"==typeof e&&(e=document.querySelector(e));var i=document.createElement(t||"div");return(e||document.body).appendChild(i),new r(i)},r.prototype={child:function(e){return r.make(this.elem,e)},stylize:function(e){e=e||{},void 0!==e.opacity&&(e.filter="alpha(opacity="+100*e.opacity+")");for(var t in e)e.hasOwnProperty(t)&&(this.elem.style[t]=e[t]);return this},clazz:function(e){return this.elem.className+=" "+e,this},html:function(t){return e(t)?this.elem.appendChild(t):this.elem.innerHTML=t,this},onClick:function(e){return this.elem.addEventListener("click",e),this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){return void 0!==t&&this.elem.setAttribute(e,t),this},anyAncestor:function(e){for(var t=this.elem;t;){if(e(new r(t)))return!0;t=t.parentNode}return!1},isVisible:function(){return!n(this.elem)}};var d=1,u=i(),f=i();return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?u.trigger():9===t&&f.trigger(e)}),function(n){function r(e,t){var i=n[e];return"function"==typeof i&&(i=i(t)),void 0===i?t:i}function d(e){F().hide(),E().hide(),A.trigger(g,e)}function f(e){C.trigger(g,e)&&d(e)}function p(e){return function(){return e.apply(this,arguments),g}}function m(e,t){if(!v){var i=s(r,f);v={modal:i,overlay:o(r,f),close:a(i,r)},y.trigger(g,t)}return v[e]}(t(n)||e(n))&&(n={content:n});var g,v,y=i(),w=i(),b=i(),C=i(),A=i(),E=m.bind(window,"modal"),F=m.bind(window,"overlay"),x=m.bind(window,"close");return g={modalElem:l(E),closeElem:l(x),overlayElem:l(F),buildDom:p(m.bind(null,null)),isVisible:function(){return!!(v&&E&&E().isVisible())},show:function(e){return w.trigger(g,e)&&(F().show(),x(),E().show(),b.trigger(g,e)),this},close:p(f),forceClose:p(d),destroy:function(){E().destroy(),F().destroy(),F=E=x=void 0},options:function(e){Object.keys(e).map(function(t){n[t]=e[t]})},afterCreate:p(y.watch),beforeShow:p(w.watch),afterShow:p(b.watch),beforeClose:p(C.watch),afterClose:p(A.watch)},c(g,r.bind(null,"focus",!0)),h(g,r.bind(null,"bodyOverflow",!0)),u.watch(function(){r("escCloses",!0)&&g.isVisible()&&g.close()}),g}})},function(e,t,i){function n(e,t){var i=e.getValue(),n='<label class="pico-modal-contents"><div class="pico-modal-header">'+a("transform")+'</div><p>Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.</p><table><tbody><tr>  <th>'+a("transformWizardLabel")+' </th>  <td>  <div id="wizard" class="jsoneditor-jmespath-wizard">  <div>    <div class="jsoneditor-jmespath-wizard-label">'+a("transformWizardFilter")+'</div>    <div class="jsoneditor-jmespath-filter">      <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >        <select id="filterField">        </select>      </div>      <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >        <select id="filterRelation">          <option value="==">==</option>          <option value="!=">!=</option>          <option value="<">&lt;</option>          <option value="<=">&lt;=</option>          <option value=">">&gt;</option>          <option value=">=">&gt;=</option>        </select>      </div>      <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >        <input placeholder="value..." id="filterValue" />      </div>    </div>  </div>  <div>    <div class="jsoneditor-jmespath-wizard-label">'+a("transformWizardSortBy")+'</div>    <div class="jsoneditor-jmespath-filter">      <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">        <select id="sortField">        </select>      </div>      <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >        <select id="sortOrder">          <option value="asc">Ascending</option>          <option value="desc">Descending</option>        </select>      </div>    </div>  </div>  <div id="selectFieldsPart">    <div class="jsoneditor-jmespath-wizard-label">'+a("transformWizardSelectFields")+'</div>    <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple>    </select>  </div>  </div>  </td></tr><tr>  <th>'+a("transformQueryLabel")+' </th>  <td class="jsoneditor-modal-input">    <textarea id="query"               rows="4"               autocomplete="off"               autocorrect="off"               autocapitalize="off"               spellcheck="false"              title="'+a("transformQueryTitle")+'">[*]</textarea>  </td></tr><tr>  <th>'+a("transformPreviewLabel")+' </th>  <td class="jsoneditor-modal-input">    <textarea id="preview"         class="jsoneditor-transform-preview"        readonly> </textarea>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+a("ok")+'" autofocus /></td></tr></tbody></table></div>';o({parent:t,content:n,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){function n(e){return"."===e[0]?"."===e?"@":e.slice(1):e}function o(){if(f.value&&p.value&&m.value){var t=f.value,i=JSON.stringify(e._stringCast(m.value));w.value="[? "+t+" "+p.value+" `"+i+"`]"}else w.value="[*]";if(g.value&&v.value){var n=g.value;"desc"===v.value?w.value+=" | reverse(sort_by(@, &"+n+"))":w.value+=" | sort_by(@, &"+n+")"}if(y.value){for(var r=[],o=0;o<y.options.length;o++)if(y.options[o].selected){var s=y.options[o].value;r.push(s)}"]"!==w.value[w.value.length-1]&&(w.value+=" | [*]"),1===r.length?w.value+="."+s:r.length>1&&(w.value+=".{"+r.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")}_()}function a(){try{var e=r.search(i,w.value),t=JSON.stringify(e,null,2).split("\n");t.length>c&&(t=t.slice(0,c).concat(["..."])),b.className="jsoneditor-transform-preview",b.value=t.join("\n"),u.disabled=!1}catch(e){b.className="jsoneditor-transform-preview jsoneditor-error",b.value=e.toString(),u.disabled=!0}}var h=t.modalElem(),d=h.querySelector("#wizard"),u=h.querySelector("#ok"),f=h.querySelector("#filterField"),p=h.querySelector("#filterRelation"),m=h.querySelector("#filterValue"),g=h.querySelector("#sortField"),v=h.querySelector("#sortOrder"),y=h.querySelector("#selectFields"),w=h.querySelector("#query"),b=h.querySelector("#preview");Array.isArray(i)||(d.style.display="none",d.parentNode.style.fontStyle="italic",d.parentNode.appendChild(document.createTextNode("(wizard not available for objects, only for arrays)"))),e.getChildPaths().forEach(function(e){var t=n(e),i=document.createElement("option");i.text=t,i.value=t,f.appendChild(i);var r=document.createElement("option");r.text=t,r.value=t,g.appendChild(r)});var C=e.getChildPaths(!0).filter(function(e){return"."!==e});C.length>0?C.forEach(function(e){var t=n(e),i=document.createElement("option");i.text=t,i.value=t,y.appendChild(i)}):h.querySelector("#selectFieldsPart").style.display="none";var A=new s(f,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),E=new s(p,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),F=new s(g,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),x=new s(v,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),S=new s(y,{multiple:!0,clearable:!0,defaultSelected:!1});A.on("selectr.change",o),E.on("selectr.change",o),m.oninput=o,F.on("selectr.change",o),x.on("selectr.change",o),S.on("selectr.change",o),h.querySelector(".pico-modal-contents").onclick=function(e){e.preventDefault()},w.value=Array.isArray(i)?"[*]":"@";var _=l(a,300);w.oninput=_,_(),u.onclick=function(i){i.preventDefault(),i.stopPropagation(),t.close(),e.transform(w.value)},setTimeout(function(){w.select(),w.focus(),w.selectionStart=3,w.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}var r=i(71),o=i(76),s=i(78),a=i(68).translate,l=i(65).debounce,c=100;e.exports=n},function(e,t){"use strict";function i(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function n(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),s.removeClass(e,"excluded"),i||(e.innerHTML=e.textContent)}var r={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."},o=function(){};o.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},o.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=o.prototype[t[i]]:e[t[i]]=o.prototype[t[i]];return e};var s={extend:function(e,t){t=t||{};var i;for(i in e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var r=0,o=e.length;r<o;r++)t.call(i,r,e[r],e)},createElement:function(e,t){var i=document,n=i.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t)){var r;for(r in t)if(r in n)n[r]=t[r];else if("html"===r)n.innerHTML=t[r];else if("text"===r){var o=i.createTextNode(t[r]);n.appendChild(o)}else n.setAttribute(r,t[r])}return n},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){s.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){s.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:s.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(e,t,i){var n;return function(){var r=this,o=arguments,s=function(){n=null,i||e.apply(r,o)},a=i&&!n;clearTimeout(n),n=setTimeout(s,t),a&&e.apply(r,o)}},rect:function(e,t){var i=window,n=e.getBoundingClientRect(),r=t?i.pageXOffset:0,o=t?i.pageYOffset:0;return{bottom:n.bottom+o,height:n.height,left:n.left+r,right:n.right+r,top:n.top+o,width:n.width}},includes:function(e,t){return e.indexOf(t)>-1},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}},a=function(){if(this.items.length){var e=document.createDocumentFragment();if(this.config.pagination){var t=this.pages.slice(0,this.pageIndex);s.each(t,function(t,i){s.each(i,function(t,i){n(i,e,this.customOption)},this)},this)}else s.each(this.items,function(t,i){n(i,e,this.customOption)},this);e.childElementCount&&(s.removeClass(this.items[this.navIndex],"active"),this.navIndex=e.querySelector(".selectr-option").idx,s.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(e)}},l=function(e){var t=e.target;this.container.contains(t)||!this.opened&&!s.hasClass(this.container,"notice")||this.close()},c=function(e,t){t=t||e;var i=this.customOption?this.config.renderOption(t):e.textContent,n=s.createElement("li",{class:"selectr-option",html:i,role:"treeitem","aria-selected":!1});return n.idx=e.idx,this.items.push(n),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(n.disabled=!0,s.addClass(n,"disabled")),n},h=function(){this.requiresPagination=this.config.pagination&&this.config.pagination>0,i(this.config,"width")&&(s.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":s.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=s.createElement("div",{class:"selectr-container"}),this.config.customClass&&s.addClass(this.container,this.config.customClass),this.mobileDevice?s.addClass(this.container,"selectr-mobile"):s.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?s.addClass(this.el,"selectr-visible"):s.addClass(this.el,"selectr-hidden"),this.selected=s.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=s.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=s.createElement("div",{class:"selectr-options-container"});if(this.tree=s.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=s.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(s.addClass(this.label,"selectr-tags"),s.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=s.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),s.addClass(this.container,"clearable")),this.config.taggable){var t=s.createElement("li",{class:"input-tag"});this.input=s.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),s.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=s.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=s.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=s.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var n=!1,r=0;if(this.el.children.length&&s.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(n=s.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),s.each(t.children,function(e,t){t.idx=r,n.appendChild(c.call(this,t,n)),r++},this)):(t.idx=r,c.call(this,t),r++)},this),this.config.data&&Array.isArray(this.config.data)){this.data=[];var o,a=!1;n=!1,r=0,s.each(this.config.data,function(e,t){i(t,"children")?(a=s.createElement("optgroup",{label:t.text}),n=s.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),s.each(t.children,function(e,t){o=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected),o.disabled=i(t,"disabled"),this.options.push(o),a.appendChild(o),o.idx=r,n.appendChild(c.call(this,o,t)),this.data[r]=t,r++},this)):(o=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected),o.disabled=i(t,"disabled"),this.options.push(o),o.idx=r,c.call(this,o,t),this.data[r]=t,r++)},this)}this.setSelected(!0);var l;this.navIndex=0;for(var h=0;h<this.items.length;h++)if(l=this.items[h],!s.hasClass(l,"disabled")){s.addClass(l,"active"),this.navIndex=h;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=s.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)},d=function(e){if(e=e||window.event,!this.items.length||!this.opened||!s.includes([13,38,40],e.which))return void(this.navigating=!1);if(e.preventDefault(),13===e.which)return!(this.config.taggable&&this.input.value.length>0)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:t=0,this.navIndex>0&&this.navIndex--;break;case 40:t=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;s.hasClass(this.items[this.navIndex],"disabled")||s.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}var n=s.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:n.top+n.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(n.top+n.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&p.call(this)):0===this.navIndex?this.tree.scrollTop=0:n.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(n.top-this.optsRect.top)),i&&s.removeClass(i,"active"),s.addClass(this.items[this.navIndex],"active")},u=function(e){var t,i=this,n=document.createDocumentFragment(),r=this.options[e.idx],o=this.data?this.data[e.idx]:r,a=this.customSelected?this.config.renderSelection(o):r.textContent,l=s.createElement("li",{class:"selectr-tag",html:a}),c=s.createElement("button",{class:"selectr-tag-remove",type:"button"});if(l.appendChild(c),l.idx=e.idx,l.tag=r.value,this.tags.push(l),this.config.sortSelected){var h=this.tags.slice();t=function(e,t){e.replace(/(\d+)|(\D+)/g,function(e,i,n){t.push([i||1/0,n||""])})},h.sort(function(e,n){var r,o,s=[],a=[];for(!0===i.config.sortSelected?(r=e.tag,o=n.tag):"text"===i.config.sortSelected&&(r=e.textContent,o=n.textContent),t(r,s),t(o,a);s.length&&a.length;){var l=s.shift(),c=a.shift(),h=l[0]-c[0]||l[1].localeCompare(c[1]);if(h)return h}return s.length-a.length}),s.each(h,function(e,t){n.appendChild(t)}),this.label.innerHTML=""}else n.appendChild(l);this.config.taggable?this.label.insertBefore(n,this.input.parentNode):this.label.appendChild(n)},f=function(e){var t=!1;s.each(this.tags,function(i,n){n.idx===e.idx&&(t=n)},this),t&&(this.label.removeChild(t),this.tags.splice(this.tags.indexOf(t),1))},p=function(){var e=this.tree;if(e.scrollTop>=e.scrollHeight-e.offsetHeight&&this.pageIndex<this.pages.length){var t=document.createDocumentFragment();s.each(this.pages[this.pageIndex],function(e,i){n(i,t,this.customOption)},this),e.appendChild(t),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}},m=function(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&s.removeClass(this.inputContainer,"active"),s.hasClass(this.container,"notice")&&(s.removeClass(this.container,"notice"),s.addClass(this.container,"open"),this.input.focus()),s.each(this.items,function(e,t){s.removeClass(t,"excluded"),this.customOption||(t.innerHTML=t.textContent)},this))},g=function(e,t){var i=new RegExp(e,"i").exec(t.textContent);return!!i&&t.textContent.replace(i[0],"<span class='selectr-match'>"+i[0]+"</span>")},v=function(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if(this.el=e,"string"==typeof e&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)};v.prototype.render=function(e){if(!this.rendered){this.config=s.extend(r,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=i(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,o.mixin(this),h.call(this),this.bindEvents(),this.update(),this.optsRect=s.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var t=this;setTimeout(function(){t.emit("selectr.init")},20)}},v.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},v.prototype.getSelectedProperties=function(e){var t=this.getSelected();return[].slice.call(t).map(function(t){return t[e]}).filter(function(e){return null!==e&&void 0!==e})},v.prototype.bindEvents=function(){var e=this;if(this.events={},this.events.dismiss=l.bind(this),this.events.navigate=d.bind(this),this.events.reset=this.reset.bind(this),this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(t){t.changedTouches[0].target===e.el&&e.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(t){t.preventDefault(),t.stopPropagation(),t.target===e.el&&e.toggle()});var t=function(e,t){for(var i,n=[],r=e.slice(0),o=0;o<t.length;o++)i=r.indexOf(t[o]),i>-1?r.splice(i,1):n.push(t[o]);return[n,r]};this.el.addEventListener("change",function(i){if(e.el.multiple){var n=e.getSelectedProperties("idx"),r=t(e.selectedIndexes,n);s.each(r[0],function(t,i){e.select(i)},e),s.each(r[1],function(t,i){e.deselect(i)},e)}else e.el.selectedIndex>-1&&e.select(e.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(t){"Enter"===t.key&&e.selected===document.activeElement&&(e.toggle(),setTimeout(function(){e.el.focus()},200))}),this.selected.addEventListener("click",function(t){e.disabled||e.toggle(),t.preventDefault(),t.stopPropagation()}),this.label.addEventListener("click",function(t){s.hasClass(t.target,"selectr-tag-remove")&&e.deselect(t.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(t){t.preventDefault(),t.stopPropagation();var i=s.closest(t.target,function(e){return e&&s.hasClass(e,"selectr-option")});i&&(s.hasClass(i,"disabled")||(s.hasClass(i,"selected")?(e.el.multiple||!e.el.multiple&&e.config.allowDeselect)&&e.deselect(i.idx):e.select(i.idx),e.opened&&!e.el.multiple&&e.close()))}),this.tree.addEventListener("mouseover",function(t){s.hasClass(t.target,"selectr-option")&&(s.hasClass(t.target,"disabled")||(s.removeClass(e.items[e.navIndex],"active"),s.addClass(t.target,"active"),e.navIndex=[].slice.call(e.items).indexOf(t.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(t){e.searching=!0}),this.input.addEventListener("blur",function(t){e.searching=!1}),this.input.addEventListener("keyup",function(t){e.search(),e.config.taggable||(this.value.length?s.addClass(this.parentNode,"active"):s.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(t){e.input.value=null,m.call(e),e.tree.childElementCount||a.call(e)})),this.config.taggable&&this.input.addEventListener("keyup",function(t){if(e.search(),e.config.taggable&&this.value.length){var i=this.value.trim();if(13===t.which||s.includes(e.tagSeperators,t.key)){s.each(e.tagSeperators,function(e,t){i=i.replace(t,"")});e.add({value:i,text:i,selected:!0},!0)?(e.close(),m.call(e)):(this.value="",e.setMessage("That tag is already in use."))}}}),this.update=s.debounce(function(){e.opened&&e.config.closeOnScroll&&e.close(),e.width&&(e.container.style.width=e.width),e.invert()},50),this.requiresPagination&&(this.paginateItems=s.debounce(function(){p.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},v.prototype.setSelected=function(e){if(this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,this.selectedIndex>-1&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),s.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data){!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0);var t=0;s.each(this.config.data,function(e,n){i(n,"children")?s.each(n.children,function(e,i){i.hasOwnProperty("selected")&&!0===i.selected&&this.select(t),t++},this):(n.hasOwnProperty("selected")&&!0===n.selected&&this.select(t),t++)},this)}},v.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),s.removeClass(this.el,"selectr-hidden"),this.el.form&&s.off(this.el.form,"reset",this.events.reset),s.off(document,"click",this.events.dismiss),s.off(document,"keydown",this.events.navigate),s.off(window,"resize",this.update),s.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},v.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&s.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},v.prototype.select=function(e){var t=this.items[e],i=[].slice.call(this.el.options),n=this.options[e];if(this.el.multiple){if(s.includes(this.selectedIndexes,e))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(n.value),this.selectedIndexes.push(e),u.call(this,t)}else{var r=this.data?this.data[e]:n;this.label.innerHTML=this.customSelected?this.config.renderSelection(r):n.textContent,this.selectedValue=n.value,this.selectedIndex=e,s.each(this.options,function(t,i){var n=this.items[t];t!==e&&(n&&s.removeClass(n,"selected"),i.selected=!1,i.removeAttribute("selected"))},this)}s.includes(i,n)||this.el.add(n),t.setAttribute("aria-selected",!0),s.addClass(t,"selected"),s.addClass(this.container,"has-selected"),n.selected=!0,n.setAttribute("selected",""),this.emit("selectr.change",n),this.emit("selectr.select",n)},v.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var r=this.selectedIndexes.indexOf(e);this.selectedIndexes.splice(r,1);var o=this.selectedValues.indexOf(n.value);this.selectedValues.splice(o,1),f.call(this,i),this.tags.length||s.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,s.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),s.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},v.prototype.setValue=function(e){var t=Array.isArray(e);if(t||(e=e.toString().trim()),!this.el.multiple&&t)return!1;s.each(this.options,function(i,n){(t&&s.includes(e.toString(),n.value)||n.value===e)&&this.change(n.idx)},this)},v.prototype.getValue=function(e,t){var i;if(this.el.multiple)e?this.selectedIndexes.length&&(i={},i.values=[],s.each(this.selectedIndexes,function(e,t){var n=this.options[t];i.values[e]={value:n.value,text:n.textContent}},this)):i=this.selectedValues.slice();else if(e){var n=this.options[this.selectedIndex];i={value:n.value,text:n.textContent}}else i=this.selectedValue;return e&&t&&(i=JSON.stringify(i)),i},v.prototype.add=function(e,t){if(e){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(e))s.each(e,function(e,i){this.add(i,t)},this);else if("[object Object]"===Object.prototype.toString.call(e)){if(t){var i=!1;if(s.each(this.options,function(t,n){n.value.toLowerCase()===e.value.toLowerCase()&&(i=!0)}),i)return!1}var n=s.createElement("option",e);return this.data.push(e),this.options.push(n),n.idx=this.options.length>0?this.options.length-1:0,c.call(this,n),e.selected&&this.select(n.idx),n}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},v.prototype.remove=function(e){var t=[];if(Array.isArray(e)?s.each(e,function(i,n){s.isInt(n)?t.push(this.getOptionByIndex(n)):"string"==typeof e&&t.push(this.getOptionByValue(n))},this):s.isInt(e)?t.push(this.getOptionByIndex(e)):"string"==typeof e&&t.push(this.getOptionByValue(e)),t.length){var i;s.each(t,function(e,t){i=t.idx,this.el.remove(t),this.options.splice(i,1);var n=this.items[i].parentNode;n&&n.removeChild(this.items[i]),this.items.splice(i,1),s.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate()}},v.prototype.removeAll=function(){this.clear(!0),s.each(this.el.options,function(e,t){this.el.remove(t)},this),s.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},v.prototype.search=function(e){if(!this.navigating){e=e||this.input.value;var t=document.createDocumentFragment();if(this.removeMessage(),s.truncate(this.tree),e.length>1)if(s.each(this.options,function(i,r){var o=this.items[r.idx];s.includes(r.textContent.toLowerCase(),e.toLowerCase())&&!r.disabled?(n(o,t,this.customOption),s.removeClass(o,"excluded"),this.customOption||(o.innerHTML=g(e,r))):s.addClass(o,"excluded")},this),t.childElementCount){var i=this.items[this.navIndex],r=t.firstElementChild;s.removeClass(i,"active"),this.navIndex=r.idx,s.addClass(r,"active")}else this.config.taggable||this.setMessage("no results.");else a.call(this);this.tree.appendChild(t)}},v.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},v.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(s.addClass(this.container,"native-open"),void(this.config.data&&s.each(this.options,function(e,t){this.el.add(t)},this))):(s.addClass(this.container,"open"),a.call(this),this.invert(),this.tree.scrollTop=0,s.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},v.prototype.close=function(){if(this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown)return void s.removeClass(this.container,"native-open");var e=s.hasClass(this.container,"notice");this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(s.removeClass(this.container,"notice"),this.notice.textContent=""),s.removeClass(this.container,"open"),s.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),s.truncate(this.tree),m.call(this)},v.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&s.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),s.removeClass(this.container,"selectr-disabled")},v.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&s.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,s.addClass(this.container,"selectr-disabled")},v.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),s.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},v.prototype.clear=function(e){if(this.el.multiple){if(this.selectedIndexes.length){var t=this.selectedIndexes.slice();s.each(t,function(e,t){this.deselect(t)},this)}}else this.selectedIndex>-1&&this.deselect(this.selectedIndex,e);this.emit("selectr.clear")},v.prototype.serialise=function(e){var t=[];return s.each(this.options,function(e,i){var n={value:i.value,text:i.textContent};i.selected&&(n.selected=!0),i.disabled&&(n.disabled=!0),t[e]=n}),e?JSON.stringify(t):t},v.prototype.serialize=function(e){return this.serialise(e)},v.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.innerHTML=e},v.prototype.paginate=function(){if(this.items.length){var e=this;return this.pages=this.items.map(function(t,i){return i%e.config.pagination==0?e.items.slice(i,i+e.config.pagination):null}).filter(function(e){return e}),this.pages}},v.prototype.setMessage=function(e,t){t&&this.close(),s.addClass(this.container,"notice"),this.notice.textContent=e},v.prototype.removeMessage=function(){s.removeClass(this.container,"notice"),this.notice.innerHTML=""},v.prototype.invert=function(){var e=s.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(s.addClass(this.container,"inverted"),this.isInverted=!0):(s.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=s.rect(this.tree)},v.prototype.getOptionByIndex=function(e){return this.options[e]},v.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=v},function(e,t,i){"use strict";function n(e,t,i,n){for(var o={code:{text:"Code",title:"Switch to code highlighter",
click:function(){n("code")}},form:{text:"Form",title:"Switch to form editor",click:function(){n("form")}},text:{text:"Text",title:"Switch to plain text editor",click:function(){n("text")}},tree:{text:"Tree",title:"Switch to tree editor",click:function(){n("tree")}},view:{text:"View",title:"Switch to tree view",click:function(){n("view")}}},s=[],a=0;a<t.length;a++){var l=t[a],c=o[l];if(!c)throw new Error('Unknown mode "'+l+'"');c.className="jsoneditor-type-modes"+(i==l?" jsoneditor-selected":""),s.push(c)}var h=o[i];if(!h)throw new Error('Unknown mode "'+i+'"');var d=h.text,u=document.createElement("button");u.type="button",u.className="jsoneditor-modes jsoneditor-separator",u.innerHTML=d+" &#x25BE;",u.title="Switch editor mode",u.onclick=function(){new r(s).show(u,e)};var f=document.createElement("div");f.className="jsoneditor-modes",f.style.position="relative",f.appendChild(u),e.appendChild(f),this.dom={container:e,box:u,frame:f}}var r=i(63);n.prototype.focus=function(){this.dom.box.focus()},n.prototype.destroy=function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null},e.exports=n},function(e,t){"use strict";function i(e){function t(e){var t,i;document.createRange?(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),i=window.getSelection(),i.removeAllRanges(),i.addRange(t)):document.selection&&(t=document.body.createTextRange(),t.moveToElementText(e),t.collapse(!1),t.select())}function i(e){return void 0===a&&(a=document.createElement("span"),a.style.visibility="hidden",a.style.position="fixed",a.style.outline="0",a.style.margin="0",a.style.padding="0",a.style.border="0",a.style.left="0",a.style.whiteSpace="pre",a.style.fontSize=n,a.style.fontFamily=r,a.style.fontWeight="normal",document.body.appendChild(a)),a.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),a.getBoundingClientRect().right}e=e||{},e.confirmKeys=e.confirmKeys||[39,35,9],e.caseSensitive=e.caseSensitive||!1;var n="",r="",o=document.createElement("div");o.style.position="relative",o.style.outline="0",o.style.border="0",o.style.margin="0",o.style.padding="0";var s=document.createElement("div");s.className="autocomplete dropdown",s.style.position="absolute",s.style.visibility="hidden";var a,l,c={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:o,show:function(e,t,i){this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""==n&&(n=window.getComputedStyle(e).getPropertyValue("font-size")),""==r&&(r=window.getComputedStyle(e).getPropertyValue("font-family"));e.getBoundingClientRect().right,e.getBoundingClientRect().left;s.style.marginLeft="0",s.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i,this.element!=e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){this.element.focus()}.bind(this),this.element.addEventListener&&(this.element.removeEventListener("keydown",d),this.element.addEventListener("keydown",d,!1),this.element.removeEventListener("blur",u),this.element.addEventListener("blur",u,!1)),o.appendChild(this.elementHint),o.appendChild(s),e.parentElement.appendChild(o),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,h.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(t){var n=t.innerText;n=n.replace("\n","");var r=(this.startFrom,this.options,this.options.length),o=n.substring(this.startFrom);l=n.substring(0,this.startFrom);for(var a=0;a<r;a++){var c=this.options[a];if(!e.caseSensitive&&0===c.toLowerCase().indexOf(o.toLowerCase())||e.caseSensitive&&0===c.indexOf(o)){this.elementHint.innerText=l+o+c.substring(o.length),this.elementHint.realInnerText=l+c;break}}s.style.left=i(l)+"px",h.refresh(o,this.options),this.elementHint.style.width=i(this.elementHint.innerText)+10+"px","hidden"==s.style.visibility||(this.elementHint.style.width=i(this.elementHint.innerText)+s.clientWidth+"px")}},h=function(t,i){var n=[],r=0,o=-1,s=function(){this.style.outline="1px solid #ddd"},a=function(){this.style.outline="0"},l=function(){c.hide(),c.onmouseselection(this.__hint,c.rs)},c={rs:i,hide:function(){t.style.visibility="hidden"},refresh:function(i,o){t.style.visibility="hidden",r=0,t.innerHTML="";var h=window.innerHeight||document.documentElement.clientHeight,d=t.parentNode.getBoundingClientRect(),u=d.top-6,f=h-d.bottom-6;n=[];for(var p=0;p<o.length;p++)if(!(e.caseSensitive&&0!==o[p].indexOf(i)||!e.caseSensitive&&0!==o[p].toLowerCase().indexOf(i.toLowerCase()))){var m=document.createElement("div");m.className="item",m.onmouseover=s,m.onmouseout=a,m.onmousedown=l,m.__hint=o[p],m.innerHTML=o[p].substring(0,i.length)+"<b>"+o[p].substring(i.length)+"</b>",n.push(m),t.appendChild(m)}0!==n.length&&(1===n.length&&(i.toLowerCase()===n[0].__hint.toLowerCase()&&!e.caseSensitive||i===n[0].__hint&&e.caseSensitive)||n.length<2||(c.highlight(0),u>3*f?(t.style.maxHeight=u+"px",t.style.top="",t.style.bottom="100%"):(t.style.top="100%",t.style.bottom="",t.style.maxHeight=f+"px"),t.style.visibility="visible"))},highlight:function(e){-1!=o&&n[o]&&(n[o].className="item"),n[e].className="item hover",o=e},move:function(e){return"hidden"===t.style.visibility?"":r+e===-1||r+e===n.length?n[r].__hint:(r+=e,c.highlight(r),n[r].__hint)},onmouseselection:function(){}};return c}(s,c),d=function(i){i=i||window.event;var n=i.keyCode;if(null!=this.elementHint&&33!=n&&34!=n){if(27==n)return c.hideDropDown(),c.element.focus(),i.preventDefault(),void i.stopPropagation();var r=this.element.innerText;r=r.replace("\n","");this.startFrom;if(e.confirmKeys.indexOf(n)>=0)return 9==n&&0==this.elementHint.innerText.length&&c.onTab(),void(this.elementHint.innerText.length>0&&this.element.innerText!=this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,c.hideDropDown(),t(this.element),9==n&&(c.element.focus(),i.preventDefault(),i.stopPropagation())));if(13!=n){if(40==n){var o=r.substring(this.startFrom),a=h.move(1);return""==a&&c.onArrowDown(),this.elementHint.innerText=l+o+a.substring(o.length),this.elementHint.realInnerText=l+a,i.preventDefault(),void i.stopPropagation()}if(38==n){var o=r.substring(this.startFrom),a=h.move(-1);return""==a&&c.onArrowUp(),this.elementHint.innerText=l+o+a.substring(o.length),this.elementHint.realInnerText=l+a,i.preventDefault(),void i.stopPropagation()}}else if(0==this.elementHint.innerText.length)c.onEnter();else{var d="hidden"==s.style.visibility;if(h.hide(),d)return c.hideDropDown(),c.element.focus(),void c.onEnter();this.element.innerText=this.elementHint.realInnerText,c.hideDropDown(),t(this.element),i.preventDefault(),i.stopPropagation()}}}.bind(c),u=function(e){c.hideDropDown()}.bind(c);return h.onmouseselection=function(e,i){i.element.innerText=i.elementHint.innerText=l+e,i.hideDropDown(),window.setTimeout(function(){i.element.focus(),t(i.element)},1)},c}e.exports=i},function(e,t,i){"use strict";function n(){try{this.format()}catch(e){}}var r=i(51),o=i(79),s=i(65),a={};a.create=function(e,t){t=t||{},void 0===t.statusBar&&(t.statusBar=!0),this.options=t,t.indentation?this.indentation=Number(t.indentation):this.indentation=2;var n=t.ace?t.ace:r;if(this.mode="code"==t.mode?"code":"text","code"==this.mode&&void 0===n&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||"ace/theme/jsoneditor","ace/theme/jsoneditor"===this.theme&&n)try{i(82)}catch(e){console.error(e)}t.onTextSelectionChange&&this.onTextSelectionChange(t.onTextSelectionChange);var a=this;this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.validationSequence=0,this.annotations=[],this._debouncedValidate=s.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){a._onKeyDown(e)},this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var l=document.createElement("button");l.type="button",l.className="jsoneditor-format",l.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(l),l.onclick=function(){try{a.format(),a._onChange()}catch(e){a._onError(e)}};var c=document.createElement("button");c.type="button",c.className="jsoneditor-compact",c.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(c),c.onclick=function(){try{a.compact(),a._onChange()}catch(e){a._onError(e)}};var h=document.createElement("button");h.type="button",h.className="jsoneditor-repair",h.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(h),h.onclick=function(){try{a.repair(),a._onChange()}catch(e){a._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new o(this.menu,this.options.modes,this.options.mode,function(e){a.setMode(e),a.modeSwitcher.focus()}));var d={},u=this.options.onEditable&&typeof("function"===this.options.onEditable)&&!this.options.onEditable(d);if(this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"==this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var f=n.edit(this.editorDom),p=f.getSession();f.$blockScrolling=1/0,f.setTheme(this.theme),f.setOptions({readOnly:u}),f.setShowPrintMargin(!1),f.setFontSize(13),p.setMode("ace/mode/json"),p.setTabSize(this.indentation),p.setUseSoftTabs(!0),p.setUseWrapMode(!0);var m=p.setAnnotations;p.setAnnotations=function(e){m.call(this,e&&e.length?e:a.annotations)},f.commands.bindKey("Ctrl-L",null),f.commands.bindKey("Command-L",null),this.aceEditor=f,this.hasOwnProperty("editor")||Object.defineProperty(this,"editor",{get:function(){return console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor},set:function(e){console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor=e}});var g=document.createElement("a");g.appendChild(document.createTextNode("powered by ace")),g.href="http://ace.ajax.org",g.target="_blank",g.className="jsoneditor-poweredBy",g.onclick=function(){window.open(g.href,g.target)},this.menu.appendChild(g),f.on("change",this._onChange.bind(this)),f.on("changeSelection",this._onSelect.bind(this))}else{var v=document.createElement("textarea");v.className="jsoneditor-text",v.spellcheck=!1,this.content.appendChild(v),this.textarea=v,this.textarea.readOnly=u,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),v.onselect=this._onSelect.bind(this),v.onmousedown=this._onMouseDown.bind(this),v.onblur=this._onBlur.bind(this)}var y=document.createElement("div");y.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=y,this.frame.appendChild(y);var w=document.createElement("div");if(w.style.display="none",w.className="jsoneditor-additional-errors fadein",w.innerHTML="Scroll for more &#9663;",this.dom.additinalErrorsIndication=w,y.appendChild(w),t.statusBar){s.addClassName(this.content,"has-status-bar"),this.curserInfoElements={};var b=document.createElement("div");this.dom.statusBar=b,b.className="jsoneditor-statusbar",this.frame.appendChild(b);var C=document.createElement("span");C.className="jsoneditor-curserinfo-label",C.innerText="Ln:";var A=document.createElement("span");A.className="jsoneditor-curserinfo-val",A.innerText="1",b.appendChild(C),b.appendChild(A);var E=document.createElement("span");E.className="jsoneditor-curserinfo-label",E.innerText="Col:";var F=document.createElement("span");F.className="jsoneditor-curserinfo-val",F.innerText="1",b.appendChild(E),b.appendChild(F),this.curserInfoElements.colVal=F,this.curserInfoElements.lnVal=A;var x=document.createElement("span");x.className="jsoneditor-curserinfo-label",x.innerText="characters selected",x.style.display="none";var S=document.createElement("span");S.className="jsoneditor-curserinfo-count",S.innerText="0",S.style.display="none",this.curserInfoElements.countLabel=x,this.curserInfoElements.countVal=S,b.appendChild(S),b.appendChild(x);var _=document.createElement("span");_.className="jsoneditor-validation-error-icon",_.style.display="none";var k=document.createElement("span");k.className="jsoneditor-validation-error-count",k.style.display="none",this.validationErrorIndication={validationErrorIcon:_,validationErrorCount:k},b.appendChild(k),b.appendChild(_),this.parseErrorIndication=document.createElement("span"),this.parseErrorIndication.className="jsoneditor-parse-error-icon",this.parseErrorIndication.style.display="none",b.appendChild(this.parseErrorIndication)}this.setSchema(this.options.schema,this.options.schemaRefs)},a._onChange=function(){if(!this.onChangeDisabled){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},a._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},a._onKeyDown=function(e){var t=e.which||e.keyCode,i=!1;220==t&&e.ctrlKey&&(e.shiftKey?(this.compact(),this._onChange()):(this.format(),this._onChange()),i=!0),i&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},a._onMouseDown=function(e){this._updateCursorInfo(),this._emitSelectionChange()},a._onBlur=function(e){var t=this;setTimeout(function(){t.isFocused||(t._updateCursorInfo(),t._emitSelectionChange()),t.isFocused=!1})},a._updateCursorInfo=function(){function e(){r.curserInfoElements.countVal.innerText!==n&&(r.curserInfoElements.countVal.innerText=n,r.curserInfoElements.countVal.style.display=n?"inline":"none",r.curserInfoElements.countLabel.style.display=n?"inline":"none"),r.curserInfoElements.lnVal.innerText=t,r.curserInfoElements.colVal.innerText=i}var t,i,n,r=this;if(this.textarea)setTimeout(function(){var o=s.getInputSelection(r.textarea);o.startIndex!==o.endIndex&&(n=o.endIndex-o.startIndex),n&&r.cursorInfo&&r.cursorInfo.line===o.end.row&&r.cursorInfo.column===o.end.column?(t=o.start.row,i=o.start.column):(t=o.end.row,i=o.end.column),r.cursorInfo={line:t,column:i,count:n},r.options.statusBar&&e()},0);else if(this.aceEditor&&this.curserInfoElements){var o=this.aceEditor.getCursorPosition(),a=this.aceEditor.getSelectedText();t=o.row+1,i=o.column+1,n=a.length,r.cursorInfo={line:t,column:i,count:n},this.options.statusBar&&e()}},a._emitSelectionChange=function(){if(this._selectionChangedHandler){var e=this.getTextSelection();this._selectionChangedHandler(e.start,e.end,e.text)}},a._refreshAnnotations=function(){var e=this.aceEditor&&this.aceEditor.getSession();if(e){var t=e.getAnnotations().filter(function(e){return"error"===e.type});e.setAnnotations(t)}},a.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode==this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},a.compact=function(){var e=this.get(),t=JSON.stringify(e);this.setText(t)},a.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this.setText(t)},a.repair=function(){var e=this.getText(),t=s.sanitize(e);this.setText(t)},a.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},a.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},a.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},a.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},a.get=function(){var e,t=this.getText();try{e=s.parse(t)}catch(i){t=s.sanitize(t),e=s.parse(t)}return e},a.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},a.setText=function(e){var t;t=!0===this.options.escapeUnicode?s.escapeUnicodeChars(e):e,this.textarea&&(this.textarea.value=t),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(t,-1),this.onChangeDisabled=!1),this._debouncedValidate()},a.updateText=function(e){this.getText()!==e&&(this.onChangeDisabled=!0,this.setText(e),this.onChangeDisabled=!1)},a.validate=function(){var e,t=!1,i=[],n=[];try{e=this.get(),this.parseErrorIndication.style.display="none",t=!0}catch(e){if(this.getText()){this.parseErrorIndication.style.display="block";var r,o=/\w*line\s*(\d+)\w*/g.exec(e.message);o&&(r=+o[1]),this.parseErrorIndication.title=isNaN(r)?"parse error - check that the json is valid":"parse error on line "+r,n.push({type:"error",message:e.message.replace(/\n/g,"<br>"),line:r})}}if(t){if(this.validateSchema){this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return e.type="validation",s.improveSchemaError(e)}))}try{this.validationSequence++;var a=this,l=this.validationSequence;this._validateCustom(e).then(function(e){if(l===a.validationSequence){var t=i.concat(n||[]).concat(e||[]);a._renderErrors(t)}}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}else this._renderErrors(n||[])},a._validateCustom=function(e){if(this.options.onValidate)try{var t=this.options.onValidate(e);return(s.isPromise(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=s.isValidValidationError(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:s.stringifyPath(e.path),message:e.message}}):null})}catch(e){return Promise.reject(e)}return Promise.resolve(null)},a._renderErrors=function(e){var t=this,i=0;this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additinalErrorsIndication.style.display="none",this.content.style.marginBottom="",this.content.style.paddingBottom="");var n=this.getText(),r=[];e.reduce(function(e,t){return-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},r);var o=s.getPositionForPath(n,r);if(e.length>0)if(this.aceEditor)this.annotations=o.map(function(t){var i=e.filter(function(e){return e.dataPath===t.path}),n=i.map(function(e){return e.message}).join("\n");return n?{row:t.line,column:t.column,text:"Schema validation error"+(1!==i.length?"s":"")+": \n"+n,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations();else{var a=document.createElement("div");a.innerHTML='<table class="jsoneditor-text-errors"><tbody></tbody></table>';var l=a.getElementsByTagName("tbody")[0];e.forEach(function(e){var n;n="string"==typeof e?'<td colspan="2"><pre>'+e+"</pre></td>":"<td>"+(e.dataPath||"")+"</td><td>"+e.message+"</td>";var r;if(isNaN(e.line)){if(e.dataPath){var s=o.find(function(t){return t.path===e.dataPath});s&&(r=s.line+1)}}else r=e.line;var a=document.createElement("tr");a.className=isNaN(r)?"":"jump-to-line","error"===e.type?a.className+=" parse-error":(a.className+=" validation-error",++i),a.innerHTML='<td><button class="jsoneditor-schema-error"></button></td><td style="white-space:nowrap;">'+(isNaN(r)?"":"Ln "+r)+"</td>"+n,a.onclick=function(){t.isFocused=!0,isNaN(r)||t.setTextSelection({row:r,column:1},{row:r,column:1e3})},l.appendChild(a)}),this.dom.validationErrors=a,this.dom.validationErrorsContainer.appendChild(a),this.dom.additinalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additinalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){t.dom.additinalErrorsIndication.style.display=t.dom.validationErrorsContainer.clientHeight>0&&0===t.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0;var c=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0);this.content.style.marginBottom=-c+"px",this.content.style.paddingBottom=c+"px"}else this.aceEditor&&(this.annotations=[],this._refreshAnnotations());if(this.options.statusBar){i=i||this.annotations.length;var h=!!i;this.validationErrorIndication.validationErrorIcon.style.display=h?"inline":"none",this.validationErrorIndication.validationErrorCount.style.display=h?"inline":"none",h&&(this.validationErrorIndication.validationErrorCount.innerText=i,this.validationErrorIndication.validationErrorIcon.title=i+" schema validation error(s) found")}if(this.aceEditor){this.aceEditor.resize(!1)}},a.getTextSelection=function(){var e={};if(this.textarea){var t=s.getInputSelection(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var i=this.aceEditor.getSelection(),n=this.aceEditor.getSelectedText(),r=i.getRange(),o=i.getSelectionLead();return o.row===r.end.row&&o.column===r.end.column?e=r:(e.start=r.end,e.end=r.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:n}}},a.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=s.debounce(e,this.DEBOUNCE_INTERVAL))},a.setTextSelection=function(e,t){if(e&&t)if(this.textarea){var i=s.getIndexForPosition(this.textarea,e.row,e.column),n=s.getIndexForPosition(this.textarea,t.row,t.column);if(i>-1&&n>-1){if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(i,n);else if(this.textarea.createTextRange){var r=this.textarea.createTextRange();r.collapse(!0),r.moveEnd("character",n),r.moveStart("character",i),r.select()}var o=(this.textarea.value.match(/\n/g)||[]).length+1,a=this.textarea.scrollHeight/o,l=e.row*a;this.textarea.scrollTop=l>this.textarea.clientHeight?l-this.textarea.clientHeight/2:0}}else if(this.aceEditor){var r={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}};this.aceEditor.selection.setRange(r)}},e.exports=[{mode:"text",mixin:a,data:"text",load:n},{mode:"code",mixin:a,data:"text",load:n}]},function(e,t){ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\tbackground: #ebebeb;\tcolor: #333\t}\t\t.ace-jsoneditor.ace_editor {\tfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\tline-height: 1.3;\tbackground-color: #fff;\t}\t.ace-jsoneditor .ace_print-margin {\twidth: 1px;\tbackground: #e8e8e8\t}\t.ace-jsoneditor .ace_scroller {\tbackground-color: #FFFFFF\t}\t.ace-jsoneditor .ace_text-layer {\tcolor: gray\t}\t.ace-jsoneditor .ace_variable {\tcolor: #1a1a1a\t}\t.ace-jsoneditor .ace_cursor {\tborder-left: 2px solid #000000\t}\t.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\tborder-left: 0px;\tborder-bottom: 1px solid #000000\t}\t.ace-jsoneditor .ace_marker-layer .ace_selection {\tbackground: lightgray\t}\t.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\tbox-shadow: 0 0 3px 0px #FFFFFF;\tborder-radius: 2px\t}\t.ace-jsoneditor .ace_marker-layer .ace_step {\tbackground: rgb(255, 255, 0)\t}\t.ace-jsoneditor .ace_marker-layer .ace_bracket {\tmargin: -1px 0 0 -1px;\tborder: 1px solid #BFBFBF\t}\t.ace-jsoneditor .ace_marker-layer .ace_active-line {\tbackground: #FFFBD1\t}\t.ace-jsoneditor .ace_gutter-active-line {\tbackground-color : #dcdcdc\t}\t.ace-jsoneditor .ace_marker-layer .ace_selected-word {\tborder: 1px solid lightgray\t}\t.ace-jsoneditor .ace_invisible {\tcolor: #BFBFBF\t}\t.ace-jsoneditor .ace_keyword,\t.ace-jsoneditor .ace_meta,\t.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\tcolor: #AF956F\t}\t.ace-jsoneditor .ace_keyword.ace_operator {\tcolor: #484848\t}\t.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\tcolor: #96DC5F\t}\t.ace-jsoneditor .ace_constant.ace_language {\tcolor: darkorange\t}\t.ace-jsoneditor .ace_constant.ace_numeric {\tcolor: red\t}\t.ace-jsoneditor .ace_constant.ace_character.ace_entity {\tcolor: #BF78CC\t}\t.ace-jsoneditor .ace_invalid {\tcolor: #FFFFFF;\tbackground-color: #FF002A;\t}\t.ace-jsoneditor .ace_fold {\tbackground-color: #AF956F;\tborder-color: #000000\t}\t.ace-jsoneditor .ace_storage,\t.ace-jsoneditor .ace_support.ace_class,\t.ace-jsoneditor .ace_support.ace_function,\t.ace-jsoneditor .ace_support.ace_other,\t.ace-jsoneditor .ace_support.ace_type {\tcolor: #C52727\t}\t.ace-jsoneditor .ace_string {\tcolor: green\t}\t.ace-jsoneditor .ace_comment {\tcolor: #BCC8BA\t}\t.ace-jsoneditor .ace_entity.ace_name.ace_tag,\t.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\tcolor: #606060\t}\t.ace-jsoneditor .ace_markup.ace_underline {\ttext-decoration: underline\t}\t.ace-jsoneditor .ace_indent-guide {\tbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\t}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})}])});
//# sourceMappingURL=jsoneditor.map